# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'DatabaseInstanceClone',
    'DatabaseInstanceIpAddress',
    'DatabaseInstanceReplicaConfiguration',
    'DatabaseInstanceRestoreBackupContext',
    'DatabaseInstanceServerCaCert',
    'DatabaseInstanceSettings',
    'DatabaseInstanceSettingsActiveDirectoryConfig',
    'DatabaseInstanceSettingsBackupConfiguration',
    'DatabaseInstanceSettingsBackupConfigurationBackupRetentionSettings',
    'DatabaseInstanceSettingsDatabaseFlag',
    'DatabaseInstanceSettingsInsightsConfig',
    'DatabaseInstanceSettingsIpConfiguration',
    'DatabaseInstanceSettingsIpConfigurationAuthorizedNetwork',
    'DatabaseInstanceSettingsLocationPreference',
    'DatabaseInstanceSettingsMaintenanceWindow',
    'DatabaseInstanceSettingsSqlServerAuditConfig',
    'UserSqlServerUserDetails',
    'GetCaCertsCertResult',
    'GetDatabaseInstanceCloneResult',
    'GetDatabaseInstanceIpAddressResult',
    'GetDatabaseInstanceReplicaConfigurationResult',
    'GetDatabaseInstanceRestoreBackupContextResult',
    'GetDatabaseInstanceServerCaCertResult',
    'GetDatabaseInstanceSettingResult',
    'GetDatabaseInstanceSettingActiveDirectoryConfigResult',
    'GetDatabaseInstanceSettingBackupConfigurationResult',
    'GetDatabaseInstanceSettingBackupConfigurationBackupRetentionSettingResult',
    'GetDatabaseInstanceSettingDatabaseFlagResult',
    'GetDatabaseInstanceSettingInsightsConfigResult',
    'GetDatabaseInstanceSettingIpConfigurationResult',
    'GetDatabaseInstanceSettingIpConfigurationAuthorizedNetworkResult',
    'GetDatabaseInstanceSettingLocationPreferenceResult',
    'GetDatabaseInstanceSettingMaintenanceWindowResult',
    'GetDatabaseInstanceSettingSqlServerAuditConfigResult',
]

@pulumi.output_type
class DatabaseInstanceClone(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceInstanceName":
            suggest = "source_instance_name"
        elif key == "allocatedIpRange":
            suggest = "allocated_ip_range"
        elif key == "pointInTime":
            suggest = "point_in_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseInstanceClone. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseInstanceClone.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseInstanceClone.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 source_instance_name: str,
                 allocated_ip_range: Optional[str] = None,
                 point_in_time: Optional[str] = None):
        """
        :param str source_instance_name: Name of the source instance which will be cloned.
        :param str allocated_ip_range: The name of the allocated ip range for the private ip CloudSQL instance. For example: "google-managed-services-default". If set, the cloned instance ip will be created in the allocated range. The range name must comply with [RFC 1035](https://tools.ietf.org/html/rfc1035). Specifically, the name must be 1-63 characters long and match the regular expression a-z?.
        :param str point_in_time: The timestamp of the point in time that should be restored.
        """
        pulumi.set(__self__, "source_instance_name", source_instance_name)
        if allocated_ip_range is not None:
            pulumi.set(__self__, "allocated_ip_range", allocated_ip_range)
        if point_in_time is not None:
            pulumi.set(__self__, "point_in_time", point_in_time)

    @property
    @pulumi.getter(name="sourceInstanceName")
    def source_instance_name(self) -> str:
        """
        Name of the source instance which will be cloned.
        """
        return pulumi.get(self, "source_instance_name")

    @property
    @pulumi.getter(name="allocatedIpRange")
    def allocated_ip_range(self) -> Optional[str]:
        """
        The name of the allocated ip range for the private ip CloudSQL instance. For example: "google-managed-services-default". If set, the cloned instance ip will be created in the allocated range. The range name must comply with [RFC 1035](https://tools.ietf.org/html/rfc1035). Specifically, the name must be 1-63 characters long and match the regular expression a-z?.
        """
        return pulumi.get(self, "allocated_ip_range")

    @property
    @pulumi.getter(name="pointInTime")
    def point_in_time(self) -> Optional[str]:
        """
        The timestamp of the point in time that should be restored.
        """
        return pulumi.get(self, "point_in_time")


@pulumi.output_type
class DatabaseInstanceIpAddress(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ipAddress":
            suggest = "ip_address"
        elif key == "timeToRetire":
            suggest = "time_to_retire"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseInstanceIpAddress. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseInstanceIpAddress.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseInstanceIpAddress.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ip_address: Optional[str] = None,
                 time_to_retire: Optional[str] = None,
                 type: Optional[str] = None):
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if time_to_retire is not None:
            pulumi.set(__self__, "time_to_retire", time_to_retire)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[str]:
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter(name="timeToRetire")
    def time_to_retire(self) -> Optional[str]:
        return pulumi.get(self, "time_to_retire")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        return pulumi.get(self, "type")


@pulumi.output_type
class DatabaseInstanceReplicaConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "caCertificate":
            suggest = "ca_certificate"
        elif key == "clientCertificate":
            suggest = "client_certificate"
        elif key == "clientKey":
            suggest = "client_key"
        elif key == "connectRetryInterval":
            suggest = "connect_retry_interval"
        elif key == "dumpFilePath":
            suggest = "dump_file_path"
        elif key == "failoverTarget":
            suggest = "failover_target"
        elif key == "masterHeartbeatPeriod":
            suggest = "master_heartbeat_period"
        elif key == "sslCipher":
            suggest = "ssl_cipher"
        elif key == "verifyServerCertificate":
            suggest = "verify_server_certificate"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseInstanceReplicaConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseInstanceReplicaConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseInstanceReplicaConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ca_certificate: Optional[str] = None,
                 client_certificate: Optional[str] = None,
                 client_key: Optional[str] = None,
                 connect_retry_interval: Optional[int] = None,
                 dump_file_path: Optional[str] = None,
                 failover_target: Optional[bool] = None,
                 master_heartbeat_period: Optional[int] = None,
                 password: Optional[str] = None,
                 ssl_cipher: Optional[str] = None,
                 username: Optional[str] = None,
                 verify_server_certificate: Optional[bool] = None):
        """
        :param str ca_certificate: PEM representation of the trusted CA's x509
               certificate.
        :param str client_certificate: PEM representation of the replica's x509
               certificate.
        :param str client_key: PEM representation of the replica's private key. The
               corresponding public key in encoded in the `client_certificate`.
        :param int connect_retry_interval: The number of seconds
               between connect retries.
        :param str dump_file_path: Path to a SQL file in GCS from which replica
               instances are created. Format is `gs://bucket/filename`.
        :param bool failover_target: Specifies if the replica is the failover target.
               If the field is set to true the replica will be designated as a failover replica.
               If the master instance fails, the replica instance will be promoted as
               the new master instance.
        :param int master_heartbeat_period: Time in ms between replication
               heartbeats.
        :param str password: Password for the replication connection.
        :param str username: Username for replication connection.
        :param bool verify_server_certificate: True if the master's common name
               value is checked during the SSL handshake.
        """
        if ca_certificate is not None:
            pulumi.set(__self__, "ca_certificate", ca_certificate)
        if client_certificate is not None:
            pulumi.set(__self__, "client_certificate", client_certificate)
        if client_key is not None:
            pulumi.set(__self__, "client_key", client_key)
        if connect_retry_interval is not None:
            pulumi.set(__self__, "connect_retry_interval", connect_retry_interval)
        if dump_file_path is not None:
            pulumi.set(__self__, "dump_file_path", dump_file_path)
        if failover_target is not None:
            pulumi.set(__self__, "failover_target", failover_target)
        if master_heartbeat_period is not None:
            pulumi.set(__self__, "master_heartbeat_period", master_heartbeat_period)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if ssl_cipher is not None:
            pulumi.set(__self__, "ssl_cipher", ssl_cipher)
        if username is not None:
            pulumi.set(__self__, "username", username)
        if verify_server_certificate is not None:
            pulumi.set(__self__, "verify_server_certificate", verify_server_certificate)

    @property
    @pulumi.getter(name="caCertificate")
    def ca_certificate(self) -> Optional[str]:
        """
        PEM representation of the trusted CA's x509
        certificate.
        """
        return pulumi.get(self, "ca_certificate")

    @property
    @pulumi.getter(name="clientCertificate")
    def client_certificate(self) -> Optional[str]:
        """
        PEM representation of the replica's x509
        certificate.
        """
        return pulumi.get(self, "client_certificate")

    @property
    @pulumi.getter(name="clientKey")
    def client_key(self) -> Optional[str]:
        """
        PEM representation of the replica's private key. The
        corresponding public key in encoded in the `client_certificate`.
        """
        return pulumi.get(self, "client_key")

    @property
    @pulumi.getter(name="connectRetryInterval")
    def connect_retry_interval(self) -> Optional[int]:
        """
        The number of seconds
        between connect retries.
        """
        return pulumi.get(self, "connect_retry_interval")

    @property
    @pulumi.getter(name="dumpFilePath")
    def dump_file_path(self) -> Optional[str]:
        """
        Path to a SQL file in GCS from which replica
        instances are created. Format is `gs://bucket/filename`.
        """
        return pulumi.get(self, "dump_file_path")

    @property
    @pulumi.getter(name="failoverTarget")
    def failover_target(self) -> Optional[bool]:
        """
        Specifies if the replica is the failover target.
        If the field is set to true the replica will be designated as a failover replica.
        If the master instance fails, the replica instance will be promoted as
        the new master instance.
        """
        return pulumi.get(self, "failover_target")

    @property
    @pulumi.getter(name="masterHeartbeatPeriod")
    def master_heartbeat_period(self) -> Optional[int]:
        """
        Time in ms between replication
        heartbeats.
        """
        return pulumi.get(self, "master_heartbeat_period")

    @property
    @pulumi.getter
    def password(self) -> Optional[str]:
        """
        Password for the replication connection.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="sslCipher")
    def ssl_cipher(self) -> Optional[str]:
        return pulumi.get(self, "ssl_cipher")

    @property
    @pulumi.getter
    def username(self) -> Optional[str]:
        """
        Username for replication connection.
        """
        return pulumi.get(self, "username")

    @property
    @pulumi.getter(name="verifyServerCertificate")
    def verify_server_certificate(self) -> Optional[bool]:
        """
        True if the master's common name
        value is checked during the SSL handshake.
        """
        return pulumi.get(self, "verify_server_certificate")


@pulumi.output_type
class DatabaseInstanceRestoreBackupContext(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backupRunId":
            suggest = "backup_run_id"
        elif key == "instanceId":
            suggest = "instance_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseInstanceRestoreBackupContext. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseInstanceRestoreBackupContext.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseInstanceRestoreBackupContext.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backup_run_id: int,
                 instance_id: Optional[str] = None,
                 project: Optional[str] = None):
        """
        :param int backup_run_id: The ID of the backup run to restore from.
        :param str instance_id: The ID of the instance that the backup was taken from. If left empty,
               this instance's ID will be used.
        :param str project: The full project ID of the source instance.`
        """
        pulumi.set(__self__, "backup_run_id", backup_run_id)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter(name="backupRunId")
    def backup_run_id(self) -> int:
        """
        The ID of the backup run to restore from.
        """
        return pulumi.get(self, "backup_run_id")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[str]:
        """
        The ID of the instance that the backup was taken from. If left empty,
        this instance's ID will be used.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter
    def project(self) -> Optional[str]:
        """
        The full project ID of the source instance.`
        """
        return pulumi.get(self, "project")


@pulumi.output_type
class DatabaseInstanceServerCaCert(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "commonName":
            suggest = "common_name"
        elif key == "createTime":
            suggest = "create_time"
        elif key == "expirationTime":
            suggest = "expiration_time"
        elif key == "sha1Fingerprint":
            suggest = "sha1_fingerprint"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseInstanceServerCaCert. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseInstanceServerCaCert.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseInstanceServerCaCert.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cert: Optional[str] = None,
                 common_name: Optional[str] = None,
                 create_time: Optional[str] = None,
                 expiration_time: Optional[str] = None,
                 sha1_fingerprint: Optional[str] = None):
        """
        :param str expiration_time: The [RFC 3339](https://tools.ietf.org/html/rfc3339)
               formatted date time string indicating when this whitelist expires.
        """
        if cert is not None:
            pulumi.set(__self__, "cert", cert)
        if common_name is not None:
            pulumi.set(__self__, "common_name", common_name)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if expiration_time is not None:
            pulumi.set(__self__, "expiration_time", expiration_time)
        if sha1_fingerprint is not None:
            pulumi.set(__self__, "sha1_fingerprint", sha1_fingerprint)

    @property
    @pulumi.getter
    def cert(self) -> Optional[str]:
        return pulumi.get(self, "cert")

    @property
    @pulumi.getter(name="commonName")
    def common_name(self) -> Optional[str]:
        return pulumi.get(self, "common_name")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[str]:
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="expirationTime")
    def expiration_time(self) -> Optional[str]:
        """
        The [RFC 3339](https://tools.ietf.org/html/rfc3339)
        formatted date time string indicating when this whitelist expires.
        """
        return pulumi.get(self, "expiration_time")

    @property
    @pulumi.getter(name="sha1Fingerprint")
    def sha1_fingerprint(self) -> Optional[str]:
        return pulumi.get(self, "sha1_fingerprint")


@pulumi.output_type
class DatabaseInstanceSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "activationPolicy":
            suggest = "activation_policy"
        elif key == "activeDirectoryConfig":
            suggest = "active_directory_config"
        elif key == "availabilityType":
            suggest = "availability_type"
        elif key == "backupConfiguration":
            suggest = "backup_configuration"
        elif key == "databaseFlags":
            suggest = "database_flags"
        elif key == "diskAutoresize":
            suggest = "disk_autoresize"
        elif key == "diskAutoresizeLimit":
            suggest = "disk_autoresize_limit"
        elif key == "diskSize":
            suggest = "disk_size"
        elif key == "diskType":
            suggest = "disk_type"
        elif key == "insightsConfig":
            suggest = "insights_config"
        elif key == "ipConfiguration":
            suggest = "ip_configuration"
        elif key == "locationPreference":
            suggest = "location_preference"
        elif key == "maintenanceWindow":
            suggest = "maintenance_window"
        elif key == "pricingPlan":
            suggest = "pricing_plan"
        elif key == "sqlServerAuditConfig":
            suggest = "sql_server_audit_config"
        elif key == "userLabels":
            suggest = "user_labels"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseInstanceSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseInstanceSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseInstanceSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 tier: str,
                 activation_policy: Optional[str] = None,
                 active_directory_config: Optional['outputs.DatabaseInstanceSettingsActiveDirectoryConfig'] = None,
                 availability_type: Optional[str] = None,
                 backup_configuration: Optional['outputs.DatabaseInstanceSettingsBackupConfiguration'] = None,
                 collation: Optional[str] = None,
                 database_flags: Optional[Sequence['outputs.DatabaseInstanceSettingsDatabaseFlag']] = None,
                 disk_autoresize: Optional[bool] = None,
                 disk_autoresize_limit: Optional[int] = None,
                 disk_size: Optional[int] = None,
                 disk_type: Optional[str] = None,
                 insights_config: Optional['outputs.DatabaseInstanceSettingsInsightsConfig'] = None,
                 ip_configuration: Optional['outputs.DatabaseInstanceSettingsIpConfiguration'] = None,
                 location_preference: Optional['outputs.DatabaseInstanceSettingsLocationPreference'] = None,
                 maintenance_window: Optional['outputs.DatabaseInstanceSettingsMaintenanceWindow'] = None,
                 pricing_plan: Optional[str] = None,
                 sql_server_audit_config: Optional['outputs.DatabaseInstanceSettingsSqlServerAuditConfig'] = None,
                 user_labels: Optional[Mapping[str, str]] = None,
                 version: Optional[int] = None):
        """
        :param str tier: The machine type to use. See [tiers](https://cloud.google.com/sql/docs/admin-api/v1beta4/tiers)
               for more details and supported versions. Postgres supports only shared-core machine types,
               and custom machine types such as `db-custom-2-13312`. See the [Custom Machine Type Documentation](https://cloud.google.com/compute/docs/instances/creating-instance-with-custom-machine-type#create) to learn about specifying custom machine types.
        :param str activation_policy: This specifies when the instance should be
               active. Can be either `ALWAYS`, `NEVER` or `ON_DEMAND`.
        :param str availability_type: The availability type of the Cloud SQL
               instance, high availability (`REGIONAL`) or single zone (`ZONAL`).' For all instances, ensure that
               `settings.backup_configuration.enabled` is set to `true`.
               For MySQL instances, ensure that `settings.backup_configuration.binary_log_enabled` is set to `true`.
               For Postgres instances, ensure that `settings.backup_configuration.point_in_time_recovery_enabled`
               is set to `true`.
        :param str collation: The name of server instance collation.
        :param bool disk_autoresize: Enables auto-resizing of the storage size. Set to false if you want to set `disk_size`.
        :param int disk_size: The size of data disk, in GB. Size of a running instance cannot be reduced but can be increased. If you want to set this field, set `disk_autoresize` to false.
        :param str disk_type: The type of data disk: PD_SSD or PD_HDD.
        :param str pricing_plan: Pricing plan for this instance, can only be `PER_USE`.
        :param Mapping[str, str] user_labels: A set of key/value user label pairs to assign to the instance.
        """
        pulumi.set(__self__, "tier", tier)
        if activation_policy is not None:
            pulumi.set(__self__, "activation_policy", activation_policy)
        if active_directory_config is not None:
            pulumi.set(__self__, "active_directory_config", active_directory_config)
        if availability_type is not None:
            pulumi.set(__self__, "availability_type", availability_type)
        if backup_configuration is not None:
            pulumi.set(__self__, "backup_configuration", backup_configuration)
        if collation is not None:
            pulumi.set(__self__, "collation", collation)
        if database_flags is not None:
            pulumi.set(__self__, "database_flags", database_flags)
        if disk_autoresize is not None:
            pulumi.set(__self__, "disk_autoresize", disk_autoresize)
        if disk_autoresize_limit is not None:
            pulumi.set(__self__, "disk_autoresize_limit", disk_autoresize_limit)
        if disk_size is not None:
            pulumi.set(__self__, "disk_size", disk_size)
        if disk_type is not None:
            pulumi.set(__self__, "disk_type", disk_type)
        if insights_config is not None:
            pulumi.set(__self__, "insights_config", insights_config)
        if ip_configuration is not None:
            pulumi.set(__self__, "ip_configuration", ip_configuration)
        if location_preference is not None:
            pulumi.set(__self__, "location_preference", location_preference)
        if maintenance_window is not None:
            pulumi.set(__self__, "maintenance_window", maintenance_window)
        if pricing_plan is not None:
            pulumi.set(__self__, "pricing_plan", pricing_plan)
        if sql_server_audit_config is not None:
            pulumi.set(__self__, "sql_server_audit_config", sql_server_audit_config)
        if user_labels is not None:
            pulumi.set(__self__, "user_labels", user_labels)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def tier(self) -> str:
        """
        The machine type to use. See [tiers](https://cloud.google.com/sql/docs/admin-api/v1beta4/tiers)
        for more details and supported versions. Postgres supports only shared-core machine types,
        and custom machine types such as `db-custom-2-13312`. See the [Custom Machine Type Documentation](https://cloud.google.com/compute/docs/instances/creating-instance-with-custom-machine-type#create) to learn about specifying custom machine types.
        """
        return pulumi.get(self, "tier")

    @property
    @pulumi.getter(name="activationPolicy")
    def activation_policy(self) -> Optional[str]:
        """
        This specifies when the instance should be
        active. Can be either `ALWAYS`, `NEVER` or `ON_DEMAND`.
        """
        return pulumi.get(self, "activation_policy")

    @property
    @pulumi.getter(name="activeDirectoryConfig")
    def active_directory_config(self) -> Optional['outputs.DatabaseInstanceSettingsActiveDirectoryConfig']:
        return pulumi.get(self, "active_directory_config")

    @property
    @pulumi.getter(name="availabilityType")
    def availability_type(self) -> Optional[str]:
        """
        The availability type of the Cloud SQL
        instance, high availability (`REGIONAL`) or single zone (`ZONAL`).' For all instances, ensure that
        `settings.backup_configuration.enabled` is set to `true`.
        For MySQL instances, ensure that `settings.backup_configuration.binary_log_enabled` is set to `true`.
        For Postgres instances, ensure that `settings.backup_configuration.point_in_time_recovery_enabled`
        is set to `true`.
        """
        return pulumi.get(self, "availability_type")

    @property
    @pulumi.getter(name="backupConfiguration")
    def backup_configuration(self) -> Optional['outputs.DatabaseInstanceSettingsBackupConfiguration']:
        return pulumi.get(self, "backup_configuration")

    @property
    @pulumi.getter
    def collation(self) -> Optional[str]:
        """
        The name of server instance collation.
        """
        return pulumi.get(self, "collation")

    @property
    @pulumi.getter(name="databaseFlags")
    def database_flags(self) -> Optional[Sequence['outputs.DatabaseInstanceSettingsDatabaseFlag']]:
        return pulumi.get(self, "database_flags")

    @property
    @pulumi.getter(name="diskAutoresize")
    def disk_autoresize(self) -> Optional[bool]:
        """
        Enables auto-resizing of the storage size. Set to false if you want to set `disk_size`.
        """
        return pulumi.get(self, "disk_autoresize")

    @property
    @pulumi.getter(name="diskAutoresizeLimit")
    def disk_autoresize_limit(self) -> Optional[int]:
        return pulumi.get(self, "disk_autoresize_limit")

    @property
    @pulumi.getter(name="diskSize")
    def disk_size(self) -> Optional[int]:
        """
        The size of data disk, in GB. Size of a running instance cannot be reduced but can be increased. If you want to set this field, set `disk_autoresize` to false.
        """
        return pulumi.get(self, "disk_size")

    @property
    @pulumi.getter(name="diskType")
    def disk_type(self) -> Optional[str]:
        """
        The type of data disk: PD_SSD or PD_HDD.
        """
        return pulumi.get(self, "disk_type")

    @property
    @pulumi.getter(name="insightsConfig")
    def insights_config(self) -> Optional['outputs.DatabaseInstanceSettingsInsightsConfig']:
        return pulumi.get(self, "insights_config")

    @property
    @pulumi.getter(name="ipConfiguration")
    def ip_configuration(self) -> Optional['outputs.DatabaseInstanceSettingsIpConfiguration']:
        return pulumi.get(self, "ip_configuration")

    @property
    @pulumi.getter(name="locationPreference")
    def location_preference(self) -> Optional['outputs.DatabaseInstanceSettingsLocationPreference']:
        return pulumi.get(self, "location_preference")

    @property
    @pulumi.getter(name="maintenanceWindow")
    def maintenance_window(self) -> Optional['outputs.DatabaseInstanceSettingsMaintenanceWindow']:
        return pulumi.get(self, "maintenance_window")

    @property
    @pulumi.getter(name="pricingPlan")
    def pricing_plan(self) -> Optional[str]:
        """
        Pricing plan for this instance, can only be `PER_USE`.
        """
        return pulumi.get(self, "pricing_plan")

    @property
    @pulumi.getter(name="sqlServerAuditConfig")
    def sql_server_audit_config(self) -> Optional['outputs.DatabaseInstanceSettingsSqlServerAuditConfig']:
        return pulumi.get(self, "sql_server_audit_config")

    @property
    @pulumi.getter(name="userLabels")
    def user_labels(self) -> Optional[Mapping[str, str]]:
        """
        A set of key/value user label pairs to assign to the instance.
        """
        return pulumi.get(self, "user_labels")

    @property
    @pulumi.getter
    def version(self) -> Optional[int]:
        return pulumi.get(self, "version")


@pulumi.output_type
class DatabaseInstanceSettingsActiveDirectoryConfig(dict):
    def __init__(__self__, *,
                 domain: str):
        """
        :param str domain: The domain name for the active directory (e.g., mydomain.com).
               Can only be used with SQL Server.
        """
        pulumi.set(__self__, "domain", domain)

    @property
    @pulumi.getter
    def domain(self) -> str:
        """
        The domain name for the active directory (e.g., mydomain.com).
        Can only be used with SQL Server.
        """
        return pulumi.get(self, "domain")


@pulumi.output_type
class DatabaseInstanceSettingsBackupConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "backupRetentionSettings":
            suggest = "backup_retention_settings"
        elif key == "binaryLogEnabled":
            suggest = "binary_log_enabled"
        elif key == "pointInTimeRecoveryEnabled":
            suggest = "point_in_time_recovery_enabled"
        elif key == "startTime":
            suggest = "start_time"
        elif key == "transactionLogRetentionDays":
            suggest = "transaction_log_retention_days"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseInstanceSettingsBackupConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseInstanceSettingsBackupConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseInstanceSettingsBackupConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 backup_retention_settings: Optional['outputs.DatabaseInstanceSettingsBackupConfigurationBackupRetentionSettings'] = None,
                 binary_log_enabled: Optional[bool] = None,
                 enabled: Optional[bool] = None,
                 location: Optional[str] = None,
                 point_in_time_recovery_enabled: Optional[bool] = None,
                 start_time: Optional[str] = None,
                 transaction_log_retention_days: Optional[int] = None):
        """
        :param 'DatabaseInstanceSettingsBackupConfigurationBackupRetentionSettingsArgs' backup_retention_settings: Backup retention settings. The configuration is detailed below.
        :param bool binary_log_enabled: True if binary logging is enabled.
               Can only be used with MySQL.
        :param bool enabled: True if backup configuration is enabled.
        :param str location: The region where the backup will be stored
        :param bool point_in_time_recovery_enabled: True if Point-in-time recovery is enabled. Will restart database if enabled after instance creation. Valid only for PostgreSQL instances.
        :param str start_time: `HH:MM` format time indicating when backup
               configuration starts.
        :param int transaction_log_retention_days: The number of days of transaction logs we retain for point in time restore, from 1-7.
        """
        if backup_retention_settings is not None:
            pulumi.set(__self__, "backup_retention_settings", backup_retention_settings)
        if binary_log_enabled is not None:
            pulumi.set(__self__, "binary_log_enabled", binary_log_enabled)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if point_in_time_recovery_enabled is not None:
            pulumi.set(__self__, "point_in_time_recovery_enabled", point_in_time_recovery_enabled)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)
        if transaction_log_retention_days is not None:
            pulumi.set(__self__, "transaction_log_retention_days", transaction_log_retention_days)

    @property
    @pulumi.getter(name="backupRetentionSettings")
    def backup_retention_settings(self) -> Optional['outputs.DatabaseInstanceSettingsBackupConfigurationBackupRetentionSettings']:
        """
        Backup retention settings. The configuration is detailed below.
        """
        return pulumi.get(self, "backup_retention_settings")

    @property
    @pulumi.getter(name="binaryLogEnabled")
    def binary_log_enabled(self) -> Optional[bool]:
        """
        True if binary logging is enabled.
        Can only be used with MySQL.
        """
        return pulumi.get(self, "binary_log_enabled")

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        True if backup configuration is enabled.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def location(self) -> Optional[str]:
        """
        The region where the backup will be stored
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="pointInTimeRecoveryEnabled")
    def point_in_time_recovery_enabled(self) -> Optional[bool]:
        """
        True if Point-in-time recovery is enabled. Will restart database if enabled after instance creation. Valid only for PostgreSQL instances.
        """
        return pulumi.get(self, "point_in_time_recovery_enabled")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[str]:
        """
        `HH:MM` format time indicating when backup
        configuration starts.
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter(name="transactionLogRetentionDays")
    def transaction_log_retention_days(self) -> Optional[int]:
        """
        The number of days of transaction logs we retain for point in time restore, from 1-7.
        """
        return pulumi.get(self, "transaction_log_retention_days")


@pulumi.output_type
class DatabaseInstanceSettingsBackupConfigurationBackupRetentionSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "retainedBackups":
            suggest = "retained_backups"
        elif key == "retentionUnit":
            suggest = "retention_unit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseInstanceSettingsBackupConfigurationBackupRetentionSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseInstanceSettingsBackupConfigurationBackupRetentionSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseInstanceSettingsBackupConfigurationBackupRetentionSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 retained_backups: int,
                 retention_unit: Optional[str] = None):
        """
        :param int retained_backups: Depending on the value of retention_unit, this is used to determine if a backup needs to be deleted. If retention_unit
               is 'COUNT', we will retain this many backups.
        :param str retention_unit: The unit that 'retained_backups' represents. Defaults to `COUNT`.
        """
        pulumi.set(__self__, "retained_backups", retained_backups)
        if retention_unit is not None:
            pulumi.set(__self__, "retention_unit", retention_unit)

    @property
    @pulumi.getter(name="retainedBackups")
    def retained_backups(self) -> int:
        """
        Depending on the value of retention_unit, this is used to determine if a backup needs to be deleted. If retention_unit
        is 'COUNT', we will retain this many backups.
        """
        return pulumi.get(self, "retained_backups")

    @property
    @pulumi.getter(name="retentionUnit")
    def retention_unit(self) -> Optional[str]:
        """
        The unit that 'retained_backups' represents. Defaults to `COUNT`.
        """
        return pulumi.get(self, "retention_unit")


@pulumi.output_type
class DatabaseInstanceSettingsDatabaseFlag(dict):
    def __init__(__self__, *,
                 name: str,
                 value: str):
        """
        :param str name: A name for this whitelist entry.
        :param str value: A CIDR notation IPv4 or IPv6 address that is allowed to
               access this instance. Must be set even if other two attributes are not for
               the whitelist to become active.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A name for this whitelist entry.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        A CIDR notation IPv4 or IPv6 address that is allowed to
        access this instance. Must be set even if other two attributes are not for
        the whitelist to become active.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class DatabaseInstanceSettingsInsightsConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "queryInsightsEnabled":
            suggest = "query_insights_enabled"
        elif key == "queryStringLength":
            suggest = "query_string_length"
        elif key == "recordApplicationTags":
            suggest = "record_application_tags"
        elif key == "recordClientAddress":
            suggest = "record_client_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseInstanceSettingsInsightsConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseInstanceSettingsInsightsConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseInstanceSettingsInsightsConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 query_insights_enabled: Optional[bool] = None,
                 query_string_length: Optional[int] = None,
                 record_application_tags: Optional[bool] = None,
                 record_client_address: Optional[bool] = None):
        """
        :param bool query_insights_enabled: True if Query Insights feature is enabled.
        :param int query_string_length: Maximum query length stored in bytes. Between 256 and 4500. Default to 1024.
        :param bool record_application_tags: True if Query Insights will record application tags from query when enabled.
        :param bool record_client_address: True if Query Insights will record client address when enabled.
        """
        if query_insights_enabled is not None:
            pulumi.set(__self__, "query_insights_enabled", query_insights_enabled)
        if query_string_length is not None:
            pulumi.set(__self__, "query_string_length", query_string_length)
        if record_application_tags is not None:
            pulumi.set(__self__, "record_application_tags", record_application_tags)
        if record_client_address is not None:
            pulumi.set(__self__, "record_client_address", record_client_address)

    @property
    @pulumi.getter(name="queryInsightsEnabled")
    def query_insights_enabled(self) -> Optional[bool]:
        """
        True if Query Insights feature is enabled.
        """
        return pulumi.get(self, "query_insights_enabled")

    @property
    @pulumi.getter(name="queryStringLength")
    def query_string_length(self) -> Optional[int]:
        """
        Maximum query length stored in bytes. Between 256 and 4500. Default to 1024.
        """
        return pulumi.get(self, "query_string_length")

    @property
    @pulumi.getter(name="recordApplicationTags")
    def record_application_tags(self) -> Optional[bool]:
        """
        True if Query Insights will record application tags from query when enabled.
        """
        return pulumi.get(self, "record_application_tags")

    @property
    @pulumi.getter(name="recordClientAddress")
    def record_client_address(self) -> Optional[bool]:
        """
        True if Query Insights will record client address when enabled.
        """
        return pulumi.get(self, "record_client_address")


@pulumi.output_type
class DatabaseInstanceSettingsIpConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allocatedIpRange":
            suggest = "allocated_ip_range"
        elif key == "authorizedNetworks":
            suggest = "authorized_networks"
        elif key == "ipv4Enabled":
            suggest = "ipv4_enabled"
        elif key == "privateNetwork":
            suggest = "private_network"
        elif key == "requireSsl":
            suggest = "require_ssl"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseInstanceSettingsIpConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseInstanceSettingsIpConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseInstanceSettingsIpConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allocated_ip_range: Optional[str] = None,
                 authorized_networks: Optional[Sequence['outputs.DatabaseInstanceSettingsIpConfigurationAuthorizedNetwork']] = None,
                 ipv4_enabled: Optional[bool] = None,
                 private_network: Optional[str] = None,
                 require_ssl: Optional[bool] = None):
        """
        :param str allocated_ip_range: The name of the allocated ip range for the private ip CloudSQL instance. For example: "google-managed-services-default". If set, the cloned instance ip will be created in the allocated range. The range name must comply with [RFC 1035](https://tools.ietf.org/html/rfc1035). Specifically, the name must be 1-63 characters long and match the regular expression a-z?.
        :param bool ipv4_enabled: Whether this Cloud SQL instance should be assigned
               a public IPV4 address. At least `ipv4_enabled` must be enabled or a
               `private_network` must be configured.
        :param str private_network: The VPC network from which the Cloud SQL
               instance is accessible for private IP. For example, projects/myProject/global/networks/default.
               Specifying a network enables private IP.
               At least `ipv4_enabled` must be enabled or a `private_network` must be configured.
               This setting can be updated, but it cannot be removed after it is set.
        :param bool require_ssl: Whether SSL connections over IP are enforced or not.
        """
        if allocated_ip_range is not None:
            pulumi.set(__self__, "allocated_ip_range", allocated_ip_range)
        if authorized_networks is not None:
            pulumi.set(__self__, "authorized_networks", authorized_networks)
        if ipv4_enabled is not None:
            pulumi.set(__self__, "ipv4_enabled", ipv4_enabled)
        if private_network is not None:
            pulumi.set(__self__, "private_network", private_network)
        if require_ssl is not None:
            pulumi.set(__self__, "require_ssl", require_ssl)

    @property
    @pulumi.getter(name="allocatedIpRange")
    def allocated_ip_range(self) -> Optional[str]:
        """
        The name of the allocated ip range for the private ip CloudSQL instance. For example: "google-managed-services-default". If set, the cloned instance ip will be created in the allocated range. The range name must comply with [RFC 1035](https://tools.ietf.org/html/rfc1035). Specifically, the name must be 1-63 characters long and match the regular expression a-z?.
        """
        return pulumi.get(self, "allocated_ip_range")

    @property
    @pulumi.getter(name="authorizedNetworks")
    def authorized_networks(self) -> Optional[Sequence['outputs.DatabaseInstanceSettingsIpConfigurationAuthorizedNetwork']]:
        return pulumi.get(self, "authorized_networks")

    @property
    @pulumi.getter(name="ipv4Enabled")
    def ipv4_enabled(self) -> Optional[bool]:
        """
        Whether this Cloud SQL instance should be assigned
        a public IPV4 address. At least `ipv4_enabled` must be enabled or a
        `private_network` must be configured.
        """
        return pulumi.get(self, "ipv4_enabled")

    @property
    @pulumi.getter(name="privateNetwork")
    def private_network(self) -> Optional[str]:
        """
        The VPC network from which the Cloud SQL
        instance is accessible for private IP. For example, projects/myProject/global/networks/default.
        Specifying a network enables private IP.
        At least `ipv4_enabled` must be enabled or a `private_network` must be configured.
        This setting can be updated, but it cannot be removed after it is set.
        """
        return pulumi.get(self, "private_network")

    @property
    @pulumi.getter(name="requireSsl")
    def require_ssl(self) -> Optional[bool]:
        """
        Whether SSL connections over IP are enforced or not.
        """
        return pulumi.get(self, "require_ssl")


@pulumi.output_type
class DatabaseInstanceSettingsIpConfigurationAuthorizedNetwork(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "expirationTime":
            suggest = "expiration_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseInstanceSettingsIpConfigurationAuthorizedNetwork. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseInstanceSettingsIpConfigurationAuthorizedNetwork.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseInstanceSettingsIpConfigurationAuthorizedNetwork.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 value: str,
                 expiration_time: Optional[str] = None,
                 name: Optional[str] = None):
        """
        :param str value: A CIDR notation IPv4 or IPv6 address that is allowed to
               access this instance. Must be set even if other two attributes are not for
               the whitelist to become active.
        :param str expiration_time: The [RFC 3339](https://tools.ietf.org/html/rfc3339)
               formatted date time string indicating when this whitelist expires.
        :param str name: A name for this whitelist entry.
        """
        pulumi.set(__self__, "value", value)
        if expiration_time is not None:
            pulumi.set(__self__, "expiration_time", expiration_time)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        A CIDR notation IPv4 or IPv6 address that is allowed to
        access this instance. Must be set even if other two attributes are not for
        the whitelist to become active.
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter(name="expirationTime")
    def expiration_time(self) -> Optional[str]:
        """
        The [RFC 3339](https://tools.ietf.org/html/rfc3339)
        formatted date time string indicating when this whitelist expires.
        """
        return pulumi.get(self, "expiration_time")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        A name for this whitelist entry.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class DatabaseInstanceSettingsLocationPreference(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "followGaeApplication":
            suggest = "follow_gae_application"
        elif key == "secondaryZone":
            suggest = "secondary_zone"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseInstanceSettingsLocationPreference. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseInstanceSettingsLocationPreference.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseInstanceSettingsLocationPreference.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 follow_gae_application: Optional[str] = None,
                 secondary_zone: Optional[str] = None,
                 zone: Optional[str] = None):
        """
        :param str follow_gae_application: A GAE application whose zone to remain
               in. Must be in the same region as this instance.
        :param str secondary_zone: The preferred Compute Engine zone for the secondary/failover.
        :param str zone: The preferred compute engine
               [zone](https://cloud.google.com/compute/docs/zones?hl=en).
        """
        if follow_gae_application is not None:
            pulumi.set(__self__, "follow_gae_application", follow_gae_application)
        if secondary_zone is not None:
            pulumi.set(__self__, "secondary_zone", secondary_zone)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="followGaeApplication")
    def follow_gae_application(self) -> Optional[str]:
        """
        A GAE application whose zone to remain
        in. Must be in the same region as this instance.
        """
        return pulumi.get(self, "follow_gae_application")

    @property
    @pulumi.getter(name="secondaryZone")
    def secondary_zone(self) -> Optional[str]:
        """
        The preferred Compute Engine zone for the secondary/failover.
        """
        return pulumi.get(self, "secondary_zone")

    @property
    @pulumi.getter
    def zone(self) -> Optional[str]:
        """
        The preferred compute engine
        [zone](https://cloud.google.com/compute/docs/zones?hl=en).
        """
        return pulumi.get(self, "zone")


@pulumi.output_type
class DatabaseInstanceSettingsMaintenanceWindow(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "updateTrack":
            suggest = "update_track"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseInstanceSettingsMaintenanceWindow. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseInstanceSettingsMaintenanceWindow.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseInstanceSettingsMaintenanceWindow.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 day: Optional[int] = None,
                 hour: Optional[int] = None,
                 update_track: Optional[str] = None):
        """
        :param int day: Day of week (`1-7`), starting on Monday
        :param int hour: Hour of day (`0-23`), ignored if `day` not set
        :param str update_track: Receive updates earlier (`canary`) or later
               (`stable`)
        """
        if day is not None:
            pulumi.set(__self__, "day", day)
        if hour is not None:
            pulumi.set(__self__, "hour", hour)
        if update_track is not None:
            pulumi.set(__self__, "update_track", update_track)

    @property
    @pulumi.getter
    def day(self) -> Optional[int]:
        """
        Day of week (`1-7`), starting on Monday
        """
        return pulumi.get(self, "day")

    @property
    @pulumi.getter
    def hour(self) -> Optional[int]:
        """
        Hour of day (`0-23`), ignored if `day` not set
        """
        return pulumi.get(self, "hour")

    @property
    @pulumi.getter(name="updateTrack")
    def update_track(self) -> Optional[str]:
        """
        Receive updates earlier (`canary`) or later
        (`stable`)
        """
        return pulumi.get(self, "update_track")


@pulumi.output_type
class DatabaseInstanceSettingsSqlServerAuditConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "retentionInterval":
            suggest = "retention_interval"
        elif key == "uploadInterval":
            suggest = "upload_interval"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseInstanceSettingsSqlServerAuditConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseInstanceSettingsSqlServerAuditConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseInstanceSettingsSqlServerAuditConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bucket: str,
                 retention_interval: Optional[str] = None,
                 upload_interval: Optional[str] = None):
        """
        :param str bucket: The name of the destination bucket (e.g., gs://mybucket).
        :param str retention_interval: How long to keep generated audit files. A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        :param str upload_interval: How often to upload generated audit files. A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        """
        pulumi.set(__self__, "bucket", bucket)
        if retention_interval is not None:
            pulumi.set(__self__, "retention_interval", retention_interval)
        if upload_interval is not None:
            pulumi.set(__self__, "upload_interval", upload_interval)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        """
        The name of the destination bucket (e.g., gs://mybucket).
        """
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="retentionInterval")
    def retention_interval(self) -> Optional[str]:
        """
        How long to keep generated audit files. A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        """
        return pulumi.get(self, "retention_interval")

    @property
    @pulumi.getter(name="uploadInterval")
    def upload_interval(self) -> Optional[str]:
        """
        How often to upload generated audit files. A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        """
        return pulumi.get(self, "upload_interval")


@pulumi.output_type
class UserSqlServerUserDetails(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "serverRoles":
            suggest = "server_roles"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in UserSqlServerUserDetails. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        UserSqlServerUserDetails.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        UserSqlServerUserDetails.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 disabled: Optional[bool] = None,
                 server_roles: Optional[Sequence[str]] = None):
        if disabled is not None:
            pulumi.set(__self__, "disabled", disabled)
        if server_roles is not None:
            pulumi.set(__self__, "server_roles", server_roles)

    @property
    @pulumi.getter
    def disabled(self) -> Optional[bool]:
        return pulumi.get(self, "disabled")

    @property
    @pulumi.getter(name="serverRoles")
    def server_roles(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "server_roles")


@pulumi.output_type
class GetCaCertsCertResult(dict):
    def __init__(__self__, *,
                 cert: str,
                 common_name: str,
                 create_time: str,
                 expiration_time: str,
                 sha1_fingerprint: str):
        """
        :param str cert: The CA certificate used to connect to the SQL instance via SSL.
        :param str common_name: The CN valid for the CA cert.
        :param str create_time: Creation time of the CA cert.
        :param str expiration_time: Expiration time of the CA cert.
        :param str sha1_fingerprint: SHA1 fingerprint of the CA cert.
        """
        pulumi.set(__self__, "cert", cert)
        pulumi.set(__self__, "common_name", common_name)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "expiration_time", expiration_time)
        pulumi.set(__self__, "sha1_fingerprint", sha1_fingerprint)

    @property
    @pulumi.getter
    def cert(self) -> str:
        """
        The CA certificate used to connect to the SQL instance via SSL.
        """
        return pulumi.get(self, "cert")

    @property
    @pulumi.getter(name="commonName")
    def common_name(self) -> str:
        """
        The CN valid for the CA cert.
        """
        return pulumi.get(self, "common_name")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        Creation time of the CA cert.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="expirationTime")
    def expiration_time(self) -> str:
        """
        Expiration time of the CA cert.
        """
        return pulumi.get(self, "expiration_time")

    @property
    @pulumi.getter(name="sha1Fingerprint")
    def sha1_fingerprint(self) -> str:
        """
        SHA1 fingerprint of the CA cert.
        """
        return pulumi.get(self, "sha1_fingerprint")


@pulumi.output_type
class GetDatabaseInstanceCloneResult(dict):
    def __init__(__self__, *,
                 allocated_ip_range: str,
                 point_in_time: str,
                 source_instance_name: str):
        pulumi.set(__self__, "allocated_ip_range", allocated_ip_range)
        pulumi.set(__self__, "point_in_time", point_in_time)
        pulumi.set(__self__, "source_instance_name", source_instance_name)

    @property
    @pulumi.getter(name="allocatedIpRange")
    def allocated_ip_range(self) -> str:
        return pulumi.get(self, "allocated_ip_range")

    @property
    @pulumi.getter(name="pointInTime")
    def point_in_time(self) -> str:
        return pulumi.get(self, "point_in_time")

    @property
    @pulumi.getter(name="sourceInstanceName")
    def source_instance_name(self) -> str:
        return pulumi.get(self, "source_instance_name")


@pulumi.output_type
class GetDatabaseInstanceIpAddressResult(dict):
    def __init__(__self__, *,
                 ip_address: str,
                 time_to_retire: str,
                 type: str):
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "time_to_retire", time_to_retire)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> str:
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter(name="timeToRetire")
    def time_to_retire(self) -> str:
        return pulumi.get(self, "time_to_retire")

    @property
    @pulumi.getter
    def type(self) -> str:
        return pulumi.get(self, "type")


@pulumi.output_type
class GetDatabaseInstanceReplicaConfigurationResult(dict):
    def __init__(__self__, *,
                 ca_certificate: str,
                 client_certificate: str,
                 client_key: str,
                 connect_retry_interval: int,
                 dump_file_path: str,
                 failover_target: bool,
                 master_heartbeat_period: int,
                 password: str,
                 ssl_cipher: str,
                 username: str,
                 verify_server_certificate: bool):
        pulumi.set(__self__, "ca_certificate", ca_certificate)
        pulumi.set(__self__, "client_certificate", client_certificate)
        pulumi.set(__self__, "client_key", client_key)
        pulumi.set(__self__, "connect_retry_interval", connect_retry_interval)
        pulumi.set(__self__, "dump_file_path", dump_file_path)
        pulumi.set(__self__, "failover_target", failover_target)
        pulumi.set(__self__, "master_heartbeat_period", master_heartbeat_period)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "ssl_cipher", ssl_cipher)
        pulumi.set(__self__, "username", username)
        pulumi.set(__self__, "verify_server_certificate", verify_server_certificate)

    @property
    @pulumi.getter(name="caCertificate")
    def ca_certificate(self) -> str:
        return pulumi.get(self, "ca_certificate")

    @property
    @pulumi.getter(name="clientCertificate")
    def client_certificate(self) -> str:
        return pulumi.get(self, "client_certificate")

    @property
    @pulumi.getter(name="clientKey")
    def client_key(self) -> str:
        return pulumi.get(self, "client_key")

    @property
    @pulumi.getter(name="connectRetryInterval")
    def connect_retry_interval(self) -> int:
        return pulumi.get(self, "connect_retry_interval")

    @property
    @pulumi.getter(name="dumpFilePath")
    def dump_file_path(self) -> str:
        return pulumi.get(self, "dump_file_path")

    @property
    @pulumi.getter(name="failoverTarget")
    def failover_target(self) -> bool:
        return pulumi.get(self, "failover_target")

    @property
    @pulumi.getter(name="masterHeartbeatPeriod")
    def master_heartbeat_period(self) -> int:
        return pulumi.get(self, "master_heartbeat_period")

    @property
    @pulumi.getter
    def password(self) -> str:
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="sslCipher")
    def ssl_cipher(self) -> str:
        return pulumi.get(self, "ssl_cipher")

    @property
    @pulumi.getter
    def username(self) -> str:
        return pulumi.get(self, "username")

    @property
    @pulumi.getter(name="verifyServerCertificate")
    def verify_server_certificate(self) -> bool:
        return pulumi.get(self, "verify_server_certificate")


@pulumi.output_type
class GetDatabaseInstanceRestoreBackupContextResult(dict):
    def __init__(__self__, *,
                 backup_run_id: int,
                 instance_id: str,
                 project: str):
        """
        :param str project: The ID of the project in which the resource belongs.
        """
        pulumi.set(__self__, "backup_run_id", backup_run_id)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter(name="backupRunId")
    def backup_run_id(self) -> int:
        return pulumi.get(self, "backup_run_id")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> str:
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter
    def project(self) -> str:
        """
        The ID of the project in which the resource belongs.
        """
        return pulumi.get(self, "project")


@pulumi.output_type
class GetDatabaseInstanceServerCaCertResult(dict):
    def __init__(__self__, *,
                 cert: str,
                 common_name: str,
                 create_time: str,
                 expiration_time: str,
                 sha1_fingerprint: str):
        pulumi.set(__self__, "cert", cert)
        pulumi.set(__self__, "common_name", common_name)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "expiration_time", expiration_time)
        pulumi.set(__self__, "sha1_fingerprint", sha1_fingerprint)

    @property
    @pulumi.getter
    def cert(self) -> str:
        return pulumi.get(self, "cert")

    @property
    @pulumi.getter(name="commonName")
    def common_name(self) -> str:
        return pulumi.get(self, "common_name")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="expirationTime")
    def expiration_time(self) -> str:
        return pulumi.get(self, "expiration_time")

    @property
    @pulumi.getter(name="sha1Fingerprint")
    def sha1_fingerprint(self) -> str:
        return pulumi.get(self, "sha1_fingerprint")


@pulumi.output_type
class GetDatabaseInstanceSettingResult(dict):
    def __init__(__self__, *,
                 activation_policy: str,
                 active_directory_configs: Sequence['outputs.GetDatabaseInstanceSettingActiveDirectoryConfigResult'],
                 availability_type: str,
                 backup_configurations: Sequence['outputs.GetDatabaseInstanceSettingBackupConfigurationResult'],
                 collation: str,
                 database_flags: Sequence['outputs.GetDatabaseInstanceSettingDatabaseFlagResult'],
                 disk_autoresize: bool,
                 disk_autoresize_limit: int,
                 disk_size: int,
                 disk_type: str,
                 insights_configs: Sequence['outputs.GetDatabaseInstanceSettingInsightsConfigResult'],
                 ip_configurations: Sequence['outputs.GetDatabaseInstanceSettingIpConfigurationResult'],
                 location_preferences: Sequence['outputs.GetDatabaseInstanceSettingLocationPreferenceResult'],
                 maintenance_windows: Sequence['outputs.GetDatabaseInstanceSettingMaintenanceWindowResult'],
                 pricing_plan: str,
                 sql_server_audit_configs: Sequence['outputs.GetDatabaseInstanceSettingSqlServerAuditConfigResult'],
                 tier: str,
                 user_labels: Mapping[str, str],
                 version: int):
        pulumi.set(__self__, "activation_policy", activation_policy)
        pulumi.set(__self__, "active_directory_configs", active_directory_configs)
        pulumi.set(__self__, "availability_type", availability_type)
        pulumi.set(__self__, "backup_configurations", backup_configurations)
        pulumi.set(__self__, "collation", collation)
        pulumi.set(__self__, "database_flags", database_flags)
        pulumi.set(__self__, "disk_autoresize", disk_autoresize)
        pulumi.set(__self__, "disk_autoresize_limit", disk_autoresize_limit)
        pulumi.set(__self__, "disk_size", disk_size)
        pulumi.set(__self__, "disk_type", disk_type)
        pulumi.set(__self__, "insights_configs", insights_configs)
        pulumi.set(__self__, "ip_configurations", ip_configurations)
        pulumi.set(__self__, "location_preferences", location_preferences)
        pulumi.set(__self__, "maintenance_windows", maintenance_windows)
        pulumi.set(__self__, "pricing_plan", pricing_plan)
        pulumi.set(__self__, "sql_server_audit_configs", sql_server_audit_configs)
        pulumi.set(__self__, "tier", tier)
        pulumi.set(__self__, "user_labels", user_labels)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="activationPolicy")
    def activation_policy(self) -> str:
        return pulumi.get(self, "activation_policy")

    @property
    @pulumi.getter(name="activeDirectoryConfigs")
    def active_directory_configs(self) -> Sequence['outputs.GetDatabaseInstanceSettingActiveDirectoryConfigResult']:
        return pulumi.get(self, "active_directory_configs")

    @property
    @pulumi.getter(name="availabilityType")
    def availability_type(self) -> str:
        return pulumi.get(self, "availability_type")

    @property
    @pulumi.getter(name="backupConfigurations")
    def backup_configurations(self) -> Sequence['outputs.GetDatabaseInstanceSettingBackupConfigurationResult']:
        return pulumi.get(self, "backup_configurations")

    @property
    @pulumi.getter
    def collation(self) -> str:
        return pulumi.get(self, "collation")

    @property
    @pulumi.getter(name="databaseFlags")
    def database_flags(self) -> Sequence['outputs.GetDatabaseInstanceSettingDatabaseFlagResult']:
        return pulumi.get(self, "database_flags")

    @property
    @pulumi.getter(name="diskAutoresize")
    def disk_autoresize(self) -> bool:
        return pulumi.get(self, "disk_autoresize")

    @property
    @pulumi.getter(name="diskAutoresizeLimit")
    def disk_autoresize_limit(self) -> int:
        return pulumi.get(self, "disk_autoresize_limit")

    @property
    @pulumi.getter(name="diskSize")
    def disk_size(self) -> int:
        return pulumi.get(self, "disk_size")

    @property
    @pulumi.getter(name="diskType")
    def disk_type(self) -> str:
        return pulumi.get(self, "disk_type")

    @property
    @pulumi.getter(name="insightsConfigs")
    def insights_configs(self) -> Sequence['outputs.GetDatabaseInstanceSettingInsightsConfigResult']:
        return pulumi.get(self, "insights_configs")

    @property
    @pulumi.getter(name="ipConfigurations")
    def ip_configurations(self) -> Sequence['outputs.GetDatabaseInstanceSettingIpConfigurationResult']:
        return pulumi.get(self, "ip_configurations")

    @property
    @pulumi.getter(name="locationPreferences")
    def location_preferences(self) -> Sequence['outputs.GetDatabaseInstanceSettingLocationPreferenceResult']:
        return pulumi.get(self, "location_preferences")

    @property
    @pulumi.getter(name="maintenanceWindows")
    def maintenance_windows(self) -> Sequence['outputs.GetDatabaseInstanceSettingMaintenanceWindowResult']:
        return pulumi.get(self, "maintenance_windows")

    @property
    @pulumi.getter(name="pricingPlan")
    def pricing_plan(self) -> str:
        return pulumi.get(self, "pricing_plan")

    @property
    @pulumi.getter(name="sqlServerAuditConfigs")
    def sql_server_audit_configs(self) -> Sequence['outputs.GetDatabaseInstanceSettingSqlServerAuditConfigResult']:
        return pulumi.get(self, "sql_server_audit_configs")

    @property
    @pulumi.getter
    def tier(self) -> str:
        return pulumi.get(self, "tier")

    @property
    @pulumi.getter(name="userLabels")
    def user_labels(self) -> Mapping[str, str]:
        return pulumi.get(self, "user_labels")

    @property
    @pulumi.getter
    def version(self) -> int:
        return pulumi.get(self, "version")


@pulumi.output_type
class GetDatabaseInstanceSettingActiveDirectoryConfigResult(dict):
    def __init__(__self__, *,
                 domain: str):
        pulumi.set(__self__, "domain", domain)

    @property
    @pulumi.getter
    def domain(self) -> str:
        return pulumi.get(self, "domain")


@pulumi.output_type
class GetDatabaseInstanceSettingBackupConfigurationResult(dict):
    def __init__(__self__, *,
                 backup_retention_settings: Sequence['outputs.GetDatabaseInstanceSettingBackupConfigurationBackupRetentionSettingResult'],
                 binary_log_enabled: bool,
                 enabled: bool,
                 location: str,
                 point_in_time_recovery_enabled: bool,
                 start_time: str,
                 transaction_log_retention_days: int):
        pulumi.set(__self__, "backup_retention_settings", backup_retention_settings)
        pulumi.set(__self__, "binary_log_enabled", binary_log_enabled)
        pulumi.set(__self__, "enabled", enabled)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "point_in_time_recovery_enabled", point_in_time_recovery_enabled)
        pulumi.set(__self__, "start_time", start_time)
        pulumi.set(__self__, "transaction_log_retention_days", transaction_log_retention_days)

    @property
    @pulumi.getter(name="backupRetentionSettings")
    def backup_retention_settings(self) -> Sequence['outputs.GetDatabaseInstanceSettingBackupConfigurationBackupRetentionSettingResult']:
        return pulumi.get(self, "backup_retention_settings")

    @property
    @pulumi.getter(name="binaryLogEnabled")
    def binary_log_enabled(self) -> bool:
        return pulumi.get(self, "binary_log_enabled")

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter
    def location(self) -> str:
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="pointInTimeRecoveryEnabled")
    def point_in_time_recovery_enabled(self) -> bool:
        return pulumi.get(self, "point_in_time_recovery_enabled")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> str:
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter(name="transactionLogRetentionDays")
    def transaction_log_retention_days(self) -> int:
        return pulumi.get(self, "transaction_log_retention_days")


@pulumi.output_type
class GetDatabaseInstanceSettingBackupConfigurationBackupRetentionSettingResult(dict):
    def __init__(__self__, *,
                 retained_backups: int,
                 retention_unit: str):
        pulumi.set(__self__, "retained_backups", retained_backups)
        pulumi.set(__self__, "retention_unit", retention_unit)

    @property
    @pulumi.getter(name="retainedBackups")
    def retained_backups(self) -> int:
        return pulumi.get(self, "retained_backups")

    @property
    @pulumi.getter(name="retentionUnit")
    def retention_unit(self) -> str:
        return pulumi.get(self, "retention_unit")


@pulumi.output_type
class GetDatabaseInstanceSettingDatabaseFlagResult(dict):
    def __init__(__self__, *,
                 name: str,
                 value: str):
        """
        :param str name: The name of the instance.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the instance.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> str:
        return pulumi.get(self, "value")


@pulumi.output_type
class GetDatabaseInstanceSettingInsightsConfigResult(dict):
    def __init__(__self__, *,
                 query_insights_enabled: bool,
                 query_string_length: int,
                 record_application_tags: bool,
                 record_client_address: bool):
        pulumi.set(__self__, "query_insights_enabled", query_insights_enabled)
        pulumi.set(__self__, "query_string_length", query_string_length)
        pulumi.set(__self__, "record_application_tags", record_application_tags)
        pulumi.set(__self__, "record_client_address", record_client_address)

    @property
    @pulumi.getter(name="queryInsightsEnabled")
    def query_insights_enabled(self) -> bool:
        return pulumi.get(self, "query_insights_enabled")

    @property
    @pulumi.getter(name="queryStringLength")
    def query_string_length(self) -> int:
        return pulumi.get(self, "query_string_length")

    @property
    @pulumi.getter(name="recordApplicationTags")
    def record_application_tags(self) -> bool:
        return pulumi.get(self, "record_application_tags")

    @property
    @pulumi.getter(name="recordClientAddress")
    def record_client_address(self) -> bool:
        return pulumi.get(self, "record_client_address")


@pulumi.output_type
class GetDatabaseInstanceSettingIpConfigurationResult(dict):
    def __init__(__self__, *,
                 allocated_ip_range: str,
                 authorized_networks: Sequence['outputs.GetDatabaseInstanceSettingIpConfigurationAuthorizedNetworkResult'],
                 ipv4_enabled: bool,
                 private_network: str,
                 require_ssl: bool):
        pulumi.set(__self__, "allocated_ip_range", allocated_ip_range)
        pulumi.set(__self__, "authorized_networks", authorized_networks)
        pulumi.set(__self__, "ipv4_enabled", ipv4_enabled)
        pulumi.set(__self__, "private_network", private_network)
        pulumi.set(__self__, "require_ssl", require_ssl)

    @property
    @pulumi.getter(name="allocatedIpRange")
    def allocated_ip_range(self) -> str:
        return pulumi.get(self, "allocated_ip_range")

    @property
    @pulumi.getter(name="authorizedNetworks")
    def authorized_networks(self) -> Sequence['outputs.GetDatabaseInstanceSettingIpConfigurationAuthorizedNetworkResult']:
        return pulumi.get(self, "authorized_networks")

    @property
    @pulumi.getter(name="ipv4Enabled")
    def ipv4_enabled(self) -> bool:
        return pulumi.get(self, "ipv4_enabled")

    @property
    @pulumi.getter(name="privateNetwork")
    def private_network(self) -> str:
        return pulumi.get(self, "private_network")

    @property
    @pulumi.getter(name="requireSsl")
    def require_ssl(self) -> bool:
        return pulumi.get(self, "require_ssl")


@pulumi.output_type
class GetDatabaseInstanceSettingIpConfigurationAuthorizedNetworkResult(dict):
    def __init__(__self__, *,
                 expiration_time: str,
                 name: str,
                 value: str):
        """
        :param str name: The name of the instance.
        """
        pulumi.set(__self__, "expiration_time", expiration_time)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter(name="expirationTime")
    def expiration_time(self) -> str:
        return pulumi.get(self, "expiration_time")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the instance.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> str:
        return pulumi.get(self, "value")


@pulumi.output_type
class GetDatabaseInstanceSettingLocationPreferenceResult(dict):
    def __init__(__self__, *,
                 follow_gae_application: str,
                 secondary_zone: str,
                 zone: str):
        pulumi.set(__self__, "follow_gae_application", follow_gae_application)
        pulumi.set(__self__, "secondary_zone", secondary_zone)
        pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="followGaeApplication")
    def follow_gae_application(self) -> str:
        return pulumi.get(self, "follow_gae_application")

    @property
    @pulumi.getter(name="secondaryZone")
    def secondary_zone(self) -> str:
        return pulumi.get(self, "secondary_zone")

    @property
    @pulumi.getter
    def zone(self) -> str:
        return pulumi.get(self, "zone")


@pulumi.output_type
class GetDatabaseInstanceSettingMaintenanceWindowResult(dict):
    def __init__(__self__, *,
                 day: int,
                 hour: int,
                 update_track: str):
        pulumi.set(__self__, "day", day)
        pulumi.set(__self__, "hour", hour)
        pulumi.set(__self__, "update_track", update_track)

    @property
    @pulumi.getter
    def day(self) -> int:
        return pulumi.get(self, "day")

    @property
    @pulumi.getter
    def hour(self) -> int:
        return pulumi.get(self, "hour")

    @property
    @pulumi.getter(name="updateTrack")
    def update_track(self) -> str:
        return pulumi.get(self, "update_track")


@pulumi.output_type
class GetDatabaseInstanceSettingSqlServerAuditConfigResult(dict):
    def __init__(__self__, *,
                 bucket: str,
                 retention_interval: str,
                 upload_interval: str):
        pulumi.set(__self__, "bucket", bucket)
        pulumi.set(__self__, "retention_interval", retention_interval)
        pulumi.set(__self__, "upload_interval", upload_interval)

    @property
    @pulumi.getter
    def bucket(self) -> str:
        return pulumi.get(self, "bucket")

    @property
    @pulumi.getter(name="retentionInterval")
    def retention_interval(self) -> str:
        return pulumi.get(self, "retention_interval")

    @property
    @pulumi.getter(name="uploadInterval")
    def upload_interval(self) -> str:
        return pulumi.get(self, "upload_interval")


