from khmernltk.utils.log_utils import logger

SEPARATOR = "\u200b"

# list of constants needed for KCC and feature generation

# consonant and independent vowels
KHCONST = set(u"កខគឃងចឆជឈញដឋឌឍណតថទធនបផពភមយរលវឝឞសហឡអឣឤឥឦឧឨឩឪឫឬឭឮឯឰឱឲឳ")
KHVOWEL = set(u"឴឵ាិីឹឺុូួើឿៀេែៃោៅ\u17c6\u17c7\u17c8")

# subscript, diacritics
KHSUB = set(u"្")
# MUUSIKATOAN, TRIISAP, BANTOC,ROBAT,
KHDIAC = set(u"\u17c9\u17ca\u17cb\u17cc\u17cd\u17ce\u17cf\u17d0")
KHSYM = set("៕។៛ៗ៚៙៘,.? ")  # add space
KHNUMBER = set(u"០១២៣៤៥៦៧៨៩0123456789")  # remove 0123456789
# lunar date:  U+19E0 to U+19FF ᧠...᧿
KHLUNAR = set("᧠᧡᧢᧣᧤᧥᧦᧧᧨᧩᧪᧫᧬᧭᧮᧯᧰᧱᧲᧳᧴᧵᧶᧷᧸᧹᧺᧻᧼᧽᧾᧿")

EN = set(u"abcdefghijklmnopqrstuvwxyz0123456789")

# E=English, C=Consonant, W=wowel, N=number, O=Other, S=subcript, D=Diacritic, NS=no_space(same E)
# roll up to: NS, C, W, S, D
NS = "NS"

mistokenized_dict = {
    "អា​ខោន​": "អាខោន​",  # account
    "​ឱវា​ទ": "​ឱវាទ",
    "នៅ​សប្តា​ហ៏​": "នៅ​សប្តាហ៏​",
    "សាយ​ ​មក​រា": "សាយ​ ​មករា",
    "រោង​កុន": "រោងកុន",
    "ដេី​មជ្រៃ": "ដេីមជ្រៃ",
    "​ដេី​ម​": "​ដេីម​",
    "មន្ទី​ពេទ្យ": "មន្ទីពេទ្យ",
    "ជាដរាបត​ទៅ": "ជា​ដរាប​តទៅ",
    "ដេី​ម្បី​": "ដេីម្បី​",
    "ធ្វេី​ការកាត់​យក": "ធ្វេីការ​កាត់​យក",  # interesting!!!!
    "ភូមិ​ផ្សារ​ដី​ហុយ": "ភូមិ​ផ្សារដីហុយ",
    "ប្រតិបត្តិការបង្ក្រាប": "ប្រតិបត្តិការ​បង្ក្រាប",
    "health​.​com​.​kh": "health.com.kh",
    "ពួយ​ ​ច័ន្ទ​សុគុណ": "ពួយ​ ​ច័ន្ទសុគុណ",
    "ភូមិ​ ​ថ្ម​ដា": "ភូមិ​ ​ថ្មដា",
    "សង្កាត់​ ​បឹង​កន្សែង": "សង្កាត់​ ​បឹងកន្សែង",  # TODO what is orig text???
    "ក្រុង​ ​បាន​លុង": "ក្រុង​ ​បានលុង",
    "នុត​ ​សុគន្ធ​ ​ផាន់​នី": "នុត​ ​សុគន្ធ​ ​ផាន់នី",
    # 'ព្រះរាជាណា ច្រក កម្ពុជា':'ព្រះរាជាណាច្រ ក កម្ពុជា', #bad spelling – no better seg
    # from https://www.redcross.org.kh/ កាកបាទក្រហមកម្ពុជា
    "កាក​បាត​ក្រហម": "កាកបាត​ក្រហម",
    "ស្រុក​ ​កំពង់ត្រា​ច": "ស្រុក​ ​កំពង់ត្រាច",
    "ឃុំ​ ​ថ្ម​កែវ": "ឃុំ​ ​ថ្មកែវ",
    "ស្រុក​ ​អង្គរ​ជ័យ": "ស្រុក​ ​អង្គរជ័យ",
    "កោះ​តា​កូវ ឃុំ​ឬ​ស្សី": "កោះ​តាកូវ ឃុំ​ឬស្សី",
    "ម៉ាក​ ​សែន​សូនីតា": "ម៉ាក​ ​សែនសូនីតា",
    "ជា​ ​ដេី​ម​ ​នោះ": "ជា​ ​ដេីម​ ​នោះ",
    # prob eiy is two chars េ ⁣ី instead of one char
    "ដេី​ម្បី​ ​ជ្រាប": "ដេីម្បី​ ​ជ្រាប",
    "ក​រករណី": "ករ​ករណី",
    "ទោ​ចក្រ​យានយន្ត": "ទោចក្រយានយន្ត",
    "ឃុំ​ ​អន្លង់​វិល": "ឃុំ​ ​អន្លង់វិល",
    "​ពោធ៍​សាត់": "​ពោធ៍សាត់",
    "ណាក់​ ​ស្រី​ណា": "ណាក់​ ​ស្រីណា",
    "ពិធីការ​នីមួយ": "ពិធីការនី​មួយ",  # valid both ways: need context
    "តូរុន​តូ": "តូរុនតូ",  # Toronto
    "ដាយ​ណូស័រ": "ដាយណូស័រ",  # Dinosaur
    "ហ្គារ៉ាល់​ហូស": "ហ្គារ៉ាល់ហូស",  # Guarulhos in Sao Paulo
    "ខេមរៈ​ ​សិរី​មន្ត": "ខេមរៈ​ ​សិរីមន្ត",  # ខេមរៈ \u200bសិរី\u200bមន្ត
    "ឱម​ ​យ៉ិន​ទៀង": "ឱម​ ​យ៉ិនទៀង",
    "មហា​លាប": "មហាលាប",
    "ការចាប់អារម្ម​ណ៏​": "ការចាប់អារម្មណ៏​",
    "វ៉ិច​ទ័រ​": "វ៉ិចទ័រ​",  # rector
    "សុវណ្ណ​ ​ឬ​ទ្ធី": "សុវណ្ណ​ ​ឬទ្ធី",
    "ខាន់​ ​ចាន់​សុផល": "ខាន់​ ​ចាន់សុផល",
    "ទំនួលខុសត្រូវ​": "ទំនួល​ខុសត្រូវ​",
    "ឯ​ណេះ": "ឯណេះ",  # confirm with Chuon Nath Dict
    "ហេយ៍​វ៉ិន": "ហេយ៍វ៉ិន",  # heaven
    "សុខ​ ​ពេញ​វុធ": "សុខ​ ​ពេញវុធ",
    "វ៉ុល​កា": "វ៉ុលកា",  # vulgar
    "ជា​ម​ ​ហុី​ម": "ជាម​ ​ហុីម",
    "​ការ​ប្រកាស​": "​ការប្រកាស​",
    "អនុ​ប្រធាន": "អនុប្រធាន",
    "កិច្ចខិតខំប្រឹងប្រែង": "កិច្ច​ខិតខំ​ប្រឹងប្រែង",  # ???
    "សស្អាត": "ស​ស្អាត",
    "ហាន់​ ​ជី​អ៊ុន": "ហាន់​ ​ជីអ៊ុន",
    "ស៊ុន​ ​ចាន់​ថុល": "ស៊ុន​ ​ចាន់ថុល",
    "លីន​ដា​": "លីនដា​",
    "យានយន្តបន្ទាប់ពី": "យានយន្ត​បន្ទាប់ពី",
    "ព្រៃ​ស្អាក​ស្រុក​អន្លង់​វែង": "ព្រៃស្អាក​ស្រុក​អន្លង់វែង",
    "​ប៉ា​កុង​": "​ប៉ាកុង​",  # first 50 articles
    "ឈើ​ ​អុស​ក្រាក់": "ឈើ​ ​អុសក្រាក់",
    "រតនៈ​គីរី​": "រតនៈគីរី​",
    "ឯក​ឧត្តម": "ឯកឧត្តម",
    "ឱម​ ​យិន​ទៀង": "ឱម​ ​យិនទៀង",
    "​ចំដែនដី​": "​ចំ​ដែនដី​",  # orig has space after រៀប
    "ឱវា​ទ": "ឱវាទ",  # correct spelling
    "អ៊ិន​វេស​មិន": "អ៊ិនវេសមិន",  # investment
    "សហគម​ន៏": "សហគមន៏",
    # orig has bad ub: mispelled but should be removed before seg
    "​គ្រូ​សារ​": "​គ្រូសារ​",
    "សុផុនពេល​សួរ": "សុផុន​ពេល​សួរ",
    "ស្រុក​កែវ​សីម៉ា": "ស្រុក​កែវសីម៉ា",
    "ហាន់​ជ័យ": "ហាន់ជ័យ",
    "បូរី​ ​ស​ចនសុន": "បូរីស​ ​ចនសុន",
    "បូរី​ ​ស​ចន​សុន": "បូរីស​ ​ចនសុន",
    "បូរីស​ ​ចន​សុន": "បូរីស​ ​ចនសុន",
    "អំណ​រ​គុណ": "អំណរ​គុណ",  # bad orig
    "ផលប៉ះពាល់​": "ផល​ប៉ះពាល់​",  # ???
    "អ្នកវិនិយោគ​": "អ្នក​វិនិយោគ​",  # ???
    "ភូមិ​ ​ស្រះ​ជ្រៃ​": "ភូមិ​ ​ស្រះជ្រៃ​",
    "ឃុំ​ ​បន្ទាយ​ឆ្មា​": "ឃុំ​ ​បន្ទាយឆ្មា​",
    "ស្រុក​ ​ថ្ម​ពួក​": "ស្រុក​ ​ថ្មពួក​",
    "ទ្វីត​ធឺ": "ទ្វីតធឺ",  # twitter
    "​ធំ​ដុំ": "​ធំដុំ",
    "​រួមមាន​": "​រួម​មាន​",  # ?
    "គុយ​វ៉ែត": "គុយវ៉ែត",
    "ងងុយគេង": "ងងុយ​គេង",
    "ស​ម​ ​រង្ស៊ី": "សម​ ​រង្ស៊ី",
    "សោ​ ​ចាន់​ដេត": "សោ​ ​ចាន់ដេត",
    "ជាលាយលក្ខណ៍អក្សរ": "ជា​លាយលក្ខណ៍​អក្សរ",
    "ផលិតកម្មវិធី": "ផលិតកម្ម​វិធី",
    "​សាជាថ្មី​": "​សា​ជា​ថ្មី​",  # ???
    "ឧកញ៉ា​ស្រី​ ​ចាន់​ថន": "ឧកញ៉ា​ ​ស្រី​ ​ចាន់ថន",
    "ភូមិ​ ​ព្រៃ​ល្វា": "ភូមិ​ ​ព្រៃល្វា",
    "សង្កាត់​ ​ចោម​ចៅ ": "សង្កាត់​ ​ចោមចៅ",
    "ខណ្ឌ​ ​ពោធិ៍​សែន": "ខណ្ឌ​ ​ពោធិ៍សែន",
    "ឃុំ​ ​ព្រែក​តា​មាក់": "ឃុំ​ ​ព្រែកតាមាក់",
    "​បាត់បង្ក": "​បាត់​បង្ក",
    "កើតមានឡើង": "កើត​មាន​ឡើង",
    "លូក​លាន់": "លូកលាន់",
    "លោក​ ​ជិន​ ​ម៉ាលី​ន": "លោក​ ​ជិន​ ​ម៉ាលីន",
    "អ្នករាយការណ៍": "អ្នក​រាយការណ៍",
    "គង់​ ​រ៉ៃ​យ៉ា": "គង់​ ​រ៉ៃយ៉ា",
    "លោក​ ​សួង​ ​នាគ​ព័ន្ធ": "លោក​ ​សួង​ ​នាគព័ន្ធ",
    "ធ្វើទុក្ខបុកម្នេញ": "ធ្វើ​ទុក្ខបុកម្នេញ",  # doc 75 mark
    "បោះបង់ចោល": "បោះបង់​ចោល",
    "ខ្លួនឯង": "ខ្លួន​ឯង",  # ???
    "សប្បាយចិត្ត": "សប្បាយ​ចិត្ត",
    "មើលទៅ": "មើល​ទៅ",  # ??? if
    "សោយសុខ": "សោយ​សុខ",
    "ទៅលើ": "ទៅ​លើ",
    "ឃុំខ្លួន": "ឃុំ​ខ្លួន",
    "ជាប់ឃុំ": "ជាប់​ឃុំ",
    "លោក​ ​ហេង​ ​ដូន​នី": "លោក​ ​ហេង​ ​ដូននី",
    "លោក​ ​កែម​ ​គិម​ស្រន់": "លោក​ ​កែម​ ​គិមស្រន់",
    "ស្រុក​ ​វាល​វែង": "ស្រុក​ ​វាលវែង",
    "ចោទប្រកាន់តែ": "ចោទប្រកាន់​តែ",  # doc 80 mark
    "ឈិញ​ ​ស៊ី​ថា": "ឈិញ​ ​ស៊ីថា",
    "ដាក់ពាក្យបណ្តឹង": "ដាក់​ពាក្យ​បណ្តឹង",
    "ម៉ាក​ ​ណូ​គា": "ម៉ាក​ ​ណូគា",
    "ធូ​ ​ស្រី​ទូច": "ធូ​ ​ស្រីទូច",
    "ម៉ូតូកង់​បី": "ម៉ូតូ​កង់​បី",
    "ឃុំ មង់​រៀវ": "ឃុំ មង់រៀវ",
    "លោក​ ​ជា​ ​ចាន់​តូ": "លោក​ ​ជា​ ​ចាន់តូ",
    "ស៊ែ​ស្វី​ច": "ស៊ែ​ស្វីច",  # shared switch
    "ប្រតិបត្តិការផ្ទេរ": "ប្រតិបត្តិការ​ផ្ទេរ",
    "បញ្ជាការស្រាល": "បញ្ជាការ​ស្រាល",
    "F​-​16": "F-16",
    "C​-​17": "C-17",
    "គោលនយោបាយ": "គោល​នយោបាយ",  # id 90 mark
    "ហាន​ ​សុខ​ន": "ហាន​ ​សុខន",
    "ខៀវ​ ​ទេ​ព": "ខៀវ​ ​ទេព",
    "កាញារី​ទ្ធ": "កាញារីទ្ធ",
    "ជី​ហែ": "ជីហែ",  # ផ្សារជីហែ
    "វិទ្យាល័យ​ ​ជី​ហែរ": "វិទ្យាល័យ​ ​ជីហែរ",
    "ស្រុកោះ​កោះ​សូទិន": "ស្រុកោះ​កោះសូទិន",
    "ជំរុញឲ្យ": "ជំរុញ​ឲ្យ",
    "ការបាក់ទឹកចិត្ត": "ការបាក់​ទឹកចិត្ត",
    "ហង់ ជួន​ណារីតា": "ហង់ ជួនណារីតា",
    "ជាទីមោទនៈ": "ជា​ទី​មោទនៈ",
    "សឿ សុជា​តា": "សឿ សុជាតា",
    "ហង់​ ​ជួន​ណារ៉ុន": "ហង់​ ​ជួនណារ៉ុន",
    "ក​សាង​ធនធាន": "កសាង​ធនធាន",
    "ស្នង​ឬ​ស្សី": "ស្នង​ឬស្សី",
    "ខៀវ​ ​កាញារី​ទ្ធ": "ខៀវ​ ​កាញារីទ្ធ",
    "ត្រេន​ ​ដី​ង": "ត្រេនដីង",  # trending
    "ទៅវិញទៅមក": "ទៅ​វិញ​ទៅ​មក",  # ??
    "ក្ដី​ស្រមៃ": "ក្ដីស្រមៃ",  # prob mispell jerg da
    "ឬ​ស្សីកែវ": "ឬស្សីកែវ",
    "អេង​ ​សុវណ្ណ​តារា": "អេង​ ​សុវណ្ណតារា",
    "កុង​ទីន​រ័": "កុងទីនរ័",
    "ជាបន្តបន្ទាប់": "ជា​បន្តបន្ទាប់",
    "ចលត័ជាប្រចាំ": "ចលត័​ជា​ប្រចាំ",
    "ឃុំ​ដី​ឥដ្ឋ": "ឃុំ​ដីឥដ្ឋ",
    "វី​ដែ​អូ": "វីដែអូ",  # misspell វីដេអូ
    "ត្រី​ខ​": "ត្រីខ​",
    "ទឹក​ត្រី​": "ទឹកត្រី​",
    "បង្ខំឲ្យ": "បង្ខំ​ឲ្យ",  # first hundred docs
    "ស្ដុក\u200bប្រវឹក": "ស្ដុកប្រវឹក",
    "វាល\u200bរិញ\u200b": "វាលរិញ\u200b",
    "ណៃ\u200b \u200bវង្ស\u200bដា": "ណៃ\u200b \u200bវង្សដា",
    "លោក\u200b \u200bឃ\u200bន \u200bជឺ ": "លោក\u200b \u200bឃន\u200b \u200bជឺ ",
    "បុត\u200b \u200bចាន់\u200bណា": "បុត\u200b \u200bចាន់ណា",
    "ឯ\u200bម\u200b \u200bច័ន្ទ\u200bមក\u200bរា": "ឯម\u200b \u200bច័ន្ទមករា",
    "សង់\u200bដ្រី\u200bន\u200b \u200bឌុយ\u200bរី": "សង់ដ្រីន\u200b \u200bឌុយរី",
    "សុខ\u200b \u200bពេញ\u200bវុធ": "សុខ\u200b \u200bពេញវុធ",
    "សោម \u200bពុទ្ធ\u200bតារា": "សោម \u200bពុទ្ធតារា",
    "ម៉ៅ\u200b ច័ន្ទ\u200bមធុរិទ្ធ": "ម៉ៅ\u200b ច័ន្ទមធុរិទ្ធ",
    "បូពិន្ទ\u200b ណា\u200bរ័ត្ន": "បូពិន្ទ\u200b ណារ័ត្ន",
    "ជា\u200b \u200bប៊ុន\u200bហេង": "ជា\u200b \u200bប៊ុនហេង",
    "ណារិក\u200bដ្រា\u200b \u200bមូឌី": "ណារិកដ្រា\u200b \u200bមូឌី",
    "ស្រុក\u200bព្រៃ\u200bនប់": "ស្រុក\u200bព្រៃនប់",
    "ខណ្ឌ\u200bចំការ\u200bមន": "ខណ្ឌ\u200bចំការមន",
    "ខណ្ឌ\u200bពោធិ៍\u200bសែន\u200bជ័យ": "ខណ្ឌ\u200bពោធិ៍សែនជ័យ",
    "សង្កាត់\u200bទឹក\u200bល្អក់": "សង្កាត់\u200bទឹកល្អក់",
    "សង្កាត់\u200bផ្សារ\u200bថ្មី": "សង្កាត់\u200bផ្សារថ្មី",
    "សង្កាត់\u200bជ្រោយ\u200bចង្វារ": "សង្កាត់\u200bជ្រោយចង្វារ",
    "សង្កាត់\u200bវាល\u200bវង់": "សង្កាត់\u200bវាលវង់",
    "សង្កាត់\u200bកោះ\u200bដាច់": "សង្កាត់\u200bកោះដាច់",
    "សង្កាត់\u200bចាក់អង្រែ\u200bលើ": "សង្កាត់\u200bចាក់អង្រែលើ",
    "សង្កាត់\u200bទន្លេ\u200bបាសាក់": "សង្កាត់\u200bទន្លេបាសាក់",
    "ឃុំ\u200bត្រពាំង\u200bជោ": "ឃុំ\u200bត្រពាំងជោ",
    "ឃុំ\u200bក្រាំង\u200bល្វា": "ឃុំ\u200bក្រាំងល្វា",
    "ឃុំ\u200bដូន\u200bសរ": "ឃុំ\u200bដូនសរ",
    "ឃុំ\u200bអូរ\u200bតាប៉ោង": "ឃុំ\u200bអូរតាប៉ោង",
    "ឃុំ\u200bក្បាល\u200bដំរី": "ឃុំ\u200bក្បាលដំរី",
    "ឃុំ\u200bត្រពាំង\u200bគង": "ឃុំត្រពាំងគង",
    "ភូមិ\u200bច្រក\u200bទៀក": "ភូមិ\u200bច្រកទៀក",
    "ភូមិ\u200bខ្សាច់\u200bស": "ភូមិ\u200bខ្សាច់ស",
    "ភូមិ\u200bអូរ\u200bត្រូន": "ភូមិ\u200bអូរត្រូន",
    "ភូមិ\u200bថ្ម\u200bធំ": "ភូមិ\u200bថ្មធំ",
    "ភូមិ\u200bចំការ\u200bដូង": "ភូមិ\u200bចំការដូង",
    "ភូមិ\u200bព្រៃ\u200bផ្តៅ": "ភូមិ\u200bព្រៃផ្តៅ",
    "ភូមិ\u200bបឹង\u200bវែង": "ភូមិ\u200bបឹងវែង",
    "\u200b \u200b.\u200b \u200bcom\u200b": ".com\u200b",
    "ចូ\u200b \u200bបាយ\u200bដិន": "ចូ\u200b \u200bបាយដិន",
    "\u200bណាន់\u200bស៊ី\u200b": "\u200bណាន់ស៊ី\u200b",
    "លោក\u200bត្រាំតទៅទៀត": "លោក\u200bត្រាំ\u200bតទៅទៀត",
}
