from dataclasses import dataclass
from datetime import datetime
from typing import ClassVar, Union

from buz.event.transactional_outbox import OutboxSortingCriteria


@dataclass(frozen=True)
class OutboxCriteria:
    UNSET_VALUE: ClassVar[object] = object()

    delivered_at: Union[datetime, None, object] = UNSET_VALUE
    delivered_at_previous_to: Union[datetime, object] = UNSET_VALUE
    order_by: Union[OutboxSortingCriteria, None, object] = UNSET_VALUE
