# MIT License
# 
# Copyright (c) 2019 Edward D. Lee, Bryan C. Daniels
# 
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
# 
# The above copyright notice and this permission notice shall be included in all
# copies or substantial portions of the Software.
# 
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
# SOFTWARE.

# Equations for 12-spin Ising model.

# Written on 2019/04/17.
from numpy import zeros, array, prod
from ..enumerate import mp_fast_logsumexp as fast_logsumexp
from mpmath import exp, isnan

def calc_observables(params):
    """
    Give all parameters concatenated into one array from lowest to highest order.
    Returns all correlations.
    """
    Cout = zeros((78), dtype=object)
    H = params[0:12]
    J = params[12:78]
    energyTerms = array([    +H[0]+H[1]+H[2]+H[3]+H[4]+H[5]+H[6]+H[7]+H[8]+H[9]+H[10]+H[11]+J[0]+J[1]+J[2]+J[3]+J[4]+J[5]+J[6]+J[7]+
    J[8]+J[9]+J[10]+J[11]+J[12]+J[13]+J[14]+J[15]+J[16]+J[17]+J[18]+J[19]+J[20]+J[21]+J[22]+J[23]+J[24]+
    J[25]+J[26]+J[27]+J[28]+J[29]+J[30]+J[31]+J[32]+J[33]+J[34]+J[35]+J[36]+J[37]+J[38]+J[39]+J[40]+J[41]+
    J[42]+J[43]+J[44]+J[45]+J[46]+J[47]+J[48]+J[49]+J[50]+J[51]+J[52]+J[53]+J[54]+J[55]+J[56]+J[57]+J[58]+
    J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]+H[1]+H[2]+H[3]+H[4]+H[5]+H[6]+H[7]+H[8]+H[9]+H[10]-H[11]+
    J[0]+J[1]+J[2]+J[3]+J[4]+J[5]+J[6]+J[7]+J[8]+J[9]-J[10]+J[11]+J[12]+J[13]+J[14]+J[15]+J[16]+J[17]+J[18]+
    J[19]-J[20]+J[21]+J[22]+J[23]+J[24]+J[25]+J[26]+J[27]+J[28]-J[29]+J[30]+J[31]+J[32]+J[33]+J[34]+J[35]+
    J[36]-J[37]+J[38]+J[39]+J[40]+J[41]+J[42]+J[43]-J[44]+J[45]+J[46]+J[47]+J[48]+J[49]-J[50]+J[51]+J[52]+
    J[53]+J[54]-J[55]+J[56]+J[57]+J[58]-J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]+H[1]+H[2]+H[3]+
    H[4]+H[5]+H[6]+H[7]+H[8]+H[9]-H[10]+H[11]+J[0]+J[1]+J[2]+J[3]+J[4]+J[5]+J[6]+J[7]+J[8]-J[9]+J[10]+J[11]+
    J[12]+J[13]+J[14]+J[15]+J[16]+J[17]+J[18]-J[19]+J[20]+J[21]+J[22]+J[23]+J[24]+J[25]+J[26]+J[27]-J[28]+
    J[29]+J[30]+J[31]+J[32]+J[33]+J[34]+J[35]-J[36]+J[37]+J[38]+J[39]+J[40]+J[41]+J[42]-J[43]+J[44]+J[45]+
    J[46]+J[47]+J[48]-J[49]+J[50]+J[51]+J[52]+J[53]-J[54]+J[55]+J[56]+J[57]-J[58]+J[59]+J[60]-J[61]+J[62]-J[63]+
    J[64]-J[65], +H[0]+H[1]+H[2]+H[3]+H[4]+H[5]+H[6]+H[7]+H[8]+H[9]-H[10]-H[11]+J[0]+J[1]+J[2]+J[3]+J[4]+
    J[5]+J[6]+J[7]+J[8]-J[9]-J[10]+J[11]+J[12]+J[13]+J[14]+J[15]+J[16]+J[17]+J[18]-J[19]-J[20]+J[21]+J[22]+
    J[23]+J[24]+J[25]+J[26]+J[27]-J[28]-J[29]+J[30]+J[31]+J[32]+J[33]+J[34]+J[35]-J[36]-J[37]+J[38]+J[39]+
    J[40]+J[41]+J[42]-J[43]-J[44]+J[45]+J[46]+J[47]+J[48]-J[49]-J[50]+J[51]+J[52]+J[53]-J[54]-J[55]+J[56]+
    J[57]-J[58]-J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]+H[1]+H[2]+H[3]+H[4]+H[5]+H[6]+H[7]+H[8]-H[9]+
    H[10]+H[11]+J[0]+J[1]+J[2]+J[3]+J[4]+J[5]+J[6]+J[7]-J[8]+J[9]+J[10]+J[11]+J[12]+J[13]+J[14]+J[15]+J[16]+
    J[17]-J[18]+J[19]+J[20]+J[21]+J[22]+J[23]+J[24]+J[25]+J[26]-J[27]+J[28]+J[29]+J[30]+J[31]+J[32]+J[33]+
    J[34]-J[35]+J[36]+J[37]+J[38]+J[39]+J[40]+J[41]-J[42]+J[43]+J[44]+J[45]+J[46]+J[47]-J[48]+J[49]+J[50]+
    J[51]+J[52]-J[53]+J[54]+J[55]+J[56]-J[57]+J[58]+J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]+H[1]+
    H[2]+H[3]+H[4]+H[5]+H[6]+H[7]+H[8]-H[9]+H[10]-H[11]+J[0]+J[1]+J[2]+J[3]+J[4]+J[5]+J[6]+J[7]-J[8]+J[9]-J[10]+
    J[11]+J[12]+J[13]+J[14]+J[15]+J[16]+J[17]-J[18]+J[19]-J[20]+J[21]+J[22]+J[23]+J[24]+J[25]+J[26]-J[27]+
    J[28]-J[29]+J[30]+J[31]+J[32]+J[33]+J[34]-J[35]+J[36]-J[37]+J[38]+J[39]+J[40]+J[41]-J[42]+J[43]-J[44]+
    J[45]+J[46]+J[47]-J[48]+J[49]-J[50]+J[51]+J[52]-J[53]+J[54]-J[55]+J[56]-J[57]+J[58]-J[59]-J[60]+J[61]-J[62]-J[63]+
    J[64]-J[65], +H[0]+H[1]+H[2]+H[3]+H[4]+H[5]+H[6]+H[7]+H[8]-H[9]-H[10]+H[11]+J[0]+J[1]+J[2]+J[3]+J[4]+
    J[5]+J[6]+J[7]-J[8]-J[9]+J[10]+J[11]+J[12]+J[13]+J[14]+J[15]+J[16]+J[17]-J[18]-J[19]+J[20]+J[21]+J[22]+
    J[23]+J[24]+J[25]+J[26]-J[27]-J[28]+J[29]+J[30]+J[31]+J[32]+J[33]+J[34]-J[35]-J[36]+J[37]+J[38]+J[39]+
    J[40]+J[41]-J[42]-J[43]+J[44]+J[45]+J[46]+J[47]-J[48]-J[49]+J[50]+J[51]+J[52]-J[53]-J[54]+J[55]+J[56]-J[57]-J[58]+
    J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]+H[1]+H[2]+H[3]+H[4]+H[5]+H[6]+H[7]+H[8]-H[9]-H[10]-H[11]+
    J[0]+J[1]+J[2]+J[3]+J[4]+J[5]+J[6]+J[7]-J[8]-J[9]-J[10]+J[11]+J[12]+J[13]+J[14]+J[15]+J[16]+J[17]-J[18]-J[19]-J[20]+
    J[21]+J[22]+J[23]+J[24]+J[25]+J[26]-J[27]-J[28]-J[29]+J[30]+J[31]+J[32]+J[33]+J[34]-J[35]-J[36]-J[37]+
    J[38]+J[39]+J[40]+J[41]-J[42]-J[43]-J[44]+J[45]+J[46]+J[47]-J[48]-J[49]-J[50]+J[51]+J[52]-J[53]-J[54]-J[55]+
    J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]+H[1]+H[2]+H[3]+H[4]+H[5]+H[6]+H[7]-H[8]+
    H[9]+H[10]+H[11]+J[0]+J[1]+J[2]+J[3]+J[4]+J[5]+J[6]-J[7]+J[8]+J[9]+J[10]+J[11]+J[12]+J[13]+J[14]+J[15]+
    J[16]-J[17]+J[18]+J[19]+J[20]+J[21]+J[22]+J[23]+J[24]+J[25]-J[26]+J[27]+J[28]+J[29]+J[30]+J[31]+J[32]+
    J[33]-J[34]+J[35]+J[36]+J[37]+J[38]+J[39]+J[40]-J[41]+J[42]+J[43]+J[44]+J[45]+J[46]-J[47]+J[48]+J[49]+
    J[50]+J[51]-J[52]+J[53]+J[54]+J[55]-J[56]+J[57]+J[58]+J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]+
    H[1]+H[2]+H[3]+H[4]+H[5]+H[6]+H[7]-H[8]+H[9]+H[10]-H[11]+J[0]+J[1]+J[2]+J[3]+J[4]+J[5]+J[6]-J[7]+J[8]+
    J[9]-J[10]+J[11]+J[12]+J[13]+J[14]+J[15]+J[16]-J[17]+J[18]+J[19]-J[20]+J[21]+J[22]+J[23]+J[24]+J[25]-J[26]+
    J[27]+J[28]-J[29]+J[30]+J[31]+J[32]+J[33]-J[34]+J[35]+J[36]-J[37]+J[38]+J[39]+J[40]-J[41]+J[42]+J[43]-J[44]+
    J[45]+J[46]-J[47]+J[48]+J[49]-J[50]+J[51]-J[52]+J[53]+J[54]-J[55]-J[56]+J[57]+J[58]-J[59]-J[60]-J[61]+
    J[62]+J[63]-J[64]-J[65], +H[0]+H[1]+H[2]+H[3]+H[4]+H[5]+H[6]+H[7]-H[8]+H[9]-H[10]+H[11]+J[0]+J[1]+J[2]+
    J[3]+J[4]+J[5]+J[6]-J[7]+J[8]-J[9]+J[10]+J[11]+J[12]+J[13]+J[14]+J[15]+J[16]-J[17]+J[18]-J[19]+J[20]+
    J[21]+J[22]+J[23]+J[24]+J[25]-J[26]+J[27]-J[28]+J[29]+J[30]+J[31]+J[32]+J[33]-J[34]+J[35]-J[36]+J[37]+
    J[38]+J[39]+J[40]-J[41]+J[42]-J[43]+J[44]+J[45]+J[46]-J[47]+J[48]-J[49]+J[50]+J[51]-J[52]+J[53]-J[54]+
    J[55]-J[56]+J[57]-J[58]+J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]+H[1]+H[2]+H[3]+H[4]+H[5]+H[6]+
    H[7]-H[8]+H[9]-H[10]-H[11]+J[0]+J[1]+J[2]+J[3]+J[4]+J[5]+J[6]-J[7]+J[8]-J[9]-J[10]+J[11]+J[12]+J[13]+
    J[14]+J[15]+J[16]-J[17]+J[18]-J[19]-J[20]+J[21]+J[22]+J[23]+J[24]+J[25]-J[26]+J[27]-J[28]-J[29]+J[30]+
    J[31]+J[32]+J[33]-J[34]+J[35]-J[36]-J[37]+J[38]+J[39]+J[40]-J[41]+J[42]-J[43]-J[44]+J[45]+J[46]-J[47]+
    J[48]-J[49]-J[50]+J[51]-J[52]+J[53]-J[54]-J[55]-J[56]+J[57]-J[58]-J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+
    J[65], +H[0]+H[1]+H[2]+H[3]+H[4]+H[5]+H[6]+H[7]-H[8]-H[9]+H[10]+H[11]+J[0]+J[1]+J[2]+J[3]+J[4]+J[5]+
    J[6]-J[7]-J[8]+J[9]+J[10]+J[11]+J[12]+J[13]+J[14]+J[15]+J[16]-J[17]-J[18]+J[19]+J[20]+J[21]+J[22]+J[23]+
    J[24]+J[25]-J[26]-J[27]+J[28]+J[29]+J[30]+J[31]+J[32]+J[33]-J[34]-J[35]+J[36]+J[37]+J[38]+J[39]+J[40]-J[41]-J[42]+
    J[43]+J[44]+J[45]+J[46]-J[47]-J[48]+J[49]+J[50]+J[51]-J[52]-J[53]+J[54]+J[55]-J[56]-J[57]+J[58]+J[59]+
    J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]+H[1]+H[2]+H[3]+H[4]+H[5]+H[6]+H[7]-H[8]-H[9]+H[10]-H[11]+
    J[0]+J[1]+J[2]+J[3]+J[4]+J[5]+J[6]-J[7]-J[8]+J[9]-J[10]+J[11]+J[12]+J[13]+J[14]+J[15]+J[16]-J[17]-J[18]+
    J[19]-J[20]+J[21]+J[22]+J[23]+J[24]+J[25]-J[26]-J[27]+J[28]-J[29]+J[30]+J[31]+J[32]+J[33]-J[34]-J[35]+
    J[36]-J[37]+J[38]+J[39]+J[40]-J[41]-J[42]+J[43]-J[44]+J[45]+J[46]-J[47]-J[48]+J[49]-J[50]+J[51]-J[52]-J[53]+
    J[54]-J[55]-J[56]-J[57]+J[58]-J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]+H[1]+H[2]+H[3]+H[4]+H[5]+
    H[6]+H[7]-H[8]-H[9]-H[10]+H[11]+J[0]+J[1]+J[2]+J[3]+J[4]+J[5]+J[6]-J[7]-J[8]-J[9]+J[10]+J[11]+J[12]+
    J[13]+J[14]+J[15]+J[16]-J[17]-J[18]-J[19]+J[20]+J[21]+J[22]+J[23]+J[24]+J[25]-J[26]-J[27]-J[28]+J[29]+
    J[30]+J[31]+J[32]+J[33]-J[34]-J[35]-J[36]+J[37]+J[38]+J[39]+J[40]-J[41]-J[42]-J[43]+J[44]+J[45]+J[46]-J[47]-J[48]-J[49]+
    J[50]+J[51]-J[52]-J[53]-J[54]+J[55]-J[56]-J[57]-J[58]+J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]+
    H[1]+H[2]+H[3]+H[4]+H[5]+H[6]+H[7]-H[8]-H[9]-H[10]-H[11]+J[0]+J[1]+J[2]+J[3]+J[4]+J[5]+J[6]-J[7]-J[8]-J[9]-J[10]+
    J[11]+J[12]+J[13]+J[14]+J[15]+J[16]-J[17]-J[18]-J[19]-J[20]+J[21]+J[22]+J[23]+J[24]+J[25]-J[26]-J[27]-J[28]-J[29]+
    J[30]+J[31]+J[32]+J[33]-J[34]-J[35]-J[36]-J[37]+J[38]+J[39]+J[40]-J[41]-J[42]-J[43]-J[44]+J[45]+J[46]-J[47]-J[48]-J[49]-J[50]+
    J[51]-J[52]-J[53]-J[54]-J[55]-J[56]-J[57]-J[58]-J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]+H[1]+
    H[2]+H[3]+H[4]+H[5]+H[6]-H[7]+H[8]+H[9]+H[10]+H[11]+J[0]+J[1]+J[2]+J[3]+J[4]+J[5]-J[6]+J[7]+J[8]+J[9]+
    J[10]+J[11]+J[12]+J[13]+J[14]+J[15]-J[16]+J[17]+J[18]+J[19]+J[20]+J[21]+J[22]+J[23]+J[24]-J[25]+J[26]+
    J[27]+J[28]+J[29]+J[30]+J[31]+J[32]-J[33]+J[34]+J[35]+J[36]+J[37]+J[38]+J[39]-J[40]+J[41]+J[42]+J[43]+
    J[44]+J[45]-J[46]+J[47]+J[48]+J[49]+J[50]-J[51]+J[52]+J[53]+J[54]+J[55]-J[56]-J[57]-J[58]-J[59]+J[60]+
    J[61]+J[62]+J[63]+J[64]+J[65], +H[0]+H[1]+H[2]+H[3]+H[4]+H[5]+H[6]-H[7]+H[8]+H[9]+H[10]-H[11]+J[0]+J[1]+
    J[2]+J[3]+J[4]+J[5]-J[6]+J[7]+J[8]+J[9]-J[10]+J[11]+J[12]+J[13]+J[14]+J[15]-J[16]+J[17]+J[18]+J[19]-J[20]+
    J[21]+J[22]+J[23]+J[24]-J[25]+J[26]+J[27]+J[28]-J[29]+J[30]+J[31]+J[32]-J[33]+J[34]+J[35]+J[36]-J[37]+
    J[38]+J[39]-J[40]+J[41]+J[42]+J[43]-J[44]+J[45]-J[46]+J[47]+J[48]+J[49]-J[50]-J[51]+J[52]+J[53]+J[54]-J[55]-J[56]-J[57]-J[58]+
    J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]+H[1]+H[2]+H[3]+H[4]+H[5]+H[6]-H[7]+H[8]+H[9]-H[10]+
    H[11]+J[0]+J[1]+J[2]+J[3]+J[4]+J[5]-J[6]+J[7]+J[8]-J[9]+J[10]+J[11]+J[12]+J[13]+J[14]+J[15]-J[16]+J[17]+
    J[18]-J[19]+J[20]+J[21]+J[22]+J[23]+J[24]-J[25]+J[26]+J[27]-J[28]+J[29]+J[30]+J[31]+J[32]-J[33]+J[34]+
    J[35]-J[36]+J[37]+J[38]+J[39]-J[40]+J[41]+J[42]-J[43]+J[44]+J[45]-J[46]+J[47]+J[48]-J[49]+J[50]-J[51]+
    J[52]+J[53]-J[54]+J[55]-J[56]-J[57]+J[58]-J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]+H[1]+H[2]+
    H[3]+H[4]+H[5]+H[6]-H[7]+H[8]+H[9]-H[10]-H[11]+J[0]+J[1]+J[2]+J[3]+J[4]+J[5]-J[6]+J[7]+J[8]-J[9]-J[10]+
    J[11]+J[12]+J[13]+J[14]+J[15]-J[16]+J[17]+J[18]-J[19]-J[20]+J[21]+J[22]+J[23]+J[24]-J[25]+J[26]+J[27]-J[28]-J[29]+
    J[30]+J[31]+J[32]-J[33]+J[34]+J[35]-J[36]-J[37]+J[38]+J[39]-J[40]+J[41]+J[42]-J[43]-J[44]+J[45]-J[46]+
    J[47]+J[48]-J[49]-J[50]-J[51]+J[52]+J[53]-J[54]-J[55]-J[56]-J[57]+J[58]+J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+
    J[65], +H[0]+H[1]+H[2]+H[3]+H[4]+H[5]+H[6]-H[7]+H[8]-H[9]+H[10]+H[11]+J[0]+J[1]+J[2]+J[3]+J[4]+J[5]-J[6]+
    J[7]-J[8]+J[9]+J[10]+J[11]+J[12]+J[13]+J[14]+J[15]-J[16]+J[17]-J[18]+J[19]+J[20]+J[21]+J[22]+J[23]+J[24]-J[25]+
    J[26]-J[27]+J[28]+J[29]+J[30]+J[31]+J[32]-J[33]+J[34]-J[35]+J[36]+J[37]+J[38]+J[39]-J[40]+J[41]-J[42]+
    J[43]+J[44]+J[45]-J[46]+J[47]-J[48]+J[49]+J[50]-J[51]+J[52]-J[53]+J[54]+J[55]-J[56]+J[57]-J[58]-J[59]-J[60]+
    J[61]+J[62]-J[63]-J[64]+J[65], +H[0]+H[1]+H[2]+H[3]+H[4]+H[5]+H[6]-H[7]+H[8]-H[9]+H[10]-H[11]+J[0]+J[1]+
    J[2]+J[3]+J[4]+J[5]-J[6]+J[7]-J[8]+J[9]-J[10]+J[11]+J[12]+J[13]+J[14]+J[15]-J[16]+J[17]-J[18]+J[19]-J[20]+
    J[21]+J[22]+J[23]+J[24]-J[25]+J[26]-J[27]+J[28]-J[29]+J[30]+J[31]+J[32]-J[33]+J[34]-J[35]+J[36]-J[37]+
    J[38]+J[39]-J[40]+J[41]-J[42]+J[43]-J[44]+J[45]-J[46]+J[47]-J[48]+J[49]-J[50]-J[51]+J[52]-J[53]+J[54]-J[55]-J[56]+
    J[57]-J[58]+J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]+H[1]+H[2]+H[3]+H[4]+H[5]+H[6]-H[7]+H[8]-H[9]-H[10]+
    H[11]+J[0]+J[1]+J[2]+J[3]+J[4]+J[5]-J[6]+J[7]-J[8]-J[9]+J[10]+J[11]+J[12]+J[13]+J[14]+J[15]-J[16]+J[17]-J[18]-J[19]+
    J[20]+J[21]+J[22]+J[23]+J[24]-J[25]+J[26]-J[27]-J[28]+J[29]+J[30]+J[31]+J[32]-J[33]+J[34]-J[35]-J[36]+
    J[37]+J[38]+J[39]-J[40]+J[41]-J[42]-J[43]+J[44]+J[45]-J[46]+J[47]-J[48]-J[49]+J[50]-J[51]+J[52]-J[53]-J[54]+
    J[55]-J[56]+J[57]+J[58]-J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]+H[1]+H[2]+H[3]+H[4]+H[5]+H[6]-H[7]+
    H[8]-H[9]-H[10]-H[11]+J[0]+J[1]+J[2]+J[3]+J[4]+J[5]-J[6]+J[7]-J[8]-J[9]-J[10]+J[11]+J[12]+J[13]+J[14]+
    J[15]-J[16]+J[17]-J[18]-J[19]-J[20]+J[21]+J[22]+J[23]+J[24]-J[25]+J[26]-J[27]-J[28]-J[29]+J[30]+J[31]+
    J[32]-J[33]+J[34]-J[35]-J[36]-J[37]+J[38]+J[39]-J[40]+J[41]-J[42]-J[43]-J[44]+J[45]-J[46]+J[47]-J[48]-J[49]-J[50]-J[51]+
    J[52]-J[53]-J[54]-J[55]-J[56]+J[57]+J[58]+J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]+H[1]+H[2]+
    H[3]+H[4]+H[5]+H[6]-H[7]-H[8]+H[9]+H[10]+H[11]+J[0]+J[1]+J[2]+J[3]+J[4]+J[5]-J[6]-J[7]+J[8]+J[9]+J[10]+
    J[11]+J[12]+J[13]+J[14]+J[15]-J[16]-J[17]+J[18]+J[19]+J[20]+J[21]+J[22]+J[23]+J[24]-J[25]-J[26]+J[27]+
    J[28]+J[29]+J[30]+J[31]+J[32]-J[33]-J[34]+J[35]+J[36]+J[37]+J[38]+J[39]-J[40]-J[41]+J[42]+J[43]+J[44]+
    J[45]-J[46]-J[47]+J[48]+J[49]+J[50]-J[51]-J[52]+J[53]+J[54]+J[55]+J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+
    J[63]+J[64]+J[65], +H[0]+H[1]+H[2]+H[3]+H[4]+H[5]+H[6]-H[7]-H[8]+H[9]+H[10]-H[11]+J[0]+J[1]+J[2]+J[3]+
    J[4]+J[5]-J[6]-J[7]+J[8]+J[9]-J[10]+J[11]+J[12]+J[13]+J[14]+J[15]-J[16]-J[17]+J[18]+J[19]-J[20]+J[21]+
    J[22]+J[23]+J[24]-J[25]-J[26]+J[27]+J[28]-J[29]+J[30]+J[31]+J[32]-J[33]-J[34]+J[35]+J[36]-J[37]+J[38]+
    J[39]-J[40]-J[41]+J[42]+J[43]-J[44]+J[45]-J[46]-J[47]+J[48]+J[49]-J[50]-J[51]-J[52]+J[53]+J[54]-J[55]+
    J[56]-J[57]-J[58]+J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]+H[1]+H[2]+H[3]+H[4]+H[5]+H[6]-H[7]-H[8]+
    H[9]-H[10]+H[11]+J[0]+J[1]+J[2]+J[3]+J[4]+J[5]-J[6]-J[7]+J[8]-J[9]+J[10]+J[11]+J[12]+J[13]+J[14]+J[15]-J[16]-J[17]+
    J[18]-J[19]+J[20]+J[21]+J[22]+J[23]+J[24]-J[25]-J[26]+J[27]-J[28]+J[29]+J[30]+J[31]+J[32]-J[33]-J[34]+
    J[35]-J[36]+J[37]+J[38]+J[39]-J[40]-J[41]+J[42]-J[43]+J[44]+J[45]-J[46]-J[47]+J[48]-J[49]+J[50]-J[51]-J[52]+
    J[53]-J[54]+J[55]+J[56]-J[57]+J[58]-J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]+H[1]+H[2]+H[3]+
    H[4]+H[5]+H[6]-H[7]-H[8]+H[9]-H[10]-H[11]+J[0]+J[1]+J[2]+J[3]+J[4]+J[5]-J[6]-J[7]+J[8]-J[9]-J[10]+J[11]+
    J[12]+J[13]+J[14]+J[15]-J[16]-J[17]+J[18]-J[19]-J[20]+J[21]+J[22]+J[23]+J[24]-J[25]-J[26]+J[27]-J[28]-J[29]+
    J[30]+J[31]+J[32]-J[33]-J[34]+J[35]-J[36]-J[37]+J[38]+J[39]-J[40]-J[41]+J[42]-J[43]-J[44]+J[45]-J[46]-J[47]+
    J[48]-J[49]-J[50]-J[51]-J[52]+J[53]-J[54]-J[55]+J[56]-J[57]+J[58]+J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+
    J[65], +H[0]+H[1]+H[2]+H[3]+H[4]+H[5]+H[6]-H[7]-H[8]-H[9]+H[10]+H[11]+J[0]+J[1]+J[2]+J[3]+J[4]+J[5]-J[6]-J[7]-J[8]+
    J[9]+J[10]+J[11]+J[12]+J[13]+J[14]+J[15]-J[16]-J[17]-J[18]+J[19]+J[20]+J[21]+J[22]+J[23]+J[24]-J[25]-J[26]-J[27]+
    J[28]+J[29]+J[30]+J[31]+J[32]-J[33]-J[34]-J[35]+J[36]+J[37]+J[38]+J[39]-J[40]-J[41]-J[42]+J[43]+J[44]+
    J[45]-J[46]-J[47]-J[48]+J[49]+J[50]-J[51]-J[52]-J[53]+J[54]+J[55]+J[56]+J[57]-J[58]-J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+
    J[65], +H[0]+H[1]+H[2]+H[3]+H[4]+H[5]+H[6]-H[7]-H[8]-H[9]+H[10]-H[11]+J[0]+J[1]+J[2]+J[3]+J[4]+J[5]-J[6]-J[7]-J[8]+
    J[9]-J[10]+J[11]+J[12]+J[13]+J[14]+J[15]-J[16]-J[17]-J[18]+J[19]-J[20]+J[21]+J[22]+J[23]+J[24]-J[25]-J[26]-J[27]+
    J[28]-J[29]+J[30]+J[31]+J[32]-J[33]-J[34]-J[35]+J[36]-J[37]+J[38]+J[39]-J[40]-J[41]-J[42]+J[43]-J[44]+
    J[45]-J[46]-J[47]-J[48]+J[49]-J[50]-J[51]-J[52]-J[53]+J[54]-J[55]+J[56]+J[57]-J[58]+J[59]+J[60]-J[61]+
    J[62]-J[63]+J[64]-J[65], +H[0]+H[1]+H[2]+H[3]+H[4]+H[5]+H[6]-H[7]-H[8]-H[9]-H[10]+H[11]+J[0]+J[1]+J[2]+
    J[3]+J[4]+J[5]-J[6]-J[7]-J[8]-J[9]+J[10]+J[11]+J[12]+J[13]+J[14]+J[15]-J[16]-J[17]-J[18]-J[19]+J[20]+
    J[21]+J[22]+J[23]+J[24]-J[25]-J[26]-J[27]-J[28]+J[29]+J[30]+J[31]+J[32]-J[33]-J[34]-J[35]-J[36]+J[37]+
    J[38]+J[39]-J[40]-J[41]-J[42]-J[43]+J[44]+J[45]-J[46]-J[47]-J[48]-J[49]+J[50]-J[51]-J[52]-J[53]-J[54]+
    J[55]+J[56]+J[57]+J[58]-J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]+H[1]+H[2]+H[3]+H[4]+H[5]+H[6]-H[7]-H[8]-H[9]-H[10]-H[11]+
    J[0]+J[1]+J[2]+J[3]+J[4]+J[5]-J[6]-J[7]-J[8]-J[9]-J[10]+J[11]+J[12]+J[13]+J[14]+J[15]-J[16]-J[17]-J[18]-J[19]-J[20]+
    J[21]+J[22]+J[23]+J[24]-J[25]-J[26]-J[27]-J[28]-J[29]+J[30]+J[31]+J[32]-J[33]-J[34]-J[35]-J[36]-J[37]+
    J[38]+J[39]-J[40]-J[41]-J[42]-J[43]-J[44]+J[45]-J[46]-J[47]-J[48]-J[49]-J[50]-J[51]-J[52]-J[53]-J[54]-J[55]+
    J[56]+J[57]+J[58]+J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]+H[1]+H[2]+H[3]+H[4]+H[5]-H[6]+H[7]+
    H[8]+H[9]+H[10]+H[11]+J[0]+J[1]+J[2]+J[3]+J[4]-J[5]+J[6]+J[7]+J[8]+J[9]+J[10]+J[11]+J[12]+J[13]+J[14]-J[15]+
    J[16]+J[17]+J[18]+J[19]+J[20]+J[21]+J[22]+J[23]-J[24]+J[25]+J[26]+J[27]+J[28]+J[29]+J[30]+J[31]-J[32]+
    J[33]+J[34]+J[35]+J[36]+J[37]+J[38]-J[39]+J[40]+J[41]+J[42]+J[43]+J[44]-J[45]+J[46]+J[47]+J[48]+J[49]+
    J[50]-J[51]-J[52]-J[53]-J[54]-J[55]+J[56]+J[57]+J[58]+J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]+
    H[1]+H[2]+H[3]+H[4]+H[5]-H[6]+H[7]+H[8]+H[9]+H[10]-H[11]+J[0]+J[1]+J[2]+J[3]+J[4]-J[5]+J[6]+J[7]+J[8]+
    J[9]-J[10]+J[11]+J[12]+J[13]+J[14]-J[15]+J[16]+J[17]+J[18]+J[19]-J[20]+J[21]+J[22]+J[23]-J[24]+J[25]+
    J[26]+J[27]+J[28]-J[29]+J[30]+J[31]-J[32]+J[33]+J[34]+J[35]+J[36]-J[37]+J[38]-J[39]+J[40]+J[41]+J[42]+
    J[43]-J[44]-J[45]+J[46]+J[47]+J[48]+J[49]-J[50]-J[51]-J[52]-J[53]-J[54]+J[55]+J[56]+J[57]+J[58]-J[59]+
    J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]+H[1]+H[2]+H[3]+H[4]+H[5]-H[6]+H[7]+H[8]+H[9]-H[10]+H[11]+
    J[0]+J[1]+J[2]+J[3]+J[4]-J[5]+J[6]+J[7]+J[8]-J[9]+J[10]+J[11]+J[12]+J[13]+J[14]-J[15]+J[16]+J[17]+J[18]-J[19]+
    J[20]+J[21]+J[22]+J[23]-J[24]+J[25]+J[26]+J[27]-J[28]+J[29]+J[30]+J[31]-J[32]+J[33]+J[34]+J[35]-J[36]+
    J[37]+J[38]-J[39]+J[40]+J[41]+J[42]-J[43]+J[44]-J[45]+J[46]+J[47]+J[48]-J[49]+J[50]-J[51]-J[52]-J[53]+
    J[54]-J[55]+J[56]+J[57]-J[58]+J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]+H[1]+H[2]+H[3]+H[4]+H[5]-H[6]+
    H[7]+H[8]+H[9]-H[10]-H[11]+J[0]+J[1]+J[2]+J[3]+J[4]-J[5]+J[6]+J[7]+J[8]-J[9]-J[10]+J[11]+J[12]+J[13]+
    J[14]-J[15]+J[16]+J[17]+J[18]-J[19]-J[20]+J[21]+J[22]+J[23]-J[24]+J[25]+J[26]+J[27]-J[28]-J[29]+J[30]+
    J[31]-J[32]+J[33]+J[34]+J[35]-J[36]-J[37]+J[38]-J[39]+J[40]+J[41]+J[42]-J[43]-J[44]-J[45]+J[46]+J[47]+
    J[48]-J[49]-J[50]-J[51]-J[52]-J[53]+J[54]+J[55]+J[56]+J[57]-J[58]-J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+
    J[65], +H[0]+H[1]+H[2]+H[3]+H[4]+H[5]-H[6]+H[7]+H[8]-H[9]+H[10]+H[11]+J[0]+J[1]+J[2]+J[3]+J[4]-J[5]+
    J[6]+J[7]-J[8]+J[9]+J[10]+J[11]+J[12]+J[13]+J[14]-J[15]+J[16]+J[17]-J[18]+J[19]+J[20]+J[21]+J[22]+J[23]-J[24]+
    J[25]+J[26]-J[27]+J[28]+J[29]+J[30]+J[31]-J[32]+J[33]+J[34]-J[35]+J[36]+J[37]+J[38]-J[39]+J[40]+J[41]-J[42]+
    J[43]+J[44]-J[45]+J[46]+J[47]-J[48]+J[49]+J[50]-J[51]-J[52]+J[53]-J[54]-J[55]+J[56]-J[57]+J[58]+J[59]-J[60]+
    J[61]+J[62]-J[63]-J[64]+J[65], +H[0]+H[1]+H[2]+H[3]+H[4]+H[5]-H[6]+H[7]+H[8]-H[9]+H[10]-H[11]+J[0]+J[1]+
    J[2]+J[3]+J[4]-J[5]+J[6]+J[7]-J[8]+J[9]-J[10]+J[11]+J[12]+J[13]+J[14]-J[15]+J[16]+J[17]-J[18]+J[19]-J[20]+
    J[21]+J[22]+J[23]-J[24]+J[25]+J[26]-J[27]+J[28]-J[29]+J[30]+J[31]-J[32]+J[33]+J[34]-J[35]+J[36]-J[37]+
    J[38]-J[39]+J[40]+J[41]-J[42]+J[43]-J[44]-J[45]+J[46]+J[47]-J[48]+J[49]-J[50]-J[51]-J[52]+J[53]-J[54]+
    J[55]+J[56]-J[57]+J[58]-J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]+H[1]+H[2]+H[3]+H[4]+H[5]-H[6]+
    H[7]+H[8]-H[9]-H[10]+H[11]+J[0]+J[1]+J[2]+J[3]+J[4]-J[5]+J[6]+J[7]-J[8]-J[9]+J[10]+J[11]+J[12]+J[13]+
    J[14]-J[15]+J[16]+J[17]-J[18]-J[19]+J[20]+J[21]+J[22]+J[23]-J[24]+J[25]+J[26]-J[27]-J[28]+J[29]+J[30]+
    J[31]-J[32]+J[33]+J[34]-J[35]-J[36]+J[37]+J[38]-J[39]+J[40]+J[41]-J[42]-J[43]+J[44]-J[45]+J[46]+J[47]-J[48]-J[49]+
    J[50]-J[51]-J[52]+J[53]+J[54]-J[55]+J[56]-J[57]-J[58]+J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]+
    H[1]+H[2]+H[3]+H[4]+H[5]-H[6]+H[7]+H[8]-H[9]-H[10]-H[11]+J[0]+J[1]+J[2]+J[3]+J[4]-J[5]+J[6]+J[7]-J[8]-J[9]-J[10]+
    J[11]+J[12]+J[13]+J[14]-J[15]+J[16]+J[17]-J[18]-J[19]-J[20]+J[21]+J[22]+J[23]-J[24]+J[25]+J[26]-J[27]-J[28]-J[29]+
    J[30]+J[31]-J[32]+J[33]+J[34]-J[35]-J[36]-J[37]+J[38]-J[39]+J[40]+J[41]-J[42]-J[43]-J[44]-J[45]+J[46]+
    J[47]-J[48]-J[49]-J[50]-J[51]-J[52]+J[53]+J[54]+J[55]+J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+J[63]+
    J[64]+J[65], +H[0]+H[1]+H[2]+H[3]+H[4]+H[5]-H[6]+H[7]-H[8]+H[9]+H[10]+H[11]+J[0]+J[1]+J[2]+J[3]+J[4]-J[5]+
    J[6]-J[7]+J[8]+J[9]+J[10]+J[11]+J[12]+J[13]+J[14]-J[15]+J[16]-J[17]+J[18]+J[19]+J[20]+J[21]+J[22]+J[23]-J[24]+
    J[25]-J[26]+J[27]+J[28]+J[29]+J[30]+J[31]-J[32]+J[33]-J[34]+J[35]+J[36]+J[37]+J[38]-J[39]+J[40]-J[41]+
    J[42]+J[43]+J[44]-J[45]+J[46]-J[47]+J[48]+J[49]+J[50]-J[51]+J[52]-J[53]-J[54]-J[55]-J[56]+J[57]+J[58]+
    J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]+H[1]+H[2]+H[3]+H[4]+H[5]-H[6]+H[7]-H[8]+H[9]+H[10]-H[11]+
    J[0]+J[1]+J[2]+J[3]+J[4]-J[5]+J[6]-J[7]+J[8]+J[9]-J[10]+J[11]+J[12]+J[13]+J[14]-J[15]+J[16]-J[17]+J[18]+
    J[19]-J[20]+J[21]+J[22]+J[23]-J[24]+J[25]-J[26]+J[27]+J[28]-J[29]+J[30]+J[31]-J[32]+J[33]-J[34]+J[35]+
    J[36]-J[37]+J[38]-J[39]+J[40]-J[41]+J[42]+J[43]-J[44]-J[45]+J[46]-J[47]+J[48]+J[49]-J[50]-J[51]+J[52]-J[53]-J[54]+
    J[55]-J[56]+J[57]+J[58]-J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]+H[1]+H[2]+H[3]+H[4]+H[5]-H[6]+
    H[7]-H[8]+H[9]-H[10]+H[11]+J[0]+J[1]+J[2]+J[3]+J[4]-J[5]+J[6]-J[7]+J[8]-J[9]+J[10]+J[11]+J[12]+J[13]+
    J[14]-J[15]+J[16]-J[17]+J[18]-J[19]+J[20]+J[21]+J[22]+J[23]-J[24]+J[25]-J[26]+J[27]-J[28]+J[29]+J[30]+
    J[31]-J[32]+J[33]-J[34]+J[35]-J[36]+J[37]+J[38]-J[39]+J[40]-J[41]+J[42]-J[43]+J[44]-J[45]+J[46]-J[47]+
    J[48]-J[49]+J[50]-J[51]+J[52]-J[53]+J[54]-J[55]-J[56]+J[57]-J[58]+J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +
    H[0]+H[1]+H[2]+H[3]+H[4]+H[5]-H[6]+H[7]-H[8]+H[9]-H[10]-H[11]+J[0]+J[1]+J[2]+J[3]+J[4]-J[5]+J[6]-J[7]+
    J[8]-J[9]-J[10]+J[11]+J[12]+J[13]+J[14]-J[15]+J[16]-J[17]+J[18]-J[19]-J[20]+J[21]+J[22]+J[23]-J[24]+
    J[25]-J[26]+J[27]-J[28]-J[29]+J[30]+J[31]-J[32]+J[33]-J[34]+J[35]-J[36]-J[37]+J[38]-J[39]+J[40]-J[41]+
    J[42]-J[43]-J[44]-J[45]+J[46]-J[47]+J[48]-J[49]-J[50]-J[51]+J[52]-J[53]+J[54]+J[55]-J[56]+J[57]-J[58]-J[59]-J[60]+
    J[61]+J[62]-J[63]-J[64]+J[65], +H[0]+H[1]+H[2]+H[3]+H[4]+H[5]-H[6]+H[7]-H[8]-H[9]+H[10]+H[11]+J[0]+J[1]+
    J[2]+J[3]+J[4]-J[5]+J[6]-J[7]-J[8]+J[9]+J[10]+J[11]+J[12]+J[13]+J[14]-J[15]+J[16]-J[17]-J[18]+J[19]+
    J[20]+J[21]+J[22]+J[23]-J[24]+J[25]-J[26]-J[27]+J[28]+J[29]+J[30]+J[31]-J[32]+J[33]-J[34]-J[35]+J[36]+
    J[37]+J[38]-J[39]+J[40]-J[41]-J[42]+J[43]+J[44]-J[45]+J[46]-J[47]-J[48]+J[49]+J[50]-J[51]+J[52]+J[53]-J[54]-J[55]-J[56]-J[57]+
    J[58]+J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]+H[1]+H[2]+H[3]+H[4]+H[5]-H[6]+H[7]-H[8]-H[9]+
    H[10]-H[11]+J[0]+J[1]+J[2]+J[3]+J[4]-J[5]+J[6]-J[7]-J[8]+J[9]-J[10]+J[11]+J[12]+J[13]+J[14]-J[15]+J[16]-J[17]-J[18]+
    J[19]-J[20]+J[21]+J[22]+J[23]-J[24]+J[25]-J[26]-J[27]+J[28]-J[29]+J[30]+J[31]-J[32]+J[33]-J[34]-J[35]+
    J[36]-J[37]+J[38]-J[39]+J[40]-J[41]-J[42]+J[43]-J[44]-J[45]+J[46]-J[47]-J[48]+J[49]-J[50]-J[51]+J[52]+
    J[53]-J[54]+J[55]-J[56]-J[57]+J[58]-J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]+H[1]+H[2]+H[3]+
    H[4]+H[5]-H[6]+H[7]-H[8]-H[9]-H[10]+H[11]+J[0]+J[1]+J[2]+J[3]+J[4]-J[5]+J[6]-J[7]-J[8]-J[9]+J[10]+J[11]+
    J[12]+J[13]+J[14]-J[15]+J[16]-J[17]-J[18]-J[19]+J[20]+J[21]+J[22]+J[23]-J[24]+J[25]-J[26]-J[27]-J[28]+
    J[29]+J[30]+J[31]-J[32]+J[33]-J[34]-J[35]-J[36]+J[37]+J[38]-J[39]+J[40]-J[41]-J[42]-J[43]+J[44]-J[45]+
    J[46]-J[47]-J[48]-J[49]+J[50]-J[51]+J[52]+J[53]+J[54]-J[55]-J[56]-J[57]-J[58]+J[59]+J[60]+J[61]-J[62]+
    J[63]-J[64]-J[65], +H[0]+H[1]+H[2]+H[3]+H[4]+H[5]-H[6]+H[7]-H[8]-H[9]-H[10]-H[11]+J[0]+J[1]+J[2]+J[3]+
    J[4]-J[5]+J[6]-J[7]-J[8]-J[9]-J[10]+J[11]+J[12]+J[13]+J[14]-J[15]+J[16]-J[17]-J[18]-J[19]-J[20]+J[21]+
    J[22]+J[23]-J[24]+J[25]-J[26]-J[27]-J[28]-J[29]+J[30]+J[31]-J[32]+J[33]-J[34]-J[35]-J[36]-J[37]+J[38]-J[39]+
    J[40]-J[41]-J[42]-J[43]-J[44]-J[45]+J[46]-J[47]-J[48]-J[49]-J[50]-J[51]+J[52]+J[53]+J[54]+J[55]-J[56]-J[57]-J[58]-J[59]+
    J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]+H[1]+H[2]+H[3]+H[4]+H[5]-H[6]-H[7]+H[8]+H[9]+H[10]+H[11]+
    J[0]+J[1]+J[2]+J[3]+J[4]-J[5]-J[6]+J[7]+J[8]+J[9]+J[10]+J[11]+J[12]+J[13]+J[14]-J[15]-J[16]+J[17]+J[18]+
    J[19]+J[20]+J[21]+J[22]+J[23]-J[24]-J[25]+J[26]+J[27]+J[28]+J[29]+J[30]+J[31]-J[32]-J[33]+J[34]+J[35]+
    J[36]+J[37]+J[38]-J[39]-J[40]+J[41]+J[42]+J[43]+J[44]-J[45]-J[46]+J[47]+J[48]+J[49]+J[50]+J[51]-J[52]-J[53]-J[54]-J[55]-J[56]-J[57]-J[58]-J[59]+
    J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]+H[1]+H[2]+H[3]+H[4]+H[5]-H[6]-H[7]+H[8]+H[9]+H[10]-H[11]+
    J[0]+J[1]+J[2]+J[3]+J[4]-J[5]-J[6]+J[7]+J[8]+J[9]-J[10]+J[11]+J[12]+J[13]+J[14]-J[15]-J[16]+J[17]+J[18]+
    J[19]-J[20]+J[21]+J[22]+J[23]-J[24]-J[25]+J[26]+J[27]+J[28]-J[29]+J[30]+J[31]-J[32]-J[33]+J[34]+J[35]+
    J[36]-J[37]+J[38]-J[39]-J[40]+J[41]+J[42]+J[43]-J[44]-J[45]-J[46]+J[47]+J[48]+J[49]-J[50]+J[51]-J[52]-J[53]-J[54]+
    J[55]-J[56]-J[57]-J[58]+J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]+H[1]+H[2]+H[3]+H[4]+H[5]-H[6]-H[7]+
    H[8]+H[9]-H[10]+H[11]+J[0]+J[1]+J[2]+J[3]+J[4]-J[5]-J[6]+J[7]+J[8]-J[9]+J[10]+J[11]+J[12]+J[13]+J[14]-J[15]-J[16]+
    J[17]+J[18]-J[19]+J[20]+J[21]+J[22]+J[23]-J[24]-J[25]+J[26]+J[27]-J[28]+J[29]+J[30]+J[31]-J[32]-J[33]+
    J[34]+J[35]-J[36]+J[37]+J[38]-J[39]-J[40]+J[41]+J[42]-J[43]+J[44]-J[45]-J[46]+J[47]+J[48]-J[49]+J[50]+
    J[51]-J[52]-J[53]+J[54]-J[55]-J[56]-J[57]+J[58]-J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]+H[1]+
    H[2]+H[3]+H[4]+H[5]-H[6]-H[7]+H[8]+H[9]-H[10]-H[11]+J[0]+J[1]+J[2]+J[3]+J[4]-J[5]-J[6]+J[7]+J[8]-J[9]-J[10]+
    J[11]+J[12]+J[13]+J[14]-J[15]-J[16]+J[17]+J[18]-J[19]-J[20]+J[21]+J[22]+J[23]-J[24]-J[25]+J[26]+J[27]-J[28]-J[29]+
    J[30]+J[31]-J[32]-J[33]+J[34]+J[35]-J[36]-J[37]+J[38]-J[39]-J[40]+J[41]+J[42]-J[43]-J[44]-J[45]-J[46]+
    J[47]+J[48]-J[49]-J[50]+J[51]-J[52]-J[53]+J[54]+J[55]-J[56]-J[57]+J[58]+J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+
    J[65], +H[0]+H[1]+H[2]+H[3]+H[4]+H[5]-H[6]-H[7]+H[8]-H[9]+H[10]+H[11]+J[0]+J[1]+J[2]+J[3]+J[4]-J[5]-J[6]+
    J[7]-J[8]+J[9]+J[10]+J[11]+J[12]+J[13]+J[14]-J[15]-J[16]+J[17]-J[18]+J[19]+J[20]+J[21]+J[22]+J[23]-J[24]-J[25]+
    J[26]-J[27]+J[28]+J[29]+J[30]+J[31]-J[32]-J[33]+J[34]-J[35]+J[36]+J[37]+J[38]-J[39]-J[40]+J[41]-J[42]+
    J[43]+J[44]-J[45]-J[46]+J[47]-J[48]+J[49]+J[50]+J[51]-J[52]+J[53]-J[54]-J[55]-J[56]+J[57]-J[58]-J[59]-J[60]+
    J[61]+J[62]-J[63]-J[64]+J[65], +H[0]+H[1]+H[2]+H[3]+H[4]+H[5]-H[6]-H[7]+H[8]-H[9]+H[10]-H[11]+J[0]+J[1]+
    J[2]+J[3]+J[4]-J[5]-J[6]+J[7]-J[8]+J[9]-J[10]+J[11]+J[12]+J[13]+J[14]-J[15]-J[16]+J[17]-J[18]+J[19]-J[20]+
    J[21]+J[22]+J[23]-J[24]-J[25]+J[26]-J[27]+J[28]-J[29]+J[30]+J[31]-J[32]-J[33]+J[34]-J[35]+J[36]-J[37]+
    J[38]-J[39]-J[40]+J[41]-J[42]+J[43]-J[44]-J[45]-J[46]+J[47]-J[48]+J[49]-J[50]+J[51]-J[52]+J[53]-J[54]+
    J[55]-J[56]+J[57]-J[58]+J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]+H[1]+H[2]+H[3]+H[4]+H[5]-H[6]-H[7]+
    H[8]-H[9]-H[10]+H[11]+J[0]+J[1]+J[2]+J[3]+J[4]-J[5]-J[6]+J[7]-J[8]-J[9]+J[10]+J[11]+J[12]+J[13]+J[14]-J[15]-J[16]+
    J[17]-J[18]-J[19]+J[20]+J[21]+J[22]+J[23]-J[24]-J[25]+J[26]-J[27]-J[28]+J[29]+J[30]+J[31]-J[32]-J[33]+
    J[34]-J[35]-J[36]+J[37]+J[38]-J[39]-J[40]+J[41]-J[42]-J[43]+J[44]-J[45]-J[46]+J[47]-J[48]-J[49]+J[50]+
    J[51]-J[52]+J[53]+J[54]-J[55]-J[56]+J[57]+J[58]-J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]+H[1]+
    H[2]+H[3]+H[4]+H[5]-H[6]-H[7]+H[8]-H[9]-H[10]-H[11]+J[0]+J[1]+J[2]+J[3]+J[4]-J[5]-J[6]+J[7]-J[8]-J[9]-J[10]+
    J[11]+J[12]+J[13]+J[14]-J[15]-J[16]+J[17]-J[18]-J[19]-J[20]+J[21]+J[22]+J[23]-J[24]-J[25]+J[26]-J[27]-J[28]-J[29]+
    J[30]+J[31]-J[32]-J[33]+J[34]-J[35]-J[36]-J[37]+J[38]-J[39]-J[40]+J[41]-J[42]-J[43]-J[44]-J[45]-J[46]+
    J[47]-J[48]-J[49]-J[50]+J[51]-J[52]+J[53]+J[54]+J[55]-J[56]+J[57]+J[58]+J[59]-J[60]-J[61]-J[62]+J[63]+
    J[64]+J[65], +H[0]+H[1]+H[2]+H[3]+H[4]+H[5]-H[6]-H[7]-H[8]+H[9]+H[10]+H[11]+J[0]+J[1]+J[2]+J[3]+J[4]-J[5]-J[6]-J[7]+
    J[8]+J[9]+J[10]+J[11]+J[12]+J[13]+J[14]-J[15]-J[16]-J[17]+J[18]+J[19]+J[20]+J[21]+J[22]+J[23]-J[24]-J[25]-J[26]+
    J[27]+J[28]+J[29]+J[30]+J[31]-J[32]-J[33]-J[34]+J[35]+J[36]+J[37]+J[38]-J[39]-J[40]-J[41]+J[42]+J[43]+
    J[44]-J[45]-J[46]-J[47]+J[48]+J[49]+J[50]+J[51]+J[52]-J[53]-J[54]-J[55]+J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+
    J[63]+J[64]+J[65], +H[0]+H[1]+H[2]+H[3]+H[4]+H[5]-H[6]-H[7]-H[8]+H[9]+H[10]-H[11]+J[0]+J[1]+J[2]+J[3]+
    J[4]-J[5]-J[6]-J[7]+J[8]+J[9]-J[10]+J[11]+J[12]+J[13]+J[14]-J[15]-J[16]-J[17]+J[18]+J[19]-J[20]+J[21]+
    J[22]+J[23]-J[24]-J[25]-J[26]+J[27]+J[28]-J[29]+J[30]+J[31]-J[32]-J[33]-J[34]+J[35]+J[36]-J[37]+J[38]-J[39]-J[40]-J[41]+
    J[42]+J[43]-J[44]-J[45]-J[46]-J[47]+J[48]+J[49]-J[50]+J[51]+J[52]-J[53]-J[54]+J[55]+J[56]-J[57]-J[58]+
    J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]+H[1]+H[2]+H[3]+H[4]+H[5]-H[6]-H[7]-H[8]+H[9]-H[10]+
    H[11]+J[0]+J[1]+J[2]+J[3]+J[4]-J[5]-J[6]-J[7]+J[8]-J[9]+J[10]+J[11]+J[12]+J[13]+J[14]-J[15]-J[16]-J[17]+
    J[18]-J[19]+J[20]+J[21]+J[22]+J[23]-J[24]-J[25]-J[26]+J[27]-J[28]+J[29]+J[30]+J[31]-J[32]-J[33]-J[34]+
    J[35]-J[36]+J[37]+J[38]-J[39]-J[40]-J[41]+J[42]-J[43]+J[44]-J[45]-J[46]-J[47]+J[48]-J[49]+J[50]+J[51]+
    J[52]-J[53]+J[54]-J[55]+J[56]-J[57]+J[58]-J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]+H[1]+H[2]+
    H[3]+H[4]+H[5]-H[6]-H[7]-H[8]+H[9]-H[10]-H[11]+J[0]+J[1]+J[2]+J[3]+J[4]-J[5]-J[6]-J[7]+J[8]-J[9]-J[10]+
    J[11]+J[12]+J[13]+J[14]-J[15]-J[16]-J[17]+J[18]-J[19]-J[20]+J[21]+J[22]+J[23]-J[24]-J[25]-J[26]+J[27]-J[28]-J[29]+
    J[30]+J[31]-J[32]-J[33]-J[34]+J[35]-J[36]-J[37]+J[38]-J[39]-J[40]-J[41]+J[42]-J[43]-J[44]-J[45]-J[46]-J[47]+
    J[48]-J[49]-J[50]+J[51]+J[52]-J[53]+J[54]+J[55]+J[56]-J[57]+J[58]+J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+
    J[65], +H[0]+H[1]+H[2]+H[3]+H[4]+H[5]-H[6]-H[7]-H[8]-H[9]+H[10]+H[11]+J[0]+J[1]+J[2]+J[3]+J[4]-J[5]-J[6]-J[7]-J[8]+
    J[9]+J[10]+J[11]+J[12]+J[13]+J[14]-J[15]-J[16]-J[17]-J[18]+J[19]+J[20]+J[21]+J[22]+J[23]-J[24]-J[25]-J[26]-J[27]+
    J[28]+J[29]+J[30]+J[31]-J[32]-J[33]-J[34]-J[35]+J[36]+J[37]+J[38]-J[39]-J[40]-J[41]-J[42]+J[43]+J[44]-J[45]-J[46]-J[47]-J[48]+
    J[49]+J[50]+J[51]+J[52]+J[53]-J[54]-J[55]+J[56]+J[57]-J[58]-J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +
    H[0]+H[1]+H[2]+H[3]+H[4]+H[5]-H[6]-H[7]-H[8]-H[9]+H[10]-H[11]+J[0]+J[1]+J[2]+J[3]+J[4]-J[5]-J[6]-J[7]-J[8]+
    J[9]-J[10]+J[11]+J[12]+J[13]+J[14]-J[15]-J[16]-J[17]-J[18]+J[19]-J[20]+J[21]+J[22]+J[23]-J[24]-J[25]-J[26]-J[27]+
    J[28]-J[29]+J[30]+J[31]-J[32]-J[33]-J[34]-J[35]+J[36]-J[37]+J[38]-J[39]-J[40]-J[41]-J[42]+J[43]-J[44]-J[45]-J[46]-J[47]-J[48]+
    J[49]-J[50]+J[51]+J[52]+J[53]-J[54]+J[55]+J[56]+J[57]-J[58]+J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +
    H[0]+H[1]+H[2]+H[3]+H[4]+H[5]-H[6]-H[7]-H[8]-H[9]-H[10]+H[11]+J[0]+J[1]+J[2]+J[3]+J[4]-J[5]-J[6]-J[7]-J[8]-J[9]+
    J[10]+J[11]+J[12]+J[13]+J[14]-J[15]-J[16]-J[17]-J[18]-J[19]+J[20]+J[21]+J[22]+J[23]-J[24]-J[25]-J[26]-J[27]-J[28]+
    J[29]+J[30]+J[31]-J[32]-J[33]-J[34]-J[35]-J[36]+J[37]+J[38]-J[39]-J[40]-J[41]-J[42]-J[43]+J[44]-J[45]-J[46]-J[47]-J[48]-J[49]+
    J[50]+J[51]+J[52]+J[53]+J[54]-J[55]+J[56]+J[57]+J[58]-J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]+
    H[1]+H[2]+H[3]+H[4]+H[5]-H[6]-H[7]-H[8]-H[9]-H[10]-H[11]+J[0]+J[1]+J[2]+J[3]+J[4]-J[5]-J[6]-J[7]-J[8]-J[9]-J[10]+
    J[11]+J[12]+J[13]+J[14]-J[15]-J[16]-J[17]-J[18]-J[19]-J[20]+J[21]+J[22]+J[23]-J[24]-J[25]-J[26]-J[27]-J[28]-J[29]+
    J[30]+J[31]-J[32]-J[33]-J[34]-J[35]-J[36]-J[37]+J[38]-J[39]-J[40]-J[41]-J[42]-J[43]-J[44]-J[45]-J[46]-J[47]-J[48]-J[49]-J[50]+
    J[51]+J[52]+J[53]+J[54]+J[55]+J[56]+J[57]+J[58]+J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]+H[1]+
    H[2]+H[3]+H[4]-H[5]+H[6]+H[7]+H[8]+H[9]+H[10]+H[11]+J[0]+J[1]+J[2]+J[3]-J[4]+J[5]+J[6]+J[7]+J[8]+J[9]+
    J[10]+J[11]+J[12]+J[13]-J[14]+J[15]+J[16]+J[17]+J[18]+J[19]+J[20]+J[21]+J[22]-J[23]+J[24]+J[25]+J[26]+
    J[27]+J[28]+J[29]+J[30]-J[31]+J[32]+J[33]+J[34]+J[35]+J[36]+J[37]-J[38]+J[39]+J[40]+J[41]+J[42]+J[43]+
    J[44]-J[45]-J[46]-J[47]-J[48]-J[49]-J[50]+J[51]+J[52]+J[53]+J[54]+J[55]+J[56]+J[57]+J[58]+J[59]+J[60]+
    J[61]+J[62]+J[63]+J[64]+J[65], +H[0]+H[1]+H[2]+H[3]+H[4]-H[5]+H[6]+H[7]+H[8]+H[9]+H[10]-H[11]+J[0]+J[1]+
    J[2]+J[3]-J[4]+J[5]+J[6]+J[7]+J[8]+J[9]-J[10]+J[11]+J[12]+J[13]-J[14]+J[15]+J[16]+J[17]+J[18]+J[19]-J[20]+
    J[21]+J[22]-J[23]+J[24]+J[25]+J[26]+J[27]+J[28]-J[29]+J[30]-J[31]+J[32]+J[33]+J[34]+J[35]+J[36]-J[37]-J[38]+
    J[39]+J[40]+J[41]+J[42]+J[43]-J[44]-J[45]-J[46]-J[47]-J[48]-J[49]+J[50]+J[51]+J[52]+J[53]+J[54]-J[55]+
    J[56]+J[57]+J[58]-J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]+H[1]+H[2]+H[3]+H[4]-H[5]+H[6]+H[7]+
    H[8]+H[9]-H[10]+H[11]+J[0]+J[1]+J[2]+J[3]-J[4]+J[5]+J[6]+J[7]+J[8]-J[9]+J[10]+J[11]+J[12]+J[13]-J[14]+
    J[15]+J[16]+J[17]+J[18]-J[19]+J[20]+J[21]+J[22]-J[23]+J[24]+J[25]+J[26]+J[27]-J[28]+J[29]+J[30]-J[31]+
    J[32]+J[33]+J[34]+J[35]-J[36]+J[37]-J[38]+J[39]+J[40]+J[41]+J[42]-J[43]+J[44]-J[45]-J[46]-J[47]-J[48]+
    J[49]-J[50]+J[51]+J[52]+J[53]-J[54]+J[55]+J[56]+J[57]-J[58]+J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +
    H[0]+H[1]+H[2]+H[3]+H[4]-H[5]+H[6]+H[7]+H[8]+H[9]-H[10]-H[11]+J[0]+J[1]+J[2]+J[3]-J[4]+J[5]+J[6]+J[7]+
    J[8]-J[9]-J[10]+J[11]+J[12]+J[13]-J[14]+J[15]+J[16]+J[17]+J[18]-J[19]-J[20]+J[21]+J[22]-J[23]+J[24]+
    J[25]+J[26]+J[27]-J[28]-J[29]+J[30]-J[31]+J[32]+J[33]+J[34]+J[35]-J[36]-J[37]-J[38]+J[39]+J[40]+J[41]+
    J[42]-J[43]-J[44]-J[45]-J[46]-J[47]-J[48]+J[49]+J[50]+J[51]+J[52]+J[53]-J[54]-J[55]+J[56]+J[57]-J[58]-J[59]+
    J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]+H[1]+H[2]+H[3]+H[4]-H[5]+H[6]+H[7]+H[8]-H[9]+H[10]+H[11]+
    J[0]+J[1]+J[2]+J[3]-J[4]+J[5]+J[6]+J[7]-J[8]+J[9]+J[10]+J[11]+J[12]+J[13]-J[14]+J[15]+J[16]+J[17]-J[18]+
    J[19]+J[20]+J[21]+J[22]-J[23]+J[24]+J[25]+J[26]-J[27]+J[28]+J[29]+J[30]-J[31]+J[32]+J[33]+J[34]-J[35]+
    J[36]+J[37]-J[38]+J[39]+J[40]+J[41]-J[42]+J[43]+J[44]-J[45]-J[46]-J[47]+J[48]-J[49]-J[50]+J[51]+J[52]-J[53]+
    J[54]+J[55]+J[56]-J[57]+J[58]+J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]+H[1]+H[2]+H[3]+H[4]-H[5]+
    H[6]+H[7]+H[8]-H[9]+H[10]-H[11]+J[0]+J[1]+J[2]+J[3]-J[4]+J[5]+J[6]+J[7]-J[8]+J[9]-J[10]+J[11]+J[12]+
    J[13]-J[14]+J[15]+J[16]+J[17]-J[18]+J[19]-J[20]+J[21]+J[22]-J[23]+J[24]+J[25]+J[26]-J[27]+J[28]-J[29]+
    J[30]-J[31]+J[32]+J[33]+J[34]-J[35]+J[36]-J[37]-J[38]+J[39]+J[40]+J[41]-J[42]+J[43]-J[44]-J[45]-J[46]-J[47]+
    J[48]-J[49]+J[50]+J[51]+J[52]-J[53]+J[54]-J[55]+J[56]-J[57]+J[58]-J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +
    H[0]+H[1]+H[2]+H[3]+H[4]-H[5]+H[6]+H[7]+H[8]-H[9]-H[10]+H[11]+J[0]+J[1]+J[2]+J[3]-J[4]+J[5]+J[6]+J[7]-J[8]-J[9]+
    J[10]+J[11]+J[12]+J[13]-J[14]+J[15]+J[16]+J[17]-J[18]-J[19]+J[20]+J[21]+J[22]-J[23]+J[24]+J[25]+J[26]-J[27]-J[28]+
    J[29]+J[30]-J[31]+J[32]+J[33]+J[34]-J[35]-J[36]+J[37]-J[38]+J[39]+J[40]+J[41]-J[42]-J[43]+J[44]-J[45]-J[46]-J[47]+
    J[48]+J[49]-J[50]+J[51]+J[52]-J[53]-J[54]+J[55]+J[56]-J[57]-J[58]+J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +
    H[0]+H[1]+H[2]+H[3]+H[4]-H[5]+H[6]+H[7]+H[8]-H[9]-H[10]-H[11]+J[0]+J[1]+J[2]+J[3]-J[4]+J[5]+J[6]+J[7]-J[8]-J[9]-J[10]+
    J[11]+J[12]+J[13]-J[14]+J[15]+J[16]+J[17]-J[18]-J[19]-J[20]+J[21]+J[22]-J[23]+J[24]+J[25]+J[26]-J[27]-J[28]-J[29]+
    J[30]-J[31]+J[32]+J[33]+J[34]-J[35]-J[36]-J[37]-J[38]+J[39]+J[40]+J[41]-J[42]-J[43]-J[44]-J[45]-J[46]-J[47]+
    J[48]+J[49]+J[50]+J[51]+J[52]-J[53]-J[54]-J[55]+J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+
    J[65], +H[0]+H[1]+H[2]+H[3]+H[4]-H[5]+H[6]+H[7]-H[8]+H[9]+H[10]+H[11]+J[0]+J[1]+J[2]+J[3]-J[4]+J[5]+
    J[6]-J[7]+J[8]+J[9]+J[10]+J[11]+J[12]+J[13]-J[14]+J[15]+J[16]-J[17]+J[18]+J[19]+J[20]+J[21]+J[22]-J[23]+
    J[24]+J[25]-J[26]+J[27]+J[28]+J[29]+J[30]-J[31]+J[32]+J[33]-J[34]+J[35]+J[36]+J[37]-J[38]+J[39]+J[40]-J[41]+
    J[42]+J[43]+J[44]-J[45]-J[46]+J[47]-J[48]-J[49]-J[50]+J[51]-J[52]+J[53]+J[54]+J[55]-J[56]+J[57]+J[58]+
    J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]+H[1]+H[2]+H[3]+H[4]-H[5]+H[6]+H[7]-H[8]+H[9]+H[10]-H[11]+
    J[0]+J[1]+J[2]+J[3]-J[4]+J[5]+J[6]-J[7]+J[8]+J[9]-J[10]+J[11]+J[12]+J[13]-J[14]+J[15]+J[16]-J[17]+J[18]+
    J[19]-J[20]+J[21]+J[22]-J[23]+J[24]+J[25]-J[26]+J[27]+J[28]-J[29]+J[30]-J[31]+J[32]+J[33]-J[34]+J[35]+
    J[36]-J[37]-J[38]+J[39]+J[40]-J[41]+J[42]+J[43]-J[44]-J[45]-J[46]+J[47]-J[48]-J[49]+J[50]+J[51]-J[52]+
    J[53]+J[54]-J[55]-J[56]+J[57]+J[58]-J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]+H[1]+H[2]+H[3]+
    H[4]-H[5]+H[6]+H[7]-H[8]+H[9]-H[10]+H[11]+J[0]+J[1]+J[2]+J[3]-J[4]+J[5]+J[6]-J[7]+J[8]-J[9]+J[10]+J[11]+
    J[12]+J[13]-J[14]+J[15]+J[16]-J[17]+J[18]-J[19]+J[20]+J[21]+J[22]-J[23]+J[24]+J[25]-J[26]+J[27]-J[28]+
    J[29]+J[30]-J[31]+J[32]+J[33]-J[34]+J[35]-J[36]+J[37]-J[38]+J[39]+J[40]-J[41]+J[42]-J[43]+J[44]-J[45]-J[46]+
    J[47]-J[48]+J[49]-J[50]+J[51]-J[52]+J[53]-J[54]+J[55]-J[56]+J[57]-J[58]+J[59]-J[60]+J[61]-J[62]-J[63]+
    J[64]-J[65], +H[0]+H[1]+H[2]+H[3]+H[4]-H[5]+H[6]+H[7]-H[8]+H[9]-H[10]-H[11]+J[0]+J[1]+J[2]+J[3]-J[4]+
    J[5]+J[6]-J[7]+J[8]-J[9]-J[10]+J[11]+J[12]+J[13]-J[14]+J[15]+J[16]-J[17]+J[18]-J[19]-J[20]+J[21]+J[22]-J[23]+
    J[24]+J[25]-J[26]+J[27]-J[28]-J[29]+J[30]-J[31]+J[32]+J[33]-J[34]+J[35]-J[36]-J[37]-J[38]+J[39]+J[40]-J[41]+
    J[42]-J[43]-J[44]-J[45]-J[46]+J[47]-J[48]+J[49]+J[50]+J[51]-J[52]+J[53]-J[54]-J[55]-J[56]+J[57]-J[58]-J[59]-J[60]+
    J[61]+J[62]-J[63]-J[64]+J[65], +H[0]+H[1]+H[2]+H[3]+H[4]-H[5]+H[6]+H[7]-H[8]-H[9]+H[10]+H[11]+J[0]+J[1]+
    J[2]+J[3]-J[4]+J[5]+J[6]-J[7]-J[8]+J[9]+J[10]+J[11]+J[12]+J[13]-J[14]+J[15]+J[16]-J[17]-J[18]+J[19]+
    J[20]+J[21]+J[22]-J[23]+J[24]+J[25]-J[26]-J[27]+J[28]+J[29]+J[30]-J[31]+J[32]+J[33]-J[34]-J[35]+J[36]+
    J[37]-J[38]+J[39]+J[40]-J[41]-J[42]+J[43]+J[44]-J[45]-J[46]+J[47]+J[48]-J[49]-J[50]+J[51]-J[52]-J[53]+
    J[54]+J[55]-J[56]-J[57]+J[58]+J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]+H[1]+H[2]+H[3]+H[4]-H[5]+
    H[6]+H[7]-H[8]-H[9]+H[10]-H[11]+J[0]+J[1]+J[2]+J[3]-J[4]+J[5]+J[6]-J[7]-J[8]+J[9]-J[10]+J[11]+J[12]+
    J[13]-J[14]+J[15]+J[16]-J[17]-J[18]+J[19]-J[20]+J[21]+J[22]-J[23]+J[24]+J[25]-J[26]-J[27]+J[28]-J[29]+
    J[30]-J[31]+J[32]+J[33]-J[34]-J[35]+J[36]-J[37]-J[38]+J[39]+J[40]-J[41]-J[42]+J[43]-J[44]-J[45]-J[46]+
    J[47]+J[48]-J[49]+J[50]+J[51]-J[52]-J[53]+J[54]-J[55]-J[56]-J[57]+J[58]-J[59]+J[60]-J[61]+J[62]-J[63]+
    J[64]-J[65], +H[0]+H[1]+H[2]+H[3]+H[4]-H[5]+H[6]+H[7]-H[8]-H[9]-H[10]+H[11]+J[0]+J[1]+J[2]+J[3]-J[4]+
    J[5]+J[6]-J[7]-J[8]-J[9]+J[10]+J[11]+J[12]+J[13]-J[14]+J[15]+J[16]-J[17]-J[18]-J[19]+J[20]+J[21]+J[22]-J[23]+
    J[24]+J[25]-J[26]-J[27]-J[28]+J[29]+J[30]-J[31]+J[32]+J[33]-J[34]-J[35]-J[36]+J[37]-J[38]+J[39]+J[40]-J[41]-J[42]-J[43]+
    J[44]-J[45]-J[46]+J[47]+J[48]+J[49]-J[50]+J[51]-J[52]-J[53]-J[54]+J[55]-J[56]-J[57]-J[58]+J[59]+J[60]+
    J[61]-J[62]+J[63]-J[64]-J[65], +H[0]+H[1]+H[2]+H[3]+H[4]-H[5]+H[6]+H[7]-H[8]-H[9]-H[10]-H[11]+J[0]+J[1]+
    J[2]+J[3]-J[4]+J[5]+J[6]-J[7]-J[8]-J[9]-J[10]+J[11]+J[12]+J[13]-J[14]+J[15]+J[16]-J[17]-J[18]-J[19]-J[20]+
    J[21]+J[22]-J[23]+J[24]+J[25]-J[26]-J[27]-J[28]-J[29]+J[30]-J[31]+J[32]+J[33]-J[34]-J[35]-J[36]-J[37]-J[38]+
    J[39]+J[40]-J[41]-J[42]-J[43]-J[44]-J[45]-J[46]+J[47]+J[48]+J[49]+J[50]+J[51]-J[52]-J[53]-J[54]-J[55]-J[56]-J[57]-J[58]-J[59]+
    J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]+H[1]+H[2]+H[3]+H[4]-H[5]+H[6]-H[7]+H[8]+H[9]+H[10]+H[11]+
    J[0]+J[1]+J[2]+J[3]-J[4]+J[5]-J[6]+J[7]+J[8]+J[9]+J[10]+J[11]+J[12]+J[13]-J[14]+J[15]-J[16]+J[17]+J[18]+
    J[19]+J[20]+J[21]+J[22]-J[23]+J[24]-J[25]+J[26]+J[27]+J[28]+J[29]+J[30]-J[31]+J[32]-J[33]+J[34]+J[35]+
    J[36]+J[37]-J[38]+J[39]-J[40]+J[41]+J[42]+J[43]+J[44]-J[45]+J[46]-J[47]-J[48]-J[49]-J[50]-J[51]+J[52]+
    J[53]+J[54]+J[55]-J[56]-J[57]-J[58]-J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]+H[1]+H[2]+H[3]+
    H[4]-H[5]+H[6]-H[7]+H[8]+H[9]+H[10]-H[11]+J[0]+J[1]+J[2]+J[3]-J[4]+J[5]-J[6]+J[7]+J[8]+J[9]-J[10]+J[11]+
    J[12]+J[13]-J[14]+J[15]-J[16]+J[17]+J[18]+J[19]-J[20]+J[21]+J[22]-J[23]+J[24]-J[25]+J[26]+J[27]+J[28]-J[29]+
    J[30]-J[31]+J[32]-J[33]+J[34]+J[35]+J[36]-J[37]-J[38]+J[39]-J[40]+J[41]+J[42]+J[43]-J[44]-J[45]+J[46]-J[47]-J[48]-J[49]+
    J[50]-J[51]+J[52]+J[53]+J[54]-J[55]-J[56]-J[57]-J[58]+J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]+
    H[1]+H[2]+H[3]+H[4]-H[5]+H[6]-H[7]+H[8]+H[9]-H[10]+H[11]+J[0]+J[1]+J[2]+J[3]-J[4]+J[5]-J[6]+J[7]+J[8]-J[9]+
    J[10]+J[11]+J[12]+J[13]-J[14]+J[15]-J[16]+J[17]+J[18]-J[19]+J[20]+J[21]+J[22]-J[23]+J[24]-J[25]+J[26]+
    J[27]-J[28]+J[29]+J[30]-J[31]+J[32]-J[33]+J[34]+J[35]-J[36]+J[37]-J[38]+J[39]-J[40]+J[41]+J[42]-J[43]+
    J[44]-J[45]+J[46]-J[47]-J[48]+J[49]-J[50]-J[51]+J[52]+J[53]-J[54]+J[55]-J[56]-J[57]+J[58]-J[59]+J[60]-J[61]+
    J[62]-J[63]+J[64]-J[65], +H[0]+H[1]+H[2]+H[3]+H[4]-H[5]+H[6]-H[7]+H[8]+H[9]-H[10]-H[11]+J[0]+J[1]+J[2]+
    J[3]-J[4]+J[5]-J[6]+J[7]+J[8]-J[9]-J[10]+J[11]+J[12]+J[13]-J[14]+J[15]-J[16]+J[17]+J[18]-J[19]-J[20]+
    J[21]+J[22]-J[23]+J[24]-J[25]+J[26]+J[27]-J[28]-J[29]+J[30]-J[31]+J[32]-J[33]+J[34]+J[35]-J[36]-J[37]-J[38]+
    J[39]-J[40]+J[41]+J[42]-J[43]-J[44]-J[45]+J[46]-J[47]-J[48]+J[49]+J[50]-J[51]+J[52]+J[53]-J[54]-J[55]-J[56]-J[57]+
    J[58]+J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]+H[1]+H[2]+H[3]+H[4]-H[5]+H[6]-H[7]+H[8]-H[9]+
    H[10]+H[11]+J[0]+J[1]+J[2]+J[3]-J[4]+J[5]-J[6]+J[7]-J[8]+J[9]+J[10]+J[11]+J[12]+J[13]-J[14]+J[15]-J[16]+
    J[17]-J[18]+J[19]+J[20]+J[21]+J[22]-J[23]+J[24]-J[25]+J[26]-J[27]+J[28]+J[29]+J[30]-J[31]+J[32]-J[33]+
    J[34]-J[35]+J[36]+J[37]-J[38]+J[39]-J[40]+J[41]-J[42]+J[43]+J[44]-J[45]+J[46]-J[47]+J[48]-J[49]-J[50]-J[51]+
    J[52]-J[53]+J[54]+J[55]-J[56]+J[57]-J[58]-J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]+H[1]+H[2]+
    H[3]+H[4]-H[5]+H[6]-H[7]+H[8]-H[9]+H[10]-H[11]+J[0]+J[1]+J[2]+J[3]-J[4]+J[5]-J[6]+J[7]-J[8]+J[9]-J[10]+
    J[11]+J[12]+J[13]-J[14]+J[15]-J[16]+J[17]-J[18]+J[19]-J[20]+J[21]+J[22]-J[23]+J[24]-J[25]+J[26]-J[27]+
    J[28]-J[29]+J[30]-J[31]+J[32]-J[33]+J[34]-J[35]+J[36]-J[37]-J[38]+J[39]-J[40]+J[41]-J[42]+J[43]-J[44]-J[45]+
    J[46]-J[47]+J[48]-J[49]+J[50]-J[51]+J[52]-J[53]+J[54]-J[55]-J[56]+J[57]-J[58]+J[59]-J[60]+J[61]-J[62]-J[63]+
    J[64]-J[65], +H[0]+H[1]+H[2]+H[3]+H[4]-H[5]+H[6]-H[7]+H[8]-H[9]-H[10]+H[11]+J[0]+J[1]+J[2]+J[3]-J[4]+
    J[5]-J[6]+J[7]-J[8]-J[9]+J[10]+J[11]+J[12]+J[13]-J[14]+J[15]-J[16]+J[17]-J[18]-J[19]+J[20]+J[21]+J[22]-J[23]+
    J[24]-J[25]+J[26]-J[27]-J[28]+J[29]+J[30]-J[31]+J[32]-J[33]+J[34]-J[35]-J[36]+J[37]-J[38]+J[39]-J[40]+
    J[41]-J[42]-J[43]+J[44]-J[45]+J[46]-J[47]+J[48]+J[49]-J[50]-J[51]+J[52]-J[53]-J[54]+J[55]-J[56]+J[57]+
    J[58]-J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]+H[1]+H[2]+H[3]+H[4]-H[5]+H[6]-H[7]+H[8]-H[9]-H[10]-H[11]+
    J[0]+J[1]+J[2]+J[3]-J[4]+J[5]-J[6]+J[7]-J[8]-J[9]-J[10]+J[11]+J[12]+J[13]-J[14]+J[15]-J[16]+J[17]-J[18]-J[19]-J[20]+
    J[21]+J[22]-J[23]+J[24]-J[25]+J[26]-J[27]-J[28]-J[29]+J[30]-J[31]+J[32]-J[33]+J[34]-J[35]-J[36]-J[37]-J[38]+
    J[39]-J[40]+J[41]-J[42]-J[43]-J[44]-J[45]+J[46]-J[47]+J[48]+J[49]+J[50]-J[51]+J[52]-J[53]-J[54]-J[55]-J[56]+
    J[57]+J[58]+J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]+H[1]+H[2]+H[3]+H[4]-H[5]+H[6]-H[7]-H[8]+
    H[9]+H[10]+H[11]+J[0]+J[1]+J[2]+J[3]-J[4]+J[5]-J[6]-J[7]+J[8]+J[9]+J[10]+J[11]+J[12]+J[13]-J[14]+J[15]-J[16]-J[17]+
    J[18]+J[19]+J[20]+J[21]+J[22]-J[23]+J[24]-J[25]-J[26]+J[27]+J[28]+J[29]+J[30]-J[31]+J[32]-J[33]-J[34]+
    J[35]+J[36]+J[37]-J[38]+J[39]-J[40]-J[41]+J[42]+J[43]+J[44]-J[45]+J[46]+J[47]-J[48]-J[49]-J[50]-J[51]-J[52]+
    J[53]+J[54]+J[55]+J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]+H[1]+H[2]+H[3]+
    H[4]-H[5]+H[6]-H[7]-H[8]+H[9]+H[10]-H[11]+J[0]+J[1]+J[2]+J[3]-J[4]+J[5]-J[6]-J[7]+J[8]+J[9]-J[10]+J[11]+
    J[12]+J[13]-J[14]+J[15]-J[16]-J[17]+J[18]+J[19]-J[20]+J[21]+J[22]-J[23]+J[24]-J[25]-J[26]+J[27]+J[28]-J[29]+
    J[30]-J[31]+J[32]-J[33]-J[34]+J[35]+J[36]-J[37]-J[38]+J[39]-J[40]-J[41]+J[42]+J[43]-J[44]-J[45]+J[46]+
    J[47]-J[48]-J[49]+J[50]-J[51]-J[52]+J[53]+J[54]-J[55]+J[56]-J[57]-J[58]+J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +
    H[0]+H[1]+H[2]+H[3]+H[4]-H[5]+H[6]-H[7]-H[8]+H[9]-H[10]+H[11]+J[0]+J[1]+J[2]+J[3]-J[4]+J[5]-J[6]-J[7]+
    J[8]-J[9]+J[10]+J[11]+J[12]+J[13]-J[14]+J[15]-J[16]-J[17]+J[18]-J[19]+J[20]+J[21]+J[22]-J[23]+J[24]-J[25]-J[26]+
    J[27]-J[28]+J[29]+J[30]-J[31]+J[32]-J[33]-J[34]+J[35]-J[36]+J[37]-J[38]+J[39]-J[40]-J[41]+J[42]-J[43]+
    J[44]-J[45]+J[46]+J[47]-J[48]+J[49]-J[50]-J[51]-J[52]+J[53]-J[54]+J[55]+J[56]-J[57]+J[58]-J[59]-J[60]+
    J[61]-J[62]-J[63]+J[64]-J[65], +H[0]+H[1]+H[2]+H[3]+H[4]-H[5]+H[6]-H[7]-H[8]+H[9]-H[10]-H[11]+J[0]+J[1]+
    J[2]+J[3]-J[4]+J[5]-J[6]-J[7]+J[8]-J[9]-J[10]+J[11]+J[12]+J[13]-J[14]+J[15]-J[16]-J[17]+J[18]-J[19]-J[20]+
    J[21]+J[22]-J[23]+J[24]-J[25]-J[26]+J[27]-J[28]-J[29]+J[30]-J[31]+J[32]-J[33]-J[34]+J[35]-J[36]-J[37]-J[38]+
    J[39]-J[40]-J[41]+J[42]-J[43]-J[44]-J[45]+J[46]+J[47]-J[48]+J[49]+J[50]-J[51]-J[52]+J[53]-J[54]-J[55]+
    J[56]-J[57]+J[58]+J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]+H[1]+H[2]+H[3]+H[4]-H[5]+H[6]-H[7]-H[8]-H[9]+
    H[10]+H[11]+J[0]+J[1]+J[2]+J[3]-J[4]+J[5]-J[6]-J[7]-J[8]+J[9]+J[10]+J[11]+J[12]+J[13]-J[14]+J[15]-J[16]-J[17]-J[18]+
    J[19]+J[20]+J[21]+J[22]-J[23]+J[24]-J[25]-J[26]-J[27]+J[28]+J[29]+J[30]-J[31]+J[32]-J[33]-J[34]-J[35]+
    J[36]+J[37]-J[38]+J[39]-J[40]-J[41]-J[42]+J[43]+J[44]-J[45]+J[46]+J[47]+J[48]-J[49]-J[50]-J[51]-J[52]-J[53]+
    J[54]+J[55]+J[56]+J[57]-J[58]-J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]+H[1]+H[2]+H[3]+H[4]-H[5]+
    H[6]-H[7]-H[8]-H[9]+H[10]-H[11]+J[0]+J[1]+J[2]+J[3]-J[4]+J[5]-J[6]-J[7]-J[8]+J[9]-J[10]+J[11]+J[12]+
    J[13]-J[14]+J[15]-J[16]-J[17]-J[18]+J[19]-J[20]+J[21]+J[22]-J[23]+J[24]-J[25]-J[26]-J[27]+J[28]-J[29]+
    J[30]-J[31]+J[32]-J[33]-J[34]-J[35]+J[36]-J[37]-J[38]+J[39]-J[40]-J[41]-J[42]+J[43]-J[44]-J[45]+J[46]+
    J[47]+J[48]-J[49]+J[50]-J[51]-J[52]-J[53]+J[54]-J[55]+J[56]+J[57]-J[58]+J[59]+J[60]-J[61]+J[62]-J[63]+
    J[64]-J[65], +H[0]+H[1]+H[2]+H[3]+H[4]-H[5]+H[6]-H[7]-H[8]-H[9]-H[10]+H[11]+J[0]+J[1]+J[2]+J[3]-J[4]+
    J[5]-J[6]-J[7]-J[8]-J[9]+J[10]+J[11]+J[12]+J[13]-J[14]+J[15]-J[16]-J[17]-J[18]-J[19]+J[20]+J[21]+J[22]-J[23]+
    J[24]-J[25]-J[26]-J[27]-J[28]+J[29]+J[30]-J[31]+J[32]-J[33]-J[34]-J[35]-J[36]+J[37]-J[38]+J[39]-J[40]-J[41]-J[42]-J[43]+
    J[44]-J[45]+J[46]+J[47]+J[48]+J[49]-J[50]-J[51]-J[52]-J[53]-J[54]+J[55]+J[56]+J[57]+J[58]-J[59]+J[60]+
    J[61]-J[62]+J[63]-J[64]-J[65], +H[0]+H[1]+H[2]+H[3]+H[4]-H[5]+H[6]-H[7]-H[8]-H[9]-H[10]-H[11]+J[0]+J[1]+
    J[2]+J[3]-J[4]+J[5]-J[6]-J[7]-J[8]-J[9]-J[10]+J[11]+J[12]+J[13]-J[14]+J[15]-J[16]-J[17]-J[18]-J[19]-J[20]+
    J[21]+J[22]-J[23]+J[24]-J[25]-J[26]-J[27]-J[28]-J[29]+J[30]-J[31]+J[32]-J[33]-J[34]-J[35]-J[36]-J[37]-J[38]+
    J[39]-J[40]-J[41]-J[42]-J[43]-J[44]-J[45]+J[46]+J[47]+J[48]+J[49]+J[50]-J[51]-J[52]-J[53]-J[54]-J[55]+
    J[56]+J[57]+J[58]+J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]+H[1]+H[2]+H[3]+H[4]-H[5]-H[6]+H[7]+
    H[8]+H[9]+H[10]+H[11]+J[0]+J[1]+J[2]+J[3]-J[4]-J[5]+J[6]+J[7]+J[8]+J[9]+J[10]+J[11]+J[12]+J[13]-J[14]-J[15]+
    J[16]+J[17]+J[18]+J[19]+J[20]+J[21]+J[22]-J[23]-J[24]+J[25]+J[26]+J[27]+J[28]+J[29]+J[30]-J[31]-J[32]+
    J[33]+J[34]+J[35]+J[36]+J[37]-J[38]-J[39]+J[40]+J[41]+J[42]+J[43]+J[44]+J[45]-J[46]-J[47]-J[48]-J[49]-J[50]-J[51]-J[52]-J[53]-J[54]-J[55]+
    J[56]+J[57]+J[58]+J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]+H[1]+H[2]+H[3]+H[4]-H[5]-H[6]+H[7]+
    H[8]+H[9]+H[10]-H[11]+J[0]+J[1]+J[2]+J[3]-J[4]-J[5]+J[6]+J[7]+J[8]+J[9]-J[10]+J[11]+J[12]+J[13]-J[14]-J[15]+
    J[16]+J[17]+J[18]+J[19]-J[20]+J[21]+J[22]-J[23]-J[24]+J[25]+J[26]+J[27]+J[28]-J[29]+J[30]-J[31]-J[32]+
    J[33]+J[34]+J[35]+J[36]-J[37]-J[38]-J[39]+J[40]+J[41]+J[42]+J[43]-J[44]+J[45]-J[46]-J[47]-J[48]-J[49]+
    J[50]-J[51]-J[52]-J[53]-J[54]+J[55]+J[56]+J[57]+J[58]-J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]+
    H[1]+H[2]+H[3]+H[4]-H[5]-H[6]+H[7]+H[8]+H[9]-H[10]+H[11]+J[0]+J[1]+J[2]+J[3]-J[4]-J[5]+J[6]+J[7]+J[8]-J[9]+
    J[10]+J[11]+J[12]+J[13]-J[14]-J[15]+J[16]+J[17]+J[18]-J[19]+J[20]+J[21]+J[22]-J[23]-J[24]+J[25]+J[26]+
    J[27]-J[28]+J[29]+J[30]-J[31]-J[32]+J[33]+J[34]+J[35]-J[36]+J[37]-J[38]-J[39]+J[40]+J[41]+J[42]-J[43]+
    J[44]+J[45]-J[46]-J[47]-J[48]+J[49]-J[50]-J[51]-J[52]-J[53]+J[54]-J[55]+J[56]+J[57]-J[58]+J[59]+J[60]-J[61]+
    J[62]-J[63]+J[64]-J[65], +H[0]+H[1]+H[2]+H[3]+H[4]-H[5]-H[6]+H[7]+H[8]+H[9]-H[10]-H[11]+J[0]+J[1]+J[2]+
    J[3]-J[4]-J[5]+J[6]+J[7]+J[8]-J[9]-J[10]+J[11]+J[12]+J[13]-J[14]-J[15]+J[16]+J[17]+J[18]-J[19]-J[20]+
    J[21]+J[22]-J[23]-J[24]+J[25]+J[26]+J[27]-J[28]-J[29]+J[30]-J[31]-J[32]+J[33]+J[34]+J[35]-J[36]-J[37]-J[38]-J[39]+
    J[40]+J[41]+J[42]-J[43]-J[44]+J[45]-J[46]-J[47]-J[48]+J[49]+J[50]-J[51]-J[52]-J[53]+J[54]+J[55]+J[56]+
    J[57]-J[58]-J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]+H[1]+H[2]+H[3]+H[4]-H[5]-H[6]+H[7]+H[8]-H[9]+
    H[10]+H[11]+J[0]+J[1]+J[2]+J[3]-J[4]-J[5]+J[6]+J[7]-J[8]+J[9]+J[10]+J[11]+J[12]+J[13]-J[14]-J[15]+J[16]+
    J[17]-J[18]+J[19]+J[20]+J[21]+J[22]-J[23]-J[24]+J[25]+J[26]-J[27]+J[28]+J[29]+J[30]-J[31]-J[32]+J[33]+
    J[34]-J[35]+J[36]+J[37]-J[38]-J[39]+J[40]+J[41]-J[42]+J[43]+J[44]+J[45]-J[46]-J[47]+J[48]-J[49]-J[50]-J[51]-J[52]+
    J[53]-J[54]-J[55]+J[56]-J[57]+J[58]+J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]+H[1]+H[2]+H[3]+
    H[4]-H[5]-H[6]+H[7]+H[8]-H[9]+H[10]-H[11]+J[0]+J[1]+J[2]+J[3]-J[4]-J[5]+J[6]+J[7]-J[8]+J[9]-J[10]+J[11]+
    J[12]+J[13]-J[14]-J[15]+J[16]+J[17]-J[18]+J[19]-J[20]+J[21]+J[22]-J[23]-J[24]+J[25]+J[26]-J[27]+J[28]-J[29]+
    J[30]-J[31]-J[32]+J[33]+J[34]-J[35]+J[36]-J[37]-J[38]-J[39]+J[40]+J[41]-J[42]+J[43]-J[44]+J[45]-J[46]-J[47]+
    J[48]-J[49]+J[50]-J[51]-J[52]+J[53]-J[54]+J[55]+J[56]-J[57]+J[58]-J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +
    H[0]+H[1]+H[2]+H[3]+H[4]-H[5]-H[6]+H[7]+H[8]-H[9]-H[10]+H[11]+J[0]+J[1]+J[2]+J[3]-J[4]-J[5]+J[6]+J[7]-J[8]-J[9]+
    J[10]+J[11]+J[12]+J[13]-J[14]-J[15]+J[16]+J[17]-J[18]-J[19]+J[20]+J[21]+J[22]-J[23]-J[24]+J[25]+J[26]-J[27]-J[28]+
    J[29]+J[30]-J[31]-J[32]+J[33]+J[34]-J[35]-J[36]+J[37]-J[38]-J[39]+J[40]+J[41]-J[42]-J[43]+J[44]+J[45]-J[46]-J[47]+
    J[48]+J[49]-J[50]-J[51]-J[52]+J[53]+J[54]-J[55]+J[56]-J[57]-J[58]+J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +
    H[0]+H[1]+H[2]+H[3]+H[4]-H[5]-H[6]+H[7]+H[8]-H[9]-H[10]-H[11]+J[0]+J[1]+J[2]+J[3]-J[4]-J[5]+J[6]+J[7]-J[8]-J[9]-J[10]+
    J[11]+J[12]+J[13]-J[14]-J[15]+J[16]+J[17]-J[18]-J[19]-J[20]+J[21]+J[22]-J[23]-J[24]+J[25]+J[26]-J[27]-J[28]-J[29]+
    J[30]-J[31]-J[32]+J[33]+J[34]-J[35]-J[36]-J[37]-J[38]-J[39]+J[40]+J[41]-J[42]-J[43]-J[44]+J[45]-J[46]-J[47]+
    J[48]+J[49]+J[50]-J[51]-J[52]+J[53]+J[54]+J[55]+J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+
    J[65], +H[0]+H[1]+H[2]+H[3]+H[4]-H[5]-H[6]+H[7]-H[8]+H[9]+H[10]+H[11]+J[0]+J[1]+J[2]+J[3]-J[4]-J[5]+
    J[6]-J[7]+J[8]+J[9]+J[10]+J[11]+J[12]+J[13]-J[14]-J[15]+J[16]-J[17]+J[18]+J[19]+J[20]+J[21]+J[22]-J[23]-J[24]+
    J[25]-J[26]+J[27]+J[28]+J[29]+J[30]-J[31]-J[32]+J[33]-J[34]+J[35]+J[36]+J[37]-J[38]-J[39]+J[40]-J[41]+
    J[42]+J[43]+J[44]+J[45]-J[46]+J[47]-J[48]-J[49]-J[50]-J[51]+J[52]-J[53]-J[54]-J[55]-J[56]+J[57]+J[58]+
    J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]+H[1]+H[2]+H[3]+H[4]-H[5]-H[6]+H[7]-H[8]+H[9]+H[10]-H[11]+
    J[0]+J[1]+J[2]+J[3]-J[4]-J[5]+J[6]-J[7]+J[8]+J[9]-J[10]+J[11]+J[12]+J[13]-J[14]-J[15]+J[16]-J[17]+J[18]+
    J[19]-J[20]+J[21]+J[22]-J[23]-J[24]+J[25]-J[26]+J[27]+J[28]-J[29]+J[30]-J[31]-J[32]+J[33]-J[34]+J[35]+
    J[36]-J[37]-J[38]-J[39]+J[40]-J[41]+J[42]+J[43]-J[44]+J[45]-J[46]+J[47]-J[48]-J[49]+J[50]-J[51]+J[52]-J[53]-J[54]+
    J[55]-J[56]+J[57]+J[58]-J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]+H[1]+H[2]+H[3]+H[4]-H[5]-H[6]+
    H[7]-H[8]+H[9]-H[10]+H[11]+J[0]+J[1]+J[2]+J[3]-J[4]-J[5]+J[6]-J[7]+J[8]-J[9]+J[10]+J[11]+J[12]+J[13]-J[14]-J[15]+
    J[16]-J[17]+J[18]-J[19]+J[20]+J[21]+J[22]-J[23]-J[24]+J[25]-J[26]+J[27]-J[28]+J[29]+J[30]-J[31]-J[32]+
    J[33]-J[34]+J[35]-J[36]+J[37]-J[38]-J[39]+J[40]-J[41]+J[42]-J[43]+J[44]+J[45]-J[46]+J[47]-J[48]+J[49]-J[50]-J[51]+
    J[52]-J[53]+J[54]-J[55]-J[56]+J[57]-J[58]+J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]+H[1]+H[2]+
    H[3]+H[4]-H[5]-H[6]+H[7]-H[8]+H[9]-H[10]-H[11]+J[0]+J[1]+J[2]+J[3]-J[4]-J[5]+J[6]-J[7]+J[8]-J[9]-J[10]+
    J[11]+J[12]+J[13]-J[14]-J[15]+J[16]-J[17]+J[18]-J[19]-J[20]+J[21]+J[22]-J[23]-J[24]+J[25]-J[26]+J[27]-J[28]-J[29]+
    J[30]-J[31]-J[32]+J[33]-J[34]+J[35]-J[36]-J[37]-J[38]-J[39]+J[40]-J[41]+J[42]-J[43]-J[44]+J[45]-J[46]+
    J[47]-J[48]+J[49]+J[50]-J[51]+J[52]-J[53]+J[54]+J[55]-J[56]+J[57]-J[58]-J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+
    J[65], +H[0]+H[1]+H[2]+H[3]+H[4]-H[5]-H[6]+H[7]-H[8]-H[9]+H[10]+H[11]+J[0]+J[1]+J[2]+J[3]-J[4]-J[5]+
    J[6]-J[7]-J[8]+J[9]+J[10]+J[11]+J[12]+J[13]-J[14]-J[15]+J[16]-J[17]-J[18]+J[19]+J[20]+J[21]+J[22]-J[23]-J[24]+
    J[25]-J[26]-J[27]+J[28]+J[29]+J[30]-J[31]-J[32]+J[33]-J[34]-J[35]+J[36]+J[37]-J[38]-J[39]+J[40]-J[41]-J[42]+
    J[43]+J[44]+J[45]-J[46]+J[47]+J[48]-J[49]-J[50]-J[51]+J[52]+J[53]-J[54]-J[55]-J[56]-J[57]+J[58]+J[59]+
    J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]+H[1]+H[2]+H[3]+H[4]-H[5]-H[6]+H[7]-H[8]-H[9]+H[10]-H[11]+
    J[0]+J[1]+J[2]+J[3]-J[4]-J[5]+J[6]-J[7]-J[8]+J[9]-J[10]+J[11]+J[12]+J[13]-J[14]-J[15]+J[16]-J[17]-J[18]+
    J[19]-J[20]+J[21]+J[22]-J[23]-J[24]+J[25]-J[26]-J[27]+J[28]-J[29]+J[30]-J[31]-J[32]+J[33]-J[34]-J[35]+
    J[36]-J[37]-J[38]-J[39]+J[40]-J[41]-J[42]+J[43]-J[44]+J[45]-J[46]+J[47]+J[48]-J[49]+J[50]-J[51]+J[52]+
    J[53]-J[54]+J[55]-J[56]-J[57]+J[58]-J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]+H[1]+H[2]+H[3]+
    H[4]-H[5]-H[6]+H[7]-H[8]-H[9]-H[10]+H[11]+J[0]+J[1]+J[2]+J[3]-J[4]-J[5]+J[6]-J[7]-J[8]-J[9]+J[10]+J[11]+
    J[12]+J[13]-J[14]-J[15]+J[16]-J[17]-J[18]-J[19]+J[20]+J[21]+J[22]-J[23]-J[24]+J[25]-J[26]-J[27]-J[28]+
    J[29]+J[30]-J[31]-J[32]+J[33]-J[34]-J[35]-J[36]+J[37]-J[38]-J[39]+J[40]-J[41]-J[42]-J[43]+J[44]+J[45]-J[46]+
    J[47]+J[48]+J[49]-J[50]-J[51]+J[52]+J[53]+J[54]-J[55]-J[56]-J[57]-J[58]+J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +
    H[0]+H[1]+H[2]+H[3]+H[4]-H[5]-H[6]+H[7]-H[8]-H[9]-H[10]-H[11]+J[0]+J[1]+J[2]+J[3]-J[4]-J[5]+J[6]-J[7]-J[8]-J[9]-J[10]+
    J[11]+J[12]+J[13]-J[14]-J[15]+J[16]-J[17]-J[18]-J[19]-J[20]+J[21]+J[22]-J[23]-J[24]+J[25]-J[26]-J[27]-J[28]-J[29]+
    J[30]-J[31]-J[32]+J[33]-J[34]-J[35]-J[36]-J[37]-J[38]-J[39]+J[40]-J[41]-J[42]-J[43]-J[44]+J[45]-J[46]+
    J[47]+J[48]+J[49]+J[50]-J[51]+J[52]+J[53]+J[54]+J[55]-J[56]-J[57]-J[58]-J[59]+J[60]+J[61]+J[62]+J[63]+
    J[64]+J[65], +H[0]+H[1]+H[2]+H[3]+H[4]-H[5]-H[6]-H[7]+H[8]+H[9]+H[10]+H[11]+J[0]+J[1]+J[2]+J[3]-J[4]-J[5]-J[6]+
    J[7]+J[8]+J[9]+J[10]+J[11]+J[12]+J[13]-J[14]-J[15]-J[16]+J[17]+J[18]+J[19]+J[20]+J[21]+J[22]-J[23]-J[24]-J[25]+
    J[26]+J[27]+J[28]+J[29]+J[30]-J[31]-J[32]-J[33]+J[34]+J[35]+J[36]+J[37]-J[38]-J[39]-J[40]+J[41]+J[42]+
    J[43]+J[44]+J[45]+J[46]-J[47]-J[48]-J[49]-J[50]+J[51]-J[52]-J[53]-J[54]-J[55]-J[56]-J[57]-J[58]-J[59]+
    J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]+H[1]+H[2]+H[3]+H[4]-H[5]-H[6]-H[7]+H[8]+H[9]+H[10]-H[11]+
    J[0]+J[1]+J[2]+J[3]-J[4]-J[5]-J[6]+J[7]+J[8]+J[9]-J[10]+J[11]+J[12]+J[13]-J[14]-J[15]-J[16]+J[17]+J[18]+
    J[19]-J[20]+J[21]+J[22]-J[23]-J[24]-J[25]+J[26]+J[27]+J[28]-J[29]+J[30]-J[31]-J[32]-J[33]+J[34]+J[35]+
    J[36]-J[37]-J[38]-J[39]-J[40]+J[41]+J[42]+J[43]-J[44]+J[45]+J[46]-J[47]-J[48]-J[49]+J[50]+J[51]-J[52]-J[53]-J[54]+
    J[55]-J[56]-J[57]-J[58]+J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]+H[1]+H[2]+H[3]+H[4]-H[5]-H[6]-H[7]+
    H[8]+H[9]-H[10]+H[11]+J[0]+J[1]+J[2]+J[3]-J[4]-J[5]-J[6]+J[7]+J[8]-J[9]+J[10]+J[11]+J[12]+J[13]-J[14]-J[15]-J[16]+
    J[17]+J[18]-J[19]+J[20]+J[21]+J[22]-J[23]-J[24]-J[25]+J[26]+J[27]-J[28]+J[29]+J[30]-J[31]-J[32]-J[33]+
    J[34]+J[35]-J[36]+J[37]-J[38]-J[39]-J[40]+J[41]+J[42]-J[43]+J[44]+J[45]+J[46]-J[47]-J[48]+J[49]-J[50]+
    J[51]-J[52]-J[53]+J[54]-J[55]-J[56]-J[57]+J[58]-J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]+H[1]+
    H[2]+H[3]+H[4]-H[5]-H[6]-H[7]+H[8]+H[9]-H[10]-H[11]+J[0]+J[1]+J[2]+J[3]-J[4]-J[5]-J[6]+J[7]+J[8]-J[9]-J[10]+
    J[11]+J[12]+J[13]-J[14]-J[15]-J[16]+J[17]+J[18]-J[19]-J[20]+J[21]+J[22]-J[23]-J[24]-J[25]+J[26]+J[27]-J[28]-J[29]+
    J[30]-J[31]-J[32]-J[33]+J[34]+J[35]-J[36]-J[37]-J[38]-J[39]-J[40]+J[41]+J[42]-J[43]-J[44]+J[45]+J[46]-J[47]-J[48]+
    J[49]+J[50]+J[51]-J[52]-J[53]+J[54]+J[55]-J[56]-J[57]+J[58]+J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +
    H[0]+H[1]+H[2]+H[3]+H[4]-H[5]-H[6]-H[7]+H[8]-H[9]+H[10]+H[11]+J[0]+J[1]+J[2]+J[3]-J[4]-J[5]-J[6]+J[7]-J[8]+
    J[9]+J[10]+J[11]+J[12]+J[13]-J[14]-J[15]-J[16]+J[17]-J[18]+J[19]+J[20]+J[21]+J[22]-J[23]-J[24]-J[25]+
    J[26]-J[27]+J[28]+J[29]+J[30]-J[31]-J[32]-J[33]+J[34]-J[35]+J[36]+J[37]-J[38]-J[39]-J[40]+J[41]-J[42]+
    J[43]+J[44]+J[45]+J[46]-J[47]+J[48]-J[49]-J[50]+J[51]-J[52]+J[53]-J[54]-J[55]-J[56]+J[57]-J[58]-J[59]-J[60]+
    J[61]+J[62]-J[63]-J[64]+J[65], +H[0]+H[1]+H[2]+H[3]+H[4]-H[5]-H[6]-H[7]+H[8]-H[9]+H[10]-H[11]+J[0]+J[1]+
    J[2]+J[3]-J[4]-J[5]-J[6]+J[7]-J[8]+J[9]-J[10]+J[11]+J[12]+J[13]-J[14]-J[15]-J[16]+J[17]-J[18]+J[19]-J[20]+
    J[21]+J[22]-J[23]-J[24]-J[25]+J[26]-J[27]+J[28]-J[29]+J[30]-J[31]-J[32]-J[33]+J[34]-J[35]+J[36]-J[37]-J[38]-J[39]-J[40]+
    J[41]-J[42]+J[43]-J[44]+J[45]+J[46]-J[47]+J[48]-J[49]+J[50]+J[51]-J[52]+J[53]-J[54]+J[55]-J[56]+J[57]-J[58]+
    J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]+H[1]+H[2]+H[3]+H[4]-H[5]-H[6]-H[7]+H[8]-H[9]-H[10]+
    H[11]+J[0]+J[1]+J[2]+J[3]-J[4]-J[5]-J[6]+J[7]-J[8]-J[9]+J[10]+J[11]+J[12]+J[13]-J[14]-J[15]-J[16]+J[17]-J[18]-J[19]+
    J[20]+J[21]+J[22]-J[23]-J[24]-J[25]+J[26]-J[27]-J[28]+J[29]+J[30]-J[31]-J[32]-J[33]+J[34]-J[35]-J[36]+
    J[37]-J[38]-J[39]-J[40]+J[41]-J[42]-J[43]+J[44]+J[45]+J[46]-J[47]+J[48]+J[49]-J[50]+J[51]-J[52]+J[53]+
    J[54]-J[55]-J[56]+J[57]+J[58]-J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]+H[1]+H[2]+H[3]+H[4]-H[5]-H[6]-H[7]+
    H[8]-H[9]-H[10]-H[11]+J[0]+J[1]+J[2]+J[3]-J[4]-J[5]-J[6]+J[7]-J[8]-J[9]-J[10]+J[11]+J[12]+J[13]-J[14]-J[15]-J[16]+
    J[17]-J[18]-J[19]-J[20]+J[21]+J[22]-J[23]-J[24]-J[25]+J[26]-J[27]-J[28]-J[29]+J[30]-J[31]-J[32]-J[33]+
    J[34]-J[35]-J[36]-J[37]-J[38]-J[39]-J[40]+J[41]-J[42]-J[43]-J[44]+J[45]+J[46]-J[47]+J[48]+J[49]+J[50]+
    J[51]-J[52]+J[53]+J[54]+J[55]-J[56]+J[57]+J[58]+J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]+H[1]+
    H[2]+H[3]+H[4]-H[5]-H[6]-H[7]-H[8]+H[9]+H[10]+H[11]+J[0]+J[1]+J[2]+J[3]-J[4]-J[5]-J[6]-J[7]+J[8]+J[9]+
    J[10]+J[11]+J[12]+J[13]-J[14]-J[15]-J[16]-J[17]+J[18]+J[19]+J[20]+J[21]+J[22]-J[23]-J[24]-J[25]-J[26]+
    J[27]+J[28]+J[29]+J[30]-J[31]-J[32]-J[33]-J[34]+J[35]+J[36]+J[37]-J[38]-J[39]-J[40]-J[41]+J[42]+J[43]+
    J[44]+J[45]+J[46]+J[47]-J[48]-J[49]-J[50]+J[51]+J[52]-J[53]-J[54]-J[55]+J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+
    J[63]+J[64]+J[65], +H[0]+H[1]+H[2]+H[3]+H[4]-H[5]-H[6]-H[7]-H[8]+H[9]+H[10]-H[11]+J[0]+J[1]+J[2]+J[3]-J[4]-J[5]-J[6]-J[7]+
    J[8]+J[9]-J[10]+J[11]+J[12]+J[13]-J[14]-J[15]-J[16]-J[17]+J[18]+J[19]-J[20]+J[21]+J[22]-J[23]-J[24]-J[25]-J[26]+
    J[27]+J[28]-J[29]+J[30]-J[31]-J[32]-J[33]-J[34]+J[35]+J[36]-J[37]-J[38]-J[39]-J[40]-J[41]+J[42]+J[43]-J[44]+
    J[45]+J[46]+J[47]-J[48]-J[49]+J[50]+J[51]+J[52]-J[53]-J[54]+J[55]+J[56]-J[57]-J[58]+J[59]-J[60]-J[61]+
    J[62]+J[63]-J[64]-J[65], +H[0]+H[1]+H[2]+H[3]+H[4]-H[5]-H[6]-H[7]-H[8]+H[9]-H[10]+H[11]+J[0]+J[1]+J[2]+
    J[3]-J[4]-J[5]-J[6]-J[7]+J[8]-J[9]+J[10]+J[11]+J[12]+J[13]-J[14]-J[15]-J[16]-J[17]+J[18]-J[19]+J[20]+
    J[21]+J[22]-J[23]-J[24]-J[25]-J[26]+J[27]-J[28]+J[29]+J[30]-J[31]-J[32]-J[33]-J[34]+J[35]-J[36]+J[37]-J[38]-J[39]-J[40]-J[41]+
    J[42]-J[43]+J[44]+J[45]+J[46]+J[47]-J[48]+J[49]-J[50]+J[51]+J[52]-J[53]+J[54]-J[55]+J[56]-J[57]+J[58]-J[59]-J[60]+
    J[61]-J[62]-J[63]+J[64]-J[65], +H[0]+H[1]+H[2]+H[3]+H[4]-H[5]-H[6]-H[7]-H[8]+H[9]-H[10]-H[11]+J[0]+J[1]+
    J[2]+J[3]-J[4]-J[5]-J[6]-J[7]+J[8]-J[9]-J[10]+J[11]+J[12]+J[13]-J[14]-J[15]-J[16]-J[17]+J[18]-J[19]-J[20]+
    J[21]+J[22]-J[23]-J[24]-J[25]-J[26]+J[27]-J[28]-J[29]+J[30]-J[31]-J[32]-J[33]-J[34]+J[35]-J[36]-J[37]-J[38]-J[39]-J[40]-J[41]+
    J[42]-J[43]-J[44]+J[45]+J[46]+J[47]-J[48]+J[49]+J[50]+J[51]+J[52]-J[53]+J[54]+J[55]+J[56]-J[57]+J[58]+
    J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]+H[1]+H[2]+H[3]+H[4]-H[5]-H[6]-H[7]-H[8]-H[9]+H[10]+
    H[11]+J[0]+J[1]+J[2]+J[3]-J[4]-J[5]-J[6]-J[7]-J[8]+J[9]+J[10]+J[11]+J[12]+J[13]-J[14]-J[15]-J[16]-J[17]-J[18]+
    J[19]+J[20]+J[21]+J[22]-J[23]-J[24]-J[25]-J[26]-J[27]+J[28]+J[29]+J[30]-J[31]-J[32]-J[33]-J[34]-J[35]+
    J[36]+J[37]-J[38]-J[39]-J[40]-J[41]-J[42]+J[43]+J[44]+J[45]+J[46]+J[47]+J[48]-J[49]-J[50]+J[51]+J[52]+
    J[53]-J[54]-J[55]+J[56]+J[57]-J[58]-J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]+H[1]+H[2]+H[3]+
    H[4]-H[5]-H[6]-H[7]-H[8]-H[9]+H[10]-H[11]+J[0]+J[1]+J[2]+J[3]-J[4]-J[5]-J[6]-J[7]-J[8]+J[9]-J[10]+J[11]+
    J[12]+J[13]-J[14]-J[15]-J[16]-J[17]-J[18]+J[19]-J[20]+J[21]+J[22]-J[23]-J[24]-J[25]-J[26]-J[27]+J[28]-J[29]+
    J[30]-J[31]-J[32]-J[33]-J[34]-J[35]+J[36]-J[37]-J[38]-J[39]-J[40]-J[41]-J[42]+J[43]-J[44]+J[45]+J[46]+
    J[47]+J[48]-J[49]+J[50]+J[51]+J[52]+J[53]-J[54]+J[55]+J[56]+J[57]-J[58]+J[59]+J[60]-J[61]+J[62]-J[63]+
    J[64]-J[65], +H[0]+H[1]+H[2]+H[3]+H[4]-H[5]-H[6]-H[7]-H[8]-H[9]-H[10]+H[11]+J[0]+J[1]+J[2]+J[3]-J[4]-J[5]-J[6]-J[7]-J[8]-J[9]+
    J[10]+J[11]+J[12]+J[13]-J[14]-J[15]-J[16]-J[17]-J[18]-J[19]+J[20]+J[21]+J[22]-J[23]-J[24]-J[25]-J[26]-J[27]-J[28]+
    J[29]+J[30]-J[31]-J[32]-J[33]-J[34]-J[35]-J[36]+J[37]-J[38]-J[39]-J[40]-J[41]-J[42]-J[43]+J[44]+J[45]+
    J[46]+J[47]+J[48]+J[49]-J[50]+J[51]+J[52]+J[53]+J[54]-J[55]+J[56]+J[57]+J[58]-J[59]+J[60]+J[61]-J[62]+
    J[63]-J[64]-J[65], +H[0]+H[1]+H[2]+H[3]+H[4]-H[5]-H[6]-H[7]-H[8]-H[9]-H[10]-H[11]+J[0]+J[1]+J[2]+J[3]-J[4]-J[5]-J[6]-J[7]-J[8]-J[9]-J[10]+
    J[11]+J[12]+J[13]-J[14]-J[15]-J[16]-J[17]-J[18]-J[19]-J[20]+J[21]+J[22]-J[23]-J[24]-J[25]-J[26]-J[27]-J[28]-J[29]+
    J[30]-J[31]-J[32]-J[33]-J[34]-J[35]-J[36]-J[37]-J[38]-J[39]-J[40]-J[41]-J[42]-J[43]-J[44]+J[45]+J[46]+
    J[47]+J[48]+J[49]+J[50]+J[51]+J[52]+J[53]+J[54]+J[55]+J[56]+J[57]+J[58]+J[59]+J[60]+J[61]+J[62]+J[63]+
    J[64]+J[65], +H[0]+H[1]+H[2]+H[3]-H[4]+H[5]+H[6]+H[7]+H[8]+H[9]+H[10]+H[11]+J[0]+J[1]+J[2]-J[3]+J[4]+
    J[5]+J[6]+J[7]+J[8]+J[9]+J[10]+J[11]+J[12]-J[13]+J[14]+J[15]+J[16]+J[17]+J[18]+J[19]+J[20]+J[21]-J[22]+
    J[23]+J[24]+J[25]+J[26]+J[27]+J[28]+J[29]-J[30]+J[31]+J[32]+J[33]+J[34]+J[35]+J[36]+J[37]-J[38]-J[39]-J[40]-J[41]-J[42]-J[43]-J[44]+
    J[45]+J[46]+J[47]+J[48]+J[49]+J[50]+J[51]+J[52]+J[53]+J[54]+J[55]+J[56]+J[57]+J[58]+J[59]+J[60]+J[61]+
    J[62]+J[63]+J[64]+J[65], +H[0]+H[1]+H[2]+H[3]-H[4]+H[5]+H[6]+H[7]+H[8]+H[9]+H[10]-H[11]+J[0]+J[1]+J[2]-J[3]+
    J[4]+J[5]+J[6]+J[7]+J[8]+J[9]-J[10]+J[11]+J[12]-J[13]+J[14]+J[15]+J[16]+J[17]+J[18]+J[19]-J[20]+J[21]-J[22]+
    J[23]+J[24]+J[25]+J[26]+J[27]+J[28]-J[29]-J[30]+J[31]+J[32]+J[33]+J[34]+J[35]+J[36]-J[37]-J[38]-J[39]-J[40]-J[41]-J[42]-J[43]+
    J[44]+J[45]+J[46]+J[47]+J[48]+J[49]-J[50]+J[51]+J[52]+J[53]+J[54]-J[55]+J[56]+J[57]+J[58]-J[59]+J[60]+
    J[61]-J[62]+J[63]-J[64]-J[65], +H[0]+H[1]+H[2]+H[3]-H[4]+H[5]+H[6]+H[7]+H[8]+H[9]-H[10]+H[11]+J[0]+J[1]+
    J[2]-J[3]+J[4]+J[5]+J[6]+J[7]+J[8]-J[9]+J[10]+J[11]+J[12]-J[13]+J[14]+J[15]+J[16]+J[17]+J[18]-J[19]+
    J[20]+J[21]-J[22]+J[23]+J[24]+J[25]+J[26]+J[27]-J[28]+J[29]-J[30]+J[31]+J[32]+J[33]+J[34]+J[35]-J[36]+
    J[37]-J[38]-J[39]-J[40]-J[41]-J[42]+J[43]-J[44]+J[45]+J[46]+J[47]+J[48]-J[49]+J[50]+J[51]+J[52]+J[53]-J[54]+
    J[55]+J[56]+J[57]-J[58]+J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]+H[1]+H[2]+H[3]-H[4]+H[5]+H[6]+
    H[7]+H[8]+H[9]-H[10]-H[11]+J[0]+J[1]+J[2]-J[3]+J[4]+J[5]+J[6]+J[7]+J[8]-J[9]-J[10]+J[11]+J[12]-J[13]+
    J[14]+J[15]+J[16]+J[17]+J[18]-J[19]-J[20]+J[21]-J[22]+J[23]+J[24]+J[25]+J[26]+J[27]-J[28]-J[29]-J[30]+
    J[31]+J[32]+J[33]+J[34]+J[35]-J[36]-J[37]-J[38]-J[39]-J[40]-J[41]-J[42]+J[43]+J[44]+J[45]+J[46]+J[47]+
    J[48]-J[49]-J[50]+J[51]+J[52]+J[53]-J[54]-J[55]+J[56]+J[57]-J[58]-J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+
    J[65], +H[0]+H[1]+H[2]+H[3]-H[4]+H[5]+H[6]+H[7]+H[8]-H[9]+H[10]+H[11]+J[0]+J[1]+J[2]-J[3]+J[4]+J[5]+
    J[6]+J[7]-J[8]+J[9]+J[10]+J[11]+J[12]-J[13]+J[14]+J[15]+J[16]+J[17]-J[18]+J[19]+J[20]+J[21]-J[22]+J[23]+
    J[24]+J[25]+J[26]-J[27]+J[28]+J[29]-J[30]+J[31]+J[32]+J[33]+J[34]-J[35]+J[36]+J[37]-J[38]-J[39]-J[40]-J[41]+
    J[42]-J[43]-J[44]+J[45]+J[46]+J[47]-J[48]+J[49]+J[50]+J[51]+J[52]-J[53]+J[54]+J[55]+J[56]-J[57]+J[58]+
    J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]+H[1]+H[2]+H[3]-H[4]+H[5]+H[6]+H[7]+H[8]-H[9]+H[10]-H[11]+
    J[0]+J[1]+J[2]-J[3]+J[4]+J[5]+J[6]+J[7]-J[8]+J[9]-J[10]+J[11]+J[12]-J[13]+J[14]+J[15]+J[16]+J[17]-J[18]+
    J[19]-J[20]+J[21]-J[22]+J[23]+J[24]+J[25]+J[26]-J[27]+J[28]-J[29]-J[30]+J[31]+J[32]+J[33]+J[34]-J[35]+
    J[36]-J[37]-J[38]-J[39]-J[40]-J[41]+J[42]-J[43]+J[44]+J[45]+J[46]+J[47]-J[48]+J[49]-J[50]+J[51]+J[52]-J[53]+
    J[54]-J[55]+J[56]-J[57]+J[58]-J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]+H[1]+H[2]+H[3]-H[4]+H[5]+
    H[6]+H[7]+H[8]-H[9]-H[10]+H[11]+J[0]+J[1]+J[2]-J[3]+J[4]+J[5]+J[6]+J[7]-J[8]-J[9]+J[10]+J[11]+J[12]-J[13]+
    J[14]+J[15]+J[16]+J[17]-J[18]-J[19]+J[20]+J[21]-J[22]+J[23]+J[24]+J[25]+J[26]-J[27]-J[28]+J[29]-J[30]+
    J[31]+J[32]+J[33]+J[34]-J[35]-J[36]+J[37]-J[38]-J[39]-J[40]-J[41]+J[42]+J[43]-J[44]+J[45]+J[46]+J[47]-J[48]-J[49]+
    J[50]+J[51]+J[52]-J[53]-J[54]+J[55]+J[56]-J[57]-J[58]+J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]+
    H[1]+H[2]+H[3]-H[4]+H[5]+H[6]+H[7]+H[8]-H[9]-H[10]-H[11]+J[0]+J[1]+J[2]-J[3]+J[4]+J[5]+J[6]+J[7]-J[8]-J[9]-J[10]+
    J[11]+J[12]-J[13]+J[14]+J[15]+J[16]+J[17]-J[18]-J[19]-J[20]+J[21]-J[22]+J[23]+J[24]+J[25]+J[26]-J[27]-J[28]-J[29]-J[30]+
    J[31]+J[32]+J[33]+J[34]-J[35]-J[36]-J[37]-J[38]-J[39]-J[40]-J[41]+J[42]+J[43]+J[44]+J[45]+J[46]+J[47]-J[48]-J[49]-J[50]+
    J[51]+J[52]-J[53]-J[54]-J[55]+J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]+H[1]+
    H[2]+H[3]-H[4]+H[5]+H[6]+H[7]-H[8]+H[9]+H[10]+H[11]+J[0]+J[1]+J[2]-J[3]+J[4]+J[5]+J[6]-J[7]+J[8]+J[9]+
    J[10]+J[11]+J[12]-J[13]+J[14]+J[15]+J[16]-J[17]+J[18]+J[19]+J[20]+J[21]-J[22]+J[23]+J[24]+J[25]-J[26]+
    J[27]+J[28]+J[29]-J[30]+J[31]+J[32]+J[33]-J[34]+J[35]+J[36]+J[37]-J[38]-J[39]-J[40]+J[41]-J[42]-J[43]-J[44]+
    J[45]+J[46]-J[47]+J[48]+J[49]+J[50]+J[51]-J[52]+J[53]+J[54]+J[55]-J[56]+J[57]+J[58]+J[59]-J[60]-J[61]-J[62]+
    J[63]+J[64]+J[65], +H[0]+H[1]+H[2]+H[3]-H[4]+H[5]+H[6]+H[7]-H[8]+H[9]+H[10]-H[11]+J[0]+J[1]+J[2]-J[3]+
    J[4]+J[5]+J[6]-J[7]+J[8]+J[9]-J[10]+J[11]+J[12]-J[13]+J[14]+J[15]+J[16]-J[17]+J[18]+J[19]-J[20]+J[21]-J[22]+
    J[23]+J[24]+J[25]-J[26]+J[27]+J[28]-J[29]-J[30]+J[31]+J[32]+J[33]-J[34]+J[35]+J[36]-J[37]-J[38]-J[39]-J[40]+
    J[41]-J[42]-J[43]+J[44]+J[45]+J[46]-J[47]+J[48]+J[49]-J[50]+J[51]-J[52]+J[53]+J[54]-J[55]-J[56]+J[57]+
    J[58]-J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]+H[1]+H[2]+H[3]-H[4]+H[5]+H[6]+H[7]-H[8]+H[9]-H[10]+
    H[11]+J[0]+J[1]+J[2]-J[3]+J[4]+J[5]+J[6]-J[7]+J[8]-J[9]+J[10]+J[11]+J[12]-J[13]+J[14]+J[15]+J[16]-J[17]+
    J[18]-J[19]+J[20]+J[21]-J[22]+J[23]+J[24]+J[25]-J[26]+J[27]-J[28]+J[29]-J[30]+J[31]+J[32]+J[33]-J[34]+
    J[35]-J[36]+J[37]-J[38]-J[39]-J[40]+J[41]-J[42]+J[43]-J[44]+J[45]+J[46]-J[47]+J[48]-J[49]+J[50]+J[51]-J[52]+
    J[53]-J[54]+J[55]-J[56]+J[57]-J[58]+J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]+H[1]+H[2]+H[3]-H[4]+
    H[5]+H[6]+H[7]-H[8]+H[9]-H[10]-H[11]+J[0]+J[1]+J[2]-J[3]+J[4]+J[5]+J[6]-J[7]+J[8]-J[9]-J[10]+J[11]+J[12]-J[13]+
    J[14]+J[15]+J[16]-J[17]+J[18]-J[19]-J[20]+J[21]-J[22]+J[23]+J[24]+J[25]-J[26]+J[27]-J[28]-J[29]-J[30]+
    J[31]+J[32]+J[33]-J[34]+J[35]-J[36]-J[37]-J[38]-J[39]-J[40]+J[41]-J[42]+J[43]+J[44]+J[45]+J[46]-J[47]+
    J[48]-J[49]-J[50]+J[51]-J[52]+J[53]-J[54]-J[55]-J[56]+J[57]-J[58]-J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+
    J[65], +H[0]+H[1]+H[2]+H[3]-H[4]+H[5]+H[6]+H[7]-H[8]-H[9]+H[10]+H[11]+J[0]+J[1]+J[2]-J[3]+J[4]+J[5]+
    J[6]-J[7]-J[8]+J[9]+J[10]+J[11]+J[12]-J[13]+J[14]+J[15]+J[16]-J[17]-J[18]+J[19]+J[20]+J[21]-J[22]+J[23]+
    J[24]+J[25]-J[26]-J[27]+J[28]+J[29]-J[30]+J[31]+J[32]+J[33]-J[34]-J[35]+J[36]+J[37]-J[38]-J[39]-J[40]+
    J[41]+J[42]-J[43]-J[44]+J[45]+J[46]-J[47]-J[48]+J[49]+J[50]+J[51]-J[52]-J[53]+J[54]+J[55]-J[56]-J[57]+
    J[58]+J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]+H[1]+H[2]+H[3]-H[4]+H[5]+H[6]+H[7]-H[8]-H[9]+
    H[10]-H[11]+J[0]+J[1]+J[2]-J[3]+J[4]+J[5]+J[6]-J[7]-J[8]+J[9]-J[10]+J[11]+J[12]-J[13]+J[14]+J[15]+J[16]-J[17]-J[18]+
    J[19]-J[20]+J[21]-J[22]+J[23]+J[24]+J[25]-J[26]-J[27]+J[28]-J[29]-J[30]+J[31]+J[32]+J[33]-J[34]-J[35]+
    J[36]-J[37]-J[38]-J[39]-J[40]+J[41]+J[42]-J[43]+J[44]+J[45]+J[46]-J[47]-J[48]+J[49]-J[50]+J[51]-J[52]-J[53]+
    J[54]-J[55]-J[56]-J[57]+J[58]-J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]+H[1]+H[2]+H[3]-H[4]+H[5]+
    H[6]+H[7]-H[8]-H[9]-H[10]+H[11]+J[0]+J[1]+J[2]-J[3]+J[4]+J[5]+J[6]-J[7]-J[8]-J[9]+J[10]+J[11]+J[12]-J[13]+
    J[14]+J[15]+J[16]-J[17]-J[18]-J[19]+J[20]+J[21]-J[22]+J[23]+J[24]+J[25]-J[26]-J[27]-J[28]+J[29]-J[30]+
    J[31]+J[32]+J[33]-J[34]-J[35]-J[36]+J[37]-J[38]-J[39]-J[40]+J[41]+J[42]+J[43]-J[44]+J[45]+J[46]-J[47]-J[48]-J[49]+
    J[50]+J[51]-J[52]-J[53]-J[54]+J[55]-J[56]-J[57]-J[58]+J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]+
    H[1]+H[2]+H[3]-H[4]+H[5]+H[6]+H[7]-H[8]-H[9]-H[10]-H[11]+J[0]+J[1]+J[2]-J[3]+J[4]+J[5]+J[6]-J[7]-J[8]-J[9]-J[10]+
    J[11]+J[12]-J[13]+J[14]+J[15]+J[16]-J[17]-J[18]-J[19]-J[20]+J[21]-J[22]+J[23]+J[24]+J[25]-J[26]-J[27]-J[28]-J[29]-J[30]+
    J[31]+J[32]+J[33]-J[34]-J[35]-J[36]-J[37]-J[38]-J[39]-J[40]+J[41]+J[42]+J[43]+J[44]+J[45]+J[46]-J[47]-J[48]-J[49]-J[50]+
    J[51]-J[52]-J[53]-J[54]-J[55]-J[56]-J[57]-J[58]-J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]+H[1]+
    H[2]+H[3]-H[4]+H[5]+H[6]-H[7]+H[8]+H[9]+H[10]+H[11]+J[0]+J[1]+J[2]-J[3]+J[4]+J[5]-J[6]+J[7]+J[8]+J[9]+
    J[10]+J[11]+J[12]-J[13]+J[14]+J[15]-J[16]+J[17]+J[18]+J[19]+J[20]+J[21]-J[22]+J[23]+J[24]-J[25]+J[26]+
    J[27]+J[28]+J[29]-J[30]+J[31]+J[32]-J[33]+J[34]+J[35]+J[36]+J[37]-J[38]-J[39]+J[40]-J[41]-J[42]-J[43]-J[44]+
    J[45]-J[46]+J[47]+J[48]+J[49]+J[50]-J[51]+J[52]+J[53]+J[54]+J[55]-J[56]-J[57]-J[58]-J[59]+J[60]+J[61]+
    J[62]+J[63]+J[64]+J[65], +H[0]+H[1]+H[2]+H[3]-H[4]+H[5]+H[6]-H[7]+H[8]+H[9]+H[10]-H[11]+J[0]+J[1]+J[2]-J[3]+
    J[4]+J[5]-J[6]+J[7]+J[8]+J[9]-J[10]+J[11]+J[12]-J[13]+J[14]+J[15]-J[16]+J[17]+J[18]+J[19]-J[20]+J[21]-J[22]+
    J[23]+J[24]-J[25]+J[26]+J[27]+J[28]-J[29]-J[30]+J[31]+J[32]-J[33]+J[34]+J[35]+J[36]-J[37]-J[38]-J[39]+
    J[40]-J[41]-J[42]-J[43]+J[44]+J[45]-J[46]+J[47]+J[48]+J[49]-J[50]-J[51]+J[52]+J[53]+J[54]-J[55]-J[56]-J[57]-J[58]+
    J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]+H[1]+H[2]+H[3]-H[4]+H[5]+H[6]-H[7]+H[8]+H[9]-H[10]+
    H[11]+J[0]+J[1]+J[2]-J[3]+J[4]+J[5]-J[6]+J[7]+J[8]-J[9]+J[10]+J[11]+J[12]-J[13]+J[14]+J[15]-J[16]+J[17]+
    J[18]-J[19]+J[20]+J[21]-J[22]+J[23]+J[24]-J[25]+J[26]+J[27]-J[28]+J[29]-J[30]+J[31]+J[32]-J[33]+J[34]+
    J[35]-J[36]+J[37]-J[38]-J[39]+J[40]-J[41]-J[42]+J[43]-J[44]+J[45]-J[46]+J[47]+J[48]-J[49]+J[50]-J[51]+
    J[52]+J[53]-J[54]+J[55]-J[56]-J[57]+J[58]-J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]+H[1]+H[2]+
    H[3]-H[4]+H[5]+H[6]-H[7]+H[8]+H[9]-H[10]-H[11]+J[0]+J[1]+J[2]-J[3]+J[4]+J[5]-J[6]+J[7]+J[8]-J[9]-J[10]+
    J[11]+J[12]-J[13]+J[14]+J[15]-J[16]+J[17]+J[18]-J[19]-J[20]+J[21]-J[22]+J[23]+J[24]-J[25]+J[26]+J[27]-J[28]-J[29]-J[30]+
    J[31]+J[32]-J[33]+J[34]+J[35]-J[36]-J[37]-J[38]-J[39]+J[40]-J[41]-J[42]+J[43]+J[44]+J[45]-J[46]+J[47]+
    J[48]-J[49]-J[50]-J[51]+J[52]+J[53]-J[54]-J[55]-J[56]-J[57]+J[58]+J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+
    J[65], +H[0]+H[1]+H[2]+H[3]-H[4]+H[5]+H[6]-H[7]+H[8]-H[9]+H[10]+H[11]+J[0]+J[1]+J[2]-J[3]+J[4]+J[5]-J[6]+
    J[7]-J[8]+J[9]+J[10]+J[11]+J[12]-J[13]+J[14]+J[15]-J[16]+J[17]-J[18]+J[19]+J[20]+J[21]-J[22]+J[23]+J[24]-J[25]+
    J[26]-J[27]+J[28]+J[29]-J[30]+J[31]+J[32]-J[33]+J[34]-J[35]+J[36]+J[37]-J[38]-J[39]+J[40]-J[41]+J[42]-J[43]-J[44]+
    J[45]-J[46]+J[47]-J[48]+J[49]+J[50]-J[51]+J[52]-J[53]+J[54]+J[55]-J[56]+J[57]-J[58]-J[59]-J[60]+J[61]+
    J[62]-J[63]-J[64]+J[65], +H[0]+H[1]+H[2]+H[3]-H[4]+H[5]+H[6]-H[7]+H[8]-H[9]+H[10]-H[11]+J[0]+J[1]+J[2]-J[3]+
    J[4]+J[5]-J[6]+J[7]-J[8]+J[9]-J[10]+J[11]+J[12]-J[13]+J[14]+J[15]-J[16]+J[17]-J[18]+J[19]-J[20]+J[21]-J[22]+
    J[23]+J[24]-J[25]+J[26]-J[27]+J[28]-J[29]-J[30]+J[31]+J[32]-J[33]+J[34]-J[35]+J[36]-J[37]-J[38]-J[39]+
    J[40]-J[41]+J[42]-J[43]+J[44]+J[45]-J[46]+J[47]-J[48]+J[49]-J[50]-J[51]+J[52]-J[53]+J[54]-J[55]-J[56]+
    J[57]-J[58]+J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]+H[1]+H[2]+H[3]-H[4]+H[5]+H[6]-H[7]+H[8]-H[9]-H[10]+
    H[11]+J[0]+J[1]+J[2]-J[3]+J[4]+J[5]-J[6]+J[7]-J[8]-J[9]+J[10]+J[11]+J[12]-J[13]+J[14]+J[15]-J[16]+J[17]-J[18]-J[19]+
    J[20]+J[21]-J[22]+J[23]+J[24]-J[25]+J[26]-J[27]-J[28]+J[29]-J[30]+J[31]+J[32]-J[33]+J[34]-J[35]-J[36]+
    J[37]-J[38]-J[39]+J[40]-J[41]+J[42]+J[43]-J[44]+J[45]-J[46]+J[47]-J[48]-J[49]+J[50]-J[51]+J[52]-J[53]-J[54]+
    J[55]-J[56]+J[57]+J[58]-J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]+H[1]+H[2]+H[3]-H[4]+H[5]+H[6]-H[7]+
    H[8]-H[9]-H[10]-H[11]+J[0]+J[1]+J[2]-J[3]+J[4]+J[5]-J[6]+J[7]-J[8]-J[9]-J[10]+J[11]+J[12]-J[13]+J[14]+
    J[15]-J[16]+J[17]-J[18]-J[19]-J[20]+J[21]-J[22]+J[23]+J[24]-J[25]+J[26]-J[27]-J[28]-J[29]-J[30]+J[31]+
    J[32]-J[33]+J[34]-J[35]-J[36]-J[37]-J[38]-J[39]+J[40]-J[41]+J[42]+J[43]+J[44]+J[45]-J[46]+J[47]-J[48]-J[49]-J[50]-J[51]+
    J[52]-J[53]-J[54]-J[55]-J[56]+J[57]+J[58]+J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]+H[1]+H[2]+
    H[3]-H[4]+H[5]+H[6]-H[7]-H[8]+H[9]+H[10]+H[11]+J[0]+J[1]+J[2]-J[3]+J[4]+J[5]-J[6]-J[7]+J[8]+J[9]+J[10]+
    J[11]+J[12]-J[13]+J[14]+J[15]-J[16]-J[17]+J[18]+J[19]+J[20]+J[21]-J[22]+J[23]+J[24]-J[25]-J[26]+J[27]+
    J[28]+J[29]-J[30]+J[31]+J[32]-J[33]-J[34]+J[35]+J[36]+J[37]-J[38]-J[39]+J[40]+J[41]-J[42]-J[43]-J[44]+
    J[45]-J[46]-J[47]+J[48]+J[49]+J[50]-J[51]-J[52]+J[53]+J[54]+J[55]+J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+
    J[63]+J[64]+J[65], +H[0]+H[1]+H[2]+H[3]-H[4]+H[5]+H[6]-H[7]-H[8]+H[9]+H[10]-H[11]+J[0]+J[1]+J[2]-J[3]+
    J[4]+J[5]-J[6]-J[7]+J[8]+J[9]-J[10]+J[11]+J[12]-J[13]+J[14]+J[15]-J[16]-J[17]+J[18]+J[19]-J[20]+J[21]-J[22]+
    J[23]+J[24]-J[25]-J[26]+J[27]+J[28]-J[29]-J[30]+J[31]+J[32]-J[33]-J[34]+J[35]+J[36]-J[37]-J[38]-J[39]+
    J[40]+J[41]-J[42]-J[43]+J[44]+J[45]-J[46]-J[47]+J[48]+J[49]-J[50]-J[51]-J[52]+J[53]+J[54]-J[55]+J[56]-J[57]-J[58]+
    J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]+H[1]+H[2]+H[3]-H[4]+H[5]+H[6]-H[7]-H[8]+H[9]-H[10]+
    H[11]+J[0]+J[1]+J[2]-J[3]+J[4]+J[5]-J[6]-J[7]+J[8]-J[9]+J[10]+J[11]+J[12]-J[13]+J[14]+J[15]-J[16]-J[17]+
    J[18]-J[19]+J[20]+J[21]-J[22]+J[23]+J[24]-J[25]-J[26]+J[27]-J[28]+J[29]-J[30]+J[31]+J[32]-J[33]-J[34]+
    J[35]-J[36]+J[37]-J[38]-J[39]+J[40]+J[41]-J[42]+J[43]-J[44]+J[45]-J[46]-J[47]+J[48]-J[49]+J[50]-J[51]-J[52]+
    J[53]-J[54]+J[55]+J[56]-J[57]+J[58]-J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]+H[1]+H[2]+H[3]-H[4]+
    H[5]+H[6]-H[7]-H[8]+H[9]-H[10]-H[11]+J[0]+J[1]+J[2]-J[3]+J[4]+J[5]-J[6]-J[7]+J[8]-J[9]-J[10]+J[11]+J[12]-J[13]+
    J[14]+J[15]-J[16]-J[17]+J[18]-J[19]-J[20]+J[21]-J[22]+J[23]+J[24]-J[25]-J[26]+J[27]-J[28]-J[29]-J[30]+
    J[31]+J[32]-J[33]-J[34]+J[35]-J[36]-J[37]-J[38]-J[39]+J[40]+J[41]-J[42]+J[43]+J[44]+J[45]-J[46]-J[47]+
    J[48]-J[49]-J[50]-J[51]-J[52]+J[53]-J[54]-J[55]+J[56]-J[57]+J[58]+J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+
    J[65], +H[0]+H[1]+H[2]+H[3]-H[4]+H[5]+H[6]-H[7]-H[8]-H[9]+H[10]+H[11]+J[0]+J[1]+J[2]-J[3]+J[4]+J[5]-J[6]-J[7]-J[8]+
    J[9]+J[10]+J[11]+J[12]-J[13]+J[14]+J[15]-J[16]-J[17]-J[18]+J[19]+J[20]+J[21]-J[22]+J[23]+J[24]-J[25]-J[26]-J[27]+
    J[28]+J[29]-J[30]+J[31]+J[32]-J[33]-J[34]-J[35]+J[36]+J[37]-J[38]-J[39]+J[40]+J[41]+J[42]-J[43]-J[44]+
    J[45]-J[46]-J[47]-J[48]+J[49]+J[50]-J[51]-J[52]-J[53]+J[54]+J[55]+J[56]+J[57]-J[58]-J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+
    J[65], +H[0]+H[1]+H[2]+H[3]-H[4]+H[5]+H[6]-H[7]-H[8]-H[9]+H[10]-H[11]+J[0]+J[1]+J[2]-J[3]+J[4]+J[5]-J[6]-J[7]-J[8]+
    J[9]-J[10]+J[11]+J[12]-J[13]+J[14]+J[15]-J[16]-J[17]-J[18]+J[19]-J[20]+J[21]-J[22]+J[23]+J[24]-J[25]-J[26]-J[27]+
    J[28]-J[29]-J[30]+J[31]+J[32]-J[33]-J[34]-J[35]+J[36]-J[37]-J[38]-J[39]+J[40]+J[41]+J[42]-J[43]+J[44]+
    J[45]-J[46]-J[47]-J[48]+J[49]-J[50]-J[51]-J[52]-J[53]+J[54]-J[55]+J[56]+J[57]-J[58]+J[59]+J[60]-J[61]+
    J[62]-J[63]+J[64]-J[65], +H[0]+H[1]+H[2]+H[3]-H[4]+H[5]+H[6]-H[7]-H[8]-H[9]-H[10]+H[11]+J[0]+J[1]+J[2]-J[3]+
    J[4]+J[5]-J[6]-J[7]-J[8]-J[9]+J[10]+J[11]+J[12]-J[13]+J[14]+J[15]-J[16]-J[17]-J[18]-J[19]+J[20]+J[21]-J[22]+
    J[23]+J[24]-J[25]-J[26]-J[27]-J[28]+J[29]-J[30]+J[31]+J[32]-J[33]-J[34]-J[35]-J[36]+J[37]-J[38]-J[39]+
    J[40]+J[41]+J[42]+J[43]-J[44]+J[45]-J[46]-J[47]-J[48]-J[49]+J[50]-J[51]-J[52]-J[53]-J[54]+J[55]+J[56]+
    J[57]+J[58]-J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]+H[1]+H[2]+H[3]-H[4]+H[5]+H[6]-H[7]-H[8]-H[9]-H[10]-H[11]+
    J[0]+J[1]+J[2]-J[3]+J[4]+J[5]-J[6]-J[7]-J[8]-J[9]-J[10]+J[11]+J[12]-J[13]+J[14]+J[15]-J[16]-J[17]-J[18]-J[19]-J[20]+
    J[21]-J[22]+J[23]+J[24]-J[25]-J[26]-J[27]-J[28]-J[29]-J[30]+J[31]+J[32]-J[33]-J[34]-J[35]-J[36]-J[37]-J[38]-J[39]+
    J[40]+J[41]+J[42]+J[43]+J[44]+J[45]-J[46]-J[47]-J[48]-J[49]-J[50]-J[51]-J[52]-J[53]-J[54]-J[55]+J[56]+
    J[57]+J[58]+J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]+H[1]+H[2]+H[3]-H[4]+H[5]-H[6]+H[7]+H[8]+
    H[9]+H[10]+H[11]+J[0]+J[1]+J[2]-J[3]+J[4]-J[5]+J[6]+J[7]+J[8]+J[9]+J[10]+J[11]+J[12]-J[13]+J[14]-J[15]+
    J[16]+J[17]+J[18]+J[19]+J[20]+J[21]-J[22]+J[23]-J[24]+J[25]+J[26]+J[27]+J[28]+J[29]-J[30]+J[31]-J[32]+
    J[33]+J[34]+J[35]+J[36]+J[37]-J[38]+J[39]-J[40]-J[41]-J[42]-J[43]-J[44]-J[45]+J[46]+J[47]+J[48]+J[49]+
    J[50]-J[51]-J[52]-J[53]-J[54]-J[55]+J[56]+J[57]+J[58]+J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]+
    H[1]+H[2]+H[3]-H[4]+H[5]-H[6]+H[7]+H[8]+H[9]+H[10]-H[11]+J[0]+J[1]+J[2]-J[3]+J[4]-J[5]+J[6]+J[7]+J[8]+
    J[9]-J[10]+J[11]+J[12]-J[13]+J[14]-J[15]+J[16]+J[17]+J[18]+J[19]-J[20]+J[21]-J[22]+J[23]-J[24]+J[25]+
    J[26]+J[27]+J[28]-J[29]-J[30]+J[31]-J[32]+J[33]+J[34]+J[35]+J[36]-J[37]-J[38]+J[39]-J[40]-J[41]-J[42]-J[43]+
    J[44]-J[45]+J[46]+J[47]+J[48]+J[49]-J[50]-J[51]-J[52]-J[53]-J[54]+J[55]+J[56]+J[57]+J[58]-J[59]+J[60]+
    J[61]-J[62]+J[63]-J[64]-J[65], +H[0]+H[1]+H[2]+H[3]-H[4]+H[5]-H[6]+H[7]+H[8]+H[9]-H[10]+H[11]+J[0]+J[1]+
    J[2]-J[3]+J[4]-J[5]+J[6]+J[7]+J[8]-J[9]+J[10]+J[11]+J[12]-J[13]+J[14]-J[15]+J[16]+J[17]+J[18]-J[19]+
    J[20]+J[21]-J[22]+J[23]-J[24]+J[25]+J[26]+J[27]-J[28]+J[29]-J[30]+J[31]-J[32]+J[33]+J[34]+J[35]-J[36]+
    J[37]-J[38]+J[39]-J[40]-J[41]-J[42]+J[43]-J[44]-J[45]+J[46]+J[47]+J[48]-J[49]+J[50]-J[51]-J[52]-J[53]+
    J[54]-J[55]+J[56]+J[57]-J[58]+J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]+H[1]+H[2]+H[3]-H[4]+H[5]-H[6]+
    H[7]+H[8]+H[9]-H[10]-H[11]+J[0]+J[1]+J[2]-J[3]+J[4]-J[5]+J[6]+J[7]+J[8]-J[9]-J[10]+J[11]+J[12]-J[13]+
    J[14]-J[15]+J[16]+J[17]+J[18]-J[19]-J[20]+J[21]-J[22]+J[23]-J[24]+J[25]+J[26]+J[27]-J[28]-J[29]-J[30]+
    J[31]-J[32]+J[33]+J[34]+J[35]-J[36]-J[37]-J[38]+J[39]-J[40]-J[41]-J[42]+J[43]+J[44]-J[45]+J[46]+J[47]+
    J[48]-J[49]-J[50]-J[51]-J[52]-J[53]+J[54]+J[55]+J[56]+J[57]-J[58]-J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+
    J[65], +H[0]+H[1]+H[2]+H[3]-H[4]+H[5]-H[6]+H[7]+H[8]-H[9]+H[10]+H[11]+J[0]+J[1]+J[2]-J[3]+J[4]-J[5]+
    J[6]+J[7]-J[8]+J[9]+J[10]+J[11]+J[12]-J[13]+J[14]-J[15]+J[16]+J[17]-J[18]+J[19]+J[20]+J[21]-J[22]+J[23]-J[24]+
    J[25]+J[26]-J[27]+J[28]+J[29]-J[30]+J[31]-J[32]+J[33]+J[34]-J[35]+J[36]+J[37]-J[38]+J[39]-J[40]-J[41]+
    J[42]-J[43]-J[44]-J[45]+J[46]+J[47]-J[48]+J[49]+J[50]-J[51]-J[52]+J[53]-J[54]-J[55]+J[56]-J[57]+J[58]+
    J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]+H[1]+H[2]+H[3]-H[4]+H[5]-H[6]+H[7]+H[8]-H[9]+H[10]-H[11]+
    J[0]+J[1]+J[2]-J[3]+J[4]-J[5]+J[6]+J[7]-J[8]+J[9]-J[10]+J[11]+J[12]-J[13]+J[14]-J[15]+J[16]+J[17]-J[18]+
    J[19]-J[20]+J[21]-J[22]+J[23]-J[24]+J[25]+J[26]-J[27]+J[28]-J[29]-J[30]+J[31]-J[32]+J[33]+J[34]-J[35]+
    J[36]-J[37]-J[38]+J[39]-J[40]-J[41]+J[42]-J[43]+J[44]-J[45]+J[46]+J[47]-J[48]+J[49]-J[50]-J[51]-J[52]+
    J[53]-J[54]+J[55]+J[56]-J[57]+J[58]-J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]+H[1]+H[2]+H[3]-H[4]+
    H[5]-H[6]+H[7]+H[8]-H[9]-H[10]+H[11]+J[0]+J[1]+J[2]-J[3]+J[4]-J[5]+J[6]+J[7]-J[8]-J[9]+J[10]+J[11]+J[12]-J[13]+
    J[14]-J[15]+J[16]+J[17]-J[18]-J[19]+J[20]+J[21]-J[22]+J[23]-J[24]+J[25]+J[26]-J[27]-J[28]+J[29]-J[30]+
    J[31]-J[32]+J[33]+J[34]-J[35]-J[36]+J[37]-J[38]+J[39]-J[40]-J[41]+J[42]+J[43]-J[44]-J[45]+J[46]+J[47]-J[48]-J[49]+
    J[50]-J[51]-J[52]+J[53]+J[54]-J[55]+J[56]-J[57]-J[58]+J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]+
    H[1]+H[2]+H[3]-H[4]+H[5]-H[6]+H[7]+H[8]-H[9]-H[10]-H[11]+J[0]+J[1]+J[2]-J[3]+J[4]-J[5]+J[6]+J[7]-J[8]-J[9]-J[10]+
    J[11]+J[12]-J[13]+J[14]-J[15]+J[16]+J[17]-J[18]-J[19]-J[20]+J[21]-J[22]+J[23]-J[24]+J[25]+J[26]-J[27]-J[28]-J[29]-J[30]+
    J[31]-J[32]+J[33]+J[34]-J[35]-J[36]-J[37]-J[38]+J[39]-J[40]-J[41]+J[42]+J[43]+J[44]-J[45]+J[46]+J[47]-J[48]-J[49]-J[50]-J[51]-J[52]+
    J[53]+J[54]+J[55]+J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]+H[1]+H[2]+H[3]-H[4]+
    H[5]-H[6]+H[7]-H[8]+H[9]+H[10]+H[11]+J[0]+J[1]+J[2]-J[3]+J[4]-J[5]+J[6]-J[7]+J[8]+J[9]+J[10]+J[11]+J[12]-J[13]+
    J[14]-J[15]+J[16]-J[17]+J[18]+J[19]+J[20]+J[21]-J[22]+J[23]-J[24]+J[25]-J[26]+J[27]+J[28]+J[29]-J[30]+
    J[31]-J[32]+J[33]-J[34]+J[35]+J[36]+J[37]-J[38]+J[39]-J[40]+J[41]-J[42]-J[43]-J[44]-J[45]+J[46]-J[47]+
    J[48]+J[49]+J[50]-J[51]+J[52]-J[53]-J[54]-J[55]-J[56]+J[57]+J[58]+J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+
    J[65], +H[0]+H[1]+H[2]+H[3]-H[4]+H[5]-H[6]+H[7]-H[8]+H[9]+H[10]-H[11]+J[0]+J[1]+J[2]-J[3]+J[4]-J[5]+
    J[6]-J[7]+J[8]+J[9]-J[10]+J[11]+J[12]-J[13]+J[14]-J[15]+J[16]-J[17]+J[18]+J[19]-J[20]+J[21]-J[22]+J[23]-J[24]+
    J[25]-J[26]+J[27]+J[28]-J[29]-J[30]+J[31]-J[32]+J[33]-J[34]+J[35]+J[36]-J[37]-J[38]+J[39]-J[40]+J[41]-J[42]-J[43]+
    J[44]-J[45]+J[46]-J[47]+J[48]+J[49]-J[50]-J[51]+J[52]-J[53]-J[54]+J[55]-J[56]+J[57]+J[58]-J[59]-J[60]-J[61]+
    J[62]+J[63]-J[64]-J[65], +H[0]+H[1]+H[2]+H[3]-H[4]+H[5]-H[6]+H[7]-H[8]+H[9]-H[10]+H[11]+J[0]+J[1]+J[2]-J[3]+
    J[4]-J[5]+J[6]-J[7]+J[8]-J[9]+J[10]+J[11]+J[12]-J[13]+J[14]-J[15]+J[16]-J[17]+J[18]-J[19]+J[20]+J[21]-J[22]+
    J[23]-J[24]+J[25]-J[26]+J[27]-J[28]+J[29]-J[30]+J[31]-J[32]+J[33]-J[34]+J[35]-J[36]+J[37]-J[38]+J[39]-J[40]+
    J[41]-J[42]+J[43]-J[44]-J[45]+J[46]-J[47]+J[48]-J[49]+J[50]-J[51]+J[52]-J[53]+J[54]-J[55]-J[56]+J[57]-J[58]+
    J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]+H[1]+H[2]+H[3]-H[4]+H[5]-H[6]+H[7]-H[8]+H[9]-H[10]-H[11]+
    J[0]+J[1]+J[2]-J[3]+J[4]-J[5]+J[6]-J[7]+J[8]-J[9]-J[10]+J[11]+J[12]-J[13]+J[14]-J[15]+J[16]-J[17]+J[18]-J[19]-J[20]+
    J[21]-J[22]+J[23]-J[24]+J[25]-J[26]+J[27]-J[28]-J[29]-J[30]+J[31]-J[32]+J[33]-J[34]+J[35]-J[36]-J[37]-J[38]+
    J[39]-J[40]+J[41]-J[42]+J[43]+J[44]-J[45]+J[46]-J[47]+J[48]-J[49]-J[50]-J[51]+J[52]-J[53]+J[54]+J[55]-J[56]+
    J[57]-J[58]-J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]+H[1]+H[2]+H[3]-H[4]+H[5]-H[6]+H[7]-H[8]-H[9]+
    H[10]+H[11]+J[0]+J[1]+J[2]-J[3]+J[4]-J[5]+J[6]-J[7]-J[8]+J[9]+J[10]+J[11]+J[12]-J[13]+J[14]-J[15]+J[16]-J[17]-J[18]+
    J[19]+J[20]+J[21]-J[22]+J[23]-J[24]+J[25]-J[26]-J[27]+J[28]+J[29]-J[30]+J[31]-J[32]+J[33]-J[34]-J[35]+
    J[36]+J[37]-J[38]+J[39]-J[40]+J[41]+J[42]-J[43]-J[44]-J[45]+J[46]-J[47]-J[48]+J[49]+J[50]-J[51]+J[52]+
    J[53]-J[54]-J[55]-J[56]-J[57]+J[58]+J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]+H[1]+H[2]+H[3]-H[4]+
    H[5]-H[6]+H[7]-H[8]-H[9]+H[10]-H[11]+J[0]+J[1]+J[2]-J[3]+J[4]-J[5]+J[6]-J[7]-J[8]+J[9]-J[10]+J[11]+J[12]-J[13]+
    J[14]-J[15]+J[16]-J[17]-J[18]+J[19]-J[20]+J[21]-J[22]+J[23]-J[24]+J[25]-J[26]-J[27]+J[28]-J[29]-J[30]+
    J[31]-J[32]+J[33]-J[34]-J[35]+J[36]-J[37]-J[38]+J[39]-J[40]+J[41]+J[42]-J[43]+J[44]-J[45]+J[46]-J[47]-J[48]+
    J[49]-J[50]-J[51]+J[52]+J[53]-J[54]+J[55]-J[56]-J[57]+J[58]-J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +
    H[0]+H[1]+H[2]+H[3]-H[4]+H[5]-H[6]+H[7]-H[8]-H[9]-H[10]+H[11]+J[0]+J[1]+J[2]-J[3]+J[4]-J[5]+J[6]-J[7]-J[8]-J[9]+
    J[10]+J[11]+J[12]-J[13]+J[14]-J[15]+J[16]-J[17]-J[18]-J[19]+J[20]+J[21]-J[22]+J[23]-J[24]+J[25]-J[26]-J[27]-J[28]+
    J[29]-J[30]+J[31]-J[32]+J[33]-J[34]-J[35]-J[36]+J[37]-J[38]+J[39]-J[40]+J[41]+J[42]+J[43]-J[44]-J[45]+
    J[46]-J[47]-J[48]-J[49]+J[50]-J[51]+J[52]+J[53]+J[54]-J[55]-J[56]-J[57]-J[58]+J[59]+J[60]+J[61]-J[62]+
    J[63]-J[64]-J[65], +H[0]+H[1]+H[2]+H[3]-H[4]+H[5]-H[6]+H[7]-H[8]-H[9]-H[10]-H[11]+J[0]+J[1]+J[2]-J[3]+
    J[4]-J[5]+J[6]-J[7]-J[8]-J[9]-J[10]+J[11]+J[12]-J[13]+J[14]-J[15]+J[16]-J[17]-J[18]-J[19]-J[20]+J[21]-J[22]+
    J[23]-J[24]+J[25]-J[26]-J[27]-J[28]-J[29]-J[30]+J[31]-J[32]+J[33]-J[34]-J[35]-J[36]-J[37]-J[38]+J[39]-J[40]+
    J[41]+J[42]+J[43]+J[44]-J[45]+J[46]-J[47]-J[48]-J[49]-J[50]-J[51]+J[52]+J[53]+J[54]+J[55]-J[56]-J[57]-J[58]-J[59]+
    J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]+H[1]+H[2]+H[3]-H[4]+H[5]-H[6]-H[7]+H[8]+H[9]+H[10]+H[11]+
    J[0]+J[1]+J[2]-J[3]+J[4]-J[5]-J[6]+J[7]+J[8]+J[9]+J[10]+J[11]+J[12]-J[13]+J[14]-J[15]-J[16]+J[17]+J[18]+
    J[19]+J[20]+J[21]-J[22]+J[23]-J[24]-J[25]+J[26]+J[27]+J[28]+J[29]-J[30]+J[31]-J[32]-J[33]+J[34]+J[35]+
    J[36]+J[37]-J[38]+J[39]+J[40]-J[41]-J[42]-J[43]-J[44]-J[45]-J[46]+J[47]+J[48]+J[49]+J[50]+J[51]-J[52]-J[53]-J[54]-J[55]-J[56]-J[57]-J[58]-J[59]+
    J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]+H[1]+H[2]+H[3]-H[4]+H[5]-H[6]-H[7]+H[8]+H[9]+H[10]-H[11]+
    J[0]+J[1]+J[2]-J[3]+J[4]-J[5]-J[6]+J[7]+J[8]+J[9]-J[10]+J[11]+J[12]-J[13]+J[14]-J[15]-J[16]+J[17]+J[18]+
    J[19]-J[20]+J[21]-J[22]+J[23]-J[24]-J[25]+J[26]+J[27]+J[28]-J[29]-J[30]+J[31]-J[32]-J[33]+J[34]+J[35]+
    J[36]-J[37]-J[38]+J[39]+J[40]-J[41]-J[42]-J[43]+J[44]-J[45]-J[46]+J[47]+J[48]+J[49]-J[50]+J[51]-J[52]-J[53]-J[54]+
    J[55]-J[56]-J[57]-J[58]+J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]+H[1]+H[2]+H[3]-H[4]+H[5]-H[6]-H[7]+
    H[8]+H[9]-H[10]+H[11]+J[0]+J[1]+J[2]-J[3]+J[4]-J[5]-J[6]+J[7]+J[8]-J[9]+J[10]+J[11]+J[12]-J[13]+J[14]-J[15]-J[16]+
    J[17]+J[18]-J[19]+J[20]+J[21]-J[22]+J[23]-J[24]-J[25]+J[26]+J[27]-J[28]+J[29]-J[30]+J[31]-J[32]-J[33]+
    J[34]+J[35]-J[36]+J[37]-J[38]+J[39]+J[40]-J[41]-J[42]+J[43]-J[44]-J[45]-J[46]+J[47]+J[48]-J[49]+J[50]+
    J[51]-J[52]-J[53]+J[54]-J[55]-J[56]-J[57]+J[58]-J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]+H[1]+
    H[2]+H[3]-H[4]+H[5]-H[6]-H[7]+H[8]+H[9]-H[10]-H[11]+J[0]+J[1]+J[2]-J[3]+J[4]-J[5]-J[6]+J[7]+J[8]-J[9]-J[10]+
    J[11]+J[12]-J[13]+J[14]-J[15]-J[16]+J[17]+J[18]-J[19]-J[20]+J[21]-J[22]+J[23]-J[24]-J[25]+J[26]+J[27]-J[28]-J[29]-J[30]+
    J[31]-J[32]-J[33]+J[34]+J[35]-J[36]-J[37]-J[38]+J[39]+J[40]-J[41]-J[42]+J[43]+J[44]-J[45]-J[46]+J[47]+
    J[48]-J[49]-J[50]+J[51]-J[52]-J[53]+J[54]+J[55]-J[56]-J[57]+J[58]+J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+
    J[65], +H[0]+H[1]+H[2]+H[3]-H[4]+H[5]-H[6]-H[7]+H[8]-H[9]+H[10]+H[11]+J[0]+J[1]+J[2]-J[3]+J[4]-J[5]-J[6]+
    J[7]-J[8]+J[9]+J[10]+J[11]+J[12]-J[13]+J[14]-J[15]-J[16]+J[17]-J[18]+J[19]+J[20]+J[21]-J[22]+J[23]-J[24]-J[25]+
    J[26]-J[27]+J[28]+J[29]-J[30]+J[31]-J[32]-J[33]+J[34]-J[35]+J[36]+J[37]-J[38]+J[39]+J[40]-J[41]+J[42]-J[43]-J[44]-J[45]-J[46]+
    J[47]-J[48]+J[49]+J[50]+J[51]-J[52]+J[53]-J[54]-J[55]-J[56]+J[57]-J[58]-J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+
    J[65], +H[0]+H[1]+H[2]+H[3]-H[4]+H[5]-H[6]-H[7]+H[8]-H[9]+H[10]-H[11]+J[0]+J[1]+J[2]-J[3]+J[4]-J[5]-J[6]+
    J[7]-J[8]+J[9]-J[10]+J[11]+J[12]-J[13]+J[14]-J[15]-J[16]+J[17]-J[18]+J[19]-J[20]+J[21]-J[22]+J[23]-J[24]-J[25]+
    J[26]-J[27]+J[28]-J[29]-J[30]+J[31]-J[32]-J[33]+J[34]-J[35]+J[36]-J[37]-J[38]+J[39]+J[40]-J[41]+J[42]-J[43]+
    J[44]-J[45]-J[46]+J[47]-J[48]+J[49]-J[50]+J[51]-J[52]+J[53]-J[54]+J[55]-J[56]+J[57]-J[58]+J[59]-J[60]+
    J[61]-J[62]-J[63]+J[64]-J[65], +H[0]+H[1]+H[2]+H[3]-H[4]+H[5]-H[6]-H[7]+H[8]-H[9]-H[10]+H[11]+J[0]+J[1]+
    J[2]-J[3]+J[4]-J[5]-J[6]+J[7]-J[8]-J[9]+J[10]+J[11]+J[12]-J[13]+J[14]-J[15]-J[16]+J[17]-J[18]-J[19]+
    J[20]+J[21]-J[22]+J[23]-J[24]-J[25]+J[26]-J[27]-J[28]+J[29]-J[30]+J[31]-J[32]-J[33]+J[34]-J[35]-J[36]+
    J[37]-J[38]+J[39]+J[40]-J[41]+J[42]+J[43]-J[44]-J[45]-J[46]+J[47]-J[48]-J[49]+J[50]+J[51]-J[52]+J[53]+
    J[54]-J[55]-J[56]+J[57]+J[58]-J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]+H[1]+H[2]+H[3]-H[4]+H[5]-H[6]-H[7]+
    H[8]-H[9]-H[10]-H[11]+J[0]+J[1]+J[2]-J[3]+J[4]-J[5]-J[6]+J[7]-J[8]-J[9]-J[10]+J[11]+J[12]-J[13]+J[14]-J[15]-J[16]+
    J[17]-J[18]-J[19]-J[20]+J[21]-J[22]+J[23]-J[24]-J[25]+J[26]-J[27]-J[28]-J[29]-J[30]+J[31]-J[32]-J[33]+
    J[34]-J[35]-J[36]-J[37]-J[38]+J[39]+J[40]-J[41]+J[42]+J[43]+J[44]-J[45]-J[46]+J[47]-J[48]-J[49]-J[50]+
    J[51]-J[52]+J[53]+J[54]+J[55]-J[56]+J[57]+J[58]+J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]+H[1]+
    H[2]+H[3]-H[4]+H[5]-H[6]-H[7]-H[8]+H[9]+H[10]+H[11]+J[0]+J[1]+J[2]-J[3]+J[4]-J[5]-J[6]-J[7]+J[8]+J[9]+
    J[10]+J[11]+J[12]-J[13]+J[14]-J[15]-J[16]-J[17]+J[18]+J[19]+J[20]+J[21]-J[22]+J[23]-J[24]-J[25]-J[26]+
    J[27]+J[28]+J[29]-J[30]+J[31]-J[32]-J[33]-J[34]+J[35]+J[36]+J[37]-J[38]+J[39]+J[40]+J[41]-J[42]-J[43]-J[44]-J[45]-J[46]-J[47]+
    J[48]+J[49]+J[50]+J[51]+J[52]-J[53]-J[54]-J[55]+J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+
    J[65], +H[0]+H[1]+H[2]+H[3]-H[4]+H[5]-H[6]-H[7]-H[8]+H[9]+H[10]-H[11]+J[0]+J[1]+J[2]-J[3]+J[4]-J[5]-J[6]-J[7]+
    J[8]+J[9]-J[10]+J[11]+J[12]-J[13]+J[14]-J[15]-J[16]-J[17]+J[18]+J[19]-J[20]+J[21]-J[22]+J[23]-J[24]-J[25]-J[26]+
    J[27]+J[28]-J[29]-J[30]+J[31]-J[32]-J[33]-J[34]+J[35]+J[36]-J[37]-J[38]+J[39]+J[40]+J[41]-J[42]-J[43]+
    J[44]-J[45]-J[46]-J[47]+J[48]+J[49]-J[50]+J[51]+J[52]-J[53]-J[54]+J[55]+J[56]-J[57]-J[58]+J[59]-J[60]-J[61]+
    J[62]+J[63]-J[64]-J[65], +H[0]+H[1]+H[2]+H[3]-H[4]+H[5]-H[6]-H[7]-H[8]+H[9]-H[10]+H[11]+J[0]+J[1]+J[2]-J[3]+
    J[4]-J[5]-J[6]-J[7]+J[8]-J[9]+J[10]+J[11]+J[12]-J[13]+J[14]-J[15]-J[16]-J[17]+J[18]-J[19]+J[20]+J[21]-J[22]+
    J[23]-J[24]-J[25]-J[26]+J[27]-J[28]+J[29]-J[30]+J[31]-J[32]-J[33]-J[34]+J[35]-J[36]+J[37]-J[38]+J[39]+
    J[40]+J[41]-J[42]+J[43]-J[44]-J[45]-J[46]-J[47]+J[48]-J[49]+J[50]+J[51]+J[52]-J[53]+J[54]-J[55]+J[56]-J[57]+
    J[58]-J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]+H[1]+H[2]+H[3]-H[4]+H[5]-H[6]-H[7]-H[8]+H[9]-H[10]-H[11]+
    J[0]+J[1]+J[2]-J[3]+J[4]-J[5]-J[6]-J[7]+J[8]-J[9]-J[10]+J[11]+J[12]-J[13]+J[14]-J[15]-J[16]-J[17]+J[18]-J[19]-J[20]+
    J[21]-J[22]+J[23]-J[24]-J[25]-J[26]+J[27]-J[28]-J[29]-J[30]+J[31]-J[32]-J[33]-J[34]+J[35]-J[36]-J[37]-J[38]+
    J[39]+J[40]+J[41]-J[42]+J[43]+J[44]-J[45]-J[46]-J[47]+J[48]-J[49]-J[50]+J[51]+J[52]-J[53]+J[54]+J[55]+
    J[56]-J[57]+J[58]+J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]+H[1]+H[2]+H[3]-H[4]+H[5]-H[6]-H[7]-H[8]-H[9]+
    H[10]+H[11]+J[0]+J[1]+J[2]-J[3]+J[4]-J[5]-J[6]-J[7]-J[8]+J[9]+J[10]+J[11]+J[12]-J[13]+J[14]-J[15]-J[16]-J[17]-J[18]+
    J[19]+J[20]+J[21]-J[22]+J[23]-J[24]-J[25]-J[26]-J[27]+J[28]+J[29]-J[30]+J[31]-J[32]-J[33]-J[34]-J[35]+
    J[36]+J[37]-J[38]+J[39]+J[40]+J[41]+J[42]-J[43]-J[44]-J[45]-J[46]-J[47]-J[48]+J[49]+J[50]+J[51]+J[52]+
    J[53]-J[54]-J[55]+J[56]+J[57]-J[58]-J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]+H[1]+H[2]+H[3]-H[4]+
    H[5]-H[6]-H[7]-H[8]-H[9]+H[10]-H[11]+J[0]+J[1]+J[2]-J[3]+J[4]-J[5]-J[6]-J[7]-J[8]+J[9]-J[10]+J[11]+J[12]-J[13]+
    J[14]-J[15]-J[16]-J[17]-J[18]+J[19]-J[20]+J[21]-J[22]+J[23]-J[24]-J[25]-J[26]-J[27]+J[28]-J[29]-J[30]+
    J[31]-J[32]-J[33]-J[34]-J[35]+J[36]-J[37]-J[38]+J[39]+J[40]+J[41]+J[42]-J[43]+J[44]-J[45]-J[46]-J[47]-J[48]+
    J[49]-J[50]+J[51]+J[52]+J[53]-J[54]+J[55]+J[56]+J[57]-J[58]+J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +
    H[0]+H[1]+H[2]+H[3]-H[4]+H[5]-H[6]-H[7]-H[8]-H[9]-H[10]+H[11]+J[0]+J[1]+J[2]-J[3]+J[4]-J[5]-J[6]-J[7]-J[8]-J[9]+
    J[10]+J[11]+J[12]-J[13]+J[14]-J[15]-J[16]-J[17]-J[18]-J[19]+J[20]+J[21]-J[22]+J[23]-J[24]-J[25]-J[26]-J[27]-J[28]+
    J[29]-J[30]+J[31]-J[32]-J[33]-J[34]-J[35]-J[36]+J[37]-J[38]+J[39]+J[40]+J[41]+J[42]+J[43]-J[44]-J[45]-J[46]-J[47]-J[48]-J[49]+
    J[50]+J[51]+J[52]+J[53]+J[54]-J[55]+J[56]+J[57]+J[58]-J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]+
    H[1]+H[2]+H[3]-H[4]+H[5]-H[6]-H[7]-H[8]-H[9]-H[10]-H[11]+J[0]+J[1]+J[2]-J[3]+J[4]-J[5]-J[6]-J[7]-J[8]-J[9]-J[10]+
    J[11]+J[12]-J[13]+J[14]-J[15]-J[16]-J[17]-J[18]-J[19]-J[20]+J[21]-J[22]+J[23]-J[24]-J[25]-J[26]-J[27]-J[28]-J[29]-J[30]+
    J[31]-J[32]-J[33]-J[34]-J[35]-J[36]-J[37]-J[38]+J[39]+J[40]+J[41]+J[42]+J[43]+J[44]-J[45]-J[46]-J[47]-J[48]-J[49]-J[50]+
    J[51]+J[52]+J[53]+J[54]+J[55]+J[56]+J[57]+J[58]+J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]+H[1]+
    H[2]+H[3]-H[4]-H[5]+H[6]+H[7]+H[8]+H[9]+H[10]+H[11]+J[0]+J[1]+J[2]-J[3]-J[4]+J[5]+J[6]+J[7]+J[8]+J[9]+
    J[10]+J[11]+J[12]-J[13]-J[14]+J[15]+J[16]+J[17]+J[18]+J[19]+J[20]+J[21]-J[22]-J[23]+J[24]+J[25]+J[26]+
    J[27]+J[28]+J[29]-J[30]-J[31]+J[32]+J[33]+J[34]+J[35]+J[36]+J[37]+J[38]-J[39]-J[40]-J[41]-J[42]-J[43]-J[44]-J[45]-J[46]-J[47]-J[48]-J[49]-J[50]+
    J[51]+J[52]+J[53]+J[54]+J[55]+J[56]+J[57]+J[58]+J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]+H[1]+
    H[2]+H[3]-H[4]-H[5]+H[6]+H[7]+H[8]+H[9]+H[10]-H[11]+J[0]+J[1]+J[2]-J[3]-J[4]+J[5]+J[6]+J[7]+J[8]+J[9]-J[10]+
    J[11]+J[12]-J[13]-J[14]+J[15]+J[16]+J[17]+J[18]+J[19]-J[20]+J[21]-J[22]-J[23]+J[24]+J[25]+J[26]+J[27]+
    J[28]-J[29]-J[30]-J[31]+J[32]+J[33]+J[34]+J[35]+J[36]-J[37]+J[38]-J[39]-J[40]-J[41]-J[42]-J[43]+J[44]-J[45]-J[46]-J[47]-J[48]-J[49]+
    J[50]+J[51]+J[52]+J[53]+J[54]-J[55]+J[56]+J[57]+J[58]-J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]+
    H[1]+H[2]+H[3]-H[4]-H[5]+H[6]+H[7]+H[8]+H[9]-H[10]+H[11]+J[0]+J[1]+J[2]-J[3]-J[4]+J[5]+J[6]+J[7]+J[8]-J[9]+
    J[10]+J[11]+J[12]-J[13]-J[14]+J[15]+J[16]+J[17]+J[18]-J[19]+J[20]+J[21]-J[22]-J[23]+J[24]+J[25]+J[26]+
    J[27]-J[28]+J[29]-J[30]-J[31]+J[32]+J[33]+J[34]+J[35]-J[36]+J[37]+J[38]-J[39]-J[40]-J[41]-J[42]+J[43]-J[44]-J[45]-J[46]-J[47]-J[48]+
    J[49]-J[50]+J[51]+J[52]+J[53]-J[54]+J[55]+J[56]+J[57]-J[58]+J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +
    H[0]+H[1]+H[2]+H[3]-H[4]-H[5]+H[6]+H[7]+H[8]+H[9]-H[10]-H[11]+J[0]+J[1]+J[2]-J[3]-J[4]+J[5]+J[6]+J[7]+
    J[8]-J[9]-J[10]+J[11]+J[12]-J[13]-J[14]+J[15]+J[16]+J[17]+J[18]-J[19]-J[20]+J[21]-J[22]-J[23]+J[24]+
    J[25]+J[26]+J[27]-J[28]-J[29]-J[30]-J[31]+J[32]+J[33]+J[34]+J[35]-J[36]-J[37]+J[38]-J[39]-J[40]-J[41]-J[42]+
    J[43]+J[44]-J[45]-J[46]-J[47]-J[48]+J[49]+J[50]+J[51]+J[52]+J[53]-J[54]-J[55]+J[56]+J[57]-J[58]-J[59]+
    J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]+H[1]+H[2]+H[3]-H[4]-H[5]+H[6]+H[7]+H[8]-H[9]+H[10]+H[11]+
    J[0]+J[1]+J[2]-J[3]-J[4]+J[5]+J[6]+J[7]-J[8]+J[9]+J[10]+J[11]+J[12]-J[13]-J[14]+J[15]+J[16]+J[17]-J[18]+
    J[19]+J[20]+J[21]-J[22]-J[23]+J[24]+J[25]+J[26]-J[27]+J[28]+J[29]-J[30]-J[31]+J[32]+J[33]+J[34]-J[35]+
    J[36]+J[37]+J[38]-J[39]-J[40]-J[41]+J[42]-J[43]-J[44]-J[45]-J[46]-J[47]+J[48]-J[49]-J[50]+J[51]+J[52]-J[53]+
    J[54]+J[55]+J[56]-J[57]+J[58]+J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]+H[1]+H[2]+H[3]-H[4]-H[5]+
    H[6]+H[7]+H[8]-H[9]+H[10]-H[11]+J[0]+J[1]+J[2]-J[3]-J[4]+J[5]+J[6]+J[7]-J[8]+J[9]-J[10]+J[11]+J[12]-J[13]-J[14]+
    J[15]+J[16]+J[17]-J[18]+J[19]-J[20]+J[21]-J[22]-J[23]+J[24]+J[25]+J[26]-J[27]+J[28]-J[29]-J[30]-J[31]+
    J[32]+J[33]+J[34]-J[35]+J[36]-J[37]+J[38]-J[39]-J[40]-J[41]+J[42]-J[43]+J[44]-J[45]-J[46]-J[47]+J[48]-J[49]+
    J[50]+J[51]+J[52]-J[53]+J[54]-J[55]+J[56]-J[57]+J[58]-J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]+
    H[1]+H[2]+H[3]-H[4]-H[5]+H[6]+H[7]+H[8]-H[9]-H[10]+H[11]+J[0]+J[1]+J[2]-J[3]-J[4]+J[5]+J[6]+J[7]-J[8]-J[9]+
    J[10]+J[11]+J[12]-J[13]-J[14]+J[15]+J[16]+J[17]-J[18]-J[19]+J[20]+J[21]-J[22]-J[23]+J[24]+J[25]+J[26]-J[27]-J[28]+
    J[29]-J[30]-J[31]+J[32]+J[33]+J[34]-J[35]-J[36]+J[37]+J[38]-J[39]-J[40]-J[41]+J[42]+J[43]-J[44]-J[45]-J[46]-J[47]+
    J[48]+J[49]-J[50]+J[51]+J[52]-J[53]-J[54]+J[55]+J[56]-J[57]-J[58]+J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +
    H[0]+H[1]+H[2]+H[3]-H[4]-H[5]+H[6]+H[7]+H[8]-H[9]-H[10]-H[11]+J[0]+J[1]+J[2]-J[3]-J[4]+J[5]+J[6]+J[7]-J[8]-J[9]-J[10]+
    J[11]+J[12]-J[13]-J[14]+J[15]+J[16]+J[17]-J[18]-J[19]-J[20]+J[21]-J[22]-J[23]+J[24]+J[25]+J[26]-J[27]-J[28]-J[29]-J[30]-J[31]+
    J[32]+J[33]+J[34]-J[35]-J[36]-J[37]+J[38]-J[39]-J[40]-J[41]+J[42]+J[43]+J[44]-J[45]-J[46]-J[47]+J[48]+
    J[49]+J[50]+J[51]+J[52]-J[53]-J[54]-J[55]+J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +
    H[0]+H[1]+H[2]+H[3]-H[4]-H[5]+H[6]+H[7]-H[8]+H[9]+H[10]+H[11]+J[0]+J[1]+J[2]-J[3]-J[4]+J[5]+J[6]-J[7]+
    J[8]+J[9]+J[10]+J[11]+J[12]-J[13]-J[14]+J[15]+J[16]-J[17]+J[18]+J[19]+J[20]+J[21]-J[22]-J[23]+J[24]+
    J[25]-J[26]+J[27]+J[28]+J[29]-J[30]-J[31]+J[32]+J[33]-J[34]+J[35]+J[36]+J[37]+J[38]-J[39]-J[40]+J[41]-J[42]-J[43]-J[44]-J[45]-J[46]+
    J[47]-J[48]-J[49]-J[50]+J[51]-J[52]+J[53]+J[54]+J[55]-J[56]+J[57]+J[58]+J[59]-J[60]-J[61]-J[62]+J[63]+
    J[64]+J[65], +H[0]+H[1]+H[2]+H[3]-H[4]-H[5]+H[6]+H[7]-H[8]+H[9]+H[10]-H[11]+J[0]+J[1]+J[2]-J[3]-J[4]+
    J[5]+J[6]-J[7]+J[8]+J[9]-J[10]+J[11]+J[12]-J[13]-J[14]+J[15]+J[16]-J[17]+J[18]+J[19]-J[20]+J[21]-J[22]-J[23]+
    J[24]+J[25]-J[26]+J[27]+J[28]-J[29]-J[30]-J[31]+J[32]+J[33]-J[34]+J[35]+J[36]-J[37]+J[38]-J[39]-J[40]+
    J[41]-J[42]-J[43]+J[44]-J[45]-J[46]+J[47]-J[48]-J[49]+J[50]+J[51]-J[52]+J[53]+J[54]-J[55]-J[56]+J[57]+
    J[58]-J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]+H[1]+H[2]+H[3]-H[4]-H[5]+H[6]+H[7]-H[8]+H[9]-H[10]+
    H[11]+J[0]+J[1]+J[2]-J[3]-J[4]+J[5]+J[6]-J[7]+J[8]-J[9]+J[10]+J[11]+J[12]-J[13]-J[14]+J[15]+J[16]-J[17]+
    J[18]-J[19]+J[20]+J[21]-J[22]-J[23]+J[24]+J[25]-J[26]+J[27]-J[28]+J[29]-J[30]-J[31]+J[32]+J[33]-J[34]+
    J[35]-J[36]+J[37]+J[38]-J[39]-J[40]+J[41]-J[42]+J[43]-J[44]-J[45]-J[46]+J[47]-J[48]+J[49]-J[50]+J[51]-J[52]+
    J[53]-J[54]+J[55]-J[56]+J[57]-J[58]+J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]+H[1]+H[2]+H[3]-H[4]-H[5]+
    H[6]+H[7]-H[8]+H[9]-H[10]-H[11]+J[0]+J[1]+J[2]-J[3]-J[4]+J[5]+J[6]-J[7]+J[8]-J[9]-J[10]+J[11]+J[12]-J[13]-J[14]+
    J[15]+J[16]-J[17]+J[18]-J[19]-J[20]+J[21]-J[22]-J[23]+J[24]+J[25]-J[26]+J[27]-J[28]-J[29]-J[30]-J[31]+
    J[32]+J[33]-J[34]+J[35]-J[36]-J[37]+J[38]-J[39]-J[40]+J[41]-J[42]+J[43]+J[44]-J[45]-J[46]+J[47]-J[48]+
    J[49]+J[50]+J[51]-J[52]+J[53]-J[54]-J[55]-J[56]+J[57]-J[58]-J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +
    H[0]+H[1]+H[2]+H[3]-H[4]-H[5]+H[6]+H[7]-H[8]-H[9]+H[10]+H[11]+J[0]+J[1]+J[2]-J[3]-J[4]+J[5]+J[6]-J[7]-J[8]+
    J[9]+J[10]+J[11]+J[12]-J[13]-J[14]+J[15]+J[16]-J[17]-J[18]+J[19]+J[20]+J[21]-J[22]-J[23]+J[24]+J[25]-J[26]-J[27]+
    J[28]+J[29]-J[30]-J[31]+J[32]+J[33]-J[34]-J[35]+J[36]+J[37]+J[38]-J[39]-J[40]+J[41]+J[42]-J[43]-J[44]-J[45]-J[46]+
    J[47]+J[48]-J[49]-J[50]+J[51]-J[52]-J[53]+J[54]+J[55]-J[56]-J[57]+J[58]+J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+
    J[65], +H[0]+H[1]+H[2]+H[3]-H[4]-H[5]+H[6]+H[7]-H[8]-H[9]+H[10]-H[11]+J[0]+J[1]+J[2]-J[3]-J[4]+J[5]+
    J[6]-J[7]-J[8]+J[9]-J[10]+J[11]+J[12]-J[13]-J[14]+J[15]+J[16]-J[17]-J[18]+J[19]-J[20]+J[21]-J[22]-J[23]+
    J[24]+J[25]-J[26]-J[27]+J[28]-J[29]-J[30]-J[31]+J[32]+J[33]-J[34]-J[35]+J[36]-J[37]+J[38]-J[39]-J[40]+
    J[41]+J[42]-J[43]+J[44]-J[45]-J[46]+J[47]+J[48]-J[49]+J[50]+J[51]-J[52]-J[53]+J[54]-J[55]-J[56]-J[57]+
    J[58]-J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]+H[1]+H[2]+H[3]-H[4]-H[5]+H[6]+H[7]-H[8]-H[9]-H[10]+
    H[11]+J[0]+J[1]+J[2]-J[3]-J[4]+J[5]+J[6]-J[7]-J[8]-J[9]+J[10]+J[11]+J[12]-J[13]-J[14]+J[15]+J[16]-J[17]-J[18]-J[19]+
    J[20]+J[21]-J[22]-J[23]+J[24]+J[25]-J[26]-J[27]-J[28]+J[29]-J[30]-J[31]+J[32]+J[33]-J[34]-J[35]-J[36]+
    J[37]+J[38]-J[39]-J[40]+J[41]+J[42]+J[43]-J[44]-J[45]-J[46]+J[47]+J[48]+J[49]-J[50]+J[51]-J[52]-J[53]-J[54]+
    J[55]-J[56]-J[57]-J[58]+J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]+H[1]+H[2]+H[3]-H[4]-H[5]+H[6]+
    H[7]-H[8]-H[9]-H[10]-H[11]+J[0]+J[1]+J[2]-J[3]-J[4]+J[5]+J[6]-J[7]-J[8]-J[9]-J[10]+J[11]+J[12]-J[13]-J[14]+
    J[15]+J[16]-J[17]-J[18]-J[19]-J[20]+J[21]-J[22]-J[23]+J[24]+J[25]-J[26]-J[27]-J[28]-J[29]-J[30]-J[31]+
    J[32]+J[33]-J[34]-J[35]-J[36]-J[37]+J[38]-J[39]-J[40]+J[41]+J[42]+J[43]+J[44]-J[45]-J[46]+J[47]+J[48]+
    J[49]+J[50]+J[51]-J[52]-J[53]-J[54]-J[55]-J[56]-J[57]-J[58]-J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +
    H[0]+H[1]+H[2]+H[3]-H[4]-H[5]+H[6]-H[7]+H[8]+H[9]+H[10]+H[11]+J[0]+J[1]+J[2]-J[3]-J[4]+J[5]-J[6]+J[7]+
    J[8]+J[9]+J[10]+J[11]+J[12]-J[13]-J[14]+J[15]-J[16]+J[17]+J[18]+J[19]+J[20]+J[21]-J[22]-J[23]+J[24]-J[25]+
    J[26]+J[27]+J[28]+J[29]-J[30]-J[31]+J[32]-J[33]+J[34]+J[35]+J[36]+J[37]+J[38]-J[39]+J[40]-J[41]-J[42]-J[43]-J[44]-J[45]+
    J[46]-J[47]-J[48]-J[49]-J[50]-J[51]+J[52]+J[53]+J[54]+J[55]-J[56]-J[57]-J[58]-J[59]+J[60]+J[61]+J[62]+
    J[63]+J[64]+J[65], +H[0]+H[1]+H[2]+H[3]-H[4]-H[5]+H[6]-H[7]+H[8]+H[9]+H[10]-H[11]+J[0]+J[1]+J[2]-J[3]-J[4]+
    J[5]-J[6]+J[7]+J[8]+J[9]-J[10]+J[11]+J[12]-J[13]-J[14]+J[15]-J[16]+J[17]+J[18]+J[19]-J[20]+J[21]-J[22]-J[23]+
    J[24]-J[25]+J[26]+J[27]+J[28]-J[29]-J[30]-J[31]+J[32]-J[33]+J[34]+J[35]+J[36]-J[37]+J[38]-J[39]+J[40]-J[41]-J[42]-J[43]+
    J[44]-J[45]+J[46]-J[47]-J[48]-J[49]+J[50]-J[51]+J[52]+J[53]+J[54]-J[55]-J[56]-J[57]-J[58]+J[59]+J[60]+
    J[61]-J[62]+J[63]-J[64]-J[65], +H[0]+H[1]+H[2]+H[3]-H[4]-H[5]+H[6]-H[7]+H[8]+H[9]-H[10]+H[11]+J[0]+J[1]+
    J[2]-J[3]-J[4]+J[5]-J[6]+J[7]+J[8]-J[9]+J[10]+J[11]+J[12]-J[13]-J[14]+J[15]-J[16]+J[17]+J[18]-J[19]+
    J[20]+J[21]-J[22]-J[23]+J[24]-J[25]+J[26]+J[27]-J[28]+J[29]-J[30]-J[31]+J[32]-J[33]+J[34]+J[35]-J[36]+
    J[37]+J[38]-J[39]+J[40]-J[41]-J[42]+J[43]-J[44]-J[45]+J[46]-J[47]-J[48]+J[49]-J[50]-J[51]+J[52]+J[53]-J[54]+
    J[55]-J[56]-J[57]+J[58]-J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]+H[1]+H[2]+H[3]-H[4]-H[5]+H[6]-H[7]+
    H[8]+H[9]-H[10]-H[11]+J[0]+J[1]+J[2]-J[3]-J[4]+J[5]-J[6]+J[7]+J[8]-J[9]-J[10]+J[11]+J[12]-J[13]-J[14]+
    J[15]-J[16]+J[17]+J[18]-J[19]-J[20]+J[21]-J[22]-J[23]+J[24]-J[25]+J[26]+J[27]-J[28]-J[29]-J[30]-J[31]+
    J[32]-J[33]+J[34]+J[35]-J[36]-J[37]+J[38]-J[39]+J[40]-J[41]-J[42]+J[43]+J[44]-J[45]+J[46]-J[47]-J[48]+
    J[49]+J[50]-J[51]+J[52]+J[53]-J[54]-J[55]-J[56]-J[57]+J[58]+J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +
    H[0]+H[1]+H[2]+H[3]-H[4]-H[5]+H[6]-H[7]+H[8]-H[9]+H[10]+H[11]+J[0]+J[1]+J[2]-J[3]-J[4]+J[5]-J[6]+J[7]-J[8]+
    J[9]+J[10]+J[11]+J[12]-J[13]-J[14]+J[15]-J[16]+J[17]-J[18]+J[19]+J[20]+J[21]-J[22]-J[23]+J[24]-J[25]+
    J[26]-J[27]+J[28]+J[29]-J[30]-J[31]+J[32]-J[33]+J[34]-J[35]+J[36]+J[37]+J[38]-J[39]+J[40]-J[41]+J[42]-J[43]-J[44]-J[45]+
    J[46]-J[47]+J[48]-J[49]-J[50]-J[51]+J[52]-J[53]+J[54]+J[55]-J[56]+J[57]-J[58]-J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+
    J[65], +H[0]+H[1]+H[2]+H[3]-H[4]-H[5]+H[6]-H[7]+H[8]-H[9]+H[10]-H[11]+J[0]+J[1]+J[2]-J[3]-J[4]+J[5]-J[6]+
    J[7]-J[8]+J[9]-J[10]+J[11]+J[12]-J[13]-J[14]+J[15]-J[16]+J[17]-J[18]+J[19]-J[20]+J[21]-J[22]-J[23]+J[24]-J[25]+
    J[26]-J[27]+J[28]-J[29]-J[30]-J[31]+J[32]-J[33]+J[34]-J[35]+J[36]-J[37]+J[38]-J[39]+J[40]-J[41]+J[42]-J[43]+
    J[44]-J[45]+J[46]-J[47]+J[48]-J[49]+J[50]-J[51]+J[52]-J[53]+J[54]-J[55]-J[56]+J[57]-J[58]+J[59]-J[60]+
    J[61]-J[62]-J[63]+J[64]-J[65], +H[0]+H[1]+H[2]+H[3]-H[4]-H[5]+H[6]-H[7]+H[8]-H[9]-H[10]+H[11]+J[0]+J[1]+
    J[2]-J[3]-J[4]+J[5]-J[6]+J[7]-J[8]-J[9]+J[10]+J[11]+J[12]-J[13]-J[14]+J[15]-J[16]+J[17]-J[18]-J[19]+
    J[20]+J[21]-J[22]-J[23]+J[24]-J[25]+J[26]-J[27]-J[28]+J[29]-J[30]-J[31]+J[32]-J[33]+J[34]-J[35]-J[36]+
    J[37]+J[38]-J[39]+J[40]-J[41]+J[42]+J[43]-J[44]-J[45]+J[46]-J[47]+J[48]+J[49]-J[50]-J[51]+J[52]-J[53]-J[54]+
    J[55]-J[56]+J[57]+J[58]-J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]+H[1]+H[2]+H[3]-H[4]-H[5]+H[6]-H[7]+
    H[8]-H[9]-H[10]-H[11]+J[0]+J[1]+J[2]-J[3]-J[4]+J[5]-J[6]+J[7]-J[8]-J[9]-J[10]+J[11]+J[12]-J[13]-J[14]+
    J[15]-J[16]+J[17]-J[18]-J[19]-J[20]+J[21]-J[22]-J[23]+J[24]-J[25]+J[26]-J[27]-J[28]-J[29]-J[30]-J[31]+
    J[32]-J[33]+J[34]-J[35]-J[36]-J[37]+J[38]-J[39]+J[40]-J[41]+J[42]+J[43]+J[44]-J[45]+J[46]-J[47]+J[48]+
    J[49]+J[50]-J[51]+J[52]-J[53]-J[54]-J[55]-J[56]+J[57]+J[58]+J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +
    H[0]+H[1]+H[2]+H[3]-H[4]-H[5]+H[6]-H[7]-H[8]+H[9]+H[10]+H[11]+J[0]+J[1]+J[2]-J[3]-J[4]+J[5]-J[6]-J[7]+
    J[8]+J[9]+J[10]+J[11]+J[12]-J[13]-J[14]+J[15]-J[16]-J[17]+J[18]+J[19]+J[20]+J[21]-J[22]-J[23]+J[24]-J[25]-J[26]+
    J[27]+J[28]+J[29]-J[30]-J[31]+J[32]-J[33]-J[34]+J[35]+J[36]+J[37]+J[38]-J[39]+J[40]+J[41]-J[42]-J[43]-J[44]-J[45]+
    J[46]+J[47]-J[48]-J[49]-J[50]-J[51]-J[52]+J[53]+J[54]+J[55]+J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+
    J[63]+J[64]+J[65], +H[0]+H[1]+H[2]+H[3]-H[4]-H[5]+H[6]-H[7]-H[8]+H[9]+H[10]-H[11]+J[0]+J[1]+J[2]-J[3]-J[4]+
    J[5]-J[6]-J[7]+J[8]+J[9]-J[10]+J[11]+J[12]-J[13]-J[14]+J[15]-J[16]-J[17]+J[18]+J[19]-J[20]+J[21]-J[22]-J[23]+
    J[24]-J[25]-J[26]+J[27]+J[28]-J[29]-J[30]-J[31]+J[32]-J[33]-J[34]+J[35]+J[36]-J[37]+J[38]-J[39]+J[40]+
    J[41]-J[42]-J[43]+J[44]-J[45]+J[46]+J[47]-J[48]-J[49]+J[50]-J[51]-J[52]+J[53]+J[54]-J[55]+J[56]-J[57]-J[58]+
    J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]+H[1]+H[2]+H[3]-H[4]-H[5]+H[6]-H[7]-H[8]+H[9]-H[10]+
    H[11]+J[0]+J[1]+J[2]-J[3]-J[4]+J[5]-J[6]-J[7]+J[8]-J[9]+J[10]+J[11]+J[12]-J[13]-J[14]+J[15]-J[16]-J[17]+
    J[18]-J[19]+J[20]+J[21]-J[22]-J[23]+J[24]-J[25]-J[26]+J[27]-J[28]+J[29]-J[30]-J[31]+J[32]-J[33]-J[34]+
    J[35]-J[36]+J[37]+J[38]-J[39]+J[40]+J[41]-J[42]+J[43]-J[44]-J[45]+J[46]+J[47]-J[48]+J[49]-J[50]-J[51]-J[52]+
    J[53]-J[54]+J[55]+J[56]-J[57]+J[58]-J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]+H[1]+H[2]+H[3]-H[4]-H[5]+
    H[6]-H[7]-H[8]+H[9]-H[10]-H[11]+J[0]+J[1]+J[2]-J[3]-J[4]+J[5]-J[6]-J[7]+J[8]-J[9]-J[10]+J[11]+J[12]-J[13]-J[14]+
    J[15]-J[16]-J[17]+J[18]-J[19]-J[20]+J[21]-J[22]-J[23]+J[24]-J[25]-J[26]+J[27]-J[28]-J[29]-J[30]-J[31]+
    J[32]-J[33]-J[34]+J[35]-J[36]-J[37]+J[38]-J[39]+J[40]+J[41]-J[42]+J[43]+J[44]-J[45]+J[46]+J[47]-J[48]+
    J[49]+J[50]-J[51]-J[52]+J[53]-J[54]-J[55]+J[56]-J[57]+J[58]+J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +
    H[0]+H[1]+H[2]+H[3]-H[4]-H[5]+H[6]-H[7]-H[8]-H[9]+H[10]+H[11]+J[0]+J[1]+J[2]-J[3]-J[4]+J[5]-J[6]-J[7]-J[8]+
    J[9]+J[10]+J[11]+J[12]-J[13]-J[14]+J[15]-J[16]-J[17]-J[18]+J[19]+J[20]+J[21]-J[22]-J[23]+J[24]-J[25]-J[26]-J[27]+
    J[28]+J[29]-J[30]-J[31]+J[32]-J[33]-J[34]-J[35]+J[36]+J[37]+J[38]-J[39]+J[40]+J[41]+J[42]-J[43]-J[44]-J[45]+
    J[46]+J[47]+J[48]-J[49]-J[50]-J[51]-J[52]-J[53]+J[54]+J[55]+J[56]+J[57]-J[58]-J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+
    J[65], +H[0]+H[1]+H[2]+H[3]-H[4]-H[5]+H[6]-H[7]-H[8]-H[9]+H[10]-H[11]+J[0]+J[1]+J[2]-J[3]-J[4]+J[5]-J[6]-J[7]-J[8]+
    J[9]-J[10]+J[11]+J[12]-J[13]-J[14]+J[15]-J[16]-J[17]-J[18]+J[19]-J[20]+J[21]-J[22]-J[23]+J[24]-J[25]-J[26]-J[27]+
    J[28]-J[29]-J[30]-J[31]+J[32]-J[33]-J[34]-J[35]+J[36]-J[37]+J[38]-J[39]+J[40]+J[41]+J[42]-J[43]+J[44]-J[45]+
    J[46]+J[47]+J[48]-J[49]+J[50]-J[51]-J[52]-J[53]+J[54]-J[55]+J[56]+J[57]-J[58]+J[59]+J[60]-J[61]+J[62]-J[63]+
    J[64]-J[65], +H[0]+H[1]+H[2]+H[3]-H[4]-H[5]+H[6]-H[7]-H[8]-H[9]-H[10]+H[11]+J[0]+J[1]+J[2]-J[3]-J[4]+
    J[5]-J[6]-J[7]-J[8]-J[9]+J[10]+J[11]+J[12]-J[13]-J[14]+J[15]-J[16]-J[17]-J[18]-J[19]+J[20]+J[21]-J[22]-J[23]+
    J[24]-J[25]-J[26]-J[27]-J[28]+J[29]-J[30]-J[31]+J[32]-J[33]-J[34]-J[35]-J[36]+J[37]+J[38]-J[39]+J[40]+
    J[41]+J[42]+J[43]-J[44]-J[45]+J[46]+J[47]+J[48]+J[49]-J[50]-J[51]-J[52]-J[53]-J[54]+J[55]+J[56]+J[57]+
    J[58]-J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]+H[1]+H[2]+H[3]-H[4]-H[5]+H[6]-H[7]-H[8]-H[9]-H[10]-H[11]+
    J[0]+J[1]+J[2]-J[3]-J[4]+J[5]-J[6]-J[7]-J[8]-J[9]-J[10]+J[11]+J[12]-J[13]-J[14]+J[15]-J[16]-J[17]-J[18]-J[19]-J[20]+
    J[21]-J[22]-J[23]+J[24]-J[25]-J[26]-J[27]-J[28]-J[29]-J[30]-J[31]+J[32]-J[33]-J[34]-J[35]-J[36]-J[37]+
    J[38]-J[39]+J[40]+J[41]+J[42]+J[43]+J[44]-J[45]+J[46]+J[47]+J[48]+J[49]+J[50]-J[51]-J[52]-J[53]-J[54]-J[55]+
    J[56]+J[57]+J[58]+J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]+H[1]+H[2]+H[3]-H[4]-H[5]-H[6]+H[7]+
    H[8]+H[9]+H[10]+H[11]+J[0]+J[1]+J[2]-J[3]-J[4]-J[5]+J[6]+J[7]+J[8]+J[9]+J[10]+J[11]+J[12]-J[13]-J[14]-J[15]+
    J[16]+J[17]+J[18]+J[19]+J[20]+J[21]-J[22]-J[23]-J[24]+J[25]+J[26]+J[27]+J[28]+J[29]-J[30]-J[31]-J[32]+
    J[33]+J[34]+J[35]+J[36]+J[37]+J[38]+J[39]-J[40]-J[41]-J[42]-J[43]-J[44]+J[45]-J[46]-J[47]-J[48]-J[49]-J[50]-J[51]-J[52]-J[53]-J[54]-J[55]+
    J[56]+J[57]+J[58]+J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]+H[1]+H[2]+H[3]-H[4]-H[5]-H[6]+H[7]+
    H[8]+H[9]+H[10]-H[11]+J[0]+J[1]+J[2]-J[3]-J[4]-J[5]+J[6]+J[7]+J[8]+J[9]-J[10]+J[11]+J[12]-J[13]-J[14]-J[15]+
    J[16]+J[17]+J[18]+J[19]-J[20]+J[21]-J[22]-J[23]-J[24]+J[25]+J[26]+J[27]+J[28]-J[29]-J[30]-J[31]-J[32]+
    J[33]+J[34]+J[35]+J[36]-J[37]+J[38]+J[39]-J[40]-J[41]-J[42]-J[43]+J[44]+J[45]-J[46]-J[47]-J[48]-J[49]+
    J[50]-J[51]-J[52]-J[53]-J[54]+J[55]+J[56]+J[57]+J[58]-J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]+
    H[1]+H[2]+H[3]-H[4]-H[5]-H[6]+H[7]+H[8]+H[9]-H[10]+H[11]+J[0]+J[1]+J[2]-J[3]-J[4]-J[5]+J[6]+J[7]+J[8]-J[9]+
    J[10]+J[11]+J[12]-J[13]-J[14]-J[15]+J[16]+J[17]+J[18]-J[19]+J[20]+J[21]-J[22]-J[23]-J[24]+J[25]+J[26]+
    J[27]-J[28]+J[29]-J[30]-J[31]-J[32]+J[33]+J[34]+J[35]-J[36]+J[37]+J[38]+J[39]-J[40]-J[41]-J[42]+J[43]-J[44]+
    J[45]-J[46]-J[47]-J[48]+J[49]-J[50]-J[51]-J[52]-J[53]+J[54]-J[55]+J[56]+J[57]-J[58]+J[59]+J[60]-J[61]+
    J[62]-J[63]+J[64]-J[65], +H[0]+H[1]+H[2]+H[3]-H[4]-H[5]-H[6]+H[7]+H[8]+H[9]-H[10]-H[11]+J[0]+J[1]+J[2]-J[3]-J[4]-J[5]+
    J[6]+J[7]+J[8]-J[9]-J[10]+J[11]+J[12]-J[13]-J[14]-J[15]+J[16]+J[17]+J[18]-J[19]-J[20]+J[21]-J[22]-J[23]-J[24]+
    J[25]+J[26]+J[27]-J[28]-J[29]-J[30]-J[31]-J[32]+J[33]+J[34]+J[35]-J[36]-J[37]+J[38]+J[39]-J[40]-J[41]-J[42]+
    J[43]+J[44]+J[45]-J[46]-J[47]-J[48]+J[49]+J[50]-J[51]-J[52]-J[53]+J[54]+J[55]+J[56]+J[57]-J[58]-J[59]+
    J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]+H[1]+H[2]+H[3]-H[4]-H[5]-H[6]+H[7]+H[8]-H[9]+H[10]+H[11]+
    J[0]+J[1]+J[2]-J[3]-J[4]-J[5]+J[6]+J[7]-J[8]+J[9]+J[10]+J[11]+J[12]-J[13]-J[14]-J[15]+J[16]+J[17]-J[18]+
    J[19]+J[20]+J[21]-J[22]-J[23]-J[24]+J[25]+J[26]-J[27]+J[28]+J[29]-J[30]-J[31]-J[32]+J[33]+J[34]-J[35]+
    J[36]+J[37]+J[38]+J[39]-J[40]-J[41]+J[42]-J[43]-J[44]+J[45]-J[46]-J[47]+J[48]-J[49]-J[50]-J[51]-J[52]+
    J[53]-J[54]-J[55]+J[56]-J[57]+J[58]+J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]+H[1]+H[2]+H[3]-H[4]-H[5]-H[6]+
    H[7]+H[8]-H[9]+H[10]-H[11]+J[0]+J[1]+J[2]-J[3]-J[4]-J[5]+J[6]+J[7]-J[8]+J[9]-J[10]+J[11]+J[12]-J[13]-J[14]-J[15]+
    J[16]+J[17]-J[18]+J[19]-J[20]+J[21]-J[22]-J[23]-J[24]+J[25]+J[26]-J[27]+J[28]-J[29]-J[30]-J[31]-J[32]+
    J[33]+J[34]-J[35]+J[36]-J[37]+J[38]+J[39]-J[40]-J[41]+J[42]-J[43]+J[44]+J[45]-J[46]-J[47]+J[48]-J[49]+
    J[50]-J[51]-J[52]+J[53]-J[54]+J[55]+J[56]-J[57]+J[58]-J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]+
    H[1]+H[2]+H[3]-H[4]-H[5]-H[6]+H[7]+H[8]-H[9]-H[10]+H[11]+J[0]+J[1]+J[2]-J[3]-J[4]-J[5]+J[6]+J[7]-J[8]-J[9]+
    J[10]+J[11]+J[12]-J[13]-J[14]-J[15]+J[16]+J[17]-J[18]-J[19]+J[20]+J[21]-J[22]-J[23]-J[24]+J[25]+J[26]-J[27]-J[28]+
    J[29]-J[30]-J[31]-J[32]+J[33]+J[34]-J[35]-J[36]+J[37]+J[38]+J[39]-J[40]-J[41]+J[42]+J[43]-J[44]+J[45]-J[46]-J[47]+
    J[48]+J[49]-J[50]-J[51]-J[52]+J[53]+J[54]-J[55]+J[56]-J[57]-J[58]+J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +
    H[0]+H[1]+H[2]+H[3]-H[4]-H[5]-H[6]+H[7]+H[8]-H[9]-H[10]-H[11]+J[0]+J[1]+J[2]-J[3]-J[4]-J[5]+J[6]+J[7]-J[8]-J[9]-J[10]+
    J[11]+J[12]-J[13]-J[14]-J[15]+J[16]+J[17]-J[18]-J[19]-J[20]+J[21]-J[22]-J[23]-J[24]+J[25]+J[26]-J[27]-J[28]-J[29]-J[30]-J[31]-J[32]+
    J[33]+J[34]-J[35]-J[36]-J[37]+J[38]+J[39]-J[40]-J[41]+J[42]+J[43]+J[44]+J[45]-J[46]-J[47]+J[48]+J[49]+
    J[50]-J[51]-J[52]+J[53]+J[54]+J[55]+J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]+
    H[1]+H[2]+H[3]-H[4]-H[5]-H[6]+H[7]-H[8]+H[9]+H[10]+H[11]+J[0]+J[1]+J[2]-J[3]-J[4]-J[5]+J[6]-J[7]+J[8]+
    J[9]+J[10]+J[11]+J[12]-J[13]-J[14]-J[15]+J[16]-J[17]+J[18]+J[19]+J[20]+J[21]-J[22]-J[23]-J[24]+J[25]-J[26]+
    J[27]+J[28]+J[29]-J[30]-J[31]-J[32]+J[33]-J[34]+J[35]+J[36]+J[37]+J[38]+J[39]-J[40]+J[41]-J[42]-J[43]-J[44]+
    J[45]-J[46]+J[47]-J[48]-J[49]-J[50]-J[51]+J[52]-J[53]-J[54]-J[55]-J[56]+J[57]+J[58]+J[59]-J[60]-J[61]-J[62]+
    J[63]+J[64]+J[65], +H[0]+H[1]+H[2]+H[3]-H[4]-H[5]-H[6]+H[7]-H[8]+H[9]+H[10]-H[11]+J[0]+J[1]+J[2]-J[3]-J[4]-J[5]+
    J[6]-J[7]+J[8]+J[9]-J[10]+J[11]+J[12]-J[13]-J[14]-J[15]+J[16]-J[17]+J[18]+J[19]-J[20]+J[21]-J[22]-J[23]-J[24]+
    J[25]-J[26]+J[27]+J[28]-J[29]-J[30]-J[31]-J[32]+J[33]-J[34]+J[35]+J[36]-J[37]+J[38]+J[39]-J[40]+J[41]-J[42]-J[43]+
    J[44]+J[45]-J[46]+J[47]-J[48]-J[49]+J[50]-J[51]+J[52]-J[53]-J[54]+J[55]-J[56]+J[57]+J[58]-J[59]-J[60]-J[61]+
    J[62]+J[63]-J[64]-J[65], +H[0]+H[1]+H[2]+H[3]-H[4]-H[5]-H[6]+H[7]-H[8]+H[9]-H[10]+H[11]+J[0]+J[1]+J[2]-J[3]-J[4]-J[5]+
    J[6]-J[7]+J[8]-J[9]+J[10]+J[11]+J[12]-J[13]-J[14]-J[15]+J[16]-J[17]+J[18]-J[19]+J[20]+J[21]-J[22]-J[23]-J[24]+
    J[25]-J[26]+J[27]-J[28]+J[29]-J[30]-J[31]-J[32]+J[33]-J[34]+J[35]-J[36]+J[37]+J[38]+J[39]-J[40]+J[41]-J[42]+
    J[43]-J[44]+J[45]-J[46]+J[47]-J[48]+J[49]-J[50]-J[51]+J[52]-J[53]+J[54]-J[55]-J[56]+J[57]-J[58]+J[59]-J[60]+
    J[61]-J[62]-J[63]+J[64]-J[65], +H[0]+H[1]+H[2]+H[3]-H[4]-H[5]-H[6]+H[7]-H[8]+H[9]-H[10]-H[11]+J[0]+J[1]+
    J[2]-J[3]-J[4]-J[5]+J[6]-J[7]+J[8]-J[9]-J[10]+J[11]+J[12]-J[13]-J[14]-J[15]+J[16]-J[17]+J[18]-J[19]-J[20]+
    J[21]-J[22]-J[23]-J[24]+J[25]-J[26]+J[27]-J[28]-J[29]-J[30]-J[31]-J[32]+J[33]-J[34]+J[35]-J[36]-J[37]+
    J[38]+J[39]-J[40]+J[41]-J[42]+J[43]+J[44]+J[45]-J[46]+J[47]-J[48]+J[49]+J[50]-J[51]+J[52]-J[53]+J[54]+
    J[55]-J[56]+J[57]-J[58]-J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]+H[1]+H[2]+H[3]-H[4]-H[5]-H[6]+
    H[7]-H[8]-H[9]+H[10]+H[11]+J[0]+J[1]+J[2]-J[3]-J[4]-J[5]+J[6]-J[7]-J[8]+J[9]+J[10]+J[11]+J[12]-J[13]-J[14]-J[15]+
    J[16]-J[17]-J[18]+J[19]+J[20]+J[21]-J[22]-J[23]-J[24]+J[25]-J[26]-J[27]+J[28]+J[29]-J[30]-J[31]-J[32]+
    J[33]-J[34]-J[35]+J[36]+J[37]+J[38]+J[39]-J[40]+J[41]+J[42]-J[43]-J[44]+J[45]-J[46]+J[47]+J[48]-J[49]-J[50]-J[51]+
    J[52]+J[53]-J[54]-J[55]-J[56]-J[57]+J[58]+J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]+H[1]+H[2]+
    H[3]-H[4]-H[5]-H[6]+H[7]-H[8]-H[9]+H[10]-H[11]+J[0]+J[1]+J[2]-J[3]-J[4]-J[5]+J[6]-J[7]-J[8]+J[9]-J[10]+
    J[11]+J[12]-J[13]-J[14]-J[15]+J[16]-J[17]-J[18]+J[19]-J[20]+J[21]-J[22]-J[23]-J[24]+J[25]-J[26]-J[27]+
    J[28]-J[29]-J[30]-J[31]-J[32]+J[33]-J[34]-J[35]+J[36]-J[37]+J[38]+J[39]-J[40]+J[41]+J[42]-J[43]+J[44]+
    J[45]-J[46]+J[47]+J[48]-J[49]+J[50]-J[51]+J[52]+J[53]-J[54]+J[55]-J[56]-J[57]+J[58]-J[59]+J[60]-J[61]+
    J[62]-J[63]+J[64]-J[65], +H[0]+H[1]+H[2]+H[3]-H[4]-H[5]-H[6]+H[7]-H[8]-H[9]-H[10]+H[11]+J[0]+J[1]+J[2]-J[3]-J[4]-J[5]+
    J[6]-J[7]-J[8]-J[9]+J[10]+J[11]+J[12]-J[13]-J[14]-J[15]+J[16]-J[17]-J[18]-J[19]+J[20]+J[21]-J[22]-J[23]-J[24]+
    J[25]-J[26]-J[27]-J[28]+J[29]-J[30]-J[31]-J[32]+J[33]-J[34]-J[35]-J[36]+J[37]+J[38]+J[39]-J[40]+J[41]+
    J[42]+J[43]-J[44]+J[45]-J[46]+J[47]+J[48]+J[49]-J[50]-J[51]+J[52]+J[53]+J[54]-J[55]-J[56]-J[57]-J[58]+
    J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]+H[1]+H[2]+H[3]-H[4]-H[5]-H[6]+H[7]-H[8]-H[9]-H[10]-H[11]+
    J[0]+J[1]+J[2]-J[3]-J[4]-J[5]+J[6]-J[7]-J[8]-J[9]-J[10]+J[11]+J[12]-J[13]-J[14]-J[15]+J[16]-J[17]-J[18]-J[19]-J[20]+
    J[21]-J[22]-J[23]-J[24]+J[25]-J[26]-J[27]-J[28]-J[29]-J[30]-J[31]-J[32]+J[33]-J[34]-J[35]-J[36]-J[37]+
    J[38]+J[39]-J[40]+J[41]+J[42]+J[43]+J[44]+J[45]-J[46]+J[47]+J[48]+J[49]+J[50]-J[51]+J[52]+J[53]+J[54]+
    J[55]-J[56]-J[57]-J[58]-J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]+H[1]+H[2]+H[3]-H[4]-H[5]-H[6]-H[7]+
    H[8]+H[9]+H[10]+H[11]+J[0]+J[1]+J[2]-J[3]-J[4]-J[5]-J[6]+J[7]+J[8]+J[9]+J[10]+J[11]+J[12]-J[13]-J[14]-J[15]-J[16]+
    J[17]+J[18]+J[19]+J[20]+J[21]-J[22]-J[23]-J[24]-J[25]+J[26]+J[27]+J[28]+J[29]-J[30]-J[31]-J[32]-J[33]+
    J[34]+J[35]+J[36]+J[37]+J[38]+J[39]+J[40]-J[41]-J[42]-J[43]-J[44]+J[45]+J[46]-J[47]-J[48]-J[49]-J[50]+
    J[51]-J[52]-J[53]-J[54]-J[55]-J[56]-J[57]-J[58]-J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]+H[1]+
    H[2]+H[3]-H[4]-H[5]-H[6]-H[7]+H[8]+H[9]+H[10]-H[11]+J[0]+J[1]+J[2]-J[3]-J[4]-J[5]-J[6]+J[7]+J[8]+J[9]-J[10]+
    J[11]+J[12]-J[13]-J[14]-J[15]-J[16]+J[17]+J[18]+J[19]-J[20]+J[21]-J[22]-J[23]-J[24]-J[25]+J[26]+J[27]+
    J[28]-J[29]-J[30]-J[31]-J[32]-J[33]+J[34]+J[35]+J[36]-J[37]+J[38]+J[39]+J[40]-J[41]-J[42]-J[43]+J[44]+
    J[45]+J[46]-J[47]-J[48]-J[49]+J[50]+J[51]-J[52]-J[53]-J[54]+J[55]-J[56]-J[57]-J[58]+J[59]+J[60]+J[61]-J[62]+
    J[63]-J[64]-J[65], +H[0]+H[1]+H[2]+H[3]-H[4]-H[5]-H[6]-H[7]+H[8]+H[9]-H[10]+H[11]+J[0]+J[1]+J[2]-J[3]-J[4]-J[5]-J[6]+
    J[7]+J[8]-J[9]+J[10]+J[11]+J[12]-J[13]-J[14]-J[15]-J[16]+J[17]+J[18]-J[19]+J[20]+J[21]-J[22]-J[23]-J[24]-J[25]+
    J[26]+J[27]-J[28]+J[29]-J[30]-J[31]-J[32]-J[33]+J[34]+J[35]-J[36]+J[37]+J[38]+J[39]+J[40]-J[41]-J[42]+
    J[43]-J[44]+J[45]+J[46]-J[47]-J[48]+J[49]-J[50]+J[51]-J[52]-J[53]+J[54]-J[55]-J[56]-J[57]+J[58]-J[59]+
    J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]+H[1]+H[2]+H[3]-H[4]-H[5]-H[6]-H[7]+H[8]+H[9]-H[10]-H[11]+
    J[0]+J[1]+J[2]-J[3]-J[4]-J[5]-J[6]+J[7]+J[8]-J[9]-J[10]+J[11]+J[12]-J[13]-J[14]-J[15]-J[16]+J[17]+J[18]-J[19]-J[20]+
    J[21]-J[22]-J[23]-J[24]-J[25]+J[26]+J[27]-J[28]-J[29]-J[30]-J[31]-J[32]-J[33]+J[34]+J[35]-J[36]-J[37]+
    J[38]+J[39]+J[40]-J[41]-J[42]+J[43]+J[44]+J[45]+J[46]-J[47]-J[48]+J[49]+J[50]+J[51]-J[52]-J[53]+J[54]+
    J[55]-J[56]-J[57]+J[58]+J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]+H[1]+H[2]+H[3]-H[4]-H[5]-H[6]-H[7]+
    H[8]-H[9]+H[10]+H[11]+J[0]+J[1]+J[2]-J[3]-J[4]-J[5]-J[6]+J[7]-J[8]+J[9]+J[10]+J[11]+J[12]-J[13]-J[14]-J[15]-J[16]+
    J[17]-J[18]+J[19]+J[20]+J[21]-J[22]-J[23]-J[24]-J[25]+J[26]-J[27]+J[28]+J[29]-J[30]-J[31]-J[32]-J[33]+
    J[34]-J[35]+J[36]+J[37]+J[38]+J[39]+J[40]-J[41]+J[42]-J[43]-J[44]+J[45]+J[46]-J[47]+J[48]-J[49]-J[50]+
    J[51]-J[52]+J[53]-J[54]-J[55]-J[56]+J[57]-J[58]-J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]+H[1]+
    H[2]+H[3]-H[4]-H[5]-H[6]-H[7]+H[8]-H[9]+H[10]-H[11]+J[0]+J[1]+J[2]-J[3]-J[4]-J[5]-J[6]+J[7]-J[8]+J[9]-J[10]+
    J[11]+J[12]-J[13]-J[14]-J[15]-J[16]+J[17]-J[18]+J[19]-J[20]+J[21]-J[22]-J[23]-J[24]-J[25]+J[26]-J[27]+
    J[28]-J[29]-J[30]-J[31]-J[32]-J[33]+J[34]-J[35]+J[36]-J[37]+J[38]+J[39]+J[40]-J[41]+J[42]-J[43]+J[44]+
    J[45]+J[46]-J[47]+J[48]-J[49]+J[50]+J[51]-J[52]+J[53]-J[54]+J[55]-J[56]+J[57]-J[58]+J[59]-J[60]+J[61]-J[62]-J[63]+
    J[64]-J[65], +H[0]+H[1]+H[2]+H[3]-H[4]-H[5]-H[6]-H[7]+H[8]-H[9]-H[10]+H[11]+J[0]+J[1]+J[2]-J[3]-J[4]-J[5]-J[6]+
    J[7]-J[8]-J[9]+J[10]+J[11]+J[12]-J[13]-J[14]-J[15]-J[16]+J[17]-J[18]-J[19]+J[20]+J[21]-J[22]-J[23]-J[24]-J[25]+
    J[26]-J[27]-J[28]+J[29]-J[30]-J[31]-J[32]-J[33]+J[34]-J[35]-J[36]+J[37]+J[38]+J[39]+J[40]-J[41]+J[42]+
    J[43]-J[44]+J[45]+J[46]-J[47]+J[48]+J[49]-J[50]+J[51]-J[52]+J[53]+J[54]-J[55]-J[56]+J[57]+J[58]-J[59]-J[60]-J[61]+
    J[62]+J[63]-J[64]-J[65], +H[0]+H[1]+H[2]+H[3]-H[4]-H[5]-H[6]-H[7]+H[8]-H[9]-H[10]-H[11]+J[0]+J[1]+J[2]-J[3]-J[4]-J[5]-J[6]+
    J[7]-J[8]-J[9]-J[10]+J[11]+J[12]-J[13]-J[14]-J[15]-J[16]+J[17]-J[18]-J[19]-J[20]+J[21]-J[22]-J[23]-J[24]-J[25]+
    J[26]-J[27]-J[28]-J[29]-J[30]-J[31]-J[32]-J[33]+J[34]-J[35]-J[36]-J[37]+J[38]+J[39]+J[40]-J[41]+J[42]+
    J[43]+J[44]+J[45]+J[46]-J[47]+J[48]+J[49]+J[50]+J[51]-J[52]+J[53]+J[54]+J[55]-J[56]+J[57]+J[58]+J[59]-J[60]-J[61]-J[62]+
    J[63]+J[64]+J[65], +H[0]+H[1]+H[2]+H[3]-H[4]-H[5]-H[6]-H[7]-H[8]+H[9]+H[10]+H[11]+J[0]+J[1]+J[2]-J[3]-J[4]-J[5]-J[6]-J[7]+
    J[8]+J[9]+J[10]+J[11]+J[12]-J[13]-J[14]-J[15]-J[16]-J[17]+J[18]+J[19]+J[20]+J[21]-J[22]-J[23]-J[24]-J[25]-J[26]+
    J[27]+J[28]+J[29]-J[30]-J[31]-J[32]-J[33]-J[34]+J[35]+J[36]+J[37]+J[38]+J[39]+J[40]+J[41]-J[42]-J[43]-J[44]+
    J[45]+J[46]+J[47]-J[48]-J[49]-J[50]+J[51]+J[52]-J[53]-J[54]-J[55]+J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+
    J[63]+J[64]+J[65], +H[0]+H[1]+H[2]+H[3]-H[4]-H[5]-H[6]-H[7]-H[8]+H[9]+H[10]-H[11]+J[0]+J[1]+J[2]-J[3]-J[4]-J[5]-J[6]-J[7]+
    J[8]+J[9]-J[10]+J[11]+J[12]-J[13]-J[14]-J[15]-J[16]-J[17]+J[18]+J[19]-J[20]+J[21]-J[22]-J[23]-J[24]-J[25]-J[26]+
    J[27]+J[28]-J[29]-J[30]-J[31]-J[32]-J[33]-J[34]+J[35]+J[36]-J[37]+J[38]+J[39]+J[40]+J[41]-J[42]-J[43]+
    J[44]+J[45]+J[46]+J[47]-J[48]-J[49]+J[50]+J[51]+J[52]-J[53]-J[54]+J[55]+J[56]-J[57]-J[58]+J[59]-J[60]-J[61]+
    J[62]+J[63]-J[64]-J[65], +H[0]+H[1]+H[2]+H[3]-H[4]-H[5]-H[6]-H[7]-H[8]+H[9]-H[10]+H[11]+J[0]+J[1]+J[2]-J[3]-J[4]-J[5]-J[6]-J[7]+
    J[8]-J[9]+J[10]+J[11]+J[12]-J[13]-J[14]-J[15]-J[16]-J[17]+J[18]-J[19]+J[20]+J[21]-J[22]-J[23]-J[24]-J[25]-J[26]+
    J[27]-J[28]+J[29]-J[30]-J[31]-J[32]-J[33]-J[34]+J[35]-J[36]+J[37]+J[38]+J[39]+J[40]+J[41]-J[42]+J[43]-J[44]+
    J[45]+J[46]+J[47]-J[48]+J[49]-J[50]+J[51]+J[52]-J[53]+J[54]-J[55]+J[56]-J[57]+J[58]-J[59]-J[60]+J[61]-J[62]-J[63]+
    J[64]-J[65], +H[0]+H[1]+H[2]+H[3]-H[4]-H[5]-H[6]-H[7]-H[8]+H[9]-H[10]-H[11]+J[0]+J[1]+J[2]-J[3]-J[4]-J[5]-J[6]-J[7]+
    J[8]-J[9]-J[10]+J[11]+J[12]-J[13]-J[14]-J[15]-J[16]-J[17]+J[18]-J[19]-J[20]+J[21]-J[22]-J[23]-J[24]-J[25]-J[26]+
    J[27]-J[28]-J[29]-J[30]-J[31]-J[32]-J[33]-J[34]+J[35]-J[36]-J[37]+J[38]+J[39]+J[40]+J[41]-J[42]+J[43]+
    J[44]+J[45]+J[46]+J[47]-J[48]+J[49]+J[50]+J[51]+J[52]-J[53]+J[54]+J[55]+J[56]-J[57]+J[58]+J[59]-J[60]+
    J[61]+J[62]-J[63]-J[64]+J[65], +H[0]+H[1]+H[2]+H[3]-H[4]-H[5]-H[6]-H[7]-H[8]-H[9]+H[10]+H[11]+J[0]+J[1]+
    J[2]-J[3]-J[4]-J[5]-J[6]-J[7]-J[8]+J[9]+J[10]+J[11]+J[12]-J[13]-J[14]-J[15]-J[16]-J[17]-J[18]+J[19]+
    J[20]+J[21]-J[22]-J[23]-J[24]-J[25]-J[26]-J[27]+J[28]+J[29]-J[30]-J[31]-J[32]-J[33]-J[34]-J[35]+J[36]+
    J[37]+J[38]+J[39]+J[40]+J[41]+J[42]-J[43]-J[44]+J[45]+J[46]+J[47]+J[48]-J[49]-J[50]+J[51]+J[52]+J[53]-J[54]-J[55]+
    J[56]+J[57]-J[58]-J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]+H[1]+H[2]+H[3]-H[4]-H[5]-H[6]-H[7]-H[8]-H[9]+
    H[10]-H[11]+J[0]+J[1]+J[2]-J[3]-J[4]-J[5]-J[6]-J[7]-J[8]+J[9]-J[10]+J[11]+J[12]-J[13]-J[14]-J[15]-J[16]-J[17]-J[18]+
    J[19]-J[20]+J[21]-J[22]-J[23]-J[24]-J[25]-J[26]-J[27]+J[28]-J[29]-J[30]-J[31]-J[32]-J[33]-J[34]-J[35]+
    J[36]-J[37]+J[38]+J[39]+J[40]+J[41]+J[42]-J[43]+J[44]+J[45]+J[46]+J[47]+J[48]-J[49]+J[50]+J[51]+J[52]+
    J[53]-J[54]+J[55]+J[56]+J[57]-J[58]+J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]+H[1]+H[2]+H[3]-H[4]-H[5]-H[6]-H[7]-H[8]-H[9]-H[10]+
    H[11]+J[0]+J[1]+J[2]-J[3]-J[4]-J[5]-J[6]-J[7]-J[8]-J[9]+J[10]+J[11]+J[12]-J[13]-J[14]-J[15]-J[16]-J[17]-J[18]-J[19]+
    J[20]+J[21]-J[22]-J[23]-J[24]-J[25]-J[26]-J[27]-J[28]+J[29]-J[30]-J[31]-J[32]-J[33]-J[34]-J[35]-J[36]+
    J[37]+J[38]+J[39]+J[40]+J[41]+J[42]+J[43]-J[44]+J[45]+J[46]+J[47]+J[48]+J[49]-J[50]+J[51]+J[52]+J[53]+
    J[54]-J[55]+J[56]+J[57]+J[58]-J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]+H[1]+H[2]+H[3]-H[4]-H[5]-H[6]-H[7]-H[8]-H[9]-H[10]-H[11]+
    J[0]+J[1]+J[2]-J[3]-J[4]-J[5]-J[6]-J[7]-J[8]-J[9]-J[10]+J[11]+J[12]-J[13]-J[14]-J[15]-J[16]-J[17]-J[18]-J[19]-J[20]+
    J[21]-J[22]-J[23]-J[24]-J[25]-J[26]-J[27]-J[28]-J[29]-J[30]-J[31]-J[32]-J[33]-J[34]-J[35]-J[36]-J[37]+
    J[38]+J[39]+J[40]+J[41]+J[42]+J[43]+J[44]+J[45]+J[46]+J[47]+J[48]+J[49]+J[50]+J[51]+J[52]+J[53]+J[54]+
    J[55]+J[56]+J[57]+J[58]+J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]+H[1]+H[2]-H[3]+H[4]+H[5]+H[6]+
    H[7]+H[8]+H[9]+H[10]+H[11]+J[0]+J[1]-J[2]+J[3]+J[4]+J[5]+J[6]+J[7]+J[8]+J[9]+J[10]+J[11]-J[12]+J[13]+
    J[14]+J[15]+J[16]+J[17]+J[18]+J[19]+J[20]-J[21]+J[22]+J[23]+J[24]+J[25]+J[26]+J[27]+J[28]+J[29]-J[30]-J[31]-J[32]-J[33]-J[34]-J[35]-J[36]-J[37]+
    J[38]+J[39]+J[40]+J[41]+J[42]+J[43]+J[44]+J[45]+J[46]+J[47]+J[48]+J[49]+J[50]+J[51]+J[52]+J[53]+J[54]+
    J[55]+J[56]+J[57]+J[58]+J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]+H[1]+H[2]-H[3]+H[4]+H[5]+H[6]+
    H[7]+H[8]+H[9]+H[10]-H[11]+J[0]+J[1]-J[2]+J[3]+J[4]+J[5]+J[6]+J[7]+J[8]+J[9]-J[10]+J[11]-J[12]+J[13]+
    J[14]+J[15]+J[16]+J[17]+J[18]+J[19]-J[20]-J[21]+J[22]+J[23]+J[24]+J[25]+J[26]+J[27]+J[28]-J[29]-J[30]-J[31]-J[32]-J[33]-J[34]-J[35]-J[36]+
    J[37]+J[38]+J[39]+J[40]+J[41]+J[42]+J[43]-J[44]+J[45]+J[46]+J[47]+J[48]+J[49]-J[50]+J[51]+J[52]+J[53]+
    J[54]-J[55]+J[56]+J[57]+J[58]-J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]+H[1]+H[2]-H[3]+H[4]+H[5]+
    H[6]+H[7]+H[8]+H[9]-H[10]+H[11]+J[0]+J[1]-J[2]+J[3]+J[4]+J[5]+J[6]+J[7]+J[8]-J[9]+J[10]+J[11]-J[12]+
    J[13]+J[14]+J[15]+J[16]+J[17]+J[18]-J[19]+J[20]-J[21]+J[22]+J[23]+J[24]+J[25]+J[26]+J[27]-J[28]+J[29]-J[30]-J[31]-J[32]-J[33]-J[34]-J[35]+
    J[36]-J[37]+J[38]+J[39]+J[40]+J[41]+J[42]-J[43]+J[44]+J[45]+J[46]+J[47]+J[48]-J[49]+J[50]+J[51]+J[52]+
    J[53]-J[54]+J[55]+J[56]+J[57]-J[58]+J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]+H[1]+H[2]-H[3]+
    H[4]+H[5]+H[6]+H[7]+H[8]+H[9]-H[10]-H[11]+J[0]+J[1]-J[2]+J[3]+J[4]+J[5]+J[6]+J[7]+J[8]-J[9]-J[10]+J[11]-J[12]+
    J[13]+J[14]+J[15]+J[16]+J[17]+J[18]-J[19]-J[20]-J[21]+J[22]+J[23]+J[24]+J[25]+J[26]+J[27]-J[28]-J[29]-J[30]-J[31]-J[32]-J[33]-J[34]-J[35]+
    J[36]+J[37]+J[38]+J[39]+J[40]+J[41]+J[42]-J[43]-J[44]+J[45]+J[46]+J[47]+J[48]-J[49]-J[50]+J[51]+J[52]+
    J[53]-J[54]-J[55]+J[56]+J[57]-J[58]-J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]+H[1]+H[2]-H[3]+
    H[4]+H[5]+H[6]+H[7]+H[8]-H[9]+H[10]+H[11]+J[0]+J[1]-J[2]+J[3]+J[4]+J[5]+J[6]+J[7]-J[8]+J[9]+J[10]+J[11]-J[12]+
    J[13]+J[14]+J[15]+J[16]+J[17]-J[18]+J[19]+J[20]-J[21]+J[22]+J[23]+J[24]+J[25]+J[26]-J[27]+J[28]+J[29]-J[30]-J[31]-J[32]-J[33]-J[34]+
    J[35]-J[36]-J[37]+J[38]+J[39]+J[40]+J[41]-J[42]+J[43]+J[44]+J[45]+J[46]+J[47]-J[48]+J[49]+J[50]+J[51]+
    J[52]-J[53]+J[54]+J[55]+J[56]-J[57]+J[58]+J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]+H[1]+H[2]-H[3]+
    H[4]+H[5]+H[6]+H[7]+H[8]-H[9]+H[10]-H[11]+J[0]+J[1]-J[2]+J[3]+J[4]+J[5]+J[6]+J[7]-J[8]+J[9]-J[10]+J[11]-J[12]+
    J[13]+J[14]+J[15]+J[16]+J[17]-J[18]+J[19]-J[20]-J[21]+J[22]+J[23]+J[24]+J[25]+J[26]-J[27]+J[28]-J[29]-J[30]-J[31]-J[32]-J[33]-J[34]+
    J[35]-J[36]+J[37]+J[38]+J[39]+J[40]+J[41]-J[42]+J[43]-J[44]+J[45]+J[46]+J[47]-J[48]+J[49]-J[50]+J[51]+
    J[52]-J[53]+J[54]-J[55]+J[56]-J[57]+J[58]-J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]+H[1]+H[2]-H[3]+
    H[4]+H[5]+H[6]+H[7]+H[8]-H[9]-H[10]+H[11]+J[0]+J[1]-J[2]+J[3]+J[4]+J[5]+J[6]+J[7]-J[8]-J[9]+J[10]+J[11]-J[12]+
    J[13]+J[14]+J[15]+J[16]+J[17]-J[18]-J[19]+J[20]-J[21]+J[22]+J[23]+J[24]+J[25]+J[26]-J[27]-J[28]+J[29]-J[30]-J[31]-J[32]-J[33]-J[34]+
    J[35]+J[36]-J[37]+J[38]+J[39]+J[40]+J[41]-J[42]-J[43]+J[44]+J[45]+J[46]+J[47]-J[48]-J[49]+J[50]+J[51]+
    J[52]-J[53]-J[54]+J[55]+J[56]-J[57]-J[58]+J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]+H[1]+H[2]-H[3]+
    H[4]+H[5]+H[6]+H[7]+H[8]-H[9]-H[10]-H[11]+J[0]+J[1]-J[2]+J[3]+J[4]+J[5]+J[6]+J[7]-J[8]-J[9]-J[10]+J[11]-J[12]+
    J[13]+J[14]+J[15]+J[16]+J[17]-J[18]-J[19]-J[20]-J[21]+J[22]+J[23]+J[24]+J[25]+J[26]-J[27]-J[28]-J[29]-J[30]-J[31]-J[32]-J[33]-J[34]+
    J[35]+J[36]+J[37]+J[38]+J[39]+J[40]+J[41]-J[42]-J[43]-J[44]+J[45]+J[46]+J[47]-J[48]-J[49]-J[50]+J[51]+
    J[52]-J[53]-J[54]-J[55]+J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]+H[1]+H[2]-H[3]+
    H[4]+H[5]+H[6]+H[7]-H[8]+H[9]+H[10]+H[11]+J[0]+J[1]-J[2]+J[3]+J[4]+J[5]+J[6]-J[7]+J[8]+J[9]+J[10]+J[11]-J[12]+
    J[13]+J[14]+J[15]+J[16]-J[17]+J[18]+J[19]+J[20]-J[21]+J[22]+J[23]+J[24]+J[25]-J[26]+J[27]+J[28]+J[29]-J[30]-J[31]-J[32]-J[33]+
    J[34]-J[35]-J[36]-J[37]+J[38]+J[39]+J[40]-J[41]+J[42]+J[43]+J[44]+J[45]+J[46]-J[47]+J[48]+J[49]+J[50]+
    J[51]-J[52]+J[53]+J[54]+J[55]-J[56]+J[57]+J[58]+J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]+H[1]+
    H[2]-H[3]+H[4]+H[5]+H[6]+H[7]-H[8]+H[9]+H[10]-H[11]+J[0]+J[1]-J[2]+J[3]+J[4]+J[5]+J[6]-J[7]+J[8]+J[9]-J[10]+
    J[11]-J[12]+J[13]+J[14]+J[15]+J[16]-J[17]+J[18]+J[19]-J[20]-J[21]+J[22]+J[23]+J[24]+J[25]-J[26]+J[27]+
    J[28]-J[29]-J[30]-J[31]-J[32]-J[33]+J[34]-J[35]-J[36]+J[37]+J[38]+J[39]+J[40]-J[41]+J[42]+J[43]-J[44]+
    J[45]+J[46]-J[47]+J[48]+J[49]-J[50]+J[51]-J[52]+J[53]+J[54]-J[55]-J[56]+J[57]+J[58]-J[59]-J[60]-J[61]+
    J[62]+J[63]-J[64]-J[65], +H[0]+H[1]+H[2]-H[3]+H[4]+H[5]+H[6]+H[7]-H[8]+H[9]-H[10]+H[11]+J[0]+J[1]-J[2]+
    J[3]+J[4]+J[5]+J[6]-J[7]+J[8]-J[9]+J[10]+J[11]-J[12]+J[13]+J[14]+J[15]+J[16]-J[17]+J[18]-J[19]+J[20]-J[21]+
    J[22]+J[23]+J[24]+J[25]-J[26]+J[27]-J[28]+J[29]-J[30]-J[31]-J[32]-J[33]+J[34]-J[35]+J[36]-J[37]+J[38]+
    J[39]+J[40]-J[41]+J[42]-J[43]+J[44]+J[45]+J[46]-J[47]+J[48]-J[49]+J[50]+J[51]-J[52]+J[53]-J[54]+J[55]-J[56]+
    J[57]-J[58]+J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]+H[1]+H[2]-H[3]+H[4]+H[5]+H[6]+H[7]-H[8]+
    H[9]-H[10]-H[11]+J[0]+J[1]-J[2]+J[3]+J[4]+J[5]+J[6]-J[7]+J[8]-J[9]-J[10]+J[11]-J[12]+J[13]+J[14]+J[15]+
    J[16]-J[17]+J[18]-J[19]-J[20]-J[21]+J[22]+J[23]+J[24]+J[25]-J[26]+J[27]-J[28]-J[29]-J[30]-J[31]-J[32]-J[33]+
    J[34]-J[35]+J[36]+J[37]+J[38]+J[39]+J[40]-J[41]+J[42]-J[43]-J[44]+J[45]+J[46]-J[47]+J[48]-J[49]-J[50]+
    J[51]-J[52]+J[53]-J[54]-J[55]-J[56]+J[57]-J[58]-J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]+H[1]+
    H[2]-H[3]+H[4]+H[5]+H[6]+H[7]-H[8]-H[9]+H[10]+H[11]+J[0]+J[1]-J[2]+J[3]+J[4]+J[5]+J[6]-J[7]-J[8]+J[9]+
    J[10]+J[11]-J[12]+J[13]+J[14]+J[15]+J[16]-J[17]-J[18]+J[19]+J[20]-J[21]+J[22]+J[23]+J[24]+J[25]-J[26]-J[27]+
    J[28]+J[29]-J[30]-J[31]-J[32]-J[33]+J[34]+J[35]-J[36]-J[37]+J[38]+J[39]+J[40]-J[41]-J[42]+J[43]+J[44]+
    J[45]+J[46]-J[47]-J[48]+J[49]+J[50]+J[51]-J[52]-J[53]+J[54]+J[55]-J[56]-J[57]+J[58]+J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+
    J[65], +H[0]+H[1]+H[2]-H[3]+H[4]+H[5]+H[6]+H[7]-H[8]-H[9]+H[10]-H[11]+J[0]+J[1]-J[2]+J[3]+J[4]+J[5]+
    J[6]-J[7]-J[8]+J[9]-J[10]+J[11]-J[12]+J[13]+J[14]+J[15]+J[16]-J[17]-J[18]+J[19]-J[20]-J[21]+J[22]+J[23]+
    J[24]+J[25]-J[26]-J[27]+J[28]-J[29]-J[30]-J[31]-J[32]-J[33]+J[34]+J[35]-J[36]+J[37]+J[38]+J[39]+J[40]-J[41]-J[42]+
    J[43]-J[44]+J[45]+J[46]-J[47]-J[48]+J[49]-J[50]+J[51]-J[52]-J[53]+J[54]-J[55]-J[56]-J[57]+J[58]-J[59]+
    J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]+H[1]+H[2]-H[3]+H[4]+H[5]+H[6]+H[7]-H[8]-H[9]-H[10]+H[11]+
    J[0]+J[1]-J[2]+J[3]+J[4]+J[5]+J[6]-J[7]-J[8]-J[9]+J[10]+J[11]-J[12]+J[13]+J[14]+J[15]+J[16]-J[17]-J[18]-J[19]+
    J[20]-J[21]+J[22]+J[23]+J[24]+J[25]-J[26]-J[27]-J[28]+J[29]-J[30]-J[31]-J[32]-J[33]+J[34]+J[35]+J[36]-J[37]+
    J[38]+J[39]+J[40]-J[41]-J[42]-J[43]+J[44]+J[45]+J[46]-J[47]-J[48]-J[49]+J[50]+J[51]-J[52]-J[53]-J[54]+
    J[55]-J[56]-J[57]-J[58]+J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]+H[1]+H[2]-H[3]+H[4]+H[5]+H[6]+
    H[7]-H[8]-H[9]-H[10]-H[11]+J[0]+J[1]-J[2]+J[3]+J[4]+J[5]+J[6]-J[7]-J[8]-J[9]-J[10]+J[11]-J[12]+J[13]+
    J[14]+J[15]+J[16]-J[17]-J[18]-J[19]-J[20]-J[21]+J[22]+J[23]+J[24]+J[25]-J[26]-J[27]-J[28]-J[29]-J[30]-J[31]-J[32]-J[33]+
    J[34]+J[35]+J[36]+J[37]+J[38]+J[39]+J[40]-J[41]-J[42]-J[43]-J[44]+J[45]+J[46]-J[47]-J[48]-J[49]-J[50]+
    J[51]-J[52]-J[53]-J[54]-J[55]-J[56]-J[57]-J[58]-J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]+H[1]+
    H[2]-H[3]+H[4]+H[5]+H[6]-H[7]+H[8]+H[9]+H[10]+H[11]+J[0]+J[1]-J[2]+J[3]+J[4]+J[5]-J[6]+J[7]+J[8]+J[9]+
    J[10]+J[11]-J[12]+J[13]+J[14]+J[15]-J[16]+J[17]+J[18]+J[19]+J[20]-J[21]+J[22]+J[23]+J[24]-J[25]+J[26]+
    J[27]+J[28]+J[29]-J[30]-J[31]-J[32]+J[33]-J[34]-J[35]-J[36]-J[37]+J[38]+J[39]-J[40]+J[41]+J[42]+J[43]+
    J[44]+J[45]-J[46]+J[47]+J[48]+J[49]+J[50]-J[51]+J[52]+J[53]+J[54]+J[55]-J[56]-J[57]-J[58]-J[59]+J[60]+
    J[61]+J[62]+J[63]+J[64]+J[65], +H[0]+H[1]+H[2]-H[3]+H[4]+H[5]+H[6]-H[7]+H[8]+H[9]+H[10]-H[11]+J[0]+J[1]-J[2]+
    J[3]+J[4]+J[5]-J[6]+J[7]+J[8]+J[9]-J[10]+J[11]-J[12]+J[13]+J[14]+J[15]-J[16]+J[17]+J[18]+J[19]-J[20]-J[21]+
    J[22]+J[23]+J[24]-J[25]+J[26]+J[27]+J[28]-J[29]-J[30]-J[31]-J[32]+J[33]-J[34]-J[35]-J[36]+J[37]+J[38]+
    J[39]-J[40]+J[41]+J[42]+J[43]-J[44]+J[45]-J[46]+J[47]+J[48]+J[49]-J[50]-J[51]+J[52]+J[53]+J[54]-J[55]-J[56]-J[57]-J[58]+
    J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]+H[1]+H[2]-H[3]+H[4]+H[5]+H[6]-H[7]+H[8]+H[9]-H[10]+
    H[11]+J[0]+J[1]-J[2]+J[3]+J[4]+J[5]-J[6]+J[7]+J[8]-J[9]+J[10]+J[11]-J[12]+J[13]+J[14]+J[15]-J[16]+J[17]+
    J[18]-J[19]+J[20]-J[21]+J[22]+J[23]+J[24]-J[25]+J[26]+J[27]-J[28]+J[29]-J[30]-J[31]-J[32]+J[33]-J[34]-J[35]+
    J[36]-J[37]+J[38]+J[39]-J[40]+J[41]+J[42]-J[43]+J[44]+J[45]-J[46]+J[47]+J[48]-J[49]+J[50]-J[51]+J[52]+
    J[53]-J[54]+J[55]-J[56]-J[57]+J[58]-J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]+H[1]+H[2]-H[3]+
    H[4]+H[5]+H[6]-H[7]+H[8]+H[9]-H[10]-H[11]+J[0]+J[1]-J[2]+J[3]+J[4]+J[5]-J[6]+J[7]+J[8]-J[9]-J[10]+J[11]-J[12]+
    J[13]+J[14]+J[15]-J[16]+J[17]+J[18]-J[19]-J[20]-J[21]+J[22]+J[23]+J[24]-J[25]+J[26]+J[27]-J[28]-J[29]-J[30]-J[31]-J[32]+
    J[33]-J[34]-J[35]+J[36]+J[37]+J[38]+J[39]-J[40]+J[41]+J[42]-J[43]-J[44]+J[45]-J[46]+J[47]+J[48]-J[49]-J[50]-J[51]+
    J[52]+J[53]-J[54]-J[55]-J[56]-J[57]+J[58]+J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]+H[1]+H[2]-H[3]+
    H[4]+H[5]+H[6]-H[7]+H[8]-H[9]+H[10]+H[11]+J[0]+J[1]-J[2]+J[3]+J[4]+J[5]-J[6]+J[7]-J[8]+J[9]+J[10]+J[11]-J[12]+
    J[13]+J[14]+J[15]-J[16]+J[17]-J[18]+J[19]+J[20]-J[21]+J[22]+J[23]+J[24]-J[25]+J[26]-J[27]+J[28]+J[29]-J[30]-J[31]-J[32]+
    J[33]-J[34]+J[35]-J[36]-J[37]+J[38]+J[39]-J[40]+J[41]-J[42]+J[43]+J[44]+J[45]-J[46]+J[47]-J[48]+J[49]+
    J[50]-J[51]+J[52]-J[53]+J[54]+J[55]-J[56]+J[57]-J[58]-J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]+
    H[1]+H[2]-H[3]+H[4]+H[5]+H[6]-H[7]+H[8]-H[9]+H[10]-H[11]+J[0]+J[1]-J[2]+J[3]+J[4]+J[5]-J[6]+J[7]-J[8]+
    J[9]-J[10]+J[11]-J[12]+J[13]+J[14]+J[15]-J[16]+J[17]-J[18]+J[19]-J[20]-J[21]+J[22]+J[23]+J[24]-J[25]+
    J[26]-J[27]+J[28]-J[29]-J[30]-J[31]-J[32]+J[33]-J[34]+J[35]-J[36]+J[37]+J[38]+J[39]-J[40]+J[41]-J[42]+
    J[43]-J[44]+J[45]-J[46]+J[47]-J[48]+J[49]-J[50]-J[51]+J[52]-J[53]+J[54]-J[55]-J[56]+J[57]-J[58]+J[59]-J[60]+
    J[61]-J[62]-J[63]+J[64]-J[65], +H[0]+H[1]+H[2]-H[3]+H[4]+H[5]+H[6]-H[7]+H[8]-H[9]-H[10]+H[11]+J[0]+J[1]-J[2]+
    J[3]+J[4]+J[5]-J[6]+J[7]-J[8]-J[9]+J[10]+J[11]-J[12]+J[13]+J[14]+J[15]-J[16]+J[17]-J[18]-J[19]+J[20]-J[21]+
    J[22]+J[23]+J[24]-J[25]+J[26]-J[27]-J[28]+J[29]-J[30]-J[31]-J[32]+J[33]-J[34]+J[35]+J[36]-J[37]+J[38]+
    J[39]-J[40]+J[41]-J[42]-J[43]+J[44]+J[45]-J[46]+J[47]-J[48]-J[49]+J[50]-J[51]+J[52]-J[53]-J[54]+J[55]-J[56]+
    J[57]+J[58]-J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]+H[1]+H[2]-H[3]+H[4]+H[5]+H[6]-H[7]+H[8]-H[9]-H[10]-H[11]+
    J[0]+J[1]-J[2]+J[3]+J[4]+J[5]-J[6]+J[7]-J[8]-J[9]-J[10]+J[11]-J[12]+J[13]+J[14]+J[15]-J[16]+J[17]-J[18]-J[19]-J[20]-J[21]+
    J[22]+J[23]+J[24]-J[25]+J[26]-J[27]-J[28]-J[29]-J[30]-J[31]-J[32]+J[33]-J[34]+J[35]+J[36]+J[37]+J[38]+
    J[39]-J[40]+J[41]-J[42]-J[43]-J[44]+J[45]-J[46]+J[47]-J[48]-J[49]-J[50]-J[51]+J[52]-J[53]-J[54]-J[55]-J[56]+
    J[57]+J[58]+J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]+H[1]+H[2]-H[3]+H[4]+H[5]+H[6]-H[7]-H[8]+
    H[9]+H[10]+H[11]+J[0]+J[1]-J[2]+J[3]+J[4]+J[5]-J[6]-J[7]+J[8]+J[9]+J[10]+J[11]-J[12]+J[13]+J[14]+J[15]-J[16]-J[17]+
    J[18]+J[19]+J[20]-J[21]+J[22]+J[23]+J[24]-J[25]-J[26]+J[27]+J[28]+J[29]-J[30]-J[31]-J[32]+J[33]+J[34]-J[35]-J[36]-J[37]+
    J[38]+J[39]-J[40]-J[41]+J[42]+J[43]+J[44]+J[45]-J[46]-J[47]+J[48]+J[49]+J[50]-J[51]-J[52]+J[53]+J[54]+
    J[55]+J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]+H[1]+H[2]-H[3]+H[4]+H[5]+H[6]-H[7]-H[8]+
    H[9]+H[10]-H[11]+J[0]+J[1]-J[2]+J[3]+J[4]+J[5]-J[6]-J[7]+J[8]+J[9]-J[10]+J[11]-J[12]+J[13]+J[14]+J[15]-J[16]-J[17]+
    J[18]+J[19]-J[20]-J[21]+J[22]+J[23]+J[24]-J[25]-J[26]+J[27]+J[28]-J[29]-J[30]-J[31]-J[32]+J[33]+J[34]-J[35]-J[36]+
    J[37]+J[38]+J[39]-J[40]-J[41]+J[42]+J[43]-J[44]+J[45]-J[46]-J[47]+J[48]+J[49]-J[50]-J[51]-J[52]+J[53]+
    J[54]-J[55]+J[56]-J[57]-J[58]+J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]+H[1]+H[2]-H[3]+H[4]+H[5]+
    H[6]-H[7]-H[8]+H[9]-H[10]+H[11]+J[0]+J[1]-J[2]+J[3]+J[4]+J[5]-J[6]-J[7]+J[8]-J[9]+J[10]+J[11]-J[12]+
    J[13]+J[14]+J[15]-J[16]-J[17]+J[18]-J[19]+J[20]-J[21]+J[22]+J[23]+J[24]-J[25]-J[26]+J[27]-J[28]+J[29]-J[30]-J[31]-J[32]+
    J[33]+J[34]-J[35]+J[36]-J[37]+J[38]+J[39]-J[40]-J[41]+J[42]-J[43]+J[44]+J[45]-J[46]-J[47]+J[48]-J[49]+
    J[50]-J[51]-J[52]+J[53]-J[54]+J[55]+J[56]-J[57]+J[58]-J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]+
    H[1]+H[2]-H[3]+H[4]+H[5]+H[6]-H[7]-H[8]+H[9]-H[10]-H[11]+J[0]+J[1]-J[2]+J[3]+J[4]+J[5]-J[6]-J[7]+J[8]-J[9]-J[10]+
    J[11]-J[12]+J[13]+J[14]+J[15]-J[16]-J[17]+J[18]-J[19]-J[20]-J[21]+J[22]+J[23]+J[24]-J[25]-J[26]+J[27]-J[28]-J[29]-J[30]-J[31]-J[32]+
    J[33]+J[34]-J[35]+J[36]+J[37]+J[38]+J[39]-J[40]-J[41]+J[42]-J[43]-J[44]+J[45]-J[46]-J[47]+J[48]-J[49]-J[50]-J[51]-J[52]+
    J[53]-J[54]-J[55]+J[56]-J[57]+J[58]+J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]+H[1]+H[2]-H[3]+
    H[4]+H[5]+H[6]-H[7]-H[8]-H[9]+H[10]+H[11]+J[0]+J[1]-J[2]+J[3]+J[4]+J[5]-J[6]-J[7]-J[8]+J[9]+J[10]+J[11]-J[12]+
    J[13]+J[14]+J[15]-J[16]-J[17]-J[18]+J[19]+J[20]-J[21]+J[22]+J[23]+J[24]-J[25]-J[26]-J[27]+J[28]+J[29]-J[30]-J[31]-J[32]+
    J[33]+J[34]+J[35]-J[36]-J[37]+J[38]+J[39]-J[40]-J[41]-J[42]+J[43]+J[44]+J[45]-J[46]-J[47]-J[48]+J[49]+
    J[50]-J[51]-J[52]-J[53]+J[54]+J[55]+J[56]+J[57]-J[58]-J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]+
    H[1]+H[2]-H[3]+H[4]+H[5]+H[6]-H[7]-H[8]-H[9]+H[10]-H[11]+J[0]+J[1]-J[2]+J[3]+J[4]+J[5]-J[6]-J[7]-J[8]+
    J[9]-J[10]+J[11]-J[12]+J[13]+J[14]+J[15]-J[16]-J[17]-J[18]+J[19]-J[20]-J[21]+J[22]+J[23]+J[24]-J[25]-J[26]-J[27]+
    J[28]-J[29]-J[30]-J[31]-J[32]+J[33]+J[34]+J[35]-J[36]+J[37]+J[38]+J[39]-J[40]-J[41]-J[42]+J[43]-J[44]+
    J[45]-J[46]-J[47]-J[48]+J[49]-J[50]-J[51]-J[52]-J[53]+J[54]-J[55]+J[56]+J[57]-J[58]+J[59]+J[60]-J[61]+
    J[62]-J[63]+J[64]-J[65], +H[0]+H[1]+H[2]-H[3]+H[4]+H[5]+H[6]-H[7]-H[8]-H[9]-H[10]+H[11]+J[0]+J[1]-J[2]+
    J[3]+J[4]+J[5]-J[6]-J[7]-J[8]-J[9]+J[10]+J[11]-J[12]+J[13]+J[14]+J[15]-J[16]-J[17]-J[18]-J[19]+J[20]-J[21]+
    J[22]+J[23]+J[24]-J[25]-J[26]-J[27]-J[28]+J[29]-J[30]-J[31]-J[32]+J[33]+J[34]+J[35]+J[36]-J[37]+J[38]+
    J[39]-J[40]-J[41]-J[42]-J[43]+J[44]+J[45]-J[46]-J[47]-J[48]-J[49]+J[50]-J[51]-J[52]-J[53]-J[54]+J[55]+
    J[56]+J[57]+J[58]-J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]+H[1]+H[2]-H[3]+H[4]+H[5]+H[6]-H[7]-H[8]-H[9]-H[10]-H[11]+
    J[0]+J[1]-J[2]+J[3]+J[4]+J[5]-J[6]-J[7]-J[8]-J[9]-J[10]+J[11]-J[12]+J[13]+J[14]+J[15]-J[16]-J[17]-J[18]-J[19]-J[20]-J[21]+
    J[22]+J[23]+J[24]-J[25]-J[26]-J[27]-J[28]-J[29]-J[30]-J[31]-J[32]+J[33]+J[34]+J[35]+J[36]+J[37]+J[38]+
    J[39]-J[40]-J[41]-J[42]-J[43]-J[44]+J[45]-J[46]-J[47]-J[48]-J[49]-J[50]-J[51]-J[52]-J[53]-J[54]-J[55]+
    J[56]+J[57]+J[58]+J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]+H[1]+H[2]-H[3]+H[4]+H[5]-H[6]+H[7]+
    H[8]+H[9]+H[10]+H[11]+J[0]+J[1]-J[2]+J[3]+J[4]-J[5]+J[6]+J[7]+J[8]+J[9]+J[10]+J[11]-J[12]+J[13]+J[14]-J[15]+
    J[16]+J[17]+J[18]+J[19]+J[20]-J[21]+J[22]+J[23]-J[24]+J[25]+J[26]+J[27]+J[28]+J[29]-J[30]-J[31]+J[32]-J[33]-J[34]-J[35]-J[36]-J[37]+
    J[38]-J[39]+J[40]+J[41]+J[42]+J[43]+J[44]-J[45]+J[46]+J[47]+J[48]+J[49]+J[50]-J[51]-J[52]-J[53]-J[54]-J[55]+
    J[56]+J[57]+J[58]+J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]+H[1]+H[2]-H[3]+H[4]+H[5]-H[6]+H[7]+
    H[8]+H[9]+H[10]-H[11]+J[0]+J[1]-J[2]+J[3]+J[4]-J[5]+J[6]+J[7]+J[8]+J[9]-J[10]+J[11]-J[12]+J[13]+J[14]-J[15]+
    J[16]+J[17]+J[18]+J[19]-J[20]-J[21]+J[22]+J[23]-J[24]+J[25]+J[26]+J[27]+J[28]-J[29]-J[30]-J[31]+J[32]-J[33]-J[34]-J[35]-J[36]+
    J[37]+J[38]-J[39]+J[40]+J[41]+J[42]+J[43]-J[44]-J[45]+J[46]+J[47]+J[48]+J[49]-J[50]-J[51]-J[52]-J[53]-J[54]+
    J[55]+J[56]+J[57]+J[58]-J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]+H[1]+H[2]-H[3]+H[4]+H[5]-H[6]+
    H[7]+H[8]+H[9]-H[10]+H[11]+J[0]+J[1]-J[2]+J[3]+J[4]-J[5]+J[6]+J[7]+J[8]-J[9]+J[10]+J[11]-J[12]+J[13]+
    J[14]-J[15]+J[16]+J[17]+J[18]-J[19]+J[20]-J[21]+J[22]+J[23]-J[24]+J[25]+J[26]+J[27]-J[28]+J[29]-J[30]-J[31]+
    J[32]-J[33]-J[34]-J[35]+J[36]-J[37]+J[38]-J[39]+J[40]+J[41]+J[42]-J[43]+J[44]-J[45]+J[46]+J[47]+J[48]-J[49]+
    J[50]-J[51]-J[52]-J[53]+J[54]-J[55]+J[56]+J[57]-J[58]+J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]+
    H[1]+H[2]-H[3]+H[4]+H[5]-H[6]+H[7]+H[8]+H[9]-H[10]-H[11]+J[0]+J[1]-J[2]+J[3]+J[4]-J[5]+J[6]+J[7]+J[8]-J[9]-J[10]+
    J[11]-J[12]+J[13]+J[14]-J[15]+J[16]+J[17]+J[18]-J[19]-J[20]-J[21]+J[22]+J[23]-J[24]+J[25]+J[26]+J[27]-J[28]-J[29]-J[30]-J[31]+
    J[32]-J[33]-J[34]-J[35]+J[36]+J[37]+J[38]-J[39]+J[40]+J[41]+J[42]-J[43]-J[44]-J[45]+J[46]+J[47]+J[48]-J[49]-J[50]-J[51]-J[52]-J[53]+
    J[54]+J[55]+J[56]+J[57]-J[58]-J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]+H[1]+H[2]-H[3]+H[4]+H[5]-H[6]+
    H[7]+H[8]-H[9]+H[10]+H[11]+J[0]+J[1]-J[2]+J[3]+J[4]-J[5]+J[6]+J[7]-J[8]+J[9]+J[10]+J[11]-J[12]+J[13]+
    J[14]-J[15]+J[16]+J[17]-J[18]+J[19]+J[20]-J[21]+J[22]+J[23]-J[24]+J[25]+J[26]-J[27]+J[28]+J[29]-J[30]-J[31]+
    J[32]-J[33]-J[34]+J[35]-J[36]-J[37]+J[38]-J[39]+J[40]+J[41]-J[42]+J[43]+J[44]-J[45]+J[46]+J[47]-J[48]+
    J[49]+J[50]-J[51]-J[52]+J[53]-J[54]-J[55]+J[56]-J[57]+J[58]+J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +
    H[0]+H[1]+H[2]-H[3]+H[4]+H[5]-H[6]+H[7]+H[8]-H[9]+H[10]-H[11]+J[0]+J[1]-J[2]+J[3]+J[4]-J[5]+J[6]+J[7]-J[8]+
    J[9]-J[10]+J[11]-J[12]+J[13]+J[14]-J[15]+J[16]+J[17]-J[18]+J[19]-J[20]-J[21]+J[22]+J[23]-J[24]+J[25]+
    J[26]-J[27]+J[28]-J[29]-J[30]-J[31]+J[32]-J[33]-J[34]+J[35]-J[36]+J[37]+J[38]-J[39]+J[40]+J[41]-J[42]+
    J[43]-J[44]-J[45]+J[46]+J[47]-J[48]+J[49]-J[50]-J[51]-J[52]+J[53]-J[54]+J[55]+J[56]-J[57]+J[58]-J[59]-J[60]+
    J[61]-J[62]-J[63]+J[64]-J[65], +H[0]+H[1]+H[2]-H[3]+H[4]+H[5]-H[6]+H[7]+H[8]-H[9]-H[10]+H[11]+J[0]+J[1]-J[2]+
    J[3]+J[4]-J[5]+J[6]+J[7]-J[8]-J[9]+J[10]+J[11]-J[12]+J[13]+J[14]-J[15]+J[16]+J[17]-J[18]-J[19]+J[20]-J[21]+
    J[22]+J[23]-J[24]+J[25]+J[26]-J[27]-J[28]+J[29]-J[30]-J[31]+J[32]-J[33]-J[34]+J[35]+J[36]-J[37]+J[38]-J[39]+
    J[40]+J[41]-J[42]-J[43]+J[44]-J[45]+J[46]+J[47]-J[48]-J[49]+J[50]-J[51]-J[52]+J[53]+J[54]-J[55]+J[56]-J[57]-J[58]+
    J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]+H[1]+H[2]-H[3]+H[4]+H[5]-H[6]+H[7]+H[8]-H[9]-H[10]-H[11]+
    J[0]+J[1]-J[2]+J[3]+J[4]-J[5]+J[6]+J[7]-J[8]-J[9]-J[10]+J[11]-J[12]+J[13]+J[14]-J[15]+J[16]+J[17]-J[18]-J[19]-J[20]-J[21]+
    J[22]+J[23]-J[24]+J[25]+J[26]-J[27]-J[28]-J[29]-J[30]-J[31]+J[32]-J[33]-J[34]+J[35]+J[36]+J[37]+J[38]-J[39]+
    J[40]+J[41]-J[42]-J[43]-J[44]-J[45]+J[46]+J[47]-J[48]-J[49]-J[50]-J[51]-J[52]+J[53]+J[54]+J[55]+J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+
    J[63]+J[64]+J[65], +H[0]+H[1]+H[2]-H[3]+H[4]+H[5]-H[6]+H[7]-H[8]+H[9]+H[10]+H[11]+J[0]+J[1]-J[2]+J[3]+
    J[4]-J[5]+J[6]-J[7]+J[8]+J[9]+J[10]+J[11]-J[12]+J[13]+J[14]-J[15]+J[16]-J[17]+J[18]+J[19]+J[20]-J[21]+
    J[22]+J[23]-J[24]+J[25]-J[26]+J[27]+J[28]+J[29]-J[30]-J[31]+J[32]-J[33]+J[34]-J[35]-J[36]-J[37]+J[38]-J[39]+
    J[40]-J[41]+J[42]+J[43]+J[44]-J[45]+J[46]-J[47]+J[48]+J[49]+J[50]-J[51]+J[52]-J[53]-J[54]-J[55]-J[56]+
    J[57]+J[58]+J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]+H[1]+H[2]-H[3]+H[4]+H[5]-H[6]+H[7]-H[8]+
    H[9]+H[10]-H[11]+J[0]+J[1]-J[2]+J[3]+J[4]-J[5]+J[6]-J[7]+J[8]+J[9]-J[10]+J[11]-J[12]+J[13]+J[14]-J[15]+
    J[16]-J[17]+J[18]+J[19]-J[20]-J[21]+J[22]+J[23]-J[24]+J[25]-J[26]+J[27]+J[28]-J[29]-J[30]-J[31]+J[32]-J[33]+
    J[34]-J[35]-J[36]+J[37]+J[38]-J[39]+J[40]-J[41]+J[42]+J[43]-J[44]-J[45]+J[46]-J[47]+J[48]+J[49]-J[50]-J[51]+
    J[52]-J[53]-J[54]+J[55]-J[56]+J[57]+J[58]-J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]+H[1]+H[2]-H[3]+
    H[4]+H[5]-H[6]+H[7]-H[8]+H[9]-H[10]+H[11]+J[0]+J[1]-J[2]+J[3]+J[4]-J[5]+J[6]-J[7]+J[8]-J[9]+J[10]+J[11]-J[12]+
    J[13]+J[14]-J[15]+J[16]-J[17]+J[18]-J[19]+J[20]-J[21]+J[22]+J[23]-J[24]+J[25]-J[26]+J[27]-J[28]+J[29]-J[30]-J[31]+
    J[32]-J[33]+J[34]-J[35]+J[36]-J[37]+J[38]-J[39]+J[40]-J[41]+J[42]-J[43]+J[44]-J[45]+J[46]-J[47]+J[48]-J[49]+
    J[50]-J[51]+J[52]-J[53]+J[54]-J[55]-J[56]+J[57]-J[58]+J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]+
    H[1]+H[2]-H[3]+H[4]+H[5]-H[6]+H[7]-H[8]+H[9]-H[10]-H[11]+J[0]+J[1]-J[2]+J[3]+J[4]-J[5]+J[6]-J[7]+J[8]-J[9]-J[10]+
    J[11]-J[12]+J[13]+J[14]-J[15]+J[16]-J[17]+J[18]-J[19]-J[20]-J[21]+J[22]+J[23]-J[24]+J[25]-J[26]+J[27]-J[28]-J[29]-J[30]-J[31]+
    J[32]-J[33]+J[34]-J[35]+J[36]+J[37]+J[38]-J[39]+J[40]-J[41]+J[42]-J[43]-J[44]-J[45]+J[46]-J[47]+J[48]-J[49]-J[50]-J[51]+
    J[52]-J[53]+J[54]+J[55]-J[56]+J[57]-J[58]-J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]+H[1]+H[2]-H[3]+
    H[4]+H[5]-H[6]+H[7]-H[8]-H[9]+H[10]+H[11]+J[0]+J[1]-J[2]+J[3]+J[4]-J[5]+J[6]-J[7]-J[8]+J[9]+J[10]+J[11]-J[12]+
    J[13]+J[14]-J[15]+J[16]-J[17]-J[18]+J[19]+J[20]-J[21]+J[22]+J[23]-J[24]+J[25]-J[26]-J[27]+J[28]+J[29]-J[30]-J[31]+
    J[32]-J[33]+J[34]+J[35]-J[36]-J[37]+J[38]-J[39]+J[40]-J[41]-J[42]+J[43]+J[44]-J[45]+J[46]-J[47]-J[48]+
    J[49]+J[50]-J[51]+J[52]+J[53]-J[54]-J[55]-J[56]-J[57]+J[58]+J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +
    H[0]+H[1]+H[2]-H[3]+H[4]+H[5]-H[6]+H[7]-H[8]-H[9]+H[10]-H[11]+J[0]+J[1]-J[2]+J[3]+J[4]-J[5]+J[6]-J[7]-J[8]+
    J[9]-J[10]+J[11]-J[12]+J[13]+J[14]-J[15]+J[16]-J[17]-J[18]+J[19]-J[20]-J[21]+J[22]+J[23]-J[24]+J[25]-J[26]-J[27]+
    J[28]-J[29]-J[30]-J[31]+J[32]-J[33]+J[34]+J[35]-J[36]+J[37]+J[38]-J[39]+J[40]-J[41]-J[42]+J[43]-J[44]-J[45]+
    J[46]-J[47]-J[48]+J[49]-J[50]-J[51]+J[52]+J[53]-J[54]+J[55]-J[56]-J[57]+J[58]-J[59]+J[60]-J[61]+J[62]-J[63]+
    J[64]-J[65], +H[0]+H[1]+H[2]-H[3]+H[4]+H[5]-H[6]+H[7]-H[8]-H[9]-H[10]+H[11]+J[0]+J[1]-J[2]+J[3]+J[4]-J[5]+
    J[6]-J[7]-J[8]-J[9]+J[10]+J[11]-J[12]+J[13]+J[14]-J[15]+J[16]-J[17]-J[18]-J[19]+J[20]-J[21]+J[22]+J[23]-J[24]+
    J[25]-J[26]-J[27]-J[28]+J[29]-J[30]-J[31]+J[32]-J[33]+J[34]+J[35]+J[36]-J[37]+J[38]-J[39]+J[40]-J[41]-J[42]-J[43]+
    J[44]-J[45]+J[46]-J[47]-J[48]-J[49]+J[50]-J[51]+J[52]+J[53]+J[54]-J[55]-J[56]-J[57]-J[58]+J[59]+J[60]+
    J[61]-J[62]+J[63]-J[64]-J[65], +H[0]+H[1]+H[2]-H[3]+H[4]+H[5]-H[6]+H[7]-H[8]-H[9]-H[10]-H[11]+J[0]+J[1]-J[2]+
    J[3]+J[4]-J[5]+J[6]-J[7]-J[8]-J[9]-J[10]+J[11]-J[12]+J[13]+J[14]-J[15]+J[16]-J[17]-J[18]-J[19]-J[20]-J[21]+
    J[22]+J[23]-J[24]+J[25]-J[26]-J[27]-J[28]-J[29]-J[30]-J[31]+J[32]-J[33]+J[34]+J[35]+J[36]+J[37]+J[38]-J[39]+
    J[40]-J[41]-J[42]-J[43]-J[44]-J[45]+J[46]-J[47]-J[48]-J[49]-J[50]-J[51]+J[52]+J[53]+J[54]+J[55]-J[56]-J[57]-J[58]-J[59]+
    J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]+H[1]+H[2]-H[3]+H[4]+H[5]-H[6]-H[7]+H[8]+H[9]+H[10]+H[11]+
    J[0]+J[1]-J[2]+J[3]+J[4]-J[5]-J[6]+J[7]+J[8]+J[9]+J[10]+J[11]-J[12]+J[13]+J[14]-J[15]-J[16]+J[17]+J[18]+
    J[19]+J[20]-J[21]+J[22]+J[23]-J[24]-J[25]+J[26]+J[27]+J[28]+J[29]-J[30]-J[31]+J[32]+J[33]-J[34]-J[35]-J[36]-J[37]+
    J[38]-J[39]-J[40]+J[41]+J[42]+J[43]+J[44]-J[45]-J[46]+J[47]+J[48]+J[49]+J[50]+J[51]-J[52]-J[53]-J[54]-J[55]-J[56]-J[57]-J[58]-J[59]+
    J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]+H[1]+H[2]-H[3]+H[4]+H[5]-H[6]-H[7]+H[8]+H[9]+H[10]-H[11]+
    J[0]+J[1]-J[2]+J[3]+J[4]-J[5]-J[6]+J[7]+J[8]+J[9]-J[10]+J[11]-J[12]+J[13]+J[14]-J[15]-J[16]+J[17]+J[18]+
    J[19]-J[20]-J[21]+J[22]+J[23]-J[24]-J[25]+J[26]+J[27]+J[28]-J[29]-J[30]-J[31]+J[32]+J[33]-J[34]-J[35]-J[36]+
    J[37]+J[38]-J[39]-J[40]+J[41]+J[42]+J[43]-J[44]-J[45]-J[46]+J[47]+J[48]+J[49]-J[50]+J[51]-J[52]-J[53]-J[54]+
    J[55]-J[56]-J[57]-J[58]+J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]+H[1]+H[2]-H[3]+H[4]+H[5]-H[6]-H[7]+
    H[8]+H[9]-H[10]+H[11]+J[0]+J[1]-J[2]+J[3]+J[4]-J[5]-J[6]+J[7]+J[8]-J[9]+J[10]+J[11]-J[12]+J[13]+J[14]-J[15]-J[16]+
    J[17]+J[18]-J[19]+J[20]-J[21]+J[22]+J[23]-J[24]-J[25]+J[26]+J[27]-J[28]+J[29]-J[30]-J[31]+J[32]+J[33]-J[34]-J[35]+
    J[36]-J[37]+J[38]-J[39]-J[40]+J[41]+J[42]-J[43]+J[44]-J[45]-J[46]+J[47]+J[48]-J[49]+J[50]+J[51]-J[52]-J[53]+
    J[54]-J[55]-J[56]-J[57]+J[58]-J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]+H[1]+H[2]-H[3]+H[4]+H[5]-H[6]-H[7]+
    H[8]+H[9]-H[10]-H[11]+J[0]+J[1]-J[2]+J[3]+J[4]-J[5]-J[6]+J[7]+J[8]-J[9]-J[10]+J[11]-J[12]+J[13]+J[14]-J[15]-J[16]+
    J[17]+J[18]-J[19]-J[20]-J[21]+J[22]+J[23]-J[24]-J[25]+J[26]+J[27]-J[28]-J[29]-J[30]-J[31]+J[32]+J[33]-J[34]-J[35]+
    J[36]+J[37]+J[38]-J[39]-J[40]+J[41]+J[42]-J[43]-J[44]-J[45]-J[46]+J[47]+J[48]-J[49]-J[50]+J[51]-J[52]-J[53]+
    J[54]+J[55]-J[56]-J[57]+J[58]+J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]+H[1]+H[2]-H[3]+H[4]+H[5]-H[6]-H[7]+
    H[8]-H[9]+H[10]+H[11]+J[0]+J[1]-J[2]+J[3]+J[4]-J[5]-J[6]+J[7]-J[8]+J[9]+J[10]+J[11]-J[12]+J[13]+J[14]-J[15]-J[16]+
    J[17]-J[18]+J[19]+J[20]-J[21]+J[22]+J[23]-J[24]-J[25]+J[26]-J[27]+J[28]+J[29]-J[30]-J[31]+J[32]+J[33]-J[34]+
    J[35]-J[36]-J[37]+J[38]-J[39]-J[40]+J[41]-J[42]+J[43]+J[44]-J[45]-J[46]+J[47]-J[48]+J[49]+J[50]+J[51]-J[52]+
    J[53]-J[54]-J[55]-J[56]+J[57]-J[58]-J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]+H[1]+H[2]-H[3]+
    H[4]+H[5]-H[6]-H[7]+H[8]-H[9]+H[10]-H[11]+J[0]+J[1]-J[2]+J[3]+J[4]-J[5]-J[6]+J[7]-J[8]+J[9]-J[10]+J[11]-J[12]+
    J[13]+J[14]-J[15]-J[16]+J[17]-J[18]+J[19]-J[20]-J[21]+J[22]+J[23]-J[24]-J[25]+J[26]-J[27]+J[28]-J[29]-J[30]-J[31]+
    J[32]+J[33]-J[34]+J[35]-J[36]+J[37]+J[38]-J[39]-J[40]+J[41]-J[42]+J[43]-J[44]-J[45]-J[46]+J[47]-J[48]+
    J[49]-J[50]+J[51]-J[52]+J[53]-J[54]+J[55]-J[56]+J[57]-J[58]+J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +
    H[0]+H[1]+H[2]-H[3]+H[4]+H[5]-H[6]-H[7]+H[8]-H[9]-H[10]+H[11]+J[0]+J[1]-J[2]+J[3]+J[4]-J[5]-J[6]+J[7]-J[8]-J[9]+
    J[10]+J[11]-J[12]+J[13]+J[14]-J[15]-J[16]+J[17]-J[18]-J[19]+J[20]-J[21]+J[22]+J[23]-J[24]-J[25]+J[26]-J[27]-J[28]+
    J[29]-J[30]-J[31]+J[32]+J[33]-J[34]+J[35]+J[36]-J[37]+J[38]-J[39]-J[40]+J[41]-J[42]-J[43]+J[44]-J[45]-J[46]+
    J[47]-J[48]-J[49]+J[50]+J[51]-J[52]+J[53]+J[54]-J[55]-J[56]+J[57]+J[58]-J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +
    H[0]+H[1]+H[2]-H[3]+H[4]+H[5]-H[6]-H[7]+H[8]-H[9]-H[10]-H[11]+J[0]+J[1]-J[2]+J[3]+J[4]-J[5]-J[6]+J[7]-J[8]-J[9]-J[10]+
    J[11]-J[12]+J[13]+J[14]-J[15]-J[16]+J[17]-J[18]-J[19]-J[20]-J[21]+J[22]+J[23]-J[24]-J[25]+J[26]-J[27]-J[28]-J[29]-J[30]-J[31]+
    J[32]+J[33]-J[34]+J[35]+J[36]+J[37]+J[38]-J[39]-J[40]+J[41]-J[42]-J[43]-J[44]-J[45]-J[46]+J[47]-J[48]-J[49]-J[50]+
    J[51]-J[52]+J[53]+J[54]+J[55]-J[56]+J[57]+J[58]+J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]+H[1]+
    H[2]-H[3]+H[4]+H[5]-H[6]-H[7]-H[8]+H[9]+H[10]+H[11]+J[0]+J[1]-J[2]+J[3]+J[4]-J[5]-J[6]-J[7]+J[8]+J[9]+
    J[10]+J[11]-J[12]+J[13]+J[14]-J[15]-J[16]-J[17]+J[18]+J[19]+J[20]-J[21]+J[22]+J[23]-J[24]-J[25]-J[26]+
    J[27]+J[28]+J[29]-J[30]-J[31]+J[32]+J[33]+J[34]-J[35]-J[36]-J[37]+J[38]-J[39]-J[40]-J[41]+J[42]+J[43]+
    J[44]-J[45]-J[46]-J[47]+J[48]+J[49]+J[50]+J[51]+J[52]-J[53]-J[54]-J[55]+J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+
    J[63]+J[64]+J[65], +H[0]+H[1]+H[2]-H[3]+H[4]+H[5]-H[6]-H[7]-H[8]+H[9]+H[10]-H[11]+J[0]+J[1]-J[2]+J[3]+
    J[4]-J[5]-J[6]-J[7]+J[8]+J[9]-J[10]+J[11]-J[12]+J[13]+J[14]-J[15]-J[16]-J[17]+J[18]+J[19]-J[20]-J[21]+
    J[22]+J[23]-J[24]-J[25]-J[26]+J[27]+J[28]-J[29]-J[30]-J[31]+J[32]+J[33]+J[34]-J[35]-J[36]+J[37]+J[38]-J[39]-J[40]-J[41]+
    J[42]+J[43]-J[44]-J[45]-J[46]-J[47]+J[48]+J[49]-J[50]+J[51]+J[52]-J[53]-J[54]+J[55]+J[56]-J[57]-J[58]+
    J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]+H[1]+H[2]-H[3]+H[4]+H[5]-H[6]-H[7]-H[8]+H[9]-H[10]+
    H[11]+J[0]+J[1]-J[2]+J[3]+J[4]-J[5]-J[6]-J[7]+J[8]-J[9]+J[10]+J[11]-J[12]+J[13]+J[14]-J[15]-J[16]-J[17]+
    J[18]-J[19]+J[20]-J[21]+J[22]+J[23]-J[24]-J[25]-J[26]+J[27]-J[28]+J[29]-J[30]-J[31]+J[32]+J[33]+J[34]-J[35]+
    J[36]-J[37]+J[38]-J[39]-J[40]-J[41]+J[42]-J[43]+J[44]-J[45]-J[46]-J[47]+J[48]-J[49]+J[50]+J[51]+J[52]-J[53]+
    J[54]-J[55]+J[56]-J[57]+J[58]-J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]+H[1]+H[2]-H[3]+H[4]+H[5]-H[6]-H[7]-H[8]+
    H[9]-H[10]-H[11]+J[0]+J[1]-J[2]+J[3]+J[4]-J[5]-J[6]-J[7]+J[8]-J[9]-J[10]+J[11]-J[12]+J[13]+J[14]-J[15]-J[16]-J[17]+
    J[18]-J[19]-J[20]-J[21]+J[22]+J[23]-J[24]-J[25]-J[26]+J[27]-J[28]-J[29]-J[30]-J[31]+J[32]+J[33]+J[34]-J[35]+
    J[36]+J[37]+J[38]-J[39]-J[40]-J[41]+J[42]-J[43]-J[44]-J[45]-J[46]-J[47]+J[48]-J[49]-J[50]+J[51]+J[52]-J[53]+
    J[54]+J[55]+J[56]-J[57]+J[58]+J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]+H[1]+H[2]-H[3]+H[4]+H[5]-H[6]-H[7]-H[8]-H[9]+
    H[10]+H[11]+J[0]+J[1]-J[2]+J[3]+J[4]-J[5]-J[6]-J[7]-J[8]+J[9]+J[10]+J[11]-J[12]+J[13]+J[14]-J[15]-J[16]-J[17]-J[18]+
    J[19]+J[20]-J[21]+J[22]+J[23]-J[24]-J[25]-J[26]-J[27]+J[28]+J[29]-J[30]-J[31]+J[32]+J[33]+J[34]+J[35]-J[36]-J[37]+
    J[38]-J[39]-J[40]-J[41]-J[42]+J[43]+J[44]-J[45]-J[46]-J[47]-J[48]+J[49]+J[50]+J[51]+J[52]+J[53]-J[54]-J[55]+
    J[56]+J[57]-J[58]-J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]+H[1]+H[2]-H[3]+H[4]+H[5]-H[6]-H[7]-H[8]-H[9]+
    H[10]-H[11]+J[0]+J[1]-J[2]+J[3]+J[4]-J[5]-J[6]-J[7]-J[8]+J[9]-J[10]+J[11]-J[12]+J[13]+J[14]-J[15]-J[16]-J[17]-J[18]+
    J[19]-J[20]-J[21]+J[22]+J[23]-J[24]-J[25]-J[26]-J[27]+J[28]-J[29]-J[30]-J[31]+J[32]+J[33]+J[34]+J[35]-J[36]+
    J[37]+J[38]-J[39]-J[40]-J[41]-J[42]+J[43]-J[44]-J[45]-J[46]-J[47]-J[48]+J[49]-J[50]+J[51]+J[52]+J[53]-J[54]+
    J[55]+J[56]+J[57]-J[58]+J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]+H[1]+H[2]-H[3]+H[4]+H[5]-H[6]-H[7]-H[8]-H[9]-H[10]+
    H[11]+J[0]+J[1]-J[2]+J[3]+J[4]-J[5]-J[6]-J[7]-J[8]-J[9]+J[10]+J[11]-J[12]+J[13]+J[14]-J[15]-J[16]-J[17]-J[18]-J[19]+
    J[20]-J[21]+J[22]+J[23]-J[24]-J[25]-J[26]-J[27]-J[28]+J[29]-J[30]-J[31]+J[32]+J[33]+J[34]+J[35]+J[36]-J[37]+
    J[38]-J[39]-J[40]-J[41]-J[42]-J[43]+J[44]-J[45]-J[46]-J[47]-J[48]-J[49]+J[50]+J[51]+J[52]+J[53]+J[54]-J[55]+
    J[56]+J[57]+J[58]-J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]+H[1]+H[2]-H[3]+H[4]+H[5]-H[6]-H[7]-H[8]-H[9]-H[10]-H[11]+
    J[0]+J[1]-J[2]+J[3]+J[4]-J[5]-J[6]-J[7]-J[8]-J[9]-J[10]+J[11]-J[12]+J[13]+J[14]-J[15]-J[16]-J[17]-J[18]-J[19]-J[20]-J[21]+
    J[22]+J[23]-J[24]-J[25]-J[26]-J[27]-J[28]-J[29]-J[30]-J[31]+J[32]+J[33]+J[34]+J[35]+J[36]+J[37]+J[38]-J[39]-J[40]-J[41]-J[42]-J[43]-J[44]-J[45]-J[46]-J[47]-J[48]-J[49]-J[50]+
    J[51]+J[52]+J[53]+J[54]+J[55]+J[56]+J[57]+J[58]+J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]+H[1]+
    H[2]-H[3]+H[4]-H[5]+H[6]+H[7]+H[8]+H[9]+H[10]+H[11]+J[0]+J[1]-J[2]+J[3]-J[4]+J[5]+J[6]+J[7]+J[8]+J[9]+
    J[10]+J[11]-J[12]+J[13]-J[14]+J[15]+J[16]+J[17]+J[18]+J[19]+J[20]-J[21]+J[22]-J[23]+J[24]+J[25]+J[26]+
    J[27]+J[28]+J[29]-J[30]+J[31]-J[32]-J[33]-J[34]-J[35]-J[36]-J[37]-J[38]+J[39]+J[40]+J[41]+J[42]+J[43]+
    J[44]-J[45]-J[46]-J[47]-J[48]-J[49]-J[50]+J[51]+J[52]+J[53]+J[54]+J[55]+J[56]+J[57]+J[58]+J[59]+J[60]+
    J[61]+J[62]+J[63]+J[64]+J[65], +H[0]+H[1]+H[2]-H[3]+H[4]-H[5]+H[6]+H[7]+H[8]+H[9]+H[10]-H[11]+J[0]+J[1]-J[2]+
    J[3]-J[4]+J[5]+J[6]+J[7]+J[8]+J[9]-J[10]+J[11]-J[12]+J[13]-J[14]+J[15]+J[16]+J[17]+J[18]+J[19]-J[20]-J[21]+
    J[22]-J[23]+J[24]+J[25]+J[26]+J[27]+J[28]-J[29]-J[30]+J[31]-J[32]-J[33]-J[34]-J[35]-J[36]+J[37]-J[38]+
    J[39]+J[40]+J[41]+J[42]+J[43]-J[44]-J[45]-J[46]-J[47]-J[48]-J[49]+J[50]+J[51]+J[52]+J[53]+J[54]-J[55]+
    J[56]+J[57]+J[58]-J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]+H[1]+H[2]-H[3]+H[4]-H[5]+H[6]+H[7]+
    H[8]+H[9]-H[10]+H[11]+J[0]+J[1]-J[2]+J[3]-J[4]+J[5]+J[6]+J[7]+J[8]-J[9]+J[10]+J[11]-J[12]+J[13]-J[14]+
    J[15]+J[16]+J[17]+J[18]-J[19]+J[20]-J[21]+J[22]-J[23]+J[24]+J[25]+J[26]+J[27]-J[28]+J[29]-J[30]+J[31]-J[32]-J[33]-J[34]-J[35]+
    J[36]-J[37]-J[38]+J[39]+J[40]+J[41]+J[42]-J[43]+J[44]-J[45]-J[46]-J[47]-J[48]+J[49]-J[50]+J[51]+J[52]+
    J[53]-J[54]+J[55]+J[56]+J[57]-J[58]+J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]+H[1]+H[2]-H[3]+
    H[4]-H[5]+H[6]+H[7]+H[8]+H[9]-H[10]-H[11]+J[0]+J[1]-J[2]+J[3]-J[4]+J[5]+J[6]+J[7]+J[8]-J[9]-J[10]+J[11]-J[12]+
    J[13]-J[14]+J[15]+J[16]+J[17]+J[18]-J[19]-J[20]-J[21]+J[22]-J[23]+J[24]+J[25]+J[26]+J[27]-J[28]-J[29]-J[30]+
    J[31]-J[32]-J[33]-J[34]-J[35]+J[36]+J[37]-J[38]+J[39]+J[40]+J[41]+J[42]-J[43]-J[44]-J[45]-J[46]-J[47]-J[48]+
    J[49]+J[50]+J[51]+J[52]+J[53]-J[54]-J[55]+J[56]+J[57]-J[58]-J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +
    H[0]+H[1]+H[2]-H[3]+H[4]-H[5]+H[6]+H[7]+H[8]-H[9]+H[10]+H[11]+J[0]+J[1]-J[2]+J[3]-J[4]+J[5]+J[6]+J[7]-J[8]+
    J[9]+J[10]+J[11]-J[12]+J[13]-J[14]+J[15]+J[16]+J[17]-J[18]+J[19]+J[20]-J[21]+J[22]-J[23]+J[24]+J[25]+
    J[26]-J[27]+J[28]+J[29]-J[30]+J[31]-J[32]-J[33]-J[34]+J[35]-J[36]-J[37]-J[38]+J[39]+J[40]+J[41]-J[42]+
    J[43]+J[44]-J[45]-J[46]-J[47]+J[48]-J[49]-J[50]+J[51]+J[52]-J[53]+J[54]+J[55]+J[56]-J[57]+J[58]+J[59]-J[60]+
    J[61]+J[62]-J[63]-J[64]+J[65], +H[0]+H[1]+H[2]-H[3]+H[4]-H[5]+H[6]+H[7]+H[8]-H[9]+H[10]-H[11]+J[0]+J[1]-J[2]+
    J[3]-J[4]+J[5]+J[6]+J[7]-J[8]+J[9]-J[10]+J[11]-J[12]+J[13]-J[14]+J[15]+J[16]+J[17]-J[18]+J[19]-J[20]-J[21]+
    J[22]-J[23]+J[24]+J[25]+J[26]-J[27]+J[28]-J[29]-J[30]+J[31]-J[32]-J[33]-J[34]+J[35]-J[36]+J[37]-J[38]+
    J[39]+J[40]+J[41]-J[42]+J[43]-J[44]-J[45]-J[46]-J[47]+J[48]-J[49]+J[50]+J[51]+J[52]-J[53]+J[54]-J[55]+
    J[56]-J[57]+J[58]-J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]+H[1]+H[2]-H[3]+H[4]-H[5]+H[6]+H[7]+
    H[8]-H[9]-H[10]+H[11]+J[0]+J[1]-J[2]+J[3]-J[4]+J[5]+J[6]+J[7]-J[8]-J[9]+J[10]+J[11]-J[12]+J[13]-J[14]+
    J[15]+J[16]+J[17]-J[18]-J[19]+J[20]-J[21]+J[22]-J[23]+J[24]+J[25]+J[26]-J[27]-J[28]+J[29]-J[30]+J[31]-J[32]-J[33]-J[34]+
    J[35]+J[36]-J[37]-J[38]+J[39]+J[40]+J[41]-J[42]-J[43]+J[44]-J[45]-J[46]-J[47]+J[48]+J[49]-J[50]+J[51]+
    J[52]-J[53]-J[54]+J[55]+J[56]-J[57]-J[58]+J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]+H[1]+H[2]-H[3]+
    H[4]-H[5]+H[6]+H[7]+H[8]-H[9]-H[10]-H[11]+J[0]+J[1]-J[2]+J[3]-J[4]+J[5]+J[6]+J[7]-J[8]-J[9]-J[10]+J[11]-J[12]+
    J[13]-J[14]+J[15]+J[16]+J[17]-J[18]-J[19]-J[20]-J[21]+J[22]-J[23]+J[24]+J[25]+J[26]-J[27]-J[28]-J[29]-J[30]+
    J[31]-J[32]-J[33]-J[34]+J[35]+J[36]+J[37]-J[38]+J[39]+J[40]+J[41]-J[42]-J[43]-J[44]-J[45]-J[46]-J[47]+
    J[48]+J[49]+J[50]+J[51]+J[52]-J[53]-J[54]-J[55]+J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+
    J[65], +H[0]+H[1]+H[2]-H[3]+H[4]-H[5]+H[6]+H[7]-H[8]+H[9]+H[10]+H[11]+J[0]+J[1]-J[2]+J[3]-J[4]+J[5]+
    J[6]-J[7]+J[8]+J[9]+J[10]+J[11]-J[12]+J[13]-J[14]+J[15]+J[16]-J[17]+J[18]+J[19]+J[20]-J[21]+J[22]-J[23]+
    J[24]+J[25]-J[26]+J[27]+J[28]+J[29]-J[30]+J[31]-J[32]-J[33]+J[34]-J[35]-J[36]-J[37]-J[38]+J[39]+J[40]-J[41]+
    J[42]+J[43]+J[44]-J[45]-J[46]+J[47]-J[48]-J[49]-J[50]+J[51]-J[52]+J[53]+J[54]+J[55]-J[56]+J[57]+J[58]+
    J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]+H[1]+H[2]-H[3]+H[4]-H[5]+H[6]+H[7]-H[8]+H[9]+H[10]-H[11]+
    J[0]+J[1]-J[2]+J[3]-J[4]+J[5]+J[6]-J[7]+J[8]+J[9]-J[10]+J[11]-J[12]+J[13]-J[14]+J[15]+J[16]-J[17]+J[18]+
    J[19]-J[20]-J[21]+J[22]-J[23]+J[24]+J[25]-J[26]+J[27]+J[28]-J[29]-J[30]+J[31]-J[32]-J[33]+J[34]-J[35]-J[36]+
    J[37]-J[38]+J[39]+J[40]-J[41]+J[42]+J[43]-J[44]-J[45]-J[46]+J[47]-J[48]-J[49]+J[50]+J[51]-J[52]+J[53]+
    J[54]-J[55]-J[56]+J[57]+J[58]-J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]+H[1]+H[2]-H[3]+H[4]-H[5]+
    H[6]+H[7]-H[8]+H[9]-H[10]+H[11]+J[0]+J[1]-J[2]+J[3]-J[4]+J[5]+J[6]-J[7]+J[8]-J[9]+J[10]+J[11]-J[12]+
    J[13]-J[14]+J[15]+J[16]-J[17]+J[18]-J[19]+J[20]-J[21]+J[22]-J[23]+J[24]+J[25]-J[26]+J[27]-J[28]+J[29]-J[30]+
    J[31]-J[32]-J[33]+J[34]-J[35]+J[36]-J[37]-J[38]+J[39]+J[40]-J[41]+J[42]-J[43]+J[44]-J[45]-J[46]+J[47]-J[48]+
    J[49]-J[50]+J[51]-J[52]+J[53]-J[54]+J[55]-J[56]+J[57]-J[58]+J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +
    H[0]+H[1]+H[2]-H[3]+H[4]-H[5]+H[6]+H[7]-H[8]+H[9]-H[10]-H[11]+J[0]+J[1]-J[2]+J[3]-J[4]+J[5]+J[6]-J[7]+
    J[8]-J[9]-J[10]+J[11]-J[12]+J[13]-J[14]+J[15]+J[16]-J[17]+J[18]-J[19]-J[20]-J[21]+J[22]-J[23]+J[24]+
    J[25]-J[26]+J[27]-J[28]-J[29]-J[30]+J[31]-J[32]-J[33]+J[34]-J[35]+J[36]+J[37]-J[38]+J[39]+J[40]-J[41]+
    J[42]-J[43]-J[44]-J[45]-J[46]+J[47]-J[48]+J[49]+J[50]+J[51]-J[52]+J[53]-J[54]-J[55]-J[56]+J[57]-J[58]-J[59]-J[60]+
    J[61]+J[62]-J[63]-J[64]+J[65], +H[0]+H[1]+H[2]-H[3]+H[4]-H[5]+H[6]+H[7]-H[8]-H[9]+H[10]+H[11]+J[0]+J[1]-J[2]+
    J[3]-J[4]+J[5]+J[6]-J[7]-J[8]+J[9]+J[10]+J[11]-J[12]+J[13]-J[14]+J[15]+J[16]-J[17]-J[18]+J[19]+J[20]-J[21]+
    J[22]-J[23]+J[24]+J[25]-J[26]-J[27]+J[28]+J[29]-J[30]+J[31]-J[32]-J[33]+J[34]+J[35]-J[36]-J[37]-J[38]+
    J[39]+J[40]-J[41]-J[42]+J[43]+J[44]-J[45]-J[46]+J[47]+J[48]-J[49]-J[50]+J[51]-J[52]-J[53]+J[54]+J[55]-J[56]-J[57]+
    J[58]+J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]+H[1]+H[2]-H[3]+H[4]-H[5]+H[6]+H[7]-H[8]-H[9]+
    H[10]-H[11]+J[0]+J[1]-J[2]+J[3]-J[4]+J[5]+J[6]-J[7]-J[8]+J[9]-J[10]+J[11]-J[12]+J[13]-J[14]+J[15]+J[16]-J[17]-J[18]+
    J[19]-J[20]-J[21]+J[22]-J[23]+J[24]+J[25]-J[26]-J[27]+J[28]-J[29]-J[30]+J[31]-J[32]-J[33]+J[34]+J[35]-J[36]+
    J[37]-J[38]+J[39]+J[40]-J[41]-J[42]+J[43]-J[44]-J[45]-J[46]+J[47]+J[48]-J[49]+J[50]+J[51]-J[52]-J[53]+
    J[54]-J[55]-J[56]-J[57]+J[58]-J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]+H[1]+H[2]-H[3]+H[4]-H[5]+
    H[6]+H[7]-H[8]-H[9]-H[10]+H[11]+J[0]+J[1]-J[2]+J[3]-J[4]+J[5]+J[6]-J[7]-J[8]-J[9]+J[10]+J[11]-J[12]+
    J[13]-J[14]+J[15]+J[16]-J[17]-J[18]-J[19]+J[20]-J[21]+J[22]-J[23]+J[24]+J[25]-J[26]-J[27]-J[28]+J[29]-J[30]+
    J[31]-J[32]-J[33]+J[34]+J[35]+J[36]-J[37]-J[38]+J[39]+J[40]-J[41]-J[42]-J[43]+J[44]-J[45]-J[46]+J[47]+
    J[48]+J[49]-J[50]+J[51]-J[52]-J[53]-J[54]+J[55]-J[56]-J[57]-J[58]+J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +
    H[0]+H[1]+H[2]-H[3]+H[4]-H[5]+H[6]+H[7]-H[8]-H[9]-H[10]-H[11]+J[0]+J[1]-J[2]+J[3]-J[4]+J[5]+J[6]-J[7]-J[8]-J[9]-J[10]+
    J[11]-J[12]+J[13]-J[14]+J[15]+J[16]-J[17]-J[18]-J[19]-J[20]-J[21]+J[22]-J[23]+J[24]+J[25]-J[26]-J[27]-J[28]-J[29]-J[30]+
    J[31]-J[32]-J[33]+J[34]+J[35]+J[36]+J[37]-J[38]+J[39]+J[40]-J[41]-J[42]-J[43]-J[44]-J[45]-J[46]+J[47]+
    J[48]+J[49]+J[50]+J[51]-J[52]-J[53]-J[54]-J[55]-J[56]-J[57]-J[58]-J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+
    J[65], +H[0]+H[1]+H[2]-H[3]+H[4]-H[5]+H[6]-H[7]+H[8]+H[9]+H[10]+H[11]+J[0]+J[1]-J[2]+J[3]-J[4]+J[5]-J[6]+
    J[7]+J[8]+J[9]+J[10]+J[11]-J[12]+J[13]-J[14]+J[15]-J[16]+J[17]+J[18]+J[19]+J[20]-J[21]+J[22]-J[23]+J[24]-J[25]+
    J[26]+J[27]+J[28]+J[29]-J[30]+J[31]-J[32]+J[33]-J[34]-J[35]-J[36]-J[37]-J[38]+J[39]-J[40]+J[41]+J[42]+
    J[43]+J[44]-J[45]+J[46]-J[47]-J[48]-J[49]-J[50]-J[51]+J[52]+J[53]+J[54]+J[55]-J[56]-J[57]-J[58]-J[59]+
    J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]+H[1]+H[2]-H[3]+H[4]-H[5]+H[6]-H[7]+H[8]+H[9]+H[10]-H[11]+
    J[0]+J[1]-J[2]+J[3]-J[4]+J[5]-J[6]+J[7]+J[8]+J[9]-J[10]+J[11]-J[12]+J[13]-J[14]+J[15]-J[16]+J[17]+J[18]+
    J[19]-J[20]-J[21]+J[22]-J[23]+J[24]-J[25]+J[26]+J[27]+J[28]-J[29]-J[30]+J[31]-J[32]+J[33]-J[34]-J[35]-J[36]+
    J[37]-J[38]+J[39]-J[40]+J[41]+J[42]+J[43]-J[44]-J[45]+J[46]-J[47]-J[48]-J[49]+J[50]-J[51]+J[52]+J[53]+
    J[54]-J[55]-J[56]-J[57]-J[58]+J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]+H[1]+H[2]-H[3]+H[4]-H[5]+
    H[6]-H[7]+H[8]+H[9]-H[10]+H[11]+J[0]+J[1]-J[2]+J[3]-J[4]+J[5]-J[6]+J[7]+J[8]-J[9]+J[10]+J[11]-J[12]+
    J[13]-J[14]+J[15]-J[16]+J[17]+J[18]-J[19]+J[20]-J[21]+J[22]-J[23]+J[24]-J[25]+J[26]+J[27]-J[28]+J[29]-J[30]+
    J[31]-J[32]+J[33]-J[34]-J[35]+J[36]-J[37]-J[38]+J[39]-J[40]+J[41]+J[42]-J[43]+J[44]-J[45]+J[46]-J[47]-J[48]+
    J[49]-J[50]-J[51]+J[52]+J[53]-J[54]+J[55]-J[56]-J[57]+J[58]-J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +
    H[0]+H[1]+H[2]-H[3]+H[4]-H[5]+H[6]-H[7]+H[8]+H[9]-H[10]-H[11]+J[0]+J[1]-J[2]+J[3]-J[4]+J[5]-J[6]+J[7]+
    J[8]-J[9]-J[10]+J[11]-J[12]+J[13]-J[14]+J[15]-J[16]+J[17]+J[18]-J[19]-J[20]-J[21]+J[22]-J[23]+J[24]-J[25]+
    J[26]+J[27]-J[28]-J[29]-J[30]+J[31]-J[32]+J[33]-J[34]-J[35]+J[36]+J[37]-J[38]+J[39]-J[40]+J[41]+J[42]-J[43]-J[44]-J[45]+
    J[46]-J[47]-J[48]+J[49]+J[50]-J[51]+J[52]+J[53]-J[54]-J[55]-J[56]-J[57]+J[58]+J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+
    J[65], +H[0]+H[1]+H[2]-H[3]+H[4]-H[5]+H[6]-H[7]+H[8]-H[9]+H[10]+H[11]+J[0]+J[1]-J[2]+J[3]-J[4]+J[5]-J[6]+
    J[7]-J[8]+J[9]+J[10]+J[11]-J[12]+J[13]-J[14]+J[15]-J[16]+J[17]-J[18]+J[19]+J[20]-J[21]+J[22]-J[23]+J[24]-J[25]+
    J[26]-J[27]+J[28]+J[29]-J[30]+J[31]-J[32]+J[33]-J[34]+J[35]-J[36]-J[37]-J[38]+J[39]-J[40]+J[41]-J[42]+
    J[43]+J[44]-J[45]+J[46]-J[47]+J[48]-J[49]-J[50]-J[51]+J[52]-J[53]+J[54]+J[55]-J[56]+J[57]-J[58]-J[59]-J[60]+
    J[61]+J[62]-J[63]-J[64]+J[65], +H[0]+H[1]+H[2]-H[3]+H[4]-H[5]+H[6]-H[7]+H[8]-H[9]+H[10]-H[11]+J[0]+J[1]-J[2]+
    J[3]-J[4]+J[5]-J[6]+J[7]-J[8]+J[9]-J[10]+J[11]-J[12]+J[13]-J[14]+J[15]-J[16]+J[17]-J[18]+J[19]-J[20]-J[21]+
    J[22]-J[23]+J[24]-J[25]+J[26]-J[27]+J[28]-J[29]-J[30]+J[31]-J[32]+J[33]-J[34]+J[35]-J[36]+J[37]-J[38]+
    J[39]-J[40]+J[41]-J[42]+J[43]-J[44]-J[45]+J[46]-J[47]+J[48]-J[49]+J[50]-J[51]+J[52]-J[53]+J[54]-J[55]-J[56]+
    J[57]-J[58]+J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]+H[1]+H[2]-H[3]+H[4]-H[5]+H[6]-H[7]+H[8]-H[9]-H[10]+
    H[11]+J[0]+J[1]-J[2]+J[3]-J[4]+J[5]-J[6]+J[7]-J[8]-J[9]+J[10]+J[11]-J[12]+J[13]-J[14]+J[15]-J[16]+J[17]-J[18]-J[19]+
    J[20]-J[21]+J[22]-J[23]+J[24]-J[25]+J[26]-J[27]-J[28]+J[29]-J[30]+J[31]-J[32]+J[33]-J[34]+J[35]+J[36]-J[37]-J[38]+
    J[39]-J[40]+J[41]-J[42]-J[43]+J[44]-J[45]+J[46]-J[47]+J[48]+J[49]-J[50]-J[51]+J[52]-J[53]-J[54]+J[55]-J[56]+
    J[57]+J[58]-J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]+H[1]+H[2]-H[3]+H[4]-H[5]+H[6]-H[7]+H[8]-H[9]-H[10]-H[11]+
    J[0]+J[1]-J[2]+J[3]-J[4]+J[5]-J[6]+J[7]-J[8]-J[9]-J[10]+J[11]-J[12]+J[13]-J[14]+J[15]-J[16]+J[17]-J[18]-J[19]-J[20]-J[21]+
    J[22]-J[23]+J[24]-J[25]+J[26]-J[27]-J[28]-J[29]-J[30]+J[31]-J[32]+J[33]-J[34]+J[35]+J[36]+J[37]-J[38]+
    J[39]-J[40]+J[41]-J[42]-J[43]-J[44]-J[45]+J[46]-J[47]+J[48]+J[49]+J[50]-J[51]+J[52]-J[53]-J[54]-J[55]-J[56]+
    J[57]+J[58]+J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]+H[1]+H[2]-H[3]+H[4]-H[5]+H[6]-H[7]-H[8]+
    H[9]+H[10]+H[11]+J[0]+J[1]-J[2]+J[3]-J[4]+J[5]-J[6]-J[7]+J[8]+J[9]+J[10]+J[11]-J[12]+J[13]-J[14]+J[15]-J[16]-J[17]+
    J[18]+J[19]+J[20]-J[21]+J[22]-J[23]+J[24]-J[25]-J[26]+J[27]+J[28]+J[29]-J[30]+J[31]-J[32]+J[33]+J[34]-J[35]-J[36]-J[37]-J[38]+
    J[39]-J[40]-J[41]+J[42]+J[43]+J[44]-J[45]+J[46]+J[47]-J[48]-J[49]-J[50]-J[51]-J[52]+J[53]+J[54]+J[55]+
    J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]+H[1]+H[2]-H[3]+H[4]-H[5]+H[6]-H[7]-H[8]+
    H[9]+H[10]-H[11]+J[0]+J[1]-J[2]+J[3]-J[4]+J[5]-J[6]-J[7]+J[8]+J[9]-J[10]+J[11]-J[12]+J[13]-J[14]+J[15]-J[16]-J[17]+
    J[18]+J[19]-J[20]-J[21]+J[22]-J[23]+J[24]-J[25]-J[26]+J[27]+J[28]-J[29]-J[30]+J[31]-J[32]+J[33]+J[34]-J[35]-J[36]+
    J[37]-J[38]+J[39]-J[40]-J[41]+J[42]+J[43]-J[44]-J[45]+J[46]+J[47]-J[48]-J[49]+J[50]-J[51]-J[52]+J[53]+
    J[54]-J[55]+J[56]-J[57]-J[58]+J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]+H[1]+H[2]-H[3]+H[4]-H[5]+
    H[6]-H[7]-H[8]+H[9]-H[10]+H[11]+J[0]+J[1]-J[2]+J[3]-J[4]+J[5]-J[6]-J[7]+J[8]-J[9]+J[10]+J[11]-J[12]+
    J[13]-J[14]+J[15]-J[16]-J[17]+J[18]-J[19]+J[20]-J[21]+J[22]-J[23]+J[24]-J[25]-J[26]+J[27]-J[28]+J[29]-J[30]+
    J[31]-J[32]+J[33]+J[34]-J[35]+J[36]-J[37]-J[38]+J[39]-J[40]-J[41]+J[42]-J[43]+J[44]-J[45]+J[46]+J[47]-J[48]+
    J[49]-J[50]-J[51]-J[52]+J[53]-J[54]+J[55]+J[56]-J[57]+J[58]-J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +
    H[0]+H[1]+H[2]-H[3]+H[4]-H[5]+H[6]-H[7]-H[8]+H[9]-H[10]-H[11]+J[0]+J[1]-J[2]+J[3]-J[4]+J[5]-J[6]-J[7]+
    J[8]-J[9]-J[10]+J[11]-J[12]+J[13]-J[14]+J[15]-J[16]-J[17]+J[18]-J[19]-J[20]-J[21]+J[22]-J[23]+J[24]-J[25]-J[26]+
    J[27]-J[28]-J[29]-J[30]+J[31]-J[32]+J[33]+J[34]-J[35]+J[36]+J[37]-J[38]+J[39]-J[40]-J[41]+J[42]-J[43]-J[44]-J[45]+
    J[46]+J[47]-J[48]+J[49]+J[50]-J[51]-J[52]+J[53]-J[54]-J[55]+J[56]-J[57]+J[58]+J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+
    J[65], +H[0]+H[1]+H[2]-H[3]+H[4]-H[5]+H[6]-H[7]-H[8]-H[9]+H[10]+H[11]+J[0]+J[1]-J[2]+J[3]-J[4]+J[5]-J[6]-J[7]-J[8]+
    J[9]+J[10]+J[11]-J[12]+J[13]-J[14]+J[15]-J[16]-J[17]-J[18]+J[19]+J[20]-J[21]+J[22]-J[23]+J[24]-J[25]-J[26]-J[27]+
    J[28]+J[29]-J[30]+J[31]-J[32]+J[33]+J[34]+J[35]-J[36]-J[37]-J[38]+J[39]-J[40]-J[41]-J[42]+J[43]+J[44]-J[45]+
    J[46]+J[47]+J[48]-J[49]-J[50]-J[51]-J[52]-J[53]+J[54]+J[55]+J[56]+J[57]-J[58]-J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+
    J[65], +H[0]+H[1]+H[2]-H[3]+H[4]-H[5]+H[6]-H[7]-H[8]-H[9]+H[10]-H[11]+J[0]+J[1]-J[2]+J[3]-J[4]+J[5]-J[6]-J[7]-J[8]+
    J[9]-J[10]+J[11]-J[12]+J[13]-J[14]+J[15]-J[16]-J[17]-J[18]+J[19]-J[20]-J[21]+J[22]-J[23]+J[24]-J[25]-J[26]-J[27]+
    J[28]-J[29]-J[30]+J[31]-J[32]+J[33]+J[34]+J[35]-J[36]+J[37]-J[38]+J[39]-J[40]-J[41]-J[42]+J[43]-J[44]-J[45]+
    J[46]+J[47]+J[48]-J[49]+J[50]-J[51]-J[52]-J[53]+J[54]-J[55]+J[56]+J[57]-J[58]+J[59]+J[60]-J[61]+J[62]-J[63]+
    J[64]-J[65], +H[0]+H[1]+H[2]-H[3]+H[4]-H[5]+H[6]-H[7]-H[8]-H[9]-H[10]+H[11]+J[0]+J[1]-J[2]+J[3]-J[4]+
    J[5]-J[6]-J[7]-J[8]-J[9]+J[10]+J[11]-J[12]+J[13]-J[14]+J[15]-J[16]-J[17]-J[18]-J[19]+J[20]-J[21]+J[22]-J[23]+
    J[24]-J[25]-J[26]-J[27]-J[28]+J[29]-J[30]+J[31]-J[32]+J[33]+J[34]+J[35]+J[36]-J[37]-J[38]+J[39]-J[40]-J[41]-J[42]-J[43]+
    J[44]-J[45]+J[46]+J[47]+J[48]+J[49]-J[50]-J[51]-J[52]-J[53]-J[54]+J[55]+J[56]+J[57]+J[58]-J[59]+J[60]+
    J[61]-J[62]+J[63]-J[64]-J[65], +H[0]+H[1]+H[2]-H[3]+H[4]-H[5]+H[6]-H[7]-H[8]-H[9]-H[10]-H[11]+J[0]+J[1]-J[2]+
    J[3]-J[4]+J[5]-J[6]-J[7]-J[8]-J[9]-J[10]+J[11]-J[12]+J[13]-J[14]+J[15]-J[16]-J[17]-J[18]-J[19]-J[20]-J[21]+
    J[22]-J[23]+J[24]-J[25]-J[26]-J[27]-J[28]-J[29]-J[30]+J[31]-J[32]+J[33]+J[34]+J[35]+J[36]+J[37]-J[38]+
    J[39]-J[40]-J[41]-J[42]-J[43]-J[44]-J[45]+J[46]+J[47]+J[48]+J[49]+J[50]-J[51]-J[52]-J[53]-J[54]-J[55]+
    J[56]+J[57]+J[58]+J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]+H[1]+H[2]-H[3]+H[4]-H[5]-H[6]+H[7]+
    H[8]+H[9]+H[10]+H[11]+J[0]+J[1]-J[2]+J[3]-J[4]-J[5]+J[6]+J[7]+J[8]+J[9]+J[10]+J[11]-J[12]+J[13]-J[14]-J[15]+
    J[16]+J[17]+J[18]+J[19]+J[20]-J[21]+J[22]-J[23]-J[24]+J[25]+J[26]+J[27]+J[28]+J[29]-J[30]+J[31]+J[32]-J[33]-J[34]-J[35]-J[36]-J[37]-J[38]-J[39]+
    J[40]+J[41]+J[42]+J[43]+J[44]+J[45]-J[46]-J[47]-J[48]-J[49]-J[50]-J[51]-J[52]-J[53]-J[54]-J[55]+J[56]+
    J[57]+J[58]+J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]+H[1]+H[2]-H[3]+H[4]-H[5]-H[6]+H[7]+H[8]+
    H[9]+H[10]-H[11]+J[0]+J[1]-J[2]+J[3]-J[4]-J[5]+J[6]+J[7]+J[8]+J[9]-J[10]+J[11]-J[12]+J[13]-J[14]-J[15]+
    J[16]+J[17]+J[18]+J[19]-J[20]-J[21]+J[22]-J[23]-J[24]+J[25]+J[26]+J[27]+J[28]-J[29]-J[30]+J[31]+J[32]-J[33]-J[34]-J[35]-J[36]+
    J[37]-J[38]-J[39]+J[40]+J[41]+J[42]+J[43]-J[44]+J[45]-J[46]-J[47]-J[48]-J[49]+J[50]-J[51]-J[52]-J[53]-J[54]+
    J[55]+J[56]+J[57]+J[58]-J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]+H[1]+H[2]-H[3]+H[4]-H[5]-H[6]+
    H[7]+H[8]+H[9]-H[10]+H[11]+J[0]+J[1]-J[2]+J[3]-J[4]-J[5]+J[6]+J[7]+J[8]-J[9]+J[10]+J[11]-J[12]+J[13]-J[14]-J[15]+
    J[16]+J[17]+J[18]-J[19]+J[20]-J[21]+J[22]-J[23]-J[24]+J[25]+J[26]+J[27]-J[28]+J[29]-J[30]+J[31]+J[32]-J[33]-J[34]-J[35]+
    J[36]-J[37]-J[38]-J[39]+J[40]+J[41]+J[42]-J[43]+J[44]+J[45]-J[46]-J[47]-J[48]+J[49]-J[50]-J[51]-J[52]-J[53]+
    J[54]-J[55]+J[56]+J[57]-J[58]+J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]+H[1]+H[2]-H[3]+H[4]-H[5]-H[6]+
    H[7]+H[8]+H[9]-H[10]-H[11]+J[0]+J[1]-J[2]+J[3]-J[4]-J[5]+J[6]+J[7]+J[8]-J[9]-J[10]+J[11]-J[12]+J[13]-J[14]-J[15]+
    J[16]+J[17]+J[18]-J[19]-J[20]-J[21]+J[22]-J[23]-J[24]+J[25]+J[26]+J[27]-J[28]-J[29]-J[30]+J[31]+J[32]-J[33]-J[34]-J[35]+
    J[36]+J[37]-J[38]-J[39]+J[40]+J[41]+J[42]-J[43]-J[44]+J[45]-J[46]-J[47]-J[48]+J[49]+J[50]-J[51]-J[52]-J[53]+
    J[54]+J[55]+J[56]+J[57]-J[58]-J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]+H[1]+H[2]-H[3]+H[4]-H[5]-H[6]+
    H[7]+H[8]-H[9]+H[10]+H[11]+J[0]+J[1]-J[2]+J[3]-J[4]-J[5]+J[6]+J[7]-J[8]+J[9]+J[10]+J[11]-J[12]+J[13]-J[14]-J[15]+
    J[16]+J[17]-J[18]+J[19]+J[20]-J[21]+J[22]-J[23]-J[24]+J[25]+J[26]-J[27]+J[28]+J[29]-J[30]+J[31]+J[32]-J[33]-J[34]+
    J[35]-J[36]-J[37]-J[38]-J[39]+J[40]+J[41]-J[42]+J[43]+J[44]+J[45]-J[46]-J[47]+J[48]-J[49]-J[50]-J[51]-J[52]+
    J[53]-J[54]-J[55]+J[56]-J[57]+J[58]+J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]+H[1]+H[2]-H[3]+
    H[4]-H[5]-H[6]+H[7]+H[8]-H[9]+H[10]-H[11]+J[0]+J[1]-J[2]+J[3]-J[4]-J[5]+J[6]+J[7]-J[8]+J[9]-J[10]+J[11]-J[12]+
    J[13]-J[14]-J[15]+J[16]+J[17]-J[18]+J[19]-J[20]-J[21]+J[22]-J[23]-J[24]+J[25]+J[26]-J[27]+J[28]-J[29]-J[30]+
    J[31]+J[32]-J[33]-J[34]+J[35]-J[36]+J[37]-J[38]-J[39]+J[40]+J[41]-J[42]+J[43]-J[44]+J[45]-J[46]-J[47]+
    J[48]-J[49]+J[50]-J[51]-J[52]+J[53]-J[54]+J[55]+J[56]-J[57]+J[58]-J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +
    H[0]+H[1]+H[2]-H[3]+H[4]-H[5]-H[6]+H[7]+H[8]-H[9]-H[10]+H[11]+J[0]+J[1]-J[2]+J[3]-J[4]-J[5]+J[6]+J[7]-J[8]-J[9]+
    J[10]+J[11]-J[12]+J[13]-J[14]-J[15]+J[16]+J[17]-J[18]-J[19]+J[20]-J[21]+J[22]-J[23]-J[24]+J[25]+J[26]-J[27]-J[28]+
    J[29]-J[30]+J[31]+J[32]-J[33]-J[34]+J[35]+J[36]-J[37]-J[38]-J[39]+J[40]+J[41]-J[42]-J[43]+J[44]+J[45]-J[46]-J[47]+
    J[48]+J[49]-J[50]-J[51]-J[52]+J[53]+J[54]-J[55]+J[56]-J[57]-J[58]+J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +
    H[0]+H[1]+H[2]-H[3]+H[4]-H[5]-H[6]+H[7]+H[8]-H[9]-H[10]-H[11]+J[0]+J[1]-J[2]+J[3]-J[4]-J[5]+J[6]+J[7]-J[8]-J[9]-J[10]+
    J[11]-J[12]+J[13]-J[14]-J[15]+J[16]+J[17]-J[18]-J[19]-J[20]-J[21]+J[22]-J[23]-J[24]+J[25]+J[26]-J[27]-J[28]-J[29]-J[30]+
    J[31]+J[32]-J[33]-J[34]+J[35]+J[36]+J[37]-J[38]-J[39]+J[40]+J[41]-J[42]-J[43]-J[44]+J[45]-J[46]-J[47]+
    J[48]+J[49]+J[50]-J[51]-J[52]+J[53]+J[54]+J[55]+J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+
    J[65], +H[0]+H[1]+H[2]-H[3]+H[4]-H[5]-H[6]+H[7]-H[8]+H[9]+H[10]+H[11]+J[0]+J[1]-J[2]+J[3]-J[4]-J[5]+
    J[6]-J[7]+J[8]+J[9]+J[10]+J[11]-J[12]+J[13]-J[14]-J[15]+J[16]-J[17]+J[18]+J[19]+J[20]-J[21]+J[22]-J[23]-J[24]+
    J[25]-J[26]+J[27]+J[28]+J[29]-J[30]+J[31]+J[32]-J[33]+J[34]-J[35]-J[36]-J[37]-J[38]-J[39]+J[40]-J[41]+
    J[42]+J[43]+J[44]+J[45]-J[46]+J[47]-J[48]-J[49]-J[50]-J[51]+J[52]-J[53]-J[54]-J[55]-J[56]+J[57]+J[58]+
    J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]+H[1]+H[2]-H[3]+H[4]-H[5]-H[6]+H[7]-H[8]+H[9]+H[10]-H[11]+
    J[0]+J[1]-J[2]+J[3]-J[4]-J[5]+J[6]-J[7]+J[8]+J[9]-J[10]+J[11]-J[12]+J[13]-J[14]-J[15]+J[16]-J[17]+J[18]+
    J[19]-J[20]-J[21]+J[22]-J[23]-J[24]+J[25]-J[26]+J[27]+J[28]-J[29]-J[30]+J[31]+J[32]-J[33]+J[34]-J[35]-J[36]+
    J[37]-J[38]-J[39]+J[40]-J[41]+J[42]+J[43]-J[44]+J[45]-J[46]+J[47]-J[48]-J[49]+J[50]-J[51]+J[52]-J[53]-J[54]+
    J[55]-J[56]+J[57]+J[58]-J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]+H[1]+H[2]-H[3]+H[4]-H[5]-H[6]+
    H[7]-H[8]+H[9]-H[10]+H[11]+J[0]+J[1]-J[2]+J[3]-J[4]-J[5]+J[6]-J[7]+J[8]-J[9]+J[10]+J[11]-J[12]+J[13]-J[14]-J[15]+
    J[16]-J[17]+J[18]-J[19]+J[20]-J[21]+J[22]-J[23]-J[24]+J[25]-J[26]+J[27]-J[28]+J[29]-J[30]+J[31]+J[32]-J[33]+
    J[34]-J[35]+J[36]-J[37]-J[38]-J[39]+J[40]-J[41]+J[42]-J[43]+J[44]+J[45]-J[46]+J[47]-J[48]+J[49]-J[50]-J[51]+
    J[52]-J[53]+J[54]-J[55]-J[56]+J[57]-J[58]+J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]+H[1]+H[2]-H[3]+
    H[4]-H[5]-H[6]+H[7]-H[8]+H[9]-H[10]-H[11]+J[0]+J[1]-J[2]+J[3]-J[4]-J[5]+J[6]-J[7]+J[8]-J[9]-J[10]+J[11]-J[12]+
    J[13]-J[14]-J[15]+J[16]-J[17]+J[18]-J[19]-J[20]-J[21]+J[22]-J[23]-J[24]+J[25]-J[26]+J[27]-J[28]-J[29]-J[30]+
    J[31]+J[32]-J[33]+J[34]-J[35]+J[36]+J[37]-J[38]-J[39]+J[40]-J[41]+J[42]-J[43]-J[44]+J[45]-J[46]+J[47]-J[48]+
    J[49]+J[50]-J[51]+J[52]-J[53]+J[54]+J[55]-J[56]+J[57]-J[58]-J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +
    H[0]+H[1]+H[2]-H[3]+H[4]-H[5]-H[6]+H[7]-H[8]-H[9]+H[10]+H[11]+J[0]+J[1]-J[2]+J[3]-J[4]-J[5]+J[6]-J[7]-J[8]+
    J[9]+J[10]+J[11]-J[12]+J[13]-J[14]-J[15]+J[16]-J[17]-J[18]+J[19]+J[20]-J[21]+J[22]-J[23]-J[24]+J[25]-J[26]-J[27]+
    J[28]+J[29]-J[30]+J[31]+J[32]-J[33]+J[34]+J[35]-J[36]-J[37]-J[38]-J[39]+J[40]-J[41]-J[42]+J[43]+J[44]+
    J[45]-J[46]+J[47]+J[48]-J[49]-J[50]-J[51]+J[52]+J[53]-J[54]-J[55]-J[56]-J[57]+J[58]+J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+
    J[65], +H[0]+H[1]+H[2]-H[3]+H[4]-H[5]-H[6]+H[7]-H[8]-H[9]+H[10]-H[11]+J[0]+J[1]-J[2]+J[3]-J[4]-J[5]+
    J[6]-J[7]-J[8]+J[9]-J[10]+J[11]-J[12]+J[13]-J[14]-J[15]+J[16]-J[17]-J[18]+J[19]-J[20]-J[21]+J[22]-J[23]-J[24]+
    J[25]-J[26]-J[27]+J[28]-J[29]-J[30]+J[31]+J[32]-J[33]+J[34]+J[35]-J[36]+J[37]-J[38]-J[39]+J[40]-J[41]-J[42]+
    J[43]-J[44]+J[45]-J[46]+J[47]+J[48]-J[49]+J[50]-J[51]+J[52]+J[53]-J[54]+J[55]-J[56]-J[57]+J[58]-J[59]+
    J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]+H[1]+H[2]-H[3]+H[4]-H[5]-H[6]+H[7]-H[8]-H[9]-H[10]+H[11]+
    J[0]+J[1]-J[2]+J[3]-J[4]-J[5]+J[6]-J[7]-J[8]-J[9]+J[10]+J[11]-J[12]+J[13]-J[14]-J[15]+J[16]-J[17]-J[18]-J[19]+
    J[20]-J[21]+J[22]-J[23]-J[24]+J[25]-J[26]-J[27]-J[28]+J[29]-J[30]+J[31]+J[32]-J[33]+J[34]+J[35]+J[36]-J[37]-J[38]-J[39]+
    J[40]-J[41]-J[42]-J[43]+J[44]+J[45]-J[46]+J[47]+J[48]+J[49]-J[50]-J[51]+J[52]+J[53]+J[54]-J[55]-J[56]-J[57]-J[58]+
    J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]+H[1]+H[2]-H[3]+H[4]-H[5]-H[6]+H[7]-H[8]-H[9]-H[10]-H[11]+
    J[0]+J[1]-J[2]+J[3]-J[4]-J[5]+J[6]-J[7]-J[8]-J[9]-J[10]+J[11]-J[12]+J[13]-J[14]-J[15]+J[16]-J[17]-J[18]-J[19]-J[20]-J[21]+
    J[22]-J[23]-J[24]+J[25]-J[26]-J[27]-J[28]-J[29]-J[30]+J[31]+J[32]-J[33]+J[34]+J[35]+J[36]+J[37]-J[38]-J[39]+
    J[40]-J[41]-J[42]-J[43]-J[44]+J[45]-J[46]+J[47]+J[48]+J[49]+J[50]-J[51]+J[52]+J[53]+J[54]+J[55]-J[56]-J[57]-J[58]-J[59]+
    J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]+H[1]+H[2]-H[3]+H[4]-H[5]-H[6]-H[7]+H[8]+H[9]+H[10]+H[11]+
    J[0]+J[1]-J[2]+J[3]-J[4]-J[5]-J[6]+J[7]+J[8]+J[9]+J[10]+J[11]-J[12]+J[13]-J[14]-J[15]-J[16]+J[17]+J[18]+
    J[19]+J[20]-J[21]+J[22]-J[23]-J[24]-J[25]+J[26]+J[27]+J[28]+J[29]-J[30]+J[31]+J[32]+J[33]-J[34]-J[35]-J[36]-J[37]-J[38]-J[39]-J[40]+
    J[41]+J[42]+J[43]+J[44]+J[45]+J[46]-J[47]-J[48]-J[49]-J[50]+J[51]-J[52]-J[53]-J[54]-J[55]-J[56]-J[57]-J[58]-J[59]+
    J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]+H[1]+H[2]-H[3]+H[4]-H[5]-H[6]-H[7]+H[8]+H[9]+H[10]-H[11]+
    J[0]+J[1]-J[2]+J[3]-J[4]-J[5]-J[6]+J[7]+J[8]+J[9]-J[10]+J[11]-J[12]+J[13]-J[14]-J[15]-J[16]+J[17]+J[18]+
    J[19]-J[20]-J[21]+J[22]-J[23]-J[24]-J[25]+J[26]+J[27]+J[28]-J[29]-J[30]+J[31]+J[32]+J[33]-J[34]-J[35]-J[36]+
    J[37]-J[38]-J[39]-J[40]+J[41]+J[42]+J[43]-J[44]+J[45]+J[46]-J[47]-J[48]-J[49]+J[50]+J[51]-J[52]-J[53]-J[54]+
    J[55]-J[56]-J[57]-J[58]+J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]+H[1]+H[2]-H[3]+H[4]-H[5]-H[6]-H[7]+
    H[8]+H[9]-H[10]+H[11]+J[0]+J[1]-J[2]+J[3]-J[4]-J[5]-J[6]+J[7]+J[8]-J[9]+J[10]+J[11]-J[12]+J[13]-J[14]-J[15]-J[16]+
    J[17]+J[18]-J[19]+J[20]-J[21]+J[22]-J[23]-J[24]-J[25]+J[26]+J[27]-J[28]+J[29]-J[30]+J[31]+J[32]+J[33]-J[34]-J[35]+
    J[36]-J[37]-J[38]-J[39]-J[40]+J[41]+J[42]-J[43]+J[44]+J[45]+J[46]-J[47]-J[48]+J[49]-J[50]+J[51]-J[52]-J[53]+
    J[54]-J[55]-J[56]-J[57]+J[58]-J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]+H[1]+H[2]-H[3]+H[4]-H[5]-H[6]-H[7]+
    H[8]+H[9]-H[10]-H[11]+J[0]+J[1]-J[2]+J[3]-J[4]-J[5]-J[6]+J[7]+J[8]-J[9]-J[10]+J[11]-J[12]+J[13]-J[14]-J[15]-J[16]+
    J[17]+J[18]-J[19]-J[20]-J[21]+J[22]-J[23]-J[24]-J[25]+J[26]+J[27]-J[28]-J[29]-J[30]+J[31]+J[32]+J[33]-J[34]-J[35]+
    J[36]+J[37]-J[38]-J[39]-J[40]+J[41]+J[42]-J[43]-J[44]+J[45]+J[46]-J[47]-J[48]+J[49]+J[50]+J[51]-J[52]-J[53]+
    J[54]+J[55]-J[56]-J[57]+J[58]+J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]+H[1]+H[2]-H[3]+H[4]-H[5]-H[6]-H[7]+
    H[8]-H[9]+H[10]+H[11]+J[0]+J[1]-J[2]+J[3]-J[4]-J[5]-J[6]+J[7]-J[8]+J[9]+J[10]+J[11]-J[12]+J[13]-J[14]-J[15]-J[16]+
    J[17]-J[18]+J[19]+J[20]-J[21]+J[22]-J[23]-J[24]-J[25]+J[26]-J[27]+J[28]+J[29]-J[30]+J[31]+J[32]+J[33]-J[34]+
    J[35]-J[36]-J[37]-J[38]-J[39]-J[40]+J[41]-J[42]+J[43]+J[44]+J[45]+J[46]-J[47]+J[48]-J[49]-J[50]+J[51]-J[52]+
    J[53]-J[54]-J[55]-J[56]+J[57]-J[58]-J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]+H[1]+H[2]-H[3]+
    H[4]-H[5]-H[6]-H[7]+H[8]-H[9]+H[10]-H[11]+J[0]+J[1]-J[2]+J[3]-J[4]-J[5]-J[6]+J[7]-J[8]+J[9]-J[10]+J[11]-J[12]+
    J[13]-J[14]-J[15]-J[16]+J[17]-J[18]+J[19]-J[20]-J[21]+J[22]-J[23]-J[24]-J[25]+J[26]-J[27]+J[28]-J[29]-J[30]+
    J[31]+J[32]+J[33]-J[34]+J[35]-J[36]+J[37]-J[38]-J[39]-J[40]+J[41]-J[42]+J[43]-J[44]+J[45]+J[46]-J[47]+
    J[48]-J[49]+J[50]+J[51]-J[52]+J[53]-J[54]+J[55]-J[56]+J[57]-J[58]+J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +
    H[0]+H[1]+H[2]-H[3]+H[4]-H[5]-H[6]-H[7]+H[8]-H[9]-H[10]+H[11]+J[0]+J[1]-J[2]+J[3]-J[4]-J[5]-J[6]+J[7]-J[8]-J[9]+
    J[10]+J[11]-J[12]+J[13]-J[14]-J[15]-J[16]+J[17]-J[18]-J[19]+J[20]-J[21]+J[22]-J[23]-J[24]-J[25]+J[26]-J[27]-J[28]+
    J[29]-J[30]+J[31]+J[32]+J[33]-J[34]+J[35]+J[36]-J[37]-J[38]-J[39]-J[40]+J[41]-J[42]-J[43]+J[44]+J[45]+
    J[46]-J[47]+J[48]+J[49]-J[50]+J[51]-J[52]+J[53]+J[54]-J[55]-J[56]+J[57]+J[58]-J[59]-J[60]-J[61]+J[62]+
    J[63]-J[64]-J[65], +H[0]+H[1]+H[2]-H[3]+H[4]-H[5]-H[6]-H[7]+H[8]-H[9]-H[10]-H[11]+J[0]+J[1]-J[2]+J[3]-J[4]-J[5]-J[6]+
    J[7]-J[8]-J[9]-J[10]+J[11]-J[12]+J[13]-J[14]-J[15]-J[16]+J[17]-J[18]-J[19]-J[20]-J[21]+J[22]-J[23]-J[24]-J[25]+
    J[26]-J[27]-J[28]-J[29]-J[30]+J[31]+J[32]+J[33]-J[34]+J[35]+J[36]+J[37]-J[38]-J[39]-J[40]+J[41]-J[42]-J[43]-J[44]+
    J[45]+J[46]-J[47]+J[48]+J[49]+J[50]+J[51]-J[52]+J[53]+J[54]+J[55]-J[56]+J[57]+J[58]+J[59]-J[60]-J[61]-J[62]+
    J[63]+J[64]+J[65], +H[0]+H[1]+H[2]-H[3]+H[4]-H[5]-H[6]-H[7]-H[8]+H[9]+H[10]+H[11]+J[0]+J[1]-J[2]+J[3]-J[4]-J[5]-J[6]-J[7]+
    J[8]+J[9]+J[10]+J[11]-J[12]+J[13]-J[14]-J[15]-J[16]-J[17]+J[18]+J[19]+J[20]-J[21]+J[22]-J[23]-J[24]-J[25]-J[26]+
    J[27]+J[28]+J[29]-J[30]+J[31]+J[32]+J[33]+J[34]-J[35]-J[36]-J[37]-J[38]-J[39]-J[40]-J[41]+J[42]+J[43]+
    J[44]+J[45]+J[46]+J[47]-J[48]-J[49]-J[50]+J[51]+J[52]-J[53]-J[54]-J[55]+J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+
    J[63]+J[64]+J[65], +H[0]+H[1]+H[2]-H[3]+H[4]-H[5]-H[6]-H[7]-H[8]+H[9]+H[10]-H[11]+J[0]+J[1]-J[2]+J[3]-J[4]-J[5]-J[6]-J[7]+
    J[8]+J[9]-J[10]+J[11]-J[12]+J[13]-J[14]-J[15]-J[16]-J[17]+J[18]+J[19]-J[20]-J[21]+J[22]-J[23]-J[24]-J[25]-J[26]+
    J[27]+J[28]-J[29]-J[30]+J[31]+J[32]+J[33]+J[34]-J[35]-J[36]+J[37]-J[38]-J[39]-J[40]-J[41]+J[42]+J[43]-J[44]+
    J[45]+J[46]+J[47]-J[48]-J[49]+J[50]+J[51]+J[52]-J[53]-J[54]+J[55]+J[56]-J[57]-J[58]+J[59]-J[60]-J[61]+
    J[62]+J[63]-J[64]-J[65], +H[0]+H[1]+H[2]-H[3]+H[4]-H[5]-H[6]-H[7]-H[8]+H[9]-H[10]+H[11]+J[0]+J[1]-J[2]+
    J[3]-J[4]-J[5]-J[6]-J[7]+J[8]-J[9]+J[10]+J[11]-J[12]+J[13]-J[14]-J[15]-J[16]-J[17]+J[18]-J[19]+J[20]-J[21]+
    J[22]-J[23]-J[24]-J[25]-J[26]+J[27]-J[28]+J[29]-J[30]+J[31]+J[32]+J[33]+J[34]-J[35]+J[36]-J[37]-J[38]-J[39]-J[40]-J[41]+
    J[42]-J[43]+J[44]+J[45]+J[46]+J[47]-J[48]+J[49]-J[50]+J[51]+J[52]-J[53]+J[54]-J[55]+J[56]-J[57]+J[58]-J[59]-J[60]+
    J[61]-J[62]-J[63]+J[64]-J[65], +H[0]+H[1]+H[2]-H[3]+H[4]-H[5]-H[6]-H[7]-H[8]+H[9]-H[10]-H[11]+J[0]+J[1]-J[2]+
    J[3]-J[4]-J[5]-J[6]-J[7]+J[8]-J[9]-J[10]+J[11]-J[12]+J[13]-J[14]-J[15]-J[16]-J[17]+J[18]-J[19]-J[20]-J[21]+
    J[22]-J[23]-J[24]-J[25]-J[26]+J[27]-J[28]-J[29]-J[30]+J[31]+J[32]+J[33]+J[34]-J[35]+J[36]+J[37]-J[38]-J[39]-J[40]-J[41]+
    J[42]-J[43]-J[44]+J[45]+J[46]+J[47]-J[48]+J[49]+J[50]+J[51]+J[52]-J[53]+J[54]+J[55]+J[56]-J[57]+J[58]+
    J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]+H[1]+H[2]-H[3]+H[4]-H[5]-H[6]-H[7]-H[8]-H[9]+H[10]+
    H[11]+J[0]+J[1]-J[2]+J[3]-J[4]-J[5]-J[6]-J[7]-J[8]+J[9]+J[10]+J[11]-J[12]+J[13]-J[14]-J[15]-J[16]-J[17]-J[18]+
    J[19]+J[20]-J[21]+J[22]-J[23]-J[24]-J[25]-J[26]-J[27]+J[28]+J[29]-J[30]+J[31]+J[32]+J[33]+J[34]+J[35]-J[36]-J[37]-J[38]-J[39]-J[40]-J[41]-J[42]+
    J[43]+J[44]+J[45]+J[46]+J[47]+J[48]-J[49]-J[50]+J[51]+J[52]+J[53]-J[54]-J[55]+J[56]+J[57]-J[58]-J[59]+
    J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]+H[1]+H[2]-H[3]+H[4]-H[5]-H[6]-H[7]-H[8]-H[9]+H[10]-H[11]+
    J[0]+J[1]-J[2]+J[3]-J[4]-J[5]-J[6]-J[7]-J[8]+J[9]-J[10]+J[11]-J[12]+J[13]-J[14]-J[15]-J[16]-J[17]-J[18]+
    J[19]-J[20]-J[21]+J[22]-J[23]-J[24]-J[25]-J[26]-J[27]+J[28]-J[29]-J[30]+J[31]+J[32]+J[33]+J[34]+J[35]-J[36]+
    J[37]-J[38]-J[39]-J[40]-J[41]-J[42]+J[43]-J[44]+J[45]+J[46]+J[47]+J[48]-J[49]+J[50]+J[51]+J[52]+J[53]-J[54]+
    J[55]+J[56]+J[57]-J[58]+J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]+H[1]+H[2]-H[3]+H[4]-H[5]-H[6]-H[7]-H[8]-H[9]-H[10]+
    H[11]+J[0]+J[1]-J[2]+J[3]-J[4]-J[5]-J[6]-J[7]-J[8]-J[9]+J[10]+J[11]-J[12]+J[13]-J[14]-J[15]-J[16]-J[17]-J[18]-J[19]+
    J[20]-J[21]+J[22]-J[23]-J[24]-J[25]-J[26]-J[27]-J[28]+J[29]-J[30]+J[31]+J[32]+J[33]+J[34]+J[35]+J[36]-J[37]-J[38]-J[39]-J[40]-J[41]-J[42]-J[43]+
    J[44]+J[45]+J[46]+J[47]+J[48]+J[49]-J[50]+J[51]+J[52]+J[53]+J[54]-J[55]+J[56]+J[57]+J[58]-J[59]+J[60]+
    J[61]-J[62]+J[63]-J[64]-J[65], +H[0]+H[1]+H[2]-H[3]+H[4]-H[5]-H[6]-H[7]-H[8]-H[9]-H[10]-H[11]+J[0]+J[1]-J[2]+
    J[3]-J[4]-J[5]-J[6]-J[7]-J[8]-J[9]-J[10]+J[11]-J[12]+J[13]-J[14]-J[15]-J[16]-J[17]-J[18]-J[19]-J[20]-J[21]+
    J[22]-J[23]-J[24]-J[25]-J[26]-J[27]-J[28]-J[29]-J[30]+J[31]+J[32]+J[33]+J[34]+J[35]+J[36]+J[37]-J[38]-J[39]-J[40]-J[41]-J[42]-J[43]-J[44]+
    J[45]+J[46]+J[47]+J[48]+J[49]+J[50]+J[51]+J[52]+J[53]+J[54]+J[55]+J[56]+J[57]+J[58]+J[59]+J[60]+J[61]+
    J[62]+J[63]+J[64]+J[65], +H[0]+H[1]+H[2]-H[3]-H[4]+H[5]+H[6]+H[7]+H[8]+H[9]+H[10]+H[11]+J[0]+J[1]-J[2]-J[3]+
    J[4]+J[5]+J[6]+J[7]+J[8]+J[9]+J[10]+J[11]-J[12]-J[13]+J[14]+J[15]+J[16]+J[17]+J[18]+J[19]+J[20]-J[21]-J[22]+
    J[23]+J[24]+J[25]+J[26]+J[27]+J[28]+J[29]+J[30]-J[31]-J[32]-J[33]-J[34]-J[35]-J[36]-J[37]-J[38]-J[39]-J[40]-J[41]-J[42]-J[43]-J[44]+
    J[45]+J[46]+J[47]+J[48]+J[49]+J[50]+J[51]+J[52]+J[53]+J[54]+J[55]+J[56]+J[57]+J[58]+J[59]+J[60]+J[61]+
    J[62]+J[63]+J[64]+J[65], +H[0]+H[1]+H[2]-H[3]-H[4]+H[5]+H[6]+H[7]+H[8]+H[9]+H[10]-H[11]+J[0]+J[1]-J[2]-J[3]+
    J[4]+J[5]+J[6]+J[7]+J[8]+J[9]-J[10]+J[11]-J[12]-J[13]+J[14]+J[15]+J[16]+J[17]+J[18]+J[19]-J[20]-J[21]-J[22]+
    J[23]+J[24]+J[25]+J[26]+J[27]+J[28]-J[29]+J[30]-J[31]-J[32]-J[33]-J[34]-J[35]-J[36]+J[37]-J[38]-J[39]-J[40]-J[41]-J[42]-J[43]+
    J[44]+J[45]+J[46]+J[47]+J[48]+J[49]-J[50]+J[51]+J[52]+J[53]+J[54]-J[55]+J[56]+J[57]+J[58]-J[59]+J[60]+
    J[61]-J[62]+J[63]-J[64]-J[65], +H[0]+H[1]+H[2]-H[3]-H[4]+H[5]+H[6]+H[7]+H[8]+H[9]-H[10]+H[11]+J[0]+J[1]-J[2]-J[3]+
    J[4]+J[5]+J[6]+J[7]+J[8]-J[9]+J[10]+J[11]-J[12]-J[13]+J[14]+J[15]+J[16]+J[17]+J[18]-J[19]+J[20]-J[21]-J[22]+
    J[23]+J[24]+J[25]+J[26]+J[27]-J[28]+J[29]+J[30]-J[31]-J[32]-J[33]-J[34]-J[35]+J[36]-J[37]-J[38]-J[39]-J[40]-J[41]-J[42]+
    J[43]-J[44]+J[45]+J[46]+J[47]+J[48]-J[49]+J[50]+J[51]+J[52]+J[53]-J[54]+J[55]+J[56]+J[57]-J[58]+J[59]+
    J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]+H[1]+H[2]-H[3]-H[4]+H[5]+H[6]+H[7]+H[8]+H[9]-H[10]-H[11]+
    J[0]+J[1]-J[2]-J[3]+J[4]+J[5]+J[6]+J[7]+J[8]-J[9]-J[10]+J[11]-J[12]-J[13]+J[14]+J[15]+J[16]+J[17]+J[18]-J[19]-J[20]-J[21]-J[22]+
    J[23]+J[24]+J[25]+J[26]+J[27]-J[28]-J[29]+J[30]-J[31]-J[32]-J[33]-J[34]-J[35]+J[36]+J[37]-J[38]-J[39]-J[40]-J[41]-J[42]+
    J[43]+J[44]+J[45]+J[46]+J[47]+J[48]-J[49]-J[50]+J[51]+J[52]+J[53]-J[54]-J[55]+J[56]+J[57]-J[58]-J[59]+
    J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]+H[1]+H[2]-H[3]-H[4]+H[5]+H[6]+H[7]+H[8]-H[9]+H[10]+H[11]+
    J[0]+J[1]-J[2]-J[3]+J[4]+J[5]+J[6]+J[7]-J[8]+J[9]+J[10]+J[11]-J[12]-J[13]+J[14]+J[15]+J[16]+J[17]-J[18]+
    J[19]+J[20]-J[21]-J[22]+J[23]+J[24]+J[25]+J[26]-J[27]+J[28]+J[29]+J[30]-J[31]-J[32]-J[33]-J[34]+J[35]-J[36]-J[37]-J[38]-J[39]-J[40]-J[41]+
    J[42]-J[43]-J[44]+J[45]+J[46]+J[47]-J[48]+J[49]+J[50]+J[51]+J[52]-J[53]+J[54]+J[55]+J[56]-J[57]+J[58]+
    J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]+H[1]+H[2]-H[3]-H[4]+H[5]+H[6]+H[7]+H[8]-H[9]+H[10]-H[11]+
    J[0]+J[1]-J[2]-J[3]+J[4]+J[5]+J[6]+J[7]-J[8]+J[9]-J[10]+J[11]-J[12]-J[13]+J[14]+J[15]+J[16]+J[17]-J[18]+
    J[19]-J[20]-J[21]-J[22]+J[23]+J[24]+J[25]+J[26]-J[27]+J[28]-J[29]+J[30]-J[31]-J[32]-J[33]-J[34]+J[35]-J[36]+
    J[37]-J[38]-J[39]-J[40]-J[41]+J[42]-J[43]+J[44]+J[45]+J[46]+J[47]-J[48]+J[49]-J[50]+J[51]+J[52]-J[53]+
    J[54]-J[55]+J[56]-J[57]+J[58]-J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]+H[1]+H[2]-H[3]-H[4]+H[5]+
    H[6]+H[7]+H[8]-H[9]-H[10]+H[11]+J[0]+J[1]-J[2]-J[3]+J[4]+J[5]+J[6]+J[7]-J[8]-J[9]+J[10]+J[11]-J[12]-J[13]+
    J[14]+J[15]+J[16]+J[17]-J[18]-J[19]+J[20]-J[21]-J[22]+J[23]+J[24]+J[25]+J[26]-J[27]-J[28]+J[29]+J[30]-J[31]-J[32]-J[33]-J[34]+
    J[35]+J[36]-J[37]-J[38]-J[39]-J[40]-J[41]+J[42]+J[43]-J[44]+J[45]+J[46]+J[47]-J[48]-J[49]+J[50]+J[51]+
    J[52]-J[53]-J[54]+J[55]+J[56]-J[57]-J[58]+J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]+H[1]+H[2]-H[3]-H[4]+
    H[5]+H[6]+H[7]+H[8]-H[9]-H[10]-H[11]+J[0]+J[1]-J[2]-J[3]+J[4]+J[5]+J[6]+J[7]-J[8]-J[9]-J[10]+J[11]-J[12]-J[13]+
    J[14]+J[15]+J[16]+J[17]-J[18]-J[19]-J[20]-J[21]-J[22]+J[23]+J[24]+J[25]+J[26]-J[27]-J[28]-J[29]+J[30]-J[31]-J[32]-J[33]-J[34]+
    J[35]+J[36]+J[37]-J[38]-J[39]-J[40]-J[41]+J[42]+J[43]+J[44]+J[45]+J[46]+J[47]-J[48]-J[49]-J[50]+J[51]+
    J[52]-J[53]-J[54]-J[55]+J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]+H[1]+H[2]-H[3]-H[4]+
    H[5]+H[6]+H[7]-H[8]+H[9]+H[10]+H[11]+J[0]+J[1]-J[2]-J[3]+J[4]+J[5]+J[6]-J[7]+J[8]+J[9]+J[10]+J[11]-J[12]-J[13]+
    J[14]+J[15]+J[16]-J[17]+J[18]+J[19]+J[20]-J[21]-J[22]+J[23]+J[24]+J[25]-J[26]+J[27]+J[28]+J[29]+J[30]-J[31]-J[32]-J[33]+
    J[34]-J[35]-J[36]-J[37]-J[38]-J[39]-J[40]+J[41]-J[42]-J[43]-J[44]+J[45]+J[46]-J[47]+J[48]+J[49]+J[50]+
    J[51]-J[52]+J[53]+J[54]+J[55]-J[56]+J[57]+J[58]+J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]+H[1]+
    H[2]-H[3]-H[4]+H[5]+H[6]+H[7]-H[8]+H[9]+H[10]-H[11]+J[0]+J[1]-J[2]-J[3]+J[4]+J[5]+J[6]-J[7]+J[8]+J[9]-J[10]+
    J[11]-J[12]-J[13]+J[14]+J[15]+J[16]-J[17]+J[18]+J[19]-J[20]-J[21]-J[22]+J[23]+J[24]+J[25]-J[26]+J[27]+
    J[28]-J[29]+J[30]-J[31]-J[32]-J[33]+J[34]-J[35]-J[36]+J[37]-J[38]-J[39]-J[40]+J[41]-J[42]-J[43]+J[44]+
    J[45]+J[46]-J[47]+J[48]+J[49]-J[50]+J[51]-J[52]+J[53]+J[54]-J[55]-J[56]+J[57]+J[58]-J[59]-J[60]-J[61]+
    J[62]+J[63]-J[64]-J[65], +H[0]+H[1]+H[2]-H[3]-H[4]+H[5]+H[6]+H[7]-H[8]+H[9]-H[10]+H[11]+J[0]+J[1]-J[2]-J[3]+
    J[4]+J[5]+J[6]-J[7]+J[8]-J[9]+J[10]+J[11]-J[12]-J[13]+J[14]+J[15]+J[16]-J[17]+J[18]-J[19]+J[20]-J[21]-J[22]+
    J[23]+J[24]+J[25]-J[26]+J[27]-J[28]+J[29]+J[30]-J[31]-J[32]-J[33]+J[34]-J[35]+J[36]-J[37]-J[38]-J[39]-J[40]+
    J[41]-J[42]+J[43]-J[44]+J[45]+J[46]-J[47]+J[48]-J[49]+J[50]+J[51]-J[52]+J[53]-J[54]+J[55]-J[56]+J[57]-J[58]+
    J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]+H[1]+H[2]-H[3]-H[4]+H[5]+H[6]+H[7]-H[8]+H[9]-H[10]-H[11]+
    J[0]+J[1]-J[2]-J[3]+J[4]+J[5]+J[6]-J[7]+J[8]-J[9]-J[10]+J[11]-J[12]-J[13]+J[14]+J[15]+J[16]-J[17]+J[18]-J[19]-J[20]-J[21]-J[22]+
    J[23]+J[24]+J[25]-J[26]+J[27]-J[28]-J[29]+J[30]-J[31]-J[32]-J[33]+J[34]-J[35]+J[36]+J[37]-J[38]-J[39]-J[40]+
    J[41]-J[42]+J[43]+J[44]+J[45]+J[46]-J[47]+J[48]-J[49]-J[50]+J[51]-J[52]+J[53]-J[54]-J[55]-J[56]+J[57]-J[58]-J[59]-J[60]+
    J[61]+J[62]-J[63]-J[64]+J[65], +H[0]+H[1]+H[2]-H[3]-H[4]+H[5]+H[6]+H[7]-H[8]-H[9]+H[10]+H[11]+J[0]+J[1]-J[2]-J[3]+
    J[4]+J[5]+J[6]-J[7]-J[8]+J[9]+J[10]+J[11]-J[12]-J[13]+J[14]+J[15]+J[16]-J[17]-J[18]+J[19]+J[20]-J[21]-J[22]+
    J[23]+J[24]+J[25]-J[26]-J[27]+J[28]+J[29]+J[30]-J[31]-J[32]-J[33]+J[34]+J[35]-J[36]-J[37]-J[38]-J[39]-J[40]+
    J[41]+J[42]-J[43]-J[44]+J[45]+J[46]-J[47]-J[48]+J[49]+J[50]+J[51]-J[52]-J[53]+J[54]+J[55]-J[56]-J[57]+
    J[58]+J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]+H[1]+H[2]-H[3]-H[4]+H[5]+H[6]+H[7]-H[8]-H[9]+
    H[10]-H[11]+J[0]+J[1]-J[2]-J[3]+J[4]+J[5]+J[6]-J[7]-J[8]+J[9]-J[10]+J[11]-J[12]-J[13]+J[14]+J[15]+J[16]-J[17]-J[18]+
    J[19]-J[20]-J[21]-J[22]+J[23]+J[24]+J[25]-J[26]-J[27]+J[28]-J[29]+J[30]-J[31]-J[32]-J[33]+J[34]+J[35]-J[36]+
    J[37]-J[38]-J[39]-J[40]+J[41]+J[42]-J[43]+J[44]+J[45]+J[46]-J[47]-J[48]+J[49]-J[50]+J[51]-J[52]-J[53]+
    J[54]-J[55]-J[56]-J[57]+J[58]-J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]+H[1]+H[2]-H[3]-H[4]+H[5]+
    H[6]+H[7]-H[8]-H[9]-H[10]+H[11]+J[0]+J[1]-J[2]-J[3]+J[4]+J[5]+J[6]-J[7]-J[8]-J[9]+J[10]+J[11]-J[12]-J[13]+
    J[14]+J[15]+J[16]-J[17]-J[18]-J[19]+J[20]-J[21]-J[22]+J[23]+J[24]+J[25]-J[26]-J[27]-J[28]+J[29]+J[30]-J[31]-J[32]-J[33]+
    J[34]+J[35]+J[36]-J[37]-J[38]-J[39]-J[40]+J[41]+J[42]+J[43]-J[44]+J[45]+J[46]-J[47]-J[48]-J[49]+J[50]+
    J[51]-J[52]-J[53]-J[54]+J[55]-J[56]-J[57]-J[58]+J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]+H[1]+
    H[2]-H[3]-H[4]+H[5]+H[6]+H[7]-H[8]-H[9]-H[10]-H[11]+J[0]+J[1]-J[2]-J[3]+J[4]+J[5]+J[6]-J[7]-J[8]-J[9]-J[10]+
    J[11]-J[12]-J[13]+J[14]+J[15]+J[16]-J[17]-J[18]-J[19]-J[20]-J[21]-J[22]+J[23]+J[24]+J[25]-J[26]-J[27]-J[28]-J[29]+
    J[30]-J[31]-J[32]-J[33]+J[34]+J[35]+J[36]+J[37]-J[38]-J[39]-J[40]+J[41]+J[42]+J[43]+J[44]+J[45]+J[46]-J[47]-J[48]-J[49]-J[50]+
    J[51]-J[52]-J[53]-J[54]-J[55]-J[56]-J[57]-J[58]-J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]+H[1]+
    H[2]-H[3]-H[4]+H[5]+H[6]-H[7]+H[8]+H[9]+H[10]+H[11]+J[0]+J[1]-J[2]-J[3]+J[4]+J[5]-J[6]+J[7]+J[8]+J[9]+
    J[10]+J[11]-J[12]-J[13]+J[14]+J[15]-J[16]+J[17]+J[18]+J[19]+J[20]-J[21]-J[22]+J[23]+J[24]-J[25]+J[26]+
    J[27]+J[28]+J[29]+J[30]-J[31]-J[32]+J[33]-J[34]-J[35]-J[36]-J[37]-J[38]-J[39]+J[40]-J[41]-J[42]-J[43]-J[44]+
    J[45]-J[46]+J[47]+J[48]+J[49]+J[50]-J[51]+J[52]+J[53]+J[54]+J[55]-J[56]-J[57]-J[58]-J[59]+J[60]+J[61]+
    J[62]+J[63]+J[64]+J[65], +H[0]+H[1]+H[2]-H[3]-H[4]+H[5]+H[6]-H[7]+H[8]+H[9]+H[10]-H[11]+J[0]+J[1]-J[2]-J[3]+
    J[4]+J[5]-J[6]+J[7]+J[8]+J[9]-J[10]+J[11]-J[12]-J[13]+J[14]+J[15]-J[16]+J[17]+J[18]+J[19]-J[20]-J[21]-J[22]+
    J[23]+J[24]-J[25]+J[26]+J[27]+J[28]-J[29]+J[30]-J[31]-J[32]+J[33]-J[34]-J[35]-J[36]+J[37]-J[38]-J[39]+
    J[40]-J[41]-J[42]-J[43]+J[44]+J[45]-J[46]+J[47]+J[48]+J[49]-J[50]-J[51]+J[52]+J[53]+J[54]-J[55]-J[56]-J[57]-J[58]+
    J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]+H[1]+H[2]-H[3]-H[4]+H[5]+H[6]-H[7]+H[8]+H[9]-H[10]+
    H[11]+J[0]+J[1]-J[2]-J[3]+J[4]+J[5]-J[6]+J[7]+J[8]-J[9]+J[10]+J[11]-J[12]-J[13]+J[14]+J[15]-J[16]+J[17]+
    J[18]-J[19]+J[20]-J[21]-J[22]+J[23]+J[24]-J[25]+J[26]+J[27]-J[28]+J[29]+J[30]-J[31]-J[32]+J[33]-J[34]-J[35]+
    J[36]-J[37]-J[38]-J[39]+J[40]-J[41]-J[42]+J[43]-J[44]+J[45]-J[46]+J[47]+J[48]-J[49]+J[50]-J[51]+J[52]+
    J[53]-J[54]+J[55]-J[56]-J[57]+J[58]-J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]+H[1]+H[2]-H[3]-H[4]+
    H[5]+H[6]-H[7]+H[8]+H[9]-H[10]-H[11]+J[0]+J[1]-J[2]-J[3]+J[4]+J[5]-J[6]+J[7]+J[8]-J[9]-J[10]+J[11]-J[12]-J[13]+
    J[14]+J[15]-J[16]+J[17]+J[18]-J[19]-J[20]-J[21]-J[22]+J[23]+J[24]-J[25]+J[26]+J[27]-J[28]-J[29]+J[30]-J[31]-J[32]+
    J[33]-J[34]-J[35]+J[36]+J[37]-J[38]-J[39]+J[40]-J[41]-J[42]+J[43]+J[44]+J[45]-J[46]+J[47]+J[48]-J[49]-J[50]-J[51]+
    J[52]+J[53]-J[54]-J[55]-J[56]-J[57]+J[58]+J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]+H[1]+H[2]-H[3]-H[4]+
    H[5]+H[6]-H[7]+H[8]-H[9]+H[10]+H[11]+J[0]+J[1]-J[2]-J[3]+J[4]+J[5]-J[6]+J[7]-J[8]+J[9]+J[10]+J[11]-J[12]-J[13]+
    J[14]+J[15]-J[16]+J[17]-J[18]+J[19]+J[20]-J[21]-J[22]+J[23]+J[24]-J[25]+J[26]-J[27]+J[28]+J[29]+J[30]-J[31]-J[32]+
    J[33]-J[34]+J[35]-J[36]-J[37]-J[38]-J[39]+J[40]-J[41]+J[42]-J[43]-J[44]+J[45]-J[46]+J[47]-J[48]+J[49]+
    J[50]-J[51]+J[52]-J[53]+J[54]+J[55]-J[56]+J[57]-J[58]-J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]+
    H[1]+H[2]-H[3]-H[4]+H[5]+H[6]-H[7]+H[8]-H[9]+H[10]-H[11]+J[0]+J[1]-J[2]-J[3]+J[4]+J[5]-J[6]+J[7]-J[8]+
    J[9]-J[10]+J[11]-J[12]-J[13]+J[14]+J[15]-J[16]+J[17]-J[18]+J[19]-J[20]-J[21]-J[22]+J[23]+J[24]-J[25]+
    J[26]-J[27]+J[28]-J[29]+J[30]-J[31]-J[32]+J[33]-J[34]+J[35]-J[36]+J[37]-J[38]-J[39]+J[40]-J[41]+J[42]-J[43]+
    J[44]+J[45]-J[46]+J[47]-J[48]+J[49]-J[50]-J[51]+J[52]-J[53]+J[54]-J[55]-J[56]+J[57]-J[58]+J[59]-J[60]+
    J[61]-J[62]-J[63]+J[64]-J[65], +H[0]+H[1]+H[2]-H[3]-H[4]+H[5]+H[6]-H[7]+H[8]-H[9]-H[10]+H[11]+J[0]+J[1]-J[2]-J[3]+
    J[4]+J[5]-J[6]+J[7]-J[8]-J[9]+J[10]+J[11]-J[12]-J[13]+J[14]+J[15]-J[16]+J[17]-J[18]-J[19]+J[20]-J[21]-J[22]+
    J[23]+J[24]-J[25]+J[26]-J[27]-J[28]+J[29]+J[30]-J[31]-J[32]+J[33]-J[34]+J[35]+J[36]-J[37]-J[38]-J[39]+
    J[40]-J[41]+J[42]+J[43]-J[44]+J[45]-J[46]+J[47]-J[48]-J[49]+J[50]-J[51]+J[52]-J[53]-J[54]+J[55]-J[56]+
    J[57]+J[58]-J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]+H[1]+H[2]-H[3]-H[4]+H[5]+H[6]-H[7]+H[8]-H[9]-H[10]-H[11]+
    J[0]+J[1]-J[2]-J[3]+J[4]+J[5]-J[6]+J[7]-J[8]-J[9]-J[10]+J[11]-J[12]-J[13]+J[14]+J[15]-J[16]+J[17]-J[18]-J[19]-J[20]-J[21]-J[22]+
    J[23]+J[24]-J[25]+J[26]-J[27]-J[28]-J[29]+J[30]-J[31]-J[32]+J[33]-J[34]+J[35]+J[36]+J[37]-J[38]-J[39]+
    J[40]-J[41]+J[42]+J[43]+J[44]+J[45]-J[46]+J[47]-J[48]-J[49]-J[50]-J[51]+J[52]-J[53]-J[54]-J[55]-J[56]+
    J[57]+J[58]+J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]+H[1]+H[2]-H[3]-H[4]+H[5]+H[6]-H[7]-H[8]+
    H[9]+H[10]+H[11]+J[0]+J[1]-J[2]-J[3]+J[4]+J[5]-J[6]-J[7]+J[8]+J[9]+J[10]+J[11]-J[12]-J[13]+J[14]+J[15]-J[16]-J[17]+
    J[18]+J[19]+J[20]-J[21]-J[22]+J[23]+J[24]-J[25]-J[26]+J[27]+J[28]+J[29]+J[30]-J[31]-J[32]+J[33]+J[34]-J[35]-J[36]-J[37]-J[38]-J[39]+
    J[40]+J[41]-J[42]-J[43]-J[44]+J[45]-J[46]-J[47]+J[48]+J[49]+J[50]-J[51]-J[52]+J[53]+J[54]+J[55]+J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+
    J[63]+J[64]+J[65], +H[0]+H[1]+H[2]-H[3]-H[4]+H[5]+H[6]-H[7]-H[8]+H[9]+H[10]-H[11]+J[0]+J[1]-J[2]-J[3]+
    J[4]+J[5]-J[6]-J[7]+J[8]+J[9]-J[10]+J[11]-J[12]-J[13]+J[14]+J[15]-J[16]-J[17]+J[18]+J[19]-J[20]-J[21]-J[22]+
    J[23]+J[24]-J[25]-J[26]+J[27]+J[28]-J[29]+J[30]-J[31]-J[32]+J[33]+J[34]-J[35]-J[36]+J[37]-J[38]-J[39]+
    J[40]+J[41]-J[42]-J[43]+J[44]+J[45]-J[46]-J[47]+J[48]+J[49]-J[50]-J[51]-J[52]+J[53]+J[54]-J[55]+J[56]-J[57]-J[58]+
    J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]+H[1]+H[2]-H[3]-H[4]+H[5]+H[6]-H[7]-H[8]+H[9]-H[10]+
    H[11]+J[0]+J[1]-J[2]-J[3]+J[4]+J[5]-J[6]-J[7]+J[8]-J[9]+J[10]+J[11]-J[12]-J[13]+J[14]+J[15]-J[16]-J[17]+
    J[18]-J[19]+J[20]-J[21]-J[22]+J[23]+J[24]-J[25]-J[26]+J[27]-J[28]+J[29]+J[30]-J[31]-J[32]+J[33]+J[34]-J[35]+
    J[36]-J[37]-J[38]-J[39]+J[40]+J[41]-J[42]+J[43]-J[44]+J[45]-J[46]-J[47]+J[48]-J[49]+J[50]-J[51]-J[52]+
    J[53]-J[54]+J[55]+J[56]-J[57]+J[58]-J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]+H[1]+H[2]-H[3]-H[4]+
    H[5]+H[6]-H[7]-H[8]+H[9]-H[10]-H[11]+J[0]+J[1]-J[2]-J[3]+J[4]+J[5]-J[6]-J[7]+J[8]-J[9]-J[10]+J[11]-J[12]-J[13]+
    J[14]+J[15]-J[16]-J[17]+J[18]-J[19]-J[20]-J[21]-J[22]+J[23]+J[24]-J[25]-J[26]+J[27]-J[28]-J[29]+J[30]-J[31]-J[32]+
    J[33]+J[34]-J[35]+J[36]+J[37]-J[38]-J[39]+J[40]+J[41]-J[42]+J[43]+J[44]+J[45]-J[46]-J[47]+J[48]-J[49]-J[50]-J[51]-J[52]+
    J[53]-J[54]-J[55]+J[56]-J[57]+J[58]+J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]+H[1]+H[2]-H[3]-H[4]+
    H[5]+H[6]-H[7]-H[8]-H[9]+H[10]+H[11]+J[0]+J[1]-J[2]-J[3]+J[4]+J[5]-J[6]-J[7]-J[8]+J[9]+J[10]+J[11]-J[12]-J[13]+
    J[14]+J[15]-J[16]-J[17]-J[18]+J[19]+J[20]-J[21]-J[22]+J[23]+J[24]-J[25]-J[26]-J[27]+J[28]+J[29]+J[30]-J[31]-J[32]+
    J[33]+J[34]+J[35]-J[36]-J[37]-J[38]-J[39]+J[40]+J[41]+J[42]-J[43]-J[44]+J[45]-J[46]-J[47]-J[48]+J[49]+
    J[50]-J[51]-J[52]-J[53]+J[54]+J[55]+J[56]+J[57]-J[58]-J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]+
    H[1]+H[2]-H[3]-H[4]+H[5]+H[6]-H[7]-H[8]-H[9]+H[10]-H[11]+J[0]+J[1]-J[2]-J[3]+J[4]+J[5]-J[6]-J[7]-J[8]+
    J[9]-J[10]+J[11]-J[12]-J[13]+J[14]+J[15]-J[16]-J[17]-J[18]+J[19]-J[20]-J[21]-J[22]+J[23]+J[24]-J[25]-J[26]-J[27]+
    J[28]-J[29]+J[30]-J[31]-J[32]+J[33]+J[34]+J[35]-J[36]+J[37]-J[38]-J[39]+J[40]+J[41]+J[42]-J[43]+J[44]+
    J[45]-J[46]-J[47]-J[48]+J[49]-J[50]-J[51]-J[52]-J[53]+J[54]-J[55]+J[56]+J[57]-J[58]+J[59]+J[60]-J[61]+
    J[62]-J[63]+J[64]-J[65], +H[0]+H[1]+H[2]-H[3]-H[4]+H[5]+H[6]-H[7]-H[8]-H[9]-H[10]+H[11]+J[0]+J[1]-J[2]-J[3]+
    J[4]+J[5]-J[6]-J[7]-J[8]-J[9]+J[10]+J[11]-J[12]-J[13]+J[14]+J[15]-J[16]-J[17]-J[18]-J[19]+J[20]-J[21]-J[22]+
    J[23]+J[24]-J[25]-J[26]-J[27]-J[28]+J[29]+J[30]-J[31]-J[32]+J[33]+J[34]+J[35]+J[36]-J[37]-J[38]-J[39]+
    J[40]+J[41]+J[42]+J[43]-J[44]+J[45]-J[46]-J[47]-J[48]-J[49]+J[50]-J[51]-J[52]-J[53]-J[54]+J[55]+J[56]+
    J[57]+J[58]-J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]+H[1]+H[2]-H[3]-H[4]+H[5]+H[6]-H[7]-H[8]-H[9]-H[10]-H[11]+
    J[0]+J[1]-J[2]-J[3]+J[4]+J[5]-J[6]-J[7]-J[8]-J[9]-J[10]+J[11]-J[12]-J[13]+J[14]+J[15]-J[16]-J[17]-J[18]-J[19]-J[20]-J[21]-J[22]+
    J[23]+J[24]-J[25]-J[26]-J[27]-J[28]-J[29]+J[30]-J[31]-J[32]+J[33]+J[34]+J[35]+J[36]+J[37]-J[38]-J[39]+
    J[40]+J[41]+J[42]+J[43]+J[44]+J[45]-J[46]-J[47]-J[48]-J[49]-J[50]-J[51]-J[52]-J[53]-J[54]-J[55]+J[56]+
    J[57]+J[58]+J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]+H[1]+H[2]-H[3]-H[4]+H[5]-H[6]+H[7]+H[8]+
    H[9]+H[10]+H[11]+J[0]+J[1]-J[2]-J[3]+J[4]-J[5]+J[6]+J[7]+J[8]+J[9]+J[10]+J[11]-J[12]-J[13]+J[14]-J[15]+
    J[16]+J[17]+J[18]+J[19]+J[20]-J[21]-J[22]+J[23]-J[24]+J[25]+J[26]+J[27]+J[28]+J[29]+J[30]-J[31]+J[32]-J[33]-J[34]-J[35]-J[36]-J[37]-J[38]+
    J[39]-J[40]-J[41]-J[42]-J[43]-J[44]-J[45]+J[46]+J[47]+J[48]+J[49]+J[50]-J[51]-J[52]-J[53]-J[54]-J[55]+
    J[56]+J[57]+J[58]+J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]+H[1]+H[2]-H[3]-H[4]+H[5]-H[6]+H[7]+
    H[8]+H[9]+H[10]-H[11]+J[0]+J[1]-J[2]-J[3]+J[4]-J[5]+J[6]+J[7]+J[8]+J[9]-J[10]+J[11]-J[12]-J[13]+J[14]-J[15]+
    J[16]+J[17]+J[18]+J[19]-J[20]-J[21]-J[22]+J[23]-J[24]+J[25]+J[26]+J[27]+J[28]-J[29]+J[30]-J[31]+J[32]-J[33]-J[34]-J[35]-J[36]+
    J[37]-J[38]+J[39]-J[40]-J[41]-J[42]-J[43]+J[44]-J[45]+J[46]+J[47]+J[48]+J[49]-J[50]-J[51]-J[52]-J[53]-J[54]+
    J[55]+J[56]+J[57]+J[58]-J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]+H[1]+H[2]-H[3]-H[4]+H[5]-H[6]+
    H[7]+H[8]+H[9]-H[10]+H[11]+J[0]+J[1]-J[2]-J[3]+J[4]-J[5]+J[6]+J[7]+J[8]-J[9]+J[10]+J[11]-J[12]-J[13]+
    J[14]-J[15]+J[16]+J[17]+J[18]-J[19]+J[20]-J[21]-J[22]+J[23]-J[24]+J[25]+J[26]+J[27]-J[28]+J[29]+J[30]-J[31]+
    J[32]-J[33]-J[34]-J[35]+J[36]-J[37]-J[38]+J[39]-J[40]-J[41]-J[42]+J[43]-J[44]-J[45]+J[46]+J[47]+J[48]-J[49]+
    J[50]-J[51]-J[52]-J[53]+J[54]-J[55]+J[56]+J[57]-J[58]+J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]+
    H[1]+H[2]-H[3]-H[4]+H[5]-H[6]+H[7]+H[8]+H[9]-H[10]-H[11]+J[0]+J[1]-J[2]-J[3]+J[4]-J[5]+J[6]+J[7]+J[8]-J[9]-J[10]+
    J[11]-J[12]-J[13]+J[14]-J[15]+J[16]+J[17]+J[18]-J[19]-J[20]-J[21]-J[22]+J[23]-J[24]+J[25]+J[26]+J[27]-J[28]-J[29]+
    J[30]-J[31]+J[32]-J[33]-J[34]-J[35]+J[36]+J[37]-J[38]+J[39]-J[40]-J[41]-J[42]+J[43]+J[44]-J[45]+J[46]+
    J[47]+J[48]-J[49]-J[50]-J[51]-J[52]-J[53]+J[54]+J[55]+J[56]+J[57]-J[58]-J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+
    J[65], +H[0]+H[1]+H[2]-H[3]-H[4]+H[5]-H[6]+H[7]+H[8]-H[9]+H[10]+H[11]+J[0]+J[1]-J[2]-J[3]+J[4]-J[5]+
    J[6]+J[7]-J[8]+J[9]+J[10]+J[11]-J[12]-J[13]+J[14]-J[15]+J[16]+J[17]-J[18]+J[19]+J[20]-J[21]-J[22]+J[23]-J[24]+
    J[25]+J[26]-J[27]+J[28]+J[29]+J[30]-J[31]+J[32]-J[33]-J[34]+J[35]-J[36]-J[37]-J[38]+J[39]-J[40]-J[41]+
    J[42]-J[43]-J[44]-J[45]+J[46]+J[47]-J[48]+J[49]+J[50]-J[51]-J[52]+J[53]-J[54]-J[55]+J[56]-J[57]+J[58]+
    J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]+H[1]+H[2]-H[3]-H[4]+H[5]-H[6]+H[7]+H[8]-H[9]+H[10]-H[11]+
    J[0]+J[1]-J[2]-J[3]+J[4]-J[5]+J[6]+J[7]-J[8]+J[9]-J[10]+J[11]-J[12]-J[13]+J[14]-J[15]+J[16]+J[17]-J[18]+
    J[19]-J[20]-J[21]-J[22]+J[23]-J[24]+J[25]+J[26]-J[27]+J[28]-J[29]+J[30]-J[31]+J[32]-J[33]-J[34]+J[35]-J[36]+
    J[37]-J[38]+J[39]-J[40]-J[41]+J[42]-J[43]+J[44]-J[45]+J[46]+J[47]-J[48]+J[49]-J[50]-J[51]-J[52]+J[53]-J[54]+
    J[55]+J[56]-J[57]+J[58]-J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]+H[1]+H[2]-H[3]-H[4]+H[5]-H[6]+
    H[7]+H[8]-H[9]-H[10]+H[11]+J[0]+J[1]-J[2]-J[3]+J[4]-J[5]+J[6]+J[7]-J[8]-J[9]+J[10]+J[11]-J[12]-J[13]+
    J[14]-J[15]+J[16]+J[17]-J[18]-J[19]+J[20]-J[21]-J[22]+J[23]-J[24]+J[25]+J[26]-J[27]-J[28]+J[29]+J[30]-J[31]+
    J[32]-J[33]-J[34]+J[35]+J[36]-J[37]-J[38]+J[39]-J[40]-J[41]+J[42]+J[43]-J[44]-J[45]+J[46]+J[47]-J[48]-J[49]+
    J[50]-J[51]-J[52]+J[53]+J[54]-J[55]+J[56]-J[57]-J[58]+J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]+
    H[1]+H[2]-H[3]-H[4]+H[5]-H[6]+H[7]+H[8]-H[9]-H[10]-H[11]+J[0]+J[1]-J[2]-J[3]+J[4]-J[5]+J[6]+J[7]-J[8]-J[9]-J[10]+
    J[11]-J[12]-J[13]+J[14]-J[15]+J[16]+J[17]-J[18]-J[19]-J[20]-J[21]-J[22]+J[23]-J[24]+J[25]+J[26]-J[27]-J[28]-J[29]+
    J[30]-J[31]+J[32]-J[33]-J[34]+J[35]+J[36]+J[37]-J[38]+J[39]-J[40]-J[41]+J[42]+J[43]+J[44]-J[45]+J[46]+
    J[47]-J[48]-J[49]-J[50]-J[51]-J[52]+J[53]+J[54]+J[55]+J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+J[63]+
    J[64]+J[65], +H[0]+H[1]+H[2]-H[3]-H[4]+H[5]-H[6]+H[7]-H[8]+H[9]+H[10]+H[11]+J[0]+J[1]-J[2]-J[3]+J[4]-J[5]+
    J[6]-J[7]+J[8]+J[9]+J[10]+J[11]-J[12]-J[13]+J[14]-J[15]+J[16]-J[17]+J[18]+J[19]+J[20]-J[21]-J[22]+J[23]-J[24]+
    J[25]-J[26]+J[27]+J[28]+J[29]+J[30]-J[31]+J[32]-J[33]+J[34]-J[35]-J[36]-J[37]-J[38]+J[39]-J[40]+J[41]-J[42]-J[43]-J[44]-J[45]+
    J[46]-J[47]+J[48]+J[49]+J[50]-J[51]+J[52]-J[53]-J[54]-J[55]-J[56]+J[57]+J[58]+J[59]-J[60]-J[61]-J[62]+
    J[63]+J[64]+J[65], +H[0]+H[1]+H[2]-H[3]-H[4]+H[5]-H[6]+H[7]-H[8]+H[9]+H[10]-H[11]+J[0]+J[1]-J[2]-J[3]+
    J[4]-J[5]+J[6]-J[7]+J[8]+J[9]-J[10]+J[11]-J[12]-J[13]+J[14]-J[15]+J[16]-J[17]+J[18]+J[19]-J[20]-J[21]-J[22]+
    J[23]-J[24]+J[25]-J[26]+J[27]+J[28]-J[29]+J[30]-J[31]+J[32]-J[33]+J[34]-J[35]-J[36]+J[37]-J[38]+J[39]-J[40]+
    J[41]-J[42]-J[43]+J[44]-J[45]+J[46]-J[47]+J[48]+J[49]-J[50]-J[51]+J[52]-J[53]-J[54]+J[55]-J[56]+J[57]+
    J[58]-J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]+H[1]+H[2]-H[3]-H[4]+H[5]-H[6]+H[7]-H[8]+H[9]-H[10]+
    H[11]+J[0]+J[1]-J[2]-J[3]+J[4]-J[5]+J[6]-J[7]+J[8]-J[9]+J[10]+J[11]-J[12]-J[13]+J[14]-J[15]+J[16]-J[17]+
    J[18]-J[19]+J[20]-J[21]-J[22]+J[23]-J[24]+J[25]-J[26]+J[27]-J[28]+J[29]+J[30]-J[31]+J[32]-J[33]+J[34]-J[35]+
    J[36]-J[37]-J[38]+J[39]-J[40]+J[41]-J[42]+J[43]-J[44]-J[45]+J[46]-J[47]+J[48]-J[49]+J[50]-J[51]+J[52]-J[53]+
    J[54]-J[55]-J[56]+J[57]-J[58]+J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]+H[1]+H[2]-H[3]-H[4]+H[5]-H[6]+
    H[7]-H[8]+H[9]-H[10]-H[11]+J[0]+J[1]-J[2]-J[3]+J[4]-J[5]+J[6]-J[7]+J[8]-J[9]-J[10]+J[11]-J[12]-J[13]+
    J[14]-J[15]+J[16]-J[17]+J[18]-J[19]-J[20]-J[21]-J[22]+J[23]-J[24]+J[25]-J[26]+J[27]-J[28]-J[29]+J[30]-J[31]+
    J[32]-J[33]+J[34]-J[35]+J[36]+J[37]-J[38]+J[39]-J[40]+J[41]-J[42]+J[43]+J[44]-J[45]+J[46]-J[47]+J[48]-J[49]-J[50]-J[51]+
    J[52]-J[53]+J[54]+J[55]-J[56]+J[57]-J[58]-J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]+H[1]+H[2]-H[3]-H[4]+
    H[5]-H[6]+H[7]-H[8]-H[9]+H[10]+H[11]+J[0]+J[1]-J[2]-J[3]+J[4]-J[5]+J[6]-J[7]-J[8]+J[9]+J[10]+J[11]-J[12]-J[13]+
    J[14]-J[15]+J[16]-J[17]-J[18]+J[19]+J[20]-J[21]-J[22]+J[23]-J[24]+J[25]-J[26]-J[27]+J[28]+J[29]+J[30]-J[31]+
    J[32]-J[33]+J[34]+J[35]-J[36]-J[37]-J[38]+J[39]-J[40]+J[41]+J[42]-J[43]-J[44]-J[45]+J[46]-J[47]-J[48]+
    J[49]+J[50]-J[51]+J[52]+J[53]-J[54]-J[55]-J[56]-J[57]+J[58]+J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +
    H[0]+H[1]+H[2]-H[3]-H[4]+H[5]-H[6]+H[7]-H[8]-H[9]+H[10]-H[11]+J[0]+J[1]-J[2]-J[3]+J[4]-J[5]+J[6]-J[7]-J[8]+
    J[9]-J[10]+J[11]-J[12]-J[13]+J[14]-J[15]+J[16]-J[17]-J[18]+J[19]-J[20]-J[21]-J[22]+J[23]-J[24]+J[25]-J[26]-J[27]+
    J[28]-J[29]+J[30]-J[31]+J[32]-J[33]+J[34]+J[35]-J[36]+J[37]-J[38]+J[39]-J[40]+J[41]+J[42]-J[43]+J[44]-J[45]+
    J[46]-J[47]-J[48]+J[49]-J[50]-J[51]+J[52]+J[53]-J[54]+J[55]-J[56]-J[57]+J[58]-J[59]+J[60]-J[61]+J[62]-J[63]+
    J[64]-J[65], +H[0]+H[1]+H[2]-H[3]-H[4]+H[5]-H[6]+H[7]-H[8]-H[9]-H[10]+H[11]+J[0]+J[1]-J[2]-J[3]+J[4]-J[5]+
    J[6]-J[7]-J[8]-J[9]+J[10]+J[11]-J[12]-J[13]+J[14]-J[15]+J[16]-J[17]-J[18]-J[19]+J[20]-J[21]-J[22]+J[23]-J[24]+
    J[25]-J[26]-J[27]-J[28]+J[29]+J[30]-J[31]+J[32]-J[33]+J[34]+J[35]+J[36]-J[37]-J[38]+J[39]-J[40]+J[41]+
    J[42]+J[43]-J[44]-J[45]+J[46]-J[47]-J[48]-J[49]+J[50]-J[51]+J[52]+J[53]+J[54]-J[55]-J[56]-J[57]-J[58]+
    J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]+H[1]+H[2]-H[3]-H[4]+H[5]-H[6]+H[7]-H[8]-H[9]-H[10]-H[11]+
    J[0]+J[1]-J[2]-J[3]+J[4]-J[5]+J[6]-J[7]-J[8]-J[9]-J[10]+J[11]-J[12]-J[13]+J[14]-J[15]+J[16]-J[17]-J[18]-J[19]-J[20]-J[21]-J[22]+
    J[23]-J[24]+J[25]-J[26]-J[27]-J[28]-J[29]+J[30]-J[31]+J[32]-J[33]+J[34]+J[35]+J[36]+J[37]-J[38]+J[39]-J[40]+
    J[41]+J[42]+J[43]+J[44]-J[45]+J[46]-J[47]-J[48]-J[49]-J[50]-J[51]+J[52]+J[53]+J[54]+J[55]-J[56]-J[57]-J[58]-J[59]+
    J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]+H[1]+H[2]-H[3]-H[4]+H[5]-H[6]-H[7]+H[8]+H[9]+H[10]+H[11]+
    J[0]+J[1]-J[2]-J[3]+J[4]-J[5]-J[6]+J[7]+J[8]+J[9]+J[10]+J[11]-J[12]-J[13]+J[14]-J[15]-J[16]+J[17]+J[18]+
    J[19]+J[20]-J[21]-J[22]+J[23]-J[24]-J[25]+J[26]+J[27]+J[28]+J[29]+J[30]-J[31]+J[32]+J[33]-J[34]-J[35]-J[36]-J[37]-J[38]+
    J[39]+J[40]-J[41]-J[42]-J[43]-J[44]-J[45]-J[46]+J[47]+J[48]+J[49]+J[50]+J[51]-J[52]-J[53]-J[54]-J[55]-J[56]-J[57]-J[58]-J[59]+
    J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]+H[1]+H[2]-H[3]-H[4]+H[5]-H[6]-H[7]+H[8]+H[9]+H[10]-H[11]+
    J[0]+J[1]-J[2]-J[3]+J[4]-J[5]-J[6]+J[7]+J[8]+J[9]-J[10]+J[11]-J[12]-J[13]+J[14]-J[15]-J[16]+J[17]+J[18]+
    J[19]-J[20]-J[21]-J[22]+J[23]-J[24]-J[25]+J[26]+J[27]+J[28]-J[29]+J[30]-J[31]+J[32]+J[33]-J[34]-J[35]-J[36]+
    J[37]-J[38]+J[39]+J[40]-J[41]-J[42]-J[43]+J[44]-J[45]-J[46]+J[47]+J[48]+J[49]-J[50]+J[51]-J[52]-J[53]-J[54]+
    J[55]-J[56]-J[57]-J[58]+J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]+H[1]+H[2]-H[3]-H[4]+H[5]-H[6]-H[7]+
    H[8]+H[9]-H[10]+H[11]+J[0]+J[1]-J[2]-J[3]+J[4]-J[5]-J[6]+J[7]+J[8]-J[9]+J[10]+J[11]-J[12]-J[13]+J[14]-J[15]-J[16]+
    J[17]+J[18]-J[19]+J[20]-J[21]-J[22]+J[23]-J[24]-J[25]+J[26]+J[27]-J[28]+J[29]+J[30]-J[31]+J[32]+J[33]-J[34]-J[35]+
    J[36]-J[37]-J[38]+J[39]+J[40]-J[41]-J[42]+J[43]-J[44]-J[45]-J[46]+J[47]+J[48]-J[49]+J[50]+J[51]-J[52]-J[53]+
    J[54]-J[55]-J[56]-J[57]+J[58]-J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]+H[1]+H[2]-H[3]-H[4]+H[5]-H[6]-H[7]+
    H[8]+H[9]-H[10]-H[11]+J[0]+J[1]-J[2]-J[3]+J[4]-J[5]-J[6]+J[7]+J[8]-J[9]-J[10]+J[11]-J[12]-J[13]+J[14]-J[15]-J[16]+
    J[17]+J[18]-J[19]-J[20]-J[21]-J[22]+J[23]-J[24]-J[25]+J[26]+J[27]-J[28]-J[29]+J[30]-J[31]+J[32]+J[33]-J[34]-J[35]+
    J[36]+J[37]-J[38]+J[39]+J[40]-J[41]-J[42]+J[43]+J[44]-J[45]-J[46]+J[47]+J[48]-J[49]-J[50]+J[51]-J[52]-J[53]+
    J[54]+J[55]-J[56]-J[57]+J[58]+J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]+H[1]+H[2]-H[3]-H[4]+H[5]-H[6]-H[7]+
    H[8]-H[9]+H[10]+H[11]+J[0]+J[1]-J[2]-J[3]+J[4]-J[5]-J[6]+J[7]-J[8]+J[9]+J[10]+J[11]-J[12]-J[13]+J[14]-J[15]-J[16]+
    J[17]-J[18]+J[19]+J[20]-J[21]-J[22]+J[23]-J[24]-J[25]+J[26]-J[27]+J[28]+J[29]+J[30]-J[31]+J[32]+J[33]-J[34]+
    J[35]-J[36]-J[37]-J[38]+J[39]+J[40]-J[41]+J[42]-J[43]-J[44]-J[45]-J[46]+J[47]-J[48]+J[49]+J[50]+J[51]-J[52]+
    J[53]-J[54]-J[55]-J[56]+J[57]-J[58]-J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]+H[1]+H[2]-H[3]-H[4]+
    H[5]-H[6]-H[7]+H[8]-H[9]+H[10]-H[11]+J[0]+J[1]-J[2]-J[3]+J[4]-J[5]-J[6]+J[7]-J[8]+J[9]-J[10]+J[11]-J[12]-J[13]+
    J[14]-J[15]-J[16]+J[17]-J[18]+J[19]-J[20]-J[21]-J[22]+J[23]-J[24]-J[25]+J[26]-J[27]+J[28]-J[29]+J[30]-J[31]+
    J[32]+J[33]-J[34]+J[35]-J[36]+J[37]-J[38]+J[39]+J[40]-J[41]+J[42]-J[43]+J[44]-J[45]-J[46]+J[47]-J[48]+
    J[49]-J[50]+J[51]-J[52]+J[53]-J[54]+J[55]-J[56]+J[57]-J[58]+J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +
    H[0]+H[1]+H[2]-H[3]-H[4]+H[5]-H[6]-H[7]+H[8]-H[9]-H[10]+H[11]+J[0]+J[1]-J[2]-J[3]+J[4]-J[5]-J[6]+J[7]-J[8]-J[9]+
    J[10]+J[11]-J[12]-J[13]+J[14]-J[15]-J[16]+J[17]-J[18]-J[19]+J[20]-J[21]-J[22]+J[23]-J[24]-J[25]+J[26]-J[27]-J[28]+
    J[29]+J[30]-J[31]+J[32]+J[33]-J[34]+J[35]+J[36]-J[37]-J[38]+J[39]+J[40]-J[41]+J[42]+J[43]-J[44]-J[45]-J[46]+
    J[47]-J[48]-J[49]+J[50]+J[51]-J[52]+J[53]+J[54]-J[55]-J[56]+J[57]+J[58]-J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +
    H[0]+H[1]+H[2]-H[3]-H[4]+H[5]-H[6]-H[7]+H[8]-H[9]-H[10]-H[11]+J[0]+J[1]-J[2]-J[3]+J[4]-J[5]-J[6]+J[7]-J[8]-J[9]-J[10]+
    J[11]-J[12]-J[13]+J[14]-J[15]-J[16]+J[17]-J[18]-J[19]-J[20]-J[21]-J[22]+J[23]-J[24]-J[25]+J[26]-J[27]-J[28]-J[29]+
    J[30]-J[31]+J[32]+J[33]-J[34]+J[35]+J[36]+J[37]-J[38]+J[39]+J[40]-J[41]+J[42]+J[43]+J[44]-J[45]-J[46]+
    J[47]-J[48]-J[49]-J[50]+J[51]-J[52]+J[53]+J[54]+J[55]-J[56]+J[57]+J[58]+J[59]-J[60]-J[61]-J[62]+J[63]+
    J[64]+J[65], +H[0]+H[1]+H[2]-H[3]-H[4]+H[5]-H[6]-H[7]-H[8]+H[9]+H[10]+H[11]+J[0]+J[1]-J[2]-J[3]+J[4]-J[5]-J[6]-J[7]+
    J[8]+J[9]+J[10]+J[11]-J[12]-J[13]+J[14]-J[15]-J[16]-J[17]+J[18]+J[19]+J[20]-J[21]-J[22]+J[23]-J[24]-J[25]-J[26]+
    J[27]+J[28]+J[29]+J[30]-J[31]+J[32]+J[33]+J[34]-J[35]-J[36]-J[37]-J[38]+J[39]+J[40]+J[41]-J[42]-J[43]-J[44]-J[45]-J[46]-J[47]+
    J[48]+J[49]+J[50]+J[51]+J[52]-J[53]-J[54]-J[55]+J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+
    J[65], +H[0]+H[1]+H[2]-H[3]-H[4]+H[5]-H[6]-H[7]-H[8]+H[9]+H[10]-H[11]+J[0]+J[1]-J[2]-J[3]+J[4]-J[5]-J[6]-J[7]+
    J[8]+J[9]-J[10]+J[11]-J[12]-J[13]+J[14]-J[15]-J[16]-J[17]+J[18]+J[19]-J[20]-J[21]-J[22]+J[23]-J[24]-J[25]-J[26]+
    J[27]+J[28]-J[29]+J[30]-J[31]+J[32]+J[33]+J[34]-J[35]-J[36]+J[37]-J[38]+J[39]+J[40]+J[41]-J[42]-J[43]+
    J[44]-J[45]-J[46]-J[47]+J[48]+J[49]-J[50]+J[51]+J[52]-J[53]-J[54]+J[55]+J[56]-J[57]-J[58]+J[59]-J[60]-J[61]+
    J[62]+J[63]-J[64]-J[65], +H[0]+H[1]+H[2]-H[3]-H[4]+H[5]-H[6]-H[7]-H[8]+H[9]-H[10]+H[11]+J[0]+J[1]-J[2]-J[3]+
    J[4]-J[5]-J[6]-J[7]+J[8]-J[9]+J[10]+J[11]-J[12]-J[13]+J[14]-J[15]-J[16]-J[17]+J[18]-J[19]+J[20]-J[21]-J[22]+
    J[23]-J[24]-J[25]-J[26]+J[27]-J[28]+J[29]+J[30]-J[31]+J[32]+J[33]+J[34]-J[35]+J[36]-J[37]-J[38]+J[39]+
    J[40]+J[41]-J[42]+J[43]-J[44]-J[45]-J[46]-J[47]+J[48]-J[49]+J[50]+J[51]+J[52]-J[53]+J[54]-J[55]+J[56]-J[57]+
    J[58]-J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]+H[1]+H[2]-H[3]-H[4]+H[5]-H[6]-H[7]-H[8]+H[9]-H[10]-H[11]+
    J[0]+J[1]-J[2]-J[3]+J[4]-J[5]-J[6]-J[7]+J[8]-J[9]-J[10]+J[11]-J[12]-J[13]+J[14]-J[15]-J[16]-J[17]+J[18]-J[19]-J[20]-J[21]-J[22]+
    J[23]-J[24]-J[25]-J[26]+J[27]-J[28]-J[29]+J[30]-J[31]+J[32]+J[33]+J[34]-J[35]+J[36]+J[37]-J[38]+J[39]+
    J[40]+J[41]-J[42]+J[43]+J[44]-J[45]-J[46]-J[47]+J[48]-J[49]-J[50]+J[51]+J[52]-J[53]+J[54]+J[55]+J[56]-J[57]+
    J[58]+J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]+H[1]+H[2]-H[3]-H[4]+H[5]-H[6]-H[7]-H[8]-H[9]+
    H[10]+H[11]+J[0]+J[1]-J[2]-J[3]+J[4]-J[5]-J[6]-J[7]-J[8]+J[9]+J[10]+J[11]-J[12]-J[13]+J[14]-J[15]-J[16]-J[17]-J[18]+
    J[19]+J[20]-J[21]-J[22]+J[23]-J[24]-J[25]-J[26]-J[27]+J[28]+J[29]+J[30]-J[31]+J[32]+J[33]+J[34]+J[35]-J[36]-J[37]-J[38]+
    J[39]+J[40]+J[41]+J[42]-J[43]-J[44]-J[45]-J[46]-J[47]-J[48]+J[49]+J[50]+J[51]+J[52]+J[53]-J[54]-J[55]+
    J[56]+J[57]-J[58]-J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]+H[1]+H[2]-H[3]-H[4]+H[5]-H[6]-H[7]-H[8]-H[9]+
    H[10]-H[11]+J[0]+J[1]-J[2]-J[3]+J[4]-J[5]-J[6]-J[7]-J[8]+J[9]-J[10]+J[11]-J[12]-J[13]+J[14]-J[15]-J[16]-J[17]-J[18]+
    J[19]-J[20]-J[21]-J[22]+J[23]-J[24]-J[25]-J[26]-J[27]+J[28]-J[29]+J[30]-J[31]+J[32]+J[33]+J[34]+J[35]-J[36]+
    J[37]-J[38]+J[39]+J[40]+J[41]+J[42]-J[43]+J[44]-J[45]-J[46]-J[47]-J[48]+J[49]-J[50]+J[51]+J[52]+J[53]-J[54]+
    J[55]+J[56]+J[57]-J[58]+J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]+H[1]+H[2]-H[3]-H[4]+H[5]-H[6]-H[7]-H[8]-H[9]-H[10]+
    H[11]+J[0]+J[1]-J[2]-J[3]+J[4]-J[5]-J[6]-J[7]-J[8]-J[9]+J[10]+J[11]-J[12]-J[13]+J[14]-J[15]-J[16]-J[17]-J[18]-J[19]+
    J[20]-J[21]-J[22]+J[23]-J[24]-J[25]-J[26]-J[27]-J[28]+J[29]+J[30]-J[31]+J[32]+J[33]+J[34]+J[35]+J[36]-J[37]-J[38]+
    J[39]+J[40]+J[41]+J[42]+J[43]-J[44]-J[45]-J[46]-J[47]-J[48]-J[49]+J[50]+J[51]+J[52]+J[53]+J[54]-J[55]+
    J[56]+J[57]+J[58]-J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]+H[1]+H[2]-H[3]-H[4]+H[5]-H[6]-H[7]-H[8]-H[9]-H[10]-H[11]+
    J[0]+J[1]-J[2]-J[3]+J[4]-J[5]-J[6]-J[7]-J[8]-J[9]-J[10]+J[11]-J[12]-J[13]+J[14]-J[15]-J[16]-J[17]-J[18]-J[19]-J[20]-J[21]-J[22]+
    J[23]-J[24]-J[25]-J[26]-J[27]-J[28]-J[29]+J[30]-J[31]+J[32]+J[33]+J[34]+J[35]+J[36]+J[37]-J[38]+J[39]+
    J[40]+J[41]+J[42]+J[43]+J[44]-J[45]-J[46]-J[47]-J[48]-J[49]-J[50]+J[51]+J[52]+J[53]+J[54]+J[55]+J[56]+
    J[57]+J[58]+J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]+H[1]+H[2]-H[3]-H[4]-H[5]+H[6]+H[7]+H[8]+
    H[9]+H[10]+H[11]+J[0]+J[1]-J[2]-J[3]-J[4]+J[5]+J[6]+J[7]+J[8]+J[9]+J[10]+J[11]-J[12]-J[13]-J[14]+J[15]+
    J[16]+J[17]+J[18]+J[19]+J[20]-J[21]-J[22]-J[23]+J[24]+J[25]+J[26]+J[27]+J[28]+J[29]+J[30]+J[31]-J[32]-J[33]-J[34]-J[35]-J[36]-J[37]+
    J[38]-J[39]-J[40]-J[41]-J[42]-J[43]-J[44]-J[45]-J[46]-J[47]-J[48]-J[49]-J[50]+J[51]+J[52]+J[53]+J[54]+
    J[55]+J[56]+J[57]+J[58]+J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]+H[1]+H[2]-H[3]-H[4]-H[5]+H[6]+
    H[7]+H[8]+H[9]+H[10]-H[11]+J[0]+J[1]-J[2]-J[3]-J[4]+J[5]+J[6]+J[7]+J[8]+J[9]-J[10]+J[11]-J[12]-J[13]-J[14]+
    J[15]+J[16]+J[17]+J[18]+J[19]-J[20]-J[21]-J[22]-J[23]+J[24]+J[25]+J[26]+J[27]+J[28]-J[29]+J[30]+J[31]-J[32]-J[33]-J[34]-J[35]-J[36]+
    J[37]+J[38]-J[39]-J[40]-J[41]-J[42]-J[43]+J[44]-J[45]-J[46]-J[47]-J[48]-J[49]+J[50]+J[51]+J[52]+J[53]+
    J[54]-J[55]+J[56]+J[57]+J[58]-J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]+H[1]+H[2]-H[3]-H[4]-H[5]+
    H[6]+H[7]+H[8]+H[9]-H[10]+H[11]+J[0]+J[1]-J[2]-J[3]-J[4]+J[5]+J[6]+J[7]+J[8]-J[9]+J[10]+J[11]-J[12]-J[13]-J[14]+
    J[15]+J[16]+J[17]+J[18]-J[19]+J[20]-J[21]-J[22]-J[23]+J[24]+J[25]+J[26]+J[27]-J[28]+J[29]+J[30]+J[31]-J[32]-J[33]-J[34]-J[35]+
    J[36]-J[37]+J[38]-J[39]-J[40]-J[41]-J[42]+J[43]-J[44]-J[45]-J[46]-J[47]-J[48]+J[49]-J[50]+J[51]+J[52]+
    J[53]-J[54]+J[55]+J[56]+J[57]-J[58]+J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]+H[1]+H[2]-H[3]-H[4]-H[5]+
    H[6]+H[7]+H[8]+H[9]-H[10]-H[11]+J[0]+J[1]-J[2]-J[3]-J[4]+J[5]+J[6]+J[7]+J[8]-J[9]-J[10]+J[11]-J[12]-J[13]-J[14]+
    J[15]+J[16]+J[17]+J[18]-J[19]-J[20]-J[21]-J[22]-J[23]+J[24]+J[25]+J[26]+J[27]-J[28]-J[29]+J[30]+J[31]-J[32]-J[33]-J[34]-J[35]+
    J[36]+J[37]+J[38]-J[39]-J[40]-J[41]-J[42]+J[43]+J[44]-J[45]-J[46]-J[47]-J[48]+J[49]+J[50]+J[51]+J[52]+
    J[53]-J[54]-J[55]+J[56]+J[57]-J[58]-J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]+H[1]+H[2]-H[3]-H[4]-H[5]+
    H[6]+H[7]+H[8]-H[9]+H[10]+H[11]+J[0]+J[1]-J[2]-J[3]-J[4]+J[5]+J[6]+J[7]-J[8]+J[9]+J[10]+J[11]-J[12]-J[13]-J[14]+
    J[15]+J[16]+J[17]-J[18]+J[19]+J[20]-J[21]-J[22]-J[23]+J[24]+J[25]+J[26]-J[27]+J[28]+J[29]+J[30]+J[31]-J[32]-J[33]-J[34]+
    J[35]-J[36]-J[37]+J[38]-J[39]-J[40]-J[41]+J[42]-J[43]-J[44]-J[45]-J[46]-J[47]+J[48]-J[49]-J[50]+J[51]+
    J[52]-J[53]+J[54]+J[55]+J[56]-J[57]+J[58]+J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]+H[1]+H[2]-H[3]-H[4]-H[5]+
    H[6]+H[7]+H[8]-H[9]+H[10]-H[11]+J[0]+J[1]-J[2]-J[3]-J[4]+J[5]+J[6]+J[7]-J[8]+J[9]-J[10]+J[11]-J[12]-J[13]-J[14]+
    J[15]+J[16]+J[17]-J[18]+J[19]-J[20]-J[21]-J[22]-J[23]+J[24]+J[25]+J[26]-J[27]+J[28]-J[29]+J[30]+J[31]-J[32]-J[33]-J[34]+
    J[35]-J[36]+J[37]+J[38]-J[39]-J[40]-J[41]+J[42]-J[43]+J[44]-J[45]-J[46]-J[47]+J[48]-J[49]+J[50]+J[51]+
    J[52]-J[53]+J[54]-J[55]+J[56]-J[57]+J[58]-J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]+H[1]+H[2]-H[3]-H[4]-H[5]+
    H[6]+H[7]+H[8]-H[9]-H[10]+H[11]+J[0]+J[1]-J[2]-J[3]-J[4]+J[5]+J[6]+J[7]-J[8]-J[9]+J[10]+J[11]-J[12]-J[13]-J[14]+
    J[15]+J[16]+J[17]-J[18]-J[19]+J[20]-J[21]-J[22]-J[23]+J[24]+J[25]+J[26]-J[27]-J[28]+J[29]+J[30]+J[31]-J[32]-J[33]-J[34]+
    J[35]+J[36]-J[37]+J[38]-J[39]-J[40]-J[41]+J[42]+J[43]-J[44]-J[45]-J[46]-J[47]+J[48]+J[49]-J[50]+J[51]+
    J[52]-J[53]-J[54]+J[55]+J[56]-J[57]-J[58]+J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]+H[1]+H[2]-H[3]-H[4]-H[5]+
    H[6]+H[7]+H[8]-H[9]-H[10]-H[11]+J[0]+J[1]-J[2]-J[3]-J[4]+J[5]+J[6]+J[7]-J[8]-J[9]-J[10]+J[11]-J[12]-J[13]-J[14]+
    J[15]+J[16]+J[17]-J[18]-J[19]-J[20]-J[21]-J[22]-J[23]+J[24]+J[25]+J[26]-J[27]-J[28]-J[29]+J[30]+J[31]-J[32]-J[33]-J[34]+
    J[35]+J[36]+J[37]+J[38]-J[39]-J[40]-J[41]+J[42]+J[43]+J[44]-J[45]-J[46]-J[47]+J[48]+J[49]+J[50]+J[51]+
    J[52]-J[53]-J[54]-J[55]+J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]+H[1]+H[2]-H[3]-H[4]-H[5]+
    H[6]+H[7]-H[8]+H[9]+H[10]+H[11]+J[0]+J[1]-J[2]-J[3]-J[4]+J[5]+J[6]-J[7]+J[8]+J[9]+J[10]+J[11]-J[12]-J[13]-J[14]+
    J[15]+J[16]-J[17]+J[18]+J[19]+J[20]-J[21]-J[22]-J[23]+J[24]+J[25]-J[26]+J[27]+J[28]+J[29]+J[30]+J[31]-J[32]-J[33]+
    J[34]-J[35]-J[36]-J[37]+J[38]-J[39]-J[40]+J[41]-J[42]-J[43]-J[44]-J[45]-J[46]+J[47]-J[48]-J[49]-J[50]+
    J[51]-J[52]+J[53]+J[54]+J[55]-J[56]+J[57]+J[58]+J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]+H[1]+
    H[2]-H[3]-H[4]-H[5]+H[6]+H[7]-H[8]+H[9]+H[10]-H[11]+J[0]+J[1]-J[2]-J[3]-J[4]+J[5]+J[6]-J[7]+J[8]+J[9]-J[10]+
    J[11]-J[12]-J[13]-J[14]+J[15]+J[16]-J[17]+J[18]+J[19]-J[20]-J[21]-J[22]-J[23]+J[24]+J[25]-J[26]+J[27]+
    J[28]-J[29]+J[30]+J[31]-J[32]-J[33]+J[34]-J[35]-J[36]+J[37]+J[38]-J[39]-J[40]+J[41]-J[42]-J[43]+J[44]-J[45]-J[46]+
    J[47]-J[48]-J[49]+J[50]+J[51]-J[52]+J[53]+J[54]-J[55]-J[56]+J[57]+J[58]-J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +
    H[0]+H[1]+H[2]-H[3]-H[4]-H[5]+H[6]+H[7]-H[8]+H[9]-H[10]+H[11]+J[0]+J[1]-J[2]-J[3]-J[4]+J[5]+J[6]-J[7]+
    J[8]-J[9]+J[10]+J[11]-J[12]-J[13]-J[14]+J[15]+J[16]-J[17]+J[18]-J[19]+J[20]-J[21]-J[22]-J[23]+J[24]+
    J[25]-J[26]+J[27]-J[28]+J[29]+J[30]+J[31]-J[32]-J[33]+J[34]-J[35]+J[36]-J[37]+J[38]-J[39]-J[40]+J[41]-J[42]+
    J[43]-J[44]-J[45]-J[46]+J[47]-J[48]+J[49]-J[50]+J[51]-J[52]+J[53]-J[54]+J[55]-J[56]+J[57]-J[58]+J[59]-J[60]+
    J[61]-J[62]-J[63]+J[64]-J[65], +H[0]+H[1]+H[2]-H[3]-H[4]-H[5]+H[6]+H[7]-H[8]+H[9]-H[10]-H[11]+J[0]+J[1]-J[2]-J[3]-J[4]+
    J[5]+J[6]-J[7]+J[8]-J[9]-J[10]+J[11]-J[12]-J[13]-J[14]+J[15]+J[16]-J[17]+J[18]-J[19]-J[20]-J[21]-J[22]-J[23]+
    J[24]+J[25]-J[26]+J[27]-J[28]-J[29]+J[30]+J[31]-J[32]-J[33]+J[34]-J[35]+J[36]+J[37]+J[38]-J[39]-J[40]+
    J[41]-J[42]+J[43]+J[44]-J[45]-J[46]+J[47]-J[48]+J[49]+J[50]+J[51]-J[52]+J[53]-J[54]-J[55]-J[56]+J[57]-J[58]-J[59]-J[60]+
    J[61]+J[62]-J[63]-J[64]+J[65], +H[0]+H[1]+H[2]-H[3]-H[4]-H[5]+H[6]+H[7]-H[8]-H[9]+H[10]+H[11]+J[0]+J[1]-J[2]-J[3]-J[4]+
    J[5]+J[6]-J[7]-J[8]+J[9]+J[10]+J[11]-J[12]-J[13]-J[14]+J[15]+J[16]-J[17]-J[18]+J[19]+J[20]-J[21]-J[22]-J[23]+
    J[24]+J[25]-J[26]-J[27]+J[28]+J[29]+J[30]+J[31]-J[32]-J[33]+J[34]+J[35]-J[36]-J[37]+J[38]-J[39]-J[40]+
    J[41]+J[42]-J[43]-J[44]-J[45]-J[46]+J[47]+J[48]-J[49]-J[50]+J[51]-J[52]-J[53]+J[54]+J[55]-J[56]-J[57]+
    J[58]+J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]+H[1]+H[2]-H[3]-H[4]-H[5]+H[6]+H[7]-H[8]-H[9]+
    H[10]-H[11]+J[0]+J[1]-J[2]-J[3]-J[4]+J[5]+J[6]-J[7]-J[8]+J[9]-J[10]+J[11]-J[12]-J[13]-J[14]+J[15]+J[16]-J[17]-J[18]+
    J[19]-J[20]-J[21]-J[22]-J[23]+J[24]+J[25]-J[26]-J[27]+J[28]-J[29]+J[30]+J[31]-J[32]-J[33]+J[34]+J[35]-J[36]+
    J[37]+J[38]-J[39]-J[40]+J[41]+J[42]-J[43]+J[44]-J[45]-J[46]+J[47]+J[48]-J[49]+J[50]+J[51]-J[52]-J[53]+
    J[54]-J[55]-J[56]-J[57]+J[58]-J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]+H[1]+H[2]-H[3]-H[4]-H[5]+
    H[6]+H[7]-H[8]-H[9]-H[10]+H[11]+J[0]+J[1]-J[2]-J[3]-J[4]+J[5]+J[6]-J[7]-J[8]-J[9]+J[10]+J[11]-J[12]-J[13]-J[14]+
    J[15]+J[16]-J[17]-J[18]-J[19]+J[20]-J[21]-J[22]-J[23]+J[24]+J[25]-J[26]-J[27]-J[28]+J[29]+J[30]+J[31]-J[32]-J[33]+
    J[34]+J[35]+J[36]-J[37]+J[38]-J[39]-J[40]+J[41]+J[42]+J[43]-J[44]-J[45]-J[46]+J[47]+J[48]+J[49]-J[50]+
    J[51]-J[52]-J[53]-J[54]+J[55]-J[56]-J[57]-J[58]+J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]+H[1]+
    H[2]-H[3]-H[4]-H[5]+H[6]+H[7]-H[8]-H[9]-H[10]-H[11]+J[0]+J[1]-J[2]-J[3]-J[4]+J[5]+J[6]-J[7]-J[8]-J[9]-J[10]+
    J[11]-J[12]-J[13]-J[14]+J[15]+J[16]-J[17]-J[18]-J[19]-J[20]-J[21]-J[22]-J[23]+J[24]+J[25]-J[26]-J[27]-J[28]-J[29]+
    J[30]+J[31]-J[32]-J[33]+J[34]+J[35]+J[36]+J[37]+J[38]-J[39]-J[40]+J[41]+J[42]+J[43]+J[44]-J[45]-J[46]+
    J[47]+J[48]+J[49]+J[50]+J[51]-J[52]-J[53]-J[54]-J[55]-J[56]-J[57]-J[58]-J[59]+J[60]+J[61]+J[62]+J[63]+
    J[64]+J[65], +H[0]+H[1]+H[2]-H[3]-H[4]-H[5]+H[6]-H[7]+H[8]+H[9]+H[10]+H[11]+J[0]+J[1]-J[2]-J[3]-J[4]+
    J[5]-J[6]+J[7]+J[8]+J[9]+J[10]+J[11]-J[12]-J[13]-J[14]+J[15]-J[16]+J[17]+J[18]+J[19]+J[20]-J[21]-J[22]-J[23]+
    J[24]-J[25]+J[26]+J[27]+J[28]+J[29]+J[30]+J[31]-J[32]+J[33]-J[34]-J[35]-J[36]-J[37]+J[38]-J[39]+J[40]-J[41]-J[42]-J[43]-J[44]-J[45]+
    J[46]-J[47]-J[48]-J[49]-J[50]-J[51]+J[52]+J[53]+J[54]+J[55]-J[56]-J[57]-J[58]-J[59]+J[60]+J[61]+J[62]+
    J[63]+J[64]+J[65], +H[0]+H[1]+H[2]-H[3]-H[4]-H[5]+H[6]-H[7]+H[8]+H[9]+H[10]-H[11]+J[0]+J[1]-J[2]-J[3]-J[4]+
    J[5]-J[6]+J[7]+J[8]+J[9]-J[10]+J[11]-J[12]-J[13]-J[14]+J[15]-J[16]+J[17]+J[18]+J[19]-J[20]-J[21]-J[22]-J[23]+
    J[24]-J[25]+J[26]+J[27]+J[28]-J[29]+J[30]+J[31]-J[32]+J[33]-J[34]-J[35]-J[36]+J[37]+J[38]-J[39]+J[40]-J[41]-J[42]-J[43]+
    J[44]-J[45]+J[46]-J[47]-J[48]-J[49]+J[50]-J[51]+J[52]+J[53]+J[54]-J[55]-J[56]-J[57]-J[58]+J[59]+J[60]+
    J[61]-J[62]+J[63]-J[64]-J[65], +H[0]+H[1]+H[2]-H[3]-H[4]-H[5]+H[6]-H[7]+H[8]+H[9]-H[10]+H[11]+J[0]+J[1]-J[2]-J[3]-J[4]+
    J[5]-J[6]+J[7]+J[8]-J[9]+J[10]+J[11]-J[12]-J[13]-J[14]+J[15]-J[16]+J[17]+J[18]-J[19]+J[20]-J[21]-J[22]-J[23]+
    J[24]-J[25]+J[26]+J[27]-J[28]+J[29]+J[30]+J[31]-J[32]+J[33]-J[34]-J[35]+J[36]-J[37]+J[38]-J[39]+J[40]-J[41]-J[42]+
    J[43]-J[44]-J[45]+J[46]-J[47]-J[48]+J[49]-J[50]-J[51]+J[52]+J[53]-J[54]+J[55]-J[56]-J[57]+J[58]-J[59]+
    J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]+H[1]+H[2]-H[3]-H[4]-H[5]+H[6]-H[7]+H[8]+H[9]-H[10]-H[11]+
    J[0]+J[1]-J[2]-J[3]-J[4]+J[5]-J[6]+J[7]+J[8]-J[9]-J[10]+J[11]-J[12]-J[13]-J[14]+J[15]-J[16]+J[17]+J[18]-J[19]-J[20]-J[21]-J[22]-J[23]+
    J[24]-J[25]+J[26]+J[27]-J[28]-J[29]+J[30]+J[31]-J[32]+J[33]-J[34]-J[35]+J[36]+J[37]+J[38]-J[39]+J[40]-J[41]-J[42]+
    J[43]+J[44]-J[45]+J[46]-J[47]-J[48]+J[49]+J[50]-J[51]+J[52]+J[53]-J[54]-J[55]-J[56]-J[57]+J[58]+J[59]+
    J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]+H[1]+H[2]-H[3]-H[4]-H[5]+H[6]-H[7]+H[8]-H[9]+H[10]+H[11]+
    J[0]+J[1]-J[2]-J[3]-J[4]+J[5]-J[6]+J[7]-J[8]+J[9]+J[10]+J[11]-J[12]-J[13]-J[14]+J[15]-J[16]+J[17]-J[18]+
    J[19]+J[20]-J[21]-J[22]-J[23]+J[24]-J[25]+J[26]-J[27]+J[28]+J[29]+J[30]+J[31]-J[32]+J[33]-J[34]+J[35]-J[36]-J[37]+
    J[38]-J[39]+J[40]-J[41]+J[42]-J[43]-J[44]-J[45]+J[46]-J[47]+J[48]-J[49]-J[50]-J[51]+J[52]-J[53]+J[54]+
    J[55]-J[56]+J[57]-J[58]-J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]+H[1]+H[2]-H[3]-H[4]-H[5]+H[6]-H[7]+
    H[8]-H[9]+H[10]-H[11]+J[0]+J[1]-J[2]-J[3]-J[4]+J[5]-J[6]+J[7]-J[8]+J[9]-J[10]+J[11]-J[12]-J[13]-J[14]+
    J[15]-J[16]+J[17]-J[18]+J[19]-J[20]-J[21]-J[22]-J[23]+J[24]-J[25]+J[26]-J[27]+J[28]-J[29]+J[30]+J[31]-J[32]+
    J[33]-J[34]+J[35]-J[36]+J[37]+J[38]-J[39]+J[40]-J[41]+J[42]-J[43]+J[44]-J[45]+J[46]-J[47]+J[48]-J[49]+
    J[50]-J[51]+J[52]-J[53]+J[54]-J[55]-J[56]+J[57]-J[58]+J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]+
    H[1]+H[2]-H[3]-H[4]-H[5]+H[6]-H[7]+H[8]-H[9]-H[10]+H[11]+J[0]+J[1]-J[2]-J[3]-J[4]+J[5]-J[6]+J[7]-J[8]-J[9]+
    J[10]+J[11]-J[12]-J[13]-J[14]+J[15]-J[16]+J[17]-J[18]-J[19]+J[20]-J[21]-J[22]-J[23]+J[24]-J[25]+J[26]-J[27]-J[28]+
    J[29]+J[30]+J[31]-J[32]+J[33]-J[34]+J[35]+J[36]-J[37]+J[38]-J[39]+J[40]-J[41]+J[42]+J[43]-J[44]-J[45]+
    J[46]-J[47]+J[48]+J[49]-J[50]-J[51]+J[52]-J[53]-J[54]+J[55]-J[56]+J[57]+J[58]-J[59]-J[60]-J[61]+J[62]+
    J[63]-J[64]-J[65], +H[0]+H[1]+H[2]-H[3]-H[4]-H[5]+H[6]-H[7]+H[8]-H[9]-H[10]-H[11]+J[0]+J[1]-J[2]-J[3]-J[4]+
    J[5]-J[6]+J[7]-J[8]-J[9]-J[10]+J[11]-J[12]-J[13]-J[14]+J[15]-J[16]+J[17]-J[18]-J[19]-J[20]-J[21]-J[22]-J[23]+
    J[24]-J[25]+J[26]-J[27]-J[28]-J[29]+J[30]+J[31]-J[32]+J[33]-J[34]+J[35]+J[36]+J[37]+J[38]-J[39]+J[40]-J[41]+
    J[42]+J[43]+J[44]-J[45]+J[46]-J[47]+J[48]+J[49]+J[50]-J[51]+J[52]-J[53]-J[54]-J[55]-J[56]+J[57]+J[58]+
    J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]+H[1]+H[2]-H[3]-H[4]-H[5]+H[6]-H[7]-H[8]+H[9]+H[10]+
    H[11]+J[0]+J[1]-J[2]-J[3]-J[4]+J[5]-J[6]-J[7]+J[8]+J[9]+J[10]+J[11]-J[12]-J[13]-J[14]+J[15]-J[16]-J[17]+
    J[18]+J[19]+J[20]-J[21]-J[22]-J[23]+J[24]-J[25]-J[26]+J[27]+J[28]+J[29]+J[30]+J[31]-J[32]+J[33]+J[34]-J[35]-J[36]-J[37]+
    J[38]-J[39]+J[40]+J[41]-J[42]-J[43]-J[44]-J[45]+J[46]+J[47]-J[48]-J[49]-J[50]-J[51]-J[52]+J[53]+J[54]+
    J[55]+J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]+H[1]+H[2]-H[3]-H[4]-H[5]+H[6]-H[7]-H[8]+
    H[9]+H[10]-H[11]+J[0]+J[1]-J[2]-J[3]-J[4]+J[5]-J[6]-J[7]+J[8]+J[9]-J[10]+J[11]-J[12]-J[13]-J[14]+J[15]-J[16]-J[17]+
    J[18]+J[19]-J[20]-J[21]-J[22]-J[23]+J[24]-J[25]-J[26]+J[27]+J[28]-J[29]+J[30]+J[31]-J[32]+J[33]+J[34]-J[35]-J[36]+
    J[37]+J[38]-J[39]+J[40]+J[41]-J[42]-J[43]+J[44]-J[45]+J[46]+J[47]-J[48]-J[49]+J[50]-J[51]-J[52]+J[53]+
    J[54]-J[55]+J[56]-J[57]-J[58]+J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]+H[1]+H[2]-H[3]-H[4]-H[5]+
    H[6]-H[7]-H[8]+H[9]-H[10]+H[11]+J[0]+J[1]-J[2]-J[3]-J[4]+J[5]-J[6]-J[7]+J[8]-J[9]+J[10]+J[11]-J[12]-J[13]-J[14]+
    J[15]-J[16]-J[17]+J[18]-J[19]+J[20]-J[21]-J[22]-J[23]+J[24]-J[25]-J[26]+J[27]-J[28]+J[29]+J[30]+J[31]-J[32]+
    J[33]+J[34]-J[35]+J[36]-J[37]+J[38]-J[39]+J[40]+J[41]-J[42]+J[43]-J[44]-J[45]+J[46]+J[47]-J[48]+J[49]-J[50]-J[51]-J[52]+
    J[53]-J[54]+J[55]+J[56]-J[57]+J[58]-J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]+H[1]+H[2]-H[3]-H[4]-H[5]+
    H[6]-H[7]-H[8]+H[9]-H[10]-H[11]+J[0]+J[1]-J[2]-J[3]-J[4]+J[5]-J[6]-J[7]+J[8]-J[9]-J[10]+J[11]-J[12]-J[13]-J[14]+
    J[15]-J[16]-J[17]+J[18]-J[19]-J[20]-J[21]-J[22]-J[23]+J[24]-J[25]-J[26]+J[27]-J[28]-J[29]+J[30]+J[31]-J[32]+
    J[33]+J[34]-J[35]+J[36]+J[37]+J[38]-J[39]+J[40]+J[41]-J[42]+J[43]+J[44]-J[45]+J[46]+J[47]-J[48]+J[49]+
    J[50]-J[51]-J[52]+J[53]-J[54]-J[55]+J[56]-J[57]+J[58]+J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]+
    H[1]+H[2]-H[3]-H[4]-H[5]+H[6]-H[7]-H[8]-H[9]+H[10]+H[11]+J[0]+J[1]-J[2]-J[3]-J[4]+J[5]-J[6]-J[7]-J[8]+
    J[9]+J[10]+J[11]-J[12]-J[13]-J[14]+J[15]-J[16]-J[17]-J[18]+J[19]+J[20]-J[21]-J[22]-J[23]+J[24]-J[25]-J[26]-J[27]+
    J[28]+J[29]+J[30]+J[31]-J[32]+J[33]+J[34]+J[35]-J[36]-J[37]+J[38]-J[39]+J[40]+J[41]+J[42]-J[43]-J[44]-J[45]+
    J[46]+J[47]+J[48]-J[49]-J[50]-J[51]-J[52]-J[53]+J[54]+J[55]+J[56]+J[57]-J[58]-J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+
    J[65], +H[0]+H[1]+H[2]-H[3]-H[4]-H[5]+H[6]-H[7]-H[8]-H[9]+H[10]-H[11]+J[0]+J[1]-J[2]-J[3]-J[4]+J[5]-J[6]-J[7]-J[8]+
    J[9]-J[10]+J[11]-J[12]-J[13]-J[14]+J[15]-J[16]-J[17]-J[18]+J[19]-J[20]-J[21]-J[22]-J[23]+J[24]-J[25]-J[26]-J[27]+
    J[28]-J[29]+J[30]+J[31]-J[32]+J[33]+J[34]+J[35]-J[36]+J[37]+J[38]-J[39]+J[40]+J[41]+J[42]-J[43]+J[44]-J[45]+
    J[46]+J[47]+J[48]-J[49]+J[50]-J[51]-J[52]-J[53]+J[54]-J[55]+J[56]+J[57]-J[58]+J[59]+J[60]-J[61]+J[62]-J[63]+
    J[64]-J[65], +H[0]+H[1]+H[2]-H[3]-H[4]-H[5]+H[6]-H[7]-H[8]-H[9]-H[10]+H[11]+J[0]+J[1]-J[2]-J[3]-J[4]+
    J[5]-J[6]-J[7]-J[8]-J[9]+J[10]+J[11]-J[12]-J[13]-J[14]+J[15]-J[16]-J[17]-J[18]-J[19]+J[20]-J[21]-J[22]-J[23]+
    J[24]-J[25]-J[26]-J[27]-J[28]+J[29]+J[30]+J[31]-J[32]+J[33]+J[34]+J[35]+J[36]-J[37]+J[38]-J[39]+J[40]+
    J[41]+J[42]+J[43]-J[44]-J[45]+J[46]+J[47]+J[48]+J[49]-J[50]-J[51]-J[52]-J[53]-J[54]+J[55]+J[56]+J[57]+
    J[58]-J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]+H[1]+H[2]-H[3]-H[4]-H[5]+H[6]-H[7]-H[8]-H[9]-H[10]-H[11]+
    J[0]+J[1]-J[2]-J[3]-J[4]+J[5]-J[6]-J[7]-J[8]-J[9]-J[10]+J[11]-J[12]-J[13]-J[14]+J[15]-J[16]-J[17]-J[18]-J[19]-J[20]-J[21]-J[22]-J[23]+
    J[24]-J[25]-J[26]-J[27]-J[28]-J[29]+J[30]+J[31]-J[32]+J[33]+J[34]+J[35]+J[36]+J[37]+J[38]-J[39]+J[40]+
    J[41]+J[42]+J[43]+J[44]-J[45]+J[46]+J[47]+J[48]+J[49]+J[50]-J[51]-J[52]-J[53]-J[54]-J[55]+J[56]+J[57]+
    J[58]+J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]+H[1]+H[2]-H[3]-H[4]-H[5]-H[6]+H[7]+H[8]+H[9]+
    H[10]+H[11]+J[0]+J[1]-J[2]-J[3]-J[4]-J[5]+J[6]+J[7]+J[8]+J[9]+J[10]+J[11]-J[12]-J[13]-J[14]-J[15]+J[16]+
    J[17]+J[18]+J[19]+J[20]-J[21]-J[22]-J[23]-J[24]+J[25]+J[26]+J[27]+J[28]+J[29]+J[30]+J[31]+J[32]-J[33]-J[34]-J[35]-J[36]-J[37]+
    J[38]+J[39]-J[40]-J[41]-J[42]-J[43]-J[44]+J[45]-J[46]-J[47]-J[48]-J[49]-J[50]-J[51]-J[52]-J[53]-J[54]-J[55]+
    J[56]+J[57]+J[58]+J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]+H[1]+H[2]-H[3]-H[4]-H[5]-H[6]+H[7]+
    H[8]+H[9]+H[10]-H[11]+J[0]+J[1]-J[2]-J[3]-J[4]-J[5]+J[6]+J[7]+J[8]+J[9]-J[10]+J[11]-J[12]-J[13]-J[14]-J[15]+
    J[16]+J[17]+J[18]+J[19]-J[20]-J[21]-J[22]-J[23]-J[24]+J[25]+J[26]+J[27]+J[28]-J[29]+J[30]+J[31]+J[32]-J[33]-J[34]-J[35]-J[36]+
    J[37]+J[38]+J[39]-J[40]-J[41]-J[42]-J[43]+J[44]+J[45]-J[46]-J[47]-J[48]-J[49]+J[50]-J[51]-J[52]-J[53]-J[54]+
    J[55]+J[56]+J[57]+J[58]-J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]+H[1]+H[2]-H[3]-H[4]-H[5]-H[6]+
    H[7]+H[8]+H[9]-H[10]+H[11]+J[0]+J[1]-J[2]-J[3]-J[4]-J[5]+J[6]+J[7]+J[8]-J[9]+J[10]+J[11]-J[12]-J[13]-J[14]-J[15]+
    J[16]+J[17]+J[18]-J[19]+J[20]-J[21]-J[22]-J[23]-J[24]+J[25]+J[26]+J[27]-J[28]+J[29]+J[30]+J[31]+J[32]-J[33]-J[34]-J[35]+
    J[36]-J[37]+J[38]+J[39]-J[40]-J[41]-J[42]+J[43]-J[44]+J[45]-J[46]-J[47]-J[48]+J[49]-J[50]-J[51]-J[52]-J[53]+
    J[54]-J[55]+J[56]+J[57]-J[58]+J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]+H[1]+H[2]-H[3]-H[4]-H[5]-H[6]+
    H[7]+H[8]+H[9]-H[10]-H[11]+J[0]+J[1]-J[2]-J[3]-J[4]-J[5]+J[6]+J[7]+J[8]-J[9]-J[10]+J[11]-J[12]-J[13]-J[14]-J[15]+
    J[16]+J[17]+J[18]-J[19]-J[20]-J[21]-J[22]-J[23]-J[24]+J[25]+J[26]+J[27]-J[28]-J[29]+J[30]+J[31]+J[32]-J[33]-J[34]-J[35]+
    J[36]+J[37]+J[38]+J[39]-J[40]-J[41]-J[42]+J[43]+J[44]+J[45]-J[46]-J[47]-J[48]+J[49]+J[50]-J[51]-J[52]-J[53]+
    J[54]+J[55]+J[56]+J[57]-J[58]-J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]+H[1]+H[2]-H[3]-H[4]-H[5]-H[6]+
    H[7]+H[8]-H[9]+H[10]+H[11]+J[0]+J[1]-J[2]-J[3]-J[4]-J[5]+J[6]+J[7]-J[8]+J[9]+J[10]+J[11]-J[12]-J[13]-J[14]-J[15]+
    J[16]+J[17]-J[18]+J[19]+J[20]-J[21]-J[22]-J[23]-J[24]+J[25]+J[26]-J[27]+J[28]+J[29]+J[30]+J[31]+J[32]-J[33]-J[34]+
    J[35]-J[36]-J[37]+J[38]+J[39]-J[40]-J[41]+J[42]-J[43]-J[44]+J[45]-J[46]-J[47]+J[48]-J[49]-J[50]-J[51]-J[52]+
    J[53]-J[54]-J[55]+J[56]-J[57]+J[58]+J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]+H[1]+H[2]-H[3]-H[4]-H[5]-H[6]+
    H[7]+H[8]-H[9]+H[10]-H[11]+J[0]+J[1]-J[2]-J[3]-J[4]-J[5]+J[6]+J[7]-J[8]+J[9]-J[10]+J[11]-J[12]-J[13]-J[14]-J[15]+
    J[16]+J[17]-J[18]+J[19]-J[20]-J[21]-J[22]-J[23]-J[24]+J[25]+J[26]-J[27]+J[28]-J[29]+J[30]+J[31]+J[32]-J[33]-J[34]+
    J[35]-J[36]+J[37]+J[38]+J[39]-J[40]-J[41]+J[42]-J[43]+J[44]+J[45]-J[46]-J[47]+J[48]-J[49]+J[50]-J[51]-J[52]+
    J[53]-J[54]+J[55]+J[56]-J[57]+J[58]-J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]+H[1]+H[2]-H[3]-H[4]-H[5]-H[6]+
    H[7]+H[8]-H[9]-H[10]+H[11]+J[0]+J[1]-J[2]-J[3]-J[4]-J[5]+J[6]+J[7]-J[8]-J[9]+J[10]+J[11]-J[12]-J[13]-J[14]-J[15]+
    J[16]+J[17]-J[18]-J[19]+J[20]-J[21]-J[22]-J[23]-J[24]+J[25]+J[26]-J[27]-J[28]+J[29]+J[30]+J[31]+J[32]-J[33]-J[34]+
    J[35]+J[36]-J[37]+J[38]+J[39]-J[40]-J[41]+J[42]+J[43]-J[44]+J[45]-J[46]-J[47]+J[48]+J[49]-J[50]-J[51]-J[52]+
    J[53]+J[54]-J[55]+J[56]-J[57]-J[58]+J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]+H[1]+H[2]-H[3]-H[4]-H[5]-H[6]+
    H[7]+H[8]-H[9]-H[10]-H[11]+J[0]+J[1]-J[2]-J[3]-J[4]-J[5]+J[6]+J[7]-J[8]-J[9]-J[10]+J[11]-J[12]-J[13]-J[14]-J[15]+
    J[16]+J[17]-J[18]-J[19]-J[20]-J[21]-J[22]-J[23]-J[24]+J[25]+J[26]-J[27]-J[28]-J[29]+J[30]+J[31]+J[32]-J[33]-J[34]+
    J[35]+J[36]+J[37]+J[38]+J[39]-J[40]-J[41]+J[42]+J[43]+J[44]+J[45]-J[46]-J[47]+J[48]+J[49]+J[50]-J[51]-J[52]+
    J[53]+J[54]+J[55]+J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]+H[1]+H[2]-H[3]-H[4]-H[5]-H[6]+
    H[7]-H[8]+H[9]+H[10]+H[11]+J[0]+J[1]-J[2]-J[3]-J[4]-J[5]+J[6]-J[7]+J[8]+J[9]+J[10]+J[11]-J[12]-J[13]-J[14]-J[15]+
    J[16]-J[17]+J[18]+J[19]+J[20]-J[21]-J[22]-J[23]-J[24]+J[25]-J[26]+J[27]+J[28]+J[29]+J[30]+J[31]+J[32]-J[33]+
    J[34]-J[35]-J[36]-J[37]+J[38]+J[39]-J[40]+J[41]-J[42]-J[43]-J[44]+J[45]-J[46]+J[47]-J[48]-J[49]-J[50]-J[51]+
    J[52]-J[53]-J[54]-J[55]-J[56]+J[57]+J[58]+J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]+H[1]+H[2]-H[3]-H[4]-H[5]-H[6]+
    H[7]-H[8]+H[9]+H[10]-H[11]+J[0]+J[1]-J[2]-J[3]-J[4]-J[5]+J[6]-J[7]+J[8]+J[9]-J[10]+J[11]-J[12]-J[13]-J[14]-J[15]+
    J[16]-J[17]+J[18]+J[19]-J[20]-J[21]-J[22]-J[23]-J[24]+J[25]-J[26]+J[27]+J[28]-J[29]+J[30]+J[31]+J[32]-J[33]+
    J[34]-J[35]-J[36]+J[37]+J[38]+J[39]-J[40]+J[41]-J[42]-J[43]+J[44]+J[45]-J[46]+J[47]-J[48]-J[49]+J[50]-J[51]+
    J[52]-J[53]-J[54]+J[55]-J[56]+J[57]+J[58]-J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]+H[1]+H[2]-H[3]-H[4]-H[5]-H[6]+
    H[7]-H[8]+H[9]-H[10]+H[11]+J[0]+J[1]-J[2]-J[3]-J[4]-J[5]+J[6]-J[7]+J[8]-J[9]+J[10]+J[11]-J[12]-J[13]-J[14]-J[15]+
    J[16]-J[17]+J[18]-J[19]+J[20]-J[21]-J[22]-J[23]-J[24]+J[25]-J[26]+J[27]-J[28]+J[29]+J[30]+J[31]+J[32]-J[33]+
    J[34]-J[35]+J[36]-J[37]+J[38]+J[39]-J[40]+J[41]-J[42]+J[43]-J[44]+J[45]-J[46]+J[47]-J[48]+J[49]-J[50]-J[51]+
    J[52]-J[53]+J[54]-J[55]-J[56]+J[57]-J[58]+J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]+H[1]+H[2]-H[3]-H[4]-H[5]-H[6]+
    H[7]-H[8]+H[9]-H[10]-H[11]+J[0]+J[1]-J[2]-J[3]-J[4]-J[5]+J[6]-J[7]+J[8]-J[9]-J[10]+J[11]-J[12]-J[13]-J[14]-J[15]+
    J[16]-J[17]+J[18]-J[19]-J[20]-J[21]-J[22]-J[23]-J[24]+J[25]-J[26]+J[27]-J[28]-J[29]+J[30]+J[31]+J[32]-J[33]+
    J[34]-J[35]+J[36]+J[37]+J[38]+J[39]-J[40]+J[41]-J[42]+J[43]+J[44]+J[45]-J[46]+J[47]-J[48]+J[49]+J[50]-J[51]+
    J[52]-J[53]+J[54]+J[55]-J[56]+J[57]-J[58]-J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]+H[1]+H[2]-H[3]-H[4]-H[5]-H[6]+
    H[7]-H[8]-H[9]+H[10]+H[11]+J[0]+J[1]-J[2]-J[3]-J[4]-J[5]+J[6]-J[7]-J[8]+J[9]+J[10]+J[11]-J[12]-J[13]-J[14]-J[15]+
    J[16]-J[17]-J[18]+J[19]+J[20]-J[21]-J[22]-J[23]-J[24]+J[25]-J[26]-J[27]+J[28]+J[29]+J[30]+J[31]+J[32]-J[33]+
    J[34]+J[35]-J[36]-J[37]+J[38]+J[39]-J[40]+J[41]+J[42]-J[43]-J[44]+J[45]-J[46]+J[47]+J[48]-J[49]-J[50]-J[51]+
    J[52]+J[53]-J[54]-J[55]-J[56]-J[57]+J[58]+J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]+H[1]+H[2]-H[3]-H[4]-H[5]-H[6]+
    H[7]-H[8]-H[9]+H[10]-H[11]+J[0]+J[1]-J[2]-J[3]-J[4]-J[5]+J[6]-J[7]-J[8]+J[9]-J[10]+J[11]-J[12]-J[13]-J[14]-J[15]+
    J[16]-J[17]-J[18]+J[19]-J[20]-J[21]-J[22]-J[23]-J[24]+J[25]-J[26]-J[27]+J[28]-J[29]+J[30]+J[31]+J[32]-J[33]+
    J[34]+J[35]-J[36]+J[37]+J[38]+J[39]-J[40]+J[41]+J[42]-J[43]+J[44]+J[45]-J[46]+J[47]+J[48]-J[49]+J[50]-J[51]+
    J[52]+J[53]-J[54]+J[55]-J[56]-J[57]+J[58]-J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]+H[1]+H[2]-H[3]-H[4]-H[5]-H[6]+
    H[7]-H[8]-H[9]-H[10]+H[11]+J[0]+J[1]-J[2]-J[3]-J[4]-J[5]+J[6]-J[7]-J[8]-J[9]+J[10]+J[11]-J[12]-J[13]-J[14]-J[15]+
    J[16]-J[17]-J[18]-J[19]+J[20]-J[21]-J[22]-J[23]-J[24]+J[25]-J[26]-J[27]-J[28]+J[29]+J[30]+J[31]+J[32]-J[33]+
    J[34]+J[35]+J[36]-J[37]+J[38]+J[39]-J[40]+J[41]+J[42]+J[43]-J[44]+J[45]-J[46]+J[47]+J[48]+J[49]-J[50]-J[51]+
    J[52]+J[53]+J[54]-J[55]-J[56]-J[57]-J[58]+J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]+H[1]+H[2]-H[3]-H[4]-H[5]-H[6]+
    H[7]-H[8]-H[9]-H[10]-H[11]+J[0]+J[1]-J[2]-J[3]-J[4]-J[5]+J[6]-J[7]-J[8]-J[9]-J[10]+J[11]-J[12]-J[13]-J[14]-J[15]+
    J[16]-J[17]-J[18]-J[19]-J[20]-J[21]-J[22]-J[23]-J[24]+J[25]-J[26]-J[27]-J[28]-J[29]+J[30]+J[31]+J[32]-J[33]+
    J[34]+J[35]+J[36]+J[37]+J[38]+J[39]-J[40]+J[41]+J[42]+J[43]+J[44]+J[45]-J[46]+J[47]+J[48]+J[49]+J[50]-J[51]+
    J[52]+J[53]+J[54]+J[55]-J[56]-J[57]-J[58]-J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]+H[1]+H[2]-H[3]-H[4]-H[5]-H[6]-H[7]+
    H[8]+H[9]+H[10]+H[11]+J[0]+J[1]-J[2]-J[3]-J[4]-J[5]-J[6]+J[7]+J[8]+J[9]+J[10]+J[11]-J[12]-J[13]-J[14]-J[15]-J[16]+
    J[17]+J[18]+J[19]+J[20]-J[21]-J[22]-J[23]-J[24]-J[25]+J[26]+J[27]+J[28]+J[29]+J[30]+J[31]+J[32]+J[33]-J[34]-J[35]-J[36]-J[37]+
    J[38]+J[39]+J[40]-J[41]-J[42]-J[43]-J[44]+J[45]+J[46]-J[47]-J[48]-J[49]-J[50]+J[51]-J[52]-J[53]-J[54]-J[55]-J[56]-J[57]-J[58]-J[59]+
    J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]+H[1]+H[2]-H[3]-H[4]-H[5]-H[6]-H[7]+H[8]+H[9]+H[10]-H[11]+
    J[0]+J[1]-J[2]-J[3]-J[4]-J[5]-J[6]+J[7]+J[8]+J[9]-J[10]+J[11]-J[12]-J[13]-J[14]-J[15]-J[16]+J[17]+J[18]+
    J[19]-J[20]-J[21]-J[22]-J[23]-J[24]-J[25]+J[26]+J[27]+J[28]-J[29]+J[30]+J[31]+J[32]+J[33]-J[34]-J[35]-J[36]+
    J[37]+J[38]+J[39]+J[40]-J[41]-J[42]-J[43]+J[44]+J[45]+J[46]-J[47]-J[48]-J[49]+J[50]+J[51]-J[52]-J[53]-J[54]+
    J[55]-J[56]-J[57]-J[58]+J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]+H[1]+H[2]-H[3]-H[4]-H[5]-H[6]-H[7]+
    H[8]+H[9]-H[10]+H[11]+J[0]+J[1]-J[2]-J[3]-J[4]-J[5]-J[6]+J[7]+J[8]-J[9]+J[10]+J[11]-J[12]-J[13]-J[14]-J[15]-J[16]+
    J[17]+J[18]-J[19]+J[20]-J[21]-J[22]-J[23]-J[24]-J[25]+J[26]+J[27]-J[28]+J[29]+J[30]+J[31]+J[32]+J[33]-J[34]-J[35]+
    J[36]-J[37]+J[38]+J[39]+J[40]-J[41]-J[42]+J[43]-J[44]+J[45]+J[46]-J[47]-J[48]+J[49]-J[50]+J[51]-J[52]-J[53]+
    J[54]-J[55]-J[56]-J[57]+J[58]-J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]+H[1]+H[2]-H[3]-H[4]-H[5]-H[6]-H[7]+
    H[8]+H[9]-H[10]-H[11]+J[0]+J[1]-J[2]-J[3]-J[4]-J[5]-J[6]+J[7]+J[8]-J[9]-J[10]+J[11]-J[12]-J[13]-J[14]-J[15]-J[16]+
    J[17]+J[18]-J[19]-J[20]-J[21]-J[22]-J[23]-J[24]-J[25]+J[26]+J[27]-J[28]-J[29]+J[30]+J[31]+J[32]+J[33]-J[34]-J[35]+
    J[36]+J[37]+J[38]+J[39]+J[40]-J[41]-J[42]+J[43]+J[44]+J[45]+J[46]-J[47]-J[48]+J[49]+J[50]+J[51]-J[52]-J[53]+
    J[54]+J[55]-J[56]-J[57]+J[58]+J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]+H[1]+H[2]-H[3]-H[4]-H[5]-H[6]-H[7]+
    H[8]-H[9]+H[10]+H[11]+J[0]+J[1]-J[2]-J[3]-J[4]-J[5]-J[6]+J[7]-J[8]+J[9]+J[10]+J[11]-J[12]-J[13]-J[14]-J[15]-J[16]+
    J[17]-J[18]+J[19]+J[20]-J[21]-J[22]-J[23]-J[24]-J[25]+J[26]-J[27]+J[28]+J[29]+J[30]+J[31]+J[32]+J[33]-J[34]+
    J[35]-J[36]-J[37]+J[38]+J[39]+J[40]-J[41]+J[42]-J[43]-J[44]+J[45]+J[46]-J[47]+J[48]-J[49]-J[50]+J[51]-J[52]+
    J[53]-J[54]-J[55]-J[56]+J[57]-J[58]-J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]+H[1]+H[2]-H[3]-H[4]-H[5]-H[6]-H[7]+
    H[8]-H[9]+H[10]-H[11]+J[0]+J[1]-J[2]-J[3]-J[4]-J[5]-J[6]+J[7]-J[8]+J[9]-J[10]+J[11]-J[12]-J[13]-J[14]-J[15]-J[16]+
    J[17]-J[18]+J[19]-J[20]-J[21]-J[22]-J[23]-J[24]-J[25]+J[26]-J[27]+J[28]-J[29]+J[30]+J[31]+J[32]+J[33]-J[34]+
    J[35]-J[36]+J[37]+J[38]+J[39]+J[40]-J[41]+J[42]-J[43]+J[44]+J[45]+J[46]-J[47]+J[48]-J[49]+J[50]+J[51]-J[52]+
    J[53]-J[54]+J[55]-J[56]+J[57]-J[58]+J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]+H[1]+H[2]-H[3]-H[4]-H[5]-H[6]-H[7]+
    H[8]-H[9]-H[10]+H[11]+J[0]+J[1]-J[2]-J[3]-J[4]-J[5]-J[6]+J[7]-J[8]-J[9]+J[10]+J[11]-J[12]-J[13]-J[14]-J[15]-J[16]+
    J[17]-J[18]-J[19]+J[20]-J[21]-J[22]-J[23]-J[24]-J[25]+J[26]-J[27]-J[28]+J[29]+J[30]+J[31]+J[32]+J[33]-J[34]+
    J[35]+J[36]-J[37]+J[38]+J[39]+J[40]-J[41]+J[42]+J[43]-J[44]+J[45]+J[46]-J[47]+J[48]+J[49]-J[50]+J[51]-J[52]+
    J[53]+J[54]-J[55]-J[56]+J[57]+J[58]-J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]+H[1]+H[2]-H[3]-H[4]-H[5]-H[6]-H[7]+
    H[8]-H[9]-H[10]-H[11]+J[0]+J[1]-J[2]-J[3]-J[4]-J[5]-J[6]+J[7]-J[8]-J[9]-J[10]+J[11]-J[12]-J[13]-J[14]-J[15]-J[16]+
    J[17]-J[18]-J[19]-J[20]-J[21]-J[22]-J[23]-J[24]-J[25]+J[26]-J[27]-J[28]-J[29]+J[30]+J[31]+J[32]+J[33]-J[34]+
    J[35]+J[36]+J[37]+J[38]+J[39]+J[40]-J[41]+J[42]+J[43]+J[44]+J[45]+J[46]-J[47]+J[48]+J[49]+J[50]+J[51]-J[52]+
    J[53]+J[54]+J[55]-J[56]+J[57]+J[58]+J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]+H[1]+H[2]-H[3]-H[4]-H[5]-H[6]-H[7]-H[8]+
    H[9]+H[10]+H[11]+J[0]+J[1]-J[2]-J[3]-J[4]-J[5]-J[6]-J[7]+J[8]+J[9]+J[10]+J[11]-J[12]-J[13]-J[14]-J[15]-J[16]-J[17]+
    J[18]+J[19]+J[20]-J[21]-J[22]-J[23]-J[24]-J[25]-J[26]+J[27]+J[28]+J[29]+J[30]+J[31]+J[32]+J[33]+J[34]-J[35]-J[36]-J[37]+
    J[38]+J[39]+J[40]+J[41]-J[42]-J[43]-J[44]+J[45]+J[46]+J[47]-J[48]-J[49]-J[50]+J[51]+J[52]-J[53]-J[54]-J[55]+
    J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]+H[1]+H[2]-H[3]-H[4]-H[5]-H[6]-H[7]-H[8]+
    H[9]+H[10]-H[11]+J[0]+J[1]-J[2]-J[3]-J[4]-J[5]-J[6]-J[7]+J[8]+J[9]-J[10]+J[11]-J[12]-J[13]-J[14]-J[15]-J[16]-J[17]+
    J[18]+J[19]-J[20]-J[21]-J[22]-J[23]-J[24]-J[25]-J[26]+J[27]+J[28]-J[29]+J[30]+J[31]+J[32]+J[33]+J[34]-J[35]-J[36]+
    J[37]+J[38]+J[39]+J[40]+J[41]-J[42]-J[43]+J[44]+J[45]+J[46]+J[47]-J[48]-J[49]+J[50]+J[51]+J[52]-J[53]-J[54]+
    J[55]+J[56]-J[57]-J[58]+J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]+H[1]+H[2]-H[3]-H[4]-H[5]-H[6]-H[7]-H[8]+
    H[9]-H[10]+H[11]+J[0]+J[1]-J[2]-J[3]-J[4]-J[5]-J[6]-J[7]+J[8]-J[9]+J[10]+J[11]-J[12]-J[13]-J[14]-J[15]-J[16]-J[17]+
    J[18]-J[19]+J[20]-J[21]-J[22]-J[23]-J[24]-J[25]-J[26]+J[27]-J[28]+J[29]+J[30]+J[31]+J[32]+J[33]+J[34]-J[35]+
    J[36]-J[37]+J[38]+J[39]+J[40]+J[41]-J[42]+J[43]-J[44]+J[45]+J[46]+J[47]-J[48]+J[49]-J[50]+J[51]+J[52]-J[53]+
    J[54]-J[55]+J[56]-J[57]+J[58]-J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]+H[1]+H[2]-H[3]-H[4]-H[5]-H[6]-H[7]-H[8]+
    H[9]-H[10]-H[11]+J[0]+J[1]-J[2]-J[3]-J[4]-J[5]-J[6]-J[7]+J[8]-J[9]-J[10]+J[11]-J[12]-J[13]-J[14]-J[15]-J[16]-J[17]+
    J[18]-J[19]-J[20]-J[21]-J[22]-J[23]-J[24]-J[25]-J[26]+J[27]-J[28]-J[29]+J[30]+J[31]+J[32]+J[33]+J[34]-J[35]+
    J[36]+J[37]+J[38]+J[39]+J[40]+J[41]-J[42]+J[43]+J[44]+J[45]+J[46]+J[47]-J[48]+J[49]+J[50]+J[51]+J[52]-J[53]+
    J[54]+J[55]+J[56]-J[57]+J[58]+J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]+H[1]+H[2]-H[3]-H[4]-H[5]-H[6]-H[7]-H[8]-H[9]+
    H[10]+H[11]+J[0]+J[1]-J[2]-J[3]-J[4]-J[5]-J[6]-J[7]-J[8]+J[9]+J[10]+J[11]-J[12]-J[13]-J[14]-J[15]-J[16]-J[17]-J[18]+
    J[19]+J[20]-J[21]-J[22]-J[23]-J[24]-J[25]-J[26]-J[27]+J[28]+J[29]+J[30]+J[31]+J[32]+J[33]+J[34]+J[35]-J[36]-J[37]+
    J[38]+J[39]+J[40]+J[41]+J[42]-J[43]-J[44]+J[45]+J[46]+J[47]+J[48]-J[49]-J[50]+J[51]+J[52]+J[53]-J[54]-J[55]+
    J[56]+J[57]-J[58]-J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]+H[1]+H[2]-H[3]-H[4]-H[5]-H[6]-H[7]-H[8]-H[9]+
    H[10]-H[11]+J[0]+J[1]-J[2]-J[3]-J[4]-J[5]-J[6]-J[7]-J[8]+J[9]-J[10]+J[11]-J[12]-J[13]-J[14]-J[15]-J[16]-J[17]-J[18]+
    J[19]-J[20]-J[21]-J[22]-J[23]-J[24]-J[25]-J[26]-J[27]+J[28]-J[29]+J[30]+J[31]+J[32]+J[33]+J[34]+J[35]-J[36]+
    J[37]+J[38]+J[39]+J[40]+J[41]+J[42]-J[43]+J[44]+J[45]+J[46]+J[47]+J[48]-J[49]+J[50]+J[51]+J[52]+J[53]-J[54]+
    J[55]+J[56]+J[57]-J[58]+J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]+H[1]+H[2]-H[3]-H[4]-H[5]-H[6]-H[7]-H[8]-H[9]-H[10]+
    H[11]+J[0]+J[1]-J[2]-J[3]-J[4]-J[5]-J[6]-J[7]-J[8]-J[9]+J[10]+J[11]-J[12]-J[13]-J[14]-J[15]-J[16]-J[17]-J[18]-J[19]+
    J[20]-J[21]-J[22]-J[23]-J[24]-J[25]-J[26]-J[27]-J[28]+J[29]+J[30]+J[31]+J[32]+J[33]+J[34]+J[35]+J[36]-J[37]+
    J[38]+J[39]+J[40]+J[41]+J[42]+J[43]-J[44]+J[45]+J[46]+J[47]+J[48]+J[49]-J[50]+J[51]+J[52]+J[53]+J[54]-J[55]+
    J[56]+J[57]+J[58]-J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]+H[1]+H[2]-H[3]-H[4]-H[5]-H[6]-H[7]-H[8]-H[9]-H[10]-H[11]+
    J[0]+J[1]-J[2]-J[3]-J[4]-J[5]-J[6]-J[7]-J[8]-J[9]-J[10]+J[11]-J[12]-J[13]-J[14]-J[15]-J[16]-J[17]-J[18]-J[19]-J[20]-J[21]-J[22]-J[23]-J[24]-J[25]-J[26]-J[27]-J[28]-J[29]+
    J[30]+J[31]+J[32]+J[33]+J[34]+J[35]+J[36]+J[37]+J[38]+J[39]+J[40]+J[41]+J[42]+J[43]+J[44]+J[45]+J[46]+
    J[47]+J[48]+J[49]+J[50]+J[51]+J[52]+J[53]+J[54]+J[55]+J[56]+J[57]+J[58]+J[59]+J[60]+J[61]+J[62]+J[63]+
    J[64]+J[65], +H[0]+H[1]-H[2]+H[3]+H[4]+H[5]+H[6]+H[7]+H[8]+H[9]+H[10]+H[11]+J[0]-J[1]+J[2]+J[3]+J[4]+
    J[5]+J[6]+J[7]+J[8]+J[9]+J[10]-J[11]+J[12]+J[13]+J[14]+J[15]+J[16]+J[17]+J[18]+J[19]+J[20]-J[21]-J[22]-J[23]-J[24]-J[25]-J[26]-J[27]-J[28]-J[29]+
    J[30]+J[31]+J[32]+J[33]+J[34]+J[35]+J[36]+J[37]+J[38]+J[39]+J[40]+J[41]+J[42]+J[43]+J[44]+J[45]+J[46]+
    J[47]+J[48]+J[49]+J[50]+J[51]+J[52]+J[53]+J[54]+J[55]+J[56]+J[57]+J[58]+J[59]+J[60]+J[61]+J[62]+J[63]+
    J[64]+J[65], +H[0]+H[1]-H[2]+H[3]+H[4]+H[5]+H[6]+H[7]+H[8]+H[9]+H[10]-H[11]+J[0]-J[1]+J[2]+J[3]+J[4]+
    J[5]+J[6]+J[7]+J[8]+J[9]-J[10]-J[11]+J[12]+J[13]+J[14]+J[15]+J[16]+J[17]+J[18]+J[19]-J[20]-J[21]-J[22]-J[23]-J[24]-J[25]-J[26]-J[27]-J[28]+
    J[29]+J[30]+J[31]+J[32]+J[33]+J[34]+J[35]+J[36]-J[37]+J[38]+J[39]+J[40]+J[41]+J[42]+J[43]-J[44]+J[45]+
    J[46]+J[47]+J[48]+J[49]-J[50]+J[51]+J[52]+J[53]+J[54]-J[55]+J[56]+J[57]+J[58]-J[59]+J[60]+J[61]-J[62]+
    J[63]-J[64]-J[65], +H[0]+H[1]-H[2]+H[3]+H[4]+H[5]+H[6]+H[7]+H[8]+H[9]-H[10]+H[11]+J[0]-J[1]+J[2]+J[3]+
    J[4]+J[5]+J[6]+J[7]+J[8]-J[9]+J[10]-J[11]+J[12]+J[13]+J[14]+J[15]+J[16]+J[17]+J[18]-J[19]+J[20]-J[21]-J[22]-J[23]-J[24]-J[25]-J[26]-J[27]+
    J[28]-J[29]+J[30]+J[31]+J[32]+J[33]+J[34]+J[35]-J[36]+J[37]+J[38]+J[39]+J[40]+J[41]+J[42]-J[43]+J[44]+
    J[45]+J[46]+J[47]+J[48]-J[49]+J[50]+J[51]+J[52]+J[53]-J[54]+J[55]+J[56]+J[57]-J[58]+J[59]+J[60]-J[61]+
    J[62]-J[63]+J[64]-J[65], +H[0]+H[1]-H[2]+H[3]+H[4]+H[5]+H[6]+H[7]+H[8]+H[9]-H[10]-H[11]+J[0]-J[1]+J[2]+
    J[3]+J[4]+J[5]+J[6]+J[7]+J[8]-J[9]-J[10]-J[11]+J[12]+J[13]+J[14]+J[15]+J[16]+J[17]+J[18]-J[19]-J[20]-J[21]-J[22]-J[23]-J[24]-J[25]-J[26]-J[27]+
    J[28]+J[29]+J[30]+J[31]+J[32]+J[33]+J[34]+J[35]-J[36]-J[37]+J[38]+J[39]+J[40]+J[41]+J[42]-J[43]-J[44]+
    J[45]+J[46]+J[47]+J[48]-J[49]-J[50]+J[51]+J[52]+J[53]-J[54]-J[55]+J[56]+J[57]-J[58]-J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+
    J[65], +H[0]+H[1]-H[2]+H[3]+H[4]+H[5]+H[6]+H[7]+H[8]-H[9]+H[10]+H[11]+J[0]-J[1]+J[2]+J[3]+J[4]+J[5]+
    J[6]+J[7]-J[8]+J[9]+J[10]-J[11]+J[12]+J[13]+J[14]+J[15]+J[16]+J[17]-J[18]+J[19]+J[20]-J[21]-J[22]-J[23]-J[24]-J[25]-J[26]+
    J[27]-J[28]-J[29]+J[30]+J[31]+J[32]+J[33]+J[34]-J[35]+J[36]+J[37]+J[38]+J[39]+J[40]+J[41]-J[42]+J[43]+
    J[44]+J[45]+J[46]+J[47]-J[48]+J[49]+J[50]+J[51]+J[52]-J[53]+J[54]+J[55]+J[56]-J[57]+J[58]+J[59]-J[60]+
    J[61]+J[62]-J[63]-J[64]+J[65], +H[0]+H[1]-H[2]+H[3]+H[4]+H[5]+H[6]+H[7]+H[8]-H[9]+H[10]-H[11]+J[0]-J[1]+
    J[2]+J[3]+J[4]+J[5]+J[6]+J[7]-J[8]+J[9]-J[10]-J[11]+J[12]+J[13]+J[14]+J[15]+J[16]+J[17]-J[18]+J[19]-J[20]-J[21]-J[22]-J[23]-J[24]-J[25]-J[26]+
    J[27]-J[28]+J[29]+J[30]+J[31]+J[32]+J[33]+J[34]-J[35]+J[36]-J[37]+J[38]+J[39]+J[40]+J[41]-J[42]+J[43]-J[44]+
    J[45]+J[46]+J[47]-J[48]+J[49]-J[50]+J[51]+J[52]-J[53]+J[54]-J[55]+J[56]-J[57]+J[58]-J[59]-J[60]+J[61]-J[62]-J[63]+
    J[64]-J[65], +H[0]+H[1]-H[2]+H[3]+H[4]+H[5]+H[6]+H[7]+H[8]-H[9]-H[10]+H[11]+J[0]-J[1]+J[2]+J[3]+J[4]+
    J[5]+J[6]+J[7]-J[8]-J[9]+J[10]-J[11]+J[12]+J[13]+J[14]+J[15]+J[16]+J[17]-J[18]-J[19]+J[20]-J[21]-J[22]-J[23]-J[24]-J[25]-J[26]+
    J[27]+J[28]-J[29]+J[30]+J[31]+J[32]+J[33]+J[34]-J[35]-J[36]+J[37]+J[38]+J[39]+J[40]+J[41]-J[42]-J[43]+
    J[44]+J[45]+J[46]+J[47]-J[48]-J[49]+J[50]+J[51]+J[52]-J[53]-J[54]+J[55]+J[56]-J[57]-J[58]+J[59]-J[60]-J[61]+
    J[62]+J[63]-J[64]-J[65], +H[0]+H[1]-H[2]+H[3]+H[4]+H[5]+H[6]+H[7]+H[8]-H[9]-H[10]-H[11]+J[0]-J[1]+J[2]+
    J[3]+J[4]+J[5]+J[6]+J[7]-J[8]-J[9]-J[10]-J[11]+J[12]+J[13]+J[14]+J[15]+J[16]+J[17]-J[18]-J[19]-J[20]-J[21]-J[22]-J[23]-J[24]-J[25]-J[26]+
    J[27]+J[28]+J[29]+J[30]+J[31]+J[32]+J[33]+J[34]-J[35]-J[36]-J[37]+J[38]+J[39]+J[40]+J[41]-J[42]-J[43]-J[44]+
    J[45]+J[46]+J[47]-J[48]-J[49]-J[50]+J[51]+J[52]-J[53]-J[54]-J[55]+J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+
    J[63]+J[64]+J[65], +H[0]+H[1]-H[2]+H[3]+H[4]+H[5]+H[6]+H[7]-H[8]+H[9]+H[10]+H[11]+J[0]-J[1]+J[2]+J[3]+
    J[4]+J[5]+J[6]-J[7]+J[8]+J[9]+J[10]-J[11]+J[12]+J[13]+J[14]+J[15]+J[16]-J[17]+J[18]+J[19]+J[20]-J[21]-J[22]-J[23]-J[24]-J[25]+
    J[26]-J[27]-J[28]-J[29]+J[30]+J[31]+J[32]+J[33]-J[34]+J[35]+J[36]+J[37]+J[38]+J[39]+J[40]-J[41]+J[42]+
    J[43]+J[44]+J[45]+J[46]-J[47]+J[48]+J[49]+J[50]+J[51]-J[52]+J[53]+J[54]+J[55]-J[56]+J[57]+J[58]+J[59]-J[60]-J[61]-J[62]+
    J[63]+J[64]+J[65], +H[0]+H[1]-H[2]+H[3]+H[4]+H[5]+H[6]+H[7]-H[8]+H[9]+H[10]-H[11]+J[0]-J[1]+J[2]+J[3]+
    J[4]+J[5]+J[6]-J[7]+J[8]+J[9]-J[10]-J[11]+J[12]+J[13]+J[14]+J[15]+J[16]-J[17]+J[18]+J[19]-J[20]-J[21]-J[22]-J[23]-J[24]-J[25]+
    J[26]-J[27]-J[28]+J[29]+J[30]+J[31]+J[32]+J[33]-J[34]+J[35]+J[36]-J[37]+J[38]+J[39]+J[40]-J[41]+J[42]+
    J[43]-J[44]+J[45]+J[46]-J[47]+J[48]+J[49]-J[50]+J[51]-J[52]+J[53]+J[54]-J[55]-J[56]+J[57]+J[58]-J[59]-J[60]-J[61]+
    J[62]+J[63]-J[64]-J[65], +H[0]+H[1]-H[2]+H[3]+H[4]+H[5]+H[6]+H[7]-H[8]+H[9]-H[10]+H[11]+J[0]-J[1]+J[2]+
    J[3]+J[4]+J[5]+J[6]-J[7]+J[8]-J[9]+J[10]-J[11]+J[12]+J[13]+J[14]+J[15]+J[16]-J[17]+J[18]-J[19]+J[20]-J[21]-J[22]-J[23]-J[24]-J[25]+
    J[26]-J[27]+J[28]-J[29]+J[30]+J[31]+J[32]+J[33]-J[34]+J[35]-J[36]+J[37]+J[38]+J[39]+J[40]-J[41]+J[42]-J[43]+
    J[44]+J[45]+J[46]-J[47]+J[48]-J[49]+J[50]+J[51]-J[52]+J[53]-J[54]+J[55]-J[56]+J[57]-J[58]+J[59]-J[60]+
    J[61]-J[62]-J[63]+J[64]-J[65], +H[0]+H[1]-H[2]+H[3]+H[4]+H[5]+H[6]+H[7]-H[8]+H[9]-H[10]-H[11]+J[0]-J[1]+
    J[2]+J[3]+J[4]+J[5]+J[6]-J[7]+J[8]-J[9]-J[10]-J[11]+J[12]+J[13]+J[14]+J[15]+J[16]-J[17]+J[18]-J[19]-J[20]-J[21]-J[22]-J[23]-J[24]-J[25]+
    J[26]-J[27]+J[28]+J[29]+J[30]+J[31]+J[32]+J[33]-J[34]+J[35]-J[36]-J[37]+J[38]+J[39]+J[40]-J[41]+J[42]-J[43]-J[44]+
    J[45]+J[46]-J[47]+J[48]-J[49]-J[50]+J[51]-J[52]+J[53]-J[54]-J[55]-J[56]+J[57]-J[58]-J[59]-J[60]+J[61]+
    J[62]-J[63]-J[64]+J[65], +H[0]+H[1]-H[2]+H[3]+H[4]+H[5]+H[6]+H[7]-H[8]-H[9]+H[10]+H[11]+J[0]-J[1]+J[2]+
    J[3]+J[4]+J[5]+J[6]-J[7]-J[8]+J[9]+J[10]-J[11]+J[12]+J[13]+J[14]+J[15]+J[16]-J[17]-J[18]+J[19]+J[20]-J[21]-J[22]-J[23]-J[24]-J[25]+
    J[26]+J[27]-J[28]-J[29]+J[30]+J[31]+J[32]+J[33]-J[34]-J[35]+J[36]+J[37]+J[38]+J[39]+J[40]-J[41]-J[42]+
    J[43]+J[44]+J[45]+J[46]-J[47]-J[48]+J[49]+J[50]+J[51]-J[52]-J[53]+J[54]+J[55]-J[56]-J[57]+J[58]+J[59]+
    J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]+H[1]-H[2]+H[3]+H[4]+H[5]+H[6]+H[7]-H[8]-H[9]+H[10]-H[11]+
    J[0]-J[1]+J[2]+J[3]+J[4]+J[5]+J[6]-J[7]-J[8]+J[9]-J[10]-J[11]+J[12]+J[13]+J[14]+J[15]+J[16]-J[17]-J[18]+
    J[19]-J[20]-J[21]-J[22]-J[23]-J[24]-J[25]+J[26]+J[27]-J[28]+J[29]+J[30]+J[31]+J[32]+J[33]-J[34]-J[35]+
    J[36]-J[37]+J[38]+J[39]+J[40]-J[41]-J[42]+J[43]-J[44]+J[45]+J[46]-J[47]-J[48]+J[49]-J[50]+J[51]-J[52]-J[53]+
    J[54]-J[55]-J[56]-J[57]+J[58]-J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]+H[1]-H[2]+H[3]+H[4]+H[5]+
    H[6]+H[7]-H[8]-H[9]-H[10]+H[11]+J[0]-J[1]+J[2]+J[3]+J[4]+J[5]+J[6]-J[7]-J[8]-J[9]+J[10]-J[11]+J[12]+
    J[13]+J[14]+J[15]+J[16]-J[17]-J[18]-J[19]+J[20]-J[21]-J[22]-J[23]-J[24]-J[25]+J[26]+J[27]+J[28]-J[29]+
    J[30]+J[31]+J[32]+J[33]-J[34]-J[35]-J[36]+J[37]+J[38]+J[39]+J[40]-J[41]-J[42]-J[43]+J[44]+J[45]+J[46]-J[47]-J[48]-J[49]+
    J[50]+J[51]-J[52]-J[53]-J[54]+J[55]-J[56]-J[57]-J[58]+J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]+
    H[1]-H[2]+H[3]+H[4]+H[5]+H[6]+H[7]-H[8]-H[9]-H[10]-H[11]+J[0]-J[1]+J[2]+J[3]+J[4]+J[5]+J[6]-J[7]-J[8]-J[9]-J[10]-J[11]+
    J[12]+J[13]+J[14]+J[15]+J[16]-J[17]-J[18]-J[19]-J[20]-J[21]-J[22]-J[23]-J[24]-J[25]+J[26]+J[27]+J[28]+
    J[29]+J[30]+J[31]+J[32]+J[33]-J[34]-J[35]-J[36]-J[37]+J[38]+J[39]+J[40]-J[41]-J[42]-J[43]-J[44]+J[45]+
    J[46]-J[47]-J[48]-J[49]-J[50]+J[51]-J[52]-J[53]-J[54]-J[55]-J[56]-J[57]-J[58]-J[59]+J[60]+J[61]+J[62]+
    J[63]+J[64]+J[65], +H[0]+H[1]-H[2]+H[3]+H[4]+H[5]+H[6]-H[7]+H[8]+H[9]+H[10]+H[11]+J[0]-J[1]+J[2]+J[3]+
    J[4]+J[5]-J[6]+J[7]+J[8]+J[9]+J[10]-J[11]+J[12]+J[13]+J[14]+J[15]-J[16]+J[17]+J[18]+J[19]+J[20]-J[21]-J[22]-J[23]-J[24]+
    J[25]-J[26]-J[27]-J[28]-J[29]+J[30]+J[31]+J[32]-J[33]+J[34]+J[35]+J[36]+J[37]+J[38]+J[39]-J[40]+J[41]+
    J[42]+J[43]+J[44]+J[45]-J[46]+J[47]+J[48]+J[49]+J[50]-J[51]+J[52]+J[53]+J[54]+J[55]-J[56]-J[57]-J[58]-J[59]+
    J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]+H[1]-H[2]+H[3]+H[4]+H[5]+H[6]-H[7]+H[8]+H[9]+H[10]-H[11]+
    J[0]-J[1]+J[2]+J[3]+J[4]+J[5]-J[6]+J[7]+J[8]+J[9]-J[10]-J[11]+J[12]+J[13]+J[14]+J[15]-J[16]+J[17]+J[18]+
    J[19]-J[20]-J[21]-J[22]-J[23]-J[24]+J[25]-J[26]-J[27]-J[28]+J[29]+J[30]+J[31]+J[32]-J[33]+J[34]+J[35]+
    J[36]-J[37]+J[38]+J[39]-J[40]+J[41]+J[42]+J[43]-J[44]+J[45]-J[46]+J[47]+J[48]+J[49]-J[50]-J[51]+J[52]+
    J[53]+J[54]-J[55]-J[56]-J[57]-J[58]+J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]+H[1]-H[2]+H[3]+
    H[4]+H[5]+H[6]-H[7]+H[8]+H[9]-H[10]+H[11]+J[0]-J[1]+J[2]+J[3]+J[4]+J[5]-J[6]+J[7]+J[8]-J[9]+J[10]-J[11]+
    J[12]+J[13]+J[14]+J[15]-J[16]+J[17]+J[18]-J[19]+J[20]-J[21]-J[22]-J[23]-J[24]+J[25]-J[26]-J[27]+J[28]-J[29]+
    J[30]+J[31]+J[32]-J[33]+J[34]+J[35]-J[36]+J[37]+J[38]+J[39]-J[40]+J[41]+J[42]-J[43]+J[44]+J[45]-J[46]+
    J[47]+J[48]-J[49]+J[50]-J[51]+J[52]+J[53]-J[54]+J[55]-J[56]-J[57]+J[58]-J[59]+J[60]-J[61]+J[62]-J[63]+
    J[64]-J[65], +H[0]+H[1]-H[2]+H[3]+H[4]+H[5]+H[6]-H[7]+H[8]+H[9]-H[10]-H[11]+J[0]-J[1]+J[2]+J[3]+J[4]+
    J[5]-J[6]+J[7]+J[8]-J[9]-J[10]-J[11]+J[12]+J[13]+J[14]+J[15]-J[16]+J[17]+J[18]-J[19]-J[20]-J[21]-J[22]-J[23]-J[24]+
    J[25]-J[26]-J[27]+J[28]+J[29]+J[30]+J[31]+J[32]-J[33]+J[34]+J[35]-J[36]-J[37]+J[38]+J[39]-J[40]+J[41]+
    J[42]-J[43]-J[44]+J[45]-J[46]+J[47]+J[48]-J[49]-J[50]-J[51]+J[52]+J[53]-J[54]-J[55]-J[56]-J[57]+J[58]+
    J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]+H[1]-H[2]+H[3]+H[4]+H[5]+H[6]-H[7]+H[8]-H[9]+H[10]+
    H[11]+J[0]-J[1]+J[2]+J[3]+J[4]+J[5]-J[6]+J[7]-J[8]+J[9]+J[10]-J[11]+J[12]+J[13]+J[14]+J[15]-J[16]+J[17]-J[18]+
    J[19]+J[20]-J[21]-J[22]-J[23]-J[24]+J[25]-J[26]+J[27]-J[28]-J[29]+J[30]+J[31]+J[32]-J[33]+J[34]-J[35]+
    J[36]+J[37]+J[38]+J[39]-J[40]+J[41]-J[42]+J[43]+J[44]+J[45]-J[46]+J[47]-J[48]+J[49]+J[50]-J[51]+J[52]-J[53]+
    J[54]+J[55]-J[56]+J[57]-J[58]-J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]+H[1]-H[2]+H[3]+H[4]+H[5]+
    H[6]-H[7]+H[8]-H[9]+H[10]-H[11]+J[0]-J[1]+J[2]+J[3]+J[4]+J[5]-J[6]+J[7]-J[8]+J[9]-J[10]-J[11]+J[12]+
    J[13]+J[14]+J[15]-J[16]+J[17]-J[18]+J[19]-J[20]-J[21]-J[22]-J[23]-J[24]+J[25]-J[26]+J[27]-J[28]+J[29]+
    J[30]+J[31]+J[32]-J[33]+J[34]-J[35]+J[36]-J[37]+J[38]+J[39]-J[40]+J[41]-J[42]+J[43]-J[44]+J[45]-J[46]+
    J[47]-J[48]+J[49]-J[50]-J[51]+J[52]-J[53]+J[54]-J[55]-J[56]+J[57]-J[58]+J[59]-J[60]+J[61]-J[62]-J[63]+
    J[64]-J[65], +H[0]+H[1]-H[2]+H[3]+H[4]+H[5]+H[6]-H[7]+H[8]-H[9]-H[10]+H[11]+J[0]-J[1]+J[2]+J[3]+J[4]+
    J[5]-J[6]+J[7]-J[8]-J[9]+J[10]-J[11]+J[12]+J[13]+J[14]+J[15]-J[16]+J[17]-J[18]-J[19]+J[20]-J[21]-J[22]-J[23]-J[24]+
    J[25]-J[26]+J[27]+J[28]-J[29]+J[30]+J[31]+J[32]-J[33]+J[34]-J[35]-J[36]+J[37]+J[38]+J[39]-J[40]+J[41]-J[42]-J[43]+
    J[44]+J[45]-J[46]+J[47]-J[48]-J[49]+J[50]-J[51]+J[52]-J[53]-J[54]+J[55]-J[56]+J[57]+J[58]-J[59]-J[60]-J[61]+
    J[62]+J[63]-J[64]-J[65], +H[0]+H[1]-H[2]+H[3]+H[4]+H[5]+H[6]-H[7]+H[8]-H[9]-H[10]-H[11]+J[0]-J[1]+J[2]+
    J[3]+J[4]+J[5]-J[6]+J[7]-J[8]-J[9]-J[10]-J[11]+J[12]+J[13]+J[14]+J[15]-J[16]+J[17]-J[18]-J[19]-J[20]-J[21]-J[22]-J[23]-J[24]+
    J[25]-J[26]+J[27]+J[28]+J[29]+J[30]+J[31]+J[32]-J[33]+J[34]-J[35]-J[36]-J[37]+J[38]+J[39]-J[40]+J[41]-J[42]-J[43]-J[44]+
    J[45]-J[46]+J[47]-J[48]-J[49]-J[50]-J[51]+J[52]-J[53]-J[54]-J[55]-J[56]+J[57]+J[58]+J[59]-J[60]-J[61]-J[62]+
    J[63]+J[64]+J[65], +H[0]+H[1]-H[2]+H[3]+H[4]+H[5]+H[6]-H[7]-H[8]+H[9]+H[10]+H[11]+J[0]-J[1]+J[2]+J[3]+
    J[4]+J[5]-J[6]-J[7]+J[8]+J[9]+J[10]-J[11]+J[12]+J[13]+J[14]+J[15]-J[16]-J[17]+J[18]+J[19]+J[20]-J[21]-J[22]-J[23]-J[24]+
    J[25]+J[26]-J[27]-J[28]-J[29]+J[30]+J[31]+J[32]-J[33]-J[34]+J[35]+J[36]+J[37]+J[38]+J[39]-J[40]-J[41]+
    J[42]+J[43]+J[44]+J[45]-J[46]-J[47]+J[48]+J[49]+J[50]-J[51]-J[52]+J[53]+J[54]+J[55]+J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+
    J[63]+J[64]+J[65], +H[0]+H[1]-H[2]+H[3]+H[4]+H[5]+H[6]-H[7]-H[8]+H[9]+H[10]-H[11]+J[0]-J[1]+J[2]+J[3]+
    J[4]+J[5]-J[6]-J[7]+J[8]+J[9]-J[10]-J[11]+J[12]+J[13]+J[14]+J[15]-J[16]-J[17]+J[18]+J[19]-J[20]-J[21]-J[22]-J[23]-J[24]+
    J[25]+J[26]-J[27]-J[28]+J[29]+J[30]+J[31]+J[32]-J[33]-J[34]+J[35]+J[36]-J[37]+J[38]+J[39]-J[40]-J[41]+
    J[42]+J[43]-J[44]+J[45]-J[46]-J[47]+J[48]+J[49]-J[50]-J[51]-J[52]+J[53]+J[54]-J[55]+J[56]-J[57]-J[58]+
    J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]+H[1]-H[2]+H[3]+H[4]+H[5]+H[6]-H[7]-H[8]+H[9]-H[10]+
    H[11]+J[0]-J[1]+J[2]+J[3]+J[4]+J[5]-J[6]-J[7]+J[8]-J[9]+J[10]-J[11]+J[12]+J[13]+J[14]+J[15]-J[16]-J[17]+
    J[18]-J[19]+J[20]-J[21]-J[22]-J[23]-J[24]+J[25]+J[26]-J[27]+J[28]-J[29]+J[30]+J[31]+J[32]-J[33]-J[34]+
    J[35]-J[36]+J[37]+J[38]+J[39]-J[40]-J[41]+J[42]-J[43]+J[44]+J[45]-J[46]-J[47]+J[48]-J[49]+J[50]-J[51]-J[52]+
    J[53]-J[54]+J[55]+J[56]-J[57]+J[58]-J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]+H[1]-H[2]+H[3]+
    H[4]+H[5]+H[6]-H[7]-H[8]+H[9]-H[10]-H[11]+J[0]-J[1]+J[2]+J[3]+J[4]+J[5]-J[6]-J[7]+J[8]-J[9]-J[10]-J[11]+
    J[12]+J[13]+J[14]+J[15]-J[16]-J[17]+J[18]-J[19]-J[20]-J[21]-J[22]-J[23]-J[24]+J[25]+J[26]-J[27]+J[28]+
    J[29]+J[30]+J[31]+J[32]-J[33]-J[34]+J[35]-J[36]-J[37]+J[38]+J[39]-J[40]-J[41]+J[42]-J[43]-J[44]+J[45]-J[46]-J[47]+
    J[48]-J[49]-J[50]-J[51]-J[52]+J[53]-J[54]-J[55]+J[56]-J[57]+J[58]+J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+
    J[65], +H[0]+H[1]-H[2]+H[3]+H[4]+H[5]+H[6]-H[7]-H[8]-H[9]+H[10]+H[11]+J[0]-J[1]+J[2]+J[3]+J[4]+J[5]-J[6]-J[7]-J[8]+
    J[9]+J[10]-J[11]+J[12]+J[13]+J[14]+J[15]-J[16]-J[17]-J[18]+J[19]+J[20]-J[21]-J[22]-J[23]-J[24]+J[25]+
    J[26]+J[27]-J[28]-J[29]+J[30]+J[31]+J[32]-J[33]-J[34]-J[35]+J[36]+J[37]+J[38]+J[39]-J[40]-J[41]-J[42]+
    J[43]+J[44]+J[45]-J[46]-J[47]-J[48]+J[49]+J[50]-J[51]-J[52]-J[53]+J[54]+J[55]+J[56]+J[57]-J[58]-J[59]+
    J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]+H[1]-H[2]+H[3]+H[4]+H[5]+H[6]-H[7]-H[8]-H[9]+H[10]-H[11]+
    J[0]-J[1]+J[2]+J[3]+J[4]+J[5]-J[6]-J[7]-J[8]+J[9]-J[10]-J[11]+J[12]+J[13]+J[14]+J[15]-J[16]-J[17]-J[18]+
    J[19]-J[20]-J[21]-J[22]-J[23]-J[24]+J[25]+J[26]+J[27]-J[28]+J[29]+J[30]+J[31]+J[32]-J[33]-J[34]-J[35]+
    J[36]-J[37]+J[38]+J[39]-J[40]-J[41]-J[42]+J[43]-J[44]+J[45]-J[46]-J[47]-J[48]+J[49]-J[50]-J[51]-J[52]-J[53]+
    J[54]-J[55]+J[56]+J[57]-J[58]+J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]+H[1]-H[2]+H[3]+H[4]+H[5]+
    H[6]-H[7]-H[8]-H[9]-H[10]+H[11]+J[0]-J[1]+J[2]+J[3]+J[4]+J[5]-J[6]-J[7]-J[8]-J[9]+J[10]-J[11]+J[12]+
    J[13]+J[14]+J[15]-J[16]-J[17]-J[18]-J[19]+J[20]-J[21]-J[22]-J[23]-J[24]+J[25]+J[26]+J[27]+J[28]-J[29]+
    J[30]+J[31]+J[32]-J[33]-J[34]-J[35]-J[36]+J[37]+J[38]+J[39]-J[40]-J[41]-J[42]-J[43]+J[44]+J[45]-J[46]-J[47]-J[48]-J[49]+
    J[50]-J[51]-J[52]-J[53]-J[54]+J[55]+J[56]+J[57]+J[58]-J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]+
    H[1]-H[2]+H[3]+H[4]+H[5]+H[6]-H[7]-H[8]-H[9]-H[10]-H[11]+J[0]-J[1]+J[2]+J[3]+J[4]+J[5]-J[6]-J[7]-J[8]-J[9]-J[10]-J[11]+
    J[12]+J[13]+J[14]+J[15]-J[16]-J[17]-J[18]-J[19]-J[20]-J[21]-J[22]-J[23]-J[24]+J[25]+J[26]+J[27]+J[28]+
    J[29]+J[30]+J[31]+J[32]-J[33]-J[34]-J[35]-J[36]-J[37]+J[38]+J[39]-J[40]-J[41]-J[42]-J[43]-J[44]+J[45]-J[46]-J[47]-J[48]-J[49]-J[50]-J[51]-J[52]-J[53]-J[54]-J[55]+
    J[56]+J[57]+J[58]+J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]+H[1]-H[2]+H[3]+H[4]+H[5]-H[6]+H[7]+
    H[8]+H[9]+H[10]+H[11]+J[0]-J[1]+J[2]+J[3]+J[4]-J[5]+J[6]+J[7]+J[8]+J[9]+J[10]-J[11]+J[12]+J[13]+J[14]-J[15]+
    J[16]+J[17]+J[18]+J[19]+J[20]-J[21]-J[22]-J[23]+J[24]-J[25]-J[26]-J[27]-J[28]-J[29]+J[30]+J[31]-J[32]+
    J[33]+J[34]+J[35]+J[36]+J[37]+J[38]-J[39]+J[40]+J[41]+J[42]+J[43]+J[44]-J[45]+J[46]+J[47]+J[48]+J[49]+
    J[50]-J[51]-J[52]-J[53]-J[54]-J[55]+J[56]+J[57]+J[58]+J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]+
    H[1]-H[2]+H[3]+H[4]+H[5]-H[6]+H[7]+H[8]+H[9]+H[10]-H[11]+J[0]-J[1]+J[2]+J[3]+J[4]-J[5]+J[6]+J[7]+J[8]+
    J[9]-J[10]-J[11]+J[12]+J[13]+J[14]-J[15]+J[16]+J[17]+J[18]+J[19]-J[20]-J[21]-J[22]-J[23]+J[24]-J[25]-J[26]-J[27]-J[28]+
    J[29]+J[30]+J[31]-J[32]+J[33]+J[34]+J[35]+J[36]-J[37]+J[38]-J[39]+J[40]+J[41]+J[42]+J[43]-J[44]-J[45]+
    J[46]+J[47]+J[48]+J[49]-J[50]-J[51]-J[52]-J[53]-J[54]+J[55]+J[56]+J[57]+J[58]-J[59]+J[60]+J[61]-J[62]+
    J[63]-J[64]-J[65], +H[0]+H[1]-H[2]+H[3]+H[4]+H[5]-H[6]+H[7]+H[8]+H[9]-H[10]+H[11]+J[0]-J[1]+J[2]+J[3]+
    J[4]-J[5]+J[6]+J[7]+J[8]-J[9]+J[10]-J[11]+J[12]+J[13]+J[14]-J[15]+J[16]+J[17]+J[18]-J[19]+J[20]-J[21]-J[22]-J[23]+
    J[24]-J[25]-J[26]-J[27]+J[28]-J[29]+J[30]+J[31]-J[32]+J[33]+J[34]+J[35]-J[36]+J[37]+J[38]-J[39]+J[40]+
    J[41]+J[42]-J[43]+J[44]-J[45]+J[46]+J[47]+J[48]-J[49]+J[50]-J[51]-J[52]-J[53]+J[54]-J[55]+J[56]+J[57]-J[58]+
    J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]+H[1]-H[2]+H[3]+H[4]+H[5]-H[6]+H[7]+H[8]+H[9]-H[10]-H[11]+
    J[0]-J[1]+J[2]+J[3]+J[4]-J[5]+J[6]+J[7]+J[8]-J[9]-J[10]-J[11]+J[12]+J[13]+J[14]-J[15]+J[16]+J[17]+J[18]-J[19]-J[20]-J[21]-J[22]-J[23]+
    J[24]-J[25]-J[26]-J[27]+J[28]+J[29]+J[30]+J[31]-J[32]+J[33]+J[34]+J[35]-J[36]-J[37]+J[38]-J[39]+J[40]+
    J[41]+J[42]-J[43]-J[44]-J[45]+J[46]+J[47]+J[48]-J[49]-J[50]-J[51]-J[52]-J[53]+J[54]+J[55]+J[56]+J[57]-J[58]-J[59]+
    J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]+H[1]-H[2]+H[3]+H[4]+H[5]-H[6]+H[7]+H[8]-H[9]+H[10]+H[11]+
    J[0]-J[1]+J[2]+J[3]+J[4]-J[5]+J[6]+J[7]-J[8]+J[9]+J[10]-J[11]+J[12]+J[13]+J[14]-J[15]+J[16]+J[17]-J[18]+
    J[19]+J[20]-J[21]-J[22]-J[23]+J[24]-J[25]-J[26]+J[27]-J[28]-J[29]+J[30]+J[31]-J[32]+J[33]+J[34]-J[35]+
    J[36]+J[37]+J[38]-J[39]+J[40]+J[41]-J[42]+J[43]+J[44]-J[45]+J[46]+J[47]-J[48]+J[49]+J[50]-J[51]-J[52]+
    J[53]-J[54]-J[55]+J[56]-J[57]+J[58]+J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]+H[1]-H[2]+H[3]+
    H[4]+H[5]-H[6]+H[7]+H[8]-H[9]+H[10]-H[11]+J[0]-J[1]+J[2]+J[3]+J[4]-J[5]+J[6]+J[7]-J[8]+J[9]-J[10]-J[11]+
    J[12]+J[13]+J[14]-J[15]+J[16]+J[17]-J[18]+J[19]-J[20]-J[21]-J[22]-J[23]+J[24]-J[25]-J[26]+J[27]-J[28]+
    J[29]+J[30]+J[31]-J[32]+J[33]+J[34]-J[35]+J[36]-J[37]+J[38]-J[39]+J[40]+J[41]-J[42]+J[43]-J[44]-J[45]+
    J[46]+J[47]-J[48]+J[49]-J[50]-J[51]-J[52]+J[53]-J[54]+J[55]+J[56]-J[57]+J[58]-J[59]-J[60]+J[61]-J[62]-J[63]+
    J[64]-J[65], +H[0]+H[1]-H[2]+H[3]+H[4]+H[5]-H[6]+H[7]+H[8]-H[9]-H[10]+H[11]+J[0]-J[1]+J[2]+J[3]+J[4]-J[5]+
    J[6]+J[7]-J[8]-J[9]+J[10]-J[11]+J[12]+J[13]+J[14]-J[15]+J[16]+J[17]-J[18]-J[19]+J[20]-J[21]-J[22]-J[23]+
    J[24]-J[25]-J[26]+J[27]+J[28]-J[29]+J[30]+J[31]-J[32]+J[33]+J[34]-J[35]-J[36]+J[37]+J[38]-J[39]+J[40]+
    J[41]-J[42]-J[43]+J[44]-J[45]+J[46]+J[47]-J[48]-J[49]+J[50]-J[51]-J[52]+J[53]+J[54]-J[55]+J[56]-J[57]-J[58]+
    J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]+H[1]-H[2]+H[3]+H[4]+H[5]-H[6]+H[7]+H[8]-H[9]-H[10]-H[11]+
    J[0]-J[1]+J[2]+J[3]+J[4]-J[5]+J[6]+J[7]-J[8]-J[9]-J[10]-J[11]+J[12]+J[13]+J[14]-J[15]+J[16]+J[17]-J[18]-J[19]-J[20]-J[21]-J[22]-J[23]+
    J[24]-J[25]-J[26]+J[27]+J[28]+J[29]+J[30]+J[31]-J[32]+J[33]+J[34]-J[35]-J[36]-J[37]+J[38]-J[39]+J[40]+
    J[41]-J[42]-J[43]-J[44]-J[45]+J[46]+J[47]-J[48]-J[49]-J[50]-J[51]-J[52]+J[53]+J[54]+J[55]+J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+
    J[63]+J[64]+J[65], +H[0]+H[1]-H[2]+H[3]+H[4]+H[5]-H[6]+H[7]-H[8]+H[9]+H[10]+H[11]+J[0]-J[1]+J[2]+J[3]+
    J[4]-J[5]+J[6]-J[7]+J[8]+J[9]+J[10]-J[11]+J[12]+J[13]+J[14]-J[15]+J[16]-J[17]+J[18]+J[19]+J[20]-J[21]-J[22]-J[23]+
    J[24]-J[25]+J[26]-J[27]-J[28]-J[29]+J[30]+J[31]-J[32]+J[33]-J[34]+J[35]+J[36]+J[37]+J[38]-J[39]+J[40]-J[41]+
    J[42]+J[43]+J[44]-J[45]+J[46]-J[47]+J[48]+J[49]+J[50]-J[51]+J[52]-J[53]-J[54]-J[55]-J[56]+J[57]+J[58]+
    J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]+H[1]-H[2]+H[3]+H[4]+H[5]-H[6]+H[7]-H[8]+H[9]+H[10]-H[11]+
    J[0]-J[1]+J[2]+J[3]+J[4]-J[5]+J[6]-J[7]+J[8]+J[9]-J[10]-J[11]+J[12]+J[13]+J[14]-J[15]+J[16]-J[17]+J[18]+
    J[19]-J[20]-J[21]-J[22]-J[23]+J[24]-J[25]+J[26]-J[27]-J[28]+J[29]+J[30]+J[31]-J[32]+J[33]-J[34]+J[35]+
    J[36]-J[37]+J[38]-J[39]+J[40]-J[41]+J[42]+J[43]-J[44]-J[45]+J[46]-J[47]+J[48]+J[49]-J[50]-J[51]+J[52]-J[53]-J[54]+
    J[55]-J[56]+J[57]+J[58]-J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]+H[1]-H[2]+H[3]+H[4]+H[5]-H[6]+
    H[7]-H[8]+H[9]-H[10]+H[11]+J[0]-J[1]+J[2]+J[3]+J[4]-J[5]+J[6]-J[7]+J[8]-J[9]+J[10]-J[11]+J[12]+J[13]+
    J[14]-J[15]+J[16]-J[17]+J[18]-J[19]+J[20]-J[21]-J[22]-J[23]+J[24]-J[25]+J[26]-J[27]+J[28]-J[29]+J[30]+
    J[31]-J[32]+J[33]-J[34]+J[35]-J[36]+J[37]+J[38]-J[39]+J[40]-J[41]+J[42]-J[43]+J[44]-J[45]+J[46]-J[47]+
    J[48]-J[49]+J[50]-J[51]+J[52]-J[53]+J[54]-J[55]-J[56]+J[57]-J[58]+J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +
    H[0]+H[1]-H[2]+H[3]+H[4]+H[5]-H[6]+H[7]-H[8]+H[9]-H[10]-H[11]+J[0]-J[1]+J[2]+J[3]+J[4]-J[5]+J[6]-J[7]+
    J[8]-J[9]-J[10]-J[11]+J[12]+J[13]+J[14]-J[15]+J[16]-J[17]+J[18]-J[19]-J[20]-J[21]-J[22]-J[23]+J[24]-J[25]+
    J[26]-J[27]+J[28]+J[29]+J[30]+J[31]-J[32]+J[33]-J[34]+J[35]-J[36]-J[37]+J[38]-J[39]+J[40]-J[41]+J[42]-J[43]-J[44]-J[45]+
    J[46]-J[47]+J[48]-J[49]-J[50]-J[51]+J[52]-J[53]+J[54]+J[55]-J[56]+J[57]-J[58]-J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+
    J[65], +H[0]+H[1]-H[2]+H[3]+H[4]+H[5]-H[6]+H[7]-H[8]-H[9]+H[10]+H[11]+J[0]-J[1]+J[2]+J[3]+J[4]-J[5]+
    J[6]-J[7]-J[8]+J[9]+J[10]-J[11]+J[12]+J[13]+J[14]-J[15]+J[16]-J[17]-J[18]+J[19]+J[20]-J[21]-J[22]-J[23]+
    J[24]-J[25]+J[26]+J[27]-J[28]-J[29]+J[30]+J[31]-J[32]+J[33]-J[34]-J[35]+J[36]+J[37]+J[38]-J[39]+J[40]-J[41]-J[42]+
    J[43]+J[44]-J[45]+J[46]-J[47]-J[48]+J[49]+J[50]-J[51]+J[52]+J[53]-J[54]-J[55]-J[56]-J[57]+J[58]+J[59]+
    J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]+H[1]-H[2]+H[3]+H[4]+H[5]-H[6]+H[7]-H[8]-H[9]+H[10]-H[11]+
    J[0]-J[1]+J[2]+J[3]+J[4]-J[5]+J[6]-J[7]-J[8]+J[9]-J[10]-J[11]+J[12]+J[13]+J[14]-J[15]+J[16]-J[17]-J[18]+
    J[19]-J[20]-J[21]-J[22]-J[23]+J[24]-J[25]+J[26]+J[27]-J[28]+J[29]+J[30]+J[31]-J[32]+J[33]-J[34]-J[35]+
    J[36]-J[37]+J[38]-J[39]+J[40]-J[41]-J[42]+J[43]-J[44]-J[45]+J[46]-J[47]-J[48]+J[49]-J[50]-J[51]+J[52]+
    J[53]-J[54]+J[55]-J[56]-J[57]+J[58]-J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]+H[1]-H[2]+H[3]+
    H[4]+H[5]-H[6]+H[7]-H[8]-H[9]-H[10]+H[11]+J[0]-J[1]+J[2]+J[3]+J[4]-J[5]+J[6]-J[7]-J[8]-J[9]+J[10]-J[11]+
    J[12]+J[13]+J[14]-J[15]+J[16]-J[17]-J[18]-J[19]+J[20]-J[21]-J[22]-J[23]+J[24]-J[25]+J[26]+J[27]+J[28]-J[29]+
    J[30]+J[31]-J[32]+J[33]-J[34]-J[35]-J[36]+J[37]+J[38]-J[39]+J[40]-J[41]-J[42]-J[43]+J[44]-J[45]+J[46]-J[47]-J[48]-J[49]+
    J[50]-J[51]+J[52]+J[53]+J[54]-J[55]-J[56]-J[57]-J[58]+J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]+
    H[1]-H[2]+H[3]+H[4]+H[5]-H[6]+H[7]-H[8]-H[9]-H[10]-H[11]+J[0]-J[1]+J[2]+J[3]+J[4]-J[5]+J[6]-J[7]-J[8]-J[9]-J[10]-J[11]+
    J[12]+J[13]+J[14]-J[15]+J[16]-J[17]-J[18]-J[19]-J[20]-J[21]-J[22]-J[23]+J[24]-J[25]+J[26]+J[27]+J[28]+
    J[29]+J[30]+J[31]-J[32]+J[33]-J[34]-J[35]-J[36]-J[37]+J[38]-J[39]+J[40]-J[41]-J[42]-J[43]-J[44]-J[45]+
    J[46]-J[47]-J[48]-J[49]-J[50]-J[51]+J[52]+J[53]+J[54]+J[55]-J[56]-J[57]-J[58]-J[59]+J[60]+J[61]+J[62]+
    J[63]+J[64]+J[65], +H[0]+H[1]-H[2]+H[3]+H[4]+H[5]-H[6]-H[7]+H[8]+H[9]+H[10]+H[11]+J[0]-J[1]+J[2]+J[3]+
    J[4]-J[5]-J[6]+J[7]+J[8]+J[9]+J[10]-J[11]+J[12]+J[13]+J[14]-J[15]-J[16]+J[17]+J[18]+J[19]+J[20]-J[21]-J[22]-J[23]+
    J[24]+J[25]-J[26]-J[27]-J[28]-J[29]+J[30]+J[31]-J[32]-J[33]+J[34]+J[35]+J[36]+J[37]+J[38]-J[39]-J[40]+
    J[41]+J[42]+J[43]+J[44]-J[45]-J[46]+J[47]+J[48]+J[49]+J[50]+J[51]-J[52]-J[53]-J[54]-J[55]-J[56]-J[57]-J[58]-J[59]+
    J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]+H[1]-H[2]+H[3]+H[4]+H[5]-H[6]-H[7]+H[8]+H[9]+H[10]-H[11]+
    J[0]-J[1]+J[2]+J[3]+J[4]-J[5]-J[6]+J[7]+J[8]+J[9]-J[10]-J[11]+J[12]+J[13]+J[14]-J[15]-J[16]+J[17]+J[18]+
    J[19]-J[20]-J[21]-J[22]-J[23]+J[24]+J[25]-J[26]-J[27]-J[28]+J[29]+J[30]+J[31]-J[32]-J[33]+J[34]+J[35]+
    J[36]-J[37]+J[38]-J[39]-J[40]+J[41]+J[42]+J[43]-J[44]-J[45]-J[46]+J[47]+J[48]+J[49]-J[50]+J[51]-J[52]-J[53]-J[54]+
    J[55]-J[56]-J[57]-J[58]+J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]+H[1]-H[2]+H[3]+H[4]+H[5]-H[6]-H[7]+
    H[8]+H[9]-H[10]+H[11]+J[0]-J[1]+J[2]+J[3]+J[4]-J[5]-J[6]+J[7]+J[8]-J[9]+J[10]-J[11]+J[12]+J[13]+J[14]-J[15]-J[16]+
    J[17]+J[18]-J[19]+J[20]-J[21]-J[22]-J[23]+J[24]+J[25]-J[26]-J[27]+J[28]-J[29]+J[30]+J[31]-J[32]-J[33]+
    J[34]+J[35]-J[36]+J[37]+J[38]-J[39]-J[40]+J[41]+J[42]-J[43]+J[44]-J[45]-J[46]+J[47]+J[48]-J[49]+J[50]+
    J[51]-J[52]-J[53]+J[54]-J[55]-J[56]-J[57]+J[58]-J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]+H[1]-H[2]+
    H[3]+H[4]+H[5]-H[6]-H[7]+H[8]+H[9]-H[10]-H[11]+J[0]-J[1]+J[2]+J[3]+J[4]-J[5]-J[6]+J[7]+J[8]-J[9]-J[10]-J[11]+
    J[12]+J[13]+J[14]-J[15]-J[16]+J[17]+J[18]-J[19]-J[20]-J[21]-J[22]-J[23]+J[24]+J[25]-J[26]-J[27]+J[28]+
    J[29]+J[30]+J[31]-J[32]-J[33]+J[34]+J[35]-J[36]-J[37]+J[38]-J[39]-J[40]+J[41]+J[42]-J[43]-J[44]-J[45]-J[46]+
    J[47]+J[48]-J[49]-J[50]+J[51]-J[52]-J[53]+J[54]+J[55]-J[56]-J[57]+J[58]+J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+
    J[65], +H[0]+H[1]-H[2]+H[3]+H[4]+H[5]-H[6]-H[7]+H[8]-H[9]+H[10]+H[11]+J[0]-J[1]+J[2]+J[3]+J[4]-J[5]-J[6]+
    J[7]-J[8]+J[9]+J[10]-J[11]+J[12]+J[13]+J[14]-J[15]-J[16]+J[17]-J[18]+J[19]+J[20]-J[21]-J[22]-J[23]+J[24]+
    J[25]-J[26]+J[27]-J[28]-J[29]+J[30]+J[31]-J[32]-J[33]+J[34]-J[35]+J[36]+J[37]+J[38]-J[39]-J[40]+J[41]-J[42]+
    J[43]+J[44]-J[45]-J[46]+J[47]-J[48]+J[49]+J[50]+J[51]-J[52]+J[53]-J[54]-J[55]-J[56]+J[57]-J[58]-J[59]-J[60]+
    J[61]+J[62]-J[63]-J[64]+J[65], +H[0]+H[1]-H[2]+H[3]+H[4]+H[5]-H[6]-H[7]+H[8]-H[9]+H[10]-H[11]+J[0]-J[1]+
    J[2]+J[3]+J[4]-J[5]-J[6]+J[7]-J[8]+J[9]-J[10]-J[11]+J[12]+J[13]+J[14]-J[15]-J[16]+J[17]-J[18]+J[19]-J[20]-J[21]-J[22]-J[23]+
    J[24]+J[25]-J[26]+J[27]-J[28]+J[29]+J[30]+J[31]-J[32]-J[33]+J[34]-J[35]+J[36]-J[37]+J[38]-J[39]-J[40]+
    J[41]-J[42]+J[43]-J[44]-J[45]-J[46]+J[47]-J[48]+J[49]-J[50]+J[51]-J[52]+J[53]-J[54]+J[55]-J[56]+J[57]-J[58]+
    J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]+H[1]-H[2]+H[3]+H[4]+H[5]-H[6]-H[7]+H[8]-H[9]-H[10]+
    H[11]+J[0]-J[1]+J[2]+J[3]+J[4]-J[5]-J[6]+J[7]-J[8]-J[9]+J[10]-J[11]+J[12]+J[13]+J[14]-J[15]-J[16]+J[17]-J[18]-J[19]+
    J[20]-J[21]-J[22]-J[23]+J[24]+J[25]-J[26]+J[27]+J[28]-J[29]+J[30]+J[31]-J[32]-J[33]+J[34]-J[35]-J[36]+
    J[37]+J[38]-J[39]-J[40]+J[41]-J[42]-J[43]+J[44]-J[45]-J[46]+J[47]-J[48]-J[49]+J[50]+J[51]-J[52]+J[53]+
    J[54]-J[55]-J[56]+J[57]+J[58]-J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]+H[1]-H[2]+H[3]+H[4]+H[5]-H[6]-H[7]+
    H[8]-H[9]-H[10]-H[11]+J[0]-J[1]+J[2]+J[3]+J[4]-J[5]-J[6]+J[7]-J[8]-J[9]-J[10]-J[11]+J[12]+J[13]+J[14]-J[15]-J[16]+
    J[17]-J[18]-J[19]-J[20]-J[21]-J[22]-J[23]+J[24]+J[25]-J[26]+J[27]+J[28]+J[29]+J[30]+J[31]-J[32]-J[33]+
    J[34]-J[35]-J[36]-J[37]+J[38]-J[39]-J[40]+J[41]-J[42]-J[43]-J[44]-J[45]-J[46]+J[47]-J[48]-J[49]-J[50]+
    J[51]-J[52]+J[53]+J[54]+J[55]-J[56]+J[57]+J[58]+J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]+H[1]-H[2]+
    H[3]+H[4]+H[5]-H[6]-H[7]-H[8]+H[9]+H[10]+H[11]+J[0]-J[1]+J[2]+J[3]+J[4]-J[5]-J[6]-J[7]+J[8]+J[9]+J[10]-J[11]+
    J[12]+J[13]+J[14]-J[15]-J[16]-J[17]+J[18]+J[19]+J[20]-J[21]-J[22]-J[23]+J[24]+J[25]+J[26]-J[27]-J[28]-J[29]+
    J[30]+J[31]-J[32]-J[33]-J[34]+J[35]+J[36]+J[37]+J[38]-J[39]-J[40]-J[41]+J[42]+J[43]+J[44]-J[45]-J[46]-J[47]+
    J[48]+J[49]+J[50]+J[51]+J[52]-J[53]-J[54]-J[55]+J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+
    J[65], +H[0]+H[1]-H[2]+H[3]+H[4]+H[5]-H[6]-H[7]-H[8]+H[9]+H[10]-H[11]+J[0]-J[1]+J[2]+J[3]+J[4]-J[5]-J[6]-J[7]+
    J[8]+J[9]-J[10]-J[11]+J[12]+J[13]+J[14]-J[15]-J[16]-J[17]+J[18]+J[19]-J[20]-J[21]-J[22]-J[23]+J[24]+
    J[25]+J[26]-J[27]-J[28]+J[29]+J[30]+J[31]-J[32]-J[33]-J[34]+J[35]+J[36]-J[37]+J[38]-J[39]-J[40]-J[41]+
    J[42]+J[43]-J[44]-J[45]-J[46]-J[47]+J[48]+J[49]-J[50]+J[51]+J[52]-J[53]-J[54]+J[55]+J[56]-J[57]-J[58]+
    J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]+H[1]-H[2]+H[3]+H[4]+H[5]-H[6]-H[7]-H[8]+H[9]-H[10]+
    H[11]+J[0]-J[1]+J[2]+J[3]+J[4]-J[5]-J[6]-J[7]+J[8]-J[9]+J[10]-J[11]+J[12]+J[13]+J[14]-J[15]-J[16]-J[17]+
    J[18]-J[19]+J[20]-J[21]-J[22]-J[23]+J[24]+J[25]+J[26]-J[27]+J[28]-J[29]+J[30]+J[31]-J[32]-J[33]-J[34]+
    J[35]-J[36]+J[37]+J[38]-J[39]-J[40]-J[41]+J[42]-J[43]+J[44]-J[45]-J[46]-J[47]+J[48]-J[49]+J[50]+J[51]+
    J[52]-J[53]+J[54]-J[55]+J[56]-J[57]+J[58]-J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]+H[1]-H[2]+
    H[3]+H[4]+H[5]-H[6]-H[7]-H[8]+H[9]-H[10]-H[11]+J[0]-J[1]+J[2]+J[3]+J[4]-J[5]-J[6]-J[7]+J[8]-J[9]-J[10]-J[11]+
    J[12]+J[13]+J[14]-J[15]-J[16]-J[17]+J[18]-J[19]-J[20]-J[21]-J[22]-J[23]+J[24]+J[25]+J[26]-J[27]+J[28]+
    J[29]+J[30]+J[31]-J[32]-J[33]-J[34]+J[35]-J[36]-J[37]+J[38]-J[39]-J[40]-J[41]+J[42]-J[43]-J[44]-J[45]-J[46]-J[47]+
    J[48]-J[49]-J[50]+J[51]+J[52]-J[53]+J[54]+J[55]+J[56]-J[57]+J[58]+J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+
    J[65], +H[0]+H[1]-H[2]+H[3]+H[4]+H[5]-H[6]-H[7]-H[8]-H[9]+H[10]+H[11]+J[0]-J[1]+J[2]+J[3]+J[4]-J[5]-J[6]-J[7]-J[8]+
    J[9]+J[10]-J[11]+J[12]+J[13]+J[14]-J[15]-J[16]-J[17]-J[18]+J[19]+J[20]-J[21]-J[22]-J[23]+J[24]+J[25]+
    J[26]+J[27]-J[28]-J[29]+J[30]+J[31]-J[32]-J[33]-J[34]-J[35]+J[36]+J[37]+J[38]-J[39]-J[40]-J[41]-J[42]+
    J[43]+J[44]-J[45]-J[46]-J[47]-J[48]+J[49]+J[50]+J[51]+J[52]+J[53]-J[54]-J[55]+J[56]+J[57]-J[58]-J[59]+
    J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]+H[1]-H[2]+H[3]+H[4]+H[5]-H[6]-H[7]-H[8]-H[9]+H[10]-H[11]+
    J[0]-J[1]+J[2]+J[3]+J[4]-J[5]-J[6]-J[7]-J[8]+J[9]-J[10]-J[11]+J[12]+J[13]+J[14]-J[15]-J[16]-J[17]-J[18]+
    J[19]-J[20]-J[21]-J[22]-J[23]+J[24]+J[25]+J[26]+J[27]-J[28]+J[29]+J[30]+J[31]-J[32]-J[33]-J[34]-J[35]+
    J[36]-J[37]+J[38]-J[39]-J[40]-J[41]-J[42]+J[43]-J[44]-J[45]-J[46]-J[47]-J[48]+J[49]-J[50]+J[51]+J[52]+
    J[53]-J[54]+J[55]+J[56]+J[57]-J[58]+J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]+H[1]-H[2]+H[3]+
    H[4]+H[5]-H[6]-H[7]-H[8]-H[9]-H[10]+H[11]+J[0]-J[1]+J[2]+J[3]+J[4]-J[5]-J[6]-J[7]-J[8]-J[9]+J[10]-J[11]+
    J[12]+J[13]+J[14]-J[15]-J[16]-J[17]-J[18]-J[19]+J[20]-J[21]-J[22]-J[23]+J[24]+J[25]+J[26]+J[27]+J[28]-J[29]+
    J[30]+J[31]-J[32]-J[33]-J[34]-J[35]-J[36]+J[37]+J[38]-J[39]-J[40]-J[41]-J[42]-J[43]+J[44]-J[45]-J[46]-J[47]-J[48]-J[49]+
    J[50]+J[51]+J[52]+J[53]+J[54]-J[55]+J[56]+J[57]+J[58]-J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]+
    H[1]-H[2]+H[3]+H[4]+H[5]-H[6]-H[7]-H[8]-H[9]-H[10]-H[11]+J[0]-J[1]+J[2]+J[3]+J[4]-J[5]-J[6]-J[7]-J[8]-J[9]-J[10]-J[11]+
    J[12]+J[13]+J[14]-J[15]-J[16]-J[17]-J[18]-J[19]-J[20]-J[21]-J[22]-J[23]+J[24]+J[25]+J[26]+J[27]+J[28]+
    J[29]+J[30]+J[31]-J[32]-J[33]-J[34]-J[35]-J[36]-J[37]+J[38]-J[39]-J[40]-J[41]-J[42]-J[43]-J[44]-J[45]-J[46]-J[47]-J[48]-J[49]-J[50]+
    J[51]+J[52]+J[53]+J[54]+J[55]+J[56]+J[57]+J[58]+J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]+H[1]-H[2]+
    H[3]+H[4]-H[5]+H[6]+H[7]+H[8]+H[9]+H[10]+H[11]+J[0]-J[1]+J[2]+J[3]-J[4]+J[5]+J[6]+J[7]+J[8]+J[9]+J[10]-J[11]+
    J[12]+J[13]-J[14]+J[15]+J[16]+J[17]+J[18]+J[19]+J[20]-J[21]-J[22]+J[23]-J[24]-J[25]-J[26]-J[27]-J[28]-J[29]+
    J[30]-J[31]+J[32]+J[33]+J[34]+J[35]+J[36]+J[37]-J[38]+J[39]+J[40]+J[41]+J[42]+J[43]+J[44]-J[45]-J[46]-J[47]-J[48]-J[49]-J[50]+
    J[51]+J[52]+J[53]+J[54]+J[55]+J[56]+J[57]+J[58]+J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]+H[1]-H[2]+
    H[3]+H[4]-H[5]+H[6]+H[7]+H[8]+H[9]+H[10]-H[11]+J[0]-J[1]+J[2]+J[3]-J[4]+J[5]+J[6]+J[7]+J[8]+J[9]-J[10]-J[11]+
    J[12]+J[13]-J[14]+J[15]+J[16]+J[17]+J[18]+J[19]-J[20]-J[21]-J[22]+J[23]-J[24]-J[25]-J[26]-J[27]-J[28]+
    J[29]+J[30]-J[31]+J[32]+J[33]+J[34]+J[35]+J[36]-J[37]-J[38]+J[39]+J[40]+J[41]+J[42]+J[43]-J[44]-J[45]-J[46]-J[47]-J[48]-J[49]+
    J[50]+J[51]+J[52]+J[53]+J[54]-J[55]+J[56]+J[57]+J[58]-J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]+
    H[1]-H[2]+H[3]+H[4]-H[5]+H[6]+H[7]+H[8]+H[9]-H[10]+H[11]+J[0]-J[1]+J[2]+J[3]-J[4]+J[5]+J[6]+J[7]+J[8]-J[9]+
    J[10]-J[11]+J[12]+J[13]-J[14]+J[15]+J[16]+J[17]+J[18]-J[19]+J[20]-J[21]-J[22]+J[23]-J[24]-J[25]-J[26]-J[27]+
    J[28]-J[29]+J[30]-J[31]+J[32]+J[33]+J[34]+J[35]-J[36]+J[37]-J[38]+J[39]+J[40]+J[41]+J[42]-J[43]+J[44]-J[45]-J[46]-J[47]-J[48]+
    J[49]-J[50]+J[51]+J[52]+J[53]-J[54]+J[55]+J[56]+J[57]-J[58]+J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +
    H[0]+H[1]-H[2]+H[3]+H[4]-H[5]+H[6]+H[7]+H[8]+H[9]-H[10]-H[11]+J[0]-J[1]+J[2]+J[3]-J[4]+J[5]+J[6]+J[7]+
    J[8]-J[9]-J[10]-J[11]+J[12]+J[13]-J[14]+J[15]+J[16]+J[17]+J[18]-J[19]-J[20]-J[21]-J[22]+J[23]-J[24]-J[25]-J[26]-J[27]+
    J[28]+J[29]+J[30]-J[31]+J[32]+J[33]+J[34]+J[35]-J[36]-J[37]-J[38]+J[39]+J[40]+J[41]+J[42]-J[43]-J[44]-J[45]-J[46]-J[47]-J[48]+
    J[49]+J[50]+J[51]+J[52]+J[53]-J[54]-J[55]+J[56]+J[57]-J[58]-J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +
    H[0]+H[1]-H[2]+H[3]+H[4]-H[5]+H[6]+H[7]+H[8]-H[9]+H[10]+H[11]+J[0]-J[1]+J[2]+J[3]-J[4]+J[5]+J[6]+J[7]-J[8]+
    J[9]+J[10]-J[11]+J[12]+J[13]-J[14]+J[15]+J[16]+J[17]-J[18]+J[19]+J[20]-J[21]-J[22]+J[23]-J[24]-J[25]-J[26]+
    J[27]-J[28]-J[29]+J[30]-J[31]+J[32]+J[33]+J[34]-J[35]+J[36]+J[37]-J[38]+J[39]+J[40]+J[41]-J[42]+J[43]+
    J[44]-J[45]-J[46]-J[47]+J[48]-J[49]-J[50]+J[51]+J[52]-J[53]+J[54]+J[55]+J[56]-J[57]+J[58]+J[59]-J[60]+
    J[61]+J[62]-J[63]-J[64]+J[65], +H[0]+H[1]-H[2]+H[3]+H[4]-H[5]+H[6]+H[7]+H[8]-H[9]+H[10]-H[11]+J[0]-J[1]+
    J[2]+J[3]-J[4]+J[5]+J[6]+J[7]-J[8]+J[9]-J[10]-J[11]+J[12]+J[13]-J[14]+J[15]+J[16]+J[17]-J[18]+J[19]-J[20]-J[21]-J[22]+
    J[23]-J[24]-J[25]-J[26]+J[27]-J[28]+J[29]+J[30]-J[31]+J[32]+J[33]+J[34]-J[35]+J[36]-J[37]-J[38]+J[39]+
    J[40]+J[41]-J[42]+J[43]-J[44]-J[45]-J[46]-J[47]+J[48]-J[49]+J[50]+J[51]+J[52]-J[53]+J[54]-J[55]+J[56]-J[57]+
    J[58]-J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]+H[1]-H[2]+H[3]+H[4]-H[5]+H[6]+H[7]+H[8]-H[9]-H[10]+
    H[11]+J[0]-J[1]+J[2]+J[3]-J[4]+J[5]+J[6]+J[7]-J[8]-J[9]+J[10]-J[11]+J[12]+J[13]-J[14]+J[15]+J[16]+J[17]-J[18]-J[19]+
    J[20]-J[21]-J[22]+J[23]-J[24]-J[25]-J[26]+J[27]+J[28]-J[29]+J[30]-J[31]+J[32]+J[33]+J[34]-J[35]-J[36]+
    J[37]-J[38]+J[39]+J[40]+J[41]-J[42]-J[43]+J[44]-J[45]-J[46]-J[47]+J[48]+J[49]-J[50]+J[51]+J[52]-J[53]-J[54]+
    J[55]+J[56]-J[57]-J[58]+J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]+H[1]-H[2]+H[3]+H[4]-H[5]+H[6]+
    H[7]+H[8]-H[9]-H[10]-H[11]+J[0]-J[1]+J[2]+J[3]-J[4]+J[5]+J[6]+J[7]-J[8]-J[9]-J[10]-J[11]+J[12]+J[13]-J[14]+
    J[15]+J[16]+J[17]-J[18]-J[19]-J[20]-J[21]-J[22]+J[23]-J[24]-J[25]-J[26]+J[27]+J[28]+J[29]+J[30]-J[31]+
    J[32]+J[33]+J[34]-J[35]-J[36]-J[37]-J[38]+J[39]+J[40]+J[41]-J[42]-J[43]-J[44]-J[45]-J[46]-J[47]+J[48]+
    J[49]+J[50]+J[51]+J[52]-J[53]-J[54]-J[55]+J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +
    H[0]+H[1]-H[2]+H[3]+H[4]-H[5]+H[6]+H[7]-H[8]+H[9]+H[10]+H[11]+J[0]-J[1]+J[2]+J[3]-J[4]+J[5]+J[6]-J[7]+
    J[8]+J[9]+J[10]-J[11]+J[12]+J[13]-J[14]+J[15]+J[16]-J[17]+J[18]+J[19]+J[20]-J[21]-J[22]+J[23]-J[24]-J[25]+
    J[26]-J[27]-J[28]-J[29]+J[30]-J[31]+J[32]+J[33]-J[34]+J[35]+J[36]+J[37]-J[38]+J[39]+J[40]-J[41]+J[42]+
    J[43]+J[44]-J[45]-J[46]+J[47]-J[48]-J[49]-J[50]+J[51]-J[52]+J[53]+J[54]+J[55]-J[56]+J[57]+J[58]+J[59]-J[60]-J[61]-J[62]+
    J[63]+J[64]+J[65], +H[0]+H[1]-H[2]+H[3]+H[4]-H[5]+H[6]+H[7]-H[8]+H[9]+H[10]-H[11]+J[0]-J[1]+J[2]+J[3]-J[4]+
    J[5]+J[6]-J[7]+J[8]+J[9]-J[10]-J[11]+J[12]+J[13]-J[14]+J[15]+J[16]-J[17]+J[18]+J[19]-J[20]-J[21]-J[22]+
    J[23]-J[24]-J[25]+J[26]-J[27]-J[28]+J[29]+J[30]-J[31]+J[32]+J[33]-J[34]+J[35]+J[36]-J[37]-J[38]+J[39]+
    J[40]-J[41]+J[42]+J[43]-J[44]-J[45]-J[46]+J[47]-J[48]-J[49]+J[50]+J[51]-J[52]+J[53]+J[54]-J[55]-J[56]+
    J[57]+J[58]-J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]+H[1]-H[2]+H[3]+H[4]-H[5]+H[6]+H[7]-H[8]+
    H[9]-H[10]+H[11]+J[0]-J[1]+J[2]+J[3]-J[4]+J[5]+J[6]-J[7]+J[8]-J[9]+J[10]-J[11]+J[12]+J[13]-J[14]+J[15]+
    J[16]-J[17]+J[18]-J[19]+J[20]-J[21]-J[22]+J[23]-J[24]-J[25]+J[26]-J[27]+J[28]-J[29]+J[30]-J[31]+J[32]+
    J[33]-J[34]+J[35]-J[36]+J[37]-J[38]+J[39]+J[40]-J[41]+J[42]-J[43]+J[44]-J[45]-J[46]+J[47]-J[48]+J[49]-J[50]+
    J[51]-J[52]+J[53]-J[54]+J[55]-J[56]+J[57]-J[58]+J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]+H[1]-H[2]+
    H[3]+H[4]-H[5]+H[6]+H[7]-H[8]+H[9]-H[10]-H[11]+J[0]-J[1]+J[2]+J[3]-J[4]+J[5]+J[6]-J[7]+J[8]-J[9]-J[10]-J[11]+
    J[12]+J[13]-J[14]+J[15]+J[16]-J[17]+J[18]-J[19]-J[20]-J[21]-J[22]+J[23]-J[24]-J[25]+J[26]-J[27]+J[28]+
    J[29]+J[30]-J[31]+J[32]+J[33]-J[34]+J[35]-J[36]-J[37]-J[38]+J[39]+J[40]-J[41]+J[42]-J[43]-J[44]-J[45]-J[46]+
    J[47]-J[48]+J[49]+J[50]+J[51]-J[52]+J[53]-J[54]-J[55]-J[56]+J[57]-J[58]-J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+
    J[65], +H[0]+H[1]-H[2]+H[3]+H[4]-H[5]+H[6]+H[7]-H[8]-H[9]+H[10]+H[11]+J[0]-J[1]+J[2]+J[3]-J[4]+J[5]+
    J[6]-J[7]-J[8]+J[9]+J[10]-J[11]+J[12]+J[13]-J[14]+J[15]+J[16]-J[17]-J[18]+J[19]+J[20]-J[21]-J[22]+J[23]-J[24]-J[25]+
    J[26]+J[27]-J[28]-J[29]+J[30]-J[31]+J[32]+J[33]-J[34]-J[35]+J[36]+J[37]-J[38]+J[39]+J[40]-J[41]-J[42]+
    J[43]+J[44]-J[45]-J[46]+J[47]+J[48]-J[49]-J[50]+J[51]-J[52]-J[53]+J[54]+J[55]-J[56]-J[57]+J[58]+J[59]+
    J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]+H[1]-H[2]+H[3]+H[4]-H[5]+H[6]+H[7]-H[8]-H[9]+H[10]-H[11]+
    J[0]-J[1]+J[2]+J[3]-J[4]+J[5]+J[6]-J[7]-J[8]+J[9]-J[10]-J[11]+J[12]+J[13]-J[14]+J[15]+J[16]-J[17]-J[18]+
    J[19]-J[20]-J[21]-J[22]+J[23]-J[24]-J[25]+J[26]+J[27]-J[28]+J[29]+J[30]-J[31]+J[32]+J[33]-J[34]-J[35]+
    J[36]-J[37]-J[38]+J[39]+J[40]-J[41]-J[42]+J[43]-J[44]-J[45]-J[46]+J[47]+J[48]-J[49]+J[50]+J[51]-J[52]-J[53]+
    J[54]-J[55]-J[56]-J[57]+J[58]-J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]+H[1]-H[2]+H[3]+H[4]-H[5]+
    H[6]+H[7]-H[8]-H[9]-H[10]+H[11]+J[0]-J[1]+J[2]+J[3]-J[4]+J[5]+J[6]-J[7]-J[8]-J[9]+J[10]-J[11]+J[12]+
    J[13]-J[14]+J[15]+J[16]-J[17]-J[18]-J[19]+J[20]-J[21]-J[22]+J[23]-J[24]-J[25]+J[26]+J[27]+J[28]-J[29]+
    J[30]-J[31]+J[32]+J[33]-J[34]-J[35]-J[36]+J[37]-J[38]+J[39]+J[40]-J[41]-J[42]-J[43]+J[44]-J[45]-J[46]+
    J[47]+J[48]+J[49]-J[50]+J[51]-J[52]-J[53]-J[54]+J[55]-J[56]-J[57]-J[58]+J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +
    H[0]+H[1]-H[2]+H[3]+H[4]-H[5]+H[6]+H[7]-H[8]-H[9]-H[10]-H[11]+J[0]-J[1]+J[2]+J[3]-J[4]+J[5]+J[6]-J[7]-J[8]-J[9]-J[10]-J[11]+
    J[12]+J[13]-J[14]+J[15]+J[16]-J[17]-J[18]-J[19]-J[20]-J[21]-J[22]+J[23]-J[24]-J[25]+J[26]+J[27]+J[28]+
    J[29]+J[30]-J[31]+J[32]+J[33]-J[34]-J[35]-J[36]-J[37]-J[38]+J[39]+J[40]-J[41]-J[42]-J[43]-J[44]-J[45]-J[46]+
    J[47]+J[48]+J[49]+J[50]+J[51]-J[52]-J[53]-J[54]-J[55]-J[56]-J[57]-J[58]-J[59]+J[60]+J[61]+J[62]+J[63]+
    J[64]+J[65], +H[0]+H[1]-H[2]+H[3]+H[4]-H[5]+H[6]-H[7]+H[8]+H[9]+H[10]+H[11]+J[0]-J[1]+J[2]+J[3]-J[4]+
    J[5]-J[6]+J[7]+J[8]+J[9]+J[10]-J[11]+J[12]+J[13]-J[14]+J[15]-J[16]+J[17]+J[18]+J[19]+J[20]-J[21]-J[22]+
    J[23]-J[24]+J[25]-J[26]-J[27]-J[28]-J[29]+J[30]-J[31]+J[32]-J[33]+J[34]+J[35]+J[36]+J[37]-J[38]+J[39]-J[40]+
    J[41]+J[42]+J[43]+J[44]-J[45]+J[46]-J[47]-J[48]-J[49]-J[50]-J[51]+J[52]+J[53]+J[54]+J[55]-J[56]-J[57]-J[58]-J[59]+
    J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]+H[1]-H[2]+H[3]+H[4]-H[5]+H[6]-H[7]+H[8]+H[9]+H[10]-H[11]+
    J[0]-J[1]+J[2]+J[3]-J[4]+J[5]-J[6]+J[7]+J[8]+J[9]-J[10]-J[11]+J[12]+J[13]-J[14]+J[15]-J[16]+J[17]+J[18]+
    J[19]-J[20]-J[21]-J[22]+J[23]-J[24]+J[25]-J[26]-J[27]-J[28]+J[29]+J[30]-J[31]+J[32]-J[33]+J[34]+J[35]+
    J[36]-J[37]-J[38]+J[39]-J[40]+J[41]+J[42]+J[43]-J[44]-J[45]+J[46]-J[47]-J[48]-J[49]+J[50]-J[51]+J[52]+
    J[53]+J[54]-J[55]-J[56]-J[57]-J[58]+J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]+H[1]-H[2]+H[3]+
    H[4]-H[5]+H[6]-H[7]+H[8]+H[9]-H[10]+H[11]+J[0]-J[1]+J[2]+J[3]-J[4]+J[5]-J[6]+J[7]+J[8]-J[9]+J[10]-J[11]+
    J[12]+J[13]-J[14]+J[15]-J[16]+J[17]+J[18]-J[19]+J[20]-J[21]-J[22]+J[23]-J[24]+J[25]-J[26]-J[27]+J[28]-J[29]+
    J[30]-J[31]+J[32]-J[33]+J[34]+J[35]-J[36]+J[37]-J[38]+J[39]-J[40]+J[41]+J[42]-J[43]+J[44]-J[45]+J[46]-J[47]-J[48]+
    J[49]-J[50]-J[51]+J[52]+J[53]-J[54]+J[55]-J[56]-J[57]+J[58]-J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +
    H[0]+H[1]-H[2]+H[3]+H[4]-H[5]+H[6]-H[7]+H[8]+H[9]-H[10]-H[11]+J[0]-J[1]+J[2]+J[3]-J[4]+J[5]-J[6]+J[7]+
    J[8]-J[9]-J[10]-J[11]+J[12]+J[13]-J[14]+J[15]-J[16]+J[17]+J[18]-J[19]-J[20]-J[21]-J[22]+J[23]-J[24]+
    J[25]-J[26]-J[27]+J[28]+J[29]+J[30]-J[31]+J[32]-J[33]+J[34]+J[35]-J[36]-J[37]-J[38]+J[39]-J[40]+J[41]+
    J[42]-J[43]-J[44]-J[45]+J[46]-J[47]-J[48]+J[49]+J[50]-J[51]+J[52]+J[53]-J[54]-J[55]-J[56]-J[57]+J[58]+
    J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]+H[1]-H[2]+H[3]+H[4]-H[5]+H[6]-H[7]+H[8]-H[9]+H[10]+
    H[11]+J[0]-J[1]+J[2]+J[3]-J[4]+J[5]-J[6]+J[7]-J[8]+J[9]+J[10]-J[11]+J[12]+J[13]-J[14]+J[15]-J[16]+J[17]-J[18]+
    J[19]+J[20]-J[21]-J[22]+J[23]-J[24]+J[25]-J[26]+J[27]-J[28]-J[29]+J[30]-J[31]+J[32]-J[33]+J[34]-J[35]+
    J[36]+J[37]-J[38]+J[39]-J[40]+J[41]-J[42]+J[43]+J[44]-J[45]+J[46]-J[47]+J[48]-J[49]-J[50]-J[51]+J[52]-J[53]+
    J[54]+J[55]-J[56]+J[57]-J[58]-J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]+H[1]-H[2]+H[3]+H[4]-H[5]+
    H[6]-H[7]+H[8]-H[9]+H[10]-H[11]+J[0]-J[1]+J[2]+J[3]-J[4]+J[5]-J[6]+J[7]-J[8]+J[9]-J[10]-J[11]+J[12]+
    J[13]-J[14]+J[15]-J[16]+J[17]-J[18]+J[19]-J[20]-J[21]-J[22]+J[23]-J[24]+J[25]-J[26]+J[27]-J[28]+J[29]+
    J[30]-J[31]+J[32]-J[33]+J[34]-J[35]+J[36]-J[37]-J[38]+J[39]-J[40]+J[41]-J[42]+J[43]-J[44]-J[45]+J[46]-J[47]+
    J[48]-J[49]+J[50]-J[51]+J[52]-J[53]+J[54]-J[55]-J[56]+J[57]-J[58]+J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +
    H[0]+H[1]-H[2]+H[3]+H[4]-H[5]+H[6]-H[7]+H[8]-H[9]-H[10]+H[11]+J[0]-J[1]+J[2]+J[3]-J[4]+J[5]-J[6]+J[7]-J[8]-J[9]+
    J[10]-J[11]+J[12]+J[13]-J[14]+J[15]-J[16]+J[17]-J[18]-J[19]+J[20]-J[21]-J[22]+J[23]-J[24]+J[25]-J[26]+
    J[27]+J[28]-J[29]+J[30]-J[31]+J[32]-J[33]+J[34]-J[35]-J[36]+J[37]-J[38]+J[39]-J[40]+J[41]-J[42]-J[43]+
    J[44]-J[45]+J[46]-J[47]+J[48]+J[49]-J[50]-J[51]+J[52]-J[53]-J[54]+J[55]-J[56]+J[57]+J[58]-J[59]-J[60]-J[61]+
    J[62]+J[63]-J[64]-J[65], +H[0]+H[1]-H[2]+H[3]+H[4]-H[5]+H[6]-H[7]+H[8]-H[9]-H[10]-H[11]+J[0]-J[1]+J[2]+
    J[3]-J[4]+J[5]-J[6]+J[7]-J[8]-J[9]-J[10]-J[11]+J[12]+J[13]-J[14]+J[15]-J[16]+J[17]-J[18]-J[19]-J[20]-J[21]-J[22]+
    J[23]-J[24]+J[25]-J[26]+J[27]+J[28]+J[29]+J[30]-J[31]+J[32]-J[33]+J[34]-J[35]-J[36]-J[37]-J[38]+J[39]-J[40]+
    J[41]-J[42]-J[43]-J[44]-J[45]+J[46]-J[47]+J[48]+J[49]+J[50]-J[51]+J[52]-J[53]-J[54]-J[55]-J[56]+J[57]+
    J[58]+J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]+H[1]-H[2]+H[3]+H[4]-H[5]+H[6]-H[7]-H[8]+H[9]+
    H[10]+H[11]+J[0]-J[1]+J[2]+J[3]-J[4]+J[5]-J[6]-J[7]+J[8]+J[9]+J[10]-J[11]+J[12]+J[13]-J[14]+J[15]-J[16]-J[17]+
    J[18]+J[19]+J[20]-J[21]-J[22]+J[23]-J[24]+J[25]+J[26]-J[27]-J[28]-J[29]+J[30]-J[31]+J[32]-J[33]-J[34]+
    J[35]+J[36]+J[37]-J[38]+J[39]-J[40]-J[41]+J[42]+J[43]+J[44]-J[45]+J[46]+J[47]-J[48]-J[49]-J[50]-J[51]-J[52]+
    J[53]+J[54]+J[55]+J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]+H[1]-H[2]+H[3]+
    H[4]-H[5]+H[6]-H[7]-H[8]+H[9]+H[10]-H[11]+J[0]-J[1]+J[2]+J[3]-J[4]+J[5]-J[6]-J[7]+J[8]+J[9]-J[10]-J[11]+
    J[12]+J[13]-J[14]+J[15]-J[16]-J[17]+J[18]+J[19]-J[20]-J[21]-J[22]+J[23]-J[24]+J[25]+J[26]-J[27]-J[28]+
    J[29]+J[30]-J[31]+J[32]-J[33]-J[34]+J[35]+J[36]-J[37]-J[38]+J[39]-J[40]-J[41]+J[42]+J[43]-J[44]-J[45]+
    J[46]+J[47]-J[48]-J[49]+J[50]-J[51]-J[52]+J[53]+J[54]-J[55]+J[56]-J[57]-J[58]+J[59]-J[60]-J[61]+J[62]+
    J[63]-J[64]-J[65], +H[0]+H[1]-H[2]+H[3]+H[4]-H[5]+H[6]-H[7]-H[8]+H[9]-H[10]+H[11]+J[0]-J[1]+J[2]+J[3]-J[4]+
    J[5]-J[6]-J[7]+J[8]-J[9]+J[10]-J[11]+J[12]+J[13]-J[14]+J[15]-J[16]-J[17]+J[18]-J[19]+J[20]-J[21]-J[22]+
    J[23]-J[24]+J[25]+J[26]-J[27]+J[28]-J[29]+J[30]-J[31]+J[32]-J[33]-J[34]+J[35]-J[36]+J[37]-J[38]+J[39]-J[40]-J[41]+
    J[42]-J[43]+J[44]-J[45]+J[46]+J[47]-J[48]+J[49]-J[50]-J[51]-J[52]+J[53]-J[54]+J[55]+J[56]-J[57]+J[58]-J[59]-J[60]+
    J[61]-J[62]-J[63]+J[64]-J[65], +H[0]+H[1]-H[2]+H[3]+H[4]-H[5]+H[6]-H[7]-H[8]+H[9]-H[10]-H[11]+J[0]-J[1]+
    J[2]+J[3]-J[4]+J[5]-J[6]-J[7]+J[8]-J[9]-J[10]-J[11]+J[12]+J[13]-J[14]+J[15]-J[16]-J[17]+J[18]-J[19]-J[20]-J[21]-J[22]+
    J[23]-J[24]+J[25]+J[26]-J[27]+J[28]+J[29]+J[30]-J[31]+J[32]-J[33]-J[34]+J[35]-J[36]-J[37]-J[38]+J[39]-J[40]-J[41]+
    J[42]-J[43]-J[44]-J[45]+J[46]+J[47]-J[48]+J[49]+J[50]-J[51]-J[52]+J[53]-J[54]-J[55]+J[56]-J[57]+J[58]+
    J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]+H[1]-H[2]+H[3]+H[4]-H[5]+H[6]-H[7]-H[8]-H[9]+H[10]+
    H[11]+J[0]-J[1]+J[2]+J[3]-J[4]+J[5]-J[6]-J[7]-J[8]+J[9]+J[10]-J[11]+J[12]+J[13]-J[14]+J[15]-J[16]-J[17]-J[18]+
    J[19]+J[20]-J[21]-J[22]+J[23]-J[24]+J[25]+J[26]+J[27]-J[28]-J[29]+J[30]-J[31]+J[32]-J[33]-J[34]-J[35]+
    J[36]+J[37]-J[38]+J[39]-J[40]-J[41]-J[42]+J[43]+J[44]-J[45]+J[46]+J[47]+J[48]-J[49]-J[50]-J[51]-J[52]-J[53]+
    J[54]+J[55]+J[56]+J[57]-J[58]-J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]+H[1]-H[2]+H[3]+H[4]-H[5]+
    H[6]-H[7]-H[8]-H[9]+H[10]-H[11]+J[0]-J[1]+J[2]+J[3]-J[4]+J[5]-J[6]-J[7]-J[8]+J[9]-J[10]-J[11]+J[12]+
    J[13]-J[14]+J[15]-J[16]-J[17]-J[18]+J[19]-J[20]-J[21]-J[22]+J[23]-J[24]+J[25]+J[26]+J[27]-J[28]+J[29]+
    J[30]-J[31]+J[32]-J[33]-J[34]-J[35]+J[36]-J[37]-J[38]+J[39]-J[40]-J[41]-J[42]+J[43]-J[44]-J[45]+J[46]+
    J[47]+J[48]-J[49]+J[50]-J[51]-J[52]-J[53]+J[54]-J[55]+J[56]+J[57]-J[58]+J[59]+J[60]-J[61]+J[62]-J[63]+
    J[64]-J[65], +H[0]+H[1]-H[2]+H[3]+H[4]-H[5]+H[6]-H[7]-H[8]-H[9]-H[10]+H[11]+J[0]-J[1]+J[2]+J[3]-J[4]+
    J[5]-J[6]-J[7]-J[8]-J[9]+J[10]-J[11]+J[12]+J[13]-J[14]+J[15]-J[16]-J[17]-J[18]-J[19]+J[20]-J[21]-J[22]+
    J[23]-J[24]+J[25]+J[26]+J[27]+J[28]-J[29]+J[30]-J[31]+J[32]-J[33]-J[34]-J[35]-J[36]+J[37]-J[38]+J[39]-J[40]-J[41]-J[42]-J[43]+
    J[44]-J[45]+J[46]+J[47]+J[48]+J[49]-J[50]-J[51]-J[52]-J[53]-J[54]+J[55]+J[56]+J[57]+J[58]-J[59]+J[60]+
    J[61]-J[62]+J[63]-J[64]-J[65], +H[0]+H[1]-H[2]+H[3]+H[4]-H[5]+H[6]-H[7]-H[8]-H[9]-H[10]-H[11]+J[0]-J[1]+
    J[2]+J[3]-J[4]+J[5]-J[6]-J[7]-J[8]-J[9]-J[10]-J[11]+J[12]+J[13]-J[14]+J[15]-J[16]-J[17]-J[18]-J[19]-J[20]-J[21]-J[22]+
    J[23]-J[24]+J[25]+J[26]+J[27]+J[28]+J[29]+J[30]-J[31]+J[32]-J[33]-J[34]-J[35]-J[36]-J[37]-J[38]+J[39]-J[40]-J[41]-J[42]-J[43]-J[44]-J[45]+
    J[46]+J[47]+J[48]+J[49]+J[50]-J[51]-J[52]-J[53]-J[54]-J[55]+J[56]+J[57]+J[58]+J[59]+J[60]+J[61]+J[62]+
    J[63]+J[64]+J[65], +H[0]+H[1]-H[2]+H[3]+H[4]-H[5]-H[6]+H[7]+H[8]+H[9]+H[10]+H[11]+J[0]-J[1]+J[2]+J[3]-J[4]-J[5]+
    J[6]+J[7]+J[8]+J[9]+J[10]-J[11]+J[12]+J[13]-J[14]-J[15]+J[16]+J[17]+J[18]+J[19]+J[20]-J[21]-J[22]+J[23]+
    J[24]-J[25]-J[26]-J[27]-J[28]-J[29]+J[30]-J[31]-J[32]+J[33]+J[34]+J[35]+J[36]+J[37]-J[38]-J[39]+J[40]+
    J[41]+J[42]+J[43]+J[44]+J[45]-J[46]-J[47]-J[48]-J[49]-J[50]-J[51]-J[52]-J[53]-J[54]-J[55]+J[56]+J[57]+
    J[58]+J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]+H[1]-H[2]+H[3]+H[4]-H[5]-H[6]+H[7]+H[8]+H[9]+
    H[10]-H[11]+J[0]-J[1]+J[2]+J[3]-J[4]-J[5]+J[6]+J[7]+J[8]+J[9]-J[10]-J[11]+J[12]+J[13]-J[14]-J[15]+J[16]+
    J[17]+J[18]+J[19]-J[20]-J[21]-J[22]+J[23]+J[24]-J[25]-J[26]-J[27]-J[28]+J[29]+J[30]-J[31]-J[32]+J[33]+
    J[34]+J[35]+J[36]-J[37]-J[38]-J[39]+J[40]+J[41]+J[42]+J[43]-J[44]+J[45]-J[46]-J[47]-J[48]-J[49]+J[50]-J[51]-J[52]-J[53]-J[54]+
    J[55]+J[56]+J[57]+J[58]-J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]+H[1]-H[2]+H[3]+H[4]-H[5]-H[6]+
    H[7]+H[8]+H[9]-H[10]+H[11]+J[0]-J[1]+J[2]+J[3]-J[4]-J[5]+J[6]+J[7]+J[8]-J[9]+J[10]-J[11]+J[12]+J[13]-J[14]-J[15]+
    J[16]+J[17]+J[18]-J[19]+J[20]-J[21]-J[22]+J[23]+J[24]-J[25]-J[26]-J[27]+J[28]-J[29]+J[30]-J[31]-J[32]+
    J[33]+J[34]+J[35]-J[36]+J[37]-J[38]-J[39]+J[40]+J[41]+J[42]-J[43]+J[44]+J[45]-J[46]-J[47]-J[48]+J[49]-J[50]-J[51]-J[52]-J[53]+
    J[54]-J[55]+J[56]+J[57]-J[58]+J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]+H[1]-H[2]+H[3]+H[4]-H[5]-H[6]+
    H[7]+H[8]+H[9]-H[10]-H[11]+J[0]-J[1]+J[2]+J[3]-J[4]-J[5]+J[6]+J[7]+J[8]-J[9]-J[10]-J[11]+J[12]+J[13]-J[14]-J[15]+
    J[16]+J[17]+J[18]-J[19]-J[20]-J[21]-J[22]+J[23]+J[24]-J[25]-J[26]-J[27]+J[28]+J[29]+J[30]-J[31]-J[32]+
    J[33]+J[34]+J[35]-J[36]-J[37]-J[38]-J[39]+J[40]+J[41]+J[42]-J[43]-J[44]+J[45]-J[46]-J[47]-J[48]+J[49]+
    J[50]-J[51]-J[52]-J[53]+J[54]+J[55]+J[56]+J[57]-J[58]-J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]+
    H[1]-H[2]+H[3]+H[4]-H[5]-H[6]+H[7]+H[8]-H[9]+H[10]+H[11]+J[0]-J[1]+J[2]+J[3]-J[4]-J[5]+J[6]+J[7]-J[8]+
    J[9]+J[10]-J[11]+J[12]+J[13]-J[14]-J[15]+J[16]+J[17]-J[18]+J[19]+J[20]-J[21]-J[22]+J[23]+J[24]-J[25]-J[26]+
    J[27]-J[28]-J[29]+J[30]-J[31]-J[32]+J[33]+J[34]-J[35]+J[36]+J[37]-J[38]-J[39]+J[40]+J[41]-J[42]+J[43]+
    J[44]+J[45]-J[46]-J[47]+J[48]-J[49]-J[50]-J[51]-J[52]+J[53]-J[54]-J[55]+J[56]-J[57]+J[58]+J[59]-J[60]+
    J[61]+J[62]-J[63]-J[64]+J[65], +H[0]+H[1]-H[2]+H[3]+H[4]-H[5]-H[6]+H[7]+H[8]-H[9]+H[10]-H[11]+J[0]-J[1]+
    J[2]+J[3]-J[4]-J[5]+J[6]+J[7]-J[8]+J[9]-J[10]-J[11]+J[12]+J[13]-J[14]-J[15]+J[16]+J[17]-J[18]+J[19]-J[20]-J[21]-J[22]+
    J[23]+J[24]-J[25]-J[26]+J[27]-J[28]+J[29]+J[30]-J[31]-J[32]+J[33]+J[34]-J[35]+J[36]-J[37]-J[38]-J[39]+
    J[40]+J[41]-J[42]+J[43]-J[44]+J[45]-J[46]-J[47]+J[48]-J[49]+J[50]-J[51]-J[52]+J[53]-J[54]+J[55]+J[56]-J[57]+
    J[58]-J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]+H[1]-H[2]+H[3]+H[4]-H[5]-H[6]+H[7]+H[8]-H[9]-H[10]+
    H[11]+J[0]-J[1]+J[2]+J[3]-J[4]-J[5]+J[6]+J[7]-J[8]-J[9]+J[10]-J[11]+J[12]+J[13]-J[14]-J[15]+J[16]+J[17]-J[18]-J[19]+
    J[20]-J[21]-J[22]+J[23]+J[24]-J[25]-J[26]+J[27]+J[28]-J[29]+J[30]-J[31]-J[32]+J[33]+J[34]-J[35]-J[36]+
    J[37]-J[38]-J[39]+J[40]+J[41]-J[42]-J[43]+J[44]+J[45]-J[46]-J[47]+J[48]+J[49]-J[50]-J[51]-J[52]+J[53]+
    J[54]-J[55]+J[56]-J[57]-J[58]+J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]+H[1]-H[2]+H[3]+H[4]-H[5]-H[6]+
    H[7]+H[8]-H[9]-H[10]-H[11]+J[0]-J[1]+J[2]+J[3]-J[4]-J[5]+J[6]+J[7]-J[8]-J[9]-J[10]-J[11]+J[12]+J[13]-J[14]-J[15]+
    J[16]+J[17]-J[18]-J[19]-J[20]-J[21]-J[22]+J[23]+J[24]-J[25]-J[26]+J[27]+J[28]+J[29]+J[30]-J[31]-J[32]+
    J[33]+J[34]-J[35]-J[36]-J[37]-J[38]-J[39]+J[40]+J[41]-J[42]-J[43]-J[44]+J[45]-J[46]-J[47]+J[48]+J[49]+
    J[50]-J[51]-J[52]+J[53]+J[54]+J[55]+J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]+
    H[1]-H[2]+H[3]+H[4]-H[5]-H[6]+H[7]-H[8]+H[9]+H[10]+H[11]+J[0]-J[1]+J[2]+J[3]-J[4]-J[5]+J[6]-J[7]+J[8]+
    J[9]+J[10]-J[11]+J[12]+J[13]-J[14]-J[15]+J[16]-J[17]+J[18]+J[19]+J[20]-J[21]-J[22]+J[23]+J[24]-J[25]+
    J[26]-J[27]-J[28]-J[29]+J[30]-J[31]-J[32]+J[33]-J[34]+J[35]+J[36]+J[37]-J[38]-J[39]+J[40]-J[41]+J[42]+
    J[43]+J[44]+J[45]-J[46]+J[47]-J[48]-J[49]-J[50]-J[51]+J[52]-J[53]-J[54]-J[55]-J[56]+J[57]+J[58]+J[59]-J[60]-J[61]-J[62]+
    J[63]+J[64]+J[65], +H[0]+H[1]-H[2]+H[3]+H[4]-H[5]-H[6]+H[7]-H[8]+H[9]+H[10]-H[11]+J[0]-J[1]+J[2]+J[3]-J[4]-J[5]+
    J[6]-J[7]+J[8]+J[9]-J[10]-J[11]+J[12]+J[13]-J[14]-J[15]+J[16]-J[17]+J[18]+J[19]-J[20]-J[21]-J[22]+J[23]+
    J[24]-J[25]+J[26]-J[27]-J[28]+J[29]+J[30]-J[31]-J[32]+J[33]-J[34]+J[35]+J[36]-J[37]-J[38]-J[39]+J[40]-J[41]+
    J[42]+J[43]-J[44]+J[45]-J[46]+J[47]-J[48]-J[49]+J[50]-J[51]+J[52]-J[53]-J[54]+J[55]-J[56]+J[57]+J[58]-J[59]-J[60]-J[61]+
    J[62]+J[63]-J[64]-J[65], +H[0]+H[1]-H[2]+H[3]+H[4]-H[5]-H[6]+H[7]-H[8]+H[9]-H[10]+H[11]+J[0]-J[1]+J[2]+
    J[3]-J[4]-J[5]+J[6]-J[7]+J[8]-J[9]+J[10]-J[11]+J[12]+J[13]-J[14]-J[15]+J[16]-J[17]+J[18]-J[19]+J[20]-J[21]-J[22]+
    J[23]+J[24]-J[25]+J[26]-J[27]+J[28]-J[29]+J[30]-J[31]-J[32]+J[33]-J[34]+J[35]-J[36]+J[37]-J[38]-J[39]+
    J[40]-J[41]+J[42]-J[43]+J[44]+J[45]-J[46]+J[47]-J[48]+J[49]-J[50]-J[51]+J[52]-J[53]+J[54]-J[55]-J[56]+
    J[57]-J[58]+J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]+H[1]-H[2]+H[3]+H[4]-H[5]-H[6]+H[7]-H[8]+
    H[9]-H[10]-H[11]+J[0]-J[1]+J[2]+J[3]-J[4]-J[5]+J[6]-J[7]+J[8]-J[9]-J[10]-J[11]+J[12]+J[13]-J[14]-J[15]+
    J[16]-J[17]+J[18]-J[19]-J[20]-J[21]-J[22]+J[23]+J[24]-J[25]+J[26]-J[27]+J[28]+J[29]+J[30]-J[31]-J[32]+
    J[33]-J[34]+J[35]-J[36]-J[37]-J[38]-J[39]+J[40]-J[41]+J[42]-J[43]-J[44]+J[45]-J[46]+J[47]-J[48]+J[49]+
    J[50]-J[51]+J[52]-J[53]+J[54]+J[55]-J[56]+J[57]-J[58]-J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]+
    H[1]-H[2]+H[3]+H[4]-H[5]-H[6]+H[7]-H[8]-H[9]+H[10]+H[11]+J[0]-J[1]+J[2]+J[3]-J[4]-J[5]+J[6]-J[7]-J[8]+
    J[9]+J[10]-J[11]+J[12]+J[13]-J[14]-J[15]+J[16]-J[17]-J[18]+J[19]+J[20]-J[21]-J[22]+J[23]+J[24]-J[25]+
    J[26]+J[27]-J[28]-J[29]+J[30]-J[31]-J[32]+J[33]-J[34]-J[35]+J[36]+J[37]-J[38]-J[39]+J[40]-J[41]-J[42]+
    J[43]+J[44]+J[45]-J[46]+J[47]+J[48]-J[49]-J[50]-J[51]+J[52]+J[53]-J[54]-J[55]-J[56]-J[57]+J[58]+J[59]+
    J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]+H[1]-H[2]+H[3]+H[4]-H[5]-H[6]+H[7]-H[8]-H[9]+H[10]-H[11]+
    J[0]-J[1]+J[2]+J[3]-J[4]-J[5]+J[6]-J[7]-J[8]+J[9]-J[10]-J[11]+J[12]+J[13]-J[14]-J[15]+J[16]-J[17]-J[18]+
    J[19]-J[20]-J[21]-J[22]+J[23]+J[24]-J[25]+J[26]+J[27]-J[28]+J[29]+J[30]-J[31]-J[32]+J[33]-J[34]-J[35]+
    J[36]-J[37]-J[38]-J[39]+J[40]-J[41]-J[42]+J[43]-J[44]+J[45]-J[46]+J[47]+J[48]-J[49]+J[50]-J[51]+J[52]+
    J[53]-J[54]+J[55]-J[56]-J[57]+J[58]-J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]+H[1]-H[2]+H[3]+
    H[4]-H[5]-H[6]+H[7]-H[8]-H[9]-H[10]+H[11]+J[0]-J[1]+J[2]+J[3]-J[4]-J[5]+J[6]-J[7]-J[8]-J[9]+J[10]-J[11]+
    J[12]+J[13]-J[14]-J[15]+J[16]-J[17]-J[18]-J[19]+J[20]-J[21]-J[22]+J[23]+J[24]-J[25]+J[26]+J[27]+J[28]-J[29]+
    J[30]-J[31]-J[32]+J[33]-J[34]-J[35]-J[36]+J[37]-J[38]-J[39]+J[40]-J[41]-J[42]-J[43]+J[44]+J[45]-J[46]+
    J[47]+J[48]+J[49]-J[50]-J[51]+J[52]+J[53]+J[54]-J[55]-J[56]-J[57]-J[58]+J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +
    H[0]+H[1]-H[2]+H[3]+H[4]-H[5]-H[6]+H[7]-H[8]-H[9]-H[10]-H[11]+J[0]-J[1]+J[2]+J[3]-J[4]-J[5]+J[6]-J[7]-J[8]-J[9]-J[10]-J[11]+
    J[12]+J[13]-J[14]-J[15]+J[16]-J[17]-J[18]-J[19]-J[20]-J[21]-J[22]+J[23]+J[24]-J[25]+J[26]+J[27]+J[28]+
    J[29]+J[30]-J[31]-J[32]+J[33]-J[34]-J[35]-J[36]-J[37]-J[38]-J[39]+J[40]-J[41]-J[42]-J[43]-J[44]+J[45]-J[46]+
    J[47]+J[48]+J[49]+J[50]-J[51]+J[52]+J[53]+J[54]+J[55]-J[56]-J[57]-J[58]-J[59]+J[60]+J[61]+J[62]+J[63]+
    J[64]+J[65], +H[0]+H[1]-H[2]+H[3]+H[4]-H[5]-H[6]-H[7]+H[8]+H[9]+H[10]+H[11]+J[0]-J[1]+J[2]+J[3]-J[4]-J[5]-J[6]+
    J[7]+J[8]+J[9]+J[10]-J[11]+J[12]+J[13]-J[14]-J[15]-J[16]+J[17]+J[18]+J[19]+J[20]-J[21]-J[22]+J[23]+J[24]+
    J[25]-J[26]-J[27]-J[28]-J[29]+J[30]-J[31]-J[32]-J[33]+J[34]+J[35]+J[36]+J[37]-J[38]-J[39]-J[40]+J[41]+
    J[42]+J[43]+J[44]+J[45]+J[46]-J[47]-J[48]-J[49]-J[50]+J[51]-J[52]-J[53]-J[54]-J[55]-J[56]-J[57]-J[58]-J[59]+
    J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]+H[1]-H[2]+H[3]+H[4]-H[5]-H[6]-H[7]+H[8]+H[9]+H[10]-H[11]+
    J[0]-J[1]+J[2]+J[3]-J[4]-J[5]-J[6]+J[7]+J[8]+J[9]-J[10]-J[11]+J[12]+J[13]-J[14]-J[15]-J[16]+J[17]+J[18]+
    J[19]-J[20]-J[21]-J[22]+J[23]+J[24]+J[25]-J[26]-J[27]-J[28]+J[29]+J[30]-J[31]-J[32]-J[33]+J[34]+J[35]+
    J[36]-J[37]-J[38]-J[39]-J[40]+J[41]+J[42]+J[43]-J[44]+J[45]+J[46]-J[47]-J[48]-J[49]+J[50]+J[51]-J[52]-J[53]-J[54]+
    J[55]-J[56]-J[57]-J[58]+J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]+H[1]-H[2]+H[3]+H[4]-H[5]-H[6]-H[7]+
    H[8]+H[9]-H[10]+H[11]+J[0]-J[1]+J[2]+J[3]-J[4]-J[5]-J[6]+J[7]+J[8]-J[9]+J[10]-J[11]+J[12]+J[13]-J[14]-J[15]-J[16]+
    J[17]+J[18]-J[19]+J[20]-J[21]-J[22]+J[23]+J[24]+J[25]-J[26]-J[27]+J[28]-J[29]+J[30]-J[31]-J[32]-J[33]+
    J[34]+J[35]-J[36]+J[37]-J[38]-J[39]-J[40]+J[41]+J[42]-J[43]+J[44]+J[45]+J[46]-J[47]-J[48]+J[49]-J[50]+
    J[51]-J[52]-J[53]+J[54]-J[55]-J[56]-J[57]+J[58]-J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]+H[1]-H[2]+
    H[3]+H[4]-H[5]-H[6]-H[7]+H[8]+H[9]-H[10]-H[11]+J[0]-J[1]+J[2]+J[3]-J[4]-J[5]-J[6]+J[7]+J[8]-J[9]-J[10]-J[11]+
    J[12]+J[13]-J[14]-J[15]-J[16]+J[17]+J[18]-J[19]-J[20]-J[21]-J[22]+J[23]+J[24]+J[25]-J[26]-J[27]+J[28]+
    J[29]+J[30]-J[31]-J[32]-J[33]+J[34]+J[35]-J[36]-J[37]-J[38]-J[39]-J[40]+J[41]+J[42]-J[43]-J[44]+J[45]+
    J[46]-J[47]-J[48]+J[49]+J[50]+J[51]-J[52]-J[53]+J[54]+J[55]-J[56]-J[57]+J[58]+J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+
    J[65], +H[0]+H[1]-H[2]+H[3]+H[4]-H[5]-H[6]-H[7]+H[8]-H[9]+H[10]+H[11]+J[0]-J[1]+J[2]+J[3]-J[4]-J[5]-J[6]+
    J[7]-J[8]+J[9]+J[10]-J[11]+J[12]+J[13]-J[14]-J[15]-J[16]+J[17]-J[18]+J[19]+J[20]-J[21]-J[22]+J[23]+J[24]+
    J[25]-J[26]+J[27]-J[28]-J[29]+J[30]-J[31]-J[32]-J[33]+J[34]-J[35]+J[36]+J[37]-J[38]-J[39]-J[40]+J[41]-J[42]+
    J[43]+J[44]+J[45]+J[46]-J[47]+J[48]-J[49]-J[50]+J[51]-J[52]+J[53]-J[54]-J[55]-J[56]+J[57]-J[58]-J[59]-J[60]+
    J[61]+J[62]-J[63]-J[64]+J[65], +H[0]+H[1]-H[2]+H[3]+H[4]-H[5]-H[6]-H[7]+H[8]-H[9]+H[10]-H[11]+J[0]-J[1]+
    J[2]+J[3]-J[4]-J[5]-J[6]+J[7]-J[8]+J[9]-J[10]-J[11]+J[12]+J[13]-J[14]-J[15]-J[16]+J[17]-J[18]+J[19]-J[20]-J[21]-J[22]+
    J[23]+J[24]+J[25]-J[26]+J[27]-J[28]+J[29]+J[30]-J[31]-J[32]-J[33]+J[34]-J[35]+J[36]-J[37]-J[38]-J[39]-J[40]+
    J[41]-J[42]+J[43]-J[44]+J[45]+J[46]-J[47]+J[48]-J[49]+J[50]+J[51]-J[52]+J[53]-J[54]+J[55]-J[56]+J[57]-J[58]+
    J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]+H[1]-H[2]+H[3]+H[4]-H[5]-H[6]-H[7]+H[8]-H[9]-H[10]+
    H[11]+J[0]-J[1]+J[2]+J[3]-J[4]-J[5]-J[6]+J[7]-J[8]-J[9]+J[10]-J[11]+J[12]+J[13]-J[14]-J[15]-J[16]+J[17]-J[18]-J[19]+
    J[20]-J[21]-J[22]+J[23]+J[24]+J[25]-J[26]+J[27]+J[28]-J[29]+J[30]-J[31]-J[32]-J[33]+J[34]-J[35]-J[36]+
    J[37]-J[38]-J[39]-J[40]+J[41]-J[42]-J[43]+J[44]+J[45]+J[46]-J[47]+J[48]+J[49]-J[50]+J[51]-J[52]+J[53]+
    J[54]-J[55]-J[56]+J[57]+J[58]-J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]+H[1]-H[2]+H[3]+H[4]-H[5]-H[6]-H[7]+
    H[8]-H[9]-H[10]-H[11]+J[0]-J[1]+J[2]+J[3]-J[4]-J[5]-J[6]+J[7]-J[8]-J[9]-J[10]-J[11]+J[12]+J[13]-J[14]-J[15]-J[16]+
    J[17]-J[18]-J[19]-J[20]-J[21]-J[22]+J[23]+J[24]+J[25]-J[26]+J[27]+J[28]+J[29]+J[30]-J[31]-J[32]-J[33]+
    J[34]-J[35]-J[36]-J[37]-J[38]-J[39]-J[40]+J[41]-J[42]-J[43]-J[44]+J[45]+J[46]-J[47]+J[48]+J[49]+J[50]+
    J[51]-J[52]+J[53]+J[54]+J[55]-J[56]+J[57]+J[58]+J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]+H[1]-H[2]+
    H[3]+H[4]-H[5]-H[6]-H[7]-H[8]+H[9]+H[10]+H[11]+J[0]-J[1]+J[2]+J[3]-J[4]-J[5]-J[6]-J[7]+J[8]+J[9]+J[10]-J[11]+
    J[12]+J[13]-J[14]-J[15]-J[16]-J[17]+J[18]+J[19]+J[20]-J[21]-J[22]+J[23]+J[24]+J[25]+J[26]-J[27]-J[28]-J[29]+
    J[30]-J[31]-J[32]-J[33]-J[34]+J[35]+J[36]+J[37]-J[38]-J[39]-J[40]-J[41]+J[42]+J[43]+J[44]+J[45]+J[46]+
    J[47]-J[48]-J[49]-J[50]+J[51]+J[52]-J[53]-J[54]-J[55]+J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+J[63]+
    J[64]+J[65], +H[0]+H[1]-H[2]+H[3]+H[4]-H[5]-H[6]-H[7]-H[8]+H[9]+H[10]-H[11]+J[0]-J[1]+J[2]+J[3]-J[4]-J[5]-J[6]-J[7]+
    J[8]+J[9]-J[10]-J[11]+J[12]+J[13]-J[14]-J[15]-J[16]-J[17]+J[18]+J[19]-J[20]-J[21]-J[22]+J[23]+J[24]+
    J[25]+J[26]-J[27]-J[28]+J[29]+J[30]-J[31]-J[32]-J[33]-J[34]+J[35]+J[36]-J[37]-J[38]-J[39]-J[40]-J[41]+
    J[42]+J[43]-J[44]+J[45]+J[46]+J[47]-J[48]-J[49]+J[50]+J[51]+J[52]-J[53]-J[54]+J[55]+J[56]-J[57]-J[58]+
    J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]+H[1]-H[2]+H[3]+H[4]-H[5]-H[6]-H[7]-H[8]+H[9]-H[10]+
    H[11]+J[0]-J[1]+J[2]+J[3]-J[4]-J[5]-J[6]-J[7]+J[8]-J[9]+J[10]-J[11]+J[12]+J[13]-J[14]-J[15]-J[16]-J[17]+
    J[18]-J[19]+J[20]-J[21]-J[22]+J[23]+J[24]+J[25]+J[26]-J[27]+J[28]-J[29]+J[30]-J[31]-J[32]-J[33]-J[34]+
    J[35]-J[36]+J[37]-J[38]-J[39]-J[40]-J[41]+J[42]-J[43]+J[44]+J[45]+J[46]+J[47]-J[48]+J[49]-J[50]+J[51]+
    J[52]-J[53]+J[54]-J[55]+J[56]-J[57]+J[58]-J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]+H[1]-H[2]+
    H[3]+H[4]-H[5]-H[6]-H[7]-H[8]+H[9]-H[10]-H[11]+J[0]-J[1]+J[2]+J[3]-J[4]-J[5]-J[6]-J[7]+J[8]-J[9]-J[10]-J[11]+
    J[12]+J[13]-J[14]-J[15]-J[16]-J[17]+J[18]-J[19]-J[20]-J[21]-J[22]+J[23]+J[24]+J[25]+J[26]-J[27]+J[28]+
    J[29]+J[30]-J[31]-J[32]-J[33]-J[34]+J[35]-J[36]-J[37]-J[38]-J[39]-J[40]-J[41]+J[42]-J[43]-J[44]+J[45]+
    J[46]+J[47]-J[48]+J[49]+J[50]+J[51]+J[52]-J[53]+J[54]+J[55]+J[56]-J[57]+J[58]+J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+
    J[65], +H[0]+H[1]-H[2]+H[3]+H[4]-H[5]-H[6]-H[7]-H[8]-H[9]+H[10]+H[11]+J[0]-J[1]+J[2]+J[3]-J[4]-J[5]-J[6]-J[7]-J[8]+
    J[9]+J[10]-J[11]+J[12]+J[13]-J[14]-J[15]-J[16]-J[17]-J[18]+J[19]+J[20]-J[21]-J[22]+J[23]+J[24]+J[25]+
    J[26]+J[27]-J[28]-J[29]+J[30]-J[31]-J[32]-J[33]-J[34]-J[35]+J[36]+J[37]-J[38]-J[39]-J[40]-J[41]-J[42]+
    J[43]+J[44]+J[45]+J[46]+J[47]+J[48]-J[49]-J[50]+J[51]+J[52]+J[53]-J[54]-J[55]+J[56]+J[57]-J[58]-J[59]+
    J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]+H[1]-H[2]+H[3]+H[4]-H[5]-H[6]-H[7]-H[8]-H[9]+H[10]-H[11]+
    J[0]-J[1]+J[2]+J[3]-J[4]-J[5]-J[6]-J[7]-J[8]+J[9]-J[10]-J[11]+J[12]+J[13]-J[14]-J[15]-J[16]-J[17]-J[18]+
    J[19]-J[20]-J[21]-J[22]+J[23]+J[24]+J[25]+J[26]+J[27]-J[28]+J[29]+J[30]-J[31]-J[32]-J[33]-J[34]-J[35]+
    J[36]-J[37]-J[38]-J[39]-J[40]-J[41]-J[42]+J[43]-J[44]+J[45]+J[46]+J[47]+J[48]-J[49]+J[50]+J[51]+J[52]+
    J[53]-J[54]+J[55]+J[56]+J[57]-J[58]+J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]+H[1]-H[2]+H[3]+
    H[4]-H[5]-H[6]-H[7]-H[8]-H[9]-H[10]+H[11]+J[0]-J[1]+J[2]+J[3]-J[4]-J[5]-J[6]-J[7]-J[8]-J[9]+J[10]-J[11]+
    J[12]+J[13]-J[14]-J[15]-J[16]-J[17]-J[18]-J[19]+J[20]-J[21]-J[22]+J[23]+J[24]+J[25]+J[26]+J[27]+J[28]-J[29]+
    J[30]-J[31]-J[32]-J[33]-J[34]-J[35]-J[36]+J[37]-J[38]-J[39]-J[40]-J[41]-J[42]-J[43]+J[44]+J[45]+J[46]+
    J[47]+J[48]+J[49]-J[50]+J[51]+J[52]+J[53]+J[54]-J[55]+J[56]+J[57]+J[58]-J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +
    H[0]+H[1]-H[2]+H[3]+H[4]-H[5]-H[6]-H[7]-H[8]-H[9]-H[10]-H[11]+J[0]-J[1]+J[2]+J[3]-J[4]-J[5]-J[6]-J[7]-J[8]-J[9]-J[10]-J[11]+
    J[12]+J[13]-J[14]-J[15]-J[16]-J[17]-J[18]-J[19]-J[20]-J[21]-J[22]+J[23]+J[24]+J[25]+J[26]+J[27]+J[28]+
    J[29]+J[30]-J[31]-J[32]-J[33]-J[34]-J[35]-J[36]-J[37]-J[38]-J[39]-J[40]-J[41]-J[42]-J[43]-J[44]+J[45]+
    J[46]+J[47]+J[48]+J[49]+J[50]+J[51]+J[52]+J[53]+J[54]+J[55]+J[56]+J[57]+J[58]+J[59]+J[60]+J[61]+J[62]+
    J[63]+J[64]+J[65], +H[0]+H[1]-H[2]+H[3]-H[4]+H[5]+H[6]+H[7]+H[8]+H[9]+H[10]+H[11]+J[0]-J[1]+J[2]-J[3]+
    J[4]+J[5]+J[6]+J[7]+J[8]+J[9]+J[10]-J[11]+J[12]-J[13]+J[14]+J[15]+J[16]+J[17]+J[18]+J[19]+J[20]-J[21]+
    J[22]-J[23]-J[24]-J[25]-J[26]-J[27]-J[28]-J[29]-J[30]+J[31]+J[32]+J[33]+J[34]+J[35]+J[36]+J[37]-J[38]-J[39]-J[40]-J[41]-J[42]-J[43]-J[44]+
    J[45]+J[46]+J[47]+J[48]+J[49]+J[50]+J[51]+J[52]+J[53]+J[54]+J[55]+J[56]+J[57]+J[58]+J[59]+J[60]+J[61]+
    J[62]+J[63]+J[64]+J[65], +H[0]+H[1]-H[2]+H[3]-H[4]+H[5]+H[6]+H[7]+H[8]+H[9]+H[10]-H[11]+J[0]-J[1]+J[2]-J[3]+
    J[4]+J[5]+J[6]+J[7]+J[8]+J[9]-J[10]-J[11]+J[12]-J[13]+J[14]+J[15]+J[16]+J[17]+J[18]+J[19]-J[20]-J[21]+
    J[22]-J[23]-J[24]-J[25]-J[26]-J[27]-J[28]+J[29]-J[30]+J[31]+J[32]+J[33]+J[34]+J[35]+J[36]-J[37]-J[38]-J[39]-J[40]-J[41]-J[42]-J[43]+
    J[44]+J[45]+J[46]+J[47]+J[48]+J[49]-J[50]+J[51]+J[52]+J[53]+J[54]-J[55]+J[56]+J[57]+J[58]-J[59]+J[60]+
    J[61]-J[62]+J[63]-J[64]-J[65], +H[0]+H[1]-H[2]+H[3]-H[4]+H[5]+H[6]+H[7]+H[8]+H[9]-H[10]+H[11]+J[0]-J[1]+
    J[2]-J[3]+J[4]+J[5]+J[6]+J[7]+J[8]-J[9]+J[10]-J[11]+J[12]-J[13]+J[14]+J[15]+J[16]+J[17]+J[18]-J[19]+
    J[20]-J[21]+J[22]-J[23]-J[24]-J[25]-J[26]-J[27]+J[28]-J[29]-J[30]+J[31]+J[32]+J[33]+J[34]+J[35]-J[36]+
    J[37]-J[38]-J[39]-J[40]-J[41]-J[42]+J[43]-J[44]+J[45]+J[46]+J[47]+J[48]-J[49]+J[50]+J[51]+J[52]+J[53]-J[54]+
    J[55]+J[56]+J[57]-J[58]+J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]+H[1]-H[2]+H[3]-H[4]+H[5]+H[6]+
    H[7]+H[8]+H[9]-H[10]-H[11]+J[0]-J[1]+J[2]-J[3]+J[4]+J[5]+J[6]+J[7]+J[8]-J[9]-J[10]-J[11]+J[12]-J[13]+
    J[14]+J[15]+J[16]+J[17]+J[18]-J[19]-J[20]-J[21]+J[22]-J[23]-J[24]-J[25]-J[26]-J[27]+J[28]+J[29]-J[30]+
    J[31]+J[32]+J[33]+J[34]+J[35]-J[36]-J[37]-J[38]-J[39]-J[40]-J[41]-J[42]+J[43]+J[44]+J[45]+J[46]+J[47]+
    J[48]-J[49]-J[50]+J[51]+J[52]+J[53]-J[54]-J[55]+J[56]+J[57]-J[58]-J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+
    J[65], +H[0]+H[1]-H[2]+H[3]-H[4]+H[5]+H[6]+H[7]+H[8]-H[9]+H[10]+H[11]+J[0]-J[1]+J[2]-J[3]+J[4]+J[5]+
    J[6]+J[7]-J[8]+J[9]+J[10]-J[11]+J[12]-J[13]+J[14]+J[15]+J[16]+J[17]-J[18]+J[19]+J[20]-J[21]+J[22]-J[23]-J[24]-J[25]-J[26]+
    J[27]-J[28]-J[29]-J[30]+J[31]+J[32]+J[33]+J[34]-J[35]+J[36]+J[37]-J[38]-J[39]-J[40]-J[41]+J[42]-J[43]-J[44]+
    J[45]+J[46]+J[47]-J[48]+J[49]+J[50]+J[51]+J[52]-J[53]+J[54]+J[55]+J[56]-J[57]+J[58]+J[59]-J[60]+J[61]+
    J[62]-J[63]-J[64]+J[65], +H[0]+H[1]-H[2]+H[3]-H[4]+H[5]+H[6]+H[7]+H[8]-H[9]+H[10]-H[11]+J[0]-J[1]+J[2]-J[3]+
    J[4]+J[5]+J[6]+J[7]-J[8]+J[9]-J[10]-J[11]+J[12]-J[13]+J[14]+J[15]+J[16]+J[17]-J[18]+J[19]-J[20]-J[21]+
    J[22]-J[23]-J[24]-J[25]-J[26]+J[27]-J[28]+J[29]-J[30]+J[31]+J[32]+J[33]+J[34]-J[35]+J[36]-J[37]-J[38]-J[39]-J[40]-J[41]+
    J[42]-J[43]+J[44]+J[45]+J[46]+J[47]-J[48]+J[49]-J[50]+J[51]+J[52]-J[53]+J[54]-J[55]+J[56]-J[57]+J[58]-J[59]-J[60]+
    J[61]-J[62]-J[63]+J[64]-J[65], +H[0]+H[1]-H[2]+H[3]-H[4]+H[5]+H[6]+H[7]+H[8]-H[9]-H[10]+H[11]+J[0]-J[1]+
    J[2]-J[3]+J[4]+J[5]+J[6]+J[7]-J[8]-J[9]+J[10]-J[11]+J[12]-J[13]+J[14]+J[15]+J[16]+J[17]-J[18]-J[19]+
    J[20]-J[21]+J[22]-J[23]-J[24]-J[25]-J[26]+J[27]+J[28]-J[29]-J[30]+J[31]+J[32]+J[33]+J[34]-J[35]-J[36]+
    J[37]-J[38]-J[39]-J[40]-J[41]+J[42]+J[43]-J[44]+J[45]+J[46]+J[47]-J[48]-J[49]+J[50]+J[51]+J[52]-J[53]-J[54]+
    J[55]+J[56]-J[57]-J[58]+J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]+H[1]-H[2]+H[3]-H[4]+H[5]+H[6]+
    H[7]+H[8]-H[9]-H[10]-H[11]+J[0]-J[1]+J[2]-J[3]+J[4]+J[5]+J[6]+J[7]-J[8]-J[9]-J[10]-J[11]+J[12]-J[13]+
    J[14]+J[15]+J[16]+J[17]-J[18]-J[19]-J[20]-J[21]+J[22]-J[23]-J[24]-J[25]-J[26]+J[27]+J[28]+J[29]-J[30]+
    J[31]+J[32]+J[33]+J[34]-J[35]-J[36]-J[37]-J[38]-J[39]-J[40]-J[41]+J[42]+J[43]+J[44]+J[45]+J[46]+J[47]-J[48]-J[49]-J[50]+
    J[51]+J[52]-J[53]-J[54]-J[55]+J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]+H[1]-H[2]+
    H[3]-H[4]+H[5]+H[6]+H[7]-H[8]+H[9]+H[10]+H[11]+J[0]-J[1]+J[2]-J[3]+J[4]+J[5]+J[6]-J[7]+J[8]+J[9]+J[10]-J[11]+
    J[12]-J[13]+J[14]+J[15]+J[16]-J[17]+J[18]+J[19]+J[20]-J[21]+J[22]-J[23]-J[24]-J[25]+J[26]-J[27]-J[28]-J[29]-J[30]+
    J[31]+J[32]+J[33]-J[34]+J[35]+J[36]+J[37]-J[38]-J[39]-J[40]+J[41]-J[42]-J[43]-J[44]+J[45]+J[46]-J[47]+
    J[48]+J[49]+J[50]+J[51]-J[52]+J[53]+J[54]+J[55]-J[56]+J[57]+J[58]+J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+
    J[65], +H[0]+H[1]-H[2]+H[3]-H[4]+H[5]+H[6]+H[7]-H[8]+H[9]+H[10]-H[11]+J[0]-J[1]+J[2]-J[3]+J[4]+J[5]+
    J[6]-J[7]+J[8]+J[9]-J[10]-J[11]+J[12]-J[13]+J[14]+J[15]+J[16]-J[17]+J[18]+J[19]-J[20]-J[21]+J[22]-J[23]-J[24]-J[25]+
    J[26]-J[27]-J[28]+J[29]-J[30]+J[31]+J[32]+J[33]-J[34]+J[35]+J[36]-J[37]-J[38]-J[39]-J[40]+J[41]-J[42]-J[43]+
    J[44]+J[45]+J[46]-J[47]+J[48]+J[49]-J[50]+J[51]-J[52]+J[53]+J[54]-J[55]-J[56]+J[57]+J[58]-J[59]-J[60]-J[61]+
    J[62]+J[63]-J[64]-J[65], +H[0]+H[1]-H[2]+H[3]-H[4]+H[5]+H[6]+H[7]-H[8]+H[9]-H[10]+H[11]+J[0]-J[1]+J[2]-J[3]+
    J[4]+J[5]+J[6]-J[7]+J[8]-J[9]+J[10]-J[11]+J[12]-J[13]+J[14]+J[15]+J[16]-J[17]+J[18]-J[19]+J[20]-J[21]+
    J[22]-J[23]-J[24]-J[25]+J[26]-J[27]+J[28]-J[29]-J[30]+J[31]+J[32]+J[33]-J[34]+J[35]-J[36]+J[37]-J[38]-J[39]-J[40]+
    J[41]-J[42]+J[43]-J[44]+J[45]+J[46]-J[47]+J[48]-J[49]+J[50]+J[51]-J[52]+J[53]-J[54]+J[55]-J[56]+J[57]-J[58]+
    J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]+H[1]-H[2]+H[3]-H[4]+H[5]+H[6]+H[7]-H[8]+H[9]-H[10]-H[11]+
    J[0]-J[1]+J[2]-J[3]+J[4]+J[5]+J[6]-J[7]+J[8]-J[9]-J[10]-J[11]+J[12]-J[13]+J[14]+J[15]+J[16]-J[17]+J[18]-J[19]-J[20]-J[21]+
    J[22]-J[23]-J[24]-J[25]+J[26]-J[27]+J[28]+J[29]-J[30]+J[31]+J[32]+J[33]-J[34]+J[35]-J[36]-J[37]-J[38]-J[39]-J[40]+
    J[41]-J[42]+J[43]+J[44]+J[45]+J[46]-J[47]+J[48]-J[49]-J[50]+J[51]-J[52]+J[53]-J[54]-J[55]-J[56]+J[57]-J[58]-J[59]-J[60]+
    J[61]+J[62]-J[63]-J[64]+J[65], +H[0]+H[1]-H[2]+H[3]-H[4]+H[5]+H[6]+H[7]-H[8]-H[9]+H[10]+H[11]+J[0]-J[1]+
    J[2]-J[3]+J[4]+J[5]+J[6]-J[7]-J[8]+J[9]+J[10]-J[11]+J[12]-J[13]+J[14]+J[15]+J[16]-J[17]-J[18]+J[19]+
    J[20]-J[21]+J[22]-J[23]-J[24]-J[25]+J[26]+J[27]-J[28]-J[29]-J[30]+J[31]+J[32]+J[33]-J[34]-J[35]+J[36]+
    J[37]-J[38]-J[39]-J[40]+J[41]+J[42]-J[43]-J[44]+J[45]+J[46]-J[47]-J[48]+J[49]+J[50]+J[51]-J[52]-J[53]+
    J[54]+J[55]-J[56]-J[57]+J[58]+J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]+H[1]-H[2]+H[3]-H[4]+H[5]+
    H[6]+H[7]-H[8]-H[9]+H[10]-H[11]+J[0]-J[1]+J[2]-J[3]+J[4]+J[5]+J[6]-J[7]-J[8]+J[9]-J[10]-J[11]+J[12]-J[13]+
    J[14]+J[15]+J[16]-J[17]-J[18]+J[19]-J[20]-J[21]+J[22]-J[23]-J[24]-J[25]+J[26]+J[27]-J[28]+J[29]-J[30]+
    J[31]+J[32]+J[33]-J[34]-J[35]+J[36]-J[37]-J[38]-J[39]-J[40]+J[41]+J[42]-J[43]+J[44]+J[45]+J[46]-J[47]-J[48]+
    J[49]-J[50]+J[51]-J[52]-J[53]+J[54]-J[55]-J[56]-J[57]+J[58]-J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +
    H[0]+H[1]-H[2]+H[3]-H[4]+H[5]+H[6]+H[7]-H[8]-H[9]-H[10]+H[11]+J[0]-J[1]+J[2]-J[3]+J[4]+J[5]+J[6]-J[7]-J[8]-J[9]+
    J[10]-J[11]+J[12]-J[13]+J[14]+J[15]+J[16]-J[17]-J[18]-J[19]+J[20]-J[21]+J[22]-J[23]-J[24]-J[25]+J[26]+
    J[27]+J[28]-J[29]-J[30]+J[31]+J[32]+J[33]-J[34]-J[35]-J[36]+J[37]-J[38]-J[39]-J[40]+J[41]+J[42]+J[43]-J[44]+
    J[45]+J[46]-J[47]-J[48]-J[49]+J[50]+J[51]-J[52]-J[53]-J[54]+J[55]-J[56]-J[57]-J[58]+J[59]+J[60]+J[61]-J[62]+
    J[63]-J[64]-J[65], +H[0]+H[1]-H[2]+H[3]-H[4]+H[5]+H[6]+H[7]-H[8]-H[9]-H[10]-H[11]+J[0]-J[1]+J[2]-J[3]+
    J[4]+J[5]+J[6]-J[7]-J[8]-J[9]-J[10]-J[11]+J[12]-J[13]+J[14]+J[15]+J[16]-J[17]-J[18]-J[19]-J[20]-J[21]+
    J[22]-J[23]-J[24]-J[25]+J[26]+J[27]+J[28]+J[29]-J[30]+J[31]+J[32]+J[33]-J[34]-J[35]-J[36]-J[37]-J[38]-J[39]-J[40]+
    J[41]+J[42]+J[43]+J[44]+J[45]+J[46]-J[47]-J[48]-J[49]-J[50]+J[51]-J[52]-J[53]-J[54]-J[55]-J[56]-J[57]-J[58]-J[59]+
    J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]+H[1]-H[2]+H[3]-H[4]+H[5]+H[6]-H[7]+H[8]+H[9]+H[10]+H[11]+
    J[0]-J[1]+J[2]-J[3]+J[4]+J[5]-J[6]+J[7]+J[8]+J[9]+J[10]-J[11]+J[12]-J[13]+J[14]+J[15]-J[16]+J[17]+J[18]+
    J[19]+J[20]-J[21]+J[22]-J[23]-J[24]+J[25]-J[26]-J[27]-J[28]-J[29]-J[30]+J[31]+J[32]-J[33]+J[34]+J[35]+
    J[36]+J[37]-J[38]-J[39]+J[40]-J[41]-J[42]-J[43]-J[44]+J[45]-J[46]+J[47]+J[48]+J[49]+J[50]-J[51]+J[52]+
    J[53]+J[54]+J[55]-J[56]-J[57]-J[58]-J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]+H[1]-H[2]+H[3]-H[4]+
    H[5]+H[6]-H[7]+H[8]+H[9]+H[10]-H[11]+J[0]-J[1]+J[2]-J[3]+J[4]+J[5]-J[6]+J[7]+J[8]+J[9]-J[10]-J[11]+J[12]-J[13]+
    J[14]+J[15]-J[16]+J[17]+J[18]+J[19]-J[20]-J[21]+J[22]-J[23]-J[24]+J[25]-J[26]-J[27]-J[28]+J[29]-J[30]+
    J[31]+J[32]-J[33]+J[34]+J[35]+J[36]-J[37]-J[38]-J[39]+J[40]-J[41]-J[42]-J[43]+J[44]+J[45]-J[46]+J[47]+
    J[48]+J[49]-J[50]-J[51]+J[52]+J[53]+J[54]-J[55]-J[56]-J[57]-J[58]+J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +
    H[0]+H[1]-H[2]+H[3]-H[4]+H[5]+H[6]-H[7]+H[8]+H[9]-H[10]+H[11]+J[0]-J[1]+J[2]-J[3]+J[4]+J[5]-J[6]+J[7]+
    J[8]-J[9]+J[10]-J[11]+J[12]-J[13]+J[14]+J[15]-J[16]+J[17]+J[18]-J[19]+J[20]-J[21]+J[22]-J[23]-J[24]+
    J[25]-J[26]-J[27]+J[28]-J[29]-J[30]+J[31]+J[32]-J[33]+J[34]+J[35]-J[36]+J[37]-J[38]-J[39]+J[40]-J[41]-J[42]+
    J[43]-J[44]+J[45]-J[46]+J[47]+J[48]-J[49]+J[50]-J[51]+J[52]+J[53]-J[54]+J[55]-J[56]-J[57]+J[58]-J[59]+
    J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]+H[1]-H[2]+H[3]-H[4]+H[5]+H[6]-H[7]+H[8]+H[9]-H[10]-H[11]+
    J[0]-J[1]+J[2]-J[3]+J[4]+J[5]-J[6]+J[7]+J[8]-J[9]-J[10]-J[11]+J[12]-J[13]+J[14]+J[15]-J[16]+J[17]+J[18]-J[19]-J[20]-J[21]+
    J[22]-J[23]-J[24]+J[25]-J[26]-J[27]+J[28]+J[29]-J[30]+J[31]+J[32]-J[33]+J[34]+J[35]-J[36]-J[37]-J[38]-J[39]+
    J[40]-J[41]-J[42]+J[43]+J[44]+J[45]-J[46]+J[47]+J[48]-J[49]-J[50]-J[51]+J[52]+J[53]-J[54]-J[55]-J[56]-J[57]+
    J[58]+J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]+H[1]-H[2]+H[3]-H[4]+H[5]+H[6]-H[7]+H[8]-H[9]+
    H[10]+H[11]+J[0]-J[1]+J[2]-J[3]+J[4]+J[5]-J[6]+J[7]-J[8]+J[9]+J[10]-J[11]+J[12]-J[13]+J[14]+J[15]-J[16]+
    J[17]-J[18]+J[19]+J[20]-J[21]+J[22]-J[23]-J[24]+J[25]-J[26]+J[27]-J[28]-J[29]-J[30]+J[31]+J[32]-J[33]+
    J[34]-J[35]+J[36]+J[37]-J[38]-J[39]+J[40]-J[41]+J[42]-J[43]-J[44]+J[45]-J[46]+J[47]-J[48]+J[49]+J[50]-J[51]+
    J[52]-J[53]+J[54]+J[55]-J[56]+J[57]-J[58]-J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]+H[1]-H[2]+
    H[3]-H[4]+H[5]+H[6]-H[7]+H[8]-H[9]+H[10]-H[11]+J[0]-J[1]+J[2]-J[3]+J[4]+J[5]-J[6]+J[7]-J[8]+J[9]-J[10]-J[11]+
    J[12]-J[13]+J[14]+J[15]-J[16]+J[17]-J[18]+J[19]-J[20]-J[21]+J[22]-J[23]-J[24]+J[25]-J[26]+J[27]-J[28]+
    J[29]-J[30]+J[31]+J[32]-J[33]+J[34]-J[35]+J[36]-J[37]-J[38]-J[39]+J[40]-J[41]+J[42]-J[43]+J[44]+J[45]-J[46]+
    J[47]-J[48]+J[49]-J[50]-J[51]+J[52]-J[53]+J[54]-J[55]-J[56]+J[57]-J[58]+J[59]-J[60]+J[61]-J[62]-J[63]+
    J[64]-J[65], +H[0]+H[1]-H[2]+H[3]-H[4]+H[5]+H[6]-H[7]+H[8]-H[9]-H[10]+H[11]+J[0]-J[1]+J[2]-J[3]+J[4]+
    J[5]-J[6]+J[7]-J[8]-J[9]+J[10]-J[11]+J[12]-J[13]+J[14]+J[15]-J[16]+J[17]-J[18]-J[19]+J[20]-J[21]+J[22]-J[23]-J[24]+
    J[25]-J[26]+J[27]+J[28]-J[29]-J[30]+J[31]+J[32]-J[33]+J[34]-J[35]-J[36]+J[37]-J[38]-J[39]+J[40]-J[41]+
    J[42]+J[43]-J[44]+J[45]-J[46]+J[47]-J[48]-J[49]+J[50]-J[51]+J[52]-J[53]-J[54]+J[55]-J[56]+J[57]+J[58]-J[59]-J[60]-J[61]+
    J[62]+J[63]-J[64]-J[65], +H[0]+H[1]-H[2]+H[3]-H[4]+H[5]+H[6]-H[7]+H[8]-H[9]-H[10]-H[11]+J[0]-J[1]+J[2]-J[3]+
    J[4]+J[5]-J[6]+J[7]-J[8]-J[9]-J[10]-J[11]+J[12]-J[13]+J[14]+J[15]-J[16]+J[17]-J[18]-J[19]-J[20]-J[21]+
    J[22]-J[23]-J[24]+J[25]-J[26]+J[27]+J[28]+J[29]-J[30]+J[31]+J[32]-J[33]+J[34]-J[35]-J[36]-J[37]-J[38]-J[39]+
    J[40]-J[41]+J[42]+J[43]+J[44]+J[45]-J[46]+J[47]-J[48]-J[49]-J[50]-J[51]+J[52]-J[53]-J[54]-J[55]-J[56]+
    J[57]+J[58]+J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]+H[1]-H[2]+H[3]-H[4]+H[5]+H[6]-H[7]-H[8]+
    H[9]+H[10]+H[11]+J[0]-J[1]+J[2]-J[3]+J[4]+J[5]-J[6]-J[7]+J[8]+J[9]+J[10]-J[11]+J[12]-J[13]+J[14]+J[15]-J[16]-J[17]+
    J[18]+J[19]+J[20]-J[21]+J[22]-J[23]-J[24]+J[25]+J[26]-J[27]-J[28]-J[29]-J[30]+J[31]+J[32]-J[33]-J[34]+
    J[35]+J[36]+J[37]-J[38]-J[39]+J[40]+J[41]-J[42]-J[43]-J[44]+J[45]-J[46]-J[47]+J[48]+J[49]+J[50]-J[51]-J[52]+
    J[53]+J[54]+J[55]+J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]+H[1]-H[2]+H[3]-H[4]+
    H[5]+H[6]-H[7]-H[8]+H[9]+H[10]-H[11]+J[0]-J[1]+J[2]-J[3]+J[4]+J[5]-J[6]-J[7]+J[8]+J[9]-J[10]-J[11]+J[12]-J[13]+
    J[14]+J[15]-J[16]-J[17]+J[18]+J[19]-J[20]-J[21]+J[22]-J[23]-J[24]+J[25]+J[26]-J[27]-J[28]+J[29]-J[30]+
    J[31]+J[32]-J[33]-J[34]+J[35]+J[36]-J[37]-J[38]-J[39]+J[40]+J[41]-J[42]-J[43]+J[44]+J[45]-J[46]-J[47]+
    J[48]+J[49]-J[50]-J[51]-J[52]+J[53]+J[54]-J[55]+J[56]-J[57]-J[58]+J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +
    H[0]+H[1]-H[2]+H[3]-H[4]+H[5]+H[6]-H[7]-H[8]+H[9]-H[10]+H[11]+J[0]-J[1]+J[2]-J[3]+J[4]+J[5]-J[6]-J[7]+
    J[8]-J[9]+J[10]-J[11]+J[12]-J[13]+J[14]+J[15]-J[16]-J[17]+J[18]-J[19]+J[20]-J[21]+J[22]-J[23]-J[24]+
    J[25]+J[26]-J[27]+J[28]-J[29]-J[30]+J[31]+J[32]-J[33]-J[34]+J[35]-J[36]+J[37]-J[38]-J[39]+J[40]+J[41]-J[42]+
    J[43]-J[44]+J[45]-J[46]-J[47]+J[48]-J[49]+J[50]-J[51]-J[52]+J[53]-J[54]+J[55]+J[56]-J[57]+J[58]-J[59]-J[60]+
    J[61]-J[62]-J[63]+J[64]-J[65], +H[0]+H[1]-H[2]+H[3]-H[4]+H[5]+H[6]-H[7]-H[8]+H[9]-H[10]-H[11]+J[0]-J[1]+
    J[2]-J[3]+J[4]+J[5]-J[6]-J[7]+J[8]-J[9]-J[10]-J[11]+J[12]-J[13]+J[14]+J[15]-J[16]-J[17]+J[18]-J[19]-J[20]-J[21]+
    J[22]-J[23]-J[24]+J[25]+J[26]-J[27]+J[28]+J[29]-J[30]+J[31]+J[32]-J[33]-J[34]+J[35]-J[36]-J[37]-J[38]-J[39]+
    J[40]+J[41]-J[42]+J[43]+J[44]+J[45]-J[46]-J[47]+J[48]-J[49]-J[50]-J[51]-J[52]+J[53]-J[54]-J[55]+J[56]-J[57]+
    J[58]+J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]+H[1]-H[2]+H[3]-H[4]+H[5]+H[6]-H[7]-H[8]-H[9]+
    H[10]+H[11]+J[0]-J[1]+J[2]-J[3]+J[4]+J[5]-J[6]-J[7]-J[8]+J[9]+J[10]-J[11]+J[12]-J[13]+J[14]+J[15]-J[16]-J[17]-J[18]+
    J[19]+J[20]-J[21]+J[22]-J[23]-J[24]+J[25]+J[26]+J[27]-J[28]-J[29]-J[30]+J[31]+J[32]-J[33]-J[34]-J[35]+
    J[36]+J[37]-J[38]-J[39]+J[40]+J[41]+J[42]-J[43]-J[44]+J[45]-J[46]-J[47]-J[48]+J[49]+J[50]-J[51]-J[52]-J[53]+
    J[54]+J[55]+J[56]+J[57]-J[58]-J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]+H[1]-H[2]+H[3]-H[4]+H[5]+
    H[6]-H[7]-H[8]-H[9]+H[10]-H[11]+J[0]-J[1]+J[2]-J[3]+J[4]+J[5]-J[6]-J[7]-J[8]+J[9]-J[10]-J[11]+J[12]-J[13]+
    J[14]+J[15]-J[16]-J[17]-J[18]+J[19]-J[20]-J[21]+J[22]-J[23]-J[24]+J[25]+J[26]+J[27]-J[28]+J[29]-J[30]+
    J[31]+J[32]-J[33]-J[34]-J[35]+J[36]-J[37]-J[38]-J[39]+J[40]+J[41]+J[42]-J[43]+J[44]+J[45]-J[46]-J[47]-J[48]+
    J[49]-J[50]-J[51]-J[52]-J[53]+J[54]-J[55]+J[56]+J[57]-J[58]+J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +
    H[0]+H[1]-H[2]+H[3]-H[4]+H[5]+H[6]-H[7]-H[8]-H[9]-H[10]+H[11]+J[0]-J[1]+J[2]-J[3]+J[4]+J[5]-J[6]-J[7]-J[8]-J[9]+
    J[10]-J[11]+J[12]-J[13]+J[14]+J[15]-J[16]-J[17]-J[18]-J[19]+J[20]-J[21]+J[22]-J[23]-J[24]+J[25]+J[26]+
    J[27]+J[28]-J[29]-J[30]+J[31]+J[32]-J[33]-J[34]-J[35]-J[36]+J[37]-J[38]-J[39]+J[40]+J[41]+J[42]+J[43]-J[44]+
    J[45]-J[46]-J[47]-J[48]-J[49]+J[50]-J[51]-J[52]-J[53]-J[54]+J[55]+J[56]+J[57]+J[58]-J[59]+J[60]+J[61]-J[62]+
    J[63]-J[64]-J[65], +H[0]+H[1]-H[2]+H[3]-H[4]+H[5]+H[6]-H[7]-H[8]-H[9]-H[10]-H[11]+J[0]-J[1]+J[2]-J[3]+
    J[4]+J[5]-J[6]-J[7]-J[8]-J[9]-J[10]-J[11]+J[12]-J[13]+J[14]+J[15]-J[16]-J[17]-J[18]-J[19]-J[20]-J[21]+
    J[22]-J[23]-J[24]+J[25]+J[26]+J[27]+J[28]+J[29]-J[30]+J[31]+J[32]-J[33]-J[34]-J[35]-J[36]-J[37]-J[38]-J[39]+
    J[40]+J[41]+J[42]+J[43]+J[44]+J[45]-J[46]-J[47]-J[48]-J[49]-J[50]-J[51]-J[52]-J[53]-J[54]-J[55]+J[56]+
    J[57]+J[58]+J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]+H[1]-H[2]+H[3]-H[4]+H[5]-H[6]+H[7]+H[8]+
    H[9]+H[10]+H[11]+J[0]-J[1]+J[2]-J[3]+J[4]-J[5]+J[6]+J[7]+J[8]+J[9]+J[10]-J[11]+J[12]-J[13]+J[14]-J[15]+
    J[16]+J[17]+J[18]+J[19]+J[20]-J[21]+J[22]-J[23]+J[24]-J[25]-J[26]-J[27]-J[28]-J[29]-J[30]+J[31]-J[32]+
    J[33]+J[34]+J[35]+J[36]+J[37]-J[38]+J[39]-J[40]-J[41]-J[42]-J[43]-J[44]-J[45]+J[46]+J[47]+J[48]+J[49]+
    J[50]-J[51]-J[52]-J[53]-J[54]-J[55]+J[56]+J[57]+J[58]+J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]+
    H[1]-H[2]+H[3]-H[4]+H[5]-H[6]+H[7]+H[8]+H[9]+H[10]-H[11]+J[0]-J[1]+J[2]-J[3]+J[4]-J[5]+J[6]+J[7]+J[8]+
    J[9]-J[10]-J[11]+J[12]-J[13]+J[14]-J[15]+J[16]+J[17]+J[18]+J[19]-J[20]-J[21]+J[22]-J[23]+J[24]-J[25]-J[26]-J[27]-J[28]+
    J[29]-J[30]+J[31]-J[32]+J[33]+J[34]+J[35]+J[36]-J[37]-J[38]+J[39]-J[40]-J[41]-J[42]-J[43]+J[44]-J[45]+
    J[46]+J[47]+J[48]+J[49]-J[50]-J[51]-J[52]-J[53]-J[54]+J[55]+J[56]+J[57]+J[58]-J[59]+J[60]+J[61]-J[62]+
    J[63]-J[64]-J[65], +H[0]+H[1]-H[2]+H[3]-H[4]+H[5]-H[6]+H[7]+H[8]+H[9]-H[10]+H[11]+J[0]-J[1]+J[2]-J[3]+
    J[4]-J[5]+J[6]+J[7]+J[8]-J[9]+J[10]-J[11]+J[12]-J[13]+J[14]-J[15]+J[16]+J[17]+J[18]-J[19]+J[20]-J[21]+
    J[22]-J[23]+J[24]-J[25]-J[26]-J[27]+J[28]-J[29]-J[30]+J[31]-J[32]+J[33]+J[34]+J[35]-J[36]+J[37]-J[38]+
    J[39]-J[40]-J[41]-J[42]+J[43]-J[44]-J[45]+J[46]+J[47]+J[48]-J[49]+J[50]-J[51]-J[52]-J[53]+J[54]-J[55]+
    J[56]+J[57]-J[58]+J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]+H[1]-H[2]+H[3]-H[4]+H[5]-H[6]+H[7]+
    H[8]+H[9]-H[10]-H[11]+J[0]-J[1]+J[2]-J[3]+J[4]-J[5]+J[6]+J[7]+J[8]-J[9]-J[10]-J[11]+J[12]-J[13]+J[14]-J[15]+
    J[16]+J[17]+J[18]-J[19]-J[20]-J[21]+J[22]-J[23]+J[24]-J[25]-J[26]-J[27]+J[28]+J[29]-J[30]+J[31]-J[32]+
    J[33]+J[34]+J[35]-J[36]-J[37]-J[38]+J[39]-J[40]-J[41]-J[42]+J[43]+J[44]-J[45]+J[46]+J[47]+J[48]-J[49]-J[50]-J[51]-J[52]-J[53]+
    J[54]+J[55]+J[56]+J[57]-J[58]-J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]+H[1]-H[2]+H[3]-H[4]+H[5]-H[6]+
    H[7]+H[8]-H[9]+H[10]+H[11]+J[0]-J[1]+J[2]-J[3]+J[4]-J[5]+J[6]+J[7]-J[8]+J[9]+J[10]-J[11]+J[12]-J[13]+
    J[14]-J[15]+J[16]+J[17]-J[18]+J[19]+J[20]-J[21]+J[22]-J[23]+J[24]-J[25]-J[26]+J[27]-J[28]-J[29]-J[30]+
    J[31]-J[32]+J[33]+J[34]-J[35]+J[36]+J[37]-J[38]+J[39]-J[40]-J[41]+J[42]-J[43]-J[44]-J[45]+J[46]+J[47]-J[48]+
    J[49]+J[50]-J[51]-J[52]+J[53]-J[54]-J[55]+J[56]-J[57]+J[58]+J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +
    H[0]+H[1]-H[2]+H[3]-H[4]+H[5]-H[6]+H[7]+H[8]-H[9]+H[10]-H[11]+J[0]-J[1]+J[2]-J[3]+J[4]-J[5]+J[6]+J[7]-J[8]+
    J[9]-J[10]-J[11]+J[12]-J[13]+J[14]-J[15]+J[16]+J[17]-J[18]+J[19]-J[20]-J[21]+J[22]-J[23]+J[24]-J[25]-J[26]+
    J[27]-J[28]+J[29]-J[30]+J[31]-J[32]+J[33]+J[34]-J[35]+J[36]-J[37]-J[38]+J[39]-J[40]-J[41]+J[42]-J[43]+
    J[44]-J[45]+J[46]+J[47]-J[48]+J[49]-J[50]-J[51]-J[52]+J[53]-J[54]+J[55]+J[56]-J[57]+J[58]-J[59]-J[60]+
    J[61]-J[62]-J[63]+J[64]-J[65], +H[0]+H[1]-H[2]+H[3]-H[4]+H[5]-H[6]+H[7]+H[8]-H[9]-H[10]+H[11]+J[0]-J[1]+
    J[2]-J[3]+J[4]-J[5]+J[6]+J[7]-J[8]-J[9]+J[10]-J[11]+J[12]-J[13]+J[14]-J[15]+J[16]+J[17]-J[18]-J[19]+
    J[20]-J[21]+J[22]-J[23]+J[24]-J[25]-J[26]+J[27]+J[28]-J[29]-J[30]+J[31]-J[32]+J[33]+J[34]-J[35]-J[36]+
    J[37]-J[38]+J[39]-J[40]-J[41]+J[42]+J[43]-J[44]-J[45]+J[46]+J[47]-J[48]-J[49]+J[50]-J[51]-J[52]+J[53]+
    J[54]-J[55]+J[56]-J[57]-J[58]+J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]+H[1]-H[2]+H[3]-H[4]+H[5]-H[6]+
    H[7]+H[8]-H[9]-H[10]-H[11]+J[0]-J[1]+J[2]-J[3]+J[4]-J[5]+J[6]+J[7]-J[8]-J[9]-J[10]-J[11]+J[12]-J[13]+
    J[14]-J[15]+J[16]+J[17]-J[18]-J[19]-J[20]-J[21]+J[22]-J[23]+J[24]-J[25]-J[26]+J[27]+J[28]+J[29]-J[30]+
    J[31]-J[32]+J[33]+J[34]-J[35]-J[36]-J[37]-J[38]+J[39]-J[40]-J[41]+J[42]+J[43]+J[44]-J[45]+J[46]+J[47]-J[48]-J[49]-J[50]-J[51]-J[52]+
    J[53]+J[54]+J[55]+J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]+H[1]-H[2]+H[3]-H[4]+
    H[5]-H[6]+H[7]-H[8]+H[9]+H[10]+H[11]+J[0]-J[1]+J[2]-J[3]+J[4]-J[5]+J[6]-J[7]+J[8]+J[9]+J[10]-J[11]+J[12]-J[13]+
    J[14]-J[15]+J[16]-J[17]+J[18]+J[19]+J[20]-J[21]+J[22]-J[23]+J[24]-J[25]+J[26]-J[27]-J[28]-J[29]-J[30]+
    J[31]-J[32]+J[33]-J[34]+J[35]+J[36]+J[37]-J[38]+J[39]-J[40]+J[41]-J[42]-J[43]-J[44]-J[45]+J[46]-J[47]+
    J[48]+J[49]+J[50]-J[51]+J[52]-J[53]-J[54]-J[55]-J[56]+J[57]+J[58]+J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+
    J[65], +H[0]+H[1]-H[2]+H[3]-H[4]+H[5]-H[6]+H[7]-H[8]+H[9]+H[10]-H[11]+J[0]-J[1]+J[2]-J[3]+J[4]-J[5]+
    J[6]-J[7]+J[8]+J[9]-J[10]-J[11]+J[12]-J[13]+J[14]-J[15]+J[16]-J[17]+J[18]+J[19]-J[20]-J[21]+J[22]-J[23]+
    J[24]-J[25]+J[26]-J[27]-J[28]+J[29]-J[30]+J[31]-J[32]+J[33]-J[34]+J[35]+J[36]-J[37]-J[38]+J[39]-J[40]+
    J[41]-J[42]-J[43]+J[44]-J[45]+J[46]-J[47]+J[48]+J[49]-J[50]-J[51]+J[52]-J[53]-J[54]+J[55]-J[56]+J[57]+
    J[58]-J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]+H[1]-H[2]+H[3]-H[4]+H[5]-H[6]+H[7]-H[8]+H[9]-H[10]+
    H[11]+J[0]-J[1]+J[2]-J[3]+J[4]-J[5]+J[6]-J[7]+J[8]-J[9]+J[10]-J[11]+J[12]-J[13]+J[14]-J[15]+J[16]-J[17]+
    J[18]-J[19]+J[20]-J[21]+J[22]-J[23]+J[24]-J[25]+J[26]-J[27]+J[28]-J[29]-J[30]+J[31]-J[32]+J[33]-J[34]+
    J[35]-J[36]+J[37]-J[38]+J[39]-J[40]+J[41]-J[42]+J[43]-J[44]-J[45]+J[46]-J[47]+J[48]-J[49]+J[50]-J[51]+
    J[52]-J[53]+J[54]-J[55]-J[56]+J[57]-J[58]+J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]+H[1]-H[2]+
    H[3]-H[4]+H[5]-H[6]+H[7]-H[8]+H[9]-H[10]-H[11]+J[0]-J[1]+J[2]-J[3]+J[4]-J[5]+J[6]-J[7]+J[8]-J[9]-J[10]-J[11]+
    J[12]-J[13]+J[14]-J[15]+J[16]-J[17]+J[18]-J[19]-J[20]-J[21]+J[22]-J[23]+J[24]-J[25]+J[26]-J[27]+J[28]+
    J[29]-J[30]+J[31]-J[32]+J[33]-J[34]+J[35]-J[36]-J[37]-J[38]+J[39]-J[40]+J[41]-J[42]+J[43]+J[44]-J[45]+
    J[46]-J[47]+J[48]-J[49]-J[50]-J[51]+J[52]-J[53]+J[54]+J[55]-J[56]+J[57]-J[58]-J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+
    J[65], +H[0]+H[1]-H[2]+H[3]-H[4]+H[5]-H[6]+H[7]-H[8]-H[9]+H[10]+H[11]+J[0]-J[1]+J[2]-J[3]+J[4]-J[5]+
    J[6]-J[7]-J[8]+J[9]+J[10]-J[11]+J[12]-J[13]+J[14]-J[15]+J[16]-J[17]-J[18]+J[19]+J[20]-J[21]+J[22]-J[23]+
    J[24]-J[25]+J[26]+J[27]-J[28]-J[29]-J[30]+J[31]-J[32]+J[33]-J[34]-J[35]+J[36]+J[37]-J[38]+J[39]-J[40]+
    J[41]+J[42]-J[43]-J[44]-J[45]+J[46]-J[47]-J[48]+J[49]+J[50]-J[51]+J[52]+J[53]-J[54]-J[55]-J[56]-J[57]+
    J[58]+J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]+H[1]-H[2]+H[3]-H[4]+H[5]-H[6]+H[7]-H[8]-H[9]+
    H[10]-H[11]+J[0]-J[1]+J[2]-J[3]+J[4]-J[5]+J[6]-J[7]-J[8]+J[9]-J[10]-J[11]+J[12]-J[13]+J[14]-J[15]+J[16]-J[17]-J[18]+
    J[19]-J[20]-J[21]+J[22]-J[23]+J[24]-J[25]+J[26]+J[27]-J[28]+J[29]-J[30]+J[31]-J[32]+J[33]-J[34]-J[35]+
    J[36]-J[37]-J[38]+J[39]-J[40]+J[41]+J[42]-J[43]+J[44]-J[45]+J[46]-J[47]-J[48]+J[49]-J[50]-J[51]+J[52]+
    J[53]-J[54]+J[55]-J[56]-J[57]+J[58]-J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]+H[1]-H[2]+H[3]-H[4]+
    H[5]-H[6]+H[7]-H[8]-H[9]-H[10]+H[11]+J[0]-J[1]+J[2]-J[3]+J[4]-J[5]+J[6]-J[7]-J[8]-J[9]+J[10]-J[11]+J[12]-J[13]+
    J[14]-J[15]+J[16]-J[17]-J[18]-J[19]+J[20]-J[21]+J[22]-J[23]+J[24]-J[25]+J[26]+J[27]+J[28]-J[29]-J[30]+
    J[31]-J[32]+J[33]-J[34]-J[35]-J[36]+J[37]-J[38]+J[39]-J[40]+J[41]+J[42]+J[43]-J[44]-J[45]+J[46]-J[47]-J[48]-J[49]+
    J[50]-J[51]+J[52]+J[53]+J[54]-J[55]-J[56]-J[57]-J[58]+J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]+
    H[1]-H[2]+H[3]-H[4]+H[5]-H[6]+H[7]-H[8]-H[9]-H[10]-H[11]+J[0]-J[1]+J[2]-J[3]+J[4]-J[5]+J[6]-J[7]-J[8]-J[9]-J[10]-J[11]+
    J[12]-J[13]+J[14]-J[15]+J[16]-J[17]-J[18]-J[19]-J[20]-J[21]+J[22]-J[23]+J[24]-J[25]+J[26]+J[27]+J[28]+
    J[29]-J[30]+J[31]-J[32]+J[33]-J[34]-J[35]-J[36]-J[37]-J[38]+J[39]-J[40]+J[41]+J[42]+J[43]+J[44]-J[45]+
    J[46]-J[47]-J[48]-J[49]-J[50]-J[51]+J[52]+J[53]+J[54]+J[55]-J[56]-J[57]-J[58]-J[59]+J[60]+J[61]+J[62]+
    J[63]+J[64]+J[65], +H[0]+H[1]-H[2]+H[3]-H[4]+H[5]-H[6]-H[7]+H[8]+H[9]+H[10]+H[11]+J[0]-J[1]+J[2]-J[3]+
    J[4]-J[5]-J[6]+J[7]+J[8]+J[9]+J[10]-J[11]+J[12]-J[13]+J[14]-J[15]-J[16]+J[17]+J[18]+J[19]+J[20]-J[21]+
    J[22]-J[23]+J[24]+J[25]-J[26]-J[27]-J[28]-J[29]-J[30]+J[31]-J[32]-J[33]+J[34]+J[35]+J[36]+J[37]-J[38]+
    J[39]+J[40]-J[41]-J[42]-J[43]-J[44]-J[45]-J[46]+J[47]+J[48]+J[49]+J[50]+J[51]-J[52]-J[53]-J[54]-J[55]-J[56]-J[57]-J[58]-J[59]+
    J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]+H[1]-H[2]+H[3]-H[4]+H[5]-H[6]-H[7]+H[8]+H[9]+H[10]-H[11]+
    J[0]-J[1]+J[2]-J[3]+J[4]-J[5]-J[6]+J[7]+J[8]+J[9]-J[10]-J[11]+J[12]-J[13]+J[14]-J[15]-J[16]+J[17]+J[18]+
    J[19]-J[20]-J[21]+J[22]-J[23]+J[24]+J[25]-J[26]-J[27]-J[28]+J[29]-J[30]+J[31]-J[32]-J[33]+J[34]+J[35]+
    J[36]-J[37]-J[38]+J[39]+J[40]-J[41]-J[42]-J[43]+J[44]-J[45]-J[46]+J[47]+J[48]+J[49]-J[50]+J[51]-J[52]-J[53]-J[54]+
    J[55]-J[56]-J[57]-J[58]+J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]+H[1]-H[2]+H[3]-H[4]+H[5]-H[6]-H[7]+
    H[8]+H[9]-H[10]+H[11]+J[0]-J[1]+J[2]-J[3]+J[4]-J[5]-J[6]+J[7]+J[8]-J[9]+J[10]-J[11]+J[12]-J[13]+J[14]-J[15]-J[16]+
    J[17]+J[18]-J[19]+J[20]-J[21]+J[22]-J[23]+J[24]+J[25]-J[26]-J[27]+J[28]-J[29]-J[30]+J[31]-J[32]-J[33]+
    J[34]+J[35]-J[36]+J[37]-J[38]+J[39]+J[40]-J[41]-J[42]+J[43]-J[44]-J[45]-J[46]+J[47]+J[48]-J[49]+J[50]+
    J[51]-J[52]-J[53]+J[54]-J[55]-J[56]-J[57]+J[58]-J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]+H[1]-H[2]+
    H[3]-H[4]+H[5]-H[6]-H[7]+H[8]+H[9]-H[10]-H[11]+J[0]-J[1]+J[2]-J[3]+J[4]-J[5]-J[6]+J[7]+J[8]-J[9]-J[10]-J[11]+
    J[12]-J[13]+J[14]-J[15]-J[16]+J[17]+J[18]-J[19]-J[20]-J[21]+J[22]-J[23]+J[24]+J[25]-J[26]-J[27]+J[28]+
    J[29]-J[30]+J[31]-J[32]-J[33]+J[34]+J[35]-J[36]-J[37]-J[38]+J[39]+J[40]-J[41]-J[42]+J[43]+J[44]-J[45]-J[46]+
    J[47]+J[48]-J[49]-J[50]+J[51]-J[52]-J[53]+J[54]+J[55]-J[56]-J[57]+J[58]+J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+
    J[65], +H[0]+H[1]-H[2]+H[3]-H[4]+H[5]-H[6]-H[7]+H[8]-H[9]+H[10]+H[11]+J[0]-J[1]+J[2]-J[3]+J[4]-J[5]-J[6]+
    J[7]-J[8]+J[9]+J[10]-J[11]+J[12]-J[13]+J[14]-J[15]-J[16]+J[17]-J[18]+J[19]+J[20]-J[21]+J[22]-J[23]+J[24]+
    J[25]-J[26]+J[27]-J[28]-J[29]-J[30]+J[31]-J[32]-J[33]+J[34]-J[35]+J[36]+J[37]-J[38]+J[39]+J[40]-J[41]+
    J[42]-J[43]-J[44]-J[45]-J[46]+J[47]-J[48]+J[49]+J[50]+J[51]-J[52]+J[53]-J[54]-J[55]-J[56]+J[57]-J[58]-J[59]-J[60]+
    J[61]+J[62]-J[63]-J[64]+J[65], +H[0]+H[1]-H[2]+H[3]-H[4]+H[5]-H[6]-H[7]+H[8]-H[9]+H[10]-H[11]+J[0]-J[1]+
    J[2]-J[3]+J[4]-J[5]-J[6]+J[7]-J[8]+J[9]-J[10]-J[11]+J[12]-J[13]+J[14]-J[15]-J[16]+J[17]-J[18]+J[19]-J[20]-J[21]+
    J[22]-J[23]+J[24]+J[25]-J[26]+J[27]-J[28]+J[29]-J[30]+J[31]-J[32]-J[33]+J[34]-J[35]+J[36]-J[37]-J[38]+
    J[39]+J[40]-J[41]+J[42]-J[43]+J[44]-J[45]-J[46]+J[47]-J[48]+J[49]-J[50]+J[51]-J[52]+J[53]-J[54]+J[55]-J[56]+
    J[57]-J[58]+J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]+H[1]-H[2]+H[3]-H[4]+H[5]-H[6]-H[7]+H[8]-H[9]-H[10]+
    H[11]+J[0]-J[1]+J[2]-J[3]+J[4]-J[5]-J[6]+J[7]-J[8]-J[9]+J[10]-J[11]+J[12]-J[13]+J[14]-J[15]-J[16]+J[17]-J[18]-J[19]+
    J[20]-J[21]+J[22]-J[23]+J[24]+J[25]-J[26]+J[27]+J[28]-J[29]-J[30]+J[31]-J[32]-J[33]+J[34]-J[35]-J[36]+
    J[37]-J[38]+J[39]+J[40]-J[41]+J[42]+J[43]-J[44]-J[45]-J[46]+J[47]-J[48]-J[49]+J[50]+J[51]-J[52]+J[53]+
    J[54]-J[55]-J[56]+J[57]+J[58]-J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]+H[1]-H[2]+H[3]-H[4]+H[5]-H[6]-H[7]+
    H[8]-H[9]-H[10]-H[11]+J[0]-J[1]+J[2]-J[3]+J[4]-J[5]-J[6]+J[7]-J[8]-J[9]-J[10]-J[11]+J[12]-J[13]+J[14]-J[15]-J[16]+
    J[17]-J[18]-J[19]-J[20]-J[21]+J[22]-J[23]+J[24]+J[25]-J[26]+J[27]+J[28]+J[29]-J[30]+J[31]-J[32]-J[33]+
    J[34]-J[35]-J[36]-J[37]-J[38]+J[39]+J[40]-J[41]+J[42]+J[43]+J[44]-J[45]-J[46]+J[47]-J[48]-J[49]-J[50]+
    J[51]-J[52]+J[53]+J[54]+J[55]-J[56]+J[57]+J[58]+J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]+H[1]-H[2]+
    H[3]-H[4]+H[5]-H[6]-H[7]-H[8]+H[9]+H[10]+H[11]+J[0]-J[1]+J[2]-J[3]+J[4]-J[5]-J[6]-J[7]+J[8]+J[9]+J[10]-J[11]+
    J[12]-J[13]+J[14]-J[15]-J[16]-J[17]+J[18]+J[19]+J[20]-J[21]+J[22]-J[23]+J[24]+J[25]+J[26]-J[27]-J[28]-J[29]-J[30]+
    J[31]-J[32]-J[33]-J[34]+J[35]+J[36]+J[37]-J[38]+J[39]+J[40]+J[41]-J[42]-J[43]-J[44]-J[45]-J[46]-J[47]+
    J[48]+J[49]+J[50]+J[51]+J[52]-J[53]-J[54]-J[55]+J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+
    J[65], +H[0]+H[1]-H[2]+H[3]-H[4]+H[5]-H[6]-H[7]-H[8]+H[9]+H[10]-H[11]+J[0]-J[1]+J[2]-J[3]+J[4]-J[5]-J[6]-J[7]+
    J[8]+J[9]-J[10]-J[11]+J[12]-J[13]+J[14]-J[15]-J[16]-J[17]+J[18]+J[19]-J[20]-J[21]+J[22]-J[23]+J[24]+
    J[25]+J[26]-J[27]-J[28]+J[29]-J[30]+J[31]-J[32]-J[33]-J[34]+J[35]+J[36]-J[37]-J[38]+J[39]+J[40]+J[41]-J[42]-J[43]+
    J[44]-J[45]-J[46]-J[47]+J[48]+J[49]-J[50]+J[51]+J[52]-J[53]-J[54]+J[55]+J[56]-J[57]-J[58]+J[59]-J[60]-J[61]+
    J[62]+J[63]-J[64]-J[65], +H[0]+H[1]-H[2]+H[3]-H[4]+H[5]-H[6]-H[7]-H[8]+H[9]-H[10]+H[11]+J[0]-J[1]+J[2]-J[3]+
    J[4]-J[5]-J[6]-J[7]+J[8]-J[9]+J[10]-J[11]+J[12]-J[13]+J[14]-J[15]-J[16]-J[17]+J[18]-J[19]+J[20]-J[21]+
    J[22]-J[23]+J[24]+J[25]+J[26]-J[27]+J[28]-J[29]-J[30]+J[31]-J[32]-J[33]-J[34]+J[35]-J[36]+J[37]-J[38]+
    J[39]+J[40]+J[41]-J[42]+J[43]-J[44]-J[45]-J[46]-J[47]+J[48]-J[49]+J[50]+J[51]+J[52]-J[53]+J[54]-J[55]+
    J[56]-J[57]+J[58]-J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]+H[1]-H[2]+H[3]-H[4]+H[5]-H[6]-H[7]-H[8]+
    H[9]-H[10]-H[11]+J[0]-J[1]+J[2]-J[3]+J[4]-J[5]-J[6]-J[7]+J[8]-J[9]-J[10]-J[11]+J[12]-J[13]+J[14]-J[15]-J[16]-J[17]+
    J[18]-J[19]-J[20]-J[21]+J[22]-J[23]+J[24]+J[25]+J[26]-J[27]+J[28]+J[29]-J[30]+J[31]-J[32]-J[33]-J[34]+
    J[35]-J[36]-J[37]-J[38]+J[39]+J[40]+J[41]-J[42]+J[43]+J[44]-J[45]-J[46]-J[47]+J[48]-J[49]-J[50]+J[51]+
    J[52]-J[53]+J[54]+J[55]+J[56]-J[57]+J[58]+J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]+H[1]-H[2]+
    H[3]-H[4]+H[5]-H[6]-H[7]-H[8]-H[9]+H[10]+H[11]+J[0]-J[1]+J[2]-J[3]+J[4]-J[5]-J[6]-J[7]-J[8]+J[9]+J[10]-J[11]+
    J[12]-J[13]+J[14]-J[15]-J[16]-J[17]-J[18]+J[19]+J[20]-J[21]+J[22]-J[23]+J[24]+J[25]+J[26]+J[27]-J[28]-J[29]-J[30]+
    J[31]-J[32]-J[33]-J[34]-J[35]+J[36]+J[37]-J[38]+J[39]+J[40]+J[41]+J[42]-J[43]-J[44]-J[45]-J[46]-J[47]-J[48]+
    J[49]+J[50]+J[51]+J[52]+J[53]-J[54]-J[55]+J[56]+J[57]-J[58]-J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +
    H[0]+H[1]-H[2]+H[3]-H[4]+H[5]-H[6]-H[7]-H[8]-H[9]+H[10]-H[11]+J[0]-J[1]+J[2]-J[3]+J[4]-J[5]-J[6]-J[7]-J[8]+
    J[9]-J[10]-J[11]+J[12]-J[13]+J[14]-J[15]-J[16]-J[17]-J[18]+J[19]-J[20]-J[21]+J[22]-J[23]+J[24]+J[25]+
    J[26]+J[27]-J[28]+J[29]-J[30]+J[31]-J[32]-J[33]-J[34]-J[35]+J[36]-J[37]-J[38]+J[39]+J[40]+J[41]+J[42]-J[43]+
    J[44]-J[45]-J[46]-J[47]-J[48]+J[49]-J[50]+J[51]+J[52]+J[53]-J[54]+J[55]+J[56]+J[57]-J[58]+J[59]+J[60]-J[61]+
    J[62]-J[63]+J[64]-J[65], +H[0]+H[1]-H[2]+H[3]-H[4]+H[5]-H[6]-H[7]-H[8]-H[9]-H[10]+H[11]+J[0]-J[1]+J[2]-J[3]+
    J[4]-J[5]-J[6]-J[7]-J[8]-J[9]+J[10]-J[11]+J[12]-J[13]+J[14]-J[15]-J[16]-J[17]-J[18]-J[19]+J[20]-J[21]+
    J[22]-J[23]+J[24]+J[25]+J[26]+J[27]+J[28]-J[29]-J[30]+J[31]-J[32]-J[33]-J[34]-J[35]-J[36]+J[37]-J[38]+
    J[39]+J[40]+J[41]+J[42]+J[43]-J[44]-J[45]-J[46]-J[47]-J[48]-J[49]+J[50]+J[51]+J[52]+J[53]+J[54]-J[55]+
    J[56]+J[57]+J[58]-J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]+H[1]-H[2]+H[3]-H[4]+H[5]-H[6]-H[7]-H[8]-H[9]-H[10]-H[11]+
    J[0]-J[1]+J[2]-J[3]+J[4]-J[5]-J[6]-J[7]-J[8]-J[9]-J[10]-J[11]+J[12]-J[13]+J[14]-J[15]-J[16]-J[17]-J[18]-J[19]-J[20]-J[21]+
    J[22]-J[23]+J[24]+J[25]+J[26]+J[27]+J[28]+J[29]-J[30]+J[31]-J[32]-J[33]-J[34]-J[35]-J[36]-J[37]-J[38]+
    J[39]+J[40]+J[41]+J[42]+J[43]+J[44]-J[45]-J[46]-J[47]-J[48]-J[49]-J[50]+J[51]+J[52]+J[53]+J[54]+J[55]+
    J[56]+J[57]+J[58]+J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]+H[1]-H[2]+H[3]-H[4]-H[5]+H[6]+H[7]+
    H[8]+H[9]+H[10]+H[11]+J[0]-J[1]+J[2]-J[3]-J[4]+J[5]+J[6]+J[7]+J[8]+J[9]+J[10]-J[11]+J[12]-J[13]-J[14]+
    J[15]+J[16]+J[17]+J[18]+J[19]+J[20]-J[21]+J[22]+J[23]-J[24]-J[25]-J[26]-J[27]-J[28]-J[29]-J[30]-J[31]+
    J[32]+J[33]+J[34]+J[35]+J[36]+J[37]+J[38]-J[39]-J[40]-J[41]-J[42]-J[43]-J[44]-J[45]-J[46]-J[47]-J[48]-J[49]-J[50]+
    J[51]+J[52]+J[53]+J[54]+J[55]+J[56]+J[57]+J[58]+J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]+H[1]-H[2]+
    H[3]-H[4]-H[5]+H[6]+H[7]+H[8]+H[9]+H[10]-H[11]+J[0]-J[1]+J[2]-J[3]-J[4]+J[5]+J[6]+J[7]+J[8]+J[9]-J[10]-J[11]+
    J[12]-J[13]-J[14]+J[15]+J[16]+J[17]+J[18]+J[19]-J[20]-J[21]+J[22]+J[23]-J[24]-J[25]-J[26]-J[27]-J[28]+
    J[29]-J[30]-J[31]+J[32]+J[33]+J[34]+J[35]+J[36]-J[37]+J[38]-J[39]-J[40]-J[41]-J[42]-J[43]+J[44]-J[45]-J[46]-J[47]-J[48]-J[49]+
    J[50]+J[51]+J[52]+J[53]+J[54]-J[55]+J[56]+J[57]+J[58]-J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]+
    H[1]-H[2]+H[3]-H[4]-H[5]+H[6]+H[7]+H[8]+H[9]-H[10]+H[11]+J[0]-J[1]+J[2]-J[3]-J[4]+J[5]+J[6]+J[7]+J[8]-J[9]+
    J[10]-J[11]+J[12]-J[13]-J[14]+J[15]+J[16]+J[17]+J[18]-J[19]+J[20]-J[21]+J[22]+J[23]-J[24]-J[25]-J[26]-J[27]+
    J[28]-J[29]-J[30]-J[31]+J[32]+J[33]+J[34]+J[35]-J[36]+J[37]+J[38]-J[39]-J[40]-J[41]-J[42]+J[43]-J[44]-J[45]-J[46]-J[47]-J[48]+
    J[49]-J[50]+J[51]+J[52]+J[53]-J[54]+J[55]+J[56]+J[57]-J[58]+J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +
    H[0]+H[1]-H[2]+H[3]-H[4]-H[5]+H[6]+H[7]+H[8]+H[9]-H[10]-H[11]+J[0]-J[1]+J[2]-J[3]-J[4]+J[5]+J[6]+J[7]+
    J[8]-J[9]-J[10]-J[11]+J[12]-J[13]-J[14]+J[15]+J[16]+J[17]+J[18]-J[19]-J[20]-J[21]+J[22]+J[23]-J[24]-J[25]-J[26]-J[27]+
    J[28]+J[29]-J[30]-J[31]+J[32]+J[33]+J[34]+J[35]-J[36]-J[37]+J[38]-J[39]-J[40]-J[41]-J[42]+J[43]+J[44]-J[45]-J[46]-J[47]-J[48]+
    J[49]+J[50]+J[51]+J[52]+J[53]-J[54]-J[55]+J[56]+J[57]-J[58]-J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +
    H[0]+H[1]-H[2]+H[3]-H[4]-H[5]+H[6]+H[7]+H[8]-H[9]+H[10]+H[11]+J[0]-J[1]+J[2]-J[3]-J[4]+J[5]+J[6]+J[7]-J[8]+
    J[9]+J[10]-J[11]+J[12]-J[13]-J[14]+J[15]+J[16]+J[17]-J[18]+J[19]+J[20]-J[21]+J[22]+J[23]-J[24]-J[25]-J[26]+
    J[27]-J[28]-J[29]-J[30]-J[31]+J[32]+J[33]+J[34]-J[35]+J[36]+J[37]+J[38]-J[39]-J[40]-J[41]+J[42]-J[43]-J[44]-J[45]-J[46]-J[47]+
    J[48]-J[49]-J[50]+J[51]+J[52]-J[53]+J[54]+J[55]+J[56]-J[57]+J[58]+J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+
    J[65], +H[0]+H[1]-H[2]+H[3]-H[4]-H[5]+H[6]+H[7]+H[8]-H[9]+H[10]-H[11]+J[0]-J[1]+J[2]-J[3]-J[4]+J[5]+
    J[6]+J[7]-J[8]+J[9]-J[10]-J[11]+J[12]-J[13]-J[14]+J[15]+J[16]+J[17]-J[18]+J[19]-J[20]-J[21]+J[22]+J[23]-J[24]-J[25]-J[26]+
    J[27]-J[28]+J[29]-J[30]-J[31]+J[32]+J[33]+J[34]-J[35]+J[36]-J[37]+J[38]-J[39]-J[40]-J[41]+J[42]-J[43]+
    J[44]-J[45]-J[46]-J[47]+J[48]-J[49]+J[50]+J[51]+J[52]-J[53]+J[54]-J[55]+J[56]-J[57]+J[58]-J[59]-J[60]+
    J[61]-J[62]-J[63]+J[64]-J[65], +H[0]+H[1]-H[2]+H[3]-H[4]-H[5]+H[6]+H[7]+H[8]-H[9]-H[10]+H[11]+J[0]-J[1]+
    J[2]-J[3]-J[4]+J[5]+J[6]+J[7]-J[8]-J[9]+J[10]-J[11]+J[12]-J[13]-J[14]+J[15]+J[16]+J[17]-J[18]-J[19]+
    J[20]-J[21]+J[22]+J[23]-J[24]-J[25]-J[26]+J[27]+J[28]-J[29]-J[30]-J[31]+J[32]+J[33]+J[34]-J[35]-J[36]+
    J[37]+J[38]-J[39]-J[40]-J[41]+J[42]+J[43]-J[44]-J[45]-J[46]-J[47]+J[48]+J[49]-J[50]+J[51]+J[52]-J[53]-J[54]+
    J[55]+J[56]-J[57]-J[58]+J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]+H[1]-H[2]+H[3]-H[4]-H[5]+H[6]+
    H[7]+H[8]-H[9]-H[10]-H[11]+J[0]-J[1]+J[2]-J[3]-J[4]+J[5]+J[6]+J[7]-J[8]-J[9]-J[10]-J[11]+J[12]-J[13]-J[14]+
    J[15]+J[16]+J[17]-J[18]-J[19]-J[20]-J[21]+J[22]+J[23]-J[24]-J[25]-J[26]+J[27]+J[28]+J[29]-J[30]-J[31]+
    J[32]+J[33]+J[34]-J[35]-J[36]-J[37]+J[38]-J[39]-J[40]-J[41]+J[42]+J[43]+J[44]-J[45]-J[46]-J[47]+J[48]+
    J[49]+J[50]+J[51]+J[52]-J[53]-J[54]-J[55]+J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +
    H[0]+H[1]-H[2]+H[3]-H[4]-H[5]+H[6]+H[7]-H[8]+H[9]+H[10]+H[11]+J[0]-J[1]+J[2]-J[3]-J[4]+J[5]+J[6]-J[7]+
    J[8]+J[9]+J[10]-J[11]+J[12]-J[13]-J[14]+J[15]+J[16]-J[17]+J[18]+J[19]+J[20]-J[21]+J[22]+J[23]-J[24]-J[25]+
    J[26]-J[27]-J[28]-J[29]-J[30]-J[31]+J[32]+J[33]-J[34]+J[35]+J[36]+J[37]+J[38]-J[39]-J[40]+J[41]-J[42]-J[43]-J[44]-J[45]-J[46]+
    J[47]-J[48]-J[49]-J[50]+J[51]-J[52]+J[53]+J[54]+J[55]-J[56]+J[57]+J[58]+J[59]-J[60]-J[61]-J[62]+J[63]+
    J[64]+J[65], +H[0]+H[1]-H[2]+H[3]-H[4]-H[5]+H[6]+H[7]-H[8]+H[9]+H[10]-H[11]+J[0]-J[1]+J[2]-J[3]-J[4]+
    J[5]+J[6]-J[7]+J[8]+J[9]-J[10]-J[11]+J[12]-J[13]-J[14]+J[15]+J[16]-J[17]+J[18]+J[19]-J[20]-J[21]+J[22]+
    J[23]-J[24]-J[25]+J[26]-J[27]-J[28]+J[29]-J[30]-J[31]+J[32]+J[33]-J[34]+J[35]+J[36]-J[37]+J[38]-J[39]-J[40]+
    J[41]-J[42]-J[43]+J[44]-J[45]-J[46]+J[47]-J[48]-J[49]+J[50]+J[51]-J[52]+J[53]+J[54]-J[55]-J[56]+J[57]+
    J[58]-J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]+H[1]-H[2]+H[3]-H[4]-H[5]+H[6]+H[7]-H[8]+H[9]-H[10]+
    H[11]+J[0]-J[1]+J[2]-J[3]-J[4]+J[5]+J[6]-J[7]+J[8]-J[9]+J[10]-J[11]+J[12]-J[13]-J[14]+J[15]+J[16]-J[17]+
    J[18]-J[19]+J[20]-J[21]+J[22]+J[23]-J[24]-J[25]+J[26]-J[27]+J[28]-J[29]-J[30]-J[31]+J[32]+J[33]-J[34]+
    J[35]-J[36]+J[37]+J[38]-J[39]-J[40]+J[41]-J[42]+J[43]-J[44]-J[45]-J[46]+J[47]-J[48]+J[49]-J[50]+J[51]-J[52]+
    J[53]-J[54]+J[55]-J[56]+J[57]-J[58]+J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]+H[1]-H[2]+H[3]-H[4]-H[5]+
    H[6]+H[7]-H[8]+H[9]-H[10]-H[11]+J[0]-J[1]+J[2]-J[3]-J[4]+J[5]+J[6]-J[7]+J[8]-J[9]-J[10]-J[11]+J[12]-J[13]-J[14]+
    J[15]+J[16]-J[17]+J[18]-J[19]-J[20]-J[21]+J[22]+J[23]-J[24]-J[25]+J[26]-J[27]+J[28]+J[29]-J[30]-J[31]+
    J[32]+J[33]-J[34]+J[35]-J[36]-J[37]+J[38]-J[39]-J[40]+J[41]-J[42]+J[43]+J[44]-J[45]-J[46]+J[47]-J[48]+
    J[49]+J[50]+J[51]-J[52]+J[53]-J[54]-J[55]-J[56]+J[57]-J[58]-J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +
    H[0]+H[1]-H[2]+H[3]-H[4]-H[5]+H[6]+H[7]-H[8]-H[9]+H[10]+H[11]+J[0]-J[1]+J[2]-J[3]-J[4]+J[5]+J[6]-J[7]-J[8]+
    J[9]+J[10]-J[11]+J[12]-J[13]-J[14]+J[15]+J[16]-J[17]-J[18]+J[19]+J[20]-J[21]+J[22]+J[23]-J[24]-J[25]+
    J[26]+J[27]-J[28]-J[29]-J[30]-J[31]+J[32]+J[33]-J[34]-J[35]+J[36]+J[37]+J[38]-J[39]-J[40]+J[41]+J[42]-J[43]-J[44]-J[45]-J[46]+
    J[47]+J[48]-J[49]-J[50]+J[51]-J[52]-J[53]+J[54]+J[55]-J[56]-J[57]+J[58]+J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+
    J[65], +H[0]+H[1]-H[2]+H[3]-H[4]-H[5]+H[6]+H[7]-H[8]-H[9]+H[10]-H[11]+J[0]-J[1]+J[2]-J[3]-J[4]+J[5]+
    J[6]-J[7]-J[8]+J[9]-J[10]-J[11]+J[12]-J[13]-J[14]+J[15]+J[16]-J[17]-J[18]+J[19]-J[20]-J[21]+J[22]+J[23]-J[24]-J[25]+
    J[26]+J[27]-J[28]+J[29]-J[30]-J[31]+J[32]+J[33]-J[34]-J[35]+J[36]-J[37]+J[38]-J[39]-J[40]+J[41]+J[42]-J[43]+
    J[44]-J[45]-J[46]+J[47]+J[48]-J[49]+J[50]+J[51]-J[52]-J[53]+J[54]-J[55]-J[56]-J[57]+J[58]-J[59]+J[60]-J[61]+
    J[62]-J[63]+J[64]-J[65], +H[0]+H[1]-H[2]+H[3]-H[4]-H[5]+H[6]+H[7]-H[8]-H[9]-H[10]+H[11]+J[0]-J[1]+J[2]-J[3]-J[4]+
    J[5]+J[6]-J[7]-J[8]-J[9]+J[10]-J[11]+J[12]-J[13]-J[14]+J[15]+J[16]-J[17]-J[18]-J[19]+J[20]-J[21]+J[22]+
    J[23]-J[24]-J[25]+J[26]+J[27]+J[28]-J[29]-J[30]-J[31]+J[32]+J[33]-J[34]-J[35]-J[36]+J[37]+J[38]-J[39]-J[40]+
    J[41]+J[42]+J[43]-J[44]-J[45]-J[46]+J[47]+J[48]+J[49]-J[50]+J[51]-J[52]-J[53]-J[54]+J[55]-J[56]-J[57]-J[58]+
    J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]+H[1]-H[2]+H[3]-H[4]-H[5]+H[6]+H[7]-H[8]-H[9]-H[10]-H[11]+
    J[0]-J[1]+J[2]-J[3]-J[4]+J[5]+J[6]-J[7]-J[8]-J[9]-J[10]-J[11]+J[12]-J[13]-J[14]+J[15]+J[16]-J[17]-J[18]-J[19]-J[20]-J[21]+
    J[22]+J[23]-J[24]-J[25]+J[26]+J[27]+J[28]+J[29]-J[30]-J[31]+J[32]+J[33]-J[34]-J[35]-J[36]-J[37]+J[38]-J[39]-J[40]+
    J[41]+J[42]+J[43]+J[44]-J[45]-J[46]+J[47]+J[48]+J[49]+J[50]+J[51]-J[52]-J[53]-J[54]-J[55]-J[56]-J[57]-J[58]-J[59]+
    J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]+H[1]-H[2]+H[3]-H[4]-H[5]+H[6]-H[7]+H[8]+H[9]+H[10]+H[11]+
    J[0]-J[1]+J[2]-J[3]-J[4]+J[5]-J[6]+J[7]+J[8]+J[9]+J[10]-J[11]+J[12]-J[13]-J[14]+J[15]-J[16]+J[17]+J[18]+
    J[19]+J[20]-J[21]+J[22]+J[23]-J[24]+J[25]-J[26]-J[27]-J[28]-J[29]-J[30]-J[31]+J[32]-J[33]+J[34]+J[35]+
    J[36]+J[37]+J[38]-J[39]+J[40]-J[41]-J[42]-J[43]-J[44]-J[45]+J[46]-J[47]-J[48]-J[49]-J[50]-J[51]+J[52]+
    J[53]+J[54]+J[55]-J[56]-J[57]-J[58]-J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]+H[1]-H[2]+H[3]-H[4]-H[5]+
    H[6]-H[7]+H[8]+H[9]+H[10]-H[11]+J[0]-J[1]+J[2]-J[3]-J[4]+J[5]-J[6]+J[7]+J[8]+J[9]-J[10]-J[11]+J[12]-J[13]-J[14]+
    J[15]-J[16]+J[17]+J[18]+J[19]-J[20]-J[21]+J[22]+J[23]-J[24]+J[25]-J[26]-J[27]-J[28]+J[29]-J[30]-J[31]+
    J[32]-J[33]+J[34]+J[35]+J[36]-J[37]+J[38]-J[39]+J[40]-J[41]-J[42]-J[43]+J[44]-J[45]+J[46]-J[47]-J[48]-J[49]+
    J[50]-J[51]+J[52]+J[53]+J[54]-J[55]-J[56]-J[57]-J[58]+J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]+
    H[1]-H[2]+H[3]-H[4]-H[5]+H[6]-H[7]+H[8]+H[9]-H[10]+H[11]+J[0]-J[1]+J[2]-J[3]-J[4]+J[5]-J[6]+J[7]+J[8]-J[9]+
    J[10]-J[11]+J[12]-J[13]-J[14]+J[15]-J[16]+J[17]+J[18]-J[19]+J[20]-J[21]+J[22]+J[23]-J[24]+J[25]-J[26]-J[27]+
    J[28]-J[29]-J[30]-J[31]+J[32]-J[33]+J[34]+J[35]-J[36]+J[37]+J[38]-J[39]+J[40]-J[41]-J[42]+J[43]-J[44]-J[45]+
    J[46]-J[47]-J[48]+J[49]-J[50]-J[51]+J[52]+J[53]-J[54]+J[55]-J[56]-J[57]+J[58]-J[59]+J[60]-J[61]+J[62]-J[63]+
    J[64]-J[65], +H[0]+H[1]-H[2]+H[3]-H[4]-H[5]+H[6]-H[7]+H[8]+H[9]-H[10]-H[11]+J[0]-J[1]+J[2]-J[3]-J[4]+
    J[5]-J[6]+J[7]+J[8]-J[9]-J[10]-J[11]+J[12]-J[13]-J[14]+J[15]-J[16]+J[17]+J[18]-J[19]-J[20]-J[21]+J[22]+
    J[23]-J[24]+J[25]-J[26]-J[27]+J[28]+J[29]-J[30]-J[31]+J[32]-J[33]+J[34]+J[35]-J[36]-J[37]+J[38]-J[39]+
    J[40]-J[41]-J[42]+J[43]+J[44]-J[45]+J[46]-J[47]-J[48]+J[49]+J[50]-J[51]+J[52]+J[53]-J[54]-J[55]-J[56]-J[57]+
    J[58]+J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]+H[1]-H[2]+H[3]-H[4]-H[5]+H[6]-H[7]+H[8]-H[9]+
    H[10]+H[11]+J[0]-J[1]+J[2]-J[3]-J[4]+J[5]-J[6]+J[7]-J[8]+J[9]+J[10]-J[11]+J[12]-J[13]-J[14]+J[15]-J[16]+
    J[17]-J[18]+J[19]+J[20]-J[21]+J[22]+J[23]-J[24]+J[25]-J[26]+J[27]-J[28]-J[29]-J[30]-J[31]+J[32]-J[33]+
    J[34]-J[35]+J[36]+J[37]+J[38]-J[39]+J[40]-J[41]+J[42]-J[43]-J[44]-J[45]+J[46]-J[47]+J[48]-J[49]-J[50]-J[51]+
    J[52]-J[53]+J[54]+J[55]-J[56]+J[57]-J[58]-J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]+H[1]-H[2]+
    H[3]-H[4]-H[5]+H[6]-H[7]+H[8]-H[9]+H[10]-H[11]+J[0]-J[1]+J[2]-J[3]-J[4]+J[5]-J[6]+J[7]-J[8]+J[9]-J[10]-J[11]+
    J[12]-J[13]-J[14]+J[15]-J[16]+J[17]-J[18]+J[19]-J[20]-J[21]+J[22]+J[23]-J[24]+J[25]-J[26]+J[27]-J[28]+
    J[29]-J[30]-J[31]+J[32]-J[33]+J[34]-J[35]+J[36]-J[37]+J[38]-J[39]+J[40]-J[41]+J[42]-J[43]+J[44]-J[45]+
    J[46]-J[47]+J[48]-J[49]+J[50]-J[51]+J[52]-J[53]+J[54]-J[55]-J[56]+J[57]-J[58]+J[59]-J[60]+J[61]-J[62]-J[63]+
    J[64]-J[65], +H[0]+H[1]-H[2]+H[3]-H[4]-H[5]+H[6]-H[7]+H[8]-H[9]-H[10]+H[11]+J[0]-J[1]+J[2]-J[3]-J[4]+
    J[5]-J[6]+J[7]-J[8]-J[9]+J[10]-J[11]+J[12]-J[13]-J[14]+J[15]-J[16]+J[17]-J[18]-J[19]+J[20]-J[21]+J[22]+
    J[23]-J[24]+J[25]-J[26]+J[27]+J[28]-J[29]-J[30]-J[31]+J[32]-J[33]+J[34]-J[35]-J[36]+J[37]+J[38]-J[39]+
    J[40]-J[41]+J[42]+J[43]-J[44]-J[45]+J[46]-J[47]+J[48]+J[49]-J[50]-J[51]+J[52]-J[53]-J[54]+J[55]-J[56]+
    J[57]+J[58]-J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]+H[1]-H[2]+H[3]-H[4]-H[5]+H[6]-H[7]+H[8]-H[9]-H[10]-H[11]+
    J[0]-J[1]+J[2]-J[3]-J[4]+J[5]-J[6]+J[7]-J[8]-J[9]-J[10]-J[11]+J[12]-J[13]-J[14]+J[15]-J[16]+J[17]-J[18]-J[19]-J[20]-J[21]+
    J[22]+J[23]-J[24]+J[25]-J[26]+J[27]+J[28]+J[29]-J[30]-J[31]+J[32]-J[33]+J[34]-J[35]-J[36]-J[37]+J[38]-J[39]+
    J[40]-J[41]+J[42]+J[43]+J[44]-J[45]+J[46]-J[47]+J[48]+J[49]+J[50]-J[51]+J[52]-J[53]-J[54]-J[55]-J[56]+
    J[57]+J[58]+J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]+H[1]-H[2]+H[3]-H[4]-H[5]+H[6]-H[7]-H[8]+
    H[9]+H[10]+H[11]+J[0]-J[1]+J[2]-J[3]-J[4]+J[5]-J[6]-J[7]+J[8]+J[9]+J[10]-J[11]+J[12]-J[13]-J[14]+J[15]-J[16]-J[17]+
    J[18]+J[19]+J[20]-J[21]+J[22]+J[23]-J[24]+J[25]+J[26]-J[27]-J[28]-J[29]-J[30]-J[31]+J[32]-J[33]-J[34]+
    J[35]+J[36]+J[37]+J[38]-J[39]+J[40]+J[41]-J[42]-J[43]-J[44]-J[45]+J[46]+J[47]-J[48]-J[49]-J[50]-J[51]-J[52]+
    J[53]+J[54]+J[55]+J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]+H[1]-H[2]+H[3]-H[4]-H[5]+
    H[6]-H[7]-H[8]+H[9]+H[10]-H[11]+J[0]-J[1]+J[2]-J[3]-J[4]+J[5]-J[6]-J[7]+J[8]+J[9]-J[10]-J[11]+J[12]-J[13]-J[14]+
    J[15]-J[16]-J[17]+J[18]+J[19]-J[20]-J[21]+J[22]+J[23]-J[24]+J[25]+J[26]-J[27]-J[28]+J[29]-J[30]-J[31]+
    J[32]-J[33]-J[34]+J[35]+J[36]-J[37]+J[38]-J[39]+J[40]+J[41]-J[42]-J[43]+J[44]-J[45]+J[46]+J[47]-J[48]-J[49]+
    J[50]-J[51]-J[52]+J[53]+J[54]-J[55]+J[56]-J[57]-J[58]+J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]+
    H[1]-H[2]+H[3]-H[4]-H[5]+H[6]-H[7]-H[8]+H[9]-H[10]+H[11]+J[0]-J[1]+J[2]-J[3]-J[4]+J[5]-J[6]-J[7]+J[8]-J[9]+
    J[10]-J[11]+J[12]-J[13]-J[14]+J[15]-J[16]-J[17]+J[18]-J[19]+J[20]-J[21]+J[22]+J[23]-J[24]+J[25]+J[26]-J[27]+
    J[28]-J[29]-J[30]-J[31]+J[32]-J[33]-J[34]+J[35]-J[36]+J[37]+J[38]-J[39]+J[40]+J[41]-J[42]+J[43]-J[44]-J[45]+
    J[46]+J[47]-J[48]+J[49]-J[50]-J[51]-J[52]+J[53]-J[54]+J[55]+J[56]-J[57]+J[58]-J[59]-J[60]+J[61]-J[62]-J[63]+
    J[64]-J[65], +H[0]+H[1]-H[2]+H[3]-H[4]-H[5]+H[6]-H[7]-H[8]+H[9]-H[10]-H[11]+J[0]-J[1]+J[2]-J[3]-J[4]+
    J[5]-J[6]-J[7]+J[8]-J[9]-J[10]-J[11]+J[12]-J[13]-J[14]+J[15]-J[16]-J[17]+J[18]-J[19]-J[20]-J[21]+J[22]+
    J[23]-J[24]+J[25]+J[26]-J[27]+J[28]+J[29]-J[30]-J[31]+J[32]-J[33]-J[34]+J[35]-J[36]-J[37]+J[38]-J[39]+
    J[40]+J[41]-J[42]+J[43]+J[44]-J[45]+J[46]+J[47]-J[48]+J[49]+J[50]-J[51]-J[52]+J[53]-J[54]-J[55]+J[56]-J[57]+
    J[58]+J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]+H[1]-H[2]+H[3]-H[4]-H[5]+H[6]-H[7]-H[8]-H[9]+
    H[10]+H[11]+J[0]-J[1]+J[2]-J[3]-J[4]+J[5]-J[6]-J[7]-J[8]+J[9]+J[10]-J[11]+J[12]-J[13]-J[14]+J[15]-J[16]-J[17]-J[18]+
    J[19]+J[20]-J[21]+J[22]+J[23]-J[24]+J[25]+J[26]+J[27]-J[28]-J[29]-J[30]-J[31]+J[32]-J[33]-J[34]-J[35]+
    J[36]+J[37]+J[38]-J[39]+J[40]+J[41]+J[42]-J[43]-J[44]-J[45]+J[46]+J[47]+J[48]-J[49]-J[50]-J[51]-J[52]-J[53]+
    J[54]+J[55]+J[56]+J[57]-J[58]-J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]+H[1]-H[2]+H[3]-H[4]-H[5]+
    H[6]-H[7]-H[8]-H[9]+H[10]-H[11]+J[0]-J[1]+J[2]-J[3]-J[4]+J[5]-J[6]-J[7]-J[8]+J[9]-J[10]-J[11]+J[12]-J[13]-J[14]+
    J[15]-J[16]-J[17]-J[18]+J[19]-J[20]-J[21]+J[22]+J[23]-J[24]+J[25]+J[26]+J[27]-J[28]+J[29]-J[30]-J[31]+
    J[32]-J[33]-J[34]-J[35]+J[36]-J[37]+J[38]-J[39]+J[40]+J[41]+J[42]-J[43]+J[44]-J[45]+J[46]+J[47]+J[48]-J[49]+
    J[50]-J[51]-J[52]-J[53]+J[54]-J[55]+J[56]+J[57]-J[58]+J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]+
    H[1]-H[2]+H[3]-H[4]-H[5]+H[6]-H[7]-H[8]-H[9]-H[10]+H[11]+J[0]-J[1]+J[2]-J[3]-J[4]+J[5]-J[6]-J[7]-J[8]-J[9]+
    J[10]-J[11]+J[12]-J[13]-J[14]+J[15]-J[16]-J[17]-J[18]-J[19]+J[20]-J[21]+J[22]+J[23]-J[24]+J[25]+J[26]+
    J[27]+J[28]-J[29]-J[30]-J[31]+J[32]-J[33]-J[34]-J[35]-J[36]+J[37]+J[38]-J[39]+J[40]+J[41]+J[42]+J[43]-J[44]-J[45]+
    J[46]+J[47]+J[48]+J[49]-J[50]-J[51]-J[52]-J[53]-J[54]+J[55]+J[56]+J[57]+J[58]-J[59]+J[60]+J[61]-J[62]+
    J[63]-J[64]-J[65], +H[0]+H[1]-H[2]+H[3]-H[4]-H[5]+H[6]-H[7]-H[8]-H[9]-H[10]-H[11]+J[0]-J[1]+J[2]-J[3]-J[4]+
    J[5]-J[6]-J[7]-J[8]-J[9]-J[10]-J[11]+J[12]-J[13]-J[14]+J[15]-J[16]-J[17]-J[18]-J[19]-J[20]-J[21]+J[22]+
    J[23]-J[24]+J[25]+J[26]+J[27]+J[28]+J[29]-J[30]-J[31]+J[32]-J[33]-J[34]-J[35]-J[36]-J[37]+J[38]-J[39]+
    J[40]+J[41]+J[42]+J[43]+J[44]-J[45]+J[46]+J[47]+J[48]+J[49]+J[50]-J[51]-J[52]-J[53]-J[54]-J[55]+J[56]+
    J[57]+J[58]+J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]+H[1]-H[2]+H[3]-H[4]-H[5]-H[6]+H[7]+H[8]+
    H[9]+H[10]+H[11]+J[0]-J[1]+J[2]-J[3]-J[4]-J[5]+J[6]+J[7]+J[8]+J[9]+J[10]-J[11]+J[12]-J[13]-J[14]-J[15]+
    J[16]+J[17]+J[18]+J[19]+J[20]-J[21]+J[22]+J[23]+J[24]-J[25]-J[26]-J[27]-J[28]-J[29]-J[30]-J[31]-J[32]+
    J[33]+J[34]+J[35]+J[36]+J[37]+J[38]+J[39]-J[40]-J[41]-J[42]-J[43]-J[44]+J[45]-J[46]-J[47]-J[48]-J[49]-J[50]-J[51]-J[52]-J[53]-J[54]-J[55]+
    J[56]+J[57]+J[58]+J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]+H[1]-H[2]+H[3]-H[4]-H[5]-H[6]+H[7]+
    H[8]+H[9]+H[10]-H[11]+J[0]-J[1]+J[2]-J[3]-J[4]-J[5]+J[6]+J[7]+J[8]+J[9]-J[10]-J[11]+J[12]-J[13]-J[14]-J[15]+
    J[16]+J[17]+J[18]+J[19]-J[20]-J[21]+J[22]+J[23]+J[24]-J[25]-J[26]-J[27]-J[28]+J[29]-J[30]-J[31]-J[32]+
    J[33]+J[34]+J[35]+J[36]-J[37]+J[38]+J[39]-J[40]-J[41]-J[42]-J[43]+J[44]+J[45]-J[46]-J[47]-J[48]-J[49]+
    J[50]-J[51]-J[52]-J[53]-J[54]+J[55]+J[56]+J[57]+J[58]-J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]+
    H[1]-H[2]+H[3]-H[4]-H[5]-H[6]+H[7]+H[8]+H[9]-H[10]+H[11]+J[0]-J[1]+J[2]-J[3]-J[4]-J[5]+J[6]+J[7]+J[8]-J[9]+
    J[10]-J[11]+J[12]-J[13]-J[14]-J[15]+J[16]+J[17]+J[18]-J[19]+J[20]-J[21]+J[22]+J[23]+J[24]-J[25]-J[26]-J[27]+
    J[28]-J[29]-J[30]-J[31]-J[32]+J[33]+J[34]+J[35]-J[36]+J[37]+J[38]+J[39]-J[40]-J[41]-J[42]+J[43]-J[44]+
    J[45]-J[46]-J[47]-J[48]+J[49]-J[50]-J[51]-J[52]-J[53]+J[54]-J[55]+J[56]+J[57]-J[58]+J[59]+J[60]-J[61]+
    J[62]-J[63]+J[64]-J[65], +H[0]+H[1]-H[2]+H[3]-H[4]-H[5]-H[6]+H[7]+H[8]+H[9]-H[10]-H[11]+J[0]-J[1]+J[2]-J[3]-J[4]-J[5]+
    J[6]+J[7]+J[8]-J[9]-J[10]-J[11]+J[12]-J[13]-J[14]-J[15]+J[16]+J[17]+J[18]-J[19]-J[20]-J[21]+J[22]+J[23]+
    J[24]-J[25]-J[26]-J[27]+J[28]+J[29]-J[30]-J[31]-J[32]+J[33]+J[34]+J[35]-J[36]-J[37]+J[38]+J[39]-J[40]-J[41]-J[42]+
    J[43]+J[44]+J[45]-J[46]-J[47]-J[48]+J[49]+J[50]-J[51]-J[52]-J[53]+J[54]+J[55]+J[56]+J[57]-J[58]-J[59]+
    J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]+H[1]-H[2]+H[3]-H[4]-H[5]-H[6]+H[7]+H[8]-H[9]+H[10]+H[11]+
    J[0]-J[1]+J[2]-J[3]-J[4]-J[5]+J[6]+J[7]-J[8]+J[9]+J[10]-J[11]+J[12]-J[13]-J[14]-J[15]+J[16]+J[17]-J[18]+
    J[19]+J[20]-J[21]+J[22]+J[23]+J[24]-J[25]-J[26]+J[27]-J[28]-J[29]-J[30]-J[31]-J[32]+J[33]+J[34]-J[35]+
    J[36]+J[37]+J[38]+J[39]-J[40]-J[41]+J[42]-J[43]-J[44]+J[45]-J[46]-J[47]+J[48]-J[49]-J[50]-J[51]-J[52]+
    J[53]-J[54]-J[55]+J[56]-J[57]+J[58]+J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]+H[1]-H[2]+H[3]-H[4]-H[5]-H[6]+
    H[7]+H[8]-H[9]+H[10]-H[11]+J[0]-J[1]+J[2]-J[3]-J[4]-J[5]+J[6]+J[7]-J[8]+J[9]-J[10]-J[11]+J[12]-J[13]-J[14]-J[15]+
    J[16]+J[17]-J[18]+J[19]-J[20]-J[21]+J[22]+J[23]+J[24]-J[25]-J[26]+J[27]-J[28]+J[29]-J[30]-J[31]-J[32]+
    J[33]+J[34]-J[35]+J[36]-J[37]+J[38]+J[39]-J[40]-J[41]+J[42]-J[43]+J[44]+J[45]-J[46]-J[47]+J[48]-J[49]+
    J[50]-J[51]-J[52]+J[53]-J[54]+J[55]+J[56]-J[57]+J[58]-J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]+
    H[1]-H[2]+H[3]-H[4]-H[5]-H[6]+H[7]+H[8]-H[9]-H[10]+H[11]+J[0]-J[1]+J[2]-J[3]-J[4]-J[5]+J[6]+J[7]-J[8]-J[9]+
    J[10]-J[11]+J[12]-J[13]-J[14]-J[15]+J[16]+J[17]-J[18]-J[19]+J[20]-J[21]+J[22]+J[23]+J[24]-J[25]-J[26]+
    J[27]+J[28]-J[29]-J[30]-J[31]-J[32]+J[33]+J[34]-J[35]-J[36]+J[37]+J[38]+J[39]-J[40]-J[41]+J[42]+J[43]-J[44]+
    J[45]-J[46]-J[47]+J[48]+J[49]-J[50]-J[51]-J[52]+J[53]+J[54]-J[55]+J[56]-J[57]-J[58]+J[59]-J[60]-J[61]+
    J[62]+J[63]-J[64]-J[65], +H[0]+H[1]-H[2]+H[3]-H[4]-H[5]-H[6]+H[7]+H[8]-H[9]-H[10]-H[11]+J[0]-J[1]+J[2]-J[3]-J[4]-J[5]+
    J[6]+J[7]-J[8]-J[9]-J[10]-J[11]+J[12]-J[13]-J[14]-J[15]+J[16]+J[17]-J[18]-J[19]-J[20]-J[21]+J[22]+J[23]+
    J[24]-J[25]-J[26]+J[27]+J[28]+J[29]-J[30]-J[31]-J[32]+J[33]+J[34]-J[35]-J[36]-J[37]+J[38]+J[39]-J[40]-J[41]+
    J[42]+J[43]+J[44]+J[45]-J[46]-J[47]+J[48]+J[49]+J[50]-J[51]-J[52]+J[53]+J[54]+J[55]+J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+
    J[63]+J[64]+J[65], +H[0]+H[1]-H[2]+H[3]-H[4]-H[5]-H[6]+H[7]-H[8]+H[9]+H[10]+H[11]+J[0]-J[1]+J[2]-J[3]-J[4]-J[5]+
    J[6]-J[7]+J[8]+J[9]+J[10]-J[11]+J[12]-J[13]-J[14]-J[15]+J[16]-J[17]+J[18]+J[19]+J[20]-J[21]+J[22]+J[23]+
    J[24]-J[25]+J[26]-J[27]-J[28]-J[29]-J[30]-J[31]-J[32]+J[33]-J[34]+J[35]+J[36]+J[37]+J[38]+J[39]-J[40]+
    J[41]-J[42]-J[43]-J[44]+J[45]-J[46]+J[47]-J[48]-J[49]-J[50]-J[51]+J[52]-J[53]-J[54]-J[55]-J[56]+J[57]+
    J[58]+J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]+H[1]-H[2]+H[3]-H[4]-H[5]-H[6]+H[7]-H[8]+H[9]+
    H[10]-H[11]+J[0]-J[1]+J[2]-J[3]-J[4]-J[5]+J[6]-J[7]+J[8]+J[9]-J[10]-J[11]+J[12]-J[13]-J[14]-J[15]+J[16]-J[17]+
    J[18]+J[19]-J[20]-J[21]+J[22]+J[23]+J[24]-J[25]+J[26]-J[27]-J[28]+J[29]-J[30]-J[31]-J[32]+J[33]-J[34]+
    J[35]+J[36]-J[37]+J[38]+J[39]-J[40]+J[41]-J[42]-J[43]+J[44]+J[45]-J[46]+J[47]-J[48]-J[49]+J[50]-J[51]+
    J[52]-J[53]-J[54]+J[55]-J[56]+J[57]+J[58]-J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]+H[1]-H[2]+
    H[3]-H[4]-H[5]-H[6]+H[7]-H[8]+H[9]-H[10]+H[11]+J[0]-J[1]+J[2]-J[3]-J[4]-J[5]+J[6]-J[7]+J[8]-J[9]+J[10]-J[11]+
    J[12]-J[13]-J[14]-J[15]+J[16]-J[17]+J[18]-J[19]+J[20]-J[21]+J[22]+J[23]+J[24]-J[25]+J[26]-J[27]+J[28]-J[29]-J[30]-J[31]-J[32]+
    J[33]-J[34]+J[35]-J[36]+J[37]+J[38]+J[39]-J[40]+J[41]-J[42]+J[43]-J[44]+J[45]-J[46]+J[47]-J[48]+J[49]-J[50]-J[51]+
    J[52]-J[53]+J[54]-J[55]-J[56]+J[57]-J[58]+J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]+H[1]-H[2]+
    H[3]-H[4]-H[5]-H[6]+H[7]-H[8]+H[9]-H[10]-H[11]+J[0]-J[1]+J[2]-J[3]-J[4]-J[5]+J[6]-J[7]+J[8]-J[9]-J[10]-J[11]+
    J[12]-J[13]-J[14]-J[15]+J[16]-J[17]+J[18]-J[19]-J[20]-J[21]+J[22]+J[23]+J[24]-J[25]+J[26]-J[27]+J[28]+
    J[29]-J[30]-J[31]-J[32]+J[33]-J[34]+J[35]-J[36]-J[37]+J[38]+J[39]-J[40]+J[41]-J[42]+J[43]+J[44]+J[45]-J[46]+
    J[47]-J[48]+J[49]+J[50]-J[51]+J[52]-J[53]+J[54]+J[55]-J[56]+J[57]-J[58]-J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+
    J[65], +H[0]+H[1]-H[2]+H[3]-H[4]-H[5]-H[6]+H[7]-H[8]-H[9]+H[10]+H[11]+J[0]-J[1]+J[2]-J[3]-J[4]-J[5]+
    J[6]-J[7]-J[8]+J[9]+J[10]-J[11]+J[12]-J[13]-J[14]-J[15]+J[16]-J[17]-J[18]+J[19]+J[20]-J[21]+J[22]+J[23]+
    J[24]-J[25]+J[26]+J[27]-J[28]-J[29]-J[30]-J[31]-J[32]+J[33]-J[34]-J[35]+J[36]+J[37]+J[38]+J[39]-J[40]+
    J[41]+J[42]-J[43]-J[44]+J[45]-J[46]+J[47]+J[48]-J[49]-J[50]-J[51]+J[52]+J[53]-J[54]-J[55]-J[56]-J[57]+
    J[58]+J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]+H[1]-H[2]+H[3]-H[4]-H[5]-H[6]+H[7]-H[8]-H[9]+
    H[10]-H[11]+J[0]-J[1]+J[2]-J[3]-J[4]-J[5]+J[6]-J[7]-J[8]+J[9]-J[10]-J[11]+J[12]-J[13]-J[14]-J[15]+J[16]-J[17]-J[18]+
    J[19]-J[20]-J[21]+J[22]+J[23]+J[24]-J[25]+J[26]+J[27]-J[28]+J[29]-J[30]-J[31]-J[32]+J[33]-J[34]-J[35]+
    J[36]-J[37]+J[38]+J[39]-J[40]+J[41]+J[42]-J[43]+J[44]+J[45]-J[46]+J[47]+J[48]-J[49]+J[50]-J[51]+J[52]+
    J[53]-J[54]+J[55]-J[56]-J[57]+J[58]-J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]+H[1]-H[2]+H[3]-H[4]-H[5]-H[6]+
    H[7]-H[8]-H[9]-H[10]+H[11]+J[0]-J[1]+J[2]-J[3]-J[4]-J[5]+J[6]-J[7]-J[8]-J[9]+J[10]-J[11]+J[12]-J[13]-J[14]-J[15]+
    J[16]-J[17]-J[18]-J[19]+J[20]-J[21]+J[22]+J[23]+J[24]-J[25]+J[26]+J[27]+J[28]-J[29]-J[30]-J[31]-J[32]+
    J[33]-J[34]-J[35]-J[36]+J[37]+J[38]+J[39]-J[40]+J[41]+J[42]+J[43]-J[44]+J[45]-J[46]+J[47]+J[48]+J[49]-J[50]-J[51]+
    J[52]+J[53]+J[54]-J[55]-J[56]-J[57]-J[58]+J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]+H[1]-H[2]+
    H[3]-H[4]-H[5]-H[6]+H[7]-H[8]-H[9]-H[10]-H[11]+J[0]-J[1]+J[2]-J[3]-J[4]-J[5]+J[6]-J[7]-J[8]-J[9]-J[10]-J[11]+
    J[12]-J[13]-J[14]-J[15]+J[16]-J[17]-J[18]-J[19]-J[20]-J[21]+J[22]+J[23]+J[24]-J[25]+J[26]+J[27]+J[28]+
    J[29]-J[30]-J[31]-J[32]+J[33]-J[34]-J[35]-J[36]-J[37]+J[38]+J[39]-J[40]+J[41]+J[42]+J[43]+J[44]+J[45]-J[46]+
    J[47]+J[48]+J[49]+J[50]-J[51]+J[52]+J[53]+J[54]+J[55]-J[56]-J[57]-J[58]-J[59]+J[60]+J[61]+J[62]+J[63]+
    J[64]+J[65], +H[0]+H[1]-H[2]+H[3]-H[4]-H[5]-H[6]-H[7]+H[8]+H[9]+H[10]+H[11]+J[0]-J[1]+J[2]-J[3]-J[4]-J[5]-J[6]+
    J[7]+J[8]+J[9]+J[10]-J[11]+J[12]-J[13]-J[14]-J[15]-J[16]+J[17]+J[18]+J[19]+J[20]-J[21]+J[22]+J[23]+J[24]+
    J[25]-J[26]-J[27]-J[28]-J[29]-J[30]-J[31]-J[32]-J[33]+J[34]+J[35]+J[36]+J[37]+J[38]+J[39]+J[40]-J[41]-J[42]-J[43]-J[44]+
    J[45]+J[46]-J[47]-J[48]-J[49]-J[50]+J[51]-J[52]-J[53]-J[54]-J[55]-J[56]-J[57]-J[58]-J[59]+J[60]+J[61]+
    J[62]+J[63]+J[64]+J[65], +H[0]+H[1]-H[2]+H[3]-H[4]-H[5]-H[6]-H[7]+H[8]+H[9]+H[10]-H[11]+J[0]-J[1]+J[2]-J[3]-J[4]-J[5]-J[6]+
    J[7]+J[8]+J[9]-J[10]-J[11]+J[12]-J[13]-J[14]-J[15]-J[16]+J[17]+J[18]+J[19]-J[20]-J[21]+J[22]+J[23]+J[24]+
    J[25]-J[26]-J[27]-J[28]+J[29]-J[30]-J[31]-J[32]-J[33]+J[34]+J[35]+J[36]-J[37]+J[38]+J[39]+J[40]-J[41]-J[42]-J[43]+
    J[44]+J[45]+J[46]-J[47]-J[48]-J[49]+J[50]+J[51]-J[52]-J[53]-J[54]+J[55]-J[56]-J[57]-J[58]+J[59]+J[60]+
    J[61]-J[62]+J[63]-J[64]-J[65], +H[0]+H[1]-H[2]+H[3]-H[4]-H[5]-H[6]-H[7]+H[8]+H[9]-H[10]+H[11]+J[0]-J[1]+
    J[2]-J[3]-J[4]-J[5]-J[6]+J[7]+J[8]-J[9]+J[10]-J[11]+J[12]-J[13]-J[14]-J[15]-J[16]+J[17]+J[18]-J[19]+
    J[20]-J[21]+J[22]+J[23]+J[24]+J[25]-J[26]-J[27]+J[28]-J[29]-J[30]-J[31]-J[32]-J[33]+J[34]+J[35]-J[36]+
    J[37]+J[38]+J[39]+J[40]-J[41]-J[42]+J[43]-J[44]+J[45]+J[46]-J[47]-J[48]+J[49]-J[50]+J[51]-J[52]-J[53]+
    J[54]-J[55]-J[56]-J[57]+J[58]-J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]+H[1]-H[2]+H[3]-H[4]-H[5]-H[6]-H[7]+
    H[8]+H[9]-H[10]-H[11]+J[0]-J[1]+J[2]-J[3]-J[4]-J[5]-J[6]+J[7]+J[8]-J[9]-J[10]-J[11]+J[12]-J[13]-J[14]-J[15]-J[16]+
    J[17]+J[18]-J[19]-J[20]-J[21]+J[22]+J[23]+J[24]+J[25]-J[26]-J[27]+J[28]+J[29]-J[30]-J[31]-J[32]-J[33]+
    J[34]+J[35]-J[36]-J[37]+J[38]+J[39]+J[40]-J[41]-J[42]+J[43]+J[44]+J[45]+J[46]-J[47]-J[48]+J[49]+J[50]+
    J[51]-J[52]-J[53]+J[54]+J[55]-J[56]-J[57]+J[58]+J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]+H[1]-H[2]+
    H[3]-H[4]-H[5]-H[6]-H[7]+H[8]-H[9]+H[10]+H[11]+J[0]-J[1]+J[2]-J[3]-J[4]-J[5]-J[6]+J[7]-J[8]+J[9]+J[10]-J[11]+
    J[12]-J[13]-J[14]-J[15]-J[16]+J[17]-J[18]+J[19]+J[20]-J[21]+J[22]+J[23]+J[24]+J[25]-J[26]+J[27]-J[28]-J[29]-J[30]-J[31]-J[32]-J[33]+
    J[34]-J[35]+J[36]+J[37]+J[38]+J[39]+J[40]-J[41]+J[42]-J[43]-J[44]+J[45]+J[46]-J[47]+J[48]-J[49]-J[50]+
    J[51]-J[52]+J[53]-J[54]-J[55]-J[56]+J[57]-J[58]-J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]+H[1]-H[2]+
    H[3]-H[4]-H[5]-H[6]-H[7]+H[8]-H[9]+H[10]-H[11]+J[0]-J[1]+J[2]-J[3]-J[4]-J[5]-J[6]+J[7]-J[8]+J[9]-J[10]-J[11]+
    J[12]-J[13]-J[14]-J[15]-J[16]+J[17]-J[18]+J[19]-J[20]-J[21]+J[22]+J[23]+J[24]+J[25]-J[26]+J[27]-J[28]+
    J[29]-J[30]-J[31]-J[32]-J[33]+J[34]-J[35]+J[36]-J[37]+J[38]+J[39]+J[40]-J[41]+J[42]-J[43]+J[44]+J[45]+
    J[46]-J[47]+J[48]-J[49]+J[50]+J[51]-J[52]+J[53]-J[54]+J[55]-J[56]+J[57]-J[58]+J[59]-J[60]+J[61]-J[62]-J[63]+
    J[64]-J[65], +H[0]+H[1]-H[2]+H[3]-H[4]-H[5]-H[6]-H[7]+H[8]-H[9]-H[10]+H[11]+J[0]-J[1]+J[2]-J[3]-J[4]-J[5]-J[6]+
    J[7]-J[8]-J[9]+J[10]-J[11]+J[12]-J[13]-J[14]-J[15]-J[16]+J[17]-J[18]-J[19]+J[20]-J[21]+J[22]+J[23]+J[24]+
    J[25]-J[26]+J[27]+J[28]-J[29]-J[30]-J[31]-J[32]-J[33]+J[34]-J[35]-J[36]+J[37]+J[38]+J[39]+J[40]-J[41]+
    J[42]+J[43]-J[44]+J[45]+J[46]-J[47]+J[48]+J[49]-J[50]+J[51]-J[52]+J[53]+J[54]-J[55]-J[56]+J[57]+J[58]-J[59]-J[60]-J[61]+
    J[62]+J[63]-J[64]-J[65], +H[0]+H[1]-H[2]+H[3]-H[4]-H[5]-H[6]-H[7]+H[8]-H[9]-H[10]-H[11]+J[0]-J[1]+J[2]-J[3]-J[4]-J[5]-J[6]+
    J[7]-J[8]-J[9]-J[10]-J[11]+J[12]-J[13]-J[14]-J[15]-J[16]+J[17]-J[18]-J[19]-J[20]-J[21]+J[22]+J[23]+J[24]+
    J[25]-J[26]+J[27]+J[28]+J[29]-J[30]-J[31]-J[32]-J[33]+J[34]-J[35]-J[36]-J[37]+J[38]+J[39]+J[40]-J[41]+
    J[42]+J[43]+J[44]+J[45]+J[46]-J[47]+J[48]+J[49]+J[50]+J[51]-J[52]+J[53]+J[54]+J[55]-J[56]+J[57]+J[58]+
    J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]+H[1]-H[2]+H[3]-H[4]-H[5]-H[6]-H[7]-H[8]+H[9]+H[10]+
    H[11]+J[0]-J[1]+J[2]-J[3]-J[4]-J[5]-J[6]-J[7]+J[8]+J[9]+J[10]-J[11]+J[12]-J[13]-J[14]-J[15]-J[16]-J[17]+
    J[18]+J[19]+J[20]-J[21]+J[22]+J[23]+J[24]+J[25]+J[26]-J[27]-J[28]-J[29]-J[30]-J[31]-J[32]-J[33]-J[34]+
    J[35]+J[36]+J[37]+J[38]+J[39]+J[40]+J[41]-J[42]-J[43]-J[44]+J[45]+J[46]+J[47]-J[48]-J[49]-J[50]+J[51]+
    J[52]-J[53]-J[54]-J[55]+J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]+H[1]-H[2]+
    H[3]-H[4]-H[5]-H[6]-H[7]-H[8]+H[9]+H[10]-H[11]+J[0]-J[1]+J[2]-J[3]-J[4]-J[5]-J[6]-J[7]+J[8]+J[9]-J[10]-J[11]+
    J[12]-J[13]-J[14]-J[15]-J[16]-J[17]+J[18]+J[19]-J[20]-J[21]+J[22]+J[23]+J[24]+J[25]+J[26]-J[27]-J[28]+
    J[29]-J[30]-J[31]-J[32]-J[33]-J[34]+J[35]+J[36]-J[37]+J[38]+J[39]+J[40]+J[41]-J[42]-J[43]+J[44]+J[45]+
    J[46]+J[47]-J[48]-J[49]+J[50]+J[51]+J[52]-J[53]-J[54]+J[55]+J[56]-J[57]-J[58]+J[59]-J[60]-J[61]+J[62]+
    J[63]-J[64]-J[65], +H[0]+H[1]-H[2]+H[3]-H[4]-H[5]-H[6]-H[7]-H[8]+H[9]-H[10]+H[11]+J[0]-J[1]+J[2]-J[3]-J[4]-J[5]-J[6]-J[7]+
    J[8]-J[9]+J[10]-J[11]+J[12]-J[13]-J[14]-J[15]-J[16]-J[17]+J[18]-J[19]+J[20]-J[21]+J[22]+J[23]+J[24]+
    J[25]+J[26]-J[27]+J[28]-J[29]-J[30]-J[31]-J[32]-J[33]-J[34]+J[35]-J[36]+J[37]+J[38]+J[39]+J[40]+J[41]-J[42]+
    J[43]-J[44]+J[45]+J[46]+J[47]-J[48]+J[49]-J[50]+J[51]+J[52]-J[53]+J[54]-J[55]+J[56]-J[57]+J[58]-J[59]-J[60]+
    J[61]-J[62]-J[63]+J[64]-J[65], +H[0]+H[1]-H[2]+H[3]-H[4]-H[5]-H[6]-H[7]-H[8]+H[9]-H[10]-H[11]+J[0]-J[1]+
    J[2]-J[3]-J[4]-J[5]-J[6]-J[7]+J[8]-J[9]-J[10]-J[11]+J[12]-J[13]-J[14]-J[15]-J[16]-J[17]+J[18]-J[19]-J[20]-J[21]+
    J[22]+J[23]+J[24]+J[25]+J[26]-J[27]+J[28]+J[29]-J[30]-J[31]-J[32]-J[33]-J[34]+J[35]-J[36]-J[37]+J[38]+
    J[39]+J[40]+J[41]-J[42]+J[43]+J[44]+J[45]+J[46]+J[47]-J[48]+J[49]+J[50]+J[51]+J[52]-J[53]+J[54]+J[55]+
    J[56]-J[57]+J[58]+J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]+H[1]-H[2]+H[3]-H[4]-H[5]-H[6]-H[7]-H[8]-H[9]+
    H[10]+H[11]+J[0]-J[1]+J[2]-J[3]-J[4]-J[5]-J[6]-J[7]-J[8]+J[9]+J[10]-J[11]+J[12]-J[13]-J[14]-J[15]-J[16]-J[17]-J[18]+
    J[19]+J[20]-J[21]+J[22]+J[23]+J[24]+J[25]+J[26]+J[27]-J[28]-J[29]-J[30]-J[31]-J[32]-J[33]-J[34]-J[35]+
    J[36]+J[37]+J[38]+J[39]+J[40]+J[41]+J[42]-J[43]-J[44]+J[45]+J[46]+J[47]+J[48]-J[49]-J[50]+J[51]+J[52]+
    J[53]-J[54]-J[55]+J[56]+J[57]-J[58]-J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]+H[1]-H[2]+H[3]-H[4]-H[5]-H[6]-H[7]-H[8]-H[9]+
    H[10]-H[11]+J[0]-J[1]+J[2]-J[3]-J[4]-J[5]-J[6]-J[7]-J[8]+J[9]-J[10]-J[11]+J[12]-J[13]-J[14]-J[15]-J[16]-J[17]-J[18]+
    J[19]-J[20]-J[21]+J[22]+J[23]+J[24]+J[25]+J[26]+J[27]-J[28]+J[29]-J[30]-J[31]-J[32]-J[33]-J[34]-J[35]+
    J[36]-J[37]+J[38]+J[39]+J[40]+J[41]+J[42]-J[43]+J[44]+J[45]+J[46]+J[47]+J[48]-J[49]+J[50]+J[51]+J[52]+
    J[53]-J[54]+J[55]+J[56]+J[57]-J[58]+J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]+H[1]-H[2]+H[3]-H[4]-H[5]-H[6]-H[7]-H[8]-H[9]-H[10]+
    H[11]+J[0]-J[1]+J[2]-J[3]-J[4]-J[5]-J[6]-J[7]-J[8]-J[9]+J[10]-J[11]+J[12]-J[13]-J[14]-J[15]-J[16]-J[17]-J[18]-J[19]+
    J[20]-J[21]+J[22]+J[23]+J[24]+J[25]+J[26]+J[27]+J[28]-J[29]-J[30]-J[31]-J[32]-J[33]-J[34]-J[35]-J[36]+
    J[37]+J[38]+J[39]+J[40]+J[41]+J[42]+J[43]-J[44]+J[45]+J[46]+J[47]+J[48]+J[49]-J[50]+J[51]+J[52]+J[53]+
    J[54]-J[55]+J[56]+J[57]+J[58]-J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]+H[1]-H[2]+H[3]-H[4]-H[5]-H[6]-H[7]-H[8]-H[9]-H[10]-H[11]+
    J[0]-J[1]+J[2]-J[3]-J[4]-J[5]-J[6]-J[7]-J[8]-J[9]-J[10]-J[11]+J[12]-J[13]-J[14]-J[15]-J[16]-J[17]-J[18]-J[19]-J[20]-J[21]+
    J[22]+J[23]+J[24]+J[25]+J[26]+J[27]+J[28]+J[29]-J[30]-J[31]-J[32]-J[33]-J[34]-J[35]-J[36]-J[37]+J[38]+
    J[39]+J[40]+J[41]+J[42]+J[43]+J[44]+J[45]+J[46]+J[47]+J[48]+J[49]+J[50]+J[51]+J[52]+J[53]+J[54]+J[55]+
    J[56]+J[57]+J[58]+J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]+H[1]-H[2]-H[3]+H[4]+H[5]+H[6]+H[7]+
    H[8]+H[9]+H[10]+H[11]+J[0]-J[1]-J[2]+J[3]+J[4]+J[5]+J[6]+J[7]+J[8]+J[9]+J[10]-J[11]-J[12]+J[13]+J[14]+
    J[15]+J[16]+J[17]+J[18]+J[19]+J[20]+J[21]-J[22]-J[23]-J[24]-J[25]-J[26]-J[27]-J[28]-J[29]-J[30]-J[31]-J[32]-J[33]-J[34]-J[35]-J[36]-J[37]+
    J[38]+J[39]+J[40]+J[41]+J[42]+J[43]+J[44]+J[45]+J[46]+J[47]+J[48]+J[49]+J[50]+J[51]+J[52]+J[53]+J[54]+
    J[55]+J[56]+J[57]+J[58]+J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]+H[1]-H[2]-H[3]+H[4]+H[5]+H[6]+
    H[7]+H[8]+H[9]+H[10]-H[11]+J[0]-J[1]-J[2]+J[3]+J[4]+J[5]+J[6]+J[7]+J[8]+J[9]-J[10]-J[11]-J[12]+J[13]+
    J[14]+J[15]+J[16]+J[17]+J[18]+J[19]-J[20]+J[21]-J[22]-J[23]-J[24]-J[25]-J[26]-J[27]-J[28]+J[29]-J[30]-J[31]-J[32]-J[33]-J[34]-J[35]-J[36]+
    J[37]+J[38]+J[39]+J[40]+J[41]+J[42]+J[43]-J[44]+J[45]+J[46]+J[47]+J[48]+J[49]-J[50]+J[51]+J[52]+J[53]+
    J[54]-J[55]+J[56]+J[57]+J[58]-J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]+H[1]-H[2]-H[3]+H[4]+H[5]+
    H[6]+H[7]+H[8]+H[9]-H[10]+H[11]+J[0]-J[1]-J[2]+J[3]+J[4]+J[5]+J[6]+J[7]+J[8]-J[9]+J[10]-J[11]-J[12]+
    J[13]+J[14]+J[15]+J[16]+J[17]+J[18]-J[19]+J[20]+J[21]-J[22]-J[23]-J[24]-J[25]-J[26]-J[27]+J[28]-J[29]-J[30]-J[31]-J[32]-J[33]-J[34]-J[35]+
    J[36]-J[37]+J[38]+J[39]+J[40]+J[41]+J[42]-J[43]+J[44]+J[45]+J[46]+J[47]+J[48]-J[49]+J[50]+J[51]+J[52]+
    J[53]-J[54]+J[55]+J[56]+J[57]-J[58]+J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]+H[1]-H[2]-H[3]+
    H[4]+H[5]+H[6]+H[7]+H[8]+H[9]-H[10]-H[11]+J[0]-J[1]-J[2]+J[3]+J[4]+J[5]+J[6]+J[7]+J[8]-J[9]-J[10]-J[11]-J[12]+
    J[13]+J[14]+J[15]+J[16]+J[17]+J[18]-J[19]-J[20]+J[21]-J[22]-J[23]-J[24]-J[25]-J[26]-J[27]+J[28]+J[29]-J[30]-J[31]-J[32]-J[33]-J[34]-J[35]+
    J[36]+J[37]+J[38]+J[39]+J[40]+J[41]+J[42]-J[43]-J[44]+J[45]+J[46]+J[47]+J[48]-J[49]-J[50]+J[51]+J[52]+
    J[53]-J[54]-J[55]+J[56]+J[57]-J[58]-J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]+H[1]-H[2]-H[3]+
    H[4]+H[5]+H[6]+H[7]+H[8]-H[9]+H[10]+H[11]+J[0]-J[1]-J[2]+J[3]+J[4]+J[5]+J[6]+J[7]-J[8]+J[9]+J[10]-J[11]-J[12]+
    J[13]+J[14]+J[15]+J[16]+J[17]-J[18]+J[19]+J[20]+J[21]-J[22]-J[23]-J[24]-J[25]-J[26]+J[27]-J[28]-J[29]-J[30]-J[31]-J[32]-J[33]-J[34]+
    J[35]-J[36]-J[37]+J[38]+J[39]+J[40]+J[41]-J[42]+J[43]+J[44]+J[45]+J[46]+J[47]-J[48]+J[49]+J[50]+J[51]+
    J[52]-J[53]+J[54]+J[55]+J[56]-J[57]+J[58]+J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]+H[1]-H[2]-H[3]+
    H[4]+H[5]+H[6]+H[7]+H[8]-H[9]+H[10]-H[11]+J[0]-J[1]-J[2]+J[3]+J[4]+J[5]+J[6]+J[7]-J[8]+J[9]-J[10]-J[11]-J[12]+
    J[13]+J[14]+J[15]+J[16]+J[17]-J[18]+J[19]-J[20]+J[21]-J[22]-J[23]-J[24]-J[25]-J[26]+J[27]-J[28]+J[29]-J[30]-J[31]-J[32]-J[33]-J[34]+
    J[35]-J[36]+J[37]+J[38]+J[39]+J[40]+J[41]-J[42]+J[43]-J[44]+J[45]+J[46]+J[47]-J[48]+J[49]-J[50]+J[51]+
    J[52]-J[53]+J[54]-J[55]+J[56]-J[57]+J[58]-J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]+H[1]-H[2]-H[3]+
    H[4]+H[5]+H[6]+H[7]+H[8]-H[9]-H[10]+H[11]+J[0]-J[1]-J[2]+J[3]+J[4]+J[5]+J[6]+J[7]-J[8]-J[9]+J[10]-J[11]-J[12]+
    J[13]+J[14]+J[15]+J[16]+J[17]-J[18]-J[19]+J[20]+J[21]-J[22]-J[23]-J[24]-J[25]-J[26]+J[27]+J[28]-J[29]-J[30]-J[31]-J[32]-J[33]-J[34]+
    J[35]+J[36]-J[37]+J[38]+J[39]+J[40]+J[41]-J[42]-J[43]+J[44]+J[45]+J[46]+J[47]-J[48]-J[49]+J[50]+J[51]+
    J[52]-J[53]-J[54]+J[55]+J[56]-J[57]-J[58]+J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]+H[1]-H[2]-H[3]+
    H[4]+H[5]+H[6]+H[7]+H[8]-H[9]-H[10]-H[11]+J[0]-J[1]-J[2]+J[3]+J[4]+J[5]+J[6]+J[7]-J[8]-J[9]-J[10]-J[11]-J[12]+
    J[13]+J[14]+J[15]+J[16]+J[17]-J[18]-J[19]-J[20]+J[21]-J[22]-J[23]-J[24]-J[25]-J[26]+J[27]+J[28]+J[29]-J[30]-J[31]-J[32]-J[33]-J[34]+
    J[35]+J[36]+J[37]+J[38]+J[39]+J[40]+J[41]-J[42]-J[43]-J[44]+J[45]+J[46]+J[47]-J[48]-J[49]-J[50]+J[51]+
    J[52]-J[53]-J[54]-J[55]+J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]+H[1]-H[2]-H[3]+
    H[4]+H[5]+H[6]+H[7]-H[8]+H[9]+H[10]+H[11]+J[0]-J[1]-J[2]+J[3]+J[4]+J[5]+J[6]-J[7]+J[8]+J[9]+J[10]-J[11]-J[12]+
    J[13]+J[14]+J[15]+J[16]-J[17]+J[18]+J[19]+J[20]+J[21]-J[22]-J[23]-J[24]-J[25]+J[26]-J[27]-J[28]-J[29]-J[30]-J[31]-J[32]-J[33]+
    J[34]-J[35]-J[36]-J[37]+J[38]+J[39]+J[40]-J[41]+J[42]+J[43]+J[44]+J[45]+J[46]-J[47]+J[48]+J[49]+J[50]+
    J[51]-J[52]+J[53]+J[54]+J[55]-J[56]+J[57]+J[58]+J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]+H[1]-H[2]-H[3]+
    H[4]+H[5]+H[6]+H[7]-H[8]+H[9]+H[10]-H[11]+J[0]-J[1]-J[2]+J[3]+J[4]+J[5]+J[6]-J[7]+J[8]+J[9]-J[10]-J[11]-J[12]+
    J[13]+J[14]+J[15]+J[16]-J[17]+J[18]+J[19]-J[20]+J[21]-J[22]-J[23]-J[24]-J[25]+J[26]-J[27]-J[28]+J[29]-J[30]-J[31]-J[32]-J[33]+
    J[34]-J[35]-J[36]+J[37]+J[38]+J[39]+J[40]-J[41]+J[42]+J[43]-J[44]+J[45]+J[46]-J[47]+J[48]+J[49]-J[50]+
    J[51]-J[52]+J[53]+J[54]-J[55]-J[56]+J[57]+J[58]-J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]+H[1]-H[2]-H[3]+
    H[4]+H[5]+H[6]+H[7]-H[8]+H[9]-H[10]+H[11]+J[0]-J[1]-J[2]+J[3]+J[4]+J[5]+J[6]-J[7]+J[8]-J[9]+J[10]-J[11]-J[12]+
    J[13]+J[14]+J[15]+J[16]-J[17]+J[18]-J[19]+J[20]+J[21]-J[22]-J[23]-J[24]-J[25]+J[26]-J[27]+J[28]-J[29]-J[30]-J[31]-J[32]-J[33]+
    J[34]-J[35]+J[36]-J[37]+J[38]+J[39]+J[40]-J[41]+J[42]-J[43]+J[44]+J[45]+J[46]-J[47]+J[48]-J[49]+J[50]+
    J[51]-J[52]+J[53]-J[54]+J[55]-J[56]+J[57]-J[58]+J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]+H[1]-H[2]-H[3]+
    H[4]+H[5]+H[6]+H[7]-H[8]+H[9]-H[10]-H[11]+J[0]-J[1]-J[2]+J[3]+J[4]+J[5]+J[6]-J[7]+J[8]-J[9]-J[10]-J[11]-J[12]+
    J[13]+J[14]+J[15]+J[16]-J[17]+J[18]-J[19]-J[20]+J[21]-J[22]-J[23]-J[24]-J[25]+J[26]-J[27]+J[28]+J[29]-J[30]-J[31]-J[32]-J[33]+
    J[34]-J[35]+J[36]+J[37]+J[38]+J[39]+J[40]-J[41]+J[42]-J[43]-J[44]+J[45]+J[46]-J[47]+J[48]-J[49]-J[50]+
    J[51]-J[52]+J[53]-J[54]-J[55]-J[56]+J[57]-J[58]-J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]+H[1]-H[2]-H[3]+
    H[4]+H[5]+H[6]+H[7]-H[8]-H[9]+H[10]+H[11]+J[0]-J[1]-J[2]+J[3]+J[4]+J[5]+J[6]-J[7]-J[8]+J[9]+J[10]-J[11]-J[12]+
    J[13]+J[14]+J[15]+J[16]-J[17]-J[18]+J[19]+J[20]+J[21]-J[22]-J[23]-J[24]-J[25]+J[26]+J[27]-J[28]-J[29]-J[30]-J[31]-J[32]-J[33]+
    J[34]+J[35]-J[36]-J[37]+J[38]+J[39]+J[40]-J[41]-J[42]+J[43]+J[44]+J[45]+J[46]-J[47]-J[48]+J[49]+J[50]+
    J[51]-J[52]-J[53]+J[54]+J[55]-J[56]-J[57]+J[58]+J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]+H[1]-H[2]-H[3]+
    H[4]+H[5]+H[6]+H[7]-H[8]-H[9]+H[10]-H[11]+J[0]-J[1]-J[2]+J[3]+J[4]+J[5]+J[6]-J[7]-J[8]+J[9]-J[10]-J[11]-J[12]+
    J[13]+J[14]+J[15]+J[16]-J[17]-J[18]+J[19]-J[20]+J[21]-J[22]-J[23]-J[24]-J[25]+J[26]+J[27]-J[28]+J[29]-J[30]-J[31]-J[32]-J[33]+
    J[34]+J[35]-J[36]+J[37]+J[38]+J[39]+J[40]-J[41]-J[42]+J[43]-J[44]+J[45]+J[46]-J[47]-J[48]+J[49]-J[50]+
    J[51]-J[52]-J[53]+J[54]-J[55]-J[56]-J[57]+J[58]-J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]+H[1]-H[2]-H[3]+
    H[4]+H[5]+H[6]+H[7]-H[8]-H[9]-H[10]+H[11]+J[0]-J[1]-J[2]+J[3]+J[4]+J[5]+J[6]-J[7]-J[8]-J[9]+J[10]-J[11]-J[12]+
    J[13]+J[14]+J[15]+J[16]-J[17]-J[18]-J[19]+J[20]+J[21]-J[22]-J[23]-J[24]-J[25]+J[26]+J[27]+J[28]-J[29]-J[30]-J[31]-J[32]-J[33]+
    J[34]+J[35]+J[36]-J[37]+J[38]+J[39]+J[40]-J[41]-J[42]-J[43]+J[44]+J[45]+J[46]-J[47]-J[48]-J[49]+J[50]+
    J[51]-J[52]-J[53]-J[54]+J[55]-J[56]-J[57]-J[58]+J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]+H[1]-H[2]-H[3]+
    H[4]+H[5]+H[6]+H[7]-H[8]-H[9]-H[10]-H[11]+J[0]-J[1]-J[2]+J[3]+J[4]+J[5]+J[6]-J[7]-J[8]-J[9]-J[10]-J[11]-J[12]+
    J[13]+J[14]+J[15]+J[16]-J[17]-J[18]-J[19]-J[20]+J[21]-J[22]-J[23]-J[24]-J[25]+J[26]+J[27]+J[28]+J[29]-J[30]-J[31]-J[32]-J[33]+
    J[34]+J[35]+J[36]+J[37]+J[38]+J[39]+J[40]-J[41]-J[42]-J[43]-J[44]+J[45]+J[46]-J[47]-J[48]-J[49]-J[50]+
    J[51]-J[52]-J[53]-J[54]-J[55]-J[56]-J[57]-J[58]-J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]+H[1]-H[2]-H[3]+
    H[4]+H[5]+H[6]-H[7]+H[8]+H[9]+H[10]+H[11]+J[0]-J[1]-J[2]+J[3]+J[4]+J[5]-J[6]+J[7]+J[8]+J[9]+J[10]-J[11]-J[12]+
    J[13]+J[14]+J[15]-J[16]+J[17]+J[18]+J[19]+J[20]+J[21]-J[22]-J[23]-J[24]+J[25]-J[26]-J[27]-J[28]-J[29]-J[30]-J[31]-J[32]+
    J[33]-J[34]-J[35]-J[36]-J[37]+J[38]+J[39]-J[40]+J[41]+J[42]+J[43]+J[44]+J[45]-J[46]+J[47]+J[48]+J[49]+
    J[50]-J[51]+J[52]+J[53]+J[54]+J[55]-J[56]-J[57]-J[58]-J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]+
    H[1]-H[2]-H[3]+H[4]+H[5]+H[6]-H[7]+H[8]+H[9]+H[10]-H[11]+J[0]-J[1]-J[2]+J[3]+J[4]+J[5]-J[6]+J[7]+J[8]+
    J[9]-J[10]-J[11]-J[12]+J[13]+J[14]+J[15]-J[16]+J[17]+J[18]+J[19]-J[20]+J[21]-J[22]-J[23]-J[24]+J[25]-J[26]-J[27]-J[28]+
    J[29]-J[30]-J[31]-J[32]+J[33]-J[34]-J[35]-J[36]+J[37]+J[38]+J[39]-J[40]+J[41]+J[42]+J[43]-J[44]+J[45]-J[46]+
    J[47]+J[48]+J[49]-J[50]-J[51]+J[52]+J[53]+J[54]-J[55]-J[56]-J[57]-J[58]+J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +
    H[0]+H[1]-H[2]-H[3]+H[4]+H[5]+H[6]-H[7]+H[8]+H[9]-H[10]+H[11]+J[0]-J[1]-J[2]+J[3]+J[4]+J[5]-J[6]+J[7]+
    J[8]-J[9]+J[10]-J[11]-J[12]+J[13]+J[14]+J[15]-J[16]+J[17]+J[18]-J[19]+J[20]+J[21]-J[22]-J[23]-J[24]+
    J[25]-J[26]-J[27]+J[28]-J[29]-J[30]-J[31]-J[32]+J[33]-J[34]-J[35]+J[36]-J[37]+J[38]+J[39]-J[40]+J[41]+
    J[42]-J[43]+J[44]+J[45]-J[46]+J[47]+J[48]-J[49]+J[50]-J[51]+J[52]+J[53]-J[54]+J[55]-J[56]-J[57]+J[58]-J[59]+
    J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]+H[1]-H[2]-H[3]+H[4]+H[5]+H[6]-H[7]+H[8]+H[9]-H[10]-H[11]+
    J[0]-J[1]-J[2]+J[3]+J[4]+J[5]-J[6]+J[7]+J[8]-J[9]-J[10]-J[11]-J[12]+J[13]+J[14]+J[15]-J[16]+J[17]+J[18]-J[19]-J[20]+
    J[21]-J[22]-J[23]-J[24]+J[25]-J[26]-J[27]+J[28]+J[29]-J[30]-J[31]-J[32]+J[33]-J[34]-J[35]+J[36]+J[37]+
    J[38]+J[39]-J[40]+J[41]+J[42]-J[43]-J[44]+J[45]-J[46]+J[47]+J[48]-J[49]-J[50]-J[51]+J[52]+J[53]-J[54]-J[55]-J[56]-J[57]+
    J[58]+J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]+H[1]-H[2]-H[3]+H[4]+H[5]+H[6]-H[7]+H[8]-H[9]+
    H[10]+H[11]+J[0]-J[1]-J[2]+J[3]+J[4]+J[5]-J[6]+J[7]-J[8]+J[9]+J[10]-J[11]-J[12]+J[13]+J[14]+J[15]-J[16]+
    J[17]-J[18]+J[19]+J[20]+J[21]-J[22]-J[23]-J[24]+J[25]-J[26]+J[27]-J[28]-J[29]-J[30]-J[31]-J[32]+J[33]-J[34]+
    J[35]-J[36]-J[37]+J[38]+J[39]-J[40]+J[41]-J[42]+J[43]+J[44]+J[45]-J[46]+J[47]-J[48]+J[49]+J[50]-J[51]+
    J[52]-J[53]+J[54]+J[55]-J[56]+J[57]-J[58]-J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]+H[1]-H[2]-H[3]+
    H[4]+H[5]+H[6]-H[7]+H[8]-H[9]+H[10]-H[11]+J[0]-J[1]-J[2]+J[3]+J[4]+J[5]-J[6]+J[7]-J[8]+J[9]-J[10]-J[11]-J[12]+
    J[13]+J[14]+J[15]-J[16]+J[17]-J[18]+J[19]-J[20]+J[21]-J[22]-J[23]-J[24]+J[25]-J[26]+J[27]-J[28]+J[29]-J[30]-J[31]-J[32]+
    J[33]-J[34]+J[35]-J[36]+J[37]+J[38]+J[39]-J[40]+J[41]-J[42]+J[43]-J[44]+J[45]-J[46]+J[47]-J[48]+J[49]-J[50]-J[51]+
    J[52]-J[53]+J[54]-J[55]-J[56]+J[57]-J[58]+J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]+H[1]-H[2]-H[3]+
    H[4]+H[5]+H[6]-H[7]+H[8]-H[9]-H[10]+H[11]+J[0]-J[1]-J[2]+J[3]+J[4]+J[5]-J[6]+J[7]-J[8]-J[9]+J[10]-J[11]-J[12]+
    J[13]+J[14]+J[15]-J[16]+J[17]-J[18]-J[19]+J[20]+J[21]-J[22]-J[23]-J[24]+J[25]-J[26]+J[27]+J[28]-J[29]-J[30]-J[31]-J[32]+
    J[33]-J[34]+J[35]+J[36]-J[37]+J[38]+J[39]-J[40]+J[41]-J[42]-J[43]+J[44]+J[45]-J[46]+J[47]-J[48]-J[49]+
    J[50]-J[51]+J[52]-J[53]-J[54]+J[55]-J[56]+J[57]+J[58]-J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]+
    H[1]-H[2]-H[3]+H[4]+H[5]+H[6]-H[7]+H[8]-H[9]-H[10]-H[11]+J[0]-J[1]-J[2]+J[3]+J[4]+J[5]-J[6]+J[7]-J[8]-J[9]-J[10]-J[11]-J[12]+
    J[13]+J[14]+J[15]-J[16]+J[17]-J[18]-J[19]-J[20]+J[21]-J[22]-J[23]-J[24]+J[25]-J[26]+J[27]+J[28]+J[29]-J[30]-J[31]-J[32]+
    J[33]-J[34]+J[35]+J[36]+J[37]+J[38]+J[39]-J[40]+J[41]-J[42]-J[43]-J[44]+J[45]-J[46]+J[47]-J[48]-J[49]-J[50]-J[51]+
    J[52]-J[53]-J[54]-J[55]-J[56]+J[57]+J[58]+J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]+H[1]-H[2]-H[3]+
    H[4]+H[5]+H[6]-H[7]-H[8]+H[9]+H[10]+H[11]+J[0]-J[1]-J[2]+J[3]+J[4]+J[5]-J[6]-J[7]+J[8]+J[9]+J[10]-J[11]-J[12]+
    J[13]+J[14]+J[15]-J[16]-J[17]+J[18]+J[19]+J[20]+J[21]-J[22]-J[23]-J[24]+J[25]+J[26]-J[27]-J[28]-J[29]-J[30]-J[31]-J[32]+
    J[33]+J[34]-J[35]-J[36]-J[37]+J[38]+J[39]-J[40]-J[41]+J[42]+J[43]+J[44]+J[45]-J[46]-J[47]+J[48]+J[49]+
    J[50]-J[51]-J[52]+J[53]+J[54]+J[55]+J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]+
    H[1]-H[2]-H[3]+H[4]+H[5]+H[6]-H[7]-H[8]+H[9]+H[10]-H[11]+J[0]-J[1]-J[2]+J[3]+J[4]+J[5]-J[6]-J[7]+J[8]+
    J[9]-J[10]-J[11]-J[12]+J[13]+J[14]+J[15]-J[16]-J[17]+J[18]+J[19]-J[20]+J[21]-J[22]-J[23]-J[24]+J[25]+
    J[26]-J[27]-J[28]+J[29]-J[30]-J[31]-J[32]+J[33]+J[34]-J[35]-J[36]+J[37]+J[38]+J[39]-J[40]-J[41]+J[42]+
    J[43]-J[44]+J[45]-J[46]-J[47]+J[48]+J[49]-J[50]-J[51]-J[52]+J[53]+J[54]-J[55]+J[56]-J[57]-J[58]+J[59]-J[60]-J[61]+
    J[62]+J[63]-J[64]-J[65], +H[0]+H[1]-H[2]-H[3]+H[4]+H[5]+H[6]-H[7]-H[8]+H[9]-H[10]+H[11]+J[0]-J[1]-J[2]+
    J[3]+J[4]+J[5]-J[6]-J[7]+J[8]-J[9]+J[10]-J[11]-J[12]+J[13]+J[14]+J[15]-J[16]-J[17]+J[18]-J[19]+J[20]+
    J[21]-J[22]-J[23]-J[24]+J[25]+J[26]-J[27]+J[28]-J[29]-J[30]-J[31]-J[32]+J[33]+J[34]-J[35]+J[36]-J[37]+
    J[38]+J[39]-J[40]-J[41]+J[42]-J[43]+J[44]+J[45]-J[46]-J[47]+J[48]-J[49]+J[50]-J[51]-J[52]+J[53]-J[54]+
    J[55]+J[56]-J[57]+J[58]-J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]+H[1]-H[2]-H[3]+H[4]+H[5]+H[6]-H[7]-H[8]+
    H[9]-H[10]-H[11]+J[0]-J[1]-J[2]+J[3]+J[4]+J[5]-J[6]-J[7]+J[8]-J[9]-J[10]-J[11]-J[12]+J[13]+J[14]+J[15]-J[16]-J[17]+
    J[18]-J[19]-J[20]+J[21]-J[22]-J[23]-J[24]+J[25]+J[26]-J[27]+J[28]+J[29]-J[30]-J[31]-J[32]+J[33]+J[34]-J[35]+
    J[36]+J[37]+J[38]+J[39]-J[40]-J[41]+J[42]-J[43]-J[44]+J[45]-J[46]-J[47]+J[48]-J[49]-J[50]-J[51]-J[52]+
    J[53]-J[54]-J[55]+J[56]-J[57]+J[58]+J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]+H[1]-H[2]-H[3]+
    H[4]+H[5]+H[6]-H[7]-H[8]-H[9]+H[10]+H[11]+J[0]-J[1]-J[2]+J[3]+J[4]+J[5]-J[6]-J[7]-J[8]+J[9]+J[10]-J[11]-J[12]+
    J[13]+J[14]+J[15]-J[16]-J[17]-J[18]+J[19]+J[20]+J[21]-J[22]-J[23]-J[24]+J[25]+J[26]+J[27]-J[28]-J[29]-J[30]-J[31]-J[32]+
    J[33]+J[34]+J[35]-J[36]-J[37]+J[38]+J[39]-J[40]-J[41]-J[42]+J[43]+J[44]+J[45]-J[46]-J[47]-J[48]+J[49]+
    J[50]-J[51]-J[52]-J[53]+J[54]+J[55]+J[56]+J[57]-J[58]-J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]+
    H[1]-H[2]-H[3]+H[4]+H[5]+H[6]-H[7]-H[8]-H[9]+H[10]-H[11]+J[0]-J[1]-J[2]+J[3]+J[4]+J[5]-J[6]-J[7]-J[8]+
    J[9]-J[10]-J[11]-J[12]+J[13]+J[14]+J[15]-J[16]-J[17]-J[18]+J[19]-J[20]+J[21]-J[22]-J[23]-J[24]+J[25]+
    J[26]+J[27]-J[28]+J[29]-J[30]-J[31]-J[32]+J[33]+J[34]+J[35]-J[36]+J[37]+J[38]+J[39]-J[40]-J[41]-J[42]+
    J[43]-J[44]+J[45]-J[46]-J[47]-J[48]+J[49]-J[50]-J[51]-J[52]-J[53]+J[54]-J[55]+J[56]+J[57]-J[58]+J[59]+
    J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]+H[1]-H[2]-H[3]+H[4]+H[5]+H[6]-H[7]-H[8]-H[9]-H[10]+H[11]+
    J[0]-J[1]-J[2]+J[3]+J[4]+J[5]-J[6]-J[7]-J[8]-J[9]+J[10]-J[11]-J[12]+J[13]+J[14]+J[15]-J[16]-J[17]-J[18]-J[19]+
    J[20]+J[21]-J[22]-J[23]-J[24]+J[25]+J[26]+J[27]+J[28]-J[29]-J[30]-J[31]-J[32]+J[33]+J[34]+J[35]+J[36]-J[37]+
    J[38]+J[39]-J[40]-J[41]-J[42]-J[43]+J[44]+J[45]-J[46]-J[47]-J[48]-J[49]+J[50]-J[51]-J[52]-J[53]-J[54]+
    J[55]+J[56]+J[57]+J[58]-J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]+H[1]-H[2]-H[3]+H[4]+H[5]+H[6]-H[7]-H[8]-H[9]-H[10]-H[11]+
    J[0]-J[1]-J[2]+J[3]+J[4]+J[5]-J[6]-J[7]-J[8]-J[9]-J[10]-J[11]-J[12]+J[13]+J[14]+J[15]-J[16]-J[17]-J[18]-J[19]-J[20]+
    J[21]-J[22]-J[23]-J[24]+J[25]+J[26]+J[27]+J[28]+J[29]-J[30]-J[31]-J[32]+J[33]+J[34]+J[35]+J[36]+J[37]+
    J[38]+J[39]-J[40]-J[41]-J[42]-J[43]-J[44]+J[45]-J[46]-J[47]-J[48]-J[49]-J[50]-J[51]-J[52]-J[53]-J[54]-J[55]+
    J[56]+J[57]+J[58]+J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]+H[1]-H[2]-H[3]+H[4]+H[5]-H[6]+H[7]+
    H[8]+H[9]+H[10]+H[11]+J[0]-J[1]-J[2]+J[3]+J[4]-J[5]+J[6]+J[7]+J[8]+J[9]+J[10]-J[11]-J[12]+J[13]+J[14]-J[15]+
    J[16]+J[17]+J[18]+J[19]+J[20]+J[21]-J[22]-J[23]+J[24]-J[25]-J[26]-J[27]-J[28]-J[29]-J[30]-J[31]+J[32]-J[33]-J[34]-J[35]-J[36]-J[37]+
    J[38]-J[39]+J[40]+J[41]+J[42]+J[43]+J[44]-J[45]+J[46]+J[47]+J[48]+J[49]+J[50]-J[51]-J[52]-J[53]-J[54]-J[55]+
    J[56]+J[57]+J[58]+J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]+H[1]-H[2]-H[3]+H[4]+H[5]-H[6]+H[7]+
    H[8]+H[9]+H[10]-H[11]+J[0]-J[1]-J[2]+J[3]+J[4]-J[5]+J[6]+J[7]+J[8]+J[9]-J[10]-J[11]-J[12]+J[13]+J[14]-J[15]+
    J[16]+J[17]+J[18]+J[19]-J[20]+J[21]-J[22]-J[23]+J[24]-J[25]-J[26]-J[27]-J[28]+J[29]-J[30]-J[31]+J[32]-J[33]-J[34]-J[35]-J[36]+
    J[37]+J[38]-J[39]+J[40]+J[41]+J[42]+J[43]-J[44]-J[45]+J[46]+J[47]+J[48]+J[49]-J[50]-J[51]-J[52]-J[53]-J[54]+
    J[55]+J[56]+J[57]+J[58]-J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]+H[1]-H[2]-H[3]+H[4]+H[5]-H[6]+
    H[7]+H[8]+H[9]-H[10]+H[11]+J[0]-J[1]-J[2]+J[3]+J[4]-J[5]+J[6]+J[7]+J[8]-J[9]+J[10]-J[11]-J[12]+J[13]+
    J[14]-J[15]+J[16]+J[17]+J[18]-J[19]+J[20]+J[21]-J[22]-J[23]+J[24]-J[25]-J[26]-J[27]+J[28]-J[29]-J[30]-J[31]+
    J[32]-J[33]-J[34]-J[35]+J[36]-J[37]+J[38]-J[39]+J[40]+J[41]+J[42]-J[43]+J[44]-J[45]+J[46]+J[47]+J[48]-J[49]+
    J[50]-J[51]-J[52]-J[53]+J[54]-J[55]+J[56]+J[57]-J[58]+J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]+
    H[1]-H[2]-H[3]+H[4]+H[5]-H[6]+H[7]+H[8]+H[9]-H[10]-H[11]+J[0]-J[1]-J[2]+J[3]+J[4]-J[5]+J[6]+J[7]+J[8]-J[9]-J[10]-J[11]-J[12]+
    J[13]+J[14]-J[15]+J[16]+J[17]+J[18]-J[19]-J[20]+J[21]-J[22]-J[23]+J[24]-J[25]-J[26]-J[27]+J[28]+J[29]-J[30]-J[31]+
    J[32]-J[33]-J[34]-J[35]+J[36]+J[37]+J[38]-J[39]+J[40]+J[41]+J[42]-J[43]-J[44]-J[45]+J[46]+J[47]+J[48]-J[49]-J[50]-J[51]-J[52]-J[53]+
    J[54]+J[55]+J[56]+J[57]-J[58]-J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]+H[1]-H[2]-H[3]+H[4]+H[5]-H[6]+
    H[7]+H[8]-H[9]+H[10]+H[11]+J[0]-J[1]-J[2]+J[3]+J[4]-J[5]+J[6]+J[7]-J[8]+J[9]+J[10]-J[11]-J[12]+J[13]+
    J[14]-J[15]+J[16]+J[17]-J[18]+J[19]+J[20]+J[21]-J[22]-J[23]+J[24]-J[25]-J[26]+J[27]-J[28]-J[29]-J[30]-J[31]+
    J[32]-J[33]-J[34]+J[35]-J[36]-J[37]+J[38]-J[39]+J[40]+J[41]-J[42]+J[43]+J[44]-J[45]+J[46]+J[47]-J[48]+
    J[49]+J[50]-J[51]-J[52]+J[53]-J[54]-J[55]+J[56]-J[57]+J[58]+J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +
    H[0]+H[1]-H[2]-H[3]+H[4]+H[5]-H[6]+H[7]+H[8]-H[9]+H[10]-H[11]+J[0]-J[1]-J[2]+J[3]+J[4]-J[5]+J[6]+J[7]-J[8]+
    J[9]-J[10]-J[11]-J[12]+J[13]+J[14]-J[15]+J[16]+J[17]-J[18]+J[19]-J[20]+J[21]-J[22]-J[23]+J[24]-J[25]-J[26]+
    J[27]-J[28]+J[29]-J[30]-J[31]+J[32]-J[33]-J[34]+J[35]-J[36]+J[37]+J[38]-J[39]+J[40]+J[41]-J[42]+J[43]-J[44]-J[45]+
    J[46]+J[47]-J[48]+J[49]-J[50]-J[51]-J[52]+J[53]-J[54]+J[55]+J[56]-J[57]+J[58]-J[59]-J[60]+J[61]-J[62]-J[63]+
    J[64]-J[65], +H[0]+H[1]-H[2]-H[3]+H[4]+H[5]-H[6]+H[7]+H[8]-H[9]-H[10]+H[11]+J[0]-J[1]-J[2]+J[3]+J[4]-J[5]+
    J[6]+J[7]-J[8]-J[9]+J[10]-J[11]-J[12]+J[13]+J[14]-J[15]+J[16]+J[17]-J[18]-J[19]+J[20]+J[21]-J[22]-J[23]+
    J[24]-J[25]-J[26]+J[27]+J[28]-J[29]-J[30]-J[31]+J[32]-J[33]-J[34]+J[35]+J[36]-J[37]+J[38]-J[39]+J[40]+
    J[41]-J[42]-J[43]+J[44]-J[45]+J[46]+J[47]-J[48]-J[49]+J[50]-J[51]-J[52]+J[53]+J[54]-J[55]+J[56]-J[57]-J[58]+
    J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]+H[1]-H[2]-H[3]+H[4]+H[5]-H[6]+H[7]+H[8]-H[9]-H[10]-H[11]+
    J[0]-J[1]-J[2]+J[3]+J[4]-J[5]+J[6]+J[7]-J[8]-J[9]-J[10]-J[11]-J[12]+J[13]+J[14]-J[15]+J[16]+J[17]-J[18]-J[19]-J[20]+
    J[21]-J[22]-J[23]+J[24]-J[25]-J[26]+J[27]+J[28]+J[29]-J[30]-J[31]+J[32]-J[33]-J[34]+J[35]+J[36]+J[37]+
    J[38]-J[39]+J[40]+J[41]-J[42]-J[43]-J[44]-J[45]+J[46]+J[47]-J[48]-J[49]-J[50]-J[51]-J[52]+J[53]+J[54]+
    J[55]+J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]+H[1]-H[2]-H[3]+H[4]+H[5]-H[6]+
    H[7]-H[8]+H[9]+H[10]+H[11]+J[0]-J[1]-J[2]+J[3]+J[4]-J[5]+J[6]-J[7]+J[8]+J[9]+J[10]-J[11]-J[12]+J[13]+
    J[14]-J[15]+J[16]-J[17]+J[18]+J[19]+J[20]+J[21]-J[22]-J[23]+J[24]-J[25]+J[26]-J[27]-J[28]-J[29]-J[30]-J[31]+
    J[32]-J[33]+J[34]-J[35]-J[36]-J[37]+J[38]-J[39]+J[40]-J[41]+J[42]+J[43]+J[44]-J[45]+J[46]-J[47]+J[48]+
    J[49]+J[50]-J[51]+J[52]-J[53]-J[54]-J[55]-J[56]+J[57]+J[58]+J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +
    H[0]+H[1]-H[2]-H[3]+H[4]+H[5]-H[6]+H[7]-H[8]+H[9]+H[10]-H[11]+J[0]-J[1]-J[2]+J[3]+J[4]-J[5]+J[6]-J[7]+
    J[8]+J[9]-J[10]-J[11]-J[12]+J[13]+J[14]-J[15]+J[16]-J[17]+J[18]+J[19]-J[20]+J[21]-J[22]-J[23]+J[24]-J[25]+
    J[26]-J[27]-J[28]+J[29]-J[30]-J[31]+J[32]-J[33]+J[34]-J[35]-J[36]+J[37]+J[38]-J[39]+J[40]-J[41]+J[42]+
    J[43]-J[44]-J[45]+J[46]-J[47]+J[48]+J[49]-J[50]-J[51]+J[52]-J[53]-J[54]+J[55]-J[56]+J[57]+J[58]-J[59]-J[60]-J[61]+
    J[62]+J[63]-J[64]-J[65], +H[0]+H[1]-H[2]-H[3]+H[4]+H[5]-H[6]+H[7]-H[8]+H[9]-H[10]+H[11]+J[0]-J[1]-J[2]+
    J[3]+J[4]-J[5]+J[6]-J[7]+J[8]-J[9]+J[10]-J[11]-J[12]+J[13]+J[14]-J[15]+J[16]-J[17]+J[18]-J[19]+J[20]+
    J[21]-J[22]-J[23]+J[24]-J[25]+J[26]-J[27]+J[28]-J[29]-J[30]-J[31]+J[32]-J[33]+J[34]-J[35]+J[36]-J[37]+
    J[38]-J[39]+J[40]-J[41]+J[42]-J[43]+J[44]-J[45]+J[46]-J[47]+J[48]-J[49]+J[50]-J[51]+J[52]-J[53]+J[54]-J[55]-J[56]+
    J[57]-J[58]+J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]+H[1]-H[2]-H[3]+H[4]+H[5]-H[6]+H[7]-H[8]+
    H[9]-H[10]-H[11]+J[0]-J[1]-J[2]+J[3]+J[4]-J[5]+J[6]-J[7]+J[8]-J[9]-J[10]-J[11]-J[12]+J[13]+J[14]-J[15]+
    J[16]-J[17]+J[18]-J[19]-J[20]+J[21]-J[22]-J[23]+J[24]-J[25]+J[26]-J[27]+J[28]+J[29]-J[30]-J[31]+J[32]-J[33]+
    J[34]-J[35]+J[36]+J[37]+J[38]-J[39]+J[40]-J[41]+J[42]-J[43]-J[44]-J[45]+J[46]-J[47]+J[48]-J[49]-J[50]-J[51]+
    J[52]-J[53]+J[54]+J[55]-J[56]+J[57]-J[58]-J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]+H[1]-H[2]-H[3]+
    H[4]+H[5]-H[6]+H[7]-H[8]-H[9]+H[10]+H[11]+J[0]-J[1]-J[2]+J[3]+J[4]-J[5]+J[6]-J[7]-J[8]+J[9]+J[10]-J[11]-J[12]+
    J[13]+J[14]-J[15]+J[16]-J[17]-J[18]+J[19]+J[20]+J[21]-J[22]-J[23]+J[24]-J[25]+J[26]+J[27]-J[28]-J[29]-J[30]-J[31]+
    J[32]-J[33]+J[34]+J[35]-J[36]-J[37]+J[38]-J[39]+J[40]-J[41]-J[42]+J[43]+J[44]-J[45]+J[46]-J[47]-J[48]+
    J[49]+J[50]-J[51]+J[52]+J[53]-J[54]-J[55]-J[56]-J[57]+J[58]+J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +
    H[0]+H[1]-H[2]-H[3]+H[4]+H[5]-H[6]+H[7]-H[8]-H[9]+H[10]-H[11]+J[0]-J[1]-J[2]+J[3]+J[4]-J[5]+J[6]-J[7]-J[8]+
    J[9]-J[10]-J[11]-J[12]+J[13]+J[14]-J[15]+J[16]-J[17]-J[18]+J[19]-J[20]+J[21]-J[22]-J[23]+J[24]-J[25]+
    J[26]+J[27]-J[28]+J[29]-J[30]-J[31]+J[32]-J[33]+J[34]+J[35]-J[36]+J[37]+J[38]-J[39]+J[40]-J[41]-J[42]+
    J[43]-J[44]-J[45]+J[46]-J[47]-J[48]+J[49]-J[50]-J[51]+J[52]+J[53]-J[54]+J[55]-J[56]-J[57]+J[58]-J[59]+
    J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]+H[1]-H[2]-H[3]+H[4]+H[5]-H[6]+H[7]-H[8]-H[9]-H[10]+H[11]+
    J[0]-J[1]-J[2]+J[3]+J[4]-J[5]+J[6]-J[7]-J[8]-J[9]+J[10]-J[11]-J[12]+J[13]+J[14]-J[15]+J[16]-J[17]-J[18]-J[19]+
    J[20]+J[21]-J[22]-J[23]+J[24]-J[25]+J[26]+J[27]+J[28]-J[29]-J[30]-J[31]+J[32]-J[33]+J[34]+J[35]+J[36]-J[37]+
    J[38]-J[39]+J[40]-J[41]-J[42]-J[43]+J[44]-J[45]+J[46]-J[47]-J[48]-J[49]+J[50]-J[51]+J[52]+J[53]+J[54]-J[55]-J[56]-J[57]-J[58]+
    J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]+H[1]-H[2]-H[3]+H[4]+H[5]-H[6]+H[7]-H[8]-H[9]-H[10]-H[11]+
    J[0]-J[1]-J[2]+J[3]+J[4]-J[5]+J[6]-J[7]-J[8]-J[9]-J[10]-J[11]-J[12]+J[13]+J[14]-J[15]+J[16]-J[17]-J[18]-J[19]-J[20]+
    J[21]-J[22]-J[23]+J[24]-J[25]+J[26]+J[27]+J[28]+J[29]-J[30]-J[31]+J[32]-J[33]+J[34]+J[35]+J[36]+J[37]+
    J[38]-J[39]+J[40]-J[41]-J[42]-J[43]-J[44]-J[45]+J[46]-J[47]-J[48]-J[49]-J[50]-J[51]+J[52]+J[53]+J[54]+
    J[55]-J[56]-J[57]-J[58]-J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]+H[1]-H[2]-H[3]+H[4]+H[5]-H[6]-H[7]+
    H[8]+H[9]+H[10]+H[11]+J[0]-J[1]-J[2]+J[3]+J[4]-J[5]-J[6]+J[7]+J[8]+J[9]+J[10]-J[11]-J[12]+J[13]+J[14]-J[15]-J[16]+
    J[17]+J[18]+J[19]+J[20]+J[21]-J[22]-J[23]+J[24]+J[25]-J[26]-J[27]-J[28]-J[29]-J[30]-J[31]+J[32]+J[33]-J[34]-J[35]-J[36]-J[37]+
    J[38]-J[39]-J[40]+J[41]+J[42]+J[43]+J[44]-J[45]-J[46]+J[47]+J[48]+J[49]+J[50]+J[51]-J[52]-J[53]-J[54]-J[55]-J[56]-J[57]-J[58]-J[59]+
    J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]+H[1]-H[2]-H[3]+H[4]+H[5]-H[6]-H[7]+H[8]+H[9]+H[10]-H[11]+
    J[0]-J[1]-J[2]+J[3]+J[4]-J[5]-J[6]+J[7]+J[8]+J[9]-J[10]-J[11]-J[12]+J[13]+J[14]-J[15]-J[16]+J[17]+J[18]+
    J[19]-J[20]+J[21]-J[22]-J[23]+J[24]+J[25]-J[26]-J[27]-J[28]+J[29]-J[30]-J[31]+J[32]+J[33]-J[34]-J[35]-J[36]+
    J[37]+J[38]-J[39]-J[40]+J[41]+J[42]+J[43]-J[44]-J[45]-J[46]+J[47]+J[48]+J[49]-J[50]+J[51]-J[52]-J[53]-J[54]+
    J[55]-J[56]-J[57]-J[58]+J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]+H[1]-H[2]-H[3]+H[4]+H[5]-H[6]-H[7]+
    H[8]+H[9]-H[10]+H[11]+J[0]-J[1]-J[2]+J[3]+J[4]-J[5]-J[6]+J[7]+J[8]-J[9]+J[10]-J[11]-J[12]+J[13]+J[14]-J[15]-J[16]+
    J[17]+J[18]-J[19]+J[20]+J[21]-J[22]-J[23]+J[24]+J[25]-J[26]-J[27]+J[28]-J[29]-J[30]-J[31]+J[32]+J[33]-J[34]-J[35]+
    J[36]-J[37]+J[38]-J[39]-J[40]+J[41]+J[42]-J[43]+J[44]-J[45]-J[46]+J[47]+J[48]-J[49]+J[50]+J[51]-J[52]-J[53]+
    J[54]-J[55]-J[56]-J[57]+J[58]-J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]+H[1]-H[2]-H[3]+H[4]+H[5]-H[6]-H[7]+
    H[8]+H[9]-H[10]-H[11]+J[0]-J[1]-J[2]+J[3]+J[4]-J[5]-J[6]+J[7]+J[8]-J[9]-J[10]-J[11]-J[12]+J[13]+J[14]-J[15]-J[16]+
    J[17]+J[18]-J[19]-J[20]+J[21]-J[22]-J[23]+J[24]+J[25]-J[26]-J[27]+J[28]+J[29]-J[30]-J[31]+J[32]+J[33]-J[34]-J[35]+
    J[36]+J[37]+J[38]-J[39]-J[40]+J[41]+J[42]-J[43]-J[44]-J[45]-J[46]+J[47]+J[48]-J[49]-J[50]+J[51]-J[52]-J[53]+
    J[54]+J[55]-J[56]-J[57]+J[58]+J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]+H[1]-H[2]-H[3]+H[4]+H[5]-H[6]-H[7]+
    H[8]-H[9]+H[10]+H[11]+J[0]-J[1]-J[2]+J[3]+J[4]-J[5]-J[6]+J[7]-J[8]+J[9]+J[10]-J[11]-J[12]+J[13]+J[14]-J[15]-J[16]+
    J[17]-J[18]+J[19]+J[20]+J[21]-J[22]-J[23]+J[24]+J[25]-J[26]+J[27]-J[28]-J[29]-J[30]-J[31]+J[32]+J[33]-J[34]+
    J[35]-J[36]-J[37]+J[38]-J[39]-J[40]+J[41]-J[42]+J[43]+J[44]-J[45]-J[46]+J[47]-J[48]+J[49]+J[50]+J[51]-J[52]+
    J[53]-J[54]-J[55]-J[56]+J[57]-J[58]-J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]+H[1]-H[2]-H[3]+
    H[4]+H[5]-H[6]-H[7]+H[8]-H[9]+H[10]-H[11]+J[0]-J[1]-J[2]+J[3]+J[4]-J[5]-J[6]+J[7]-J[8]+J[9]-J[10]-J[11]-J[12]+
    J[13]+J[14]-J[15]-J[16]+J[17]-J[18]+J[19]-J[20]+J[21]-J[22]-J[23]+J[24]+J[25]-J[26]+J[27]-J[28]+J[29]-J[30]-J[31]+
    J[32]+J[33]-J[34]+J[35]-J[36]+J[37]+J[38]-J[39]-J[40]+J[41]-J[42]+J[43]-J[44]-J[45]-J[46]+J[47]-J[48]+
    J[49]-J[50]+J[51]-J[52]+J[53]-J[54]+J[55]-J[56]+J[57]-J[58]+J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +
    H[0]+H[1]-H[2]-H[3]+H[4]+H[5]-H[6]-H[7]+H[8]-H[9]-H[10]+H[11]+J[0]-J[1]-J[2]+J[3]+J[4]-J[5]-J[6]+J[7]-J[8]-J[9]+
    J[10]-J[11]-J[12]+J[13]+J[14]-J[15]-J[16]+J[17]-J[18]-J[19]+J[20]+J[21]-J[22]-J[23]+J[24]+J[25]-J[26]+
    J[27]+J[28]-J[29]-J[30]-J[31]+J[32]+J[33]-J[34]+J[35]+J[36]-J[37]+J[38]-J[39]-J[40]+J[41]-J[42]-J[43]+
    J[44]-J[45]-J[46]+J[47]-J[48]-J[49]+J[50]+J[51]-J[52]+J[53]+J[54]-J[55]-J[56]+J[57]+J[58]-J[59]-J[60]-J[61]+
    J[62]+J[63]-J[64]-J[65], +H[0]+H[1]-H[2]-H[3]+H[4]+H[5]-H[6]-H[7]+H[8]-H[9]-H[10]-H[11]+J[0]-J[1]-J[2]+
    J[3]+J[4]-J[5]-J[6]+J[7]-J[8]-J[9]-J[10]-J[11]-J[12]+J[13]+J[14]-J[15]-J[16]+J[17]-J[18]-J[19]-J[20]+
    J[21]-J[22]-J[23]+J[24]+J[25]-J[26]+J[27]+J[28]+J[29]-J[30]-J[31]+J[32]+J[33]-J[34]+J[35]+J[36]+J[37]+
    J[38]-J[39]-J[40]+J[41]-J[42]-J[43]-J[44]-J[45]-J[46]+J[47]-J[48]-J[49]-J[50]+J[51]-J[52]+J[53]+J[54]+
    J[55]-J[56]+J[57]+J[58]+J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]+H[1]-H[2]-H[3]+H[4]+H[5]-H[6]-H[7]-H[8]+
    H[9]+H[10]+H[11]+J[0]-J[1]-J[2]+J[3]+J[4]-J[5]-J[6]-J[7]+J[8]+J[9]+J[10]-J[11]-J[12]+J[13]+J[14]-J[15]-J[16]-J[17]+
    J[18]+J[19]+J[20]+J[21]-J[22]-J[23]+J[24]+J[25]+J[26]-J[27]-J[28]-J[29]-J[30]-J[31]+J[32]+J[33]+J[34]-J[35]-J[36]-J[37]+
    J[38]-J[39]-J[40]-J[41]+J[42]+J[43]+J[44]-J[45]-J[46]-J[47]+J[48]+J[49]+J[50]+J[51]+J[52]-J[53]-J[54]-J[55]+
    J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]+H[1]-H[2]-H[3]+H[4]+H[5]-H[6]-H[7]-H[8]+
    H[9]+H[10]-H[11]+J[0]-J[1]-J[2]+J[3]+J[4]-J[5]-J[6]-J[7]+J[8]+J[9]-J[10]-J[11]-J[12]+J[13]+J[14]-J[15]-J[16]-J[17]+
    J[18]+J[19]-J[20]+J[21]-J[22]-J[23]+J[24]+J[25]+J[26]-J[27]-J[28]+J[29]-J[30]-J[31]+J[32]+J[33]+J[34]-J[35]-J[36]+
    J[37]+J[38]-J[39]-J[40]-J[41]+J[42]+J[43]-J[44]-J[45]-J[46]-J[47]+J[48]+J[49]-J[50]+J[51]+J[52]-J[53]-J[54]+
    J[55]+J[56]-J[57]-J[58]+J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]+H[1]-H[2]-H[3]+H[4]+H[5]-H[6]-H[7]-H[8]+
    H[9]-H[10]+H[11]+J[0]-J[1]-J[2]+J[3]+J[4]-J[5]-J[6]-J[7]+J[8]-J[9]+J[10]-J[11]-J[12]+J[13]+J[14]-J[15]-J[16]-J[17]+
    J[18]-J[19]+J[20]+J[21]-J[22]-J[23]+J[24]+J[25]+J[26]-J[27]+J[28]-J[29]-J[30]-J[31]+J[32]+J[33]+J[34]-J[35]+
    J[36]-J[37]+J[38]-J[39]-J[40]-J[41]+J[42]-J[43]+J[44]-J[45]-J[46]-J[47]+J[48]-J[49]+J[50]+J[51]+J[52]-J[53]+
    J[54]-J[55]+J[56]-J[57]+J[58]-J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]+H[1]-H[2]-H[3]+H[4]+H[5]-H[6]-H[7]-H[8]+
    H[9]-H[10]-H[11]+J[0]-J[1]-J[2]+J[3]+J[4]-J[5]-J[6]-J[7]+J[8]-J[9]-J[10]-J[11]-J[12]+J[13]+J[14]-J[15]-J[16]-J[17]+
    J[18]-J[19]-J[20]+J[21]-J[22]-J[23]+J[24]+J[25]+J[26]-J[27]+J[28]+J[29]-J[30]-J[31]+J[32]+J[33]+J[34]-J[35]+
    J[36]+J[37]+J[38]-J[39]-J[40]-J[41]+J[42]-J[43]-J[44]-J[45]-J[46]-J[47]+J[48]-J[49]-J[50]+J[51]+J[52]-J[53]+
    J[54]+J[55]+J[56]-J[57]+J[58]+J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]+H[1]-H[2]-H[3]+H[4]+H[5]-H[6]-H[7]-H[8]-H[9]+
    H[10]+H[11]+J[0]-J[1]-J[2]+J[3]+J[4]-J[5]-J[6]-J[7]-J[8]+J[9]+J[10]-J[11]-J[12]+J[13]+J[14]-J[15]-J[16]-J[17]-J[18]+
    J[19]+J[20]+J[21]-J[22]-J[23]+J[24]+J[25]+J[26]+J[27]-J[28]-J[29]-J[30]-J[31]+J[32]+J[33]+J[34]+J[35]-J[36]-J[37]+
    J[38]-J[39]-J[40]-J[41]-J[42]+J[43]+J[44]-J[45]-J[46]-J[47]-J[48]+J[49]+J[50]+J[51]+J[52]+J[53]-J[54]-J[55]+
    J[56]+J[57]-J[58]-J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]+H[1]-H[2]-H[3]+H[4]+H[5]-H[6]-H[7]-H[8]-H[9]+
    H[10]-H[11]+J[0]-J[1]-J[2]+J[3]+J[4]-J[5]-J[6]-J[7]-J[8]+J[9]-J[10]-J[11]-J[12]+J[13]+J[14]-J[15]-J[16]-J[17]-J[18]+
    J[19]-J[20]+J[21]-J[22]-J[23]+J[24]+J[25]+J[26]+J[27]-J[28]+J[29]-J[30]-J[31]+J[32]+J[33]+J[34]+J[35]-J[36]+
    J[37]+J[38]-J[39]-J[40]-J[41]-J[42]+J[43]-J[44]-J[45]-J[46]-J[47]-J[48]+J[49]-J[50]+J[51]+J[52]+J[53]-J[54]+
    J[55]+J[56]+J[57]-J[58]+J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]+H[1]-H[2]-H[3]+H[4]+H[5]-H[6]-H[7]-H[8]-H[9]-H[10]+
    H[11]+J[0]-J[1]-J[2]+J[3]+J[4]-J[5]-J[6]-J[7]-J[8]-J[9]+J[10]-J[11]-J[12]+J[13]+J[14]-J[15]-J[16]-J[17]-J[18]-J[19]+
    J[20]+J[21]-J[22]-J[23]+J[24]+J[25]+J[26]+J[27]+J[28]-J[29]-J[30]-J[31]+J[32]+J[33]+J[34]+J[35]+J[36]-J[37]+
    J[38]-J[39]-J[40]-J[41]-J[42]-J[43]+J[44]-J[45]-J[46]-J[47]-J[48]-J[49]+J[50]+J[51]+J[52]+J[53]+J[54]-J[55]+
    J[56]+J[57]+J[58]-J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]+H[1]-H[2]-H[3]+H[4]+H[5]-H[6]-H[7]-H[8]-H[9]-H[10]-H[11]+
    J[0]-J[1]-J[2]+J[3]+J[4]-J[5]-J[6]-J[7]-J[8]-J[9]-J[10]-J[11]-J[12]+J[13]+J[14]-J[15]-J[16]-J[17]-J[18]-J[19]-J[20]+
    J[21]-J[22]-J[23]+J[24]+J[25]+J[26]+J[27]+J[28]+J[29]-J[30]-J[31]+J[32]+J[33]+J[34]+J[35]+J[36]+J[37]+
    J[38]-J[39]-J[40]-J[41]-J[42]-J[43]-J[44]-J[45]-J[46]-J[47]-J[48]-J[49]-J[50]+J[51]+J[52]+J[53]+J[54]+
    J[55]+J[56]+J[57]+J[58]+J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]+H[1]-H[2]-H[3]+H[4]-H[5]+H[6]+
    H[7]+H[8]+H[9]+H[10]+H[11]+J[0]-J[1]-J[2]+J[3]-J[4]+J[5]+J[6]+J[7]+J[8]+J[9]+J[10]-J[11]-J[12]+J[13]-J[14]+
    J[15]+J[16]+J[17]+J[18]+J[19]+J[20]+J[21]-J[22]+J[23]-J[24]-J[25]-J[26]-J[27]-J[28]-J[29]-J[30]+J[31]-J[32]-J[33]-J[34]-J[35]-J[36]-J[37]-J[38]+
    J[39]+J[40]+J[41]+J[42]+J[43]+J[44]-J[45]-J[46]-J[47]-J[48]-J[49]-J[50]+J[51]+J[52]+J[53]+J[54]+J[55]+
    J[56]+J[57]+J[58]+J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]+H[1]-H[2]-H[3]+H[4]-H[5]+H[6]+H[7]+
    H[8]+H[9]+H[10]-H[11]+J[0]-J[1]-J[2]+J[3]-J[4]+J[5]+J[6]+J[7]+J[8]+J[9]-J[10]-J[11]-J[12]+J[13]-J[14]+
    J[15]+J[16]+J[17]+J[18]+J[19]-J[20]+J[21]-J[22]+J[23]-J[24]-J[25]-J[26]-J[27]-J[28]+J[29]-J[30]+J[31]-J[32]-J[33]-J[34]-J[35]-J[36]+
    J[37]-J[38]+J[39]+J[40]+J[41]+J[42]+J[43]-J[44]-J[45]-J[46]-J[47]-J[48]-J[49]+J[50]+J[51]+J[52]+J[53]+
    J[54]-J[55]+J[56]+J[57]+J[58]-J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]+H[1]-H[2]-H[3]+H[4]-H[5]+
    H[6]+H[7]+H[8]+H[9]-H[10]+H[11]+J[0]-J[1]-J[2]+J[3]-J[4]+J[5]+J[6]+J[7]+J[8]-J[9]+J[10]-J[11]-J[12]+
    J[13]-J[14]+J[15]+J[16]+J[17]+J[18]-J[19]+J[20]+J[21]-J[22]+J[23]-J[24]-J[25]-J[26]-J[27]+J[28]-J[29]-J[30]+
    J[31]-J[32]-J[33]-J[34]-J[35]+J[36]-J[37]-J[38]+J[39]+J[40]+J[41]+J[42]-J[43]+J[44]-J[45]-J[46]-J[47]-J[48]+
    J[49]-J[50]+J[51]+J[52]+J[53]-J[54]+J[55]+J[56]+J[57]-J[58]+J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +
    H[0]+H[1]-H[2]-H[3]+H[4]-H[5]+H[6]+H[7]+H[8]+H[9]-H[10]-H[11]+J[0]-J[1]-J[2]+J[3]-J[4]+J[5]+J[6]+J[7]+
    J[8]-J[9]-J[10]-J[11]-J[12]+J[13]-J[14]+J[15]+J[16]+J[17]+J[18]-J[19]-J[20]+J[21]-J[22]+J[23]-J[24]-J[25]-J[26]-J[27]+
    J[28]+J[29]-J[30]+J[31]-J[32]-J[33]-J[34]-J[35]+J[36]+J[37]-J[38]+J[39]+J[40]+J[41]+J[42]-J[43]-J[44]-J[45]-J[46]-J[47]-J[48]+
    J[49]+J[50]+J[51]+J[52]+J[53]-J[54]-J[55]+J[56]+J[57]-J[58]-J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +
    H[0]+H[1]-H[2]-H[3]+H[4]-H[5]+H[6]+H[7]+H[8]-H[9]+H[10]+H[11]+J[0]-J[1]-J[2]+J[3]-J[4]+J[5]+J[6]+J[7]-J[8]+
    J[9]+J[10]-J[11]-J[12]+J[13]-J[14]+J[15]+J[16]+J[17]-J[18]+J[19]+J[20]+J[21]-J[22]+J[23]-J[24]-J[25]-J[26]+
    J[27]-J[28]-J[29]-J[30]+J[31]-J[32]-J[33]-J[34]+J[35]-J[36]-J[37]-J[38]+J[39]+J[40]+J[41]-J[42]+J[43]+
    J[44]-J[45]-J[46]-J[47]+J[48]-J[49]-J[50]+J[51]+J[52]-J[53]+J[54]+J[55]+J[56]-J[57]+J[58]+J[59]-J[60]+
    J[61]+J[62]-J[63]-J[64]+J[65], +H[0]+H[1]-H[2]-H[3]+H[4]-H[5]+H[6]+H[7]+H[8]-H[9]+H[10]-H[11]+J[0]-J[1]-J[2]+
    J[3]-J[4]+J[5]+J[6]+J[7]-J[8]+J[9]-J[10]-J[11]-J[12]+J[13]-J[14]+J[15]+J[16]+J[17]-J[18]+J[19]-J[20]+
    J[21]-J[22]+J[23]-J[24]-J[25]-J[26]+J[27]-J[28]+J[29]-J[30]+J[31]-J[32]-J[33]-J[34]+J[35]-J[36]+J[37]-J[38]+
    J[39]+J[40]+J[41]-J[42]+J[43]-J[44]-J[45]-J[46]-J[47]+J[48]-J[49]+J[50]+J[51]+J[52]-J[53]+J[54]-J[55]+
    J[56]-J[57]+J[58]-J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]+H[1]-H[2]-H[3]+H[4]-H[5]+H[6]+H[7]+
    H[8]-H[9]-H[10]+H[11]+J[0]-J[1]-J[2]+J[3]-J[4]+J[5]+J[6]+J[7]-J[8]-J[9]+J[10]-J[11]-J[12]+J[13]-J[14]+
    J[15]+J[16]+J[17]-J[18]-J[19]+J[20]+J[21]-J[22]+J[23]-J[24]-J[25]-J[26]+J[27]+J[28]-J[29]-J[30]+J[31]-J[32]-J[33]-J[34]+
    J[35]+J[36]-J[37]-J[38]+J[39]+J[40]+J[41]-J[42]-J[43]+J[44]-J[45]-J[46]-J[47]+J[48]+J[49]-J[50]+J[51]+
    J[52]-J[53]-J[54]+J[55]+J[56]-J[57]-J[58]+J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]+H[1]-H[2]-H[3]+
    H[4]-H[5]+H[6]+H[7]+H[8]-H[9]-H[10]-H[11]+J[0]-J[1]-J[2]+J[3]-J[4]+J[5]+J[6]+J[7]-J[8]-J[9]-J[10]-J[11]-J[12]+
    J[13]-J[14]+J[15]+J[16]+J[17]-J[18]-J[19]-J[20]+J[21]-J[22]+J[23]-J[24]-J[25]-J[26]+J[27]+J[28]+J[29]-J[30]+
    J[31]-J[32]-J[33]-J[34]+J[35]+J[36]+J[37]-J[38]+J[39]+J[40]+J[41]-J[42]-J[43]-J[44]-J[45]-J[46]-J[47]+
    J[48]+J[49]+J[50]+J[51]+J[52]-J[53]-J[54]-J[55]+J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+
    J[65], +H[0]+H[1]-H[2]-H[3]+H[4]-H[5]+H[6]+H[7]-H[8]+H[9]+H[10]+H[11]+J[0]-J[1]-J[2]+J[3]-J[4]+J[5]+
    J[6]-J[7]+J[8]+J[9]+J[10]-J[11]-J[12]+J[13]-J[14]+J[15]+J[16]-J[17]+J[18]+J[19]+J[20]+J[21]-J[22]+J[23]-J[24]-J[25]+
    J[26]-J[27]-J[28]-J[29]-J[30]+J[31]-J[32]-J[33]+J[34]-J[35]-J[36]-J[37]-J[38]+J[39]+J[40]-J[41]+J[42]+
    J[43]+J[44]-J[45]-J[46]+J[47]-J[48]-J[49]-J[50]+J[51]-J[52]+J[53]+J[54]+J[55]-J[56]+J[57]+J[58]+J[59]-J[60]-J[61]-J[62]+
    J[63]+J[64]+J[65], +H[0]+H[1]-H[2]-H[3]+H[4]-H[5]+H[6]+H[7]-H[8]+H[9]+H[10]-H[11]+J[0]-J[1]-J[2]+J[3]-J[4]+
    J[5]+J[6]-J[7]+J[8]+J[9]-J[10]-J[11]-J[12]+J[13]-J[14]+J[15]+J[16]-J[17]+J[18]+J[19]-J[20]+J[21]-J[22]+
    J[23]-J[24]-J[25]+J[26]-J[27]-J[28]+J[29]-J[30]+J[31]-J[32]-J[33]+J[34]-J[35]-J[36]+J[37]-J[38]+J[39]+
    J[40]-J[41]+J[42]+J[43]-J[44]-J[45]-J[46]+J[47]-J[48]-J[49]+J[50]+J[51]-J[52]+J[53]+J[54]-J[55]-J[56]+
    J[57]+J[58]-J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]+H[1]-H[2]-H[3]+H[4]-H[5]+H[6]+H[7]-H[8]+
    H[9]-H[10]+H[11]+J[0]-J[1]-J[2]+J[3]-J[4]+J[5]+J[6]-J[7]+J[8]-J[9]+J[10]-J[11]-J[12]+J[13]-J[14]+J[15]+
    J[16]-J[17]+J[18]-J[19]+J[20]+J[21]-J[22]+J[23]-J[24]-J[25]+J[26]-J[27]+J[28]-J[29]-J[30]+J[31]-J[32]-J[33]+
    J[34]-J[35]+J[36]-J[37]-J[38]+J[39]+J[40]-J[41]+J[42]-J[43]+J[44]-J[45]-J[46]+J[47]-J[48]+J[49]-J[50]+
    J[51]-J[52]+J[53]-J[54]+J[55]-J[56]+J[57]-J[58]+J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]+H[1]-H[2]-H[3]+
    H[4]-H[5]+H[6]+H[7]-H[8]+H[9]-H[10]-H[11]+J[0]-J[1]-J[2]+J[3]-J[4]+J[5]+J[6]-J[7]+J[8]-J[9]-J[10]-J[11]-J[12]+
    J[13]-J[14]+J[15]+J[16]-J[17]+J[18]-J[19]-J[20]+J[21]-J[22]+J[23]-J[24]-J[25]+J[26]-J[27]+J[28]+J[29]-J[30]+
    J[31]-J[32]-J[33]+J[34]-J[35]+J[36]+J[37]-J[38]+J[39]+J[40]-J[41]+J[42]-J[43]-J[44]-J[45]-J[46]+J[47]-J[48]+
    J[49]+J[50]+J[51]-J[52]+J[53]-J[54]-J[55]-J[56]+J[57]-J[58]-J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +
    H[0]+H[1]-H[2]-H[3]+H[4]-H[5]+H[6]+H[7]-H[8]-H[9]+H[10]+H[11]+J[0]-J[1]-J[2]+J[3]-J[4]+J[5]+J[6]-J[7]-J[8]+
    J[9]+J[10]-J[11]-J[12]+J[13]-J[14]+J[15]+J[16]-J[17]-J[18]+J[19]+J[20]+J[21]-J[22]+J[23]-J[24]-J[25]+
    J[26]+J[27]-J[28]-J[29]-J[30]+J[31]-J[32]-J[33]+J[34]+J[35]-J[36]-J[37]-J[38]+J[39]+J[40]-J[41]-J[42]+
    J[43]+J[44]-J[45]-J[46]+J[47]+J[48]-J[49]-J[50]+J[51]-J[52]-J[53]+J[54]+J[55]-J[56]-J[57]+J[58]+J[59]+
    J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]+H[1]-H[2]-H[3]+H[4]-H[5]+H[6]+H[7]-H[8]-H[9]+H[10]-H[11]+
    J[0]-J[1]-J[2]+J[3]-J[4]+J[5]+J[6]-J[7]-J[8]+J[9]-J[10]-J[11]-J[12]+J[13]-J[14]+J[15]+J[16]-J[17]-J[18]+
    J[19]-J[20]+J[21]-J[22]+J[23]-J[24]-J[25]+J[26]+J[27]-J[28]+J[29]-J[30]+J[31]-J[32]-J[33]+J[34]+J[35]-J[36]+
    J[37]-J[38]+J[39]+J[40]-J[41]-J[42]+J[43]-J[44]-J[45]-J[46]+J[47]+J[48]-J[49]+J[50]+J[51]-J[52]-J[53]+
    J[54]-J[55]-J[56]-J[57]+J[58]-J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]+H[1]-H[2]-H[3]+H[4]-H[5]+
    H[6]+H[7]-H[8]-H[9]-H[10]+H[11]+J[0]-J[1]-J[2]+J[3]-J[4]+J[5]+J[6]-J[7]-J[8]-J[9]+J[10]-J[11]-J[12]+
    J[13]-J[14]+J[15]+J[16]-J[17]-J[18]-J[19]+J[20]+J[21]-J[22]+J[23]-J[24]-J[25]+J[26]+J[27]+J[28]-J[29]-J[30]+
    J[31]-J[32]-J[33]+J[34]+J[35]+J[36]-J[37]-J[38]+J[39]+J[40]-J[41]-J[42]-J[43]+J[44]-J[45]-J[46]+J[47]+
    J[48]+J[49]-J[50]+J[51]-J[52]-J[53]-J[54]+J[55]-J[56]-J[57]-J[58]+J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +
    H[0]+H[1]-H[2]-H[3]+H[4]-H[5]+H[6]+H[7]-H[8]-H[9]-H[10]-H[11]+J[0]-J[1]-J[2]+J[3]-J[4]+J[5]+J[6]-J[7]-J[8]-J[9]-J[10]-J[11]-J[12]+
    J[13]-J[14]+J[15]+J[16]-J[17]-J[18]-J[19]-J[20]+J[21]-J[22]+J[23]-J[24]-J[25]+J[26]+J[27]+J[28]+J[29]-J[30]+
    J[31]-J[32]-J[33]+J[34]+J[35]+J[36]+J[37]-J[38]+J[39]+J[40]-J[41]-J[42]-J[43]-J[44]-J[45]-J[46]+J[47]+
    J[48]+J[49]+J[50]+J[51]-J[52]-J[53]-J[54]-J[55]-J[56]-J[57]-J[58]-J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+
    J[65], +H[0]+H[1]-H[2]-H[3]+H[4]-H[5]+H[6]-H[7]+H[8]+H[9]+H[10]+H[11]+J[0]-J[1]-J[2]+J[3]-J[4]+J[5]-J[6]+
    J[7]+J[8]+J[9]+J[10]-J[11]-J[12]+J[13]-J[14]+J[15]-J[16]+J[17]+J[18]+J[19]+J[20]+J[21]-J[22]+J[23]-J[24]+
    J[25]-J[26]-J[27]-J[28]-J[29]-J[30]+J[31]-J[32]+J[33]-J[34]-J[35]-J[36]-J[37]-J[38]+J[39]-J[40]+J[41]+
    J[42]+J[43]+J[44]-J[45]+J[46]-J[47]-J[48]-J[49]-J[50]-J[51]+J[52]+J[53]+J[54]+J[55]-J[56]-J[57]-J[58]-J[59]+
    J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]+H[1]-H[2]-H[3]+H[4]-H[5]+H[6]-H[7]+H[8]+H[9]+H[10]-H[11]+
    J[0]-J[1]-J[2]+J[3]-J[4]+J[5]-J[6]+J[7]+J[8]+J[9]-J[10]-J[11]-J[12]+J[13]-J[14]+J[15]-J[16]+J[17]+J[18]+
    J[19]-J[20]+J[21]-J[22]+J[23]-J[24]+J[25]-J[26]-J[27]-J[28]+J[29]-J[30]+J[31]-J[32]+J[33]-J[34]-J[35]-J[36]+
    J[37]-J[38]+J[39]-J[40]+J[41]+J[42]+J[43]-J[44]-J[45]+J[46]-J[47]-J[48]-J[49]+J[50]-J[51]+J[52]+J[53]+
    J[54]-J[55]-J[56]-J[57]-J[58]+J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]+H[1]-H[2]-H[3]+H[4]-H[5]+
    H[6]-H[7]+H[8]+H[9]-H[10]+H[11]+J[0]-J[1]-J[2]+J[3]-J[4]+J[5]-J[6]+J[7]+J[8]-J[9]+J[10]-J[11]-J[12]+
    J[13]-J[14]+J[15]-J[16]+J[17]+J[18]-J[19]+J[20]+J[21]-J[22]+J[23]-J[24]+J[25]-J[26]-J[27]+J[28]-J[29]-J[30]+
    J[31]-J[32]+J[33]-J[34]-J[35]+J[36]-J[37]-J[38]+J[39]-J[40]+J[41]+J[42]-J[43]+J[44]-J[45]+J[46]-J[47]-J[48]+
    J[49]-J[50]-J[51]+J[52]+J[53]-J[54]+J[55]-J[56]-J[57]+J[58]-J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +
    H[0]+H[1]-H[2]-H[3]+H[4]-H[5]+H[6]-H[7]+H[8]+H[9]-H[10]-H[11]+J[0]-J[1]-J[2]+J[3]-J[4]+J[5]-J[6]+J[7]+
    J[8]-J[9]-J[10]-J[11]-J[12]+J[13]-J[14]+J[15]-J[16]+J[17]+J[18]-J[19]-J[20]+J[21]-J[22]+J[23]-J[24]+
    J[25]-J[26]-J[27]+J[28]+J[29]-J[30]+J[31]-J[32]+J[33]-J[34]-J[35]+J[36]+J[37]-J[38]+J[39]-J[40]+J[41]+
    J[42]-J[43]-J[44]-J[45]+J[46]-J[47]-J[48]+J[49]+J[50]-J[51]+J[52]+J[53]-J[54]-J[55]-J[56]-J[57]+J[58]+
    J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]+H[1]-H[2]-H[3]+H[4]-H[5]+H[6]-H[7]+H[8]-H[9]+H[10]+
    H[11]+J[0]-J[1]-J[2]+J[3]-J[4]+J[5]-J[6]+J[7]-J[8]+J[9]+J[10]-J[11]-J[12]+J[13]-J[14]+J[15]-J[16]+J[17]-J[18]+
    J[19]+J[20]+J[21]-J[22]+J[23]-J[24]+J[25]-J[26]+J[27]-J[28]-J[29]-J[30]+J[31]-J[32]+J[33]-J[34]+J[35]-J[36]-J[37]-J[38]+
    J[39]-J[40]+J[41]-J[42]+J[43]+J[44]-J[45]+J[46]-J[47]+J[48]-J[49]-J[50]-J[51]+J[52]-J[53]+J[54]+J[55]-J[56]+
    J[57]-J[58]-J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]+H[1]-H[2]-H[3]+H[4]-H[5]+H[6]-H[7]+H[8]-H[9]+
    H[10]-H[11]+J[0]-J[1]-J[2]+J[3]-J[4]+J[5]-J[6]+J[7]-J[8]+J[9]-J[10]-J[11]-J[12]+J[13]-J[14]+J[15]-J[16]+
    J[17]-J[18]+J[19]-J[20]+J[21]-J[22]+J[23]-J[24]+J[25]-J[26]+J[27]-J[28]+J[29]-J[30]+J[31]-J[32]+J[33]-J[34]+
    J[35]-J[36]+J[37]-J[38]+J[39]-J[40]+J[41]-J[42]+J[43]-J[44]-J[45]+J[46]-J[47]+J[48]-J[49]+J[50]-J[51]+
    J[52]-J[53]+J[54]-J[55]-J[56]+J[57]-J[58]+J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]+H[1]-H[2]-H[3]+
    H[4]-H[5]+H[6]-H[7]+H[8]-H[9]-H[10]+H[11]+J[0]-J[1]-J[2]+J[3]-J[4]+J[5]-J[6]+J[7]-J[8]-J[9]+J[10]-J[11]-J[12]+
    J[13]-J[14]+J[15]-J[16]+J[17]-J[18]-J[19]+J[20]+J[21]-J[22]+J[23]-J[24]+J[25]-J[26]+J[27]+J[28]-J[29]-J[30]+
    J[31]-J[32]+J[33]-J[34]+J[35]+J[36]-J[37]-J[38]+J[39]-J[40]+J[41]-J[42]-J[43]+J[44]-J[45]+J[46]-J[47]+
    J[48]+J[49]-J[50]-J[51]+J[52]-J[53]-J[54]+J[55]-J[56]+J[57]+J[58]-J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +
    H[0]+H[1]-H[2]-H[3]+H[4]-H[5]+H[6]-H[7]+H[8]-H[9]-H[10]-H[11]+J[0]-J[1]-J[2]+J[3]-J[4]+J[5]-J[6]+J[7]-J[8]-J[9]-J[10]-J[11]-J[12]+
    J[13]-J[14]+J[15]-J[16]+J[17]-J[18]-J[19]-J[20]+J[21]-J[22]+J[23]-J[24]+J[25]-J[26]+J[27]+J[28]+J[29]-J[30]+
    J[31]-J[32]+J[33]-J[34]+J[35]+J[36]+J[37]-J[38]+J[39]-J[40]+J[41]-J[42]-J[43]-J[44]-J[45]+J[46]-J[47]+
    J[48]+J[49]+J[50]-J[51]+J[52]-J[53]-J[54]-J[55]-J[56]+J[57]+J[58]+J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+
    J[65], +H[0]+H[1]-H[2]-H[3]+H[4]-H[5]+H[6]-H[7]-H[8]+H[9]+H[10]+H[11]+J[0]-J[1]-J[2]+J[3]-J[4]+J[5]-J[6]-J[7]+
    J[8]+J[9]+J[10]-J[11]-J[12]+J[13]-J[14]+J[15]-J[16]-J[17]+J[18]+J[19]+J[20]+J[21]-J[22]+J[23]-J[24]+
    J[25]+J[26]-J[27]-J[28]-J[29]-J[30]+J[31]-J[32]+J[33]+J[34]-J[35]-J[36]-J[37]-J[38]+J[39]-J[40]-J[41]+
    J[42]+J[43]+J[44]-J[45]+J[46]+J[47]-J[48]-J[49]-J[50]-J[51]-J[52]+J[53]+J[54]+J[55]+J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+
    J[63]+J[64]+J[65], +H[0]+H[1]-H[2]-H[3]+H[4]-H[5]+H[6]-H[7]-H[8]+H[9]+H[10]-H[11]+J[0]-J[1]-J[2]+J[3]-J[4]+
    J[5]-J[6]-J[7]+J[8]+J[9]-J[10]-J[11]-J[12]+J[13]-J[14]+J[15]-J[16]-J[17]+J[18]+J[19]-J[20]+J[21]-J[22]+
    J[23]-J[24]+J[25]+J[26]-J[27]-J[28]+J[29]-J[30]+J[31]-J[32]+J[33]+J[34]-J[35]-J[36]+J[37]-J[38]+J[39]-J[40]-J[41]+
    J[42]+J[43]-J[44]-J[45]+J[46]+J[47]-J[48]-J[49]+J[50]-J[51]-J[52]+J[53]+J[54]-J[55]+J[56]-J[57]-J[58]+
    J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]+H[1]-H[2]-H[3]+H[4]-H[5]+H[6]-H[7]-H[8]+H[9]-H[10]+
    H[11]+J[0]-J[1]-J[2]+J[3]-J[4]+J[5]-J[6]-J[7]+J[8]-J[9]+J[10]-J[11]-J[12]+J[13]-J[14]+J[15]-J[16]-J[17]+
    J[18]-J[19]+J[20]+J[21]-J[22]+J[23]-J[24]+J[25]+J[26]-J[27]+J[28]-J[29]-J[30]+J[31]-J[32]+J[33]+J[34]-J[35]+
    J[36]-J[37]-J[38]+J[39]-J[40]-J[41]+J[42]-J[43]+J[44]-J[45]+J[46]+J[47]-J[48]+J[49]-J[50]-J[51]-J[52]+
    J[53]-J[54]+J[55]+J[56]-J[57]+J[58]-J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]+H[1]-H[2]-H[3]+
    H[4]-H[5]+H[6]-H[7]-H[8]+H[9]-H[10]-H[11]+J[0]-J[1]-J[2]+J[3]-J[4]+J[5]-J[6]-J[7]+J[8]-J[9]-J[10]-J[11]-J[12]+
    J[13]-J[14]+J[15]-J[16]-J[17]+J[18]-J[19]-J[20]+J[21]-J[22]+J[23]-J[24]+J[25]+J[26]-J[27]+J[28]+J[29]-J[30]+
    J[31]-J[32]+J[33]+J[34]-J[35]+J[36]+J[37]-J[38]+J[39]-J[40]-J[41]+J[42]-J[43]-J[44]-J[45]+J[46]+J[47]-J[48]+
    J[49]+J[50]-J[51]-J[52]+J[53]-J[54]-J[55]+J[56]-J[57]+J[58]+J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +
    H[0]+H[1]-H[2]-H[3]+H[4]-H[5]+H[6]-H[7]-H[8]-H[9]+H[10]+H[11]+J[0]-J[1]-J[2]+J[3]-J[4]+J[5]-J[6]-J[7]-J[8]+
    J[9]+J[10]-J[11]-J[12]+J[13]-J[14]+J[15]-J[16]-J[17]-J[18]+J[19]+J[20]+J[21]-J[22]+J[23]-J[24]+J[25]+
    J[26]+J[27]-J[28]-J[29]-J[30]+J[31]-J[32]+J[33]+J[34]+J[35]-J[36]-J[37]-J[38]+J[39]-J[40]-J[41]-J[42]+
    J[43]+J[44]-J[45]+J[46]+J[47]+J[48]-J[49]-J[50]-J[51]-J[52]-J[53]+J[54]+J[55]+J[56]+J[57]-J[58]-J[59]+
    J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]+H[1]-H[2]-H[3]+H[4]-H[5]+H[6]-H[7]-H[8]-H[9]+H[10]-H[11]+
    J[0]-J[1]-J[2]+J[3]-J[4]+J[5]-J[6]-J[7]-J[8]+J[9]-J[10]-J[11]-J[12]+J[13]-J[14]+J[15]-J[16]-J[17]-J[18]+
    J[19]-J[20]+J[21]-J[22]+J[23]-J[24]+J[25]+J[26]+J[27]-J[28]+J[29]-J[30]+J[31]-J[32]+J[33]+J[34]+J[35]-J[36]+
    J[37]-J[38]+J[39]-J[40]-J[41]-J[42]+J[43]-J[44]-J[45]+J[46]+J[47]+J[48]-J[49]+J[50]-J[51]-J[52]-J[53]+
    J[54]-J[55]+J[56]+J[57]-J[58]+J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]+H[1]-H[2]-H[3]+H[4]-H[5]+
    H[6]-H[7]-H[8]-H[9]-H[10]+H[11]+J[0]-J[1]-J[2]+J[3]-J[4]+J[5]-J[6]-J[7]-J[8]-J[9]+J[10]-J[11]-J[12]+
    J[13]-J[14]+J[15]-J[16]-J[17]-J[18]-J[19]+J[20]+J[21]-J[22]+J[23]-J[24]+J[25]+J[26]+J[27]+J[28]-J[29]-J[30]+
    J[31]-J[32]+J[33]+J[34]+J[35]+J[36]-J[37]-J[38]+J[39]-J[40]-J[41]-J[42]-J[43]+J[44]-J[45]+J[46]+J[47]+
    J[48]+J[49]-J[50]-J[51]-J[52]-J[53]-J[54]+J[55]+J[56]+J[57]+J[58]-J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +
    H[0]+H[1]-H[2]-H[3]+H[4]-H[5]+H[6]-H[7]-H[8]-H[9]-H[10]-H[11]+J[0]-J[1]-J[2]+J[3]-J[4]+J[5]-J[6]-J[7]-J[8]-J[9]-J[10]-J[11]-J[12]+
    J[13]-J[14]+J[15]-J[16]-J[17]-J[18]-J[19]-J[20]+J[21]-J[22]+J[23]-J[24]+J[25]+J[26]+J[27]+J[28]+J[29]-J[30]+
    J[31]-J[32]+J[33]+J[34]+J[35]+J[36]+J[37]-J[38]+J[39]-J[40]-J[41]-J[42]-J[43]-J[44]-J[45]+J[46]+J[47]+
    J[48]+J[49]+J[50]-J[51]-J[52]-J[53]-J[54]-J[55]+J[56]+J[57]+J[58]+J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+
    J[65], +H[0]+H[1]-H[2]-H[3]+H[4]-H[5]-H[6]+H[7]+H[8]+H[9]+H[10]+H[11]+J[0]-J[1]-J[2]+J[3]-J[4]-J[5]+
    J[6]+J[7]+J[8]+J[9]+J[10]-J[11]-J[12]+J[13]-J[14]-J[15]+J[16]+J[17]+J[18]+J[19]+J[20]+J[21]-J[22]+J[23]+
    J[24]-J[25]-J[26]-J[27]-J[28]-J[29]-J[30]+J[31]+J[32]-J[33]-J[34]-J[35]-J[36]-J[37]-J[38]-J[39]+J[40]+
    J[41]+J[42]+J[43]+J[44]+J[45]-J[46]-J[47]-J[48]-J[49]-J[50]-J[51]-J[52]-J[53]-J[54]-J[55]+J[56]+J[57]+
    J[58]+J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]+H[1]-H[2]-H[3]+H[4]-H[5]-H[6]+H[7]+H[8]+H[9]+
    H[10]-H[11]+J[0]-J[1]-J[2]+J[3]-J[4]-J[5]+J[6]+J[7]+J[8]+J[9]-J[10]-J[11]-J[12]+J[13]-J[14]-J[15]+J[16]+
    J[17]+J[18]+J[19]-J[20]+J[21]-J[22]+J[23]+J[24]-J[25]-J[26]-J[27]-J[28]+J[29]-J[30]+J[31]+J[32]-J[33]-J[34]-J[35]-J[36]+
    J[37]-J[38]-J[39]+J[40]+J[41]+J[42]+J[43]-J[44]+J[45]-J[46]-J[47]-J[48]-J[49]+J[50]-J[51]-J[52]-J[53]-J[54]+
    J[55]+J[56]+J[57]+J[58]-J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]+H[1]-H[2]-H[3]+H[4]-H[5]-H[6]+
    H[7]+H[8]+H[9]-H[10]+H[11]+J[0]-J[1]-J[2]+J[3]-J[4]-J[5]+J[6]+J[7]+J[8]-J[9]+J[10]-J[11]-J[12]+J[13]-J[14]-J[15]+
    J[16]+J[17]+J[18]-J[19]+J[20]+J[21]-J[22]+J[23]+J[24]-J[25]-J[26]-J[27]+J[28]-J[29]-J[30]+J[31]+J[32]-J[33]-J[34]-J[35]+
    J[36]-J[37]-J[38]-J[39]+J[40]+J[41]+J[42]-J[43]+J[44]+J[45]-J[46]-J[47]-J[48]+J[49]-J[50]-J[51]-J[52]-J[53]+
    J[54]-J[55]+J[56]+J[57]-J[58]+J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]+H[1]-H[2]-H[3]+H[4]-H[5]-H[6]+
    H[7]+H[8]+H[9]-H[10]-H[11]+J[0]-J[1]-J[2]+J[3]-J[4]-J[5]+J[6]+J[7]+J[8]-J[9]-J[10]-J[11]-J[12]+J[13]-J[14]-J[15]+
    J[16]+J[17]+J[18]-J[19]-J[20]+J[21]-J[22]+J[23]+J[24]-J[25]-J[26]-J[27]+J[28]+J[29]-J[30]+J[31]+J[32]-J[33]-J[34]-J[35]+
    J[36]+J[37]-J[38]-J[39]+J[40]+J[41]+J[42]-J[43]-J[44]+J[45]-J[46]-J[47]-J[48]+J[49]+J[50]-J[51]-J[52]-J[53]+
    J[54]+J[55]+J[56]+J[57]-J[58]-J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]+H[1]-H[2]-H[3]+H[4]-H[5]-H[6]+
    H[7]+H[8]-H[9]+H[10]+H[11]+J[0]-J[1]-J[2]+J[3]-J[4]-J[5]+J[6]+J[7]-J[8]+J[9]+J[10]-J[11]-J[12]+J[13]-J[14]-J[15]+
    J[16]+J[17]-J[18]+J[19]+J[20]+J[21]-J[22]+J[23]+J[24]-J[25]-J[26]+J[27]-J[28]-J[29]-J[30]+J[31]+J[32]-J[33]-J[34]+
    J[35]-J[36]-J[37]-J[38]-J[39]+J[40]+J[41]-J[42]+J[43]+J[44]+J[45]-J[46]-J[47]+J[48]-J[49]-J[50]-J[51]-J[52]+
    J[53]-J[54]-J[55]+J[56]-J[57]+J[58]+J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]+H[1]-H[2]-H[3]+
    H[4]-H[5]-H[6]+H[7]+H[8]-H[9]+H[10]-H[11]+J[0]-J[1]-J[2]+J[3]-J[4]-J[5]+J[6]+J[7]-J[8]+J[9]-J[10]-J[11]-J[12]+
    J[13]-J[14]-J[15]+J[16]+J[17]-J[18]+J[19]-J[20]+J[21]-J[22]+J[23]+J[24]-J[25]-J[26]+J[27]-J[28]+J[29]-J[30]+
    J[31]+J[32]-J[33]-J[34]+J[35]-J[36]+J[37]-J[38]-J[39]+J[40]+J[41]-J[42]+J[43]-J[44]+J[45]-J[46]-J[47]+
    J[48]-J[49]+J[50]-J[51]-J[52]+J[53]-J[54]+J[55]+J[56]-J[57]+J[58]-J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +
    H[0]+H[1]-H[2]-H[3]+H[4]-H[5]-H[6]+H[7]+H[8]-H[9]-H[10]+H[11]+J[0]-J[1]-J[2]+J[3]-J[4]-J[5]+J[6]+J[7]-J[8]-J[9]+
    J[10]-J[11]-J[12]+J[13]-J[14]-J[15]+J[16]+J[17]-J[18]-J[19]+J[20]+J[21]-J[22]+J[23]+J[24]-J[25]-J[26]+
    J[27]+J[28]-J[29]-J[30]+J[31]+J[32]-J[33]-J[34]+J[35]+J[36]-J[37]-J[38]-J[39]+J[40]+J[41]-J[42]-J[43]+
    J[44]+J[45]-J[46]-J[47]+J[48]+J[49]-J[50]-J[51]-J[52]+J[53]+J[54]-J[55]+J[56]-J[57]-J[58]+J[59]-J[60]-J[61]+
    J[62]+J[63]-J[64]-J[65], +H[0]+H[1]-H[2]-H[3]+H[4]-H[5]-H[6]+H[7]+H[8]-H[9]-H[10]-H[11]+J[0]-J[1]-J[2]+
    J[3]-J[4]-J[5]+J[6]+J[7]-J[8]-J[9]-J[10]-J[11]-J[12]+J[13]-J[14]-J[15]+J[16]+J[17]-J[18]-J[19]-J[20]+
    J[21]-J[22]+J[23]+J[24]-J[25]-J[26]+J[27]+J[28]+J[29]-J[30]+J[31]+J[32]-J[33]-J[34]+J[35]+J[36]+J[37]-J[38]-J[39]+
    J[40]+J[41]-J[42]-J[43]-J[44]+J[45]-J[46]-J[47]+J[48]+J[49]+J[50]-J[51]-J[52]+J[53]+J[54]+J[55]+J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+
    J[63]+J[64]+J[65], +H[0]+H[1]-H[2]-H[3]+H[4]-H[5]-H[6]+H[7]-H[8]+H[9]+H[10]+H[11]+J[0]-J[1]-J[2]+J[3]-J[4]-J[5]+
    J[6]-J[7]+J[8]+J[9]+J[10]-J[11]-J[12]+J[13]-J[14]-J[15]+J[16]-J[17]+J[18]+J[19]+J[20]+J[21]-J[22]+J[23]+
    J[24]-J[25]+J[26]-J[27]-J[28]-J[29]-J[30]+J[31]+J[32]-J[33]+J[34]-J[35]-J[36]-J[37]-J[38]-J[39]+J[40]-J[41]+
    J[42]+J[43]+J[44]+J[45]-J[46]+J[47]-J[48]-J[49]-J[50]-J[51]+J[52]-J[53]-J[54]-J[55]-J[56]+J[57]+J[58]+
    J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]+H[1]-H[2]-H[3]+H[4]-H[5]-H[6]+H[7]-H[8]+H[9]+H[10]-H[11]+
    J[0]-J[1]-J[2]+J[3]-J[4]-J[5]+J[6]-J[7]+J[8]+J[9]-J[10]-J[11]-J[12]+J[13]-J[14]-J[15]+J[16]-J[17]+J[18]+
    J[19]-J[20]+J[21]-J[22]+J[23]+J[24]-J[25]+J[26]-J[27]-J[28]+J[29]-J[30]+J[31]+J[32]-J[33]+J[34]-J[35]-J[36]+
    J[37]-J[38]-J[39]+J[40]-J[41]+J[42]+J[43]-J[44]+J[45]-J[46]+J[47]-J[48]-J[49]+J[50]-J[51]+J[52]-J[53]-J[54]+
    J[55]-J[56]+J[57]+J[58]-J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]+H[1]-H[2]-H[3]+H[4]-H[5]-H[6]+
    H[7]-H[8]+H[9]-H[10]+H[11]+J[0]-J[1]-J[2]+J[3]-J[4]-J[5]+J[6]-J[7]+J[8]-J[9]+J[10]-J[11]-J[12]+J[13]-J[14]-J[15]+
    J[16]-J[17]+J[18]-J[19]+J[20]+J[21]-J[22]+J[23]+J[24]-J[25]+J[26]-J[27]+J[28]-J[29]-J[30]+J[31]+J[32]-J[33]+
    J[34]-J[35]+J[36]-J[37]-J[38]-J[39]+J[40]-J[41]+J[42]-J[43]+J[44]+J[45]-J[46]+J[47]-J[48]+J[49]-J[50]-J[51]+
    J[52]-J[53]+J[54]-J[55]-J[56]+J[57]-J[58]+J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]+H[1]-H[2]-H[3]+
    H[4]-H[5]-H[6]+H[7]-H[8]+H[9]-H[10]-H[11]+J[0]-J[1]-J[2]+J[3]-J[4]-J[5]+J[6]-J[7]+J[8]-J[9]-J[10]-J[11]-J[12]+
    J[13]-J[14]-J[15]+J[16]-J[17]+J[18]-J[19]-J[20]+J[21]-J[22]+J[23]+J[24]-J[25]+J[26]-J[27]+J[28]+J[29]-J[30]+
    J[31]+J[32]-J[33]+J[34]-J[35]+J[36]+J[37]-J[38]-J[39]+J[40]-J[41]+J[42]-J[43]-J[44]+J[45]-J[46]+J[47]-J[48]+
    J[49]+J[50]-J[51]+J[52]-J[53]+J[54]+J[55]-J[56]+J[57]-J[58]-J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +
    H[0]+H[1]-H[2]-H[3]+H[4]-H[5]-H[6]+H[7]-H[8]-H[9]+H[10]+H[11]+J[0]-J[1]-J[2]+J[3]-J[4]-J[5]+J[6]-J[7]-J[8]+
    J[9]+J[10]-J[11]-J[12]+J[13]-J[14]-J[15]+J[16]-J[17]-J[18]+J[19]+J[20]+J[21]-J[22]+J[23]+J[24]-J[25]+
    J[26]+J[27]-J[28]-J[29]-J[30]+J[31]+J[32]-J[33]+J[34]+J[35]-J[36]-J[37]-J[38]-J[39]+J[40]-J[41]-J[42]+
    J[43]+J[44]+J[45]-J[46]+J[47]+J[48]-J[49]-J[50]-J[51]+J[52]+J[53]-J[54]-J[55]-J[56]-J[57]+J[58]+J[59]+
    J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]+H[1]-H[2]-H[3]+H[4]-H[5]-H[6]+H[7]-H[8]-H[9]+H[10]-H[11]+
    J[0]-J[1]-J[2]+J[3]-J[4]-J[5]+J[6]-J[7]-J[8]+J[9]-J[10]-J[11]-J[12]+J[13]-J[14]-J[15]+J[16]-J[17]-J[18]+
    J[19]-J[20]+J[21]-J[22]+J[23]+J[24]-J[25]+J[26]+J[27]-J[28]+J[29]-J[30]+J[31]+J[32]-J[33]+J[34]+J[35]-J[36]+
    J[37]-J[38]-J[39]+J[40]-J[41]-J[42]+J[43]-J[44]+J[45]-J[46]+J[47]+J[48]-J[49]+J[50]-J[51]+J[52]+J[53]-J[54]+
    J[55]-J[56]-J[57]+J[58]-J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]+H[1]-H[2]-H[3]+H[4]-H[5]-H[6]+
    H[7]-H[8]-H[9]-H[10]+H[11]+J[0]-J[1]-J[2]+J[3]-J[4]-J[5]+J[6]-J[7]-J[8]-J[9]+J[10]-J[11]-J[12]+J[13]-J[14]-J[15]+
    J[16]-J[17]-J[18]-J[19]+J[20]+J[21]-J[22]+J[23]+J[24]-J[25]+J[26]+J[27]+J[28]-J[29]-J[30]+J[31]+J[32]-J[33]+
    J[34]+J[35]+J[36]-J[37]-J[38]-J[39]+J[40]-J[41]-J[42]-J[43]+J[44]+J[45]-J[46]+J[47]+J[48]+J[49]-J[50]-J[51]+
    J[52]+J[53]+J[54]-J[55]-J[56]-J[57]-J[58]+J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]+H[1]-H[2]-H[3]+
    H[4]-H[5]-H[6]+H[7]-H[8]-H[9]-H[10]-H[11]+J[0]-J[1]-J[2]+J[3]-J[4]-J[5]+J[6]-J[7]-J[8]-J[9]-J[10]-J[11]-J[12]+
    J[13]-J[14]-J[15]+J[16]-J[17]-J[18]-J[19]-J[20]+J[21]-J[22]+J[23]+J[24]-J[25]+J[26]+J[27]+J[28]+J[29]-J[30]+
    J[31]+J[32]-J[33]+J[34]+J[35]+J[36]+J[37]-J[38]-J[39]+J[40]-J[41]-J[42]-J[43]-J[44]+J[45]-J[46]+J[47]+
    J[48]+J[49]+J[50]-J[51]+J[52]+J[53]+J[54]+J[55]-J[56]-J[57]-J[58]-J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+
    J[65], +H[0]+H[1]-H[2]-H[3]+H[4]-H[5]-H[6]-H[7]+H[8]+H[9]+H[10]+H[11]+J[0]-J[1]-J[2]+J[3]-J[4]-J[5]-J[6]+
    J[7]+J[8]+J[9]+J[10]-J[11]-J[12]+J[13]-J[14]-J[15]-J[16]+J[17]+J[18]+J[19]+J[20]+J[21]-J[22]+J[23]+J[24]+
    J[25]-J[26]-J[27]-J[28]-J[29]-J[30]+J[31]+J[32]+J[33]-J[34]-J[35]-J[36]-J[37]-J[38]-J[39]-J[40]+J[41]+
    J[42]+J[43]+J[44]+J[45]+J[46]-J[47]-J[48]-J[49]-J[50]+J[51]-J[52]-J[53]-J[54]-J[55]-J[56]-J[57]-J[58]-J[59]+
    J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]+H[1]-H[2]-H[3]+H[4]-H[5]-H[6]-H[7]+H[8]+H[9]+H[10]-H[11]+
    J[0]-J[1]-J[2]+J[3]-J[4]-J[5]-J[6]+J[7]+J[8]+J[9]-J[10]-J[11]-J[12]+J[13]-J[14]-J[15]-J[16]+J[17]+J[18]+
    J[19]-J[20]+J[21]-J[22]+J[23]+J[24]+J[25]-J[26]-J[27]-J[28]+J[29]-J[30]+J[31]+J[32]+J[33]-J[34]-J[35]-J[36]+
    J[37]-J[38]-J[39]-J[40]+J[41]+J[42]+J[43]-J[44]+J[45]+J[46]-J[47]-J[48]-J[49]+J[50]+J[51]-J[52]-J[53]-J[54]+
    J[55]-J[56]-J[57]-J[58]+J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]+H[1]-H[2]-H[3]+H[4]-H[5]-H[6]-H[7]+
    H[8]+H[9]-H[10]+H[11]+J[0]-J[1]-J[2]+J[3]-J[4]-J[5]-J[6]+J[7]+J[8]-J[9]+J[10]-J[11]-J[12]+J[13]-J[14]-J[15]-J[16]+
    J[17]+J[18]-J[19]+J[20]+J[21]-J[22]+J[23]+J[24]+J[25]-J[26]-J[27]+J[28]-J[29]-J[30]+J[31]+J[32]+J[33]-J[34]-J[35]+
    J[36]-J[37]-J[38]-J[39]-J[40]+J[41]+J[42]-J[43]+J[44]+J[45]+J[46]-J[47]-J[48]+J[49]-J[50]+J[51]-J[52]-J[53]+
    J[54]-J[55]-J[56]-J[57]+J[58]-J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]+H[1]-H[2]-H[3]+H[4]-H[5]-H[6]-H[7]+
    H[8]+H[9]-H[10]-H[11]+J[0]-J[1]-J[2]+J[3]-J[4]-J[5]-J[6]+J[7]+J[8]-J[9]-J[10]-J[11]-J[12]+J[13]-J[14]-J[15]-J[16]+
    J[17]+J[18]-J[19]-J[20]+J[21]-J[22]+J[23]+J[24]+J[25]-J[26]-J[27]+J[28]+J[29]-J[30]+J[31]+J[32]+J[33]-J[34]-J[35]+
    J[36]+J[37]-J[38]-J[39]-J[40]+J[41]+J[42]-J[43]-J[44]+J[45]+J[46]-J[47]-J[48]+J[49]+J[50]+J[51]-J[52]-J[53]+
    J[54]+J[55]-J[56]-J[57]+J[58]+J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]+H[1]-H[2]-H[3]+H[4]-H[5]-H[6]-H[7]+
    H[8]-H[9]+H[10]+H[11]+J[0]-J[1]-J[2]+J[3]-J[4]-J[5]-J[6]+J[7]-J[8]+J[9]+J[10]-J[11]-J[12]+J[13]-J[14]-J[15]-J[16]+
    J[17]-J[18]+J[19]+J[20]+J[21]-J[22]+J[23]+J[24]+J[25]-J[26]+J[27]-J[28]-J[29]-J[30]+J[31]+J[32]+J[33]-J[34]+
    J[35]-J[36]-J[37]-J[38]-J[39]-J[40]+J[41]-J[42]+J[43]+J[44]+J[45]+J[46]-J[47]+J[48]-J[49]-J[50]+J[51]-J[52]+
    J[53]-J[54]-J[55]-J[56]+J[57]-J[58]-J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]+H[1]-H[2]-H[3]+
    H[4]-H[5]-H[6]-H[7]+H[8]-H[9]+H[10]-H[11]+J[0]-J[1]-J[2]+J[3]-J[4]-J[5]-J[6]+J[7]-J[8]+J[9]-J[10]-J[11]-J[12]+
    J[13]-J[14]-J[15]-J[16]+J[17]-J[18]+J[19]-J[20]+J[21]-J[22]+J[23]+J[24]+J[25]-J[26]+J[27]-J[28]+J[29]-J[30]+
    J[31]+J[32]+J[33]-J[34]+J[35]-J[36]+J[37]-J[38]-J[39]-J[40]+J[41]-J[42]+J[43]-J[44]+J[45]+J[46]-J[47]+
    J[48]-J[49]+J[50]+J[51]-J[52]+J[53]-J[54]+J[55]-J[56]+J[57]-J[58]+J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +
    H[0]+H[1]-H[2]-H[3]+H[4]-H[5]-H[6]-H[7]+H[8]-H[9]-H[10]+H[11]+J[0]-J[1]-J[2]+J[3]-J[4]-J[5]-J[6]+J[7]-J[8]-J[9]+
    J[10]-J[11]-J[12]+J[13]-J[14]-J[15]-J[16]+J[17]-J[18]-J[19]+J[20]+J[21]-J[22]+J[23]+J[24]+J[25]-J[26]+
    J[27]+J[28]-J[29]-J[30]+J[31]+J[32]+J[33]-J[34]+J[35]+J[36]-J[37]-J[38]-J[39]-J[40]+J[41]-J[42]-J[43]+
    J[44]+J[45]+J[46]-J[47]+J[48]+J[49]-J[50]+J[51]-J[52]+J[53]+J[54]-J[55]-J[56]+J[57]+J[58]-J[59]-J[60]-J[61]+
    J[62]+J[63]-J[64]-J[65], +H[0]+H[1]-H[2]-H[3]+H[4]-H[5]-H[6]-H[7]+H[8]-H[9]-H[10]-H[11]+J[0]-J[1]-J[2]+
    J[3]-J[4]-J[5]-J[6]+J[7]-J[8]-J[9]-J[10]-J[11]-J[12]+J[13]-J[14]-J[15]-J[16]+J[17]-J[18]-J[19]-J[20]+
    J[21]-J[22]+J[23]+J[24]+J[25]-J[26]+J[27]+J[28]+J[29]-J[30]+J[31]+J[32]+J[33]-J[34]+J[35]+J[36]+J[37]-J[38]-J[39]-J[40]+
    J[41]-J[42]-J[43]-J[44]+J[45]+J[46]-J[47]+J[48]+J[49]+J[50]+J[51]-J[52]+J[53]+J[54]+J[55]-J[56]+J[57]+
    J[58]+J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]+H[1]-H[2]-H[3]+H[4]-H[5]-H[6]-H[7]-H[8]+H[9]+
    H[10]+H[11]+J[0]-J[1]-J[2]+J[3]-J[4]-J[5]-J[6]-J[7]+J[8]+J[9]+J[10]-J[11]-J[12]+J[13]-J[14]-J[15]-J[16]-J[17]+
    J[18]+J[19]+J[20]+J[21]-J[22]+J[23]+J[24]+J[25]+J[26]-J[27]-J[28]-J[29]-J[30]+J[31]+J[32]+J[33]+J[34]-J[35]-J[36]-J[37]-J[38]-J[39]-J[40]-J[41]+
    J[42]+J[43]+J[44]+J[45]+J[46]+J[47]-J[48]-J[49]-J[50]+J[51]+J[52]-J[53]-J[54]-J[55]+J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+
    J[63]+J[64]+J[65], +H[0]+H[1]-H[2]-H[3]+H[4]-H[5]-H[6]-H[7]-H[8]+H[9]+H[10]-H[11]+J[0]-J[1]-J[2]+J[3]-J[4]-J[5]-J[6]-J[7]+
    J[8]+J[9]-J[10]-J[11]-J[12]+J[13]-J[14]-J[15]-J[16]-J[17]+J[18]+J[19]-J[20]+J[21]-J[22]+J[23]+J[24]+
    J[25]+J[26]-J[27]-J[28]+J[29]-J[30]+J[31]+J[32]+J[33]+J[34]-J[35]-J[36]+J[37]-J[38]-J[39]-J[40]-J[41]+
    J[42]+J[43]-J[44]+J[45]+J[46]+J[47]-J[48]-J[49]+J[50]+J[51]+J[52]-J[53]-J[54]+J[55]+J[56]-J[57]-J[58]+
    J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]+H[1]-H[2]-H[3]+H[4]-H[5]-H[6]-H[7]-H[8]+H[9]-H[10]+
    H[11]+J[0]-J[1]-J[2]+J[3]-J[4]-J[5]-J[6]-J[7]+J[8]-J[9]+J[10]-J[11]-J[12]+J[13]-J[14]-J[15]-J[16]-J[17]+
    J[18]-J[19]+J[20]+J[21]-J[22]+J[23]+J[24]+J[25]+J[26]-J[27]+J[28]-J[29]-J[30]+J[31]+J[32]+J[33]+J[34]-J[35]+
    J[36]-J[37]-J[38]-J[39]-J[40]-J[41]+J[42]-J[43]+J[44]+J[45]+J[46]+J[47]-J[48]+J[49]-J[50]+J[51]+J[52]-J[53]+
    J[54]-J[55]+J[56]-J[57]+J[58]-J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]+H[1]-H[2]-H[3]+H[4]-H[5]-H[6]-H[7]-H[8]+
    H[9]-H[10]-H[11]+J[0]-J[1]-J[2]+J[3]-J[4]-J[5]-J[6]-J[7]+J[8]-J[9]-J[10]-J[11]-J[12]+J[13]-J[14]-J[15]-J[16]-J[17]+
    J[18]-J[19]-J[20]+J[21]-J[22]+J[23]+J[24]+J[25]+J[26]-J[27]+J[28]+J[29]-J[30]+J[31]+J[32]+J[33]+J[34]-J[35]+
    J[36]+J[37]-J[38]-J[39]-J[40]-J[41]+J[42]-J[43]-J[44]+J[45]+J[46]+J[47]-J[48]+J[49]+J[50]+J[51]+J[52]-J[53]+
    J[54]+J[55]+J[56]-J[57]+J[58]+J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]+H[1]-H[2]-H[3]+H[4]-H[5]-H[6]-H[7]-H[8]-H[9]+
    H[10]+H[11]+J[0]-J[1]-J[2]+J[3]-J[4]-J[5]-J[6]-J[7]-J[8]+J[9]+J[10]-J[11]-J[12]+J[13]-J[14]-J[15]-J[16]-J[17]-J[18]+
    J[19]+J[20]+J[21]-J[22]+J[23]+J[24]+J[25]+J[26]+J[27]-J[28]-J[29]-J[30]+J[31]+J[32]+J[33]+J[34]+J[35]-J[36]-J[37]-J[38]-J[39]-J[40]-J[41]-J[42]+
    J[43]+J[44]+J[45]+J[46]+J[47]+J[48]-J[49]-J[50]+J[51]+J[52]+J[53]-J[54]-J[55]+J[56]+J[57]-J[58]-J[59]+
    J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]+H[1]-H[2]-H[3]+H[4]-H[5]-H[6]-H[7]-H[8]-H[9]+H[10]-H[11]+
    J[0]-J[1]-J[2]+J[3]-J[4]-J[5]-J[6]-J[7]-J[8]+J[9]-J[10]-J[11]-J[12]+J[13]-J[14]-J[15]-J[16]-J[17]-J[18]+
    J[19]-J[20]+J[21]-J[22]+J[23]+J[24]+J[25]+J[26]+J[27]-J[28]+J[29]-J[30]+J[31]+J[32]+J[33]+J[34]+J[35]-J[36]+
    J[37]-J[38]-J[39]-J[40]-J[41]-J[42]+J[43]-J[44]+J[45]+J[46]+J[47]+J[48]-J[49]+J[50]+J[51]+J[52]+J[53]-J[54]+
    J[55]+J[56]+J[57]-J[58]+J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]+H[1]-H[2]-H[3]+H[4]-H[5]-H[6]-H[7]-H[8]-H[9]-H[10]+
    H[11]+J[0]-J[1]-J[2]+J[3]-J[4]-J[5]-J[6]-J[7]-J[8]-J[9]+J[10]-J[11]-J[12]+J[13]-J[14]-J[15]-J[16]-J[17]-J[18]-J[19]+
    J[20]+J[21]-J[22]+J[23]+J[24]+J[25]+J[26]+J[27]+J[28]-J[29]-J[30]+J[31]+J[32]+J[33]+J[34]+J[35]+J[36]-J[37]-J[38]-J[39]-J[40]-J[41]-J[42]-J[43]+
    J[44]+J[45]+J[46]+J[47]+J[48]+J[49]-J[50]+J[51]+J[52]+J[53]+J[54]-J[55]+J[56]+J[57]+J[58]-J[59]+J[60]+
    J[61]-J[62]+J[63]-J[64]-J[65], +H[0]+H[1]-H[2]-H[3]+H[4]-H[5]-H[6]-H[7]-H[8]-H[9]-H[10]-H[11]+J[0]-J[1]-J[2]+
    J[3]-J[4]-J[5]-J[6]-J[7]-J[8]-J[9]-J[10]-J[11]-J[12]+J[13]-J[14]-J[15]-J[16]-J[17]-J[18]-J[19]-J[20]+
    J[21]-J[22]+J[23]+J[24]+J[25]+J[26]+J[27]+J[28]+J[29]-J[30]+J[31]+J[32]+J[33]+J[34]+J[35]+J[36]+J[37]-J[38]-J[39]-J[40]-J[41]-J[42]-J[43]-J[44]+
    J[45]+J[46]+J[47]+J[48]+J[49]+J[50]+J[51]+J[52]+J[53]+J[54]+J[55]+J[56]+J[57]+J[58]+J[59]+J[60]+J[61]+
    J[62]+J[63]+J[64]+J[65], +H[0]+H[1]-H[2]-H[3]-H[4]+H[5]+H[6]+H[7]+H[8]+H[9]+H[10]+H[11]+J[0]-J[1]-J[2]-J[3]+
    J[4]+J[5]+J[6]+J[7]+J[8]+J[9]+J[10]-J[11]-J[12]-J[13]+J[14]+J[15]+J[16]+J[17]+J[18]+J[19]+J[20]+J[21]+
    J[22]-J[23]-J[24]-J[25]-J[26]-J[27]-J[28]-J[29]+J[30]-J[31]-J[32]-J[33]-J[34]-J[35]-J[36]-J[37]-J[38]-J[39]-J[40]-J[41]-J[42]-J[43]-J[44]+
    J[45]+J[46]+J[47]+J[48]+J[49]+J[50]+J[51]+J[52]+J[53]+J[54]+J[55]+J[56]+J[57]+J[58]+J[59]+J[60]+J[61]+
    J[62]+J[63]+J[64]+J[65], +H[0]+H[1]-H[2]-H[3]-H[4]+H[5]+H[6]+H[7]+H[8]+H[9]+H[10]-H[11]+J[0]-J[1]-J[2]-J[3]+
    J[4]+J[5]+J[6]+J[7]+J[8]+J[9]-J[10]-J[11]-J[12]-J[13]+J[14]+J[15]+J[16]+J[17]+J[18]+J[19]-J[20]+J[21]+
    J[22]-J[23]-J[24]-J[25]-J[26]-J[27]-J[28]+J[29]+J[30]-J[31]-J[32]-J[33]-J[34]-J[35]-J[36]+J[37]-J[38]-J[39]-J[40]-J[41]-J[42]-J[43]+
    J[44]+J[45]+J[46]+J[47]+J[48]+J[49]-J[50]+J[51]+J[52]+J[53]+J[54]-J[55]+J[56]+J[57]+J[58]-J[59]+J[60]+
    J[61]-J[62]+J[63]-J[64]-J[65], +H[0]+H[1]-H[2]-H[3]-H[4]+H[5]+H[6]+H[7]+H[8]+H[9]-H[10]+H[11]+J[0]-J[1]-J[2]-J[3]+
    J[4]+J[5]+J[6]+J[7]+J[8]-J[9]+J[10]-J[11]-J[12]-J[13]+J[14]+J[15]+J[16]+J[17]+J[18]-J[19]+J[20]+J[21]+
    J[22]-J[23]-J[24]-J[25]-J[26]-J[27]+J[28]-J[29]+J[30]-J[31]-J[32]-J[33]-J[34]-J[35]+J[36]-J[37]-J[38]-J[39]-J[40]-J[41]-J[42]+
    J[43]-J[44]+J[45]+J[46]+J[47]+J[48]-J[49]+J[50]+J[51]+J[52]+J[53]-J[54]+J[55]+J[56]+J[57]-J[58]+J[59]+
    J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]+H[1]-H[2]-H[3]-H[4]+H[5]+H[6]+H[7]+H[8]+H[9]-H[10]-H[11]+
    J[0]-J[1]-J[2]-J[3]+J[4]+J[5]+J[6]+J[7]+J[8]-J[9]-J[10]-J[11]-J[12]-J[13]+J[14]+J[15]+J[16]+J[17]+J[18]-J[19]-J[20]+
    J[21]+J[22]-J[23]-J[24]-J[25]-J[26]-J[27]+J[28]+J[29]+J[30]-J[31]-J[32]-J[33]-J[34]-J[35]+J[36]+J[37]-J[38]-J[39]-J[40]-J[41]-J[42]+
    J[43]+J[44]+J[45]+J[46]+J[47]+J[48]-J[49]-J[50]+J[51]+J[52]+J[53]-J[54]-J[55]+J[56]+J[57]-J[58]-J[59]+
    J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]+H[1]-H[2]-H[3]-H[4]+H[5]+H[6]+H[7]+H[8]-H[9]+H[10]+H[11]+
    J[0]-J[1]-J[2]-J[3]+J[4]+J[5]+J[6]+J[7]-J[8]+J[9]+J[10]-J[11]-J[12]-J[13]+J[14]+J[15]+J[16]+J[17]-J[18]+
    J[19]+J[20]+J[21]+J[22]-J[23]-J[24]-J[25]-J[26]+J[27]-J[28]-J[29]+J[30]-J[31]-J[32]-J[33]-J[34]+J[35]-J[36]-J[37]-J[38]-J[39]-J[40]-J[41]+
    J[42]-J[43]-J[44]+J[45]+J[46]+J[47]-J[48]+J[49]+J[50]+J[51]+J[52]-J[53]+J[54]+J[55]+J[56]-J[57]+J[58]+
    J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]+H[1]-H[2]-H[3]-H[4]+H[5]+H[6]+H[7]+H[8]-H[9]+H[10]-H[11]+
    J[0]-J[1]-J[2]-J[3]+J[4]+J[5]+J[6]+J[7]-J[8]+J[9]-J[10]-J[11]-J[12]-J[13]+J[14]+J[15]+J[16]+J[17]-J[18]+
    J[19]-J[20]+J[21]+J[22]-J[23]-J[24]-J[25]-J[26]+J[27]-J[28]+J[29]+J[30]-J[31]-J[32]-J[33]-J[34]+J[35]-J[36]+
    J[37]-J[38]-J[39]-J[40]-J[41]+J[42]-J[43]+J[44]+J[45]+J[46]+J[47]-J[48]+J[49]-J[50]+J[51]+J[52]-J[53]+
    J[54]-J[55]+J[56]-J[57]+J[58]-J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]+H[1]-H[2]-H[3]-H[4]+H[5]+
    H[6]+H[7]+H[8]-H[9]-H[10]+H[11]+J[0]-J[1]-J[2]-J[3]+J[4]+J[5]+J[6]+J[7]-J[8]-J[9]+J[10]-J[11]-J[12]-J[13]+
    J[14]+J[15]+J[16]+J[17]-J[18]-J[19]+J[20]+J[21]+J[22]-J[23]-J[24]-J[25]-J[26]+J[27]+J[28]-J[29]+J[30]-J[31]-J[32]-J[33]-J[34]+
    J[35]+J[36]-J[37]-J[38]-J[39]-J[40]-J[41]+J[42]+J[43]-J[44]+J[45]+J[46]+J[47]-J[48]-J[49]+J[50]+J[51]+
    J[52]-J[53]-J[54]+J[55]+J[56]-J[57]-J[58]+J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]+H[1]-H[2]-H[3]-H[4]+
    H[5]+H[6]+H[7]+H[8]-H[9]-H[10]-H[11]+J[0]-J[1]-J[2]-J[3]+J[4]+J[5]+J[6]+J[7]-J[8]-J[9]-J[10]-J[11]-J[12]-J[13]+
    J[14]+J[15]+J[16]+J[17]-J[18]-J[19]-J[20]+J[21]+J[22]-J[23]-J[24]-J[25]-J[26]+J[27]+J[28]+J[29]+J[30]-J[31]-J[32]-J[33]-J[34]+
    J[35]+J[36]+J[37]-J[38]-J[39]-J[40]-J[41]+J[42]+J[43]+J[44]+J[45]+J[46]+J[47]-J[48]-J[49]-J[50]+J[51]+
    J[52]-J[53]-J[54]-J[55]+J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]+H[1]-H[2]-H[3]-H[4]+
    H[5]+H[6]+H[7]-H[8]+H[9]+H[10]+H[11]+J[0]-J[1]-J[2]-J[3]+J[4]+J[5]+J[6]-J[7]+J[8]+J[9]+J[10]-J[11]-J[12]-J[13]+
    J[14]+J[15]+J[16]-J[17]+J[18]+J[19]+J[20]+J[21]+J[22]-J[23]-J[24]-J[25]+J[26]-J[27]-J[28]-J[29]+J[30]-J[31]-J[32]-J[33]+
    J[34]-J[35]-J[36]-J[37]-J[38]-J[39]-J[40]+J[41]-J[42]-J[43]-J[44]+J[45]+J[46]-J[47]+J[48]+J[49]+J[50]+
    J[51]-J[52]+J[53]+J[54]+J[55]-J[56]+J[57]+J[58]+J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]+H[1]-H[2]-H[3]-H[4]+
    H[5]+H[6]+H[7]-H[8]+H[9]+H[10]-H[11]+J[0]-J[1]-J[2]-J[3]+J[4]+J[5]+J[6]-J[7]+J[8]+J[9]-J[10]-J[11]-J[12]-J[13]+
    J[14]+J[15]+J[16]-J[17]+J[18]+J[19]-J[20]+J[21]+J[22]-J[23]-J[24]-J[25]+J[26]-J[27]-J[28]+J[29]+J[30]-J[31]-J[32]-J[33]+
    J[34]-J[35]-J[36]+J[37]-J[38]-J[39]-J[40]+J[41]-J[42]-J[43]+J[44]+J[45]+J[46]-J[47]+J[48]+J[49]-J[50]+
    J[51]-J[52]+J[53]+J[54]-J[55]-J[56]+J[57]+J[58]-J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]+H[1]-H[2]-H[3]-H[4]+
    H[5]+H[6]+H[7]-H[8]+H[9]-H[10]+H[11]+J[0]-J[1]-J[2]-J[3]+J[4]+J[5]+J[6]-J[7]+J[8]-J[9]+J[10]-J[11]-J[12]-J[13]+
    J[14]+J[15]+J[16]-J[17]+J[18]-J[19]+J[20]+J[21]+J[22]-J[23]-J[24]-J[25]+J[26]-J[27]+J[28]-J[29]+J[30]-J[31]-J[32]-J[33]+
    J[34]-J[35]+J[36]-J[37]-J[38]-J[39]-J[40]+J[41]-J[42]+J[43]-J[44]+J[45]+J[46]-J[47]+J[48]-J[49]+J[50]+
    J[51]-J[52]+J[53]-J[54]+J[55]-J[56]+J[57]-J[58]+J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]+H[1]-H[2]-H[3]-H[4]+
    H[5]+H[6]+H[7]-H[8]+H[9]-H[10]-H[11]+J[0]-J[1]-J[2]-J[3]+J[4]+J[5]+J[6]-J[7]+J[8]-J[9]-J[10]-J[11]-J[12]-J[13]+
    J[14]+J[15]+J[16]-J[17]+J[18]-J[19]-J[20]+J[21]+J[22]-J[23]-J[24]-J[25]+J[26]-J[27]+J[28]+J[29]+J[30]-J[31]-J[32]-J[33]+
    J[34]-J[35]+J[36]+J[37]-J[38]-J[39]-J[40]+J[41]-J[42]+J[43]+J[44]+J[45]+J[46]-J[47]+J[48]-J[49]-J[50]+
    J[51]-J[52]+J[53]-J[54]-J[55]-J[56]+J[57]-J[58]-J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]+H[1]-H[2]-H[3]-H[4]+
    H[5]+H[6]+H[7]-H[8]-H[9]+H[10]+H[11]+J[0]-J[1]-J[2]-J[3]+J[4]+J[5]+J[6]-J[7]-J[8]+J[9]+J[10]-J[11]-J[12]-J[13]+
    J[14]+J[15]+J[16]-J[17]-J[18]+J[19]+J[20]+J[21]+J[22]-J[23]-J[24]-J[25]+J[26]+J[27]-J[28]-J[29]+J[30]-J[31]-J[32]-J[33]+
    J[34]+J[35]-J[36]-J[37]-J[38]-J[39]-J[40]+J[41]+J[42]-J[43]-J[44]+J[45]+J[46]-J[47]-J[48]+J[49]+J[50]+
    J[51]-J[52]-J[53]+J[54]+J[55]-J[56]-J[57]+J[58]+J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]+H[1]-H[2]-H[3]-H[4]+
    H[5]+H[6]+H[7]-H[8]-H[9]+H[10]-H[11]+J[0]-J[1]-J[2]-J[3]+J[4]+J[5]+J[6]-J[7]-J[8]+J[9]-J[10]-J[11]-J[12]-J[13]+
    J[14]+J[15]+J[16]-J[17]-J[18]+J[19]-J[20]+J[21]+J[22]-J[23]-J[24]-J[25]+J[26]+J[27]-J[28]+J[29]+J[30]-J[31]-J[32]-J[33]+
    J[34]+J[35]-J[36]+J[37]-J[38]-J[39]-J[40]+J[41]+J[42]-J[43]+J[44]+J[45]+J[46]-J[47]-J[48]+J[49]-J[50]+
    J[51]-J[52]-J[53]+J[54]-J[55]-J[56]-J[57]+J[58]-J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]+H[1]-H[2]-H[3]-H[4]+
    H[5]+H[6]+H[7]-H[8]-H[9]-H[10]+H[11]+J[0]-J[1]-J[2]-J[3]+J[4]+J[5]+J[6]-J[7]-J[8]-J[9]+J[10]-J[11]-J[12]-J[13]+
    J[14]+J[15]+J[16]-J[17]-J[18]-J[19]+J[20]+J[21]+J[22]-J[23]-J[24]-J[25]+J[26]+J[27]+J[28]-J[29]+J[30]-J[31]-J[32]-J[33]+
    J[34]+J[35]+J[36]-J[37]-J[38]-J[39]-J[40]+J[41]+J[42]+J[43]-J[44]+J[45]+J[46]-J[47]-J[48]-J[49]+J[50]+
    J[51]-J[52]-J[53]-J[54]+J[55]-J[56]-J[57]-J[58]+J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]+H[1]-H[2]-H[3]-H[4]+
    H[5]+H[6]+H[7]-H[8]-H[9]-H[10]-H[11]+J[0]-J[1]-J[2]-J[3]+J[4]+J[5]+J[6]-J[7]-J[8]-J[9]-J[10]-J[11]-J[12]-J[13]+
    J[14]+J[15]+J[16]-J[17]-J[18]-J[19]-J[20]+J[21]+J[22]-J[23]-J[24]-J[25]+J[26]+J[27]+J[28]+J[29]+J[30]-J[31]-J[32]-J[33]+
    J[34]+J[35]+J[36]+J[37]-J[38]-J[39]-J[40]+J[41]+J[42]+J[43]+J[44]+J[45]+J[46]-J[47]-J[48]-J[49]-J[50]+
    J[51]-J[52]-J[53]-J[54]-J[55]-J[56]-J[57]-J[58]-J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]+H[1]-H[2]-H[3]-H[4]+
    H[5]+H[6]-H[7]+H[8]+H[9]+H[10]+H[11]+J[0]-J[1]-J[2]-J[3]+J[4]+J[5]-J[6]+J[7]+J[8]+J[9]+J[10]-J[11]-J[12]-J[13]+
    J[14]+J[15]-J[16]+J[17]+J[18]+J[19]+J[20]+J[21]+J[22]-J[23]-J[24]+J[25]-J[26]-J[27]-J[28]-J[29]+J[30]-J[31]-J[32]+
    J[33]-J[34]-J[35]-J[36]-J[37]-J[38]-J[39]+J[40]-J[41]-J[42]-J[43]-J[44]+J[45]-J[46]+J[47]+J[48]+J[49]+
    J[50]-J[51]+J[52]+J[53]+J[54]+J[55]-J[56]-J[57]-J[58]-J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]+
    H[1]-H[2]-H[3]-H[4]+H[5]+H[6]-H[7]+H[8]+H[9]+H[10]-H[11]+J[0]-J[1]-J[2]-J[3]+J[4]+J[5]-J[6]+J[7]+J[8]+
    J[9]-J[10]-J[11]-J[12]-J[13]+J[14]+J[15]-J[16]+J[17]+J[18]+J[19]-J[20]+J[21]+J[22]-J[23]-J[24]+J[25]-J[26]-J[27]-J[28]+
    J[29]+J[30]-J[31]-J[32]+J[33]-J[34]-J[35]-J[36]+J[37]-J[38]-J[39]+J[40]-J[41]-J[42]-J[43]+J[44]+J[45]-J[46]+
    J[47]+J[48]+J[49]-J[50]-J[51]+J[52]+J[53]+J[54]-J[55]-J[56]-J[57]-J[58]+J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +
    H[0]+H[1]-H[2]-H[3]-H[4]+H[5]+H[6]-H[7]+H[8]+H[9]-H[10]+H[11]+J[0]-J[1]-J[2]-J[3]+J[4]+J[5]-J[6]+J[7]+
    J[8]-J[9]+J[10]-J[11]-J[12]-J[13]+J[14]+J[15]-J[16]+J[17]+J[18]-J[19]+J[20]+J[21]+J[22]-J[23]-J[24]+
    J[25]-J[26]-J[27]+J[28]-J[29]+J[30]-J[31]-J[32]+J[33]-J[34]-J[35]+J[36]-J[37]-J[38]-J[39]+J[40]-J[41]-J[42]+
    J[43]-J[44]+J[45]-J[46]+J[47]+J[48]-J[49]+J[50]-J[51]+J[52]+J[53]-J[54]+J[55]-J[56]-J[57]+J[58]-J[59]+
    J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]+H[1]-H[2]-H[3]-H[4]+H[5]+H[6]-H[7]+H[8]+H[9]-H[10]-H[11]+
    J[0]-J[1]-J[2]-J[3]+J[4]+J[5]-J[6]+J[7]+J[8]-J[9]-J[10]-J[11]-J[12]-J[13]+J[14]+J[15]-J[16]+J[17]+J[18]-J[19]-J[20]+
    J[21]+J[22]-J[23]-J[24]+J[25]-J[26]-J[27]+J[28]+J[29]+J[30]-J[31]-J[32]+J[33]-J[34]-J[35]+J[36]+J[37]-J[38]-J[39]+
    J[40]-J[41]-J[42]+J[43]+J[44]+J[45]-J[46]+J[47]+J[48]-J[49]-J[50]-J[51]+J[52]+J[53]-J[54]-J[55]-J[56]-J[57]+
    J[58]+J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]+H[1]-H[2]-H[3]-H[4]+H[5]+H[6]-H[7]+H[8]-H[9]+
    H[10]+H[11]+J[0]-J[1]-J[2]-J[3]+J[4]+J[5]-J[6]+J[7]-J[8]+J[9]+J[10]-J[11]-J[12]-J[13]+J[14]+J[15]-J[16]+
    J[17]-J[18]+J[19]+J[20]+J[21]+J[22]-J[23]-J[24]+J[25]-J[26]+J[27]-J[28]-J[29]+J[30]-J[31]-J[32]+J[33]-J[34]+
    J[35]-J[36]-J[37]-J[38]-J[39]+J[40]-J[41]+J[42]-J[43]-J[44]+J[45]-J[46]+J[47]-J[48]+J[49]+J[50]-J[51]+
    J[52]-J[53]+J[54]+J[55]-J[56]+J[57]-J[58]-J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]+H[1]-H[2]-H[3]-H[4]+
    H[5]+H[6]-H[7]+H[8]-H[9]+H[10]-H[11]+J[0]-J[1]-J[2]-J[3]+J[4]+J[5]-J[6]+J[7]-J[8]+J[9]-J[10]-J[11]-J[12]-J[13]+
    J[14]+J[15]-J[16]+J[17]-J[18]+J[19]-J[20]+J[21]+J[22]-J[23]-J[24]+J[25]-J[26]+J[27]-J[28]+J[29]+J[30]-J[31]-J[32]+
    J[33]-J[34]+J[35]-J[36]+J[37]-J[38]-J[39]+J[40]-J[41]+J[42]-J[43]+J[44]+J[45]-J[46]+J[47]-J[48]+J[49]-J[50]-J[51]+
    J[52]-J[53]+J[54]-J[55]-J[56]+J[57]-J[58]+J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]+H[1]-H[2]-H[3]-H[4]+
    H[5]+H[6]-H[7]+H[8]-H[9]-H[10]+H[11]+J[0]-J[1]-J[2]-J[3]+J[4]+J[5]-J[6]+J[7]-J[8]-J[9]+J[10]-J[11]-J[12]-J[13]+
    J[14]+J[15]-J[16]+J[17]-J[18]-J[19]+J[20]+J[21]+J[22]-J[23]-J[24]+J[25]-J[26]+J[27]+J[28]-J[29]+J[30]-J[31]-J[32]+
    J[33]-J[34]+J[35]+J[36]-J[37]-J[38]-J[39]+J[40]-J[41]+J[42]+J[43]-J[44]+J[45]-J[46]+J[47]-J[48]-J[49]+
    J[50]-J[51]+J[52]-J[53]-J[54]+J[55]-J[56]+J[57]+J[58]-J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]+
    H[1]-H[2]-H[3]-H[4]+H[5]+H[6]-H[7]+H[8]-H[9]-H[10]-H[11]+J[0]-J[1]-J[2]-J[3]+J[4]+J[5]-J[6]+J[7]-J[8]-J[9]-J[10]-J[11]-J[12]-J[13]+
    J[14]+J[15]-J[16]+J[17]-J[18]-J[19]-J[20]+J[21]+J[22]-J[23]-J[24]+J[25]-J[26]+J[27]+J[28]+J[29]+J[30]-J[31]-J[32]+
    J[33]-J[34]+J[35]+J[36]+J[37]-J[38]-J[39]+J[40]-J[41]+J[42]+J[43]+J[44]+J[45]-J[46]+J[47]-J[48]-J[49]-J[50]-J[51]+
    J[52]-J[53]-J[54]-J[55]-J[56]+J[57]+J[58]+J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]+H[1]-H[2]-H[3]-H[4]+
    H[5]+H[6]-H[7]-H[8]+H[9]+H[10]+H[11]+J[0]-J[1]-J[2]-J[3]+J[4]+J[5]-J[6]-J[7]+J[8]+J[9]+J[10]-J[11]-J[12]-J[13]+
    J[14]+J[15]-J[16]-J[17]+J[18]+J[19]+J[20]+J[21]+J[22]-J[23]-J[24]+J[25]+J[26]-J[27]-J[28]-J[29]+J[30]-J[31]-J[32]+
    J[33]+J[34]-J[35]-J[36]-J[37]-J[38]-J[39]+J[40]+J[41]-J[42]-J[43]-J[44]+J[45]-J[46]-J[47]+J[48]+J[49]+
    J[50]-J[51]-J[52]+J[53]+J[54]+J[55]+J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]+
    H[1]-H[2]-H[3]-H[4]+H[5]+H[6]-H[7]-H[8]+H[9]+H[10]-H[11]+J[0]-J[1]-J[2]-J[3]+J[4]+J[5]-J[6]-J[7]+J[8]+
    J[9]-J[10]-J[11]-J[12]-J[13]+J[14]+J[15]-J[16]-J[17]+J[18]+J[19]-J[20]+J[21]+J[22]-J[23]-J[24]+J[25]+
    J[26]-J[27]-J[28]+J[29]+J[30]-J[31]-J[32]+J[33]+J[34]-J[35]-J[36]+J[37]-J[38]-J[39]+J[40]+J[41]-J[42]-J[43]+
    J[44]+J[45]-J[46]-J[47]+J[48]+J[49]-J[50]-J[51]-J[52]+J[53]+J[54]-J[55]+J[56]-J[57]-J[58]+J[59]-J[60]-J[61]+
    J[62]+J[63]-J[64]-J[65], +H[0]+H[1]-H[2]-H[3]-H[4]+H[5]+H[6]-H[7]-H[8]+H[9]-H[10]+H[11]+J[0]-J[1]-J[2]-J[3]+
    J[4]+J[5]-J[6]-J[7]+J[8]-J[9]+J[10]-J[11]-J[12]-J[13]+J[14]+J[15]-J[16]-J[17]+J[18]-J[19]+J[20]+J[21]+
    J[22]-J[23]-J[24]+J[25]+J[26]-J[27]+J[28]-J[29]+J[30]-J[31]-J[32]+J[33]+J[34]-J[35]+J[36]-J[37]-J[38]-J[39]+
    J[40]+J[41]-J[42]+J[43]-J[44]+J[45]-J[46]-J[47]+J[48]-J[49]+J[50]-J[51]-J[52]+J[53]-J[54]+J[55]+J[56]-J[57]+
    J[58]-J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]+H[1]-H[2]-H[3]-H[4]+H[5]+H[6]-H[7]-H[8]+H[9]-H[10]-H[11]+
    J[0]-J[1]-J[2]-J[3]+J[4]+J[5]-J[6]-J[7]+J[8]-J[9]-J[10]-J[11]-J[12]-J[13]+J[14]+J[15]-J[16]-J[17]+J[18]-J[19]-J[20]+
    J[21]+J[22]-J[23]-J[24]+J[25]+J[26]-J[27]+J[28]+J[29]+J[30]-J[31]-J[32]+J[33]+J[34]-J[35]+J[36]+J[37]-J[38]-J[39]+
    J[40]+J[41]-J[42]+J[43]+J[44]+J[45]-J[46]-J[47]+J[48]-J[49]-J[50]-J[51]-J[52]+J[53]-J[54]-J[55]+J[56]-J[57]+
    J[58]+J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]+H[1]-H[2]-H[3]-H[4]+H[5]+H[6]-H[7]-H[8]-H[9]+
    H[10]+H[11]+J[0]-J[1]-J[2]-J[3]+J[4]+J[5]-J[6]-J[7]-J[8]+J[9]+J[10]-J[11]-J[12]-J[13]+J[14]+J[15]-J[16]-J[17]-J[18]+
    J[19]+J[20]+J[21]+J[22]-J[23]-J[24]+J[25]+J[26]+J[27]-J[28]-J[29]+J[30]-J[31]-J[32]+J[33]+J[34]+J[35]-J[36]-J[37]-J[38]-J[39]+
    J[40]+J[41]+J[42]-J[43]-J[44]+J[45]-J[46]-J[47]-J[48]+J[49]+J[50]-J[51]-J[52]-J[53]+J[54]+J[55]+J[56]+
    J[57]-J[58]-J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]+H[1]-H[2]-H[3]-H[4]+H[5]+H[6]-H[7]-H[8]-H[9]+
    H[10]-H[11]+J[0]-J[1]-J[2]-J[3]+J[4]+J[5]-J[6]-J[7]-J[8]+J[9]-J[10]-J[11]-J[12]-J[13]+J[14]+J[15]-J[16]-J[17]-J[18]+
    J[19]-J[20]+J[21]+J[22]-J[23]-J[24]+J[25]+J[26]+J[27]-J[28]+J[29]+J[30]-J[31]-J[32]+J[33]+J[34]+J[35]-J[36]+
    J[37]-J[38]-J[39]+J[40]+J[41]+J[42]-J[43]+J[44]+J[45]-J[46]-J[47]-J[48]+J[49]-J[50]-J[51]-J[52]-J[53]+
    J[54]-J[55]+J[56]+J[57]-J[58]+J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]+H[1]-H[2]-H[3]-H[4]+H[5]+
    H[6]-H[7]-H[8]-H[9]-H[10]+H[11]+J[0]-J[1]-J[2]-J[3]+J[4]+J[5]-J[6]-J[7]-J[8]-J[9]+J[10]-J[11]-J[12]-J[13]+
    J[14]+J[15]-J[16]-J[17]-J[18]-J[19]+J[20]+J[21]+J[22]-J[23]-J[24]+J[25]+J[26]+J[27]+J[28]-J[29]+J[30]-J[31]-J[32]+
    J[33]+J[34]+J[35]+J[36]-J[37]-J[38]-J[39]+J[40]+J[41]+J[42]+J[43]-J[44]+J[45]-J[46]-J[47]-J[48]-J[49]+
    J[50]-J[51]-J[52]-J[53]-J[54]+J[55]+J[56]+J[57]+J[58]-J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]+
    H[1]-H[2]-H[3]-H[4]+H[5]+H[6]-H[7]-H[8]-H[9]-H[10]-H[11]+J[0]-J[1]-J[2]-J[3]+J[4]+J[5]-J[6]-J[7]-J[8]-J[9]-J[10]-J[11]-J[12]-J[13]+
    J[14]+J[15]-J[16]-J[17]-J[18]-J[19]-J[20]+J[21]+J[22]-J[23]-J[24]+J[25]+J[26]+J[27]+J[28]+J[29]+J[30]-J[31]-J[32]+
    J[33]+J[34]+J[35]+J[36]+J[37]-J[38]-J[39]+J[40]+J[41]+J[42]+J[43]+J[44]+J[45]-J[46]-J[47]-J[48]-J[49]-J[50]-J[51]-J[52]-J[53]-J[54]-J[55]+
    J[56]+J[57]+J[58]+J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]+H[1]-H[2]-H[3]-H[4]+H[5]-H[6]+H[7]+
    H[8]+H[9]+H[10]+H[11]+J[0]-J[1]-J[2]-J[3]+J[4]-J[5]+J[6]+J[7]+J[8]+J[9]+J[10]-J[11]-J[12]-J[13]+J[14]-J[15]+
    J[16]+J[17]+J[18]+J[19]+J[20]+J[21]+J[22]-J[23]+J[24]-J[25]-J[26]-J[27]-J[28]-J[29]+J[30]-J[31]+J[32]-J[33]-J[34]-J[35]-J[36]-J[37]-J[38]+
    J[39]-J[40]-J[41]-J[42]-J[43]-J[44]-J[45]+J[46]+J[47]+J[48]+J[49]+J[50]-J[51]-J[52]-J[53]-J[54]-J[55]+
    J[56]+J[57]+J[58]+J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]+H[1]-H[2]-H[3]-H[4]+H[5]-H[6]+H[7]+
    H[8]+H[9]+H[10]-H[11]+J[0]-J[1]-J[2]-J[3]+J[4]-J[5]+J[6]+J[7]+J[8]+J[9]-J[10]-J[11]-J[12]-J[13]+J[14]-J[15]+
    J[16]+J[17]+J[18]+J[19]-J[20]+J[21]+J[22]-J[23]+J[24]-J[25]-J[26]-J[27]-J[28]+J[29]+J[30]-J[31]+J[32]-J[33]-J[34]-J[35]-J[36]+
    J[37]-J[38]+J[39]-J[40]-J[41]-J[42]-J[43]+J[44]-J[45]+J[46]+J[47]+J[48]+J[49]-J[50]-J[51]-J[52]-J[53]-J[54]+
    J[55]+J[56]+J[57]+J[58]-J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]+H[1]-H[2]-H[3]-H[4]+H[5]-H[6]+
    H[7]+H[8]+H[9]-H[10]+H[11]+J[0]-J[1]-J[2]-J[3]+J[4]-J[5]+J[6]+J[7]+J[8]-J[9]+J[10]-J[11]-J[12]-J[13]+
    J[14]-J[15]+J[16]+J[17]+J[18]-J[19]+J[20]+J[21]+J[22]-J[23]+J[24]-J[25]-J[26]-J[27]+J[28]-J[29]+J[30]-J[31]+
    J[32]-J[33]-J[34]-J[35]+J[36]-J[37]-J[38]+J[39]-J[40]-J[41]-J[42]+J[43]-J[44]-J[45]+J[46]+J[47]+J[48]-J[49]+
    J[50]-J[51]-J[52]-J[53]+J[54]-J[55]+J[56]+J[57]-J[58]+J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]+
    H[1]-H[2]-H[3]-H[4]+H[5]-H[6]+H[7]+H[8]+H[9]-H[10]-H[11]+J[0]-J[1]-J[2]-J[3]+J[4]-J[5]+J[6]+J[7]+J[8]-J[9]-J[10]-J[11]-J[12]-J[13]+
    J[14]-J[15]+J[16]+J[17]+J[18]-J[19]-J[20]+J[21]+J[22]-J[23]+J[24]-J[25]-J[26]-J[27]+J[28]+J[29]+J[30]-J[31]+
    J[32]-J[33]-J[34]-J[35]+J[36]+J[37]-J[38]+J[39]-J[40]-J[41]-J[42]+J[43]+J[44]-J[45]+J[46]+J[47]+J[48]-J[49]-J[50]-J[51]-J[52]-J[53]+
    J[54]+J[55]+J[56]+J[57]-J[58]-J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]+H[1]-H[2]-H[3]-H[4]+H[5]-H[6]+
    H[7]+H[8]-H[9]+H[10]+H[11]+J[0]-J[1]-J[2]-J[3]+J[4]-J[5]+J[6]+J[7]-J[8]+J[9]+J[10]-J[11]-J[12]-J[13]+
    J[14]-J[15]+J[16]+J[17]-J[18]+J[19]+J[20]+J[21]+J[22]-J[23]+J[24]-J[25]-J[26]+J[27]-J[28]-J[29]+J[30]-J[31]+
    J[32]-J[33]-J[34]+J[35]-J[36]-J[37]-J[38]+J[39]-J[40]-J[41]+J[42]-J[43]-J[44]-J[45]+J[46]+J[47]-J[48]+
    J[49]+J[50]-J[51]-J[52]+J[53]-J[54]-J[55]+J[56]-J[57]+J[58]+J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +
    H[0]+H[1]-H[2]-H[3]-H[4]+H[5]-H[6]+H[7]+H[8]-H[9]+H[10]-H[11]+J[0]-J[1]-J[2]-J[3]+J[4]-J[5]+J[6]+J[7]-J[8]+
    J[9]-J[10]-J[11]-J[12]-J[13]+J[14]-J[15]+J[16]+J[17]-J[18]+J[19]-J[20]+J[21]+J[22]-J[23]+J[24]-J[25]-J[26]+
    J[27]-J[28]+J[29]+J[30]-J[31]+J[32]-J[33]-J[34]+J[35]-J[36]+J[37]-J[38]+J[39]-J[40]-J[41]+J[42]-J[43]+
    J[44]-J[45]+J[46]+J[47]-J[48]+J[49]-J[50]-J[51]-J[52]+J[53]-J[54]+J[55]+J[56]-J[57]+J[58]-J[59]-J[60]+
    J[61]-J[62]-J[63]+J[64]-J[65], +H[0]+H[1]-H[2]-H[3]-H[4]+H[5]-H[6]+H[7]+H[8]-H[9]-H[10]+H[11]+J[0]-J[1]-J[2]-J[3]+
    J[4]-J[5]+J[6]+J[7]-J[8]-J[9]+J[10]-J[11]-J[12]-J[13]+J[14]-J[15]+J[16]+J[17]-J[18]-J[19]+J[20]+J[21]+
    J[22]-J[23]+J[24]-J[25]-J[26]+J[27]+J[28]-J[29]+J[30]-J[31]+J[32]-J[33]-J[34]+J[35]+J[36]-J[37]-J[38]+
    J[39]-J[40]-J[41]+J[42]+J[43]-J[44]-J[45]+J[46]+J[47]-J[48]-J[49]+J[50]-J[51]-J[52]+J[53]+J[54]-J[55]+
    J[56]-J[57]-J[58]+J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]+H[1]-H[2]-H[3]-H[4]+H[5]-H[6]+H[7]+
    H[8]-H[9]-H[10]-H[11]+J[0]-J[1]-J[2]-J[3]+J[4]-J[5]+J[6]+J[7]-J[8]-J[9]-J[10]-J[11]-J[12]-J[13]+J[14]-J[15]+
    J[16]+J[17]-J[18]-J[19]-J[20]+J[21]+J[22]-J[23]+J[24]-J[25]-J[26]+J[27]+J[28]+J[29]+J[30]-J[31]+J[32]-J[33]-J[34]+
    J[35]+J[36]+J[37]-J[38]+J[39]-J[40]-J[41]+J[42]+J[43]+J[44]-J[45]+J[46]+J[47]-J[48]-J[49]-J[50]-J[51]-J[52]+
    J[53]+J[54]+J[55]+J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]+H[1]-H[2]-H[3]-H[4]+
    H[5]-H[6]+H[7]-H[8]+H[9]+H[10]+H[11]+J[0]-J[1]-J[2]-J[3]+J[4]-J[5]+J[6]-J[7]+J[8]+J[9]+J[10]-J[11]-J[12]-J[13]+
    J[14]-J[15]+J[16]-J[17]+J[18]+J[19]+J[20]+J[21]+J[22]-J[23]+J[24]-J[25]+J[26]-J[27]-J[28]-J[29]+J[30]-J[31]+
    J[32]-J[33]+J[34]-J[35]-J[36]-J[37]-J[38]+J[39]-J[40]+J[41]-J[42]-J[43]-J[44]-J[45]+J[46]-J[47]+J[48]+
    J[49]+J[50]-J[51]+J[52]-J[53]-J[54]-J[55]-J[56]+J[57]+J[58]+J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +
    H[0]+H[1]-H[2]-H[3]-H[4]+H[5]-H[6]+H[7]-H[8]+H[9]+H[10]-H[11]+J[0]-J[1]-J[2]-J[3]+J[4]-J[5]+J[6]-J[7]+
    J[8]+J[9]-J[10]-J[11]-J[12]-J[13]+J[14]-J[15]+J[16]-J[17]+J[18]+J[19]-J[20]+J[21]+J[22]-J[23]+J[24]-J[25]+
    J[26]-J[27]-J[28]+J[29]+J[30]-J[31]+J[32]-J[33]+J[34]-J[35]-J[36]+J[37]-J[38]+J[39]-J[40]+J[41]-J[42]-J[43]+
    J[44]-J[45]+J[46]-J[47]+J[48]+J[49]-J[50]-J[51]+J[52]-J[53]-J[54]+J[55]-J[56]+J[57]+J[58]-J[59]-J[60]-J[61]+
    J[62]+J[63]-J[64]-J[65], +H[0]+H[1]-H[2]-H[3]-H[4]+H[5]-H[6]+H[7]-H[8]+H[9]-H[10]+H[11]+J[0]-J[1]-J[2]-J[3]+
    J[4]-J[5]+J[6]-J[7]+J[8]-J[9]+J[10]-J[11]-J[12]-J[13]+J[14]-J[15]+J[16]-J[17]+J[18]-J[19]+J[20]+J[21]+
    J[22]-J[23]+J[24]-J[25]+J[26]-J[27]+J[28]-J[29]+J[30]-J[31]+J[32]-J[33]+J[34]-J[35]+J[36]-J[37]-J[38]+
    J[39]-J[40]+J[41]-J[42]+J[43]-J[44]-J[45]+J[46]-J[47]+J[48]-J[49]+J[50]-J[51]+J[52]-J[53]+J[54]-J[55]-J[56]+
    J[57]-J[58]+J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]+H[1]-H[2]-H[3]-H[4]+H[5]-H[6]+H[7]-H[8]+
    H[9]-H[10]-H[11]+J[0]-J[1]-J[2]-J[3]+J[4]-J[5]+J[6]-J[7]+J[8]-J[9]-J[10]-J[11]-J[12]-J[13]+J[14]-J[15]+
    J[16]-J[17]+J[18]-J[19]-J[20]+J[21]+J[22]-J[23]+J[24]-J[25]+J[26]-J[27]+J[28]+J[29]+J[30]-J[31]+J[32]-J[33]+
    J[34]-J[35]+J[36]+J[37]-J[38]+J[39]-J[40]+J[41]-J[42]+J[43]+J[44]-J[45]+J[46]-J[47]+J[48]-J[49]-J[50]-J[51]+
    J[52]-J[53]+J[54]+J[55]-J[56]+J[57]-J[58]-J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]+H[1]-H[2]-H[3]-H[4]+
    H[5]-H[6]+H[7]-H[8]-H[9]+H[10]+H[11]+J[0]-J[1]-J[2]-J[3]+J[4]-J[5]+J[6]-J[7]-J[8]+J[9]+J[10]-J[11]-J[12]-J[13]+
    J[14]-J[15]+J[16]-J[17]-J[18]+J[19]+J[20]+J[21]+J[22]-J[23]+J[24]-J[25]+J[26]+J[27]-J[28]-J[29]+J[30]-J[31]+
    J[32]-J[33]+J[34]+J[35]-J[36]-J[37]-J[38]+J[39]-J[40]+J[41]+J[42]-J[43]-J[44]-J[45]+J[46]-J[47]-J[48]+
    J[49]+J[50]-J[51]+J[52]+J[53]-J[54]-J[55]-J[56]-J[57]+J[58]+J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +
    H[0]+H[1]-H[2]-H[3]-H[4]+H[5]-H[6]+H[7]-H[8]-H[9]+H[10]-H[11]+J[0]-J[1]-J[2]-J[3]+J[4]-J[5]+J[6]-J[7]-J[8]+
    J[9]-J[10]-J[11]-J[12]-J[13]+J[14]-J[15]+J[16]-J[17]-J[18]+J[19]-J[20]+J[21]+J[22]-J[23]+J[24]-J[25]+
    J[26]+J[27]-J[28]+J[29]+J[30]-J[31]+J[32]-J[33]+J[34]+J[35]-J[36]+J[37]-J[38]+J[39]-J[40]+J[41]+J[42]-J[43]+
    J[44]-J[45]+J[46]-J[47]-J[48]+J[49]-J[50]-J[51]+J[52]+J[53]-J[54]+J[55]-J[56]-J[57]+J[58]-J[59]+J[60]-J[61]+
    J[62]-J[63]+J[64]-J[65], +H[0]+H[1]-H[2]-H[3]-H[4]+H[5]-H[6]+H[7]-H[8]-H[9]-H[10]+H[11]+J[0]-J[1]-J[2]-J[3]+
    J[4]-J[5]+J[6]-J[7]-J[8]-J[9]+J[10]-J[11]-J[12]-J[13]+J[14]-J[15]+J[16]-J[17]-J[18]-J[19]+J[20]+J[21]+
    J[22]-J[23]+J[24]-J[25]+J[26]+J[27]+J[28]-J[29]+J[30]-J[31]+J[32]-J[33]+J[34]+J[35]+J[36]-J[37]-J[38]+
    J[39]-J[40]+J[41]+J[42]+J[43]-J[44]-J[45]+J[46]-J[47]-J[48]-J[49]+J[50]-J[51]+J[52]+J[53]+J[54]-J[55]-J[56]-J[57]-J[58]+
    J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]+H[1]-H[2]-H[3]-H[4]+H[5]-H[6]+H[7]-H[8]-H[9]-H[10]-H[11]+
    J[0]-J[1]-J[2]-J[3]+J[4]-J[5]+J[6]-J[7]-J[8]-J[9]-J[10]-J[11]-J[12]-J[13]+J[14]-J[15]+J[16]-J[17]-J[18]-J[19]-J[20]+
    J[21]+J[22]-J[23]+J[24]-J[25]+J[26]+J[27]+J[28]+J[29]+J[30]-J[31]+J[32]-J[33]+J[34]+J[35]+J[36]+J[37]-J[38]+
    J[39]-J[40]+J[41]+J[42]+J[43]+J[44]-J[45]+J[46]-J[47]-J[48]-J[49]-J[50]-J[51]+J[52]+J[53]+J[54]+J[55]-J[56]-J[57]-J[58]-J[59]+
    J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]+H[1]-H[2]-H[3]-H[4]+H[5]-H[6]-H[7]+H[8]+H[9]+H[10]+H[11]+
    J[0]-J[1]-J[2]-J[3]+J[4]-J[5]-J[6]+J[7]+J[8]+J[9]+J[10]-J[11]-J[12]-J[13]+J[14]-J[15]-J[16]+J[17]+J[18]+
    J[19]+J[20]+J[21]+J[22]-J[23]+J[24]+J[25]-J[26]-J[27]-J[28]-J[29]+J[30]-J[31]+J[32]+J[33]-J[34]-J[35]-J[36]-J[37]-J[38]+
    J[39]+J[40]-J[41]-J[42]-J[43]-J[44]-J[45]-J[46]+J[47]+J[48]+J[49]+J[50]+J[51]-J[52]-J[53]-J[54]-J[55]-J[56]-J[57]-J[58]-J[59]+
    J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]+H[1]-H[2]-H[3]-H[4]+H[5]-H[6]-H[7]+H[8]+H[9]+H[10]-H[11]+
    J[0]-J[1]-J[2]-J[3]+J[4]-J[5]-J[6]+J[7]+J[8]+J[9]-J[10]-J[11]-J[12]-J[13]+J[14]-J[15]-J[16]+J[17]+J[18]+
    J[19]-J[20]+J[21]+J[22]-J[23]+J[24]+J[25]-J[26]-J[27]-J[28]+J[29]+J[30]-J[31]+J[32]+J[33]-J[34]-J[35]-J[36]+
    J[37]-J[38]+J[39]+J[40]-J[41]-J[42]-J[43]+J[44]-J[45]-J[46]+J[47]+J[48]+J[49]-J[50]+J[51]-J[52]-J[53]-J[54]+
    J[55]-J[56]-J[57]-J[58]+J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]+H[1]-H[2]-H[3]-H[4]+H[5]-H[6]-H[7]+
    H[8]+H[9]-H[10]+H[11]+J[0]-J[1]-J[2]-J[3]+J[4]-J[5]-J[6]+J[7]+J[8]-J[9]+J[10]-J[11]-J[12]-J[13]+J[14]-J[15]-J[16]+
    J[17]+J[18]-J[19]+J[20]+J[21]+J[22]-J[23]+J[24]+J[25]-J[26]-J[27]+J[28]-J[29]+J[30]-J[31]+J[32]+J[33]-J[34]-J[35]+
    J[36]-J[37]-J[38]+J[39]+J[40]-J[41]-J[42]+J[43]-J[44]-J[45]-J[46]+J[47]+J[48]-J[49]+J[50]+J[51]-J[52]-J[53]+
    J[54]-J[55]-J[56]-J[57]+J[58]-J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]+H[1]-H[2]-H[3]-H[4]+H[5]-H[6]-H[7]+
    H[8]+H[9]-H[10]-H[11]+J[0]-J[1]-J[2]-J[3]+J[4]-J[5]-J[6]+J[7]+J[8]-J[9]-J[10]-J[11]-J[12]-J[13]+J[14]-J[15]-J[16]+
    J[17]+J[18]-J[19]-J[20]+J[21]+J[22]-J[23]+J[24]+J[25]-J[26]-J[27]+J[28]+J[29]+J[30]-J[31]+J[32]+J[33]-J[34]-J[35]+
    J[36]+J[37]-J[38]+J[39]+J[40]-J[41]-J[42]+J[43]+J[44]-J[45]-J[46]+J[47]+J[48]-J[49]-J[50]+J[51]-J[52]-J[53]+
    J[54]+J[55]-J[56]-J[57]+J[58]+J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]+H[1]-H[2]-H[3]-H[4]+H[5]-H[6]-H[7]+
    H[8]-H[9]+H[10]+H[11]+J[0]-J[1]-J[2]-J[3]+J[4]-J[5]-J[6]+J[7]-J[8]+J[9]+J[10]-J[11]-J[12]-J[13]+J[14]-J[15]-J[16]+
    J[17]-J[18]+J[19]+J[20]+J[21]+J[22]-J[23]+J[24]+J[25]-J[26]+J[27]-J[28]-J[29]+J[30]-J[31]+J[32]+J[33]-J[34]+
    J[35]-J[36]-J[37]-J[38]+J[39]+J[40]-J[41]+J[42]-J[43]-J[44]-J[45]-J[46]+J[47]-J[48]+J[49]+J[50]+J[51]-J[52]+
    J[53]-J[54]-J[55]-J[56]+J[57]-J[58]-J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]+H[1]-H[2]-H[3]-H[4]+
    H[5]-H[6]-H[7]+H[8]-H[9]+H[10]-H[11]+J[0]-J[1]-J[2]-J[3]+J[4]-J[5]-J[6]+J[7]-J[8]+J[9]-J[10]-J[11]-J[12]-J[13]+
    J[14]-J[15]-J[16]+J[17]-J[18]+J[19]-J[20]+J[21]+J[22]-J[23]+J[24]+J[25]-J[26]+J[27]-J[28]+J[29]+J[30]-J[31]+
    J[32]+J[33]-J[34]+J[35]-J[36]+J[37]-J[38]+J[39]+J[40]-J[41]+J[42]-J[43]+J[44]-J[45]-J[46]+J[47]-J[48]+
    J[49]-J[50]+J[51]-J[52]+J[53]-J[54]+J[55]-J[56]+J[57]-J[58]+J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +
    H[0]+H[1]-H[2]-H[3]-H[4]+H[5]-H[6]-H[7]+H[8]-H[9]-H[10]+H[11]+J[0]-J[1]-J[2]-J[3]+J[4]-J[5]-J[6]+J[7]-J[8]-J[9]+
    J[10]-J[11]-J[12]-J[13]+J[14]-J[15]-J[16]+J[17]-J[18]-J[19]+J[20]+J[21]+J[22]-J[23]+J[24]+J[25]-J[26]+
    J[27]+J[28]-J[29]+J[30]-J[31]+J[32]+J[33]-J[34]+J[35]+J[36]-J[37]-J[38]+J[39]+J[40]-J[41]+J[42]+J[43]-J[44]-J[45]-J[46]+
    J[47]-J[48]-J[49]+J[50]+J[51]-J[52]+J[53]+J[54]-J[55]-J[56]+J[57]+J[58]-J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +
    H[0]+H[1]-H[2]-H[3]-H[4]+H[5]-H[6]-H[7]+H[8]-H[9]-H[10]-H[11]+J[0]-J[1]-J[2]-J[3]+J[4]-J[5]-J[6]+J[7]-J[8]-J[9]-J[10]-J[11]-J[12]-J[13]+
    J[14]-J[15]-J[16]+J[17]-J[18]-J[19]-J[20]+J[21]+J[22]-J[23]+J[24]+J[25]-J[26]+J[27]+J[28]+J[29]+J[30]-J[31]+
    J[32]+J[33]-J[34]+J[35]+J[36]+J[37]-J[38]+J[39]+J[40]-J[41]+J[42]+J[43]+J[44]-J[45]-J[46]+J[47]-J[48]-J[49]-J[50]+
    J[51]-J[52]+J[53]+J[54]+J[55]-J[56]+J[57]+J[58]+J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]+H[1]-H[2]-H[3]-H[4]+
    H[5]-H[6]-H[7]-H[8]+H[9]+H[10]+H[11]+J[0]-J[1]-J[2]-J[3]+J[4]-J[5]-J[6]-J[7]+J[8]+J[9]+J[10]-J[11]-J[12]-J[13]+
    J[14]-J[15]-J[16]-J[17]+J[18]+J[19]+J[20]+J[21]+J[22]-J[23]+J[24]+J[25]+J[26]-J[27]-J[28]-J[29]+J[30]-J[31]+
    J[32]+J[33]+J[34]-J[35]-J[36]-J[37]-J[38]+J[39]+J[40]+J[41]-J[42]-J[43]-J[44]-J[45]-J[46]-J[47]+J[48]+
    J[49]+J[50]+J[51]+J[52]-J[53]-J[54]-J[55]+J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +
    H[0]+H[1]-H[2]-H[3]-H[4]+H[5]-H[6]-H[7]-H[8]+H[9]+H[10]-H[11]+J[0]-J[1]-J[2]-J[3]+J[4]-J[5]-J[6]-J[7]+
    J[8]+J[9]-J[10]-J[11]-J[12]-J[13]+J[14]-J[15]-J[16]-J[17]+J[18]+J[19]-J[20]+J[21]+J[22]-J[23]+J[24]+
    J[25]+J[26]-J[27]-J[28]+J[29]+J[30]-J[31]+J[32]+J[33]+J[34]-J[35]-J[36]+J[37]-J[38]+J[39]+J[40]+J[41]-J[42]-J[43]+
    J[44]-J[45]-J[46]-J[47]+J[48]+J[49]-J[50]+J[51]+J[52]-J[53]-J[54]+J[55]+J[56]-J[57]-J[58]+J[59]-J[60]-J[61]+
    J[62]+J[63]-J[64]-J[65], +H[0]+H[1]-H[2]-H[3]-H[4]+H[5]-H[6]-H[7]-H[8]+H[9]-H[10]+H[11]+J[0]-J[1]-J[2]-J[3]+
    J[4]-J[5]-J[6]-J[7]+J[8]-J[9]+J[10]-J[11]-J[12]-J[13]+J[14]-J[15]-J[16]-J[17]+J[18]-J[19]+J[20]+J[21]+
    J[22]-J[23]+J[24]+J[25]+J[26]-J[27]+J[28]-J[29]+J[30]-J[31]+J[32]+J[33]+J[34]-J[35]+J[36]-J[37]-J[38]+
    J[39]+J[40]+J[41]-J[42]+J[43]-J[44]-J[45]-J[46]-J[47]+J[48]-J[49]+J[50]+J[51]+J[52]-J[53]+J[54]-J[55]+
    J[56]-J[57]+J[58]-J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]+H[1]-H[2]-H[3]-H[4]+H[5]-H[6]-H[7]-H[8]+
    H[9]-H[10]-H[11]+J[0]-J[1]-J[2]-J[3]+J[4]-J[5]-J[6]-J[7]+J[8]-J[9]-J[10]-J[11]-J[12]-J[13]+J[14]-J[15]-J[16]-J[17]+
    J[18]-J[19]-J[20]+J[21]+J[22]-J[23]+J[24]+J[25]+J[26]-J[27]+J[28]+J[29]+J[30]-J[31]+J[32]+J[33]+J[34]-J[35]+
    J[36]+J[37]-J[38]+J[39]+J[40]+J[41]-J[42]+J[43]+J[44]-J[45]-J[46]-J[47]+J[48]-J[49]-J[50]+J[51]+J[52]-J[53]+
    J[54]+J[55]+J[56]-J[57]+J[58]+J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]+H[1]-H[2]-H[3]-H[4]+H[5]-H[6]-H[7]-H[8]-H[9]+
    H[10]+H[11]+J[0]-J[1]-J[2]-J[3]+J[4]-J[5]-J[6]-J[7]-J[8]+J[9]+J[10]-J[11]-J[12]-J[13]+J[14]-J[15]-J[16]-J[17]-J[18]+
    J[19]+J[20]+J[21]+J[22]-J[23]+J[24]+J[25]+J[26]+J[27]-J[28]-J[29]+J[30]-J[31]+J[32]+J[33]+J[34]+J[35]-J[36]-J[37]-J[38]+
    J[39]+J[40]+J[41]+J[42]-J[43]-J[44]-J[45]-J[46]-J[47]-J[48]+J[49]+J[50]+J[51]+J[52]+J[53]-J[54]-J[55]+
    J[56]+J[57]-J[58]-J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]+H[1]-H[2]-H[3]-H[4]+H[5]-H[6]-H[7]-H[8]-H[9]+
    H[10]-H[11]+J[0]-J[1]-J[2]-J[3]+J[4]-J[5]-J[6]-J[7]-J[8]+J[9]-J[10]-J[11]-J[12]-J[13]+J[14]-J[15]-J[16]-J[17]-J[18]+
    J[19]-J[20]+J[21]+J[22]-J[23]+J[24]+J[25]+J[26]+J[27]-J[28]+J[29]+J[30]-J[31]+J[32]+J[33]+J[34]+J[35]-J[36]+
    J[37]-J[38]+J[39]+J[40]+J[41]+J[42]-J[43]+J[44]-J[45]-J[46]-J[47]-J[48]+J[49]-J[50]+J[51]+J[52]+J[53]-J[54]+
    J[55]+J[56]+J[57]-J[58]+J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]+H[1]-H[2]-H[3]-H[4]+H[5]-H[6]-H[7]-H[8]-H[9]-H[10]+
    H[11]+J[0]-J[1]-J[2]-J[3]+J[4]-J[5]-J[6]-J[7]-J[8]-J[9]+J[10]-J[11]-J[12]-J[13]+J[14]-J[15]-J[16]-J[17]-J[18]-J[19]+
    J[20]+J[21]+J[22]-J[23]+J[24]+J[25]+J[26]+J[27]+J[28]-J[29]+J[30]-J[31]+J[32]+J[33]+J[34]+J[35]+J[36]-J[37]-J[38]+
    J[39]+J[40]+J[41]+J[42]+J[43]-J[44]-J[45]-J[46]-J[47]-J[48]-J[49]+J[50]+J[51]+J[52]+J[53]+J[54]-J[55]+
    J[56]+J[57]+J[58]-J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]+H[1]-H[2]-H[3]-H[4]+H[5]-H[6]-H[7]-H[8]-H[9]-H[10]-H[11]+
    J[0]-J[1]-J[2]-J[3]+J[4]-J[5]-J[6]-J[7]-J[8]-J[9]-J[10]-J[11]-J[12]-J[13]+J[14]-J[15]-J[16]-J[17]-J[18]-J[19]-J[20]+
    J[21]+J[22]-J[23]+J[24]+J[25]+J[26]+J[27]+J[28]+J[29]+J[30]-J[31]+J[32]+J[33]+J[34]+J[35]+J[36]+J[37]-J[38]+
    J[39]+J[40]+J[41]+J[42]+J[43]+J[44]-J[45]-J[46]-J[47]-J[48]-J[49]-J[50]+J[51]+J[52]+J[53]+J[54]+J[55]+
    J[56]+J[57]+J[58]+J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]+H[1]-H[2]-H[3]-H[4]-H[5]+H[6]+H[7]+
    H[8]+H[9]+H[10]+H[11]+J[0]-J[1]-J[2]-J[3]-J[4]+J[5]+J[6]+J[7]+J[8]+J[9]+J[10]-J[11]-J[12]-J[13]-J[14]+
    J[15]+J[16]+J[17]+J[18]+J[19]+J[20]+J[21]+J[22]+J[23]-J[24]-J[25]-J[26]-J[27]-J[28]-J[29]+J[30]+J[31]-J[32]-J[33]-J[34]-J[35]-J[36]-J[37]+
    J[38]-J[39]-J[40]-J[41]-J[42]-J[43]-J[44]-J[45]-J[46]-J[47]-J[48]-J[49]-J[50]+J[51]+J[52]+J[53]+J[54]+
    J[55]+J[56]+J[57]+J[58]+J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]+H[1]-H[2]-H[3]-H[4]-H[5]+H[6]+
    H[7]+H[8]+H[9]+H[10]-H[11]+J[0]-J[1]-J[2]-J[3]-J[4]+J[5]+J[6]+J[7]+J[8]+J[9]-J[10]-J[11]-J[12]-J[13]-J[14]+
    J[15]+J[16]+J[17]+J[18]+J[19]-J[20]+J[21]+J[22]+J[23]-J[24]-J[25]-J[26]-J[27]-J[28]+J[29]+J[30]+J[31]-J[32]-J[33]-J[34]-J[35]-J[36]+
    J[37]+J[38]-J[39]-J[40]-J[41]-J[42]-J[43]+J[44]-J[45]-J[46]-J[47]-J[48]-J[49]+J[50]+J[51]+J[52]+J[53]+
    J[54]-J[55]+J[56]+J[57]+J[58]-J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]+H[1]-H[2]-H[3]-H[4]-H[5]+
    H[6]+H[7]+H[8]+H[9]-H[10]+H[11]+J[0]-J[1]-J[2]-J[3]-J[4]+J[5]+J[6]+J[7]+J[8]-J[9]+J[10]-J[11]-J[12]-J[13]-J[14]+
    J[15]+J[16]+J[17]+J[18]-J[19]+J[20]+J[21]+J[22]+J[23]-J[24]-J[25]-J[26]-J[27]+J[28]-J[29]+J[30]+J[31]-J[32]-J[33]-J[34]-J[35]+
    J[36]-J[37]+J[38]-J[39]-J[40]-J[41]-J[42]+J[43]-J[44]-J[45]-J[46]-J[47]-J[48]+J[49]-J[50]+J[51]+J[52]+
    J[53]-J[54]+J[55]+J[56]+J[57]-J[58]+J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]+H[1]-H[2]-H[3]-H[4]-H[5]+
    H[6]+H[7]+H[8]+H[9]-H[10]-H[11]+J[0]-J[1]-J[2]-J[3]-J[4]+J[5]+J[6]+J[7]+J[8]-J[9]-J[10]-J[11]-J[12]-J[13]-J[14]+
    J[15]+J[16]+J[17]+J[18]-J[19]-J[20]+J[21]+J[22]+J[23]-J[24]-J[25]-J[26]-J[27]+J[28]+J[29]+J[30]+J[31]-J[32]-J[33]-J[34]-J[35]+
    J[36]+J[37]+J[38]-J[39]-J[40]-J[41]-J[42]+J[43]+J[44]-J[45]-J[46]-J[47]-J[48]+J[49]+J[50]+J[51]+J[52]+
    J[53]-J[54]-J[55]+J[56]+J[57]-J[58]-J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]+H[1]-H[2]-H[3]-H[4]-H[5]+
    H[6]+H[7]+H[8]-H[9]+H[10]+H[11]+J[0]-J[1]-J[2]-J[3]-J[4]+J[5]+J[6]+J[7]-J[8]+J[9]+J[10]-J[11]-J[12]-J[13]-J[14]+
    J[15]+J[16]+J[17]-J[18]+J[19]+J[20]+J[21]+J[22]+J[23]-J[24]-J[25]-J[26]+J[27]-J[28]-J[29]+J[30]+J[31]-J[32]-J[33]-J[34]+
    J[35]-J[36]-J[37]+J[38]-J[39]-J[40]-J[41]+J[42]-J[43]-J[44]-J[45]-J[46]-J[47]+J[48]-J[49]-J[50]+J[51]+
    J[52]-J[53]+J[54]+J[55]+J[56]-J[57]+J[58]+J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]+H[1]-H[2]-H[3]-H[4]-H[5]+
    H[6]+H[7]+H[8]-H[9]+H[10]-H[11]+J[0]-J[1]-J[2]-J[3]-J[4]+J[5]+J[6]+J[7]-J[8]+J[9]-J[10]-J[11]-J[12]-J[13]-J[14]+
    J[15]+J[16]+J[17]-J[18]+J[19]-J[20]+J[21]+J[22]+J[23]-J[24]-J[25]-J[26]+J[27]-J[28]+J[29]+J[30]+J[31]-J[32]-J[33]-J[34]+
    J[35]-J[36]+J[37]+J[38]-J[39]-J[40]-J[41]+J[42]-J[43]+J[44]-J[45]-J[46]-J[47]+J[48]-J[49]+J[50]+J[51]+
    J[52]-J[53]+J[54]-J[55]+J[56]-J[57]+J[58]-J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]+H[1]-H[2]-H[3]-H[4]-H[5]+
    H[6]+H[7]+H[8]-H[9]-H[10]+H[11]+J[0]-J[1]-J[2]-J[3]-J[4]+J[5]+J[6]+J[7]-J[8]-J[9]+J[10]-J[11]-J[12]-J[13]-J[14]+
    J[15]+J[16]+J[17]-J[18]-J[19]+J[20]+J[21]+J[22]+J[23]-J[24]-J[25]-J[26]+J[27]+J[28]-J[29]+J[30]+J[31]-J[32]-J[33]-J[34]+
    J[35]+J[36]-J[37]+J[38]-J[39]-J[40]-J[41]+J[42]+J[43]-J[44]-J[45]-J[46]-J[47]+J[48]+J[49]-J[50]+J[51]+
    J[52]-J[53]-J[54]+J[55]+J[56]-J[57]-J[58]+J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]+H[1]-H[2]-H[3]-H[4]-H[5]+
    H[6]+H[7]+H[8]-H[9]-H[10]-H[11]+J[0]-J[1]-J[2]-J[3]-J[4]+J[5]+J[6]+J[7]-J[8]-J[9]-J[10]-J[11]-J[12]-J[13]-J[14]+
    J[15]+J[16]+J[17]-J[18]-J[19]-J[20]+J[21]+J[22]+J[23]-J[24]-J[25]-J[26]+J[27]+J[28]+J[29]+J[30]+J[31]-J[32]-J[33]-J[34]+
    J[35]+J[36]+J[37]+J[38]-J[39]-J[40]-J[41]+J[42]+J[43]+J[44]-J[45]-J[46]-J[47]+J[48]+J[49]+J[50]+J[51]+
    J[52]-J[53]-J[54]-J[55]+J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]+H[1]-H[2]-H[3]-H[4]-H[5]+
    H[6]+H[7]-H[8]+H[9]+H[10]+H[11]+J[0]-J[1]-J[2]-J[3]-J[4]+J[5]+J[6]-J[7]+J[8]+J[9]+J[10]-J[11]-J[12]-J[13]-J[14]+
    J[15]+J[16]-J[17]+J[18]+J[19]+J[20]+J[21]+J[22]+J[23]-J[24]-J[25]+J[26]-J[27]-J[28]-J[29]+J[30]+J[31]-J[32]-J[33]+
    J[34]-J[35]-J[36]-J[37]+J[38]-J[39]-J[40]+J[41]-J[42]-J[43]-J[44]-J[45]-J[46]+J[47]-J[48]-J[49]-J[50]+
    J[51]-J[52]+J[53]+J[54]+J[55]-J[56]+J[57]+J[58]+J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]+H[1]-H[2]-H[3]-H[4]-H[5]+
    H[6]+H[7]-H[8]+H[9]+H[10]-H[11]+J[0]-J[1]-J[2]-J[3]-J[4]+J[5]+J[6]-J[7]+J[8]+J[9]-J[10]-J[11]-J[12]-J[13]-J[14]+
    J[15]+J[16]-J[17]+J[18]+J[19]-J[20]+J[21]+J[22]+J[23]-J[24]-J[25]+J[26]-J[27]-J[28]+J[29]+J[30]+J[31]-J[32]-J[33]+
    J[34]-J[35]-J[36]+J[37]+J[38]-J[39]-J[40]+J[41]-J[42]-J[43]+J[44]-J[45]-J[46]+J[47]-J[48]-J[49]+J[50]+
    J[51]-J[52]+J[53]+J[54]-J[55]-J[56]+J[57]+J[58]-J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]+H[1]-H[2]-H[3]-H[4]-H[5]+
    H[6]+H[7]-H[8]+H[9]-H[10]+H[11]+J[0]-J[1]-J[2]-J[3]-J[4]+J[5]+J[6]-J[7]+J[8]-J[9]+J[10]-J[11]-J[12]-J[13]-J[14]+
    J[15]+J[16]-J[17]+J[18]-J[19]+J[20]+J[21]+J[22]+J[23]-J[24]-J[25]+J[26]-J[27]+J[28]-J[29]+J[30]+J[31]-J[32]-J[33]+
    J[34]-J[35]+J[36]-J[37]+J[38]-J[39]-J[40]+J[41]-J[42]+J[43]-J[44]-J[45]-J[46]+J[47]-J[48]+J[49]-J[50]+
    J[51]-J[52]+J[53]-J[54]+J[55]-J[56]+J[57]-J[58]+J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]+H[1]-H[2]-H[3]-H[4]-H[5]+
    H[6]+H[7]-H[8]+H[9]-H[10]-H[11]+J[0]-J[1]-J[2]-J[3]-J[4]+J[5]+J[6]-J[7]+J[8]-J[9]-J[10]-J[11]-J[12]-J[13]-J[14]+
    J[15]+J[16]-J[17]+J[18]-J[19]-J[20]+J[21]+J[22]+J[23]-J[24]-J[25]+J[26]-J[27]+J[28]+J[29]+J[30]+J[31]-J[32]-J[33]+
    J[34]-J[35]+J[36]+J[37]+J[38]-J[39]-J[40]+J[41]-J[42]+J[43]+J[44]-J[45]-J[46]+J[47]-J[48]+J[49]+J[50]+
    J[51]-J[52]+J[53]-J[54]-J[55]-J[56]+J[57]-J[58]-J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]+H[1]-H[2]-H[3]-H[4]-H[5]+
    H[6]+H[7]-H[8]-H[9]+H[10]+H[11]+J[0]-J[1]-J[2]-J[3]-J[4]+J[5]+J[6]-J[7]-J[8]+J[9]+J[10]-J[11]-J[12]-J[13]-J[14]+
    J[15]+J[16]-J[17]-J[18]+J[19]+J[20]+J[21]+J[22]+J[23]-J[24]-J[25]+J[26]+J[27]-J[28]-J[29]+J[30]+J[31]-J[32]-J[33]+
    J[34]+J[35]-J[36]-J[37]+J[38]-J[39]-J[40]+J[41]+J[42]-J[43]-J[44]-J[45]-J[46]+J[47]+J[48]-J[49]-J[50]+
    J[51]-J[52]-J[53]+J[54]+J[55]-J[56]-J[57]+J[58]+J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]+H[1]-H[2]-H[3]-H[4]-H[5]+
    H[6]+H[7]-H[8]-H[9]+H[10]-H[11]+J[0]-J[1]-J[2]-J[3]-J[4]+J[5]+J[6]-J[7]-J[8]+J[9]-J[10]-J[11]-J[12]-J[13]-J[14]+
    J[15]+J[16]-J[17]-J[18]+J[19]-J[20]+J[21]+J[22]+J[23]-J[24]-J[25]+J[26]+J[27]-J[28]+J[29]+J[30]+J[31]-J[32]-J[33]+
    J[34]+J[35]-J[36]+J[37]+J[38]-J[39]-J[40]+J[41]+J[42]-J[43]+J[44]-J[45]-J[46]+J[47]+J[48]-J[49]+J[50]+
    J[51]-J[52]-J[53]+J[54]-J[55]-J[56]-J[57]+J[58]-J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]+H[1]-H[2]-H[3]-H[4]-H[5]+
    H[6]+H[7]-H[8]-H[9]-H[10]+H[11]+J[0]-J[1]-J[2]-J[3]-J[4]+J[5]+J[6]-J[7]-J[8]-J[9]+J[10]-J[11]-J[12]-J[13]-J[14]+
    J[15]+J[16]-J[17]-J[18]-J[19]+J[20]+J[21]+J[22]+J[23]-J[24]-J[25]+J[26]+J[27]+J[28]-J[29]+J[30]+J[31]-J[32]-J[33]+
    J[34]+J[35]+J[36]-J[37]+J[38]-J[39]-J[40]+J[41]+J[42]+J[43]-J[44]-J[45]-J[46]+J[47]+J[48]+J[49]-J[50]+
    J[51]-J[52]-J[53]-J[54]+J[55]-J[56]-J[57]-J[58]+J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]+H[1]-H[2]-H[3]-H[4]-H[5]+
    H[6]+H[7]-H[8]-H[9]-H[10]-H[11]+J[0]-J[1]-J[2]-J[3]-J[4]+J[5]+J[6]-J[7]-J[8]-J[9]-J[10]-J[11]-J[12]-J[13]-J[14]+
    J[15]+J[16]-J[17]-J[18]-J[19]-J[20]+J[21]+J[22]+J[23]-J[24]-J[25]+J[26]+J[27]+J[28]+J[29]+J[30]+J[31]-J[32]-J[33]+
    J[34]+J[35]+J[36]+J[37]+J[38]-J[39]-J[40]+J[41]+J[42]+J[43]+J[44]-J[45]-J[46]+J[47]+J[48]+J[49]+J[50]+
    J[51]-J[52]-J[53]-J[54]-J[55]-J[56]-J[57]-J[58]-J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]+H[1]-H[2]-H[3]-H[4]-H[5]+
    H[6]-H[7]+H[8]+H[9]+H[10]+H[11]+J[0]-J[1]-J[2]-J[3]-J[4]+J[5]-J[6]+J[7]+J[8]+J[9]+J[10]-J[11]-J[12]-J[13]-J[14]+
    J[15]-J[16]+J[17]+J[18]+J[19]+J[20]+J[21]+J[22]+J[23]-J[24]+J[25]-J[26]-J[27]-J[28]-J[29]+J[30]+J[31]-J[32]+
    J[33]-J[34]-J[35]-J[36]-J[37]+J[38]-J[39]+J[40]-J[41]-J[42]-J[43]-J[44]-J[45]+J[46]-J[47]-J[48]-J[49]-J[50]-J[51]+
    J[52]+J[53]+J[54]+J[55]-J[56]-J[57]-J[58]-J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]+H[1]-H[2]-H[3]-H[4]-H[5]+
    H[6]-H[7]+H[8]+H[9]+H[10]-H[11]+J[0]-J[1]-J[2]-J[3]-J[4]+J[5]-J[6]+J[7]+J[8]+J[9]-J[10]-J[11]-J[12]-J[13]-J[14]+
    J[15]-J[16]+J[17]+J[18]+J[19]-J[20]+J[21]+J[22]+J[23]-J[24]+J[25]-J[26]-J[27]-J[28]+J[29]+J[30]+J[31]-J[32]+
    J[33]-J[34]-J[35]-J[36]+J[37]+J[38]-J[39]+J[40]-J[41]-J[42]-J[43]+J[44]-J[45]+J[46]-J[47]-J[48]-J[49]+
    J[50]-J[51]+J[52]+J[53]+J[54]-J[55]-J[56]-J[57]-J[58]+J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]+
    H[1]-H[2]-H[3]-H[4]-H[5]+H[6]-H[7]+H[8]+H[9]-H[10]+H[11]+J[0]-J[1]-J[2]-J[3]-J[4]+J[5]-J[6]+J[7]+J[8]-J[9]+
    J[10]-J[11]-J[12]-J[13]-J[14]+J[15]-J[16]+J[17]+J[18]-J[19]+J[20]+J[21]+J[22]+J[23]-J[24]+J[25]-J[26]-J[27]+
    J[28]-J[29]+J[30]+J[31]-J[32]+J[33]-J[34]-J[35]+J[36]-J[37]+J[38]-J[39]+J[40]-J[41]-J[42]+J[43]-J[44]-J[45]+
    J[46]-J[47]-J[48]+J[49]-J[50]-J[51]+J[52]+J[53]-J[54]+J[55]-J[56]-J[57]+J[58]-J[59]+J[60]-J[61]+J[62]-J[63]+
    J[64]-J[65], +H[0]+H[1]-H[2]-H[3]-H[4]-H[5]+H[6]-H[7]+H[8]+H[9]-H[10]-H[11]+J[0]-J[1]-J[2]-J[3]-J[4]+
    J[5]-J[6]+J[7]+J[8]-J[9]-J[10]-J[11]-J[12]-J[13]-J[14]+J[15]-J[16]+J[17]+J[18]-J[19]-J[20]+J[21]+J[22]+
    J[23]-J[24]+J[25]-J[26]-J[27]+J[28]+J[29]+J[30]+J[31]-J[32]+J[33]-J[34]-J[35]+J[36]+J[37]+J[38]-J[39]+
    J[40]-J[41]-J[42]+J[43]+J[44]-J[45]+J[46]-J[47]-J[48]+J[49]+J[50]-J[51]+J[52]+J[53]-J[54]-J[55]-J[56]-J[57]+
    J[58]+J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]+H[1]-H[2]-H[3]-H[4]-H[5]+H[6]-H[7]+H[8]-H[9]+
    H[10]+H[11]+J[0]-J[1]-J[2]-J[3]-J[4]+J[5]-J[6]+J[7]-J[8]+J[9]+J[10]-J[11]-J[12]-J[13]-J[14]+J[15]-J[16]+
    J[17]-J[18]+J[19]+J[20]+J[21]+J[22]+J[23]-J[24]+J[25]-J[26]+J[27]-J[28]-J[29]+J[30]+J[31]-J[32]+J[33]-J[34]+
    J[35]-J[36]-J[37]+J[38]-J[39]+J[40]-J[41]+J[42]-J[43]-J[44]-J[45]+J[46]-J[47]+J[48]-J[49]-J[50]-J[51]+
    J[52]-J[53]+J[54]+J[55]-J[56]+J[57]-J[58]-J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]+H[1]-H[2]-H[3]-H[4]-H[5]+
    H[6]-H[7]+H[8]-H[9]+H[10]-H[11]+J[0]-J[1]-J[2]-J[3]-J[4]+J[5]-J[6]+J[7]-J[8]+J[9]-J[10]-J[11]-J[12]-J[13]-J[14]+
    J[15]-J[16]+J[17]-J[18]+J[19]-J[20]+J[21]+J[22]+J[23]-J[24]+J[25]-J[26]+J[27]-J[28]+J[29]+J[30]+J[31]-J[32]+
    J[33]-J[34]+J[35]-J[36]+J[37]+J[38]-J[39]+J[40]-J[41]+J[42]-J[43]+J[44]-J[45]+J[46]-J[47]+J[48]-J[49]+
    J[50]-J[51]+J[52]-J[53]+J[54]-J[55]-J[56]+J[57]-J[58]+J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]+
    H[1]-H[2]-H[3]-H[4]-H[5]+H[6]-H[7]+H[8]-H[9]-H[10]+H[11]+J[0]-J[1]-J[2]-J[3]-J[4]+J[5]-J[6]+J[7]-J[8]-J[9]+
    J[10]-J[11]-J[12]-J[13]-J[14]+J[15]-J[16]+J[17]-J[18]-J[19]+J[20]+J[21]+J[22]+J[23]-J[24]+J[25]-J[26]+
    J[27]+J[28]-J[29]+J[30]+J[31]-J[32]+J[33]-J[34]+J[35]+J[36]-J[37]+J[38]-J[39]+J[40]-J[41]+J[42]+J[43]-J[44]-J[45]+
    J[46]-J[47]+J[48]+J[49]-J[50]-J[51]+J[52]-J[53]-J[54]+J[55]-J[56]+J[57]+J[58]-J[59]-J[60]-J[61]+J[62]+
    J[63]-J[64]-J[65], +H[0]+H[1]-H[2]-H[3]-H[4]-H[5]+H[6]-H[7]+H[8]-H[9]-H[10]-H[11]+J[0]-J[1]-J[2]-J[3]-J[4]+
    J[5]-J[6]+J[7]-J[8]-J[9]-J[10]-J[11]-J[12]-J[13]-J[14]+J[15]-J[16]+J[17]-J[18]-J[19]-J[20]+J[21]+J[22]+
    J[23]-J[24]+J[25]-J[26]+J[27]+J[28]+J[29]+J[30]+J[31]-J[32]+J[33]-J[34]+J[35]+J[36]+J[37]+J[38]-J[39]+
    J[40]-J[41]+J[42]+J[43]+J[44]-J[45]+J[46]-J[47]+J[48]+J[49]+J[50]-J[51]+J[52]-J[53]-J[54]-J[55]-J[56]+
    J[57]+J[58]+J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]+H[1]-H[2]-H[3]-H[4]-H[5]+H[6]-H[7]-H[8]+
    H[9]+H[10]+H[11]+J[0]-J[1]-J[2]-J[3]-J[4]+J[5]-J[6]-J[7]+J[8]+J[9]+J[10]-J[11]-J[12]-J[13]-J[14]+J[15]-J[16]-J[17]+
    J[18]+J[19]+J[20]+J[21]+J[22]+J[23]-J[24]+J[25]+J[26]-J[27]-J[28]-J[29]+J[30]+J[31]-J[32]+J[33]+J[34]-J[35]-J[36]-J[37]+
    J[38]-J[39]+J[40]+J[41]-J[42]-J[43]-J[44]-J[45]+J[46]+J[47]-J[48]-J[49]-J[50]-J[51]-J[52]+J[53]+J[54]+
    J[55]+J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]+H[1]-H[2]-H[3]-H[4]-H[5]+H[6]-H[7]-H[8]+
    H[9]+H[10]-H[11]+J[0]-J[1]-J[2]-J[3]-J[4]+J[5]-J[6]-J[7]+J[8]+J[9]-J[10]-J[11]-J[12]-J[13]-J[14]+J[15]-J[16]-J[17]+
    J[18]+J[19]-J[20]+J[21]+J[22]+J[23]-J[24]+J[25]+J[26]-J[27]-J[28]+J[29]+J[30]+J[31]-J[32]+J[33]+J[34]-J[35]-J[36]+
    J[37]+J[38]-J[39]+J[40]+J[41]-J[42]-J[43]+J[44]-J[45]+J[46]+J[47]-J[48]-J[49]+J[50]-J[51]-J[52]+J[53]+
    J[54]-J[55]+J[56]-J[57]-J[58]+J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]+H[1]-H[2]-H[3]-H[4]-H[5]+
    H[6]-H[7]-H[8]+H[9]-H[10]+H[11]+J[0]-J[1]-J[2]-J[3]-J[4]+J[5]-J[6]-J[7]+J[8]-J[9]+J[10]-J[11]-J[12]-J[13]-J[14]+
    J[15]-J[16]-J[17]+J[18]-J[19]+J[20]+J[21]+J[22]+J[23]-J[24]+J[25]+J[26]-J[27]+J[28]-J[29]+J[30]+J[31]-J[32]+
    J[33]+J[34]-J[35]+J[36]-J[37]+J[38]-J[39]+J[40]+J[41]-J[42]+J[43]-J[44]-J[45]+J[46]+J[47]-J[48]+J[49]-J[50]-J[51]-J[52]+
    J[53]-J[54]+J[55]+J[56]-J[57]+J[58]-J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]+H[1]-H[2]-H[3]-H[4]-H[5]+
    H[6]-H[7]-H[8]+H[9]-H[10]-H[11]+J[0]-J[1]-J[2]-J[3]-J[4]+J[5]-J[6]-J[7]+J[8]-J[9]-J[10]-J[11]-J[12]-J[13]-J[14]+
    J[15]-J[16]-J[17]+J[18]-J[19]-J[20]+J[21]+J[22]+J[23]-J[24]+J[25]+J[26]-J[27]+J[28]+J[29]+J[30]+J[31]-J[32]+
    J[33]+J[34]-J[35]+J[36]+J[37]+J[38]-J[39]+J[40]+J[41]-J[42]+J[43]+J[44]-J[45]+J[46]+J[47]-J[48]+J[49]+
    J[50]-J[51]-J[52]+J[53]-J[54]-J[55]+J[56]-J[57]+J[58]+J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]+
    H[1]-H[2]-H[3]-H[4]-H[5]+H[6]-H[7]-H[8]-H[9]+H[10]+H[11]+J[0]-J[1]-J[2]-J[3]-J[4]+J[5]-J[6]-J[7]-J[8]+
    J[9]+J[10]-J[11]-J[12]-J[13]-J[14]+J[15]-J[16]-J[17]-J[18]+J[19]+J[20]+J[21]+J[22]+J[23]-J[24]+J[25]+
    J[26]+J[27]-J[28]-J[29]+J[30]+J[31]-J[32]+J[33]+J[34]+J[35]-J[36]-J[37]+J[38]-J[39]+J[40]+J[41]+J[42]-J[43]-J[44]-J[45]+
    J[46]+J[47]+J[48]-J[49]-J[50]-J[51]-J[52]-J[53]+J[54]+J[55]+J[56]+J[57]-J[58]-J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+
    J[65], +H[0]+H[1]-H[2]-H[3]-H[4]-H[5]+H[6]-H[7]-H[8]-H[9]+H[10]-H[11]+J[0]-J[1]-J[2]-J[3]-J[4]+J[5]-J[6]-J[7]-J[8]+
    J[9]-J[10]-J[11]-J[12]-J[13]-J[14]+J[15]-J[16]-J[17]-J[18]+J[19]-J[20]+J[21]+J[22]+J[23]-J[24]+J[25]+
    J[26]+J[27]-J[28]+J[29]+J[30]+J[31]-J[32]+J[33]+J[34]+J[35]-J[36]+J[37]+J[38]-J[39]+J[40]+J[41]+J[42]-J[43]+
    J[44]-J[45]+J[46]+J[47]+J[48]-J[49]+J[50]-J[51]-J[52]-J[53]+J[54]-J[55]+J[56]+J[57]-J[58]+J[59]+J[60]-J[61]+
    J[62]-J[63]+J[64]-J[65], +H[0]+H[1]-H[2]-H[3]-H[4]-H[5]+H[6]-H[7]-H[8]-H[9]-H[10]+H[11]+J[0]-J[1]-J[2]-J[3]-J[4]+
    J[5]-J[6]-J[7]-J[8]-J[9]+J[10]-J[11]-J[12]-J[13]-J[14]+J[15]-J[16]-J[17]-J[18]-J[19]+J[20]+J[21]+J[22]+
    J[23]-J[24]+J[25]+J[26]+J[27]+J[28]-J[29]+J[30]+J[31]-J[32]+J[33]+J[34]+J[35]+J[36]-J[37]+J[38]-J[39]+
    J[40]+J[41]+J[42]+J[43]-J[44]-J[45]+J[46]+J[47]+J[48]+J[49]-J[50]-J[51]-J[52]-J[53]-J[54]+J[55]+J[56]+
    J[57]+J[58]-J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]+H[1]-H[2]-H[3]-H[4]-H[5]+H[6]-H[7]-H[8]-H[9]-H[10]-H[11]+
    J[0]-J[1]-J[2]-J[3]-J[4]+J[5]-J[6]-J[7]-J[8]-J[9]-J[10]-J[11]-J[12]-J[13]-J[14]+J[15]-J[16]-J[17]-J[18]-J[19]-J[20]+
    J[21]+J[22]+J[23]-J[24]+J[25]+J[26]+J[27]+J[28]+J[29]+J[30]+J[31]-J[32]+J[33]+J[34]+J[35]+J[36]+J[37]+
    J[38]-J[39]+J[40]+J[41]+J[42]+J[43]+J[44]-J[45]+J[46]+J[47]+J[48]+J[49]+J[50]-J[51]-J[52]-J[53]-J[54]-J[55]+
    J[56]+J[57]+J[58]+J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]+H[1]-H[2]-H[3]-H[4]-H[5]-H[6]+H[7]+
    H[8]+H[9]+H[10]+H[11]+J[0]-J[1]-J[2]-J[3]-J[4]-J[5]+J[6]+J[7]+J[8]+J[9]+J[10]-J[11]-J[12]-J[13]-J[14]-J[15]+
    J[16]+J[17]+J[18]+J[19]+J[20]+J[21]+J[22]+J[23]+J[24]-J[25]-J[26]-J[27]-J[28]-J[29]+J[30]+J[31]+J[32]-J[33]-J[34]-J[35]-J[36]-J[37]+
    J[38]+J[39]-J[40]-J[41]-J[42]-J[43]-J[44]+J[45]-J[46]-J[47]-J[48]-J[49]-J[50]-J[51]-J[52]-J[53]-J[54]-J[55]+
    J[56]+J[57]+J[58]+J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]+H[1]-H[2]-H[3]-H[4]-H[5]-H[6]+H[7]+
    H[8]+H[9]+H[10]-H[11]+J[0]-J[1]-J[2]-J[3]-J[4]-J[5]+J[6]+J[7]+J[8]+J[9]-J[10]-J[11]-J[12]-J[13]-J[14]-J[15]+
    J[16]+J[17]+J[18]+J[19]-J[20]+J[21]+J[22]+J[23]+J[24]-J[25]-J[26]-J[27]-J[28]+J[29]+J[30]+J[31]+J[32]-J[33]-J[34]-J[35]-J[36]+
    J[37]+J[38]+J[39]-J[40]-J[41]-J[42]-J[43]+J[44]+J[45]-J[46]-J[47]-J[48]-J[49]+J[50]-J[51]-J[52]-J[53]-J[54]+
    J[55]+J[56]+J[57]+J[58]-J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]+H[1]-H[2]-H[3]-H[4]-H[5]-H[6]+
    H[7]+H[8]+H[9]-H[10]+H[11]+J[0]-J[1]-J[2]-J[3]-J[4]-J[5]+J[6]+J[7]+J[8]-J[9]+J[10]-J[11]-J[12]-J[13]-J[14]-J[15]+
    J[16]+J[17]+J[18]-J[19]+J[20]+J[21]+J[22]+J[23]+J[24]-J[25]-J[26]-J[27]+J[28]-J[29]+J[30]+J[31]+J[32]-J[33]-J[34]-J[35]+
    J[36]-J[37]+J[38]+J[39]-J[40]-J[41]-J[42]+J[43]-J[44]+J[45]-J[46]-J[47]-J[48]+J[49]-J[50]-J[51]-J[52]-J[53]+
    J[54]-J[55]+J[56]+J[57]-J[58]+J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]+H[1]-H[2]-H[3]-H[4]-H[5]-H[6]+
    H[7]+H[8]+H[9]-H[10]-H[11]+J[0]-J[1]-J[2]-J[3]-J[4]-J[5]+J[6]+J[7]+J[8]-J[9]-J[10]-J[11]-J[12]-J[13]-J[14]-J[15]+
    J[16]+J[17]+J[18]-J[19]-J[20]+J[21]+J[22]+J[23]+J[24]-J[25]-J[26]-J[27]+J[28]+J[29]+J[30]+J[31]+J[32]-J[33]-J[34]-J[35]+
    J[36]+J[37]+J[38]+J[39]-J[40]-J[41]-J[42]+J[43]+J[44]+J[45]-J[46]-J[47]-J[48]+J[49]+J[50]-J[51]-J[52]-J[53]+
    J[54]+J[55]+J[56]+J[57]-J[58]-J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]+H[1]-H[2]-H[3]-H[4]-H[5]-H[6]+
    H[7]+H[8]-H[9]+H[10]+H[11]+J[0]-J[1]-J[2]-J[3]-J[4]-J[5]+J[6]+J[7]-J[8]+J[9]+J[10]-J[11]-J[12]-J[13]-J[14]-J[15]+
    J[16]+J[17]-J[18]+J[19]+J[20]+J[21]+J[22]+J[23]+J[24]-J[25]-J[26]+J[27]-J[28]-J[29]+J[30]+J[31]+J[32]-J[33]-J[34]+
    J[35]-J[36]-J[37]+J[38]+J[39]-J[40]-J[41]+J[42]-J[43]-J[44]+J[45]-J[46]-J[47]+J[48]-J[49]-J[50]-J[51]-J[52]+
    J[53]-J[54]-J[55]+J[56]-J[57]+J[58]+J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]+H[1]-H[2]-H[3]-H[4]-H[5]-H[6]+
    H[7]+H[8]-H[9]+H[10]-H[11]+J[0]-J[1]-J[2]-J[3]-J[4]-J[5]+J[6]+J[7]-J[8]+J[9]-J[10]-J[11]-J[12]-J[13]-J[14]-J[15]+
    J[16]+J[17]-J[18]+J[19]-J[20]+J[21]+J[22]+J[23]+J[24]-J[25]-J[26]+J[27]-J[28]+J[29]+J[30]+J[31]+J[32]-J[33]-J[34]+
    J[35]-J[36]+J[37]+J[38]+J[39]-J[40]-J[41]+J[42]-J[43]+J[44]+J[45]-J[46]-J[47]+J[48]-J[49]+J[50]-J[51]-J[52]+
    J[53]-J[54]+J[55]+J[56]-J[57]+J[58]-J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]+H[1]-H[2]-H[3]-H[4]-H[5]-H[6]+
    H[7]+H[8]-H[9]-H[10]+H[11]+J[0]-J[1]-J[2]-J[3]-J[4]-J[5]+J[6]+J[7]-J[8]-J[9]+J[10]-J[11]-J[12]-J[13]-J[14]-J[15]+
    J[16]+J[17]-J[18]-J[19]+J[20]+J[21]+J[22]+J[23]+J[24]-J[25]-J[26]+J[27]+J[28]-J[29]+J[30]+J[31]+J[32]-J[33]-J[34]+
    J[35]+J[36]-J[37]+J[38]+J[39]-J[40]-J[41]+J[42]+J[43]-J[44]+J[45]-J[46]-J[47]+J[48]+J[49]-J[50]-J[51]-J[52]+
    J[53]+J[54]-J[55]+J[56]-J[57]-J[58]+J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]+H[1]-H[2]-H[3]-H[4]-H[5]-H[6]+
    H[7]+H[8]-H[9]-H[10]-H[11]+J[0]-J[1]-J[2]-J[3]-J[4]-J[5]+J[6]+J[7]-J[8]-J[9]-J[10]-J[11]-J[12]-J[13]-J[14]-J[15]+
    J[16]+J[17]-J[18]-J[19]-J[20]+J[21]+J[22]+J[23]+J[24]-J[25]-J[26]+J[27]+J[28]+J[29]+J[30]+J[31]+J[32]-J[33]-J[34]+
    J[35]+J[36]+J[37]+J[38]+J[39]-J[40]-J[41]+J[42]+J[43]+J[44]+J[45]-J[46]-J[47]+J[48]+J[49]+J[50]-J[51]-J[52]+
    J[53]+J[54]+J[55]+J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]+H[1]-H[2]-H[3]-H[4]-H[5]-H[6]+
    H[7]-H[8]+H[9]+H[10]+H[11]+J[0]-J[1]-J[2]-J[3]-J[4]-J[5]+J[6]-J[7]+J[8]+J[9]+J[10]-J[11]-J[12]-J[13]-J[14]-J[15]+
    J[16]-J[17]+J[18]+J[19]+J[20]+J[21]+J[22]+J[23]+J[24]-J[25]+J[26]-J[27]-J[28]-J[29]+J[30]+J[31]+J[32]-J[33]+
    J[34]-J[35]-J[36]-J[37]+J[38]+J[39]-J[40]+J[41]-J[42]-J[43]-J[44]+J[45]-J[46]+J[47]-J[48]-J[49]-J[50]-J[51]+
    J[52]-J[53]-J[54]-J[55]-J[56]+J[57]+J[58]+J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]+H[1]-H[2]-H[3]-H[4]-H[5]-H[6]+
    H[7]-H[8]+H[9]+H[10]-H[11]+J[0]-J[1]-J[2]-J[3]-J[4]-J[5]+J[6]-J[7]+J[8]+J[9]-J[10]-J[11]-J[12]-J[13]-J[14]-J[15]+
    J[16]-J[17]+J[18]+J[19]-J[20]+J[21]+J[22]+J[23]+J[24]-J[25]+J[26]-J[27]-J[28]+J[29]+J[30]+J[31]+J[32]-J[33]+
    J[34]-J[35]-J[36]+J[37]+J[38]+J[39]-J[40]+J[41]-J[42]-J[43]+J[44]+J[45]-J[46]+J[47]-J[48]-J[49]+J[50]-J[51]+
    J[52]-J[53]-J[54]+J[55]-J[56]+J[57]+J[58]-J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]+H[1]-H[2]-H[3]-H[4]-H[5]-H[6]+
    H[7]-H[8]+H[9]-H[10]+H[11]+J[0]-J[1]-J[2]-J[3]-J[4]-J[5]+J[6]-J[7]+J[8]-J[9]+J[10]-J[11]-J[12]-J[13]-J[14]-J[15]+
    J[16]-J[17]+J[18]-J[19]+J[20]+J[21]+J[22]+J[23]+J[24]-J[25]+J[26]-J[27]+J[28]-J[29]+J[30]+J[31]+J[32]-J[33]+
    J[34]-J[35]+J[36]-J[37]+J[38]+J[39]-J[40]+J[41]-J[42]+J[43]-J[44]+J[45]-J[46]+J[47]-J[48]+J[49]-J[50]-J[51]+
    J[52]-J[53]+J[54]-J[55]-J[56]+J[57]-J[58]+J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]+H[1]-H[2]-H[3]-H[4]-H[5]-H[6]+
    H[7]-H[8]+H[9]-H[10]-H[11]+J[0]-J[1]-J[2]-J[3]-J[4]-J[5]+J[6]-J[7]+J[8]-J[9]-J[10]-J[11]-J[12]-J[13]-J[14]-J[15]+
    J[16]-J[17]+J[18]-J[19]-J[20]+J[21]+J[22]+J[23]+J[24]-J[25]+J[26]-J[27]+J[28]+J[29]+J[30]+J[31]+J[32]-J[33]+
    J[34]-J[35]+J[36]+J[37]+J[38]+J[39]-J[40]+J[41]-J[42]+J[43]+J[44]+J[45]-J[46]+J[47]-J[48]+J[49]+J[50]-J[51]+
    J[52]-J[53]+J[54]+J[55]-J[56]+J[57]-J[58]-J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]+H[1]-H[2]-H[3]-H[4]-H[5]-H[6]+
    H[7]-H[8]-H[9]+H[10]+H[11]+J[0]-J[1]-J[2]-J[3]-J[4]-J[5]+J[6]-J[7]-J[8]+J[9]+J[10]-J[11]-J[12]-J[13]-J[14]-J[15]+
    J[16]-J[17]-J[18]+J[19]+J[20]+J[21]+J[22]+J[23]+J[24]-J[25]+J[26]+J[27]-J[28]-J[29]+J[30]+J[31]+J[32]-J[33]+
    J[34]+J[35]-J[36]-J[37]+J[38]+J[39]-J[40]+J[41]+J[42]-J[43]-J[44]+J[45]-J[46]+J[47]+J[48]-J[49]-J[50]-J[51]+
    J[52]+J[53]-J[54]-J[55]-J[56]-J[57]+J[58]+J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]+H[1]-H[2]-H[3]-H[4]-H[5]-H[6]+
    H[7]-H[8]-H[9]+H[10]-H[11]+J[0]-J[1]-J[2]-J[3]-J[4]-J[5]+J[6]-J[7]-J[8]+J[9]-J[10]-J[11]-J[12]-J[13]-J[14]-J[15]+
    J[16]-J[17]-J[18]+J[19]-J[20]+J[21]+J[22]+J[23]+J[24]-J[25]+J[26]+J[27]-J[28]+J[29]+J[30]+J[31]+J[32]-J[33]+
    J[34]+J[35]-J[36]+J[37]+J[38]+J[39]-J[40]+J[41]+J[42]-J[43]+J[44]+J[45]-J[46]+J[47]+J[48]-J[49]+J[50]-J[51]+
    J[52]+J[53]-J[54]+J[55]-J[56]-J[57]+J[58]-J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]+H[1]-H[2]-H[3]-H[4]-H[5]-H[6]+
    H[7]-H[8]-H[9]-H[10]+H[11]+J[0]-J[1]-J[2]-J[3]-J[4]-J[5]+J[6]-J[7]-J[8]-J[9]+J[10]-J[11]-J[12]-J[13]-J[14]-J[15]+
    J[16]-J[17]-J[18]-J[19]+J[20]+J[21]+J[22]+J[23]+J[24]-J[25]+J[26]+J[27]+J[28]-J[29]+J[30]+J[31]+J[32]-J[33]+
    J[34]+J[35]+J[36]-J[37]+J[38]+J[39]-J[40]+J[41]+J[42]+J[43]-J[44]+J[45]-J[46]+J[47]+J[48]+J[49]-J[50]-J[51]+
    J[52]+J[53]+J[54]-J[55]-J[56]-J[57]-J[58]+J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]+H[1]-H[2]-H[3]-H[4]-H[5]-H[6]+
    H[7]-H[8]-H[9]-H[10]-H[11]+J[0]-J[1]-J[2]-J[3]-J[4]-J[5]+J[6]-J[7]-J[8]-J[9]-J[10]-J[11]-J[12]-J[13]-J[14]-J[15]+
    J[16]-J[17]-J[18]-J[19]-J[20]+J[21]+J[22]+J[23]+J[24]-J[25]+J[26]+J[27]+J[28]+J[29]+J[30]+J[31]+J[32]-J[33]+
    J[34]+J[35]+J[36]+J[37]+J[38]+J[39]-J[40]+J[41]+J[42]+J[43]+J[44]+J[45]-J[46]+J[47]+J[48]+J[49]+J[50]-J[51]+
    J[52]+J[53]+J[54]+J[55]-J[56]-J[57]-J[58]-J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]+H[1]-H[2]-H[3]-H[4]-H[5]-H[6]-H[7]+
    H[8]+H[9]+H[10]+H[11]+J[0]-J[1]-J[2]-J[3]-J[4]-J[5]-J[6]+J[7]+J[8]+J[9]+J[10]-J[11]-J[12]-J[13]-J[14]-J[15]-J[16]+
    J[17]+J[18]+J[19]+J[20]+J[21]+J[22]+J[23]+J[24]+J[25]-J[26]-J[27]-J[28]-J[29]+J[30]+J[31]+J[32]+J[33]-J[34]-J[35]-J[36]-J[37]+
    J[38]+J[39]+J[40]-J[41]-J[42]-J[43]-J[44]+J[45]+J[46]-J[47]-J[48]-J[49]-J[50]+J[51]-J[52]-J[53]-J[54]-J[55]-J[56]-J[57]-J[58]-J[59]+
    J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]+H[1]-H[2]-H[3]-H[4]-H[5]-H[6]-H[7]+H[8]+H[9]+H[10]-H[11]+
    J[0]-J[1]-J[2]-J[3]-J[4]-J[5]-J[6]+J[7]+J[8]+J[9]-J[10]-J[11]-J[12]-J[13]-J[14]-J[15]-J[16]+J[17]+J[18]+
    J[19]-J[20]+J[21]+J[22]+J[23]+J[24]+J[25]-J[26]-J[27]-J[28]+J[29]+J[30]+J[31]+J[32]+J[33]-J[34]-J[35]-J[36]+
    J[37]+J[38]+J[39]+J[40]-J[41]-J[42]-J[43]+J[44]+J[45]+J[46]-J[47]-J[48]-J[49]+J[50]+J[51]-J[52]-J[53]-J[54]+
    J[55]-J[56]-J[57]-J[58]+J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]+H[1]-H[2]-H[3]-H[4]-H[5]-H[6]-H[7]+
    H[8]+H[9]-H[10]+H[11]+J[0]-J[1]-J[2]-J[3]-J[4]-J[5]-J[6]+J[7]+J[8]-J[9]+J[10]-J[11]-J[12]-J[13]-J[14]-J[15]-J[16]+
    J[17]+J[18]-J[19]+J[20]+J[21]+J[22]+J[23]+J[24]+J[25]-J[26]-J[27]+J[28]-J[29]+J[30]+J[31]+J[32]+J[33]-J[34]-J[35]+
    J[36]-J[37]+J[38]+J[39]+J[40]-J[41]-J[42]+J[43]-J[44]+J[45]+J[46]-J[47]-J[48]+J[49]-J[50]+J[51]-J[52]-J[53]+
    J[54]-J[55]-J[56]-J[57]+J[58]-J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]+H[1]-H[2]-H[3]-H[4]-H[5]-H[6]-H[7]+
    H[8]+H[9]-H[10]-H[11]+J[0]-J[1]-J[2]-J[3]-J[4]-J[5]-J[6]+J[7]+J[8]-J[9]-J[10]-J[11]-J[12]-J[13]-J[14]-J[15]-J[16]+
    J[17]+J[18]-J[19]-J[20]+J[21]+J[22]+J[23]+J[24]+J[25]-J[26]-J[27]+J[28]+J[29]+J[30]+J[31]+J[32]+J[33]-J[34]-J[35]+
    J[36]+J[37]+J[38]+J[39]+J[40]-J[41]-J[42]+J[43]+J[44]+J[45]+J[46]-J[47]-J[48]+J[49]+J[50]+J[51]-J[52]-J[53]+
    J[54]+J[55]-J[56]-J[57]+J[58]+J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]+H[1]-H[2]-H[3]-H[4]-H[5]-H[6]-H[7]+
    H[8]-H[9]+H[10]+H[11]+J[0]-J[1]-J[2]-J[3]-J[4]-J[5]-J[6]+J[7]-J[8]+J[9]+J[10]-J[11]-J[12]-J[13]-J[14]-J[15]-J[16]+
    J[17]-J[18]+J[19]+J[20]+J[21]+J[22]+J[23]+J[24]+J[25]-J[26]+J[27]-J[28]-J[29]+J[30]+J[31]+J[32]+J[33]-J[34]+
    J[35]-J[36]-J[37]+J[38]+J[39]+J[40]-J[41]+J[42]-J[43]-J[44]+J[45]+J[46]-J[47]+J[48]-J[49]-J[50]+J[51]-J[52]+
    J[53]-J[54]-J[55]-J[56]+J[57]-J[58]-J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]+H[1]-H[2]-H[3]-H[4]-H[5]-H[6]-H[7]+
    H[8]-H[9]+H[10]-H[11]+J[0]-J[1]-J[2]-J[3]-J[4]-J[5]-J[6]+J[7]-J[8]+J[9]-J[10]-J[11]-J[12]-J[13]-J[14]-J[15]-J[16]+
    J[17]-J[18]+J[19]-J[20]+J[21]+J[22]+J[23]+J[24]+J[25]-J[26]+J[27]-J[28]+J[29]+J[30]+J[31]+J[32]+J[33]-J[34]+
    J[35]-J[36]+J[37]+J[38]+J[39]+J[40]-J[41]+J[42]-J[43]+J[44]+J[45]+J[46]-J[47]+J[48]-J[49]+J[50]+J[51]-J[52]+
    J[53]-J[54]+J[55]-J[56]+J[57]-J[58]+J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]+H[1]-H[2]-H[3]-H[4]-H[5]-H[6]-H[7]+
    H[8]-H[9]-H[10]+H[11]+J[0]-J[1]-J[2]-J[3]-J[4]-J[5]-J[6]+J[7]-J[8]-J[9]+J[10]-J[11]-J[12]-J[13]-J[14]-J[15]-J[16]+
    J[17]-J[18]-J[19]+J[20]+J[21]+J[22]+J[23]+J[24]+J[25]-J[26]+J[27]+J[28]-J[29]+J[30]+J[31]+J[32]+J[33]-J[34]+
    J[35]+J[36]-J[37]+J[38]+J[39]+J[40]-J[41]+J[42]+J[43]-J[44]+J[45]+J[46]-J[47]+J[48]+J[49]-J[50]+J[51]-J[52]+
    J[53]+J[54]-J[55]-J[56]+J[57]+J[58]-J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]+H[1]-H[2]-H[3]-H[4]-H[5]-H[6]-H[7]+
    H[8]-H[9]-H[10]-H[11]+J[0]-J[1]-J[2]-J[3]-J[4]-J[5]-J[6]+J[7]-J[8]-J[9]-J[10]-J[11]-J[12]-J[13]-J[14]-J[15]-J[16]+
    J[17]-J[18]-J[19]-J[20]+J[21]+J[22]+J[23]+J[24]+J[25]-J[26]+J[27]+J[28]+J[29]+J[30]+J[31]+J[32]+J[33]-J[34]+
    J[35]+J[36]+J[37]+J[38]+J[39]+J[40]-J[41]+J[42]+J[43]+J[44]+J[45]+J[46]-J[47]+J[48]+J[49]+J[50]+J[51]-J[52]+
    J[53]+J[54]+J[55]-J[56]+J[57]+J[58]+J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]+H[1]-H[2]-H[3]-H[4]-H[5]-H[6]-H[7]-H[8]+
    H[9]+H[10]+H[11]+J[0]-J[1]-J[2]-J[3]-J[4]-J[5]-J[6]-J[7]+J[8]+J[9]+J[10]-J[11]-J[12]-J[13]-J[14]-J[15]-J[16]-J[17]+
    J[18]+J[19]+J[20]+J[21]+J[22]+J[23]+J[24]+J[25]+J[26]-J[27]-J[28]-J[29]+J[30]+J[31]+J[32]+J[33]+J[34]-J[35]-J[36]-J[37]+
    J[38]+J[39]+J[40]+J[41]-J[42]-J[43]-J[44]+J[45]+J[46]+J[47]-J[48]-J[49]-J[50]+J[51]+J[52]-J[53]-J[54]-J[55]+
    J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]+H[1]-H[2]-H[3]-H[4]-H[5]-H[6]-H[7]-H[8]+
    H[9]+H[10]-H[11]+J[0]-J[1]-J[2]-J[3]-J[4]-J[5]-J[6]-J[7]+J[8]+J[9]-J[10]-J[11]-J[12]-J[13]-J[14]-J[15]-J[16]-J[17]+
    J[18]+J[19]-J[20]+J[21]+J[22]+J[23]+J[24]+J[25]+J[26]-J[27]-J[28]+J[29]+J[30]+J[31]+J[32]+J[33]+J[34]-J[35]-J[36]+
    J[37]+J[38]+J[39]+J[40]+J[41]-J[42]-J[43]+J[44]+J[45]+J[46]+J[47]-J[48]-J[49]+J[50]+J[51]+J[52]-J[53]-J[54]+
    J[55]+J[56]-J[57]-J[58]+J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]+H[1]-H[2]-H[3]-H[4]-H[5]-H[6]-H[7]-H[8]+
    H[9]-H[10]+H[11]+J[0]-J[1]-J[2]-J[3]-J[4]-J[5]-J[6]-J[7]+J[8]-J[9]+J[10]-J[11]-J[12]-J[13]-J[14]-J[15]-J[16]-J[17]+
    J[18]-J[19]+J[20]+J[21]+J[22]+J[23]+J[24]+J[25]+J[26]-J[27]+J[28]-J[29]+J[30]+J[31]+J[32]+J[33]+J[34]-J[35]+
    J[36]-J[37]+J[38]+J[39]+J[40]+J[41]-J[42]+J[43]-J[44]+J[45]+J[46]+J[47]-J[48]+J[49]-J[50]+J[51]+J[52]-J[53]+
    J[54]-J[55]+J[56]-J[57]+J[58]-J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]+H[1]-H[2]-H[3]-H[4]-H[5]-H[6]-H[7]-H[8]+
    H[9]-H[10]-H[11]+J[0]-J[1]-J[2]-J[3]-J[4]-J[5]-J[6]-J[7]+J[8]-J[9]-J[10]-J[11]-J[12]-J[13]-J[14]-J[15]-J[16]-J[17]+
    J[18]-J[19]-J[20]+J[21]+J[22]+J[23]+J[24]+J[25]+J[26]-J[27]+J[28]+J[29]+J[30]+J[31]+J[32]+J[33]+J[34]-J[35]+
    J[36]+J[37]+J[38]+J[39]+J[40]+J[41]-J[42]+J[43]+J[44]+J[45]+J[46]+J[47]-J[48]+J[49]+J[50]+J[51]+J[52]-J[53]+
    J[54]+J[55]+J[56]-J[57]+J[58]+J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]+H[1]-H[2]-H[3]-H[4]-H[5]-H[6]-H[7]-H[8]-H[9]+
    H[10]+H[11]+J[0]-J[1]-J[2]-J[3]-J[4]-J[5]-J[6]-J[7]-J[8]+J[9]+J[10]-J[11]-J[12]-J[13]-J[14]-J[15]-J[16]-J[17]-J[18]+
    J[19]+J[20]+J[21]+J[22]+J[23]+J[24]+J[25]+J[26]+J[27]-J[28]-J[29]+J[30]+J[31]+J[32]+J[33]+J[34]+J[35]-J[36]-J[37]+
    J[38]+J[39]+J[40]+J[41]+J[42]-J[43]-J[44]+J[45]+J[46]+J[47]+J[48]-J[49]-J[50]+J[51]+J[52]+J[53]-J[54]-J[55]+
    J[56]+J[57]-J[58]-J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]+H[1]-H[2]-H[3]-H[4]-H[5]-H[6]-H[7]-H[8]-H[9]+
    H[10]-H[11]+J[0]-J[1]-J[2]-J[3]-J[4]-J[5]-J[6]-J[7]-J[8]+J[9]-J[10]-J[11]-J[12]-J[13]-J[14]-J[15]-J[16]-J[17]-J[18]+
    J[19]-J[20]+J[21]+J[22]+J[23]+J[24]+J[25]+J[26]+J[27]-J[28]+J[29]+J[30]+J[31]+J[32]+J[33]+J[34]+J[35]-J[36]+
    J[37]+J[38]+J[39]+J[40]+J[41]+J[42]-J[43]+J[44]+J[45]+J[46]+J[47]+J[48]-J[49]+J[50]+J[51]+J[52]+J[53]-J[54]+
    J[55]+J[56]+J[57]-J[58]+J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]+H[1]-H[2]-H[3]-H[4]-H[5]-H[6]-H[7]-H[8]-H[9]-H[10]+
    H[11]+J[0]-J[1]-J[2]-J[3]-J[4]-J[5]-J[6]-J[7]-J[8]-J[9]+J[10]-J[11]-J[12]-J[13]-J[14]-J[15]-J[16]-J[17]-J[18]-J[19]+
    J[20]+J[21]+J[22]+J[23]+J[24]+J[25]+J[26]+J[27]+J[28]-J[29]+J[30]+J[31]+J[32]+J[33]+J[34]+J[35]+J[36]-J[37]+
    J[38]+J[39]+J[40]+J[41]+J[42]+J[43]-J[44]+J[45]+J[46]+J[47]+J[48]+J[49]-J[50]+J[51]+J[52]+J[53]+J[54]-J[55]+
    J[56]+J[57]+J[58]-J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]+H[1]-H[2]-H[3]-H[4]-H[5]-H[6]-H[7]-H[8]-H[9]-H[10]-H[11]+
    J[0]-J[1]-J[2]-J[3]-J[4]-J[5]-J[6]-J[7]-J[8]-J[9]-J[10]-J[11]-J[12]-J[13]-J[14]-J[15]-J[16]-J[17]-J[18]-J[19]-J[20]+
    J[21]+J[22]+J[23]+J[24]+J[25]+J[26]+J[27]+J[28]+J[29]+J[30]+J[31]+J[32]+J[33]+J[34]+J[35]+J[36]+J[37]+
    J[38]+J[39]+J[40]+J[41]+J[42]+J[43]+J[44]+J[45]+J[46]+J[47]+J[48]+J[49]+J[50]+J[51]+J[52]+J[53]+J[54]+
    J[55]+J[56]+J[57]+J[58]+J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]-H[1]+H[2]+H[3]+H[4]+H[5]+H[6]+
    H[7]+H[8]+H[9]+H[10]+H[11]-J[0]+J[1]+J[2]+J[3]+J[4]+J[5]+J[6]+J[7]+J[8]+J[9]+J[10]-J[11]-J[12]-J[13]-J[14]-J[15]-J[16]-J[17]-J[18]-J[19]-J[20]+
    J[21]+J[22]+J[23]+J[24]+J[25]+J[26]+J[27]+J[28]+J[29]+J[30]+J[31]+J[32]+J[33]+J[34]+J[35]+J[36]+J[37]+
    J[38]+J[39]+J[40]+J[41]+J[42]+J[43]+J[44]+J[45]+J[46]+J[47]+J[48]+J[49]+J[50]+J[51]+J[52]+J[53]+J[54]+
    J[55]+J[56]+J[57]+J[58]+J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]-H[1]+H[2]+H[3]+H[4]+H[5]+H[6]+
    H[7]+H[8]+H[9]+H[10]-H[11]-J[0]+J[1]+J[2]+J[3]+J[4]+J[5]+J[6]+J[7]+J[8]+J[9]-J[10]-J[11]-J[12]-J[13]-J[14]-J[15]-J[16]-J[17]-J[18]-J[19]+
    J[20]+J[21]+J[22]+J[23]+J[24]+J[25]+J[26]+J[27]+J[28]-J[29]+J[30]+J[31]+J[32]+J[33]+J[34]+J[35]+J[36]-J[37]+
    J[38]+J[39]+J[40]+J[41]+J[42]+J[43]-J[44]+J[45]+J[46]+J[47]+J[48]+J[49]-J[50]+J[51]+J[52]+J[53]+J[54]-J[55]+
    J[56]+J[57]+J[58]-J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]-H[1]+H[2]+H[3]+H[4]+H[5]+H[6]+H[7]+
    H[8]+H[9]-H[10]+H[11]-J[0]+J[1]+J[2]+J[3]+J[4]+J[5]+J[6]+J[7]+J[8]-J[9]+J[10]-J[11]-J[12]-J[13]-J[14]-J[15]-J[16]-J[17]-J[18]+
    J[19]-J[20]+J[21]+J[22]+J[23]+J[24]+J[25]+J[26]+J[27]-J[28]+J[29]+J[30]+J[31]+J[32]+J[33]+J[34]+J[35]-J[36]+
    J[37]+J[38]+J[39]+J[40]+J[41]+J[42]-J[43]+J[44]+J[45]+J[46]+J[47]+J[48]-J[49]+J[50]+J[51]+J[52]+J[53]-J[54]+
    J[55]+J[56]+J[57]-J[58]+J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]-H[1]+H[2]+H[3]+H[4]+H[5]+H[6]+
    H[7]+H[8]+H[9]-H[10]-H[11]-J[0]+J[1]+J[2]+J[3]+J[4]+J[5]+J[6]+J[7]+J[8]-J[9]-J[10]-J[11]-J[12]-J[13]-J[14]-J[15]-J[16]-J[17]-J[18]+
    J[19]+J[20]+J[21]+J[22]+J[23]+J[24]+J[25]+J[26]+J[27]-J[28]-J[29]+J[30]+J[31]+J[32]+J[33]+J[34]+J[35]-J[36]-J[37]+
    J[38]+J[39]+J[40]+J[41]+J[42]-J[43]-J[44]+J[45]+J[46]+J[47]+J[48]-J[49]-J[50]+J[51]+J[52]+J[53]-J[54]-J[55]+
    J[56]+J[57]-J[58]-J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]-H[1]+H[2]+H[3]+H[4]+H[5]+H[6]+H[7]+
    H[8]-H[9]+H[10]+H[11]-J[0]+J[1]+J[2]+J[3]+J[4]+J[5]+J[6]+J[7]-J[8]+J[9]+J[10]-J[11]-J[12]-J[13]-J[14]-J[15]-J[16]-J[17]+
    J[18]-J[19]-J[20]+J[21]+J[22]+J[23]+J[24]+J[25]+J[26]-J[27]+J[28]+J[29]+J[30]+J[31]+J[32]+J[33]+J[34]-J[35]+
    J[36]+J[37]+J[38]+J[39]+J[40]+J[41]-J[42]+J[43]+J[44]+J[45]+J[46]+J[47]-J[48]+J[49]+J[50]+J[51]+J[52]-J[53]+
    J[54]+J[55]+J[56]-J[57]+J[58]+J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]-H[1]+H[2]+H[3]+H[4]+H[5]+
    H[6]+H[7]+H[8]-H[9]+H[10]-H[11]-J[0]+J[1]+J[2]+J[3]+J[4]+J[5]+J[6]+J[7]-J[8]+J[9]-J[10]-J[11]-J[12]-J[13]-J[14]-J[15]-J[16]-J[17]+
    J[18]-J[19]+J[20]+J[21]+J[22]+J[23]+J[24]+J[25]+J[26]-J[27]+J[28]-J[29]+J[30]+J[31]+J[32]+J[33]+J[34]-J[35]+
    J[36]-J[37]+J[38]+J[39]+J[40]+J[41]-J[42]+J[43]-J[44]+J[45]+J[46]+J[47]-J[48]+J[49]-J[50]+J[51]+J[52]-J[53]+
    J[54]-J[55]+J[56]-J[57]+J[58]-J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]-H[1]+H[2]+H[3]+H[4]+H[5]+
    H[6]+H[7]+H[8]-H[9]-H[10]+H[11]-J[0]+J[1]+J[2]+J[3]+J[4]+J[5]+J[6]+J[7]-J[8]-J[9]+J[10]-J[11]-J[12]-J[13]-J[14]-J[15]-J[16]-J[17]+
    J[18]+J[19]-J[20]+J[21]+J[22]+J[23]+J[24]+J[25]+J[26]-J[27]-J[28]+J[29]+J[30]+J[31]+J[32]+J[33]+J[34]-J[35]-J[36]+
    J[37]+J[38]+J[39]+J[40]+J[41]-J[42]-J[43]+J[44]+J[45]+J[46]+J[47]-J[48]-J[49]+J[50]+J[51]+J[52]-J[53]-J[54]+
    J[55]+J[56]-J[57]-J[58]+J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]-H[1]+H[2]+H[3]+H[4]+H[5]+H[6]+
    H[7]+H[8]-H[9]-H[10]-H[11]-J[0]+J[1]+J[2]+J[3]+J[4]+J[5]+J[6]+J[7]-J[8]-J[9]-J[10]-J[11]-J[12]-J[13]-J[14]-J[15]-J[16]-J[17]+
    J[18]+J[19]+J[20]+J[21]+J[22]+J[23]+J[24]+J[25]+J[26]-J[27]-J[28]-J[29]+J[30]+J[31]+J[32]+J[33]+J[34]-J[35]-J[36]-J[37]+
    J[38]+J[39]+J[40]+J[41]-J[42]-J[43]-J[44]+J[45]+J[46]+J[47]-J[48]-J[49]-J[50]+J[51]+J[52]-J[53]-J[54]-J[55]+
    J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]-H[1]+H[2]+H[3]+H[4]+H[5]+H[6]+H[7]-H[8]+
    H[9]+H[10]+H[11]-J[0]+J[1]+J[2]+J[3]+J[4]+J[5]+J[6]-J[7]+J[8]+J[9]+J[10]-J[11]-J[12]-J[13]-J[14]-J[15]-J[16]+
    J[17]-J[18]-J[19]-J[20]+J[21]+J[22]+J[23]+J[24]+J[25]-J[26]+J[27]+J[28]+J[29]+J[30]+J[31]+J[32]+J[33]-J[34]+
    J[35]+J[36]+J[37]+J[38]+J[39]+J[40]-J[41]+J[42]+J[43]+J[44]+J[45]+J[46]-J[47]+J[48]+J[49]+J[50]+J[51]-J[52]+
    J[53]+J[54]+J[55]-J[56]+J[57]+J[58]+J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]-H[1]+H[2]+H[3]+
    H[4]+H[5]+H[6]+H[7]-H[8]+H[9]+H[10]-H[11]-J[0]+J[1]+J[2]+J[3]+J[4]+J[5]+J[6]-J[7]+J[8]+J[9]-J[10]-J[11]-J[12]-J[13]-J[14]-J[15]-J[16]+
    J[17]-J[18]-J[19]+J[20]+J[21]+J[22]+J[23]+J[24]+J[25]-J[26]+J[27]+J[28]-J[29]+J[30]+J[31]+J[32]+J[33]-J[34]+
    J[35]+J[36]-J[37]+J[38]+J[39]+J[40]-J[41]+J[42]+J[43]-J[44]+J[45]+J[46]-J[47]+J[48]+J[49]-J[50]+J[51]-J[52]+
    J[53]+J[54]-J[55]-J[56]+J[57]+J[58]-J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]-H[1]+H[2]+H[3]+
    H[4]+H[5]+H[6]+H[7]-H[8]+H[9]-H[10]+H[11]-J[0]+J[1]+J[2]+J[3]+J[4]+J[5]+J[6]-J[7]+J[8]-J[9]+J[10]-J[11]-J[12]-J[13]-J[14]-J[15]-J[16]+
    J[17]-J[18]+J[19]-J[20]+J[21]+J[22]+J[23]+J[24]+J[25]-J[26]+J[27]-J[28]+J[29]+J[30]+J[31]+J[32]+J[33]-J[34]+
    J[35]-J[36]+J[37]+J[38]+J[39]+J[40]-J[41]+J[42]-J[43]+J[44]+J[45]+J[46]-J[47]+J[48]-J[49]+J[50]+J[51]-J[52]+
    J[53]-J[54]+J[55]-J[56]+J[57]-J[58]+J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]-H[1]+H[2]+H[3]+
    H[4]+H[5]+H[6]+H[7]-H[8]+H[9]-H[10]-H[11]-J[0]+J[1]+J[2]+J[3]+J[4]+J[5]+J[6]-J[7]+J[8]-J[9]-J[10]-J[11]-J[12]-J[13]-J[14]-J[15]-J[16]+
    J[17]-J[18]+J[19]+J[20]+J[21]+J[22]+J[23]+J[24]+J[25]-J[26]+J[27]-J[28]-J[29]+J[30]+J[31]+J[32]+J[33]-J[34]+
    J[35]-J[36]-J[37]+J[38]+J[39]+J[40]-J[41]+J[42]-J[43]-J[44]+J[45]+J[46]-J[47]+J[48]-J[49]-J[50]+J[51]-J[52]+
    J[53]-J[54]-J[55]-J[56]+J[57]-J[58]-J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]-H[1]+H[2]+H[3]+
    H[4]+H[5]+H[6]+H[7]-H[8]-H[9]+H[10]+H[11]-J[0]+J[1]+J[2]+J[3]+J[4]+J[5]+J[6]-J[7]-J[8]+J[9]+J[10]-J[11]-J[12]-J[13]-J[14]-J[15]-J[16]+
    J[17]+J[18]-J[19]-J[20]+J[21]+J[22]+J[23]+J[24]+J[25]-J[26]-J[27]+J[28]+J[29]+J[30]+J[31]+J[32]+J[33]-J[34]-J[35]+
    J[36]+J[37]+J[38]+J[39]+J[40]-J[41]-J[42]+J[43]+J[44]+J[45]+J[46]-J[47]-J[48]+J[49]+J[50]+J[51]-J[52]-J[53]+
    J[54]+J[55]-J[56]-J[57]+J[58]+J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]-H[1]+H[2]+H[3]+H[4]+H[5]+
    H[6]+H[7]-H[8]-H[9]+H[10]-H[11]-J[0]+J[1]+J[2]+J[3]+J[4]+J[5]+J[6]-J[7]-J[8]+J[9]-J[10]-J[11]-J[12]-J[13]-J[14]-J[15]-J[16]+
    J[17]+J[18]-J[19]+J[20]+J[21]+J[22]+J[23]+J[24]+J[25]-J[26]-J[27]+J[28]-J[29]+J[30]+J[31]+J[32]+J[33]-J[34]-J[35]+
    J[36]-J[37]+J[38]+J[39]+J[40]-J[41]-J[42]+J[43]-J[44]+J[45]+J[46]-J[47]-J[48]+J[49]-J[50]+J[51]-J[52]-J[53]+
    J[54]-J[55]-J[56]-J[57]+J[58]-J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]-H[1]+H[2]+H[3]+H[4]+H[5]+
    H[6]+H[7]-H[8]-H[9]-H[10]+H[11]-J[0]+J[1]+J[2]+J[3]+J[4]+J[5]+J[6]-J[7]-J[8]-J[9]+J[10]-J[11]-J[12]-J[13]-J[14]-J[15]-J[16]+
    J[17]+J[18]+J[19]-J[20]+J[21]+J[22]+J[23]+J[24]+J[25]-J[26]-J[27]-J[28]+J[29]+J[30]+J[31]+J[32]+J[33]-J[34]-J[35]-J[36]+
    J[37]+J[38]+J[39]+J[40]-J[41]-J[42]-J[43]+J[44]+J[45]+J[46]-J[47]-J[48]-J[49]+J[50]+J[51]-J[52]-J[53]-J[54]+
    J[55]-J[56]-J[57]-J[58]+J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]-H[1]+H[2]+H[3]+H[4]+H[5]+H[6]+
    H[7]-H[8]-H[9]-H[10]-H[11]-J[0]+J[1]+J[2]+J[3]+J[4]+J[5]+J[6]-J[7]-J[8]-J[9]-J[10]-J[11]-J[12]-J[13]-J[14]-J[15]-J[16]+
    J[17]+J[18]+J[19]+J[20]+J[21]+J[22]+J[23]+J[24]+J[25]-J[26]-J[27]-J[28]-J[29]+J[30]+J[31]+J[32]+J[33]-J[34]-J[35]-J[36]-J[37]+
    J[38]+J[39]+J[40]-J[41]-J[42]-J[43]-J[44]+J[45]+J[46]-J[47]-J[48]-J[49]-J[50]+J[51]-J[52]-J[53]-J[54]-J[55]-J[56]-J[57]-J[58]-J[59]+
    J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]-H[1]+H[2]+H[3]+H[4]+H[5]+H[6]-H[7]+H[8]+H[9]+H[10]+H[11]-J[0]+
    J[1]+J[2]+J[3]+J[4]+J[5]-J[6]+J[7]+J[8]+J[9]+J[10]-J[11]-J[12]-J[13]-J[14]-J[15]+J[16]-J[17]-J[18]-J[19]-J[20]+
    J[21]+J[22]+J[23]+J[24]-J[25]+J[26]+J[27]+J[28]+J[29]+J[30]+J[31]+J[32]-J[33]+J[34]+J[35]+J[36]+J[37]+
    J[38]+J[39]-J[40]+J[41]+J[42]+J[43]+J[44]+J[45]-J[46]+J[47]+J[48]+J[49]+J[50]-J[51]+J[52]+J[53]+J[54]+
    J[55]-J[56]-J[57]-J[58]-J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]-H[1]+H[2]+H[3]+H[4]+H[5]+H[6]-H[7]+
    H[8]+H[9]+H[10]-H[11]-J[0]+J[1]+J[2]+J[3]+J[4]+J[5]-J[6]+J[7]+J[8]+J[9]-J[10]-J[11]-J[12]-J[13]-J[14]-J[15]+
    J[16]-J[17]-J[18]-J[19]+J[20]+J[21]+J[22]+J[23]+J[24]-J[25]+J[26]+J[27]+J[28]-J[29]+J[30]+J[31]+J[32]-J[33]+
    J[34]+J[35]+J[36]-J[37]+J[38]+J[39]-J[40]+J[41]+J[42]+J[43]-J[44]+J[45]-J[46]+J[47]+J[48]+J[49]-J[50]-J[51]+
    J[52]+J[53]+J[54]-J[55]-J[56]-J[57]-J[58]+J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]-H[1]+H[2]+
    H[3]+H[4]+H[5]+H[6]-H[7]+H[8]+H[9]-H[10]+H[11]-J[0]+J[1]+J[2]+J[3]+J[4]+J[5]-J[6]+J[7]+J[8]-J[9]+J[10]-J[11]-J[12]-J[13]-J[14]-J[15]+
    J[16]-J[17]-J[18]+J[19]-J[20]+J[21]+J[22]+J[23]+J[24]-J[25]+J[26]+J[27]-J[28]+J[29]+J[30]+J[31]+J[32]-J[33]+
    J[34]+J[35]-J[36]+J[37]+J[38]+J[39]-J[40]+J[41]+J[42]-J[43]+J[44]+J[45]-J[46]+J[47]+J[48]-J[49]+J[50]-J[51]+
    J[52]+J[53]-J[54]+J[55]-J[56]-J[57]+J[58]-J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]-H[1]+H[2]+
    H[3]+H[4]+H[5]+H[6]-H[7]+H[8]+H[9]-H[10]-H[11]-J[0]+J[1]+J[2]+J[3]+J[4]+J[5]-J[6]+J[7]+J[8]-J[9]-J[10]-J[11]-J[12]-J[13]-J[14]-J[15]+
    J[16]-J[17]-J[18]+J[19]+J[20]+J[21]+J[22]+J[23]+J[24]-J[25]+J[26]+J[27]-J[28]-J[29]+J[30]+J[31]+J[32]-J[33]+
    J[34]+J[35]-J[36]-J[37]+J[38]+J[39]-J[40]+J[41]+J[42]-J[43]-J[44]+J[45]-J[46]+J[47]+J[48]-J[49]-J[50]-J[51]+
    J[52]+J[53]-J[54]-J[55]-J[56]-J[57]+J[58]+J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]-H[1]+H[2]+
    H[3]+H[4]+H[5]+H[6]-H[7]+H[8]-H[9]+H[10]+H[11]-J[0]+J[1]+J[2]+J[3]+J[4]+J[5]-J[6]+J[7]-J[8]+J[9]+J[10]-J[11]-J[12]-J[13]-J[14]-J[15]+
    J[16]-J[17]+J[18]-J[19]-J[20]+J[21]+J[22]+J[23]+J[24]-J[25]+J[26]-J[27]+J[28]+J[29]+J[30]+J[31]+J[32]-J[33]+
    J[34]-J[35]+J[36]+J[37]+J[38]+J[39]-J[40]+J[41]-J[42]+J[43]+J[44]+J[45]-J[46]+J[47]-J[48]+J[49]+J[50]-J[51]+
    J[52]-J[53]+J[54]+J[55]-J[56]+J[57]-J[58]-J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]-H[1]+H[2]+
    H[3]+H[4]+H[5]+H[6]-H[7]+H[8]-H[9]+H[10]-H[11]-J[0]+J[1]+J[2]+J[3]+J[4]+J[5]-J[6]+J[7]-J[8]+J[9]-J[10]-J[11]-J[12]-J[13]-J[14]-J[15]+
    J[16]-J[17]+J[18]-J[19]+J[20]+J[21]+J[22]+J[23]+J[24]-J[25]+J[26]-J[27]+J[28]-J[29]+J[30]+J[31]+J[32]-J[33]+
    J[34]-J[35]+J[36]-J[37]+J[38]+J[39]-J[40]+J[41]-J[42]+J[43]-J[44]+J[45]-J[46]+J[47]-J[48]+J[49]-J[50]-J[51]+
    J[52]-J[53]+J[54]-J[55]-J[56]+J[57]-J[58]+J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]-H[1]+H[2]+
    H[3]+H[4]+H[5]+H[6]-H[7]+H[8]-H[9]-H[10]+H[11]-J[0]+J[1]+J[2]+J[3]+J[4]+J[5]-J[6]+J[7]-J[8]-J[9]+J[10]-J[11]-J[12]-J[13]-J[14]-J[15]+
    J[16]-J[17]+J[18]+J[19]-J[20]+J[21]+J[22]+J[23]+J[24]-J[25]+J[26]-J[27]-J[28]+J[29]+J[30]+J[31]+J[32]-J[33]+
    J[34]-J[35]-J[36]+J[37]+J[38]+J[39]-J[40]+J[41]-J[42]-J[43]+J[44]+J[45]-J[46]+J[47]-J[48]-J[49]+J[50]-J[51]+
    J[52]-J[53]-J[54]+J[55]-J[56]+J[57]+J[58]-J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]-H[1]+H[2]+
    H[3]+H[4]+H[5]+H[6]-H[7]+H[8]-H[9]-H[10]-H[11]-J[0]+J[1]+J[2]+J[3]+J[4]+J[5]-J[6]+J[7]-J[8]-J[9]-J[10]-J[11]-J[12]-J[13]-J[14]-J[15]+
    J[16]-J[17]+J[18]+J[19]+J[20]+J[21]+J[22]+J[23]+J[24]-J[25]+J[26]-J[27]-J[28]-J[29]+J[30]+J[31]+J[32]-J[33]+
    J[34]-J[35]-J[36]-J[37]+J[38]+J[39]-J[40]+J[41]-J[42]-J[43]-J[44]+J[45]-J[46]+J[47]-J[48]-J[49]-J[50]-J[51]+
    J[52]-J[53]-J[54]-J[55]-J[56]+J[57]+J[58]+J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]-H[1]+H[2]+
    H[3]+H[4]+H[5]+H[6]-H[7]-H[8]+H[9]+H[10]+H[11]-J[0]+J[1]+J[2]+J[3]+J[4]+J[5]-J[6]-J[7]+J[8]+J[9]+J[10]-J[11]-J[12]-J[13]-J[14]-J[15]+
    J[16]+J[17]-J[18]-J[19]-J[20]+J[21]+J[22]+J[23]+J[24]-J[25]-J[26]+J[27]+J[28]+J[29]+J[30]+J[31]+J[32]-J[33]-J[34]+
    J[35]+J[36]+J[37]+J[38]+J[39]-J[40]-J[41]+J[42]+J[43]+J[44]+J[45]-J[46]-J[47]+J[48]+J[49]+J[50]-J[51]-J[52]+
    J[53]+J[54]+J[55]+J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]-H[1]+H[2]+H[3]+
    H[4]+H[5]+H[6]-H[7]-H[8]+H[9]+H[10]-H[11]-J[0]+J[1]+J[2]+J[3]+J[4]+J[5]-J[6]-J[7]+J[8]+J[9]-J[10]-J[11]-J[12]-J[13]-J[14]-J[15]+
    J[16]+J[17]-J[18]-J[19]+J[20]+J[21]+J[22]+J[23]+J[24]-J[25]-J[26]+J[27]+J[28]-J[29]+J[30]+J[31]+J[32]-J[33]-J[34]+
    J[35]+J[36]-J[37]+J[38]+J[39]-J[40]-J[41]+J[42]+J[43]-J[44]+J[45]-J[46]-J[47]+J[48]+J[49]-J[50]-J[51]-J[52]+
    J[53]+J[54]-J[55]+J[56]-J[57]-J[58]+J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]-H[1]+H[2]+H[3]+
    H[4]+H[5]+H[6]-H[7]-H[8]+H[9]-H[10]+H[11]-J[0]+J[1]+J[2]+J[3]+J[4]+J[5]-J[6]-J[7]+J[8]-J[9]+J[10]-J[11]-J[12]-J[13]-J[14]-J[15]+
    J[16]+J[17]-J[18]+J[19]-J[20]+J[21]+J[22]+J[23]+J[24]-J[25]-J[26]+J[27]-J[28]+J[29]+J[30]+J[31]+J[32]-J[33]-J[34]+
    J[35]-J[36]+J[37]+J[38]+J[39]-J[40]-J[41]+J[42]-J[43]+J[44]+J[45]-J[46]-J[47]+J[48]-J[49]+J[50]-J[51]-J[52]+
    J[53]-J[54]+J[55]+J[56]-J[57]+J[58]-J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]-H[1]+H[2]+H[3]+
    H[4]+H[5]+H[6]-H[7]-H[8]+H[9]-H[10]-H[11]-J[0]+J[1]+J[2]+J[3]+J[4]+J[5]-J[6]-J[7]+J[8]-J[9]-J[10]-J[11]-J[12]-J[13]-J[14]-J[15]+
    J[16]+J[17]-J[18]+J[19]+J[20]+J[21]+J[22]+J[23]+J[24]-J[25]-J[26]+J[27]-J[28]-J[29]+J[30]+J[31]+J[32]-J[33]-J[34]+
    J[35]-J[36]-J[37]+J[38]+J[39]-J[40]-J[41]+J[42]-J[43]-J[44]+J[45]-J[46]-J[47]+J[48]-J[49]-J[50]-J[51]-J[52]+
    J[53]-J[54]-J[55]+J[56]-J[57]+J[58]+J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]-H[1]+H[2]+H[3]+
    H[4]+H[5]+H[6]-H[7]-H[8]-H[9]+H[10]+H[11]-J[0]+J[1]+J[2]+J[3]+J[4]+J[5]-J[6]-J[7]-J[8]+J[9]+J[10]-J[11]-J[12]-J[13]-J[14]-J[15]+
    J[16]+J[17]+J[18]-J[19]-J[20]+J[21]+J[22]+J[23]+J[24]-J[25]-J[26]-J[27]+J[28]+J[29]+J[30]+J[31]+J[32]-J[33]-J[34]-J[35]+
    J[36]+J[37]+J[38]+J[39]-J[40]-J[41]-J[42]+J[43]+J[44]+J[45]-J[46]-J[47]-J[48]+J[49]+J[50]-J[51]-J[52]-J[53]+
    J[54]+J[55]+J[56]+J[57]-J[58]-J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]-H[1]+H[2]+H[3]+H[4]+H[5]+
    H[6]-H[7]-H[8]-H[9]+H[10]-H[11]-J[0]+J[1]+J[2]+J[3]+J[4]+J[5]-J[6]-J[7]-J[8]+J[9]-J[10]-J[11]-J[12]-J[13]-J[14]-J[15]+
    J[16]+J[17]+J[18]-J[19]+J[20]+J[21]+J[22]+J[23]+J[24]-J[25]-J[26]-J[27]+J[28]-J[29]+J[30]+J[31]+J[32]-J[33]-J[34]-J[35]+
    J[36]-J[37]+J[38]+J[39]-J[40]-J[41]-J[42]+J[43]-J[44]+J[45]-J[46]-J[47]-J[48]+J[49]-J[50]-J[51]-J[52]-J[53]+
    J[54]-J[55]+J[56]+J[57]-J[58]+J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]-H[1]+H[2]+H[3]+H[4]+H[5]+
    H[6]-H[7]-H[8]-H[9]-H[10]+H[11]-J[0]+J[1]+J[2]+J[3]+J[4]+J[5]-J[6]-J[7]-J[8]-J[9]+J[10]-J[11]-J[12]-J[13]-J[14]-J[15]+
    J[16]+J[17]+J[18]+J[19]-J[20]+J[21]+J[22]+J[23]+J[24]-J[25]-J[26]-J[27]-J[28]+J[29]+J[30]+J[31]+J[32]-J[33]-J[34]-J[35]-J[36]+
    J[37]+J[38]+J[39]-J[40]-J[41]-J[42]-J[43]+J[44]+J[45]-J[46]-J[47]-J[48]-J[49]+J[50]-J[51]-J[52]-J[53]-J[54]+
    J[55]+J[56]+J[57]+J[58]-J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]-H[1]+H[2]+H[3]+H[4]+H[5]+H[6]-H[7]-H[8]-H[9]-H[10]-H[11]-J[0]+
    J[1]+J[2]+J[3]+J[4]+J[5]-J[6]-J[7]-J[8]-J[9]-J[10]-J[11]-J[12]-J[13]-J[14]-J[15]+J[16]+J[17]+J[18]+J[19]+
    J[20]+J[21]+J[22]+J[23]+J[24]-J[25]-J[26]-J[27]-J[28]-J[29]+J[30]+J[31]+J[32]-J[33]-J[34]-J[35]-J[36]-J[37]+
    J[38]+J[39]-J[40]-J[41]-J[42]-J[43]-J[44]+J[45]-J[46]-J[47]-J[48]-J[49]-J[50]-J[51]-J[52]-J[53]-J[54]-J[55]+
    J[56]+J[57]+J[58]+J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]-H[1]+H[2]+H[3]+H[4]+H[5]-H[6]+H[7]+
    H[8]+H[9]+H[10]+H[11]-J[0]+J[1]+J[2]+J[3]+J[4]-J[5]+J[6]+J[7]+J[8]+J[9]+J[10]-J[11]-J[12]-J[13]-J[14]+
    J[15]-J[16]-J[17]-J[18]-J[19]-J[20]+J[21]+J[22]+J[23]-J[24]+J[25]+J[26]+J[27]+J[28]+J[29]+J[30]+J[31]-J[32]+
    J[33]+J[34]+J[35]+J[36]+J[37]+J[38]-J[39]+J[40]+J[41]+J[42]+J[43]+J[44]-J[45]+J[46]+J[47]+J[48]+J[49]+
    J[50]-J[51]-J[52]-J[53]-J[54]-J[55]+J[56]+J[57]+J[58]+J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]-H[1]+
    H[2]+H[3]+H[4]+H[5]-H[6]+H[7]+H[8]+H[9]+H[10]-H[11]-J[0]+J[1]+J[2]+J[3]+J[4]-J[5]+J[6]+J[7]+J[8]+J[9]-J[10]-J[11]-J[12]-J[13]-J[14]+
    J[15]-J[16]-J[17]-J[18]-J[19]+J[20]+J[21]+J[22]+J[23]-J[24]+J[25]+J[26]+J[27]+J[28]-J[29]+J[30]+J[31]-J[32]+
    J[33]+J[34]+J[35]+J[36]-J[37]+J[38]-J[39]+J[40]+J[41]+J[42]+J[43]-J[44]-J[45]+J[46]+J[47]+J[48]+J[49]-J[50]-J[51]-J[52]-J[53]-J[54]+
    J[55]+J[56]+J[57]+J[58]-J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]-H[1]+H[2]+H[3]+H[4]+H[5]-H[6]+
    H[7]+H[8]+H[9]-H[10]+H[11]-J[0]+J[1]+J[2]+J[3]+J[4]-J[5]+J[6]+J[7]+J[8]-J[9]+J[10]-J[11]-J[12]-J[13]-J[14]+
    J[15]-J[16]-J[17]-J[18]+J[19]-J[20]+J[21]+J[22]+J[23]-J[24]+J[25]+J[26]+J[27]-J[28]+J[29]+J[30]+J[31]-J[32]+
    J[33]+J[34]+J[35]-J[36]+J[37]+J[38]-J[39]+J[40]+J[41]+J[42]-J[43]+J[44]-J[45]+J[46]+J[47]+J[48]-J[49]+
    J[50]-J[51]-J[52]-J[53]+J[54]-J[55]+J[56]+J[57]-J[58]+J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]-H[1]+
    H[2]+H[3]+H[4]+H[5]-H[6]+H[7]+H[8]+H[9]-H[10]-H[11]-J[0]+J[1]+J[2]+J[3]+J[4]-J[5]+J[6]+J[7]+J[8]-J[9]-J[10]-J[11]-J[12]-J[13]-J[14]+
    J[15]-J[16]-J[17]-J[18]+J[19]+J[20]+J[21]+J[22]+J[23]-J[24]+J[25]+J[26]+J[27]-J[28]-J[29]+J[30]+J[31]-J[32]+
    J[33]+J[34]+J[35]-J[36]-J[37]+J[38]-J[39]+J[40]+J[41]+J[42]-J[43]-J[44]-J[45]+J[46]+J[47]+J[48]-J[49]-J[50]-J[51]-J[52]-J[53]+
    J[54]+J[55]+J[56]+J[57]-J[58]-J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]-H[1]+H[2]+H[3]+H[4]+H[5]-H[6]+
    H[7]+H[8]-H[9]+H[10]+H[11]-J[0]+J[1]+J[2]+J[3]+J[4]-J[5]+J[6]+J[7]-J[8]+J[9]+J[10]-J[11]-J[12]-J[13]-J[14]+
    J[15]-J[16]-J[17]+J[18]-J[19]-J[20]+J[21]+J[22]+J[23]-J[24]+J[25]+J[26]-J[27]+J[28]+J[29]+J[30]+J[31]-J[32]+
    J[33]+J[34]-J[35]+J[36]+J[37]+J[38]-J[39]+J[40]+J[41]-J[42]+J[43]+J[44]-J[45]+J[46]+J[47]-J[48]+J[49]+
    J[50]-J[51]-J[52]+J[53]-J[54]-J[55]+J[56]-J[57]+J[58]+J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]-H[1]+
    H[2]+H[3]+H[4]+H[5]-H[6]+H[7]+H[8]-H[9]+H[10]-H[11]-J[0]+J[1]+J[2]+J[3]+J[4]-J[5]+J[6]+J[7]-J[8]+J[9]-J[10]-J[11]-J[12]-J[13]-J[14]+
    J[15]-J[16]-J[17]+J[18]-J[19]+J[20]+J[21]+J[22]+J[23]-J[24]+J[25]+J[26]-J[27]+J[28]-J[29]+J[30]+J[31]-J[32]+
    J[33]+J[34]-J[35]+J[36]-J[37]+J[38]-J[39]+J[40]+J[41]-J[42]+J[43]-J[44]-J[45]+J[46]+J[47]-J[48]+J[49]-J[50]-J[51]-J[52]+
    J[53]-J[54]+J[55]+J[56]-J[57]+J[58]-J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]-H[1]+H[2]+H[3]+
    H[4]+H[5]-H[6]+H[7]+H[8]-H[9]-H[10]+H[11]-J[0]+J[1]+J[2]+J[3]+J[4]-J[5]+J[6]+J[7]-J[8]-J[9]+J[10]-J[11]-J[12]-J[13]-J[14]+
    J[15]-J[16]-J[17]+J[18]+J[19]-J[20]+J[21]+J[22]+J[23]-J[24]+J[25]+J[26]-J[27]-J[28]+J[29]+J[30]+J[31]-J[32]+
    J[33]+J[34]-J[35]-J[36]+J[37]+J[38]-J[39]+J[40]+J[41]-J[42]-J[43]+J[44]-J[45]+J[46]+J[47]-J[48]-J[49]+
    J[50]-J[51]-J[52]+J[53]+J[54]-J[55]+J[56]-J[57]-J[58]+J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]-H[1]+
    H[2]+H[3]+H[4]+H[5]-H[6]+H[7]+H[8]-H[9]-H[10]-H[11]-J[0]+J[1]+J[2]+J[3]+J[4]-J[5]+J[6]+J[7]-J[8]-J[9]-J[10]-J[11]-J[12]-J[13]-J[14]+
    J[15]-J[16]-J[17]+J[18]+J[19]+J[20]+J[21]+J[22]+J[23]-J[24]+J[25]+J[26]-J[27]-J[28]-J[29]+J[30]+J[31]-J[32]+
    J[33]+J[34]-J[35]-J[36]-J[37]+J[38]-J[39]+J[40]+J[41]-J[42]-J[43]-J[44]-J[45]+J[46]+J[47]-J[48]-J[49]-J[50]-J[51]-J[52]+
    J[53]+J[54]+J[55]+J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]-H[1]+H[2]+H[3]+
    H[4]+H[5]-H[6]+H[7]-H[8]+H[9]+H[10]+H[11]-J[0]+J[1]+J[2]+J[3]+J[4]-J[5]+J[6]-J[7]+J[8]+J[9]+J[10]-J[11]-J[12]-J[13]-J[14]+
    J[15]-J[16]+J[17]-J[18]-J[19]-J[20]+J[21]+J[22]+J[23]-J[24]+J[25]-J[26]+J[27]+J[28]+J[29]+J[30]+J[31]-J[32]+
    J[33]-J[34]+J[35]+J[36]+J[37]+J[38]-J[39]+J[40]-J[41]+J[42]+J[43]+J[44]-J[45]+J[46]-J[47]+J[48]+J[49]+
    J[50]-J[51]+J[52]-J[53]-J[54]-J[55]-J[56]+J[57]+J[58]+J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]-H[1]+
    H[2]+H[3]+H[4]+H[5]-H[6]+H[7]-H[8]+H[9]+H[10]-H[11]-J[0]+J[1]+J[2]+J[3]+J[4]-J[5]+J[6]-J[7]+J[8]+J[9]-J[10]-J[11]-J[12]-J[13]-J[14]+
    J[15]-J[16]+J[17]-J[18]-J[19]+J[20]+J[21]+J[22]+J[23]-J[24]+J[25]-J[26]+J[27]+J[28]-J[29]+J[30]+J[31]-J[32]+
    J[33]-J[34]+J[35]+J[36]-J[37]+J[38]-J[39]+J[40]-J[41]+J[42]+J[43]-J[44]-J[45]+J[46]-J[47]+J[48]+J[49]-J[50]-J[51]+
    J[52]-J[53]-J[54]+J[55]-J[56]+J[57]+J[58]-J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]-H[1]+H[2]+
    H[3]+H[4]+H[5]-H[6]+H[7]-H[8]+H[9]-H[10]+H[11]-J[0]+J[1]+J[2]+J[3]+J[4]-J[5]+J[6]-J[7]+J[8]-J[9]+J[10]-J[11]-J[12]-J[13]-J[14]+
    J[15]-J[16]+J[17]-J[18]+J[19]-J[20]+J[21]+J[22]+J[23]-J[24]+J[25]-J[26]+J[27]-J[28]+J[29]+J[30]+J[31]-J[32]+
    J[33]-J[34]+J[35]-J[36]+J[37]+J[38]-J[39]+J[40]-J[41]+J[42]-J[43]+J[44]-J[45]+J[46]-J[47]+J[48]-J[49]+
    J[50]-J[51]+J[52]-J[53]+J[54]-J[55]-J[56]+J[57]-J[58]+J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]-H[1]+
    H[2]+H[3]+H[4]+H[5]-H[6]+H[7]-H[8]+H[9]-H[10]-H[11]-J[0]+J[1]+J[2]+J[3]+J[4]-J[5]+J[6]-J[7]+J[8]-J[9]-J[10]-J[11]-J[12]-J[13]-J[14]+
    J[15]-J[16]+J[17]-J[18]+J[19]+J[20]+J[21]+J[22]+J[23]-J[24]+J[25]-J[26]+J[27]-J[28]-J[29]+J[30]+J[31]-J[32]+
    J[33]-J[34]+J[35]-J[36]-J[37]+J[38]-J[39]+J[40]-J[41]+J[42]-J[43]-J[44]-J[45]+J[46]-J[47]+J[48]-J[49]-J[50]-J[51]+
    J[52]-J[53]+J[54]+J[55]-J[56]+J[57]-J[58]-J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]-H[1]+H[2]+
    H[3]+H[4]+H[5]-H[6]+H[7]-H[8]-H[9]+H[10]+H[11]-J[0]+J[1]+J[2]+J[3]+J[4]-J[5]+J[6]-J[7]-J[8]+J[9]+J[10]-J[11]-J[12]-J[13]-J[14]+
    J[15]-J[16]+J[17]+J[18]-J[19]-J[20]+J[21]+J[22]+J[23]-J[24]+J[25]-J[26]-J[27]+J[28]+J[29]+J[30]+J[31]-J[32]+
    J[33]-J[34]-J[35]+J[36]+J[37]+J[38]-J[39]+J[40]-J[41]-J[42]+J[43]+J[44]-J[45]+J[46]-J[47]-J[48]+J[49]+
    J[50]-J[51]+J[52]+J[53]-J[54]-J[55]-J[56]-J[57]+J[58]+J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]-H[1]+
    H[2]+H[3]+H[4]+H[5]-H[6]+H[7]-H[8]-H[9]+H[10]-H[11]-J[0]+J[1]+J[2]+J[3]+J[4]-J[5]+J[6]-J[7]-J[8]+J[9]-J[10]-J[11]-J[12]-J[13]-J[14]+
    J[15]-J[16]+J[17]+J[18]-J[19]+J[20]+J[21]+J[22]+J[23]-J[24]+J[25]-J[26]-J[27]+J[28]-J[29]+J[30]+J[31]-J[32]+
    J[33]-J[34]-J[35]+J[36]-J[37]+J[38]-J[39]+J[40]-J[41]-J[42]+J[43]-J[44]-J[45]+J[46]-J[47]-J[48]+J[49]-J[50]-J[51]+
    J[52]+J[53]-J[54]+J[55]-J[56]-J[57]+J[58]-J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]-H[1]+H[2]+
    H[3]+H[4]+H[5]-H[6]+H[7]-H[8]-H[9]-H[10]+H[11]-J[0]+J[1]+J[2]+J[3]+J[4]-J[5]+J[6]-J[7]-J[8]-J[9]+J[10]-J[11]-J[12]-J[13]-J[14]+
    J[15]-J[16]+J[17]+J[18]+J[19]-J[20]+J[21]+J[22]+J[23]-J[24]+J[25]-J[26]-J[27]-J[28]+J[29]+J[30]+J[31]-J[32]+
    J[33]-J[34]-J[35]-J[36]+J[37]+J[38]-J[39]+J[40]-J[41]-J[42]-J[43]+J[44]-J[45]+J[46]-J[47]-J[48]-J[49]+
    J[50]-J[51]+J[52]+J[53]+J[54]-J[55]-J[56]-J[57]-J[58]+J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]-H[1]+
    H[2]+H[3]+H[4]+H[5]-H[6]+H[7]-H[8]-H[9]-H[10]-H[11]-J[0]+J[1]+J[2]+J[3]+J[4]-J[5]+J[6]-J[7]-J[8]-J[9]-J[10]-J[11]-J[12]-J[13]-J[14]+
    J[15]-J[16]+J[17]+J[18]+J[19]+J[20]+J[21]+J[22]+J[23]-J[24]+J[25]-J[26]-J[27]-J[28]-J[29]+J[30]+J[31]-J[32]+
    J[33]-J[34]-J[35]-J[36]-J[37]+J[38]-J[39]+J[40]-J[41]-J[42]-J[43]-J[44]-J[45]+J[46]-J[47]-J[48]-J[49]-J[50]-J[51]+
    J[52]+J[53]+J[54]+J[55]-J[56]-J[57]-J[58]-J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]-H[1]+H[2]+
    H[3]+H[4]+H[5]-H[6]-H[7]+H[8]+H[9]+H[10]+H[11]-J[0]+J[1]+J[2]+J[3]+J[4]-J[5]-J[6]+J[7]+J[8]+J[9]+J[10]-J[11]-J[12]-J[13]-J[14]+
    J[15]+J[16]-J[17]-J[18]-J[19]-J[20]+J[21]+J[22]+J[23]-J[24]-J[25]+J[26]+J[27]+J[28]+J[29]+J[30]+J[31]-J[32]-J[33]+
    J[34]+J[35]+J[36]+J[37]+J[38]-J[39]-J[40]+J[41]+J[42]+J[43]+J[44]-J[45]-J[46]+J[47]+J[48]+J[49]+J[50]+
    J[51]-J[52]-J[53]-J[54]-J[55]-J[56]-J[57]-J[58]-J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]-H[1]+
    H[2]+H[3]+H[4]+H[5]-H[6]-H[7]+H[8]+H[9]+H[10]-H[11]-J[0]+J[1]+J[2]+J[3]+J[4]-J[5]-J[6]+J[7]+J[8]+J[9]-J[10]-J[11]-J[12]-J[13]-J[14]+
    J[15]+J[16]-J[17]-J[18]-J[19]+J[20]+J[21]+J[22]+J[23]-J[24]-J[25]+J[26]+J[27]+J[28]-J[29]+J[30]+J[31]-J[32]-J[33]+
    J[34]+J[35]+J[36]-J[37]+J[38]-J[39]-J[40]+J[41]+J[42]+J[43]-J[44]-J[45]-J[46]+J[47]+J[48]+J[49]-J[50]+
    J[51]-J[52]-J[53]-J[54]+J[55]-J[56]-J[57]-J[58]+J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]-H[1]+
    H[2]+H[3]+H[4]+H[5]-H[6]-H[7]+H[8]+H[9]-H[10]+H[11]-J[0]+J[1]+J[2]+J[3]+J[4]-J[5]-J[6]+J[7]+J[8]-J[9]+
    J[10]-J[11]-J[12]-J[13]-J[14]+J[15]+J[16]-J[17]-J[18]+J[19]-J[20]+J[21]+J[22]+J[23]-J[24]-J[25]+J[26]+
    J[27]-J[28]+J[29]+J[30]+J[31]-J[32]-J[33]+J[34]+J[35]-J[36]+J[37]+J[38]-J[39]-J[40]+J[41]+J[42]-J[43]+
    J[44]-J[45]-J[46]+J[47]+J[48]-J[49]+J[50]+J[51]-J[52]-J[53]+J[54]-J[55]-J[56]-J[57]+J[58]-J[59]+J[60]-J[61]+
    J[62]-J[63]+J[64]-J[65], +H[0]-H[1]+H[2]+H[3]+H[4]+H[5]-H[6]-H[7]+H[8]+H[9]-H[10]-H[11]-J[0]+J[1]+J[2]+
    J[3]+J[4]-J[5]-J[6]+J[7]+J[8]-J[9]-J[10]-J[11]-J[12]-J[13]-J[14]+J[15]+J[16]-J[17]-J[18]+J[19]+J[20]+
    J[21]+J[22]+J[23]-J[24]-J[25]+J[26]+J[27]-J[28]-J[29]+J[30]+J[31]-J[32]-J[33]+J[34]+J[35]-J[36]-J[37]+
    J[38]-J[39]-J[40]+J[41]+J[42]-J[43]-J[44]-J[45]-J[46]+J[47]+J[48]-J[49]-J[50]+J[51]-J[52]-J[53]+J[54]+
    J[55]-J[56]-J[57]+J[58]+J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]-H[1]+H[2]+H[3]+H[4]+H[5]-H[6]-H[7]+
    H[8]-H[9]+H[10]+H[11]-J[0]+J[1]+J[2]+J[3]+J[4]-J[5]-J[6]+J[7]-J[8]+J[9]+J[10]-J[11]-J[12]-J[13]-J[14]+
    J[15]+J[16]-J[17]+J[18]-J[19]-J[20]+J[21]+J[22]+J[23]-J[24]-J[25]+J[26]-J[27]+J[28]+J[29]+J[30]+J[31]-J[32]-J[33]+
    J[34]-J[35]+J[36]+J[37]+J[38]-J[39]-J[40]+J[41]-J[42]+J[43]+J[44]-J[45]-J[46]+J[47]-J[48]+J[49]+J[50]+
    J[51]-J[52]+J[53]-J[54]-J[55]-J[56]+J[57]-J[58]-J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]-H[1]+
    H[2]+H[3]+H[4]+H[5]-H[6]-H[7]+H[8]-H[9]+H[10]-H[11]-J[0]+J[1]+J[2]+J[3]+J[4]-J[5]-J[6]+J[7]-J[8]+J[9]-J[10]-J[11]-J[12]-J[13]-J[14]+
    J[15]+J[16]-J[17]+J[18]-J[19]+J[20]+J[21]+J[22]+J[23]-J[24]-J[25]+J[26]-J[27]+J[28]-J[29]+J[30]+J[31]-J[32]-J[33]+
    J[34]-J[35]+J[36]-J[37]+J[38]-J[39]-J[40]+J[41]-J[42]+J[43]-J[44]-J[45]-J[46]+J[47]-J[48]+J[49]-J[50]+
    J[51]-J[52]+J[53]-J[54]+J[55]-J[56]+J[57]-J[58]+J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]-H[1]+
    H[2]+H[3]+H[4]+H[5]-H[6]-H[7]+H[8]-H[9]-H[10]+H[11]-J[0]+J[1]+J[2]+J[3]+J[4]-J[5]-J[6]+J[7]-J[8]-J[9]+
    J[10]-J[11]-J[12]-J[13]-J[14]+J[15]+J[16]-J[17]+J[18]+J[19]-J[20]+J[21]+J[22]+J[23]-J[24]-J[25]+J[26]-J[27]-J[28]+
    J[29]+J[30]+J[31]-J[32]-J[33]+J[34]-J[35]-J[36]+J[37]+J[38]-J[39]-J[40]+J[41]-J[42]-J[43]+J[44]-J[45]-J[46]+
    J[47]-J[48]-J[49]+J[50]+J[51]-J[52]+J[53]+J[54]-J[55]-J[56]+J[57]+J[58]-J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +
    H[0]-H[1]+H[2]+H[3]+H[4]+H[5]-H[6]-H[7]+H[8]-H[9]-H[10]-H[11]-J[0]+J[1]+J[2]+J[3]+J[4]-J[5]-J[6]+J[7]-J[8]-J[9]-J[10]-J[11]-J[12]-J[13]-J[14]+
    J[15]+J[16]-J[17]+J[18]+J[19]+J[20]+J[21]+J[22]+J[23]-J[24]-J[25]+J[26]-J[27]-J[28]-J[29]+J[30]+J[31]-J[32]-J[33]+
    J[34]-J[35]-J[36]-J[37]+J[38]-J[39]-J[40]+J[41]-J[42]-J[43]-J[44]-J[45]-J[46]+J[47]-J[48]-J[49]-J[50]+
    J[51]-J[52]+J[53]+J[54]+J[55]-J[56]+J[57]+J[58]+J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]-H[1]+
    H[2]+H[3]+H[4]+H[5]-H[6]-H[7]-H[8]+H[9]+H[10]+H[11]-J[0]+J[1]+J[2]+J[3]+J[4]-J[5]-J[6]-J[7]+J[8]+J[9]+
    J[10]-J[11]-J[12]-J[13]-J[14]+J[15]+J[16]+J[17]-J[18]-J[19]-J[20]+J[21]+J[22]+J[23]-J[24]-J[25]-J[26]+
    J[27]+J[28]+J[29]+J[30]+J[31]-J[32]-J[33]-J[34]+J[35]+J[36]+J[37]+J[38]-J[39]-J[40]-J[41]+J[42]+J[43]+
    J[44]-J[45]-J[46]-J[47]+J[48]+J[49]+J[50]+J[51]+J[52]-J[53]-J[54]-J[55]+J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+
    J[63]+J[64]+J[65], +H[0]-H[1]+H[2]+H[3]+H[4]+H[5]-H[6]-H[7]-H[8]+H[9]+H[10]-H[11]-J[0]+J[1]+J[2]+J[3]+
    J[4]-J[5]-J[6]-J[7]+J[8]+J[9]-J[10]-J[11]-J[12]-J[13]-J[14]+J[15]+J[16]+J[17]-J[18]-J[19]+J[20]+J[21]+
    J[22]+J[23]-J[24]-J[25]-J[26]+J[27]+J[28]-J[29]+J[30]+J[31]-J[32]-J[33]-J[34]+J[35]+J[36]-J[37]+J[38]-J[39]-J[40]-J[41]+
    J[42]+J[43]-J[44]-J[45]-J[46]-J[47]+J[48]+J[49]-J[50]+J[51]+J[52]-J[53]-J[54]+J[55]+J[56]-J[57]-J[58]+
    J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]-H[1]+H[2]+H[3]+H[4]+H[5]-H[6]-H[7]-H[8]+H[9]-H[10]+
    H[11]-J[0]+J[1]+J[2]+J[3]+J[4]-J[5]-J[6]-J[7]+J[8]-J[9]+J[10]-J[11]-J[12]-J[13]-J[14]+J[15]+J[16]+J[17]-J[18]+
    J[19]-J[20]+J[21]+J[22]+J[23]-J[24]-J[25]-J[26]+J[27]-J[28]+J[29]+J[30]+J[31]-J[32]-J[33]-J[34]+J[35]-J[36]+
    J[37]+J[38]-J[39]-J[40]-J[41]+J[42]-J[43]+J[44]-J[45]-J[46]-J[47]+J[48]-J[49]+J[50]+J[51]+J[52]-J[53]+
    J[54]-J[55]+J[56]-J[57]+J[58]-J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]-H[1]+H[2]+H[3]+H[4]+H[5]-H[6]-H[7]-H[8]+
    H[9]-H[10]-H[11]-J[0]+J[1]+J[2]+J[3]+J[4]-J[5]-J[6]-J[7]+J[8]-J[9]-J[10]-J[11]-J[12]-J[13]-J[14]+J[15]+
    J[16]+J[17]-J[18]+J[19]+J[20]+J[21]+J[22]+J[23]-J[24]-J[25]-J[26]+J[27]-J[28]-J[29]+J[30]+J[31]-J[32]-J[33]-J[34]+
    J[35]-J[36]-J[37]+J[38]-J[39]-J[40]-J[41]+J[42]-J[43]-J[44]-J[45]-J[46]-J[47]+J[48]-J[49]-J[50]+J[51]+
    J[52]-J[53]+J[54]+J[55]+J[56]-J[57]+J[58]+J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]-H[1]+H[2]+
    H[3]+H[4]+H[5]-H[6]-H[7]-H[8]-H[9]+H[10]+H[11]-J[0]+J[1]+J[2]+J[3]+J[4]-J[5]-J[6]-J[7]-J[8]+J[9]+J[10]-J[11]-J[12]-J[13]-J[14]+
    J[15]+J[16]+J[17]+J[18]-J[19]-J[20]+J[21]+J[22]+J[23]-J[24]-J[25]-J[26]-J[27]+J[28]+J[29]+J[30]+J[31]-J[32]-J[33]-J[34]-J[35]+
    J[36]+J[37]+J[38]-J[39]-J[40]-J[41]-J[42]+J[43]+J[44]-J[45]-J[46]-J[47]-J[48]+J[49]+J[50]+J[51]+J[52]+
    J[53]-J[54]-J[55]+J[56]+J[57]-J[58]-J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]-H[1]+H[2]+H[3]+
    H[4]+H[5]-H[6]-H[7]-H[8]-H[9]+H[10]-H[11]-J[0]+J[1]+J[2]+J[3]+J[4]-J[5]-J[6]-J[7]-J[8]+J[9]-J[10]-J[11]-J[12]-J[13]-J[14]+
    J[15]+J[16]+J[17]+J[18]-J[19]+J[20]+J[21]+J[22]+J[23]-J[24]-J[25]-J[26]-J[27]+J[28]-J[29]+J[30]+J[31]-J[32]-J[33]-J[34]-J[35]+
    J[36]-J[37]+J[38]-J[39]-J[40]-J[41]-J[42]+J[43]-J[44]-J[45]-J[46]-J[47]-J[48]+J[49]-J[50]+J[51]+J[52]+
    J[53]-J[54]+J[55]+J[56]+J[57]-J[58]+J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]-H[1]+H[2]+H[3]+
    H[4]+H[5]-H[6]-H[7]-H[8]-H[9]-H[10]+H[11]-J[0]+J[1]+J[2]+J[3]+J[4]-J[5]-J[6]-J[7]-J[8]-J[9]+J[10]-J[11]-J[12]-J[13]-J[14]+
    J[15]+J[16]+J[17]+J[18]+J[19]-J[20]+J[21]+J[22]+J[23]-J[24]-J[25]-J[26]-J[27]-J[28]+J[29]+J[30]+J[31]-J[32]-J[33]-J[34]-J[35]-J[36]+
    J[37]+J[38]-J[39]-J[40]-J[41]-J[42]-J[43]+J[44]-J[45]-J[46]-J[47]-J[48]-J[49]+J[50]+J[51]+J[52]+J[53]+
    J[54]-J[55]+J[56]+J[57]+J[58]-J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]-H[1]+H[2]+H[3]+H[4]+H[5]-H[6]-H[7]-H[8]-H[9]-H[10]-H[11]-J[0]+
    J[1]+J[2]+J[3]+J[4]-J[5]-J[6]-J[7]-J[8]-J[9]-J[10]-J[11]-J[12]-J[13]-J[14]+J[15]+J[16]+J[17]+J[18]+J[19]+
    J[20]+J[21]+J[22]+J[23]-J[24]-J[25]-J[26]-J[27]-J[28]-J[29]+J[30]+J[31]-J[32]-J[33]-J[34]-J[35]-J[36]-J[37]+
    J[38]-J[39]-J[40]-J[41]-J[42]-J[43]-J[44]-J[45]-J[46]-J[47]-J[48]-J[49]-J[50]+J[51]+J[52]+J[53]+J[54]+
    J[55]+J[56]+J[57]+J[58]+J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]-H[1]+H[2]+H[3]+H[4]-H[5]+H[6]+
    H[7]+H[8]+H[9]+H[10]+H[11]-J[0]+J[1]+J[2]+J[3]-J[4]+J[5]+J[6]+J[7]+J[8]+J[9]+J[10]-J[11]-J[12]-J[13]+
    J[14]-J[15]-J[16]-J[17]-J[18]-J[19]-J[20]+J[21]+J[22]-J[23]+J[24]+J[25]+J[26]+J[27]+J[28]+J[29]+J[30]-J[31]+
    J[32]+J[33]+J[34]+J[35]+J[36]+J[37]-J[38]+J[39]+J[40]+J[41]+J[42]+J[43]+J[44]-J[45]-J[46]-J[47]-J[48]-J[49]-J[50]+
    J[51]+J[52]+J[53]+J[54]+J[55]+J[56]+J[57]+J[58]+J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]-H[1]+
    H[2]+H[3]+H[4]-H[5]+H[6]+H[7]+H[8]+H[9]+H[10]-H[11]-J[0]+J[1]+J[2]+J[3]-J[4]+J[5]+J[6]+J[7]+J[8]+J[9]-J[10]-J[11]-J[12]-J[13]+
    J[14]-J[15]-J[16]-J[17]-J[18]-J[19]+J[20]+J[21]+J[22]-J[23]+J[24]+J[25]+J[26]+J[27]+J[28]-J[29]+J[30]-J[31]+
    J[32]+J[33]+J[34]+J[35]+J[36]-J[37]-J[38]+J[39]+J[40]+J[41]+J[42]+J[43]-J[44]-J[45]-J[46]-J[47]-J[48]-J[49]+
    J[50]+J[51]+J[52]+J[53]+J[54]-J[55]+J[56]+J[57]+J[58]-J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]-H[1]+
    H[2]+H[3]+H[4]-H[5]+H[6]+H[7]+H[8]+H[9]-H[10]+H[11]-J[0]+J[1]+J[2]+J[3]-J[4]+J[5]+J[6]+J[7]+J[8]-J[9]+
    J[10]-J[11]-J[12]-J[13]+J[14]-J[15]-J[16]-J[17]-J[18]+J[19]-J[20]+J[21]+J[22]-J[23]+J[24]+J[25]+J[26]+
    J[27]-J[28]+J[29]+J[30]-J[31]+J[32]+J[33]+J[34]+J[35]-J[36]+J[37]-J[38]+J[39]+J[40]+J[41]+J[42]-J[43]+
    J[44]-J[45]-J[46]-J[47]-J[48]+J[49]-J[50]+J[51]+J[52]+J[53]-J[54]+J[55]+J[56]+J[57]-J[58]+J[59]+J[60]-J[61]+
    J[62]-J[63]+J[64]-J[65], +H[0]-H[1]+H[2]+H[3]+H[4]-H[5]+H[6]+H[7]+H[8]+H[9]-H[10]-H[11]-J[0]+J[1]+J[2]+
    J[3]-J[4]+J[5]+J[6]+J[7]+J[8]-J[9]-J[10]-J[11]-J[12]-J[13]+J[14]-J[15]-J[16]-J[17]-J[18]+J[19]+J[20]+
    J[21]+J[22]-J[23]+J[24]+J[25]+J[26]+J[27]-J[28]-J[29]+J[30]-J[31]+J[32]+J[33]+J[34]+J[35]-J[36]-J[37]-J[38]+
    J[39]+J[40]+J[41]+J[42]-J[43]-J[44]-J[45]-J[46]-J[47]-J[48]+J[49]+J[50]+J[51]+J[52]+J[53]-J[54]-J[55]+
    J[56]+J[57]-J[58]-J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]-H[1]+H[2]+H[3]+H[4]-H[5]+H[6]+H[7]+
    H[8]-H[9]+H[10]+H[11]-J[0]+J[1]+J[2]+J[3]-J[4]+J[5]+J[6]+J[7]-J[8]+J[9]+J[10]-J[11]-J[12]-J[13]+J[14]-J[15]-J[16]-J[17]+
    J[18]-J[19]-J[20]+J[21]+J[22]-J[23]+J[24]+J[25]+J[26]-J[27]+J[28]+J[29]+J[30]-J[31]+J[32]+J[33]+J[34]-J[35]+
    J[36]+J[37]-J[38]+J[39]+J[40]+J[41]-J[42]+J[43]+J[44]-J[45]-J[46]-J[47]+J[48]-J[49]-J[50]+J[51]+J[52]-J[53]+
    J[54]+J[55]+J[56]-J[57]+J[58]+J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]-H[1]+H[2]+H[3]+H[4]-H[5]+
    H[6]+H[7]+H[8]-H[9]+H[10]-H[11]-J[0]+J[1]+J[2]+J[3]-J[4]+J[5]+J[6]+J[7]-J[8]+J[9]-J[10]-J[11]-J[12]-J[13]+
    J[14]-J[15]-J[16]-J[17]+J[18]-J[19]+J[20]+J[21]+J[22]-J[23]+J[24]+J[25]+J[26]-J[27]+J[28]-J[29]+J[30]-J[31]+
    J[32]+J[33]+J[34]-J[35]+J[36]-J[37]-J[38]+J[39]+J[40]+J[41]-J[42]+J[43]-J[44]-J[45]-J[46]-J[47]+J[48]-J[49]+
    J[50]+J[51]+J[52]-J[53]+J[54]-J[55]+J[56]-J[57]+J[58]-J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]-H[1]+
    H[2]+H[3]+H[4]-H[5]+H[6]+H[7]+H[8]-H[9]-H[10]+H[11]-J[0]+J[1]+J[2]+J[3]-J[4]+J[5]+J[6]+J[7]-J[8]-J[9]+
    J[10]-J[11]-J[12]-J[13]+J[14]-J[15]-J[16]-J[17]+J[18]+J[19]-J[20]+J[21]+J[22]-J[23]+J[24]+J[25]+J[26]-J[27]-J[28]+
    J[29]+J[30]-J[31]+J[32]+J[33]+J[34]-J[35]-J[36]+J[37]-J[38]+J[39]+J[40]+J[41]-J[42]-J[43]+J[44]-J[45]-J[46]-J[47]+
    J[48]+J[49]-J[50]+J[51]+J[52]-J[53]-J[54]+J[55]+J[56]-J[57]-J[58]+J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +
    H[0]-H[1]+H[2]+H[3]+H[4]-H[5]+H[6]+H[7]+H[8]-H[9]-H[10]-H[11]-J[0]+J[1]+J[2]+J[3]-J[4]+J[5]+J[6]+J[7]-J[8]-J[9]-J[10]-J[11]-J[12]-J[13]+
    J[14]-J[15]-J[16]-J[17]+J[18]+J[19]+J[20]+J[21]+J[22]-J[23]+J[24]+J[25]+J[26]-J[27]-J[28]-J[29]+J[30]-J[31]+
    J[32]+J[33]+J[34]-J[35]-J[36]-J[37]-J[38]+J[39]+J[40]+J[41]-J[42]-J[43]-J[44]-J[45]-J[46]-J[47]+J[48]+
    J[49]+J[50]+J[51]+J[52]-J[53]-J[54]-J[55]+J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +
    H[0]-H[1]+H[2]+H[3]+H[4]-H[5]+H[6]+H[7]-H[8]+H[9]+H[10]+H[11]-J[0]+J[1]+J[2]+J[3]-J[4]+J[5]+J[6]-J[7]+
    J[8]+J[9]+J[10]-J[11]-J[12]-J[13]+J[14]-J[15]-J[16]+J[17]-J[18]-J[19]-J[20]+J[21]+J[22]-J[23]+J[24]+
    J[25]-J[26]+J[27]+J[28]+J[29]+J[30]-J[31]+J[32]+J[33]-J[34]+J[35]+J[36]+J[37]-J[38]+J[39]+J[40]-J[41]+
    J[42]+J[43]+J[44]-J[45]-J[46]+J[47]-J[48]-J[49]-J[50]+J[51]-J[52]+J[53]+J[54]+J[55]-J[56]+J[57]+J[58]+
    J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]-H[1]+H[2]+H[3]+H[4]-H[5]+H[6]+H[7]-H[8]+H[9]+H[10]-H[11]-J[0]+
    J[1]+J[2]+J[3]-J[4]+J[5]+J[6]-J[7]+J[8]+J[9]-J[10]-J[11]-J[12]-J[13]+J[14]-J[15]-J[16]+J[17]-J[18]-J[19]+
    J[20]+J[21]+J[22]-J[23]+J[24]+J[25]-J[26]+J[27]+J[28]-J[29]+J[30]-J[31]+J[32]+J[33]-J[34]+J[35]+J[36]-J[37]-J[38]+
    J[39]+J[40]-J[41]+J[42]+J[43]-J[44]-J[45]-J[46]+J[47]-J[48]-J[49]+J[50]+J[51]-J[52]+J[53]+J[54]-J[55]-J[56]+
    J[57]+J[58]-J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]-H[1]+H[2]+H[3]+H[4]-H[5]+H[6]+H[7]-H[8]+
    H[9]-H[10]+H[11]-J[0]+J[1]+J[2]+J[3]-J[4]+J[5]+J[6]-J[7]+J[8]-J[9]+J[10]-J[11]-J[12]-J[13]+J[14]-J[15]-J[16]+
    J[17]-J[18]+J[19]-J[20]+J[21]+J[22]-J[23]+J[24]+J[25]-J[26]+J[27]-J[28]+J[29]+J[30]-J[31]+J[32]+J[33]-J[34]+
    J[35]-J[36]+J[37]-J[38]+J[39]+J[40]-J[41]+J[42]-J[43]+J[44]-J[45]-J[46]+J[47]-J[48]+J[49]-J[50]+J[51]-J[52]+
    J[53]-J[54]+J[55]-J[56]+J[57]-J[58]+J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]-H[1]+H[2]+H[3]+
    H[4]-H[5]+H[6]+H[7]-H[8]+H[9]-H[10]-H[11]-J[0]+J[1]+J[2]+J[3]-J[4]+J[5]+J[6]-J[7]+J[8]-J[9]-J[10]-J[11]-J[12]-J[13]+
    J[14]-J[15]-J[16]+J[17]-J[18]+J[19]+J[20]+J[21]+J[22]-J[23]+J[24]+J[25]-J[26]+J[27]-J[28]-J[29]+J[30]-J[31]+
    J[32]+J[33]-J[34]+J[35]-J[36]-J[37]-J[38]+J[39]+J[40]-J[41]+J[42]-J[43]-J[44]-J[45]-J[46]+J[47]-J[48]+
    J[49]+J[50]+J[51]-J[52]+J[53]-J[54]-J[55]-J[56]+J[57]-J[58]-J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +
    H[0]-H[1]+H[2]+H[3]+H[4]-H[5]+H[6]+H[7]-H[8]-H[9]+H[10]+H[11]-J[0]+J[1]+J[2]+J[3]-J[4]+J[5]+J[6]-J[7]-J[8]+
    J[9]+J[10]-J[11]-J[12]-J[13]+J[14]-J[15]-J[16]+J[17]+J[18]-J[19]-J[20]+J[21]+J[22]-J[23]+J[24]+J[25]-J[26]-J[27]+
    J[28]+J[29]+J[30]-J[31]+J[32]+J[33]-J[34]-J[35]+J[36]+J[37]-J[38]+J[39]+J[40]-J[41]-J[42]+J[43]+J[44]-J[45]-J[46]+
    J[47]+J[48]-J[49]-J[50]+J[51]-J[52]-J[53]+J[54]+J[55]-J[56]-J[57]+J[58]+J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+
    J[65], +H[0]-H[1]+H[2]+H[3]+H[4]-H[5]+H[6]+H[7]-H[8]-H[9]+H[10]-H[11]-J[0]+J[1]+J[2]+J[3]-J[4]+J[5]+
    J[6]-J[7]-J[8]+J[9]-J[10]-J[11]-J[12]-J[13]+J[14]-J[15]-J[16]+J[17]+J[18]-J[19]+J[20]+J[21]+J[22]-J[23]+
    J[24]+J[25]-J[26]-J[27]+J[28]-J[29]+J[30]-J[31]+J[32]+J[33]-J[34]-J[35]+J[36]-J[37]-J[38]+J[39]+J[40]-J[41]-J[42]+
    J[43]-J[44]-J[45]-J[46]+J[47]+J[48]-J[49]+J[50]+J[51]-J[52]-J[53]+J[54]-J[55]-J[56]-J[57]+J[58]-J[59]+
    J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]-H[1]+H[2]+H[3]+H[4]-H[5]+H[6]+H[7]-H[8]-H[9]-H[10]+H[11]-J[0]+
    J[1]+J[2]+J[3]-J[4]+J[5]+J[6]-J[7]-J[8]-J[9]+J[10]-J[11]-J[12]-J[13]+J[14]-J[15]-J[16]+J[17]+J[18]+J[19]-J[20]+
    J[21]+J[22]-J[23]+J[24]+J[25]-J[26]-J[27]-J[28]+J[29]+J[30]-J[31]+J[32]+J[33]-J[34]-J[35]-J[36]+J[37]-J[38]+
    J[39]+J[40]-J[41]-J[42]-J[43]+J[44]-J[45]-J[46]+J[47]+J[48]+J[49]-J[50]+J[51]-J[52]-J[53]-J[54]+J[55]-J[56]-J[57]-J[58]+
    J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]-H[1]+H[2]+H[3]+H[4]-H[5]+H[6]+H[7]-H[8]-H[9]-H[10]-H[11]-J[0]+
    J[1]+J[2]+J[3]-J[4]+J[5]+J[6]-J[7]-J[8]-J[9]-J[10]-J[11]-J[12]-J[13]+J[14]-J[15]-J[16]+J[17]+J[18]+J[19]+
    J[20]+J[21]+J[22]-J[23]+J[24]+J[25]-J[26]-J[27]-J[28]-J[29]+J[30]-J[31]+J[32]+J[33]-J[34]-J[35]-J[36]-J[37]-J[38]+
    J[39]+J[40]-J[41]-J[42]-J[43]-J[44]-J[45]-J[46]+J[47]+J[48]+J[49]+J[50]+J[51]-J[52]-J[53]-J[54]-J[55]-J[56]-J[57]-J[58]-J[59]+
    J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]-H[1]+H[2]+H[3]+H[4]-H[5]+H[6]-H[7]+H[8]+H[9]+H[10]+H[11]-J[0]+
    J[1]+J[2]+J[3]-J[4]+J[5]-J[6]+J[7]+J[8]+J[9]+J[10]-J[11]-J[12]-J[13]+J[14]-J[15]+J[16]-J[17]-J[18]-J[19]-J[20]+
    J[21]+J[22]-J[23]+J[24]-J[25]+J[26]+J[27]+J[28]+J[29]+J[30]-J[31]+J[32]-J[33]+J[34]+J[35]+J[36]+J[37]-J[38]+
    J[39]-J[40]+J[41]+J[42]+J[43]+J[44]-J[45]+J[46]-J[47]-J[48]-J[49]-J[50]-J[51]+J[52]+J[53]+J[54]+J[55]-J[56]-J[57]-J[58]-J[59]+
    J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]-H[1]+H[2]+H[3]+H[4]-H[5]+H[6]-H[7]+H[8]+H[9]+H[10]-H[11]-J[0]+
    J[1]+J[2]+J[3]-J[4]+J[5]-J[6]+J[7]+J[8]+J[9]-J[10]-J[11]-J[12]-J[13]+J[14]-J[15]+J[16]-J[17]-J[18]-J[19]+
    J[20]+J[21]+J[22]-J[23]+J[24]-J[25]+J[26]+J[27]+J[28]-J[29]+J[30]-J[31]+J[32]-J[33]+J[34]+J[35]+J[36]-J[37]-J[38]+
    J[39]-J[40]+J[41]+J[42]+J[43]-J[44]-J[45]+J[46]-J[47]-J[48]-J[49]+J[50]-J[51]+J[52]+J[53]+J[54]-J[55]-J[56]-J[57]-J[58]+
    J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]-H[1]+H[2]+H[3]+H[4]-H[5]+H[6]-H[7]+H[8]+H[9]-H[10]+
    H[11]-J[0]+J[1]+J[2]+J[3]-J[4]+J[5]-J[6]+J[7]+J[8]-J[9]+J[10]-J[11]-J[12]-J[13]+J[14]-J[15]+J[16]-J[17]-J[18]+
    J[19]-J[20]+J[21]+J[22]-J[23]+J[24]-J[25]+J[26]+J[27]-J[28]+J[29]+J[30]-J[31]+J[32]-J[33]+J[34]+J[35]-J[36]+
    J[37]-J[38]+J[39]-J[40]+J[41]+J[42]-J[43]+J[44]-J[45]+J[46]-J[47]-J[48]+J[49]-J[50]-J[51]+J[52]+J[53]-J[54]+
    J[55]-J[56]-J[57]+J[58]-J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]-H[1]+H[2]+H[3]+H[4]-H[5]+H[6]-H[7]+
    H[8]+H[9]-H[10]-H[11]-J[0]+J[1]+J[2]+J[3]-J[4]+J[5]-J[6]+J[7]+J[8]-J[9]-J[10]-J[11]-J[12]-J[13]+J[14]-J[15]+
    J[16]-J[17]-J[18]+J[19]+J[20]+J[21]+J[22]-J[23]+J[24]-J[25]+J[26]+J[27]-J[28]-J[29]+J[30]-J[31]+J[32]-J[33]+
    J[34]+J[35]-J[36]-J[37]-J[38]+J[39]-J[40]+J[41]+J[42]-J[43]-J[44]-J[45]+J[46]-J[47]-J[48]+J[49]+J[50]-J[51]+
    J[52]+J[53]-J[54]-J[55]-J[56]-J[57]+J[58]+J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]-H[1]+H[2]+
    H[3]+H[4]-H[5]+H[6]-H[7]+H[8]-H[9]+H[10]+H[11]-J[0]+J[1]+J[2]+J[3]-J[4]+J[5]-J[6]+J[7]-J[8]+J[9]+J[10]-J[11]-J[12]-J[13]+
    J[14]-J[15]+J[16]-J[17]+J[18]-J[19]-J[20]+J[21]+J[22]-J[23]+J[24]-J[25]+J[26]-J[27]+J[28]+J[29]+J[30]-J[31]+
    J[32]-J[33]+J[34]-J[35]+J[36]+J[37]-J[38]+J[39]-J[40]+J[41]-J[42]+J[43]+J[44]-J[45]+J[46]-J[47]+J[48]-J[49]-J[50]-J[51]+
    J[52]-J[53]+J[54]+J[55]-J[56]+J[57]-J[58]-J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]-H[1]+H[2]+
    H[3]+H[4]-H[5]+H[6]-H[7]+H[8]-H[9]+H[10]-H[11]-J[0]+J[1]+J[2]+J[3]-J[4]+J[5]-J[6]+J[7]-J[8]+J[9]-J[10]-J[11]-J[12]-J[13]+
    J[14]-J[15]+J[16]-J[17]+J[18]-J[19]+J[20]+J[21]+J[22]-J[23]+J[24]-J[25]+J[26]-J[27]+J[28]-J[29]+J[30]-J[31]+
    J[32]-J[33]+J[34]-J[35]+J[36]-J[37]-J[38]+J[39]-J[40]+J[41]-J[42]+J[43]-J[44]-J[45]+J[46]-J[47]+J[48]-J[49]+
    J[50]-J[51]+J[52]-J[53]+J[54]-J[55]-J[56]+J[57]-J[58]+J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]-H[1]+
    H[2]+H[3]+H[4]-H[5]+H[6]-H[7]+H[8]-H[9]-H[10]+H[11]-J[0]+J[1]+J[2]+J[3]-J[4]+J[5]-J[6]+J[7]-J[8]-J[9]+
    J[10]-J[11]-J[12]-J[13]+J[14]-J[15]+J[16]-J[17]+J[18]+J[19]-J[20]+J[21]+J[22]-J[23]+J[24]-J[25]+J[26]-J[27]-J[28]+
    J[29]+J[30]-J[31]+J[32]-J[33]+J[34]-J[35]-J[36]+J[37]-J[38]+J[39]-J[40]+J[41]-J[42]-J[43]+J[44]-J[45]+
    J[46]-J[47]+J[48]+J[49]-J[50]-J[51]+J[52]-J[53]-J[54]+J[55]-J[56]+J[57]+J[58]-J[59]-J[60]-J[61]+J[62]+
    J[63]-J[64]-J[65], +H[0]-H[1]+H[2]+H[3]+H[4]-H[5]+H[6]-H[7]+H[8]-H[9]-H[10]-H[11]-J[0]+J[1]+J[2]+J[3]-J[4]+
    J[5]-J[6]+J[7]-J[8]-J[9]-J[10]-J[11]-J[12]-J[13]+J[14]-J[15]+J[16]-J[17]+J[18]+J[19]+J[20]+J[21]+J[22]-J[23]+
    J[24]-J[25]+J[26]-J[27]-J[28]-J[29]+J[30]-J[31]+J[32]-J[33]+J[34]-J[35]-J[36]-J[37]-J[38]+J[39]-J[40]+
    J[41]-J[42]-J[43]-J[44]-J[45]+J[46]-J[47]+J[48]+J[49]+J[50]-J[51]+J[52]-J[53]-J[54]-J[55]-J[56]+J[57]+
    J[58]+J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]-H[1]+H[2]+H[3]+H[4]-H[5]+H[6]-H[7]-H[8]+H[9]+
    H[10]+H[11]-J[0]+J[1]+J[2]+J[3]-J[4]+J[5]-J[6]-J[7]+J[8]+J[9]+J[10]-J[11]-J[12]-J[13]+J[14]-J[15]+J[16]+
    J[17]-J[18]-J[19]-J[20]+J[21]+J[22]-J[23]+J[24]-J[25]-J[26]+J[27]+J[28]+J[29]+J[30]-J[31]+J[32]-J[33]-J[34]+
    J[35]+J[36]+J[37]-J[38]+J[39]-J[40]-J[41]+J[42]+J[43]+J[44]-J[45]+J[46]+J[47]-J[48]-J[49]-J[50]-J[51]-J[52]+
    J[53]+J[54]+J[55]+J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]-H[1]+H[2]+H[3]+
    H[4]-H[5]+H[6]-H[7]-H[8]+H[9]+H[10]-H[11]-J[0]+J[1]+J[2]+J[3]-J[4]+J[5]-J[6]-J[7]+J[8]+J[9]-J[10]-J[11]-J[12]-J[13]+
    J[14]-J[15]+J[16]+J[17]-J[18]-J[19]+J[20]+J[21]+J[22]-J[23]+J[24]-J[25]-J[26]+J[27]+J[28]-J[29]+J[30]-J[31]+
    J[32]-J[33]-J[34]+J[35]+J[36]-J[37]-J[38]+J[39]-J[40]-J[41]+J[42]+J[43]-J[44]-J[45]+J[46]+J[47]-J[48]-J[49]+
    J[50]-J[51]-J[52]+J[53]+J[54]-J[55]+J[56]-J[57]-J[58]+J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]-H[1]+
    H[2]+H[3]+H[4]-H[5]+H[6]-H[7]-H[8]+H[9]-H[10]+H[11]-J[0]+J[1]+J[2]+J[3]-J[4]+J[5]-J[6]-J[7]+J[8]-J[9]+
    J[10]-J[11]-J[12]-J[13]+J[14]-J[15]+J[16]+J[17]-J[18]+J[19]-J[20]+J[21]+J[22]-J[23]+J[24]-J[25]-J[26]+
    J[27]-J[28]+J[29]+J[30]-J[31]+J[32]-J[33]-J[34]+J[35]-J[36]+J[37]-J[38]+J[39]-J[40]-J[41]+J[42]-J[43]+
    J[44]-J[45]+J[46]+J[47]-J[48]+J[49]-J[50]-J[51]-J[52]+J[53]-J[54]+J[55]+J[56]-J[57]+J[58]-J[59]-J[60]+
    J[61]-J[62]-J[63]+J[64]-J[65], +H[0]-H[1]+H[2]+H[3]+H[4]-H[5]+H[6]-H[7]-H[8]+H[9]-H[10]-H[11]-J[0]+J[1]+
    J[2]+J[3]-J[4]+J[5]-J[6]-J[7]+J[8]-J[9]-J[10]-J[11]-J[12]-J[13]+J[14]-J[15]+J[16]+J[17]-J[18]+J[19]+
    J[20]+J[21]+J[22]-J[23]+J[24]-J[25]-J[26]+J[27]-J[28]-J[29]+J[30]-J[31]+J[32]-J[33]-J[34]+J[35]-J[36]-J[37]-J[38]+
    J[39]-J[40]-J[41]+J[42]-J[43]-J[44]-J[45]+J[46]+J[47]-J[48]+J[49]+J[50]-J[51]-J[52]+J[53]-J[54]-J[55]+
    J[56]-J[57]+J[58]+J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]-H[1]+H[2]+H[3]+H[4]-H[5]+H[6]-H[7]-H[8]-H[9]+
    H[10]+H[11]-J[0]+J[1]+J[2]+J[3]-J[4]+J[5]-J[6]-J[7]-J[8]+J[9]+J[10]-J[11]-J[12]-J[13]+J[14]-J[15]+J[16]+
    J[17]+J[18]-J[19]-J[20]+J[21]+J[22]-J[23]+J[24]-J[25]-J[26]-J[27]+J[28]+J[29]+J[30]-J[31]+J[32]-J[33]-J[34]-J[35]+
    J[36]+J[37]-J[38]+J[39]-J[40]-J[41]-J[42]+J[43]+J[44]-J[45]+J[46]+J[47]+J[48]-J[49]-J[50]-J[51]-J[52]-J[53]+
    J[54]+J[55]+J[56]+J[57]-J[58]-J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]-H[1]+H[2]+H[3]+H[4]-H[5]+
    H[6]-H[7]-H[8]-H[9]+H[10]-H[11]-J[0]+J[1]+J[2]+J[3]-J[4]+J[5]-J[6]-J[7]-J[8]+J[9]-J[10]-J[11]-J[12]-J[13]+
    J[14]-J[15]+J[16]+J[17]+J[18]-J[19]+J[20]+J[21]+J[22]-J[23]+J[24]-J[25]-J[26]-J[27]+J[28]-J[29]+J[30]-J[31]+
    J[32]-J[33]-J[34]-J[35]+J[36]-J[37]-J[38]+J[39]-J[40]-J[41]-J[42]+J[43]-J[44]-J[45]+J[46]+J[47]+J[48]-J[49]+
    J[50]-J[51]-J[52]-J[53]+J[54]-J[55]+J[56]+J[57]-J[58]+J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]-H[1]+
    H[2]+H[3]+H[4]-H[5]+H[6]-H[7]-H[8]-H[9]-H[10]+H[11]-J[0]+J[1]+J[2]+J[3]-J[4]+J[5]-J[6]-J[7]-J[8]-J[9]+
    J[10]-J[11]-J[12]-J[13]+J[14]-J[15]+J[16]+J[17]+J[18]+J[19]-J[20]+J[21]+J[22]-J[23]+J[24]-J[25]-J[26]-J[27]-J[28]+
    J[29]+J[30]-J[31]+J[32]-J[33]-J[34]-J[35]-J[36]+J[37]-J[38]+J[39]-J[40]-J[41]-J[42]-J[43]+J[44]-J[45]+
    J[46]+J[47]+J[48]+J[49]-J[50]-J[51]-J[52]-J[53]-J[54]+J[55]+J[56]+J[57]+J[58]-J[59]+J[60]+J[61]-J[62]+
    J[63]-J[64]-J[65], +H[0]-H[1]+H[2]+H[3]+H[4]-H[5]+H[6]-H[7]-H[8]-H[9]-H[10]-H[11]-J[0]+J[1]+J[2]+J[3]-J[4]+
    J[5]-J[6]-J[7]-J[8]-J[9]-J[10]-J[11]-J[12]-J[13]+J[14]-J[15]+J[16]+J[17]+J[18]+J[19]+J[20]+J[21]+J[22]-J[23]+
    J[24]-J[25]-J[26]-J[27]-J[28]-J[29]+J[30]-J[31]+J[32]-J[33]-J[34]-J[35]-J[36]-J[37]-J[38]+J[39]-J[40]-J[41]-J[42]-J[43]-J[44]-J[45]+
    J[46]+J[47]+J[48]+J[49]+J[50]-J[51]-J[52]-J[53]-J[54]-J[55]+J[56]+J[57]+J[58]+J[59]+J[60]+J[61]+J[62]+
    J[63]+J[64]+J[65], +H[0]-H[1]+H[2]+H[3]+H[4]-H[5]-H[6]+H[7]+H[8]+H[9]+H[10]+H[11]-J[0]+J[1]+J[2]+J[3]-J[4]-J[5]+
    J[6]+J[7]+J[8]+J[9]+J[10]-J[11]-J[12]-J[13]+J[14]+J[15]-J[16]-J[17]-J[18]-J[19]-J[20]+J[21]+J[22]-J[23]-J[24]+
    J[25]+J[26]+J[27]+J[28]+J[29]+J[30]-J[31]-J[32]+J[33]+J[34]+J[35]+J[36]+J[37]-J[38]-J[39]+J[40]+J[41]+
    J[42]+J[43]+J[44]+J[45]-J[46]-J[47]-J[48]-J[49]-J[50]-J[51]-J[52]-J[53]-J[54]-J[55]+J[56]+J[57]+J[58]+
    J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]-H[1]+H[2]+H[3]+H[4]-H[5]-H[6]+H[7]+H[8]+H[9]+H[10]-H[11]-J[0]+
    J[1]+J[2]+J[3]-J[4]-J[5]+J[6]+J[7]+J[8]+J[9]-J[10]-J[11]-J[12]-J[13]+J[14]+J[15]-J[16]-J[17]-J[18]-J[19]+
    J[20]+J[21]+J[22]-J[23]-J[24]+J[25]+J[26]+J[27]+J[28]-J[29]+J[30]-J[31]-J[32]+J[33]+J[34]+J[35]+J[36]-J[37]-J[38]-J[39]+
    J[40]+J[41]+J[42]+J[43]-J[44]+J[45]-J[46]-J[47]-J[48]-J[49]+J[50]-J[51]-J[52]-J[53]-J[54]+J[55]+J[56]+
    J[57]+J[58]-J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]-H[1]+H[2]+H[3]+H[4]-H[5]-H[6]+H[7]+H[8]+
    H[9]-H[10]+H[11]-J[0]+J[1]+J[2]+J[3]-J[4]-J[5]+J[6]+J[7]+J[8]-J[9]+J[10]-J[11]-J[12]-J[13]+J[14]+J[15]-J[16]-J[17]-J[18]+
    J[19]-J[20]+J[21]+J[22]-J[23]-J[24]+J[25]+J[26]+J[27]-J[28]+J[29]+J[30]-J[31]-J[32]+J[33]+J[34]+J[35]-J[36]+
    J[37]-J[38]-J[39]+J[40]+J[41]+J[42]-J[43]+J[44]+J[45]-J[46]-J[47]-J[48]+J[49]-J[50]-J[51]-J[52]-J[53]+
    J[54]-J[55]+J[56]+J[57]-J[58]+J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]-H[1]+H[2]+H[3]+H[4]-H[5]-H[6]+
    H[7]+H[8]+H[9]-H[10]-H[11]-J[0]+J[1]+J[2]+J[3]-J[4]-J[5]+J[6]+J[7]+J[8]-J[9]-J[10]-J[11]-J[12]-J[13]+
    J[14]+J[15]-J[16]-J[17]-J[18]+J[19]+J[20]+J[21]+J[22]-J[23]-J[24]+J[25]+J[26]+J[27]-J[28]-J[29]+J[30]-J[31]-J[32]+
    J[33]+J[34]+J[35]-J[36]-J[37]-J[38]-J[39]+J[40]+J[41]+J[42]-J[43]-J[44]+J[45]-J[46]-J[47]-J[48]+J[49]+
    J[50]-J[51]-J[52]-J[53]+J[54]+J[55]+J[56]+J[57]-J[58]-J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]-H[1]+
    H[2]+H[3]+H[4]-H[5]-H[6]+H[7]+H[8]-H[9]+H[10]+H[11]-J[0]+J[1]+J[2]+J[3]-J[4]-J[5]+J[6]+J[7]-J[8]+J[9]+
    J[10]-J[11]-J[12]-J[13]+J[14]+J[15]-J[16]-J[17]+J[18]-J[19]-J[20]+J[21]+J[22]-J[23]-J[24]+J[25]+J[26]-J[27]+
    J[28]+J[29]+J[30]-J[31]-J[32]+J[33]+J[34]-J[35]+J[36]+J[37]-J[38]-J[39]+J[40]+J[41]-J[42]+J[43]+J[44]+
    J[45]-J[46]-J[47]+J[48]-J[49]-J[50]-J[51]-J[52]+J[53]-J[54]-J[55]+J[56]-J[57]+J[58]+J[59]-J[60]+J[61]+
    J[62]-J[63]-J[64]+J[65], +H[0]-H[1]+H[2]+H[3]+H[4]-H[5]-H[6]+H[7]+H[8]-H[9]+H[10]-H[11]-J[0]+J[1]+J[2]+
    J[3]-J[4]-J[5]+J[6]+J[7]-J[8]+J[9]-J[10]-J[11]-J[12]-J[13]+J[14]+J[15]-J[16]-J[17]+J[18]-J[19]+J[20]+
    J[21]+J[22]-J[23]-J[24]+J[25]+J[26]-J[27]+J[28]-J[29]+J[30]-J[31]-J[32]+J[33]+J[34]-J[35]+J[36]-J[37]-J[38]-J[39]+
    J[40]+J[41]-J[42]+J[43]-J[44]+J[45]-J[46]-J[47]+J[48]-J[49]+J[50]-J[51]-J[52]+J[53]-J[54]+J[55]+J[56]-J[57]+
    J[58]-J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]-H[1]+H[2]+H[3]+H[4]-H[5]-H[6]+H[7]+H[8]-H[9]-H[10]+
    H[11]-J[0]+J[1]+J[2]+J[3]-J[4]-J[5]+J[6]+J[7]-J[8]-J[9]+J[10]-J[11]-J[12]-J[13]+J[14]+J[15]-J[16]-J[17]+
    J[18]+J[19]-J[20]+J[21]+J[22]-J[23]-J[24]+J[25]+J[26]-J[27]-J[28]+J[29]+J[30]-J[31]-J[32]+J[33]+J[34]-J[35]-J[36]+
    J[37]-J[38]-J[39]+J[40]+J[41]-J[42]-J[43]+J[44]+J[45]-J[46]-J[47]+J[48]+J[49]-J[50]-J[51]-J[52]+J[53]+
    J[54]-J[55]+J[56]-J[57]-J[58]+J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]-H[1]+H[2]+H[3]+H[4]-H[5]-H[6]+
    H[7]+H[8]-H[9]-H[10]-H[11]-J[0]+J[1]+J[2]+J[3]-J[4]-J[5]+J[6]+J[7]-J[8]-J[9]-J[10]-J[11]-J[12]-J[13]+
    J[14]+J[15]-J[16]-J[17]+J[18]+J[19]+J[20]+J[21]+J[22]-J[23]-J[24]+J[25]+J[26]-J[27]-J[28]-J[29]+J[30]-J[31]-J[32]+
    J[33]+J[34]-J[35]-J[36]-J[37]-J[38]-J[39]+J[40]+J[41]-J[42]-J[43]-J[44]+J[45]-J[46]-J[47]+J[48]+J[49]+
    J[50]-J[51]-J[52]+J[53]+J[54]+J[55]+J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]-H[1]+
    H[2]+H[3]+H[4]-H[5]-H[6]+H[7]-H[8]+H[9]+H[10]+H[11]-J[0]+J[1]+J[2]+J[3]-J[4]-J[5]+J[6]-J[7]+J[8]+J[9]+
    J[10]-J[11]-J[12]-J[13]+J[14]+J[15]-J[16]+J[17]-J[18]-J[19]-J[20]+J[21]+J[22]-J[23]-J[24]+J[25]-J[26]+
    J[27]+J[28]+J[29]+J[30]-J[31]-J[32]+J[33]-J[34]+J[35]+J[36]+J[37]-J[38]-J[39]+J[40]-J[41]+J[42]+J[43]+
    J[44]+J[45]-J[46]+J[47]-J[48]-J[49]-J[50]-J[51]+J[52]-J[53]-J[54]-J[55]-J[56]+J[57]+J[58]+J[59]-J[60]-J[61]-J[62]+
    J[63]+J[64]+J[65], +H[0]-H[1]+H[2]+H[3]+H[4]-H[5]-H[6]+H[7]-H[8]+H[9]+H[10]-H[11]-J[0]+J[1]+J[2]+J[3]-J[4]-J[5]+
    J[6]-J[7]+J[8]+J[9]-J[10]-J[11]-J[12]-J[13]+J[14]+J[15]-J[16]+J[17]-J[18]-J[19]+J[20]+J[21]+J[22]-J[23]-J[24]+
    J[25]-J[26]+J[27]+J[28]-J[29]+J[30]-J[31]-J[32]+J[33]-J[34]+J[35]+J[36]-J[37]-J[38]-J[39]+J[40]-J[41]+
    J[42]+J[43]-J[44]+J[45]-J[46]+J[47]-J[48]-J[49]+J[50]-J[51]+J[52]-J[53]-J[54]+J[55]-J[56]+J[57]+J[58]-J[59]-J[60]-J[61]+
    J[62]+J[63]-J[64]-J[65], +H[0]-H[1]+H[2]+H[3]+H[4]-H[5]-H[6]+H[7]-H[8]+H[9]-H[10]+H[11]-J[0]+J[1]+J[2]+
    J[3]-J[4]-J[5]+J[6]-J[7]+J[8]-J[9]+J[10]-J[11]-J[12]-J[13]+J[14]+J[15]-J[16]+J[17]-J[18]+J[19]-J[20]+
    J[21]+J[22]-J[23]-J[24]+J[25]-J[26]+J[27]-J[28]+J[29]+J[30]-J[31]-J[32]+J[33]-J[34]+J[35]-J[36]+J[37]-J[38]-J[39]+
    J[40]-J[41]+J[42]-J[43]+J[44]+J[45]-J[46]+J[47]-J[48]+J[49]-J[50]-J[51]+J[52]-J[53]+J[54]-J[55]-J[56]+
    J[57]-J[58]+J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]-H[1]+H[2]+H[3]+H[4]-H[5]-H[6]+H[7]-H[8]+
    H[9]-H[10]-H[11]-J[0]+J[1]+J[2]+J[3]-J[4]-J[5]+J[6]-J[7]+J[8]-J[9]-J[10]-J[11]-J[12]-J[13]+J[14]+J[15]-J[16]+
    J[17]-J[18]+J[19]+J[20]+J[21]+J[22]-J[23]-J[24]+J[25]-J[26]+J[27]-J[28]-J[29]+J[30]-J[31]-J[32]+J[33]-J[34]+
    J[35]-J[36]-J[37]-J[38]-J[39]+J[40]-J[41]+J[42]-J[43]-J[44]+J[45]-J[46]+J[47]-J[48]+J[49]+J[50]-J[51]+
    J[52]-J[53]+J[54]+J[55]-J[56]+J[57]-J[58]-J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]-H[1]+H[2]+
    H[3]+H[4]-H[5]-H[6]+H[7]-H[8]-H[9]+H[10]+H[11]-J[0]+J[1]+J[2]+J[3]-J[4]-J[5]+J[6]-J[7]-J[8]+J[9]+J[10]-J[11]-J[12]-J[13]+
    J[14]+J[15]-J[16]+J[17]+J[18]-J[19]-J[20]+J[21]+J[22]-J[23]-J[24]+J[25]-J[26]-J[27]+J[28]+J[29]+J[30]-J[31]-J[32]+
    J[33]-J[34]-J[35]+J[36]+J[37]-J[38]-J[39]+J[40]-J[41]-J[42]+J[43]+J[44]+J[45]-J[46]+J[47]+J[48]-J[49]-J[50]-J[51]+
    J[52]+J[53]-J[54]-J[55]-J[56]-J[57]+J[58]+J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]-H[1]+H[2]+
    H[3]+H[4]-H[5]-H[6]+H[7]-H[8]-H[9]+H[10]-H[11]-J[0]+J[1]+J[2]+J[3]-J[4]-J[5]+J[6]-J[7]-J[8]+J[9]-J[10]-J[11]-J[12]-J[13]+
    J[14]+J[15]-J[16]+J[17]+J[18]-J[19]+J[20]+J[21]+J[22]-J[23]-J[24]+J[25]-J[26]-J[27]+J[28]-J[29]+J[30]-J[31]-J[32]+
    J[33]-J[34]-J[35]+J[36]-J[37]-J[38]-J[39]+J[40]-J[41]-J[42]+J[43]-J[44]+J[45]-J[46]+J[47]+J[48]-J[49]+
    J[50]-J[51]+J[52]+J[53]-J[54]+J[55]-J[56]-J[57]+J[58]-J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]-H[1]+
    H[2]+H[3]+H[4]-H[5]-H[6]+H[7]-H[8]-H[9]-H[10]+H[11]-J[0]+J[1]+J[2]+J[3]-J[4]-J[5]+J[6]-J[7]-J[8]-J[9]+
    J[10]-J[11]-J[12]-J[13]+J[14]+J[15]-J[16]+J[17]+J[18]+J[19]-J[20]+J[21]+J[22]-J[23]-J[24]+J[25]-J[26]-J[27]-J[28]+
    J[29]+J[30]-J[31]-J[32]+J[33]-J[34]-J[35]-J[36]+J[37]-J[38]-J[39]+J[40]-J[41]-J[42]-J[43]+J[44]+J[45]-J[46]+
    J[47]+J[48]+J[49]-J[50]-J[51]+J[52]+J[53]+J[54]-J[55]-J[56]-J[57]-J[58]+J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +
    H[0]-H[1]+H[2]+H[3]+H[4]-H[5]-H[6]+H[7]-H[8]-H[9]-H[10]-H[11]-J[0]+J[1]+J[2]+J[3]-J[4]-J[5]+J[6]-J[7]-J[8]-J[9]-J[10]-J[11]-J[12]-J[13]+
    J[14]+J[15]-J[16]+J[17]+J[18]+J[19]+J[20]+J[21]+J[22]-J[23]-J[24]+J[25]-J[26]-J[27]-J[28]-J[29]+J[30]-J[31]-J[32]+
    J[33]-J[34]-J[35]-J[36]-J[37]-J[38]-J[39]+J[40]-J[41]-J[42]-J[43]-J[44]+J[45]-J[46]+J[47]+J[48]+J[49]+
    J[50]-J[51]+J[52]+J[53]+J[54]+J[55]-J[56]-J[57]-J[58]-J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]-H[1]+
    H[2]+H[3]+H[4]-H[5]-H[6]-H[7]+H[8]+H[9]+H[10]+H[11]-J[0]+J[1]+J[2]+J[3]-J[4]-J[5]-J[6]+J[7]+J[8]+J[9]+
    J[10]-J[11]-J[12]-J[13]+J[14]+J[15]+J[16]-J[17]-J[18]-J[19]-J[20]+J[21]+J[22]-J[23]-J[24]-J[25]+J[26]+
    J[27]+J[28]+J[29]+J[30]-J[31]-J[32]-J[33]+J[34]+J[35]+J[36]+J[37]-J[38]-J[39]-J[40]+J[41]+J[42]+J[43]+
    J[44]+J[45]+J[46]-J[47]-J[48]-J[49]-J[50]+J[51]-J[52]-J[53]-J[54]-J[55]-J[56]-J[57]-J[58]-J[59]+J[60]+
    J[61]+J[62]+J[63]+J[64]+J[65], +H[0]-H[1]+H[2]+H[3]+H[4]-H[5]-H[6]-H[7]+H[8]+H[9]+H[10]-H[11]-J[0]+J[1]+
    J[2]+J[3]-J[4]-J[5]-J[6]+J[7]+J[8]+J[9]-J[10]-J[11]-J[12]-J[13]+J[14]+J[15]+J[16]-J[17]-J[18]-J[19]+
    J[20]+J[21]+J[22]-J[23]-J[24]-J[25]+J[26]+J[27]+J[28]-J[29]+J[30]-J[31]-J[32]-J[33]+J[34]+J[35]+J[36]-J[37]-J[38]-J[39]-J[40]+
    J[41]+J[42]+J[43]-J[44]+J[45]+J[46]-J[47]-J[48]-J[49]+J[50]+J[51]-J[52]-J[53]-J[54]+J[55]-J[56]-J[57]-J[58]+
    J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]-H[1]+H[2]+H[3]+H[4]-H[5]-H[6]-H[7]+H[8]+H[9]-H[10]+
    H[11]-J[0]+J[1]+J[2]+J[3]-J[4]-J[5]-J[6]+J[7]+J[8]-J[9]+J[10]-J[11]-J[12]-J[13]+J[14]+J[15]+J[16]-J[17]-J[18]+
    J[19]-J[20]+J[21]+J[22]-J[23]-J[24]-J[25]+J[26]+J[27]-J[28]+J[29]+J[30]-J[31]-J[32]-J[33]+J[34]+J[35]-J[36]+
    J[37]-J[38]-J[39]-J[40]+J[41]+J[42]-J[43]+J[44]+J[45]+J[46]-J[47]-J[48]+J[49]-J[50]+J[51]-J[52]-J[53]+
    J[54]-J[55]-J[56]-J[57]+J[58]-J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]-H[1]+H[2]+H[3]+H[4]-H[5]-H[6]-H[7]+
    H[8]+H[9]-H[10]-H[11]-J[0]+J[1]+J[2]+J[3]-J[4]-J[5]-J[6]+J[7]+J[8]-J[9]-J[10]-J[11]-J[12]-J[13]+J[14]+
    J[15]+J[16]-J[17]-J[18]+J[19]+J[20]+J[21]+J[22]-J[23]-J[24]-J[25]+J[26]+J[27]-J[28]-J[29]+J[30]-J[31]-J[32]-J[33]+
    J[34]+J[35]-J[36]-J[37]-J[38]-J[39]-J[40]+J[41]+J[42]-J[43]-J[44]+J[45]+J[46]-J[47]-J[48]+J[49]+J[50]+
    J[51]-J[52]-J[53]+J[54]+J[55]-J[56]-J[57]+J[58]+J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]-H[1]+
    H[2]+H[3]+H[4]-H[5]-H[6]-H[7]+H[8]-H[9]+H[10]+H[11]-J[0]+J[1]+J[2]+J[3]-J[4]-J[5]-J[6]+J[7]-J[8]+J[9]+
    J[10]-J[11]-J[12]-J[13]+J[14]+J[15]+J[16]-J[17]+J[18]-J[19]-J[20]+J[21]+J[22]-J[23]-J[24]-J[25]+J[26]-J[27]+
    J[28]+J[29]+J[30]-J[31]-J[32]-J[33]+J[34]-J[35]+J[36]+J[37]-J[38]-J[39]-J[40]+J[41]-J[42]+J[43]+J[44]+
    J[45]+J[46]-J[47]+J[48]-J[49]-J[50]+J[51]-J[52]+J[53]-J[54]-J[55]-J[56]+J[57]-J[58]-J[59]-J[60]+J[61]+
    J[62]-J[63]-J[64]+J[65], +H[0]-H[1]+H[2]+H[3]+H[4]-H[5]-H[6]-H[7]+H[8]-H[9]+H[10]-H[11]-J[0]+J[1]+J[2]+
    J[3]-J[4]-J[5]-J[6]+J[7]-J[8]+J[9]-J[10]-J[11]-J[12]-J[13]+J[14]+J[15]+J[16]-J[17]+J[18]-J[19]+J[20]+
    J[21]+J[22]-J[23]-J[24]-J[25]+J[26]-J[27]+J[28]-J[29]+J[30]-J[31]-J[32]-J[33]+J[34]-J[35]+J[36]-J[37]-J[38]-J[39]-J[40]+
    J[41]-J[42]+J[43]-J[44]+J[45]+J[46]-J[47]+J[48]-J[49]+J[50]+J[51]-J[52]+J[53]-J[54]+J[55]-J[56]+J[57]-J[58]+
    J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]-H[1]+H[2]+H[3]+H[4]-H[5]-H[6]-H[7]+H[8]-H[9]-H[10]+
    H[11]-J[0]+J[1]+J[2]+J[3]-J[4]-J[5]-J[6]+J[7]-J[8]-J[9]+J[10]-J[11]-J[12]-J[13]+J[14]+J[15]+J[16]-J[17]+
    J[18]+J[19]-J[20]+J[21]+J[22]-J[23]-J[24]-J[25]+J[26]-J[27]-J[28]+J[29]+J[30]-J[31]-J[32]-J[33]+J[34]-J[35]-J[36]+
    J[37]-J[38]-J[39]-J[40]+J[41]-J[42]-J[43]+J[44]+J[45]+J[46]-J[47]+J[48]+J[49]-J[50]+J[51]-J[52]+J[53]+
    J[54]-J[55]-J[56]+J[57]+J[58]-J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]-H[1]+H[2]+H[3]+H[4]-H[5]-H[6]-H[7]+
    H[8]-H[9]-H[10]-H[11]-J[0]+J[1]+J[2]+J[3]-J[4]-J[5]-J[6]+J[7]-J[8]-J[9]-J[10]-J[11]-J[12]-J[13]+J[14]+
    J[15]+J[16]-J[17]+J[18]+J[19]+J[20]+J[21]+J[22]-J[23]-J[24]-J[25]+J[26]-J[27]-J[28]-J[29]+J[30]-J[31]-J[32]-J[33]+
    J[34]-J[35]-J[36]-J[37]-J[38]-J[39]-J[40]+J[41]-J[42]-J[43]-J[44]+J[45]+J[46]-J[47]+J[48]+J[49]+J[50]+
    J[51]-J[52]+J[53]+J[54]+J[55]-J[56]+J[57]+J[58]+J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]-H[1]+
    H[2]+H[3]+H[4]-H[5]-H[6]-H[7]-H[8]+H[9]+H[10]+H[11]-J[0]+J[1]+J[2]+J[3]-J[4]-J[5]-J[6]-J[7]+J[8]+J[9]+
    J[10]-J[11]-J[12]-J[13]+J[14]+J[15]+J[16]+J[17]-J[18]-J[19]-J[20]+J[21]+J[22]-J[23]-J[24]-J[25]-J[26]+
    J[27]+J[28]+J[29]+J[30]-J[31]-J[32]-J[33]-J[34]+J[35]+J[36]+J[37]-J[38]-J[39]-J[40]-J[41]+J[42]+J[43]+
    J[44]+J[45]+J[46]+J[47]-J[48]-J[49]-J[50]+J[51]+J[52]-J[53]-J[54]-J[55]+J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+
    J[63]+J[64]+J[65], +H[0]-H[1]+H[2]+H[3]+H[4]-H[5]-H[6]-H[7]-H[8]+H[9]+H[10]-H[11]-J[0]+J[1]+J[2]+J[3]-J[4]-J[5]-J[6]-J[7]+
    J[8]+J[9]-J[10]-J[11]-J[12]-J[13]+J[14]+J[15]+J[16]+J[17]-J[18]-J[19]+J[20]+J[21]+J[22]-J[23]-J[24]-J[25]-J[26]+
    J[27]+J[28]-J[29]+J[30]-J[31]-J[32]-J[33]-J[34]+J[35]+J[36]-J[37]-J[38]-J[39]-J[40]-J[41]+J[42]+J[43]-J[44]+
    J[45]+J[46]+J[47]-J[48]-J[49]+J[50]+J[51]+J[52]-J[53]-J[54]+J[55]+J[56]-J[57]-J[58]+J[59]-J[60]-J[61]+
    J[62]+J[63]-J[64]-J[65], +H[0]-H[1]+H[2]+H[3]+H[4]-H[5]-H[6]-H[7]-H[8]+H[9]-H[10]+H[11]-J[0]+J[1]+J[2]+
    J[3]-J[4]-J[5]-J[6]-J[7]+J[8]-J[9]+J[10]-J[11]-J[12]-J[13]+J[14]+J[15]+J[16]+J[17]-J[18]+J[19]-J[20]+
    J[21]+J[22]-J[23]-J[24]-J[25]-J[26]+J[27]-J[28]+J[29]+J[30]-J[31]-J[32]-J[33]-J[34]+J[35]-J[36]+J[37]-J[38]-J[39]-J[40]-J[41]+
    J[42]-J[43]+J[44]+J[45]+J[46]+J[47]-J[48]+J[49]-J[50]+J[51]+J[52]-J[53]+J[54]-J[55]+J[56]-J[57]+J[58]-J[59]-J[60]+
    J[61]-J[62]-J[63]+J[64]-J[65], +H[0]-H[1]+H[2]+H[3]+H[4]-H[5]-H[6]-H[7]-H[8]+H[9]-H[10]-H[11]-J[0]+J[1]+
    J[2]+J[3]-J[4]-J[5]-J[6]-J[7]+J[8]-J[9]-J[10]-J[11]-J[12]-J[13]+J[14]+J[15]+J[16]+J[17]-J[18]+J[19]+
    J[20]+J[21]+J[22]-J[23]-J[24]-J[25]-J[26]+J[27]-J[28]-J[29]+J[30]-J[31]-J[32]-J[33]-J[34]+J[35]-J[36]-J[37]-J[38]-J[39]-J[40]-J[41]+
    J[42]-J[43]-J[44]+J[45]+J[46]+J[47]-J[48]+J[49]+J[50]+J[51]+J[52]-J[53]+J[54]+J[55]+J[56]-J[57]+J[58]+
    J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]-H[1]+H[2]+H[3]+H[4]-H[5]-H[6]-H[7]-H[8]-H[9]+H[10]+
    H[11]-J[0]+J[1]+J[2]+J[3]-J[4]-J[5]-J[6]-J[7]-J[8]+J[9]+J[10]-J[11]-J[12]-J[13]+J[14]+J[15]+J[16]+J[17]+
    J[18]-J[19]-J[20]+J[21]+J[22]-J[23]-J[24]-J[25]-J[26]-J[27]+J[28]+J[29]+J[30]-J[31]-J[32]-J[33]-J[34]-J[35]+
    J[36]+J[37]-J[38]-J[39]-J[40]-J[41]-J[42]+J[43]+J[44]+J[45]+J[46]+J[47]+J[48]-J[49]-J[50]+J[51]+J[52]+
    J[53]-J[54]-J[55]+J[56]+J[57]-J[58]-J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]-H[1]+H[2]+H[3]+
    H[4]-H[5]-H[6]-H[7]-H[8]-H[9]+H[10]-H[11]-J[0]+J[1]+J[2]+J[3]-J[4]-J[5]-J[6]-J[7]-J[8]+J[9]-J[10]-J[11]-J[12]-J[13]+
    J[14]+J[15]+J[16]+J[17]+J[18]-J[19]+J[20]+J[21]+J[22]-J[23]-J[24]-J[25]-J[26]-J[27]+J[28]-J[29]+J[30]-J[31]-J[32]-J[33]-J[34]-J[35]+
    J[36]-J[37]-J[38]-J[39]-J[40]-J[41]-J[42]+J[43]-J[44]+J[45]+J[46]+J[47]+J[48]-J[49]+J[50]+J[51]+J[52]+
    J[53]-J[54]+J[55]+J[56]+J[57]-J[58]+J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]-H[1]+H[2]+H[3]+
    H[4]-H[5]-H[6]-H[7]-H[8]-H[9]-H[10]+H[11]-J[0]+J[1]+J[2]+J[3]-J[4]-J[5]-J[6]-J[7]-J[8]-J[9]+J[10]-J[11]-J[12]-J[13]+
    J[14]+J[15]+J[16]+J[17]+J[18]+J[19]-J[20]+J[21]+J[22]-J[23]-J[24]-J[25]-J[26]-J[27]-J[28]+J[29]+J[30]-J[31]-J[32]-J[33]-J[34]-J[35]-J[36]+
    J[37]-J[38]-J[39]-J[40]-J[41]-J[42]-J[43]+J[44]+J[45]+J[46]+J[47]+J[48]+J[49]-J[50]+J[51]+J[52]+J[53]+
    J[54]-J[55]+J[56]+J[57]+J[58]-J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]-H[1]+H[2]+H[3]+H[4]-H[5]-H[6]-H[7]-H[8]-H[9]-H[10]-H[11]-J[0]+
    J[1]+J[2]+J[3]-J[4]-J[5]-J[6]-J[7]-J[8]-J[9]-J[10]-J[11]-J[12]-J[13]+J[14]+J[15]+J[16]+J[17]+J[18]+J[19]+
    J[20]+J[21]+J[22]-J[23]-J[24]-J[25]-J[26]-J[27]-J[28]-J[29]+J[30]-J[31]-J[32]-J[33]-J[34]-J[35]-J[36]-J[37]-J[38]-J[39]-J[40]-J[41]-J[42]-J[43]-J[44]+
    J[45]+J[46]+J[47]+J[48]+J[49]+J[50]+J[51]+J[52]+J[53]+J[54]+J[55]+J[56]+J[57]+J[58]+J[59]+J[60]+J[61]+
    J[62]+J[63]+J[64]+J[65], +H[0]-H[1]+H[2]+H[3]-H[4]+H[5]+H[6]+H[7]+H[8]+H[9]+H[10]+H[11]-J[0]+J[1]+J[2]-J[3]+
    J[4]+J[5]+J[6]+J[7]+J[8]+J[9]+J[10]-J[11]-J[12]+J[13]-J[14]-J[15]-J[16]-J[17]-J[18]-J[19]-J[20]+J[21]-J[22]+
    J[23]+J[24]+J[25]+J[26]+J[27]+J[28]+J[29]-J[30]+J[31]+J[32]+J[33]+J[34]+J[35]+J[36]+J[37]-J[38]-J[39]-J[40]-J[41]-J[42]-J[43]-J[44]+
    J[45]+J[46]+J[47]+J[48]+J[49]+J[50]+J[51]+J[52]+J[53]+J[54]+J[55]+J[56]+J[57]+J[58]+J[59]+J[60]+J[61]+
    J[62]+J[63]+J[64]+J[65], +H[0]-H[1]+H[2]+H[3]-H[4]+H[5]+H[6]+H[7]+H[8]+H[9]+H[10]-H[11]-J[0]+J[1]+J[2]-J[3]+
    J[4]+J[5]+J[6]+J[7]+J[8]+J[9]-J[10]-J[11]-J[12]+J[13]-J[14]-J[15]-J[16]-J[17]-J[18]-J[19]+J[20]+J[21]-J[22]+
    J[23]+J[24]+J[25]+J[26]+J[27]+J[28]-J[29]-J[30]+J[31]+J[32]+J[33]+J[34]+J[35]+J[36]-J[37]-J[38]-J[39]-J[40]-J[41]-J[42]-J[43]+
    J[44]+J[45]+J[46]+J[47]+J[48]+J[49]-J[50]+J[51]+J[52]+J[53]+J[54]-J[55]+J[56]+J[57]+J[58]-J[59]+J[60]+
    J[61]-J[62]+J[63]-J[64]-J[65], +H[0]-H[1]+H[2]+H[3]-H[4]+H[5]+H[6]+H[7]+H[8]+H[9]-H[10]+H[11]-J[0]+J[1]+
    J[2]-J[3]+J[4]+J[5]+J[6]+J[7]+J[8]-J[9]+J[10]-J[11]-J[12]+J[13]-J[14]-J[15]-J[16]-J[17]-J[18]+J[19]-J[20]+
    J[21]-J[22]+J[23]+J[24]+J[25]+J[26]+J[27]-J[28]+J[29]-J[30]+J[31]+J[32]+J[33]+J[34]+J[35]-J[36]+J[37]-J[38]-J[39]-J[40]-J[41]-J[42]+
    J[43]-J[44]+J[45]+J[46]+J[47]+J[48]-J[49]+J[50]+J[51]+J[52]+J[53]-J[54]+J[55]+J[56]+J[57]-J[58]+J[59]+
    J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]-H[1]+H[2]+H[3]-H[4]+H[5]+H[6]+H[7]+H[8]+H[9]-H[10]-H[11]-J[0]+
    J[1]+J[2]-J[3]+J[4]+J[5]+J[6]+J[7]+J[8]-J[9]-J[10]-J[11]-J[12]+J[13]-J[14]-J[15]-J[16]-J[17]-J[18]+J[19]+
    J[20]+J[21]-J[22]+J[23]+J[24]+J[25]+J[26]+J[27]-J[28]-J[29]-J[30]+J[31]+J[32]+J[33]+J[34]+J[35]-J[36]-J[37]-J[38]-J[39]-J[40]-J[41]-J[42]+
    J[43]+J[44]+J[45]+J[46]+J[47]+J[48]-J[49]-J[50]+J[51]+J[52]+J[53]-J[54]-J[55]+J[56]+J[57]-J[58]-J[59]+
    J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]-H[1]+H[2]+H[3]-H[4]+H[5]+H[6]+H[7]+H[8]-H[9]+H[10]+H[11]-J[0]+
    J[1]+J[2]-J[3]+J[4]+J[5]+J[6]+J[7]-J[8]+J[9]+J[10]-J[11]-J[12]+J[13]-J[14]-J[15]-J[16]-J[17]+J[18]-J[19]-J[20]+
    J[21]-J[22]+J[23]+J[24]+J[25]+J[26]-J[27]+J[28]+J[29]-J[30]+J[31]+J[32]+J[33]+J[34]-J[35]+J[36]+J[37]-J[38]-J[39]-J[40]-J[41]+
    J[42]-J[43]-J[44]+J[45]+J[46]+J[47]-J[48]+J[49]+J[50]+J[51]+J[52]-J[53]+J[54]+J[55]+J[56]-J[57]+J[58]+
    J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]-H[1]+H[2]+H[3]-H[4]+H[5]+H[6]+H[7]+H[8]-H[9]+H[10]-H[11]-J[0]+
    J[1]+J[2]-J[3]+J[4]+J[5]+J[6]+J[7]-J[8]+J[9]-J[10]-J[11]-J[12]+J[13]-J[14]-J[15]-J[16]-J[17]+J[18]-J[19]+
    J[20]+J[21]-J[22]+J[23]+J[24]+J[25]+J[26]-J[27]+J[28]-J[29]-J[30]+J[31]+J[32]+J[33]+J[34]-J[35]+J[36]-J[37]-J[38]-J[39]-J[40]-J[41]+
    J[42]-J[43]+J[44]+J[45]+J[46]+J[47]-J[48]+J[49]-J[50]+J[51]+J[52]-J[53]+J[54]-J[55]+J[56]-J[57]+J[58]-J[59]-J[60]+
    J[61]-J[62]-J[63]+J[64]-J[65], +H[0]-H[1]+H[2]+H[3]-H[4]+H[5]+H[6]+H[7]+H[8]-H[9]-H[10]+H[11]-J[0]+J[1]+
    J[2]-J[3]+J[4]+J[5]+J[6]+J[7]-J[8]-J[9]+J[10]-J[11]-J[12]+J[13]-J[14]-J[15]-J[16]-J[17]+J[18]+J[19]-J[20]+
    J[21]-J[22]+J[23]+J[24]+J[25]+J[26]-J[27]-J[28]+J[29]-J[30]+J[31]+J[32]+J[33]+J[34]-J[35]-J[36]+J[37]-J[38]-J[39]-J[40]-J[41]+
    J[42]+J[43]-J[44]+J[45]+J[46]+J[47]-J[48]-J[49]+J[50]+J[51]+J[52]-J[53]-J[54]+J[55]+J[56]-J[57]-J[58]+
    J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]-H[1]+H[2]+H[3]-H[4]+H[5]+H[6]+H[7]+H[8]-H[9]-H[10]-H[11]-J[0]+
    J[1]+J[2]-J[3]+J[4]+J[5]+J[6]+J[7]-J[8]-J[9]-J[10]-J[11]-J[12]+J[13]-J[14]-J[15]-J[16]-J[17]+J[18]+J[19]+
    J[20]+J[21]-J[22]+J[23]+J[24]+J[25]+J[26]-J[27]-J[28]-J[29]-J[30]+J[31]+J[32]+J[33]+J[34]-J[35]-J[36]-J[37]-J[38]-J[39]-J[40]-J[41]+
    J[42]+J[43]+J[44]+J[45]+J[46]+J[47]-J[48]-J[49]-J[50]+J[51]+J[52]-J[53]-J[54]-J[55]+J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+
    J[63]+J[64]+J[65], +H[0]-H[1]+H[2]+H[3]-H[4]+H[5]+H[6]+H[7]-H[8]+H[9]+H[10]+H[11]-J[0]+J[1]+J[2]-J[3]+
    J[4]+J[5]+J[6]-J[7]+J[8]+J[9]+J[10]-J[11]-J[12]+J[13]-J[14]-J[15]-J[16]+J[17]-J[18]-J[19]-J[20]+J[21]-J[22]+
    J[23]+J[24]+J[25]-J[26]+J[27]+J[28]+J[29]-J[30]+J[31]+J[32]+J[33]-J[34]+J[35]+J[36]+J[37]-J[38]-J[39]-J[40]+
    J[41]-J[42]-J[43]-J[44]+J[45]+J[46]-J[47]+J[48]+J[49]+J[50]+J[51]-J[52]+J[53]+J[54]+J[55]-J[56]+J[57]+
    J[58]+J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]-H[1]+H[2]+H[3]-H[4]+H[5]+H[6]+H[7]-H[8]+H[9]+
    H[10]-H[11]-J[0]+J[1]+J[2]-J[3]+J[4]+J[5]+J[6]-J[7]+J[8]+J[9]-J[10]-J[11]-J[12]+J[13]-J[14]-J[15]-J[16]+
    J[17]-J[18]-J[19]+J[20]+J[21]-J[22]+J[23]+J[24]+J[25]-J[26]+J[27]+J[28]-J[29]-J[30]+J[31]+J[32]+J[33]-J[34]+
    J[35]+J[36]-J[37]-J[38]-J[39]-J[40]+J[41]-J[42]-J[43]+J[44]+J[45]+J[46]-J[47]+J[48]+J[49]-J[50]+J[51]-J[52]+
    J[53]+J[54]-J[55]-J[56]+J[57]+J[58]-J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]-H[1]+H[2]+H[3]-H[4]+
    H[5]+H[6]+H[7]-H[8]+H[9]-H[10]+H[11]-J[0]+J[1]+J[2]-J[3]+J[4]+J[5]+J[6]-J[7]+J[8]-J[9]+J[10]-J[11]-J[12]+
    J[13]-J[14]-J[15]-J[16]+J[17]-J[18]+J[19]-J[20]+J[21]-J[22]+J[23]+J[24]+J[25]-J[26]+J[27]-J[28]+J[29]-J[30]+
    J[31]+J[32]+J[33]-J[34]+J[35]-J[36]+J[37]-J[38]-J[39]-J[40]+J[41]-J[42]+J[43]-J[44]+J[45]+J[46]-J[47]+
    J[48]-J[49]+J[50]+J[51]-J[52]+J[53]-J[54]+J[55]-J[56]+J[57]-J[58]+J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +
    H[0]-H[1]+H[2]+H[3]-H[4]+H[5]+H[6]+H[7]-H[8]+H[9]-H[10]-H[11]-J[0]+J[1]+J[2]-J[3]+J[4]+J[5]+J[6]-J[7]+
    J[8]-J[9]-J[10]-J[11]-J[12]+J[13]-J[14]-J[15]-J[16]+J[17]-J[18]+J[19]+J[20]+J[21]-J[22]+J[23]+J[24]+
    J[25]-J[26]+J[27]-J[28]-J[29]-J[30]+J[31]+J[32]+J[33]-J[34]+J[35]-J[36]-J[37]-J[38]-J[39]-J[40]+J[41]-J[42]+
    J[43]+J[44]+J[45]+J[46]-J[47]+J[48]-J[49]-J[50]+J[51]-J[52]+J[53]-J[54]-J[55]-J[56]+J[57]-J[58]-J[59]-J[60]+
    J[61]+J[62]-J[63]-J[64]+J[65], +H[0]-H[1]+H[2]+H[3]-H[4]+H[5]+H[6]+H[7]-H[8]-H[9]+H[10]+H[11]-J[0]+J[1]+
    J[2]-J[3]+J[4]+J[5]+J[6]-J[7]-J[8]+J[9]+J[10]-J[11]-J[12]+J[13]-J[14]-J[15]-J[16]+J[17]+J[18]-J[19]-J[20]+
    J[21]-J[22]+J[23]+J[24]+J[25]-J[26]-J[27]+J[28]+J[29]-J[30]+J[31]+J[32]+J[33]-J[34]-J[35]+J[36]+J[37]-J[38]-J[39]-J[40]+
    J[41]+J[42]-J[43]-J[44]+J[45]+J[46]-J[47]-J[48]+J[49]+J[50]+J[51]-J[52]-J[53]+J[54]+J[55]-J[56]-J[57]+
    J[58]+J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]-H[1]+H[2]+H[3]-H[4]+H[5]+H[6]+H[7]-H[8]-H[9]+
    H[10]-H[11]-J[0]+J[1]+J[2]-J[3]+J[4]+J[5]+J[6]-J[7]-J[8]+J[9]-J[10]-J[11]-J[12]+J[13]-J[14]-J[15]-J[16]+
    J[17]+J[18]-J[19]+J[20]+J[21]-J[22]+J[23]+J[24]+J[25]-J[26]-J[27]+J[28]-J[29]-J[30]+J[31]+J[32]+J[33]-J[34]-J[35]+
    J[36]-J[37]-J[38]-J[39]-J[40]+J[41]+J[42]-J[43]+J[44]+J[45]+J[46]-J[47]-J[48]+J[49]-J[50]+J[51]-J[52]-J[53]+
    J[54]-J[55]-J[56]-J[57]+J[58]-J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]-H[1]+H[2]+H[3]-H[4]+H[5]+
    H[6]+H[7]-H[8]-H[9]-H[10]+H[11]-J[0]+J[1]+J[2]-J[3]+J[4]+J[5]+J[6]-J[7]-J[8]-J[9]+J[10]-J[11]-J[12]+
    J[13]-J[14]-J[15]-J[16]+J[17]+J[18]+J[19]-J[20]+J[21]-J[22]+J[23]+J[24]+J[25]-J[26]-J[27]-J[28]+J[29]-J[30]+
    J[31]+J[32]+J[33]-J[34]-J[35]-J[36]+J[37]-J[38]-J[39]-J[40]+J[41]+J[42]+J[43]-J[44]+J[45]+J[46]-J[47]-J[48]-J[49]+
    J[50]+J[51]-J[52]-J[53]-J[54]+J[55]-J[56]-J[57]-J[58]+J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]-H[1]+
    H[2]+H[3]-H[4]+H[5]+H[6]+H[7]-H[8]-H[9]-H[10]-H[11]-J[0]+J[1]+J[2]-J[3]+J[4]+J[5]+J[6]-J[7]-J[8]-J[9]-J[10]-J[11]-J[12]+
    J[13]-J[14]-J[15]-J[16]+J[17]+J[18]+J[19]+J[20]+J[21]-J[22]+J[23]+J[24]+J[25]-J[26]-J[27]-J[28]-J[29]-J[30]+
    J[31]+J[32]+J[33]-J[34]-J[35]-J[36]-J[37]-J[38]-J[39]-J[40]+J[41]+J[42]+J[43]+J[44]+J[45]+J[46]-J[47]-J[48]-J[49]-J[50]+
    J[51]-J[52]-J[53]-J[54]-J[55]-J[56]-J[57]-J[58]-J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]-H[1]+
    H[2]+H[3]-H[4]+H[5]+H[6]-H[7]+H[8]+H[9]+H[10]+H[11]-J[0]+J[1]+J[2]-J[3]+J[4]+J[5]-J[6]+J[7]+J[8]+J[9]+
    J[10]-J[11]-J[12]+J[13]-J[14]-J[15]+J[16]-J[17]-J[18]-J[19]-J[20]+J[21]-J[22]+J[23]+J[24]-J[25]+J[26]+
    J[27]+J[28]+J[29]-J[30]+J[31]+J[32]-J[33]+J[34]+J[35]+J[36]+J[37]-J[38]-J[39]+J[40]-J[41]-J[42]-J[43]-J[44]+
    J[45]-J[46]+J[47]+J[48]+J[49]+J[50]-J[51]+J[52]+J[53]+J[54]+J[55]-J[56]-J[57]-J[58]-J[59]+J[60]+J[61]+
    J[62]+J[63]+J[64]+J[65], +H[0]-H[1]+H[2]+H[3]-H[4]+H[5]+H[6]-H[7]+H[8]+H[9]+H[10]-H[11]-J[0]+J[1]+J[2]-J[3]+
    J[4]+J[5]-J[6]+J[7]+J[8]+J[9]-J[10]-J[11]-J[12]+J[13]-J[14]-J[15]+J[16]-J[17]-J[18]-J[19]+J[20]+J[21]-J[22]+
    J[23]+J[24]-J[25]+J[26]+J[27]+J[28]-J[29]-J[30]+J[31]+J[32]-J[33]+J[34]+J[35]+J[36]-J[37]-J[38]-J[39]+
    J[40]-J[41]-J[42]-J[43]+J[44]+J[45]-J[46]+J[47]+J[48]+J[49]-J[50]-J[51]+J[52]+J[53]+J[54]-J[55]-J[56]-J[57]-J[58]+
    J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]-H[1]+H[2]+H[3]-H[4]+H[5]+H[6]-H[7]+H[8]+H[9]-H[10]+
    H[11]-J[0]+J[1]+J[2]-J[3]+J[4]+J[5]-J[6]+J[7]+J[8]-J[9]+J[10]-J[11]-J[12]+J[13]-J[14]-J[15]+J[16]-J[17]-J[18]+
    J[19]-J[20]+J[21]-J[22]+J[23]+J[24]-J[25]+J[26]+J[27]-J[28]+J[29]-J[30]+J[31]+J[32]-J[33]+J[34]+J[35]-J[36]+
    J[37]-J[38]-J[39]+J[40]-J[41]-J[42]+J[43]-J[44]+J[45]-J[46]+J[47]+J[48]-J[49]+J[50]-J[51]+J[52]+J[53]-J[54]+
    J[55]-J[56]-J[57]+J[58]-J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]-H[1]+H[2]+H[3]-H[4]+H[5]+H[6]-H[7]+
    H[8]+H[9]-H[10]-H[11]-J[0]+J[1]+J[2]-J[3]+J[4]+J[5]-J[6]+J[7]+J[8]-J[9]-J[10]-J[11]-J[12]+J[13]-J[14]-J[15]+
    J[16]-J[17]-J[18]+J[19]+J[20]+J[21]-J[22]+J[23]+J[24]-J[25]+J[26]+J[27]-J[28]-J[29]-J[30]+J[31]+J[32]-J[33]+
    J[34]+J[35]-J[36]-J[37]-J[38]-J[39]+J[40]-J[41]-J[42]+J[43]+J[44]+J[45]-J[46]+J[47]+J[48]-J[49]-J[50]-J[51]+
    J[52]+J[53]-J[54]-J[55]-J[56]-J[57]+J[58]+J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]-H[1]+H[2]+
    H[3]-H[4]+H[5]+H[6]-H[7]+H[8]-H[9]+H[10]+H[11]-J[0]+J[1]+J[2]-J[3]+J[4]+J[5]-J[6]+J[7]-J[8]+J[9]+J[10]-J[11]-J[12]+
    J[13]-J[14]-J[15]+J[16]-J[17]+J[18]-J[19]-J[20]+J[21]-J[22]+J[23]+J[24]-J[25]+J[26]-J[27]+J[28]+J[29]-J[30]+
    J[31]+J[32]-J[33]+J[34]-J[35]+J[36]+J[37]-J[38]-J[39]+J[40]-J[41]+J[42]-J[43]-J[44]+J[45]-J[46]+J[47]-J[48]+
    J[49]+J[50]-J[51]+J[52]-J[53]+J[54]+J[55]-J[56]+J[57]-J[58]-J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +
    H[0]-H[1]+H[2]+H[3]-H[4]+H[5]+H[6]-H[7]+H[8]-H[9]+H[10]-H[11]-J[0]+J[1]+J[2]-J[3]+J[4]+J[5]-J[6]+J[7]-J[8]+
    J[9]-J[10]-J[11]-J[12]+J[13]-J[14]-J[15]+J[16]-J[17]+J[18]-J[19]+J[20]+J[21]-J[22]+J[23]+J[24]-J[25]+
    J[26]-J[27]+J[28]-J[29]-J[30]+J[31]+J[32]-J[33]+J[34]-J[35]+J[36]-J[37]-J[38]-J[39]+J[40]-J[41]+J[42]-J[43]+
    J[44]+J[45]-J[46]+J[47]-J[48]+J[49]-J[50]-J[51]+J[52]-J[53]+J[54]-J[55]-J[56]+J[57]-J[58]+J[59]-J[60]+
    J[61]-J[62]-J[63]+J[64]-J[65], +H[0]-H[1]+H[2]+H[3]-H[4]+H[5]+H[6]-H[7]+H[8]-H[9]-H[10]+H[11]-J[0]+J[1]+
    J[2]-J[3]+J[4]+J[5]-J[6]+J[7]-J[8]-J[9]+J[10]-J[11]-J[12]+J[13]-J[14]-J[15]+J[16]-J[17]+J[18]+J[19]-J[20]+
    J[21]-J[22]+J[23]+J[24]-J[25]+J[26]-J[27]-J[28]+J[29]-J[30]+J[31]+J[32]-J[33]+J[34]-J[35]-J[36]+J[37]-J[38]-J[39]+
    J[40]-J[41]+J[42]+J[43]-J[44]+J[45]-J[46]+J[47]-J[48]-J[49]+J[50]-J[51]+J[52]-J[53]-J[54]+J[55]-J[56]+
    J[57]+J[58]-J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]-H[1]+H[2]+H[3]-H[4]+H[5]+H[6]-H[7]+H[8]-H[9]-H[10]-H[11]-J[0]+
    J[1]+J[2]-J[3]+J[4]+J[5]-J[6]+J[7]-J[8]-J[9]-J[10]-J[11]-J[12]+J[13]-J[14]-J[15]+J[16]-J[17]+J[18]+J[19]+
    J[20]+J[21]-J[22]+J[23]+J[24]-J[25]+J[26]-J[27]-J[28]-J[29]-J[30]+J[31]+J[32]-J[33]+J[34]-J[35]-J[36]-J[37]-J[38]-J[39]+
    J[40]-J[41]+J[42]+J[43]+J[44]+J[45]-J[46]+J[47]-J[48]-J[49]-J[50]-J[51]+J[52]-J[53]-J[54]-J[55]-J[56]+
    J[57]+J[58]+J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]-H[1]+H[2]+H[3]-H[4]+H[5]+H[6]-H[7]-H[8]+
    H[9]+H[10]+H[11]-J[0]+J[1]+J[2]-J[3]+J[4]+J[5]-J[6]-J[7]+J[8]+J[9]+J[10]-J[11]-J[12]+J[13]-J[14]-J[15]+
    J[16]+J[17]-J[18]-J[19]-J[20]+J[21]-J[22]+J[23]+J[24]-J[25]-J[26]+J[27]+J[28]+J[29]-J[30]+J[31]+J[32]-J[33]-J[34]+
    J[35]+J[36]+J[37]-J[38]-J[39]+J[40]+J[41]-J[42]-J[43]-J[44]+J[45]-J[46]-J[47]+J[48]+J[49]+J[50]-J[51]-J[52]+
    J[53]+J[54]+J[55]+J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]-H[1]+H[2]+H[3]-H[4]+
    H[5]+H[6]-H[7]-H[8]+H[9]+H[10]-H[11]-J[0]+J[1]+J[2]-J[3]+J[4]+J[5]-J[6]-J[7]+J[8]+J[9]-J[10]-J[11]-J[12]+
    J[13]-J[14]-J[15]+J[16]+J[17]-J[18]-J[19]+J[20]+J[21]-J[22]+J[23]+J[24]-J[25]-J[26]+J[27]+J[28]-J[29]-J[30]+
    J[31]+J[32]-J[33]-J[34]+J[35]+J[36]-J[37]-J[38]-J[39]+J[40]+J[41]-J[42]-J[43]+J[44]+J[45]-J[46]-J[47]+
    J[48]+J[49]-J[50]-J[51]-J[52]+J[53]+J[54]-J[55]+J[56]-J[57]-J[58]+J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +
    H[0]-H[1]+H[2]+H[3]-H[4]+H[5]+H[6]-H[7]-H[8]+H[9]-H[10]+H[11]-J[0]+J[1]+J[2]-J[3]+J[4]+J[5]-J[6]-J[7]+
    J[8]-J[9]+J[10]-J[11]-J[12]+J[13]-J[14]-J[15]+J[16]+J[17]-J[18]+J[19]-J[20]+J[21]-J[22]+J[23]+J[24]-J[25]-J[26]+
    J[27]-J[28]+J[29]-J[30]+J[31]+J[32]-J[33]-J[34]+J[35]-J[36]+J[37]-J[38]-J[39]+J[40]+J[41]-J[42]+J[43]-J[44]+
    J[45]-J[46]-J[47]+J[48]-J[49]+J[50]-J[51]-J[52]+J[53]-J[54]+J[55]+J[56]-J[57]+J[58]-J[59]-J[60]+J[61]-J[62]-J[63]+
    J[64]-J[65], +H[0]-H[1]+H[2]+H[3]-H[4]+H[5]+H[6]-H[7]-H[8]+H[9]-H[10]-H[11]-J[0]+J[1]+J[2]-J[3]+J[4]+
    J[5]-J[6]-J[7]+J[8]-J[9]-J[10]-J[11]-J[12]+J[13]-J[14]-J[15]+J[16]+J[17]-J[18]+J[19]+J[20]+J[21]-J[22]+
    J[23]+J[24]-J[25]-J[26]+J[27]-J[28]-J[29]-J[30]+J[31]+J[32]-J[33]-J[34]+J[35]-J[36]-J[37]-J[38]-J[39]+
    J[40]+J[41]-J[42]+J[43]+J[44]+J[45]-J[46]-J[47]+J[48]-J[49]-J[50]-J[51]-J[52]+J[53]-J[54]-J[55]+J[56]-J[57]+
    J[58]+J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]-H[1]+H[2]+H[3]-H[4]+H[5]+H[6]-H[7]-H[8]-H[9]+
    H[10]+H[11]-J[0]+J[1]+J[2]-J[3]+J[4]+J[5]-J[6]-J[7]-J[8]+J[9]+J[10]-J[11]-J[12]+J[13]-J[14]-J[15]+J[16]+
    J[17]+J[18]-J[19]-J[20]+J[21]-J[22]+J[23]+J[24]-J[25]-J[26]-J[27]+J[28]+J[29]-J[30]+J[31]+J[32]-J[33]-J[34]-J[35]+
    J[36]+J[37]-J[38]-J[39]+J[40]+J[41]+J[42]-J[43]-J[44]+J[45]-J[46]-J[47]-J[48]+J[49]+J[50]-J[51]-J[52]-J[53]+
    J[54]+J[55]+J[56]+J[57]-J[58]-J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]-H[1]+H[2]+H[3]-H[4]+H[5]+
    H[6]-H[7]-H[8]-H[9]+H[10]-H[11]-J[0]+J[1]+J[2]-J[3]+J[4]+J[5]-J[6]-J[7]-J[8]+J[9]-J[10]-J[11]-J[12]+
    J[13]-J[14]-J[15]+J[16]+J[17]+J[18]-J[19]+J[20]+J[21]-J[22]+J[23]+J[24]-J[25]-J[26]-J[27]+J[28]-J[29]-J[30]+
    J[31]+J[32]-J[33]-J[34]-J[35]+J[36]-J[37]-J[38]-J[39]+J[40]+J[41]+J[42]-J[43]+J[44]+J[45]-J[46]-J[47]-J[48]+
    J[49]-J[50]-J[51]-J[52]-J[53]+J[54]-J[55]+J[56]+J[57]-J[58]+J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +
    H[0]-H[1]+H[2]+H[3]-H[4]+H[5]+H[6]-H[7]-H[8]-H[9]-H[10]+H[11]-J[0]+J[1]+J[2]-J[3]+J[4]+J[5]-J[6]-J[7]-J[8]-J[9]+
    J[10]-J[11]-J[12]+J[13]-J[14]-J[15]+J[16]+J[17]+J[18]+J[19]-J[20]+J[21]-J[22]+J[23]+J[24]-J[25]-J[26]-J[27]-J[28]+
    J[29]-J[30]+J[31]+J[32]-J[33]-J[34]-J[35]-J[36]+J[37]-J[38]-J[39]+J[40]+J[41]+J[42]+J[43]-J[44]+J[45]-J[46]-J[47]-J[48]-J[49]+
    J[50]-J[51]-J[52]-J[53]-J[54]+J[55]+J[56]+J[57]+J[58]-J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]-H[1]+
    H[2]+H[3]-H[4]+H[5]+H[6]-H[7]-H[8]-H[9]-H[10]-H[11]-J[0]+J[1]+J[2]-J[3]+J[4]+J[5]-J[6]-J[7]-J[8]-J[9]-J[10]-J[11]-J[12]+
    J[13]-J[14]-J[15]+J[16]+J[17]+J[18]+J[19]+J[20]+J[21]-J[22]+J[23]+J[24]-J[25]-J[26]-J[27]-J[28]-J[29]-J[30]+
    J[31]+J[32]-J[33]-J[34]-J[35]-J[36]-J[37]-J[38]-J[39]+J[40]+J[41]+J[42]+J[43]+J[44]+J[45]-J[46]-J[47]-J[48]-J[49]-J[50]-J[51]-J[52]-J[53]-J[54]-J[55]+
    J[56]+J[57]+J[58]+J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]-H[1]+H[2]+H[3]-H[4]+H[5]-H[6]+H[7]+
    H[8]+H[9]+H[10]+H[11]-J[0]+J[1]+J[2]-J[3]+J[4]-J[5]+J[6]+J[7]+J[8]+J[9]+J[10]-J[11]-J[12]+J[13]-J[14]+
    J[15]-J[16]-J[17]-J[18]-J[19]-J[20]+J[21]-J[22]+J[23]-J[24]+J[25]+J[26]+J[27]+J[28]+J[29]-J[30]+J[31]-J[32]+
    J[33]+J[34]+J[35]+J[36]+J[37]-J[38]+J[39]-J[40]-J[41]-J[42]-J[43]-J[44]-J[45]+J[46]+J[47]+J[48]+J[49]+
    J[50]-J[51]-J[52]-J[53]-J[54]-J[55]+J[56]+J[57]+J[58]+J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]-H[1]+
    H[2]+H[3]-H[4]+H[5]-H[6]+H[7]+H[8]+H[9]+H[10]-H[11]-J[0]+J[1]+J[2]-J[3]+J[4]-J[5]+J[6]+J[7]+J[8]+J[9]-J[10]-J[11]-J[12]+
    J[13]-J[14]+J[15]-J[16]-J[17]-J[18]-J[19]+J[20]+J[21]-J[22]+J[23]-J[24]+J[25]+J[26]+J[27]+J[28]-J[29]-J[30]+
    J[31]-J[32]+J[33]+J[34]+J[35]+J[36]-J[37]-J[38]+J[39]-J[40]-J[41]-J[42]-J[43]+J[44]-J[45]+J[46]+J[47]+
    J[48]+J[49]-J[50]-J[51]-J[52]-J[53]-J[54]+J[55]+J[56]+J[57]+J[58]-J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +
    H[0]-H[1]+H[2]+H[3]-H[4]+H[5]-H[6]+H[7]+H[8]+H[9]-H[10]+H[11]-J[0]+J[1]+J[2]-J[3]+J[4]-J[5]+J[6]+J[7]+
    J[8]-J[9]+J[10]-J[11]-J[12]+J[13]-J[14]+J[15]-J[16]-J[17]-J[18]+J[19]-J[20]+J[21]-J[22]+J[23]-J[24]+
    J[25]+J[26]+J[27]-J[28]+J[29]-J[30]+J[31]-J[32]+J[33]+J[34]+J[35]-J[36]+J[37]-J[38]+J[39]-J[40]-J[41]-J[42]+
    J[43]-J[44]-J[45]+J[46]+J[47]+J[48]-J[49]+J[50]-J[51]-J[52]-J[53]+J[54]-J[55]+J[56]+J[57]-J[58]+J[59]+
    J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]-H[1]+H[2]+H[3]-H[4]+H[5]-H[6]+H[7]+H[8]+H[9]-H[10]-H[11]-J[0]+
    J[1]+J[2]-J[3]+J[4]-J[5]+J[6]+J[7]+J[8]-J[9]-J[10]-J[11]-J[12]+J[13]-J[14]+J[15]-J[16]-J[17]-J[18]+J[19]+
    J[20]+J[21]-J[22]+J[23]-J[24]+J[25]+J[26]+J[27]-J[28]-J[29]-J[30]+J[31]-J[32]+J[33]+J[34]+J[35]-J[36]-J[37]-J[38]+
    J[39]-J[40]-J[41]-J[42]+J[43]+J[44]-J[45]+J[46]+J[47]+J[48]-J[49]-J[50]-J[51]-J[52]-J[53]+J[54]+J[55]+
    J[56]+J[57]-J[58]-J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]-H[1]+H[2]+H[3]-H[4]+H[5]-H[6]+H[7]+
    H[8]-H[9]+H[10]+H[11]-J[0]+J[1]+J[2]-J[3]+J[4]-J[5]+J[6]+J[7]-J[8]+J[9]+J[10]-J[11]-J[12]+J[13]-J[14]+
    J[15]-J[16]-J[17]+J[18]-J[19]-J[20]+J[21]-J[22]+J[23]-J[24]+J[25]+J[26]-J[27]+J[28]+J[29]-J[30]+J[31]-J[32]+
    J[33]+J[34]-J[35]+J[36]+J[37]-J[38]+J[39]-J[40]-J[41]+J[42]-J[43]-J[44]-J[45]+J[46]+J[47]-J[48]+J[49]+
    J[50]-J[51]-J[52]+J[53]-J[54]-J[55]+J[56]-J[57]+J[58]+J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]-H[1]+
    H[2]+H[3]-H[4]+H[5]-H[6]+H[7]+H[8]-H[9]+H[10]-H[11]-J[0]+J[1]+J[2]-J[3]+J[4]-J[5]+J[6]+J[7]-J[8]+J[9]-J[10]-J[11]-J[12]+
    J[13]-J[14]+J[15]-J[16]-J[17]+J[18]-J[19]+J[20]+J[21]-J[22]+J[23]-J[24]+J[25]+J[26]-J[27]+J[28]-J[29]-J[30]+
    J[31]-J[32]+J[33]+J[34]-J[35]+J[36]-J[37]-J[38]+J[39]-J[40]-J[41]+J[42]-J[43]+J[44]-J[45]+J[46]+J[47]-J[48]+
    J[49]-J[50]-J[51]-J[52]+J[53]-J[54]+J[55]+J[56]-J[57]+J[58]-J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +
    H[0]-H[1]+H[2]+H[3]-H[4]+H[5]-H[6]+H[7]+H[8]-H[9]-H[10]+H[11]-J[0]+J[1]+J[2]-J[3]+J[4]-J[5]+J[6]+J[7]-J[8]-J[9]+
    J[10]-J[11]-J[12]+J[13]-J[14]+J[15]-J[16]-J[17]+J[18]+J[19]-J[20]+J[21]-J[22]+J[23]-J[24]+J[25]+J[26]-J[27]-J[28]+
    J[29]-J[30]+J[31]-J[32]+J[33]+J[34]-J[35]-J[36]+J[37]-J[38]+J[39]-J[40]-J[41]+J[42]+J[43]-J[44]-J[45]+
    J[46]+J[47]-J[48]-J[49]+J[50]-J[51]-J[52]+J[53]+J[54]-J[55]+J[56]-J[57]-J[58]+J[59]-J[60]-J[61]+J[62]+
    J[63]-J[64]-J[65], +H[0]-H[1]+H[2]+H[3]-H[4]+H[5]-H[6]+H[7]+H[8]-H[9]-H[10]-H[11]-J[0]+J[1]+J[2]-J[3]+
    J[4]-J[5]+J[6]+J[7]-J[8]-J[9]-J[10]-J[11]-J[12]+J[13]-J[14]+J[15]-J[16]-J[17]+J[18]+J[19]+J[20]+J[21]-J[22]+
    J[23]-J[24]+J[25]+J[26]-J[27]-J[28]-J[29]-J[30]+J[31]-J[32]+J[33]+J[34]-J[35]-J[36]-J[37]-J[38]+J[39]-J[40]-J[41]+
    J[42]+J[43]+J[44]-J[45]+J[46]+J[47]-J[48]-J[49]-J[50]-J[51]-J[52]+J[53]+J[54]+J[55]+J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+
    J[63]+J[64]+J[65], +H[0]-H[1]+H[2]+H[3]-H[4]+H[5]-H[6]+H[7]-H[8]+H[9]+H[10]+H[11]-J[0]+J[1]+J[2]-J[3]+
    J[4]-J[5]+J[6]-J[7]+J[8]+J[9]+J[10]-J[11]-J[12]+J[13]-J[14]+J[15]-J[16]+J[17]-J[18]-J[19]-J[20]+J[21]-J[22]+
    J[23]-J[24]+J[25]-J[26]+J[27]+J[28]+J[29]-J[30]+J[31]-J[32]+J[33]-J[34]+J[35]+J[36]+J[37]-J[38]+J[39]-J[40]+
    J[41]-J[42]-J[43]-J[44]-J[45]+J[46]-J[47]+J[48]+J[49]+J[50]-J[51]+J[52]-J[53]-J[54]-J[55]-J[56]+J[57]+
    J[58]+J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]-H[1]+H[2]+H[3]-H[4]+H[5]-H[6]+H[7]-H[8]+H[9]+
    H[10]-H[11]-J[0]+J[1]+J[2]-J[3]+J[4]-J[5]+J[6]-J[7]+J[8]+J[9]-J[10]-J[11]-J[12]+J[13]-J[14]+J[15]-J[16]+
    J[17]-J[18]-J[19]+J[20]+J[21]-J[22]+J[23]-J[24]+J[25]-J[26]+J[27]+J[28]-J[29]-J[30]+J[31]-J[32]+J[33]-J[34]+
    J[35]+J[36]-J[37]-J[38]+J[39]-J[40]+J[41]-J[42]-J[43]+J[44]-J[45]+J[46]-J[47]+J[48]+J[49]-J[50]-J[51]+
    J[52]-J[53]-J[54]+J[55]-J[56]+J[57]+J[58]-J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]-H[1]+H[2]+
    H[3]-H[4]+H[5]-H[6]+H[7]-H[8]+H[9]-H[10]+H[11]-J[0]+J[1]+J[2]-J[3]+J[4]-J[5]+J[6]-J[7]+J[8]-J[9]+J[10]-J[11]-J[12]+
    J[13]-J[14]+J[15]-J[16]+J[17]-J[18]+J[19]-J[20]+J[21]-J[22]+J[23]-J[24]+J[25]-J[26]+J[27]-J[28]+J[29]-J[30]+
    J[31]-J[32]+J[33]-J[34]+J[35]-J[36]+J[37]-J[38]+J[39]-J[40]+J[41]-J[42]+J[43]-J[44]-J[45]+J[46]-J[47]+
    J[48]-J[49]+J[50]-J[51]+J[52]-J[53]+J[54]-J[55]-J[56]+J[57]-J[58]+J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +
    H[0]-H[1]+H[2]+H[3]-H[4]+H[5]-H[6]+H[7]-H[8]+H[9]-H[10]-H[11]-J[0]+J[1]+J[2]-J[3]+J[4]-J[5]+J[6]-J[7]+
    J[8]-J[9]-J[10]-J[11]-J[12]+J[13]-J[14]+J[15]-J[16]+J[17]-J[18]+J[19]+J[20]+J[21]-J[22]+J[23]-J[24]+
    J[25]-J[26]+J[27]-J[28]-J[29]-J[30]+J[31]-J[32]+J[33]-J[34]+J[35]-J[36]-J[37]-J[38]+J[39]-J[40]+J[41]-J[42]+
    J[43]+J[44]-J[45]+J[46]-J[47]+J[48]-J[49]-J[50]-J[51]+J[52]-J[53]+J[54]+J[55]-J[56]+J[57]-J[58]-J[59]-J[60]+
    J[61]+J[62]-J[63]-J[64]+J[65], +H[0]-H[1]+H[2]+H[3]-H[4]+H[5]-H[6]+H[7]-H[8]-H[9]+H[10]+H[11]-J[0]+J[1]+
    J[2]-J[3]+J[4]-J[5]+J[6]-J[7]-J[8]+J[9]+J[10]-J[11]-J[12]+J[13]-J[14]+J[15]-J[16]+J[17]+J[18]-J[19]-J[20]+
    J[21]-J[22]+J[23]-J[24]+J[25]-J[26]-J[27]+J[28]+J[29]-J[30]+J[31]-J[32]+J[33]-J[34]-J[35]+J[36]+J[37]-J[38]+
    J[39]-J[40]+J[41]+J[42]-J[43]-J[44]-J[45]+J[46]-J[47]-J[48]+J[49]+J[50]-J[51]+J[52]+J[53]-J[54]-J[55]-J[56]-J[57]+
    J[58]+J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]-H[1]+H[2]+H[3]-H[4]+H[5]-H[6]+H[7]-H[8]-H[9]+
    H[10]-H[11]-J[0]+J[1]+J[2]-J[3]+J[4]-J[5]+J[6]-J[7]-J[8]+J[9]-J[10]-J[11]-J[12]+J[13]-J[14]+J[15]-J[16]+
    J[17]+J[18]-J[19]+J[20]+J[21]-J[22]+J[23]-J[24]+J[25]-J[26]-J[27]+J[28]-J[29]-J[30]+J[31]-J[32]+J[33]-J[34]-J[35]+
    J[36]-J[37]-J[38]+J[39]-J[40]+J[41]+J[42]-J[43]+J[44]-J[45]+J[46]-J[47]-J[48]+J[49]-J[50]-J[51]+J[52]+
    J[53]-J[54]+J[55]-J[56]-J[57]+J[58]-J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]-H[1]+H[2]+H[3]-H[4]+
    H[5]-H[6]+H[7]-H[8]-H[9]-H[10]+H[11]-J[0]+J[1]+J[2]-J[3]+J[4]-J[5]+J[6]-J[7]-J[8]-J[9]+J[10]-J[11]-J[12]+
    J[13]-J[14]+J[15]-J[16]+J[17]+J[18]+J[19]-J[20]+J[21]-J[22]+J[23]-J[24]+J[25]-J[26]-J[27]-J[28]+J[29]-J[30]+
    J[31]-J[32]+J[33]-J[34]-J[35]-J[36]+J[37]-J[38]+J[39]-J[40]+J[41]+J[42]+J[43]-J[44]-J[45]+J[46]-J[47]-J[48]-J[49]+
    J[50]-J[51]+J[52]+J[53]+J[54]-J[55]-J[56]-J[57]-J[58]+J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]-H[1]+
    H[2]+H[3]-H[4]+H[5]-H[6]+H[7]-H[8]-H[9]-H[10]-H[11]-J[0]+J[1]+J[2]-J[3]+J[4]-J[5]+J[6]-J[7]-J[8]-J[9]-J[10]-J[11]-J[12]+
    J[13]-J[14]+J[15]-J[16]+J[17]+J[18]+J[19]+J[20]+J[21]-J[22]+J[23]-J[24]+J[25]-J[26]-J[27]-J[28]-J[29]-J[30]+
    J[31]-J[32]+J[33]-J[34]-J[35]-J[36]-J[37]-J[38]+J[39]-J[40]+J[41]+J[42]+J[43]+J[44]-J[45]+J[46]-J[47]-J[48]-J[49]-J[50]-J[51]+
    J[52]+J[53]+J[54]+J[55]-J[56]-J[57]-J[58]-J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]-H[1]+H[2]+
    H[3]-H[4]+H[5]-H[6]-H[7]+H[8]+H[9]+H[10]+H[11]-J[0]+J[1]+J[2]-J[3]+J[4]-J[5]-J[6]+J[7]+J[8]+J[9]+J[10]-J[11]-J[12]+
    J[13]-J[14]+J[15]+J[16]-J[17]-J[18]-J[19]-J[20]+J[21]-J[22]+J[23]-J[24]-J[25]+J[26]+J[27]+J[28]+J[29]-J[30]+
    J[31]-J[32]-J[33]+J[34]+J[35]+J[36]+J[37]-J[38]+J[39]+J[40]-J[41]-J[42]-J[43]-J[44]-J[45]-J[46]+J[47]+
    J[48]+J[49]+J[50]+J[51]-J[52]-J[53]-J[54]-J[55]-J[56]-J[57]-J[58]-J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+
    J[65], +H[0]-H[1]+H[2]+H[3]-H[4]+H[5]-H[6]-H[7]+H[8]+H[9]+H[10]-H[11]-J[0]+J[1]+J[2]-J[3]+J[4]-J[5]-J[6]+
    J[7]+J[8]+J[9]-J[10]-J[11]-J[12]+J[13]-J[14]+J[15]+J[16]-J[17]-J[18]-J[19]+J[20]+J[21]-J[22]+J[23]-J[24]-J[25]+
    J[26]+J[27]+J[28]-J[29]-J[30]+J[31]-J[32]-J[33]+J[34]+J[35]+J[36]-J[37]-J[38]+J[39]+J[40]-J[41]-J[42]-J[43]+
    J[44]-J[45]-J[46]+J[47]+J[48]+J[49]-J[50]+J[51]-J[52]-J[53]-J[54]+J[55]-J[56]-J[57]-J[58]+J[59]+J[60]+
    J[61]-J[62]+J[63]-J[64]-J[65], +H[0]-H[1]+H[2]+H[3]-H[4]+H[5]-H[6]-H[7]+H[8]+H[9]-H[10]+H[11]-J[0]+J[1]+
    J[2]-J[3]+J[4]-J[5]-J[6]+J[7]+J[8]-J[9]+J[10]-J[11]-J[12]+J[13]-J[14]+J[15]+J[16]-J[17]-J[18]+J[19]-J[20]+
    J[21]-J[22]+J[23]-J[24]-J[25]+J[26]+J[27]-J[28]+J[29]-J[30]+J[31]-J[32]-J[33]+J[34]+J[35]-J[36]+J[37]-J[38]+
    J[39]+J[40]-J[41]-J[42]+J[43]-J[44]-J[45]-J[46]+J[47]+J[48]-J[49]+J[50]+J[51]-J[52]-J[53]+J[54]-J[55]-J[56]-J[57]+
    J[58]-J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]-H[1]+H[2]+H[3]-H[4]+H[5]-H[6]-H[7]+H[8]+H[9]-H[10]-H[11]-J[0]+
    J[1]+J[2]-J[3]+J[4]-J[5]-J[6]+J[7]+J[8]-J[9]-J[10]-J[11]-J[12]+J[13]-J[14]+J[15]+J[16]-J[17]-J[18]+J[19]+
    J[20]+J[21]-J[22]+J[23]-J[24]-J[25]+J[26]+J[27]-J[28]-J[29]-J[30]+J[31]-J[32]-J[33]+J[34]+J[35]-J[36]-J[37]-J[38]+
    J[39]+J[40]-J[41]-J[42]+J[43]+J[44]-J[45]-J[46]+J[47]+J[48]-J[49]-J[50]+J[51]-J[52]-J[53]+J[54]+J[55]-J[56]-J[57]+
    J[58]+J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]-H[1]+H[2]+H[3]-H[4]+H[5]-H[6]-H[7]+H[8]-H[9]+
    H[10]+H[11]-J[0]+J[1]+J[2]-J[3]+J[4]-J[5]-J[6]+J[7]-J[8]+J[9]+J[10]-J[11]-J[12]+J[13]-J[14]+J[15]+J[16]-J[17]+
    J[18]-J[19]-J[20]+J[21]-J[22]+J[23]-J[24]-J[25]+J[26]-J[27]+J[28]+J[29]-J[30]+J[31]-J[32]-J[33]+J[34]-J[35]+
    J[36]+J[37]-J[38]+J[39]+J[40]-J[41]+J[42]-J[43]-J[44]-J[45]-J[46]+J[47]-J[48]+J[49]+J[50]+J[51]-J[52]+
    J[53]-J[54]-J[55]-J[56]+J[57]-J[58]-J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]-H[1]+H[2]+H[3]-H[4]+
    H[5]-H[6]-H[7]+H[8]-H[9]+H[10]-H[11]-J[0]+J[1]+J[2]-J[3]+J[4]-J[5]-J[6]+J[7]-J[8]+J[9]-J[10]-J[11]-J[12]+
    J[13]-J[14]+J[15]+J[16]-J[17]+J[18]-J[19]+J[20]+J[21]-J[22]+J[23]-J[24]-J[25]+J[26]-J[27]+J[28]-J[29]-J[30]+
    J[31]-J[32]-J[33]+J[34]-J[35]+J[36]-J[37]-J[38]+J[39]+J[40]-J[41]+J[42]-J[43]+J[44]-J[45]-J[46]+J[47]-J[48]+
    J[49]-J[50]+J[51]-J[52]+J[53]-J[54]+J[55]-J[56]+J[57]-J[58]+J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +
    H[0]-H[1]+H[2]+H[3]-H[4]+H[5]-H[6]-H[7]+H[8]-H[9]-H[10]+H[11]-J[0]+J[1]+J[2]-J[3]+J[4]-J[5]-J[6]+J[7]-J[8]-J[9]+
    J[10]-J[11]-J[12]+J[13]-J[14]+J[15]+J[16]-J[17]+J[18]+J[19]-J[20]+J[21]-J[22]+J[23]-J[24]-J[25]+J[26]-J[27]-J[28]+
    J[29]-J[30]+J[31]-J[32]-J[33]+J[34]-J[35]-J[36]+J[37]-J[38]+J[39]+J[40]-J[41]+J[42]+J[43]-J[44]-J[45]-J[46]+
    J[47]-J[48]-J[49]+J[50]+J[51]-J[52]+J[53]+J[54]-J[55]-J[56]+J[57]+J[58]-J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +
    H[0]-H[1]+H[2]+H[3]-H[4]+H[5]-H[6]-H[7]+H[8]-H[9]-H[10]-H[11]-J[0]+J[1]+J[2]-J[3]+J[4]-J[5]-J[6]+J[7]-J[8]-J[9]-J[10]-J[11]-J[12]+
    J[13]-J[14]+J[15]+J[16]-J[17]+J[18]+J[19]+J[20]+J[21]-J[22]+J[23]-J[24]-J[25]+J[26]-J[27]-J[28]-J[29]-J[30]+
    J[31]-J[32]-J[33]+J[34]-J[35]-J[36]-J[37]-J[38]+J[39]+J[40]-J[41]+J[42]+J[43]+J[44]-J[45]-J[46]+J[47]-J[48]-J[49]-J[50]+
    J[51]-J[52]+J[53]+J[54]+J[55]-J[56]+J[57]+J[58]+J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]-H[1]+
    H[2]+H[3]-H[4]+H[5]-H[6]-H[7]-H[8]+H[9]+H[10]+H[11]-J[0]+J[1]+J[2]-J[3]+J[4]-J[5]-J[6]-J[7]+J[8]+J[9]+
    J[10]-J[11]-J[12]+J[13]-J[14]+J[15]+J[16]+J[17]-J[18]-J[19]-J[20]+J[21]-J[22]+J[23]-J[24]-J[25]-J[26]+
    J[27]+J[28]+J[29]-J[30]+J[31]-J[32]-J[33]-J[34]+J[35]+J[36]+J[37]-J[38]+J[39]+J[40]+J[41]-J[42]-J[43]-J[44]-J[45]-J[46]-J[47]+
    J[48]+J[49]+J[50]+J[51]+J[52]-J[53]-J[54]-J[55]+J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+
    J[65], +H[0]-H[1]+H[2]+H[3]-H[4]+H[5]-H[6]-H[7]-H[8]+H[9]+H[10]-H[11]-J[0]+J[1]+J[2]-J[3]+J[4]-J[5]-J[6]-J[7]+
    J[8]+J[9]-J[10]-J[11]-J[12]+J[13]-J[14]+J[15]+J[16]+J[17]-J[18]-J[19]+J[20]+J[21]-J[22]+J[23]-J[24]-J[25]-J[26]+
    J[27]+J[28]-J[29]-J[30]+J[31]-J[32]-J[33]-J[34]+J[35]+J[36]-J[37]-J[38]+J[39]+J[40]+J[41]-J[42]-J[43]+
    J[44]-J[45]-J[46]-J[47]+J[48]+J[49]-J[50]+J[51]+J[52]-J[53]-J[54]+J[55]+J[56]-J[57]-J[58]+J[59]-J[60]-J[61]+
    J[62]+J[63]-J[64]-J[65], +H[0]-H[1]+H[2]+H[3]-H[4]+H[5]-H[6]-H[7]-H[8]+H[9]-H[10]+H[11]-J[0]+J[1]+J[2]-J[3]+
    J[4]-J[5]-J[6]-J[7]+J[8]-J[9]+J[10]-J[11]-J[12]+J[13]-J[14]+J[15]+J[16]+J[17]-J[18]+J[19]-J[20]+J[21]-J[22]+
    J[23]-J[24]-J[25]-J[26]+J[27]-J[28]+J[29]-J[30]+J[31]-J[32]-J[33]-J[34]+J[35]-J[36]+J[37]-J[38]+J[39]+
    J[40]+J[41]-J[42]+J[43]-J[44]-J[45]-J[46]-J[47]+J[48]-J[49]+J[50]+J[51]+J[52]-J[53]+J[54]-J[55]+J[56]-J[57]+
    J[58]-J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]-H[1]+H[2]+H[3]-H[4]+H[5]-H[6]-H[7]-H[8]+H[9]-H[10]-H[11]-J[0]+
    J[1]+J[2]-J[3]+J[4]-J[5]-J[6]-J[7]+J[8]-J[9]-J[10]-J[11]-J[12]+J[13]-J[14]+J[15]+J[16]+J[17]-J[18]+J[19]+
    J[20]+J[21]-J[22]+J[23]-J[24]-J[25]-J[26]+J[27]-J[28]-J[29]-J[30]+J[31]-J[32]-J[33]-J[34]+J[35]-J[36]-J[37]-J[38]+
    J[39]+J[40]+J[41]-J[42]+J[43]+J[44]-J[45]-J[46]-J[47]+J[48]-J[49]-J[50]+J[51]+J[52]-J[53]+J[54]+J[55]+
    J[56]-J[57]+J[58]+J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]-H[1]+H[2]+H[3]-H[4]+H[5]-H[6]-H[7]-H[8]-H[9]+
    H[10]+H[11]-J[0]+J[1]+J[2]-J[3]+J[4]-J[5]-J[6]-J[7]-J[8]+J[9]+J[10]-J[11]-J[12]+J[13]-J[14]+J[15]+J[16]+
    J[17]+J[18]-J[19]-J[20]+J[21]-J[22]+J[23]-J[24]-J[25]-J[26]-J[27]+J[28]+J[29]-J[30]+J[31]-J[32]-J[33]-J[34]-J[35]+
    J[36]+J[37]-J[38]+J[39]+J[40]+J[41]+J[42]-J[43]-J[44]-J[45]-J[46]-J[47]-J[48]+J[49]+J[50]+J[51]+J[52]+
    J[53]-J[54]-J[55]+J[56]+J[57]-J[58]-J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]-H[1]+H[2]+H[3]-H[4]+
    H[5]-H[6]-H[7]-H[8]-H[9]+H[10]-H[11]-J[0]+J[1]+J[2]-J[3]+J[4]-J[5]-J[6]-J[7]-J[8]+J[9]-J[10]-J[11]-J[12]+
    J[13]-J[14]+J[15]+J[16]+J[17]+J[18]-J[19]+J[20]+J[21]-J[22]+J[23]-J[24]-J[25]-J[26]-J[27]+J[28]-J[29]-J[30]+
    J[31]-J[32]-J[33]-J[34]-J[35]+J[36]-J[37]-J[38]+J[39]+J[40]+J[41]+J[42]-J[43]+J[44]-J[45]-J[46]-J[47]-J[48]+
    J[49]-J[50]+J[51]+J[52]+J[53]-J[54]+J[55]+J[56]+J[57]-J[58]+J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +
    H[0]-H[1]+H[2]+H[3]-H[4]+H[5]-H[6]-H[7]-H[8]-H[9]-H[10]+H[11]-J[0]+J[1]+J[2]-J[3]+J[4]-J[5]-J[6]-J[7]-J[8]-J[9]+
    J[10]-J[11]-J[12]+J[13]-J[14]+J[15]+J[16]+J[17]+J[18]+J[19]-J[20]+J[21]-J[22]+J[23]-J[24]-J[25]-J[26]-J[27]-J[28]+
    J[29]-J[30]+J[31]-J[32]-J[33]-J[34]-J[35]-J[36]+J[37]-J[38]+J[39]+J[40]+J[41]+J[42]+J[43]-J[44]-J[45]-J[46]-J[47]-J[48]-J[49]+
    J[50]+J[51]+J[52]+J[53]+J[54]-J[55]+J[56]+J[57]+J[58]-J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]-H[1]+
    H[2]+H[3]-H[4]+H[5]-H[6]-H[7]-H[8]-H[9]-H[10]-H[11]-J[0]+J[1]+J[2]-J[3]+J[4]-J[5]-J[6]-J[7]-J[8]-J[9]-J[10]-J[11]-J[12]+
    J[13]-J[14]+J[15]+J[16]+J[17]+J[18]+J[19]+J[20]+J[21]-J[22]+J[23]-J[24]-J[25]-J[26]-J[27]-J[28]-J[29]-J[30]+
    J[31]-J[32]-J[33]-J[34]-J[35]-J[36]-J[37]-J[38]+J[39]+J[40]+J[41]+J[42]+J[43]+J[44]-J[45]-J[46]-J[47]-J[48]-J[49]-J[50]+
    J[51]+J[52]+J[53]+J[54]+J[55]+J[56]+J[57]+J[58]+J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]-H[1]+
    H[2]+H[3]-H[4]-H[5]+H[6]+H[7]+H[8]+H[9]+H[10]+H[11]-J[0]+J[1]+J[2]-J[3]-J[4]+J[5]+J[6]+J[7]+J[8]+J[9]+
    J[10]-J[11]-J[12]+J[13]+J[14]-J[15]-J[16]-J[17]-J[18]-J[19]-J[20]+J[21]-J[22]-J[23]+J[24]+J[25]+J[26]+
    J[27]+J[28]+J[29]-J[30]-J[31]+J[32]+J[33]+J[34]+J[35]+J[36]+J[37]+J[38]-J[39]-J[40]-J[41]-J[42]-J[43]-J[44]-J[45]-J[46]-J[47]-J[48]-J[49]-J[50]+
    J[51]+J[52]+J[53]+J[54]+J[55]+J[56]+J[57]+J[58]+J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]-H[1]+
    H[2]+H[3]-H[4]-H[5]+H[6]+H[7]+H[8]+H[9]+H[10]-H[11]-J[0]+J[1]+J[2]-J[3]-J[4]+J[5]+J[6]+J[7]+J[8]+J[9]-J[10]-J[11]-J[12]+
    J[13]+J[14]-J[15]-J[16]-J[17]-J[18]-J[19]+J[20]+J[21]-J[22]-J[23]+J[24]+J[25]+J[26]+J[27]+J[28]-J[29]-J[30]-J[31]+
    J[32]+J[33]+J[34]+J[35]+J[36]-J[37]+J[38]-J[39]-J[40]-J[41]-J[42]-J[43]+J[44]-J[45]-J[46]-J[47]-J[48]-J[49]+
    J[50]+J[51]+J[52]+J[53]+J[54]-J[55]+J[56]+J[57]+J[58]-J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]-H[1]+
    H[2]+H[3]-H[4]-H[5]+H[6]+H[7]+H[8]+H[9]-H[10]+H[11]-J[0]+J[1]+J[2]-J[3]-J[4]+J[5]+J[6]+J[7]+J[8]-J[9]+
    J[10]-J[11]-J[12]+J[13]+J[14]-J[15]-J[16]-J[17]-J[18]+J[19]-J[20]+J[21]-J[22]-J[23]+J[24]+J[25]+J[26]+
    J[27]-J[28]+J[29]-J[30]-J[31]+J[32]+J[33]+J[34]+J[35]-J[36]+J[37]+J[38]-J[39]-J[40]-J[41]-J[42]+J[43]-J[44]-J[45]-J[46]-J[47]-J[48]+
    J[49]-J[50]+J[51]+J[52]+J[53]-J[54]+J[55]+J[56]+J[57]-J[58]+J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +
    H[0]-H[1]+H[2]+H[3]-H[4]-H[5]+H[6]+H[7]+H[8]+H[9]-H[10]-H[11]-J[0]+J[1]+J[2]-J[3]-J[4]+J[5]+J[6]+J[7]+
    J[8]-J[9]-J[10]-J[11]-J[12]+J[13]+J[14]-J[15]-J[16]-J[17]-J[18]+J[19]+J[20]+J[21]-J[22]-J[23]+J[24]+
    J[25]+J[26]+J[27]-J[28]-J[29]-J[30]-J[31]+J[32]+J[33]+J[34]+J[35]-J[36]-J[37]+J[38]-J[39]-J[40]-J[41]-J[42]+
    J[43]+J[44]-J[45]-J[46]-J[47]-J[48]+J[49]+J[50]+J[51]+J[52]+J[53]-J[54]-J[55]+J[56]+J[57]-J[58]-J[59]+
    J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]-H[1]+H[2]+H[3]-H[4]-H[5]+H[6]+H[7]+H[8]-H[9]+H[10]+H[11]-J[0]+
    J[1]+J[2]-J[3]-J[4]+J[5]+J[6]+J[7]-J[8]+J[9]+J[10]-J[11]-J[12]+J[13]+J[14]-J[15]-J[16]-J[17]+J[18]-J[19]-J[20]+
    J[21]-J[22]-J[23]+J[24]+J[25]+J[26]-J[27]+J[28]+J[29]-J[30]-J[31]+J[32]+J[33]+J[34]-J[35]+J[36]+J[37]+
    J[38]-J[39]-J[40]-J[41]+J[42]-J[43]-J[44]-J[45]-J[46]-J[47]+J[48]-J[49]-J[50]+J[51]+J[52]-J[53]+J[54]+
    J[55]+J[56]-J[57]+J[58]+J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]-H[1]+H[2]+H[3]-H[4]-H[5]+H[6]+
    H[7]+H[8]-H[9]+H[10]-H[11]-J[0]+J[1]+J[2]-J[3]-J[4]+J[5]+J[6]+J[7]-J[8]+J[9]-J[10]-J[11]-J[12]+J[13]+
    J[14]-J[15]-J[16]-J[17]+J[18]-J[19]+J[20]+J[21]-J[22]-J[23]+J[24]+J[25]+J[26]-J[27]+J[28]-J[29]-J[30]-J[31]+
    J[32]+J[33]+J[34]-J[35]+J[36]-J[37]+J[38]-J[39]-J[40]-J[41]+J[42]-J[43]+J[44]-J[45]-J[46]-J[47]+J[48]-J[49]+
    J[50]+J[51]+J[52]-J[53]+J[54]-J[55]+J[56]-J[57]+J[58]-J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]-H[1]+
    H[2]+H[3]-H[4]-H[5]+H[6]+H[7]+H[8]-H[9]-H[10]+H[11]-J[0]+J[1]+J[2]-J[3]-J[4]+J[5]+J[6]+J[7]-J[8]-J[9]+
    J[10]-J[11]-J[12]+J[13]+J[14]-J[15]-J[16]-J[17]+J[18]+J[19]-J[20]+J[21]-J[22]-J[23]+J[24]+J[25]+J[26]-J[27]-J[28]+
    J[29]-J[30]-J[31]+J[32]+J[33]+J[34]-J[35]-J[36]+J[37]+J[38]-J[39]-J[40]-J[41]+J[42]+J[43]-J[44]-J[45]-J[46]-J[47]+
    J[48]+J[49]-J[50]+J[51]+J[52]-J[53]-J[54]+J[55]+J[56]-J[57]-J[58]+J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +
    H[0]-H[1]+H[2]+H[3]-H[4]-H[5]+H[6]+H[7]+H[8]-H[9]-H[10]-H[11]-J[0]+J[1]+J[2]-J[3]-J[4]+J[5]+J[6]+J[7]-J[8]-J[9]-J[10]-J[11]-J[12]+
    J[13]+J[14]-J[15]-J[16]-J[17]+J[18]+J[19]+J[20]+J[21]-J[22]-J[23]+J[24]+J[25]+J[26]-J[27]-J[28]-J[29]-J[30]-J[31]+
    J[32]+J[33]+J[34]-J[35]-J[36]-J[37]+J[38]-J[39]-J[40]-J[41]+J[42]+J[43]+J[44]-J[45]-J[46]-J[47]+J[48]+
    J[49]+J[50]+J[51]+J[52]-J[53]-J[54]-J[55]+J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +
    H[0]-H[1]+H[2]+H[3]-H[4]-H[5]+H[6]+H[7]-H[8]+H[9]+H[10]+H[11]-J[0]+J[1]+J[2]-J[3]-J[4]+J[5]+J[6]-J[7]+
    J[8]+J[9]+J[10]-J[11]-J[12]+J[13]+J[14]-J[15]-J[16]+J[17]-J[18]-J[19]-J[20]+J[21]-J[22]-J[23]+J[24]+
    J[25]-J[26]+J[27]+J[28]+J[29]-J[30]-J[31]+J[32]+J[33]-J[34]+J[35]+J[36]+J[37]+J[38]-J[39]-J[40]+J[41]-J[42]-J[43]-J[44]-J[45]-J[46]+
    J[47]-J[48]-J[49]-J[50]+J[51]-J[52]+J[53]+J[54]+J[55]-J[56]+J[57]+J[58]+J[59]-J[60]-J[61]-J[62]+J[63]+
    J[64]+J[65], +H[0]-H[1]+H[2]+H[3]-H[4]-H[5]+H[6]+H[7]-H[8]+H[9]+H[10]-H[11]-J[0]+J[1]+J[2]-J[3]-J[4]+
    J[5]+J[6]-J[7]+J[8]+J[9]-J[10]-J[11]-J[12]+J[13]+J[14]-J[15]-J[16]+J[17]-J[18]-J[19]+J[20]+J[21]-J[22]-J[23]+
    J[24]+J[25]-J[26]+J[27]+J[28]-J[29]-J[30]-J[31]+J[32]+J[33]-J[34]+J[35]+J[36]-J[37]+J[38]-J[39]-J[40]+
    J[41]-J[42]-J[43]+J[44]-J[45]-J[46]+J[47]-J[48]-J[49]+J[50]+J[51]-J[52]+J[53]+J[54]-J[55]-J[56]+J[57]+
    J[58]-J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]-H[1]+H[2]+H[3]-H[4]-H[5]+H[6]+H[7]-H[8]+H[9]-H[10]+
    H[11]-J[0]+J[1]+J[2]-J[3]-J[4]+J[5]+J[6]-J[7]+J[8]-J[9]+J[10]-J[11]-J[12]+J[13]+J[14]-J[15]-J[16]+J[17]-J[18]+
    J[19]-J[20]+J[21]-J[22]-J[23]+J[24]+J[25]-J[26]+J[27]-J[28]+J[29]-J[30]-J[31]+J[32]+J[33]-J[34]+J[35]-J[36]+
    J[37]+J[38]-J[39]-J[40]+J[41]-J[42]+J[43]-J[44]-J[45]-J[46]+J[47]-J[48]+J[49]-J[50]+J[51]-J[52]+J[53]-J[54]+
    J[55]-J[56]+J[57]-J[58]+J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]-H[1]+H[2]+H[3]-H[4]-H[5]+H[6]+
    H[7]-H[8]+H[9]-H[10]-H[11]-J[0]+J[1]+J[2]-J[3]-J[4]+J[5]+J[6]-J[7]+J[8]-J[9]-J[10]-J[11]-J[12]+J[13]+
    J[14]-J[15]-J[16]+J[17]-J[18]+J[19]+J[20]+J[21]-J[22]-J[23]+J[24]+J[25]-J[26]+J[27]-J[28]-J[29]-J[30]-J[31]+
    J[32]+J[33]-J[34]+J[35]-J[36]-J[37]+J[38]-J[39]-J[40]+J[41]-J[42]+J[43]+J[44]-J[45]-J[46]+J[47]-J[48]+
    J[49]+J[50]+J[51]-J[52]+J[53]-J[54]-J[55]-J[56]+J[57]-J[58]-J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +
    H[0]-H[1]+H[2]+H[3]-H[4]-H[5]+H[6]+H[7]-H[8]-H[9]+H[10]+H[11]-J[0]+J[1]+J[2]-J[3]-J[4]+J[5]+J[6]-J[7]-J[8]+
    J[9]+J[10]-J[11]-J[12]+J[13]+J[14]-J[15]-J[16]+J[17]+J[18]-J[19]-J[20]+J[21]-J[22]-J[23]+J[24]+J[25]-J[26]-J[27]+
    J[28]+J[29]-J[30]-J[31]+J[32]+J[33]-J[34]-J[35]+J[36]+J[37]+J[38]-J[39]-J[40]+J[41]+J[42]-J[43]-J[44]-J[45]-J[46]+
    J[47]+J[48]-J[49]-J[50]+J[51]-J[52]-J[53]+J[54]+J[55]-J[56]-J[57]+J[58]+J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+
    J[65], +H[0]-H[1]+H[2]+H[3]-H[4]-H[5]+H[6]+H[7]-H[8]-H[9]+H[10]-H[11]-J[0]+J[1]+J[2]-J[3]-J[4]+J[5]+
    J[6]-J[7]-J[8]+J[9]-J[10]-J[11]-J[12]+J[13]+J[14]-J[15]-J[16]+J[17]+J[18]-J[19]+J[20]+J[21]-J[22]-J[23]+
    J[24]+J[25]-J[26]-J[27]+J[28]-J[29]-J[30]-J[31]+J[32]+J[33]-J[34]-J[35]+J[36]-J[37]+J[38]-J[39]-J[40]+
    J[41]+J[42]-J[43]+J[44]-J[45]-J[46]+J[47]+J[48]-J[49]+J[50]+J[51]-J[52]-J[53]+J[54]-J[55]-J[56]-J[57]+
    J[58]-J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]-H[1]+H[2]+H[3]-H[4]-H[5]+H[6]+H[7]-H[8]-H[9]-H[10]+
    H[11]-J[0]+J[1]+J[2]-J[3]-J[4]+J[5]+J[6]-J[7]-J[8]-J[9]+J[10]-J[11]-J[12]+J[13]+J[14]-J[15]-J[16]+J[17]+
    J[18]+J[19]-J[20]+J[21]-J[22]-J[23]+J[24]+J[25]-J[26]-J[27]-J[28]+J[29]-J[30]-J[31]+J[32]+J[33]-J[34]-J[35]-J[36]+
    J[37]+J[38]-J[39]-J[40]+J[41]+J[42]+J[43]-J[44]-J[45]-J[46]+J[47]+J[48]+J[49]-J[50]+J[51]-J[52]-J[53]-J[54]+
    J[55]-J[56]-J[57]-J[58]+J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]-H[1]+H[2]+H[3]-H[4]-H[5]+H[6]+
    H[7]-H[8]-H[9]-H[10]-H[11]-J[0]+J[1]+J[2]-J[3]-J[4]+J[5]+J[6]-J[7]-J[8]-J[9]-J[10]-J[11]-J[12]+J[13]+
    J[14]-J[15]-J[16]+J[17]+J[18]+J[19]+J[20]+J[21]-J[22]-J[23]+J[24]+J[25]-J[26]-J[27]-J[28]-J[29]-J[30]-J[31]+
    J[32]+J[33]-J[34]-J[35]-J[36]-J[37]+J[38]-J[39]-J[40]+J[41]+J[42]+J[43]+J[44]-J[45]-J[46]+J[47]+J[48]+
    J[49]+J[50]+J[51]-J[52]-J[53]-J[54]-J[55]-J[56]-J[57]-J[58]-J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +
    H[0]-H[1]+H[2]+H[3]-H[4]-H[5]+H[6]-H[7]+H[8]+H[9]+H[10]+H[11]-J[0]+J[1]+J[2]-J[3]-J[4]+J[5]-J[6]+J[7]+
    J[8]+J[9]+J[10]-J[11]-J[12]+J[13]+J[14]-J[15]+J[16]-J[17]-J[18]-J[19]-J[20]+J[21]-J[22]-J[23]+J[24]-J[25]+
    J[26]+J[27]+J[28]+J[29]-J[30]-J[31]+J[32]-J[33]+J[34]+J[35]+J[36]+J[37]+J[38]-J[39]+J[40]-J[41]-J[42]-J[43]-J[44]-J[45]+
    J[46]-J[47]-J[48]-J[49]-J[50]-J[51]+J[52]+J[53]+J[54]+J[55]-J[56]-J[57]-J[58]-J[59]+J[60]+J[61]+J[62]+
    J[63]+J[64]+J[65], +H[0]-H[1]+H[2]+H[3]-H[4]-H[5]+H[6]-H[7]+H[8]+H[9]+H[10]-H[11]-J[0]+J[1]+J[2]-J[3]-J[4]+
    J[5]-J[6]+J[7]+J[8]+J[9]-J[10]-J[11]-J[12]+J[13]+J[14]-J[15]+J[16]-J[17]-J[18]-J[19]+J[20]+J[21]-J[22]-J[23]+
    J[24]-J[25]+J[26]+J[27]+J[28]-J[29]-J[30]-J[31]+J[32]-J[33]+J[34]+J[35]+J[36]-J[37]+J[38]-J[39]+J[40]-J[41]-J[42]-J[43]+
    J[44]-J[45]+J[46]-J[47]-J[48]-J[49]+J[50]-J[51]+J[52]+J[53]+J[54]-J[55]-J[56]-J[57]-J[58]+J[59]+J[60]+
    J[61]-J[62]+J[63]-J[64]-J[65], +H[0]-H[1]+H[2]+H[3]-H[4]-H[5]+H[6]-H[7]+H[8]+H[9]-H[10]+H[11]-J[0]+J[1]+
    J[2]-J[3]-J[4]+J[5]-J[6]+J[7]+J[8]-J[9]+J[10]-J[11]-J[12]+J[13]+J[14]-J[15]+J[16]-J[17]-J[18]+J[19]-J[20]+
    J[21]-J[22]-J[23]+J[24]-J[25]+J[26]+J[27]-J[28]+J[29]-J[30]-J[31]+J[32]-J[33]+J[34]+J[35]-J[36]+J[37]+
    J[38]-J[39]+J[40]-J[41]-J[42]+J[43]-J[44]-J[45]+J[46]-J[47]-J[48]+J[49]-J[50]-J[51]+J[52]+J[53]-J[54]+
    J[55]-J[56]-J[57]+J[58]-J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]-H[1]+H[2]+H[3]-H[4]-H[5]+H[6]-H[7]+
    H[8]+H[9]-H[10]-H[11]-J[0]+J[1]+J[2]-J[3]-J[4]+J[5]-J[6]+J[7]+J[8]-J[9]-J[10]-J[11]-J[12]+J[13]+J[14]-J[15]+
    J[16]-J[17]-J[18]+J[19]+J[20]+J[21]-J[22]-J[23]+J[24]-J[25]+J[26]+J[27]-J[28]-J[29]-J[30]-J[31]+J[32]-J[33]+
    J[34]+J[35]-J[36]-J[37]+J[38]-J[39]+J[40]-J[41]-J[42]+J[43]+J[44]-J[45]+J[46]-J[47]-J[48]+J[49]+J[50]-J[51]+
    J[52]+J[53]-J[54]-J[55]-J[56]-J[57]+J[58]+J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]-H[1]+H[2]+
    H[3]-H[4]-H[5]+H[6]-H[7]+H[8]-H[9]+H[10]+H[11]-J[0]+J[1]+J[2]-J[3]-J[4]+J[5]-J[6]+J[7]-J[8]+J[9]+J[10]-J[11]-J[12]+
    J[13]+J[14]-J[15]+J[16]-J[17]+J[18]-J[19]-J[20]+J[21]-J[22]-J[23]+J[24]-J[25]+J[26]-J[27]+J[28]+J[29]-J[30]-J[31]+
    J[32]-J[33]+J[34]-J[35]+J[36]+J[37]+J[38]-J[39]+J[40]-J[41]+J[42]-J[43]-J[44]-J[45]+J[46]-J[47]+J[48]-J[49]-J[50]-J[51]+
    J[52]-J[53]+J[54]+J[55]-J[56]+J[57]-J[58]-J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]-H[1]+H[2]+
    H[3]-H[4]-H[5]+H[6]-H[7]+H[8]-H[9]+H[10]-H[11]-J[0]+J[1]+J[2]-J[3]-J[4]+J[5]-J[6]+J[7]-J[8]+J[9]-J[10]-J[11]-J[12]+
    J[13]+J[14]-J[15]+J[16]-J[17]+J[18]-J[19]+J[20]+J[21]-J[22]-J[23]+J[24]-J[25]+J[26]-J[27]+J[28]-J[29]-J[30]-J[31]+
    J[32]-J[33]+J[34]-J[35]+J[36]-J[37]+J[38]-J[39]+J[40]-J[41]+J[42]-J[43]+J[44]-J[45]+J[46]-J[47]+J[48]-J[49]+
    J[50]-J[51]+J[52]-J[53]+J[54]-J[55]-J[56]+J[57]-J[58]+J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]-H[1]+
    H[2]+H[3]-H[4]-H[5]+H[6]-H[7]+H[8]-H[9]-H[10]+H[11]-J[0]+J[1]+J[2]-J[3]-J[4]+J[5]-J[6]+J[7]-J[8]-J[9]+
    J[10]-J[11]-J[12]+J[13]+J[14]-J[15]+J[16]-J[17]+J[18]+J[19]-J[20]+J[21]-J[22]-J[23]+J[24]-J[25]+J[26]-J[27]-J[28]+
    J[29]-J[30]-J[31]+J[32]-J[33]+J[34]-J[35]-J[36]+J[37]+J[38]-J[39]+J[40]-J[41]+J[42]+J[43]-J[44]-J[45]+
    J[46]-J[47]+J[48]+J[49]-J[50]-J[51]+J[52]-J[53]-J[54]+J[55]-J[56]+J[57]+J[58]-J[59]-J[60]-J[61]+J[62]+
    J[63]-J[64]-J[65], +H[0]-H[1]+H[2]+H[3]-H[4]-H[5]+H[6]-H[7]+H[8]-H[9]-H[10]-H[11]-J[0]+J[1]+J[2]-J[3]-J[4]+
    J[5]-J[6]+J[7]-J[8]-J[9]-J[10]-J[11]-J[12]+J[13]+J[14]-J[15]+J[16]-J[17]+J[18]+J[19]+J[20]+J[21]-J[22]-J[23]+
    J[24]-J[25]+J[26]-J[27]-J[28]-J[29]-J[30]-J[31]+J[32]-J[33]+J[34]-J[35]-J[36]-J[37]+J[38]-J[39]+J[40]-J[41]+
    J[42]+J[43]+J[44]-J[45]+J[46]-J[47]+J[48]+J[49]+J[50]-J[51]+J[52]-J[53]-J[54]-J[55]-J[56]+J[57]+J[58]+
    J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]-H[1]+H[2]+H[3]-H[4]-H[5]+H[6]-H[7]-H[8]+H[9]+H[10]+
    H[11]-J[0]+J[1]+J[2]-J[3]-J[4]+J[5]-J[6]-J[7]+J[8]+J[9]+J[10]-J[11]-J[12]+J[13]+J[14]-J[15]+J[16]+J[17]-J[18]-J[19]-J[20]+
    J[21]-J[22]-J[23]+J[24]-J[25]-J[26]+J[27]+J[28]+J[29]-J[30]-J[31]+J[32]-J[33]-J[34]+J[35]+J[36]+J[37]+
    J[38]-J[39]+J[40]+J[41]-J[42]-J[43]-J[44]-J[45]+J[46]+J[47]-J[48]-J[49]-J[50]-J[51]-J[52]+J[53]+J[54]+
    J[55]+J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]-H[1]+H[2]+H[3]-H[4]-H[5]+H[6]-H[7]-H[8]+
    H[9]+H[10]-H[11]-J[0]+J[1]+J[2]-J[3]-J[4]+J[5]-J[6]-J[7]+J[8]+J[9]-J[10]-J[11]-J[12]+J[13]+J[14]-J[15]+
    J[16]+J[17]-J[18]-J[19]+J[20]+J[21]-J[22]-J[23]+J[24]-J[25]-J[26]+J[27]+J[28]-J[29]-J[30]-J[31]+J[32]-J[33]-J[34]+
    J[35]+J[36]-J[37]+J[38]-J[39]+J[40]+J[41]-J[42]-J[43]+J[44]-J[45]+J[46]+J[47]-J[48]-J[49]+J[50]-J[51]-J[52]+
    J[53]+J[54]-J[55]+J[56]-J[57]-J[58]+J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]-H[1]+H[2]+H[3]-H[4]-H[5]+
    H[6]-H[7]-H[8]+H[9]-H[10]+H[11]-J[0]+J[1]+J[2]-J[3]-J[4]+J[5]-J[6]-J[7]+J[8]-J[9]+J[10]-J[11]-J[12]+
    J[13]+J[14]-J[15]+J[16]+J[17]-J[18]+J[19]-J[20]+J[21]-J[22]-J[23]+J[24]-J[25]-J[26]+J[27]-J[28]+J[29]-J[30]-J[31]+
    J[32]-J[33]-J[34]+J[35]-J[36]+J[37]+J[38]-J[39]+J[40]+J[41]-J[42]+J[43]-J[44]-J[45]+J[46]+J[47]-J[48]+
    J[49]-J[50]-J[51]-J[52]+J[53]-J[54]+J[55]+J[56]-J[57]+J[58]-J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +
    H[0]-H[1]+H[2]+H[3]-H[4]-H[5]+H[6]-H[7]-H[8]+H[9]-H[10]-H[11]-J[0]+J[1]+J[2]-J[3]-J[4]+J[5]-J[6]-J[7]+
    J[8]-J[9]-J[10]-J[11]-J[12]+J[13]+J[14]-J[15]+J[16]+J[17]-J[18]+J[19]+J[20]+J[21]-J[22]-J[23]+J[24]-J[25]-J[26]+
    J[27]-J[28]-J[29]-J[30]-J[31]+J[32]-J[33]-J[34]+J[35]-J[36]-J[37]+J[38]-J[39]+J[40]+J[41]-J[42]+J[43]+
    J[44]-J[45]+J[46]+J[47]-J[48]+J[49]+J[50]-J[51]-J[52]+J[53]-J[54]-J[55]+J[56]-J[57]+J[58]+J[59]-J[60]+
    J[61]+J[62]-J[63]-J[64]+J[65], +H[0]-H[1]+H[2]+H[3]-H[4]-H[5]+H[6]-H[7]-H[8]-H[9]+H[10]+H[11]-J[0]+J[1]+
    J[2]-J[3]-J[4]+J[5]-J[6]-J[7]-J[8]+J[9]+J[10]-J[11]-J[12]+J[13]+J[14]-J[15]+J[16]+J[17]+J[18]-J[19]-J[20]+
    J[21]-J[22]-J[23]+J[24]-J[25]-J[26]-J[27]+J[28]+J[29]-J[30]-J[31]+J[32]-J[33]-J[34]-J[35]+J[36]+J[37]+
    J[38]-J[39]+J[40]+J[41]+J[42]-J[43]-J[44]-J[45]+J[46]+J[47]+J[48]-J[49]-J[50]-J[51]-J[52]-J[53]+J[54]+
    J[55]+J[56]+J[57]-J[58]-J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]-H[1]+H[2]+H[3]-H[4]-H[5]+H[6]-H[7]-H[8]-H[9]+
    H[10]-H[11]-J[0]+J[1]+J[2]-J[3]-J[4]+J[5]-J[6]-J[7]-J[8]+J[9]-J[10]-J[11]-J[12]+J[13]+J[14]-J[15]+J[16]+
    J[17]+J[18]-J[19]+J[20]+J[21]-J[22]-J[23]+J[24]-J[25]-J[26]-J[27]+J[28]-J[29]-J[30]-J[31]+J[32]-J[33]-J[34]-J[35]+
    J[36]-J[37]+J[38]-J[39]+J[40]+J[41]+J[42]-J[43]+J[44]-J[45]+J[46]+J[47]+J[48]-J[49]+J[50]-J[51]-J[52]-J[53]+
    J[54]-J[55]+J[56]+J[57]-J[58]+J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]-H[1]+H[2]+H[3]-H[4]-H[5]+
    H[6]-H[7]-H[8]-H[9]-H[10]+H[11]-J[0]+J[1]+J[2]-J[3]-J[4]+J[5]-J[6]-J[7]-J[8]-J[9]+J[10]-J[11]-J[12]+
    J[13]+J[14]-J[15]+J[16]+J[17]+J[18]+J[19]-J[20]+J[21]-J[22]-J[23]+J[24]-J[25]-J[26]-J[27]-J[28]+J[29]-J[30]-J[31]+
    J[32]-J[33]-J[34]-J[35]-J[36]+J[37]+J[38]-J[39]+J[40]+J[41]+J[42]+J[43]-J[44]-J[45]+J[46]+J[47]+J[48]+
    J[49]-J[50]-J[51]-J[52]-J[53]-J[54]+J[55]+J[56]+J[57]+J[58]-J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +
    H[0]-H[1]+H[2]+H[3]-H[4]-H[5]+H[6]-H[7]-H[8]-H[9]-H[10]-H[11]-J[0]+J[1]+J[2]-J[3]-J[4]+J[5]-J[6]-J[7]-J[8]-J[9]-J[10]-J[11]-J[12]+
    J[13]+J[14]-J[15]+J[16]+J[17]+J[18]+J[19]+J[20]+J[21]-J[22]-J[23]+J[24]-J[25]-J[26]-J[27]-J[28]-J[29]-J[30]-J[31]+
    J[32]-J[33]-J[34]-J[35]-J[36]-J[37]+J[38]-J[39]+J[40]+J[41]+J[42]+J[43]+J[44]-J[45]+J[46]+J[47]+J[48]+
    J[49]+J[50]-J[51]-J[52]-J[53]-J[54]-J[55]+J[56]+J[57]+J[58]+J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +
    H[0]-H[1]+H[2]+H[3]-H[4]-H[5]-H[6]+H[7]+H[8]+H[9]+H[10]+H[11]-J[0]+J[1]+J[2]-J[3]-J[4]-J[5]+J[6]+J[7]+
    J[8]+J[9]+J[10]-J[11]-J[12]+J[13]+J[14]+J[15]-J[16]-J[17]-J[18]-J[19]-J[20]+J[21]-J[22]-J[23]-J[24]+
    J[25]+J[26]+J[27]+J[28]+J[29]-J[30]-J[31]-J[32]+J[33]+J[34]+J[35]+J[36]+J[37]+J[38]+J[39]-J[40]-J[41]-J[42]-J[43]-J[44]+
    J[45]-J[46]-J[47]-J[48]-J[49]-J[50]-J[51]-J[52]-J[53]-J[54]-J[55]+J[56]+J[57]+J[58]+J[59]+J[60]+J[61]+
    J[62]+J[63]+J[64]+J[65], +H[0]-H[1]+H[2]+H[3]-H[4]-H[5]-H[6]+H[7]+H[8]+H[9]+H[10]-H[11]-J[0]+J[1]+J[2]-J[3]-J[4]-J[5]+
    J[6]+J[7]+J[8]+J[9]-J[10]-J[11]-J[12]+J[13]+J[14]+J[15]-J[16]-J[17]-J[18]-J[19]+J[20]+J[21]-J[22]-J[23]-J[24]+
    J[25]+J[26]+J[27]+J[28]-J[29]-J[30]-J[31]-J[32]+J[33]+J[34]+J[35]+J[36]-J[37]+J[38]+J[39]-J[40]-J[41]-J[42]-J[43]+
    J[44]+J[45]-J[46]-J[47]-J[48]-J[49]+J[50]-J[51]-J[52]-J[53]-J[54]+J[55]+J[56]+J[57]+J[58]-J[59]+J[60]+
    J[61]-J[62]+J[63]-J[64]-J[65], +H[0]-H[1]+H[2]+H[3]-H[4]-H[5]-H[6]+H[7]+H[8]+H[9]-H[10]+H[11]-J[0]+J[1]+
    J[2]-J[3]-J[4]-J[5]+J[6]+J[7]+J[8]-J[9]+J[10]-J[11]-J[12]+J[13]+J[14]+J[15]-J[16]-J[17]-J[18]+J[19]-J[20]+
    J[21]-J[22]-J[23]-J[24]+J[25]+J[26]+J[27]-J[28]+J[29]-J[30]-J[31]-J[32]+J[33]+J[34]+J[35]-J[36]+J[37]+
    J[38]+J[39]-J[40]-J[41]-J[42]+J[43]-J[44]+J[45]-J[46]-J[47]-J[48]+J[49]-J[50]-J[51]-J[52]-J[53]+J[54]-J[55]+
    J[56]+J[57]-J[58]+J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]-H[1]+H[2]+H[3]-H[4]-H[5]-H[6]+H[7]+
    H[8]+H[9]-H[10]-H[11]-J[0]+J[1]+J[2]-J[3]-J[4]-J[5]+J[6]+J[7]+J[8]-J[9]-J[10]-J[11]-J[12]+J[13]+J[14]+
    J[15]-J[16]-J[17]-J[18]+J[19]+J[20]+J[21]-J[22]-J[23]-J[24]+J[25]+J[26]+J[27]-J[28]-J[29]-J[30]-J[31]-J[32]+
    J[33]+J[34]+J[35]-J[36]-J[37]+J[38]+J[39]-J[40]-J[41]-J[42]+J[43]+J[44]+J[45]-J[46]-J[47]-J[48]+J[49]+
    J[50]-J[51]-J[52]-J[53]+J[54]+J[55]+J[56]+J[57]-J[58]-J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]-H[1]+
    H[2]+H[3]-H[4]-H[5]-H[6]+H[7]+H[8]-H[9]+H[10]+H[11]-J[0]+J[1]+J[2]-J[3]-J[4]-J[5]+J[6]+J[7]-J[8]+J[9]+
    J[10]-J[11]-J[12]+J[13]+J[14]+J[15]-J[16]-J[17]+J[18]-J[19]-J[20]+J[21]-J[22]-J[23]-J[24]+J[25]+J[26]-J[27]+
    J[28]+J[29]-J[30]-J[31]-J[32]+J[33]+J[34]-J[35]+J[36]+J[37]+J[38]+J[39]-J[40]-J[41]+J[42]-J[43]-J[44]+
    J[45]-J[46]-J[47]+J[48]-J[49]-J[50]-J[51]-J[52]+J[53]-J[54]-J[55]+J[56]-J[57]+J[58]+J[59]-J[60]+J[61]+
    J[62]-J[63]-J[64]+J[65], +H[0]-H[1]+H[2]+H[3]-H[4]-H[5]-H[6]+H[7]+H[8]-H[9]+H[10]-H[11]-J[0]+J[1]+J[2]-J[3]-J[4]-J[5]+
    J[6]+J[7]-J[8]+J[9]-J[10]-J[11]-J[12]+J[13]+J[14]+J[15]-J[16]-J[17]+J[18]-J[19]+J[20]+J[21]-J[22]-J[23]-J[24]+
    J[25]+J[26]-J[27]+J[28]-J[29]-J[30]-J[31]-J[32]+J[33]+J[34]-J[35]+J[36]-J[37]+J[38]+J[39]-J[40]-J[41]+
    J[42]-J[43]+J[44]+J[45]-J[46]-J[47]+J[48]-J[49]+J[50]-J[51]-J[52]+J[53]-J[54]+J[55]+J[56]-J[57]+J[58]-J[59]-J[60]+
    J[61]-J[62]-J[63]+J[64]-J[65], +H[0]-H[1]+H[2]+H[3]-H[4]-H[5]-H[6]+H[7]+H[8]-H[9]-H[10]+H[11]-J[0]+J[1]+
    J[2]-J[3]-J[4]-J[5]+J[6]+J[7]-J[8]-J[9]+J[10]-J[11]-J[12]+J[13]+J[14]+J[15]-J[16]-J[17]+J[18]+J[19]-J[20]+
    J[21]-J[22]-J[23]-J[24]+J[25]+J[26]-J[27]-J[28]+J[29]-J[30]-J[31]-J[32]+J[33]+J[34]-J[35]-J[36]+J[37]+
    J[38]+J[39]-J[40]-J[41]+J[42]+J[43]-J[44]+J[45]-J[46]-J[47]+J[48]+J[49]-J[50]-J[51]-J[52]+J[53]+J[54]-J[55]+
    J[56]-J[57]-J[58]+J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]-H[1]+H[2]+H[3]-H[4]-H[5]-H[6]+H[7]+
    H[8]-H[9]-H[10]-H[11]-J[0]+J[1]+J[2]-J[3]-J[4]-J[5]+J[6]+J[7]-J[8]-J[9]-J[10]-J[11]-J[12]+J[13]+J[14]+
    J[15]-J[16]-J[17]+J[18]+J[19]+J[20]+J[21]-J[22]-J[23]-J[24]+J[25]+J[26]-J[27]-J[28]-J[29]-J[30]-J[31]-J[32]+
    J[33]+J[34]-J[35]-J[36]-J[37]+J[38]+J[39]-J[40]-J[41]+J[42]+J[43]+J[44]+J[45]-J[46]-J[47]+J[48]+J[49]+
    J[50]-J[51]-J[52]+J[53]+J[54]+J[55]+J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]-H[1]+
    H[2]+H[3]-H[4]-H[5]-H[6]+H[7]-H[8]+H[9]+H[10]+H[11]-J[0]+J[1]+J[2]-J[3]-J[4]-J[5]+J[6]-J[7]+J[8]+J[9]+
    J[10]-J[11]-J[12]+J[13]+J[14]+J[15]-J[16]+J[17]-J[18]-J[19]-J[20]+J[21]-J[22]-J[23]-J[24]+J[25]-J[26]+
    J[27]+J[28]+J[29]-J[30]-J[31]-J[32]+J[33]-J[34]+J[35]+J[36]+J[37]+J[38]+J[39]-J[40]+J[41]-J[42]-J[43]-J[44]+
    J[45]-J[46]+J[47]-J[48]-J[49]-J[50]-J[51]+J[52]-J[53]-J[54]-J[55]-J[56]+J[57]+J[58]+J[59]-J[60]-J[61]-J[62]+
    J[63]+J[64]+J[65], +H[0]-H[1]+H[2]+H[3]-H[4]-H[5]-H[6]+H[7]-H[8]+H[9]+H[10]-H[11]-J[0]+J[1]+J[2]-J[3]-J[4]-J[5]+
    J[6]-J[7]+J[8]+J[9]-J[10]-J[11]-J[12]+J[13]+J[14]+J[15]-J[16]+J[17]-J[18]-J[19]+J[20]+J[21]-J[22]-J[23]-J[24]+
    J[25]-J[26]+J[27]+J[28]-J[29]-J[30]-J[31]-J[32]+J[33]-J[34]+J[35]+J[36]-J[37]+J[38]+J[39]-J[40]+J[41]-J[42]-J[43]+
    J[44]+J[45]-J[46]+J[47]-J[48]-J[49]+J[50]-J[51]+J[52]-J[53]-J[54]+J[55]-J[56]+J[57]+J[58]-J[59]-J[60]-J[61]+
    J[62]+J[63]-J[64]-J[65], +H[0]-H[1]+H[2]+H[3]-H[4]-H[5]-H[6]+H[7]-H[8]+H[9]-H[10]+H[11]-J[0]+J[1]+J[2]-J[3]-J[4]-J[5]+
    J[6]-J[7]+J[8]-J[9]+J[10]-J[11]-J[12]+J[13]+J[14]+J[15]-J[16]+J[17]-J[18]+J[19]-J[20]+J[21]-J[22]-J[23]-J[24]+
    J[25]-J[26]+J[27]-J[28]+J[29]-J[30]-J[31]-J[32]+J[33]-J[34]+J[35]-J[36]+J[37]+J[38]+J[39]-J[40]+J[41]-J[42]+
    J[43]-J[44]+J[45]-J[46]+J[47]-J[48]+J[49]-J[50]-J[51]+J[52]-J[53]+J[54]-J[55]-J[56]+J[57]-J[58]+J[59]-J[60]+
    J[61]-J[62]-J[63]+J[64]-J[65], +H[0]-H[1]+H[2]+H[3]-H[4]-H[5]-H[6]+H[7]-H[8]+H[9]-H[10]-H[11]-J[0]+J[1]+
    J[2]-J[3]-J[4]-J[5]+J[6]-J[7]+J[8]-J[9]-J[10]-J[11]-J[12]+J[13]+J[14]+J[15]-J[16]+J[17]-J[18]+J[19]+
    J[20]+J[21]-J[22]-J[23]-J[24]+J[25]-J[26]+J[27]-J[28]-J[29]-J[30]-J[31]-J[32]+J[33]-J[34]+J[35]-J[36]-J[37]+
    J[38]+J[39]-J[40]+J[41]-J[42]+J[43]+J[44]+J[45]-J[46]+J[47]-J[48]+J[49]+J[50]-J[51]+J[52]-J[53]+J[54]+
    J[55]-J[56]+J[57]-J[58]-J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]-H[1]+H[2]+H[3]-H[4]-H[5]-H[6]+
    H[7]-H[8]-H[9]+H[10]+H[11]-J[0]+J[1]+J[2]-J[3]-J[4]-J[5]+J[6]-J[7]-J[8]+J[9]+J[10]-J[11]-J[12]+J[13]+
    J[14]+J[15]-J[16]+J[17]+J[18]-J[19]-J[20]+J[21]-J[22]-J[23]-J[24]+J[25]-J[26]-J[27]+J[28]+J[29]-J[30]-J[31]-J[32]+
    J[33]-J[34]-J[35]+J[36]+J[37]+J[38]+J[39]-J[40]+J[41]+J[42]-J[43]-J[44]+J[45]-J[46]+J[47]+J[48]-J[49]-J[50]-J[51]+
    J[52]+J[53]-J[54]-J[55]-J[56]-J[57]+J[58]+J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]-H[1]+H[2]+
    H[3]-H[4]-H[5]-H[6]+H[7]-H[8]-H[9]+H[10]-H[11]-J[0]+J[1]+J[2]-J[3]-J[4]-J[5]+J[6]-J[7]-J[8]+J[9]-J[10]-J[11]-J[12]+
    J[13]+J[14]+J[15]-J[16]+J[17]+J[18]-J[19]+J[20]+J[21]-J[22]-J[23]-J[24]+J[25]-J[26]-J[27]+J[28]-J[29]-J[30]-J[31]-J[32]+
    J[33]-J[34]-J[35]+J[36]-J[37]+J[38]+J[39]-J[40]+J[41]+J[42]-J[43]+J[44]+J[45]-J[46]+J[47]+J[48]-J[49]+
    J[50]-J[51]+J[52]+J[53]-J[54]+J[55]-J[56]-J[57]+J[58]-J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]-H[1]+
    H[2]+H[3]-H[4]-H[5]-H[6]+H[7]-H[8]-H[9]-H[10]+H[11]-J[0]+J[1]+J[2]-J[3]-J[4]-J[5]+J[6]-J[7]-J[8]-J[9]+
    J[10]-J[11]-J[12]+J[13]+J[14]+J[15]-J[16]+J[17]+J[18]+J[19]-J[20]+J[21]-J[22]-J[23]-J[24]+J[25]-J[26]-J[27]-J[28]+
    J[29]-J[30]-J[31]-J[32]+J[33]-J[34]-J[35]-J[36]+J[37]+J[38]+J[39]-J[40]+J[41]+J[42]+J[43]-J[44]+J[45]-J[46]+
    J[47]+J[48]+J[49]-J[50]-J[51]+J[52]+J[53]+J[54]-J[55]-J[56]-J[57]-J[58]+J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +
    H[0]-H[1]+H[2]+H[3]-H[4]-H[5]-H[6]+H[7]-H[8]-H[9]-H[10]-H[11]-J[0]+J[1]+J[2]-J[3]-J[4]-J[5]+J[6]-J[7]-J[8]-J[9]-J[10]-J[11]-J[12]+
    J[13]+J[14]+J[15]-J[16]+J[17]+J[18]+J[19]+J[20]+J[21]-J[22]-J[23]-J[24]+J[25]-J[26]-J[27]-J[28]-J[29]-J[30]-J[31]-J[32]+
    J[33]-J[34]-J[35]-J[36]-J[37]+J[38]+J[39]-J[40]+J[41]+J[42]+J[43]+J[44]+J[45]-J[46]+J[47]+J[48]+J[49]+
    J[50]-J[51]+J[52]+J[53]+J[54]+J[55]-J[56]-J[57]-J[58]-J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]-H[1]+
    H[2]+H[3]-H[4]-H[5]-H[6]-H[7]+H[8]+H[9]+H[10]+H[11]-J[0]+J[1]+J[2]-J[3]-J[4]-J[5]-J[6]+J[7]+J[8]+J[9]+
    J[10]-J[11]-J[12]+J[13]+J[14]+J[15]+J[16]-J[17]-J[18]-J[19]-J[20]+J[21]-J[22]-J[23]-J[24]-J[25]+J[26]+
    J[27]+J[28]+J[29]-J[30]-J[31]-J[32]-J[33]+J[34]+J[35]+J[36]+J[37]+J[38]+J[39]+J[40]-J[41]-J[42]-J[43]-J[44]+
    J[45]+J[46]-J[47]-J[48]-J[49]-J[50]+J[51]-J[52]-J[53]-J[54]-J[55]-J[56]-J[57]-J[58]-J[59]+J[60]+J[61]+
    J[62]+J[63]+J[64]+J[65], +H[0]-H[1]+H[2]+H[3]-H[4]-H[5]-H[6]-H[7]+H[8]+H[9]+H[10]-H[11]-J[0]+J[1]+J[2]-J[3]-J[4]-J[5]-J[6]+
    J[7]+J[8]+J[9]-J[10]-J[11]-J[12]+J[13]+J[14]+J[15]+J[16]-J[17]-J[18]-J[19]+J[20]+J[21]-J[22]-J[23]-J[24]-J[25]+
    J[26]+J[27]+J[28]-J[29]-J[30]-J[31]-J[32]-J[33]+J[34]+J[35]+J[36]-J[37]+J[38]+J[39]+J[40]-J[41]-J[42]-J[43]+
    J[44]+J[45]+J[46]-J[47]-J[48]-J[49]+J[50]+J[51]-J[52]-J[53]-J[54]+J[55]-J[56]-J[57]-J[58]+J[59]+J[60]+
    J[61]-J[62]+J[63]-J[64]-J[65], +H[0]-H[1]+H[2]+H[3]-H[4]-H[5]-H[6]-H[7]+H[8]+H[9]-H[10]+H[11]-J[0]+J[1]+
    J[2]-J[3]-J[4]-J[5]-J[6]+J[7]+J[8]-J[9]+J[10]-J[11]-J[12]+J[13]+J[14]+J[15]+J[16]-J[17]-J[18]+J[19]-J[20]+
    J[21]-J[22]-J[23]-J[24]-J[25]+J[26]+J[27]-J[28]+J[29]-J[30]-J[31]-J[32]-J[33]+J[34]+J[35]-J[36]+J[37]+
    J[38]+J[39]+J[40]-J[41]-J[42]+J[43]-J[44]+J[45]+J[46]-J[47]-J[48]+J[49]-J[50]+J[51]-J[52]-J[53]+J[54]-J[55]-J[56]-J[57]+
    J[58]-J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]-H[1]+H[2]+H[3]-H[4]-H[5]-H[6]-H[7]+H[8]+H[9]-H[10]-H[11]-J[0]+
    J[1]+J[2]-J[3]-J[4]-J[5]-J[6]+J[7]+J[8]-J[9]-J[10]-J[11]-J[12]+J[13]+J[14]+J[15]+J[16]-J[17]-J[18]+J[19]+
    J[20]+J[21]-J[22]-J[23]-J[24]-J[25]+J[26]+J[27]-J[28]-J[29]-J[30]-J[31]-J[32]-J[33]+J[34]+J[35]-J[36]-J[37]+
    J[38]+J[39]+J[40]-J[41]-J[42]+J[43]+J[44]+J[45]+J[46]-J[47]-J[48]+J[49]+J[50]+J[51]-J[52]-J[53]+J[54]+
    J[55]-J[56]-J[57]+J[58]+J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]-H[1]+H[2]+H[3]-H[4]-H[5]-H[6]-H[7]+
    H[8]-H[9]+H[10]+H[11]-J[0]+J[1]+J[2]-J[3]-J[4]-J[5]-J[6]+J[7]-J[8]+J[9]+J[10]-J[11]-J[12]+J[13]+J[14]+
    J[15]+J[16]-J[17]+J[18]-J[19]-J[20]+J[21]-J[22]-J[23]-J[24]-J[25]+J[26]-J[27]+J[28]+J[29]-J[30]-J[31]-J[32]-J[33]+
    J[34]-J[35]+J[36]+J[37]+J[38]+J[39]+J[40]-J[41]+J[42]-J[43]-J[44]+J[45]+J[46]-J[47]+J[48]-J[49]-J[50]+
    J[51]-J[52]+J[53]-J[54]-J[55]-J[56]+J[57]-J[58]-J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]-H[1]+
    H[2]+H[3]-H[4]-H[5]-H[6]-H[7]+H[8]-H[9]+H[10]-H[11]-J[0]+J[1]+J[2]-J[3]-J[4]-J[5]-J[6]+J[7]-J[8]+J[9]-J[10]-J[11]-J[12]+
    J[13]+J[14]+J[15]+J[16]-J[17]+J[18]-J[19]+J[20]+J[21]-J[22]-J[23]-J[24]-J[25]+J[26]-J[27]+J[28]-J[29]-J[30]-J[31]-J[32]-J[33]+
    J[34]-J[35]+J[36]-J[37]+J[38]+J[39]+J[40]-J[41]+J[42]-J[43]+J[44]+J[45]+J[46]-J[47]+J[48]-J[49]+J[50]+
    J[51]-J[52]+J[53]-J[54]+J[55]-J[56]+J[57]-J[58]+J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]-H[1]+
    H[2]+H[3]-H[4]-H[5]-H[6]-H[7]+H[8]-H[9]-H[10]+H[11]-J[0]+J[1]+J[2]-J[3]-J[4]-J[5]-J[6]+J[7]-J[8]-J[9]+
    J[10]-J[11]-J[12]+J[13]+J[14]+J[15]+J[16]-J[17]+J[18]+J[19]-J[20]+J[21]-J[22]-J[23]-J[24]-J[25]+J[26]-J[27]-J[28]+
    J[29]-J[30]-J[31]-J[32]-J[33]+J[34]-J[35]-J[36]+J[37]+J[38]+J[39]+J[40]-J[41]+J[42]+J[43]-J[44]+J[45]+
    J[46]-J[47]+J[48]+J[49]-J[50]+J[51]-J[52]+J[53]+J[54]-J[55]-J[56]+J[57]+J[58]-J[59]-J[60]-J[61]+J[62]+
    J[63]-J[64]-J[65], +H[0]-H[1]+H[2]+H[3]-H[4]-H[5]-H[6]-H[7]+H[8]-H[9]-H[10]-H[11]-J[0]+J[1]+J[2]-J[3]-J[4]-J[5]-J[6]+
    J[7]-J[8]-J[9]-J[10]-J[11]-J[12]+J[13]+J[14]+J[15]+J[16]-J[17]+J[18]+J[19]+J[20]+J[21]-J[22]-J[23]-J[24]-J[25]+
    J[26]-J[27]-J[28]-J[29]-J[30]-J[31]-J[32]-J[33]+J[34]-J[35]-J[36]-J[37]+J[38]+J[39]+J[40]-J[41]+J[42]+
    J[43]+J[44]+J[45]+J[46]-J[47]+J[48]+J[49]+J[50]+J[51]-J[52]+J[53]+J[54]+J[55]-J[56]+J[57]+J[58]+J[59]-J[60]-J[61]-J[62]+
    J[63]+J[64]+J[65], +H[0]-H[1]+H[2]+H[3]-H[4]-H[5]-H[6]-H[7]-H[8]+H[9]+H[10]+H[11]-J[0]+J[1]+J[2]-J[3]-J[4]-J[5]-J[6]-J[7]+
    J[8]+J[9]+J[10]-J[11]-J[12]+J[13]+J[14]+J[15]+J[16]+J[17]-J[18]-J[19]-J[20]+J[21]-J[22]-J[23]-J[24]-J[25]-J[26]+
    J[27]+J[28]+J[29]-J[30]-J[31]-J[32]-J[33]-J[34]+J[35]+J[36]+J[37]+J[38]+J[39]+J[40]+J[41]-J[42]-J[43]-J[44]+
    J[45]+J[46]+J[47]-J[48]-J[49]-J[50]+J[51]+J[52]-J[53]-J[54]-J[55]+J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+
    J[63]+J[64]+J[65], +H[0]-H[1]+H[2]+H[3]-H[4]-H[5]-H[6]-H[7]-H[8]+H[9]+H[10]-H[11]-J[0]+J[1]+J[2]-J[3]-J[4]-J[5]-J[6]-J[7]+
    J[8]+J[9]-J[10]-J[11]-J[12]+J[13]+J[14]+J[15]+J[16]+J[17]-J[18]-J[19]+J[20]+J[21]-J[22]-J[23]-J[24]-J[25]-J[26]+
    J[27]+J[28]-J[29]-J[30]-J[31]-J[32]-J[33]-J[34]+J[35]+J[36]-J[37]+J[38]+J[39]+J[40]+J[41]-J[42]-J[43]+
    J[44]+J[45]+J[46]+J[47]-J[48]-J[49]+J[50]+J[51]+J[52]-J[53]-J[54]+J[55]+J[56]-J[57]-J[58]+J[59]-J[60]-J[61]+
    J[62]+J[63]-J[64]-J[65], +H[0]-H[1]+H[2]+H[3]-H[4]-H[5]-H[6]-H[7]-H[8]+H[9]-H[10]+H[11]-J[0]+J[1]+J[2]-J[3]-J[4]-J[5]-J[6]-J[7]+
    J[8]-J[9]+J[10]-J[11]-J[12]+J[13]+J[14]+J[15]+J[16]+J[17]-J[18]+J[19]-J[20]+J[21]-J[22]-J[23]-J[24]-J[25]-J[26]+
    J[27]-J[28]+J[29]-J[30]-J[31]-J[32]-J[33]-J[34]+J[35]-J[36]+J[37]+J[38]+J[39]+J[40]+J[41]-J[42]+J[43]-J[44]+
    J[45]+J[46]+J[47]-J[48]+J[49]-J[50]+J[51]+J[52]-J[53]+J[54]-J[55]+J[56]-J[57]+J[58]-J[59]-J[60]+J[61]-J[62]-J[63]+
    J[64]-J[65], +H[0]-H[1]+H[2]+H[3]-H[4]-H[5]-H[6]-H[7]-H[8]+H[9]-H[10]-H[11]-J[0]+J[1]+J[2]-J[3]-J[4]-J[5]-J[6]-J[7]+
    J[8]-J[9]-J[10]-J[11]-J[12]+J[13]+J[14]+J[15]+J[16]+J[17]-J[18]+J[19]+J[20]+J[21]-J[22]-J[23]-J[24]-J[25]-J[26]+
    J[27]-J[28]-J[29]-J[30]-J[31]-J[32]-J[33]-J[34]+J[35]-J[36]-J[37]+J[38]+J[39]+J[40]+J[41]-J[42]+J[43]+
    J[44]+J[45]+J[46]+J[47]-J[48]+J[49]+J[50]+J[51]+J[52]-J[53]+J[54]+J[55]+J[56]-J[57]+J[58]+J[59]-J[60]+
    J[61]+J[62]-J[63]-J[64]+J[65], +H[0]-H[1]+H[2]+H[3]-H[4]-H[5]-H[6]-H[7]-H[8]-H[9]+H[10]+H[11]-J[0]+J[1]+
    J[2]-J[3]-J[4]-J[5]-J[6]-J[7]-J[8]+J[9]+J[10]-J[11]-J[12]+J[13]+J[14]+J[15]+J[16]+J[17]+J[18]-J[19]-J[20]+
    J[21]-J[22]-J[23]-J[24]-J[25]-J[26]-J[27]+J[28]+J[29]-J[30]-J[31]-J[32]-J[33]-J[34]-J[35]+J[36]+J[37]+
    J[38]+J[39]+J[40]+J[41]+J[42]-J[43]-J[44]+J[45]+J[46]+J[47]+J[48]-J[49]-J[50]+J[51]+J[52]+J[53]-J[54]-J[55]+
    J[56]+J[57]-J[58]-J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]-H[1]+H[2]+H[3]-H[4]-H[5]-H[6]-H[7]-H[8]-H[9]+
    H[10]-H[11]-J[0]+J[1]+J[2]-J[3]-J[4]-J[5]-J[6]-J[7]-J[8]+J[9]-J[10]-J[11]-J[12]+J[13]+J[14]+J[15]+J[16]+
    J[17]+J[18]-J[19]+J[20]+J[21]-J[22]-J[23]-J[24]-J[25]-J[26]-J[27]+J[28]-J[29]-J[30]-J[31]-J[32]-J[33]-J[34]-J[35]+
    J[36]-J[37]+J[38]+J[39]+J[40]+J[41]+J[42]-J[43]+J[44]+J[45]+J[46]+J[47]+J[48]-J[49]+J[50]+J[51]+J[52]+
    J[53]-J[54]+J[55]+J[56]+J[57]-J[58]+J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]-H[1]+H[2]+H[3]-H[4]-H[5]-H[6]-H[7]-H[8]-H[9]-H[10]+
    H[11]-J[0]+J[1]+J[2]-J[3]-J[4]-J[5]-J[6]-J[7]-J[8]-J[9]+J[10]-J[11]-J[12]+J[13]+J[14]+J[15]+J[16]+J[17]+
    J[18]+J[19]-J[20]+J[21]-J[22]-J[23]-J[24]-J[25]-J[26]-J[27]-J[28]+J[29]-J[30]-J[31]-J[32]-J[33]-J[34]-J[35]-J[36]+
    J[37]+J[38]+J[39]+J[40]+J[41]+J[42]+J[43]-J[44]+J[45]+J[46]+J[47]+J[48]+J[49]-J[50]+J[51]+J[52]+J[53]+
    J[54]-J[55]+J[56]+J[57]+J[58]-J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]-H[1]+H[2]+H[3]-H[4]-H[5]-H[6]-H[7]-H[8]-H[9]-H[10]-H[11]-J[0]+
    J[1]+J[2]-J[3]-J[4]-J[5]-J[6]-J[7]-J[8]-J[9]-J[10]-J[11]-J[12]+J[13]+J[14]+J[15]+J[16]+J[17]+J[18]+J[19]+
    J[20]+J[21]-J[22]-J[23]-J[24]-J[25]-J[26]-J[27]-J[28]-J[29]-J[30]-J[31]-J[32]-J[33]-J[34]-J[35]-J[36]-J[37]+
    J[38]+J[39]+J[40]+J[41]+J[42]+J[43]+J[44]+J[45]+J[46]+J[47]+J[48]+J[49]+J[50]+J[51]+J[52]+J[53]+J[54]+
    J[55]+J[56]+J[57]+J[58]+J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]-H[1]+H[2]-H[3]+H[4]+H[5]+H[6]+
    H[7]+H[8]+H[9]+H[10]+H[11]-J[0]+J[1]-J[2]+J[3]+J[4]+J[5]+J[6]+J[7]+J[8]+J[9]+J[10]-J[11]+J[12]-J[13]-J[14]-J[15]-J[16]-J[17]-J[18]-J[19]-J[20]-J[21]+
    J[22]+J[23]+J[24]+J[25]+J[26]+J[27]+J[28]+J[29]-J[30]-J[31]-J[32]-J[33]-J[34]-J[35]-J[36]-J[37]+J[38]+
    J[39]+J[40]+J[41]+J[42]+J[43]+J[44]+J[45]+J[46]+J[47]+J[48]+J[49]+J[50]+J[51]+J[52]+J[53]+J[54]+J[55]+
    J[56]+J[57]+J[58]+J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]-H[1]+H[2]-H[3]+H[4]+H[5]+H[6]+H[7]+
    H[8]+H[9]+H[10]-H[11]-J[0]+J[1]-J[2]+J[3]+J[4]+J[5]+J[6]+J[7]+J[8]+J[9]-J[10]-J[11]+J[12]-J[13]-J[14]-J[15]-J[16]-J[17]-J[18]-J[19]+
    J[20]-J[21]+J[22]+J[23]+J[24]+J[25]+J[26]+J[27]+J[28]-J[29]-J[30]-J[31]-J[32]-J[33]-J[34]-J[35]-J[36]+
    J[37]+J[38]+J[39]+J[40]+J[41]+J[42]+J[43]-J[44]+J[45]+J[46]+J[47]+J[48]+J[49]-J[50]+J[51]+J[52]+J[53]+
    J[54]-J[55]+J[56]+J[57]+J[58]-J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]-H[1]+H[2]-H[3]+H[4]+H[5]+
    H[6]+H[7]+H[8]+H[9]-H[10]+H[11]-J[0]+J[1]-J[2]+J[3]+J[4]+J[5]+J[6]+J[7]+J[8]-J[9]+J[10]-J[11]+J[12]-J[13]-J[14]-J[15]-J[16]-J[17]-J[18]+
    J[19]-J[20]-J[21]+J[22]+J[23]+J[24]+J[25]+J[26]+J[27]-J[28]+J[29]-J[30]-J[31]-J[32]-J[33]-J[34]-J[35]+
    J[36]-J[37]+J[38]+J[39]+J[40]+J[41]+J[42]-J[43]+J[44]+J[45]+J[46]+J[47]+J[48]-J[49]+J[50]+J[51]+J[52]+
    J[53]-J[54]+J[55]+J[56]+J[57]-J[58]+J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]-H[1]+H[2]-H[3]+
    H[4]+H[5]+H[6]+H[7]+H[8]+H[9]-H[10]-H[11]-J[0]+J[1]-J[2]+J[3]+J[4]+J[5]+J[6]+J[7]+J[8]-J[9]-J[10]-J[11]+
    J[12]-J[13]-J[14]-J[15]-J[16]-J[17]-J[18]+J[19]+J[20]-J[21]+J[22]+J[23]+J[24]+J[25]+J[26]+J[27]-J[28]-J[29]-J[30]-J[31]-J[32]-J[33]-J[34]-J[35]+
    J[36]+J[37]+J[38]+J[39]+J[40]+J[41]+J[42]-J[43]-J[44]+J[45]+J[46]+J[47]+J[48]-J[49]-J[50]+J[51]+J[52]+
    J[53]-J[54]-J[55]+J[56]+J[57]-J[58]-J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]-H[1]+H[2]-H[3]+
    H[4]+H[5]+H[6]+H[7]+H[8]-H[9]+H[10]+H[11]-J[0]+J[1]-J[2]+J[3]+J[4]+J[5]+J[6]+J[7]-J[8]+J[9]+J[10]-J[11]+
    J[12]-J[13]-J[14]-J[15]-J[16]-J[17]+J[18]-J[19]-J[20]-J[21]+J[22]+J[23]+J[24]+J[25]+J[26]-J[27]+J[28]+
    J[29]-J[30]-J[31]-J[32]-J[33]-J[34]+J[35]-J[36]-J[37]+J[38]+J[39]+J[40]+J[41]-J[42]+J[43]+J[44]+J[45]+
    J[46]+J[47]-J[48]+J[49]+J[50]+J[51]+J[52]-J[53]+J[54]+J[55]+J[56]-J[57]+J[58]+J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+
    J[65], +H[0]-H[1]+H[2]-H[3]+H[4]+H[5]+H[6]+H[7]+H[8]-H[9]+H[10]-H[11]-J[0]+J[1]-J[2]+J[3]+J[4]+J[5]+
    J[6]+J[7]-J[8]+J[9]-J[10]-J[11]+J[12]-J[13]-J[14]-J[15]-J[16]-J[17]+J[18]-J[19]+J[20]-J[21]+J[22]+J[23]+
    J[24]+J[25]+J[26]-J[27]+J[28]-J[29]-J[30]-J[31]-J[32]-J[33]-J[34]+J[35]-J[36]+J[37]+J[38]+J[39]+J[40]+
    J[41]-J[42]+J[43]-J[44]+J[45]+J[46]+J[47]-J[48]+J[49]-J[50]+J[51]+J[52]-J[53]+J[54]-J[55]+J[56]-J[57]+
    J[58]-J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]-H[1]+H[2]-H[3]+H[4]+H[5]+H[6]+H[7]+H[8]-H[9]-H[10]+
    H[11]-J[0]+J[1]-J[2]+J[3]+J[4]+J[5]+J[6]+J[7]-J[8]-J[9]+J[10]-J[11]+J[12]-J[13]-J[14]-J[15]-J[16]-J[17]+
    J[18]+J[19]-J[20]-J[21]+J[22]+J[23]+J[24]+J[25]+J[26]-J[27]-J[28]+J[29]-J[30]-J[31]-J[32]-J[33]-J[34]+
    J[35]+J[36]-J[37]+J[38]+J[39]+J[40]+J[41]-J[42]-J[43]+J[44]+J[45]+J[46]+J[47]-J[48]-J[49]+J[50]+J[51]+
    J[52]-J[53]-J[54]+J[55]+J[56]-J[57]-J[58]+J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]-H[1]+H[2]-H[3]+
    H[4]+H[5]+H[6]+H[7]+H[8]-H[9]-H[10]-H[11]-J[0]+J[1]-J[2]+J[3]+J[4]+J[5]+J[6]+J[7]-J[8]-J[9]-J[10]-J[11]+
    J[12]-J[13]-J[14]-J[15]-J[16]-J[17]+J[18]+J[19]+J[20]-J[21]+J[22]+J[23]+J[24]+J[25]+J[26]-J[27]-J[28]-J[29]-J[30]-J[31]-J[32]-J[33]-J[34]+
    J[35]+J[36]+J[37]+J[38]+J[39]+J[40]+J[41]-J[42]-J[43]-J[44]+J[45]+J[46]+J[47]-J[48]-J[49]-J[50]+J[51]+
    J[52]-J[53]-J[54]-J[55]+J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]-H[1]+H[2]-H[3]+
    H[4]+H[5]+H[6]+H[7]-H[8]+H[9]+H[10]+H[11]-J[0]+J[1]-J[2]+J[3]+J[4]+J[5]+J[6]-J[7]+J[8]+J[9]+J[10]-J[11]+
    J[12]-J[13]-J[14]-J[15]-J[16]+J[17]-J[18]-J[19]-J[20]-J[21]+J[22]+J[23]+J[24]+J[25]-J[26]+J[27]+J[28]+
    J[29]-J[30]-J[31]-J[32]-J[33]+J[34]-J[35]-J[36]-J[37]+J[38]+J[39]+J[40]-J[41]+J[42]+J[43]+J[44]+J[45]+
    J[46]-J[47]+J[48]+J[49]+J[50]+J[51]-J[52]+J[53]+J[54]+J[55]-J[56]+J[57]+J[58]+J[59]-J[60]-J[61]-J[62]+
    J[63]+J[64]+J[65], +H[0]-H[1]+H[2]-H[3]+H[4]+H[5]+H[6]+H[7]-H[8]+H[9]+H[10]-H[11]-J[0]+J[1]-J[2]+J[3]+
    J[4]+J[5]+J[6]-J[7]+J[8]+J[9]-J[10]-J[11]+J[12]-J[13]-J[14]-J[15]-J[16]+J[17]-J[18]-J[19]+J[20]-J[21]+
    J[22]+J[23]+J[24]+J[25]-J[26]+J[27]+J[28]-J[29]-J[30]-J[31]-J[32]-J[33]+J[34]-J[35]-J[36]+J[37]+J[38]+
    J[39]+J[40]-J[41]+J[42]+J[43]-J[44]+J[45]+J[46]-J[47]+J[48]+J[49]-J[50]+J[51]-J[52]+J[53]+J[54]-J[55]-J[56]+
    J[57]+J[58]-J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]-H[1]+H[2]-H[3]+H[4]+H[5]+H[6]+H[7]-H[8]+
    H[9]-H[10]+H[11]-J[0]+J[1]-J[2]+J[3]+J[4]+J[5]+J[6]-J[7]+J[8]-J[9]+J[10]-J[11]+J[12]-J[13]-J[14]-J[15]-J[16]+
    J[17]-J[18]+J[19]-J[20]-J[21]+J[22]+J[23]+J[24]+J[25]-J[26]+J[27]-J[28]+J[29]-J[30]-J[31]-J[32]-J[33]+
    J[34]-J[35]+J[36]-J[37]+J[38]+J[39]+J[40]-J[41]+J[42]-J[43]+J[44]+J[45]+J[46]-J[47]+J[48]-J[49]+J[50]+
    J[51]-J[52]+J[53]-J[54]+J[55]-J[56]+J[57]-J[58]+J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]-H[1]+
    H[2]-H[3]+H[4]+H[5]+H[6]+H[7]-H[8]+H[9]-H[10]-H[11]-J[0]+J[1]-J[2]+J[3]+J[4]+J[5]+J[6]-J[7]+J[8]-J[9]-J[10]-J[11]+
    J[12]-J[13]-J[14]-J[15]-J[16]+J[17]-J[18]+J[19]+J[20]-J[21]+J[22]+J[23]+J[24]+J[25]-J[26]+J[27]-J[28]-J[29]-J[30]-J[31]-J[32]-J[33]+
    J[34]-J[35]+J[36]+J[37]+J[38]+J[39]+J[40]-J[41]+J[42]-J[43]-J[44]+J[45]+J[46]-J[47]+J[48]-J[49]-J[50]+
    J[51]-J[52]+J[53]-J[54]-J[55]-J[56]+J[57]-J[58]-J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]-H[1]+
    H[2]-H[3]+H[4]+H[5]+H[6]+H[7]-H[8]-H[9]+H[10]+H[11]-J[0]+J[1]-J[2]+J[3]+J[4]+J[5]+J[6]-J[7]-J[8]+J[9]+
    J[10]-J[11]+J[12]-J[13]-J[14]-J[15]-J[16]+J[17]+J[18]-J[19]-J[20]-J[21]+J[22]+J[23]+J[24]+J[25]-J[26]-J[27]+
    J[28]+J[29]-J[30]-J[31]-J[32]-J[33]+J[34]+J[35]-J[36]-J[37]+J[38]+J[39]+J[40]-J[41]-J[42]+J[43]+J[44]+
    J[45]+J[46]-J[47]-J[48]+J[49]+J[50]+J[51]-J[52]-J[53]+J[54]+J[55]-J[56]-J[57]+J[58]+J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+
    J[65], +H[0]-H[1]+H[2]-H[3]+H[4]+H[5]+H[6]+H[7]-H[8]-H[9]+H[10]-H[11]-J[0]+J[1]-J[2]+J[3]+J[4]+J[5]+
    J[6]-J[7]-J[8]+J[9]-J[10]-J[11]+J[12]-J[13]-J[14]-J[15]-J[16]+J[17]+J[18]-J[19]+J[20]-J[21]+J[22]+J[23]+
    J[24]+J[25]-J[26]-J[27]+J[28]-J[29]-J[30]-J[31]-J[32]-J[33]+J[34]+J[35]-J[36]+J[37]+J[38]+J[39]+J[40]-J[41]-J[42]+
    J[43]-J[44]+J[45]+J[46]-J[47]-J[48]+J[49]-J[50]+J[51]-J[52]-J[53]+J[54]-J[55]-J[56]-J[57]+J[58]-J[59]+
    J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]-H[1]+H[2]-H[3]+H[4]+H[5]+H[6]+H[7]-H[8]-H[9]-H[10]+H[11]-J[0]+
    J[1]-J[2]+J[3]+J[4]+J[5]+J[6]-J[7]-J[8]-J[9]+J[10]-J[11]+J[12]-J[13]-J[14]-J[15]-J[16]+J[17]+J[18]+J[19]-J[20]-J[21]+
    J[22]+J[23]+J[24]+J[25]-J[26]-J[27]-J[28]+J[29]-J[30]-J[31]-J[32]-J[33]+J[34]+J[35]+J[36]-J[37]+J[38]+
    J[39]+J[40]-J[41]-J[42]-J[43]+J[44]+J[45]+J[46]-J[47]-J[48]-J[49]+J[50]+J[51]-J[52]-J[53]-J[54]+J[55]-J[56]-J[57]-J[58]+
    J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]-H[1]+H[2]-H[3]+H[4]+H[5]+H[6]+H[7]-H[8]-H[9]-H[10]-H[11]-J[0]+
    J[1]-J[2]+J[3]+J[4]+J[5]+J[6]-J[7]-J[8]-J[9]-J[10]-J[11]+J[12]-J[13]-J[14]-J[15]-J[16]+J[17]+J[18]+J[19]+
    J[20]-J[21]+J[22]+J[23]+J[24]+J[25]-J[26]-J[27]-J[28]-J[29]-J[30]-J[31]-J[32]-J[33]+J[34]+J[35]+J[36]+
    J[37]+J[38]+J[39]+J[40]-J[41]-J[42]-J[43]-J[44]+J[45]+J[46]-J[47]-J[48]-J[49]-J[50]+J[51]-J[52]-J[53]-J[54]-J[55]-J[56]-J[57]-J[58]-J[59]+
    J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]-H[1]+H[2]-H[3]+H[4]+H[5]+H[6]-H[7]+H[8]+H[9]+H[10]+H[11]-J[0]+
    J[1]-J[2]+J[3]+J[4]+J[5]-J[6]+J[7]+J[8]+J[9]+J[10]-J[11]+J[12]-J[13]-J[14]-J[15]+J[16]-J[17]-J[18]-J[19]-J[20]-J[21]+
    J[22]+J[23]+J[24]-J[25]+J[26]+J[27]+J[28]+J[29]-J[30]-J[31]-J[32]+J[33]-J[34]-J[35]-J[36]-J[37]+J[38]+
    J[39]-J[40]+J[41]+J[42]+J[43]+J[44]+J[45]-J[46]+J[47]+J[48]+J[49]+J[50]-J[51]+J[52]+J[53]+J[54]+J[55]-J[56]-J[57]-J[58]-J[59]+
    J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]-H[1]+H[2]-H[3]+H[4]+H[5]+H[6]-H[7]+H[8]+H[9]+H[10]-H[11]-J[0]+
    J[1]-J[2]+J[3]+J[4]+J[5]-J[6]+J[7]+J[8]+J[9]-J[10]-J[11]+J[12]-J[13]-J[14]-J[15]+J[16]-J[17]-J[18]-J[19]+
    J[20]-J[21]+J[22]+J[23]+J[24]-J[25]+J[26]+J[27]+J[28]-J[29]-J[30]-J[31]-J[32]+J[33]-J[34]-J[35]-J[36]+
    J[37]+J[38]+J[39]-J[40]+J[41]+J[42]+J[43]-J[44]+J[45]-J[46]+J[47]+J[48]+J[49]-J[50]-J[51]+J[52]+J[53]+
    J[54]-J[55]-J[56]-J[57]-J[58]+J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]-H[1]+H[2]-H[3]+H[4]+H[5]+
    H[6]-H[7]+H[8]+H[9]-H[10]+H[11]-J[0]+J[1]-J[2]+J[3]+J[4]+J[5]-J[6]+J[7]+J[8]-J[9]+J[10]-J[11]+J[12]-J[13]-J[14]-J[15]+
    J[16]-J[17]-J[18]+J[19]-J[20]-J[21]+J[22]+J[23]+J[24]-J[25]+J[26]+J[27]-J[28]+J[29]-J[30]-J[31]-J[32]+
    J[33]-J[34]-J[35]+J[36]-J[37]+J[38]+J[39]-J[40]+J[41]+J[42]-J[43]+J[44]+J[45]-J[46]+J[47]+J[48]-J[49]+
    J[50]-J[51]+J[52]+J[53]-J[54]+J[55]-J[56]-J[57]+J[58]-J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]-H[1]+
    H[2]-H[3]+H[4]+H[5]+H[6]-H[7]+H[8]+H[9]-H[10]-H[11]-J[0]+J[1]-J[2]+J[3]+J[4]+J[5]-J[6]+J[7]+J[8]-J[9]-J[10]-J[11]+
    J[12]-J[13]-J[14]-J[15]+J[16]-J[17]-J[18]+J[19]+J[20]-J[21]+J[22]+J[23]+J[24]-J[25]+J[26]+J[27]-J[28]-J[29]-J[30]-J[31]-J[32]+
    J[33]-J[34]-J[35]+J[36]+J[37]+J[38]+J[39]-J[40]+J[41]+J[42]-J[43]-J[44]+J[45]-J[46]+J[47]+J[48]-J[49]-J[50]-J[51]+
    J[52]+J[53]-J[54]-J[55]-J[56]-J[57]+J[58]+J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]-H[1]+H[2]-H[3]+
    H[4]+H[5]+H[6]-H[7]+H[8]-H[9]+H[10]+H[11]-J[0]+J[1]-J[2]+J[3]+J[4]+J[5]-J[6]+J[7]-J[8]+J[9]+J[10]-J[11]+
    J[12]-J[13]-J[14]-J[15]+J[16]-J[17]+J[18]-J[19]-J[20]-J[21]+J[22]+J[23]+J[24]-J[25]+J[26]-J[27]+J[28]+
    J[29]-J[30]-J[31]-J[32]+J[33]-J[34]+J[35]-J[36]-J[37]+J[38]+J[39]-J[40]+J[41]-J[42]+J[43]+J[44]+J[45]-J[46]+
    J[47]-J[48]+J[49]+J[50]-J[51]+J[52]-J[53]+J[54]+J[55]-J[56]+J[57]-J[58]-J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+
    J[65], +H[0]-H[1]+H[2]-H[3]+H[4]+H[5]+H[6]-H[7]+H[8]-H[9]+H[10]-H[11]-J[0]+J[1]-J[2]+J[3]+J[4]+J[5]-J[6]+
    J[7]-J[8]+J[9]-J[10]-J[11]+J[12]-J[13]-J[14]-J[15]+J[16]-J[17]+J[18]-J[19]+J[20]-J[21]+J[22]+J[23]+J[24]-J[25]+
    J[26]-J[27]+J[28]-J[29]-J[30]-J[31]-J[32]+J[33]-J[34]+J[35]-J[36]+J[37]+J[38]+J[39]-J[40]+J[41]-J[42]+
    J[43]-J[44]+J[45]-J[46]+J[47]-J[48]+J[49]-J[50]-J[51]+J[52]-J[53]+J[54]-J[55]-J[56]+J[57]-J[58]+J[59]-J[60]+
    J[61]-J[62]-J[63]+J[64]-J[65], +H[0]-H[1]+H[2]-H[3]+H[4]+H[5]+H[6]-H[7]+H[8]-H[9]-H[10]+H[11]-J[0]+J[1]-J[2]+
    J[3]+J[4]+J[5]-J[6]+J[7]-J[8]-J[9]+J[10]-J[11]+J[12]-J[13]-J[14]-J[15]+J[16]-J[17]+J[18]+J[19]-J[20]-J[21]+
    J[22]+J[23]+J[24]-J[25]+J[26]-J[27]-J[28]+J[29]-J[30]-J[31]-J[32]+J[33]-J[34]+J[35]+J[36]-J[37]+J[38]+
    J[39]-J[40]+J[41]-J[42]-J[43]+J[44]+J[45]-J[46]+J[47]-J[48]-J[49]+J[50]-J[51]+J[52]-J[53]-J[54]+J[55]-J[56]+
    J[57]+J[58]-J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]-H[1]+H[2]-H[3]+H[4]+H[5]+H[6]-H[7]+H[8]-H[9]-H[10]-H[11]-J[0]+
    J[1]-J[2]+J[3]+J[4]+J[5]-J[6]+J[7]-J[8]-J[9]-J[10]-J[11]+J[12]-J[13]-J[14]-J[15]+J[16]-J[17]+J[18]+J[19]+
    J[20]-J[21]+J[22]+J[23]+J[24]-J[25]+J[26]-J[27]-J[28]-J[29]-J[30]-J[31]-J[32]+J[33]-J[34]+J[35]+J[36]+
    J[37]+J[38]+J[39]-J[40]+J[41]-J[42]-J[43]-J[44]+J[45]-J[46]+J[47]-J[48]-J[49]-J[50]-J[51]+J[52]-J[53]-J[54]-J[55]-J[56]+
    J[57]+J[58]+J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]-H[1]+H[2]-H[3]+H[4]+H[5]+H[6]-H[7]-H[8]+
    H[9]+H[10]+H[11]-J[0]+J[1]-J[2]+J[3]+J[4]+J[5]-J[6]-J[7]+J[8]+J[9]+J[10]-J[11]+J[12]-J[13]-J[14]-J[15]+
    J[16]+J[17]-J[18]-J[19]-J[20]-J[21]+J[22]+J[23]+J[24]-J[25]-J[26]+J[27]+J[28]+J[29]-J[30]-J[31]-J[32]+
    J[33]+J[34]-J[35]-J[36]-J[37]+J[38]+J[39]-J[40]-J[41]+J[42]+J[43]+J[44]+J[45]-J[46]-J[47]+J[48]+J[49]+
    J[50]-J[51]-J[52]+J[53]+J[54]+J[55]+J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]-H[1]+
    H[2]-H[3]+H[4]+H[5]+H[6]-H[7]-H[8]+H[9]+H[10]-H[11]-J[0]+J[1]-J[2]+J[3]+J[4]+J[5]-J[6]-J[7]+J[8]+J[9]-J[10]-J[11]+
    J[12]-J[13]-J[14]-J[15]+J[16]+J[17]-J[18]-J[19]+J[20]-J[21]+J[22]+J[23]+J[24]-J[25]-J[26]+J[27]+J[28]-J[29]-J[30]-J[31]-J[32]+
    J[33]+J[34]-J[35]-J[36]+J[37]+J[38]+J[39]-J[40]-J[41]+J[42]+J[43]-J[44]+J[45]-J[46]-J[47]+J[48]+J[49]-J[50]-J[51]-J[52]+
    J[53]+J[54]-J[55]+J[56]-J[57]-J[58]+J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]-H[1]+H[2]-H[3]+
    H[4]+H[5]+H[6]-H[7]-H[8]+H[9]-H[10]+H[11]-J[0]+J[1]-J[2]+J[3]+J[4]+J[5]-J[6]-J[7]+J[8]-J[9]+J[10]-J[11]+
    J[12]-J[13]-J[14]-J[15]+J[16]+J[17]-J[18]+J[19]-J[20]-J[21]+J[22]+J[23]+J[24]-J[25]-J[26]+J[27]-J[28]+
    J[29]-J[30]-J[31]-J[32]+J[33]+J[34]-J[35]+J[36]-J[37]+J[38]+J[39]-J[40]-J[41]+J[42]-J[43]+J[44]+J[45]-J[46]-J[47]+
    J[48]-J[49]+J[50]-J[51]-J[52]+J[53]-J[54]+J[55]+J[56]-J[57]+J[58]-J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +
    H[0]-H[1]+H[2]-H[3]+H[4]+H[5]+H[6]-H[7]-H[8]+H[9]-H[10]-H[11]-J[0]+J[1]-J[2]+J[3]+J[4]+J[5]-J[6]-J[7]+
    J[8]-J[9]-J[10]-J[11]+J[12]-J[13]-J[14]-J[15]+J[16]+J[17]-J[18]+J[19]+J[20]-J[21]+J[22]+J[23]+J[24]-J[25]-J[26]+
    J[27]-J[28]-J[29]-J[30]-J[31]-J[32]+J[33]+J[34]-J[35]+J[36]+J[37]+J[38]+J[39]-J[40]-J[41]+J[42]-J[43]-J[44]+
    J[45]-J[46]-J[47]+J[48]-J[49]-J[50]-J[51]-J[52]+J[53]-J[54]-J[55]+J[56]-J[57]+J[58]+J[59]-J[60]+J[61]+
    J[62]-J[63]-J[64]+J[65], +H[0]-H[1]+H[2]-H[3]+H[4]+H[5]+H[6]-H[7]-H[8]-H[9]+H[10]+H[11]-J[0]+J[1]-J[2]+
    J[3]+J[4]+J[5]-J[6]-J[7]-J[8]+J[9]+J[10]-J[11]+J[12]-J[13]-J[14]-J[15]+J[16]+J[17]+J[18]-J[19]-J[20]-J[21]+
    J[22]+J[23]+J[24]-J[25]-J[26]-J[27]+J[28]+J[29]-J[30]-J[31]-J[32]+J[33]+J[34]+J[35]-J[36]-J[37]+J[38]+
    J[39]-J[40]-J[41]-J[42]+J[43]+J[44]+J[45]-J[46]-J[47]-J[48]+J[49]+J[50]-J[51]-J[52]-J[53]+J[54]+J[55]+
    J[56]+J[57]-J[58]-J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]-H[1]+H[2]-H[3]+H[4]+H[5]+H[6]-H[7]-H[8]-H[9]+
    H[10]-H[11]-J[0]+J[1]-J[2]+J[3]+J[4]+J[5]-J[6]-J[7]-J[8]+J[9]-J[10]-J[11]+J[12]-J[13]-J[14]-J[15]+J[16]+
    J[17]+J[18]-J[19]+J[20]-J[21]+J[22]+J[23]+J[24]-J[25]-J[26]-J[27]+J[28]-J[29]-J[30]-J[31]-J[32]+J[33]+
    J[34]+J[35]-J[36]+J[37]+J[38]+J[39]-J[40]-J[41]-J[42]+J[43]-J[44]+J[45]-J[46]-J[47]-J[48]+J[49]-J[50]-J[51]-J[52]-J[53]+
    J[54]-J[55]+J[56]+J[57]-J[58]+J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]-H[1]+H[2]-H[3]+H[4]+H[5]+
    H[6]-H[7]-H[8]-H[9]-H[10]+H[11]-J[0]+J[1]-J[2]+J[3]+J[4]+J[5]-J[6]-J[7]-J[8]-J[9]+J[10]-J[11]+J[12]-J[13]-J[14]-J[15]+
    J[16]+J[17]+J[18]+J[19]-J[20]-J[21]+J[22]+J[23]+J[24]-J[25]-J[26]-J[27]-J[28]+J[29]-J[30]-J[31]-J[32]+
    J[33]+J[34]+J[35]+J[36]-J[37]+J[38]+J[39]-J[40]-J[41]-J[42]-J[43]+J[44]+J[45]-J[46]-J[47]-J[48]-J[49]+
    J[50]-J[51]-J[52]-J[53]-J[54]+J[55]+J[56]+J[57]+J[58]-J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]-H[1]+
    H[2]-H[3]+H[4]+H[5]+H[6]-H[7]-H[8]-H[9]-H[10]-H[11]-J[0]+J[1]-J[2]+J[3]+J[4]+J[5]-J[6]-J[7]-J[8]-J[9]-J[10]-J[11]+
    J[12]-J[13]-J[14]-J[15]+J[16]+J[17]+J[18]+J[19]+J[20]-J[21]+J[22]+J[23]+J[24]-J[25]-J[26]-J[27]-J[28]-J[29]-J[30]-J[31]-J[32]+
    J[33]+J[34]+J[35]+J[36]+J[37]+J[38]+J[39]-J[40]-J[41]-J[42]-J[43]-J[44]+J[45]-J[46]-J[47]-J[48]-J[49]-J[50]-J[51]-J[52]-J[53]-J[54]-J[55]+
    J[56]+J[57]+J[58]+J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]-H[1]+H[2]-H[3]+H[4]+H[5]-H[6]+H[7]+
    H[8]+H[9]+H[10]+H[11]-J[0]+J[1]-J[2]+J[3]+J[4]-J[5]+J[6]+J[7]+J[8]+J[9]+J[10]-J[11]+J[12]-J[13]-J[14]+
    J[15]-J[16]-J[17]-J[18]-J[19]-J[20]-J[21]+J[22]+J[23]-J[24]+J[25]+J[26]+J[27]+J[28]+J[29]-J[30]-J[31]+
    J[32]-J[33]-J[34]-J[35]-J[36]-J[37]+J[38]-J[39]+J[40]+J[41]+J[42]+J[43]+J[44]-J[45]+J[46]+J[47]+J[48]+
    J[49]+J[50]-J[51]-J[52]-J[53]-J[54]-J[55]+J[56]+J[57]+J[58]+J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +
    H[0]-H[1]+H[2]-H[3]+H[4]+H[5]-H[6]+H[7]+H[8]+H[9]+H[10]-H[11]-J[0]+J[1]-J[2]+J[3]+J[4]-J[5]+J[6]+J[7]+
    J[8]+J[9]-J[10]-J[11]+J[12]-J[13]-J[14]+J[15]-J[16]-J[17]-J[18]-J[19]+J[20]-J[21]+J[22]+J[23]-J[24]+
    J[25]+J[26]+J[27]+J[28]-J[29]-J[30]-J[31]+J[32]-J[33]-J[34]-J[35]-J[36]+J[37]+J[38]-J[39]+J[40]+J[41]+
    J[42]+J[43]-J[44]-J[45]+J[46]+J[47]+J[48]+J[49]-J[50]-J[51]-J[52]-J[53]-J[54]+J[55]+J[56]+J[57]+J[58]-J[59]+
    J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]-H[1]+H[2]-H[3]+H[4]+H[5]-H[6]+H[7]+H[8]+H[9]-H[10]+H[11]-J[0]+
    J[1]-J[2]+J[3]+J[4]-J[5]+J[6]+J[7]+J[8]-J[9]+J[10]-J[11]+J[12]-J[13]-J[14]+J[15]-J[16]-J[17]-J[18]+J[19]-J[20]-J[21]+
    J[22]+J[23]-J[24]+J[25]+J[26]+J[27]-J[28]+J[29]-J[30]-J[31]+J[32]-J[33]-J[34]-J[35]+J[36]-J[37]+J[38]-J[39]+
    J[40]+J[41]+J[42]-J[43]+J[44]-J[45]+J[46]+J[47]+J[48]-J[49]+J[50]-J[51]-J[52]-J[53]+J[54]-J[55]+J[56]+
    J[57]-J[58]+J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]-H[1]+H[2]-H[3]+H[4]+H[5]-H[6]+H[7]+H[8]+
    H[9]-H[10]-H[11]-J[0]+J[1]-J[2]+J[3]+J[4]-J[5]+J[6]+J[7]+J[8]-J[9]-J[10]-J[11]+J[12]-J[13]-J[14]+J[15]-J[16]-J[17]-J[18]+
    J[19]+J[20]-J[21]+J[22]+J[23]-J[24]+J[25]+J[26]+J[27]-J[28]-J[29]-J[30]-J[31]+J[32]-J[33]-J[34]-J[35]+
    J[36]+J[37]+J[38]-J[39]+J[40]+J[41]+J[42]-J[43]-J[44]-J[45]+J[46]+J[47]+J[48]-J[49]-J[50]-J[51]-J[52]-J[53]+
    J[54]+J[55]+J[56]+J[57]-J[58]-J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]-H[1]+H[2]-H[3]+H[4]+H[5]-H[6]+
    H[7]+H[8]-H[9]+H[10]+H[11]-J[0]+J[1]-J[2]+J[3]+J[4]-J[5]+J[6]+J[7]-J[8]+J[9]+J[10]-J[11]+J[12]-J[13]-J[14]+
    J[15]-J[16]-J[17]+J[18]-J[19]-J[20]-J[21]+J[22]+J[23]-J[24]+J[25]+J[26]-J[27]+J[28]+J[29]-J[30]-J[31]+
    J[32]-J[33]-J[34]+J[35]-J[36]-J[37]+J[38]-J[39]+J[40]+J[41]-J[42]+J[43]+J[44]-J[45]+J[46]+J[47]-J[48]+
    J[49]+J[50]-J[51]-J[52]+J[53]-J[54]-J[55]+J[56]-J[57]+J[58]+J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +
    H[0]-H[1]+H[2]-H[3]+H[4]+H[5]-H[6]+H[7]+H[8]-H[9]+H[10]-H[11]-J[0]+J[1]-J[2]+J[3]+J[4]-J[5]+J[6]+J[7]-J[8]+
    J[9]-J[10]-J[11]+J[12]-J[13]-J[14]+J[15]-J[16]-J[17]+J[18]-J[19]+J[20]-J[21]+J[22]+J[23]-J[24]+J[25]+
    J[26]-J[27]+J[28]-J[29]-J[30]-J[31]+J[32]-J[33]-J[34]+J[35]-J[36]+J[37]+J[38]-J[39]+J[40]+J[41]-J[42]+
    J[43]-J[44]-J[45]+J[46]+J[47]-J[48]+J[49]-J[50]-J[51]-J[52]+J[53]-J[54]+J[55]+J[56]-J[57]+J[58]-J[59]-J[60]+
    J[61]-J[62]-J[63]+J[64]-J[65], +H[0]-H[1]+H[2]-H[3]+H[4]+H[5]-H[6]+H[7]+H[8]-H[9]-H[10]+H[11]-J[0]+J[1]-J[2]+
    J[3]+J[4]-J[5]+J[6]+J[7]-J[8]-J[9]+J[10]-J[11]+J[12]-J[13]-J[14]+J[15]-J[16]-J[17]+J[18]+J[19]-J[20]-J[21]+
    J[22]+J[23]-J[24]+J[25]+J[26]-J[27]-J[28]+J[29]-J[30]-J[31]+J[32]-J[33]-J[34]+J[35]+J[36]-J[37]+J[38]-J[39]+
    J[40]+J[41]-J[42]-J[43]+J[44]-J[45]+J[46]+J[47]-J[48]-J[49]+J[50]-J[51]-J[52]+J[53]+J[54]-J[55]+J[56]-J[57]-J[58]+
    J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]-H[1]+H[2]-H[3]+H[4]+H[5]-H[6]+H[7]+H[8]-H[9]-H[10]-H[11]-J[0]+
    J[1]-J[2]+J[3]+J[4]-J[5]+J[6]+J[7]-J[8]-J[9]-J[10]-J[11]+J[12]-J[13]-J[14]+J[15]-J[16]-J[17]+J[18]+J[19]+
    J[20]-J[21]+J[22]+J[23]-J[24]+J[25]+J[26]-J[27]-J[28]-J[29]-J[30]-J[31]+J[32]-J[33]-J[34]+J[35]+J[36]+
    J[37]+J[38]-J[39]+J[40]+J[41]-J[42]-J[43]-J[44]-J[45]+J[46]+J[47]-J[48]-J[49]-J[50]-J[51]-J[52]+J[53]+
    J[54]+J[55]+J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]-H[1]+H[2]-H[3]+H[4]+H[5]-H[6]+
    H[7]-H[8]+H[9]+H[10]+H[11]-J[0]+J[1]-J[2]+J[3]+J[4]-J[5]+J[6]-J[7]+J[8]+J[9]+J[10]-J[11]+J[12]-J[13]-J[14]+
    J[15]-J[16]+J[17]-J[18]-J[19]-J[20]-J[21]+J[22]+J[23]-J[24]+J[25]-J[26]+J[27]+J[28]+J[29]-J[30]-J[31]+
    J[32]-J[33]+J[34]-J[35]-J[36]-J[37]+J[38]-J[39]+J[40]-J[41]+J[42]+J[43]+J[44]-J[45]+J[46]-J[47]+J[48]+
    J[49]+J[50]-J[51]+J[52]-J[53]-J[54]-J[55]-J[56]+J[57]+J[58]+J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +
    H[0]-H[1]+H[2]-H[3]+H[4]+H[5]-H[6]+H[7]-H[8]+H[9]+H[10]-H[11]-J[0]+J[1]-J[2]+J[3]+J[4]-J[5]+J[6]-J[7]+
    J[8]+J[9]-J[10]-J[11]+J[12]-J[13]-J[14]+J[15]-J[16]+J[17]-J[18]-J[19]+J[20]-J[21]+J[22]+J[23]-J[24]+
    J[25]-J[26]+J[27]+J[28]-J[29]-J[30]-J[31]+J[32]-J[33]+J[34]-J[35]-J[36]+J[37]+J[38]-J[39]+J[40]-J[41]+
    J[42]+J[43]-J[44]-J[45]+J[46]-J[47]+J[48]+J[49]-J[50]-J[51]+J[52]-J[53]-J[54]+J[55]-J[56]+J[57]+J[58]-J[59]-J[60]-J[61]+
    J[62]+J[63]-J[64]-J[65], +H[0]-H[1]+H[2]-H[3]+H[4]+H[5]-H[6]+H[7]-H[8]+H[9]-H[10]+H[11]-J[0]+J[1]-J[2]+
    J[3]+J[4]-J[5]+J[6]-J[7]+J[8]-J[9]+J[10]-J[11]+J[12]-J[13]-J[14]+J[15]-J[16]+J[17]-J[18]+J[19]-J[20]-J[21]+
    J[22]+J[23]-J[24]+J[25]-J[26]+J[27]-J[28]+J[29]-J[30]-J[31]+J[32]-J[33]+J[34]-J[35]+J[36]-J[37]+J[38]-J[39]+
    J[40]-J[41]+J[42]-J[43]+J[44]-J[45]+J[46]-J[47]+J[48]-J[49]+J[50]-J[51]+J[52]-J[53]+J[54]-J[55]-J[56]+
    J[57]-J[58]+J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]-H[1]+H[2]-H[3]+H[4]+H[5]-H[6]+H[7]-H[8]+
    H[9]-H[10]-H[11]-J[0]+J[1]-J[2]+J[3]+J[4]-J[5]+J[6]-J[7]+J[8]-J[9]-J[10]-J[11]+J[12]-J[13]-J[14]+J[15]-J[16]+
    J[17]-J[18]+J[19]+J[20]-J[21]+J[22]+J[23]-J[24]+J[25]-J[26]+J[27]-J[28]-J[29]-J[30]-J[31]+J[32]-J[33]+
    J[34]-J[35]+J[36]+J[37]+J[38]-J[39]+J[40]-J[41]+J[42]-J[43]-J[44]-J[45]+J[46]-J[47]+J[48]-J[49]-J[50]-J[51]+
    J[52]-J[53]+J[54]+J[55]-J[56]+J[57]-J[58]-J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]-H[1]+H[2]-H[3]+
    H[4]+H[5]-H[6]+H[7]-H[8]-H[9]+H[10]+H[11]-J[0]+J[1]-J[2]+J[3]+J[4]-J[5]+J[6]-J[7]-J[8]+J[9]+J[10]-J[11]+
    J[12]-J[13]-J[14]+J[15]-J[16]+J[17]+J[18]-J[19]-J[20]-J[21]+J[22]+J[23]-J[24]+J[25]-J[26]-J[27]+J[28]+
    J[29]-J[30]-J[31]+J[32]-J[33]+J[34]+J[35]-J[36]-J[37]+J[38]-J[39]+J[40]-J[41]-J[42]+J[43]+J[44]-J[45]+
    J[46]-J[47]-J[48]+J[49]+J[50]-J[51]+J[52]+J[53]-J[54]-J[55]-J[56]-J[57]+J[58]+J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+
    J[65], +H[0]-H[1]+H[2]-H[3]+H[4]+H[5]-H[6]+H[7]-H[8]-H[9]+H[10]-H[11]-J[0]+J[1]-J[2]+J[3]+J[4]-J[5]+
    J[6]-J[7]-J[8]+J[9]-J[10]-J[11]+J[12]-J[13]-J[14]+J[15]-J[16]+J[17]+J[18]-J[19]+J[20]-J[21]+J[22]+J[23]-J[24]+
    J[25]-J[26]-J[27]+J[28]-J[29]-J[30]-J[31]+J[32]-J[33]+J[34]+J[35]-J[36]+J[37]+J[38]-J[39]+J[40]-J[41]-J[42]+
    J[43]-J[44]-J[45]+J[46]-J[47]-J[48]+J[49]-J[50]-J[51]+J[52]+J[53]-J[54]+J[55]-J[56]-J[57]+J[58]-J[59]+
    J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]-H[1]+H[2]-H[3]+H[4]+H[5]-H[6]+H[7]-H[8]-H[9]-H[10]+H[11]-J[0]+
    J[1]-J[2]+J[3]+J[4]-J[5]+J[6]-J[7]-J[8]-J[9]+J[10]-J[11]+J[12]-J[13]-J[14]+J[15]-J[16]+J[17]+J[18]+J[19]-J[20]-J[21]+
    J[22]+J[23]-J[24]+J[25]-J[26]-J[27]-J[28]+J[29]-J[30]-J[31]+J[32]-J[33]+J[34]+J[35]+J[36]-J[37]+J[38]-J[39]+
    J[40]-J[41]-J[42]-J[43]+J[44]-J[45]+J[46]-J[47]-J[48]-J[49]+J[50]-J[51]+J[52]+J[53]+J[54]-J[55]-J[56]-J[57]-J[58]+
    J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]-H[1]+H[2]-H[3]+H[4]+H[5]-H[6]+H[7]-H[8]-H[9]-H[10]-H[11]-J[0]+
    J[1]-J[2]+J[3]+J[4]-J[5]+J[6]-J[7]-J[8]-J[9]-J[10]-J[11]+J[12]-J[13]-J[14]+J[15]-J[16]+J[17]+J[18]+J[19]+
    J[20]-J[21]+J[22]+J[23]-J[24]+J[25]-J[26]-J[27]-J[28]-J[29]-J[30]-J[31]+J[32]-J[33]+J[34]+J[35]+J[36]+
    J[37]+J[38]-J[39]+J[40]-J[41]-J[42]-J[43]-J[44]-J[45]+J[46]-J[47]-J[48]-J[49]-J[50]-J[51]+J[52]+J[53]+
    J[54]+J[55]-J[56]-J[57]-J[58]-J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]-H[1]+H[2]-H[3]+H[4]+H[5]-H[6]-H[7]+
    H[8]+H[9]+H[10]+H[11]-J[0]+J[1]-J[2]+J[3]+J[4]-J[5]-J[6]+J[7]+J[8]+J[9]+J[10]-J[11]+J[12]-J[13]-J[14]+
    J[15]+J[16]-J[17]-J[18]-J[19]-J[20]-J[21]+J[22]+J[23]-J[24]-J[25]+J[26]+J[27]+J[28]+J[29]-J[30]-J[31]+
    J[32]+J[33]-J[34]-J[35]-J[36]-J[37]+J[38]-J[39]-J[40]+J[41]+J[42]+J[43]+J[44]-J[45]-J[46]+J[47]+J[48]+
    J[49]+J[50]+J[51]-J[52]-J[53]-J[54]-J[55]-J[56]-J[57]-J[58]-J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +
    H[0]-H[1]+H[2]-H[3]+H[4]+H[5]-H[6]-H[7]+H[8]+H[9]+H[10]-H[11]-J[0]+J[1]-J[2]+J[3]+J[4]-J[5]-J[6]+J[7]+
    J[8]+J[9]-J[10]-J[11]+J[12]-J[13]-J[14]+J[15]+J[16]-J[17]-J[18]-J[19]+J[20]-J[21]+J[22]+J[23]-J[24]-J[25]+
    J[26]+J[27]+J[28]-J[29]-J[30]-J[31]+J[32]+J[33]-J[34]-J[35]-J[36]+J[37]+J[38]-J[39]-J[40]+J[41]+J[42]+
    J[43]-J[44]-J[45]-J[46]+J[47]+J[48]+J[49]-J[50]+J[51]-J[52]-J[53]-J[54]+J[55]-J[56]-J[57]-J[58]+J[59]+
    J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]-H[1]+H[2]-H[3]+H[4]+H[5]-H[6]-H[7]+H[8]+H[9]-H[10]+H[11]-J[0]+
    J[1]-J[2]+J[3]+J[4]-J[5]-J[6]+J[7]+J[8]-J[9]+J[10]-J[11]+J[12]-J[13]-J[14]+J[15]+J[16]-J[17]-J[18]+J[19]-J[20]-J[21]+
    J[22]+J[23]-J[24]-J[25]+J[26]+J[27]-J[28]+J[29]-J[30]-J[31]+J[32]+J[33]-J[34]-J[35]+J[36]-J[37]+J[38]-J[39]-J[40]+
    J[41]+J[42]-J[43]+J[44]-J[45]-J[46]+J[47]+J[48]-J[49]+J[50]+J[51]-J[52]-J[53]+J[54]-J[55]-J[56]-J[57]+
    J[58]-J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]-H[1]+H[2]-H[3]+H[4]+H[5]-H[6]-H[7]+H[8]+H[9]-H[10]-H[11]-J[0]+
    J[1]-J[2]+J[3]+J[4]-J[5]-J[6]+J[7]+J[8]-J[9]-J[10]-J[11]+J[12]-J[13]-J[14]+J[15]+J[16]-J[17]-J[18]+J[19]+
    J[20]-J[21]+J[22]+J[23]-J[24]-J[25]+J[26]+J[27]-J[28]-J[29]-J[30]-J[31]+J[32]+J[33]-J[34]-J[35]+J[36]+
    J[37]+J[38]-J[39]-J[40]+J[41]+J[42]-J[43]-J[44]-J[45]-J[46]+J[47]+J[48]-J[49]-J[50]+J[51]-J[52]-J[53]+
    J[54]+J[55]-J[56]-J[57]+J[58]+J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]-H[1]+H[2]-H[3]+H[4]+H[5]-H[6]-H[7]+
    H[8]-H[9]+H[10]+H[11]-J[0]+J[1]-J[2]+J[3]+J[4]-J[5]-J[6]+J[7]-J[8]+J[9]+J[10]-J[11]+J[12]-J[13]-J[14]+
    J[15]+J[16]-J[17]+J[18]-J[19]-J[20]-J[21]+J[22]+J[23]-J[24]-J[25]+J[26]-J[27]+J[28]+J[29]-J[30]-J[31]+
    J[32]+J[33]-J[34]+J[35]-J[36]-J[37]+J[38]-J[39]-J[40]+J[41]-J[42]+J[43]+J[44]-J[45]-J[46]+J[47]-J[48]+
    J[49]+J[50]+J[51]-J[52]+J[53]-J[54]-J[55]-J[56]+J[57]-J[58]-J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +
    H[0]-H[1]+H[2]-H[3]+H[4]+H[5]-H[6]-H[7]+H[8]-H[9]+H[10]-H[11]-J[0]+J[1]-J[2]+J[3]+J[4]-J[5]-J[6]+J[7]-J[8]+
    J[9]-J[10]-J[11]+J[12]-J[13]-J[14]+J[15]+J[16]-J[17]+J[18]-J[19]+J[20]-J[21]+J[22]+J[23]-J[24]-J[25]+
    J[26]-J[27]+J[28]-J[29]-J[30]-J[31]+J[32]+J[33]-J[34]+J[35]-J[36]+J[37]+J[38]-J[39]-J[40]+J[41]-J[42]+
    J[43]-J[44]-J[45]-J[46]+J[47]-J[48]+J[49]-J[50]+J[51]-J[52]+J[53]-J[54]+J[55]-J[56]+J[57]-J[58]+J[59]-J[60]+
    J[61]-J[62]-J[63]+J[64]-J[65], +H[0]-H[1]+H[2]-H[3]+H[4]+H[5]-H[6]-H[7]+H[8]-H[9]-H[10]+H[11]-J[0]+J[1]-J[2]+
    J[3]+J[4]-J[5]-J[6]+J[7]-J[8]-J[9]+J[10]-J[11]+J[12]-J[13]-J[14]+J[15]+J[16]-J[17]+J[18]+J[19]-J[20]-J[21]+
    J[22]+J[23]-J[24]-J[25]+J[26]-J[27]-J[28]+J[29]-J[30]-J[31]+J[32]+J[33]-J[34]+J[35]+J[36]-J[37]+J[38]-J[39]-J[40]+
    J[41]-J[42]-J[43]+J[44]-J[45]-J[46]+J[47]-J[48]-J[49]+J[50]+J[51]-J[52]+J[53]+J[54]-J[55]-J[56]+J[57]+
    J[58]-J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]-H[1]+H[2]-H[3]+H[4]+H[5]-H[6]-H[7]+H[8]-H[9]-H[10]-H[11]-J[0]+
    J[1]-J[2]+J[3]+J[4]-J[5]-J[6]+J[7]-J[8]-J[9]-J[10]-J[11]+J[12]-J[13]-J[14]+J[15]+J[16]-J[17]+J[18]+J[19]+
    J[20]-J[21]+J[22]+J[23]-J[24]-J[25]+J[26]-J[27]-J[28]-J[29]-J[30]-J[31]+J[32]+J[33]-J[34]+J[35]+J[36]+
    J[37]+J[38]-J[39]-J[40]+J[41]-J[42]-J[43]-J[44]-J[45]-J[46]+J[47]-J[48]-J[49]-J[50]+J[51]-J[52]+J[53]+
    J[54]+J[55]-J[56]+J[57]+J[58]+J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]-H[1]+H[2]-H[3]+H[4]+H[5]-H[6]-H[7]-H[8]+
    H[9]+H[10]+H[11]-J[0]+J[1]-J[2]+J[3]+J[4]-J[5]-J[6]-J[7]+J[8]+J[9]+J[10]-J[11]+J[12]-J[13]-J[14]+J[15]+
    J[16]+J[17]-J[18]-J[19]-J[20]-J[21]+J[22]+J[23]-J[24]-J[25]-J[26]+J[27]+J[28]+J[29]-J[30]-J[31]+J[32]+
    J[33]+J[34]-J[35]-J[36]-J[37]+J[38]-J[39]-J[40]-J[41]+J[42]+J[43]+J[44]-J[45]-J[46]-J[47]+J[48]+J[49]+
    J[50]+J[51]+J[52]-J[53]-J[54]-J[55]+J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]-H[1]+
    H[2]-H[3]+H[4]+H[5]-H[6]-H[7]-H[8]+H[9]+H[10]-H[11]-J[0]+J[1]-J[2]+J[3]+J[4]-J[5]-J[6]-J[7]+J[8]+J[9]-J[10]-J[11]+
    J[12]-J[13]-J[14]+J[15]+J[16]+J[17]-J[18]-J[19]+J[20]-J[21]+J[22]+J[23]-J[24]-J[25]-J[26]+J[27]+J[28]-J[29]-J[30]-J[31]+
    J[32]+J[33]+J[34]-J[35]-J[36]+J[37]+J[38]-J[39]-J[40]-J[41]+J[42]+J[43]-J[44]-J[45]-J[46]-J[47]+J[48]+
    J[49]-J[50]+J[51]+J[52]-J[53]-J[54]+J[55]+J[56]-J[57]-J[58]+J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +
    H[0]-H[1]+H[2]-H[3]+H[4]+H[5]-H[6]-H[7]-H[8]+H[9]-H[10]+H[11]-J[0]+J[1]-J[2]+J[3]+J[4]-J[5]-J[6]-J[7]+
    J[8]-J[9]+J[10]-J[11]+J[12]-J[13]-J[14]+J[15]+J[16]+J[17]-J[18]+J[19]-J[20]-J[21]+J[22]+J[23]-J[24]-J[25]-J[26]+
    J[27]-J[28]+J[29]-J[30]-J[31]+J[32]+J[33]+J[34]-J[35]+J[36]-J[37]+J[38]-J[39]-J[40]-J[41]+J[42]-J[43]+
    J[44]-J[45]-J[46]-J[47]+J[48]-J[49]+J[50]+J[51]+J[52]-J[53]+J[54]-J[55]+J[56]-J[57]+J[58]-J[59]-J[60]+
    J[61]-J[62]-J[63]+J[64]-J[65], +H[0]-H[1]+H[2]-H[3]+H[4]+H[5]-H[6]-H[7]-H[8]+H[9]-H[10]-H[11]-J[0]+J[1]-J[2]+
    J[3]+J[4]-J[5]-J[6]-J[7]+J[8]-J[9]-J[10]-J[11]+J[12]-J[13]-J[14]+J[15]+J[16]+J[17]-J[18]+J[19]+J[20]-J[21]+
    J[22]+J[23]-J[24]-J[25]-J[26]+J[27]-J[28]-J[29]-J[30]-J[31]+J[32]+J[33]+J[34]-J[35]+J[36]+J[37]+J[38]-J[39]-J[40]-J[41]+
    J[42]-J[43]-J[44]-J[45]-J[46]-J[47]+J[48]-J[49]-J[50]+J[51]+J[52]-J[53]+J[54]+J[55]+J[56]-J[57]+J[58]+
    J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]-H[1]+H[2]-H[3]+H[4]+H[5]-H[6]-H[7]-H[8]-H[9]+H[10]+
    H[11]-J[0]+J[1]-J[2]+J[3]+J[4]-J[5]-J[6]-J[7]-J[8]+J[9]+J[10]-J[11]+J[12]-J[13]-J[14]+J[15]+J[16]+J[17]+
    J[18]-J[19]-J[20]-J[21]+J[22]+J[23]-J[24]-J[25]-J[26]-J[27]+J[28]+J[29]-J[30]-J[31]+J[32]+J[33]+J[34]+
    J[35]-J[36]-J[37]+J[38]-J[39]-J[40]-J[41]-J[42]+J[43]+J[44]-J[45]-J[46]-J[47]-J[48]+J[49]+J[50]+J[51]+
    J[52]+J[53]-J[54]-J[55]+J[56]+J[57]-J[58]-J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]-H[1]+H[2]-H[3]+
    H[4]+H[5]-H[6]-H[7]-H[8]-H[9]+H[10]-H[11]-J[0]+J[1]-J[2]+J[3]+J[4]-J[5]-J[6]-J[7]-J[8]+J[9]-J[10]-J[11]+
    J[12]-J[13]-J[14]+J[15]+J[16]+J[17]+J[18]-J[19]+J[20]-J[21]+J[22]+J[23]-J[24]-J[25]-J[26]-J[27]+J[28]-J[29]-J[30]-J[31]+
    J[32]+J[33]+J[34]+J[35]-J[36]+J[37]+J[38]-J[39]-J[40]-J[41]-J[42]+J[43]-J[44]-J[45]-J[46]-J[47]-J[48]+
    J[49]-J[50]+J[51]+J[52]+J[53]-J[54]+J[55]+J[56]+J[57]-J[58]+J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +
    H[0]-H[1]+H[2]-H[3]+H[4]+H[5]-H[6]-H[7]-H[8]-H[9]-H[10]+H[11]-J[0]+J[1]-J[2]+J[3]+J[4]-J[5]-J[6]-J[7]-J[8]-J[9]+
    J[10]-J[11]+J[12]-J[13]-J[14]+J[15]+J[16]+J[17]+J[18]+J[19]-J[20]-J[21]+J[22]+J[23]-J[24]-J[25]-J[26]-J[27]-J[28]+
    J[29]-J[30]-J[31]+J[32]+J[33]+J[34]+J[35]+J[36]-J[37]+J[38]-J[39]-J[40]-J[41]-J[42]-J[43]+J[44]-J[45]-J[46]-J[47]-J[48]-J[49]+
    J[50]+J[51]+J[52]+J[53]+J[54]-J[55]+J[56]+J[57]+J[58]-J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]-H[1]+
    H[2]-H[3]+H[4]+H[5]-H[6]-H[7]-H[8]-H[9]-H[10]-H[11]-J[0]+J[1]-J[2]+J[3]+J[4]-J[5]-J[6]-J[7]-J[8]-J[9]-J[10]-J[11]+
    J[12]-J[13]-J[14]+J[15]+J[16]+J[17]+J[18]+J[19]+J[20]-J[21]+J[22]+J[23]-J[24]-J[25]-J[26]-J[27]-J[28]-J[29]-J[30]-J[31]+
    J[32]+J[33]+J[34]+J[35]+J[36]+J[37]+J[38]-J[39]-J[40]-J[41]-J[42]-J[43]-J[44]-J[45]-J[46]-J[47]-J[48]-J[49]-J[50]+
    J[51]+J[52]+J[53]+J[54]+J[55]+J[56]+J[57]+J[58]+J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]-H[1]+
    H[2]-H[3]+H[4]-H[5]+H[6]+H[7]+H[8]+H[9]+H[10]+H[11]-J[0]+J[1]-J[2]+J[3]-J[4]+J[5]+J[6]+J[7]+J[8]+J[9]+
    J[10]-J[11]+J[12]-J[13]+J[14]-J[15]-J[16]-J[17]-J[18]-J[19]-J[20]-J[21]+J[22]-J[23]+J[24]+J[25]+J[26]+
    J[27]+J[28]+J[29]-J[30]+J[31]-J[32]-J[33]-J[34]-J[35]-J[36]-J[37]-J[38]+J[39]+J[40]+J[41]+J[42]+J[43]+
    J[44]-J[45]-J[46]-J[47]-J[48]-J[49]-J[50]+J[51]+J[52]+J[53]+J[54]+J[55]+J[56]+J[57]+J[58]+J[59]+J[60]+
    J[61]+J[62]+J[63]+J[64]+J[65], +H[0]-H[1]+H[2]-H[3]+H[4]-H[5]+H[6]+H[7]+H[8]+H[9]+H[10]-H[11]-J[0]+J[1]-J[2]+
    J[3]-J[4]+J[5]+J[6]+J[7]+J[8]+J[9]-J[10]-J[11]+J[12]-J[13]+J[14]-J[15]-J[16]-J[17]-J[18]-J[19]+J[20]-J[21]+
    J[22]-J[23]+J[24]+J[25]+J[26]+J[27]+J[28]-J[29]-J[30]+J[31]-J[32]-J[33]-J[34]-J[35]-J[36]+J[37]-J[38]+
    J[39]+J[40]+J[41]+J[42]+J[43]-J[44]-J[45]-J[46]-J[47]-J[48]-J[49]+J[50]+J[51]+J[52]+J[53]+J[54]-J[55]+
    J[56]+J[57]+J[58]-J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]-H[1]+H[2]-H[3]+H[4]-H[5]+H[6]+H[7]+
    H[8]+H[9]-H[10]+H[11]-J[0]+J[1]-J[2]+J[3]-J[4]+J[5]+J[6]+J[7]+J[8]-J[9]+J[10]-J[11]+J[12]-J[13]+J[14]-J[15]-J[16]-J[17]-J[18]+
    J[19]-J[20]-J[21]+J[22]-J[23]+J[24]+J[25]+J[26]+J[27]-J[28]+J[29]-J[30]+J[31]-J[32]-J[33]-J[34]-J[35]+
    J[36]-J[37]-J[38]+J[39]+J[40]+J[41]+J[42]-J[43]+J[44]-J[45]-J[46]-J[47]-J[48]+J[49]-J[50]+J[51]+J[52]+
    J[53]-J[54]+J[55]+J[56]+J[57]-J[58]+J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]-H[1]+H[2]-H[3]+
    H[4]-H[5]+H[6]+H[7]+H[8]+H[9]-H[10]-H[11]-J[0]+J[1]-J[2]+J[3]-J[4]+J[5]+J[6]+J[7]+J[8]-J[9]-J[10]-J[11]+
    J[12]-J[13]+J[14]-J[15]-J[16]-J[17]-J[18]+J[19]+J[20]-J[21]+J[22]-J[23]+J[24]+J[25]+J[26]+J[27]-J[28]-J[29]-J[30]+
    J[31]-J[32]-J[33]-J[34]-J[35]+J[36]+J[37]-J[38]+J[39]+J[40]+J[41]+J[42]-J[43]-J[44]-J[45]-J[46]-J[47]-J[48]+
    J[49]+J[50]+J[51]+J[52]+J[53]-J[54]-J[55]+J[56]+J[57]-J[58]-J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +
    H[0]-H[1]+H[2]-H[3]+H[4]-H[5]+H[6]+H[7]+H[8]-H[9]+H[10]+H[11]-J[0]+J[1]-J[2]+J[3]-J[4]+J[5]+J[6]+J[7]-J[8]+
    J[9]+J[10]-J[11]+J[12]-J[13]+J[14]-J[15]-J[16]-J[17]+J[18]-J[19]-J[20]-J[21]+J[22]-J[23]+J[24]+J[25]+
    J[26]-J[27]+J[28]+J[29]-J[30]+J[31]-J[32]-J[33]-J[34]+J[35]-J[36]-J[37]-J[38]+J[39]+J[40]+J[41]-J[42]+
    J[43]+J[44]-J[45]-J[46]-J[47]+J[48]-J[49]-J[50]+J[51]+J[52]-J[53]+J[54]+J[55]+J[56]-J[57]+J[58]+J[59]-J[60]+
    J[61]+J[62]-J[63]-J[64]+J[65], +H[0]-H[1]+H[2]-H[3]+H[4]-H[5]+H[6]+H[7]+H[8]-H[9]+H[10]-H[11]-J[0]+J[1]-J[2]+
    J[3]-J[4]+J[5]+J[6]+J[7]-J[8]+J[9]-J[10]-J[11]+J[12]-J[13]+J[14]-J[15]-J[16]-J[17]+J[18]-J[19]+J[20]-J[21]+
    J[22]-J[23]+J[24]+J[25]+J[26]-J[27]+J[28]-J[29]-J[30]+J[31]-J[32]-J[33]-J[34]+J[35]-J[36]+J[37]-J[38]+
    J[39]+J[40]+J[41]-J[42]+J[43]-J[44]-J[45]-J[46]-J[47]+J[48]-J[49]+J[50]+J[51]+J[52]-J[53]+J[54]-J[55]+
    J[56]-J[57]+J[58]-J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]-H[1]+H[2]-H[3]+H[4]-H[5]+H[6]+H[7]+
    H[8]-H[9]-H[10]+H[11]-J[0]+J[1]-J[2]+J[3]-J[4]+J[5]+J[6]+J[7]-J[8]-J[9]+J[10]-J[11]+J[12]-J[13]+J[14]-J[15]-J[16]-J[17]+
    J[18]+J[19]-J[20]-J[21]+J[22]-J[23]+J[24]+J[25]+J[26]-J[27]-J[28]+J[29]-J[30]+J[31]-J[32]-J[33]-J[34]+
    J[35]+J[36]-J[37]-J[38]+J[39]+J[40]+J[41]-J[42]-J[43]+J[44]-J[45]-J[46]-J[47]+J[48]+J[49]-J[50]+J[51]+
    J[52]-J[53]-J[54]+J[55]+J[56]-J[57]-J[58]+J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]-H[1]+H[2]-H[3]+
    H[4]-H[5]+H[6]+H[7]+H[8]-H[9]-H[10]-H[11]-J[0]+J[1]-J[2]+J[3]-J[4]+J[5]+J[6]+J[7]-J[8]-J[9]-J[10]-J[11]+
    J[12]-J[13]+J[14]-J[15]-J[16]-J[17]+J[18]+J[19]+J[20]-J[21]+J[22]-J[23]+J[24]+J[25]+J[26]-J[27]-J[28]-J[29]-J[30]+
    J[31]-J[32]-J[33]-J[34]+J[35]+J[36]+J[37]-J[38]+J[39]+J[40]+J[41]-J[42]-J[43]-J[44]-J[45]-J[46]-J[47]+
    J[48]+J[49]+J[50]+J[51]+J[52]-J[53]-J[54]-J[55]+J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+
    J[65], +H[0]-H[1]+H[2]-H[3]+H[4]-H[5]+H[6]+H[7]-H[8]+H[9]+H[10]+H[11]-J[0]+J[1]-J[2]+J[3]-J[4]+J[5]+
    J[6]-J[7]+J[8]+J[9]+J[10]-J[11]+J[12]-J[13]+J[14]-J[15]-J[16]+J[17]-J[18]-J[19]-J[20]-J[21]+J[22]-J[23]+
    J[24]+J[25]-J[26]+J[27]+J[28]+J[29]-J[30]+J[31]-J[32]-J[33]+J[34]-J[35]-J[36]-J[37]-J[38]+J[39]+J[40]-J[41]+
    J[42]+J[43]+J[44]-J[45]-J[46]+J[47]-J[48]-J[49]-J[50]+J[51]-J[52]+J[53]+J[54]+J[55]-J[56]+J[57]+J[58]+
    J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]-H[1]+H[2]-H[3]+H[4]-H[5]+H[6]+H[7]-H[8]+H[9]+H[10]-H[11]-J[0]+
    J[1]-J[2]+J[3]-J[4]+J[5]+J[6]-J[7]+J[8]+J[9]-J[10]-J[11]+J[12]-J[13]+J[14]-J[15]-J[16]+J[17]-J[18]-J[19]+
    J[20]-J[21]+J[22]-J[23]+J[24]+J[25]-J[26]+J[27]+J[28]-J[29]-J[30]+J[31]-J[32]-J[33]+J[34]-J[35]-J[36]+
    J[37]-J[38]+J[39]+J[40]-J[41]+J[42]+J[43]-J[44]-J[45]-J[46]+J[47]-J[48]-J[49]+J[50]+J[51]-J[52]+J[53]+
    J[54]-J[55]-J[56]+J[57]+J[58]-J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]-H[1]+H[2]-H[3]+H[4]-H[5]+
    H[6]+H[7]-H[8]+H[9]-H[10]+H[11]-J[0]+J[1]-J[2]+J[3]-J[4]+J[5]+J[6]-J[7]+J[8]-J[9]+J[10]-J[11]+J[12]-J[13]+
    J[14]-J[15]-J[16]+J[17]-J[18]+J[19]-J[20]-J[21]+J[22]-J[23]+J[24]+J[25]-J[26]+J[27]-J[28]+J[29]-J[30]+
    J[31]-J[32]-J[33]+J[34]-J[35]+J[36]-J[37]-J[38]+J[39]+J[40]-J[41]+J[42]-J[43]+J[44]-J[45]-J[46]+J[47]-J[48]+
    J[49]-J[50]+J[51]-J[52]+J[53]-J[54]+J[55]-J[56]+J[57]-J[58]+J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +
    H[0]-H[1]+H[2]-H[3]+H[4]-H[5]+H[6]+H[7]-H[8]+H[9]-H[10]-H[11]-J[0]+J[1]-J[2]+J[3]-J[4]+J[5]+J[6]-J[7]+
    J[8]-J[9]-J[10]-J[11]+J[12]-J[13]+J[14]-J[15]-J[16]+J[17]-J[18]+J[19]+J[20]-J[21]+J[22]-J[23]+J[24]+
    J[25]-J[26]+J[27]-J[28]-J[29]-J[30]+J[31]-J[32]-J[33]+J[34]-J[35]+J[36]+J[37]-J[38]+J[39]+J[40]-J[41]+
    J[42]-J[43]-J[44]-J[45]-J[46]+J[47]-J[48]+J[49]+J[50]+J[51]-J[52]+J[53]-J[54]-J[55]-J[56]+J[57]-J[58]-J[59]-J[60]+
    J[61]+J[62]-J[63]-J[64]+J[65], +H[0]-H[1]+H[2]-H[3]+H[4]-H[5]+H[6]+H[7]-H[8]-H[9]+H[10]+H[11]-J[0]+J[1]-J[2]+
    J[3]-J[4]+J[5]+J[6]-J[7]-J[8]+J[9]+J[10]-J[11]+J[12]-J[13]+J[14]-J[15]-J[16]+J[17]+J[18]-J[19]-J[20]-J[21]+
    J[22]-J[23]+J[24]+J[25]-J[26]-J[27]+J[28]+J[29]-J[30]+J[31]-J[32]-J[33]+J[34]+J[35]-J[36]-J[37]-J[38]+
    J[39]+J[40]-J[41]-J[42]+J[43]+J[44]-J[45]-J[46]+J[47]+J[48]-J[49]-J[50]+J[51]-J[52]-J[53]+J[54]+J[55]-J[56]-J[57]+
    J[58]+J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]-H[1]+H[2]-H[3]+H[4]-H[5]+H[6]+H[7]-H[8]-H[9]+
    H[10]-H[11]-J[0]+J[1]-J[2]+J[3]-J[4]+J[5]+J[6]-J[7]-J[8]+J[9]-J[10]-J[11]+J[12]-J[13]+J[14]-J[15]-J[16]+
    J[17]+J[18]-J[19]+J[20]-J[21]+J[22]-J[23]+J[24]+J[25]-J[26]-J[27]+J[28]-J[29]-J[30]+J[31]-J[32]-J[33]+
    J[34]+J[35]-J[36]+J[37]-J[38]+J[39]+J[40]-J[41]-J[42]+J[43]-J[44]-J[45]-J[46]+J[47]+J[48]-J[49]+J[50]+
    J[51]-J[52]-J[53]+J[54]-J[55]-J[56]-J[57]+J[58]-J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]-H[1]+
    H[2]-H[3]+H[4]-H[5]+H[6]+H[7]-H[8]-H[9]-H[10]+H[11]-J[0]+J[1]-J[2]+J[3]-J[4]+J[5]+J[6]-J[7]-J[8]-J[9]+
    J[10]-J[11]+J[12]-J[13]+J[14]-J[15]-J[16]+J[17]+J[18]+J[19]-J[20]-J[21]+J[22]-J[23]+J[24]+J[25]-J[26]-J[27]-J[28]+
    J[29]-J[30]+J[31]-J[32]-J[33]+J[34]+J[35]+J[36]-J[37]-J[38]+J[39]+J[40]-J[41]-J[42]-J[43]+J[44]-J[45]-J[46]+
    J[47]+J[48]+J[49]-J[50]+J[51]-J[52]-J[53]-J[54]+J[55]-J[56]-J[57]-J[58]+J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +
    H[0]-H[1]+H[2]-H[3]+H[4]-H[5]+H[6]+H[7]-H[8]-H[9]-H[10]-H[11]-J[0]+J[1]-J[2]+J[3]-J[4]+J[5]+J[6]-J[7]-J[8]-J[9]-J[10]-J[11]+
    J[12]-J[13]+J[14]-J[15]-J[16]+J[17]+J[18]+J[19]+J[20]-J[21]+J[22]-J[23]+J[24]+J[25]-J[26]-J[27]-J[28]-J[29]-J[30]+
    J[31]-J[32]-J[33]+J[34]+J[35]+J[36]+J[37]-J[38]+J[39]+J[40]-J[41]-J[42]-J[43]-J[44]-J[45]-J[46]+J[47]+
    J[48]+J[49]+J[50]+J[51]-J[52]-J[53]-J[54]-J[55]-J[56]-J[57]-J[58]-J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+
    J[65], +H[0]-H[1]+H[2]-H[3]+H[4]-H[5]+H[6]-H[7]+H[8]+H[9]+H[10]+H[11]-J[0]+J[1]-J[2]+J[3]-J[4]+J[5]-J[6]+
    J[7]+J[8]+J[9]+J[10]-J[11]+J[12]-J[13]+J[14]-J[15]+J[16]-J[17]-J[18]-J[19]-J[20]-J[21]+J[22]-J[23]+J[24]-J[25]+
    J[26]+J[27]+J[28]+J[29]-J[30]+J[31]-J[32]+J[33]-J[34]-J[35]-J[36]-J[37]-J[38]+J[39]-J[40]+J[41]+J[42]+
    J[43]+J[44]-J[45]+J[46]-J[47]-J[48]-J[49]-J[50]-J[51]+J[52]+J[53]+J[54]+J[55]-J[56]-J[57]-J[58]-J[59]+
    J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]-H[1]+H[2]-H[3]+H[4]-H[5]+H[6]-H[7]+H[8]+H[9]+H[10]-H[11]-J[0]+
    J[1]-J[2]+J[3]-J[4]+J[5]-J[6]+J[7]+J[8]+J[9]-J[10]-J[11]+J[12]-J[13]+J[14]-J[15]+J[16]-J[17]-J[18]-J[19]+
    J[20]-J[21]+J[22]-J[23]+J[24]-J[25]+J[26]+J[27]+J[28]-J[29]-J[30]+J[31]-J[32]+J[33]-J[34]-J[35]-J[36]+
    J[37]-J[38]+J[39]-J[40]+J[41]+J[42]+J[43]-J[44]-J[45]+J[46]-J[47]-J[48]-J[49]+J[50]-J[51]+J[52]+J[53]+
    J[54]-J[55]-J[56]-J[57]-J[58]+J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]-H[1]+H[2]-H[3]+H[4]-H[5]+
    H[6]-H[7]+H[8]+H[9]-H[10]+H[11]-J[0]+J[1]-J[2]+J[3]-J[4]+J[5]-J[6]+J[7]+J[8]-J[9]+J[10]-J[11]+J[12]-J[13]+
    J[14]-J[15]+J[16]-J[17]-J[18]+J[19]-J[20]-J[21]+J[22]-J[23]+J[24]-J[25]+J[26]+J[27]-J[28]+J[29]-J[30]+
    J[31]-J[32]+J[33]-J[34]-J[35]+J[36]-J[37]-J[38]+J[39]-J[40]+J[41]+J[42]-J[43]+J[44]-J[45]+J[46]-J[47]-J[48]+
    J[49]-J[50]-J[51]+J[52]+J[53]-J[54]+J[55]-J[56]-J[57]+J[58]-J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +
    H[0]-H[1]+H[2]-H[3]+H[4]-H[5]+H[6]-H[7]+H[8]+H[9]-H[10]-H[11]-J[0]+J[1]-J[2]+J[3]-J[4]+J[5]-J[6]+J[7]+
    J[8]-J[9]-J[10]-J[11]+J[12]-J[13]+J[14]-J[15]+J[16]-J[17]-J[18]+J[19]+J[20]-J[21]+J[22]-J[23]+J[24]-J[25]+
    J[26]+J[27]-J[28]-J[29]-J[30]+J[31]-J[32]+J[33]-J[34]-J[35]+J[36]+J[37]-J[38]+J[39]-J[40]+J[41]+J[42]-J[43]-J[44]-J[45]+
    J[46]-J[47]-J[48]+J[49]+J[50]-J[51]+J[52]+J[53]-J[54]-J[55]-J[56]-J[57]+J[58]+J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+
    J[65], +H[0]-H[1]+H[2]-H[3]+H[4]-H[5]+H[6]-H[7]+H[8]-H[9]+H[10]+H[11]-J[0]+J[1]-J[2]+J[3]-J[4]+J[5]-J[6]+
    J[7]-J[8]+J[9]+J[10]-J[11]+J[12]-J[13]+J[14]-J[15]+J[16]-J[17]+J[18]-J[19]-J[20]-J[21]+J[22]-J[23]+J[24]-J[25]+
    J[26]-J[27]+J[28]+J[29]-J[30]+J[31]-J[32]+J[33]-J[34]+J[35]-J[36]-J[37]-J[38]+J[39]-J[40]+J[41]-J[42]+
    J[43]+J[44]-J[45]+J[46]-J[47]+J[48]-J[49]-J[50]-J[51]+J[52]-J[53]+J[54]+J[55]-J[56]+J[57]-J[58]-J[59]-J[60]+
    J[61]+J[62]-J[63]-J[64]+J[65], +H[0]-H[1]+H[2]-H[3]+H[4]-H[5]+H[6]-H[7]+H[8]-H[9]+H[10]-H[11]-J[0]+J[1]-J[2]+
    J[3]-J[4]+J[5]-J[6]+J[7]-J[8]+J[9]-J[10]-J[11]+J[12]-J[13]+J[14]-J[15]+J[16]-J[17]+J[18]-J[19]+J[20]-J[21]+
    J[22]-J[23]+J[24]-J[25]+J[26]-J[27]+J[28]-J[29]-J[30]+J[31]-J[32]+J[33]-J[34]+J[35]-J[36]+J[37]-J[38]+
    J[39]-J[40]+J[41]-J[42]+J[43]-J[44]-J[45]+J[46]-J[47]+J[48]-J[49]+J[50]-J[51]+J[52]-J[53]+J[54]-J[55]-J[56]+
    J[57]-J[58]+J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]-H[1]+H[2]-H[3]+H[4]-H[5]+H[6]-H[7]+H[8]-H[9]-H[10]+
    H[11]-J[0]+J[1]-J[2]+J[3]-J[4]+J[5]-J[6]+J[7]-J[8]-J[9]+J[10]-J[11]+J[12]-J[13]+J[14]-J[15]+J[16]-J[17]+
    J[18]+J[19]-J[20]-J[21]+J[22]-J[23]+J[24]-J[25]+J[26]-J[27]-J[28]+J[29]-J[30]+J[31]-J[32]+J[33]-J[34]+
    J[35]+J[36]-J[37]-J[38]+J[39]-J[40]+J[41]-J[42]-J[43]+J[44]-J[45]+J[46]-J[47]+J[48]+J[49]-J[50]-J[51]+
    J[52]-J[53]-J[54]+J[55]-J[56]+J[57]+J[58]-J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]-H[1]+H[2]-H[3]+
    H[4]-H[5]+H[6]-H[7]+H[8]-H[9]-H[10]-H[11]-J[0]+J[1]-J[2]+J[3]-J[4]+J[5]-J[6]+J[7]-J[8]-J[9]-J[10]-J[11]+
    J[12]-J[13]+J[14]-J[15]+J[16]-J[17]+J[18]+J[19]+J[20]-J[21]+J[22]-J[23]+J[24]-J[25]+J[26]-J[27]-J[28]-J[29]-J[30]+
    J[31]-J[32]+J[33]-J[34]+J[35]+J[36]+J[37]-J[38]+J[39]-J[40]+J[41]-J[42]-J[43]-J[44]-J[45]+J[46]-J[47]+
    J[48]+J[49]+J[50]-J[51]+J[52]-J[53]-J[54]-J[55]-J[56]+J[57]+J[58]+J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+
    J[65], +H[0]-H[1]+H[2]-H[3]+H[4]-H[5]+H[6]-H[7]-H[8]+H[9]+H[10]+H[11]-J[0]+J[1]-J[2]+J[3]-J[4]+J[5]-J[6]-J[7]+
    J[8]+J[9]+J[10]-J[11]+J[12]-J[13]+J[14]-J[15]+J[16]+J[17]-J[18]-J[19]-J[20]-J[21]+J[22]-J[23]+J[24]-J[25]-J[26]+
    J[27]+J[28]+J[29]-J[30]+J[31]-J[32]+J[33]+J[34]-J[35]-J[36]-J[37]-J[38]+J[39]-J[40]-J[41]+J[42]+J[43]+
    J[44]-J[45]+J[46]+J[47]-J[48]-J[49]-J[50]-J[51]-J[52]+J[53]+J[54]+J[55]+J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+
    J[63]+J[64]+J[65], +H[0]-H[1]+H[2]-H[3]+H[4]-H[5]+H[6]-H[7]-H[8]+H[9]+H[10]-H[11]-J[0]+J[1]-J[2]+J[3]-J[4]+
    J[5]-J[6]-J[7]+J[8]+J[9]-J[10]-J[11]+J[12]-J[13]+J[14]-J[15]+J[16]+J[17]-J[18]-J[19]+J[20]-J[21]+J[22]-J[23]+
    J[24]-J[25]-J[26]+J[27]+J[28]-J[29]-J[30]+J[31]-J[32]+J[33]+J[34]-J[35]-J[36]+J[37]-J[38]+J[39]-J[40]-J[41]+
    J[42]+J[43]-J[44]-J[45]+J[46]+J[47]-J[48]-J[49]+J[50]-J[51]-J[52]+J[53]+J[54]-J[55]+J[56]-J[57]-J[58]+
    J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]-H[1]+H[2]-H[3]+H[4]-H[5]+H[6]-H[7]-H[8]+H[9]-H[10]+
    H[11]-J[0]+J[1]-J[2]+J[3]-J[4]+J[5]-J[6]-J[7]+J[8]-J[9]+J[10]-J[11]+J[12]-J[13]+J[14]-J[15]+J[16]+J[17]-J[18]+
    J[19]-J[20]-J[21]+J[22]-J[23]+J[24]-J[25]-J[26]+J[27]-J[28]+J[29]-J[30]+J[31]-J[32]+J[33]+J[34]-J[35]+
    J[36]-J[37]-J[38]+J[39]-J[40]-J[41]+J[42]-J[43]+J[44]-J[45]+J[46]+J[47]-J[48]+J[49]-J[50]-J[51]-J[52]+
    J[53]-J[54]+J[55]+J[56]-J[57]+J[58]-J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]-H[1]+H[2]-H[3]+
    H[4]-H[5]+H[6]-H[7]-H[8]+H[9]-H[10]-H[11]-J[0]+J[1]-J[2]+J[3]-J[4]+J[5]-J[6]-J[7]+J[8]-J[9]-J[10]-J[11]+
    J[12]-J[13]+J[14]-J[15]+J[16]+J[17]-J[18]+J[19]+J[20]-J[21]+J[22]-J[23]+J[24]-J[25]-J[26]+J[27]-J[28]-J[29]-J[30]+
    J[31]-J[32]+J[33]+J[34]-J[35]+J[36]+J[37]-J[38]+J[39]-J[40]-J[41]+J[42]-J[43]-J[44]-J[45]+J[46]+J[47]-J[48]+
    J[49]+J[50]-J[51]-J[52]+J[53]-J[54]-J[55]+J[56]-J[57]+J[58]+J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +
    H[0]-H[1]+H[2]-H[3]+H[4]-H[5]+H[6]-H[7]-H[8]-H[9]+H[10]+H[11]-J[0]+J[1]-J[2]+J[3]-J[4]+J[5]-J[6]-J[7]-J[8]+
    J[9]+J[10]-J[11]+J[12]-J[13]+J[14]-J[15]+J[16]+J[17]+J[18]-J[19]-J[20]-J[21]+J[22]-J[23]+J[24]-J[25]-J[26]-J[27]+
    J[28]+J[29]-J[30]+J[31]-J[32]+J[33]+J[34]+J[35]-J[36]-J[37]-J[38]+J[39]-J[40]-J[41]-J[42]+J[43]+J[44]-J[45]+
    J[46]+J[47]+J[48]-J[49]-J[50]-J[51]-J[52]-J[53]+J[54]+J[55]+J[56]+J[57]-J[58]-J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+
    J[65], +H[0]-H[1]+H[2]-H[3]+H[4]-H[5]+H[6]-H[7]-H[8]-H[9]+H[10]-H[11]-J[0]+J[1]-J[2]+J[3]-J[4]+J[5]-J[6]-J[7]-J[8]+
    J[9]-J[10]-J[11]+J[12]-J[13]+J[14]-J[15]+J[16]+J[17]+J[18]-J[19]+J[20]-J[21]+J[22]-J[23]+J[24]-J[25]-J[26]-J[27]+
    J[28]-J[29]-J[30]+J[31]-J[32]+J[33]+J[34]+J[35]-J[36]+J[37]-J[38]+J[39]-J[40]-J[41]-J[42]+J[43]-J[44]-J[45]+
    J[46]+J[47]+J[48]-J[49]+J[50]-J[51]-J[52]-J[53]+J[54]-J[55]+J[56]+J[57]-J[58]+J[59]+J[60]-J[61]+J[62]-J[63]+
    J[64]-J[65], +H[0]-H[1]+H[2]-H[3]+H[4]-H[5]+H[6]-H[7]-H[8]-H[9]-H[10]+H[11]-J[0]+J[1]-J[2]+J[3]-J[4]+
    J[5]-J[6]-J[7]-J[8]-J[9]+J[10]-J[11]+J[12]-J[13]+J[14]-J[15]+J[16]+J[17]+J[18]+J[19]-J[20]-J[21]+J[22]-J[23]+
    J[24]-J[25]-J[26]-J[27]-J[28]+J[29]-J[30]+J[31]-J[32]+J[33]+J[34]+J[35]+J[36]-J[37]-J[38]+J[39]-J[40]-J[41]-J[42]-J[43]+
    J[44]-J[45]+J[46]+J[47]+J[48]+J[49]-J[50]-J[51]-J[52]-J[53]-J[54]+J[55]+J[56]+J[57]+J[58]-J[59]+J[60]+
    J[61]-J[62]+J[63]-J[64]-J[65], +H[0]-H[1]+H[2]-H[3]+H[4]-H[5]+H[6]-H[7]-H[8]-H[9]-H[10]-H[11]-J[0]+J[1]-J[2]+
    J[3]-J[4]+J[5]-J[6]-J[7]-J[8]-J[9]-J[10]-J[11]+J[12]-J[13]+J[14]-J[15]+J[16]+J[17]+J[18]+J[19]+J[20]-J[21]+
    J[22]-J[23]+J[24]-J[25]-J[26]-J[27]-J[28]-J[29]-J[30]+J[31]-J[32]+J[33]+J[34]+J[35]+J[36]+J[37]-J[38]+
    J[39]-J[40]-J[41]-J[42]-J[43]-J[44]-J[45]+J[46]+J[47]+J[48]+J[49]+J[50]-J[51]-J[52]-J[53]-J[54]-J[55]+
    J[56]+J[57]+J[58]+J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]-H[1]+H[2]-H[3]+H[4]-H[5]-H[6]+H[7]+
    H[8]+H[9]+H[10]+H[11]-J[0]+J[1]-J[2]+J[3]-J[4]-J[5]+J[6]+J[7]+J[8]+J[9]+J[10]-J[11]+J[12]-J[13]+J[14]+
    J[15]-J[16]-J[17]-J[18]-J[19]-J[20]-J[21]+J[22]-J[23]-J[24]+J[25]+J[26]+J[27]+J[28]+J[29]-J[30]+J[31]+
    J[32]-J[33]-J[34]-J[35]-J[36]-J[37]-J[38]-J[39]+J[40]+J[41]+J[42]+J[43]+J[44]+J[45]-J[46]-J[47]-J[48]-J[49]-J[50]-J[51]-J[52]-J[53]-J[54]-J[55]+
    J[56]+J[57]+J[58]+J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]-H[1]+H[2]-H[3]+H[4]-H[5]-H[6]+H[7]+
    H[8]+H[9]+H[10]-H[11]-J[0]+J[1]-J[2]+J[3]-J[4]-J[5]+J[6]+J[7]+J[8]+J[9]-J[10]-J[11]+J[12]-J[13]+J[14]+
    J[15]-J[16]-J[17]-J[18]-J[19]+J[20]-J[21]+J[22]-J[23]-J[24]+J[25]+J[26]+J[27]+J[28]-J[29]-J[30]+J[31]+
    J[32]-J[33]-J[34]-J[35]-J[36]+J[37]-J[38]-J[39]+J[40]+J[41]+J[42]+J[43]-J[44]+J[45]-J[46]-J[47]-J[48]-J[49]+
    J[50]-J[51]-J[52]-J[53]-J[54]+J[55]+J[56]+J[57]+J[58]-J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]-H[1]+
    H[2]-H[3]+H[4]-H[5]-H[6]+H[7]+H[8]+H[9]-H[10]+H[11]-J[0]+J[1]-J[2]+J[3]-J[4]-J[5]+J[6]+J[7]+J[8]-J[9]+
    J[10]-J[11]+J[12]-J[13]+J[14]+J[15]-J[16]-J[17]-J[18]+J[19]-J[20]-J[21]+J[22]-J[23]-J[24]+J[25]+J[26]+
    J[27]-J[28]+J[29]-J[30]+J[31]+J[32]-J[33]-J[34]-J[35]+J[36]-J[37]-J[38]-J[39]+J[40]+J[41]+J[42]-J[43]+
    J[44]+J[45]-J[46]-J[47]-J[48]+J[49]-J[50]-J[51]-J[52]-J[53]+J[54]-J[55]+J[56]+J[57]-J[58]+J[59]+J[60]-J[61]+
    J[62]-J[63]+J[64]-J[65], +H[0]-H[1]+H[2]-H[3]+H[4]-H[5]-H[6]+H[7]+H[8]+H[9]-H[10]-H[11]-J[0]+J[1]-J[2]+
    J[3]-J[4]-J[5]+J[6]+J[7]+J[8]-J[9]-J[10]-J[11]+J[12]-J[13]+J[14]+J[15]-J[16]-J[17]-J[18]+J[19]+J[20]-J[21]+
    J[22]-J[23]-J[24]+J[25]+J[26]+J[27]-J[28]-J[29]-J[30]+J[31]+J[32]-J[33]-J[34]-J[35]+J[36]+J[37]-J[38]-J[39]+
    J[40]+J[41]+J[42]-J[43]-J[44]+J[45]-J[46]-J[47]-J[48]+J[49]+J[50]-J[51]-J[52]-J[53]+J[54]+J[55]+J[56]+
    J[57]-J[58]-J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]-H[1]+H[2]-H[3]+H[4]-H[5]-H[6]+H[7]+H[8]-H[9]+
    H[10]+H[11]-J[0]+J[1]-J[2]+J[3]-J[4]-J[5]+J[6]+J[7]-J[8]+J[9]+J[10]-J[11]+J[12]-J[13]+J[14]+J[15]-J[16]-J[17]+
    J[18]-J[19]-J[20]-J[21]+J[22]-J[23]-J[24]+J[25]+J[26]-J[27]+J[28]+J[29]-J[30]+J[31]+J[32]-J[33]-J[34]+
    J[35]-J[36]-J[37]-J[38]-J[39]+J[40]+J[41]-J[42]+J[43]+J[44]+J[45]-J[46]-J[47]+J[48]-J[49]-J[50]-J[51]-J[52]+
    J[53]-J[54]-J[55]+J[56]-J[57]+J[58]+J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]-H[1]+H[2]-H[3]+
    H[4]-H[5]-H[6]+H[7]+H[8]-H[9]+H[10]-H[11]-J[0]+J[1]-J[2]+J[3]-J[4]-J[5]+J[6]+J[7]-J[8]+J[9]-J[10]-J[11]+
    J[12]-J[13]+J[14]+J[15]-J[16]-J[17]+J[18]-J[19]+J[20]-J[21]+J[22]-J[23]-J[24]+J[25]+J[26]-J[27]+J[28]-J[29]-J[30]+
    J[31]+J[32]-J[33]-J[34]+J[35]-J[36]+J[37]-J[38]-J[39]+J[40]+J[41]-J[42]+J[43]-J[44]+J[45]-J[46]-J[47]+
    J[48]-J[49]+J[50]-J[51]-J[52]+J[53]-J[54]+J[55]+J[56]-J[57]+J[58]-J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +
    H[0]-H[1]+H[2]-H[3]+H[4]-H[5]-H[6]+H[7]+H[8]-H[9]-H[10]+H[11]-J[0]+J[1]-J[2]+J[3]-J[4]-J[5]+J[6]+J[7]-J[8]-J[9]+
    J[10]-J[11]+J[12]-J[13]+J[14]+J[15]-J[16]-J[17]+J[18]+J[19]-J[20]-J[21]+J[22]-J[23]-J[24]+J[25]+J[26]-J[27]-J[28]+
    J[29]-J[30]+J[31]+J[32]-J[33]-J[34]+J[35]+J[36]-J[37]-J[38]-J[39]+J[40]+J[41]-J[42]-J[43]+J[44]+J[45]-J[46]-J[47]+
    J[48]+J[49]-J[50]-J[51]-J[52]+J[53]+J[54]-J[55]+J[56]-J[57]-J[58]+J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +
    H[0]-H[1]+H[2]-H[3]+H[4]-H[5]-H[6]+H[7]+H[8]-H[9]-H[10]-H[11]-J[0]+J[1]-J[2]+J[3]-J[4]-J[5]+J[6]+J[7]-J[8]-J[9]-J[10]-J[11]+
    J[12]-J[13]+J[14]+J[15]-J[16]-J[17]+J[18]+J[19]+J[20]-J[21]+J[22]-J[23]-J[24]+J[25]+J[26]-J[27]-J[28]-J[29]-J[30]+
    J[31]+J[32]-J[33]-J[34]+J[35]+J[36]+J[37]-J[38]-J[39]+J[40]+J[41]-J[42]-J[43]-J[44]+J[45]-J[46]-J[47]+
    J[48]+J[49]+J[50]-J[51]-J[52]+J[53]+J[54]+J[55]+J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+
    J[65], +H[0]-H[1]+H[2]-H[3]+H[4]-H[5]-H[6]+H[7]-H[8]+H[9]+H[10]+H[11]-J[0]+J[1]-J[2]+J[3]-J[4]-J[5]+
    J[6]-J[7]+J[8]+J[9]+J[10]-J[11]+J[12]-J[13]+J[14]+J[15]-J[16]+J[17]-J[18]-J[19]-J[20]-J[21]+J[22]-J[23]-J[24]+
    J[25]-J[26]+J[27]+J[28]+J[29]-J[30]+J[31]+J[32]-J[33]+J[34]-J[35]-J[36]-J[37]-J[38]-J[39]+J[40]-J[41]+
    J[42]+J[43]+J[44]+J[45]-J[46]+J[47]-J[48]-J[49]-J[50]-J[51]+J[52]-J[53]-J[54]-J[55]-J[56]+J[57]+J[58]+
    J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]-H[1]+H[2]-H[3]+H[4]-H[5]-H[6]+H[7]-H[8]+H[9]+H[10]-H[11]-J[0]+
    J[1]-J[2]+J[3]-J[4]-J[5]+J[6]-J[7]+J[8]+J[9]-J[10]-J[11]+J[12]-J[13]+J[14]+J[15]-J[16]+J[17]-J[18]-J[19]+
    J[20]-J[21]+J[22]-J[23]-J[24]+J[25]-J[26]+J[27]+J[28]-J[29]-J[30]+J[31]+J[32]-J[33]+J[34]-J[35]-J[36]+
    J[37]-J[38]-J[39]+J[40]-J[41]+J[42]+J[43]-J[44]+J[45]-J[46]+J[47]-J[48]-J[49]+J[50]-J[51]+J[52]-J[53]-J[54]+
    J[55]-J[56]+J[57]+J[58]-J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]-H[1]+H[2]-H[3]+H[4]-H[5]-H[6]+
    H[7]-H[8]+H[9]-H[10]+H[11]-J[0]+J[1]-J[2]+J[3]-J[4]-J[5]+J[6]-J[7]+J[8]-J[9]+J[10]-J[11]+J[12]-J[13]+
    J[14]+J[15]-J[16]+J[17]-J[18]+J[19]-J[20]-J[21]+J[22]-J[23]-J[24]+J[25]-J[26]+J[27]-J[28]+J[29]-J[30]+
    J[31]+J[32]-J[33]+J[34]-J[35]+J[36]-J[37]-J[38]-J[39]+J[40]-J[41]+J[42]-J[43]+J[44]+J[45]-J[46]+J[47]-J[48]+
    J[49]-J[50]-J[51]+J[52]-J[53]+J[54]-J[55]-J[56]+J[57]-J[58]+J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +
    H[0]-H[1]+H[2]-H[3]+H[4]-H[5]-H[6]+H[7]-H[8]+H[9]-H[10]-H[11]-J[0]+J[1]-J[2]+J[3]-J[4]-J[5]+J[6]-J[7]+
    J[8]-J[9]-J[10]-J[11]+J[12]-J[13]+J[14]+J[15]-J[16]+J[17]-J[18]+J[19]+J[20]-J[21]+J[22]-J[23]-J[24]+
    J[25]-J[26]+J[27]-J[28]-J[29]-J[30]+J[31]+J[32]-J[33]+J[34]-J[35]+J[36]+J[37]-J[38]-J[39]+J[40]-J[41]+
    J[42]-J[43]-J[44]+J[45]-J[46]+J[47]-J[48]+J[49]+J[50]-J[51]+J[52]-J[53]+J[54]+J[55]-J[56]+J[57]-J[58]-J[59]-J[60]+
    J[61]+J[62]-J[63]-J[64]+J[65], +H[0]-H[1]+H[2]-H[3]+H[4]-H[5]-H[6]+H[7]-H[8]-H[9]+H[10]+H[11]-J[0]+J[1]-J[2]+
    J[3]-J[4]-J[5]+J[6]-J[7]-J[8]+J[9]+J[10]-J[11]+J[12]-J[13]+J[14]+J[15]-J[16]+J[17]+J[18]-J[19]-J[20]-J[21]+
    J[22]-J[23]-J[24]+J[25]-J[26]-J[27]+J[28]+J[29]-J[30]+J[31]+J[32]-J[33]+J[34]+J[35]-J[36]-J[37]-J[38]-J[39]+
    J[40]-J[41]-J[42]+J[43]+J[44]+J[45]-J[46]+J[47]+J[48]-J[49]-J[50]-J[51]+J[52]+J[53]-J[54]-J[55]-J[56]-J[57]+
    J[58]+J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]-H[1]+H[2]-H[3]+H[4]-H[5]-H[6]+H[7]-H[8]-H[9]+
    H[10]-H[11]-J[0]+J[1]-J[2]+J[3]-J[4]-J[5]+J[6]-J[7]-J[8]+J[9]-J[10]-J[11]+J[12]-J[13]+J[14]+J[15]-J[16]+
    J[17]+J[18]-J[19]+J[20]-J[21]+J[22]-J[23]-J[24]+J[25]-J[26]-J[27]+J[28]-J[29]-J[30]+J[31]+J[32]-J[33]+
    J[34]+J[35]-J[36]+J[37]-J[38]-J[39]+J[40]-J[41]-J[42]+J[43]-J[44]+J[45]-J[46]+J[47]+J[48]-J[49]+J[50]-J[51]+
    J[52]+J[53]-J[54]+J[55]-J[56]-J[57]+J[58]-J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]-H[1]+H[2]-H[3]+
    H[4]-H[5]-H[6]+H[7]-H[8]-H[9]-H[10]+H[11]-J[0]+J[1]-J[2]+J[3]-J[4]-J[5]+J[6]-J[7]-J[8]-J[9]+J[10]-J[11]+
    J[12]-J[13]+J[14]+J[15]-J[16]+J[17]+J[18]+J[19]-J[20]-J[21]+J[22]-J[23]-J[24]+J[25]-J[26]-J[27]-J[28]+
    J[29]-J[30]+J[31]+J[32]-J[33]+J[34]+J[35]+J[36]-J[37]-J[38]-J[39]+J[40]-J[41]-J[42]-J[43]+J[44]+J[45]-J[46]+
    J[47]+J[48]+J[49]-J[50]-J[51]+J[52]+J[53]+J[54]-J[55]-J[56]-J[57]-J[58]+J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +
    H[0]-H[1]+H[2]-H[3]+H[4]-H[5]-H[6]+H[7]-H[8]-H[9]-H[10]-H[11]-J[0]+J[1]-J[2]+J[3]-J[4]-J[5]+J[6]-J[7]-J[8]-J[9]-J[10]-J[11]+
    J[12]-J[13]+J[14]+J[15]-J[16]+J[17]+J[18]+J[19]+J[20]-J[21]+J[22]-J[23]-J[24]+J[25]-J[26]-J[27]-J[28]-J[29]-J[30]+
    J[31]+J[32]-J[33]+J[34]+J[35]+J[36]+J[37]-J[38]-J[39]+J[40]-J[41]-J[42]-J[43]-J[44]+J[45]-J[46]+J[47]+
    J[48]+J[49]+J[50]-J[51]+J[52]+J[53]+J[54]+J[55]-J[56]-J[57]-J[58]-J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+
    J[65], +H[0]-H[1]+H[2]-H[3]+H[4]-H[5]-H[6]-H[7]+H[8]+H[9]+H[10]+H[11]-J[0]+J[1]-J[2]+J[3]-J[4]-J[5]-J[6]+
    J[7]+J[8]+J[9]+J[10]-J[11]+J[12]-J[13]+J[14]+J[15]+J[16]-J[17]-J[18]-J[19]-J[20]-J[21]+J[22]-J[23]-J[24]-J[25]+
    J[26]+J[27]+J[28]+J[29]-J[30]+J[31]+J[32]+J[33]-J[34]-J[35]-J[36]-J[37]-J[38]-J[39]-J[40]+J[41]+J[42]+
    J[43]+J[44]+J[45]+J[46]-J[47]-J[48]-J[49]-J[50]+J[51]-J[52]-J[53]-J[54]-J[55]-J[56]-J[57]-J[58]-J[59]+
    J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]-H[1]+H[2]-H[3]+H[4]-H[5]-H[6]-H[7]+H[8]+H[9]+H[10]-H[11]-J[0]+
    J[1]-J[2]+J[3]-J[4]-J[5]-J[6]+J[7]+J[8]+J[9]-J[10]-J[11]+J[12]-J[13]+J[14]+J[15]+J[16]-J[17]-J[18]-J[19]+
    J[20]-J[21]+J[22]-J[23]-J[24]-J[25]+J[26]+J[27]+J[28]-J[29]-J[30]+J[31]+J[32]+J[33]-J[34]-J[35]-J[36]+
    J[37]-J[38]-J[39]-J[40]+J[41]+J[42]+J[43]-J[44]+J[45]+J[46]-J[47]-J[48]-J[49]+J[50]+J[51]-J[52]-J[53]-J[54]+
    J[55]-J[56]-J[57]-J[58]+J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]-H[1]+H[2]-H[3]+H[4]-H[5]-H[6]-H[7]+
    H[8]+H[9]-H[10]+H[11]-J[0]+J[1]-J[2]+J[3]-J[4]-J[5]-J[6]+J[7]+J[8]-J[9]+J[10]-J[11]+J[12]-J[13]+J[14]+
    J[15]+J[16]-J[17]-J[18]+J[19]-J[20]-J[21]+J[22]-J[23]-J[24]-J[25]+J[26]+J[27]-J[28]+J[29]-J[30]+J[31]+
    J[32]+J[33]-J[34]-J[35]+J[36]-J[37]-J[38]-J[39]-J[40]+J[41]+J[42]-J[43]+J[44]+J[45]+J[46]-J[47]-J[48]+
    J[49]-J[50]+J[51]-J[52]-J[53]+J[54]-J[55]-J[56]-J[57]+J[58]-J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +
    H[0]-H[1]+H[2]-H[3]+H[4]-H[5]-H[6]-H[7]+H[8]+H[9]-H[10]-H[11]-J[0]+J[1]-J[2]+J[3]-J[4]-J[5]-J[6]+J[7]+
    J[8]-J[9]-J[10]-J[11]+J[12]-J[13]+J[14]+J[15]+J[16]-J[17]-J[18]+J[19]+J[20]-J[21]+J[22]-J[23]-J[24]-J[25]+
    J[26]+J[27]-J[28]-J[29]-J[30]+J[31]+J[32]+J[33]-J[34]-J[35]+J[36]+J[37]-J[38]-J[39]-J[40]+J[41]+J[42]-J[43]-J[44]+
    J[45]+J[46]-J[47]-J[48]+J[49]+J[50]+J[51]-J[52]-J[53]+J[54]+J[55]-J[56]-J[57]+J[58]+J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+
    J[65], +H[0]-H[1]+H[2]-H[3]+H[4]-H[5]-H[6]-H[7]+H[8]-H[9]+H[10]+H[11]-J[0]+J[1]-J[2]+J[3]-J[4]-J[5]-J[6]+
    J[7]-J[8]+J[9]+J[10]-J[11]+J[12]-J[13]+J[14]+J[15]+J[16]-J[17]+J[18]-J[19]-J[20]-J[21]+J[22]-J[23]-J[24]-J[25]+
    J[26]-J[27]+J[28]+J[29]-J[30]+J[31]+J[32]+J[33]-J[34]+J[35]-J[36]-J[37]-J[38]-J[39]-J[40]+J[41]-J[42]+
    J[43]+J[44]+J[45]+J[46]-J[47]+J[48]-J[49]-J[50]+J[51]-J[52]+J[53]-J[54]-J[55]-J[56]+J[57]-J[58]-J[59]-J[60]+
    J[61]+J[62]-J[63]-J[64]+J[65], +H[0]-H[1]+H[2]-H[3]+H[4]-H[5]-H[6]-H[7]+H[8]-H[9]+H[10]-H[11]-J[0]+J[1]-J[2]+
    J[3]-J[4]-J[5]-J[6]+J[7]-J[8]+J[9]-J[10]-J[11]+J[12]-J[13]+J[14]+J[15]+J[16]-J[17]+J[18]-J[19]+J[20]-J[21]+
    J[22]-J[23]-J[24]-J[25]+J[26]-J[27]+J[28]-J[29]-J[30]+J[31]+J[32]+J[33]-J[34]+J[35]-J[36]+J[37]-J[38]-J[39]-J[40]+
    J[41]-J[42]+J[43]-J[44]+J[45]+J[46]-J[47]+J[48]-J[49]+J[50]+J[51]-J[52]+J[53]-J[54]+J[55]-J[56]+J[57]-J[58]+
    J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]-H[1]+H[2]-H[3]+H[4]-H[5]-H[6]-H[7]+H[8]-H[9]-H[10]+
    H[11]-J[0]+J[1]-J[2]+J[3]-J[4]-J[5]-J[6]+J[7]-J[8]-J[9]+J[10]-J[11]+J[12]-J[13]+J[14]+J[15]+J[16]-J[17]+
    J[18]+J[19]-J[20]-J[21]+J[22]-J[23]-J[24]-J[25]+J[26]-J[27]-J[28]+J[29]-J[30]+J[31]+J[32]+J[33]-J[34]+
    J[35]+J[36]-J[37]-J[38]-J[39]-J[40]+J[41]-J[42]-J[43]+J[44]+J[45]+J[46]-J[47]+J[48]+J[49]-J[50]+J[51]-J[52]+
    J[53]+J[54]-J[55]-J[56]+J[57]+J[58]-J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]-H[1]+H[2]-H[3]+
    H[4]-H[5]-H[6]-H[7]+H[8]-H[9]-H[10]-H[11]-J[0]+J[1]-J[2]+J[3]-J[4]-J[5]-J[6]+J[7]-J[8]-J[9]-J[10]-J[11]+
    J[12]-J[13]+J[14]+J[15]+J[16]-J[17]+J[18]+J[19]+J[20]-J[21]+J[22]-J[23]-J[24]-J[25]+J[26]-J[27]-J[28]-J[29]-J[30]+
    J[31]+J[32]+J[33]-J[34]+J[35]+J[36]+J[37]-J[38]-J[39]-J[40]+J[41]-J[42]-J[43]-J[44]+J[45]+J[46]-J[47]+
    J[48]+J[49]+J[50]+J[51]-J[52]+J[53]+J[54]+J[55]-J[56]+J[57]+J[58]+J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+
    J[65], +H[0]-H[1]+H[2]-H[3]+H[4]-H[5]-H[6]-H[7]-H[8]+H[9]+H[10]+H[11]-J[0]+J[1]-J[2]+J[3]-J[4]-J[5]-J[6]-J[7]+
    J[8]+J[9]+J[10]-J[11]+J[12]-J[13]+J[14]+J[15]+J[16]+J[17]-J[18]-J[19]-J[20]-J[21]+J[22]-J[23]-J[24]-J[25]-J[26]+
    J[27]+J[28]+J[29]-J[30]+J[31]+J[32]+J[33]+J[34]-J[35]-J[36]-J[37]-J[38]-J[39]-J[40]-J[41]+J[42]+J[43]+
    J[44]+J[45]+J[46]+J[47]-J[48]-J[49]-J[50]+J[51]+J[52]-J[53]-J[54]-J[55]+J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+
    J[63]+J[64]+J[65], +H[0]-H[1]+H[2]-H[3]+H[4]-H[5]-H[6]-H[7]-H[8]+H[9]+H[10]-H[11]-J[0]+J[1]-J[2]+J[3]-J[4]-J[5]-J[6]-J[7]+
    J[8]+J[9]-J[10]-J[11]+J[12]-J[13]+J[14]+J[15]+J[16]+J[17]-J[18]-J[19]+J[20]-J[21]+J[22]-J[23]-J[24]-J[25]-J[26]+
    J[27]+J[28]-J[29]-J[30]+J[31]+J[32]+J[33]+J[34]-J[35]-J[36]+J[37]-J[38]-J[39]-J[40]-J[41]+J[42]+J[43]-J[44]+
    J[45]+J[46]+J[47]-J[48]-J[49]+J[50]+J[51]+J[52]-J[53]-J[54]+J[55]+J[56]-J[57]-J[58]+J[59]-J[60]-J[61]+
    J[62]+J[63]-J[64]-J[65], +H[0]-H[1]+H[2]-H[3]+H[4]-H[5]-H[6]-H[7]-H[8]+H[9]-H[10]+H[11]-J[0]+J[1]-J[2]+
    J[3]-J[4]-J[5]-J[6]-J[7]+J[8]-J[9]+J[10]-J[11]+J[12]-J[13]+J[14]+J[15]+J[16]+J[17]-J[18]+J[19]-J[20]-J[21]+
    J[22]-J[23]-J[24]-J[25]-J[26]+J[27]-J[28]+J[29]-J[30]+J[31]+J[32]+J[33]+J[34]-J[35]+J[36]-J[37]-J[38]-J[39]-J[40]-J[41]+
    J[42]-J[43]+J[44]+J[45]+J[46]+J[47]-J[48]+J[49]-J[50]+J[51]+J[52]-J[53]+J[54]-J[55]+J[56]-J[57]+J[58]-J[59]-J[60]+
    J[61]-J[62]-J[63]+J[64]-J[65], +H[0]-H[1]+H[2]-H[3]+H[4]-H[5]-H[6]-H[7]-H[8]+H[9]-H[10]-H[11]-J[0]+J[1]-J[2]+
    J[3]-J[4]-J[5]-J[6]-J[7]+J[8]-J[9]-J[10]-J[11]+J[12]-J[13]+J[14]+J[15]+J[16]+J[17]-J[18]+J[19]+J[20]-J[21]+
    J[22]-J[23]-J[24]-J[25]-J[26]+J[27]-J[28]-J[29]-J[30]+J[31]+J[32]+J[33]+J[34]-J[35]+J[36]+J[37]-J[38]-J[39]-J[40]-J[41]+
    J[42]-J[43]-J[44]+J[45]+J[46]+J[47]-J[48]+J[49]+J[50]+J[51]+J[52]-J[53]+J[54]+J[55]+J[56]-J[57]+J[58]+
    J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]-H[1]+H[2]-H[3]+H[4]-H[5]-H[6]-H[7]-H[8]-H[9]+H[10]+
    H[11]-J[0]+J[1]-J[2]+J[3]-J[4]-J[5]-J[6]-J[7]-J[8]+J[9]+J[10]-J[11]+J[12]-J[13]+J[14]+J[15]+J[16]+J[17]+
    J[18]-J[19]-J[20]-J[21]+J[22]-J[23]-J[24]-J[25]-J[26]-J[27]+J[28]+J[29]-J[30]+J[31]+J[32]+J[33]+J[34]+
    J[35]-J[36]-J[37]-J[38]-J[39]-J[40]-J[41]-J[42]+J[43]+J[44]+J[45]+J[46]+J[47]+J[48]-J[49]-J[50]+J[51]+
    J[52]+J[53]-J[54]-J[55]+J[56]+J[57]-J[58]-J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]-H[1]+H[2]-H[3]+
    H[4]-H[5]-H[6]-H[7]-H[8]-H[9]+H[10]-H[11]-J[0]+J[1]-J[2]+J[3]-J[4]-J[5]-J[6]-J[7]-J[8]+J[9]-J[10]-J[11]+
    J[12]-J[13]+J[14]+J[15]+J[16]+J[17]+J[18]-J[19]+J[20]-J[21]+J[22]-J[23]-J[24]-J[25]-J[26]-J[27]+J[28]-J[29]-J[30]+
    J[31]+J[32]+J[33]+J[34]+J[35]-J[36]+J[37]-J[38]-J[39]-J[40]-J[41]-J[42]+J[43]-J[44]+J[45]+J[46]+J[47]+
    J[48]-J[49]+J[50]+J[51]+J[52]+J[53]-J[54]+J[55]+J[56]+J[57]-J[58]+J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +
    H[0]-H[1]+H[2]-H[3]+H[4]-H[5]-H[6]-H[7]-H[8]-H[9]-H[10]+H[11]-J[0]+J[1]-J[2]+J[3]-J[4]-J[5]-J[6]-J[7]-J[8]-J[9]+
    J[10]-J[11]+J[12]-J[13]+J[14]+J[15]+J[16]+J[17]+J[18]+J[19]-J[20]-J[21]+J[22]-J[23]-J[24]-J[25]-J[26]-J[27]-J[28]+
    J[29]-J[30]+J[31]+J[32]+J[33]+J[34]+J[35]+J[36]-J[37]-J[38]-J[39]-J[40]-J[41]-J[42]-J[43]+J[44]+J[45]+
    J[46]+J[47]+J[48]+J[49]-J[50]+J[51]+J[52]+J[53]+J[54]-J[55]+J[56]+J[57]+J[58]-J[59]+J[60]+J[61]-J[62]+
    J[63]-J[64]-J[65], +H[0]-H[1]+H[2]-H[3]+H[4]-H[5]-H[6]-H[7]-H[8]-H[9]-H[10]-H[11]-J[0]+J[1]-J[2]+J[3]-J[4]-J[5]-J[6]-J[7]-J[8]-J[9]-J[10]-J[11]+
    J[12]-J[13]+J[14]+J[15]+J[16]+J[17]+J[18]+J[19]+J[20]-J[21]+J[22]-J[23]-J[24]-J[25]-J[26]-J[27]-J[28]-J[29]-J[30]+
    J[31]+J[32]+J[33]+J[34]+J[35]+J[36]+J[37]-J[38]-J[39]-J[40]-J[41]-J[42]-J[43]-J[44]+J[45]+J[46]+J[47]+
    J[48]+J[49]+J[50]+J[51]+J[52]+J[53]+J[54]+J[55]+J[56]+J[57]+J[58]+J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+
    J[65], +H[0]-H[1]+H[2]-H[3]-H[4]+H[5]+H[6]+H[7]+H[8]+H[9]+H[10]+H[11]-J[0]+J[1]-J[2]-J[3]+J[4]+J[5]+
    J[6]+J[7]+J[8]+J[9]+J[10]-J[11]+J[12]+J[13]-J[14]-J[15]-J[16]-J[17]-J[18]-J[19]-J[20]-J[21]-J[22]+J[23]+
    J[24]+J[25]+J[26]+J[27]+J[28]+J[29]+J[30]-J[31]-J[32]-J[33]-J[34]-J[35]-J[36]-J[37]-J[38]-J[39]-J[40]-J[41]-J[42]-J[43]-J[44]+
    J[45]+J[46]+J[47]+J[48]+J[49]+J[50]+J[51]+J[52]+J[53]+J[54]+J[55]+J[56]+J[57]+J[58]+J[59]+J[60]+J[61]+
    J[62]+J[63]+J[64]+J[65], +H[0]-H[1]+H[2]-H[3]-H[4]+H[5]+H[6]+H[7]+H[8]+H[9]+H[10]-H[11]-J[0]+J[1]-J[2]-J[3]+
    J[4]+J[5]+J[6]+J[7]+J[8]+J[9]-J[10]-J[11]+J[12]+J[13]-J[14]-J[15]-J[16]-J[17]-J[18]-J[19]+J[20]-J[21]-J[22]+
    J[23]+J[24]+J[25]+J[26]+J[27]+J[28]-J[29]+J[30]-J[31]-J[32]-J[33]-J[34]-J[35]-J[36]+J[37]-J[38]-J[39]-J[40]-J[41]-J[42]-J[43]+
    J[44]+J[45]+J[46]+J[47]+J[48]+J[49]-J[50]+J[51]+J[52]+J[53]+J[54]-J[55]+J[56]+J[57]+J[58]-J[59]+J[60]+
    J[61]-J[62]+J[63]-J[64]-J[65], +H[0]-H[1]+H[2]-H[3]-H[4]+H[5]+H[6]+H[7]+H[8]+H[9]-H[10]+H[11]-J[0]+J[1]-J[2]-J[3]+
    J[4]+J[5]+J[6]+J[7]+J[8]-J[9]+J[10]-J[11]+J[12]+J[13]-J[14]-J[15]-J[16]-J[17]-J[18]+J[19]-J[20]-J[21]-J[22]+
    J[23]+J[24]+J[25]+J[26]+J[27]-J[28]+J[29]+J[30]-J[31]-J[32]-J[33]-J[34]-J[35]+J[36]-J[37]-J[38]-J[39]-J[40]-J[41]-J[42]+
    J[43]-J[44]+J[45]+J[46]+J[47]+J[48]-J[49]+J[50]+J[51]+J[52]+J[53]-J[54]+J[55]+J[56]+J[57]-J[58]+J[59]+
    J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]-H[1]+H[2]-H[3]-H[4]+H[5]+H[6]+H[7]+H[8]+H[9]-H[10]-H[11]-J[0]+
    J[1]-J[2]-J[3]+J[4]+J[5]+J[6]+J[7]+J[8]-J[9]-J[10]-J[11]+J[12]+J[13]-J[14]-J[15]-J[16]-J[17]-J[18]+J[19]+
    J[20]-J[21]-J[22]+J[23]+J[24]+J[25]+J[26]+J[27]-J[28]-J[29]+J[30]-J[31]-J[32]-J[33]-J[34]-J[35]+J[36]+
    J[37]-J[38]-J[39]-J[40]-J[41]-J[42]+J[43]+J[44]+J[45]+J[46]+J[47]+J[48]-J[49]-J[50]+J[51]+J[52]+J[53]-J[54]-J[55]+
    J[56]+J[57]-J[58]-J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]-H[1]+H[2]-H[3]-H[4]+H[5]+H[6]+H[7]+
    H[8]-H[9]+H[10]+H[11]-J[0]+J[1]-J[2]-J[3]+J[4]+J[5]+J[6]+J[7]-J[8]+J[9]+J[10]-J[11]+J[12]+J[13]-J[14]-J[15]-J[16]-J[17]+
    J[18]-J[19]-J[20]-J[21]-J[22]+J[23]+J[24]+J[25]+J[26]-J[27]+J[28]+J[29]+J[30]-J[31]-J[32]-J[33]-J[34]+
    J[35]-J[36]-J[37]-J[38]-J[39]-J[40]-J[41]+J[42]-J[43]-J[44]+J[45]+J[46]+J[47]-J[48]+J[49]+J[50]+J[51]+
    J[52]-J[53]+J[54]+J[55]+J[56]-J[57]+J[58]+J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]-H[1]+H[2]-H[3]-H[4]+
    H[5]+H[6]+H[7]+H[8]-H[9]+H[10]-H[11]-J[0]+J[1]-J[2]-J[3]+J[4]+J[5]+J[6]+J[7]-J[8]+J[9]-J[10]-J[11]+J[12]+
    J[13]-J[14]-J[15]-J[16]-J[17]+J[18]-J[19]+J[20]-J[21]-J[22]+J[23]+J[24]+J[25]+J[26]-J[27]+J[28]-J[29]+
    J[30]-J[31]-J[32]-J[33]-J[34]+J[35]-J[36]+J[37]-J[38]-J[39]-J[40]-J[41]+J[42]-J[43]+J[44]+J[45]+J[46]+
    J[47]-J[48]+J[49]-J[50]+J[51]+J[52]-J[53]+J[54]-J[55]+J[56]-J[57]+J[58]-J[59]-J[60]+J[61]-J[62]-J[63]+
    J[64]-J[65], +H[0]-H[1]+H[2]-H[3]-H[4]+H[5]+H[6]+H[7]+H[8]-H[9]-H[10]+H[11]-J[0]+J[1]-J[2]-J[3]+J[4]+
    J[5]+J[6]+J[7]-J[8]-J[9]+J[10]-J[11]+J[12]+J[13]-J[14]-J[15]-J[16]-J[17]+J[18]+J[19]-J[20]-J[21]-J[22]+
    J[23]+J[24]+J[25]+J[26]-J[27]-J[28]+J[29]+J[30]-J[31]-J[32]-J[33]-J[34]+J[35]+J[36]-J[37]-J[38]-J[39]-J[40]-J[41]+
    J[42]+J[43]-J[44]+J[45]+J[46]+J[47]-J[48]-J[49]+J[50]+J[51]+J[52]-J[53]-J[54]+J[55]+J[56]-J[57]-J[58]+
    J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]-H[1]+H[2]-H[3]-H[4]+H[5]+H[6]+H[7]+H[8]-H[9]-H[10]-H[11]-J[0]+
    J[1]-J[2]-J[3]+J[4]+J[5]+J[6]+J[7]-J[8]-J[9]-J[10]-J[11]+J[12]+J[13]-J[14]-J[15]-J[16]-J[17]+J[18]+J[19]+
    J[20]-J[21]-J[22]+J[23]+J[24]+J[25]+J[26]-J[27]-J[28]-J[29]+J[30]-J[31]-J[32]-J[33]-J[34]+J[35]+J[36]+
    J[37]-J[38]-J[39]-J[40]-J[41]+J[42]+J[43]+J[44]+J[45]+J[46]+J[47]-J[48]-J[49]-J[50]+J[51]+J[52]-J[53]-J[54]-J[55]+
    J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]-H[1]+H[2]-H[3]-H[4]+H[5]+H[6]+H[7]-H[8]+
    H[9]+H[10]+H[11]-J[0]+J[1]-J[2]-J[3]+J[4]+J[5]+J[6]-J[7]+J[8]+J[9]+J[10]-J[11]+J[12]+J[13]-J[14]-J[15]-J[16]+
    J[17]-J[18]-J[19]-J[20]-J[21]-J[22]+J[23]+J[24]+J[25]-J[26]+J[27]+J[28]+J[29]+J[30]-J[31]-J[32]-J[33]+
    J[34]-J[35]-J[36]-J[37]-J[38]-J[39]-J[40]+J[41]-J[42]-J[43]-J[44]+J[45]+J[46]-J[47]+J[48]+J[49]+J[50]+
    J[51]-J[52]+J[53]+J[54]+J[55]-J[56]+J[57]+J[58]+J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]-H[1]+
    H[2]-H[3]-H[4]+H[5]+H[6]+H[7]-H[8]+H[9]+H[10]-H[11]-J[0]+J[1]-J[2]-J[3]+J[4]+J[5]+J[6]-J[7]+J[8]+J[9]-J[10]-J[11]+
    J[12]+J[13]-J[14]-J[15]-J[16]+J[17]-J[18]-J[19]+J[20]-J[21]-J[22]+J[23]+J[24]+J[25]-J[26]+J[27]+J[28]-J[29]+
    J[30]-J[31]-J[32]-J[33]+J[34]-J[35]-J[36]+J[37]-J[38]-J[39]-J[40]+J[41]-J[42]-J[43]+J[44]+J[45]+J[46]-J[47]+
    J[48]+J[49]-J[50]+J[51]-J[52]+J[53]+J[54]-J[55]-J[56]+J[57]+J[58]-J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +
    H[0]-H[1]+H[2]-H[3]-H[4]+H[5]+H[6]+H[7]-H[8]+H[9]-H[10]+H[11]-J[0]+J[1]-J[2]-J[3]+J[4]+J[5]+J[6]-J[7]+
    J[8]-J[9]+J[10]-J[11]+J[12]+J[13]-J[14]-J[15]-J[16]+J[17]-J[18]+J[19]-J[20]-J[21]-J[22]+J[23]+J[24]+
    J[25]-J[26]+J[27]-J[28]+J[29]+J[30]-J[31]-J[32]-J[33]+J[34]-J[35]+J[36]-J[37]-J[38]-J[39]-J[40]+J[41]-J[42]+
    J[43]-J[44]+J[45]+J[46]-J[47]+J[48]-J[49]+J[50]+J[51]-J[52]+J[53]-J[54]+J[55]-J[56]+J[57]-J[58]+J[59]-J[60]+
    J[61]-J[62]-J[63]+J[64]-J[65], +H[0]-H[1]+H[2]-H[3]-H[4]+H[5]+H[6]+H[7]-H[8]+H[9]-H[10]-H[11]-J[0]+J[1]-J[2]-J[3]+
    J[4]+J[5]+J[6]-J[7]+J[8]-J[9]-J[10]-J[11]+J[12]+J[13]-J[14]-J[15]-J[16]+J[17]-J[18]+J[19]+J[20]-J[21]-J[22]+
    J[23]+J[24]+J[25]-J[26]+J[27]-J[28]-J[29]+J[30]-J[31]-J[32]-J[33]+J[34]-J[35]+J[36]+J[37]-J[38]-J[39]-J[40]+
    J[41]-J[42]+J[43]+J[44]+J[45]+J[46]-J[47]+J[48]-J[49]-J[50]+J[51]-J[52]+J[53]-J[54]-J[55]-J[56]+J[57]-J[58]-J[59]-J[60]+
    J[61]+J[62]-J[63]-J[64]+J[65], +H[0]-H[1]+H[2]-H[3]-H[4]+H[5]+H[6]+H[7]-H[8]-H[9]+H[10]+H[11]-J[0]+J[1]-J[2]-J[3]+
    J[4]+J[5]+J[6]-J[7]-J[8]+J[9]+J[10]-J[11]+J[12]+J[13]-J[14]-J[15]-J[16]+J[17]+J[18]-J[19]-J[20]-J[21]-J[22]+
    J[23]+J[24]+J[25]-J[26]-J[27]+J[28]+J[29]+J[30]-J[31]-J[32]-J[33]+J[34]+J[35]-J[36]-J[37]-J[38]-J[39]-J[40]+
    J[41]+J[42]-J[43]-J[44]+J[45]+J[46]-J[47]-J[48]+J[49]+J[50]+J[51]-J[52]-J[53]+J[54]+J[55]-J[56]-J[57]+
    J[58]+J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]-H[1]+H[2]-H[3]-H[4]+H[5]+H[6]+H[7]-H[8]-H[9]+
    H[10]-H[11]-J[0]+J[1]-J[2]-J[3]+J[4]+J[5]+J[6]-J[7]-J[8]+J[9]-J[10]-J[11]+J[12]+J[13]-J[14]-J[15]-J[16]+
    J[17]+J[18]-J[19]+J[20]-J[21]-J[22]+J[23]+J[24]+J[25]-J[26]-J[27]+J[28]-J[29]+J[30]-J[31]-J[32]-J[33]+
    J[34]+J[35]-J[36]+J[37]-J[38]-J[39]-J[40]+J[41]+J[42]-J[43]+J[44]+J[45]+J[46]-J[47]-J[48]+J[49]-J[50]+
    J[51]-J[52]-J[53]+J[54]-J[55]-J[56]-J[57]+J[58]-J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]-H[1]+
    H[2]-H[3]-H[4]+H[5]+H[6]+H[7]-H[8]-H[9]-H[10]+H[11]-J[0]+J[1]-J[2]-J[3]+J[4]+J[5]+J[6]-J[7]-J[8]-J[9]+
    J[10]-J[11]+J[12]+J[13]-J[14]-J[15]-J[16]+J[17]+J[18]+J[19]-J[20]-J[21]-J[22]+J[23]+J[24]+J[25]-J[26]-J[27]-J[28]+
    J[29]+J[30]-J[31]-J[32]-J[33]+J[34]+J[35]+J[36]-J[37]-J[38]-J[39]-J[40]+J[41]+J[42]+J[43]-J[44]+J[45]+
    J[46]-J[47]-J[48]-J[49]+J[50]+J[51]-J[52]-J[53]-J[54]+J[55]-J[56]-J[57]-J[58]+J[59]+J[60]+J[61]-J[62]+
    J[63]-J[64]-J[65], +H[0]-H[1]+H[2]-H[3]-H[4]+H[5]+H[6]+H[7]-H[8]-H[9]-H[10]-H[11]-J[0]+J[1]-J[2]-J[3]+
    J[4]+J[5]+J[6]-J[7]-J[8]-J[9]-J[10]-J[11]+J[12]+J[13]-J[14]-J[15]-J[16]+J[17]+J[18]+J[19]+J[20]-J[21]-J[22]+
    J[23]+J[24]+J[25]-J[26]-J[27]-J[28]-J[29]+J[30]-J[31]-J[32]-J[33]+J[34]+J[35]+J[36]+J[37]-J[38]-J[39]-J[40]+
    J[41]+J[42]+J[43]+J[44]+J[45]+J[46]-J[47]-J[48]-J[49]-J[50]+J[51]-J[52]-J[53]-J[54]-J[55]-J[56]-J[57]-J[58]-J[59]+
    J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]-H[1]+H[2]-H[3]-H[4]+H[5]+H[6]-H[7]+H[8]+H[9]+H[10]+H[11]-J[0]+
    J[1]-J[2]-J[3]+J[4]+J[5]-J[6]+J[7]+J[8]+J[9]+J[10]-J[11]+J[12]+J[13]-J[14]-J[15]+J[16]-J[17]-J[18]-J[19]-J[20]-J[21]-J[22]+
    J[23]+J[24]-J[25]+J[26]+J[27]+J[28]+J[29]+J[30]-J[31]-J[32]+J[33]-J[34]-J[35]-J[36]-J[37]-J[38]-J[39]+
    J[40]-J[41]-J[42]-J[43]-J[44]+J[45]-J[46]+J[47]+J[48]+J[49]+J[50]-J[51]+J[52]+J[53]+J[54]+J[55]-J[56]-J[57]-J[58]-J[59]+
    J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]-H[1]+H[2]-H[3]-H[4]+H[5]+H[6]-H[7]+H[8]+H[9]+H[10]-H[11]-J[0]+
    J[1]-J[2]-J[3]+J[4]+J[5]-J[6]+J[7]+J[8]+J[9]-J[10]-J[11]+J[12]+J[13]-J[14]-J[15]+J[16]-J[17]-J[18]-J[19]+
    J[20]-J[21]-J[22]+J[23]+J[24]-J[25]+J[26]+J[27]+J[28]-J[29]+J[30]-J[31]-J[32]+J[33]-J[34]-J[35]-J[36]+
    J[37]-J[38]-J[39]+J[40]-J[41]-J[42]-J[43]+J[44]+J[45]-J[46]+J[47]+J[48]+J[49]-J[50]-J[51]+J[52]+J[53]+
    J[54]-J[55]-J[56]-J[57]-J[58]+J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]-H[1]+H[2]-H[3]-H[4]+H[5]+
    H[6]-H[7]+H[8]+H[9]-H[10]+H[11]-J[0]+J[1]-J[2]-J[3]+J[4]+J[5]-J[6]+J[7]+J[8]-J[9]+J[10]-J[11]+J[12]+
    J[13]-J[14]-J[15]+J[16]-J[17]-J[18]+J[19]-J[20]-J[21]-J[22]+J[23]+J[24]-J[25]+J[26]+J[27]-J[28]+J[29]+
    J[30]-J[31]-J[32]+J[33]-J[34]-J[35]+J[36]-J[37]-J[38]-J[39]+J[40]-J[41]-J[42]+J[43]-J[44]+J[45]-J[46]+
    J[47]+J[48]-J[49]+J[50]-J[51]+J[52]+J[53]-J[54]+J[55]-J[56]-J[57]+J[58]-J[59]+J[60]-J[61]+J[62]-J[63]+
    J[64]-J[65], +H[0]-H[1]+H[2]-H[3]-H[4]+H[5]+H[6]-H[7]+H[8]+H[9]-H[10]-H[11]-J[0]+J[1]-J[2]-J[3]+J[4]+
    J[5]-J[6]+J[7]+J[8]-J[9]-J[10]-J[11]+J[12]+J[13]-J[14]-J[15]+J[16]-J[17]-J[18]+J[19]+J[20]-J[21]-J[22]+
    J[23]+J[24]-J[25]+J[26]+J[27]-J[28]-J[29]+J[30]-J[31]-J[32]+J[33]-J[34]-J[35]+J[36]+J[37]-J[38]-J[39]+
    J[40]-J[41]-J[42]+J[43]+J[44]+J[45]-J[46]+J[47]+J[48]-J[49]-J[50]-J[51]+J[52]+J[53]-J[54]-J[55]-J[56]-J[57]+
    J[58]+J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]-H[1]+H[2]-H[3]-H[4]+H[5]+H[6]-H[7]+H[8]-H[9]+
    H[10]+H[11]-J[0]+J[1]-J[2]-J[3]+J[4]+J[5]-J[6]+J[7]-J[8]+J[9]+J[10]-J[11]+J[12]+J[13]-J[14]-J[15]+J[16]-J[17]+
    J[18]-J[19]-J[20]-J[21]-J[22]+J[23]+J[24]-J[25]+J[26]-J[27]+J[28]+J[29]+J[30]-J[31]-J[32]+J[33]-J[34]+
    J[35]-J[36]-J[37]-J[38]-J[39]+J[40]-J[41]+J[42]-J[43]-J[44]+J[45]-J[46]+J[47]-J[48]+J[49]+J[50]-J[51]+
    J[52]-J[53]+J[54]+J[55]-J[56]+J[57]-J[58]-J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]-H[1]+H[2]-H[3]-H[4]+
    H[5]+H[6]-H[7]+H[8]-H[9]+H[10]-H[11]-J[0]+J[1]-J[2]-J[3]+J[4]+J[5]-J[6]+J[7]-J[8]+J[9]-J[10]-J[11]+J[12]+
    J[13]-J[14]-J[15]+J[16]-J[17]+J[18]-J[19]+J[20]-J[21]-J[22]+J[23]+J[24]-J[25]+J[26]-J[27]+J[28]-J[29]+
    J[30]-J[31]-J[32]+J[33]-J[34]+J[35]-J[36]+J[37]-J[38]-J[39]+J[40]-J[41]+J[42]-J[43]+J[44]+J[45]-J[46]+
    J[47]-J[48]+J[49]-J[50]-J[51]+J[52]-J[53]+J[54]-J[55]-J[56]+J[57]-J[58]+J[59]-J[60]+J[61]-J[62]-J[63]+
    J[64]-J[65], +H[0]-H[1]+H[2]-H[3]-H[4]+H[5]+H[6]-H[7]+H[8]-H[9]-H[10]+H[11]-J[0]+J[1]-J[2]-J[3]+J[4]+
    J[5]-J[6]+J[7]-J[8]-J[9]+J[10]-J[11]+J[12]+J[13]-J[14]-J[15]+J[16]-J[17]+J[18]+J[19]-J[20]-J[21]-J[22]+
    J[23]+J[24]-J[25]+J[26]-J[27]-J[28]+J[29]+J[30]-J[31]-J[32]+J[33]-J[34]+J[35]+J[36]-J[37]-J[38]-J[39]+
    J[40]-J[41]+J[42]+J[43]-J[44]+J[45]-J[46]+J[47]-J[48]-J[49]+J[50]-J[51]+J[52]-J[53]-J[54]+J[55]-J[56]+
    J[57]+J[58]-J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]-H[1]+H[2]-H[3]-H[4]+H[5]+H[6]-H[7]+H[8]-H[9]-H[10]-H[11]-J[0]+
    J[1]-J[2]-J[3]+J[4]+J[5]-J[6]+J[7]-J[8]-J[9]-J[10]-J[11]+J[12]+J[13]-J[14]-J[15]+J[16]-J[17]+J[18]+J[19]+
    J[20]-J[21]-J[22]+J[23]+J[24]-J[25]+J[26]-J[27]-J[28]-J[29]+J[30]-J[31]-J[32]+J[33]-J[34]+J[35]+J[36]+
    J[37]-J[38]-J[39]+J[40]-J[41]+J[42]+J[43]+J[44]+J[45]-J[46]+J[47]-J[48]-J[49]-J[50]-J[51]+J[52]-J[53]-J[54]-J[55]-J[56]+
    J[57]+J[58]+J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]-H[1]+H[2]-H[3]-H[4]+H[5]+H[6]-H[7]-H[8]+
    H[9]+H[10]+H[11]-J[0]+J[1]-J[2]-J[3]+J[4]+J[5]-J[6]-J[7]+J[8]+J[9]+J[10]-J[11]+J[12]+J[13]-J[14]-J[15]+
    J[16]+J[17]-J[18]-J[19]-J[20]-J[21]-J[22]+J[23]+J[24]-J[25]-J[26]+J[27]+J[28]+J[29]+J[30]-J[31]-J[32]+
    J[33]+J[34]-J[35]-J[36]-J[37]-J[38]-J[39]+J[40]+J[41]-J[42]-J[43]-J[44]+J[45]-J[46]-J[47]+J[48]+J[49]+
    J[50]-J[51]-J[52]+J[53]+J[54]+J[55]+J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]-H[1]+
    H[2]-H[3]-H[4]+H[5]+H[6]-H[7]-H[8]+H[9]+H[10]-H[11]-J[0]+J[1]-J[2]-J[3]+J[4]+J[5]-J[6]-J[7]+J[8]+J[9]-J[10]-J[11]+
    J[12]+J[13]-J[14]-J[15]+J[16]+J[17]-J[18]-J[19]+J[20]-J[21]-J[22]+J[23]+J[24]-J[25]-J[26]+J[27]+J[28]-J[29]+
    J[30]-J[31]-J[32]+J[33]+J[34]-J[35]-J[36]+J[37]-J[38]-J[39]+J[40]+J[41]-J[42]-J[43]+J[44]+J[45]-J[46]-J[47]+
    J[48]+J[49]-J[50]-J[51]-J[52]+J[53]+J[54]-J[55]+J[56]-J[57]-J[58]+J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +
    H[0]-H[1]+H[2]-H[3]-H[4]+H[5]+H[6]-H[7]-H[8]+H[9]-H[10]+H[11]-J[0]+J[1]-J[2]-J[3]+J[4]+J[5]-J[6]-J[7]+
    J[8]-J[9]+J[10]-J[11]+J[12]+J[13]-J[14]-J[15]+J[16]+J[17]-J[18]+J[19]-J[20]-J[21]-J[22]+J[23]+J[24]-J[25]-J[26]+
    J[27]-J[28]+J[29]+J[30]-J[31]-J[32]+J[33]+J[34]-J[35]+J[36]-J[37]-J[38]-J[39]+J[40]+J[41]-J[42]+J[43]-J[44]+
    J[45]-J[46]-J[47]+J[48]-J[49]+J[50]-J[51]-J[52]+J[53]-J[54]+J[55]+J[56]-J[57]+J[58]-J[59]-J[60]+J[61]-J[62]-J[63]+
    J[64]-J[65], +H[0]-H[1]+H[2]-H[3]-H[4]+H[5]+H[6]-H[7]-H[8]+H[9]-H[10]-H[11]-J[0]+J[1]-J[2]-J[3]+J[4]+
    J[5]-J[6]-J[7]+J[8]-J[9]-J[10]-J[11]+J[12]+J[13]-J[14]-J[15]+J[16]+J[17]-J[18]+J[19]+J[20]-J[21]-J[22]+
    J[23]+J[24]-J[25]-J[26]+J[27]-J[28]-J[29]+J[30]-J[31]-J[32]+J[33]+J[34]-J[35]+J[36]+J[37]-J[38]-J[39]+
    J[40]+J[41]-J[42]+J[43]+J[44]+J[45]-J[46]-J[47]+J[48]-J[49]-J[50]-J[51]-J[52]+J[53]-J[54]-J[55]+J[56]-J[57]+
    J[58]+J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]-H[1]+H[2]-H[3]-H[4]+H[5]+H[6]-H[7]-H[8]-H[9]+
    H[10]+H[11]-J[0]+J[1]-J[2]-J[3]+J[4]+J[5]-J[6]-J[7]-J[8]+J[9]+J[10]-J[11]+J[12]+J[13]-J[14]-J[15]+J[16]+
    J[17]+J[18]-J[19]-J[20]-J[21]-J[22]+J[23]+J[24]-J[25]-J[26]-J[27]+J[28]+J[29]+J[30]-J[31]-J[32]+J[33]+
    J[34]+J[35]-J[36]-J[37]-J[38]-J[39]+J[40]+J[41]+J[42]-J[43]-J[44]+J[45]-J[46]-J[47]-J[48]+J[49]+J[50]-J[51]-J[52]-J[53]+
    J[54]+J[55]+J[56]+J[57]-J[58]-J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]-H[1]+H[2]-H[3]-H[4]+H[5]+
    H[6]-H[7]-H[8]-H[9]+H[10]-H[11]-J[0]+J[1]-J[2]-J[3]+J[4]+J[5]-J[6]-J[7]-J[8]+J[9]-J[10]-J[11]+J[12]+
    J[13]-J[14]-J[15]+J[16]+J[17]+J[18]-J[19]+J[20]-J[21]-J[22]+J[23]+J[24]-J[25]-J[26]-J[27]+J[28]-J[29]+
    J[30]-J[31]-J[32]+J[33]+J[34]+J[35]-J[36]+J[37]-J[38]-J[39]+J[40]+J[41]+J[42]-J[43]+J[44]+J[45]-J[46]-J[47]-J[48]+
    J[49]-J[50]-J[51]-J[52]-J[53]+J[54]-J[55]+J[56]+J[57]-J[58]+J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +
    H[0]-H[1]+H[2]-H[3]-H[4]+H[5]+H[6]-H[7]-H[8]-H[9]-H[10]+H[11]-J[0]+J[1]-J[2]-J[3]+J[4]+J[5]-J[6]-J[7]-J[8]-J[9]+
    J[10]-J[11]+J[12]+J[13]-J[14]-J[15]+J[16]+J[17]+J[18]+J[19]-J[20]-J[21]-J[22]+J[23]+J[24]-J[25]-J[26]-J[27]-J[28]+
    J[29]+J[30]-J[31]-J[32]+J[33]+J[34]+J[35]+J[36]-J[37]-J[38]-J[39]+J[40]+J[41]+J[42]+J[43]-J[44]+J[45]-J[46]-J[47]-J[48]-J[49]+
    J[50]-J[51]-J[52]-J[53]-J[54]+J[55]+J[56]+J[57]+J[58]-J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]-H[1]+
    H[2]-H[3]-H[4]+H[5]+H[6]-H[7]-H[8]-H[9]-H[10]-H[11]-J[0]+J[1]-J[2]-J[3]+J[4]+J[5]-J[6]-J[7]-J[8]-J[9]-J[10]-J[11]+
    J[12]+J[13]-J[14]-J[15]+J[16]+J[17]+J[18]+J[19]+J[20]-J[21]-J[22]+J[23]+J[24]-J[25]-J[26]-J[27]-J[28]-J[29]+
    J[30]-J[31]-J[32]+J[33]+J[34]+J[35]+J[36]+J[37]-J[38]-J[39]+J[40]+J[41]+J[42]+J[43]+J[44]+J[45]-J[46]-J[47]-J[48]-J[49]-J[50]-J[51]-J[52]-J[53]-J[54]-J[55]+
    J[56]+J[57]+J[58]+J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]-H[1]+H[2]-H[3]-H[4]+H[5]-H[6]+H[7]+
    H[8]+H[9]+H[10]+H[11]-J[0]+J[1]-J[2]-J[3]+J[4]-J[5]+J[6]+J[7]+J[8]+J[9]+J[10]-J[11]+J[12]+J[13]-J[14]+
    J[15]-J[16]-J[17]-J[18]-J[19]-J[20]-J[21]-J[22]+J[23]-J[24]+J[25]+J[26]+J[27]+J[28]+J[29]+J[30]-J[31]+
    J[32]-J[33]-J[34]-J[35]-J[36]-J[37]-J[38]+J[39]-J[40]-J[41]-J[42]-J[43]-J[44]-J[45]+J[46]+J[47]+J[48]+
    J[49]+J[50]-J[51]-J[52]-J[53]-J[54]-J[55]+J[56]+J[57]+J[58]+J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +
    H[0]-H[1]+H[2]-H[3]-H[4]+H[5]-H[6]+H[7]+H[8]+H[9]+H[10]-H[11]-J[0]+J[1]-J[2]-J[3]+J[4]-J[5]+J[6]+J[7]+
    J[8]+J[9]-J[10]-J[11]+J[12]+J[13]-J[14]+J[15]-J[16]-J[17]-J[18]-J[19]+J[20]-J[21]-J[22]+J[23]-J[24]+
    J[25]+J[26]+J[27]+J[28]-J[29]+J[30]-J[31]+J[32]-J[33]-J[34]-J[35]-J[36]+J[37]-J[38]+J[39]-J[40]-J[41]-J[42]-J[43]+
    J[44]-J[45]+J[46]+J[47]+J[48]+J[49]-J[50]-J[51]-J[52]-J[53]-J[54]+J[55]+J[56]+J[57]+J[58]-J[59]+J[60]+
    J[61]-J[62]+J[63]-J[64]-J[65], +H[0]-H[1]+H[2]-H[3]-H[4]+H[5]-H[6]+H[7]+H[8]+H[9]-H[10]+H[11]-J[0]+J[1]-J[2]-J[3]+
    J[4]-J[5]+J[6]+J[7]+J[8]-J[9]+J[10]-J[11]+J[12]+J[13]-J[14]+J[15]-J[16]-J[17]-J[18]+J[19]-J[20]-J[21]-J[22]+
    J[23]-J[24]+J[25]+J[26]+J[27]-J[28]+J[29]+J[30]-J[31]+J[32]-J[33]-J[34]-J[35]+J[36]-J[37]-J[38]+J[39]-J[40]-J[41]-J[42]+
    J[43]-J[44]-J[45]+J[46]+J[47]+J[48]-J[49]+J[50]-J[51]-J[52]-J[53]+J[54]-J[55]+J[56]+J[57]-J[58]+J[59]+
    J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]-H[1]+H[2]-H[3]-H[4]+H[5]-H[6]+H[7]+H[8]+H[9]-H[10]-H[11]-J[0]+
    J[1]-J[2]-J[3]+J[4]-J[5]+J[6]+J[7]+J[8]-J[9]-J[10]-J[11]+J[12]+J[13]-J[14]+J[15]-J[16]-J[17]-J[18]+J[19]+
    J[20]-J[21]-J[22]+J[23]-J[24]+J[25]+J[26]+J[27]-J[28]-J[29]+J[30]-J[31]+J[32]-J[33]-J[34]-J[35]+J[36]+
    J[37]-J[38]+J[39]-J[40]-J[41]-J[42]+J[43]+J[44]-J[45]+J[46]+J[47]+J[48]-J[49]-J[50]-J[51]-J[52]-J[53]+
    J[54]+J[55]+J[56]+J[57]-J[58]-J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]-H[1]+H[2]-H[3]-H[4]+H[5]-H[6]+
    H[7]+H[8]-H[9]+H[10]+H[11]-J[0]+J[1]-J[2]-J[3]+J[4]-J[5]+J[6]+J[7]-J[8]+J[9]+J[10]-J[11]+J[12]+J[13]-J[14]+
    J[15]-J[16]-J[17]+J[18]-J[19]-J[20]-J[21]-J[22]+J[23]-J[24]+J[25]+J[26]-J[27]+J[28]+J[29]+J[30]-J[31]+
    J[32]-J[33]-J[34]+J[35]-J[36]-J[37]-J[38]+J[39]-J[40]-J[41]+J[42]-J[43]-J[44]-J[45]+J[46]+J[47]-J[48]+
    J[49]+J[50]-J[51]-J[52]+J[53]-J[54]-J[55]+J[56]-J[57]+J[58]+J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +
    H[0]-H[1]+H[2]-H[3]-H[4]+H[5]-H[6]+H[7]+H[8]-H[9]+H[10]-H[11]-J[0]+J[1]-J[2]-J[3]+J[4]-J[5]+J[6]+J[7]-J[8]+
    J[9]-J[10]-J[11]+J[12]+J[13]-J[14]+J[15]-J[16]-J[17]+J[18]-J[19]+J[20]-J[21]-J[22]+J[23]-J[24]+J[25]+
    J[26]-J[27]+J[28]-J[29]+J[30]-J[31]+J[32]-J[33]-J[34]+J[35]-J[36]+J[37]-J[38]+J[39]-J[40]-J[41]+J[42]-J[43]+
    J[44]-J[45]+J[46]+J[47]-J[48]+J[49]-J[50]-J[51]-J[52]+J[53]-J[54]+J[55]+J[56]-J[57]+J[58]-J[59]-J[60]+
    J[61]-J[62]-J[63]+J[64]-J[65], +H[0]-H[1]+H[2]-H[3]-H[4]+H[5]-H[6]+H[7]+H[8]-H[9]-H[10]+H[11]-J[0]+J[1]-J[2]-J[3]+
    J[4]-J[5]+J[6]+J[7]-J[8]-J[9]+J[10]-J[11]+J[12]+J[13]-J[14]+J[15]-J[16]-J[17]+J[18]+J[19]-J[20]-J[21]-J[22]+
    J[23]-J[24]+J[25]+J[26]-J[27]-J[28]+J[29]+J[30]-J[31]+J[32]-J[33]-J[34]+J[35]+J[36]-J[37]-J[38]+J[39]-J[40]-J[41]+
    J[42]+J[43]-J[44]-J[45]+J[46]+J[47]-J[48]-J[49]+J[50]-J[51]-J[52]+J[53]+J[54]-J[55]+J[56]-J[57]-J[58]+
    J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]-H[1]+H[2]-H[3]-H[4]+H[5]-H[6]+H[7]+H[8]-H[9]-H[10]-H[11]-J[0]+
    J[1]-J[2]-J[3]+J[4]-J[5]+J[6]+J[7]-J[8]-J[9]-J[10]-J[11]+J[12]+J[13]-J[14]+J[15]-J[16]-J[17]+J[18]+J[19]+
    J[20]-J[21]-J[22]+J[23]-J[24]+J[25]+J[26]-J[27]-J[28]-J[29]+J[30]-J[31]+J[32]-J[33]-J[34]+J[35]+J[36]+
    J[37]-J[38]+J[39]-J[40]-J[41]+J[42]+J[43]+J[44]-J[45]+J[46]+J[47]-J[48]-J[49]-J[50]-J[51]-J[52]+J[53]+
    J[54]+J[55]+J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]-H[1]+H[2]-H[3]-H[4]+H[5]-H[6]+
    H[7]-H[8]+H[9]+H[10]+H[11]-J[0]+J[1]-J[2]-J[3]+J[4]-J[5]+J[6]-J[7]+J[8]+J[9]+J[10]-J[11]+J[12]+J[13]-J[14]+
    J[15]-J[16]+J[17]-J[18]-J[19]-J[20]-J[21]-J[22]+J[23]-J[24]+J[25]-J[26]+J[27]+J[28]+J[29]+J[30]-J[31]+
    J[32]-J[33]+J[34]-J[35]-J[36]-J[37]-J[38]+J[39]-J[40]+J[41]-J[42]-J[43]-J[44]-J[45]+J[46]-J[47]+J[48]+
    J[49]+J[50]-J[51]+J[52]-J[53]-J[54]-J[55]-J[56]+J[57]+J[58]+J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +
    H[0]-H[1]+H[2]-H[3]-H[4]+H[5]-H[6]+H[7]-H[8]+H[9]+H[10]-H[11]-J[0]+J[1]-J[2]-J[3]+J[4]-J[5]+J[6]-J[7]+
    J[8]+J[9]-J[10]-J[11]+J[12]+J[13]-J[14]+J[15]-J[16]+J[17]-J[18]-J[19]+J[20]-J[21]-J[22]+J[23]-J[24]+
    J[25]-J[26]+J[27]+J[28]-J[29]+J[30]-J[31]+J[32]-J[33]+J[34]-J[35]-J[36]+J[37]-J[38]+J[39]-J[40]+J[41]-J[42]-J[43]+
    J[44]-J[45]+J[46]-J[47]+J[48]+J[49]-J[50]-J[51]+J[52]-J[53]-J[54]+J[55]-J[56]+J[57]+J[58]-J[59]-J[60]-J[61]+
    J[62]+J[63]-J[64]-J[65], +H[0]-H[1]+H[2]-H[3]-H[4]+H[5]-H[6]+H[7]-H[8]+H[9]-H[10]+H[11]-J[0]+J[1]-J[2]-J[3]+
    J[4]-J[5]+J[6]-J[7]+J[8]-J[9]+J[10]-J[11]+J[12]+J[13]-J[14]+J[15]-J[16]+J[17]-J[18]+J[19]-J[20]-J[21]-J[22]+
    J[23]-J[24]+J[25]-J[26]+J[27]-J[28]+J[29]+J[30]-J[31]+J[32]-J[33]+J[34]-J[35]+J[36]-J[37]-J[38]+J[39]-J[40]+
    J[41]-J[42]+J[43]-J[44]-J[45]+J[46]-J[47]+J[48]-J[49]+J[50]-J[51]+J[52]-J[53]+J[54]-J[55]-J[56]+J[57]-J[58]+
    J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]-H[1]+H[2]-H[3]-H[4]+H[5]-H[6]+H[7]-H[8]+H[9]-H[10]-H[11]-J[0]+
    J[1]-J[2]-J[3]+J[4]-J[5]+J[6]-J[7]+J[8]-J[9]-J[10]-J[11]+J[12]+J[13]-J[14]+J[15]-J[16]+J[17]-J[18]+J[19]+
    J[20]-J[21]-J[22]+J[23]-J[24]+J[25]-J[26]+J[27]-J[28]-J[29]+J[30]-J[31]+J[32]-J[33]+J[34]-J[35]+J[36]+
    J[37]-J[38]+J[39]-J[40]+J[41]-J[42]+J[43]+J[44]-J[45]+J[46]-J[47]+J[48]-J[49]-J[50]-J[51]+J[52]-J[53]+
    J[54]+J[55]-J[56]+J[57]-J[58]-J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]-H[1]+H[2]-H[3]-H[4]+H[5]-H[6]+
    H[7]-H[8]-H[9]+H[10]+H[11]-J[0]+J[1]-J[2]-J[3]+J[4]-J[5]+J[6]-J[7]-J[8]+J[9]+J[10]-J[11]+J[12]+J[13]-J[14]+
    J[15]-J[16]+J[17]+J[18]-J[19]-J[20]-J[21]-J[22]+J[23]-J[24]+J[25]-J[26]-J[27]+J[28]+J[29]+J[30]-J[31]+
    J[32]-J[33]+J[34]+J[35]-J[36]-J[37]-J[38]+J[39]-J[40]+J[41]+J[42]-J[43]-J[44]-J[45]+J[46]-J[47]-J[48]+
    J[49]+J[50]-J[51]+J[52]+J[53]-J[54]-J[55]-J[56]-J[57]+J[58]+J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +
    H[0]-H[1]+H[2]-H[3]-H[4]+H[5]-H[6]+H[7]-H[8]-H[9]+H[10]-H[11]-J[0]+J[1]-J[2]-J[3]+J[4]-J[5]+J[6]-J[7]-J[8]+
    J[9]-J[10]-J[11]+J[12]+J[13]-J[14]+J[15]-J[16]+J[17]+J[18]-J[19]+J[20]-J[21]-J[22]+J[23]-J[24]+J[25]-J[26]-J[27]+
    J[28]-J[29]+J[30]-J[31]+J[32]-J[33]+J[34]+J[35]-J[36]+J[37]-J[38]+J[39]-J[40]+J[41]+J[42]-J[43]+J[44]-J[45]+
    J[46]-J[47]-J[48]+J[49]-J[50]-J[51]+J[52]+J[53]-J[54]+J[55]-J[56]-J[57]+J[58]-J[59]+J[60]-J[61]+J[62]-J[63]+
    J[64]-J[65], +H[0]-H[1]+H[2]-H[3]-H[4]+H[5]-H[6]+H[7]-H[8]-H[9]-H[10]+H[11]-J[0]+J[1]-J[2]-J[3]+J[4]-J[5]+
    J[6]-J[7]-J[8]-J[9]+J[10]-J[11]+J[12]+J[13]-J[14]+J[15]-J[16]+J[17]+J[18]+J[19]-J[20]-J[21]-J[22]+J[23]-J[24]+
    J[25]-J[26]-J[27]-J[28]+J[29]+J[30]-J[31]+J[32]-J[33]+J[34]+J[35]+J[36]-J[37]-J[38]+J[39]-J[40]+J[41]+
    J[42]+J[43]-J[44]-J[45]+J[46]-J[47]-J[48]-J[49]+J[50]-J[51]+J[52]+J[53]+J[54]-J[55]-J[56]-J[57]-J[58]+
    J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]-H[1]+H[2]-H[3]-H[4]+H[5]-H[6]+H[7]-H[8]-H[9]-H[10]-H[11]-J[0]+
    J[1]-J[2]-J[3]+J[4]-J[5]+J[6]-J[7]-J[8]-J[9]-J[10]-J[11]+J[12]+J[13]-J[14]+J[15]-J[16]+J[17]+J[18]+J[19]+
    J[20]-J[21]-J[22]+J[23]-J[24]+J[25]-J[26]-J[27]-J[28]-J[29]+J[30]-J[31]+J[32]-J[33]+J[34]+J[35]+J[36]+
    J[37]-J[38]+J[39]-J[40]+J[41]+J[42]+J[43]+J[44]-J[45]+J[46]-J[47]-J[48]-J[49]-J[50]-J[51]+J[52]+J[53]+
    J[54]+J[55]-J[56]-J[57]-J[58]-J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]-H[1]+H[2]-H[3]-H[4]+H[5]-H[6]-H[7]+
    H[8]+H[9]+H[10]+H[11]-J[0]+J[1]-J[2]-J[3]+J[4]-J[5]-J[6]+J[7]+J[8]+J[9]+J[10]-J[11]+J[12]+J[13]-J[14]+
    J[15]+J[16]-J[17]-J[18]-J[19]-J[20]-J[21]-J[22]+J[23]-J[24]-J[25]+J[26]+J[27]+J[28]+J[29]+J[30]-J[31]+
    J[32]+J[33]-J[34]-J[35]-J[36]-J[37]-J[38]+J[39]+J[40]-J[41]-J[42]-J[43]-J[44]-J[45]-J[46]+J[47]+J[48]+
    J[49]+J[50]+J[51]-J[52]-J[53]-J[54]-J[55]-J[56]-J[57]-J[58]-J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +
    H[0]-H[1]+H[2]-H[3]-H[4]+H[5]-H[6]-H[7]+H[8]+H[9]+H[10]-H[11]-J[0]+J[1]-J[2]-J[3]+J[4]-J[5]-J[6]+J[7]+
    J[8]+J[9]-J[10]-J[11]+J[12]+J[13]-J[14]+J[15]+J[16]-J[17]-J[18]-J[19]+J[20]-J[21]-J[22]+J[23]-J[24]-J[25]+
    J[26]+J[27]+J[28]-J[29]+J[30]-J[31]+J[32]+J[33]-J[34]-J[35]-J[36]+J[37]-J[38]+J[39]+J[40]-J[41]-J[42]-J[43]+
    J[44]-J[45]-J[46]+J[47]+J[48]+J[49]-J[50]+J[51]-J[52]-J[53]-J[54]+J[55]-J[56]-J[57]-J[58]+J[59]+J[60]+
    J[61]-J[62]+J[63]-J[64]-J[65], +H[0]-H[1]+H[2]-H[3]-H[4]+H[5]-H[6]-H[7]+H[8]+H[9]-H[10]+H[11]-J[0]+J[1]-J[2]-J[3]+
    J[4]-J[5]-J[6]+J[7]+J[8]-J[9]+J[10]-J[11]+J[12]+J[13]-J[14]+J[15]+J[16]-J[17]-J[18]+J[19]-J[20]-J[21]-J[22]+
    J[23]-J[24]-J[25]+J[26]+J[27]-J[28]+J[29]+J[30]-J[31]+J[32]+J[33]-J[34]-J[35]+J[36]-J[37]-J[38]+J[39]+
    J[40]-J[41]-J[42]+J[43]-J[44]-J[45]-J[46]+J[47]+J[48]-J[49]+J[50]+J[51]-J[52]-J[53]+J[54]-J[55]-J[56]-J[57]+
    J[58]-J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]-H[1]+H[2]-H[3]-H[4]+H[5]-H[6]-H[7]+H[8]+H[9]-H[10]-H[11]-J[0]+
    J[1]-J[2]-J[3]+J[4]-J[5]-J[6]+J[7]+J[8]-J[9]-J[10]-J[11]+J[12]+J[13]-J[14]+J[15]+J[16]-J[17]-J[18]+J[19]+
    J[20]-J[21]-J[22]+J[23]-J[24]-J[25]+J[26]+J[27]-J[28]-J[29]+J[30]-J[31]+J[32]+J[33]-J[34]-J[35]+J[36]+
    J[37]-J[38]+J[39]+J[40]-J[41]-J[42]+J[43]+J[44]-J[45]-J[46]+J[47]+J[48]-J[49]-J[50]+J[51]-J[52]-J[53]+
    J[54]+J[55]-J[56]-J[57]+J[58]+J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]-H[1]+H[2]-H[3]-H[4]+H[5]-H[6]-H[7]+
    H[8]-H[9]+H[10]+H[11]-J[0]+J[1]-J[2]-J[3]+J[4]-J[5]-J[6]+J[7]-J[8]+J[9]+J[10]-J[11]+J[12]+J[13]-J[14]+
    J[15]+J[16]-J[17]+J[18]-J[19]-J[20]-J[21]-J[22]+J[23]-J[24]-J[25]+J[26]-J[27]+J[28]+J[29]+J[30]-J[31]+
    J[32]+J[33]-J[34]+J[35]-J[36]-J[37]-J[38]+J[39]+J[40]-J[41]+J[42]-J[43]-J[44]-J[45]-J[46]+J[47]-J[48]+
    J[49]+J[50]+J[51]-J[52]+J[53]-J[54]-J[55]-J[56]+J[57]-J[58]-J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +
    H[0]-H[1]+H[2]-H[3]-H[4]+H[5]-H[6]-H[7]+H[8]-H[9]+H[10]-H[11]-J[0]+J[1]-J[2]-J[3]+J[4]-J[5]-J[6]+J[7]-J[8]+
    J[9]-J[10]-J[11]+J[12]+J[13]-J[14]+J[15]+J[16]-J[17]+J[18]-J[19]+J[20]-J[21]-J[22]+J[23]-J[24]-J[25]+
    J[26]-J[27]+J[28]-J[29]+J[30]-J[31]+J[32]+J[33]-J[34]+J[35]-J[36]+J[37]-J[38]+J[39]+J[40]-J[41]+J[42]-J[43]+
    J[44]-J[45]-J[46]+J[47]-J[48]+J[49]-J[50]+J[51]-J[52]+J[53]-J[54]+J[55]-J[56]+J[57]-J[58]+J[59]-J[60]+
    J[61]-J[62]-J[63]+J[64]-J[65], +H[0]-H[1]+H[2]-H[3]-H[4]+H[5]-H[6]-H[7]+H[8]-H[9]-H[10]+H[11]-J[0]+J[1]-J[2]-J[3]+
    J[4]-J[5]-J[6]+J[7]-J[8]-J[9]+J[10]-J[11]+J[12]+J[13]-J[14]+J[15]+J[16]-J[17]+J[18]+J[19]-J[20]-J[21]-J[22]+
    J[23]-J[24]-J[25]+J[26]-J[27]-J[28]+J[29]+J[30]-J[31]+J[32]+J[33]-J[34]+J[35]+J[36]-J[37]-J[38]+J[39]+
    J[40]-J[41]+J[42]+J[43]-J[44]-J[45]-J[46]+J[47]-J[48]-J[49]+J[50]+J[51]-J[52]+J[53]+J[54]-J[55]-J[56]+
    J[57]+J[58]-J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]-H[1]+H[2]-H[3]-H[4]+H[5]-H[6]-H[7]+H[8]-H[9]-H[10]-H[11]-J[0]+
    J[1]-J[2]-J[3]+J[4]-J[5]-J[6]+J[7]-J[8]-J[9]-J[10]-J[11]+J[12]+J[13]-J[14]+J[15]+J[16]-J[17]+J[18]+J[19]+
    J[20]-J[21]-J[22]+J[23]-J[24]-J[25]+J[26]-J[27]-J[28]-J[29]+J[30]-J[31]+J[32]+J[33]-J[34]+J[35]+J[36]+
    J[37]-J[38]+J[39]+J[40]-J[41]+J[42]+J[43]+J[44]-J[45]-J[46]+J[47]-J[48]-J[49]-J[50]+J[51]-J[52]+J[53]+
    J[54]+J[55]-J[56]+J[57]+J[58]+J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]-H[1]+H[2]-H[3]-H[4]+H[5]-H[6]-H[7]-H[8]+
    H[9]+H[10]+H[11]-J[0]+J[1]-J[2]-J[3]+J[4]-J[5]-J[6]-J[7]+J[8]+J[9]+J[10]-J[11]+J[12]+J[13]-J[14]+J[15]+
    J[16]+J[17]-J[18]-J[19]-J[20]-J[21]-J[22]+J[23]-J[24]-J[25]-J[26]+J[27]+J[28]+J[29]+J[30]-J[31]+J[32]+
    J[33]+J[34]-J[35]-J[36]-J[37]-J[38]+J[39]+J[40]+J[41]-J[42]-J[43]-J[44]-J[45]-J[46]-J[47]+J[48]+J[49]+
    J[50]+J[51]+J[52]-J[53]-J[54]-J[55]+J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]-H[1]+
    H[2]-H[3]-H[4]+H[5]-H[6]-H[7]-H[8]+H[9]+H[10]-H[11]-J[0]+J[1]-J[2]-J[3]+J[4]-J[5]-J[6]-J[7]+J[8]+J[9]-J[10]-J[11]+
    J[12]+J[13]-J[14]+J[15]+J[16]+J[17]-J[18]-J[19]+J[20]-J[21]-J[22]+J[23]-J[24]-J[25]-J[26]+J[27]+J[28]-J[29]+
    J[30]-J[31]+J[32]+J[33]+J[34]-J[35]-J[36]+J[37]-J[38]+J[39]+J[40]+J[41]-J[42]-J[43]+J[44]-J[45]-J[46]-J[47]+
    J[48]+J[49]-J[50]+J[51]+J[52]-J[53]-J[54]+J[55]+J[56]-J[57]-J[58]+J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +
    H[0]-H[1]+H[2]-H[3]-H[4]+H[5]-H[6]-H[7]-H[8]+H[9]-H[10]+H[11]-J[0]+J[1]-J[2]-J[3]+J[4]-J[5]-J[6]-J[7]+
    J[8]-J[9]+J[10]-J[11]+J[12]+J[13]-J[14]+J[15]+J[16]+J[17]-J[18]+J[19]-J[20]-J[21]-J[22]+J[23]-J[24]-J[25]-J[26]+
    J[27]-J[28]+J[29]+J[30]-J[31]+J[32]+J[33]+J[34]-J[35]+J[36]-J[37]-J[38]+J[39]+J[40]+J[41]-J[42]+J[43]-J[44]-J[45]-J[46]-J[47]+
    J[48]-J[49]+J[50]+J[51]+J[52]-J[53]+J[54]-J[55]+J[56]-J[57]+J[58]-J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +
    H[0]-H[1]+H[2]-H[3]-H[4]+H[5]-H[6]-H[7]-H[8]+H[9]-H[10]-H[11]-J[0]+J[1]-J[2]-J[3]+J[4]-J[5]-J[6]-J[7]+
    J[8]-J[9]-J[10]-J[11]+J[12]+J[13]-J[14]+J[15]+J[16]+J[17]-J[18]+J[19]+J[20]-J[21]-J[22]+J[23]-J[24]-J[25]-J[26]+
    J[27]-J[28]-J[29]+J[30]-J[31]+J[32]+J[33]+J[34]-J[35]+J[36]+J[37]-J[38]+J[39]+J[40]+J[41]-J[42]+J[43]+
    J[44]-J[45]-J[46]-J[47]+J[48]-J[49]-J[50]+J[51]+J[52]-J[53]+J[54]+J[55]+J[56]-J[57]+J[58]+J[59]-J[60]+
    J[61]+J[62]-J[63]-J[64]+J[65], +H[0]-H[1]+H[2]-H[3]-H[4]+H[5]-H[6]-H[7]-H[8]-H[9]+H[10]+H[11]-J[0]+J[1]-J[2]-J[3]+
    J[4]-J[5]-J[6]-J[7]-J[8]+J[9]+J[10]-J[11]+J[12]+J[13]-J[14]+J[15]+J[16]+J[17]+J[18]-J[19]-J[20]-J[21]-J[22]+
    J[23]-J[24]-J[25]-J[26]-J[27]+J[28]+J[29]+J[30]-J[31]+J[32]+J[33]+J[34]+J[35]-J[36]-J[37]-J[38]+J[39]+
    J[40]+J[41]+J[42]-J[43]-J[44]-J[45]-J[46]-J[47]-J[48]+J[49]+J[50]+J[51]+J[52]+J[53]-J[54]-J[55]+J[56]+
    J[57]-J[58]-J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]-H[1]+H[2]-H[3]-H[4]+H[5]-H[6]-H[7]-H[8]-H[9]+
    H[10]-H[11]-J[0]+J[1]-J[2]-J[3]+J[4]-J[5]-J[6]-J[7]-J[8]+J[9]-J[10]-J[11]+J[12]+J[13]-J[14]+J[15]+J[16]+
    J[17]+J[18]-J[19]+J[20]-J[21]-J[22]+J[23]-J[24]-J[25]-J[26]-J[27]+J[28]-J[29]+J[30]-J[31]+J[32]+J[33]+
    J[34]+J[35]-J[36]+J[37]-J[38]+J[39]+J[40]+J[41]+J[42]-J[43]+J[44]-J[45]-J[46]-J[47]-J[48]+J[49]-J[50]+
    J[51]+J[52]+J[53]-J[54]+J[55]+J[56]+J[57]-J[58]+J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]-H[1]+
    H[2]-H[3]-H[4]+H[5]-H[6]-H[7]-H[8]-H[9]-H[10]+H[11]-J[0]+J[1]-J[2]-J[3]+J[4]-J[5]-J[6]-J[7]-J[8]-J[9]+
    J[10]-J[11]+J[12]+J[13]-J[14]+J[15]+J[16]+J[17]+J[18]+J[19]-J[20]-J[21]-J[22]+J[23]-J[24]-J[25]-J[26]-J[27]-J[28]+
    J[29]+J[30]-J[31]+J[32]+J[33]+J[34]+J[35]+J[36]-J[37]-J[38]+J[39]+J[40]+J[41]+J[42]+J[43]-J[44]-J[45]-J[46]-J[47]-J[48]-J[49]+
    J[50]+J[51]+J[52]+J[53]+J[54]-J[55]+J[56]+J[57]+J[58]-J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]-H[1]+
    H[2]-H[3]-H[4]+H[5]-H[6]-H[7]-H[8]-H[9]-H[10]-H[11]-J[0]+J[1]-J[2]-J[3]+J[4]-J[5]-J[6]-J[7]-J[8]-J[9]-J[10]-J[11]+
    J[12]+J[13]-J[14]+J[15]+J[16]+J[17]+J[18]+J[19]+J[20]-J[21]-J[22]+J[23]-J[24]-J[25]-J[26]-J[27]-J[28]-J[29]+
    J[30]-J[31]+J[32]+J[33]+J[34]+J[35]+J[36]+J[37]-J[38]+J[39]+J[40]+J[41]+J[42]+J[43]+J[44]-J[45]-J[46]-J[47]-J[48]-J[49]-J[50]+
    J[51]+J[52]+J[53]+J[54]+J[55]+J[56]+J[57]+J[58]+J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]-H[1]+
    H[2]-H[3]-H[4]-H[5]+H[6]+H[7]+H[8]+H[9]+H[10]+H[11]-J[0]+J[1]-J[2]-J[3]-J[4]+J[5]+J[6]+J[7]+J[8]+J[9]+
    J[10]-J[11]+J[12]+J[13]+J[14]-J[15]-J[16]-J[17]-J[18]-J[19]-J[20]-J[21]-J[22]-J[23]+J[24]+J[25]+J[26]+
    J[27]+J[28]+J[29]+J[30]+J[31]-J[32]-J[33]-J[34]-J[35]-J[36]-J[37]+J[38]-J[39]-J[40]-J[41]-J[42]-J[43]-J[44]-J[45]-J[46]-J[47]-J[48]-J[49]-J[50]+
    J[51]+J[52]+J[53]+J[54]+J[55]+J[56]+J[57]+J[58]+J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]-H[1]+
    H[2]-H[3]-H[4]-H[5]+H[6]+H[7]+H[8]+H[9]+H[10]-H[11]-J[0]+J[1]-J[2]-J[3]-J[4]+J[5]+J[6]+J[7]+J[8]+J[9]-J[10]-J[11]+
    J[12]+J[13]+J[14]-J[15]-J[16]-J[17]-J[18]-J[19]+J[20]-J[21]-J[22]-J[23]+J[24]+J[25]+J[26]+J[27]+J[28]-J[29]+
    J[30]+J[31]-J[32]-J[33]-J[34]-J[35]-J[36]+J[37]+J[38]-J[39]-J[40]-J[41]-J[42]-J[43]+J[44]-J[45]-J[46]-J[47]-J[48]-J[49]+
    J[50]+J[51]+J[52]+J[53]+J[54]-J[55]+J[56]+J[57]+J[58]-J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]-H[1]+
    H[2]-H[3]-H[4]-H[5]+H[6]+H[7]+H[8]+H[9]-H[10]+H[11]-J[0]+J[1]-J[2]-J[3]-J[4]+J[5]+J[6]+J[7]+J[8]-J[9]+
    J[10]-J[11]+J[12]+J[13]+J[14]-J[15]-J[16]-J[17]-J[18]+J[19]-J[20]-J[21]-J[22]-J[23]+J[24]+J[25]+J[26]+
    J[27]-J[28]+J[29]+J[30]+J[31]-J[32]-J[33]-J[34]-J[35]+J[36]-J[37]+J[38]-J[39]-J[40]-J[41]-J[42]+J[43]-J[44]-J[45]-J[46]-J[47]-J[48]+
    J[49]-J[50]+J[51]+J[52]+J[53]-J[54]+J[55]+J[56]+J[57]-J[58]+J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +
    H[0]-H[1]+H[2]-H[3]-H[4]-H[5]+H[6]+H[7]+H[8]+H[9]-H[10]-H[11]-J[0]+J[1]-J[2]-J[3]-J[4]+J[5]+J[6]+J[7]+
    J[8]-J[9]-J[10]-J[11]+J[12]+J[13]+J[14]-J[15]-J[16]-J[17]-J[18]+J[19]+J[20]-J[21]-J[22]-J[23]+J[24]+
    J[25]+J[26]+J[27]-J[28]-J[29]+J[30]+J[31]-J[32]-J[33]-J[34]-J[35]+J[36]+J[37]+J[38]-J[39]-J[40]-J[41]-J[42]+
    J[43]+J[44]-J[45]-J[46]-J[47]-J[48]+J[49]+J[50]+J[51]+J[52]+J[53]-J[54]-J[55]+J[56]+J[57]-J[58]-J[59]+
    J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]-H[1]+H[2]-H[3]-H[4]-H[5]+H[6]+H[7]+H[8]-H[9]+H[10]+H[11]-J[0]+
    J[1]-J[2]-J[3]-J[4]+J[5]+J[6]+J[7]-J[8]+J[9]+J[10]-J[11]+J[12]+J[13]+J[14]-J[15]-J[16]-J[17]+J[18]-J[19]-J[20]-J[21]-J[22]-J[23]+
    J[24]+J[25]+J[26]-J[27]+J[28]+J[29]+J[30]+J[31]-J[32]-J[33]-J[34]+J[35]-J[36]-J[37]+J[38]-J[39]-J[40]-J[41]+
    J[42]-J[43]-J[44]-J[45]-J[46]-J[47]+J[48]-J[49]-J[50]+J[51]+J[52]-J[53]+J[54]+J[55]+J[56]-J[57]+J[58]+
    J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]-H[1]+H[2]-H[3]-H[4]-H[5]+H[6]+H[7]+H[8]-H[9]+H[10]-H[11]-J[0]+
    J[1]-J[2]-J[3]-J[4]+J[5]+J[6]+J[7]-J[8]+J[9]-J[10]-J[11]+J[12]+J[13]+J[14]-J[15]-J[16]-J[17]+J[18]-J[19]+
    J[20]-J[21]-J[22]-J[23]+J[24]+J[25]+J[26]-J[27]+J[28]-J[29]+J[30]+J[31]-J[32]-J[33]-J[34]+J[35]-J[36]+
    J[37]+J[38]-J[39]-J[40]-J[41]+J[42]-J[43]+J[44]-J[45]-J[46]-J[47]+J[48]-J[49]+J[50]+J[51]+J[52]-J[53]+
    J[54]-J[55]+J[56]-J[57]+J[58]-J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]-H[1]+H[2]-H[3]-H[4]-H[5]+
    H[6]+H[7]+H[8]-H[9]-H[10]+H[11]-J[0]+J[1]-J[2]-J[3]-J[4]+J[5]+J[6]+J[7]-J[8]-J[9]+J[10]-J[11]+J[12]+
    J[13]+J[14]-J[15]-J[16]-J[17]+J[18]+J[19]-J[20]-J[21]-J[22]-J[23]+J[24]+J[25]+J[26]-J[27]-J[28]+J[29]+
    J[30]+J[31]-J[32]-J[33]-J[34]+J[35]+J[36]-J[37]+J[38]-J[39]-J[40]-J[41]+J[42]+J[43]-J[44]-J[45]-J[46]-J[47]+
    J[48]+J[49]-J[50]+J[51]+J[52]-J[53]-J[54]+J[55]+J[56]-J[57]-J[58]+J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +
    H[0]-H[1]+H[2]-H[3]-H[4]-H[5]+H[6]+H[7]+H[8]-H[9]-H[10]-H[11]-J[0]+J[1]-J[2]-J[3]-J[4]+J[5]+J[6]+J[7]-J[8]-J[9]-J[10]-J[11]+
    J[12]+J[13]+J[14]-J[15]-J[16]-J[17]+J[18]+J[19]+J[20]-J[21]-J[22]-J[23]+J[24]+J[25]+J[26]-J[27]-J[28]-J[29]+
    J[30]+J[31]-J[32]-J[33]-J[34]+J[35]+J[36]+J[37]+J[38]-J[39]-J[40]-J[41]+J[42]+J[43]+J[44]-J[45]-J[46]-J[47]+
    J[48]+J[49]+J[50]+J[51]+J[52]-J[53]-J[54]-J[55]+J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+
    J[65], +H[0]-H[1]+H[2]-H[3]-H[4]-H[5]+H[6]+H[7]-H[8]+H[9]+H[10]+H[11]-J[0]+J[1]-J[2]-J[3]-J[4]+J[5]+
    J[6]-J[7]+J[8]+J[9]+J[10]-J[11]+J[12]+J[13]+J[14]-J[15]-J[16]+J[17]-J[18]-J[19]-J[20]-J[21]-J[22]-J[23]+
    J[24]+J[25]-J[26]+J[27]+J[28]+J[29]+J[30]+J[31]-J[32]-J[33]+J[34]-J[35]-J[36]-J[37]+J[38]-J[39]-J[40]+
    J[41]-J[42]-J[43]-J[44]-J[45]-J[46]+J[47]-J[48]-J[49]-J[50]+J[51]-J[52]+J[53]+J[54]+J[55]-J[56]+J[57]+
    J[58]+J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]-H[1]+H[2]-H[3]-H[4]-H[5]+H[6]+H[7]-H[8]+H[9]+
    H[10]-H[11]-J[0]+J[1]-J[2]-J[3]-J[4]+J[5]+J[6]-J[7]+J[8]+J[9]-J[10]-J[11]+J[12]+J[13]+J[14]-J[15]-J[16]+
    J[17]-J[18]-J[19]+J[20]-J[21]-J[22]-J[23]+J[24]+J[25]-J[26]+J[27]+J[28]-J[29]+J[30]+J[31]-J[32]-J[33]+
    J[34]-J[35]-J[36]+J[37]+J[38]-J[39]-J[40]+J[41]-J[42]-J[43]+J[44]-J[45]-J[46]+J[47]-J[48]-J[49]+J[50]+
    J[51]-J[52]+J[53]+J[54]-J[55]-J[56]+J[57]+J[58]-J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]-H[1]+
    H[2]-H[3]-H[4]-H[5]+H[6]+H[7]-H[8]+H[9]-H[10]+H[11]-J[0]+J[1]-J[2]-J[3]-J[4]+J[5]+J[6]-J[7]+J[8]-J[9]+
    J[10]-J[11]+J[12]+J[13]+J[14]-J[15]-J[16]+J[17]-J[18]+J[19]-J[20]-J[21]-J[22]-J[23]+J[24]+J[25]-J[26]+
    J[27]-J[28]+J[29]+J[30]+J[31]-J[32]-J[33]+J[34]-J[35]+J[36]-J[37]+J[38]-J[39]-J[40]+J[41]-J[42]+J[43]-J[44]-J[45]-J[46]+
    J[47]-J[48]+J[49]-J[50]+J[51]-J[52]+J[53]-J[54]+J[55]-J[56]+J[57]-J[58]+J[59]-J[60]+J[61]-J[62]-J[63]+
    J[64]-J[65], +H[0]-H[1]+H[2]-H[3]-H[4]-H[5]+H[6]+H[7]-H[8]+H[9]-H[10]-H[11]-J[0]+J[1]-J[2]-J[3]-J[4]+
    J[5]+J[6]-J[7]+J[8]-J[9]-J[10]-J[11]+J[12]+J[13]+J[14]-J[15]-J[16]+J[17]-J[18]+J[19]+J[20]-J[21]-J[22]-J[23]+
    J[24]+J[25]-J[26]+J[27]-J[28]-J[29]+J[30]+J[31]-J[32]-J[33]+J[34]-J[35]+J[36]+J[37]+J[38]-J[39]-J[40]+
    J[41]-J[42]+J[43]+J[44]-J[45]-J[46]+J[47]-J[48]+J[49]+J[50]+J[51]-J[52]+J[53]-J[54]-J[55]-J[56]+J[57]-J[58]-J[59]-J[60]+
    J[61]+J[62]-J[63]-J[64]+J[65], +H[0]-H[1]+H[2]-H[3]-H[4]-H[5]+H[6]+H[7]-H[8]-H[9]+H[10]+H[11]-J[0]+J[1]-J[2]-J[3]-J[4]+
    J[5]+J[6]-J[7]-J[8]+J[9]+J[10]-J[11]+J[12]+J[13]+J[14]-J[15]-J[16]+J[17]+J[18]-J[19]-J[20]-J[21]-J[22]-J[23]+
    J[24]+J[25]-J[26]-J[27]+J[28]+J[29]+J[30]+J[31]-J[32]-J[33]+J[34]+J[35]-J[36]-J[37]+J[38]-J[39]-J[40]+
    J[41]+J[42]-J[43]-J[44]-J[45]-J[46]+J[47]+J[48]-J[49]-J[50]+J[51]-J[52]-J[53]+J[54]+J[55]-J[56]-J[57]+
    J[58]+J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]-H[1]+H[2]-H[3]-H[4]-H[5]+H[6]+H[7]-H[8]-H[9]+
    H[10]-H[11]-J[0]+J[1]-J[2]-J[3]-J[4]+J[5]+J[6]-J[7]-J[8]+J[9]-J[10]-J[11]+J[12]+J[13]+J[14]-J[15]-J[16]+
    J[17]+J[18]-J[19]+J[20]-J[21]-J[22]-J[23]+J[24]+J[25]-J[26]-J[27]+J[28]-J[29]+J[30]+J[31]-J[32]-J[33]+
    J[34]+J[35]-J[36]+J[37]+J[38]-J[39]-J[40]+J[41]+J[42]-J[43]+J[44]-J[45]-J[46]+J[47]+J[48]-J[49]+J[50]+
    J[51]-J[52]-J[53]+J[54]-J[55]-J[56]-J[57]+J[58]-J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]-H[1]+
    H[2]-H[3]-H[4]-H[5]+H[6]+H[7]-H[8]-H[9]-H[10]+H[11]-J[0]+J[1]-J[2]-J[3]-J[4]+J[5]+J[6]-J[7]-J[8]-J[9]+
    J[10]-J[11]+J[12]+J[13]+J[14]-J[15]-J[16]+J[17]+J[18]+J[19]-J[20]-J[21]-J[22]-J[23]+J[24]+J[25]-J[26]-J[27]-J[28]+
    J[29]+J[30]+J[31]-J[32]-J[33]+J[34]+J[35]+J[36]-J[37]+J[38]-J[39]-J[40]+J[41]+J[42]+J[43]-J[44]-J[45]-J[46]+
    J[47]+J[48]+J[49]-J[50]+J[51]-J[52]-J[53]-J[54]+J[55]-J[56]-J[57]-J[58]+J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +
    H[0]-H[1]+H[2]-H[3]-H[4]-H[5]+H[6]+H[7]-H[8]-H[9]-H[10]-H[11]-J[0]+J[1]-J[2]-J[3]-J[4]+J[5]+J[6]-J[7]-J[8]-J[9]-J[10]-J[11]+
    J[12]+J[13]+J[14]-J[15]-J[16]+J[17]+J[18]+J[19]+J[20]-J[21]-J[22]-J[23]+J[24]+J[25]-J[26]-J[27]-J[28]-J[29]+
    J[30]+J[31]-J[32]-J[33]+J[34]+J[35]+J[36]+J[37]+J[38]-J[39]-J[40]+J[41]+J[42]+J[43]+J[44]-J[45]-J[46]+
    J[47]+J[48]+J[49]+J[50]+J[51]-J[52]-J[53]-J[54]-J[55]-J[56]-J[57]-J[58]-J[59]+J[60]+J[61]+J[62]+J[63]+
    J[64]+J[65], +H[0]-H[1]+H[2]-H[3]-H[4]-H[5]+H[6]-H[7]+H[8]+H[9]+H[10]+H[11]-J[0]+J[1]-J[2]-J[3]-J[4]+
    J[5]-J[6]+J[7]+J[8]+J[9]+J[10]-J[11]+J[12]+J[13]+J[14]-J[15]+J[16]-J[17]-J[18]-J[19]-J[20]-J[21]-J[22]-J[23]+
    J[24]-J[25]+J[26]+J[27]+J[28]+J[29]+J[30]+J[31]-J[32]+J[33]-J[34]-J[35]-J[36]-J[37]+J[38]-J[39]+J[40]-J[41]-J[42]-J[43]-J[44]-J[45]+
    J[46]-J[47]-J[48]-J[49]-J[50]-J[51]+J[52]+J[53]+J[54]+J[55]-J[56]-J[57]-J[58]-J[59]+J[60]+J[61]+J[62]+
    J[63]+J[64]+J[65], +H[0]-H[1]+H[2]-H[3]-H[4]-H[5]+H[6]-H[7]+H[8]+H[9]+H[10]-H[11]-J[0]+J[1]-J[2]-J[3]-J[4]+
    J[5]-J[6]+J[7]+J[8]+J[9]-J[10]-J[11]+J[12]+J[13]+J[14]-J[15]+J[16]-J[17]-J[18]-J[19]+J[20]-J[21]-J[22]-J[23]+
    J[24]-J[25]+J[26]+J[27]+J[28]-J[29]+J[30]+J[31]-J[32]+J[33]-J[34]-J[35]-J[36]+J[37]+J[38]-J[39]+J[40]-J[41]-J[42]-J[43]+
    J[44]-J[45]+J[46]-J[47]-J[48]-J[49]+J[50]-J[51]+J[52]+J[53]+J[54]-J[55]-J[56]-J[57]-J[58]+J[59]+J[60]+
    J[61]-J[62]+J[63]-J[64]-J[65], +H[0]-H[1]+H[2]-H[3]-H[4]-H[5]+H[6]-H[7]+H[8]+H[9]-H[10]+H[11]-J[0]+J[1]-J[2]-J[3]-J[4]+
    J[5]-J[6]+J[7]+J[8]-J[9]+J[10]-J[11]+J[12]+J[13]+J[14]-J[15]+J[16]-J[17]-J[18]+J[19]-J[20]-J[21]-J[22]-J[23]+
    J[24]-J[25]+J[26]+J[27]-J[28]+J[29]+J[30]+J[31]-J[32]+J[33]-J[34]-J[35]+J[36]-J[37]+J[38]-J[39]+J[40]-J[41]-J[42]+
    J[43]-J[44]-J[45]+J[46]-J[47]-J[48]+J[49]-J[50]-J[51]+J[52]+J[53]-J[54]+J[55]-J[56]-J[57]+J[58]-J[59]+
    J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]-H[1]+H[2]-H[3]-H[4]-H[5]+H[6]-H[7]+H[8]+H[9]-H[10]-H[11]-J[0]+
    J[1]-J[2]-J[3]-J[4]+J[5]-J[6]+J[7]+J[8]-J[9]-J[10]-J[11]+J[12]+J[13]+J[14]-J[15]+J[16]-J[17]-J[18]+J[19]+
    J[20]-J[21]-J[22]-J[23]+J[24]-J[25]+J[26]+J[27]-J[28]-J[29]+J[30]+J[31]-J[32]+J[33]-J[34]-J[35]+J[36]+
    J[37]+J[38]-J[39]+J[40]-J[41]-J[42]+J[43]+J[44]-J[45]+J[46]-J[47]-J[48]+J[49]+J[50]-J[51]+J[52]+J[53]-J[54]-J[55]-J[56]-J[57]+
    J[58]+J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]-H[1]+H[2]-H[3]-H[4]-H[5]+H[6]-H[7]+H[8]-H[9]+
    H[10]+H[11]-J[0]+J[1]-J[2]-J[3]-J[4]+J[5]-J[6]+J[7]-J[8]+J[9]+J[10]-J[11]+J[12]+J[13]+J[14]-J[15]+J[16]-J[17]+
    J[18]-J[19]-J[20]-J[21]-J[22]-J[23]+J[24]-J[25]+J[26]-J[27]+J[28]+J[29]+J[30]+J[31]-J[32]+J[33]-J[34]+
    J[35]-J[36]-J[37]+J[38]-J[39]+J[40]-J[41]+J[42]-J[43]-J[44]-J[45]+J[46]-J[47]+J[48]-J[49]-J[50]-J[51]+
    J[52]-J[53]+J[54]+J[55]-J[56]+J[57]-J[58]-J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]-H[1]+H[2]-H[3]-H[4]-H[5]+
    H[6]-H[7]+H[8]-H[9]+H[10]-H[11]-J[0]+J[1]-J[2]-J[3]-J[4]+J[5]-J[6]+J[7]-J[8]+J[9]-J[10]-J[11]+J[12]+
    J[13]+J[14]-J[15]+J[16]-J[17]+J[18]-J[19]+J[20]-J[21]-J[22]-J[23]+J[24]-J[25]+J[26]-J[27]+J[28]-J[29]+
    J[30]+J[31]-J[32]+J[33]-J[34]+J[35]-J[36]+J[37]+J[38]-J[39]+J[40]-J[41]+J[42]-J[43]+J[44]-J[45]+J[46]-J[47]+
    J[48]-J[49]+J[50]-J[51]+J[52]-J[53]+J[54]-J[55]-J[56]+J[57]-J[58]+J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +
    H[0]-H[1]+H[2]-H[3]-H[4]-H[5]+H[6]-H[7]+H[8]-H[9]-H[10]+H[11]-J[0]+J[1]-J[2]-J[3]-J[4]+J[5]-J[6]+J[7]-J[8]-J[9]+
    J[10]-J[11]+J[12]+J[13]+J[14]-J[15]+J[16]-J[17]+J[18]+J[19]-J[20]-J[21]-J[22]-J[23]+J[24]-J[25]+J[26]-J[27]-J[28]+
    J[29]+J[30]+J[31]-J[32]+J[33]-J[34]+J[35]+J[36]-J[37]+J[38]-J[39]+J[40]-J[41]+J[42]+J[43]-J[44]-J[45]+
    J[46]-J[47]+J[48]+J[49]-J[50]-J[51]+J[52]-J[53]-J[54]+J[55]-J[56]+J[57]+J[58]-J[59]-J[60]-J[61]+J[62]+
    J[63]-J[64]-J[65], +H[0]-H[1]+H[2]-H[3]-H[4]-H[5]+H[6]-H[7]+H[8]-H[9]-H[10]-H[11]-J[0]+J[1]-J[2]-J[3]-J[4]+
    J[5]-J[6]+J[7]-J[8]-J[9]-J[10]-J[11]+J[12]+J[13]+J[14]-J[15]+J[16]-J[17]+J[18]+J[19]+J[20]-J[21]-J[22]-J[23]+
    J[24]-J[25]+J[26]-J[27]-J[28]-J[29]+J[30]+J[31]-J[32]+J[33]-J[34]+J[35]+J[36]+J[37]+J[38]-J[39]+J[40]-J[41]+
    J[42]+J[43]+J[44]-J[45]+J[46]-J[47]+J[48]+J[49]+J[50]-J[51]+J[52]-J[53]-J[54]-J[55]-J[56]+J[57]+J[58]+
    J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]-H[1]+H[2]-H[3]-H[4]-H[5]+H[6]-H[7]-H[8]+H[9]+H[10]+
    H[11]-J[0]+J[1]-J[2]-J[3]-J[4]+J[5]-J[6]-J[7]+J[8]+J[9]+J[10]-J[11]+J[12]+J[13]+J[14]-J[15]+J[16]+J[17]-J[18]-J[19]-J[20]-J[21]-J[22]-J[23]+
    J[24]-J[25]-J[26]+J[27]+J[28]+J[29]+J[30]+J[31]-J[32]+J[33]+J[34]-J[35]-J[36]-J[37]+J[38]-J[39]+J[40]+
    J[41]-J[42]-J[43]-J[44]-J[45]+J[46]+J[47]-J[48]-J[49]-J[50]-J[51]-J[52]+J[53]+J[54]+J[55]+J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+
    J[63]+J[64]+J[65], +H[0]-H[1]+H[2]-H[3]-H[4]-H[5]+H[6]-H[7]-H[8]+H[9]+H[10]-H[11]-J[0]+J[1]-J[2]-J[3]-J[4]+
    J[5]-J[6]-J[7]+J[8]+J[9]-J[10]-J[11]+J[12]+J[13]+J[14]-J[15]+J[16]+J[17]-J[18]-J[19]+J[20]-J[21]-J[22]-J[23]+
    J[24]-J[25]-J[26]+J[27]+J[28]-J[29]+J[30]+J[31]-J[32]+J[33]+J[34]-J[35]-J[36]+J[37]+J[38]-J[39]+J[40]+
    J[41]-J[42]-J[43]+J[44]-J[45]+J[46]+J[47]-J[48]-J[49]+J[50]-J[51]-J[52]+J[53]+J[54]-J[55]+J[56]-J[57]-J[58]+
    J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]-H[1]+H[2]-H[3]-H[4]-H[5]+H[6]-H[7]-H[8]+H[9]-H[10]+
    H[11]-J[0]+J[1]-J[2]-J[3]-J[4]+J[5]-J[6]-J[7]+J[8]-J[9]+J[10]-J[11]+J[12]+J[13]+J[14]-J[15]+J[16]+J[17]-J[18]+
    J[19]-J[20]-J[21]-J[22]-J[23]+J[24]-J[25]-J[26]+J[27]-J[28]+J[29]+J[30]+J[31]-J[32]+J[33]+J[34]-J[35]+
    J[36]-J[37]+J[38]-J[39]+J[40]+J[41]-J[42]+J[43]-J[44]-J[45]+J[46]+J[47]-J[48]+J[49]-J[50]-J[51]-J[52]+
    J[53]-J[54]+J[55]+J[56]-J[57]+J[58]-J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]-H[1]+H[2]-H[3]-H[4]-H[5]+
    H[6]-H[7]-H[8]+H[9]-H[10]-H[11]-J[0]+J[1]-J[2]-J[3]-J[4]+J[5]-J[6]-J[7]+J[8]-J[9]-J[10]-J[11]+J[12]+
    J[13]+J[14]-J[15]+J[16]+J[17]-J[18]+J[19]+J[20]-J[21]-J[22]-J[23]+J[24]-J[25]-J[26]+J[27]-J[28]-J[29]+
    J[30]+J[31]-J[32]+J[33]+J[34]-J[35]+J[36]+J[37]+J[38]-J[39]+J[40]+J[41]-J[42]+J[43]+J[44]-J[45]+J[46]+
    J[47]-J[48]+J[49]+J[50]-J[51]-J[52]+J[53]-J[54]-J[55]+J[56]-J[57]+J[58]+J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+
    J[65], +H[0]-H[1]+H[2]-H[3]-H[4]-H[5]+H[6]-H[7]-H[8]-H[9]+H[10]+H[11]-J[0]+J[1]-J[2]-J[3]-J[4]+J[5]-J[6]-J[7]-J[8]+
    J[9]+J[10]-J[11]+J[12]+J[13]+J[14]-J[15]+J[16]+J[17]+J[18]-J[19]-J[20]-J[21]-J[22]-J[23]+J[24]-J[25]-J[26]-J[27]+
    J[28]+J[29]+J[30]+J[31]-J[32]+J[33]+J[34]+J[35]-J[36]-J[37]+J[38]-J[39]+J[40]+J[41]+J[42]-J[43]-J[44]-J[45]+
    J[46]+J[47]+J[48]-J[49]-J[50]-J[51]-J[52]-J[53]+J[54]+J[55]+J[56]+J[57]-J[58]-J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+
    J[65], +H[0]-H[1]+H[2]-H[3]-H[4]-H[5]+H[6]-H[7]-H[8]-H[9]+H[10]-H[11]-J[0]+J[1]-J[2]-J[3]-J[4]+J[5]-J[6]-J[7]-J[8]+
    J[9]-J[10]-J[11]+J[12]+J[13]+J[14]-J[15]+J[16]+J[17]+J[18]-J[19]+J[20]-J[21]-J[22]-J[23]+J[24]-J[25]-J[26]-J[27]+
    J[28]-J[29]+J[30]+J[31]-J[32]+J[33]+J[34]+J[35]-J[36]+J[37]+J[38]-J[39]+J[40]+J[41]+J[42]-J[43]+J[44]-J[45]+
    J[46]+J[47]+J[48]-J[49]+J[50]-J[51]-J[52]-J[53]+J[54]-J[55]+J[56]+J[57]-J[58]+J[59]+J[60]-J[61]+J[62]-J[63]+
    J[64]-J[65], +H[0]-H[1]+H[2]-H[3]-H[4]-H[5]+H[6]-H[7]-H[8]-H[9]-H[10]+H[11]-J[0]+J[1]-J[2]-J[3]-J[4]+
    J[5]-J[6]-J[7]-J[8]-J[9]+J[10]-J[11]+J[12]+J[13]+J[14]-J[15]+J[16]+J[17]+J[18]+J[19]-J[20]-J[21]-J[22]-J[23]+
    J[24]-J[25]-J[26]-J[27]-J[28]+J[29]+J[30]+J[31]-J[32]+J[33]+J[34]+J[35]+J[36]-J[37]+J[38]-J[39]+J[40]+
    J[41]+J[42]+J[43]-J[44]-J[45]+J[46]+J[47]+J[48]+J[49]-J[50]-J[51]-J[52]-J[53]-J[54]+J[55]+J[56]+J[57]+
    J[58]-J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]-H[1]+H[2]-H[3]-H[4]-H[5]+H[6]-H[7]-H[8]-H[9]-H[10]-H[11]-J[0]+
    J[1]-J[2]-J[3]-J[4]+J[5]-J[6]-J[7]-J[8]-J[9]-J[10]-J[11]+J[12]+J[13]+J[14]-J[15]+J[16]+J[17]+J[18]+J[19]+
    J[20]-J[21]-J[22]-J[23]+J[24]-J[25]-J[26]-J[27]-J[28]-J[29]+J[30]+J[31]-J[32]+J[33]+J[34]+J[35]+J[36]+
    J[37]+J[38]-J[39]+J[40]+J[41]+J[42]+J[43]+J[44]-J[45]+J[46]+J[47]+J[48]+J[49]+J[50]-J[51]-J[52]-J[53]-J[54]-J[55]+
    J[56]+J[57]+J[58]+J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]-H[1]+H[2]-H[3]-H[4]-H[5]-H[6]+H[7]+
    H[8]+H[9]+H[10]+H[11]-J[0]+J[1]-J[2]-J[3]-J[4]-J[5]+J[6]+J[7]+J[8]+J[9]+J[10]-J[11]+J[12]+J[13]+J[14]+
    J[15]-J[16]-J[17]-J[18]-J[19]-J[20]-J[21]-J[22]-J[23]-J[24]+J[25]+J[26]+J[27]+J[28]+J[29]+J[30]+J[31]+
    J[32]-J[33]-J[34]-J[35]-J[36]-J[37]+J[38]+J[39]-J[40]-J[41]-J[42]-J[43]-J[44]+J[45]-J[46]-J[47]-J[48]-J[49]-J[50]-J[51]-J[52]-J[53]-J[54]-J[55]+
    J[56]+J[57]+J[58]+J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]-H[1]+H[2]-H[3]-H[4]-H[5]-H[6]+H[7]+
    H[8]+H[9]+H[10]-H[11]-J[0]+J[1]-J[2]-J[3]-J[4]-J[5]+J[6]+J[7]+J[8]+J[9]-J[10]-J[11]+J[12]+J[13]+J[14]+
    J[15]-J[16]-J[17]-J[18]-J[19]+J[20]-J[21]-J[22]-J[23]-J[24]+J[25]+J[26]+J[27]+J[28]-J[29]+J[30]+J[31]+
    J[32]-J[33]-J[34]-J[35]-J[36]+J[37]+J[38]+J[39]-J[40]-J[41]-J[42]-J[43]+J[44]+J[45]-J[46]-J[47]-J[48]-J[49]+
    J[50]-J[51]-J[52]-J[53]-J[54]+J[55]+J[56]+J[57]+J[58]-J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]-H[1]+
    H[2]-H[3]-H[4]-H[5]-H[6]+H[7]+H[8]+H[9]-H[10]+H[11]-J[0]+J[1]-J[2]-J[3]-J[4]-J[5]+J[6]+J[7]+J[8]-J[9]+
    J[10]-J[11]+J[12]+J[13]+J[14]+J[15]-J[16]-J[17]-J[18]+J[19]-J[20]-J[21]-J[22]-J[23]-J[24]+J[25]+J[26]+
    J[27]-J[28]+J[29]+J[30]+J[31]+J[32]-J[33]-J[34]-J[35]+J[36]-J[37]+J[38]+J[39]-J[40]-J[41]-J[42]+J[43]-J[44]+
    J[45]-J[46]-J[47]-J[48]+J[49]-J[50]-J[51]-J[52]-J[53]+J[54]-J[55]+J[56]+J[57]-J[58]+J[59]+J[60]-J[61]+
    J[62]-J[63]+J[64]-J[65], +H[0]-H[1]+H[2]-H[3]-H[4]-H[5]-H[6]+H[7]+H[8]+H[9]-H[10]-H[11]-J[0]+J[1]-J[2]-J[3]-J[4]-J[5]+
    J[6]+J[7]+J[8]-J[9]-J[10]-J[11]+J[12]+J[13]+J[14]+J[15]-J[16]-J[17]-J[18]+J[19]+J[20]-J[21]-J[22]-J[23]-J[24]+
    J[25]+J[26]+J[27]-J[28]-J[29]+J[30]+J[31]+J[32]-J[33]-J[34]-J[35]+J[36]+J[37]+J[38]+J[39]-J[40]-J[41]-J[42]+
    J[43]+J[44]+J[45]-J[46]-J[47]-J[48]+J[49]+J[50]-J[51]-J[52]-J[53]+J[54]+J[55]+J[56]+J[57]-J[58]-J[59]+
    J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]-H[1]+H[2]-H[3]-H[4]-H[5]-H[6]+H[7]+H[8]-H[9]+H[10]+H[11]-J[0]+
    J[1]-J[2]-J[3]-J[4]-J[5]+J[6]+J[7]-J[8]+J[9]+J[10]-J[11]+J[12]+J[13]+J[14]+J[15]-J[16]-J[17]+J[18]-J[19]-J[20]-J[21]-J[22]-J[23]-J[24]+
    J[25]+J[26]-J[27]+J[28]+J[29]+J[30]+J[31]+J[32]-J[33]-J[34]+J[35]-J[36]-J[37]+J[38]+J[39]-J[40]-J[41]+
    J[42]-J[43]-J[44]+J[45]-J[46]-J[47]+J[48]-J[49]-J[50]-J[51]-J[52]+J[53]-J[54]-J[55]+J[56]-J[57]+J[58]+
    J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]-H[1]+H[2]-H[3]-H[4]-H[5]-H[6]+H[7]+H[8]-H[9]+H[10]-H[11]-J[0]+
    J[1]-J[2]-J[3]-J[4]-J[5]+J[6]+J[7]-J[8]+J[9]-J[10]-J[11]+J[12]+J[13]+J[14]+J[15]-J[16]-J[17]+J[18]-J[19]+
    J[20]-J[21]-J[22]-J[23]-J[24]+J[25]+J[26]-J[27]+J[28]-J[29]+J[30]+J[31]+J[32]-J[33]-J[34]+J[35]-J[36]+
    J[37]+J[38]+J[39]-J[40]-J[41]+J[42]-J[43]+J[44]+J[45]-J[46]-J[47]+J[48]-J[49]+J[50]-J[51]-J[52]+J[53]-J[54]+
    J[55]+J[56]-J[57]+J[58]-J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]-H[1]+H[2]-H[3]-H[4]-H[5]-H[6]+
    H[7]+H[8]-H[9]-H[10]+H[11]-J[0]+J[1]-J[2]-J[3]-J[4]-J[5]+J[6]+J[7]-J[8]-J[9]+J[10]-J[11]+J[12]+J[13]+
    J[14]+J[15]-J[16]-J[17]+J[18]+J[19]-J[20]-J[21]-J[22]-J[23]-J[24]+J[25]+J[26]-J[27]-J[28]+J[29]+J[30]+
    J[31]+J[32]-J[33]-J[34]+J[35]+J[36]-J[37]+J[38]+J[39]-J[40]-J[41]+J[42]+J[43]-J[44]+J[45]-J[46]-J[47]+
    J[48]+J[49]-J[50]-J[51]-J[52]+J[53]+J[54]-J[55]+J[56]-J[57]-J[58]+J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +
    H[0]-H[1]+H[2]-H[3]-H[4]-H[5]-H[6]+H[7]+H[8]-H[9]-H[10]-H[11]-J[0]+J[1]-J[2]-J[3]-J[4]-J[5]+J[6]+J[7]-J[8]-J[9]-J[10]-J[11]+
    J[12]+J[13]+J[14]+J[15]-J[16]-J[17]+J[18]+J[19]+J[20]-J[21]-J[22]-J[23]-J[24]+J[25]+J[26]-J[27]-J[28]-J[29]+
    J[30]+J[31]+J[32]-J[33]-J[34]+J[35]+J[36]+J[37]+J[38]+J[39]-J[40]-J[41]+J[42]+J[43]+J[44]+J[45]-J[46]-J[47]+
    J[48]+J[49]+J[50]-J[51]-J[52]+J[53]+J[54]+J[55]+J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+
    J[65], +H[0]-H[1]+H[2]-H[3]-H[4]-H[5]-H[6]+H[7]-H[8]+H[9]+H[10]+H[11]-J[0]+J[1]-J[2]-J[3]-J[4]-J[5]+
    J[6]-J[7]+J[8]+J[9]+J[10]-J[11]+J[12]+J[13]+J[14]+J[15]-J[16]+J[17]-J[18]-J[19]-J[20]-J[21]-J[22]-J[23]-J[24]+
    J[25]-J[26]+J[27]+J[28]+J[29]+J[30]+J[31]+J[32]-J[33]+J[34]-J[35]-J[36]-J[37]+J[38]+J[39]-J[40]+J[41]-J[42]-J[43]-J[44]+
    J[45]-J[46]+J[47]-J[48]-J[49]-J[50]-J[51]+J[52]-J[53]-J[54]-J[55]-J[56]+J[57]+J[58]+J[59]-J[60]-J[61]-J[62]+
    J[63]+J[64]+J[65], +H[0]-H[1]+H[2]-H[3]-H[4]-H[5]-H[6]+H[7]-H[8]+H[9]+H[10]-H[11]-J[0]+J[1]-J[2]-J[3]-J[4]-J[5]+
    J[6]-J[7]+J[8]+J[9]-J[10]-J[11]+J[12]+J[13]+J[14]+J[15]-J[16]+J[17]-J[18]-J[19]+J[20]-J[21]-J[22]-J[23]-J[24]+
    J[25]-J[26]+J[27]+J[28]-J[29]+J[30]+J[31]+J[32]-J[33]+J[34]-J[35]-J[36]+J[37]+J[38]+J[39]-J[40]+J[41]-J[42]-J[43]+
    J[44]+J[45]-J[46]+J[47]-J[48]-J[49]+J[50]-J[51]+J[52]-J[53]-J[54]+J[55]-J[56]+J[57]+J[58]-J[59]-J[60]-J[61]+
    J[62]+J[63]-J[64]-J[65], +H[0]-H[1]+H[2]-H[3]-H[4]-H[5]-H[6]+H[7]-H[8]+H[9]-H[10]+H[11]-J[0]+J[1]-J[2]-J[3]-J[4]-J[5]+
    J[6]-J[7]+J[8]-J[9]+J[10]-J[11]+J[12]+J[13]+J[14]+J[15]-J[16]+J[17]-J[18]+J[19]-J[20]-J[21]-J[22]-J[23]-J[24]+
    J[25]-J[26]+J[27]-J[28]+J[29]+J[30]+J[31]+J[32]-J[33]+J[34]-J[35]+J[36]-J[37]+J[38]+J[39]-J[40]+J[41]-J[42]+
    J[43]-J[44]+J[45]-J[46]+J[47]-J[48]+J[49]-J[50]-J[51]+J[52]-J[53]+J[54]-J[55]-J[56]+J[57]-J[58]+J[59]-J[60]+
    J[61]-J[62]-J[63]+J[64]-J[65], +H[0]-H[1]+H[2]-H[3]-H[4]-H[5]-H[6]+H[7]-H[8]+H[9]-H[10]-H[11]-J[0]+J[1]-J[2]-J[3]-J[4]-J[5]+
    J[6]-J[7]+J[8]-J[9]-J[10]-J[11]+J[12]+J[13]+J[14]+J[15]-J[16]+J[17]-J[18]+J[19]+J[20]-J[21]-J[22]-J[23]-J[24]+
    J[25]-J[26]+J[27]-J[28]-J[29]+J[30]+J[31]+J[32]-J[33]+J[34]-J[35]+J[36]+J[37]+J[38]+J[39]-J[40]+J[41]-J[42]+
    J[43]+J[44]+J[45]-J[46]+J[47]-J[48]+J[49]+J[50]-J[51]+J[52]-J[53]+J[54]+J[55]-J[56]+J[57]-J[58]-J[59]-J[60]+
    J[61]+J[62]-J[63]-J[64]+J[65], +H[0]-H[1]+H[2]-H[3]-H[4]-H[5]-H[6]+H[7]-H[8]-H[9]+H[10]+H[11]-J[0]+J[1]-J[2]-J[3]-J[4]-J[5]+
    J[6]-J[7]-J[8]+J[9]+J[10]-J[11]+J[12]+J[13]+J[14]+J[15]-J[16]+J[17]+J[18]-J[19]-J[20]-J[21]-J[22]-J[23]-J[24]+
    J[25]-J[26]-J[27]+J[28]+J[29]+J[30]+J[31]+J[32]-J[33]+J[34]+J[35]-J[36]-J[37]+J[38]+J[39]-J[40]+J[41]+
    J[42]-J[43]-J[44]+J[45]-J[46]+J[47]+J[48]-J[49]-J[50]-J[51]+J[52]+J[53]-J[54]-J[55]-J[56]-J[57]+J[58]+
    J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]-H[1]+H[2]-H[3]-H[4]-H[5]-H[6]+H[7]-H[8]-H[9]+H[10]-H[11]-J[0]+
    J[1]-J[2]-J[3]-J[4]-J[5]+J[6]-J[7]-J[8]+J[9]-J[10]-J[11]+J[12]+J[13]+J[14]+J[15]-J[16]+J[17]+J[18]-J[19]+
    J[20]-J[21]-J[22]-J[23]-J[24]+J[25]-J[26]-J[27]+J[28]-J[29]+J[30]+J[31]+J[32]-J[33]+J[34]+J[35]-J[36]+
    J[37]+J[38]+J[39]-J[40]+J[41]+J[42]-J[43]+J[44]+J[45]-J[46]+J[47]+J[48]-J[49]+J[50]-J[51]+J[52]+J[53]-J[54]+
    J[55]-J[56]-J[57]+J[58]-J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]-H[1]+H[2]-H[3]-H[4]-H[5]-H[6]+
    H[7]-H[8]-H[9]-H[10]+H[11]-J[0]+J[1]-J[2]-J[3]-J[4]-J[5]+J[6]-J[7]-J[8]-J[9]+J[10]-J[11]+J[12]+J[13]+
    J[14]+J[15]-J[16]+J[17]+J[18]+J[19]-J[20]-J[21]-J[22]-J[23]-J[24]+J[25]-J[26]-J[27]-J[28]+J[29]+J[30]+
    J[31]+J[32]-J[33]+J[34]+J[35]+J[36]-J[37]+J[38]+J[39]-J[40]+J[41]+J[42]+J[43]-J[44]+J[45]-J[46]+J[47]+
    J[48]+J[49]-J[50]-J[51]+J[52]+J[53]+J[54]-J[55]-J[56]-J[57]-J[58]+J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +
    H[0]-H[1]+H[2]-H[3]-H[4]-H[5]-H[6]+H[7]-H[8]-H[9]-H[10]-H[11]-J[0]+J[1]-J[2]-J[3]-J[4]-J[5]+J[6]-J[7]-J[8]-J[9]-J[10]-J[11]+
    J[12]+J[13]+J[14]+J[15]-J[16]+J[17]+J[18]+J[19]+J[20]-J[21]-J[22]-J[23]-J[24]+J[25]-J[26]-J[27]-J[28]-J[29]+
    J[30]+J[31]+J[32]-J[33]+J[34]+J[35]+J[36]+J[37]+J[38]+J[39]-J[40]+J[41]+J[42]+J[43]+J[44]+J[45]-J[46]+
    J[47]+J[48]+J[49]+J[50]-J[51]+J[52]+J[53]+J[54]+J[55]-J[56]-J[57]-J[58]-J[59]+J[60]+J[61]+J[62]+J[63]+
    J[64]+J[65], +H[0]-H[1]+H[2]-H[3]-H[4]-H[5]-H[6]-H[7]+H[8]+H[9]+H[10]+H[11]-J[0]+J[1]-J[2]-J[3]-J[4]-J[5]-J[6]+
    J[7]+J[8]+J[9]+J[10]-J[11]+J[12]+J[13]+J[14]+J[15]+J[16]-J[17]-J[18]-J[19]-J[20]-J[21]-J[22]-J[23]-J[24]-J[25]+
    J[26]+J[27]+J[28]+J[29]+J[30]+J[31]+J[32]+J[33]-J[34]-J[35]-J[36]-J[37]+J[38]+J[39]+J[40]-J[41]-J[42]-J[43]-J[44]+
    J[45]+J[46]-J[47]-J[48]-J[49]-J[50]+J[51]-J[52]-J[53]-J[54]-J[55]-J[56]-J[57]-J[58]-J[59]+J[60]+J[61]+
    J[62]+J[63]+J[64]+J[65], +H[0]-H[1]+H[2]-H[3]-H[4]-H[5]-H[6]-H[7]+H[8]+H[9]+H[10]-H[11]-J[0]+J[1]-J[2]-J[3]-J[4]-J[5]-J[6]+
    J[7]+J[8]+J[9]-J[10]-J[11]+J[12]+J[13]+J[14]+J[15]+J[16]-J[17]-J[18]-J[19]+J[20]-J[21]-J[22]-J[23]-J[24]-J[25]+
    J[26]+J[27]+J[28]-J[29]+J[30]+J[31]+J[32]+J[33]-J[34]-J[35]-J[36]+J[37]+J[38]+J[39]+J[40]-J[41]-J[42]-J[43]+
    J[44]+J[45]+J[46]-J[47]-J[48]-J[49]+J[50]+J[51]-J[52]-J[53]-J[54]+J[55]-J[56]-J[57]-J[58]+J[59]+J[60]+
    J[61]-J[62]+J[63]-J[64]-J[65], +H[0]-H[1]+H[2]-H[3]-H[4]-H[5]-H[6]-H[7]+H[8]+H[9]-H[10]+H[11]-J[0]+J[1]-J[2]-J[3]-J[4]-J[5]-J[6]+
    J[7]+J[8]-J[9]+J[10]-J[11]+J[12]+J[13]+J[14]+J[15]+J[16]-J[17]-J[18]+J[19]-J[20]-J[21]-J[22]-J[23]-J[24]-J[25]+
    J[26]+J[27]-J[28]+J[29]+J[30]+J[31]+J[32]+J[33]-J[34]-J[35]+J[36]-J[37]+J[38]+J[39]+J[40]-J[41]-J[42]+
    J[43]-J[44]+J[45]+J[46]-J[47]-J[48]+J[49]-J[50]+J[51]-J[52]-J[53]+J[54]-J[55]-J[56]-J[57]+J[58]-J[59]+
    J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]-H[1]+H[2]-H[3]-H[4]-H[5]-H[6]-H[7]+H[8]+H[9]-H[10]-H[11]-J[0]+
    J[1]-J[2]-J[3]-J[4]-J[5]-J[6]+J[7]+J[8]-J[9]-J[10]-J[11]+J[12]+J[13]+J[14]+J[15]+J[16]-J[17]-J[18]+J[19]+
    J[20]-J[21]-J[22]-J[23]-J[24]-J[25]+J[26]+J[27]-J[28]-J[29]+J[30]+J[31]+J[32]+J[33]-J[34]-J[35]+J[36]+
    J[37]+J[38]+J[39]+J[40]-J[41]-J[42]+J[43]+J[44]+J[45]+J[46]-J[47]-J[48]+J[49]+J[50]+J[51]-J[52]-J[53]+
    J[54]+J[55]-J[56]-J[57]+J[58]+J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]-H[1]+H[2]-H[3]-H[4]-H[5]-H[6]-H[7]+
    H[8]-H[9]+H[10]+H[11]-J[0]+J[1]-J[2]-J[3]-J[4]-J[5]-J[6]+J[7]-J[8]+J[9]+J[10]-J[11]+J[12]+J[13]+J[14]+
    J[15]+J[16]-J[17]+J[18]-J[19]-J[20]-J[21]-J[22]-J[23]-J[24]-J[25]+J[26]-J[27]+J[28]+J[29]+J[30]+J[31]+
    J[32]+J[33]-J[34]+J[35]-J[36]-J[37]+J[38]+J[39]+J[40]-J[41]+J[42]-J[43]-J[44]+J[45]+J[46]-J[47]+J[48]-J[49]-J[50]+
    J[51]-J[52]+J[53]-J[54]-J[55]-J[56]+J[57]-J[58]-J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]-H[1]+
    H[2]-H[3]-H[4]-H[5]-H[6]-H[7]+H[8]-H[9]+H[10]-H[11]-J[0]+J[1]-J[2]-J[3]-J[4]-J[5]-J[6]+J[7]-J[8]+J[9]-J[10]-J[11]+
    J[12]+J[13]+J[14]+J[15]+J[16]-J[17]+J[18]-J[19]+J[20]-J[21]-J[22]-J[23]-J[24]-J[25]+J[26]-J[27]+J[28]-J[29]+
    J[30]+J[31]+J[32]+J[33]-J[34]+J[35]-J[36]+J[37]+J[38]+J[39]+J[40]-J[41]+J[42]-J[43]+J[44]+J[45]+J[46]-J[47]+
    J[48]-J[49]+J[50]+J[51]-J[52]+J[53]-J[54]+J[55]-J[56]+J[57]-J[58]+J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +
    H[0]-H[1]+H[2]-H[3]-H[4]-H[5]-H[6]-H[7]+H[8]-H[9]-H[10]+H[11]-J[0]+J[1]-J[2]-J[3]-J[4]-J[5]-J[6]+J[7]-J[8]-J[9]+
    J[10]-J[11]+J[12]+J[13]+J[14]+J[15]+J[16]-J[17]+J[18]+J[19]-J[20]-J[21]-J[22]-J[23]-J[24]-J[25]+J[26]-J[27]-J[28]+
    J[29]+J[30]+J[31]+J[32]+J[33]-J[34]+J[35]+J[36]-J[37]+J[38]+J[39]+J[40]-J[41]+J[42]+J[43]-J[44]+J[45]+
    J[46]-J[47]+J[48]+J[49]-J[50]+J[51]-J[52]+J[53]+J[54]-J[55]-J[56]+J[57]+J[58]-J[59]-J[60]-J[61]+J[62]+
    J[63]-J[64]-J[65], +H[0]-H[1]+H[2]-H[3]-H[4]-H[5]-H[6]-H[7]+H[8]-H[9]-H[10]-H[11]-J[0]+J[1]-J[2]-J[3]-J[4]-J[5]-J[6]+
    J[7]-J[8]-J[9]-J[10]-J[11]+J[12]+J[13]+J[14]+J[15]+J[16]-J[17]+J[18]+J[19]+J[20]-J[21]-J[22]-J[23]-J[24]-J[25]+
    J[26]-J[27]-J[28]-J[29]+J[30]+J[31]+J[32]+J[33]-J[34]+J[35]+J[36]+J[37]+J[38]+J[39]+J[40]-J[41]+J[42]+
    J[43]+J[44]+J[45]+J[46]-J[47]+J[48]+J[49]+J[50]+J[51]-J[52]+J[53]+J[54]+J[55]-J[56]+J[57]+J[58]+J[59]-J[60]-J[61]-J[62]+
    J[63]+J[64]+J[65], +H[0]-H[1]+H[2]-H[3]-H[4]-H[5]-H[6]-H[7]-H[8]+H[9]+H[10]+H[11]-J[0]+J[1]-J[2]-J[3]-J[4]-J[5]-J[6]-J[7]+
    J[8]+J[9]+J[10]-J[11]+J[12]+J[13]+J[14]+J[15]+J[16]+J[17]-J[18]-J[19]-J[20]-J[21]-J[22]-J[23]-J[24]-J[25]-J[26]+
    J[27]+J[28]+J[29]+J[30]+J[31]+J[32]+J[33]+J[34]-J[35]-J[36]-J[37]+J[38]+J[39]+J[40]+J[41]-J[42]-J[43]-J[44]+
    J[45]+J[46]+J[47]-J[48]-J[49]-J[50]+J[51]+J[52]-J[53]-J[54]-J[55]+J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+
    J[63]+J[64]+J[65], +H[0]-H[1]+H[2]-H[3]-H[4]-H[5]-H[6]-H[7]-H[8]+H[9]+H[10]-H[11]-J[0]+J[1]-J[2]-J[3]-J[4]-J[5]-J[6]-J[7]+
    J[8]+J[9]-J[10]-J[11]+J[12]+J[13]+J[14]+J[15]+J[16]+J[17]-J[18]-J[19]+J[20]-J[21]-J[22]-J[23]-J[24]-J[25]-J[26]+
    J[27]+J[28]-J[29]+J[30]+J[31]+J[32]+J[33]+J[34]-J[35]-J[36]+J[37]+J[38]+J[39]+J[40]+J[41]-J[42]-J[43]+
    J[44]+J[45]+J[46]+J[47]-J[48]-J[49]+J[50]+J[51]+J[52]-J[53]-J[54]+J[55]+J[56]-J[57]-J[58]+J[59]-J[60]-J[61]+
    J[62]+J[63]-J[64]-J[65], +H[0]-H[1]+H[2]-H[3]-H[4]-H[5]-H[6]-H[7]-H[8]+H[9]-H[10]+H[11]-J[0]+J[1]-J[2]-J[3]-J[4]-J[5]-J[6]-J[7]+
    J[8]-J[9]+J[10]-J[11]+J[12]+J[13]+J[14]+J[15]+J[16]+J[17]-J[18]+J[19]-J[20]-J[21]-J[22]-J[23]-J[24]-J[25]-J[26]+
    J[27]-J[28]+J[29]+J[30]+J[31]+J[32]+J[33]+J[34]-J[35]+J[36]-J[37]+J[38]+J[39]+J[40]+J[41]-J[42]+J[43]-J[44]+
    J[45]+J[46]+J[47]-J[48]+J[49]-J[50]+J[51]+J[52]-J[53]+J[54]-J[55]+J[56]-J[57]+J[58]-J[59]-J[60]+J[61]-J[62]-J[63]+
    J[64]-J[65], +H[0]-H[1]+H[2]-H[3]-H[4]-H[5]-H[6]-H[7]-H[8]+H[9]-H[10]-H[11]-J[0]+J[1]-J[2]-J[3]-J[4]-J[5]-J[6]-J[7]+
    J[8]-J[9]-J[10]-J[11]+J[12]+J[13]+J[14]+J[15]+J[16]+J[17]-J[18]+J[19]+J[20]-J[21]-J[22]-J[23]-J[24]-J[25]-J[26]+
    J[27]-J[28]-J[29]+J[30]+J[31]+J[32]+J[33]+J[34]-J[35]+J[36]+J[37]+J[38]+J[39]+J[40]+J[41]-J[42]+J[43]+
    J[44]+J[45]+J[46]+J[47]-J[48]+J[49]+J[50]+J[51]+J[52]-J[53]+J[54]+J[55]+J[56]-J[57]+J[58]+J[59]-J[60]+
    J[61]+J[62]-J[63]-J[64]+J[65], +H[0]-H[1]+H[2]-H[3]-H[4]-H[5]-H[6]-H[7]-H[8]-H[9]+H[10]+H[11]-J[0]+J[1]-J[2]-J[3]-J[4]-J[5]-J[6]-J[7]-J[8]+
    J[9]+J[10]-J[11]+J[12]+J[13]+J[14]+J[15]+J[16]+J[17]+J[18]-J[19]-J[20]-J[21]-J[22]-J[23]-J[24]-J[25]-J[26]-J[27]+
    J[28]+J[29]+J[30]+J[31]+J[32]+J[33]+J[34]+J[35]-J[36]-J[37]+J[38]+J[39]+J[40]+J[41]+J[42]-J[43]-J[44]+
    J[45]+J[46]+J[47]+J[48]-J[49]-J[50]+J[51]+J[52]+J[53]-J[54]-J[55]+J[56]+J[57]-J[58]-J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+
    J[65], +H[0]-H[1]+H[2]-H[3]-H[4]-H[5]-H[6]-H[7]-H[8]-H[9]+H[10]-H[11]-J[0]+J[1]-J[2]-J[3]-J[4]-J[5]-J[6]-J[7]-J[8]+
    J[9]-J[10]-J[11]+J[12]+J[13]+J[14]+J[15]+J[16]+J[17]+J[18]-J[19]+J[20]-J[21]-J[22]-J[23]-J[24]-J[25]-J[26]-J[27]+
    J[28]-J[29]+J[30]+J[31]+J[32]+J[33]+J[34]+J[35]-J[36]+J[37]+J[38]+J[39]+J[40]+J[41]+J[42]-J[43]+J[44]+
    J[45]+J[46]+J[47]+J[48]-J[49]+J[50]+J[51]+J[52]+J[53]-J[54]+J[55]+J[56]+J[57]-J[58]+J[59]+J[60]-J[61]+
    J[62]-J[63]+J[64]-J[65], +H[0]-H[1]+H[2]-H[3]-H[4]-H[5]-H[6]-H[7]-H[8]-H[9]-H[10]+H[11]-J[0]+J[1]-J[2]-J[3]-J[4]-J[5]-J[6]-J[7]-J[8]-J[9]+
    J[10]-J[11]+J[12]+J[13]+J[14]+J[15]+J[16]+J[17]+J[18]+J[19]-J[20]-J[21]-J[22]-J[23]-J[24]-J[25]-J[26]-J[27]-J[28]+
    J[29]+J[30]+J[31]+J[32]+J[33]+J[34]+J[35]+J[36]-J[37]+J[38]+J[39]+J[40]+J[41]+J[42]+J[43]-J[44]+J[45]+
    J[46]+J[47]+J[48]+J[49]-J[50]+J[51]+J[52]+J[53]+J[54]-J[55]+J[56]+J[57]+J[58]-J[59]+J[60]+J[61]-J[62]+
    J[63]-J[64]-J[65], +H[0]-H[1]+H[2]-H[3]-H[4]-H[5]-H[6]-H[7]-H[8]-H[9]-H[10]-H[11]-J[0]+J[1]-J[2]-J[3]-J[4]-J[5]-J[6]-J[7]-J[8]-J[9]-J[10]-J[11]+
    J[12]+J[13]+J[14]+J[15]+J[16]+J[17]+J[18]+J[19]+J[20]-J[21]-J[22]-J[23]-J[24]-J[25]-J[26]-J[27]-J[28]-J[29]+
    J[30]+J[31]+J[32]+J[33]+J[34]+J[35]+J[36]+J[37]+J[38]+J[39]+J[40]+J[41]+J[42]+J[43]+J[44]+J[45]+J[46]+
    J[47]+J[48]+J[49]+J[50]+J[51]+J[52]+J[53]+J[54]+J[55]+J[56]+J[57]+J[58]+J[59]+J[60]+J[61]+J[62]+J[63]+
    J[64]+J[65], +H[0]-H[1]-H[2]+H[3]+H[4]+H[5]+H[6]+H[7]+H[8]+H[9]+H[10]+H[11]-J[0]-J[1]+J[2]+J[3]+J[4]+
    J[5]+J[6]+J[7]+J[8]+J[9]+J[10]+J[11]-J[12]-J[13]-J[14]-J[15]-J[16]-J[17]-J[18]-J[19]-J[20]-J[21]-J[22]-J[23]-J[24]-J[25]-J[26]-J[27]-J[28]-J[29]+
    J[30]+J[31]+J[32]+J[33]+J[34]+J[35]+J[36]+J[37]+J[38]+J[39]+J[40]+J[41]+J[42]+J[43]+J[44]+J[45]+J[46]+
    J[47]+J[48]+J[49]+J[50]+J[51]+J[52]+J[53]+J[54]+J[55]+J[56]+J[57]+J[58]+J[59]+J[60]+J[61]+J[62]+J[63]+
    J[64]+J[65], +H[0]-H[1]-H[2]+H[3]+H[4]+H[5]+H[6]+H[7]+H[8]+H[9]+H[10]-H[11]-J[0]-J[1]+J[2]+J[3]+J[4]+
    J[5]+J[6]+J[7]+J[8]+J[9]-J[10]+J[11]-J[12]-J[13]-J[14]-J[15]-J[16]-J[17]-J[18]-J[19]+J[20]-J[21]-J[22]-J[23]-J[24]-J[25]-J[26]-J[27]-J[28]+
    J[29]+J[30]+J[31]+J[32]+J[33]+J[34]+J[35]+J[36]-J[37]+J[38]+J[39]+J[40]+J[41]+J[42]+J[43]-J[44]+J[45]+
    J[46]+J[47]+J[48]+J[49]-J[50]+J[51]+J[52]+J[53]+J[54]-J[55]+J[56]+J[57]+J[58]-J[59]+J[60]+J[61]-J[62]+
    J[63]-J[64]-J[65], +H[0]-H[1]-H[2]+H[3]+H[4]+H[5]+H[6]+H[7]+H[8]+H[9]-H[10]+H[11]-J[0]-J[1]+J[2]+J[3]+
    J[4]+J[5]+J[6]+J[7]+J[8]-J[9]+J[10]+J[11]-J[12]-J[13]-J[14]-J[15]-J[16]-J[17]-J[18]+J[19]-J[20]-J[21]-J[22]-J[23]-J[24]-J[25]-J[26]-J[27]+
    J[28]-J[29]+J[30]+J[31]+J[32]+J[33]+J[34]+J[35]-J[36]+J[37]+J[38]+J[39]+J[40]+J[41]+J[42]-J[43]+J[44]+
    J[45]+J[46]+J[47]+J[48]-J[49]+J[50]+J[51]+J[52]+J[53]-J[54]+J[55]+J[56]+J[57]-J[58]+J[59]+J[60]-J[61]+
    J[62]-J[63]+J[64]-J[65], +H[0]-H[1]-H[2]+H[3]+H[4]+H[5]+H[6]+H[7]+H[8]+H[9]-H[10]-H[11]-J[0]-J[1]+J[2]+
    J[3]+J[4]+J[5]+J[6]+J[7]+J[8]-J[9]-J[10]+J[11]-J[12]-J[13]-J[14]-J[15]-J[16]-J[17]-J[18]+J[19]+J[20]-J[21]-J[22]-J[23]-J[24]-J[25]-J[26]-J[27]+
    J[28]+J[29]+J[30]+J[31]+J[32]+J[33]+J[34]+J[35]-J[36]-J[37]+J[38]+J[39]+J[40]+J[41]+J[42]-J[43]-J[44]+
    J[45]+J[46]+J[47]+J[48]-J[49]-J[50]+J[51]+J[52]+J[53]-J[54]-J[55]+J[56]+J[57]-J[58]-J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+
    J[65], +H[0]-H[1]-H[2]+H[3]+H[4]+H[5]+H[6]+H[7]+H[8]-H[9]+H[10]+H[11]-J[0]-J[1]+J[2]+J[3]+J[4]+J[5]+
    J[6]+J[7]-J[8]+J[9]+J[10]+J[11]-J[12]-J[13]-J[14]-J[15]-J[16]-J[17]+J[18]-J[19]-J[20]-J[21]-J[22]-J[23]-J[24]-J[25]-J[26]+
    J[27]-J[28]-J[29]+J[30]+J[31]+J[32]+J[33]+J[34]-J[35]+J[36]+J[37]+J[38]+J[39]+J[40]+J[41]-J[42]+J[43]+
    J[44]+J[45]+J[46]+J[47]-J[48]+J[49]+J[50]+J[51]+J[52]-J[53]+J[54]+J[55]+J[56]-J[57]+J[58]+J[59]-J[60]+
    J[61]+J[62]-J[63]-J[64]+J[65], +H[0]-H[1]-H[2]+H[3]+H[4]+H[5]+H[6]+H[7]+H[8]-H[9]+H[10]-H[11]-J[0]-J[1]+
    J[2]+J[3]+J[4]+J[5]+J[6]+J[7]-J[8]+J[9]-J[10]+J[11]-J[12]-J[13]-J[14]-J[15]-J[16]-J[17]+J[18]-J[19]+
    J[20]-J[21]-J[22]-J[23]-J[24]-J[25]-J[26]+J[27]-J[28]+J[29]+J[30]+J[31]+J[32]+J[33]+J[34]-J[35]+J[36]-J[37]+
    J[38]+J[39]+J[40]+J[41]-J[42]+J[43]-J[44]+J[45]+J[46]+J[47]-J[48]+J[49]-J[50]+J[51]+J[52]-J[53]+J[54]-J[55]+
    J[56]-J[57]+J[58]-J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]-H[1]-H[2]+H[3]+H[4]+H[5]+H[6]+H[7]+
    H[8]-H[9]-H[10]+H[11]-J[0]-J[1]+J[2]+J[3]+J[4]+J[5]+J[6]+J[7]-J[8]-J[9]+J[10]+J[11]-J[12]-J[13]-J[14]-J[15]-J[16]-J[17]+
    J[18]+J[19]-J[20]-J[21]-J[22]-J[23]-J[24]-J[25]-J[26]+J[27]+J[28]-J[29]+J[30]+J[31]+J[32]+J[33]+J[34]-J[35]-J[36]+
    J[37]+J[38]+J[39]+J[40]+J[41]-J[42]-J[43]+J[44]+J[45]+J[46]+J[47]-J[48]-J[49]+J[50]+J[51]+J[52]-J[53]-J[54]+
    J[55]+J[56]-J[57]-J[58]+J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]-H[1]-H[2]+H[3]+H[4]+H[5]+H[6]+
    H[7]+H[8]-H[9]-H[10]-H[11]-J[0]-J[1]+J[2]+J[3]+J[4]+J[5]+J[6]+J[7]-J[8]-J[9]-J[10]+J[11]-J[12]-J[13]-J[14]-J[15]-J[16]-J[17]+
    J[18]+J[19]+J[20]-J[21]-J[22]-J[23]-J[24]-J[25]-J[26]+J[27]+J[28]+J[29]+J[30]+J[31]+J[32]+J[33]+J[34]-J[35]-J[36]-J[37]+
    J[38]+J[39]+J[40]+J[41]-J[42]-J[43]-J[44]+J[45]+J[46]+J[47]-J[48]-J[49]-J[50]+J[51]+J[52]-J[53]-J[54]-J[55]+
    J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]-H[1]-H[2]+H[3]+H[4]+H[5]+H[6]+H[7]-H[8]+
    H[9]+H[10]+H[11]-J[0]-J[1]+J[2]+J[3]+J[4]+J[5]+J[6]-J[7]+J[8]+J[9]+J[10]+J[11]-J[12]-J[13]-J[14]-J[15]-J[16]+
    J[17]-J[18]-J[19]-J[20]-J[21]-J[22]-J[23]-J[24]-J[25]+J[26]-J[27]-J[28]-J[29]+J[30]+J[31]+J[32]+J[33]-J[34]+
    J[35]+J[36]+J[37]+J[38]+J[39]+J[40]-J[41]+J[42]+J[43]+J[44]+J[45]+J[46]-J[47]+J[48]+J[49]+J[50]+J[51]-J[52]+
    J[53]+J[54]+J[55]-J[56]+J[57]+J[58]+J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]-H[1]-H[2]+H[3]+
    H[4]+H[5]+H[6]+H[7]-H[8]+H[9]+H[10]-H[11]-J[0]-J[1]+J[2]+J[3]+J[4]+J[5]+J[6]-J[7]+J[8]+J[9]-J[10]+J[11]-J[12]-J[13]-J[14]-J[15]-J[16]+
    J[17]-J[18]-J[19]+J[20]-J[21]-J[22]-J[23]-J[24]-J[25]+J[26]-J[27]-J[28]+J[29]+J[30]+J[31]+J[32]+J[33]-J[34]+
    J[35]+J[36]-J[37]+J[38]+J[39]+J[40]-J[41]+J[42]+J[43]-J[44]+J[45]+J[46]-J[47]+J[48]+J[49]-J[50]+J[51]-J[52]+
    J[53]+J[54]-J[55]-J[56]+J[57]+J[58]-J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]-H[1]-H[2]+H[3]+
    H[4]+H[5]+H[6]+H[7]-H[8]+H[9]-H[10]+H[11]-J[0]-J[1]+J[2]+J[3]+J[4]+J[5]+J[6]-J[7]+J[8]-J[9]+J[10]+J[11]-J[12]-J[13]-J[14]-J[15]-J[16]+
    J[17]-J[18]+J[19]-J[20]-J[21]-J[22]-J[23]-J[24]-J[25]+J[26]-J[27]+J[28]-J[29]+J[30]+J[31]+J[32]+J[33]-J[34]+
    J[35]-J[36]+J[37]+J[38]+J[39]+J[40]-J[41]+J[42]-J[43]+J[44]+J[45]+J[46]-J[47]+J[48]-J[49]+J[50]+J[51]-J[52]+
    J[53]-J[54]+J[55]-J[56]+J[57]-J[58]+J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]-H[1]-H[2]+H[3]+
    H[4]+H[5]+H[6]+H[7]-H[8]+H[9]-H[10]-H[11]-J[0]-J[1]+J[2]+J[3]+J[4]+J[5]+J[6]-J[7]+J[8]-J[9]-J[10]+J[11]-J[12]-J[13]-J[14]-J[15]-J[16]+
    J[17]-J[18]+J[19]+J[20]-J[21]-J[22]-J[23]-J[24]-J[25]+J[26]-J[27]+J[28]+J[29]+J[30]+J[31]+J[32]+J[33]-J[34]+
    J[35]-J[36]-J[37]+J[38]+J[39]+J[40]-J[41]+J[42]-J[43]-J[44]+J[45]+J[46]-J[47]+J[48]-J[49]-J[50]+J[51]-J[52]+
    J[53]-J[54]-J[55]-J[56]+J[57]-J[58]-J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]-H[1]-H[2]+H[3]+
    H[4]+H[5]+H[6]+H[7]-H[8]-H[9]+H[10]+H[11]-J[0]-J[1]+J[2]+J[3]+J[4]+J[5]+J[6]-J[7]-J[8]+J[9]+J[10]+J[11]-J[12]-J[13]-J[14]-J[15]-J[16]+
    J[17]+J[18]-J[19]-J[20]-J[21]-J[22]-J[23]-J[24]-J[25]+J[26]+J[27]-J[28]-J[29]+J[30]+J[31]+J[32]+J[33]-J[34]-J[35]+
    J[36]+J[37]+J[38]+J[39]+J[40]-J[41]-J[42]+J[43]+J[44]+J[45]+J[46]-J[47]-J[48]+J[49]+J[50]+J[51]-J[52]-J[53]+
    J[54]+J[55]-J[56]-J[57]+J[58]+J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]-H[1]-H[2]+H[3]+H[4]+H[5]+
    H[6]+H[7]-H[8]-H[9]+H[10]-H[11]-J[0]-J[1]+J[2]+J[3]+J[4]+J[5]+J[6]-J[7]-J[8]+J[9]-J[10]+J[11]-J[12]-J[13]-J[14]-J[15]-J[16]+
    J[17]+J[18]-J[19]+J[20]-J[21]-J[22]-J[23]-J[24]-J[25]+J[26]+J[27]-J[28]+J[29]+J[30]+J[31]+J[32]+J[33]-J[34]-J[35]+
    J[36]-J[37]+J[38]+J[39]+J[40]-J[41]-J[42]+J[43]-J[44]+J[45]+J[46]-J[47]-J[48]+J[49]-J[50]+J[51]-J[52]-J[53]+
    J[54]-J[55]-J[56]-J[57]+J[58]-J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]-H[1]-H[2]+H[3]+H[4]+H[5]+
    H[6]+H[7]-H[8]-H[9]-H[10]+H[11]-J[0]-J[1]+J[2]+J[3]+J[4]+J[5]+J[6]-J[7]-J[8]-J[9]+J[10]+J[11]-J[12]-J[13]-J[14]-J[15]-J[16]+
    J[17]+J[18]+J[19]-J[20]-J[21]-J[22]-J[23]-J[24]-J[25]+J[26]+J[27]+J[28]-J[29]+J[30]+J[31]+J[32]+J[33]-J[34]-J[35]-J[36]+
    J[37]+J[38]+J[39]+J[40]-J[41]-J[42]-J[43]+J[44]+J[45]+J[46]-J[47]-J[48]-J[49]+J[50]+J[51]-J[52]-J[53]-J[54]+
    J[55]-J[56]-J[57]-J[58]+J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]-H[1]-H[2]+H[3]+H[4]+H[5]+H[6]+
    H[7]-H[8]-H[9]-H[10]-H[11]-J[0]-J[1]+J[2]+J[3]+J[4]+J[5]+J[6]-J[7]-J[8]-J[9]-J[10]+J[11]-J[12]-J[13]-J[14]-J[15]-J[16]+
    J[17]+J[18]+J[19]+J[20]-J[21]-J[22]-J[23]-J[24]-J[25]+J[26]+J[27]+J[28]+J[29]+J[30]+J[31]+J[32]+J[33]-J[34]-J[35]-J[36]-J[37]+
    J[38]+J[39]+J[40]-J[41]-J[42]-J[43]-J[44]+J[45]+J[46]-J[47]-J[48]-J[49]-J[50]+J[51]-J[52]-J[53]-J[54]-J[55]-J[56]-J[57]-J[58]-J[59]+
    J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]-H[1]-H[2]+H[3]+H[4]+H[5]+H[6]-H[7]+H[8]+H[9]+H[10]+H[11]-J[0]-J[1]+
    J[2]+J[3]+J[4]+J[5]-J[6]+J[7]+J[8]+J[9]+J[10]+J[11]-J[12]-J[13]-J[14]-J[15]+J[16]-J[17]-J[18]-J[19]-J[20]-J[21]-J[22]-J[23]-J[24]+
    J[25]-J[26]-J[27]-J[28]-J[29]+J[30]+J[31]+J[32]-J[33]+J[34]+J[35]+J[36]+J[37]+J[38]+J[39]-J[40]+J[41]+
    J[42]+J[43]+J[44]+J[45]-J[46]+J[47]+J[48]+J[49]+J[50]-J[51]+J[52]+J[53]+J[54]+J[55]-J[56]-J[57]-J[58]-J[59]+
    J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]-H[1]-H[2]+H[3]+H[4]+H[5]+H[6]-H[7]+H[8]+H[9]+H[10]-H[11]-J[0]-J[1]+
    J[2]+J[3]+J[4]+J[5]-J[6]+J[7]+J[8]+J[9]-J[10]+J[11]-J[12]-J[13]-J[14]-J[15]+J[16]-J[17]-J[18]-J[19]+
    J[20]-J[21]-J[22]-J[23]-J[24]+J[25]-J[26]-J[27]-J[28]+J[29]+J[30]+J[31]+J[32]-J[33]+J[34]+J[35]+J[36]-J[37]+
    J[38]+J[39]-J[40]+J[41]+J[42]+J[43]-J[44]+J[45]-J[46]+J[47]+J[48]+J[49]-J[50]-J[51]+J[52]+J[53]+J[54]-J[55]-J[56]-J[57]-J[58]+
    J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]-H[1]-H[2]+H[3]+H[4]+H[5]+H[6]-H[7]+H[8]+H[9]-H[10]+
    H[11]-J[0]-J[1]+J[2]+J[3]+J[4]+J[5]-J[6]+J[7]+J[8]-J[9]+J[10]+J[11]-J[12]-J[13]-J[14]-J[15]+J[16]-J[17]-J[18]+
    J[19]-J[20]-J[21]-J[22]-J[23]-J[24]+J[25]-J[26]-J[27]+J[28]-J[29]+J[30]+J[31]+J[32]-J[33]+J[34]+J[35]-J[36]+
    J[37]+J[38]+J[39]-J[40]+J[41]+J[42]-J[43]+J[44]+J[45]-J[46]+J[47]+J[48]-J[49]+J[50]-J[51]+J[52]+J[53]-J[54]+
    J[55]-J[56]-J[57]+J[58]-J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]-H[1]-H[2]+H[3]+H[4]+H[5]+H[6]-H[7]+
    H[8]+H[9]-H[10]-H[11]-J[0]-J[1]+J[2]+J[3]+J[4]+J[5]-J[6]+J[7]+J[8]-J[9]-J[10]+J[11]-J[12]-J[13]-J[14]-J[15]+
    J[16]-J[17]-J[18]+J[19]+J[20]-J[21]-J[22]-J[23]-J[24]+J[25]-J[26]-J[27]+J[28]+J[29]+J[30]+J[31]+J[32]-J[33]+
    J[34]+J[35]-J[36]-J[37]+J[38]+J[39]-J[40]+J[41]+J[42]-J[43]-J[44]+J[45]-J[46]+J[47]+J[48]-J[49]-J[50]-J[51]+
    J[52]+J[53]-J[54]-J[55]-J[56]-J[57]+J[58]+J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]-H[1]-H[2]+
    H[3]+H[4]+H[5]+H[6]-H[7]+H[8]-H[9]+H[10]+H[11]-J[0]-J[1]+J[2]+J[3]+J[4]+J[5]-J[6]+J[7]-J[8]+J[9]+J[10]+
    J[11]-J[12]-J[13]-J[14]-J[15]+J[16]-J[17]+J[18]-J[19]-J[20]-J[21]-J[22]-J[23]-J[24]+J[25]-J[26]+J[27]-J[28]-J[29]+
    J[30]+J[31]+J[32]-J[33]+J[34]-J[35]+J[36]+J[37]+J[38]+J[39]-J[40]+J[41]-J[42]+J[43]+J[44]+J[45]-J[46]+
    J[47]-J[48]+J[49]+J[50]-J[51]+J[52]-J[53]+J[54]+J[55]-J[56]+J[57]-J[58]-J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+
    J[65], +H[0]-H[1]-H[2]+H[3]+H[4]+H[5]+H[6]-H[7]+H[8]-H[9]+H[10]-H[11]-J[0]-J[1]+J[2]+J[3]+J[4]+J[5]-J[6]+
    J[7]-J[8]+J[9]-J[10]+J[11]-J[12]-J[13]-J[14]-J[15]+J[16]-J[17]+J[18]-J[19]+J[20]-J[21]-J[22]-J[23]-J[24]+
    J[25]-J[26]+J[27]-J[28]+J[29]+J[30]+J[31]+J[32]-J[33]+J[34]-J[35]+J[36]-J[37]+J[38]+J[39]-J[40]+J[41]-J[42]+
    J[43]-J[44]+J[45]-J[46]+J[47]-J[48]+J[49]-J[50]-J[51]+J[52]-J[53]+J[54]-J[55]-J[56]+J[57]-J[58]+J[59]-J[60]+
    J[61]-J[62]-J[63]+J[64]-J[65], +H[0]-H[1]-H[2]+H[3]+H[4]+H[5]+H[6]-H[7]+H[8]-H[9]-H[10]+H[11]-J[0]-J[1]+
    J[2]+J[3]+J[4]+J[5]-J[6]+J[7]-J[8]-J[9]+J[10]+J[11]-J[12]-J[13]-J[14]-J[15]+J[16]-J[17]+J[18]+J[19]-J[20]-J[21]-J[22]-J[23]-J[24]+
    J[25]-J[26]+J[27]+J[28]-J[29]+J[30]+J[31]+J[32]-J[33]+J[34]-J[35]-J[36]+J[37]+J[38]+J[39]-J[40]+J[41]-J[42]-J[43]+
    J[44]+J[45]-J[46]+J[47]-J[48]-J[49]+J[50]-J[51]+J[52]-J[53]-J[54]+J[55]-J[56]+J[57]+J[58]-J[59]-J[60]-J[61]+
    J[62]+J[63]-J[64]-J[65], +H[0]-H[1]-H[2]+H[3]+H[4]+H[5]+H[6]-H[7]+H[8]-H[9]-H[10]-H[11]-J[0]-J[1]+J[2]+
    J[3]+J[4]+J[5]-J[6]+J[7]-J[8]-J[9]-J[10]+J[11]-J[12]-J[13]-J[14]-J[15]+J[16]-J[17]+J[18]+J[19]+J[20]-J[21]-J[22]-J[23]-J[24]+
    J[25]-J[26]+J[27]+J[28]+J[29]+J[30]+J[31]+J[32]-J[33]+J[34]-J[35]-J[36]-J[37]+J[38]+J[39]-J[40]+J[41]-J[42]-J[43]-J[44]+
    J[45]-J[46]+J[47]-J[48]-J[49]-J[50]-J[51]+J[52]-J[53]-J[54]-J[55]-J[56]+J[57]+J[58]+J[59]-J[60]-J[61]-J[62]+
    J[63]+J[64]+J[65], +H[0]-H[1]-H[2]+H[3]+H[4]+H[5]+H[6]-H[7]-H[8]+H[9]+H[10]+H[11]-J[0]-J[1]+J[2]+J[3]+
    J[4]+J[5]-J[6]-J[7]+J[8]+J[9]+J[10]+J[11]-J[12]-J[13]-J[14]-J[15]+J[16]+J[17]-J[18]-J[19]-J[20]-J[21]-J[22]-J[23]-J[24]+
    J[25]+J[26]-J[27]-J[28]-J[29]+J[30]+J[31]+J[32]-J[33]-J[34]+J[35]+J[36]+J[37]+J[38]+J[39]-J[40]-J[41]+
    J[42]+J[43]+J[44]+J[45]-J[46]-J[47]+J[48]+J[49]+J[50]-J[51]-J[52]+J[53]+J[54]+J[55]+J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+
    J[63]+J[64]+J[65], +H[0]-H[1]-H[2]+H[3]+H[4]+H[5]+H[6]-H[7]-H[8]+H[9]+H[10]-H[11]-J[0]-J[1]+J[2]+J[3]+
    J[4]+J[5]-J[6]-J[7]+J[8]+J[9]-J[10]+J[11]-J[12]-J[13]-J[14]-J[15]+J[16]+J[17]-J[18]-J[19]+J[20]-J[21]-J[22]-J[23]-J[24]+
    J[25]+J[26]-J[27]-J[28]+J[29]+J[30]+J[31]+J[32]-J[33]-J[34]+J[35]+J[36]-J[37]+J[38]+J[39]-J[40]-J[41]+
    J[42]+J[43]-J[44]+J[45]-J[46]-J[47]+J[48]+J[49]-J[50]-J[51]-J[52]+J[53]+J[54]-J[55]+J[56]-J[57]-J[58]+
    J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]-H[1]-H[2]+H[3]+H[4]+H[5]+H[6]-H[7]-H[8]+H[9]-H[10]+
    H[11]-J[0]-J[1]+J[2]+J[3]+J[4]+J[5]-J[6]-J[7]+J[8]-J[9]+J[10]+J[11]-J[12]-J[13]-J[14]-J[15]+J[16]+J[17]-J[18]+
    J[19]-J[20]-J[21]-J[22]-J[23]-J[24]+J[25]+J[26]-J[27]+J[28]-J[29]+J[30]+J[31]+J[32]-J[33]-J[34]+J[35]-J[36]+
    J[37]+J[38]+J[39]-J[40]-J[41]+J[42]-J[43]+J[44]+J[45]-J[46]-J[47]+J[48]-J[49]+J[50]-J[51]-J[52]+J[53]-J[54]+
    J[55]+J[56]-J[57]+J[58]-J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]-H[1]-H[2]+H[3]+H[4]+H[5]+H[6]-H[7]-H[8]+
    H[9]-H[10]-H[11]-J[0]-J[1]+J[2]+J[3]+J[4]+J[5]-J[6]-J[7]+J[8]-J[9]-J[10]+J[11]-J[12]-J[13]-J[14]-J[15]+
    J[16]+J[17]-J[18]+J[19]+J[20]-J[21]-J[22]-J[23]-J[24]+J[25]+J[26]-J[27]+J[28]+J[29]+J[30]+J[31]+J[32]-J[33]-J[34]+
    J[35]-J[36]-J[37]+J[38]+J[39]-J[40]-J[41]+J[42]-J[43]-J[44]+J[45]-J[46]-J[47]+J[48]-J[49]-J[50]-J[51]-J[52]+
    J[53]-J[54]-J[55]+J[56]-J[57]+J[58]+J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]-H[1]-H[2]+H[3]+
    H[4]+H[5]+H[6]-H[7]-H[8]-H[9]+H[10]+H[11]-J[0]-J[1]+J[2]+J[3]+J[4]+J[5]-J[6]-J[7]-J[8]+J[9]+J[10]+J[11]-J[12]-J[13]-J[14]-J[15]+
    J[16]+J[17]+J[18]-J[19]-J[20]-J[21]-J[22]-J[23]-J[24]+J[25]+J[26]+J[27]-J[28]-J[29]+J[30]+J[31]+J[32]-J[33]-J[34]-J[35]+
    J[36]+J[37]+J[38]+J[39]-J[40]-J[41]-J[42]+J[43]+J[44]+J[45]-J[46]-J[47]-J[48]+J[49]+J[50]-J[51]-J[52]-J[53]+
    J[54]+J[55]+J[56]+J[57]-J[58]-J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]-H[1]-H[2]+H[3]+H[4]+H[5]+
    H[6]-H[7]-H[8]-H[9]+H[10]-H[11]-J[0]-J[1]+J[2]+J[3]+J[4]+J[5]-J[6]-J[7]-J[8]+J[9]-J[10]+J[11]-J[12]-J[13]-J[14]-J[15]+
    J[16]+J[17]+J[18]-J[19]+J[20]-J[21]-J[22]-J[23]-J[24]+J[25]+J[26]+J[27]-J[28]+J[29]+J[30]+J[31]+J[32]-J[33]-J[34]-J[35]+
    J[36]-J[37]+J[38]+J[39]-J[40]-J[41]-J[42]+J[43]-J[44]+J[45]-J[46]-J[47]-J[48]+J[49]-J[50]-J[51]-J[52]-J[53]+
    J[54]-J[55]+J[56]+J[57]-J[58]+J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]-H[1]-H[2]+H[3]+H[4]+H[5]+
    H[6]-H[7]-H[8]-H[9]-H[10]+H[11]-J[0]-J[1]+J[2]+J[3]+J[4]+J[5]-J[6]-J[7]-J[8]-J[9]+J[10]+J[11]-J[12]-J[13]-J[14]-J[15]+
    J[16]+J[17]+J[18]+J[19]-J[20]-J[21]-J[22]-J[23]-J[24]+J[25]+J[26]+J[27]+J[28]-J[29]+J[30]+J[31]+J[32]-J[33]-J[34]-J[35]-J[36]+
    J[37]+J[38]+J[39]-J[40]-J[41]-J[42]-J[43]+J[44]+J[45]-J[46]-J[47]-J[48]-J[49]+J[50]-J[51]-J[52]-J[53]-J[54]+
    J[55]+J[56]+J[57]+J[58]-J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]-H[1]-H[2]+H[3]+H[4]+H[5]+H[6]-H[7]-H[8]-H[9]-H[10]-H[11]-J[0]-J[1]+
    J[2]+J[3]+J[4]+J[5]-J[6]-J[7]-J[8]-J[9]-J[10]+J[11]-J[12]-J[13]-J[14]-J[15]+J[16]+J[17]+J[18]+J[19]+
    J[20]-J[21]-J[22]-J[23]-J[24]+J[25]+J[26]+J[27]+J[28]+J[29]+J[30]+J[31]+J[32]-J[33]-J[34]-J[35]-J[36]-J[37]+
    J[38]+J[39]-J[40]-J[41]-J[42]-J[43]-J[44]+J[45]-J[46]-J[47]-J[48]-J[49]-J[50]-J[51]-J[52]-J[53]-J[54]-J[55]+
    J[56]+J[57]+J[58]+J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]-H[1]-H[2]+H[3]+H[4]+H[5]-H[6]+H[7]+
    H[8]+H[9]+H[10]+H[11]-J[0]-J[1]+J[2]+J[3]+J[4]-J[5]+J[6]+J[7]+J[8]+J[9]+J[10]+J[11]-J[12]-J[13]-J[14]+
    J[15]-J[16]-J[17]-J[18]-J[19]-J[20]-J[21]-J[22]-J[23]+J[24]-J[25]-J[26]-J[27]-J[28]-J[29]+J[30]+J[31]-J[32]+
    J[33]+J[34]+J[35]+J[36]+J[37]+J[38]-J[39]+J[40]+J[41]+J[42]+J[43]+J[44]-J[45]+J[46]+J[47]+J[48]+J[49]+
    J[50]-J[51]-J[52]-J[53]-J[54]-J[55]+J[56]+J[57]+J[58]+J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]-H[1]-H[2]+
    H[3]+H[4]+H[5]-H[6]+H[7]+H[8]+H[9]+H[10]-H[11]-J[0]-J[1]+J[2]+J[3]+J[4]-J[5]+J[6]+J[7]+J[8]+J[9]-J[10]+
    J[11]-J[12]-J[13]-J[14]+J[15]-J[16]-J[17]-J[18]-J[19]+J[20]-J[21]-J[22]-J[23]+J[24]-J[25]-J[26]-J[27]-J[28]+
    J[29]+J[30]+J[31]-J[32]+J[33]+J[34]+J[35]+J[36]-J[37]+J[38]-J[39]+J[40]+J[41]+J[42]+J[43]-J[44]-J[45]+
    J[46]+J[47]+J[48]+J[49]-J[50]-J[51]-J[52]-J[53]-J[54]+J[55]+J[56]+J[57]+J[58]-J[59]+J[60]+J[61]-J[62]+
    J[63]-J[64]-J[65], +H[0]-H[1]-H[2]+H[3]+H[4]+H[5]-H[6]+H[7]+H[8]+H[9]-H[10]+H[11]-J[0]-J[1]+J[2]+J[3]+
    J[4]-J[5]+J[6]+J[7]+J[8]-J[9]+J[10]+J[11]-J[12]-J[13]-J[14]+J[15]-J[16]-J[17]-J[18]+J[19]-J[20]-J[21]-J[22]-J[23]+
    J[24]-J[25]-J[26]-J[27]+J[28]-J[29]+J[30]+J[31]-J[32]+J[33]+J[34]+J[35]-J[36]+J[37]+J[38]-J[39]+J[40]+
    J[41]+J[42]-J[43]+J[44]-J[45]+J[46]+J[47]+J[48]-J[49]+J[50]-J[51]-J[52]-J[53]+J[54]-J[55]+J[56]+J[57]-J[58]+
    J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]-H[1]-H[2]+H[3]+H[4]+H[5]-H[6]+H[7]+H[8]+H[9]-H[10]-H[11]-J[0]-J[1]+
    J[2]+J[3]+J[4]-J[5]+J[6]+J[7]+J[8]-J[9]-J[10]+J[11]-J[12]-J[13]-J[14]+J[15]-J[16]-J[17]-J[18]+J[19]+
    J[20]-J[21]-J[22]-J[23]+J[24]-J[25]-J[26]-J[27]+J[28]+J[29]+J[30]+J[31]-J[32]+J[33]+J[34]+J[35]-J[36]-J[37]+
    J[38]-J[39]+J[40]+J[41]+J[42]-J[43]-J[44]-J[45]+J[46]+J[47]+J[48]-J[49]-J[50]-J[51]-J[52]-J[53]+J[54]+
    J[55]+J[56]+J[57]-J[58]-J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]-H[1]-H[2]+H[3]+H[4]+H[5]-H[6]+
    H[7]+H[8]-H[9]+H[10]+H[11]-J[0]-J[1]+J[2]+J[3]+J[4]-J[5]+J[6]+J[7]-J[8]+J[9]+J[10]+J[11]-J[12]-J[13]-J[14]+
    J[15]-J[16]-J[17]+J[18]-J[19]-J[20]-J[21]-J[22]-J[23]+J[24]-J[25]-J[26]+J[27]-J[28]-J[29]+J[30]+J[31]-J[32]+
    J[33]+J[34]-J[35]+J[36]+J[37]+J[38]-J[39]+J[40]+J[41]-J[42]+J[43]+J[44]-J[45]+J[46]+J[47]-J[48]+J[49]+
    J[50]-J[51]-J[52]+J[53]-J[54]-J[55]+J[56]-J[57]+J[58]+J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]-H[1]-H[2]+
    H[3]+H[4]+H[5]-H[6]+H[7]+H[8]-H[9]+H[10]-H[11]-J[0]-J[1]+J[2]+J[3]+J[4]-J[5]+J[6]+J[7]-J[8]+J[9]-J[10]+
    J[11]-J[12]-J[13]-J[14]+J[15]-J[16]-J[17]+J[18]-J[19]+J[20]-J[21]-J[22]-J[23]+J[24]-J[25]-J[26]+J[27]-J[28]+
    J[29]+J[30]+J[31]-J[32]+J[33]+J[34]-J[35]+J[36]-J[37]+J[38]-J[39]+J[40]+J[41]-J[42]+J[43]-J[44]-J[45]+
    J[46]+J[47]-J[48]+J[49]-J[50]-J[51]-J[52]+J[53]-J[54]+J[55]+J[56]-J[57]+J[58]-J[59]-J[60]+J[61]-J[62]-J[63]+
    J[64]-J[65], +H[0]-H[1]-H[2]+H[3]+H[4]+H[5]-H[6]+H[7]+H[8]-H[9]-H[10]+H[11]-J[0]-J[1]+J[2]+J[3]+J[4]-J[5]+
    J[6]+J[7]-J[8]-J[9]+J[10]+J[11]-J[12]-J[13]-J[14]+J[15]-J[16]-J[17]+J[18]+J[19]-J[20]-J[21]-J[22]-J[23]+
    J[24]-J[25]-J[26]+J[27]+J[28]-J[29]+J[30]+J[31]-J[32]+J[33]+J[34]-J[35]-J[36]+J[37]+J[38]-J[39]+J[40]+
    J[41]-J[42]-J[43]+J[44]-J[45]+J[46]+J[47]-J[48]-J[49]+J[50]-J[51]-J[52]+J[53]+J[54]-J[55]+J[56]-J[57]-J[58]+
    J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]-H[1]-H[2]+H[3]+H[4]+H[5]-H[6]+H[7]+H[8]-H[9]-H[10]-H[11]-J[0]-J[1]+
    J[2]+J[3]+J[4]-J[5]+J[6]+J[7]-J[8]-J[9]-J[10]+J[11]-J[12]-J[13]-J[14]+J[15]-J[16]-J[17]+J[18]+J[19]+
    J[20]-J[21]-J[22]-J[23]+J[24]-J[25]-J[26]+J[27]+J[28]+J[29]+J[30]+J[31]-J[32]+J[33]+J[34]-J[35]-J[36]-J[37]+
    J[38]-J[39]+J[40]+J[41]-J[42]-J[43]-J[44]-J[45]+J[46]+J[47]-J[48]-J[49]-J[50]-J[51]-J[52]+J[53]+J[54]+
    J[55]+J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]-H[1]-H[2]+H[3]+H[4]+H[5]-H[6]+
    H[7]-H[8]+H[9]+H[10]+H[11]-J[0]-J[1]+J[2]+J[3]+J[4]-J[5]+J[6]-J[7]+J[8]+J[9]+J[10]+J[11]-J[12]-J[13]-J[14]+
    J[15]-J[16]+J[17]-J[18]-J[19]-J[20]-J[21]-J[22]-J[23]+J[24]-J[25]+J[26]-J[27]-J[28]-J[29]+J[30]+J[31]-J[32]+
    J[33]-J[34]+J[35]+J[36]+J[37]+J[38]-J[39]+J[40]-J[41]+J[42]+J[43]+J[44]-J[45]+J[46]-J[47]+J[48]+J[49]+
    J[50]-J[51]+J[52]-J[53]-J[54]-J[55]-J[56]+J[57]+J[58]+J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]-H[1]-H[2]+
    H[3]+H[4]+H[5]-H[6]+H[7]-H[8]+H[9]+H[10]-H[11]-J[0]-J[1]+J[2]+J[3]+J[4]-J[5]+J[6]-J[7]+J[8]+J[9]-J[10]+
    J[11]-J[12]-J[13]-J[14]+J[15]-J[16]+J[17]-J[18]-J[19]+J[20]-J[21]-J[22]-J[23]+J[24]-J[25]+J[26]-J[27]-J[28]+
    J[29]+J[30]+J[31]-J[32]+J[33]-J[34]+J[35]+J[36]-J[37]+J[38]-J[39]+J[40]-J[41]+J[42]+J[43]-J[44]-J[45]+
    J[46]-J[47]+J[48]+J[49]-J[50]-J[51]+J[52]-J[53]-J[54]+J[55]-J[56]+J[57]+J[58]-J[59]-J[60]-J[61]+J[62]+
    J[63]-J[64]-J[65], +H[0]-H[1]-H[2]+H[3]+H[4]+H[5]-H[6]+H[7]-H[8]+H[9]-H[10]+H[11]-J[0]-J[1]+J[2]+J[3]+
    J[4]-J[5]+J[6]-J[7]+J[8]-J[9]+J[10]+J[11]-J[12]-J[13]-J[14]+J[15]-J[16]+J[17]-J[18]+J[19]-J[20]-J[21]-J[22]-J[23]+
    J[24]-J[25]+J[26]-J[27]+J[28]-J[29]+J[30]+J[31]-J[32]+J[33]-J[34]+J[35]-J[36]+J[37]+J[38]-J[39]+J[40]-J[41]+
    J[42]-J[43]+J[44]-J[45]+J[46]-J[47]+J[48]-J[49]+J[50]-J[51]+J[52]-J[53]+J[54]-J[55]-J[56]+J[57]-J[58]+
    J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]-H[1]-H[2]+H[3]+H[4]+H[5]-H[6]+H[7]-H[8]+H[9]-H[10]-H[11]-J[0]-J[1]+
    J[2]+J[3]+J[4]-J[5]+J[6]-J[7]+J[8]-J[9]-J[10]+J[11]-J[12]-J[13]-J[14]+J[15]-J[16]+J[17]-J[18]+J[19]+
    J[20]-J[21]-J[22]-J[23]+J[24]-J[25]+J[26]-J[27]+J[28]+J[29]+J[30]+J[31]-J[32]+J[33]-J[34]+J[35]-J[36]-J[37]+
    J[38]-J[39]+J[40]-J[41]+J[42]-J[43]-J[44]-J[45]+J[46]-J[47]+J[48]-J[49]-J[50]-J[51]+J[52]-J[53]+J[54]+
    J[55]-J[56]+J[57]-J[58]-J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]-H[1]-H[2]+H[3]+H[4]+H[5]-H[6]+
    H[7]-H[8]-H[9]+H[10]+H[11]-J[0]-J[1]+J[2]+J[3]+J[4]-J[5]+J[6]-J[7]-J[8]+J[9]+J[10]+J[11]-J[12]-J[13]-J[14]+
    J[15]-J[16]+J[17]+J[18]-J[19]-J[20]-J[21]-J[22]-J[23]+J[24]-J[25]+J[26]+J[27]-J[28]-J[29]+J[30]+J[31]-J[32]+
    J[33]-J[34]-J[35]+J[36]+J[37]+J[38]-J[39]+J[40]-J[41]-J[42]+J[43]+J[44]-J[45]+J[46]-J[47]-J[48]+J[49]+
    J[50]-J[51]+J[52]+J[53]-J[54]-J[55]-J[56]-J[57]+J[58]+J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]-H[1]-H[2]+
    H[3]+H[4]+H[5]-H[6]+H[7]-H[8]-H[9]+H[10]-H[11]-J[0]-J[1]+J[2]+J[3]+J[4]-J[5]+J[6]-J[7]-J[8]+J[9]-J[10]+
    J[11]-J[12]-J[13]-J[14]+J[15]-J[16]+J[17]+J[18]-J[19]+J[20]-J[21]-J[22]-J[23]+J[24]-J[25]+J[26]+J[27]-J[28]+
    J[29]+J[30]+J[31]-J[32]+J[33]-J[34]-J[35]+J[36]-J[37]+J[38]-J[39]+J[40]-J[41]-J[42]+J[43]-J[44]-J[45]+
    J[46]-J[47]-J[48]+J[49]-J[50]-J[51]+J[52]+J[53]-J[54]+J[55]-J[56]-J[57]+J[58]-J[59]+J[60]-J[61]+J[62]-J[63]+
    J[64]-J[65], +H[0]-H[1]-H[2]+H[3]+H[4]+H[5]-H[6]+H[7]-H[8]-H[9]-H[10]+H[11]-J[0]-J[1]+J[2]+J[3]+J[4]-J[5]+
    J[6]-J[7]-J[8]-J[9]+J[10]+J[11]-J[12]-J[13]-J[14]+J[15]-J[16]+J[17]+J[18]+J[19]-J[20]-J[21]-J[22]-J[23]+
    J[24]-J[25]+J[26]+J[27]+J[28]-J[29]+J[30]+J[31]-J[32]+J[33]-J[34]-J[35]-J[36]+J[37]+J[38]-J[39]+J[40]-J[41]-J[42]-J[43]+
    J[44]-J[45]+J[46]-J[47]-J[48]-J[49]+J[50]-J[51]+J[52]+J[53]+J[54]-J[55]-J[56]-J[57]-J[58]+J[59]+J[60]+
    J[61]-J[62]+J[63]-J[64]-J[65], +H[0]-H[1]-H[2]+H[3]+H[4]+H[5]-H[6]+H[7]-H[8]-H[9]-H[10]-H[11]-J[0]-J[1]+
    J[2]+J[3]+J[4]-J[5]+J[6]-J[7]-J[8]-J[9]-J[10]+J[11]-J[12]-J[13]-J[14]+J[15]-J[16]+J[17]+J[18]+J[19]+
    J[20]-J[21]-J[22]-J[23]+J[24]-J[25]+J[26]+J[27]+J[28]+J[29]+J[30]+J[31]-J[32]+J[33]-J[34]-J[35]-J[36]-J[37]+
    J[38]-J[39]+J[40]-J[41]-J[42]-J[43]-J[44]-J[45]+J[46]-J[47]-J[48]-J[49]-J[50]-J[51]+J[52]+J[53]+J[54]+
    J[55]-J[56]-J[57]-J[58]-J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]-H[1]-H[2]+H[3]+H[4]+H[5]-H[6]-H[7]+
    H[8]+H[9]+H[10]+H[11]-J[0]-J[1]+J[2]+J[3]+J[4]-J[5]-J[6]+J[7]+J[8]+J[9]+J[10]+J[11]-J[12]-J[13]-J[14]+
    J[15]+J[16]-J[17]-J[18]-J[19]-J[20]-J[21]-J[22]-J[23]+J[24]+J[25]-J[26]-J[27]-J[28]-J[29]+J[30]+J[31]-J[32]-J[33]+
    J[34]+J[35]+J[36]+J[37]+J[38]-J[39]-J[40]+J[41]+J[42]+J[43]+J[44]-J[45]-J[46]+J[47]+J[48]+J[49]+J[50]+
    J[51]-J[52]-J[53]-J[54]-J[55]-J[56]-J[57]-J[58]-J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]-H[1]-H[2]+
    H[3]+H[4]+H[5]-H[6]-H[7]+H[8]+H[9]+H[10]-H[11]-J[0]-J[1]+J[2]+J[3]+J[4]-J[5]-J[6]+J[7]+J[8]+J[9]-J[10]+
    J[11]-J[12]-J[13]-J[14]+J[15]+J[16]-J[17]-J[18]-J[19]+J[20]-J[21]-J[22]-J[23]+J[24]+J[25]-J[26]-J[27]-J[28]+
    J[29]+J[30]+J[31]-J[32]-J[33]+J[34]+J[35]+J[36]-J[37]+J[38]-J[39]-J[40]+J[41]+J[42]+J[43]-J[44]-J[45]-J[46]+
    J[47]+J[48]+J[49]-J[50]+J[51]-J[52]-J[53]-J[54]+J[55]-J[56]-J[57]-J[58]+J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +
    H[0]-H[1]-H[2]+H[3]+H[4]+H[5]-H[6]-H[7]+H[8]+H[9]-H[10]+H[11]-J[0]-J[1]+J[2]+J[3]+J[4]-J[5]-J[6]+J[7]+
    J[8]-J[9]+J[10]+J[11]-J[12]-J[13]-J[14]+J[15]+J[16]-J[17]-J[18]+J[19]-J[20]-J[21]-J[22]-J[23]+J[24]+
    J[25]-J[26]-J[27]+J[28]-J[29]+J[30]+J[31]-J[32]-J[33]+J[34]+J[35]-J[36]+J[37]+J[38]-J[39]-J[40]+J[41]+
    J[42]-J[43]+J[44]-J[45]-J[46]+J[47]+J[48]-J[49]+J[50]+J[51]-J[52]-J[53]+J[54]-J[55]-J[56]-J[57]+J[58]-J[59]+
    J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]-H[1]-H[2]+H[3]+H[4]+H[5]-H[6]-H[7]+H[8]+H[9]-H[10]-H[11]-J[0]-J[1]+
    J[2]+J[3]+J[4]-J[5]-J[6]+J[7]+J[8]-J[9]-J[10]+J[11]-J[12]-J[13]-J[14]+J[15]+J[16]-J[17]-J[18]+J[19]+
    J[20]-J[21]-J[22]-J[23]+J[24]+J[25]-J[26]-J[27]+J[28]+J[29]+J[30]+J[31]-J[32]-J[33]+J[34]+J[35]-J[36]-J[37]+
    J[38]-J[39]-J[40]+J[41]+J[42]-J[43]-J[44]-J[45]-J[46]+J[47]+J[48]-J[49]-J[50]+J[51]-J[52]-J[53]+J[54]+
    J[55]-J[56]-J[57]+J[58]+J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]-H[1]-H[2]+H[3]+H[4]+H[5]-H[6]-H[7]+
    H[8]-H[9]+H[10]+H[11]-J[0]-J[1]+J[2]+J[3]+J[4]-J[5]-J[6]+J[7]-J[8]+J[9]+J[10]+J[11]-J[12]-J[13]-J[14]+
    J[15]+J[16]-J[17]+J[18]-J[19]-J[20]-J[21]-J[22]-J[23]+J[24]+J[25]-J[26]+J[27]-J[28]-J[29]+J[30]+J[31]-J[32]-J[33]+
    J[34]-J[35]+J[36]+J[37]+J[38]-J[39]-J[40]+J[41]-J[42]+J[43]+J[44]-J[45]-J[46]+J[47]-J[48]+J[49]+J[50]+
    J[51]-J[52]+J[53]-J[54]-J[55]-J[56]+J[57]-J[58]-J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]-H[1]-H[2]+
    H[3]+H[4]+H[5]-H[6]-H[7]+H[8]-H[9]+H[10]-H[11]-J[0]-J[1]+J[2]+J[3]+J[4]-J[5]-J[6]+J[7]-J[8]+J[9]-J[10]+
    J[11]-J[12]-J[13]-J[14]+J[15]+J[16]-J[17]+J[18]-J[19]+J[20]-J[21]-J[22]-J[23]+J[24]+J[25]-J[26]+J[27]-J[28]+
    J[29]+J[30]+J[31]-J[32]-J[33]+J[34]-J[35]+J[36]-J[37]+J[38]-J[39]-J[40]+J[41]-J[42]+J[43]-J[44]-J[45]-J[46]+
    J[47]-J[48]+J[49]-J[50]+J[51]-J[52]+J[53]-J[54]+J[55]-J[56]+J[57]-J[58]+J[59]-J[60]+J[61]-J[62]-J[63]+
    J[64]-J[65], +H[0]-H[1]-H[2]+H[3]+H[4]+H[5]-H[6]-H[7]+H[8]-H[9]-H[10]+H[11]-J[0]-J[1]+J[2]+J[3]+J[4]-J[5]-J[6]+
    J[7]-J[8]-J[9]+J[10]+J[11]-J[12]-J[13]-J[14]+J[15]+J[16]-J[17]+J[18]+J[19]-J[20]-J[21]-J[22]-J[23]+J[24]+
    J[25]-J[26]+J[27]+J[28]-J[29]+J[30]+J[31]-J[32]-J[33]+J[34]-J[35]-J[36]+J[37]+J[38]-J[39]-J[40]+J[41]-J[42]-J[43]+
    J[44]-J[45]-J[46]+J[47]-J[48]-J[49]+J[50]+J[51]-J[52]+J[53]+J[54]-J[55]-J[56]+J[57]+J[58]-J[59]-J[60]-J[61]+
    J[62]+J[63]-J[64]-J[65], +H[0]-H[1]-H[2]+H[3]+H[4]+H[5]-H[6]-H[7]+H[8]-H[9]-H[10]-H[11]-J[0]-J[1]+J[2]+
    J[3]+J[4]-J[5]-J[6]+J[7]-J[8]-J[9]-J[10]+J[11]-J[12]-J[13]-J[14]+J[15]+J[16]-J[17]+J[18]+J[19]+J[20]-J[21]-J[22]-J[23]+
    J[24]+J[25]-J[26]+J[27]+J[28]+J[29]+J[30]+J[31]-J[32]-J[33]+J[34]-J[35]-J[36]-J[37]+J[38]-J[39]-J[40]+
    J[41]-J[42]-J[43]-J[44]-J[45]-J[46]+J[47]-J[48]-J[49]-J[50]+J[51]-J[52]+J[53]+J[54]+J[55]-J[56]+J[57]+
    J[58]+J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]-H[1]-H[2]+H[3]+H[4]+H[5]-H[6]-H[7]-H[8]+H[9]+
    H[10]+H[11]-J[0]-J[1]+J[2]+J[3]+J[4]-J[5]-J[6]-J[7]+J[8]+J[9]+J[10]+J[11]-J[12]-J[13]-J[14]+J[15]+J[16]+
    J[17]-J[18]-J[19]-J[20]-J[21]-J[22]-J[23]+J[24]+J[25]+J[26]-J[27]-J[28]-J[29]+J[30]+J[31]-J[32]-J[33]-J[34]+
    J[35]+J[36]+J[37]+J[38]-J[39]-J[40]-J[41]+J[42]+J[43]+J[44]-J[45]-J[46]-J[47]+J[48]+J[49]+J[50]+J[51]+
    J[52]-J[53]-J[54]-J[55]+J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]-H[1]-H[2]+
    H[3]+H[4]+H[5]-H[6]-H[7]-H[8]+H[9]+H[10]-H[11]-J[0]-J[1]+J[2]+J[3]+J[4]-J[5]-J[6]-J[7]+J[8]+J[9]-J[10]+
    J[11]-J[12]-J[13]-J[14]+J[15]+J[16]+J[17]-J[18]-J[19]+J[20]-J[21]-J[22]-J[23]+J[24]+J[25]+J[26]-J[27]-J[28]+
    J[29]+J[30]+J[31]-J[32]-J[33]-J[34]+J[35]+J[36]-J[37]+J[38]-J[39]-J[40]-J[41]+J[42]+J[43]-J[44]-J[45]-J[46]-J[47]+
    J[48]+J[49]-J[50]+J[51]+J[52]-J[53]-J[54]+J[55]+J[56]-J[57]-J[58]+J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +
    H[0]-H[1]-H[2]+H[3]+H[4]+H[5]-H[6]-H[7]-H[8]+H[9]-H[10]+H[11]-J[0]-J[1]+J[2]+J[3]+J[4]-J[5]-J[6]-J[7]+
    J[8]-J[9]+J[10]+J[11]-J[12]-J[13]-J[14]+J[15]+J[16]+J[17]-J[18]+J[19]-J[20]-J[21]-J[22]-J[23]+J[24]+
    J[25]+J[26]-J[27]+J[28]-J[29]+J[30]+J[31]-J[32]-J[33]-J[34]+J[35]-J[36]+J[37]+J[38]-J[39]-J[40]-J[41]+
    J[42]-J[43]+J[44]-J[45]-J[46]-J[47]+J[48]-J[49]+J[50]+J[51]+J[52]-J[53]+J[54]-J[55]+J[56]-J[57]+J[58]-J[59]-J[60]+
    J[61]-J[62]-J[63]+J[64]-J[65], +H[0]-H[1]-H[2]+H[3]+H[4]+H[5]-H[6]-H[7]-H[8]+H[9]-H[10]-H[11]-J[0]-J[1]+
    J[2]+J[3]+J[4]-J[5]-J[6]-J[7]+J[8]-J[9]-J[10]+J[11]-J[12]-J[13]-J[14]+J[15]+J[16]+J[17]-J[18]+J[19]+
    J[20]-J[21]-J[22]-J[23]+J[24]+J[25]+J[26]-J[27]+J[28]+J[29]+J[30]+J[31]-J[32]-J[33]-J[34]+J[35]-J[36]-J[37]+
    J[38]-J[39]-J[40]-J[41]+J[42]-J[43]-J[44]-J[45]-J[46]-J[47]+J[48]-J[49]-J[50]+J[51]+J[52]-J[53]+J[54]+
    J[55]+J[56]-J[57]+J[58]+J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]-H[1]-H[2]+H[3]+H[4]+H[5]-H[6]-H[7]-H[8]-H[9]+
    H[10]+H[11]-J[0]-J[1]+J[2]+J[3]+J[4]-J[5]-J[6]-J[7]-J[8]+J[9]+J[10]+J[11]-J[12]-J[13]-J[14]+J[15]+J[16]+
    J[17]+J[18]-J[19]-J[20]-J[21]-J[22]-J[23]+J[24]+J[25]+J[26]+J[27]-J[28]-J[29]+J[30]+J[31]-J[32]-J[33]-J[34]-J[35]+
    J[36]+J[37]+J[38]-J[39]-J[40]-J[41]-J[42]+J[43]+J[44]-J[45]-J[46]-J[47]-J[48]+J[49]+J[50]+J[51]+J[52]+
    J[53]-J[54]-J[55]+J[56]+J[57]-J[58]-J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]-H[1]-H[2]+H[3]+
    H[4]+H[5]-H[6]-H[7]-H[8]-H[9]+H[10]-H[11]-J[0]-J[1]+J[2]+J[3]+J[4]-J[5]-J[6]-J[7]-J[8]+J[9]-J[10]+J[11]-J[12]-J[13]-J[14]+
    J[15]+J[16]+J[17]+J[18]-J[19]+J[20]-J[21]-J[22]-J[23]+J[24]+J[25]+J[26]+J[27]-J[28]+J[29]+J[30]+J[31]-J[32]-J[33]-J[34]-J[35]+
    J[36]-J[37]+J[38]-J[39]-J[40]-J[41]-J[42]+J[43]-J[44]-J[45]-J[46]-J[47]-J[48]+J[49]-J[50]+J[51]+J[52]+
    J[53]-J[54]+J[55]+J[56]+J[57]-J[58]+J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]-H[1]-H[2]+H[3]+
    H[4]+H[5]-H[6]-H[7]-H[8]-H[9]-H[10]+H[11]-J[0]-J[1]+J[2]+J[3]+J[4]-J[5]-J[6]-J[7]-J[8]-J[9]+J[10]+J[11]-J[12]-J[13]-J[14]+
    J[15]+J[16]+J[17]+J[18]+J[19]-J[20]-J[21]-J[22]-J[23]+J[24]+J[25]+J[26]+J[27]+J[28]-J[29]+J[30]+J[31]-J[32]-J[33]-J[34]-J[35]-J[36]+
    J[37]+J[38]-J[39]-J[40]-J[41]-J[42]-J[43]+J[44]-J[45]-J[46]-J[47]-J[48]-J[49]+J[50]+J[51]+J[52]+J[53]+
    J[54]-J[55]+J[56]+J[57]+J[58]-J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]-H[1]-H[2]+H[3]+H[4]+H[5]-H[6]-H[7]-H[8]-H[9]-H[10]-H[11]-J[0]-J[1]+
    J[2]+J[3]+J[4]-J[5]-J[6]-J[7]-J[8]-J[9]-J[10]+J[11]-J[12]-J[13]-J[14]+J[15]+J[16]+J[17]+J[18]+J[19]+
    J[20]-J[21]-J[22]-J[23]+J[24]+J[25]+J[26]+J[27]+J[28]+J[29]+J[30]+J[31]-J[32]-J[33]-J[34]-J[35]-J[36]-J[37]+
    J[38]-J[39]-J[40]-J[41]-J[42]-J[43]-J[44]-J[45]-J[46]-J[47]-J[48]-J[49]-J[50]+J[51]+J[52]+J[53]+J[54]+
    J[55]+J[56]+J[57]+J[58]+J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]-H[1]-H[2]+H[3]+H[4]-H[5]+H[6]+
    H[7]+H[8]+H[9]+H[10]+H[11]-J[0]-J[1]+J[2]+J[3]-J[4]+J[5]+J[6]+J[7]+J[8]+J[9]+J[10]+J[11]-J[12]-J[13]+
    J[14]-J[15]-J[16]-J[17]-J[18]-J[19]-J[20]-J[21]-J[22]+J[23]-J[24]-J[25]-J[26]-J[27]-J[28]-J[29]+J[30]-J[31]+
    J[32]+J[33]+J[34]+J[35]+J[36]+J[37]-J[38]+J[39]+J[40]+J[41]+J[42]+J[43]+J[44]-J[45]-J[46]-J[47]-J[48]-J[49]-J[50]+
    J[51]+J[52]+J[53]+J[54]+J[55]+J[56]+J[57]+J[58]+J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]-H[1]-H[2]+
    H[3]+H[4]-H[5]+H[6]+H[7]+H[8]+H[9]+H[10]-H[11]-J[0]-J[1]+J[2]+J[3]-J[4]+J[5]+J[6]+J[7]+J[8]+J[9]-J[10]+
    J[11]-J[12]-J[13]+J[14]-J[15]-J[16]-J[17]-J[18]-J[19]+J[20]-J[21]-J[22]+J[23]-J[24]-J[25]-J[26]-J[27]-J[28]+
    J[29]+J[30]-J[31]+J[32]+J[33]+J[34]+J[35]+J[36]-J[37]-J[38]+J[39]+J[40]+J[41]+J[42]+J[43]-J[44]-J[45]-J[46]-J[47]-J[48]-J[49]+
    J[50]+J[51]+J[52]+J[53]+J[54]-J[55]+J[56]+J[57]+J[58]-J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]-H[1]-H[2]+
    H[3]+H[4]-H[5]+H[6]+H[7]+H[8]+H[9]-H[10]+H[11]-J[0]-J[1]+J[2]+J[3]-J[4]+J[5]+J[6]+J[7]+J[8]-J[9]+J[10]+
    J[11]-J[12]-J[13]+J[14]-J[15]-J[16]-J[17]-J[18]+J[19]-J[20]-J[21]-J[22]+J[23]-J[24]-J[25]-J[26]-J[27]+
    J[28]-J[29]+J[30]-J[31]+J[32]+J[33]+J[34]+J[35]-J[36]+J[37]-J[38]+J[39]+J[40]+J[41]+J[42]-J[43]+J[44]-J[45]-J[46]-J[47]-J[48]+
    J[49]-J[50]+J[51]+J[52]+J[53]-J[54]+J[55]+J[56]+J[57]-J[58]+J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +
    H[0]-H[1]-H[2]+H[3]+H[4]-H[5]+H[6]+H[7]+H[8]+H[9]-H[10]-H[11]-J[0]-J[1]+J[2]+J[3]-J[4]+J[5]+J[6]+J[7]+
    J[8]-J[9]-J[10]+J[11]-J[12]-J[13]+J[14]-J[15]-J[16]-J[17]-J[18]+J[19]+J[20]-J[21]-J[22]+J[23]-J[24]-J[25]-J[26]-J[27]+
    J[28]+J[29]+J[30]-J[31]+J[32]+J[33]+J[34]+J[35]-J[36]-J[37]-J[38]+J[39]+J[40]+J[41]+J[42]-J[43]-J[44]-J[45]-J[46]-J[47]-J[48]+
    J[49]+J[50]+J[51]+J[52]+J[53]-J[54]-J[55]+J[56]+J[57]-J[58]-J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +
    H[0]-H[1]-H[2]+H[3]+H[4]-H[5]+H[6]+H[7]+H[8]-H[9]+H[10]+H[11]-J[0]-J[1]+J[2]+J[3]-J[4]+J[5]+J[6]+J[7]-J[8]+
    J[9]+J[10]+J[11]-J[12]-J[13]+J[14]-J[15]-J[16]-J[17]+J[18]-J[19]-J[20]-J[21]-J[22]+J[23]-J[24]-J[25]-J[26]+
    J[27]-J[28]-J[29]+J[30]-J[31]+J[32]+J[33]+J[34]-J[35]+J[36]+J[37]-J[38]+J[39]+J[40]+J[41]-J[42]+J[43]+
    J[44]-J[45]-J[46]-J[47]+J[48]-J[49]-J[50]+J[51]+J[52]-J[53]+J[54]+J[55]+J[56]-J[57]+J[58]+J[59]-J[60]+
    J[61]+J[62]-J[63]-J[64]+J[65], +H[0]-H[1]-H[2]+H[3]+H[4]-H[5]+H[6]+H[7]+H[8]-H[9]+H[10]-H[11]-J[0]-J[1]+
    J[2]+J[3]-J[4]+J[5]+J[6]+J[7]-J[8]+J[9]-J[10]+J[11]-J[12]-J[13]+J[14]-J[15]-J[16]-J[17]+J[18]-J[19]+
    J[20]-J[21]-J[22]+J[23]-J[24]-J[25]-J[26]+J[27]-J[28]+J[29]+J[30]-J[31]+J[32]+J[33]+J[34]-J[35]+J[36]-J[37]-J[38]+
    J[39]+J[40]+J[41]-J[42]+J[43]-J[44]-J[45]-J[46]-J[47]+J[48]-J[49]+J[50]+J[51]+J[52]-J[53]+J[54]-J[55]+
    J[56]-J[57]+J[58]-J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]-H[1]-H[2]+H[3]+H[4]-H[5]+H[6]+H[7]+
    H[8]-H[9]-H[10]+H[11]-J[0]-J[1]+J[2]+J[3]-J[4]+J[5]+J[6]+J[7]-J[8]-J[9]+J[10]+J[11]-J[12]-J[13]+J[14]-J[15]-J[16]-J[17]+
    J[18]+J[19]-J[20]-J[21]-J[22]+J[23]-J[24]-J[25]-J[26]+J[27]+J[28]-J[29]+J[30]-J[31]+J[32]+J[33]+J[34]-J[35]-J[36]+
    J[37]-J[38]+J[39]+J[40]+J[41]-J[42]-J[43]+J[44]-J[45]-J[46]-J[47]+J[48]+J[49]-J[50]+J[51]+J[52]-J[53]-J[54]+
    J[55]+J[56]-J[57]-J[58]+J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]-H[1]-H[2]+H[3]+H[4]-H[5]+H[6]+
    H[7]+H[8]-H[9]-H[10]-H[11]-J[0]-J[1]+J[2]+J[3]-J[4]+J[5]+J[6]+J[7]-J[8]-J[9]-J[10]+J[11]-J[12]-J[13]+
    J[14]-J[15]-J[16]-J[17]+J[18]+J[19]+J[20]-J[21]-J[22]+J[23]-J[24]-J[25]-J[26]+J[27]+J[28]+J[29]+J[30]-J[31]+
    J[32]+J[33]+J[34]-J[35]-J[36]-J[37]-J[38]+J[39]+J[40]+J[41]-J[42]-J[43]-J[44]-J[45]-J[46]-J[47]+J[48]+
    J[49]+J[50]+J[51]+J[52]-J[53]-J[54]-J[55]+J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +
    H[0]-H[1]-H[2]+H[3]+H[4]-H[5]+H[6]+H[7]-H[8]+H[9]+H[10]+H[11]-J[0]-J[1]+J[2]+J[3]-J[4]+J[5]+J[6]-J[7]+
    J[8]+J[9]+J[10]+J[11]-J[12]-J[13]+J[14]-J[15]-J[16]+J[17]-J[18]-J[19]-J[20]-J[21]-J[22]+J[23]-J[24]-J[25]+
    J[26]-J[27]-J[28]-J[29]+J[30]-J[31]+J[32]+J[33]-J[34]+J[35]+J[36]+J[37]-J[38]+J[39]+J[40]-J[41]+J[42]+
    J[43]+J[44]-J[45]-J[46]+J[47]-J[48]-J[49]-J[50]+J[51]-J[52]+J[53]+J[54]+J[55]-J[56]+J[57]+J[58]+J[59]-J[60]-J[61]-J[62]+
    J[63]+J[64]+J[65], +H[0]-H[1]-H[2]+H[3]+H[4]-H[5]+H[6]+H[7]-H[8]+H[9]+H[10]-H[11]-J[0]-J[1]+J[2]+J[3]-J[4]+
    J[5]+J[6]-J[7]+J[8]+J[9]-J[10]+J[11]-J[12]-J[13]+J[14]-J[15]-J[16]+J[17]-J[18]-J[19]+J[20]-J[21]-J[22]+
    J[23]-J[24]-J[25]+J[26]-J[27]-J[28]+J[29]+J[30]-J[31]+J[32]+J[33]-J[34]+J[35]+J[36]-J[37]-J[38]+J[39]+
    J[40]-J[41]+J[42]+J[43]-J[44]-J[45]-J[46]+J[47]-J[48]-J[49]+J[50]+J[51]-J[52]+J[53]+J[54]-J[55]-J[56]+
    J[57]+J[58]-J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]-H[1]-H[2]+H[3]+H[4]-H[5]+H[6]+H[7]-H[8]+
    H[9]-H[10]+H[11]-J[0]-J[1]+J[2]+J[3]-J[4]+J[5]+J[6]-J[7]+J[8]-J[9]+J[10]+J[11]-J[12]-J[13]+J[14]-J[15]-J[16]+
    J[17]-J[18]+J[19]-J[20]-J[21]-J[22]+J[23]-J[24]-J[25]+J[26]-J[27]+J[28]-J[29]+J[30]-J[31]+J[32]+J[33]-J[34]+
    J[35]-J[36]+J[37]-J[38]+J[39]+J[40]-J[41]+J[42]-J[43]+J[44]-J[45]-J[46]+J[47]-J[48]+J[49]-J[50]+J[51]-J[52]+
    J[53]-J[54]+J[55]-J[56]+J[57]-J[58]+J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]-H[1]-H[2]+H[3]+
    H[4]-H[5]+H[6]+H[7]-H[8]+H[9]-H[10]-H[11]-J[0]-J[1]+J[2]+J[3]-J[4]+J[5]+J[6]-J[7]+J[8]-J[9]-J[10]+J[11]-J[12]-J[13]+
    J[14]-J[15]-J[16]+J[17]-J[18]+J[19]+J[20]-J[21]-J[22]+J[23]-J[24]-J[25]+J[26]-J[27]+J[28]+J[29]+J[30]-J[31]+
    J[32]+J[33]-J[34]+J[35]-J[36]-J[37]-J[38]+J[39]+J[40]-J[41]+J[42]-J[43]-J[44]-J[45]-J[46]+J[47]-J[48]+
    J[49]+J[50]+J[51]-J[52]+J[53]-J[54]-J[55]-J[56]+J[57]-J[58]-J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +
    H[0]-H[1]-H[2]+H[3]+H[4]-H[5]+H[6]+H[7]-H[8]-H[9]+H[10]+H[11]-J[0]-J[1]+J[2]+J[3]-J[4]+J[5]+J[6]-J[7]-J[8]+
    J[9]+J[10]+J[11]-J[12]-J[13]+J[14]-J[15]-J[16]+J[17]+J[18]-J[19]-J[20]-J[21]-J[22]+J[23]-J[24]-J[25]+
    J[26]+J[27]-J[28]-J[29]+J[30]-J[31]+J[32]+J[33]-J[34]-J[35]+J[36]+J[37]-J[38]+J[39]+J[40]-J[41]-J[42]+
    J[43]+J[44]-J[45]-J[46]+J[47]+J[48]-J[49]-J[50]+J[51]-J[52]-J[53]+J[54]+J[55]-J[56]-J[57]+J[58]+J[59]+
    J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]-H[1]-H[2]+H[3]+H[4]-H[5]+H[6]+H[7]-H[8]-H[9]+H[10]-H[11]-J[0]-J[1]+
    J[2]+J[3]-J[4]+J[5]+J[6]-J[7]-J[8]+J[9]-J[10]+J[11]-J[12]-J[13]+J[14]-J[15]-J[16]+J[17]+J[18]-J[19]+
    J[20]-J[21]-J[22]+J[23]-J[24]-J[25]+J[26]+J[27]-J[28]+J[29]+J[30]-J[31]+J[32]+J[33]-J[34]-J[35]+J[36]-J[37]-J[38]+
    J[39]+J[40]-J[41]-J[42]+J[43]-J[44]-J[45]-J[46]+J[47]+J[48]-J[49]+J[50]+J[51]-J[52]-J[53]+J[54]-J[55]-J[56]-J[57]+
    J[58]-J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]-H[1]-H[2]+H[3]+H[4]-H[5]+H[6]+H[7]-H[8]-H[9]-H[10]+
    H[11]-J[0]-J[1]+J[2]+J[3]-J[4]+J[5]+J[6]-J[7]-J[8]-J[9]+J[10]+J[11]-J[12]-J[13]+J[14]-J[15]-J[16]+J[17]+
    J[18]+J[19]-J[20]-J[21]-J[22]+J[23]-J[24]-J[25]+J[26]+J[27]+J[28]-J[29]+J[30]-J[31]+J[32]+J[33]-J[34]-J[35]-J[36]+
    J[37]-J[38]+J[39]+J[40]-J[41]-J[42]-J[43]+J[44]-J[45]-J[46]+J[47]+J[48]+J[49]-J[50]+J[51]-J[52]-J[53]-J[54]+
    J[55]-J[56]-J[57]-J[58]+J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]-H[1]-H[2]+H[3]+H[4]-H[5]+H[6]+
    H[7]-H[8]-H[9]-H[10]-H[11]-J[0]-J[1]+J[2]+J[3]-J[4]+J[5]+J[6]-J[7]-J[8]-J[9]-J[10]+J[11]-J[12]-J[13]+
    J[14]-J[15]-J[16]+J[17]+J[18]+J[19]+J[20]-J[21]-J[22]+J[23]-J[24]-J[25]+J[26]+J[27]+J[28]+J[29]+J[30]-J[31]+
    J[32]+J[33]-J[34]-J[35]-J[36]-J[37]-J[38]+J[39]+J[40]-J[41]-J[42]-J[43]-J[44]-J[45]-J[46]+J[47]+J[48]+
    J[49]+J[50]+J[51]-J[52]-J[53]-J[54]-J[55]-J[56]-J[57]-J[58]-J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +
    H[0]-H[1]-H[2]+H[3]+H[4]-H[5]+H[6]-H[7]+H[8]+H[9]+H[10]+H[11]-J[0]-J[1]+J[2]+J[3]-J[4]+J[5]-J[6]+J[7]+
    J[8]+J[9]+J[10]+J[11]-J[12]-J[13]+J[14]-J[15]+J[16]-J[17]-J[18]-J[19]-J[20]-J[21]-J[22]+J[23]-J[24]+
    J[25]-J[26]-J[27]-J[28]-J[29]+J[30]-J[31]+J[32]-J[33]+J[34]+J[35]+J[36]+J[37]-J[38]+J[39]-J[40]+J[41]+
    J[42]+J[43]+J[44]-J[45]+J[46]-J[47]-J[48]-J[49]-J[50]-J[51]+J[52]+J[53]+J[54]+J[55]-J[56]-J[57]-J[58]-J[59]+
    J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]-H[1]-H[2]+H[3]+H[4]-H[5]+H[6]-H[7]+H[8]+H[9]+H[10]-H[11]-J[0]-J[1]+
    J[2]+J[3]-J[4]+J[5]-J[6]+J[7]+J[8]+J[9]-J[10]+J[11]-J[12]-J[13]+J[14]-J[15]+J[16]-J[17]-J[18]-J[19]+
    J[20]-J[21]-J[22]+J[23]-J[24]+J[25]-J[26]-J[27]-J[28]+J[29]+J[30]-J[31]+J[32]-J[33]+J[34]+J[35]+J[36]-J[37]-J[38]+
    J[39]-J[40]+J[41]+J[42]+J[43]-J[44]-J[45]+J[46]-J[47]-J[48]-J[49]+J[50]-J[51]+J[52]+J[53]+J[54]-J[55]-J[56]-J[57]-J[58]+
    J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]-H[1]-H[2]+H[3]+H[4]-H[5]+H[6]-H[7]+H[8]+H[9]-H[10]+
    H[11]-J[0]-J[1]+J[2]+J[3]-J[4]+J[5]-J[6]+J[7]+J[8]-J[9]+J[10]+J[11]-J[12]-J[13]+J[14]-J[15]+J[16]-J[17]-J[18]+
    J[19]-J[20]-J[21]-J[22]+J[23]-J[24]+J[25]-J[26]-J[27]+J[28]-J[29]+J[30]-J[31]+J[32]-J[33]+J[34]+J[35]-J[36]+
    J[37]-J[38]+J[39]-J[40]+J[41]+J[42]-J[43]+J[44]-J[45]+J[46]-J[47]-J[48]+J[49]-J[50]-J[51]+J[52]+J[53]-J[54]+
    J[55]-J[56]-J[57]+J[58]-J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]-H[1]-H[2]+H[3]+H[4]-H[5]+H[6]-H[7]+
    H[8]+H[9]-H[10]-H[11]-J[0]-J[1]+J[2]+J[3]-J[4]+J[5]-J[6]+J[7]+J[8]-J[9]-J[10]+J[11]-J[12]-J[13]+J[14]-J[15]+
    J[16]-J[17]-J[18]+J[19]+J[20]-J[21]-J[22]+J[23]-J[24]+J[25]-J[26]-J[27]+J[28]+J[29]+J[30]-J[31]+J[32]-J[33]+
    J[34]+J[35]-J[36]-J[37]-J[38]+J[39]-J[40]+J[41]+J[42]-J[43]-J[44]-J[45]+J[46]-J[47]-J[48]+J[49]+J[50]-J[51]+
    J[52]+J[53]-J[54]-J[55]-J[56]-J[57]+J[58]+J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]-H[1]-H[2]+
    H[3]+H[4]-H[5]+H[6]-H[7]+H[8]-H[9]+H[10]+H[11]-J[0]-J[1]+J[2]+J[3]-J[4]+J[5]-J[6]+J[7]-J[8]+J[9]+J[10]+
    J[11]-J[12]-J[13]+J[14]-J[15]+J[16]-J[17]+J[18]-J[19]-J[20]-J[21]-J[22]+J[23]-J[24]+J[25]-J[26]+J[27]-J[28]-J[29]+
    J[30]-J[31]+J[32]-J[33]+J[34]-J[35]+J[36]+J[37]-J[38]+J[39]-J[40]+J[41]-J[42]+J[43]+J[44]-J[45]+J[46]-J[47]+
    J[48]-J[49]-J[50]-J[51]+J[52]-J[53]+J[54]+J[55]-J[56]+J[57]-J[58]-J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+
    J[65], +H[0]-H[1]-H[2]+H[3]+H[4]-H[5]+H[6]-H[7]+H[8]-H[9]+H[10]-H[11]-J[0]-J[1]+J[2]+J[3]-J[4]+J[5]-J[6]+
    J[7]-J[8]+J[9]-J[10]+J[11]-J[12]-J[13]+J[14]-J[15]+J[16]-J[17]+J[18]-J[19]+J[20]-J[21]-J[22]+J[23]-J[24]+
    J[25]-J[26]+J[27]-J[28]+J[29]+J[30]-J[31]+J[32]-J[33]+J[34]-J[35]+J[36]-J[37]-J[38]+J[39]-J[40]+J[41]-J[42]+
    J[43]-J[44]-J[45]+J[46]-J[47]+J[48]-J[49]+J[50]-J[51]+J[52]-J[53]+J[54]-J[55]-J[56]+J[57]-J[58]+J[59]-J[60]+
    J[61]-J[62]-J[63]+J[64]-J[65], +H[0]-H[1]-H[2]+H[3]+H[4]-H[5]+H[6]-H[7]+H[8]-H[9]-H[10]+H[11]-J[0]-J[1]+
    J[2]+J[3]-J[4]+J[5]-J[6]+J[7]-J[8]-J[9]+J[10]+J[11]-J[12]-J[13]+J[14]-J[15]+J[16]-J[17]+J[18]+J[19]-J[20]-J[21]-J[22]+
    J[23]-J[24]+J[25]-J[26]+J[27]+J[28]-J[29]+J[30]-J[31]+J[32]-J[33]+J[34]-J[35]-J[36]+J[37]-J[38]+J[39]-J[40]+
    J[41]-J[42]-J[43]+J[44]-J[45]+J[46]-J[47]+J[48]+J[49]-J[50]-J[51]+J[52]-J[53]-J[54]+J[55]-J[56]+J[57]+
    J[58]-J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]-H[1]-H[2]+H[3]+H[4]-H[5]+H[6]-H[7]+H[8]-H[9]-H[10]-H[11]-J[0]-J[1]+
    J[2]+J[3]-J[4]+J[5]-J[6]+J[7]-J[8]-J[9]-J[10]+J[11]-J[12]-J[13]+J[14]-J[15]+J[16]-J[17]+J[18]+J[19]+
    J[20]-J[21]-J[22]+J[23]-J[24]+J[25]-J[26]+J[27]+J[28]+J[29]+J[30]-J[31]+J[32]-J[33]+J[34]-J[35]-J[36]-J[37]-J[38]+
    J[39]-J[40]+J[41]-J[42]-J[43]-J[44]-J[45]+J[46]-J[47]+J[48]+J[49]+J[50]-J[51]+J[52]-J[53]-J[54]-J[55]-J[56]+
    J[57]+J[58]+J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]-H[1]-H[2]+H[3]+H[4]-H[5]+H[6]-H[7]-H[8]+
    H[9]+H[10]+H[11]-J[0]-J[1]+J[2]+J[3]-J[4]+J[5]-J[6]-J[7]+J[8]+J[9]+J[10]+J[11]-J[12]-J[13]+J[14]-J[15]+
    J[16]+J[17]-J[18]-J[19]-J[20]-J[21]-J[22]+J[23]-J[24]+J[25]+J[26]-J[27]-J[28]-J[29]+J[30]-J[31]+J[32]-J[33]-J[34]+
    J[35]+J[36]+J[37]-J[38]+J[39]-J[40]-J[41]+J[42]+J[43]+J[44]-J[45]+J[46]+J[47]-J[48]-J[49]-J[50]-J[51]-J[52]+
    J[53]+J[54]+J[55]+J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]-H[1]-H[2]+H[3]+
    H[4]-H[5]+H[6]-H[7]-H[8]+H[9]+H[10]-H[11]-J[0]-J[1]+J[2]+J[3]-J[4]+J[5]-J[6]-J[7]+J[8]+J[9]-J[10]+J[11]-J[12]-J[13]+
    J[14]-J[15]+J[16]+J[17]-J[18]-J[19]+J[20]-J[21]-J[22]+J[23]-J[24]+J[25]+J[26]-J[27]-J[28]+J[29]+J[30]-J[31]+
    J[32]-J[33]-J[34]+J[35]+J[36]-J[37]-J[38]+J[39]-J[40]-J[41]+J[42]+J[43]-J[44]-J[45]+J[46]+J[47]-J[48]-J[49]+
    J[50]-J[51]-J[52]+J[53]+J[54]-J[55]+J[56]-J[57]-J[58]+J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]-H[1]-H[2]+
    H[3]+H[4]-H[5]+H[6]-H[7]-H[8]+H[9]-H[10]+H[11]-J[0]-J[1]+J[2]+J[3]-J[4]+J[5]-J[6]-J[7]+J[8]-J[9]+J[10]+
    J[11]-J[12]-J[13]+J[14]-J[15]+J[16]+J[17]-J[18]+J[19]-J[20]-J[21]-J[22]+J[23]-J[24]+J[25]+J[26]-J[27]+
    J[28]-J[29]+J[30]-J[31]+J[32]-J[33]-J[34]+J[35]-J[36]+J[37]-J[38]+J[39]-J[40]-J[41]+J[42]-J[43]+J[44]-J[45]+
    J[46]+J[47]-J[48]+J[49]-J[50]-J[51]-J[52]+J[53]-J[54]+J[55]+J[56]-J[57]+J[58]-J[59]-J[60]+J[61]-J[62]-J[63]+
    J[64]-J[65], +H[0]-H[1]-H[2]+H[3]+H[4]-H[5]+H[6]-H[7]-H[8]+H[9]-H[10]-H[11]-J[0]-J[1]+J[2]+J[3]-J[4]+
    J[5]-J[6]-J[7]+J[8]-J[9]-J[10]+J[11]-J[12]-J[13]+J[14]-J[15]+J[16]+J[17]-J[18]+J[19]+J[20]-J[21]-J[22]+
    J[23]-J[24]+J[25]+J[26]-J[27]+J[28]+J[29]+J[30]-J[31]+J[32]-J[33]-J[34]+J[35]-J[36]-J[37]-J[38]+J[39]-J[40]-J[41]+
    J[42]-J[43]-J[44]-J[45]+J[46]+J[47]-J[48]+J[49]+J[50]-J[51]-J[52]+J[53]-J[54]-J[55]+J[56]-J[57]+J[58]+
    J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]-H[1]-H[2]+H[3]+H[4]-H[5]+H[6]-H[7]-H[8]-H[9]+H[10]+
    H[11]-J[0]-J[1]+J[2]+J[3]-J[4]+J[5]-J[6]-J[7]-J[8]+J[9]+J[10]+J[11]-J[12]-J[13]+J[14]-J[15]+J[16]+J[17]+
    J[18]-J[19]-J[20]-J[21]-J[22]+J[23]-J[24]+J[25]+J[26]+J[27]-J[28]-J[29]+J[30]-J[31]+J[32]-J[33]-J[34]-J[35]+
    J[36]+J[37]-J[38]+J[39]-J[40]-J[41]-J[42]+J[43]+J[44]-J[45]+J[46]+J[47]+J[48]-J[49]-J[50]-J[51]-J[52]-J[53]+
    J[54]+J[55]+J[56]+J[57]-J[58]-J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]-H[1]-H[2]+H[3]+H[4]-H[5]+
    H[6]-H[7]-H[8]-H[9]+H[10]-H[11]-J[0]-J[1]+J[2]+J[3]-J[4]+J[5]-J[6]-J[7]-J[8]+J[9]-J[10]+J[11]-J[12]-J[13]+
    J[14]-J[15]+J[16]+J[17]+J[18]-J[19]+J[20]-J[21]-J[22]+J[23]-J[24]+J[25]+J[26]+J[27]-J[28]+J[29]+J[30]-J[31]+
    J[32]-J[33]-J[34]-J[35]+J[36]-J[37]-J[38]+J[39]-J[40]-J[41]-J[42]+J[43]-J[44]-J[45]+J[46]+J[47]+J[48]-J[49]+
    J[50]-J[51]-J[52]-J[53]+J[54]-J[55]+J[56]+J[57]-J[58]+J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]-H[1]-H[2]+
    H[3]+H[4]-H[5]+H[6]-H[7]-H[8]-H[9]-H[10]+H[11]-J[0]-J[1]+J[2]+J[3]-J[4]+J[5]-J[6]-J[7]-J[8]-J[9]+J[10]+
    J[11]-J[12]-J[13]+J[14]-J[15]+J[16]+J[17]+J[18]+J[19]-J[20]-J[21]-J[22]+J[23]-J[24]+J[25]+J[26]+J[27]+
    J[28]-J[29]+J[30]-J[31]+J[32]-J[33]-J[34]-J[35]-J[36]+J[37]-J[38]+J[39]-J[40]-J[41]-J[42]-J[43]+J[44]-J[45]+
    J[46]+J[47]+J[48]+J[49]-J[50]-J[51]-J[52]-J[53]-J[54]+J[55]+J[56]+J[57]+J[58]-J[59]+J[60]+J[61]-J[62]+
    J[63]-J[64]-J[65], +H[0]-H[1]-H[2]+H[3]+H[4]-H[5]+H[6]-H[7]-H[8]-H[9]-H[10]-H[11]-J[0]-J[1]+J[2]+J[3]-J[4]+
    J[5]-J[6]-J[7]-J[8]-J[9]-J[10]+J[11]-J[12]-J[13]+J[14]-J[15]+J[16]+J[17]+J[18]+J[19]+J[20]-J[21]-J[22]+
    J[23]-J[24]+J[25]+J[26]+J[27]+J[28]+J[29]+J[30]-J[31]+J[32]-J[33]-J[34]-J[35]-J[36]-J[37]-J[38]+J[39]-J[40]-J[41]-J[42]-J[43]-J[44]-J[45]+
    J[46]+J[47]+J[48]+J[49]+J[50]-J[51]-J[52]-J[53]-J[54]-J[55]+J[56]+J[57]+J[58]+J[59]+J[60]+J[61]+J[62]+
    J[63]+J[64]+J[65], +H[0]-H[1]-H[2]+H[3]+H[4]-H[5]-H[6]+H[7]+H[8]+H[9]+H[10]+H[11]-J[0]-J[1]+J[2]+J[3]-J[4]-J[5]+
    J[6]+J[7]+J[8]+J[9]+J[10]+J[11]-J[12]-J[13]+J[14]+J[15]-J[16]-J[17]-J[18]-J[19]-J[20]-J[21]-J[22]+J[23]+
    J[24]-J[25]-J[26]-J[27]-J[28]-J[29]+J[30]-J[31]-J[32]+J[33]+J[34]+J[35]+J[36]+J[37]-J[38]-J[39]+J[40]+
    J[41]+J[42]+J[43]+J[44]+J[45]-J[46]-J[47]-J[48]-J[49]-J[50]-J[51]-J[52]-J[53]-J[54]-J[55]+J[56]+J[57]+
    J[58]+J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]-H[1]-H[2]+H[3]+H[4]-H[5]-H[6]+H[7]+H[8]+H[9]+
    H[10]-H[11]-J[0]-J[1]+J[2]+J[3]-J[4]-J[5]+J[6]+J[7]+J[8]+J[9]-J[10]+J[11]-J[12]-J[13]+J[14]+J[15]-J[16]-J[17]-J[18]-J[19]+
    J[20]-J[21]-J[22]+J[23]+J[24]-J[25]-J[26]-J[27]-J[28]+J[29]+J[30]-J[31]-J[32]+J[33]+J[34]+J[35]+J[36]-J[37]-J[38]-J[39]+
    J[40]+J[41]+J[42]+J[43]-J[44]+J[45]-J[46]-J[47]-J[48]-J[49]+J[50]-J[51]-J[52]-J[53]-J[54]+J[55]+J[56]+
    J[57]+J[58]-J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]-H[1]-H[2]+H[3]+H[4]-H[5]-H[6]+H[7]+H[8]+
    H[9]-H[10]+H[11]-J[0]-J[1]+J[2]+J[3]-J[4]-J[5]+J[6]+J[7]+J[8]-J[9]+J[10]+J[11]-J[12]-J[13]+J[14]+J[15]-J[16]-J[17]-J[18]+
    J[19]-J[20]-J[21]-J[22]+J[23]+J[24]-J[25]-J[26]-J[27]+J[28]-J[29]+J[30]-J[31]-J[32]+J[33]+J[34]+J[35]-J[36]+
    J[37]-J[38]-J[39]+J[40]+J[41]+J[42]-J[43]+J[44]+J[45]-J[46]-J[47]-J[48]+J[49]-J[50]-J[51]-J[52]-J[53]+
    J[54]-J[55]+J[56]+J[57]-J[58]+J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]-H[1]-H[2]+H[3]+H[4]-H[5]-H[6]+
    H[7]+H[8]+H[9]-H[10]-H[11]-J[0]-J[1]+J[2]+J[3]-J[4]-J[5]+J[6]+J[7]+J[8]-J[9]-J[10]+J[11]-J[12]-J[13]+
    J[14]+J[15]-J[16]-J[17]-J[18]+J[19]+J[20]-J[21]-J[22]+J[23]+J[24]-J[25]-J[26]-J[27]+J[28]+J[29]+J[30]-J[31]-J[32]+
    J[33]+J[34]+J[35]-J[36]-J[37]-J[38]-J[39]+J[40]+J[41]+J[42]-J[43]-J[44]+J[45]-J[46]-J[47]-J[48]+J[49]+
    J[50]-J[51]-J[52]-J[53]+J[54]+J[55]+J[56]+J[57]-J[58]-J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]-H[1]-H[2]+
    H[3]+H[4]-H[5]-H[6]+H[7]+H[8]-H[9]+H[10]+H[11]-J[0]-J[1]+J[2]+J[3]-J[4]-J[5]+J[6]+J[7]-J[8]+J[9]+J[10]+
    J[11]-J[12]-J[13]+J[14]+J[15]-J[16]-J[17]+J[18]-J[19]-J[20]-J[21]-J[22]+J[23]+J[24]-J[25]-J[26]+J[27]-J[28]-J[29]+
    J[30]-J[31]-J[32]+J[33]+J[34]-J[35]+J[36]+J[37]-J[38]-J[39]+J[40]+J[41]-J[42]+J[43]+J[44]+J[45]-J[46]-J[47]+
    J[48]-J[49]-J[50]-J[51]-J[52]+J[53]-J[54]-J[55]+J[56]-J[57]+J[58]+J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+
    J[65], +H[0]-H[1]-H[2]+H[3]+H[4]-H[5]-H[6]+H[7]+H[8]-H[9]+H[10]-H[11]-J[0]-J[1]+J[2]+J[3]-J[4]-J[5]+
    J[6]+J[7]-J[8]+J[9]-J[10]+J[11]-J[12]-J[13]+J[14]+J[15]-J[16]-J[17]+J[18]-J[19]+J[20]-J[21]-J[22]+J[23]+
    J[24]-J[25]-J[26]+J[27]-J[28]+J[29]+J[30]-J[31]-J[32]+J[33]+J[34]-J[35]+J[36]-J[37]-J[38]-J[39]+J[40]+
    J[41]-J[42]+J[43]-J[44]+J[45]-J[46]-J[47]+J[48]-J[49]+J[50]-J[51]-J[52]+J[53]-J[54]+J[55]+J[56]-J[57]+
    J[58]-J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]-H[1]-H[2]+H[3]+H[4]-H[5]-H[6]+H[7]+H[8]-H[9]-H[10]+
    H[11]-J[0]-J[1]+J[2]+J[3]-J[4]-J[5]+J[6]+J[7]-J[8]-J[9]+J[10]+J[11]-J[12]-J[13]+J[14]+J[15]-J[16]-J[17]+
    J[18]+J[19]-J[20]-J[21]-J[22]+J[23]+J[24]-J[25]-J[26]+J[27]+J[28]-J[29]+J[30]-J[31]-J[32]+J[33]+J[34]-J[35]-J[36]+
    J[37]-J[38]-J[39]+J[40]+J[41]-J[42]-J[43]+J[44]+J[45]-J[46]-J[47]+J[48]+J[49]-J[50]-J[51]-J[52]+J[53]+
    J[54]-J[55]+J[56]-J[57]-J[58]+J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]-H[1]-H[2]+H[3]+H[4]-H[5]-H[6]+
    H[7]+H[8]-H[9]-H[10]-H[11]-J[0]-J[1]+J[2]+J[3]-J[4]-J[5]+J[6]+J[7]-J[8]-J[9]-J[10]+J[11]-J[12]-J[13]+
    J[14]+J[15]-J[16]-J[17]+J[18]+J[19]+J[20]-J[21]-J[22]+J[23]+J[24]-J[25]-J[26]+J[27]+J[28]+J[29]+J[30]-J[31]-J[32]+
    J[33]+J[34]-J[35]-J[36]-J[37]-J[38]-J[39]+J[40]+J[41]-J[42]-J[43]-J[44]+J[45]-J[46]-J[47]+J[48]+J[49]+
    J[50]-J[51]-J[52]+J[53]+J[54]+J[55]+J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]-H[1]-H[2]+
    H[3]+H[4]-H[5]-H[6]+H[7]-H[8]+H[9]+H[10]+H[11]-J[0]-J[1]+J[2]+J[3]-J[4]-J[5]+J[6]-J[7]+J[8]+J[9]+J[10]+
    J[11]-J[12]-J[13]+J[14]+J[15]-J[16]+J[17]-J[18]-J[19]-J[20]-J[21]-J[22]+J[23]+J[24]-J[25]+J[26]-J[27]-J[28]-J[29]+
    J[30]-J[31]-J[32]+J[33]-J[34]+J[35]+J[36]+J[37]-J[38]-J[39]+J[40]-J[41]+J[42]+J[43]+J[44]+J[45]-J[46]+
    J[47]-J[48]-J[49]-J[50]-J[51]+J[52]-J[53]-J[54]-J[55]-J[56]+J[57]+J[58]+J[59]-J[60]-J[61]-J[62]+J[63]+
    J[64]+J[65], +H[0]-H[1]-H[2]+H[3]+H[4]-H[5]-H[6]+H[7]-H[8]+H[9]+H[10]-H[11]-J[0]-J[1]+J[2]+J[3]-J[4]-J[5]+
    J[6]-J[7]+J[8]+J[9]-J[10]+J[11]-J[12]-J[13]+J[14]+J[15]-J[16]+J[17]-J[18]-J[19]+J[20]-J[21]-J[22]+J[23]+
    J[24]-J[25]+J[26]-J[27]-J[28]+J[29]+J[30]-J[31]-J[32]+J[33]-J[34]+J[35]+J[36]-J[37]-J[38]-J[39]+J[40]-J[41]+
    J[42]+J[43]-J[44]+J[45]-J[46]+J[47]-J[48]-J[49]+J[50]-J[51]+J[52]-J[53]-J[54]+J[55]-J[56]+J[57]+J[58]-J[59]-J[60]-J[61]+
    J[62]+J[63]-J[64]-J[65], +H[0]-H[1]-H[2]+H[3]+H[4]-H[5]-H[6]+H[7]-H[8]+H[9]-H[10]+H[11]-J[0]-J[1]+J[2]+
    J[3]-J[4]-J[5]+J[6]-J[7]+J[8]-J[9]+J[10]+J[11]-J[12]-J[13]+J[14]+J[15]-J[16]+J[17]-J[18]+J[19]-J[20]-J[21]-J[22]+
    J[23]+J[24]-J[25]+J[26]-J[27]+J[28]-J[29]+J[30]-J[31]-J[32]+J[33]-J[34]+J[35]-J[36]+J[37]-J[38]-J[39]+
    J[40]-J[41]+J[42]-J[43]+J[44]+J[45]-J[46]+J[47]-J[48]+J[49]-J[50]-J[51]+J[52]-J[53]+J[54]-J[55]-J[56]+
    J[57]-J[58]+J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]-H[1]-H[2]+H[3]+H[4]-H[5]-H[6]+H[7]-H[8]+
    H[9]-H[10]-H[11]-J[0]-J[1]+J[2]+J[3]-J[4]-J[5]+J[6]-J[7]+J[8]-J[9]-J[10]+J[11]-J[12]-J[13]+J[14]+J[15]-J[16]+
    J[17]-J[18]+J[19]+J[20]-J[21]-J[22]+J[23]+J[24]-J[25]+J[26]-J[27]+J[28]+J[29]+J[30]-J[31]-J[32]+J[33]-J[34]+
    J[35]-J[36]-J[37]-J[38]-J[39]+J[40]-J[41]+J[42]-J[43]-J[44]+J[45]-J[46]+J[47]-J[48]+J[49]+J[50]-J[51]+
    J[52]-J[53]+J[54]+J[55]-J[56]+J[57]-J[58]-J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]-H[1]-H[2]+
    H[3]+H[4]-H[5]-H[6]+H[7]-H[8]-H[9]+H[10]+H[11]-J[0]-J[1]+J[2]+J[3]-J[4]-J[5]+J[6]-J[7]-J[8]+J[9]+J[10]+
    J[11]-J[12]-J[13]+J[14]+J[15]-J[16]+J[17]+J[18]-J[19]-J[20]-J[21]-J[22]+J[23]+J[24]-J[25]+J[26]+J[27]-J[28]-J[29]+
    J[30]-J[31]-J[32]+J[33]-J[34]-J[35]+J[36]+J[37]-J[38]-J[39]+J[40]-J[41]-J[42]+J[43]+J[44]+J[45]-J[46]+
    J[47]+J[48]-J[49]-J[50]-J[51]+J[52]+J[53]-J[54]-J[55]-J[56]-J[57]+J[58]+J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+
    J[65], +H[0]-H[1]-H[2]+H[3]+H[4]-H[5]-H[6]+H[7]-H[8]-H[9]+H[10]-H[11]-J[0]-J[1]+J[2]+J[3]-J[4]-J[5]+
    J[6]-J[7]-J[8]+J[9]-J[10]+J[11]-J[12]-J[13]+J[14]+J[15]-J[16]+J[17]+J[18]-J[19]+J[20]-J[21]-J[22]+J[23]+
    J[24]-J[25]+J[26]+J[27]-J[28]+J[29]+J[30]-J[31]-J[32]+J[33]-J[34]-J[35]+J[36]-J[37]-J[38]-J[39]+J[40]-J[41]-J[42]+
    J[43]-J[44]+J[45]-J[46]+J[47]+J[48]-J[49]+J[50]-J[51]+J[52]+J[53]-J[54]+J[55]-J[56]-J[57]+J[58]-J[59]+
    J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]-H[1]-H[2]+H[3]+H[4]-H[5]-H[6]+H[7]-H[8]-H[9]-H[10]+H[11]-J[0]-J[1]+
    J[2]+J[3]-J[4]-J[5]+J[6]-J[7]-J[8]-J[9]+J[10]+J[11]-J[12]-J[13]+J[14]+J[15]-J[16]+J[17]+J[18]+J[19]-J[20]-J[21]-J[22]+
    J[23]+J[24]-J[25]+J[26]+J[27]+J[28]-J[29]+J[30]-J[31]-J[32]+J[33]-J[34]-J[35]-J[36]+J[37]-J[38]-J[39]+
    J[40]-J[41]-J[42]-J[43]+J[44]+J[45]-J[46]+J[47]+J[48]+J[49]-J[50]-J[51]+J[52]+J[53]+J[54]-J[55]-J[56]-J[57]-J[58]+
    J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]-H[1]-H[2]+H[3]+H[4]-H[5]-H[6]+H[7]-H[8]-H[9]-H[10]-H[11]-J[0]-J[1]+
    J[2]+J[3]-J[4]-J[5]+J[6]-J[7]-J[8]-J[9]-J[10]+J[11]-J[12]-J[13]+J[14]+J[15]-J[16]+J[17]+J[18]+J[19]+
    J[20]-J[21]-J[22]+J[23]+J[24]-J[25]+J[26]+J[27]+J[28]+J[29]+J[30]-J[31]-J[32]+J[33]-J[34]-J[35]-J[36]-J[37]-J[38]-J[39]+
    J[40]-J[41]-J[42]-J[43]-J[44]+J[45]-J[46]+J[47]+J[48]+J[49]+J[50]-J[51]+J[52]+J[53]+J[54]+J[55]-J[56]-J[57]-J[58]-J[59]+
    J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]-H[1]-H[2]+H[3]+H[4]-H[5]-H[6]-H[7]+H[8]+H[9]+H[10]+H[11]-J[0]-J[1]+
    J[2]+J[3]-J[4]-J[5]-J[6]+J[7]+J[8]+J[9]+J[10]+J[11]-J[12]-J[13]+J[14]+J[15]+J[16]-J[17]-J[18]-J[19]-J[20]-J[21]-J[22]+
    J[23]+J[24]+J[25]-J[26]-J[27]-J[28]-J[29]+J[30]-J[31]-J[32]-J[33]+J[34]+J[35]+J[36]+J[37]-J[38]-J[39]-J[40]+
    J[41]+J[42]+J[43]+J[44]+J[45]+J[46]-J[47]-J[48]-J[49]-J[50]+J[51]-J[52]-J[53]-J[54]-J[55]-J[56]-J[57]-J[58]-J[59]+
    J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]-H[1]-H[2]+H[3]+H[4]-H[5]-H[6]-H[7]+H[8]+H[9]+H[10]-H[11]-J[0]-J[1]+
    J[2]+J[3]-J[4]-J[5]-J[6]+J[7]+J[8]+J[9]-J[10]+J[11]-J[12]-J[13]+J[14]+J[15]+J[16]-J[17]-J[18]-J[19]+
    J[20]-J[21]-J[22]+J[23]+J[24]+J[25]-J[26]-J[27]-J[28]+J[29]+J[30]-J[31]-J[32]-J[33]+J[34]+J[35]+J[36]-J[37]-J[38]-J[39]-J[40]+
    J[41]+J[42]+J[43]-J[44]+J[45]+J[46]-J[47]-J[48]-J[49]+J[50]+J[51]-J[52]-J[53]-J[54]+J[55]-J[56]-J[57]-J[58]+
    J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]-H[1]-H[2]+H[3]+H[4]-H[5]-H[6]-H[7]+H[8]+H[9]-H[10]+
    H[11]-J[0]-J[1]+J[2]+J[3]-J[4]-J[5]-J[6]+J[7]+J[8]-J[9]+J[10]+J[11]-J[12]-J[13]+J[14]+J[15]+J[16]-J[17]-J[18]+
    J[19]-J[20]-J[21]-J[22]+J[23]+J[24]+J[25]-J[26]-J[27]+J[28]-J[29]+J[30]-J[31]-J[32]-J[33]+J[34]+J[35]-J[36]+
    J[37]-J[38]-J[39]-J[40]+J[41]+J[42]-J[43]+J[44]+J[45]+J[46]-J[47]-J[48]+J[49]-J[50]+J[51]-J[52]-J[53]+
    J[54]-J[55]-J[56]-J[57]+J[58]-J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]-H[1]-H[2]+H[3]+H[4]-H[5]-H[6]-H[7]+
    H[8]+H[9]-H[10]-H[11]-J[0]-J[1]+J[2]+J[3]-J[4]-J[5]-J[6]+J[7]+J[8]-J[9]-J[10]+J[11]-J[12]-J[13]+J[14]+
    J[15]+J[16]-J[17]-J[18]+J[19]+J[20]-J[21]-J[22]+J[23]+J[24]+J[25]-J[26]-J[27]+J[28]+J[29]+J[30]-J[31]-J[32]-J[33]+
    J[34]+J[35]-J[36]-J[37]-J[38]-J[39]-J[40]+J[41]+J[42]-J[43]-J[44]+J[45]+J[46]-J[47]-J[48]+J[49]+J[50]+
    J[51]-J[52]-J[53]+J[54]+J[55]-J[56]-J[57]+J[58]+J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]-H[1]-H[2]+
    H[3]+H[4]-H[5]-H[6]-H[7]+H[8]-H[9]+H[10]+H[11]-J[0]-J[1]+J[2]+J[3]-J[4]-J[5]-J[6]+J[7]-J[8]+J[9]+J[10]+
    J[11]-J[12]-J[13]+J[14]+J[15]+J[16]-J[17]+J[18]-J[19]-J[20]-J[21]-J[22]+J[23]+J[24]+J[25]-J[26]+J[27]-J[28]-J[29]+
    J[30]-J[31]-J[32]-J[33]+J[34]-J[35]+J[36]+J[37]-J[38]-J[39]-J[40]+J[41]-J[42]+J[43]+J[44]+J[45]+J[46]-J[47]+
    J[48]-J[49]-J[50]+J[51]-J[52]+J[53]-J[54]-J[55]-J[56]+J[57]-J[58]-J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+
    J[65], +H[0]-H[1]-H[2]+H[3]+H[4]-H[5]-H[6]-H[7]+H[8]-H[9]+H[10]-H[11]-J[0]-J[1]+J[2]+J[3]-J[4]-J[5]-J[6]+
    J[7]-J[8]+J[9]-J[10]+J[11]-J[12]-J[13]+J[14]+J[15]+J[16]-J[17]+J[18]-J[19]+J[20]-J[21]-J[22]+J[23]+J[24]+
    J[25]-J[26]+J[27]-J[28]+J[29]+J[30]-J[31]-J[32]-J[33]+J[34]-J[35]+J[36]-J[37]-J[38]-J[39]-J[40]+J[41]-J[42]+
    J[43]-J[44]+J[45]+J[46]-J[47]+J[48]-J[49]+J[50]+J[51]-J[52]+J[53]-J[54]+J[55]-J[56]+J[57]-J[58]+J[59]-J[60]+
    J[61]-J[62]-J[63]+J[64]-J[65], +H[0]-H[1]-H[2]+H[3]+H[4]-H[5]-H[6]-H[7]+H[8]-H[9]-H[10]+H[11]-J[0]-J[1]+
    J[2]+J[3]-J[4]-J[5]-J[6]+J[7]-J[8]-J[9]+J[10]+J[11]-J[12]-J[13]+J[14]+J[15]+J[16]-J[17]+J[18]+J[19]-J[20]-J[21]-J[22]+
    J[23]+J[24]+J[25]-J[26]+J[27]+J[28]-J[29]+J[30]-J[31]-J[32]-J[33]+J[34]-J[35]-J[36]+J[37]-J[38]-J[39]-J[40]+
    J[41]-J[42]-J[43]+J[44]+J[45]+J[46]-J[47]+J[48]+J[49]-J[50]+J[51]-J[52]+J[53]+J[54]-J[55]-J[56]+J[57]+
    J[58]-J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]-H[1]-H[2]+H[3]+H[4]-H[5]-H[6]-H[7]+H[8]-H[9]-H[10]-H[11]-J[0]-J[1]+
    J[2]+J[3]-J[4]-J[5]-J[6]+J[7]-J[8]-J[9]-J[10]+J[11]-J[12]-J[13]+J[14]+J[15]+J[16]-J[17]+J[18]+J[19]+
    J[20]-J[21]-J[22]+J[23]+J[24]+J[25]-J[26]+J[27]+J[28]+J[29]+J[30]-J[31]-J[32]-J[33]+J[34]-J[35]-J[36]-J[37]-J[38]-J[39]-J[40]+
    J[41]-J[42]-J[43]-J[44]+J[45]+J[46]-J[47]+J[48]+J[49]+J[50]+J[51]-J[52]+J[53]+J[54]+J[55]-J[56]+J[57]+
    J[58]+J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]-H[1]-H[2]+H[3]+H[4]-H[5]-H[6]-H[7]-H[8]+H[9]+
    H[10]+H[11]-J[0]-J[1]+J[2]+J[3]-J[4]-J[5]-J[6]-J[7]+J[8]+J[9]+J[10]+J[11]-J[12]-J[13]+J[14]+J[15]+J[16]+
    J[17]-J[18]-J[19]-J[20]-J[21]-J[22]+J[23]+J[24]+J[25]+J[26]-J[27]-J[28]-J[29]+J[30]-J[31]-J[32]-J[33]-J[34]+
    J[35]+J[36]+J[37]-J[38]-J[39]-J[40]-J[41]+J[42]+J[43]+J[44]+J[45]+J[46]+J[47]-J[48]-J[49]-J[50]+J[51]+
    J[52]-J[53]-J[54]-J[55]+J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]-H[1]-H[2]+
    H[3]+H[4]-H[5]-H[6]-H[7]-H[8]+H[9]+H[10]-H[11]-J[0]-J[1]+J[2]+J[3]-J[4]-J[5]-J[6]-J[7]+J[8]+J[9]-J[10]+
    J[11]-J[12]-J[13]+J[14]+J[15]+J[16]+J[17]-J[18]-J[19]+J[20]-J[21]-J[22]+J[23]+J[24]+J[25]+J[26]-J[27]-J[28]+
    J[29]+J[30]-J[31]-J[32]-J[33]-J[34]+J[35]+J[36]-J[37]-J[38]-J[39]-J[40]-J[41]+J[42]+J[43]-J[44]+J[45]+
    J[46]+J[47]-J[48]-J[49]+J[50]+J[51]+J[52]-J[53]-J[54]+J[55]+J[56]-J[57]-J[58]+J[59]-J[60]-J[61]+J[62]+
    J[63]-J[64]-J[65], +H[0]-H[1]-H[2]+H[3]+H[4]-H[5]-H[6]-H[7]-H[8]+H[9]-H[10]+H[11]-J[0]-J[1]+J[2]+J[3]-J[4]-J[5]-J[6]-J[7]+
    J[8]-J[9]+J[10]+J[11]-J[12]-J[13]+J[14]+J[15]+J[16]+J[17]-J[18]+J[19]-J[20]-J[21]-J[22]+J[23]+J[24]+
    J[25]+J[26]-J[27]+J[28]-J[29]+J[30]-J[31]-J[32]-J[33]-J[34]+J[35]-J[36]+J[37]-J[38]-J[39]-J[40]-J[41]+
    J[42]-J[43]+J[44]+J[45]+J[46]+J[47]-J[48]+J[49]-J[50]+J[51]+J[52]-J[53]+J[54]-J[55]+J[56]-J[57]+J[58]-J[59]-J[60]+
    J[61]-J[62]-J[63]+J[64]-J[65], +H[0]-H[1]-H[2]+H[3]+H[4]-H[5]-H[6]-H[7]-H[8]+H[9]-H[10]-H[11]-J[0]-J[1]+
    J[2]+J[3]-J[4]-J[5]-J[6]-J[7]+J[8]-J[9]-J[10]+J[11]-J[12]-J[13]+J[14]+J[15]+J[16]+J[17]-J[18]+J[19]+
    J[20]-J[21]-J[22]+J[23]+J[24]+J[25]+J[26]-J[27]+J[28]+J[29]+J[30]-J[31]-J[32]-J[33]-J[34]+J[35]-J[36]-J[37]-J[38]-J[39]-J[40]-J[41]+
    J[42]-J[43]-J[44]+J[45]+J[46]+J[47]-J[48]+J[49]+J[50]+J[51]+J[52]-J[53]+J[54]+J[55]+J[56]-J[57]+J[58]+
    J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]-H[1]-H[2]+H[3]+H[4]-H[5]-H[6]-H[7]-H[8]-H[9]+H[10]+
    H[11]-J[0]-J[1]+J[2]+J[3]-J[4]-J[5]-J[6]-J[7]-J[8]+J[9]+J[10]+J[11]-J[12]-J[13]+J[14]+J[15]+J[16]+J[17]+
    J[18]-J[19]-J[20]-J[21]-J[22]+J[23]+J[24]+J[25]+J[26]+J[27]-J[28]-J[29]+J[30]-J[31]-J[32]-J[33]-J[34]-J[35]+
    J[36]+J[37]-J[38]-J[39]-J[40]-J[41]-J[42]+J[43]+J[44]+J[45]+J[46]+J[47]+J[48]-J[49]-J[50]+J[51]+J[52]+
    J[53]-J[54]-J[55]+J[56]+J[57]-J[58]-J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]-H[1]-H[2]+H[3]+
    H[4]-H[5]-H[6]-H[7]-H[8]-H[9]+H[10]-H[11]-J[0]-J[1]+J[2]+J[3]-J[4]-J[5]-J[6]-J[7]-J[8]+J[9]-J[10]+J[11]-J[12]-J[13]+
    J[14]+J[15]+J[16]+J[17]+J[18]-J[19]+J[20]-J[21]-J[22]+J[23]+J[24]+J[25]+J[26]+J[27]-J[28]+J[29]+J[30]-J[31]-J[32]-J[33]-J[34]-J[35]+
    J[36]-J[37]-J[38]-J[39]-J[40]-J[41]-J[42]+J[43]-J[44]+J[45]+J[46]+J[47]+J[48]-J[49]+J[50]+J[51]+J[52]+
    J[53]-J[54]+J[55]+J[56]+J[57]-J[58]+J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]-H[1]-H[2]+H[3]+
    H[4]-H[5]-H[6]-H[7]-H[8]-H[9]-H[10]+H[11]-J[0]-J[1]+J[2]+J[3]-J[4]-J[5]-J[6]-J[7]-J[8]-J[9]+J[10]+J[11]-J[12]-J[13]+
    J[14]+J[15]+J[16]+J[17]+J[18]+J[19]-J[20]-J[21]-J[22]+J[23]+J[24]+J[25]+J[26]+J[27]+J[28]-J[29]+J[30]-J[31]-J[32]-J[33]-J[34]-J[35]-J[36]+
    J[37]-J[38]-J[39]-J[40]-J[41]-J[42]-J[43]+J[44]+J[45]+J[46]+J[47]+J[48]+J[49]-J[50]+J[51]+J[52]+J[53]+
    J[54]-J[55]+J[56]+J[57]+J[58]-J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]-H[1]-H[2]+H[3]+H[4]-H[5]-H[6]-H[7]-H[8]-H[9]-H[10]-H[11]-J[0]-J[1]+
    J[2]+J[3]-J[4]-J[5]-J[6]-J[7]-J[8]-J[9]-J[10]+J[11]-J[12]-J[13]+J[14]+J[15]+J[16]+J[17]+J[18]+J[19]+
    J[20]-J[21]-J[22]+J[23]+J[24]+J[25]+J[26]+J[27]+J[28]+J[29]+J[30]-J[31]-J[32]-J[33]-J[34]-J[35]-J[36]-J[37]-J[38]-J[39]-J[40]-J[41]-J[42]-J[43]-J[44]+
    J[45]+J[46]+J[47]+J[48]+J[49]+J[50]+J[51]+J[52]+J[53]+J[54]+J[55]+J[56]+J[57]+J[58]+J[59]+J[60]+J[61]+
    J[62]+J[63]+J[64]+J[65], +H[0]-H[1]-H[2]+H[3]-H[4]+H[5]+H[6]+H[7]+H[8]+H[9]+H[10]+H[11]-J[0]-J[1]+J[2]-J[3]+
    J[4]+J[5]+J[6]+J[7]+J[8]+J[9]+J[10]+J[11]-J[12]+J[13]-J[14]-J[15]-J[16]-J[17]-J[18]-J[19]-J[20]-J[21]+
    J[22]-J[23]-J[24]-J[25]-J[26]-J[27]-J[28]-J[29]-J[30]+J[31]+J[32]+J[33]+J[34]+J[35]+J[36]+J[37]-J[38]-J[39]-J[40]-J[41]-J[42]-J[43]-J[44]+
    J[45]+J[46]+J[47]+J[48]+J[49]+J[50]+J[51]+J[52]+J[53]+J[54]+J[55]+J[56]+J[57]+J[58]+J[59]+J[60]+J[61]+
    J[62]+J[63]+J[64]+J[65], +H[0]-H[1]-H[2]+H[3]-H[4]+H[5]+H[6]+H[7]+H[8]+H[9]+H[10]-H[11]-J[0]-J[1]+J[2]-J[3]+
    J[4]+J[5]+J[6]+J[7]+J[8]+J[9]-J[10]+J[11]-J[12]+J[13]-J[14]-J[15]-J[16]-J[17]-J[18]-J[19]+J[20]-J[21]+
    J[22]-J[23]-J[24]-J[25]-J[26]-J[27]-J[28]+J[29]-J[30]+J[31]+J[32]+J[33]+J[34]+J[35]+J[36]-J[37]-J[38]-J[39]-J[40]-J[41]-J[42]-J[43]+
    J[44]+J[45]+J[46]+J[47]+J[48]+J[49]-J[50]+J[51]+J[52]+J[53]+J[54]-J[55]+J[56]+J[57]+J[58]-J[59]+J[60]+
    J[61]-J[62]+J[63]-J[64]-J[65], +H[0]-H[1]-H[2]+H[3]-H[4]+H[5]+H[6]+H[7]+H[8]+H[9]-H[10]+H[11]-J[0]-J[1]+
    J[2]-J[3]+J[4]+J[5]+J[6]+J[7]+J[8]-J[9]+J[10]+J[11]-J[12]+J[13]-J[14]-J[15]-J[16]-J[17]-J[18]+J[19]-J[20]-J[21]+
    J[22]-J[23]-J[24]-J[25]-J[26]-J[27]+J[28]-J[29]-J[30]+J[31]+J[32]+J[33]+J[34]+J[35]-J[36]+J[37]-J[38]-J[39]-J[40]-J[41]-J[42]+
    J[43]-J[44]+J[45]+J[46]+J[47]+J[48]-J[49]+J[50]+J[51]+J[52]+J[53]-J[54]+J[55]+J[56]+J[57]-J[58]+J[59]+
    J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]-H[1]-H[2]+H[3]-H[4]+H[5]+H[6]+H[7]+H[8]+H[9]-H[10]-H[11]-J[0]-J[1]+
    J[2]-J[3]+J[4]+J[5]+J[6]+J[7]+J[8]-J[9]-J[10]+J[11]-J[12]+J[13]-J[14]-J[15]-J[16]-J[17]-J[18]+J[19]+
    J[20]-J[21]+J[22]-J[23]-J[24]-J[25]-J[26]-J[27]+J[28]+J[29]-J[30]+J[31]+J[32]+J[33]+J[34]+J[35]-J[36]-J[37]-J[38]-J[39]-J[40]-J[41]-J[42]+
    J[43]+J[44]+J[45]+J[46]+J[47]+J[48]-J[49]-J[50]+J[51]+J[52]+J[53]-J[54]-J[55]+J[56]+J[57]-J[58]-J[59]+
    J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]-H[1]-H[2]+H[3]-H[4]+H[5]+H[6]+H[7]+H[8]-H[9]+H[10]+H[11]-J[0]-J[1]+
    J[2]-J[3]+J[4]+J[5]+J[6]+J[7]-J[8]+J[9]+J[10]+J[11]-J[12]+J[13]-J[14]-J[15]-J[16]-J[17]+J[18]-J[19]-J[20]-J[21]+
    J[22]-J[23]-J[24]-J[25]-J[26]+J[27]-J[28]-J[29]-J[30]+J[31]+J[32]+J[33]+J[34]-J[35]+J[36]+J[37]-J[38]-J[39]-J[40]-J[41]+
    J[42]-J[43]-J[44]+J[45]+J[46]+J[47]-J[48]+J[49]+J[50]+J[51]+J[52]-J[53]+J[54]+J[55]+J[56]-J[57]+J[58]+
    J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]-H[1]-H[2]+H[3]-H[4]+H[5]+H[6]+H[7]+H[8]-H[9]+H[10]-H[11]-J[0]-J[1]+
    J[2]-J[3]+J[4]+J[5]+J[6]+J[7]-J[8]+J[9]-J[10]+J[11]-J[12]+J[13]-J[14]-J[15]-J[16]-J[17]+J[18]-J[19]+
    J[20]-J[21]+J[22]-J[23]-J[24]-J[25]-J[26]+J[27]-J[28]+J[29]-J[30]+J[31]+J[32]+J[33]+J[34]-J[35]+J[36]-J[37]-J[38]-J[39]-J[40]-J[41]+
    J[42]-J[43]+J[44]+J[45]+J[46]+J[47]-J[48]+J[49]-J[50]+J[51]+J[52]-J[53]+J[54]-J[55]+J[56]-J[57]+J[58]-J[59]-J[60]+
    J[61]-J[62]-J[63]+J[64]-J[65], +H[0]-H[1]-H[2]+H[3]-H[4]+H[5]+H[6]+H[7]+H[8]-H[9]-H[10]+H[11]-J[0]-J[1]+
    J[2]-J[3]+J[4]+J[5]+J[6]+J[7]-J[8]-J[9]+J[10]+J[11]-J[12]+J[13]-J[14]-J[15]-J[16]-J[17]+J[18]+J[19]-J[20]-J[21]+
    J[22]-J[23]-J[24]-J[25]-J[26]+J[27]+J[28]-J[29]-J[30]+J[31]+J[32]+J[33]+J[34]-J[35]-J[36]+J[37]-J[38]-J[39]-J[40]-J[41]+
    J[42]+J[43]-J[44]+J[45]+J[46]+J[47]-J[48]-J[49]+J[50]+J[51]+J[52]-J[53]-J[54]+J[55]+J[56]-J[57]-J[58]+
    J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]-H[1]-H[2]+H[3]-H[4]+H[5]+H[6]+H[7]+H[8]-H[9]-H[10]-H[11]-J[0]-J[1]+
    J[2]-J[3]+J[4]+J[5]+J[6]+J[7]-J[8]-J[9]-J[10]+J[11]-J[12]+J[13]-J[14]-J[15]-J[16]-J[17]+J[18]+J[19]+
    J[20]-J[21]+J[22]-J[23]-J[24]-J[25]-J[26]+J[27]+J[28]+J[29]-J[30]+J[31]+J[32]+J[33]+J[34]-J[35]-J[36]-J[37]-J[38]-J[39]-J[40]-J[41]+
    J[42]+J[43]+J[44]+J[45]+J[46]+J[47]-J[48]-J[49]-J[50]+J[51]+J[52]-J[53]-J[54]-J[55]+J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+
    J[63]+J[64]+J[65], +H[0]-H[1]-H[2]+H[3]-H[4]+H[5]+H[6]+H[7]-H[8]+H[9]+H[10]+H[11]-J[0]-J[1]+J[2]-J[3]+
    J[4]+J[5]+J[6]-J[7]+J[8]+J[9]+J[10]+J[11]-J[12]+J[13]-J[14]-J[15]-J[16]+J[17]-J[18]-J[19]-J[20]-J[21]+
    J[22]-J[23]-J[24]-J[25]+J[26]-J[27]-J[28]-J[29]-J[30]+J[31]+J[32]+J[33]-J[34]+J[35]+J[36]+J[37]-J[38]-J[39]-J[40]+
    J[41]-J[42]-J[43]-J[44]+J[45]+J[46]-J[47]+J[48]+J[49]+J[50]+J[51]-J[52]+J[53]+J[54]+J[55]-J[56]+J[57]+
    J[58]+J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]-H[1]-H[2]+H[3]-H[4]+H[5]+H[6]+H[7]-H[8]+H[9]+
    H[10]-H[11]-J[0]-J[1]+J[2]-J[3]+J[4]+J[5]+J[6]-J[7]+J[8]+J[9]-J[10]+J[11]-J[12]+J[13]-J[14]-J[15]-J[16]+
    J[17]-J[18]-J[19]+J[20]-J[21]+J[22]-J[23]-J[24]-J[25]+J[26]-J[27]-J[28]+J[29]-J[30]+J[31]+J[32]+J[33]-J[34]+
    J[35]+J[36]-J[37]-J[38]-J[39]-J[40]+J[41]-J[42]-J[43]+J[44]+J[45]+J[46]-J[47]+J[48]+J[49]-J[50]+J[51]-J[52]+
    J[53]+J[54]-J[55]-J[56]+J[57]+J[58]-J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]-H[1]-H[2]+H[3]-H[4]+
    H[5]+H[6]+H[7]-H[8]+H[9]-H[10]+H[11]-J[0]-J[1]+J[2]-J[3]+J[4]+J[5]+J[6]-J[7]+J[8]-J[9]+J[10]+J[11]-J[12]+
    J[13]-J[14]-J[15]-J[16]+J[17]-J[18]+J[19]-J[20]-J[21]+J[22]-J[23]-J[24]-J[25]+J[26]-J[27]+J[28]-J[29]-J[30]+
    J[31]+J[32]+J[33]-J[34]+J[35]-J[36]+J[37]-J[38]-J[39]-J[40]+J[41]-J[42]+J[43]-J[44]+J[45]+J[46]-J[47]+
    J[48]-J[49]+J[50]+J[51]-J[52]+J[53]-J[54]+J[55]-J[56]+J[57]-J[58]+J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +
    H[0]-H[1]-H[2]+H[3]-H[4]+H[5]+H[6]+H[7]-H[8]+H[9]-H[10]-H[11]-J[0]-J[1]+J[2]-J[3]+J[4]+J[5]+J[6]-J[7]+
    J[8]-J[9]-J[10]+J[11]-J[12]+J[13]-J[14]-J[15]-J[16]+J[17]-J[18]+J[19]+J[20]-J[21]+J[22]-J[23]-J[24]-J[25]+
    J[26]-J[27]+J[28]+J[29]-J[30]+J[31]+J[32]+J[33]-J[34]+J[35]-J[36]-J[37]-J[38]-J[39]-J[40]+J[41]-J[42]+
    J[43]+J[44]+J[45]+J[46]-J[47]+J[48]-J[49]-J[50]+J[51]-J[52]+J[53]-J[54]-J[55]-J[56]+J[57]-J[58]-J[59]-J[60]+
    J[61]+J[62]-J[63]-J[64]+J[65], +H[0]-H[1]-H[2]+H[3]-H[4]+H[5]+H[6]+H[7]-H[8]-H[9]+H[10]+H[11]-J[0]-J[1]+
    J[2]-J[3]+J[4]+J[5]+J[6]-J[7]-J[8]+J[9]+J[10]+J[11]-J[12]+J[13]-J[14]-J[15]-J[16]+J[17]+J[18]-J[19]-J[20]-J[21]+
    J[22]-J[23]-J[24]-J[25]+J[26]+J[27]-J[28]-J[29]-J[30]+J[31]+J[32]+J[33]-J[34]-J[35]+J[36]+J[37]-J[38]-J[39]-J[40]+
    J[41]+J[42]-J[43]-J[44]+J[45]+J[46]-J[47]-J[48]+J[49]+J[50]+J[51]-J[52]-J[53]+J[54]+J[55]-J[56]-J[57]+
    J[58]+J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]-H[1]-H[2]+H[3]-H[4]+H[5]+H[6]+H[7]-H[8]-H[9]+
    H[10]-H[11]-J[0]-J[1]+J[2]-J[3]+J[4]+J[5]+J[6]-J[7]-J[8]+J[9]-J[10]+J[11]-J[12]+J[13]-J[14]-J[15]-J[16]+
    J[17]+J[18]-J[19]+J[20]-J[21]+J[22]-J[23]-J[24]-J[25]+J[26]+J[27]-J[28]+J[29]-J[30]+J[31]+J[32]+J[33]-J[34]-J[35]+
    J[36]-J[37]-J[38]-J[39]-J[40]+J[41]+J[42]-J[43]+J[44]+J[45]+J[46]-J[47]-J[48]+J[49]-J[50]+J[51]-J[52]-J[53]+
    J[54]-J[55]-J[56]-J[57]+J[58]-J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]-H[1]-H[2]+H[3]-H[4]+H[5]+
    H[6]+H[7]-H[8]-H[9]-H[10]+H[11]-J[0]-J[1]+J[2]-J[3]+J[4]+J[5]+J[6]-J[7]-J[8]-J[9]+J[10]+J[11]-J[12]+
    J[13]-J[14]-J[15]-J[16]+J[17]+J[18]+J[19]-J[20]-J[21]+J[22]-J[23]-J[24]-J[25]+J[26]+J[27]+J[28]-J[29]-J[30]+
    J[31]+J[32]+J[33]-J[34]-J[35]-J[36]+J[37]-J[38]-J[39]-J[40]+J[41]+J[42]+J[43]-J[44]+J[45]+J[46]-J[47]-J[48]-J[49]+
    J[50]+J[51]-J[52]-J[53]-J[54]+J[55]-J[56]-J[57]-J[58]+J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]-H[1]-H[2]+
    H[3]-H[4]+H[5]+H[6]+H[7]-H[8]-H[9]-H[10]-H[11]-J[0]-J[1]+J[2]-J[3]+J[4]+J[5]+J[6]-J[7]-J[8]-J[9]-J[10]+
    J[11]-J[12]+J[13]-J[14]-J[15]-J[16]+J[17]+J[18]+J[19]+J[20]-J[21]+J[22]-J[23]-J[24]-J[25]+J[26]+J[27]+
    J[28]+J[29]-J[30]+J[31]+J[32]+J[33]-J[34]-J[35]-J[36]-J[37]-J[38]-J[39]-J[40]+J[41]+J[42]+J[43]+J[44]+
    J[45]+J[46]-J[47]-J[48]-J[49]-J[50]+J[51]-J[52]-J[53]-J[54]-J[55]-J[56]-J[57]-J[58]-J[59]+J[60]+J[61]+
    J[62]+J[63]+J[64]+J[65], +H[0]-H[1]-H[2]+H[3]-H[4]+H[5]+H[6]-H[7]+H[8]+H[9]+H[10]+H[11]-J[0]-J[1]+J[2]-J[3]+
    J[4]+J[5]-J[6]+J[7]+J[8]+J[9]+J[10]+J[11]-J[12]+J[13]-J[14]-J[15]+J[16]-J[17]-J[18]-J[19]-J[20]-J[21]+
    J[22]-J[23]-J[24]+J[25]-J[26]-J[27]-J[28]-J[29]-J[30]+J[31]+J[32]-J[33]+J[34]+J[35]+J[36]+J[37]-J[38]-J[39]+
    J[40]-J[41]-J[42]-J[43]-J[44]+J[45]-J[46]+J[47]+J[48]+J[49]+J[50]-J[51]+J[52]+J[53]+J[54]+J[55]-J[56]-J[57]-J[58]-J[59]+
    J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]-H[1]-H[2]+H[3]-H[4]+H[5]+H[6]-H[7]+H[8]+H[9]+H[10]-H[11]-J[0]-J[1]+
    J[2]-J[3]+J[4]+J[5]-J[6]+J[7]+J[8]+J[9]-J[10]+J[11]-J[12]+J[13]-J[14]-J[15]+J[16]-J[17]-J[18]-J[19]+
    J[20]-J[21]+J[22]-J[23]-J[24]+J[25]-J[26]-J[27]-J[28]+J[29]-J[30]+J[31]+J[32]-J[33]+J[34]+J[35]+J[36]-J[37]-J[38]-J[39]+
    J[40]-J[41]-J[42]-J[43]+J[44]+J[45]-J[46]+J[47]+J[48]+J[49]-J[50]-J[51]+J[52]+J[53]+J[54]-J[55]-J[56]-J[57]-J[58]+
    J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]-H[1]-H[2]+H[3]-H[4]+H[5]+H[6]-H[7]+H[8]+H[9]-H[10]+
    H[11]-J[0]-J[1]+J[2]-J[3]+J[4]+J[5]-J[6]+J[7]+J[8]-J[9]+J[10]+J[11]-J[12]+J[13]-J[14]-J[15]+J[16]-J[17]-J[18]+
    J[19]-J[20]-J[21]+J[22]-J[23]-J[24]+J[25]-J[26]-J[27]+J[28]-J[29]-J[30]+J[31]+J[32]-J[33]+J[34]+J[35]-J[36]+
    J[37]-J[38]-J[39]+J[40]-J[41]-J[42]+J[43]-J[44]+J[45]-J[46]+J[47]+J[48]-J[49]+J[50]-J[51]+J[52]+J[53]-J[54]+
    J[55]-J[56]-J[57]+J[58]-J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]-H[1]-H[2]+H[3]-H[4]+H[5]+H[6]-H[7]+
    H[8]+H[9]-H[10]-H[11]-J[0]-J[1]+J[2]-J[3]+J[4]+J[5]-J[6]+J[7]+J[8]-J[9]-J[10]+J[11]-J[12]+J[13]-J[14]-J[15]+
    J[16]-J[17]-J[18]+J[19]+J[20]-J[21]+J[22]-J[23]-J[24]+J[25]-J[26]-J[27]+J[28]+J[29]-J[30]+J[31]+J[32]-J[33]+
    J[34]+J[35]-J[36]-J[37]-J[38]-J[39]+J[40]-J[41]-J[42]+J[43]+J[44]+J[45]-J[46]+J[47]+J[48]-J[49]-J[50]-J[51]+
    J[52]+J[53]-J[54]-J[55]-J[56]-J[57]+J[58]+J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]-H[1]-H[2]+
    H[3]-H[4]+H[5]+H[6]-H[7]+H[8]-H[9]+H[10]+H[11]-J[0]-J[1]+J[2]-J[3]+J[4]+J[5]-J[6]+J[7]-J[8]+J[9]+J[10]+
    J[11]-J[12]+J[13]-J[14]-J[15]+J[16]-J[17]+J[18]-J[19]-J[20]-J[21]+J[22]-J[23]-J[24]+J[25]-J[26]+J[27]-J[28]-J[29]-J[30]+
    J[31]+J[32]-J[33]+J[34]-J[35]+J[36]+J[37]-J[38]-J[39]+J[40]-J[41]+J[42]-J[43]-J[44]+J[45]-J[46]+J[47]-J[48]+
    J[49]+J[50]-J[51]+J[52]-J[53]+J[54]+J[55]-J[56]+J[57]-J[58]-J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +
    H[0]-H[1]-H[2]+H[3]-H[4]+H[5]+H[6]-H[7]+H[8]-H[9]+H[10]-H[11]-J[0]-J[1]+J[2]-J[3]+J[4]+J[5]-J[6]+J[7]-J[8]+
    J[9]-J[10]+J[11]-J[12]+J[13]-J[14]-J[15]+J[16]-J[17]+J[18]-J[19]+J[20]-J[21]+J[22]-J[23]-J[24]+J[25]-J[26]+
    J[27]-J[28]+J[29]-J[30]+J[31]+J[32]-J[33]+J[34]-J[35]+J[36]-J[37]-J[38]-J[39]+J[40]-J[41]+J[42]-J[43]+
    J[44]+J[45]-J[46]+J[47]-J[48]+J[49]-J[50]-J[51]+J[52]-J[53]+J[54]-J[55]-J[56]+J[57]-J[58]+J[59]-J[60]+
    J[61]-J[62]-J[63]+J[64]-J[65], +H[0]-H[1]-H[2]+H[3]-H[4]+H[5]+H[6]-H[7]+H[8]-H[9]-H[10]+H[11]-J[0]-J[1]+
    J[2]-J[3]+J[4]+J[5]-J[6]+J[7]-J[8]-J[9]+J[10]+J[11]-J[12]+J[13]-J[14]-J[15]+J[16]-J[17]+J[18]+J[19]-J[20]-J[21]+
    J[22]-J[23]-J[24]+J[25]-J[26]+J[27]+J[28]-J[29]-J[30]+J[31]+J[32]-J[33]+J[34]-J[35]-J[36]+J[37]-J[38]-J[39]+
    J[40]-J[41]+J[42]+J[43]-J[44]+J[45]-J[46]+J[47]-J[48]-J[49]+J[50]-J[51]+J[52]-J[53]-J[54]+J[55]-J[56]+
    J[57]+J[58]-J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]-H[1]-H[2]+H[3]-H[4]+H[5]+H[6]-H[7]+H[8]-H[9]-H[10]-H[11]-J[0]-J[1]+
    J[2]-J[3]+J[4]+J[5]-J[6]+J[7]-J[8]-J[9]-J[10]+J[11]-J[12]+J[13]-J[14]-J[15]+J[16]-J[17]+J[18]+J[19]+
    J[20]-J[21]+J[22]-J[23]-J[24]+J[25]-J[26]+J[27]+J[28]+J[29]-J[30]+J[31]+J[32]-J[33]+J[34]-J[35]-J[36]-J[37]-J[38]-J[39]+
    J[40]-J[41]+J[42]+J[43]+J[44]+J[45]-J[46]+J[47]-J[48]-J[49]-J[50]-J[51]+J[52]-J[53]-J[54]-J[55]-J[56]+
    J[57]+J[58]+J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]-H[1]-H[2]+H[3]-H[4]+H[5]+H[6]-H[7]-H[8]+
    H[9]+H[10]+H[11]-J[0]-J[1]+J[2]-J[3]+J[4]+J[5]-J[6]-J[7]+J[8]+J[9]+J[10]+J[11]-J[12]+J[13]-J[14]-J[15]+
    J[16]+J[17]-J[18]-J[19]-J[20]-J[21]+J[22]-J[23]-J[24]+J[25]+J[26]-J[27]-J[28]-J[29]-J[30]+J[31]+J[32]-J[33]-J[34]+
    J[35]+J[36]+J[37]-J[38]-J[39]+J[40]+J[41]-J[42]-J[43]-J[44]+J[45]-J[46]-J[47]+J[48]+J[49]+J[50]-J[51]-J[52]+
    J[53]+J[54]+J[55]+J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]-H[1]-H[2]+H[3]-H[4]+
    H[5]+H[6]-H[7]-H[8]+H[9]+H[10]-H[11]-J[0]-J[1]+J[2]-J[3]+J[4]+J[5]-J[6]-J[7]+J[8]+J[9]-J[10]+J[11]-J[12]+
    J[13]-J[14]-J[15]+J[16]+J[17]-J[18]-J[19]+J[20]-J[21]+J[22]-J[23]-J[24]+J[25]+J[26]-J[27]-J[28]+J[29]-J[30]+
    J[31]+J[32]-J[33]-J[34]+J[35]+J[36]-J[37]-J[38]-J[39]+J[40]+J[41]-J[42]-J[43]+J[44]+J[45]-J[46]-J[47]+
    J[48]+J[49]-J[50]-J[51]-J[52]+J[53]+J[54]-J[55]+J[56]-J[57]-J[58]+J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +
    H[0]-H[1]-H[2]+H[3]-H[4]+H[5]+H[6]-H[7]-H[8]+H[9]-H[10]+H[11]-J[0]-J[1]+J[2]-J[3]+J[4]+J[5]-J[6]-J[7]+
    J[8]-J[9]+J[10]+J[11]-J[12]+J[13]-J[14]-J[15]+J[16]+J[17]-J[18]+J[19]-J[20]-J[21]+J[22]-J[23]-J[24]+
    J[25]+J[26]-J[27]+J[28]-J[29]-J[30]+J[31]+J[32]-J[33]-J[34]+J[35]-J[36]+J[37]-J[38]-J[39]+J[40]+J[41]-J[42]+
    J[43]-J[44]+J[45]-J[46]-J[47]+J[48]-J[49]+J[50]-J[51]-J[52]+J[53]-J[54]+J[55]+J[56]-J[57]+J[58]-J[59]-J[60]+
    J[61]-J[62]-J[63]+J[64]-J[65], +H[0]-H[1]-H[2]+H[3]-H[4]+H[5]+H[6]-H[7]-H[8]+H[9]-H[10]-H[11]-J[0]-J[1]+
    J[2]-J[3]+J[4]+J[5]-J[6]-J[7]+J[8]-J[9]-J[10]+J[11]-J[12]+J[13]-J[14]-J[15]+J[16]+J[17]-J[18]+J[19]+
    J[20]-J[21]+J[22]-J[23]-J[24]+J[25]+J[26]-J[27]+J[28]+J[29]-J[30]+J[31]+J[32]-J[33]-J[34]+J[35]-J[36]-J[37]-J[38]-J[39]+
    J[40]+J[41]-J[42]+J[43]+J[44]+J[45]-J[46]-J[47]+J[48]-J[49]-J[50]-J[51]-J[52]+J[53]-J[54]-J[55]+J[56]-J[57]+
    J[58]+J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]-H[1]-H[2]+H[3]-H[4]+H[5]+H[6]-H[7]-H[8]-H[9]+
    H[10]+H[11]-J[0]-J[1]+J[2]-J[3]+J[4]+J[5]-J[6]-J[7]-J[8]+J[9]+J[10]+J[11]-J[12]+J[13]-J[14]-J[15]+J[16]+
    J[17]+J[18]-J[19]-J[20]-J[21]+J[22]-J[23]-J[24]+J[25]+J[26]+J[27]-J[28]-J[29]-J[30]+J[31]+J[32]-J[33]-J[34]-J[35]+
    J[36]+J[37]-J[38]-J[39]+J[40]+J[41]+J[42]-J[43]-J[44]+J[45]-J[46]-J[47]-J[48]+J[49]+J[50]-J[51]-J[52]-J[53]+
    J[54]+J[55]+J[56]+J[57]-J[58]-J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]-H[1]-H[2]+H[3]-H[4]+H[5]+
    H[6]-H[7]-H[8]-H[9]+H[10]-H[11]-J[0]-J[1]+J[2]-J[3]+J[4]+J[5]-J[6]-J[7]-J[8]+J[9]-J[10]+J[11]-J[12]+
    J[13]-J[14]-J[15]+J[16]+J[17]+J[18]-J[19]+J[20]-J[21]+J[22]-J[23]-J[24]+J[25]+J[26]+J[27]-J[28]+J[29]-J[30]+
    J[31]+J[32]-J[33]-J[34]-J[35]+J[36]-J[37]-J[38]-J[39]+J[40]+J[41]+J[42]-J[43]+J[44]+J[45]-J[46]-J[47]-J[48]+
    J[49]-J[50]-J[51]-J[52]-J[53]+J[54]-J[55]+J[56]+J[57]-J[58]+J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +
    H[0]-H[1]-H[2]+H[3]-H[4]+H[5]+H[6]-H[7]-H[8]-H[9]-H[10]+H[11]-J[0]-J[1]+J[2]-J[3]+J[4]+J[5]-J[6]-J[7]-J[8]-J[9]+
    J[10]+J[11]-J[12]+J[13]-J[14]-J[15]+J[16]+J[17]+J[18]+J[19]-J[20]-J[21]+J[22]-J[23]-J[24]+J[25]+J[26]+
    J[27]+J[28]-J[29]-J[30]+J[31]+J[32]-J[33]-J[34]-J[35]-J[36]+J[37]-J[38]-J[39]+J[40]+J[41]+J[42]+J[43]-J[44]+
    J[45]-J[46]-J[47]-J[48]-J[49]+J[50]-J[51]-J[52]-J[53]-J[54]+J[55]+J[56]+J[57]+J[58]-J[59]+J[60]+J[61]-J[62]+
    J[63]-J[64]-J[65], +H[0]-H[1]-H[2]+H[3]-H[4]+H[5]+H[6]-H[7]-H[8]-H[9]-H[10]-H[11]-J[0]-J[1]+J[2]-J[3]+
    J[4]+J[5]-J[6]-J[7]-J[8]-J[9]-J[10]+J[11]-J[12]+J[13]-J[14]-J[15]+J[16]+J[17]+J[18]+J[19]+J[20]-J[21]+
    J[22]-J[23]-J[24]+J[25]+J[26]+J[27]+J[28]+J[29]-J[30]+J[31]+J[32]-J[33]-J[34]-J[35]-J[36]-J[37]-J[38]-J[39]+
    J[40]+J[41]+J[42]+J[43]+J[44]+J[45]-J[46]-J[47]-J[48]-J[49]-J[50]-J[51]-J[52]-J[53]-J[54]-J[55]+J[56]+
    J[57]+J[58]+J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]-H[1]-H[2]+H[3]-H[4]+H[5]-H[6]+H[7]+H[8]+
    H[9]+H[10]+H[11]-J[0]-J[1]+J[2]-J[3]+J[4]-J[5]+J[6]+J[7]+J[8]+J[9]+J[10]+J[11]-J[12]+J[13]-J[14]+J[15]-J[16]-J[17]-J[18]-J[19]-J[20]-J[21]+
    J[22]-J[23]+J[24]-J[25]-J[26]-J[27]-J[28]-J[29]-J[30]+J[31]-J[32]+J[33]+J[34]+J[35]+J[36]+J[37]-J[38]+
    J[39]-J[40]-J[41]-J[42]-J[43]-J[44]-J[45]+J[46]+J[47]+J[48]+J[49]+J[50]-J[51]-J[52]-J[53]-J[54]-J[55]+
    J[56]+J[57]+J[58]+J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]-H[1]-H[2]+H[3]-H[4]+H[5]-H[6]+H[7]+
    H[8]+H[9]+H[10]-H[11]-J[0]-J[1]+J[2]-J[3]+J[4]-J[5]+J[6]+J[7]+J[8]+J[9]-J[10]+J[11]-J[12]+J[13]-J[14]+
    J[15]-J[16]-J[17]-J[18]-J[19]+J[20]-J[21]+J[22]-J[23]+J[24]-J[25]-J[26]-J[27]-J[28]+J[29]-J[30]+J[31]-J[32]+
    J[33]+J[34]+J[35]+J[36]-J[37]-J[38]+J[39]-J[40]-J[41]-J[42]-J[43]+J[44]-J[45]+J[46]+J[47]+J[48]+J[49]-J[50]-J[51]-J[52]-J[53]-J[54]+
    J[55]+J[56]+J[57]+J[58]-J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]-H[1]-H[2]+H[3]-H[4]+H[5]-H[6]+
    H[7]+H[8]+H[9]-H[10]+H[11]-J[0]-J[1]+J[2]-J[3]+J[4]-J[5]+J[6]+J[7]+J[8]-J[9]+J[10]+J[11]-J[12]+J[13]-J[14]+
    J[15]-J[16]-J[17]-J[18]+J[19]-J[20]-J[21]+J[22]-J[23]+J[24]-J[25]-J[26]-J[27]+J[28]-J[29]-J[30]+J[31]-J[32]+
    J[33]+J[34]+J[35]-J[36]+J[37]-J[38]+J[39]-J[40]-J[41]-J[42]+J[43]-J[44]-J[45]+J[46]+J[47]+J[48]-J[49]+
    J[50]-J[51]-J[52]-J[53]+J[54]-J[55]+J[56]+J[57]-J[58]+J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]-H[1]-H[2]+
    H[3]-H[4]+H[5]-H[6]+H[7]+H[8]+H[9]-H[10]-H[11]-J[0]-J[1]+J[2]-J[3]+J[4]-J[5]+J[6]+J[7]+J[8]-J[9]-J[10]+
    J[11]-J[12]+J[13]-J[14]+J[15]-J[16]-J[17]-J[18]+J[19]+J[20]-J[21]+J[22]-J[23]+J[24]-J[25]-J[26]-J[27]+
    J[28]+J[29]-J[30]+J[31]-J[32]+J[33]+J[34]+J[35]-J[36]-J[37]-J[38]+J[39]-J[40]-J[41]-J[42]+J[43]+J[44]-J[45]+
    J[46]+J[47]+J[48]-J[49]-J[50]-J[51]-J[52]-J[53]+J[54]+J[55]+J[56]+J[57]-J[58]-J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+
    J[65], +H[0]-H[1]-H[2]+H[3]-H[4]+H[5]-H[6]+H[7]+H[8]-H[9]+H[10]+H[11]-J[0]-J[1]+J[2]-J[3]+J[4]-J[5]+
    J[6]+J[7]-J[8]+J[9]+J[10]+J[11]-J[12]+J[13]-J[14]+J[15]-J[16]-J[17]+J[18]-J[19]-J[20]-J[21]+J[22]-J[23]+
    J[24]-J[25]-J[26]+J[27]-J[28]-J[29]-J[30]+J[31]-J[32]+J[33]+J[34]-J[35]+J[36]+J[37]-J[38]+J[39]-J[40]-J[41]+
    J[42]-J[43]-J[44]-J[45]+J[46]+J[47]-J[48]+J[49]+J[50]-J[51]-J[52]+J[53]-J[54]-J[55]+J[56]-J[57]+J[58]+
    J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]-H[1]-H[2]+H[3]-H[4]+H[5]-H[6]+H[7]+H[8]-H[9]+H[10]-H[11]-J[0]-J[1]+
    J[2]-J[3]+J[4]-J[5]+J[6]+J[7]-J[8]+J[9]-J[10]+J[11]-J[12]+J[13]-J[14]+J[15]-J[16]-J[17]+J[18]-J[19]+
    J[20]-J[21]+J[22]-J[23]+J[24]-J[25]-J[26]+J[27]-J[28]+J[29]-J[30]+J[31]-J[32]+J[33]+J[34]-J[35]+J[36]-J[37]-J[38]+
    J[39]-J[40]-J[41]+J[42]-J[43]+J[44]-J[45]+J[46]+J[47]-J[48]+J[49]-J[50]-J[51]-J[52]+J[53]-J[54]+J[55]+
    J[56]-J[57]+J[58]-J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]-H[1]-H[2]+H[3]-H[4]+H[5]-H[6]+H[7]+
    H[8]-H[9]-H[10]+H[11]-J[0]-J[1]+J[2]-J[3]+J[4]-J[5]+J[6]+J[7]-J[8]-J[9]+J[10]+J[11]-J[12]+J[13]-J[14]+
    J[15]-J[16]-J[17]+J[18]+J[19]-J[20]-J[21]+J[22]-J[23]+J[24]-J[25]-J[26]+J[27]+J[28]-J[29]-J[30]+J[31]-J[32]+
    J[33]+J[34]-J[35]-J[36]+J[37]-J[38]+J[39]-J[40]-J[41]+J[42]+J[43]-J[44]-J[45]+J[46]+J[47]-J[48]-J[49]+
    J[50]-J[51]-J[52]+J[53]+J[54]-J[55]+J[56]-J[57]-J[58]+J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]-H[1]-H[2]+
    H[3]-H[4]+H[5]-H[6]+H[7]+H[8]-H[9]-H[10]-H[11]-J[0]-J[1]+J[2]-J[3]+J[4]-J[5]+J[6]+J[7]-J[8]-J[9]-J[10]+
    J[11]-J[12]+J[13]-J[14]+J[15]-J[16]-J[17]+J[18]+J[19]+J[20]-J[21]+J[22]-J[23]+J[24]-J[25]-J[26]+J[27]+
    J[28]+J[29]-J[30]+J[31]-J[32]+J[33]+J[34]-J[35]-J[36]-J[37]-J[38]+J[39]-J[40]-J[41]+J[42]+J[43]+J[44]-J[45]+
    J[46]+J[47]-J[48]-J[49]-J[50]-J[51]-J[52]+J[53]+J[54]+J[55]+J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+
    J[63]+J[64]+J[65], +H[0]-H[1]-H[2]+H[3]-H[4]+H[5]-H[6]+H[7]-H[8]+H[9]+H[10]+H[11]-J[0]-J[1]+J[2]-J[3]+
    J[4]-J[5]+J[6]-J[7]+J[8]+J[9]+J[10]+J[11]-J[12]+J[13]-J[14]+J[15]-J[16]+J[17]-J[18]-J[19]-J[20]-J[21]+
    J[22]-J[23]+J[24]-J[25]+J[26]-J[27]-J[28]-J[29]-J[30]+J[31]-J[32]+J[33]-J[34]+J[35]+J[36]+J[37]-J[38]+
    J[39]-J[40]+J[41]-J[42]-J[43]-J[44]-J[45]+J[46]-J[47]+J[48]+J[49]+J[50]-J[51]+J[52]-J[53]-J[54]-J[55]-J[56]+
    J[57]+J[58]+J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]-H[1]-H[2]+H[3]-H[4]+H[5]-H[6]+H[7]-H[8]+
    H[9]+H[10]-H[11]-J[0]-J[1]+J[2]-J[3]+J[4]-J[5]+J[6]-J[7]+J[8]+J[9]-J[10]+J[11]-J[12]+J[13]-J[14]+J[15]-J[16]+
    J[17]-J[18]-J[19]+J[20]-J[21]+J[22]-J[23]+J[24]-J[25]+J[26]-J[27]-J[28]+J[29]-J[30]+J[31]-J[32]+J[33]-J[34]+
    J[35]+J[36]-J[37]-J[38]+J[39]-J[40]+J[41]-J[42]-J[43]+J[44]-J[45]+J[46]-J[47]+J[48]+J[49]-J[50]-J[51]+
    J[52]-J[53]-J[54]+J[55]-J[56]+J[57]+J[58]-J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]-H[1]-H[2]+
    H[3]-H[4]+H[5]-H[6]+H[7]-H[8]+H[9]-H[10]+H[11]-J[0]-J[1]+J[2]-J[3]+J[4]-J[5]+J[6]-J[7]+J[8]-J[9]+J[10]+
    J[11]-J[12]+J[13]-J[14]+J[15]-J[16]+J[17]-J[18]+J[19]-J[20]-J[21]+J[22]-J[23]+J[24]-J[25]+J[26]-J[27]+
    J[28]-J[29]-J[30]+J[31]-J[32]+J[33]-J[34]+J[35]-J[36]+J[37]-J[38]+J[39]-J[40]+J[41]-J[42]+J[43]-J[44]-J[45]+
    J[46]-J[47]+J[48]-J[49]+J[50]-J[51]+J[52]-J[53]+J[54]-J[55]-J[56]+J[57]-J[58]+J[59]-J[60]+J[61]-J[62]-J[63]+
    J[64]-J[65], +H[0]-H[1]-H[2]+H[3]-H[4]+H[5]-H[6]+H[7]-H[8]+H[9]-H[10]-H[11]-J[0]-J[1]+J[2]-J[3]+J[4]-J[5]+
    J[6]-J[7]+J[8]-J[9]-J[10]+J[11]-J[12]+J[13]-J[14]+J[15]-J[16]+J[17]-J[18]+J[19]+J[20]-J[21]+J[22]-J[23]+
    J[24]-J[25]+J[26]-J[27]+J[28]+J[29]-J[30]+J[31]-J[32]+J[33]-J[34]+J[35]-J[36]-J[37]-J[38]+J[39]-J[40]+
    J[41]-J[42]+J[43]+J[44]-J[45]+J[46]-J[47]+J[48]-J[49]-J[50]-J[51]+J[52]-J[53]+J[54]+J[55]-J[56]+J[57]-J[58]-J[59]-J[60]+
    J[61]+J[62]-J[63]-J[64]+J[65], +H[0]-H[1]-H[2]+H[3]-H[4]+H[5]-H[6]+H[7]-H[8]-H[9]+H[10]+H[11]-J[0]-J[1]+
    J[2]-J[3]+J[4]-J[5]+J[6]-J[7]-J[8]+J[9]+J[10]+J[11]-J[12]+J[13]-J[14]+J[15]-J[16]+J[17]+J[18]-J[19]-J[20]-J[21]+
    J[22]-J[23]+J[24]-J[25]+J[26]+J[27]-J[28]-J[29]-J[30]+J[31]-J[32]+J[33]-J[34]-J[35]+J[36]+J[37]-J[38]+
    J[39]-J[40]+J[41]+J[42]-J[43]-J[44]-J[45]+J[46]-J[47]-J[48]+J[49]+J[50]-J[51]+J[52]+J[53]-J[54]-J[55]-J[56]-J[57]+
    J[58]+J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]-H[1]-H[2]+H[3]-H[4]+H[5]-H[6]+H[7]-H[8]-H[9]+
    H[10]-H[11]-J[0]-J[1]+J[2]-J[3]+J[4]-J[5]+J[6]-J[7]-J[8]+J[9]-J[10]+J[11]-J[12]+J[13]-J[14]+J[15]-J[16]+
    J[17]+J[18]-J[19]+J[20]-J[21]+J[22]-J[23]+J[24]-J[25]+J[26]+J[27]-J[28]+J[29]-J[30]+J[31]-J[32]+J[33]-J[34]-J[35]+
    J[36]-J[37]-J[38]+J[39]-J[40]+J[41]+J[42]-J[43]+J[44]-J[45]+J[46]-J[47]-J[48]+J[49]-J[50]-J[51]+J[52]+
    J[53]-J[54]+J[55]-J[56]-J[57]+J[58]-J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]-H[1]-H[2]+H[3]-H[4]+
    H[5]-H[6]+H[7]-H[8]-H[9]-H[10]+H[11]-J[0]-J[1]+J[2]-J[3]+J[4]-J[5]+J[6]-J[7]-J[8]-J[9]+J[10]+J[11]-J[12]+
    J[13]-J[14]+J[15]-J[16]+J[17]+J[18]+J[19]-J[20]-J[21]+J[22]-J[23]+J[24]-J[25]+J[26]+J[27]+J[28]-J[29]-J[30]+
    J[31]-J[32]+J[33]-J[34]-J[35]-J[36]+J[37]-J[38]+J[39]-J[40]+J[41]+J[42]+J[43]-J[44]-J[45]+J[46]-J[47]-J[48]-J[49]+
    J[50]-J[51]+J[52]+J[53]+J[54]-J[55]-J[56]-J[57]-J[58]+J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]-H[1]-H[2]+
    H[3]-H[4]+H[5]-H[6]+H[7]-H[8]-H[9]-H[10]-H[11]-J[0]-J[1]+J[2]-J[3]+J[4]-J[5]+J[6]-J[7]-J[8]-J[9]-J[10]+
    J[11]-J[12]+J[13]-J[14]+J[15]-J[16]+J[17]+J[18]+J[19]+J[20]-J[21]+J[22]-J[23]+J[24]-J[25]+J[26]+J[27]+
    J[28]+J[29]-J[30]+J[31]-J[32]+J[33]-J[34]-J[35]-J[36]-J[37]-J[38]+J[39]-J[40]+J[41]+J[42]+J[43]+J[44]-J[45]+
    J[46]-J[47]-J[48]-J[49]-J[50]-J[51]+J[52]+J[53]+J[54]+J[55]-J[56]-J[57]-J[58]-J[59]+J[60]+J[61]+J[62]+
    J[63]+J[64]+J[65], +H[0]-H[1]-H[2]+H[3]-H[4]+H[5]-H[6]-H[7]+H[8]+H[9]+H[10]+H[11]-J[0]-J[1]+J[2]-J[3]+
    J[4]-J[5]-J[6]+J[7]+J[8]+J[9]+J[10]+J[11]-J[12]+J[13]-J[14]+J[15]+J[16]-J[17]-J[18]-J[19]-J[20]-J[21]+
    J[22]-J[23]+J[24]+J[25]-J[26]-J[27]-J[28]-J[29]-J[30]+J[31]-J[32]-J[33]+J[34]+J[35]+J[36]+J[37]-J[38]+
    J[39]+J[40]-J[41]-J[42]-J[43]-J[44]-J[45]-J[46]+J[47]+J[48]+J[49]+J[50]+J[51]-J[52]-J[53]-J[54]-J[55]-J[56]-J[57]-J[58]-J[59]+
    J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]-H[1]-H[2]+H[3]-H[4]+H[5]-H[6]-H[7]+H[8]+H[9]+H[10]-H[11]-J[0]-J[1]+
    J[2]-J[3]+J[4]-J[5]-J[6]+J[7]+J[8]+J[9]-J[10]+J[11]-J[12]+J[13]-J[14]+J[15]+J[16]-J[17]-J[18]-J[19]+
    J[20]-J[21]+J[22]-J[23]+J[24]+J[25]-J[26]-J[27]-J[28]+J[29]-J[30]+J[31]-J[32]-J[33]+J[34]+J[35]+J[36]-J[37]-J[38]+
    J[39]+J[40]-J[41]-J[42]-J[43]+J[44]-J[45]-J[46]+J[47]+J[48]+J[49]-J[50]+J[51]-J[52]-J[53]-J[54]+J[55]-J[56]-J[57]-J[58]+
    J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]-H[1]-H[2]+H[3]-H[4]+H[5]-H[6]-H[7]+H[8]+H[9]-H[10]+
    H[11]-J[0]-J[1]+J[2]-J[3]+J[4]-J[5]-J[6]+J[7]+J[8]-J[9]+J[10]+J[11]-J[12]+J[13]-J[14]+J[15]+J[16]-J[17]-J[18]+
    J[19]-J[20]-J[21]+J[22]-J[23]+J[24]+J[25]-J[26]-J[27]+J[28]-J[29]-J[30]+J[31]-J[32]-J[33]+J[34]+J[35]-J[36]+
    J[37]-J[38]+J[39]+J[40]-J[41]-J[42]+J[43]-J[44]-J[45]-J[46]+J[47]+J[48]-J[49]+J[50]+J[51]-J[52]-J[53]+
    J[54]-J[55]-J[56]-J[57]+J[58]-J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]-H[1]-H[2]+H[3]-H[4]+H[5]-H[6]-H[7]+
    H[8]+H[9]-H[10]-H[11]-J[0]-J[1]+J[2]-J[3]+J[4]-J[5]-J[6]+J[7]+J[8]-J[9]-J[10]+J[11]-J[12]+J[13]-J[14]+
    J[15]+J[16]-J[17]-J[18]+J[19]+J[20]-J[21]+J[22]-J[23]+J[24]+J[25]-J[26]-J[27]+J[28]+J[29]-J[30]+J[31]-J[32]-J[33]+
    J[34]+J[35]-J[36]-J[37]-J[38]+J[39]+J[40]-J[41]-J[42]+J[43]+J[44]-J[45]-J[46]+J[47]+J[48]-J[49]-J[50]+
    J[51]-J[52]-J[53]+J[54]+J[55]-J[56]-J[57]+J[58]+J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]-H[1]-H[2]+
    H[3]-H[4]+H[5]-H[6]-H[7]+H[8]-H[9]+H[10]+H[11]-J[0]-J[1]+J[2]-J[3]+J[4]-J[5]-J[6]+J[7]-J[8]+J[9]+J[10]+
    J[11]-J[12]+J[13]-J[14]+J[15]+J[16]-J[17]+J[18]-J[19]-J[20]-J[21]+J[22]-J[23]+J[24]+J[25]-J[26]+J[27]-J[28]-J[29]-J[30]+
    J[31]-J[32]-J[33]+J[34]-J[35]+J[36]+J[37]-J[38]+J[39]+J[40]-J[41]+J[42]-J[43]-J[44]-J[45]-J[46]+J[47]-J[48]+
    J[49]+J[50]+J[51]-J[52]+J[53]-J[54]-J[55]-J[56]+J[57]-J[58]-J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +
    H[0]-H[1]-H[2]+H[3]-H[4]+H[5]-H[6]-H[7]+H[8]-H[9]+H[10]-H[11]-J[0]-J[1]+J[2]-J[3]+J[4]-J[5]-J[6]+J[7]-J[8]+
    J[9]-J[10]+J[11]-J[12]+J[13]-J[14]+J[15]+J[16]-J[17]+J[18]-J[19]+J[20]-J[21]+J[22]-J[23]+J[24]+J[25]-J[26]+
    J[27]-J[28]+J[29]-J[30]+J[31]-J[32]-J[33]+J[34]-J[35]+J[36]-J[37]-J[38]+J[39]+J[40]-J[41]+J[42]-J[43]+
    J[44]-J[45]-J[46]+J[47]-J[48]+J[49]-J[50]+J[51]-J[52]+J[53]-J[54]+J[55]-J[56]+J[57]-J[58]+J[59]-J[60]+
    J[61]-J[62]-J[63]+J[64]-J[65], +H[0]-H[1]-H[2]+H[3]-H[4]+H[5]-H[6]-H[7]+H[8]-H[9]-H[10]+H[11]-J[0]-J[1]+
    J[2]-J[3]+J[4]-J[5]-J[6]+J[7]-J[8]-J[9]+J[10]+J[11]-J[12]+J[13]-J[14]+J[15]+J[16]-J[17]+J[18]+J[19]-J[20]-J[21]+
    J[22]-J[23]+J[24]+J[25]-J[26]+J[27]+J[28]-J[29]-J[30]+J[31]-J[32]-J[33]+J[34]-J[35]-J[36]+J[37]-J[38]+
    J[39]+J[40]-J[41]+J[42]+J[43]-J[44]-J[45]-J[46]+J[47]-J[48]-J[49]+J[50]+J[51]-J[52]+J[53]+J[54]-J[55]-J[56]+
    J[57]+J[58]-J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]-H[1]-H[2]+H[3]-H[4]+H[5]-H[6]-H[7]+H[8]-H[9]-H[10]-H[11]-J[0]-J[1]+
    J[2]-J[3]+J[4]-J[5]-J[6]+J[7]-J[8]-J[9]-J[10]+J[11]-J[12]+J[13]-J[14]+J[15]+J[16]-J[17]+J[18]+J[19]+
    J[20]-J[21]+J[22]-J[23]+J[24]+J[25]-J[26]+J[27]+J[28]+J[29]-J[30]+J[31]-J[32]-J[33]+J[34]-J[35]-J[36]-J[37]-J[38]+
    J[39]+J[40]-J[41]+J[42]+J[43]+J[44]-J[45]-J[46]+J[47]-J[48]-J[49]-J[50]+J[51]-J[52]+J[53]+J[54]+J[55]-J[56]+
    J[57]+J[58]+J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]-H[1]-H[2]+H[3]-H[4]+H[5]-H[6]-H[7]-H[8]+
    H[9]+H[10]+H[11]-J[0]-J[1]+J[2]-J[3]+J[4]-J[5]-J[6]-J[7]+J[8]+J[9]+J[10]+J[11]-J[12]+J[13]-J[14]+J[15]+
    J[16]+J[17]-J[18]-J[19]-J[20]-J[21]+J[22]-J[23]+J[24]+J[25]+J[26]-J[27]-J[28]-J[29]-J[30]+J[31]-J[32]-J[33]-J[34]+
    J[35]+J[36]+J[37]-J[38]+J[39]+J[40]+J[41]-J[42]-J[43]-J[44]-J[45]-J[46]-J[47]+J[48]+J[49]+J[50]+J[51]+
    J[52]-J[53]-J[54]-J[55]+J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]-H[1]-H[2]+
    H[3]-H[4]+H[5]-H[6]-H[7]-H[8]+H[9]+H[10]-H[11]-J[0]-J[1]+J[2]-J[3]+J[4]-J[5]-J[6]-J[7]+J[8]+J[9]-J[10]+
    J[11]-J[12]+J[13]-J[14]+J[15]+J[16]+J[17]-J[18]-J[19]+J[20]-J[21]+J[22]-J[23]+J[24]+J[25]+J[26]-J[27]-J[28]+
    J[29]-J[30]+J[31]-J[32]-J[33]-J[34]+J[35]+J[36]-J[37]-J[38]+J[39]+J[40]+J[41]-J[42]-J[43]+J[44]-J[45]-J[46]-J[47]+
    J[48]+J[49]-J[50]+J[51]+J[52]-J[53]-J[54]+J[55]+J[56]-J[57]-J[58]+J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +
    H[0]-H[1]-H[2]+H[3]-H[4]+H[5]-H[6]-H[7]-H[8]+H[9]-H[10]+H[11]-J[0]-J[1]+J[2]-J[3]+J[4]-J[5]-J[6]-J[7]+
    J[8]-J[9]+J[10]+J[11]-J[12]+J[13]-J[14]+J[15]+J[16]+J[17]-J[18]+J[19]-J[20]-J[21]+J[22]-J[23]+J[24]+
    J[25]+J[26]-J[27]+J[28]-J[29]-J[30]+J[31]-J[32]-J[33]-J[34]+J[35]-J[36]+J[37]-J[38]+J[39]+J[40]+J[41]-J[42]+
    J[43]-J[44]-J[45]-J[46]-J[47]+J[48]-J[49]+J[50]+J[51]+J[52]-J[53]+J[54]-J[55]+J[56]-J[57]+J[58]-J[59]-J[60]+
    J[61]-J[62]-J[63]+J[64]-J[65], +H[0]-H[1]-H[2]+H[3]-H[4]+H[5]-H[6]-H[7]-H[8]+H[9]-H[10]-H[11]-J[0]-J[1]+
    J[2]-J[3]+J[4]-J[5]-J[6]-J[7]+J[8]-J[9]-J[10]+J[11]-J[12]+J[13]-J[14]+J[15]+J[16]+J[17]-J[18]+J[19]+
    J[20]-J[21]+J[22]-J[23]+J[24]+J[25]+J[26]-J[27]+J[28]+J[29]-J[30]+J[31]-J[32]-J[33]-J[34]+J[35]-J[36]-J[37]-J[38]+
    J[39]+J[40]+J[41]-J[42]+J[43]+J[44]-J[45]-J[46]-J[47]+J[48]-J[49]-J[50]+J[51]+J[52]-J[53]+J[54]+J[55]+
    J[56]-J[57]+J[58]+J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]-H[1]-H[2]+H[3]-H[4]+H[5]-H[6]-H[7]-H[8]-H[9]+
    H[10]+H[11]-J[0]-J[1]+J[2]-J[3]+J[4]-J[5]-J[6]-J[7]-J[8]+J[9]+J[10]+J[11]-J[12]+J[13]-J[14]+J[15]+J[16]+
    J[17]+J[18]-J[19]-J[20]-J[21]+J[22]-J[23]+J[24]+J[25]+J[26]+J[27]-J[28]-J[29]-J[30]+J[31]-J[32]-J[33]-J[34]-J[35]+
    J[36]+J[37]-J[38]+J[39]+J[40]+J[41]+J[42]-J[43]-J[44]-J[45]-J[46]-J[47]-J[48]+J[49]+J[50]+J[51]+J[52]+
    J[53]-J[54]-J[55]+J[56]+J[57]-J[58]-J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]-H[1]-H[2]+H[3]-H[4]+
    H[5]-H[6]-H[7]-H[8]-H[9]+H[10]-H[11]-J[0]-J[1]+J[2]-J[3]+J[4]-J[5]-J[6]-J[7]-J[8]+J[9]-J[10]+J[11]-J[12]+
    J[13]-J[14]+J[15]+J[16]+J[17]+J[18]-J[19]+J[20]-J[21]+J[22]-J[23]+J[24]+J[25]+J[26]+J[27]-J[28]+J[29]-J[30]+
    J[31]-J[32]-J[33]-J[34]-J[35]+J[36]-J[37]-J[38]+J[39]+J[40]+J[41]+J[42]-J[43]+J[44]-J[45]-J[46]-J[47]-J[48]+
    J[49]-J[50]+J[51]+J[52]+J[53]-J[54]+J[55]+J[56]+J[57]-J[58]+J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +
    H[0]-H[1]-H[2]+H[3]-H[4]+H[5]-H[6]-H[7]-H[8]-H[9]-H[10]+H[11]-J[0]-J[1]+J[2]-J[3]+J[4]-J[5]-J[6]-J[7]-J[8]-J[9]+
    J[10]+J[11]-J[12]+J[13]-J[14]+J[15]+J[16]+J[17]+J[18]+J[19]-J[20]-J[21]+J[22]-J[23]+J[24]+J[25]+J[26]+
    J[27]+J[28]-J[29]-J[30]+J[31]-J[32]-J[33]-J[34]-J[35]-J[36]+J[37]-J[38]+J[39]+J[40]+J[41]+J[42]+J[43]-J[44]-J[45]-J[46]-J[47]-J[48]-J[49]+
    J[50]+J[51]+J[52]+J[53]+J[54]-J[55]+J[56]+J[57]+J[58]-J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]-H[1]-H[2]+
    H[3]-H[4]+H[5]-H[6]-H[7]-H[8]-H[9]-H[10]-H[11]-J[0]-J[1]+J[2]-J[3]+J[4]-J[5]-J[6]-J[7]-J[8]-J[9]-J[10]+
    J[11]-J[12]+J[13]-J[14]+J[15]+J[16]+J[17]+J[18]+J[19]+J[20]-J[21]+J[22]-J[23]+J[24]+J[25]+J[26]+J[27]+
    J[28]+J[29]-J[30]+J[31]-J[32]-J[33]-J[34]-J[35]-J[36]-J[37]-J[38]+J[39]+J[40]+J[41]+J[42]+J[43]+J[44]-J[45]-J[46]-J[47]-J[48]-J[49]-J[50]+
    J[51]+J[52]+J[53]+J[54]+J[55]+J[56]+J[57]+J[58]+J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]-H[1]-H[2]+
    H[3]-H[4]-H[5]+H[6]+H[7]+H[8]+H[9]+H[10]+H[11]-J[0]-J[1]+J[2]-J[3]-J[4]+J[5]+J[6]+J[7]+J[8]+J[9]+J[10]+
    J[11]-J[12]+J[13]+J[14]-J[15]-J[16]-J[17]-J[18]-J[19]-J[20]-J[21]+J[22]+J[23]-J[24]-J[25]-J[26]-J[27]-J[28]-J[29]-J[30]-J[31]+
    J[32]+J[33]+J[34]+J[35]+J[36]+J[37]+J[38]-J[39]-J[40]-J[41]-J[42]-J[43]-J[44]-J[45]-J[46]-J[47]-J[48]-J[49]-J[50]+
    J[51]+J[52]+J[53]+J[54]+J[55]+J[56]+J[57]+J[58]+J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]-H[1]-H[2]+
    H[3]-H[4]-H[5]+H[6]+H[7]+H[8]+H[9]+H[10]-H[11]-J[0]-J[1]+J[2]-J[3]-J[4]+J[5]+J[6]+J[7]+J[8]+J[9]-J[10]+
    J[11]-J[12]+J[13]+J[14]-J[15]-J[16]-J[17]-J[18]-J[19]+J[20]-J[21]+J[22]+J[23]-J[24]-J[25]-J[26]-J[27]-J[28]+
    J[29]-J[30]-J[31]+J[32]+J[33]+J[34]+J[35]+J[36]-J[37]+J[38]-J[39]-J[40]-J[41]-J[42]-J[43]+J[44]-J[45]-J[46]-J[47]-J[48]-J[49]+
    J[50]+J[51]+J[52]+J[53]+J[54]-J[55]+J[56]+J[57]+J[58]-J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]-H[1]-H[2]+
    H[3]-H[4]-H[5]+H[6]+H[7]+H[8]+H[9]-H[10]+H[11]-J[0]-J[1]+J[2]-J[3]-J[4]+J[5]+J[6]+J[7]+J[8]-J[9]+J[10]+
    J[11]-J[12]+J[13]+J[14]-J[15]-J[16]-J[17]-J[18]+J[19]-J[20]-J[21]+J[22]+J[23]-J[24]-J[25]-J[26]-J[27]+
    J[28]-J[29]-J[30]-J[31]+J[32]+J[33]+J[34]+J[35]-J[36]+J[37]+J[38]-J[39]-J[40]-J[41]-J[42]+J[43]-J[44]-J[45]-J[46]-J[47]-J[48]+
    J[49]-J[50]+J[51]+J[52]+J[53]-J[54]+J[55]+J[56]+J[57]-J[58]+J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +
    H[0]-H[1]-H[2]+H[3]-H[4]-H[5]+H[6]+H[7]+H[8]+H[9]-H[10]-H[11]-J[0]-J[1]+J[2]-J[3]-J[4]+J[5]+J[6]+J[7]+
    J[8]-J[9]-J[10]+J[11]-J[12]+J[13]+J[14]-J[15]-J[16]-J[17]-J[18]+J[19]+J[20]-J[21]+J[22]+J[23]-J[24]-J[25]-J[26]-J[27]+
    J[28]+J[29]-J[30]-J[31]+J[32]+J[33]+J[34]+J[35]-J[36]-J[37]+J[38]-J[39]-J[40]-J[41]-J[42]+J[43]+J[44]-J[45]-J[46]-J[47]-J[48]+
    J[49]+J[50]+J[51]+J[52]+J[53]-J[54]-J[55]+J[56]+J[57]-J[58]-J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +
    H[0]-H[1]-H[2]+H[3]-H[4]-H[5]+H[6]+H[7]+H[8]-H[9]+H[10]+H[11]-J[0]-J[1]+J[2]-J[3]-J[4]+J[5]+J[6]+J[7]-J[8]+
    J[9]+J[10]+J[11]-J[12]+J[13]+J[14]-J[15]-J[16]-J[17]+J[18]-J[19]-J[20]-J[21]+J[22]+J[23]-J[24]-J[25]-J[26]+
    J[27]-J[28]-J[29]-J[30]-J[31]+J[32]+J[33]+J[34]-J[35]+J[36]+J[37]+J[38]-J[39]-J[40]-J[41]+J[42]-J[43]-J[44]-J[45]-J[46]-J[47]+
    J[48]-J[49]-J[50]+J[51]+J[52]-J[53]+J[54]+J[55]+J[56]-J[57]+J[58]+J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+
    J[65], +H[0]-H[1]-H[2]+H[3]-H[4]-H[5]+H[6]+H[7]+H[8]-H[9]+H[10]-H[11]-J[0]-J[1]+J[2]-J[3]-J[4]+J[5]+
    J[6]+J[7]-J[8]+J[9]-J[10]+J[11]-J[12]+J[13]+J[14]-J[15]-J[16]-J[17]+J[18]-J[19]+J[20]-J[21]+J[22]+J[23]-J[24]-J[25]-J[26]+
    J[27]-J[28]+J[29]-J[30]-J[31]+J[32]+J[33]+J[34]-J[35]+J[36]-J[37]+J[38]-J[39]-J[40]-J[41]+J[42]-J[43]+
    J[44]-J[45]-J[46]-J[47]+J[48]-J[49]+J[50]+J[51]+J[52]-J[53]+J[54]-J[55]+J[56]-J[57]+J[58]-J[59]-J[60]+
    J[61]-J[62]-J[63]+J[64]-J[65], +H[0]-H[1]-H[2]+H[3]-H[4]-H[5]+H[6]+H[7]+H[8]-H[9]-H[10]+H[11]-J[0]-J[1]+
    J[2]-J[3]-J[4]+J[5]+J[6]+J[7]-J[8]-J[9]+J[10]+J[11]-J[12]+J[13]+J[14]-J[15]-J[16]-J[17]+J[18]+J[19]-J[20]-J[21]+
    J[22]+J[23]-J[24]-J[25]-J[26]+J[27]+J[28]-J[29]-J[30]-J[31]+J[32]+J[33]+J[34]-J[35]-J[36]+J[37]+J[38]-J[39]-J[40]-J[41]+
    J[42]+J[43]-J[44]-J[45]-J[46]-J[47]+J[48]+J[49]-J[50]+J[51]+J[52]-J[53]-J[54]+J[55]+J[56]-J[57]-J[58]+
    J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]-H[1]-H[2]+H[3]-H[4]-H[5]+H[6]+H[7]+H[8]-H[9]-H[10]-H[11]-J[0]-J[1]+
    J[2]-J[3]-J[4]+J[5]+J[6]+J[7]-J[8]-J[9]-J[10]+J[11]-J[12]+J[13]+J[14]-J[15]-J[16]-J[17]+J[18]+J[19]+
    J[20]-J[21]+J[22]+J[23]-J[24]-J[25]-J[26]+J[27]+J[28]+J[29]-J[30]-J[31]+J[32]+J[33]+J[34]-J[35]-J[36]-J[37]+
    J[38]-J[39]-J[40]-J[41]+J[42]+J[43]+J[44]-J[45]-J[46]-J[47]+J[48]+J[49]+J[50]+J[51]+J[52]-J[53]-J[54]-J[55]+
    J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]-H[1]-H[2]+H[3]-H[4]-H[5]+H[6]+H[7]-H[8]+
    H[9]+H[10]+H[11]-J[0]-J[1]+J[2]-J[3]-J[4]+J[5]+J[6]-J[7]+J[8]+J[9]+J[10]+J[11]-J[12]+J[13]+J[14]-J[15]-J[16]+
    J[17]-J[18]-J[19]-J[20]-J[21]+J[22]+J[23]-J[24]-J[25]+J[26]-J[27]-J[28]-J[29]-J[30]-J[31]+J[32]+J[33]-J[34]+
    J[35]+J[36]+J[37]+J[38]-J[39]-J[40]+J[41]-J[42]-J[43]-J[44]-J[45]-J[46]+J[47]-J[48]-J[49]-J[50]+J[51]-J[52]+
    J[53]+J[54]+J[55]-J[56]+J[57]+J[58]+J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]-H[1]-H[2]+H[3]-H[4]-H[5]+
    H[6]+H[7]-H[8]+H[9]+H[10]-H[11]-J[0]-J[1]+J[2]-J[3]-J[4]+J[5]+J[6]-J[7]+J[8]+J[9]-J[10]+J[11]-J[12]+
    J[13]+J[14]-J[15]-J[16]+J[17]-J[18]-J[19]+J[20]-J[21]+J[22]+J[23]-J[24]-J[25]+J[26]-J[27]-J[28]+J[29]-J[30]-J[31]+
    J[32]+J[33]-J[34]+J[35]+J[36]-J[37]+J[38]-J[39]-J[40]+J[41]-J[42]-J[43]+J[44]-J[45]-J[46]+J[47]-J[48]-J[49]+
    J[50]+J[51]-J[52]+J[53]+J[54]-J[55]-J[56]+J[57]+J[58]-J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]-H[1]-H[2]+
    H[3]-H[4]-H[5]+H[6]+H[7]-H[8]+H[9]-H[10]+H[11]-J[0]-J[1]+J[2]-J[3]-J[4]+J[5]+J[6]-J[7]+J[8]-J[9]+J[10]+
    J[11]-J[12]+J[13]+J[14]-J[15]-J[16]+J[17]-J[18]+J[19]-J[20]-J[21]+J[22]+J[23]-J[24]-J[25]+J[26]-J[27]+
    J[28]-J[29]-J[30]-J[31]+J[32]+J[33]-J[34]+J[35]-J[36]+J[37]+J[38]-J[39]-J[40]+J[41]-J[42]+J[43]-J[44]-J[45]-J[46]+
    J[47]-J[48]+J[49]-J[50]+J[51]-J[52]+J[53]-J[54]+J[55]-J[56]+J[57]-J[58]+J[59]-J[60]+J[61]-J[62]-J[63]+
    J[64]-J[65], +H[0]-H[1]-H[2]+H[3]-H[4]-H[5]+H[6]+H[7]-H[8]+H[9]-H[10]-H[11]-J[0]-J[1]+J[2]-J[3]-J[4]+
    J[5]+J[6]-J[7]+J[8]-J[9]-J[10]+J[11]-J[12]+J[13]+J[14]-J[15]-J[16]+J[17]-J[18]+J[19]+J[20]-J[21]+J[22]+
    J[23]-J[24]-J[25]+J[26]-J[27]+J[28]+J[29]-J[30]-J[31]+J[32]+J[33]-J[34]+J[35]-J[36]-J[37]+J[38]-J[39]-J[40]+
    J[41]-J[42]+J[43]+J[44]-J[45]-J[46]+J[47]-J[48]+J[49]+J[50]+J[51]-J[52]+J[53]-J[54]-J[55]-J[56]+J[57]-J[58]-J[59]-J[60]+
    J[61]+J[62]-J[63]-J[64]+J[65], +H[0]-H[1]-H[2]+H[3]-H[4]-H[5]+H[6]+H[7]-H[8]-H[9]+H[10]+H[11]-J[0]-J[1]+
    J[2]-J[3]-J[4]+J[5]+J[6]-J[7]-J[8]+J[9]+J[10]+J[11]-J[12]+J[13]+J[14]-J[15]-J[16]+J[17]+J[18]-J[19]-J[20]-J[21]+
    J[22]+J[23]-J[24]-J[25]+J[26]+J[27]-J[28]-J[29]-J[30]-J[31]+J[32]+J[33]-J[34]-J[35]+J[36]+J[37]+J[38]-J[39]-J[40]+
    J[41]+J[42]-J[43]-J[44]-J[45]-J[46]+J[47]+J[48]-J[49]-J[50]+J[51]-J[52]-J[53]+J[54]+J[55]-J[56]-J[57]+
    J[58]+J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]-H[1]-H[2]+H[3]-H[4]-H[5]+H[6]+H[7]-H[8]-H[9]+
    H[10]-H[11]-J[0]-J[1]+J[2]-J[3]-J[4]+J[5]+J[6]-J[7]-J[8]+J[9]-J[10]+J[11]-J[12]+J[13]+J[14]-J[15]-J[16]+
    J[17]+J[18]-J[19]+J[20]-J[21]+J[22]+J[23]-J[24]-J[25]+J[26]+J[27]-J[28]+J[29]-J[30]-J[31]+J[32]+J[33]-J[34]-J[35]+
    J[36]-J[37]+J[38]-J[39]-J[40]+J[41]+J[42]-J[43]+J[44]-J[45]-J[46]+J[47]+J[48]-J[49]+J[50]+J[51]-J[52]-J[53]+
    J[54]-J[55]-J[56]-J[57]+J[58]-J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]-H[1]-H[2]+H[3]-H[4]-H[5]+
    H[6]+H[7]-H[8]-H[9]-H[10]+H[11]-J[0]-J[1]+J[2]-J[3]-J[4]+J[5]+J[6]-J[7]-J[8]-J[9]+J[10]+J[11]-J[12]+
    J[13]+J[14]-J[15]-J[16]+J[17]+J[18]+J[19]-J[20]-J[21]+J[22]+J[23]-J[24]-J[25]+J[26]+J[27]+J[28]-J[29]-J[30]-J[31]+
    J[32]+J[33]-J[34]-J[35]-J[36]+J[37]+J[38]-J[39]-J[40]+J[41]+J[42]+J[43]-J[44]-J[45]-J[46]+J[47]+J[48]+
    J[49]-J[50]+J[51]-J[52]-J[53]-J[54]+J[55]-J[56]-J[57]-J[58]+J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +
    H[0]-H[1]-H[2]+H[3]-H[4]-H[5]+H[6]+H[7]-H[8]-H[9]-H[10]-H[11]-J[0]-J[1]+J[2]-J[3]-J[4]+J[5]+J[6]-J[7]-J[8]-J[9]-J[10]+
    J[11]-J[12]+J[13]+J[14]-J[15]-J[16]+J[17]+J[18]+J[19]+J[20]-J[21]+J[22]+J[23]-J[24]-J[25]+J[26]+J[27]+
    J[28]+J[29]-J[30]-J[31]+J[32]+J[33]-J[34]-J[35]-J[36]-J[37]+J[38]-J[39]-J[40]+J[41]+J[42]+J[43]+J[44]-J[45]-J[46]+
    J[47]+J[48]+J[49]+J[50]+J[51]-J[52]-J[53]-J[54]-J[55]-J[56]-J[57]-J[58]-J[59]+J[60]+J[61]+J[62]+J[63]+
    J[64]+J[65], +H[0]-H[1]-H[2]+H[3]-H[4]-H[5]+H[6]-H[7]+H[8]+H[9]+H[10]+H[11]-J[0]-J[1]+J[2]-J[3]-J[4]+
    J[5]-J[6]+J[7]+J[8]+J[9]+J[10]+J[11]-J[12]+J[13]+J[14]-J[15]+J[16]-J[17]-J[18]-J[19]-J[20]-J[21]+J[22]+
    J[23]-J[24]+J[25]-J[26]-J[27]-J[28]-J[29]-J[30]-J[31]+J[32]-J[33]+J[34]+J[35]+J[36]+J[37]+J[38]-J[39]+
    J[40]-J[41]-J[42]-J[43]-J[44]-J[45]+J[46]-J[47]-J[48]-J[49]-J[50]-J[51]+J[52]+J[53]+J[54]+J[55]-J[56]-J[57]-J[58]-J[59]+
    J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]-H[1]-H[2]+H[3]-H[4]-H[5]+H[6]-H[7]+H[8]+H[9]+H[10]-H[11]-J[0]-J[1]+
    J[2]-J[3]-J[4]+J[5]-J[6]+J[7]+J[8]+J[9]-J[10]+J[11]-J[12]+J[13]+J[14]-J[15]+J[16]-J[17]-J[18]-J[19]+
    J[20]-J[21]+J[22]+J[23]-J[24]+J[25]-J[26]-J[27]-J[28]+J[29]-J[30]-J[31]+J[32]-J[33]+J[34]+J[35]+J[36]-J[37]+
    J[38]-J[39]+J[40]-J[41]-J[42]-J[43]+J[44]-J[45]+J[46]-J[47]-J[48]-J[49]+J[50]-J[51]+J[52]+J[53]+J[54]-J[55]-J[56]-J[57]-J[58]+
    J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]-H[1]-H[2]+H[3]-H[4]-H[5]+H[6]-H[7]+H[8]+H[9]-H[10]+
    H[11]-J[0]-J[1]+J[2]-J[3]-J[4]+J[5]-J[6]+J[7]+J[8]-J[9]+J[10]+J[11]-J[12]+J[13]+J[14]-J[15]+J[16]-J[17]-J[18]+
    J[19]-J[20]-J[21]+J[22]+J[23]-J[24]+J[25]-J[26]-J[27]+J[28]-J[29]-J[30]-J[31]+J[32]-J[33]+J[34]+J[35]-J[36]+
    J[37]+J[38]-J[39]+J[40]-J[41]-J[42]+J[43]-J[44]-J[45]+J[46]-J[47]-J[48]+J[49]-J[50]-J[51]+J[52]+J[53]-J[54]+
    J[55]-J[56]-J[57]+J[58]-J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]-H[1]-H[2]+H[3]-H[4]-H[5]+H[6]-H[7]+
    H[8]+H[9]-H[10]-H[11]-J[0]-J[1]+J[2]-J[3]-J[4]+J[5]-J[6]+J[7]+J[8]-J[9]-J[10]+J[11]-J[12]+J[13]+J[14]-J[15]+
    J[16]-J[17]-J[18]+J[19]+J[20]-J[21]+J[22]+J[23]-J[24]+J[25]-J[26]-J[27]+J[28]+J[29]-J[30]-J[31]+J[32]-J[33]+
    J[34]+J[35]-J[36]-J[37]+J[38]-J[39]+J[40]-J[41]-J[42]+J[43]+J[44]-J[45]+J[46]-J[47]-J[48]+J[49]+J[50]-J[51]+
    J[52]+J[53]-J[54]-J[55]-J[56]-J[57]+J[58]+J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]-H[1]-H[2]+
    H[3]-H[4]-H[5]+H[6]-H[7]+H[8]-H[9]+H[10]+H[11]-J[0]-J[1]+J[2]-J[3]-J[4]+J[5]-J[6]+J[7]-J[8]+J[9]+J[10]+
    J[11]-J[12]+J[13]+J[14]-J[15]+J[16]-J[17]+J[18]-J[19]-J[20]-J[21]+J[22]+J[23]-J[24]+J[25]-J[26]+J[27]-J[28]-J[29]-J[30]-J[31]+
    J[32]-J[33]+J[34]-J[35]+J[36]+J[37]+J[38]-J[39]+J[40]-J[41]+J[42]-J[43]-J[44]-J[45]+J[46]-J[47]+J[48]-J[49]-J[50]-J[51]+
    J[52]-J[53]+J[54]+J[55]-J[56]+J[57]-J[58]-J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]-H[1]-H[2]+
    H[3]-H[4]-H[5]+H[6]-H[7]+H[8]-H[9]+H[10]-H[11]-J[0]-J[1]+J[2]-J[3]-J[4]+J[5]-J[6]+J[7]-J[8]+J[9]-J[10]+
    J[11]-J[12]+J[13]+J[14]-J[15]+J[16]-J[17]+J[18]-J[19]+J[20]-J[21]+J[22]+J[23]-J[24]+J[25]-J[26]+J[27]-J[28]+
    J[29]-J[30]-J[31]+J[32]-J[33]+J[34]-J[35]+J[36]-J[37]+J[38]-J[39]+J[40]-J[41]+J[42]-J[43]+J[44]-J[45]+
    J[46]-J[47]+J[48]-J[49]+J[50]-J[51]+J[52]-J[53]+J[54]-J[55]-J[56]+J[57]-J[58]+J[59]-J[60]+J[61]-J[62]-J[63]+
    J[64]-J[65], +H[0]-H[1]-H[2]+H[3]-H[4]-H[5]+H[6]-H[7]+H[8]-H[9]-H[10]+H[11]-J[0]-J[1]+J[2]-J[3]-J[4]+
    J[5]-J[6]+J[7]-J[8]-J[9]+J[10]+J[11]-J[12]+J[13]+J[14]-J[15]+J[16]-J[17]+J[18]+J[19]-J[20]-J[21]+J[22]+
    J[23]-J[24]+J[25]-J[26]+J[27]+J[28]-J[29]-J[30]-J[31]+J[32]-J[33]+J[34]-J[35]-J[36]+J[37]+J[38]-J[39]+
    J[40]-J[41]+J[42]+J[43]-J[44]-J[45]+J[46]-J[47]+J[48]+J[49]-J[50]-J[51]+J[52]-J[53]-J[54]+J[55]-J[56]+
    J[57]+J[58]-J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]-H[1]-H[2]+H[3]-H[4]-H[5]+H[6]-H[7]+H[8]-H[9]-H[10]-H[11]-J[0]-J[1]+
    J[2]-J[3]-J[4]+J[5]-J[6]+J[7]-J[8]-J[9]-J[10]+J[11]-J[12]+J[13]+J[14]-J[15]+J[16]-J[17]+J[18]+J[19]+
    J[20]-J[21]+J[22]+J[23]-J[24]+J[25]-J[26]+J[27]+J[28]+J[29]-J[30]-J[31]+J[32]-J[33]+J[34]-J[35]-J[36]-J[37]+
    J[38]-J[39]+J[40]-J[41]+J[42]+J[43]+J[44]-J[45]+J[46]-J[47]+J[48]+J[49]+J[50]-J[51]+J[52]-J[53]-J[54]-J[55]-J[56]+
    J[57]+J[58]+J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]-H[1]-H[2]+H[3]-H[4]-H[5]+H[6]-H[7]-H[8]+
    H[9]+H[10]+H[11]-J[0]-J[1]+J[2]-J[3]-J[4]+J[5]-J[6]-J[7]+J[8]+J[9]+J[10]+J[11]-J[12]+J[13]+J[14]-J[15]+
    J[16]+J[17]-J[18]-J[19]-J[20]-J[21]+J[22]+J[23]-J[24]+J[25]+J[26]-J[27]-J[28]-J[29]-J[30]-J[31]+J[32]-J[33]-J[34]+
    J[35]+J[36]+J[37]+J[38]-J[39]+J[40]+J[41]-J[42]-J[43]-J[44]-J[45]+J[46]+J[47]-J[48]-J[49]-J[50]-J[51]-J[52]+
    J[53]+J[54]+J[55]+J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]-H[1]-H[2]+H[3]-H[4]-H[5]+
    H[6]-H[7]-H[8]+H[9]+H[10]-H[11]-J[0]-J[1]+J[2]-J[3]-J[4]+J[5]-J[6]-J[7]+J[8]+J[9]-J[10]+J[11]-J[12]+
    J[13]+J[14]-J[15]+J[16]+J[17]-J[18]-J[19]+J[20]-J[21]+J[22]+J[23]-J[24]+J[25]+J[26]-J[27]-J[28]+J[29]-J[30]-J[31]+
    J[32]-J[33]-J[34]+J[35]+J[36]-J[37]+J[38]-J[39]+J[40]+J[41]-J[42]-J[43]+J[44]-J[45]+J[46]+J[47]-J[48]-J[49]+
    J[50]-J[51]-J[52]+J[53]+J[54]-J[55]+J[56]-J[57]-J[58]+J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]-H[1]-H[2]+
    H[3]-H[4]-H[5]+H[6]-H[7]-H[8]+H[9]-H[10]+H[11]-J[0]-J[1]+J[2]-J[3]-J[4]+J[5]-J[6]-J[7]+J[8]-J[9]+J[10]+
    J[11]-J[12]+J[13]+J[14]-J[15]+J[16]+J[17]-J[18]+J[19]-J[20]-J[21]+J[22]+J[23]-J[24]+J[25]+J[26]-J[27]+
    J[28]-J[29]-J[30]-J[31]+J[32]-J[33]-J[34]+J[35]-J[36]+J[37]+J[38]-J[39]+J[40]+J[41]-J[42]+J[43]-J[44]-J[45]+
    J[46]+J[47]-J[48]+J[49]-J[50]-J[51]-J[52]+J[53]-J[54]+J[55]+J[56]-J[57]+J[58]-J[59]-J[60]+J[61]-J[62]-J[63]+
    J[64]-J[65], +H[0]-H[1]-H[2]+H[3]-H[4]-H[5]+H[6]-H[7]-H[8]+H[9]-H[10]-H[11]-J[0]-J[1]+J[2]-J[3]-J[4]+
    J[5]-J[6]-J[7]+J[8]-J[9]-J[10]+J[11]-J[12]+J[13]+J[14]-J[15]+J[16]+J[17]-J[18]+J[19]+J[20]-J[21]+J[22]+
    J[23]-J[24]+J[25]+J[26]-J[27]+J[28]+J[29]-J[30]-J[31]+J[32]-J[33]-J[34]+J[35]-J[36]-J[37]+J[38]-J[39]+
    J[40]+J[41]-J[42]+J[43]+J[44]-J[45]+J[46]+J[47]-J[48]+J[49]+J[50]-J[51]-J[52]+J[53]-J[54]-J[55]+J[56]-J[57]+
    J[58]+J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]-H[1]-H[2]+H[3]-H[4]-H[5]+H[6]-H[7]-H[8]-H[9]+
    H[10]+H[11]-J[0]-J[1]+J[2]-J[3]-J[4]+J[5]-J[6]-J[7]-J[8]+J[9]+J[10]+J[11]-J[12]+J[13]+J[14]-J[15]+J[16]+
    J[17]+J[18]-J[19]-J[20]-J[21]+J[22]+J[23]-J[24]+J[25]+J[26]+J[27]-J[28]-J[29]-J[30]-J[31]+J[32]-J[33]-J[34]-J[35]+
    J[36]+J[37]+J[38]-J[39]+J[40]+J[41]+J[42]-J[43]-J[44]-J[45]+J[46]+J[47]+J[48]-J[49]-J[50]-J[51]-J[52]-J[53]+
    J[54]+J[55]+J[56]+J[57]-J[58]-J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]-H[1]-H[2]+H[3]-H[4]-H[5]+
    H[6]-H[7]-H[8]-H[9]+H[10]-H[11]-J[0]-J[1]+J[2]-J[3]-J[4]+J[5]-J[6]-J[7]-J[8]+J[9]-J[10]+J[11]-J[12]+
    J[13]+J[14]-J[15]+J[16]+J[17]+J[18]-J[19]+J[20]-J[21]+J[22]+J[23]-J[24]+J[25]+J[26]+J[27]-J[28]+J[29]-J[30]-J[31]+
    J[32]-J[33]-J[34]-J[35]+J[36]-J[37]+J[38]-J[39]+J[40]+J[41]+J[42]-J[43]+J[44]-J[45]+J[46]+J[47]+J[48]-J[49]+
    J[50]-J[51]-J[52]-J[53]+J[54]-J[55]+J[56]+J[57]-J[58]+J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]-H[1]-H[2]+
    H[3]-H[4]-H[5]+H[6]-H[7]-H[8]-H[9]-H[10]+H[11]-J[0]-J[1]+J[2]-J[3]-J[4]+J[5]-J[6]-J[7]-J[8]-J[9]+J[10]+
    J[11]-J[12]+J[13]+J[14]-J[15]+J[16]+J[17]+J[18]+J[19]-J[20]-J[21]+J[22]+J[23]-J[24]+J[25]+J[26]+J[27]+
    J[28]-J[29]-J[30]-J[31]+J[32]-J[33]-J[34]-J[35]-J[36]+J[37]+J[38]-J[39]+J[40]+J[41]+J[42]+J[43]-J[44]-J[45]+
    J[46]+J[47]+J[48]+J[49]-J[50]-J[51]-J[52]-J[53]-J[54]+J[55]+J[56]+J[57]+J[58]-J[59]+J[60]+J[61]-J[62]+
    J[63]-J[64]-J[65], +H[0]-H[1]-H[2]+H[3]-H[4]-H[5]+H[6]-H[7]-H[8]-H[9]-H[10]-H[11]-J[0]-J[1]+J[2]-J[3]-J[4]+
    J[5]-J[6]-J[7]-J[8]-J[9]-J[10]+J[11]-J[12]+J[13]+J[14]-J[15]+J[16]+J[17]+J[18]+J[19]+J[20]-J[21]+J[22]+
    J[23]-J[24]+J[25]+J[26]+J[27]+J[28]+J[29]-J[30]-J[31]+J[32]-J[33]-J[34]-J[35]-J[36]-J[37]+J[38]-J[39]+
    J[40]+J[41]+J[42]+J[43]+J[44]-J[45]+J[46]+J[47]+J[48]+J[49]+J[50]-J[51]-J[52]-J[53]-J[54]-J[55]+J[56]+
    J[57]+J[58]+J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]-H[1]-H[2]+H[3]-H[4]-H[5]-H[6]+H[7]+H[8]+
    H[9]+H[10]+H[11]-J[0]-J[1]+J[2]-J[3]-J[4]-J[5]+J[6]+J[7]+J[8]+J[9]+J[10]+J[11]-J[12]+J[13]+J[14]+J[15]-J[16]-J[17]-J[18]-J[19]-J[20]-J[21]+
    J[22]+J[23]+J[24]-J[25]-J[26]-J[27]-J[28]-J[29]-J[30]-J[31]-J[32]+J[33]+J[34]+J[35]+J[36]+J[37]+J[38]+
    J[39]-J[40]-J[41]-J[42]-J[43]-J[44]+J[45]-J[46]-J[47]-J[48]-J[49]-J[50]-J[51]-J[52]-J[53]-J[54]-J[55]+
    J[56]+J[57]+J[58]+J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]-H[1]-H[2]+H[3]-H[4]-H[5]-H[6]+H[7]+
    H[8]+H[9]+H[10]-H[11]-J[0]-J[1]+J[2]-J[3]-J[4]-J[5]+J[6]+J[7]+J[8]+J[9]-J[10]+J[11]-J[12]+J[13]+J[14]+
    J[15]-J[16]-J[17]-J[18]-J[19]+J[20]-J[21]+J[22]+J[23]+J[24]-J[25]-J[26]-J[27]-J[28]+J[29]-J[30]-J[31]-J[32]+
    J[33]+J[34]+J[35]+J[36]-J[37]+J[38]+J[39]-J[40]-J[41]-J[42]-J[43]+J[44]+J[45]-J[46]-J[47]-J[48]-J[49]+
    J[50]-J[51]-J[52]-J[53]-J[54]+J[55]+J[56]+J[57]+J[58]-J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]-H[1]-H[2]+
    H[3]-H[4]-H[5]-H[6]+H[7]+H[8]+H[9]-H[10]+H[11]-J[0]-J[1]+J[2]-J[3]-J[4]-J[5]+J[6]+J[7]+J[8]-J[9]+J[10]+
    J[11]-J[12]+J[13]+J[14]+J[15]-J[16]-J[17]-J[18]+J[19]-J[20]-J[21]+J[22]+J[23]+J[24]-J[25]-J[26]-J[27]+
    J[28]-J[29]-J[30]-J[31]-J[32]+J[33]+J[34]+J[35]-J[36]+J[37]+J[38]+J[39]-J[40]-J[41]-J[42]+J[43]-J[44]+
    J[45]-J[46]-J[47]-J[48]+J[49]-J[50]-J[51]-J[52]-J[53]+J[54]-J[55]+J[56]+J[57]-J[58]+J[59]+J[60]-J[61]+
    J[62]-J[63]+J[64]-J[65], +H[0]-H[1]-H[2]+H[3]-H[4]-H[5]-H[6]+H[7]+H[8]+H[9]-H[10]-H[11]-J[0]-J[1]+J[2]-J[3]-J[4]-J[5]+
    J[6]+J[7]+J[8]-J[9]-J[10]+J[11]-J[12]+J[13]+J[14]+J[15]-J[16]-J[17]-J[18]+J[19]+J[20]-J[21]+J[22]+J[23]+
    J[24]-J[25]-J[26]-J[27]+J[28]+J[29]-J[30]-J[31]-J[32]+J[33]+J[34]+J[35]-J[36]-J[37]+J[38]+J[39]-J[40]-J[41]-J[42]+
    J[43]+J[44]+J[45]-J[46]-J[47]-J[48]+J[49]+J[50]-J[51]-J[52]-J[53]+J[54]+J[55]+J[56]+J[57]-J[58]-J[59]+
    J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]-H[1]-H[2]+H[3]-H[4]-H[5]-H[6]+H[7]+H[8]-H[9]+H[10]+H[11]-J[0]-J[1]+
    J[2]-J[3]-J[4]-J[5]+J[6]+J[7]-J[8]+J[9]+J[10]+J[11]-J[12]+J[13]+J[14]+J[15]-J[16]-J[17]+J[18]-J[19]-J[20]-J[21]+
    J[22]+J[23]+J[24]-J[25]-J[26]+J[27]-J[28]-J[29]-J[30]-J[31]-J[32]+J[33]+J[34]-J[35]+J[36]+J[37]+J[38]+
    J[39]-J[40]-J[41]+J[42]-J[43]-J[44]+J[45]-J[46]-J[47]+J[48]-J[49]-J[50]-J[51]-J[52]+J[53]-J[54]-J[55]+
    J[56]-J[57]+J[58]+J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]-H[1]-H[2]+H[3]-H[4]-H[5]-H[6]+H[7]+
    H[8]-H[9]+H[10]-H[11]-J[0]-J[1]+J[2]-J[3]-J[4]-J[5]+J[6]+J[7]-J[8]+J[9]-J[10]+J[11]-J[12]+J[13]+J[14]+
    J[15]-J[16]-J[17]+J[18]-J[19]+J[20]-J[21]+J[22]+J[23]+J[24]-J[25]-J[26]+J[27]-J[28]+J[29]-J[30]-J[31]-J[32]+
    J[33]+J[34]-J[35]+J[36]-J[37]+J[38]+J[39]-J[40]-J[41]+J[42]-J[43]+J[44]+J[45]-J[46]-J[47]+J[48]-J[49]+
    J[50]-J[51]-J[52]+J[53]-J[54]+J[55]+J[56]-J[57]+J[58]-J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]-H[1]-H[2]+
    H[3]-H[4]-H[5]-H[6]+H[7]+H[8]-H[9]-H[10]+H[11]-J[0]-J[1]+J[2]-J[3]-J[4]-J[5]+J[6]+J[7]-J[8]-J[9]+J[10]+
    J[11]-J[12]+J[13]+J[14]+J[15]-J[16]-J[17]+J[18]+J[19]-J[20]-J[21]+J[22]+J[23]+J[24]-J[25]-J[26]+J[27]+
    J[28]-J[29]-J[30]-J[31]-J[32]+J[33]+J[34]-J[35]-J[36]+J[37]+J[38]+J[39]-J[40]-J[41]+J[42]+J[43]-J[44]+
    J[45]-J[46]-J[47]+J[48]+J[49]-J[50]-J[51]-J[52]+J[53]+J[54]-J[55]+J[56]-J[57]-J[58]+J[59]-J[60]-J[61]+
    J[62]+J[63]-J[64]-J[65], +H[0]-H[1]-H[2]+H[3]-H[4]-H[5]-H[6]+H[7]+H[8]-H[9]-H[10]-H[11]-J[0]-J[1]+J[2]-J[3]-J[4]-J[5]+
    J[6]+J[7]-J[8]-J[9]-J[10]+J[11]-J[12]+J[13]+J[14]+J[15]-J[16]-J[17]+J[18]+J[19]+J[20]-J[21]+J[22]+J[23]+
    J[24]-J[25]-J[26]+J[27]+J[28]+J[29]-J[30]-J[31]-J[32]+J[33]+J[34]-J[35]-J[36]-J[37]+J[38]+J[39]-J[40]-J[41]+
    J[42]+J[43]+J[44]+J[45]-J[46]-J[47]+J[48]+J[49]+J[50]-J[51]-J[52]+J[53]+J[54]+J[55]+J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+
    J[63]+J[64]+J[65], +H[0]-H[1]-H[2]+H[3]-H[4]-H[5]-H[6]+H[7]-H[8]+H[9]+H[10]+H[11]-J[0]-J[1]+J[2]-J[3]-J[4]-J[5]+
    J[6]-J[7]+J[8]+J[9]+J[10]+J[11]-J[12]+J[13]+J[14]+J[15]-J[16]+J[17]-J[18]-J[19]-J[20]-J[21]+J[22]+J[23]+
    J[24]-J[25]+J[26]-J[27]-J[28]-J[29]-J[30]-J[31]-J[32]+J[33]-J[34]+J[35]+J[36]+J[37]+J[38]+J[39]-J[40]+
    J[41]-J[42]-J[43]-J[44]+J[45]-J[46]+J[47]-J[48]-J[49]-J[50]-J[51]+J[52]-J[53]-J[54]-J[55]-J[56]+J[57]+
    J[58]+J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]-H[1]-H[2]+H[3]-H[4]-H[5]-H[6]+H[7]-H[8]+H[9]+
    H[10]-H[11]-J[0]-J[1]+J[2]-J[3]-J[4]-J[5]+J[6]-J[7]+J[8]+J[9]-J[10]+J[11]-J[12]+J[13]+J[14]+J[15]-J[16]+
    J[17]-J[18]-J[19]+J[20]-J[21]+J[22]+J[23]+J[24]-J[25]+J[26]-J[27]-J[28]+J[29]-J[30]-J[31]-J[32]+J[33]-J[34]+
    J[35]+J[36]-J[37]+J[38]+J[39]-J[40]+J[41]-J[42]-J[43]+J[44]+J[45]-J[46]+J[47]-J[48]-J[49]+J[50]-J[51]+
    J[52]-J[53]-J[54]+J[55]-J[56]+J[57]+J[58]-J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]-H[1]-H[2]+
    H[3]-H[4]-H[5]-H[6]+H[7]-H[8]+H[9]-H[10]+H[11]-J[0]-J[1]+J[2]-J[3]-J[4]-J[5]+J[6]-J[7]+J[8]-J[9]+J[10]+
    J[11]-J[12]+J[13]+J[14]+J[15]-J[16]+J[17]-J[18]+J[19]-J[20]-J[21]+J[22]+J[23]+J[24]-J[25]+J[26]-J[27]+
    J[28]-J[29]-J[30]-J[31]-J[32]+J[33]-J[34]+J[35]-J[36]+J[37]+J[38]+J[39]-J[40]+J[41]-J[42]+J[43]-J[44]+
    J[45]-J[46]+J[47]-J[48]+J[49]-J[50]-J[51]+J[52]-J[53]+J[54]-J[55]-J[56]+J[57]-J[58]+J[59]-J[60]+J[61]-J[62]-J[63]+
    J[64]-J[65], +H[0]-H[1]-H[2]+H[3]-H[4]-H[5]-H[6]+H[7]-H[8]+H[9]-H[10]-H[11]-J[0]-J[1]+J[2]-J[3]-J[4]-J[5]+
    J[6]-J[7]+J[8]-J[9]-J[10]+J[11]-J[12]+J[13]+J[14]+J[15]-J[16]+J[17]-J[18]+J[19]+J[20]-J[21]+J[22]+J[23]+
    J[24]-J[25]+J[26]-J[27]+J[28]+J[29]-J[30]-J[31]-J[32]+J[33]-J[34]+J[35]-J[36]-J[37]+J[38]+J[39]-J[40]+
    J[41]-J[42]+J[43]+J[44]+J[45]-J[46]+J[47]-J[48]+J[49]+J[50]-J[51]+J[52]-J[53]+J[54]+J[55]-J[56]+J[57]-J[58]-J[59]-J[60]+
    J[61]+J[62]-J[63]-J[64]+J[65], +H[0]-H[1]-H[2]+H[3]-H[4]-H[5]-H[6]+H[7]-H[8]-H[9]+H[10]+H[11]-J[0]-J[1]+
    J[2]-J[3]-J[4]-J[5]+J[6]-J[7]-J[8]+J[9]+J[10]+J[11]-J[12]+J[13]+J[14]+J[15]-J[16]+J[17]+J[18]-J[19]-J[20]-J[21]+
    J[22]+J[23]+J[24]-J[25]+J[26]+J[27]-J[28]-J[29]-J[30]-J[31]-J[32]+J[33]-J[34]-J[35]+J[36]+J[37]+J[38]+
    J[39]-J[40]+J[41]+J[42]-J[43]-J[44]+J[45]-J[46]+J[47]+J[48]-J[49]-J[50]-J[51]+J[52]+J[53]-J[54]-J[55]-J[56]-J[57]+
    J[58]+J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]-H[1]-H[2]+H[3]-H[4]-H[5]-H[6]+H[7]-H[8]-H[9]+
    H[10]-H[11]-J[0]-J[1]+J[2]-J[3]-J[4]-J[5]+J[6]-J[7]-J[8]+J[9]-J[10]+J[11]-J[12]+J[13]+J[14]+J[15]-J[16]+
    J[17]+J[18]-J[19]+J[20]-J[21]+J[22]+J[23]+J[24]-J[25]+J[26]+J[27]-J[28]+J[29]-J[30]-J[31]-J[32]+J[33]-J[34]-J[35]+
    J[36]-J[37]+J[38]+J[39]-J[40]+J[41]+J[42]-J[43]+J[44]+J[45]-J[46]+J[47]+J[48]-J[49]+J[50]-J[51]+J[52]+
    J[53]-J[54]+J[55]-J[56]-J[57]+J[58]-J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]-H[1]-H[2]+H[3]-H[4]-H[5]-H[6]+
    H[7]-H[8]-H[9]-H[10]+H[11]-J[0]-J[1]+J[2]-J[3]-J[4]-J[5]+J[6]-J[7]-J[8]-J[9]+J[10]+J[11]-J[12]+J[13]+
    J[14]+J[15]-J[16]+J[17]+J[18]+J[19]-J[20]-J[21]+J[22]+J[23]+J[24]-J[25]+J[26]+J[27]+J[28]-J[29]-J[30]-J[31]-J[32]+
    J[33]-J[34]-J[35]-J[36]+J[37]+J[38]+J[39]-J[40]+J[41]+J[42]+J[43]-J[44]+J[45]-J[46]+J[47]+J[48]+J[49]-J[50]-J[51]+
    J[52]+J[53]+J[54]-J[55]-J[56]-J[57]-J[58]+J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]-H[1]-H[2]+
    H[3]-H[4]-H[5]-H[6]+H[7]-H[8]-H[9]-H[10]-H[11]-J[0]-J[1]+J[2]-J[3]-J[4]-J[5]+J[6]-J[7]-J[8]-J[9]-J[10]+
    J[11]-J[12]+J[13]+J[14]+J[15]-J[16]+J[17]+J[18]+J[19]+J[20]-J[21]+J[22]+J[23]+J[24]-J[25]+J[26]+J[27]+
    J[28]+J[29]-J[30]-J[31]-J[32]+J[33]-J[34]-J[35]-J[36]-J[37]+J[38]+J[39]-J[40]+J[41]+J[42]+J[43]+J[44]+
    J[45]-J[46]+J[47]+J[48]+J[49]+J[50]-J[51]+J[52]+J[53]+J[54]+J[55]-J[56]-J[57]-J[58]-J[59]+J[60]+J[61]+
    J[62]+J[63]+J[64]+J[65], +H[0]-H[1]-H[2]+H[3]-H[4]-H[5]-H[6]-H[7]+H[8]+H[9]+H[10]+H[11]-J[0]-J[1]+J[2]-J[3]-J[4]-J[5]-J[6]+
    J[7]+J[8]+J[9]+J[10]+J[11]-J[12]+J[13]+J[14]+J[15]+J[16]-J[17]-J[18]-J[19]-J[20]-J[21]+J[22]+J[23]+J[24]+
    J[25]-J[26]-J[27]-J[28]-J[29]-J[30]-J[31]-J[32]-J[33]+J[34]+J[35]+J[36]+J[37]+J[38]+J[39]+J[40]-J[41]-J[42]-J[43]-J[44]+
    J[45]+J[46]-J[47]-J[48]-J[49]-J[50]+J[51]-J[52]-J[53]-J[54]-J[55]-J[56]-J[57]-J[58]-J[59]+J[60]+J[61]+
    J[62]+J[63]+J[64]+J[65], +H[0]-H[1]-H[2]+H[3]-H[4]-H[5]-H[6]-H[7]+H[8]+H[9]+H[10]-H[11]-J[0]-J[1]+J[2]-J[3]-J[4]-J[5]-J[6]+
    J[7]+J[8]+J[9]-J[10]+J[11]-J[12]+J[13]+J[14]+J[15]+J[16]-J[17]-J[18]-J[19]+J[20]-J[21]+J[22]+J[23]+J[24]+
    J[25]-J[26]-J[27]-J[28]+J[29]-J[30]-J[31]-J[32]-J[33]+J[34]+J[35]+J[36]-J[37]+J[38]+J[39]+J[40]-J[41]-J[42]-J[43]+
    J[44]+J[45]+J[46]-J[47]-J[48]-J[49]+J[50]+J[51]-J[52]-J[53]-J[54]+J[55]-J[56]-J[57]-J[58]+J[59]+J[60]+
    J[61]-J[62]+J[63]-J[64]-J[65], +H[0]-H[1]-H[2]+H[3]-H[4]-H[5]-H[6]-H[7]+H[8]+H[9]-H[10]+H[11]-J[0]-J[1]+
    J[2]-J[3]-J[4]-J[5]-J[6]+J[7]+J[8]-J[9]+J[10]+J[11]-J[12]+J[13]+J[14]+J[15]+J[16]-J[17]-J[18]+J[19]-J[20]-J[21]+
    J[22]+J[23]+J[24]+J[25]-J[26]-J[27]+J[28]-J[29]-J[30]-J[31]-J[32]-J[33]+J[34]+J[35]-J[36]+J[37]+J[38]+
    J[39]+J[40]-J[41]-J[42]+J[43]-J[44]+J[45]+J[46]-J[47]-J[48]+J[49]-J[50]+J[51]-J[52]-J[53]+J[54]-J[55]-J[56]-J[57]+
    J[58]-J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]-H[1]-H[2]+H[3]-H[4]-H[5]-H[6]-H[7]+H[8]+H[9]-H[10]-H[11]-J[0]-J[1]+
    J[2]-J[3]-J[4]-J[5]-J[6]+J[7]+J[8]-J[9]-J[10]+J[11]-J[12]+J[13]+J[14]+J[15]+J[16]-J[17]-J[18]+J[19]+
    J[20]-J[21]+J[22]+J[23]+J[24]+J[25]-J[26]-J[27]+J[28]+J[29]-J[30]-J[31]-J[32]-J[33]+J[34]+J[35]-J[36]-J[37]+
    J[38]+J[39]+J[40]-J[41]-J[42]+J[43]+J[44]+J[45]+J[46]-J[47]-J[48]+J[49]+J[50]+J[51]-J[52]-J[53]+J[54]+
    J[55]-J[56]-J[57]+J[58]+J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]-H[1]-H[2]+H[3]-H[4]-H[5]-H[6]-H[7]+
    H[8]-H[9]+H[10]+H[11]-J[0]-J[1]+J[2]-J[3]-J[4]-J[5]-J[6]+J[7]-J[8]+J[9]+J[10]+J[11]-J[12]+J[13]+J[14]+
    J[15]+J[16]-J[17]+J[18]-J[19]-J[20]-J[21]+J[22]+J[23]+J[24]+J[25]-J[26]+J[27]-J[28]-J[29]-J[30]-J[31]-J[32]-J[33]+
    J[34]-J[35]+J[36]+J[37]+J[38]+J[39]+J[40]-J[41]+J[42]-J[43]-J[44]+J[45]+J[46]-J[47]+J[48]-J[49]-J[50]+
    J[51]-J[52]+J[53]-J[54]-J[55]-J[56]+J[57]-J[58]-J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]-H[1]-H[2]+
    H[3]-H[4]-H[5]-H[6]-H[7]+H[8]-H[9]+H[10]-H[11]-J[0]-J[1]+J[2]-J[3]-J[4]-J[5]-J[6]+J[7]-J[8]+J[9]-J[10]+
    J[11]-J[12]+J[13]+J[14]+J[15]+J[16]-J[17]+J[18]-J[19]+J[20]-J[21]+J[22]+J[23]+J[24]+J[25]-J[26]+J[27]-J[28]+
    J[29]-J[30]-J[31]-J[32]-J[33]+J[34]-J[35]+J[36]-J[37]+J[38]+J[39]+J[40]-J[41]+J[42]-J[43]+J[44]+J[45]+
    J[46]-J[47]+J[48]-J[49]+J[50]+J[51]-J[52]+J[53]-J[54]+J[55]-J[56]+J[57]-J[58]+J[59]-J[60]+J[61]-J[62]-J[63]+
    J[64]-J[65], +H[0]-H[1]-H[2]+H[3]-H[4]-H[5]-H[6]-H[7]+H[8]-H[9]-H[10]+H[11]-J[0]-J[1]+J[2]-J[3]-J[4]-J[5]-J[6]+
    J[7]-J[8]-J[9]+J[10]+J[11]-J[12]+J[13]+J[14]+J[15]+J[16]-J[17]+J[18]+J[19]-J[20]-J[21]+J[22]+J[23]+J[24]+
    J[25]-J[26]+J[27]+J[28]-J[29]-J[30]-J[31]-J[32]-J[33]+J[34]-J[35]-J[36]+J[37]+J[38]+J[39]+J[40]-J[41]+
    J[42]+J[43]-J[44]+J[45]+J[46]-J[47]+J[48]+J[49]-J[50]+J[51]-J[52]+J[53]+J[54]-J[55]-J[56]+J[57]+J[58]-J[59]-J[60]-J[61]+
    J[62]+J[63]-J[64]-J[65], +H[0]-H[1]-H[2]+H[3]-H[4]-H[5]-H[6]-H[7]+H[8]-H[9]-H[10]-H[11]-J[0]-J[1]+J[2]-J[3]-J[4]-J[5]-J[6]+
    J[7]-J[8]-J[9]-J[10]+J[11]-J[12]+J[13]+J[14]+J[15]+J[16]-J[17]+J[18]+J[19]+J[20]-J[21]+J[22]+J[23]+J[24]+
    J[25]-J[26]+J[27]+J[28]+J[29]-J[30]-J[31]-J[32]-J[33]+J[34]-J[35]-J[36]-J[37]+J[38]+J[39]+J[40]-J[41]+
    J[42]+J[43]+J[44]+J[45]+J[46]-J[47]+J[48]+J[49]+J[50]+J[51]-J[52]+J[53]+J[54]+J[55]-J[56]+J[57]+J[58]+
    J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]-H[1]-H[2]+H[3]-H[4]-H[5]-H[6]-H[7]-H[8]+H[9]+H[10]+
    H[11]-J[0]-J[1]+J[2]-J[3]-J[4]-J[5]-J[6]-J[7]+J[8]+J[9]+J[10]+J[11]-J[12]+J[13]+J[14]+J[15]+J[16]+J[17]-J[18]-J[19]-J[20]-J[21]+
    J[22]+J[23]+J[24]+J[25]+J[26]-J[27]-J[28]-J[29]-J[30]-J[31]-J[32]-J[33]-J[34]+J[35]+J[36]+J[37]+J[38]+
    J[39]+J[40]+J[41]-J[42]-J[43]-J[44]+J[45]+J[46]+J[47]-J[48]-J[49]-J[50]+J[51]+J[52]-J[53]-J[54]-J[55]+
    J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]-H[1]-H[2]+H[3]-H[4]-H[5]-H[6]-H[7]-H[8]+
    H[9]+H[10]-H[11]-J[0]-J[1]+J[2]-J[3]-J[4]-J[5]-J[6]-J[7]+J[8]+J[9]-J[10]+J[11]-J[12]+J[13]+J[14]+J[15]+
    J[16]+J[17]-J[18]-J[19]+J[20]-J[21]+J[22]+J[23]+J[24]+J[25]+J[26]-J[27]-J[28]+J[29]-J[30]-J[31]-J[32]-J[33]-J[34]+
    J[35]+J[36]-J[37]+J[38]+J[39]+J[40]+J[41]-J[42]-J[43]+J[44]+J[45]+J[46]+J[47]-J[48]-J[49]+J[50]+J[51]+
    J[52]-J[53]-J[54]+J[55]+J[56]-J[57]-J[58]+J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]-H[1]-H[2]+
    H[3]-H[4]-H[5]-H[6]-H[7]-H[8]+H[9]-H[10]+H[11]-J[0]-J[1]+J[2]-J[3]-J[4]-J[5]-J[6]-J[7]+J[8]-J[9]+J[10]+
    J[11]-J[12]+J[13]+J[14]+J[15]+J[16]+J[17]-J[18]+J[19]-J[20]-J[21]+J[22]+J[23]+J[24]+J[25]+J[26]-J[27]+
    J[28]-J[29]-J[30]-J[31]-J[32]-J[33]-J[34]+J[35]-J[36]+J[37]+J[38]+J[39]+J[40]+J[41]-J[42]+J[43]-J[44]+
    J[45]+J[46]+J[47]-J[48]+J[49]-J[50]+J[51]+J[52]-J[53]+J[54]-J[55]+J[56]-J[57]+J[58]-J[59]-J[60]+J[61]-J[62]-J[63]+
    J[64]-J[65], +H[0]-H[1]-H[2]+H[3]-H[4]-H[5]-H[6]-H[7]-H[8]+H[9]-H[10]-H[11]-J[0]-J[1]+J[2]-J[3]-J[4]-J[5]-J[6]-J[7]+
    J[8]-J[9]-J[10]+J[11]-J[12]+J[13]+J[14]+J[15]+J[16]+J[17]-J[18]+J[19]+J[20]-J[21]+J[22]+J[23]+J[24]+
    J[25]+J[26]-J[27]+J[28]+J[29]-J[30]-J[31]-J[32]-J[33]-J[34]+J[35]-J[36]-J[37]+J[38]+J[39]+J[40]+J[41]-J[42]+
    J[43]+J[44]+J[45]+J[46]+J[47]-J[48]+J[49]+J[50]+J[51]+J[52]-J[53]+J[54]+J[55]+J[56]-J[57]+J[58]+J[59]-J[60]+
    J[61]+J[62]-J[63]-J[64]+J[65], +H[0]-H[1]-H[2]+H[3]-H[4]-H[5]-H[6]-H[7]-H[8]-H[9]+H[10]+H[11]-J[0]-J[1]+
    J[2]-J[3]-J[4]-J[5]-J[6]-J[7]-J[8]+J[9]+J[10]+J[11]-J[12]+J[13]+J[14]+J[15]+J[16]+J[17]+J[18]-J[19]-J[20]-J[21]+
    J[22]+J[23]+J[24]+J[25]+J[26]+J[27]-J[28]-J[29]-J[30]-J[31]-J[32]-J[33]-J[34]-J[35]+J[36]+J[37]+J[38]+
    J[39]+J[40]+J[41]+J[42]-J[43]-J[44]+J[45]+J[46]+J[47]+J[48]-J[49]-J[50]+J[51]+J[52]+J[53]-J[54]-J[55]+
    J[56]+J[57]-J[58]-J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]-H[1]-H[2]+H[3]-H[4]-H[5]-H[6]-H[7]-H[8]-H[9]+
    H[10]-H[11]-J[0]-J[1]+J[2]-J[3]-J[4]-J[5]-J[6]-J[7]-J[8]+J[9]-J[10]+J[11]-J[12]+J[13]+J[14]+J[15]+J[16]+
    J[17]+J[18]-J[19]+J[20]-J[21]+J[22]+J[23]+J[24]+J[25]+J[26]+J[27]-J[28]+J[29]-J[30]-J[31]-J[32]-J[33]-J[34]-J[35]+
    J[36]-J[37]+J[38]+J[39]+J[40]+J[41]+J[42]-J[43]+J[44]+J[45]+J[46]+J[47]+J[48]-J[49]+J[50]+J[51]+J[52]+
    J[53]-J[54]+J[55]+J[56]+J[57]-J[58]+J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]-H[1]-H[2]+H[3]-H[4]-H[5]-H[6]-H[7]-H[8]-H[9]-H[10]+
    H[11]-J[0]-J[1]+J[2]-J[3]-J[4]-J[5]-J[6]-J[7]-J[8]-J[9]+J[10]+J[11]-J[12]+J[13]+J[14]+J[15]+J[16]+J[17]+
    J[18]+J[19]-J[20]-J[21]+J[22]+J[23]+J[24]+J[25]+J[26]+J[27]+J[28]-J[29]-J[30]-J[31]-J[32]-J[33]-J[34]-J[35]-J[36]+
    J[37]+J[38]+J[39]+J[40]+J[41]+J[42]+J[43]-J[44]+J[45]+J[46]+J[47]+J[48]+J[49]-J[50]+J[51]+J[52]+J[53]+
    J[54]-J[55]+J[56]+J[57]+J[58]-J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]-H[1]-H[2]+H[3]-H[4]-H[5]-H[6]-H[7]-H[8]-H[9]-H[10]-H[11]-J[0]-J[1]+
    J[2]-J[3]-J[4]-J[5]-J[6]-J[7]-J[8]-J[9]-J[10]+J[11]-J[12]+J[13]+J[14]+J[15]+J[16]+J[17]+J[18]+J[19]+
    J[20]-J[21]+J[22]+J[23]+J[24]+J[25]+J[26]+J[27]+J[28]+J[29]-J[30]-J[31]-J[32]-J[33]-J[34]-J[35]-J[36]-J[37]+
    J[38]+J[39]+J[40]+J[41]+J[42]+J[43]+J[44]+J[45]+J[46]+J[47]+J[48]+J[49]+J[50]+J[51]+J[52]+J[53]+J[54]+
    J[55]+J[56]+J[57]+J[58]+J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]-H[1]-H[2]-H[3]+H[4]+H[5]+H[6]+
    H[7]+H[8]+H[9]+H[10]+H[11]-J[0]-J[1]-J[2]+J[3]+J[4]+J[5]+J[6]+J[7]+J[8]+J[9]+J[10]+J[11]+J[12]-J[13]-J[14]-J[15]-J[16]-J[17]-J[18]-J[19]-J[20]+
    J[21]-J[22]-J[23]-J[24]-J[25]-J[26]-J[27]-J[28]-J[29]-J[30]-J[31]-J[32]-J[33]-J[34]-J[35]-J[36]-J[37]+
    J[38]+J[39]+J[40]+J[41]+J[42]+J[43]+J[44]+J[45]+J[46]+J[47]+J[48]+J[49]+J[50]+J[51]+J[52]+J[53]+J[54]+
    J[55]+J[56]+J[57]+J[58]+J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]-H[1]-H[2]-H[3]+H[4]+H[5]+H[6]+
    H[7]+H[8]+H[9]+H[10]-H[11]-J[0]-J[1]-J[2]+J[3]+J[4]+J[5]+J[6]+J[7]+J[8]+J[9]-J[10]+J[11]+J[12]-J[13]-J[14]-J[15]-J[16]-J[17]-J[18]-J[19]+
    J[20]+J[21]-J[22]-J[23]-J[24]-J[25]-J[26]-J[27]-J[28]+J[29]-J[30]-J[31]-J[32]-J[33]-J[34]-J[35]-J[36]+
    J[37]+J[38]+J[39]+J[40]+J[41]+J[42]+J[43]-J[44]+J[45]+J[46]+J[47]+J[48]+J[49]-J[50]+J[51]+J[52]+J[53]+
    J[54]-J[55]+J[56]+J[57]+J[58]-J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]-H[1]-H[2]-H[3]+H[4]+H[5]+
    H[6]+H[7]+H[8]+H[9]-H[10]+H[11]-J[0]-J[1]-J[2]+J[3]+J[4]+J[5]+J[6]+J[7]+J[8]-J[9]+J[10]+J[11]+J[12]-J[13]-J[14]-J[15]-J[16]-J[17]-J[18]+
    J[19]-J[20]+J[21]-J[22]-J[23]-J[24]-J[25]-J[26]-J[27]+J[28]-J[29]-J[30]-J[31]-J[32]-J[33]-J[34]-J[35]+
    J[36]-J[37]+J[38]+J[39]+J[40]+J[41]+J[42]-J[43]+J[44]+J[45]+J[46]+J[47]+J[48]-J[49]+J[50]+J[51]+J[52]+
    J[53]-J[54]+J[55]+J[56]+J[57]-J[58]+J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]-H[1]-H[2]-H[3]+
    H[4]+H[5]+H[6]+H[7]+H[8]+H[9]-H[10]-H[11]-J[0]-J[1]-J[2]+J[3]+J[4]+J[5]+J[6]+J[7]+J[8]-J[9]-J[10]+J[11]+
    J[12]-J[13]-J[14]-J[15]-J[16]-J[17]-J[18]+J[19]+J[20]+J[21]-J[22]-J[23]-J[24]-J[25]-J[26]-J[27]+J[28]+
    J[29]-J[30]-J[31]-J[32]-J[33]-J[34]-J[35]+J[36]+J[37]+J[38]+J[39]+J[40]+J[41]+J[42]-J[43]-J[44]+J[45]+
    J[46]+J[47]+J[48]-J[49]-J[50]+J[51]+J[52]+J[53]-J[54]-J[55]+J[56]+J[57]-J[58]-J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+
    J[65], +H[0]-H[1]-H[2]-H[3]+H[4]+H[5]+H[6]+H[7]+H[8]-H[9]+H[10]+H[11]-J[0]-J[1]-J[2]+J[3]+J[4]+J[5]+
    J[6]+J[7]-J[8]+J[9]+J[10]+J[11]+J[12]-J[13]-J[14]-J[15]-J[16]-J[17]+J[18]-J[19]-J[20]+J[21]-J[22]-J[23]-J[24]-J[25]-J[26]+
    J[27]-J[28]-J[29]-J[30]-J[31]-J[32]-J[33]-J[34]+J[35]-J[36]-J[37]+J[38]+J[39]+J[40]+J[41]-J[42]+J[43]+
    J[44]+J[45]+J[46]+J[47]-J[48]+J[49]+J[50]+J[51]+J[52]-J[53]+J[54]+J[55]+J[56]-J[57]+J[58]+J[59]-J[60]+
    J[61]+J[62]-J[63]-J[64]+J[65], +H[0]-H[1]-H[2]-H[3]+H[4]+H[5]+H[6]+H[7]+H[8]-H[9]+H[10]-H[11]-J[0]-J[1]-J[2]+
    J[3]+J[4]+J[5]+J[6]+J[7]-J[8]+J[9]-J[10]+J[11]+J[12]-J[13]-J[14]-J[15]-J[16]-J[17]+J[18]-J[19]+J[20]+
    J[21]-J[22]-J[23]-J[24]-J[25]-J[26]+J[27]-J[28]+J[29]-J[30]-J[31]-J[32]-J[33]-J[34]+J[35]-J[36]+J[37]+
    J[38]+J[39]+J[40]+J[41]-J[42]+J[43]-J[44]+J[45]+J[46]+J[47]-J[48]+J[49]-J[50]+J[51]+J[52]-J[53]+J[54]-J[55]+
    J[56]-J[57]+J[58]-J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]-H[1]-H[2]-H[3]+H[4]+H[5]+H[6]+H[7]+
    H[8]-H[9]-H[10]+H[11]-J[0]-J[1]-J[2]+J[3]+J[4]+J[5]+J[6]+J[7]-J[8]-J[9]+J[10]+J[11]+J[12]-J[13]-J[14]-J[15]-J[16]-J[17]+
    J[18]+J[19]-J[20]+J[21]-J[22]-J[23]-J[24]-J[25]-J[26]+J[27]+J[28]-J[29]-J[30]-J[31]-J[32]-J[33]-J[34]+
    J[35]+J[36]-J[37]+J[38]+J[39]+J[40]+J[41]-J[42]-J[43]+J[44]+J[45]+J[46]+J[47]-J[48]-J[49]+J[50]+J[51]+
    J[52]-J[53]-J[54]+J[55]+J[56]-J[57]-J[58]+J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]-H[1]-H[2]-H[3]+
    H[4]+H[5]+H[6]+H[7]+H[8]-H[9]-H[10]-H[11]-J[0]-J[1]-J[2]+J[3]+J[4]+J[5]+J[6]+J[7]-J[8]-J[9]-J[10]+J[11]+
    J[12]-J[13]-J[14]-J[15]-J[16]-J[17]+J[18]+J[19]+J[20]+J[21]-J[22]-J[23]-J[24]-J[25]-J[26]+J[27]+J[28]+
    J[29]-J[30]-J[31]-J[32]-J[33]-J[34]+J[35]+J[36]+J[37]+J[38]+J[39]+J[40]+J[41]-J[42]-J[43]-J[44]+J[45]+
    J[46]+J[47]-J[48]-J[49]-J[50]+J[51]+J[52]-J[53]-J[54]-J[55]+J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+
    J[63]+J[64]+J[65], +H[0]-H[1]-H[2]-H[3]+H[4]+H[5]+H[6]+H[7]-H[8]+H[9]+H[10]+H[11]-J[0]-J[1]-J[2]+J[3]+
    J[4]+J[5]+J[6]-J[7]+J[8]+J[9]+J[10]+J[11]+J[12]-J[13]-J[14]-J[15]-J[16]+J[17]-J[18]-J[19]-J[20]+J[21]-J[22]-J[23]-J[24]-J[25]+
    J[26]-J[27]-J[28]-J[29]-J[30]-J[31]-J[32]-J[33]+J[34]-J[35]-J[36]-J[37]+J[38]+J[39]+J[40]-J[41]+J[42]+
    J[43]+J[44]+J[45]+J[46]-J[47]+J[48]+J[49]+J[50]+J[51]-J[52]+J[53]+J[54]+J[55]-J[56]+J[57]+J[58]+J[59]-J[60]-J[61]-J[62]+
    J[63]+J[64]+J[65], +H[0]-H[1]-H[2]-H[3]+H[4]+H[5]+H[6]+H[7]-H[8]+H[9]+H[10]-H[11]-J[0]-J[1]-J[2]+J[3]+
    J[4]+J[5]+J[6]-J[7]+J[8]+J[9]-J[10]+J[11]+J[12]-J[13]-J[14]-J[15]-J[16]+J[17]-J[18]-J[19]+J[20]+J[21]-J[22]-J[23]-J[24]-J[25]+
    J[26]-J[27]-J[28]+J[29]-J[30]-J[31]-J[32]-J[33]+J[34]-J[35]-J[36]+J[37]+J[38]+J[39]+J[40]-J[41]+J[42]+
    J[43]-J[44]+J[45]+J[46]-J[47]+J[48]+J[49]-J[50]+J[51]-J[52]+J[53]+J[54]-J[55]-J[56]+J[57]+J[58]-J[59]-J[60]-J[61]+
    J[62]+J[63]-J[64]-J[65], +H[0]-H[1]-H[2]-H[3]+H[4]+H[5]+H[6]+H[7]-H[8]+H[9]-H[10]+H[11]-J[0]-J[1]-J[2]+
    J[3]+J[4]+J[5]+J[6]-J[7]+J[8]-J[9]+J[10]+J[11]+J[12]-J[13]-J[14]-J[15]-J[16]+J[17]-J[18]+J[19]-J[20]+
    J[21]-J[22]-J[23]-J[24]-J[25]+J[26]-J[27]+J[28]-J[29]-J[30]-J[31]-J[32]-J[33]+J[34]-J[35]+J[36]-J[37]+
    J[38]+J[39]+J[40]-J[41]+J[42]-J[43]+J[44]+J[45]+J[46]-J[47]+J[48]-J[49]+J[50]+J[51]-J[52]+J[53]-J[54]+
    J[55]-J[56]+J[57]-J[58]+J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]-H[1]-H[2]-H[3]+H[4]+H[5]+H[6]+
    H[7]-H[8]+H[9]-H[10]-H[11]-J[0]-J[1]-J[2]+J[3]+J[4]+J[5]+J[6]-J[7]+J[8]-J[9]-J[10]+J[11]+J[12]-J[13]-J[14]-J[15]-J[16]+
    J[17]-J[18]+J[19]+J[20]+J[21]-J[22]-J[23]-J[24]-J[25]+J[26]-J[27]+J[28]+J[29]-J[30]-J[31]-J[32]-J[33]+
    J[34]-J[35]+J[36]+J[37]+J[38]+J[39]+J[40]-J[41]+J[42]-J[43]-J[44]+J[45]+J[46]-J[47]+J[48]-J[49]-J[50]+
    J[51]-J[52]+J[53]-J[54]-J[55]-J[56]+J[57]-J[58]-J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]-H[1]-H[2]-H[3]+
    H[4]+H[5]+H[6]+H[7]-H[8]-H[9]+H[10]+H[11]-J[0]-J[1]-J[2]+J[3]+J[4]+J[5]+J[6]-J[7]-J[8]+J[9]+J[10]+J[11]+
    J[12]-J[13]-J[14]-J[15]-J[16]+J[17]+J[18]-J[19]-J[20]+J[21]-J[22]-J[23]-J[24]-J[25]+J[26]+J[27]-J[28]-J[29]-J[30]-J[31]-J[32]-J[33]+
    J[34]+J[35]-J[36]-J[37]+J[38]+J[39]+J[40]-J[41]-J[42]+J[43]+J[44]+J[45]+J[46]-J[47]-J[48]+J[49]+J[50]+
    J[51]-J[52]-J[53]+J[54]+J[55]-J[56]-J[57]+J[58]+J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]-H[1]-H[2]-H[3]+
    H[4]+H[5]+H[6]+H[7]-H[8]-H[9]+H[10]-H[11]-J[0]-J[1]-J[2]+J[3]+J[4]+J[5]+J[6]-J[7]-J[8]+J[9]-J[10]+J[11]+
    J[12]-J[13]-J[14]-J[15]-J[16]+J[17]+J[18]-J[19]+J[20]+J[21]-J[22]-J[23]-J[24]-J[25]+J[26]+J[27]-J[28]+
    J[29]-J[30]-J[31]-J[32]-J[33]+J[34]+J[35]-J[36]+J[37]+J[38]+J[39]+J[40]-J[41]-J[42]+J[43]-J[44]+J[45]+
    J[46]-J[47]-J[48]+J[49]-J[50]+J[51]-J[52]-J[53]+J[54]-J[55]-J[56]-J[57]+J[58]-J[59]+J[60]-J[61]+J[62]-J[63]+
    J[64]-J[65], +H[0]-H[1]-H[2]-H[3]+H[4]+H[5]+H[6]+H[7]-H[8]-H[9]-H[10]+H[11]-J[0]-J[1]-J[2]+J[3]+J[4]+
    J[5]+J[6]-J[7]-J[8]-J[9]+J[10]+J[11]+J[12]-J[13]-J[14]-J[15]-J[16]+J[17]+J[18]+J[19]-J[20]+J[21]-J[22]-J[23]-J[24]-J[25]+
    J[26]+J[27]+J[28]-J[29]-J[30]-J[31]-J[32]-J[33]+J[34]+J[35]+J[36]-J[37]+J[38]+J[39]+J[40]-J[41]-J[42]-J[43]+
    J[44]+J[45]+J[46]-J[47]-J[48]-J[49]+J[50]+J[51]-J[52]-J[53]-J[54]+J[55]-J[56]-J[57]-J[58]+J[59]+J[60]+
    J[61]-J[62]+J[63]-J[64]-J[65], +H[0]-H[1]-H[2]-H[3]+H[4]+H[5]+H[6]+H[7]-H[8]-H[9]-H[10]-H[11]-J[0]-J[1]-J[2]+
    J[3]+J[4]+J[5]+J[6]-J[7]-J[8]-J[9]-J[10]+J[11]+J[12]-J[13]-J[14]-J[15]-J[16]+J[17]+J[18]+J[19]+J[20]+
    J[21]-J[22]-J[23]-J[24]-J[25]+J[26]+J[27]+J[28]+J[29]-J[30]-J[31]-J[32]-J[33]+J[34]+J[35]+J[36]+J[37]+
    J[38]+J[39]+J[40]-J[41]-J[42]-J[43]-J[44]+J[45]+J[46]-J[47]-J[48]-J[49]-J[50]+J[51]-J[52]-J[53]-J[54]-J[55]-J[56]-J[57]-J[58]-J[59]+
    J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]-H[1]-H[2]-H[3]+H[4]+H[5]+H[6]-H[7]+H[8]+H[9]+H[10]+H[11]-J[0]-J[1]-J[2]+
    J[3]+J[4]+J[5]-J[6]+J[7]+J[8]+J[9]+J[10]+J[11]+J[12]-J[13]-J[14]-J[15]+J[16]-J[17]-J[18]-J[19]-J[20]+
    J[21]-J[22]-J[23]-J[24]+J[25]-J[26]-J[27]-J[28]-J[29]-J[30]-J[31]-J[32]+J[33]-J[34]-J[35]-J[36]-J[37]+
    J[38]+J[39]-J[40]+J[41]+J[42]+J[43]+J[44]+J[45]-J[46]+J[47]+J[48]+J[49]+J[50]-J[51]+J[52]+J[53]+J[54]+
    J[55]-J[56]-J[57]-J[58]-J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]-H[1]-H[2]-H[3]+H[4]+H[5]+H[6]-H[7]+
    H[8]+H[9]+H[10]-H[11]-J[0]-J[1]-J[2]+J[3]+J[4]+J[5]-J[6]+J[7]+J[8]+J[9]-J[10]+J[11]+J[12]-J[13]-J[14]-J[15]+
    J[16]-J[17]-J[18]-J[19]+J[20]+J[21]-J[22]-J[23]-J[24]+J[25]-J[26]-J[27]-J[28]+J[29]-J[30]-J[31]-J[32]+
    J[33]-J[34]-J[35]-J[36]+J[37]+J[38]+J[39]-J[40]+J[41]+J[42]+J[43]-J[44]+J[45]-J[46]+J[47]+J[48]+J[49]-J[50]-J[51]+
    J[52]+J[53]+J[54]-J[55]-J[56]-J[57]-J[58]+J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]-H[1]-H[2]-H[3]+
    H[4]+H[5]+H[6]-H[7]+H[8]+H[9]-H[10]+H[11]-J[0]-J[1]-J[2]+J[3]+J[4]+J[5]-J[6]+J[7]+J[8]-J[9]+J[10]+J[11]+
    J[12]-J[13]-J[14]-J[15]+J[16]-J[17]-J[18]+J[19]-J[20]+J[21]-J[22]-J[23]-J[24]+J[25]-J[26]-J[27]+J[28]-J[29]-J[30]-J[31]-J[32]+
    J[33]-J[34]-J[35]+J[36]-J[37]+J[38]+J[39]-J[40]+J[41]+J[42]-J[43]+J[44]+J[45]-J[46]+J[47]+J[48]-J[49]+
    J[50]-J[51]+J[52]+J[53]-J[54]+J[55]-J[56]-J[57]+J[58]-J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]-H[1]-H[2]-H[3]+
    H[4]+H[5]+H[6]-H[7]+H[8]+H[9]-H[10]-H[11]-J[0]-J[1]-J[2]+J[3]+J[4]+J[5]-J[6]+J[7]+J[8]-J[9]-J[10]+J[11]+
    J[12]-J[13]-J[14]-J[15]+J[16]-J[17]-J[18]+J[19]+J[20]+J[21]-J[22]-J[23]-J[24]+J[25]-J[26]-J[27]+J[28]+
    J[29]-J[30]-J[31]-J[32]+J[33]-J[34]-J[35]+J[36]+J[37]+J[38]+J[39]-J[40]+J[41]+J[42]-J[43]-J[44]+J[45]-J[46]+
    J[47]+J[48]-J[49]-J[50]-J[51]+J[52]+J[53]-J[54]-J[55]-J[56]-J[57]+J[58]+J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+
    J[65], +H[0]-H[1]-H[2]-H[3]+H[4]+H[5]+H[6]-H[7]+H[8]-H[9]+H[10]+H[11]-J[0]-J[1]-J[2]+J[3]+J[4]+J[5]-J[6]+
    J[7]-J[8]+J[9]+J[10]+J[11]+J[12]-J[13]-J[14]-J[15]+J[16]-J[17]+J[18]-J[19]-J[20]+J[21]-J[22]-J[23]-J[24]+
    J[25]-J[26]+J[27]-J[28]-J[29]-J[30]-J[31]-J[32]+J[33]-J[34]+J[35]-J[36]-J[37]+J[38]+J[39]-J[40]+J[41]-J[42]+
    J[43]+J[44]+J[45]-J[46]+J[47]-J[48]+J[49]+J[50]-J[51]+J[52]-J[53]+J[54]+J[55]-J[56]+J[57]-J[58]-J[59]-J[60]+
    J[61]+J[62]-J[63]-J[64]+J[65], +H[0]-H[1]-H[2]-H[3]+H[4]+H[5]+H[6]-H[7]+H[8]-H[9]+H[10]-H[11]-J[0]-J[1]-J[2]+
    J[3]+J[4]+J[5]-J[6]+J[7]-J[8]+J[9]-J[10]+J[11]+J[12]-J[13]-J[14]-J[15]+J[16]-J[17]+J[18]-J[19]+J[20]+
    J[21]-J[22]-J[23]-J[24]+J[25]-J[26]+J[27]-J[28]+J[29]-J[30]-J[31]-J[32]+J[33]-J[34]+J[35]-J[36]+J[37]+
    J[38]+J[39]-J[40]+J[41]-J[42]+J[43]-J[44]+J[45]-J[46]+J[47]-J[48]+J[49]-J[50]-J[51]+J[52]-J[53]+J[54]-J[55]-J[56]+
    J[57]-J[58]+J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]-H[1]-H[2]-H[3]+H[4]+H[5]+H[6]-H[7]+H[8]-H[9]-H[10]+
    H[11]-J[0]-J[1]-J[2]+J[3]+J[4]+J[5]-J[6]+J[7]-J[8]-J[9]+J[10]+J[11]+J[12]-J[13]-J[14]-J[15]+J[16]-J[17]+
    J[18]+J[19]-J[20]+J[21]-J[22]-J[23]-J[24]+J[25]-J[26]+J[27]+J[28]-J[29]-J[30]-J[31]-J[32]+J[33]-J[34]+
    J[35]+J[36]-J[37]+J[38]+J[39]-J[40]+J[41]-J[42]-J[43]+J[44]+J[45]-J[46]+J[47]-J[48]-J[49]+J[50]-J[51]+
    J[52]-J[53]-J[54]+J[55]-J[56]+J[57]+J[58]-J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]-H[1]-H[2]-H[3]+
    H[4]+H[5]+H[6]-H[7]+H[8]-H[9]-H[10]-H[11]-J[0]-J[1]-J[2]+J[3]+J[4]+J[5]-J[6]+J[7]-J[8]-J[9]-J[10]+J[11]+
    J[12]-J[13]-J[14]-J[15]+J[16]-J[17]+J[18]+J[19]+J[20]+J[21]-J[22]-J[23]-J[24]+J[25]-J[26]+J[27]+J[28]+
    J[29]-J[30]-J[31]-J[32]+J[33]-J[34]+J[35]+J[36]+J[37]+J[38]+J[39]-J[40]+J[41]-J[42]-J[43]-J[44]+J[45]-J[46]+
    J[47]-J[48]-J[49]-J[50]-J[51]+J[52]-J[53]-J[54]-J[55]-J[56]+J[57]+J[58]+J[59]-J[60]-J[61]-J[62]+J[63]+
    J[64]+J[65], +H[0]-H[1]-H[2]-H[3]+H[4]+H[5]+H[6]-H[7]-H[8]+H[9]+H[10]+H[11]-J[0]-J[1]-J[2]+J[3]+J[4]+
    J[5]-J[6]-J[7]+J[8]+J[9]+J[10]+J[11]+J[12]-J[13]-J[14]-J[15]+J[16]+J[17]-J[18]-J[19]-J[20]+J[21]-J[22]-J[23]-J[24]+
    J[25]+J[26]-J[27]-J[28]-J[29]-J[30]-J[31]-J[32]+J[33]+J[34]-J[35]-J[36]-J[37]+J[38]+J[39]-J[40]-J[41]+
    J[42]+J[43]+J[44]+J[45]-J[46]-J[47]+J[48]+J[49]+J[50]-J[51]-J[52]+J[53]+J[54]+J[55]+J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+
    J[63]+J[64]+J[65], +H[0]-H[1]-H[2]-H[3]+H[4]+H[5]+H[6]-H[7]-H[8]+H[9]+H[10]-H[11]-J[0]-J[1]-J[2]+J[3]+
    J[4]+J[5]-J[6]-J[7]+J[8]+J[9]-J[10]+J[11]+J[12]-J[13]-J[14]-J[15]+J[16]+J[17]-J[18]-J[19]+J[20]+J[21]-J[22]-J[23]-J[24]+
    J[25]+J[26]-J[27]-J[28]+J[29]-J[30]-J[31]-J[32]+J[33]+J[34]-J[35]-J[36]+J[37]+J[38]+J[39]-J[40]-J[41]+
    J[42]+J[43]-J[44]+J[45]-J[46]-J[47]+J[48]+J[49]-J[50]-J[51]-J[52]+J[53]+J[54]-J[55]+J[56]-J[57]-J[58]+
    J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]-H[1]-H[2]-H[3]+H[4]+H[5]+H[6]-H[7]-H[8]+H[9]-H[10]+
    H[11]-J[0]-J[1]-J[2]+J[3]+J[4]+J[5]-J[6]-J[7]+J[8]-J[9]+J[10]+J[11]+J[12]-J[13]-J[14]-J[15]+J[16]+J[17]-J[18]+
    J[19]-J[20]+J[21]-J[22]-J[23]-J[24]+J[25]+J[26]-J[27]+J[28]-J[29]-J[30]-J[31]-J[32]+J[33]+J[34]-J[35]+
    J[36]-J[37]+J[38]+J[39]-J[40]-J[41]+J[42]-J[43]+J[44]+J[45]-J[46]-J[47]+J[48]-J[49]+J[50]-J[51]-J[52]+
    J[53]-J[54]+J[55]+J[56]-J[57]+J[58]-J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]-H[1]-H[2]-H[3]+
    H[4]+H[5]+H[6]-H[7]-H[8]+H[9]-H[10]-H[11]-J[0]-J[1]-J[2]+J[3]+J[4]+J[5]-J[6]-J[7]+J[8]-J[9]-J[10]+J[11]+
    J[12]-J[13]-J[14]-J[15]+J[16]+J[17]-J[18]+J[19]+J[20]+J[21]-J[22]-J[23]-J[24]+J[25]+J[26]-J[27]+J[28]+
    J[29]-J[30]-J[31]-J[32]+J[33]+J[34]-J[35]+J[36]+J[37]+J[38]+J[39]-J[40]-J[41]+J[42]-J[43]-J[44]+J[45]-J[46]-J[47]+
    J[48]-J[49]-J[50]-J[51]-J[52]+J[53]-J[54]-J[55]+J[56]-J[57]+J[58]+J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+
    J[65], +H[0]-H[1]-H[2]-H[3]+H[4]+H[5]+H[6]-H[7]-H[8]-H[9]+H[10]+H[11]-J[0]-J[1]-J[2]+J[3]+J[4]+J[5]-J[6]-J[7]-J[8]+
    J[9]+J[10]+J[11]+J[12]-J[13]-J[14]-J[15]+J[16]+J[17]+J[18]-J[19]-J[20]+J[21]-J[22]-J[23]-J[24]+J[25]+
    J[26]+J[27]-J[28]-J[29]-J[30]-J[31]-J[32]+J[33]+J[34]+J[35]-J[36]-J[37]+J[38]+J[39]-J[40]-J[41]-J[42]+
    J[43]+J[44]+J[45]-J[46]-J[47]-J[48]+J[49]+J[50]-J[51]-J[52]-J[53]+J[54]+J[55]+J[56]+J[57]-J[58]-J[59]+
    J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]-H[1]-H[2]-H[3]+H[4]+H[5]+H[6]-H[7]-H[8]-H[9]+H[10]-H[11]-J[0]-J[1]-J[2]+
    J[3]+J[4]+J[5]-J[6]-J[7]-J[8]+J[9]-J[10]+J[11]+J[12]-J[13]-J[14]-J[15]+J[16]+J[17]+J[18]-J[19]+J[20]+
    J[21]-J[22]-J[23]-J[24]+J[25]+J[26]+J[27]-J[28]+J[29]-J[30]-J[31]-J[32]+J[33]+J[34]+J[35]-J[36]+J[37]+
    J[38]+J[39]-J[40]-J[41]-J[42]+J[43]-J[44]+J[45]-J[46]-J[47]-J[48]+J[49]-J[50]-J[51]-J[52]-J[53]+J[54]-J[55]+
    J[56]+J[57]-J[58]+J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]-H[1]-H[2]-H[3]+H[4]+H[5]+H[6]-H[7]-H[8]-H[9]-H[10]+
    H[11]-J[0]-J[1]-J[2]+J[3]+J[4]+J[5]-J[6]-J[7]-J[8]-J[9]+J[10]+J[11]+J[12]-J[13]-J[14]-J[15]+J[16]+J[17]+
    J[18]+J[19]-J[20]+J[21]-J[22]-J[23]-J[24]+J[25]+J[26]+J[27]+J[28]-J[29]-J[30]-J[31]-J[32]+J[33]+J[34]+
    J[35]+J[36]-J[37]+J[38]+J[39]-J[40]-J[41]-J[42]-J[43]+J[44]+J[45]-J[46]-J[47]-J[48]-J[49]+J[50]-J[51]-J[52]-J[53]-J[54]+
    J[55]+J[56]+J[57]+J[58]-J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]-H[1]-H[2]-H[3]+H[4]+H[5]+H[6]-H[7]-H[8]-H[9]-H[10]-H[11]-J[0]-J[1]-J[2]+
    J[3]+J[4]+J[5]-J[6]-J[7]-J[8]-J[9]-J[10]+J[11]+J[12]-J[13]-J[14]-J[15]+J[16]+J[17]+J[18]+J[19]+J[20]+
    J[21]-J[22]-J[23]-J[24]+J[25]+J[26]+J[27]+J[28]+J[29]-J[30]-J[31]-J[32]+J[33]+J[34]+J[35]+J[36]+J[37]+
    J[38]+J[39]-J[40]-J[41]-J[42]-J[43]-J[44]+J[45]-J[46]-J[47]-J[48]-J[49]-J[50]-J[51]-J[52]-J[53]-J[54]-J[55]+
    J[56]+J[57]+J[58]+J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]-H[1]-H[2]-H[3]+H[4]+H[5]-H[6]+H[7]+
    H[8]+H[9]+H[10]+H[11]-J[0]-J[1]-J[2]+J[3]+J[4]-J[5]+J[6]+J[7]+J[8]+J[9]+J[10]+J[11]+J[12]-J[13]-J[14]+
    J[15]-J[16]-J[17]-J[18]-J[19]-J[20]+J[21]-J[22]-J[23]+J[24]-J[25]-J[26]-J[27]-J[28]-J[29]-J[30]-J[31]+
    J[32]-J[33]-J[34]-J[35]-J[36]-J[37]+J[38]-J[39]+J[40]+J[41]+J[42]+J[43]+J[44]-J[45]+J[46]+J[47]+J[48]+
    J[49]+J[50]-J[51]-J[52]-J[53]-J[54]-J[55]+J[56]+J[57]+J[58]+J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +
    H[0]-H[1]-H[2]-H[3]+H[4]+H[5]-H[6]+H[7]+H[8]+H[9]+H[10]-H[11]-J[0]-J[1]-J[2]+J[3]+J[4]-J[5]+J[6]+J[7]+
    J[8]+J[9]-J[10]+J[11]+J[12]-J[13]-J[14]+J[15]-J[16]-J[17]-J[18]-J[19]+J[20]+J[21]-J[22]-J[23]+J[24]-J[25]-J[26]-J[27]-J[28]+
    J[29]-J[30]-J[31]+J[32]-J[33]-J[34]-J[35]-J[36]+J[37]+J[38]-J[39]+J[40]+J[41]+J[42]+J[43]-J[44]-J[45]+
    J[46]+J[47]+J[48]+J[49]-J[50]-J[51]-J[52]-J[53]-J[54]+J[55]+J[56]+J[57]+J[58]-J[59]+J[60]+J[61]-J[62]+
    J[63]-J[64]-J[65], +H[0]-H[1]-H[2]-H[3]+H[4]+H[5]-H[6]+H[7]+H[8]+H[9]-H[10]+H[11]-J[0]-J[1]-J[2]+J[3]+
    J[4]-J[5]+J[6]+J[7]+J[8]-J[9]+J[10]+J[11]+J[12]-J[13]-J[14]+J[15]-J[16]-J[17]-J[18]+J[19]-J[20]+J[21]-J[22]-J[23]+
    J[24]-J[25]-J[26]-J[27]+J[28]-J[29]-J[30]-J[31]+J[32]-J[33]-J[34]-J[35]+J[36]-J[37]+J[38]-J[39]+J[40]+
    J[41]+J[42]-J[43]+J[44]-J[45]+J[46]+J[47]+J[48]-J[49]+J[50]-J[51]-J[52]-J[53]+J[54]-J[55]+J[56]+J[57]-J[58]+
    J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]-H[1]-H[2]-H[3]+H[4]+H[5]-H[6]+H[7]+H[8]+H[9]-H[10]-H[11]-J[0]-J[1]-J[2]+
    J[3]+J[4]-J[5]+J[6]+J[7]+J[8]-J[9]-J[10]+J[11]+J[12]-J[13]-J[14]+J[15]-J[16]-J[17]-J[18]+J[19]+J[20]+
    J[21]-J[22]-J[23]+J[24]-J[25]-J[26]-J[27]+J[28]+J[29]-J[30]-J[31]+J[32]-J[33]-J[34]-J[35]+J[36]+J[37]+
    J[38]-J[39]+J[40]+J[41]+J[42]-J[43]-J[44]-J[45]+J[46]+J[47]+J[48]-J[49]-J[50]-J[51]-J[52]-J[53]+J[54]+
    J[55]+J[56]+J[57]-J[58]-J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]-H[1]-H[2]-H[3]+H[4]+H[5]-H[6]+
    H[7]+H[8]-H[9]+H[10]+H[11]-J[0]-J[1]-J[2]+J[3]+J[4]-J[5]+J[6]+J[7]-J[8]+J[9]+J[10]+J[11]+J[12]-J[13]-J[14]+
    J[15]-J[16]-J[17]+J[18]-J[19]-J[20]+J[21]-J[22]-J[23]+J[24]-J[25]-J[26]+J[27]-J[28]-J[29]-J[30]-J[31]+
    J[32]-J[33]-J[34]+J[35]-J[36]-J[37]+J[38]-J[39]+J[40]+J[41]-J[42]+J[43]+J[44]-J[45]+J[46]+J[47]-J[48]+
    J[49]+J[50]-J[51]-J[52]+J[53]-J[54]-J[55]+J[56]-J[57]+J[58]+J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +
    H[0]-H[1]-H[2]-H[3]+H[4]+H[5]-H[6]+H[7]+H[8]-H[9]+H[10]-H[11]-J[0]-J[1]-J[2]+J[3]+J[4]-J[5]+J[6]+J[7]-J[8]+
    J[9]-J[10]+J[11]+J[12]-J[13]-J[14]+J[15]-J[16]-J[17]+J[18]-J[19]+J[20]+J[21]-J[22]-J[23]+J[24]-J[25]-J[26]+
    J[27]-J[28]+J[29]-J[30]-J[31]+J[32]-J[33]-J[34]+J[35]-J[36]+J[37]+J[38]-J[39]+J[40]+J[41]-J[42]+J[43]-J[44]-J[45]+
    J[46]+J[47]-J[48]+J[49]-J[50]-J[51]-J[52]+J[53]-J[54]+J[55]+J[56]-J[57]+J[58]-J[59]-J[60]+J[61]-J[62]-J[63]+
    J[64]-J[65], +H[0]-H[1]-H[2]-H[3]+H[4]+H[5]-H[6]+H[7]+H[8]-H[9]-H[10]+H[11]-J[0]-J[1]-J[2]+J[3]+J[4]-J[5]+
    J[6]+J[7]-J[8]-J[9]+J[10]+J[11]+J[12]-J[13]-J[14]+J[15]-J[16]-J[17]+J[18]+J[19]-J[20]+J[21]-J[22]-J[23]+
    J[24]-J[25]-J[26]+J[27]+J[28]-J[29]-J[30]-J[31]+J[32]-J[33]-J[34]+J[35]+J[36]-J[37]+J[38]-J[39]+J[40]+
    J[41]-J[42]-J[43]+J[44]-J[45]+J[46]+J[47]-J[48]-J[49]+J[50]-J[51]-J[52]+J[53]+J[54]-J[55]+J[56]-J[57]-J[58]+
    J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]-H[1]-H[2]-H[3]+H[4]+H[5]-H[6]+H[7]+H[8]-H[9]-H[10]-H[11]-J[0]-J[1]-J[2]+
    J[3]+J[4]-J[5]+J[6]+J[7]-J[8]-J[9]-J[10]+J[11]+J[12]-J[13]-J[14]+J[15]-J[16]-J[17]+J[18]+J[19]+J[20]+
    J[21]-J[22]-J[23]+J[24]-J[25]-J[26]+J[27]+J[28]+J[29]-J[30]-J[31]+J[32]-J[33]-J[34]+J[35]+J[36]+J[37]+
    J[38]-J[39]+J[40]+J[41]-J[42]-J[43]-J[44]-J[45]+J[46]+J[47]-J[48]-J[49]-J[50]-J[51]-J[52]+J[53]+J[54]+
    J[55]+J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]-H[1]-H[2]-H[3]+H[4]+H[5]-H[6]+
    H[7]-H[8]+H[9]+H[10]+H[11]-J[0]-J[1]-J[2]+J[3]+J[4]-J[5]+J[6]-J[7]+J[8]+J[9]+J[10]+J[11]+J[12]-J[13]-J[14]+
    J[15]-J[16]+J[17]-J[18]-J[19]-J[20]+J[21]-J[22]-J[23]+J[24]-J[25]+J[26]-J[27]-J[28]-J[29]-J[30]-J[31]+
    J[32]-J[33]+J[34]-J[35]-J[36]-J[37]+J[38]-J[39]+J[40]-J[41]+J[42]+J[43]+J[44]-J[45]+J[46]-J[47]+J[48]+
    J[49]+J[50]-J[51]+J[52]-J[53]-J[54]-J[55]-J[56]+J[57]+J[58]+J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +
    H[0]-H[1]-H[2]-H[3]+H[4]+H[5]-H[6]+H[7]-H[8]+H[9]+H[10]-H[11]-J[0]-J[1]-J[2]+J[3]+J[4]-J[5]+J[6]-J[7]+
    J[8]+J[9]-J[10]+J[11]+J[12]-J[13]-J[14]+J[15]-J[16]+J[17]-J[18]-J[19]+J[20]+J[21]-J[22]-J[23]+J[24]-J[25]+
    J[26]-J[27]-J[28]+J[29]-J[30]-J[31]+J[32]-J[33]+J[34]-J[35]-J[36]+J[37]+J[38]-J[39]+J[40]-J[41]+J[42]+
    J[43]-J[44]-J[45]+J[46]-J[47]+J[48]+J[49]-J[50]-J[51]+J[52]-J[53]-J[54]+J[55]-J[56]+J[57]+J[58]-J[59]-J[60]-J[61]+
    J[62]+J[63]-J[64]-J[65], +H[0]-H[1]-H[2]-H[3]+H[4]+H[5]-H[6]+H[7]-H[8]+H[9]-H[10]+H[11]-J[0]-J[1]-J[2]+
    J[3]+J[4]-J[5]+J[6]-J[7]+J[8]-J[9]+J[10]+J[11]+J[12]-J[13]-J[14]+J[15]-J[16]+J[17]-J[18]+J[19]-J[20]+
    J[21]-J[22]-J[23]+J[24]-J[25]+J[26]-J[27]+J[28]-J[29]-J[30]-J[31]+J[32]-J[33]+J[34]-J[35]+J[36]-J[37]+
    J[38]-J[39]+J[40]-J[41]+J[42]-J[43]+J[44]-J[45]+J[46]-J[47]+J[48]-J[49]+J[50]-J[51]+J[52]-J[53]+J[54]-J[55]-J[56]+
    J[57]-J[58]+J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]-H[1]-H[2]-H[3]+H[4]+H[5]-H[6]+H[7]-H[8]+
    H[9]-H[10]-H[11]-J[0]-J[1]-J[2]+J[3]+J[4]-J[5]+J[6]-J[7]+J[8]-J[9]-J[10]+J[11]+J[12]-J[13]-J[14]+J[15]-J[16]+
    J[17]-J[18]+J[19]+J[20]+J[21]-J[22]-J[23]+J[24]-J[25]+J[26]-J[27]+J[28]+J[29]-J[30]-J[31]+J[32]-J[33]+
    J[34]-J[35]+J[36]+J[37]+J[38]-J[39]+J[40]-J[41]+J[42]-J[43]-J[44]-J[45]+J[46]-J[47]+J[48]-J[49]-J[50]-J[51]+
    J[52]-J[53]+J[54]+J[55]-J[56]+J[57]-J[58]-J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]-H[1]-H[2]-H[3]+
    H[4]+H[5]-H[6]+H[7]-H[8]-H[9]+H[10]+H[11]-J[0]-J[1]-J[2]+J[3]+J[4]-J[5]+J[6]-J[7]-J[8]+J[9]+J[10]+J[11]+
    J[12]-J[13]-J[14]+J[15]-J[16]+J[17]+J[18]-J[19]-J[20]+J[21]-J[22]-J[23]+J[24]-J[25]+J[26]+J[27]-J[28]-J[29]-J[30]-J[31]+
    J[32]-J[33]+J[34]+J[35]-J[36]-J[37]+J[38]-J[39]+J[40]-J[41]-J[42]+J[43]+J[44]-J[45]+J[46]-J[47]-J[48]+
    J[49]+J[50]-J[51]+J[52]+J[53]-J[54]-J[55]-J[56]-J[57]+J[58]+J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +
    H[0]-H[1]-H[2]-H[3]+H[4]+H[5]-H[6]+H[7]-H[8]-H[9]+H[10]-H[11]-J[0]-J[1]-J[2]+J[3]+J[4]-J[5]+J[6]-J[7]-J[8]+
    J[9]-J[10]+J[11]+J[12]-J[13]-J[14]+J[15]-J[16]+J[17]+J[18]-J[19]+J[20]+J[21]-J[22]-J[23]+J[24]-J[25]+
    J[26]+J[27]-J[28]+J[29]-J[30]-J[31]+J[32]-J[33]+J[34]+J[35]-J[36]+J[37]+J[38]-J[39]+J[40]-J[41]-J[42]+
    J[43]-J[44]-J[45]+J[46]-J[47]-J[48]+J[49]-J[50]-J[51]+J[52]+J[53]-J[54]+J[55]-J[56]-J[57]+J[58]-J[59]+
    J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]-H[1]-H[2]-H[3]+H[4]+H[5]-H[6]+H[7]-H[8]-H[9]-H[10]+H[11]-J[0]-J[1]-J[2]+
    J[3]+J[4]-J[5]+J[6]-J[7]-J[8]-J[9]+J[10]+J[11]+J[12]-J[13]-J[14]+J[15]-J[16]+J[17]+J[18]+J[19]-J[20]+
    J[21]-J[22]-J[23]+J[24]-J[25]+J[26]+J[27]+J[28]-J[29]-J[30]-J[31]+J[32]-J[33]+J[34]+J[35]+J[36]-J[37]+
    J[38]-J[39]+J[40]-J[41]-J[42]-J[43]+J[44]-J[45]+J[46]-J[47]-J[48]-J[49]+J[50]-J[51]+J[52]+J[53]+J[54]-J[55]-J[56]-J[57]-J[58]+
    J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]-H[1]-H[2]-H[3]+H[4]+H[5]-H[6]+H[7]-H[8]-H[9]-H[10]-H[11]-J[0]-J[1]-J[2]+
    J[3]+J[4]-J[5]+J[6]-J[7]-J[8]-J[9]-J[10]+J[11]+J[12]-J[13]-J[14]+J[15]-J[16]+J[17]+J[18]+J[19]+J[20]+
    J[21]-J[22]-J[23]+J[24]-J[25]+J[26]+J[27]+J[28]+J[29]-J[30]-J[31]+J[32]-J[33]+J[34]+J[35]+J[36]+J[37]+
    J[38]-J[39]+J[40]-J[41]-J[42]-J[43]-J[44]-J[45]+J[46]-J[47]-J[48]-J[49]-J[50]-J[51]+J[52]+J[53]+J[54]+
    J[55]-J[56]-J[57]-J[58]-J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]-H[1]-H[2]-H[3]+H[4]+H[5]-H[6]-H[7]+
    H[8]+H[9]+H[10]+H[11]-J[0]-J[1]-J[2]+J[3]+J[4]-J[5]-J[6]+J[7]+J[8]+J[9]+J[10]+J[11]+J[12]-J[13]-J[14]+
    J[15]+J[16]-J[17]-J[18]-J[19]-J[20]+J[21]-J[22]-J[23]+J[24]+J[25]-J[26]-J[27]-J[28]-J[29]-J[30]-J[31]+
    J[32]+J[33]-J[34]-J[35]-J[36]-J[37]+J[38]-J[39]-J[40]+J[41]+J[42]+J[43]+J[44]-J[45]-J[46]+J[47]+J[48]+
    J[49]+J[50]+J[51]-J[52]-J[53]-J[54]-J[55]-J[56]-J[57]-J[58]-J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +
    H[0]-H[1]-H[2]-H[3]+H[4]+H[5]-H[6]-H[7]+H[8]+H[9]+H[10]-H[11]-J[0]-J[1]-J[2]+J[3]+J[4]-J[5]-J[6]+J[7]+
    J[8]+J[9]-J[10]+J[11]+J[12]-J[13]-J[14]+J[15]+J[16]-J[17]-J[18]-J[19]+J[20]+J[21]-J[22]-J[23]+J[24]+
    J[25]-J[26]-J[27]-J[28]+J[29]-J[30]-J[31]+J[32]+J[33]-J[34]-J[35]-J[36]+J[37]+J[38]-J[39]-J[40]+J[41]+
    J[42]+J[43]-J[44]-J[45]-J[46]+J[47]+J[48]+J[49]-J[50]+J[51]-J[52]-J[53]-J[54]+J[55]-J[56]-J[57]-J[58]+
    J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]-H[1]-H[2]-H[3]+H[4]+H[5]-H[6]-H[7]+H[8]+H[9]-H[10]+
    H[11]-J[0]-J[1]-J[2]+J[3]+J[4]-J[5]-J[6]+J[7]+J[8]-J[9]+J[10]+J[11]+J[12]-J[13]-J[14]+J[15]+J[16]-J[17]-J[18]+
    J[19]-J[20]+J[21]-J[22]-J[23]+J[24]+J[25]-J[26]-J[27]+J[28]-J[29]-J[30]-J[31]+J[32]+J[33]-J[34]-J[35]+
    J[36]-J[37]+J[38]-J[39]-J[40]+J[41]+J[42]-J[43]+J[44]-J[45]-J[46]+J[47]+J[48]-J[49]+J[50]+J[51]-J[52]-J[53]+
    J[54]-J[55]-J[56]-J[57]+J[58]-J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]-H[1]-H[2]-H[3]+H[4]+H[5]-H[6]-H[7]+
    H[8]+H[9]-H[10]-H[11]-J[0]-J[1]-J[2]+J[3]+J[4]-J[5]-J[6]+J[7]+J[8]-J[9]-J[10]+J[11]+J[12]-J[13]-J[14]+
    J[15]+J[16]-J[17]-J[18]+J[19]+J[20]+J[21]-J[22]-J[23]+J[24]+J[25]-J[26]-J[27]+J[28]+J[29]-J[30]-J[31]+
    J[32]+J[33]-J[34]-J[35]+J[36]+J[37]+J[38]-J[39]-J[40]+J[41]+J[42]-J[43]-J[44]-J[45]-J[46]+J[47]+J[48]-J[49]-J[50]+
    J[51]-J[52]-J[53]+J[54]+J[55]-J[56]-J[57]+J[58]+J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]-H[1]-H[2]-H[3]+
    H[4]+H[5]-H[6]-H[7]+H[8]-H[9]+H[10]+H[11]-J[0]-J[1]-J[2]+J[3]+J[4]-J[5]-J[6]+J[7]-J[8]+J[9]+J[10]+J[11]+
    J[12]-J[13]-J[14]+J[15]+J[16]-J[17]+J[18]-J[19]-J[20]+J[21]-J[22]-J[23]+J[24]+J[25]-J[26]+J[27]-J[28]-J[29]-J[30]-J[31]+
    J[32]+J[33]-J[34]+J[35]-J[36]-J[37]+J[38]-J[39]-J[40]+J[41]-J[42]+J[43]+J[44]-J[45]-J[46]+J[47]-J[48]+
    J[49]+J[50]+J[51]-J[52]+J[53]-J[54]-J[55]-J[56]+J[57]-J[58]-J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +
    H[0]-H[1]-H[2]-H[3]+H[4]+H[5]-H[6]-H[7]+H[8]-H[9]+H[10]-H[11]-J[0]-J[1]-J[2]+J[3]+J[4]-J[5]-J[6]+J[7]-J[8]+
    J[9]-J[10]+J[11]+J[12]-J[13]-J[14]+J[15]+J[16]-J[17]+J[18]-J[19]+J[20]+J[21]-J[22]-J[23]+J[24]+J[25]-J[26]+
    J[27]-J[28]+J[29]-J[30]-J[31]+J[32]+J[33]-J[34]+J[35]-J[36]+J[37]+J[38]-J[39]-J[40]+J[41]-J[42]+J[43]-J[44]-J[45]-J[46]+
    J[47]-J[48]+J[49]-J[50]+J[51]-J[52]+J[53]-J[54]+J[55]-J[56]+J[57]-J[58]+J[59]-J[60]+J[61]-J[62]-J[63]+
    J[64]-J[65], +H[0]-H[1]-H[2]-H[3]+H[4]+H[5]-H[6]-H[7]+H[8]-H[9]-H[10]+H[11]-J[0]-J[1]-J[2]+J[3]+J[4]-J[5]-J[6]+
    J[7]-J[8]-J[9]+J[10]+J[11]+J[12]-J[13]-J[14]+J[15]+J[16]-J[17]+J[18]+J[19]-J[20]+J[21]-J[22]-J[23]+J[24]+
    J[25]-J[26]+J[27]+J[28]-J[29]-J[30]-J[31]+J[32]+J[33]-J[34]+J[35]+J[36]-J[37]+J[38]-J[39]-J[40]+J[41]-J[42]-J[43]+
    J[44]-J[45]-J[46]+J[47]-J[48]-J[49]+J[50]+J[51]-J[52]+J[53]+J[54]-J[55]-J[56]+J[57]+J[58]-J[59]-J[60]-J[61]+
    J[62]+J[63]-J[64]-J[65], +H[0]-H[1]-H[2]-H[3]+H[4]+H[5]-H[6]-H[7]+H[8]-H[9]-H[10]-H[11]-J[0]-J[1]-J[2]+
    J[3]+J[4]-J[5]-J[6]+J[7]-J[8]-J[9]-J[10]+J[11]+J[12]-J[13]-J[14]+J[15]+J[16]-J[17]+J[18]+J[19]+J[20]+
    J[21]-J[22]-J[23]+J[24]+J[25]-J[26]+J[27]+J[28]+J[29]-J[30]-J[31]+J[32]+J[33]-J[34]+J[35]+J[36]+J[37]+
    J[38]-J[39]-J[40]+J[41]-J[42]-J[43]-J[44]-J[45]-J[46]+J[47]-J[48]-J[49]-J[50]+J[51]-J[52]+J[53]+J[54]+
    J[55]-J[56]+J[57]+J[58]+J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]-H[1]-H[2]-H[3]+H[4]+H[5]-H[6]-H[7]-H[8]+
    H[9]+H[10]+H[11]-J[0]-J[1]-J[2]+J[3]+J[4]-J[5]-J[6]-J[7]+J[8]+J[9]+J[10]+J[11]+J[12]-J[13]-J[14]+J[15]+
    J[16]+J[17]-J[18]-J[19]-J[20]+J[21]-J[22]-J[23]+J[24]+J[25]+J[26]-J[27]-J[28]-J[29]-J[30]-J[31]+J[32]+
    J[33]+J[34]-J[35]-J[36]-J[37]+J[38]-J[39]-J[40]-J[41]+J[42]+J[43]+J[44]-J[45]-J[46]-J[47]+J[48]+J[49]+
    J[50]+J[51]+J[52]-J[53]-J[54]-J[55]+J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]-H[1]-H[2]-H[3]+
    H[4]+H[5]-H[6]-H[7]-H[8]+H[9]+H[10]-H[11]-J[0]-J[1]-J[2]+J[3]+J[4]-J[5]-J[6]-J[7]+J[8]+J[9]-J[10]+J[11]+
    J[12]-J[13]-J[14]+J[15]+J[16]+J[17]-J[18]-J[19]+J[20]+J[21]-J[22]-J[23]+J[24]+J[25]+J[26]-J[27]-J[28]+
    J[29]-J[30]-J[31]+J[32]+J[33]+J[34]-J[35]-J[36]+J[37]+J[38]-J[39]-J[40]-J[41]+J[42]+J[43]-J[44]-J[45]-J[46]-J[47]+
    J[48]+J[49]-J[50]+J[51]+J[52]-J[53]-J[54]+J[55]+J[56]-J[57]-J[58]+J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +
    H[0]-H[1]-H[2]-H[3]+H[4]+H[5]-H[6]-H[7]-H[8]+H[9]-H[10]+H[11]-J[0]-J[1]-J[2]+J[3]+J[4]-J[5]-J[6]-J[7]+
    J[8]-J[9]+J[10]+J[11]+J[12]-J[13]-J[14]+J[15]+J[16]+J[17]-J[18]+J[19]-J[20]+J[21]-J[22]-J[23]+J[24]+
    J[25]+J[26]-J[27]+J[28]-J[29]-J[30]-J[31]+J[32]+J[33]+J[34]-J[35]+J[36]-J[37]+J[38]-J[39]-J[40]-J[41]+
    J[42]-J[43]+J[44]-J[45]-J[46]-J[47]+J[48]-J[49]+J[50]+J[51]+J[52]-J[53]+J[54]-J[55]+J[56]-J[57]+J[58]-J[59]-J[60]+
    J[61]-J[62]-J[63]+J[64]-J[65], +H[0]-H[1]-H[2]-H[3]+H[4]+H[5]-H[6]-H[7]-H[8]+H[9]-H[10]-H[11]-J[0]-J[1]-J[2]+
    J[3]+J[4]-J[5]-J[6]-J[7]+J[8]-J[9]-J[10]+J[11]+J[12]-J[13]-J[14]+J[15]+J[16]+J[17]-J[18]+J[19]+J[20]+
    J[21]-J[22]-J[23]+J[24]+J[25]+J[26]-J[27]+J[28]+J[29]-J[30]-J[31]+J[32]+J[33]+J[34]-J[35]+J[36]+J[37]+
    J[38]-J[39]-J[40]-J[41]+J[42]-J[43]-J[44]-J[45]-J[46]-J[47]+J[48]-J[49]-J[50]+J[51]+J[52]-J[53]+J[54]+
    J[55]+J[56]-J[57]+J[58]+J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]-H[1]-H[2]-H[3]+H[4]+H[5]-H[6]-H[7]-H[8]-H[9]+
    H[10]+H[11]-J[0]-J[1]-J[2]+J[3]+J[4]-J[5]-J[6]-J[7]-J[8]+J[9]+J[10]+J[11]+J[12]-J[13]-J[14]+J[15]+J[16]+
    J[17]+J[18]-J[19]-J[20]+J[21]-J[22]-J[23]+J[24]+J[25]+J[26]+J[27]-J[28]-J[29]-J[30]-J[31]+J[32]+J[33]+
    J[34]+J[35]-J[36]-J[37]+J[38]-J[39]-J[40]-J[41]-J[42]+J[43]+J[44]-J[45]-J[46]-J[47]-J[48]+J[49]+J[50]+
    J[51]+J[52]+J[53]-J[54]-J[55]+J[56]+J[57]-J[58]-J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]-H[1]-H[2]-H[3]+
    H[4]+H[5]-H[6]-H[7]-H[8]-H[9]+H[10]-H[11]-J[0]-J[1]-J[2]+J[3]+J[4]-J[5]-J[6]-J[7]-J[8]+J[9]-J[10]+J[11]+
    J[12]-J[13]-J[14]+J[15]+J[16]+J[17]+J[18]-J[19]+J[20]+J[21]-J[22]-J[23]+J[24]+J[25]+J[26]+J[27]-J[28]+
    J[29]-J[30]-J[31]+J[32]+J[33]+J[34]+J[35]-J[36]+J[37]+J[38]-J[39]-J[40]-J[41]-J[42]+J[43]-J[44]-J[45]-J[46]-J[47]-J[48]+
    J[49]-J[50]+J[51]+J[52]+J[53]-J[54]+J[55]+J[56]+J[57]-J[58]+J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +
    H[0]-H[1]-H[2]-H[3]+H[4]+H[5]-H[6]-H[7]-H[8]-H[9]-H[10]+H[11]-J[0]-J[1]-J[2]+J[3]+J[4]-J[5]-J[6]-J[7]-J[8]-J[9]+
    J[10]+J[11]+J[12]-J[13]-J[14]+J[15]+J[16]+J[17]+J[18]+J[19]-J[20]+J[21]-J[22]-J[23]+J[24]+J[25]+J[26]+
    J[27]+J[28]-J[29]-J[30]-J[31]+J[32]+J[33]+J[34]+J[35]+J[36]-J[37]+J[38]-J[39]-J[40]-J[41]-J[42]-J[43]+
    J[44]-J[45]-J[46]-J[47]-J[48]-J[49]+J[50]+J[51]+J[52]+J[53]+J[54]-J[55]+J[56]+J[57]+J[58]-J[59]+J[60]+
    J[61]-J[62]+J[63]-J[64]-J[65], +H[0]-H[1]-H[2]-H[3]+H[4]+H[5]-H[6]-H[7]-H[8]-H[9]-H[10]-H[11]-J[0]-J[1]-J[2]+
    J[3]+J[4]-J[5]-J[6]-J[7]-J[8]-J[9]-J[10]+J[11]+J[12]-J[13]-J[14]+J[15]+J[16]+J[17]+J[18]+J[19]+J[20]+
    J[21]-J[22]-J[23]+J[24]+J[25]+J[26]+J[27]+J[28]+J[29]-J[30]-J[31]+J[32]+J[33]+J[34]+J[35]+J[36]+J[37]+
    J[38]-J[39]-J[40]-J[41]-J[42]-J[43]-J[44]-J[45]-J[46]-J[47]-J[48]-J[49]-J[50]+J[51]+J[52]+J[53]+J[54]+
    J[55]+J[56]+J[57]+J[58]+J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]-H[1]-H[2]-H[3]+H[4]-H[5]+H[6]+
    H[7]+H[8]+H[9]+H[10]+H[11]-J[0]-J[1]-J[2]+J[3]-J[4]+J[5]+J[6]+J[7]+J[8]+J[9]+J[10]+J[11]+J[12]-J[13]+
    J[14]-J[15]-J[16]-J[17]-J[18]-J[19]-J[20]+J[21]-J[22]+J[23]-J[24]-J[25]-J[26]-J[27]-J[28]-J[29]-J[30]+
    J[31]-J[32]-J[33]-J[34]-J[35]-J[36]-J[37]-J[38]+J[39]+J[40]+J[41]+J[42]+J[43]+J[44]-J[45]-J[46]-J[47]-J[48]-J[49]-J[50]+
    J[51]+J[52]+J[53]+J[54]+J[55]+J[56]+J[57]+J[58]+J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]-H[1]-H[2]-H[3]+
    H[4]-H[5]+H[6]+H[7]+H[8]+H[9]+H[10]-H[11]-J[0]-J[1]-J[2]+J[3]-J[4]+J[5]+J[6]+J[7]+J[8]+J[9]-J[10]+J[11]+
    J[12]-J[13]+J[14]-J[15]-J[16]-J[17]-J[18]-J[19]+J[20]+J[21]-J[22]+J[23]-J[24]-J[25]-J[26]-J[27]-J[28]+
    J[29]-J[30]+J[31]-J[32]-J[33]-J[34]-J[35]-J[36]+J[37]-J[38]+J[39]+J[40]+J[41]+J[42]+J[43]-J[44]-J[45]-J[46]-J[47]-J[48]-J[49]+
    J[50]+J[51]+J[52]+J[53]+J[54]-J[55]+J[56]+J[57]+J[58]-J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]-H[1]-H[2]-H[3]+
    H[4]-H[5]+H[6]+H[7]+H[8]+H[9]-H[10]+H[11]-J[0]-J[1]-J[2]+J[3]-J[4]+J[5]+J[6]+J[7]+J[8]-J[9]+J[10]+J[11]+
    J[12]-J[13]+J[14]-J[15]-J[16]-J[17]-J[18]+J[19]-J[20]+J[21]-J[22]+J[23]-J[24]-J[25]-J[26]-J[27]+J[28]-J[29]-J[30]+
    J[31]-J[32]-J[33]-J[34]-J[35]+J[36]-J[37]-J[38]+J[39]+J[40]+J[41]+J[42]-J[43]+J[44]-J[45]-J[46]-J[47]-J[48]+
    J[49]-J[50]+J[51]+J[52]+J[53]-J[54]+J[55]+J[56]+J[57]-J[58]+J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +
    H[0]-H[1]-H[2]-H[3]+H[4]-H[5]+H[6]+H[7]+H[8]+H[9]-H[10]-H[11]-J[0]-J[1]-J[2]+J[3]-J[4]+J[5]+J[6]+J[7]+
    J[8]-J[9]-J[10]+J[11]+J[12]-J[13]+J[14]-J[15]-J[16]-J[17]-J[18]+J[19]+J[20]+J[21]-J[22]+J[23]-J[24]-J[25]-J[26]-J[27]+
    J[28]+J[29]-J[30]+J[31]-J[32]-J[33]-J[34]-J[35]+J[36]+J[37]-J[38]+J[39]+J[40]+J[41]+J[42]-J[43]-J[44]-J[45]-J[46]-J[47]-J[48]+
    J[49]+J[50]+J[51]+J[52]+J[53]-J[54]-J[55]+J[56]+J[57]-J[58]-J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +
    H[0]-H[1]-H[2]-H[3]+H[4]-H[5]+H[6]+H[7]+H[8]-H[9]+H[10]+H[11]-J[0]-J[1]-J[2]+J[3]-J[4]+J[5]+J[6]+J[7]-J[8]+
    J[9]+J[10]+J[11]+J[12]-J[13]+J[14]-J[15]-J[16]-J[17]+J[18]-J[19]-J[20]+J[21]-J[22]+J[23]-J[24]-J[25]-J[26]+
    J[27]-J[28]-J[29]-J[30]+J[31]-J[32]-J[33]-J[34]+J[35]-J[36]-J[37]-J[38]+J[39]+J[40]+J[41]-J[42]+J[43]+
    J[44]-J[45]-J[46]-J[47]+J[48]-J[49]-J[50]+J[51]+J[52]-J[53]+J[54]+J[55]+J[56]-J[57]+J[58]+J[59]-J[60]+
    J[61]+J[62]-J[63]-J[64]+J[65], +H[0]-H[1]-H[2]-H[3]+H[4]-H[5]+H[6]+H[7]+H[8]-H[9]+H[10]-H[11]-J[0]-J[1]-J[2]+
    J[3]-J[4]+J[5]+J[6]+J[7]-J[8]+J[9]-J[10]+J[11]+J[12]-J[13]+J[14]-J[15]-J[16]-J[17]+J[18]-J[19]+J[20]+
    J[21]-J[22]+J[23]-J[24]-J[25]-J[26]+J[27]-J[28]+J[29]-J[30]+J[31]-J[32]-J[33]-J[34]+J[35]-J[36]+J[37]-J[38]+
    J[39]+J[40]+J[41]-J[42]+J[43]-J[44]-J[45]-J[46]-J[47]+J[48]-J[49]+J[50]+J[51]+J[52]-J[53]+J[54]-J[55]+
    J[56]-J[57]+J[58]-J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]-H[1]-H[2]-H[3]+H[4]-H[5]+H[6]+H[7]+
    H[8]-H[9]-H[10]+H[11]-J[0]-J[1]-J[2]+J[3]-J[4]+J[5]+J[6]+J[7]-J[8]-J[9]+J[10]+J[11]+J[12]-J[13]+J[14]-J[15]-J[16]-J[17]+
    J[18]+J[19]-J[20]+J[21]-J[22]+J[23]-J[24]-J[25]-J[26]+J[27]+J[28]-J[29]-J[30]+J[31]-J[32]-J[33]-J[34]+
    J[35]+J[36]-J[37]-J[38]+J[39]+J[40]+J[41]-J[42]-J[43]+J[44]-J[45]-J[46]-J[47]+J[48]+J[49]-J[50]+J[51]+
    J[52]-J[53]-J[54]+J[55]+J[56]-J[57]-J[58]+J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]-H[1]-H[2]-H[3]+
    H[4]-H[5]+H[6]+H[7]+H[8]-H[9]-H[10]-H[11]-J[0]-J[1]-J[2]+J[3]-J[4]+J[5]+J[6]+J[7]-J[8]-J[9]-J[10]+J[11]+
    J[12]-J[13]+J[14]-J[15]-J[16]-J[17]+J[18]+J[19]+J[20]+J[21]-J[22]+J[23]-J[24]-J[25]-J[26]+J[27]+J[28]+
    J[29]-J[30]+J[31]-J[32]-J[33]-J[34]+J[35]+J[36]+J[37]-J[38]+J[39]+J[40]+J[41]-J[42]-J[43]-J[44]-J[45]-J[46]-J[47]+
    J[48]+J[49]+J[50]+J[51]+J[52]-J[53]-J[54]-J[55]+J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+
    J[65], +H[0]-H[1]-H[2]-H[3]+H[4]-H[5]+H[6]+H[7]-H[8]+H[9]+H[10]+H[11]-J[0]-J[1]-J[2]+J[3]-J[4]+J[5]+
    J[6]-J[7]+J[8]+J[9]+J[10]+J[11]+J[12]-J[13]+J[14]-J[15]-J[16]+J[17]-J[18]-J[19]-J[20]+J[21]-J[22]+J[23]-J[24]-J[25]+
    J[26]-J[27]-J[28]-J[29]-J[30]+J[31]-J[32]-J[33]+J[34]-J[35]-J[36]-J[37]-J[38]+J[39]+J[40]-J[41]+J[42]+
    J[43]+J[44]-J[45]-J[46]+J[47]-J[48]-J[49]-J[50]+J[51]-J[52]+J[53]+J[54]+J[55]-J[56]+J[57]+J[58]+J[59]-J[60]-J[61]-J[62]+
    J[63]+J[64]+J[65], +H[0]-H[1]-H[2]-H[3]+H[4]-H[5]+H[6]+H[7]-H[8]+H[9]+H[10]-H[11]-J[0]-J[1]-J[2]+J[3]-J[4]+
    J[5]+J[6]-J[7]+J[8]+J[9]-J[10]+J[11]+J[12]-J[13]+J[14]-J[15]-J[16]+J[17]-J[18]-J[19]+J[20]+J[21]-J[22]+
    J[23]-J[24]-J[25]+J[26]-J[27]-J[28]+J[29]-J[30]+J[31]-J[32]-J[33]+J[34]-J[35]-J[36]+J[37]-J[38]+J[39]+
    J[40]-J[41]+J[42]+J[43]-J[44]-J[45]-J[46]+J[47]-J[48]-J[49]+J[50]+J[51]-J[52]+J[53]+J[54]-J[55]-J[56]+
    J[57]+J[58]-J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]-H[1]-H[2]-H[3]+H[4]-H[5]+H[6]+H[7]-H[8]+
    H[9]-H[10]+H[11]-J[0]-J[1]-J[2]+J[3]-J[4]+J[5]+J[6]-J[7]+J[8]-J[9]+J[10]+J[11]+J[12]-J[13]+J[14]-J[15]-J[16]+
    J[17]-J[18]+J[19]-J[20]+J[21]-J[22]+J[23]-J[24]-J[25]+J[26]-J[27]+J[28]-J[29]-J[30]+J[31]-J[32]-J[33]+
    J[34]-J[35]+J[36]-J[37]-J[38]+J[39]+J[40]-J[41]+J[42]-J[43]+J[44]-J[45]-J[46]+J[47]-J[48]+J[49]-J[50]+
    J[51]-J[52]+J[53]-J[54]+J[55]-J[56]+J[57]-J[58]+J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]-H[1]-H[2]-H[3]+
    H[4]-H[5]+H[6]+H[7]-H[8]+H[9]-H[10]-H[11]-J[0]-J[1]-J[2]+J[3]-J[4]+J[5]+J[6]-J[7]+J[8]-J[9]-J[10]+J[11]+
    J[12]-J[13]+J[14]-J[15]-J[16]+J[17]-J[18]+J[19]+J[20]+J[21]-J[22]+J[23]-J[24]-J[25]+J[26]-J[27]+J[28]+
    J[29]-J[30]+J[31]-J[32]-J[33]+J[34]-J[35]+J[36]+J[37]-J[38]+J[39]+J[40]-J[41]+J[42]-J[43]-J[44]-J[45]-J[46]+
    J[47]-J[48]+J[49]+J[50]+J[51]-J[52]+J[53]-J[54]-J[55]-J[56]+J[57]-J[58]-J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+
    J[65], +H[0]-H[1]-H[2]-H[3]+H[4]-H[5]+H[6]+H[7]-H[8]-H[9]+H[10]+H[11]-J[0]-J[1]-J[2]+J[3]-J[4]+J[5]+
    J[6]-J[7]-J[8]+J[9]+J[10]+J[11]+J[12]-J[13]+J[14]-J[15]-J[16]+J[17]+J[18]-J[19]-J[20]+J[21]-J[22]+J[23]-J[24]-J[25]+
    J[26]+J[27]-J[28]-J[29]-J[30]+J[31]-J[32]-J[33]+J[34]+J[35]-J[36]-J[37]-J[38]+J[39]+J[40]-J[41]-J[42]+
    J[43]+J[44]-J[45]-J[46]+J[47]+J[48]-J[49]-J[50]+J[51]-J[52]-J[53]+J[54]+J[55]-J[56]-J[57]+J[58]+J[59]+
    J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]-H[1]-H[2]-H[3]+H[4]-H[5]+H[6]+H[7]-H[8]-H[9]+H[10]-H[11]-J[0]-J[1]-J[2]+
    J[3]-J[4]+J[5]+J[6]-J[7]-J[8]+J[9]-J[10]+J[11]+J[12]-J[13]+J[14]-J[15]-J[16]+J[17]+J[18]-J[19]+J[20]+
    J[21]-J[22]+J[23]-J[24]-J[25]+J[26]+J[27]-J[28]+J[29]-J[30]+J[31]-J[32]-J[33]+J[34]+J[35]-J[36]+J[37]-J[38]+
    J[39]+J[40]-J[41]-J[42]+J[43]-J[44]-J[45]-J[46]+J[47]+J[48]-J[49]+J[50]+J[51]-J[52]-J[53]+J[54]-J[55]-J[56]-J[57]+
    J[58]-J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]-H[1]-H[2]-H[3]+H[4]-H[5]+H[6]+H[7]-H[8]-H[9]-H[10]+
    H[11]-J[0]-J[1]-J[2]+J[3]-J[4]+J[5]+J[6]-J[7]-J[8]-J[9]+J[10]+J[11]+J[12]-J[13]+J[14]-J[15]-J[16]+J[17]+
    J[18]+J[19]-J[20]+J[21]-J[22]+J[23]-J[24]-J[25]+J[26]+J[27]+J[28]-J[29]-J[30]+J[31]-J[32]-J[33]+J[34]+
    J[35]+J[36]-J[37]-J[38]+J[39]+J[40]-J[41]-J[42]-J[43]+J[44]-J[45]-J[46]+J[47]+J[48]+J[49]-J[50]+J[51]-J[52]-J[53]-J[54]+
    J[55]-J[56]-J[57]-J[58]+J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]-H[1]-H[2]-H[3]+H[4]-H[5]+H[6]+
    H[7]-H[8]-H[9]-H[10]-H[11]-J[0]-J[1]-J[2]+J[3]-J[4]+J[5]+J[6]-J[7]-J[8]-J[9]-J[10]+J[11]+J[12]-J[13]+
    J[14]-J[15]-J[16]+J[17]+J[18]+J[19]+J[20]+J[21]-J[22]+J[23]-J[24]-J[25]+J[26]+J[27]+J[28]+J[29]-J[30]+
    J[31]-J[32]-J[33]+J[34]+J[35]+J[36]+J[37]-J[38]+J[39]+J[40]-J[41]-J[42]-J[43]-J[44]-J[45]-J[46]+J[47]+
    J[48]+J[49]+J[50]+J[51]-J[52]-J[53]-J[54]-J[55]-J[56]-J[57]-J[58]-J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+
    J[65], +H[0]-H[1]-H[2]-H[3]+H[4]-H[5]+H[6]-H[7]+H[8]+H[9]+H[10]+H[11]-J[0]-J[1]-J[2]+J[3]-J[4]+J[5]-J[6]+
    J[7]+J[8]+J[9]+J[10]+J[11]+J[12]-J[13]+J[14]-J[15]+J[16]-J[17]-J[18]-J[19]-J[20]+J[21]-J[22]+J[23]-J[24]+
    J[25]-J[26]-J[27]-J[28]-J[29]-J[30]+J[31]-J[32]+J[33]-J[34]-J[35]-J[36]-J[37]-J[38]+J[39]-J[40]+J[41]+
    J[42]+J[43]+J[44]-J[45]+J[46]-J[47]-J[48]-J[49]-J[50]-J[51]+J[52]+J[53]+J[54]+J[55]-J[56]-J[57]-J[58]-J[59]+
    J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]-H[1]-H[2]-H[3]+H[4]-H[5]+H[6]-H[7]+H[8]+H[9]+H[10]-H[11]-J[0]-J[1]-J[2]+
    J[3]-J[4]+J[5]-J[6]+J[7]+J[8]+J[9]-J[10]+J[11]+J[12]-J[13]+J[14]-J[15]+J[16]-J[17]-J[18]-J[19]+J[20]+
    J[21]-J[22]+J[23]-J[24]+J[25]-J[26]-J[27]-J[28]+J[29]-J[30]+J[31]-J[32]+J[33]-J[34]-J[35]-J[36]+J[37]-J[38]+
    J[39]-J[40]+J[41]+J[42]+J[43]-J[44]-J[45]+J[46]-J[47]-J[48]-J[49]+J[50]-J[51]+J[52]+J[53]+J[54]-J[55]-J[56]-J[57]-J[58]+
    J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]-H[1]-H[2]-H[3]+H[4]-H[5]+H[6]-H[7]+H[8]+H[9]-H[10]+
    H[11]-J[0]-J[1]-J[2]+J[3]-J[4]+J[5]-J[6]+J[7]+J[8]-J[9]+J[10]+J[11]+J[12]-J[13]+J[14]-J[15]+J[16]-J[17]-J[18]+
    J[19]-J[20]+J[21]-J[22]+J[23]-J[24]+J[25]-J[26]-J[27]+J[28]-J[29]-J[30]+J[31]-J[32]+J[33]-J[34]-J[35]+
    J[36]-J[37]-J[38]+J[39]-J[40]+J[41]+J[42]-J[43]+J[44]-J[45]+J[46]-J[47]-J[48]+J[49]-J[50]-J[51]+J[52]+
    J[53]-J[54]+J[55]-J[56]-J[57]+J[58]-J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]-H[1]-H[2]-H[3]+
    H[4]-H[5]+H[6]-H[7]+H[8]+H[9]-H[10]-H[11]-J[0]-J[1]-J[2]+J[3]-J[4]+J[5]-J[6]+J[7]+J[8]-J[9]-J[10]+J[11]+
    J[12]-J[13]+J[14]-J[15]+J[16]-J[17]-J[18]+J[19]+J[20]+J[21]-J[22]+J[23]-J[24]+J[25]-J[26]-J[27]+J[28]+
    J[29]-J[30]+J[31]-J[32]+J[33]-J[34]-J[35]+J[36]+J[37]-J[38]+J[39]-J[40]+J[41]+J[42]-J[43]-J[44]-J[45]+
    J[46]-J[47]-J[48]+J[49]+J[50]-J[51]+J[52]+J[53]-J[54]-J[55]-J[56]-J[57]+J[58]+J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+
    J[65], +H[0]-H[1]-H[2]-H[3]+H[4]-H[5]+H[6]-H[7]+H[8]-H[9]+H[10]+H[11]-J[0]-J[1]-J[2]+J[3]-J[4]+J[5]-J[6]+
    J[7]-J[8]+J[9]+J[10]+J[11]+J[12]-J[13]+J[14]-J[15]+J[16]-J[17]+J[18]-J[19]-J[20]+J[21]-J[22]+J[23]-J[24]+
    J[25]-J[26]+J[27]-J[28]-J[29]-J[30]+J[31]-J[32]+J[33]-J[34]+J[35]-J[36]-J[37]-J[38]+J[39]-J[40]+J[41]-J[42]+
    J[43]+J[44]-J[45]+J[46]-J[47]+J[48]-J[49]-J[50]-J[51]+J[52]-J[53]+J[54]+J[55]-J[56]+J[57]-J[58]-J[59]-J[60]+
    J[61]+J[62]-J[63]-J[64]+J[65], +H[0]-H[1]-H[2]-H[3]+H[4]-H[5]+H[6]-H[7]+H[8]-H[9]+H[10]-H[11]-J[0]-J[1]-J[2]+
    J[3]-J[4]+J[5]-J[6]+J[7]-J[8]+J[9]-J[10]+J[11]+J[12]-J[13]+J[14]-J[15]+J[16]-J[17]+J[18]-J[19]+J[20]+
    J[21]-J[22]+J[23]-J[24]+J[25]-J[26]+J[27]-J[28]+J[29]-J[30]+J[31]-J[32]+J[33]-J[34]+J[35]-J[36]+J[37]-J[38]+
    J[39]-J[40]+J[41]-J[42]+J[43]-J[44]-J[45]+J[46]-J[47]+J[48]-J[49]+J[50]-J[51]+J[52]-J[53]+J[54]-J[55]-J[56]+
    J[57]-J[58]+J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]-H[1]-H[2]-H[3]+H[4]-H[5]+H[6]-H[7]+H[8]-H[9]-H[10]+
    H[11]-J[0]-J[1]-J[2]+J[3]-J[4]+J[5]-J[6]+J[7]-J[8]-J[9]+J[10]+J[11]+J[12]-J[13]+J[14]-J[15]+J[16]-J[17]+
    J[18]+J[19]-J[20]+J[21]-J[22]+J[23]-J[24]+J[25]-J[26]+J[27]+J[28]-J[29]-J[30]+J[31]-J[32]+J[33]-J[34]+
    J[35]+J[36]-J[37]-J[38]+J[39]-J[40]+J[41]-J[42]-J[43]+J[44]-J[45]+J[46]-J[47]+J[48]+J[49]-J[50]-J[51]+
    J[52]-J[53]-J[54]+J[55]-J[56]+J[57]+J[58]-J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]-H[1]-H[2]-H[3]+
    H[4]-H[5]+H[6]-H[7]+H[8]-H[9]-H[10]-H[11]-J[0]-J[1]-J[2]+J[3]-J[4]+J[5]-J[6]+J[7]-J[8]-J[9]-J[10]+J[11]+
    J[12]-J[13]+J[14]-J[15]+J[16]-J[17]+J[18]+J[19]+J[20]+J[21]-J[22]+J[23]-J[24]+J[25]-J[26]+J[27]+J[28]+
    J[29]-J[30]+J[31]-J[32]+J[33]-J[34]+J[35]+J[36]+J[37]-J[38]+J[39]-J[40]+J[41]-J[42]-J[43]-J[44]-J[45]+
    J[46]-J[47]+J[48]+J[49]+J[50]-J[51]+J[52]-J[53]-J[54]-J[55]-J[56]+J[57]+J[58]+J[59]-J[60]-J[61]-J[62]+
    J[63]+J[64]+J[65], +H[0]-H[1]-H[2]-H[3]+H[4]-H[5]+H[6]-H[7]-H[8]+H[9]+H[10]+H[11]-J[0]-J[1]-J[2]+J[3]-J[4]+
    J[5]-J[6]-J[7]+J[8]+J[9]+J[10]+J[11]+J[12]-J[13]+J[14]-J[15]+J[16]+J[17]-J[18]-J[19]-J[20]+J[21]-J[22]+
    J[23]-J[24]+J[25]+J[26]-J[27]-J[28]-J[29]-J[30]+J[31]-J[32]+J[33]+J[34]-J[35]-J[36]-J[37]-J[38]+J[39]-J[40]-J[41]+
    J[42]+J[43]+J[44]-J[45]+J[46]+J[47]-J[48]-J[49]-J[50]-J[51]-J[52]+J[53]+J[54]+J[55]+J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+
    J[63]+J[64]+J[65], +H[0]-H[1]-H[2]-H[3]+H[4]-H[5]+H[6]-H[7]-H[8]+H[9]+H[10]-H[11]-J[0]-J[1]-J[2]+J[3]-J[4]+
    J[5]-J[6]-J[7]+J[8]+J[9]-J[10]+J[11]+J[12]-J[13]+J[14]-J[15]+J[16]+J[17]-J[18]-J[19]+J[20]+J[21]-J[22]+
    J[23]-J[24]+J[25]+J[26]-J[27]-J[28]+J[29]-J[30]+J[31]-J[32]+J[33]+J[34]-J[35]-J[36]+J[37]-J[38]+J[39]-J[40]-J[41]+
    J[42]+J[43]-J[44]-J[45]+J[46]+J[47]-J[48]-J[49]+J[50]-J[51]-J[52]+J[53]+J[54]-J[55]+J[56]-J[57]-J[58]+
    J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]-H[1]-H[2]-H[3]+H[4]-H[5]+H[6]-H[7]-H[8]+H[9]-H[10]+
    H[11]-J[0]-J[1]-J[2]+J[3]-J[4]+J[5]-J[6]-J[7]+J[8]-J[9]+J[10]+J[11]+J[12]-J[13]+J[14]-J[15]+J[16]+J[17]-J[18]+
    J[19]-J[20]+J[21]-J[22]+J[23]-J[24]+J[25]+J[26]-J[27]+J[28]-J[29]-J[30]+J[31]-J[32]+J[33]+J[34]-J[35]+
    J[36]-J[37]-J[38]+J[39]-J[40]-J[41]+J[42]-J[43]+J[44]-J[45]+J[46]+J[47]-J[48]+J[49]-J[50]-J[51]-J[52]+
    J[53]-J[54]+J[55]+J[56]-J[57]+J[58]-J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]-H[1]-H[2]-H[3]+
    H[4]-H[5]+H[6]-H[7]-H[8]+H[9]-H[10]-H[11]-J[0]-J[1]-J[2]+J[3]-J[4]+J[5]-J[6]-J[7]+J[8]-J[9]-J[10]+J[11]+
    J[12]-J[13]+J[14]-J[15]+J[16]+J[17]-J[18]+J[19]+J[20]+J[21]-J[22]+J[23]-J[24]+J[25]+J[26]-J[27]+J[28]+
    J[29]-J[30]+J[31]-J[32]+J[33]+J[34]-J[35]+J[36]+J[37]-J[38]+J[39]-J[40]-J[41]+J[42]-J[43]-J[44]-J[45]+
    J[46]+J[47]-J[48]+J[49]+J[50]-J[51]-J[52]+J[53]-J[54]-J[55]+J[56]-J[57]+J[58]+J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+
    J[65], +H[0]-H[1]-H[2]-H[3]+H[4]-H[5]+H[6]-H[7]-H[8]-H[9]+H[10]+H[11]-J[0]-J[1]-J[2]+J[3]-J[4]+J[5]-J[6]-J[7]-J[8]+
    J[9]+J[10]+J[11]+J[12]-J[13]+J[14]-J[15]+J[16]+J[17]+J[18]-J[19]-J[20]+J[21]-J[22]+J[23]-J[24]+J[25]+
    J[26]+J[27]-J[28]-J[29]-J[30]+J[31]-J[32]+J[33]+J[34]+J[35]-J[36]-J[37]-J[38]+J[39]-J[40]-J[41]-J[42]+
    J[43]+J[44]-J[45]+J[46]+J[47]+J[48]-J[49]-J[50]-J[51]-J[52]-J[53]+J[54]+J[55]+J[56]+J[57]-J[58]-J[59]+
    J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]-H[1]-H[2]-H[3]+H[4]-H[5]+H[6]-H[7]-H[8]-H[9]+H[10]-H[11]-J[0]-J[1]-J[2]+
    J[3]-J[4]+J[5]-J[6]-J[7]-J[8]+J[9]-J[10]+J[11]+J[12]-J[13]+J[14]-J[15]+J[16]+J[17]+J[18]-J[19]+J[20]+
    J[21]-J[22]+J[23]-J[24]+J[25]+J[26]+J[27]-J[28]+J[29]-J[30]+J[31]-J[32]+J[33]+J[34]+J[35]-J[36]+J[37]-J[38]+
    J[39]-J[40]-J[41]-J[42]+J[43]-J[44]-J[45]+J[46]+J[47]+J[48]-J[49]+J[50]-J[51]-J[52]-J[53]+J[54]-J[55]+
    J[56]+J[57]-J[58]+J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]-H[1]-H[2]-H[3]+H[4]-H[5]+H[6]-H[7]-H[8]-H[9]-H[10]+
    H[11]-J[0]-J[1]-J[2]+J[3]-J[4]+J[5]-J[6]-J[7]-J[8]-J[9]+J[10]+J[11]+J[12]-J[13]+J[14]-J[15]+J[16]+J[17]+
    J[18]+J[19]-J[20]+J[21]-J[22]+J[23]-J[24]+J[25]+J[26]+J[27]+J[28]-J[29]-J[30]+J[31]-J[32]+J[33]+J[34]+
    J[35]+J[36]-J[37]-J[38]+J[39]-J[40]-J[41]-J[42]-J[43]+J[44]-J[45]+J[46]+J[47]+J[48]+J[49]-J[50]-J[51]-J[52]-J[53]-J[54]+
    J[55]+J[56]+J[57]+J[58]-J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]-H[1]-H[2]-H[3]+H[4]-H[5]+H[6]-H[7]-H[8]-H[9]-H[10]-H[11]-J[0]-J[1]-J[2]+
    J[3]-J[4]+J[5]-J[6]-J[7]-J[8]-J[9]-J[10]+J[11]+J[12]-J[13]+J[14]-J[15]+J[16]+J[17]+J[18]+J[19]+J[20]+
    J[21]-J[22]+J[23]-J[24]+J[25]+J[26]+J[27]+J[28]+J[29]-J[30]+J[31]-J[32]+J[33]+J[34]+J[35]+J[36]+J[37]-J[38]+
    J[39]-J[40]-J[41]-J[42]-J[43]-J[44]-J[45]+J[46]+J[47]+J[48]+J[49]+J[50]-J[51]-J[52]-J[53]-J[54]-J[55]+
    J[56]+J[57]+J[58]+J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]-H[1]-H[2]-H[3]+H[4]-H[5]-H[6]+H[7]+
    H[8]+H[9]+H[10]+H[11]-J[0]-J[1]-J[2]+J[3]-J[4]-J[5]+J[6]+J[7]+J[8]+J[9]+J[10]+J[11]+J[12]-J[13]+J[14]+
    J[15]-J[16]-J[17]-J[18]-J[19]-J[20]+J[21]-J[22]+J[23]+J[24]-J[25]-J[26]-J[27]-J[28]-J[29]-J[30]+J[31]+
    J[32]-J[33]-J[34]-J[35]-J[36]-J[37]-J[38]-J[39]+J[40]+J[41]+J[42]+J[43]+J[44]+J[45]-J[46]-J[47]-J[48]-J[49]-J[50]-J[51]-J[52]-J[53]-J[54]-J[55]+
    J[56]+J[57]+J[58]+J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]-H[1]-H[2]-H[3]+H[4]-H[5]-H[6]+H[7]+
    H[8]+H[9]+H[10]-H[11]-J[0]-J[1]-J[2]+J[3]-J[4]-J[5]+J[6]+J[7]+J[8]+J[9]-J[10]+J[11]+J[12]-J[13]+J[14]+
    J[15]-J[16]-J[17]-J[18]-J[19]+J[20]+J[21]-J[22]+J[23]+J[24]-J[25]-J[26]-J[27]-J[28]+J[29]-J[30]+J[31]+
    J[32]-J[33]-J[34]-J[35]-J[36]+J[37]-J[38]-J[39]+J[40]+J[41]+J[42]+J[43]-J[44]+J[45]-J[46]-J[47]-J[48]-J[49]+
    J[50]-J[51]-J[52]-J[53]-J[54]+J[55]+J[56]+J[57]+J[58]-J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]-H[1]-H[2]-H[3]+
    H[4]-H[5]-H[6]+H[7]+H[8]+H[9]-H[10]+H[11]-J[0]-J[1]-J[2]+J[3]-J[4]-J[5]+J[6]+J[7]+J[8]-J[9]+J[10]+J[11]+
    J[12]-J[13]+J[14]+J[15]-J[16]-J[17]-J[18]+J[19]-J[20]+J[21]-J[22]+J[23]+J[24]-J[25]-J[26]-J[27]+J[28]-J[29]-J[30]+
    J[31]+J[32]-J[33]-J[34]-J[35]+J[36]-J[37]-J[38]-J[39]+J[40]+J[41]+J[42]-J[43]+J[44]+J[45]-J[46]-J[47]-J[48]+
    J[49]-J[50]-J[51]-J[52]-J[53]+J[54]-J[55]+J[56]+J[57]-J[58]+J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +
    H[0]-H[1]-H[2]-H[3]+H[4]-H[5]-H[6]+H[7]+H[8]+H[9]-H[10]-H[11]-J[0]-J[1]-J[2]+J[3]-J[4]-J[5]+J[6]+J[7]+
    J[8]-J[9]-J[10]+J[11]+J[12]-J[13]+J[14]+J[15]-J[16]-J[17]-J[18]+J[19]+J[20]+J[21]-J[22]+J[23]+J[24]-J[25]-J[26]-J[27]+
    J[28]+J[29]-J[30]+J[31]+J[32]-J[33]-J[34]-J[35]+J[36]+J[37]-J[38]-J[39]+J[40]+J[41]+J[42]-J[43]-J[44]+
    J[45]-J[46]-J[47]-J[48]+J[49]+J[50]-J[51]-J[52]-J[53]+J[54]+J[55]+J[56]+J[57]-J[58]-J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+
    J[65], +H[0]-H[1]-H[2]-H[3]+H[4]-H[5]-H[6]+H[7]+H[8]-H[9]+H[10]+H[11]-J[0]-J[1]-J[2]+J[3]-J[4]-J[5]+
    J[6]+J[7]-J[8]+J[9]+J[10]+J[11]+J[12]-J[13]+J[14]+J[15]-J[16]-J[17]+J[18]-J[19]-J[20]+J[21]-J[22]+J[23]+
    J[24]-J[25]-J[26]+J[27]-J[28]-J[29]-J[30]+J[31]+J[32]-J[33]-J[34]+J[35]-J[36]-J[37]-J[38]-J[39]+J[40]+
    J[41]-J[42]+J[43]+J[44]+J[45]-J[46]-J[47]+J[48]-J[49]-J[50]-J[51]-J[52]+J[53]-J[54]-J[55]+J[56]-J[57]+
    J[58]+J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]-H[1]-H[2]-H[3]+H[4]-H[5]-H[6]+H[7]+H[8]-H[9]+
    H[10]-H[11]-J[0]-J[1]-J[2]+J[3]-J[4]-J[5]+J[6]+J[7]-J[8]+J[9]-J[10]+J[11]+J[12]-J[13]+J[14]+J[15]-J[16]-J[17]+
    J[18]-J[19]+J[20]+J[21]-J[22]+J[23]+J[24]-J[25]-J[26]+J[27]-J[28]+J[29]-J[30]+J[31]+J[32]-J[33]-J[34]+
    J[35]-J[36]+J[37]-J[38]-J[39]+J[40]+J[41]-J[42]+J[43]-J[44]+J[45]-J[46]-J[47]+J[48]-J[49]+J[50]-J[51]-J[52]+
    J[53]-J[54]+J[55]+J[56]-J[57]+J[58]-J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]-H[1]-H[2]-H[3]+
    H[4]-H[5]-H[6]+H[7]+H[8]-H[9]-H[10]+H[11]-J[0]-J[1]-J[2]+J[3]-J[4]-J[5]+J[6]+J[7]-J[8]-J[9]+J[10]+J[11]+
    J[12]-J[13]+J[14]+J[15]-J[16]-J[17]+J[18]+J[19]-J[20]+J[21]-J[22]+J[23]+J[24]-J[25]-J[26]+J[27]+J[28]-J[29]-J[30]+
    J[31]+J[32]-J[33]-J[34]+J[35]+J[36]-J[37]-J[38]-J[39]+J[40]+J[41]-J[42]-J[43]+J[44]+J[45]-J[46]-J[47]+
    J[48]+J[49]-J[50]-J[51]-J[52]+J[53]+J[54]-J[55]+J[56]-J[57]-J[58]+J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +
    H[0]-H[1]-H[2]-H[3]+H[4]-H[5]-H[6]+H[7]+H[8]-H[9]-H[10]-H[11]-J[0]-J[1]-J[2]+J[3]-J[4]-J[5]+J[6]+J[7]-J[8]-J[9]-J[10]+
    J[11]+J[12]-J[13]+J[14]+J[15]-J[16]-J[17]+J[18]+J[19]+J[20]+J[21]-J[22]+J[23]+J[24]-J[25]-J[26]+J[27]+
    J[28]+J[29]-J[30]+J[31]+J[32]-J[33]-J[34]+J[35]+J[36]+J[37]-J[38]-J[39]+J[40]+J[41]-J[42]-J[43]-J[44]+
    J[45]-J[46]-J[47]+J[48]+J[49]+J[50]-J[51]-J[52]+J[53]+J[54]+J[55]+J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+
    J[63]+J[64]+J[65], +H[0]-H[1]-H[2]-H[3]+H[4]-H[5]-H[6]+H[7]-H[8]+H[9]+H[10]+H[11]-J[0]-J[1]-J[2]+J[3]-J[4]-J[5]+
    J[6]-J[7]+J[8]+J[9]+J[10]+J[11]+J[12]-J[13]+J[14]+J[15]-J[16]+J[17]-J[18]-J[19]-J[20]+J[21]-J[22]+J[23]+
    J[24]-J[25]+J[26]-J[27]-J[28]-J[29]-J[30]+J[31]+J[32]-J[33]+J[34]-J[35]-J[36]-J[37]-J[38]-J[39]+J[40]-J[41]+
    J[42]+J[43]+J[44]+J[45]-J[46]+J[47]-J[48]-J[49]-J[50]-J[51]+J[52]-J[53]-J[54]-J[55]-J[56]+J[57]+J[58]+
    J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]-H[1]-H[2]-H[3]+H[4]-H[5]-H[6]+H[7]-H[8]+H[9]+H[10]-H[11]-J[0]-J[1]-J[2]+
    J[3]-J[4]-J[5]+J[6]-J[7]+J[8]+J[9]-J[10]+J[11]+J[12]-J[13]+J[14]+J[15]-J[16]+J[17]-J[18]-J[19]+J[20]+
    J[21]-J[22]+J[23]+J[24]-J[25]+J[26]-J[27]-J[28]+J[29]-J[30]+J[31]+J[32]-J[33]+J[34]-J[35]-J[36]+J[37]-J[38]-J[39]+
    J[40]-J[41]+J[42]+J[43]-J[44]+J[45]-J[46]+J[47]-J[48]-J[49]+J[50]-J[51]+J[52]-J[53]-J[54]+J[55]-J[56]+
    J[57]+J[58]-J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]-H[1]-H[2]-H[3]+H[4]-H[5]-H[6]+H[7]-H[8]+
    H[9]-H[10]+H[11]-J[0]-J[1]-J[2]+J[3]-J[4]-J[5]+J[6]-J[7]+J[8]-J[9]+J[10]+J[11]+J[12]-J[13]+J[14]+J[15]-J[16]+
    J[17]-J[18]+J[19]-J[20]+J[21]-J[22]+J[23]+J[24]-J[25]+J[26]-J[27]+J[28]-J[29]-J[30]+J[31]+J[32]-J[33]+
    J[34]-J[35]+J[36]-J[37]-J[38]-J[39]+J[40]-J[41]+J[42]-J[43]+J[44]+J[45]-J[46]+J[47]-J[48]+J[49]-J[50]-J[51]+
    J[52]-J[53]+J[54]-J[55]-J[56]+J[57]-J[58]+J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]-H[1]-H[2]-H[3]+
    H[4]-H[5]-H[6]+H[7]-H[8]+H[9]-H[10]-H[11]-J[0]-J[1]-J[2]+J[3]-J[4]-J[5]+J[6]-J[7]+J[8]-J[9]-J[10]+J[11]+
    J[12]-J[13]+J[14]+J[15]-J[16]+J[17]-J[18]+J[19]+J[20]+J[21]-J[22]+J[23]+J[24]-J[25]+J[26]-J[27]+J[28]+
    J[29]-J[30]+J[31]+J[32]-J[33]+J[34]-J[35]+J[36]+J[37]-J[38]-J[39]+J[40]-J[41]+J[42]-J[43]-J[44]+J[45]-J[46]+
    J[47]-J[48]+J[49]+J[50]-J[51]+J[52]-J[53]+J[54]+J[55]-J[56]+J[57]-J[58]-J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+
    J[65], +H[0]-H[1]-H[2]-H[3]+H[4]-H[5]-H[6]+H[7]-H[8]-H[9]+H[10]+H[11]-J[0]-J[1]-J[2]+J[3]-J[4]-J[5]+
    J[6]-J[7]-J[8]+J[9]+J[10]+J[11]+J[12]-J[13]+J[14]+J[15]-J[16]+J[17]+J[18]-J[19]-J[20]+J[21]-J[22]+J[23]+
    J[24]-J[25]+J[26]+J[27]-J[28]-J[29]-J[30]+J[31]+J[32]-J[33]+J[34]+J[35]-J[36]-J[37]-J[38]-J[39]+J[40]-J[41]-J[42]+
    J[43]+J[44]+J[45]-J[46]+J[47]+J[48]-J[49]-J[50]-J[51]+J[52]+J[53]-J[54]-J[55]-J[56]-J[57]+J[58]+J[59]+
    J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]-H[1]-H[2]-H[3]+H[4]-H[5]-H[6]+H[7]-H[8]-H[9]+H[10]-H[11]-J[0]-J[1]-J[2]+
    J[3]-J[4]-J[5]+J[6]-J[7]-J[8]+J[9]-J[10]+J[11]+J[12]-J[13]+J[14]+J[15]-J[16]+J[17]+J[18]-J[19]+J[20]+
    J[21]-J[22]+J[23]+J[24]-J[25]+J[26]+J[27]-J[28]+J[29]-J[30]+J[31]+J[32]-J[33]+J[34]+J[35]-J[36]+J[37]-J[38]-J[39]+
    J[40]-J[41]-J[42]+J[43]-J[44]+J[45]-J[46]+J[47]+J[48]-J[49]+J[50]-J[51]+J[52]+J[53]-J[54]+J[55]-J[56]-J[57]+
    J[58]-J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]-H[1]-H[2]-H[3]+H[4]-H[5]-H[6]+H[7]-H[8]-H[9]-H[10]+
    H[11]-J[0]-J[1]-J[2]+J[3]-J[4]-J[5]+J[6]-J[7]-J[8]-J[9]+J[10]+J[11]+J[12]-J[13]+J[14]+J[15]-J[16]+J[17]+
    J[18]+J[19]-J[20]+J[21]-J[22]+J[23]+J[24]-J[25]+J[26]+J[27]+J[28]-J[29]-J[30]+J[31]+J[32]-J[33]+J[34]+
    J[35]+J[36]-J[37]-J[38]-J[39]+J[40]-J[41]-J[42]-J[43]+J[44]+J[45]-J[46]+J[47]+J[48]+J[49]-J[50]-J[51]+
    J[52]+J[53]+J[54]-J[55]-J[56]-J[57]-J[58]+J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]-H[1]-H[2]-H[3]+
    H[4]-H[5]-H[6]+H[7]-H[8]-H[9]-H[10]-H[11]-J[0]-J[1]-J[2]+J[3]-J[4]-J[5]+J[6]-J[7]-J[8]-J[9]-J[10]+J[11]+
    J[12]-J[13]+J[14]+J[15]-J[16]+J[17]+J[18]+J[19]+J[20]+J[21]-J[22]+J[23]+J[24]-J[25]+J[26]+J[27]+J[28]+
    J[29]-J[30]+J[31]+J[32]-J[33]+J[34]+J[35]+J[36]+J[37]-J[38]-J[39]+J[40]-J[41]-J[42]-J[43]-J[44]+J[45]-J[46]+
    J[47]+J[48]+J[49]+J[50]-J[51]+J[52]+J[53]+J[54]+J[55]-J[56]-J[57]-J[58]-J[59]+J[60]+J[61]+J[62]+J[63]+
    J[64]+J[65], +H[0]-H[1]-H[2]-H[3]+H[4]-H[5]-H[6]-H[7]+H[8]+H[9]+H[10]+H[11]-J[0]-J[1]-J[2]+J[3]-J[4]-J[5]-J[6]+
    J[7]+J[8]+J[9]+J[10]+J[11]+J[12]-J[13]+J[14]+J[15]+J[16]-J[17]-J[18]-J[19]-J[20]+J[21]-J[22]+J[23]+J[24]+
    J[25]-J[26]-J[27]-J[28]-J[29]-J[30]+J[31]+J[32]+J[33]-J[34]-J[35]-J[36]-J[37]-J[38]-J[39]-J[40]+J[41]+
    J[42]+J[43]+J[44]+J[45]+J[46]-J[47]-J[48]-J[49]-J[50]+J[51]-J[52]-J[53]-J[54]-J[55]-J[56]-J[57]-J[58]-J[59]+
    J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]-H[1]-H[2]-H[3]+H[4]-H[5]-H[6]-H[7]+H[8]+H[9]+H[10]-H[11]-J[0]-J[1]-J[2]+
    J[3]-J[4]-J[5]-J[6]+J[7]+J[8]+J[9]-J[10]+J[11]+J[12]-J[13]+J[14]+J[15]+J[16]-J[17]-J[18]-J[19]+J[20]+
    J[21]-J[22]+J[23]+J[24]+J[25]-J[26]-J[27]-J[28]+J[29]-J[30]+J[31]+J[32]+J[33]-J[34]-J[35]-J[36]+J[37]-J[38]-J[39]-J[40]+
    J[41]+J[42]+J[43]-J[44]+J[45]+J[46]-J[47]-J[48]-J[49]+J[50]+J[51]-J[52]-J[53]-J[54]+J[55]-J[56]-J[57]-J[58]+
    J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]-H[1]-H[2]-H[3]+H[4]-H[5]-H[6]-H[7]+H[8]+H[9]-H[10]+
    H[11]-J[0]-J[1]-J[2]+J[3]-J[4]-J[5]-J[6]+J[7]+J[8]-J[9]+J[10]+J[11]+J[12]-J[13]+J[14]+J[15]+J[16]-J[17]-J[18]+
    J[19]-J[20]+J[21]-J[22]+J[23]+J[24]+J[25]-J[26]-J[27]+J[28]-J[29]-J[30]+J[31]+J[32]+J[33]-J[34]-J[35]+
    J[36]-J[37]-J[38]-J[39]-J[40]+J[41]+J[42]-J[43]+J[44]+J[45]+J[46]-J[47]-J[48]+J[49]-J[50]+J[51]-J[52]-J[53]+
    J[54]-J[55]-J[56]-J[57]+J[58]-J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]-H[1]-H[2]-H[3]+H[4]-H[5]-H[6]-H[7]+
    H[8]+H[9]-H[10]-H[11]-J[0]-J[1]-J[2]+J[3]-J[4]-J[5]-J[6]+J[7]+J[8]-J[9]-J[10]+J[11]+J[12]-J[13]+J[14]+
    J[15]+J[16]-J[17]-J[18]+J[19]+J[20]+J[21]-J[22]+J[23]+J[24]+J[25]-J[26]-J[27]+J[28]+J[29]-J[30]+J[31]+
    J[32]+J[33]-J[34]-J[35]+J[36]+J[37]-J[38]-J[39]-J[40]+J[41]+J[42]-J[43]-J[44]+J[45]+J[46]-J[47]-J[48]+
    J[49]+J[50]+J[51]-J[52]-J[53]+J[54]+J[55]-J[56]-J[57]+J[58]+J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +
    H[0]-H[1]-H[2]-H[3]+H[4]-H[5]-H[6]-H[7]+H[8]-H[9]+H[10]+H[11]-J[0]-J[1]-J[2]+J[3]-J[4]-J[5]-J[6]+J[7]-J[8]+
    J[9]+J[10]+J[11]+J[12]-J[13]+J[14]+J[15]+J[16]-J[17]+J[18]-J[19]-J[20]+J[21]-J[22]+J[23]+J[24]+J[25]-J[26]+
    J[27]-J[28]-J[29]-J[30]+J[31]+J[32]+J[33]-J[34]+J[35]-J[36]-J[37]-J[38]-J[39]-J[40]+J[41]-J[42]+J[43]+
    J[44]+J[45]+J[46]-J[47]+J[48]-J[49]-J[50]+J[51]-J[52]+J[53]-J[54]-J[55]-J[56]+J[57]-J[58]-J[59]-J[60]+
    J[61]+J[62]-J[63]-J[64]+J[65], +H[0]-H[1]-H[2]-H[3]+H[4]-H[5]-H[6]-H[7]+H[8]-H[9]+H[10]-H[11]-J[0]-J[1]-J[2]+
    J[3]-J[4]-J[5]-J[6]+J[7]-J[8]+J[9]-J[10]+J[11]+J[12]-J[13]+J[14]+J[15]+J[16]-J[17]+J[18]-J[19]+J[20]+
    J[21]-J[22]+J[23]+J[24]+J[25]-J[26]+J[27]-J[28]+J[29]-J[30]+J[31]+J[32]+J[33]-J[34]+J[35]-J[36]+J[37]-J[38]-J[39]-J[40]+
    J[41]-J[42]+J[43]-J[44]+J[45]+J[46]-J[47]+J[48]-J[49]+J[50]+J[51]-J[52]+J[53]-J[54]+J[55]-J[56]+J[57]-J[58]+
    J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]-H[1]-H[2]-H[3]+H[4]-H[5]-H[6]-H[7]+H[8]-H[9]-H[10]+
    H[11]-J[0]-J[1]-J[2]+J[3]-J[4]-J[5]-J[6]+J[7]-J[8]-J[9]+J[10]+J[11]+J[12]-J[13]+J[14]+J[15]+J[16]-J[17]+
    J[18]+J[19]-J[20]+J[21]-J[22]+J[23]+J[24]+J[25]-J[26]+J[27]+J[28]-J[29]-J[30]+J[31]+J[32]+J[33]-J[34]+
    J[35]+J[36]-J[37]-J[38]-J[39]-J[40]+J[41]-J[42]-J[43]+J[44]+J[45]+J[46]-J[47]+J[48]+J[49]-J[50]+J[51]-J[52]+
    J[53]+J[54]-J[55]-J[56]+J[57]+J[58]-J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]-H[1]-H[2]-H[3]+
    H[4]-H[5]-H[6]-H[7]+H[8]-H[9]-H[10]-H[11]-J[0]-J[1]-J[2]+J[3]-J[4]-J[5]-J[6]+J[7]-J[8]-J[9]-J[10]+J[11]+
    J[12]-J[13]+J[14]+J[15]+J[16]-J[17]+J[18]+J[19]+J[20]+J[21]-J[22]+J[23]+J[24]+J[25]-J[26]+J[27]+J[28]+
    J[29]-J[30]+J[31]+J[32]+J[33]-J[34]+J[35]+J[36]+J[37]-J[38]-J[39]-J[40]+J[41]-J[42]-J[43]-J[44]+J[45]+
    J[46]-J[47]+J[48]+J[49]+J[50]+J[51]-J[52]+J[53]+J[54]+J[55]-J[56]+J[57]+J[58]+J[59]-J[60]-J[61]-J[62]+
    J[63]+J[64]+J[65], +H[0]-H[1]-H[2]-H[3]+H[4]-H[5]-H[6]-H[7]-H[8]+H[9]+H[10]+H[11]-J[0]-J[1]-J[2]+J[3]-J[4]-J[5]-J[6]-J[7]+
    J[8]+J[9]+J[10]+J[11]+J[12]-J[13]+J[14]+J[15]+J[16]+J[17]-J[18]-J[19]-J[20]+J[21]-J[22]+J[23]+J[24]+
    J[25]+J[26]-J[27]-J[28]-J[29]-J[30]+J[31]+J[32]+J[33]+J[34]-J[35]-J[36]-J[37]-J[38]-J[39]-J[40]-J[41]+
    J[42]+J[43]+J[44]+J[45]+J[46]+J[47]-J[48]-J[49]-J[50]+J[51]+J[52]-J[53]-J[54]-J[55]+J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+
    J[63]+J[64]+J[65], +H[0]-H[1]-H[2]-H[3]+H[4]-H[5]-H[6]-H[7]-H[8]+H[9]+H[10]-H[11]-J[0]-J[1]-J[2]+J[3]-J[4]-J[5]-J[6]-J[7]+
    J[8]+J[9]-J[10]+J[11]+J[12]-J[13]+J[14]+J[15]+J[16]+J[17]-J[18]-J[19]+J[20]+J[21]-J[22]+J[23]+J[24]+
    J[25]+J[26]-J[27]-J[28]+J[29]-J[30]+J[31]+J[32]+J[33]+J[34]-J[35]-J[36]+J[37]-J[38]-J[39]-J[40]-J[41]+
    J[42]+J[43]-J[44]+J[45]+J[46]+J[47]-J[48]-J[49]+J[50]+J[51]+J[52]-J[53]-J[54]+J[55]+J[56]-J[57]-J[58]+
    J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]-H[1]-H[2]-H[3]+H[4]-H[5]-H[6]-H[7]-H[8]+H[9]-H[10]+
    H[11]-J[0]-J[1]-J[2]+J[3]-J[4]-J[5]-J[6]-J[7]+J[8]-J[9]+J[10]+J[11]+J[12]-J[13]+J[14]+J[15]+J[16]+J[17]-J[18]+
    J[19]-J[20]+J[21]-J[22]+J[23]+J[24]+J[25]+J[26]-J[27]+J[28]-J[29]-J[30]+J[31]+J[32]+J[33]+J[34]-J[35]+
    J[36]-J[37]-J[38]-J[39]-J[40]-J[41]+J[42]-J[43]+J[44]+J[45]+J[46]+J[47]-J[48]+J[49]-J[50]+J[51]+J[52]-J[53]+
    J[54]-J[55]+J[56]-J[57]+J[58]-J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]-H[1]-H[2]-H[3]+H[4]-H[5]-H[6]-H[7]-H[8]+
    H[9]-H[10]-H[11]-J[0]-J[1]-J[2]+J[3]-J[4]-J[5]-J[6]-J[7]+J[8]-J[9]-J[10]+J[11]+J[12]-J[13]+J[14]+J[15]+
    J[16]+J[17]-J[18]+J[19]+J[20]+J[21]-J[22]+J[23]+J[24]+J[25]+J[26]-J[27]+J[28]+J[29]-J[30]+J[31]+J[32]+
    J[33]+J[34]-J[35]+J[36]+J[37]-J[38]-J[39]-J[40]-J[41]+J[42]-J[43]-J[44]+J[45]+J[46]+J[47]-J[48]+J[49]+
    J[50]+J[51]+J[52]-J[53]+J[54]+J[55]+J[56]-J[57]+J[58]+J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]-H[1]-H[2]-H[3]+
    H[4]-H[5]-H[6]-H[7]-H[8]-H[9]+H[10]+H[11]-J[0]-J[1]-J[2]+J[3]-J[4]-J[5]-J[6]-J[7]-J[8]+J[9]+J[10]+J[11]+
    J[12]-J[13]+J[14]+J[15]+J[16]+J[17]+J[18]-J[19]-J[20]+J[21]-J[22]+J[23]+J[24]+J[25]+J[26]+J[27]-J[28]-J[29]-J[30]+
    J[31]+J[32]+J[33]+J[34]+J[35]-J[36]-J[37]-J[38]-J[39]-J[40]-J[41]-J[42]+J[43]+J[44]+J[45]+J[46]+J[47]+
    J[48]-J[49]-J[50]+J[51]+J[52]+J[53]-J[54]-J[55]+J[56]+J[57]-J[58]-J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+
    J[65], +H[0]-H[1]-H[2]-H[3]+H[4]-H[5]-H[6]-H[7]-H[8]-H[9]+H[10]-H[11]-J[0]-J[1]-J[2]+J[3]-J[4]-J[5]-J[6]-J[7]-J[8]+
    J[9]-J[10]+J[11]+J[12]-J[13]+J[14]+J[15]+J[16]+J[17]+J[18]-J[19]+J[20]+J[21]-J[22]+J[23]+J[24]+J[25]+
    J[26]+J[27]-J[28]+J[29]-J[30]+J[31]+J[32]+J[33]+J[34]+J[35]-J[36]+J[37]-J[38]-J[39]-J[40]-J[41]-J[42]+
    J[43]-J[44]+J[45]+J[46]+J[47]+J[48]-J[49]+J[50]+J[51]+J[52]+J[53]-J[54]+J[55]+J[56]+J[57]-J[58]+J[59]+
    J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]-H[1]-H[2]-H[3]+H[4]-H[5]-H[6]-H[7]-H[8]-H[9]-H[10]+H[11]-J[0]-J[1]-J[2]+
    J[3]-J[4]-J[5]-J[6]-J[7]-J[8]-J[9]+J[10]+J[11]+J[12]-J[13]+J[14]+J[15]+J[16]+J[17]+J[18]+J[19]-J[20]+
    J[21]-J[22]+J[23]+J[24]+J[25]+J[26]+J[27]+J[28]-J[29]-J[30]+J[31]+J[32]+J[33]+J[34]+J[35]+J[36]-J[37]-J[38]-J[39]-J[40]-J[41]-J[42]-J[43]+
    J[44]+J[45]+J[46]+J[47]+J[48]+J[49]-J[50]+J[51]+J[52]+J[53]+J[54]-J[55]+J[56]+J[57]+J[58]-J[59]+J[60]+
    J[61]-J[62]+J[63]-J[64]-J[65], +H[0]-H[1]-H[2]-H[3]+H[4]-H[5]-H[6]-H[7]-H[8]-H[9]-H[10]-H[11]-J[0]-J[1]-J[2]+
    J[3]-J[4]-J[5]-J[6]-J[7]-J[8]-J[9]-J[10]+J[11]+J[12]-J[13]+J[14]+J[15]+J[16]+J[17]+J[18]+J[19]+J[20]+
    J[21]-J[22]+J[23]+J[24]+J[25]+J[26]+J[27]+J[28]+J[29]-J[30]+J[31]+J[32]+J[33]+J[34]+J[35]+J[36]+J[37]-J[38]-J[39]-J[40]-J[41]-J[42]-J[43]-J[44]+
    J[45]+J[46]+J[47]+J[48]+J[49]+J[50]+J[51]+J[52]+J[53]+J[54]+J[55]+J[56]+J[57]+J[58]+J[59]+J[60]+J[61]+
    J[62]+J[63]+J[64]+J[65], +H[0]-H[1]-H[2]-H[3]-H[4]+H[5]+H[6]+H[7]+H[8]+H[9]+H[10]+H[11]-J[0]-J[1]-J[2]-J[3]+
    J[4]+J[5]+J[6]+J[7]+J[8]+J[9]+J[10]+J[11]+J[12]+J[13]-J[14]-J[15]-J[16]-J[17]-J[18]-J[19]-J[20]+J[21]+
    J[22]-J[23]-J[24]-J[25]-J[26]-J[27]-J[28]-J[29]+J[30]-J[31]-J[32]-J[33]-J[34]-J[35]-J[36]-J[37]-J[38]-J[39]-J[40]-J[41]-J[42]-J[43]-J[44]+
    J[45]+J[46]+J[47]+J[48]+J[49]+J[50]+J[51]+J[52]+J[53]+J[54]+J[55]+J[56]+J[57]+J[58]+J[59]+J[60]+J[61]+
    J[62]+J[63]+J[64]+J[65], +H[0]-H[1]-H[2]-H[3]-H[4]+H[5]+H[6]+H[7]+H[8]+H[9]+H[10]-H[11]-J[0]-J[1]-J[2]-J[3]+
    J[4]+J[5]+J[6]+J[7]+J[8]+J[9]-J[10]+J[11]+J[12]+J[13]-J[14]-J[15]-J[16]-J[17]-J[18]-J[19]+J[20]+J[21]+
    J[22]-J[23]-J[24]-J[25]-J[26]-J[27]-J[28]+J[29]+J[30]-J[31]-J[32]-J[33]-J[34]-J[35]-J[36]+J[37]-J[38]-J[39]-J[40]-J[41]-J[42]-J[43]+
    J[44]+J[45]+J[46]+J[47]+J[48]+J[49]-J[50]+J[51]+J[52]+J[53]+J[54]-J[55]+J[56]+J[57]+J[58]-J[59]+J[60]+
    J[61]-J[62]+J[63]-J[64]-J[65], +H[0]-H[1]-H[2]-H[3]-H[4]+H[5]+H[6]+H[7]+H[8]+H[9]-H[10]+H[11]-J[0]-J[1]-J[2]-J[3]+
    J[4]+J[5]+J[6]+J[7]+J[8]-J[9]+J[10]+J[11]+J[12]+J[13]-J[14]-J[15]-J[16]-J[17]-J[18]+J[19]-J[20]+J[21]+
    J[22]-J[23]-J[24]-J[25]-J[26]-J[27]+J[28]-J[29]+J[30]-J[31]-J[32]-J[33]-J[34]-J[35]+J[36]-J[37]-J[38]-J[39]-J[40]-J[41]-J[42]+
    J[43]-J[44]+J[45]+J[46]+J[47]+J[48]-J[49]+J[50]+J[51]+J[52]+J[53]-J[54]+J[55]+J[56]+J[57]-J[58]+J[59]+
    J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]-H[1]-H[2]-H[3]-H[4]+H[5]+H[6]+H[7]+H[8]+H[9]-H[10]-H[11]-J[0]-J[1]-J[2]-J[3]+
    J[4]+J[5]+J[6]+J[7]+J[8]-J[9]-J[10]+J[11]+J[12]+J[13]-J[14]-J[15]-J[16]-J[17]-J[18]+J[19]+J[20]+J[21]+
    J[22]-J[23]-J[24]-J[25]-J[26]-J[27]+J[28]+J[29]+J[30]-J[31]-J[32]-J[33]-J[34]-J[35]+J[36]+J[37]-J[38]-J[39]-J[40]-J[41]-J[42]+
    J[43]+J[44]+J[45]+J[46]+J[47]+J[48]-J[49]-J[50]+J[51]+J[52]+J[53]-J[54]-J[55]+J[56]+J[57]-J[58]-J[59]+
    J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]-H[1]-H[2]-H[3]-H[4]+H[5]+H[6]+H[7]+H[8]-H[9]+H[10]+H[11]-J[0]-J[1]-J[2]-J[3]+
    J[4]+J[5]+J[6]+J[7]-J[8]+J[9]+J[10]+J[11]+J[12]+J[13]-J[14]-J[15]-J[16]-J[17]+J[18]-J[19]-J[20]+J[21]+
    J[22]-J[23]-J[24]-J[25]-J[26]+J[27]-J[28]-J[29]+J[30]-J[31]-J[32]-J[33]-J[34]+J[35]-J[36]-J[37]-J[38]-J[39]-J[40]-J[41]+
    J[42]-J[43]-J[44]+J[45]+J[46]+J[47]-J[48]+J[49]+J[50]+J[51]+J[52]-J[53]+J[54]+J[55]+J[56]-J[57]+J[58]+
    J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]-H[1]-H[2]-H[3]-H[4]+H[5]+H[6]+H[7]+H[8]-H[9]+H[10]-H[11]-J[0]-J[1]-J[2]-J[3]+
    J[4]+J[5]+J[6]+J[7]-J[8]+J[9]-J[10]+J[11]+J[12]+J[13]-J[14]-J[15]-J[16]-J[17]+J[18]-J[19]+J[20]+J[21]+
    J[22]-J[23]-J[24]-J[25]-J[26]+J[27]-J[28]+J[29]+J[30]-J[31]-J[32]-J[33]-J[34]+J[35]-J[36]+J[37]-J[38]-J[39]-J[40]-J[41]+
    J[42]-J[43]+J[44]+J[45]+J[46]+J[47]-J[48]+J[49]-J[50]+J[51]+J[52]-J[53]+J[54]-J[55]+J[56]-J[57]+J[58]-J[59]-J[60]+
    J[61]-J[62]-J[63]+J[64]-J[65], +H[0]-H[1]-H[2]-H[3]-H[4]+H[5]+H[6]+H[7]+H[8]-H[9]-H[10]+H[11]-J[0]-J[1]-J[2]-J[3]+
    J[4]+J[5]+J[6]+J[7]-J[8]-J[9]+J[10]+J[11]+J[12]+J[13]-J[14]-J[15]-J[16]-J[17]+J[18]+J[19]-J[20]+J[21]+
    J[22]-J[23]-J[24]-J[25]-J[26]+J[27]+J[28]-J[29]+J[30]-J[31]-J[32]-J[33]-J[34]+J[35]+J[36]-J[37]-J[38]-J[39]-J[40]-J[41]+
    J[42]+J[43]-J[44]+J[45]+J[46]+J[47]-J[48]-J[49]+J[50]+J[51]+J[52]-J[53]-J[54]+J[55]+J[56]-J[57]-J[58]+
    J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]-H[1]-H[2]-H[3]-H[4]+H[5]+H[6]+H[7]+H[8]-H[9]-H[10]-H[11]-J[0]-J[1]-J[2]-J[3]+
    J[4]+J[5]+J[6]+J[7]-J[8]-J[9]-J[10]+J[11]+J[12]+J[13]-J[14]-J[15]-J[16]-J[17]+J[18]+J[19]+J[20]+J[21]+
    J[22]-J[23]-J[24]-J[25]-J[26]+J[27]+J[28]+J[29]+J[30]-J[31]-J[32]-J[33]-J[34]+J[35]+J[36]+J[37]-J[38]-J[39]-J[40]-J[41]+
    J[42]+J[43]+J[44]+J[45]+J[46]+J[47]-J[48]-J[49]-J[50]+J[51]+J[52]-J[53]-J[54]-J[55]+J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+
    J[63]+J[64]+J[65], +H[0]-H[1]-H[2]-H[3]-H[4]+H[5]+H[6]+H[7]-H[8]+H[9]+H[10]+H[11]-J[0]-J[1]-J[2]-J[3]+
    J[4]+J[5]+J[6]-J[7]+J[8]+J[9]+J[10]+J[11]+J[12]+J[13]-J[14]-J[15]-J[16]+J[17]-J[18]-J[19]-J[20]+J[21]+
    J[22]-J[23]-J[24]-J[25]+J[26]-J[27]-J[28]-J[29]+J[30]-J[31]-J[32]-J[33]+J[34]-J[35]-J[36]-J[37]-J[38]-J[39]-J[40]+
    J[41]-J[42]-J[43]-J[44]+J[45]+J[46]-J[47]+J[48]+J[49]+J[50]+J[51]-J[52]+J[53]+J[54]+J[55]-J[56]+J[57]+
    J[58]+J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]-H[1]-H[2]-H[3]-H[4]+H[5]+H[6]+H[7]-H[8]+H[9]+
    H[10]-H[11]-J[0]-J[1]-J[2]-J[3]+J[4]+J[5]+J[6]-J[7]+J[8]+J[9]-J[10]+J[11]+J[12]+J[13]-J[14]-J[15]-J[16]+
    J[17]-J[18]-J[19]+J[20]+J[21]+J[22]-J[23]-J[24]-J[25]+J[26]-J[27]-J[28]+J[29]+J[30]-J[31]-J[32]-J[33]+
    J[34]-J[35]-J[36]+J[37]-J[38]-J[39]-J[40]+J[41]-J[42]-J[43]+J[44]+J[45]+J[46]-J[47]+J[48]+J[49]-J[50]+
    J[51]-J[52]+J[53]+J[54]-J[55]-J[56]+J[57]+J[58]-J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]-H[1]-H[2]-H[3]-H[4]+
    H[5]+H[6]+H[7]-H[8]+H[9]-H[10]+H[11]-J[0]-J[1]-J[2]-J[3]+J[4]+J[5]+J[6]-J[7]+J[8]-J[9]+J[10]+J[11]+J[12]+
    J[13]-J[14]-J[15]-J[16]+J[17]-J[18]+J[19]-J[20]+J[21]+J[22]-J[23]-J[24]-J[25]+J[26]-J[27]+J[28]-J[29]+
    J[30]-J[31]-J[32]-J[33]+J[34]-J[35]+J[36]-J[37]-J[38]-J[39]-J[40]+J[41]-J[42]+J[43]-J[44]+J[45]+J[46]-J[47]+
    J[48]-J[49]+J[50]+J[51]-J[52]+J[53]-J[54]+J[55]-J[56]+J[57]-J[58]+J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +
    H[0]-H[1]-H[2]-H[3]-H[4]+H[5]+H[6]+H[7]-H[8]+H[9]-H[10]-H[11]-J[0]-J[1]-J[2]-J[3]+J[4]+J[5]+J[6]-J[7]+
    J[8]-J[9]-J[10]+J[11]+J[12]+J[13]-J[14]-J[15]-J[16]+J[17]-J[18]+J[19]+J[20]+J[21]+J[22]-J[23]-J[24]-J[25]+
    J[26]-J[27]+J[28]+J[29]+J[30]-J[31]-J[32]-J[33]+J[34]-J[35]+J[36]+J[37]-J[38]-J[39]-J[40]+J[41]-J[42]+
    J[43]+J[44]+J[45]+J[46]-J[47]+J[48]-J[49]-J[50]+J[51]-J[52]+J[53]-J[54]-J[55]-J[56]+J[57]-J[58]-J[59]-J[60]+
    J[61]+J[62]-J[63]-J[64]+J[65], +H[0]-H[1]-H[2]-H[3]-H[4]+H[5]+H[6]+H[7]-H[8]-H[9]+H[10]+H[11]-J[0]-J[1]-J[2]-J[3]+
    J[4]+J[5]+J[6]-J[7]-J[8]+J[9]+J[10]+J[11]+J[12]+J[13]-J[14]-J[15]-J[16]+J[17]+J[18]-J[19]-J[20]+J[21]+
    J[22]-J[23]-J[24]-J[25]+J[26]+J[27]-J[28]-J[29]+J[30]-J[31]-J[32]-J[33]+J[34]+J[35]-J[36]-J[37]-J[38]-J[39]-J[40]+
    J[41]+J[42]-J[43]-J[44]+J[45]+J[46]-J[47]-J[48]+J[49]+J[50]+J[51]-J[52]-J[53]+J[54]+J[55]-J[56]-J[57]+
    J[58]+J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]-H[1]-H[2]-H[3]-H[4]+H[5]+H[6]+H[7]-H[8]-H[9]+
    H[10]-H[11]-J[0]-J[1]-J[2]-J[3]+J[4]+J[5]+J[6]-J[7]-J[8]+J[9]-J[10]+J[11]+J[12]+J[13]-J[14]-J[15]-J[16]+
    J[17]+J[18]-J[19]+J[20]+J[21]+J[22]-J[23]-J[24]-J[25]+J[26]+J[27]-J[28]+J[29]+J[30]-J[31]-J[32]-J[33]+
    J[34]+J[35]-J[36]+J[37]-J[38]-J[39]-J[40]+J[41]+J[42]-J[43]+J[44]+J[45]+J[46]-J[47]-J[48]+J[49]-J[50]+
    J[51]-J[52]-J[53]+J[54]-J[55]-J[56]-J[57]+J[58]-J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]-H[1]-H[2]-H[3]-H[4]+
    H[5]+H[6]+H[7]-H[8]-H[9]-H[10]+H[11]-J[0]-J[1]-J[2]-J[3]+J[4]+J[5]+J[6]-J[7]-J[8]-J[9]+J[10]+J[11]+J[12]+
    J[13]-J[14]-J[15]-J[16]+J[17]+J[18]+J[19]-J[20]+J[21]+J[22]-J[23]-J[24]-J[25]+J[26]+J[27]+J[28]-J[29]+
    J[30]-J[31]-J[32]-J[33]+J[34]+J[35]+J[36]-J[37]-J[38]-J[39]-J[40]+J[41]+J[42]+J[43]-J[44]+J[45]+J[46]-J[47]-J[48]-J[49]+
    J[50]+J[51]-J[52]-J[53]-J[54]+J[55]-J[56]-J[57]-J[58]+J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]-H[1]-H[2]-H[3]-H[4]+
    H[5]+H[6]+H[7]-H[8]-H[9]-H[10]-H[11]-J[0]-J[1]-J[2]-J[3]+J[4]+J[5]+J[6]-J[7]-J[8]-J[9]-J[10]+J[11]+J[12]+
    J[13]-J[14]-J[15]-J[16]+J[17]+J[18]+J[19]+J[20]+J[21]+J[22]-J[23]-J[24]-J[25]+J[26]+J[27]+J[28]+J[29]+
    J[30]-J[31]-J[32]-J[33]+J[34]+J[35]+J[36]+J[37]-J[38]-J[39]-J[40]+J[41]+J[42]+J[43]+J[44]+J[45]+J[46]-J[47]-J[48]-J[49]-J[50]+
    J[51]-J[52]-J[53]-J[54]-J[55]-J[56]-J[57]-J[58]-J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]-H[1]-H[2]-H[3]-H[4]+
    H[5]+H[6]-H[7]+H[8]+H[9]+H[10]+H[11]-J[0]-J[1]-J[2]-J[3]+J[4]+J[5]-J[6]+J[7]+J[8]+J[9]+J[10]+J[11]+J[12]+
    J[13]-J[14]-J[15]+J[16]-J[17]-J[18]-J[19]-J[20]+J[21]+J[22]-J[23]-J[24]+J[25]-J[26]-J[27]-J[28]-J[29]+
    J[30]-J[31]-J[32]+J[33]-J[34]-J[35]-J[36]-J[37]-J[38]-J[39]+J[40]-J[41]-J[42]-J[43]-J[44]+J[45]-J[46]+
    J[47]+J[48]+J[49]+J[50]-J[51]+J[52]+J[53]+J[54]+J[55]-J[56]-J[57]-J[58]-J[59]+J[60]+J[61]+J[62]+J[63]+
    J[64]+J[65], +H[0]-H[1]-H[2]-H[3]-H[4]+H[5]+H[6]-H[7]+H[8]+H[9]+H[10]-H[11]-J[0]-J[1]-J[2]-J[3]+J[4]+
    J[5]-J[6]+J[7]+J[8]+J[9]-J[10]+J[11]+J[12]+J[13]-J[14]-J[15]+J[16]-J[17]-J[18]-J[19]+J[20]+J[21]+J[22]-J[23]-J[24]+
    J[25]-J[26]-J[27]-J[28]+J[29]+J[30]-J[31]-J[32]+J[33]-J[34]-J[35]-J[36]+J[37]-J[38]-J[39]+J[40]-J[41]-J[42]-J[43]+
    J[44]+J[45]-J[46]+J[47]+J[48]+J[49]-J[50]-J[51]+J[52]+J[53]+J[54]-J[55]-J[56]-J[57]-J[58]+J[59]+J[60]+
    J[61]-J[62]+J[63]-J[64]-J[65], +H[0]-H[1]-H[2]-H[3]-H[4]+H[5]+H[6]-H[7]+H[8]+H[9]-H[10]+H[11]-J[0]-J[1]-J[2]-J[3]+
    J[4]+J[5]-J[6]+J[7]+J[8]-J[9]+J[10]+J[11]+J[12]+J[13]-J[14]-J[15]+J[16]-J[17]-J[18]+J[19]-J[20]+J[21]+
    J[22]-J[23]-J[24]+J[25]-J[26]-J[27]+J[28]-J[29]+J[30]-J[31]-J[32]+J[33]-J[34]-J[35]+J[36]-J[37]-J[38]-J[39]+
    J[40]-J[41]-J[42]+J[43]-J[44]+J[45]-J[46]+J[47]+J[48]-J[49]+J[50]-J[51]+J[52]+J[53]-J[54]+J[55]-J[56]-J[57]+
    J[58]-J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]-H[1]-H[2]-H[3]-H[4]+H[5]+H[6]-H[7]+H[8]+H[9]-H[10]-H[11]-J[0]-J[1]-J[2]-J[3]+
    J[4]+J[5]-J[6]+J[7]+J[8]-J[9]-J[10]+J[11]+J[12]+J[13]-J[14]-J[15]+J[16]-J[17]-J[18]+J[19]+J[20]+J[21]+
    J[22]-J[23]-J[24]+J[25]-J[26]-J[27]+J[28]+J[29]+J[30]-J[31]-J[32]+J[33]-J[34]-J[35]+J[36]+J[37]-J[38]-J[39]+
    J[40]-J[41]-J[42]+J[43]+J[44]+J[45]-J[46]+J[47]+J[48]-J[49]-J[50]-J[51]+J[52]+J[53]-J[54]-J[55]-J[56]-J[57]+
    J[58]+J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]-H[1]-H[2]-H[3]-H[4]+H[5]+H[6]-H[7]+H[8]-H[9]+
    H[10]+H[11]-J[0]-J[1]-J[2]-J[3]+J[4]+J[5]-J[6]+J[7]-J[8]+J[9]+J[10]+J[11]+J[12]+J[13]-J[14]-J[15]+J[16]-J[17]+
    J[18]-J[19]-J[20]+J[21]+J[22]-J[23]-J[24]+J[25]-J[26]+J[27]-J[28]-J[29]+J[30]-J[31]-J[32]+J[33]-J[34]+
    J[35]-J[36]-J[37]-J[38]-J[39]+J[40]-J[41]+J[42]-J[43]-J[44]+J[45]-J[46]+J[47]-J[48]+J[49]+J[50]-J[51]+
    J[52]-J[53]+J[54]+J[55]-J[56]+J[57]-J[58]-J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]-H[1]-H[2]-H[3]-H[4]+
    H[5]+H[6]-H[7]+H[8]-H[9]+H[10]-H[11]-J[0]-J[1]-J[2]-J[3]+J[4]+J[5]-J[6]+J[7]-J[8]+J[9]-J[10]+J[11]+J[12]+
    J[13]-J[14]-J[15]+J[16]-J[17]+J[18]-J[19]+J[20]+J[21]+J[22]-J[23]-J[24]+J[25]-J[26]+J[27]-J[28]+J[29]+
    J[30]-J[31]-J[32]+J[33]-J[34]+J[35]-J[36]+J[37]-J[38]-J[39]+J[40]-J[41]+J[42]-J[43]+J[44]+J[45]-J[46]+
    J[47]-J[48]+J[49]-J[50]-J[51]+J[52]-J[53]+J[54]-J[55]-J[56]+J[57]-J[58]+J[59]-J[60]+J[61]-J[62]-J[63]+
    J[64]-J[65], +H[0]-H[1]-H[2]-H[3]-H[4]+H[5]+H[6]-H[7]+H[8]-H[9]-H[10]+H[11]-J[0]-J[1]-J[2]-J[3]+J[4]+
    J[5]-J[6]+J[7]-J[8]-J[9]+J[10]+J[11]+J[12]+J[13]-J[14]-J[15]+J[16]-J[17]+J[18]+J[19]-J[20]+J[21]+J[22]-J[23]-J[24]+
    J[25]-J[26]+J[27]+J[28]-J[29]+J[30]-J[31]-J[32]+J[33]-J[34]+J[35]+J[36]-J[37]-J[38]-J[39]+J[40]-J[41]+
    J[42]+J[43]-J[44]+J[45]-J[46]+J[47]-J[48]-J[49]+J[50]-J[51]+J[52]-J[53]-J[54]+J[55]-J[56]+J[57]+J[58]-J[59]-J[60]-J[61]+
    J[62]+J[63]-J[64]-J[65], +H[0]-H[1]-H[2]-H[3]-H[4]+H[5]+H[6]-H[7]+H[8]-H[9]-H[10]-H[11]-J[0]-J[1]-J[2]-J[3]+
    J[4]+J[5]-J[6]+J[7]-J[8]-J[9]-J[10]+J[11]+J[12]+J[13]-J[14]-J[15]+J[16]-J[17]+J[18]+J[19]+J[20]+J[21]+
    J[22]-J[23]-J[24]+J[25]-J[26]+J[27]+J[28]+J[29]+J[30]-J[31]-J[32]+J[33]-J[34]+J[35]+J[36]+J[37]-J[38]-J[39]+
    J[40]-J[41]+J[42]+J[43]+J[44]+J[45]-J[46]+J[47]-J[48]-J[49]-J[50]-J[51]+J[52]-J[53]-J[54]-J[55]-J[56]+
    J[57]+J[58]+J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]-H[1]-H[2]-H[3]-H[4]+H[5]+H[6]-H[7]-H[8]+
    H[9]+H[10]+H[11]-J[0]-J[1]-J[2]-J[3]+J[4]+J[5]-J[6]-J[7]+J[8]+J[9]+J[10]+J[11]+J[12]+J[13]-J[14]-J[15]+
    J[16]+J[17]-J[18]-J[19]-J[20]+J[21]+J[22]-J[23]-J[24]+J[25]+J[26]-J[27]-J[28]-J[29]+J[30]-J[31]-J[32]+
    J[33]+J[34]-J[35]-J[36]-J[37]-J[38]-J[39]+J[40]+J[41]-J[42]-J[43]-J[44]+J[45]-J[46]-J[47]+J[48]+J[49]+
    J[50]-J[51]-J[52]+J[53]+J[54]+J[55]+J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]-H[1]-H[2]-H[3]-H[4]+
    H[5]+H[6]-H[7]-H[8]+H[9]+H[10]-H[11]-J[0]-J[1]-J[2]-J[3]+J[4]+J[5]-J[6]-J[7]+J[8]+J[9]-J[10]+J[11]+J[12]+
    J[13]-J[14]-J[15]+J[16]+J[17]-J[18]-J[19]+J[20]+J[21]+J[22]-J[23]-J[24]+J[25]+J[26]-J[27]-J[28]+J[29]+
    J[30]-J[31]-J[32]+J[33]+J[34]-J[35]-J[36]+J[37]-J[38]-J[39]+J[40]+J[41]-J[42]-J[43]+J[44]+J[45]-J[46]-J[47]+
    J[48]+J[49]-J[50]-J[51]-J[52]+J[53]+J[54]-J[55]+J[56]-J[57]-J[58]+J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +
    H[0]-H[1]-H[2]-H[3]-H[4]+H[5]+H[6]-H[7]-H[8]+H[9]-H[10]+H[11]-J[0]-J[1]-J[2]-J[3]+J[4]+J[5]-J[6]-J[7]+
    J[8]-J[9]+J[10]+J[11]+J[12]+J[13]-J[14]-J[15]+J[16]+J[17]-J[18]+J[19]-J[20]+J[21]+J[22]-J[23]-J[24]+
    J[25]+J[26]-J[27]+J[28]-J[29]+J[30]-J[31]-J[32]+J[33]+J[34]-J[35]+J[36]-J[37]-J[38]-J[39]+J[40]+J[41]-J[42]+
    J[43]-J[44]+J[45]-J[46]-J[47]+J[48]-J[49]+J[50]-J[51]-J[52]+J[53]-J[54]+J[55]+J[56]-J[57]+J[58]-J[59]-J[60]+
    J[61]-J[62]-J[63]+J[64]-J[65], +H[0]-H[1]-H[2]-H[3]-H[4]+H[5]+H[6]-H[7]-H[8]+H[9]-H[10]-H[11]-J[0]-J[1]-J[2]-J[3]+
    J[4]+J[5]-J[6]-J[7]+J[8]-J[9]-J[10]+J[11]+J[12]+J[13]-J[14]-J[15]+J[16]+J[17]-J[18]+J[19]+J[20]+J[21]+
    J[22]-J[23]-J[24]+J[25]+J[26]-J[27]+J[28]+J[29]+J[30]-J[31]-J[32]+J[33]+J[34]-J[35]+J[36]+J[37]-J[38]-J[39]+
    J[40]+J[41]-J[42]+J[43]+J[44]+J[45]-J[46]-J[47]+J[48]-J[49]-J[50]-J[51]-J[52]+J[53]-J[54]-J[55]+J[56]-J[57]+
    J[58]+J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]-H[1]-H[2]-H[3]-H[4]+H[5]+H[6]-H[7]-H[8]-H[9]+
    H[10]+H[11]-J[0]-J[1]-J[2]-J[3]+J[4]+J[5]-J[6]-J[7]-J[8]+J[9]+J[10]+J[11]+J[12]+J[13]-J[14]-J[15]+J[16]+
    J[17]+J[18]-J[19]-J[20]+J[21]+J[22]-J[23]-J[24]+J[25]+J[26]+J[27]-J[28]-J[29]+J[30]-J[31]-J[32]+J[33]+
    J[34]+J[35]-J[36]-J[37]-J[38]-J[39]+J[40]+J[41]+J[42]-J[43]-J[44]+J[45]-J[46]-J[47]-J[48]+J[49]+J[50]-J[51]-J[52]-J[53]+
    J[54]+J[55]+J[56]+J[57]-J[58]-J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]-H[1]-H[2]-H[3]-H[4]+H[5]+
    H[6]-H[7]-H[8]-H[9]+H[10]-H[11]-J[0]-J[1]-J[2]-J[3]+J[4]+J[5]-J[6]-J[7]-J[8]+J[9]-J[10]+J[11]+J[12]+
    J[13]-J[14]-J[15]+J[16]+J[17]+J[18]-J[19]+J[20]+J[21]+J[22]-J[23]-J[24]+J[25]+J[26]+J[27]-J[28]+J[29]+
    J[30]-J[31]-J[32]+J[33]+J[34]+J[35]-J[36]+J[37]-J[38]-J[39]+J[40]+J[41]+J[42]-J[43]+J[44]+J[45]-J[46]-J[47]-J[48]+
    J[49]-J[50]-J[51]-J[52]-J[53]+J[54]-J[55]+J[56]+J[57]-J[58]+J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +
    H[0]-H[1]-H[2]-H[3]-H[4]+H[5]+H[6]-H[7]-H[8]-H[9]-H[10]+H[11]-J[0]-J[1]-J[2]-J[3]+J[4]+J[5]-J[6]-J[7]-J[8]-J[9]+
    J[10]+J[11]+J[12]+J[13]-J[14]-J[15]+J[16]+J[17]+J[18]+J[19]-J[20]+J[21]+J[22]-J[23]-J[24]+J[25]+J[26]+
    J[27]+J[28]-J[29]+J[30]-J[31]-J[32]+J[33]+J[34]+J[35]+J[36]-J[37]-J[38]-J[39]+J[40]+J[41]+J[42]+J[43]-J[44]+
    J[45]-J[46]-J[47]-J[48]-J[49]+J[50]-J[51]-J[52]-J[53]-J[54]+J[55]+J[56]+J[57]+J[58]-J[59]+J[60]+J[61]-J[62]+
    J[63]-J[64]-J[65], +H[0]-H[1]-H[2]-H[3]-H[4]+H[5]+H[6]-H[7]-H[8]-H[9]-H[10]-H[11]-J[0]-J[1]-J[2]-J[3]+
    J[4]+J[5]-J[6]-J[7]-J[8]-J[9]-J[10]+J[11]+J[12]+J[13]-J[14]-J[15]+J[16]+J[17]+J[18]+J[19]+J[20]+J[21]+
    J[22]-J[23]-J[24]+J[25]+J[26]+J[27]+J[28]+J[29]+J[30]-J[31]-J[32]+J[33]+J[34]+J[35]+J[36]+J[37]-J[38]-J[39]+
    J[40]+J[41]+J[42]+J[43]+J[44]+J[45]-J[46]-J[47]-J[48]-J[49]-J[50]-J[51]-J[52]-J[53]-J[54]-J[55]+J[56]+
    J[57]+J[58]+J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]-H[1]-H[2]-H[3]-H[4]+H[5]-H[6]+H[7]+H[8]+
    H[9]+H[10]+H[11]-J[0]-J[1]-J[2]-J[3]+J[4]-J[5]+J[6]+J[7]+J[8]+J[9]+J[10]+J[11]+J[12]+J[13]-J[14]+J[15]-J[16]-J[17]-J[18]-J[19]-J[20]+
    J[21]+J[22]-J[23]+J[24]-J[25]-J[26]-J[27]-J[28]-J[29]+J[30]-J[31]+J[32]-J[33]-J[34]-J[35]-J[36]-J[37]-J[38]+
    J[39]-J[40]-J[41]-J[42]-J[43]-J[44]-J[45]+J[46]+J[47]+J[48]+J[49]+J[50]-J[51]-J[52]-J[53]-J[54]-J[55]+
    J[56]+J[57]+J[58]+J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]-H[1]-H[2]-H[3]-H[4]+H[5]-H[6]+H[7]+
    H[8]+H[9]+H[10]-H[11]-J[0]-J[1]-J[2]-J[3]+J[4]-J[5]+J[6]+J[7]+J[8]+J[9]-J[10]+J[11]+J[12]+J[13]-J[14]+
    J[15]-J[16]-J[17]-J[18]-J[19]+J[20]+J[21]+J[22]-J[23]+J[24]-J[25]-J[26]-J[27]-J[28]+J[29]+J[30]-J[31]+
    J[32]-J[33]-J[34]-J[35]-J[36]+J[37]-J[38]+J[39]-J[40]-J[41]-J[42]-J[43]+J[44]-J[45]+J[46]+J[47]+J[48]+
    J[49]-J[50]-J[51]-J[52]-J[53]-J[54]+J[55]+J[56]+J[57]+J[58]-J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +
    H[0]-H[1]-H[2]-H[3]-H[4]+H[5]-H[6]+H[7]+H[8]+H[9]-H[10]+H[11]-J[0]-J[1]-J[2]-J[3]+J[4]-J[5]+J[6]+J[7]+
    J[8]-J[9]+J[10]+J[11]+J[12]+J[13]-J[14]+J[15]-J[16]-J[17]-J[18]+J[19]-J[20]+J[21]+J[22]-J[23]+J[24]-J[25]-J[26]-J[27]+
    J[28]-J[29]+J[30]-J[31]+J[32]-J[33]-J[34]-J[35]+J[36]-J[37]-J[38]+J[39]-J[40]-J[41]-J[42]+J[43]-J[44]-J[45]+
    J[46]+J[47]+J[48]-J[49]+J[50]-J[51]-J[52]-J[53]+J[54]-J[55]+J[56]+J[57]-J[58]+J[59]+J[60]-J[61]+J[62]-J[63]+
    J[64]-J[65], +H[0]-H[1]-H[2]-H[3]-H[4]+H[5]-H[6]+H[7]+H[8]+H[9]-H[10]-H[11]-J[0]-J[1]-J[2]-J[3]+J[4]-J[5]+
    J[6]+J[7]+J[8]-J[9]-J[10]+J[11]+J[12]+J[13]-J[14]+J[15]-J[16]-J[17]-J[18]+J[19]+J[20]+J[21]+J[22]-J[23]+
    J[24]-J[25]-J[26]-J[27]+J[28]+J[29]+J[30]-J[31]+J[32]-J[33]-J[34]-J[35]+J[36]+J[37]-J[38]+J[39]-J[40]-J[41]-J[42]+
    J[43]+J[44]-J[45]+J[46]+J[47]+J[48]-J[49]-J[50]-J[51]-J[52]-J[53]+J[54]+J[55]+J[56]+J[57]-J[58]-J[59]+
    J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]-H[1]-H[2]-H[3]-H[4]+H[5]-H[6]+H[7]+H[8]-H[9]+H[10]+H[11]-J[0]-J[1]-J[2]-J[3]+
    J[4]-J[5]+J[6]+J[7]-J[8]+J[9]+J[10]+J[11]+J[12]+J[13]-J[14]+J[15]-J[16]-J[17]+J[18]-J[19]-J[20]+J[21]+
    J[22]-J[23]+J[24]-J[25]-J[26]+J[27]-J[28]-J[29]+J[30]-J[31]+J[32]-J[33]-J[34]+J[35]-J[36]-J[37]-J[38]+
    J[39]-J[40]-J[41]+J[42]-J[43]-J[44]-J[45]+J[46]+J[47]-J[48]+J[49]+J[50]-J[51]-J[52]+J[53]-J[54]-J[55]+
    J[56]-J[57]+J[58]+J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]-H[1]-H[2]-H[3]-H[4]+H[5]-H[6]+H[7]+
    H[8]-H[9]+H[10]-H[11]-J[0]-J[1]-J[2]-J[3]+J[4]-J[5]+J[6]+J[7]-J[8]+J[9]-J[10]+J[11]+J[12]+J[13]-J[14]+
    J[15]-J[16]-J[17]+J[18]-J[19]+J[20]+J[21]+J[22]-J[23]+J[24]-J[25]-J[26]+J[27]-J[28]+J[29]+J[30]-J[31]+
    J[32]-J[33]-J[34]+J[35]-J[36]+J[37]-J[38]+J[39]-J[40]-J[41]+J[42]-J[43]+J[44]-J[45]+J[46]+J[47]-J[48]+
    J[49]-J[50]-J[51]-J[52]+J[53]-J[54]+J[55]+J[56]-J[57]+J[58]-J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +
    H[0]-H[1]-H[2]-H[3]-H[4]+H[5]-H[6]+H[7]+H[8]-H[9]-H[10]+H[11]-J[0]-J[1]-J[2]-J[3]+J[4]-J[5]+J[6]+J[7]-J[8]-J[9]+
    J[10]+J[11]+J[12]+J[13]-J[14]+J[15]-J[16]-J[17]+J[18]+J[19]-J[20]+J[21]+J[22]-J[23]+J[24]-J[25]-J[26]+
    J[27]+J[28]-J[29]+J[30]-J[31]+J[32]-J[33]-J[34]+J[35]+J[36]-J[37]-J[38]+J[39]-J[40]-J[41]+J[42]+J[43]-J[44]-J[45]+
    J[46]+J[47]-J[48]-J[49]+J[50]-J[51]-J[52]+J[53]+J[54]-J[55]+J[56]-J[57]-J[58]+J[59]-J[60]-J[61]+J[62]+
    J[63]-J[64]-J[65], +H[0]-H[1]-H[2]-H[3]-H[4]+H[5]-H[6]+H[7]+H[8]-H[9]-H[10]-H[11]-J[0]-J[1]-J[2]-J[3]+
    J[4]-J[5]+J[6]+J[7]-J[8]-J[9]-J[10]+J[11]+J[12]+J[13]-J[14]+J[15]-J[16]-J[17]+J[18]+J[19]+J[20]+J[21]+
    J[22]-J[23]+J[24]-J[25]-J[26]+J[27]+J[28]+J[29]+J[30]-J[31]+J[32]-J[33]-J[34]+J[35]+J[36]+J[37]-J[38]+
    J[39]-J[40]-J[41]+J[42]+J[43]+J[44]-J[45]+J[46]+J[47]-J[48]-J[49]-J[50]-J[51]-J[52]+J[53]+J[54]+J[55]+
    J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]-H[1]-H[2]-H[3]-H[4]+H[5]-H[6]+H[7]-H[8]+
    H[9]+H[10]+H[11]-J[0]-J[1]-J[2]-J[3]+J[4]-J[5]+J[6]-J[7]+J[8]+J[9]+J[10]+J[11]+J[12]+J[13]-J[14]+J[15]-J[16]+
    J[17]-J[18]-J[19]-J[20]+J[21]+J[22]-J[23]+J[24]-J[25]+J[26]-J[27]-J[28]-J[29]+J[30]-J[31]+J[32]-J[33]+
    J[34]-J[35]-J[36]-J[37]-J[38]+J[39]-J[40]+J[41]-J[42]-J[43]-J[44]-J[45]+J[46]-J[47]+J[48]+J[49]+J[50]-J[51]+
    J[52]-J[53]-J[54]-J[55]-J[56]+J[57]+J[58]+J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]-H[1]-H[2]-H[3]-H[4]+
    H[5]-H[6]+H[7]-H[8]+H[9]+H[10]-H[11]-J[0]-J[1]-J[2]-J[3]+J[4]-J[5]+J[6]-J[7]+J[8]+J[9]-J[10]+J[11]+J[12]+
    J[13]-J[14]+J[15]-J[16]+J[17]-J[18]-J[19]+J[20]+J[21]+J[22]-J[23]+J[24]-J[25]+J[26]-J[27]-J[28]+J[29]+
    J[30]-J[31]+J[32]-J[33]+J[34]-J[35]-J[36]+J[37]-J[38]+J[39]-J[40]+J[41]-J[42]-J[43]+J[44]-J[45]+J[46]-J[47]+
    J[48]+J[49]-J[50]-J[51]+J[52]-J[53]-J[54]+J[55]-J[56]+J[57]+J[58]-J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +
    H[0]-H[1]-H[2]-H[3]-H[4]+H[5]-H[6]+H[7]-H[8]+H[9]-H[10]+H[11]-J[0]-J[1]-J[2]-J[3]+J[4]-J[5]+J[6]-J[7]+
    J[8]-J[9]+J[10]+J[11]+J[12]+J[13]-J[14]+J[15]-J[16]+J[17]-J[18]+J[19]-J[20]+J[21]+J[22]-J[23]+J[24]-J[25]+
    J[26]-J[27]+J[28]-J[29]+J[30]-J[31]+J[32]-J[33]+J[34]-J[35]+J[36]-J[37]-J[38]+J[39]-J[40]+J[41]-J[42]+
    J[43]-J[44]-J[45]+J[46]-J[47]+J[48]-J[49]+J[50]-J[51]+J[52]-J[53]+J[54]-J[55]-J[56]+J[57]-J[58]+J[59]-J[60]+
    J[61]-J[62]-J[63]+J[64]-J[65], +H[0]-H[1]-H[2]-H[3]-H[4]+H[5]-H[6]+H[7]-H[8]+H[9]-H[10]-H[11]-J[0]-J[1]-J[2]-J[3]+
    J[4]-J[5]+J[6]-J[7]+J[8]-J[9]-J[10]+J[11]+J[12]+J[13]-J[14]+J[15]-J[16]+J[17]-J[18]+J[19]+J[20]+J[21]+
    J[22]-J[23]+J[24]-J[25]+J[26]-J[27]+J[28]+J[29]+J[30]-J[31]+J[32]-J[33]+J[34]-J[35]+J[36]+J[37]-J[38]+
    J[39]-J[40]+J[41]-J[42]+J[43]+J[44]-J[45]+J[46]-J[47]+J[48]-J[49]-J[50]-J[51]+J[52]-J[53]+J[54]+J[55]-J[56]+
    J[57]-J[58]-J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]-H[1]-H[2]-H[3]-H[4]+H[5]-H[6]+H[7]-H[8]-H[9]+
    H[10]+H[11]-J[0]-J[1]-J[2]-J[3]+J[4]-J[5]+J[6]-J[7]-J[8]+J[9]+J[10]+J[11]+J[12]+J[13]-J[14]+J[15]-J[16]+
    J[17]+J[18]-J[19]-J[20]+J[21]+J[22]-J[23]+J[24]-J[25]+J[26]+J[27]-J[28]-J[29]+J[30]-J[31]+J[32]-J[33]+
    J[34]+J[35]-J[36]-J[37]-J[38]+J[39]-J[40]+J[41]+J[42]-J[43]-J[44]-J[45]+J[46]-J[47]-J[48]+J[49]+J[50]-J[51]+
    J[52]+J[53]-J[54]-J[55]-J[56]-J[57]+J[58]+J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]-H[1]-H[2]-H[3]-H[4]+
    H[5]-H[6]+H[7]-H[8]-H[9]+H[10]-H[11]-J[0]-J[1]-J[2]-J[3]+J[4]-J[5]+J[6]-J[7]-J[8]+J[9]-J[10]+J[11]+J[12]+
    J[13]-J[14]+J[15]-J[16]+J[17]+J[18]-J[19]+J[20]+J[21]+J[22]-J[23]+J[24]-J[25]+J[26]+J[27]-J[28]+J[29]+
    J[30]-J[31]+J[32]-J[33]+J[34]+J[35]-J[36]+J[37]-J[38]+J[39]-J[40]+J[41]+J[42]-J[43]+J[44]-J[45]+J[46]-J[47]-J[48]+
    J[49]-J[50]-J[51]+J[52]+J[53]-J[54]+J[55]-J[56]-J[57]+J[58]-J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +
    H[0]-H[1]-H[2]-H[3]-H[4]+H[5]-H[6]+H[7]-H[8]-H[9]-H[10]+H[11]-J[0]-J[1]-J[2]-J[3]+J[4]-J[5]+J[6]-J[7]-J[8]-J[9]+
    J[10]+J[11]+J[12]+J[13]-J[14]+J[15]-J[16]+J[17]+J[18]+J[19]-J[20]+J[21]+J[22]-J[23]+J[24]-J[25]+J[26]+
    J[27]+J[28]-J[29]+J[30]-J[31]+J[32]-J[33]+J[34]+J[35]+J[36]-J[37]-J[38]+J[39]-J[40]+J[41]+J[42]+J[43]-J[44]-J[45]+
    J[46]-J[47]-J[48]-J[49]+J[50]-J[51]+J[52]+J[53]+J[54]-J[55]-J[56]-J[57]-J[58]+J[59]+J[60]+J[61]-J[62]+
    J[63]-J[64]-J[65], +H[0]-H[1]-H[2]-H[3]-H[4]+H[5]-H[6]+H[7]-H[8]-H[9]-H[10]-H[11]-J[0]-J[1]-J[2]-J[3]+
    J[4]-J[5]+J[6]-J[7]-J[8]-J[9]-J[10]+J[11]+J[12]+J[13]-J[14]+J[15]-J[16]+J[17]+J[18]+J[19]+J[20]+J[21]+
    J[22]-J[23]+J[24]-J[25]+J[26]+J[27]+J[28]+J[29]+J[30]-J[31]+J[32]-J[33]+J[34]+J[35]+J[36]+J[37]-J[38]+
    J[39]-J[40]+J[41]+J[42]+J[43]+J[44]-J[45]+J[46]-J[47]-J[48]-J[49]-J[50]-J[51]+J[52]+J[53]+J[54]+J[55]-J[56]-J[57]-J[58]-J[59]+
    J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]-H[1]-H[2]-H[3]-H[4]+H[5]-H[6]-H[7]+H[8]+H[9]+H[10]+H[11]-J[0]-J[1]-J[2]-J[3]+
    J[4]-J[5]-J[6]+J[7]+J[8]+J[9]+J[10]+J[11]+J[12]+J[13]-J[14]+J[15]+J[16]-J[17]-J[18]-J[19]-J[20]+J[21]+
    J[22]-J[23]+J[24]+J[25]-J[26]-J[27]-J[28]-J[29]+J[30]-J[31]+J[32]+J[33]-J[34]-J[35]-J[36]-J[37]-J[38]+
    J[39]+J[40]-J[41]-J[42]-J[43]-J[44]-J[45]-J[46]+J[47]+J[48]+J[49]+J[50]+J[51]-J[52]-J[53]-J[54]-J[55]-J[56]-J[57]-J[58]-J[59]+
    J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]-H[1]-H[2]-H[3]-H[4]+H[5]-H[6]-H[7]+H[8]+H[9]+H[10]-H[11]-J[0]-J[1]-J[2]-J[3]+
    J[4]-J[5]-J[6]+J[7]+J[8]+J[9]-J[10]+J[11]+J[12]+J[13]-J[14]+J[15]+J[16]-J[17]-J[18]-J[19]+J[20]+J[21]+
    J[22]-J[23]+J[24]+J[25]-J[26]-J[27]-J[28]+J[29]+J[30]-J[31]+J[32]+J[33]-J[34]-J[35]-J[36]+J[37]-J[38]+
    J[39]+J[40]-J[41]-J[42]-J[43]+J[44]-J[45]-J[46]+J[47]+J[48]+J[49]-J[50]+J[51]-J[52]-J[53]-J[54]+J[55]-J[56]-J[57]-J[58]+
    J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]-H[1]-H[2]-H[3]-H[4]+H[5]-H[6]-H[7]+H[8]+H[9]-H[10]+
    H[11]-J[0]-J[1]-J[2]-J[3]+J[4]-J[5]-J[6]+J[7]+J[8]-J[9]+J[10]+J[11]+J[12]+J[13]-J[14]+J[15]+J[16]-J[17]-J[18]+
    J[19]-J[20]+J[21]+J[22]-J[23]+J[24]+J[25]-J[26]-J[27]+J[28]-J[29]+J[30]-J[31]+J[32]+J[33]-J[34]-J[35]+
    J[36]-J[37]-J[38]+J[39]+J[40]-J[41]-J[42]+J[43]-J[44]-J[45]-J[46]+J[47]+J[48]-J[49]+J[50]+J[51]-J[52]-J[53]+
    J[54]-J[55]-J[56]-J[57]+J[58]-J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]-H[1]-H[2]-H[3]-H[4]+H[5]-H[6]-H[7]+
    H[8]+H[9]-H[10]-H[11]-J[0]-J[1]-J[2]-J[3]+J[4]-J[5]-J[6]+J[7]+J[8]-J[9]-J[10]+J[11]+J[12]+J[13]-J[14]+
    J[15]+J[16]-J[17]-J[18]+J[19]+J[20]+J[21]+J[22]-J[23]+J[24]+J[25]-J[26]-J[27]+J[28]+J[29]+J[30]-J[31]+
    J[32]+J[33]-J[34]-J[35]+J[36]+J[37]-J[38]+J[39]+J[40]-J[41]-J[42]+J[43]+J[44]-J[45]-J[46]+J[47]+J[48]-J[49]-J[50]+
    J[51]-J[52]-J[53]+J[54]+J[55]-J[56]-J[57]+J[58]+J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]-H[1]-H[2]-H[3]-H[4]+
    H[5]-H[6]-H[7]+H[8]-H[9]+H[10]+H[11]-J[0]-J[1]-J[2]-J[3]+J[4]-J[5]-J[6]+J[7]-J[8]+J[9]+J[10]+J[11]+J[12]+
    J[13]-J[14]+J[15]+J[16]-J[17]+J[18]-J[19]-J[20]+J[21]+J[22]-J[23]+J[24]+J[25]-J[26]+J[27]-J[28]-J[29]+
    J[30]-J[31]+J[32]+J[33]-J[34]+J[35]-J[36]-J[37]-J[38]+J[39]+J[40]-J[41]+J[42]-J[43]-J[44]-J[45]-J[46]+
    J[47]-J[48]+J[49]+J[50]+J[51]-J[52]+J[53]-J[54]-J[55]-J[56]+J[57]-J[58]-J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+
    J[65], +H[0]-H[1]-H[2]-H[3]-H[4]+H[5]-H[6]-H[7]+H[8]-H[9]+H[10]-H[11]-J[0]-J[1]-J[2]-J[3]+J[4]-J[5]-J[6]+
    J[7]-J[8]+J[9]-J[10]+J[11]+J[12]+J[13]-J[14]+J[15]+J[16]-J[17]+J[18]-J[19]+J[20]+J[21]+J[22]-J[23]+J[24]+
    J[25]-J[26]+J[27]-J[28]+J[29]+J[30]-J[31]+J[32]+J[33]-J[34]+J[35]-J[36]+J[37]-J[38]+J[39]+J[40]-J[41]+
    J[42]-J[43]+J[44]-J[45]-J[46]+J[47]-J[48]+J[49]-J[50]+J[51]-J[52]+J[53]-J[54]+J[55]-J[56]+J[57]-J[58]+
    J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]-H[1]-H[2]-H[3]-H[4]+H[5]-H[6]-H[7]+H[8]-H[9]-H[10]+
    H[11]-J[0]-J[1]-J[2]-J[3]+J[4]-J[5]-J[6]+J[7]-J[8]-J[9]+J[10]+J[11]+J[12]+J[13]-J[14]+J[15]+J[16]-J[17]+
    J[18]+J[19]-J[20]+J[21]+J[22]-J[23]+J[24]+J[25]-J[26]+J[27]+J[28]-J[29]+J[30]-J[31]+J[32]+J[33]-J[34]+
    J[35]+J[36]-J[37]-J[38]+J[39]+J[40]-J[41]+J[42]+J[43]-J[44]-J[45]-J[46]+J[47]-J[48]-J[49]+J[50]+J[51]-J[52]+
    J[53]+J[54]-J[55]-J[56]+J[57]+J[58]-J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]-H[1]-H[2]-H[3]-H[4]+
    H[5]-H[6]-H[7]+H[8]-H[9]-H[10]-H[11]-J[0]-J[1]-J[2]-J[3]+J[4]-J[5]-J[6]+J[7]-J[8]-J[9]-J[10]+J[11]+J[12]+
    J[13]-J[14]+J[15]+J[16]-J[17]+J[18]+J[19]+J[20]+J[21]+J[22]-J[23]+J[24]+J[25]-J[26]+J[27]+J[28]+J[29]+
    J[30]-J[31]+J[32]+J[33]-J[34]+J[35]+J[36]+J[37]-J[38]+J[39]+J[40]-J[41]+J[42]+J[43]+J[44]-J[45]-J[46]+
    J[47]-J[48]-J[49]-J[50]+J[51]-J[52]+J[53]+J[54]+J[55]-J[56]+J[57]+J[58]+J[59]-J[60]-J[61]-J[62]+J[63]+
    J[64]+J[65], +H[0]-H[1]-H[2]-H[3]-H[4]+H[5]-H[6]-H[7]-H[8]+H[9]+H[10]+H[11]-J[0]-J[1]-J[2]-J[3]+J[4]-J[5]-J[6]-J[7]+
    J[8]+J[9]+J[10]+J[11]+J[12]+J[13]-J[14]+J[15]+J[16]+J[17]-J[18]-J[19]-J[20]+J[21]+J[22]-J[23]+J[24]+
    J[25]+J[26]-J[27]-J[28]-J[29]+J[30]-J[31]+J[32]+J[33]+J[34]-J[35]-J[36]-J[37]-J[38]+J[39]+J[40]+J[41]-J[42]-J[43]-J[44]-J[45]-J[46]-J[47]+
    J[48]+J[49]+J[50]+J[51]+J[52]-J[53]-J[54]-J[55]+J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+
    J[65], +H[0]-H[1]-H[2]-H[3]-H[4]+H[5]-H[6]-H[7]-H[8]+H[9]+H[10]-H[11]-J[0]-J[1]-J[2]-J[3]+J[4]-J[5]-J[6]-J[7]+
    J[8]+J[9]-J[10]+J[11]+J[12]+J[13]-J[14]+J[15]+J[16]+J[17]-J[18]-J[19]+J[20]+J[21]+J[22]-J[23]+J[24]+
    J[25]+J[26]-J[27]-J[28]+J[29]+J[30]-J[31]+J[32]+J[33]+J[34]-J[35]-J[36]+J[37]-J[38]+J[39]+J[40]+J[41]-J[42]-J[43]+
    J[44]-J[45]-J[46]-J[47]+J[48]+J[49]-J[50]+J[51]+J[52]-J[53]-J[54]+J[55]+J[56]-J[57]-J[58]+J[59]-J[60]-J[61]+
    J[62]+J[63]-J[64]-J[65], +H[0]-H[1]-H[2]-H[3]-H[4]+H[5]-H[6]-H[7]-H[8]+H[9]-H[10]+H[11]-J[0]-J[1]-J[2]-J[3]+
    J[4]-J[5]-J[6]-J[7]+J[8]-J[9]+J[10]+J[11]+J[12]+J[13]-J[14]+J[15]+J[16]+J[17]-J[18]+J[19]-J[20]+J[21]+
    J[22]-J[23]+J[24]+J[25]+J[26]-J[27]+J[28]-J[29]+J[30]-J[31]+J[32]+J[33]+J[34]-J[35]+J[36]-J[37]-J[38]+
    J[39]+J[40]+J[41]-J[42]+J[43]-J[44]-J[45]-J[46]-J[47]+J[48]-J[49]+J[50]+J[51]+J[52]-J[53]+J[54]-J[55]+
    J[56]-J[57]+J[58]-J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]-H[1]-H[2]-H[3]-H[4]+H[5]-H[6]-H[7]-H[8]+
    H[9]-H[10]-H[11]-J[0]-J[1]-J[2]-J[3]+J[4]-J[5]-J[6]-J[7]+J[8]-J[9]-J[10]+J[11]+J[12]+J[13]-J[14]+J[15]+
    J[16]+J[17]-J[18]+J[19]+J[20]+J[21]+J[22]-J[23]+J[24]+J[25]+J[26]-J[27]+J[28]+J[29]+J[30]-J[31]+J[32]+
    J[33]+J[34]-J[35]+J[36]+J[37]-J[38]+J[39]+J[40]+J[41]-J[42]+J[43]+J[44]-J[45]-J[46]-J[47]+J[48]-J[49]-J[50]+
    J[51]+J[52]-J[53]+J[54]+J[55]+J[56]-J[57]+J[58]+J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]-H[1]-H[2]-H[3]-H[4]+
    H[5]-H[6]-H[7]-H[8]-H[9]+H[10]+H[11]-J[0]-J[1]-J[2]-J[3]+J[4]-J[5]-J[6]-J[7]-J[8]+J[9]+J[10]+J[11]+J[12]+
    J[13]-J[14]+J[15]+J[16]+J[17]+J[18]-J[19]-J[20]+J[21]+J[22]-J[23]+J[24]+J[25]+J[26]+J[27]-J[28]-J[29]+
    J[30]-J[31]+J[32]+J[33]+J[34]+J[35]-J[36]-J[37]-J[38]+J[39]+J[40]+J[41]+J[42]-J[43]-J[44]-J[45]-J[46]-J[47]-J[48]+
    J[49]+J[50]+J[51]+J[52]+J[53]-J[54]-J[55]+J[56]+J[57]-J[58]-J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +
    H[0]-H[1]-H[2]-H[3]-H[4]+H[5]-H[6]-H[7]-H[8]-H[9]+H[10]-H[11]-J[0]-J[1]-J[2]-J[3]+J[4]-J[5]-J[6]-J[7]-J[8]+
    J[9]-J[10]+J[11]+J[12]+J[13]-J[14]+J[15]+J[16]+J[17]+J[18]-J[19]+J[20]+J[21]+J[22]-J[23]+J[24]+J[25]+
    J[26]+J[27]-J[28]+J[29]+J[30]-J[31]+J[32]+J[33]+J[34]+J[35]-J[36]+J[37]-J[38]+J[39]+J[40]+J[41]+J[42]-J[43]+
    J[44]-J[45]-J[46]-J[47]-J[48]+J[49]-J[50]+J[51]+J[52]+J[53]-J[54]+J[55]+J[56]+J[57]-J[58]+J[59]+J[60]-J[61]+
    J[62]-J[63]+J[64]-J[65], +H[0]-H[1]-H[2]-H[3]-H[4]+H[5]-H[6]-H[7]-H[8]-H[9]-H[10]+H[11]-J[0]-J[1]-J[2]-J[3]+
    J[4]-J[5]-J[6]-J[7]-J[8]-J[9]+J[10]+J[11]+J[12]+J[13]-J[14]+J[15]+J[16]+J[17]+J[18]+J[19]-J[20]+J[21]+
    J[22]-J[23]+J[24]+J[25]+J[26]+J[27]+J[28]-J[29]+J[30]-J[31]+J[32]+J[33]+J[34]+J[35]+J[36]-J[37]-J[38]+
    J[39]+J[40]+J[41]+J[42]+J[43]-J[44]-J[45]-J[46]-J[47]-J[48]-J[49]+J[50]+J[51]+J[52]+J[53]+J[54]-J[55]+
    J[56]+J[57]+J[58]-J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]-H[1]-H[2]-H[3]-H[4]+H[5]-H[6]-H[7]-H[8]-H[9]-H[10]-H[11]-J[0]-J[1]-J[2]-J[3]+
    J[4]-J[5]-J[6]-J[7]-J[8]-J[9]-J[10]+J[11]+J[12]+J[13]-J[14]+J[15]+J[16]+J[17]+J[18]+J[19]+J[20]+J[21]+
    J[22]-J[23]+J[24]+J[25]+J[26]+J[27]+J[28]+J[29]+J[30]-J[31]+J[32]+J[33]+J[34]+J[35]+J[36]+J[37]-J[38]+
    J[39]+J[40]+J[41]+J[42]+J[43]+J[44]-J[45]-J[46]-J[47]-J[48]-J[49]-J[50]+J[51]+J[52]+J[53]+J[54]+J[55]+
    J[56]+J[57]+J[58]+J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]-H[1]-H[2]-H[3]-H[4]-H[5]+H[6]+H[7]+
    H[8]+H[9]+H[10]+H[11]-J[0]-J[1]-J[2]-J[3]-J[4]+J[5]+J[6]+J[7]+J[8]+J[9]+J[10]+J[11]+J[12]+J[13]+J[14]-J[15]-J[16]-J[17]-J[18]-J[19]-J[20]+
    J[21]+J[22]+J[23]-J[24]-J[25]-J[26]-J[27]-J[28]-J[29]+J[30]+J[31]-J[32]-J[33]-J[34]-J[35]-J[36]-J[37]+
    J[38]-J[39]-J[40]-J[41]-J[42]-J[43]-J[44]-J[45]-J[46]-J[47]-J[48]-J[49]-J[50]+J[51]+J[52]+J[53]+J[54]+
    J[55]+J[56]+J[57]+J[58]+J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]-H[1]-H[2]-H[3]-H[4]-H[5]+H[6]+
    H[7]+H[8]+H[9]+H[10]-H[11]-J[0]-J[1]-J[2]-J[3]-J[4]+J[5]+J[6]+J[7]+J[8]+J[9]-J[10]+J[11]+J[12]+J[13]+
    J[14]-J[15]-J[16]-J[17]-J[18]-J[19]+J[20]+J[21]+J[22]+J[23]-J[24]-J[25]-J[26]-J[27]-J[28]+J[29]+J[30]+
    J[31]-J[32]-J[33]-J[34]-J[35]-J[36]+J[37]+J[38]-J[39]-J[40]-J[41]-J[42]-J[43]+J[44]-J[45]-J[46]-J[47]-J[48]-J[49]+
    J[50]+J[51]+J[52]+J[53]+J[54]-J[55]+J[56]+J[57]+J[58]-J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]-H[1]-H[2]-H[3]-H[4]-H[5]+
    H[6]+H[7]+H[8]+H[9]-H[10]+H[11]-J[0]-J[1]-J[2]-J[3]-J[4]+J[5]+J[6]+J[7]+J[8]-J[9]+J[10]+J[11]+J[12]+
    J[13]+J[14]-J[15]-J[16]-J[17]-J[18]+J[19]-J[20]+J[21]+J[22]+J[23]-J[24]-J[25]-J[26]-J[27]+J[28]-J[29]+
    J[30]+J[31]-J[32]-J[33]-J[34]-J[35]+J[36]-J[37]+J[38]-J[39]-J[40]-J[41]-J[42]+J[43]-J[44]-J[45]-J[46]-J[47]-J[48]+
    J[49]-J[50]+J[51]+J[52]+J[53]-J[54]+J[55]+J[56]+J[57]-J[58]+J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +
    H[0]-H[1]-H[2]-H[3]-H[4]-H[5]+H[6]+H[7]+H[8]+H[9]-H[10]-H[11]-J[0]-J[1]-J[2]-J[3]-J[4]+J[5]+J[6]+J[7]+
    J[8]-J[9]-J[10]+J[11]+J[12]+J[13]+J[14]-J[15]-J[16]-J[17]-J[18]+J[19]+J[20]+J[21]+J[22]+J[23]-J[24]-J[25]-J[26]-J[27]+
    J[28]+J[29]+J[30]+J[31]-J[32]-J[33]-J[34]-J[35]+J[36]+J[37]+J[38]-J[39]-J[40]-J[41]-J[42]+J[43]+J[44]-J[45]-J[46]-J[47]-J[48]+
    J[49]+J[50]+J[51]+J[52]+J[53]-J[54]-J[55]+J[56]+J[57]-J[58]-J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +
    H[0]-H[1]-H[2]-H[3]-H[4]-H[5]+H[6]+H[7]+H[8]-H[9]+H[10]+H[11]-J[0]-J[1]-J[2]-J[3]-J[4]+J[5]+J[6]+J[7]-J[8]+
    J[9]+J[10]+J[11]+J[12]+J[13]+J[14]-J[15]-J[16]-J[17]+J[18]-J[19]-J[20]+J[21]+J[22]+J[23]-J[24]-J[25]-J[26]+
    J[27]-J[28]-J[29]+J[30]+J[31]-J[32]-J[33]-J[34]+J[35]-J[36]-J[37]+J[38]-J[39]-J[40]-J[41]+J[42]-J[43]-J[44]-J[45]-J[46]-J[47]+
    J[48]-J[49]-J[50]+J[51]+J[52]-J[53]+J[54]+J[55]+J[56]-J[57]+J[58]+J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+
    J[65], +H[0]-H[1]-H[2]-H[3]-H[4]-H[5]+H[6]+H[7]+H[8]-H[9]+H[10]-H[11]-J[0]-J[1]-J[2]-J[3]-J[4]+J[5]+
    J[6]+J[7]-J[8]+J[9]-J[10]+J[11]+J[12]+J[13]+J[14]-J[15]-J[16]-J[17]+J[18]-J[19]+J[20]+J[21]+J[22]+J[23]-J[24]-J[25]-J[26]+
    J[27]-J[28]+J[29]+J[30]+J[31]-J[32]-J[33]-J[34]+J[35]-J[36]+J[37]+J[38]-J[39]-J[40]-J[41]+J[42]-J[43]+
    J[44]-J[45]-J[46]-J[47]+J[48]-J[49]+J[50]+J[51]+J[52]-J[53]+J[54]-J[55]+J[56]-J[57]+J[58]-J[59]-J[60]+
    J[61]-J[62]-J[63]+J[64]-J[65], +H[0]-H[1]-H[2]-H[3]-H[4]-H[5]+H[6]+H[7]+H[8]-H[9]-H[10]+H[11]-J[0]-J[1]-J[2]-J[3]-J[4]+
    J[5]+J[6]+J[7]-J[8]-J[9]+J[10]+J[11]+J[12]+J[13]+J[14]-J[15]-J[16]-J[17]+J[18]+J[19]-J[20]+J[21]+J[22]+
    J[23]-J[24]-J[25]-J[26]+J[27]+J[28]-J[29]+J[30]+J[31]-J[32]-J[33]-J[34]+J[35]+J[36]-J[37]+J[38]-J[39]-J[40]-J[41]+
    J[42]+J[43]-J[44]-J[45]-J[46]-J[47]+J[48]+J[49]-J[50]+J[51]+J[52]-J[53]-J[54]+J[55]+J[56]-J[57]-J[58]+
    J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]-H[1]-H[2]-H[3]-H[4]-H[5]+H[6]+H[7]+H[8]-H[9]-H[10]-H[11]-J[0]-J[1]-J[2]-J[3]-J[4]+
    J[5]+J[6]+J[7]-J[8]-J[9]-J[10]+J[11]+J[12]+J[13]+J[14]-J[15]-J[16]-J[17]+J[18]+J[19]+J[20]+J[21]+J[22]+
    J[23]-J[24]-J[25]-J[26]+J[27]+J[28]+J[29]+J[30]+J[31]-J[32]-J[33]-J[34]+J[35]+J[36]+J[37]+J[38]-J[39]-J[40]-J[41]+
    J[42]+J[43]+J[44]-J[45]-J[46]-J[47]+J[48]+J[49]+J[50]+J[51]+J[52]-J[53]-J[54]-J[55]+J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+
    J[63]+J[64]+J[65], +H[0]-H[1]-H[2]-H[3]-H[4]-H[5]+H[6]+H[7]-H[8]+H[9]+H[10]+H[11]-J[0]-J[1]-J[2]-J[3]-J[4]+
    J[5]+J[6]-J[7]+J[8]+J[9]+J[10]+J[11]+J[12]+J[13]+J[14]-J[15]-J[16]+J[17]-J[18]-J[19]-J[20]+J[21]+J[22]+
    J[23]-J[24]-J[25]+J[26]-J[27]-J[28]-J[29]+J[30]+J[31]-J[32]-J[33]+J[34]-J[35]-J[36]-J[37]+J[38]-J[39]-J[40]+
    J[41]-J[42]-J[43]-J[44]-J[45]-J[46]+J[47]-J[48]-J[49]-J[50]+J[51]-J[52]+J[53]+J[54]+J[55]-J[56]+J[57]+
    J[58]+J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]-H[1]-H[2]-H[3]-H[4]-H[5]+H[6]+H[7]-H[8]+H[9]+
    H[10]-H[11]-J[0]-J[1]-J[2]-J[3]-J[4]+J[5]+J[6]-J[7]+J[8]+J[9]-J[10]+J[11]+J[12]+J[13]+J[14]-J[15]-J[16]+
    J[17]-J[18]-J[19]+J[20]+J[21]+J[22]+J[23]-J[24]-J[25]+J[26]-J[27]-J[28]+J[29]+J[30]+J[31]-J[32]-J[33]+
    J[34]-J[35]-J[36]+J[37]+J[38]-J[39]-J[40]+J[41]-J[42]-J[43]+J[44]-J[45]-J[46]+J[47]-J[48]-J[49]+J[50]+
    J[51]-J[52]+J[53]+J[54]-J[55]-J[56]+J[57]+J[58]-J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]-H[1]-H[2]-H[3]-H[4]-H[5]+
    H[6]+H[7]-H[8]+H[9]-H[10]+H[11]-J[0]-J[1]-J[2]-J[3]-J[4]+J[5]+J[6]-J[7]+J[8]-J[9]+J[10]+J[11]+J[12]+
    J[13]+J[14]-J[15]-J[16]+J[17]-J[18]+J[19]-J[20]+J[21]+J[22]+J[23]-J[24]-J[25]+J[26]-J[27]+J[28]-J[29]+
    J[30]+J[31]-J[32]-J[33]+J[34]-J[35]+J[36]-J[37]+J[38]-J[39]-J[40]+J[41]-J[42]+J[43]-J[44]-J[45]-J[46]+
    J[47]-J[48]+J[49]-J[50]+J[51]-J[52]+J[53]-J[54]+J[55]-J[56]+J[57]-J[58]+J[59]-J[60]+J[61]-J[62]-J[63]+
    J[64]-J[65], +H[0]-H[1]-H[2]-H[3]-H[4]-H[5]+H[6]+H[7]-H[8]+H[9]-H[10]-H[11]-J[0]-J[1]-J[2]-J[3]-J[4]+
    J[5]+J[6]-J[7]+J[8]-J[9]-J[10]+J[11]+J[12]+J[13]+J[14]-J[15]-J[16]+J[17]-J[18]+J[19]+J[20]+J[21]+J[22]+
    J[23]-J[24]-J[25]+J[26]-J[27]+J[28]+J[29]+J[30]+J[31]-J[32]-J[33]+J[34]-J[35]+J[36]+J[37]+J[38]-J[39]-J[40]+
    J[41]-J[42]+J[43]+J[44]-J[45]-J[46]+J[47]-J[48]+J[49]+J[50]+J[51]-J[52]+J[53]-J[54]-J[55]-J[56]+J[57]-J[58]-J[59]-J[60]+
    J[61]+J[62]-J[63]-J[64]+J[65], +H[0]-H[1]-H[2]-H[3]-H[4]-H[5]+H[6]+H[7]-H[8]-H[9]+H[10]+H[11]-J[0]-J[1]-J[2]-J[3]-J[4]+
    J[5]+J[6]-J[7]-J[8]+J[9]+J[10]+J[11]+J[12]+J[13]+J[14]-J[15]-J[16]+J[17]+J[18]-J[19]-J[20]+J[21]+J[22]+
    J[23]-J[24]-J[25]+J[26]+J[27]-J[28]-J[29]+J[30]+J[31]-J[32]-J[33]+J[34]+J[35]-J[36]-J[37]+J[38]-J[39]-J[40]+
    J[41]+J[42]-J[43]-J[44]-J[45]-J[46]+J[47]+J[48]-J[49]-J[50]+J[51]-J[52]-J[53]+J[54]+J[55]-J[56]-J[57]+
    J[58]+J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]-H[1]-H[2]-H[3]-H[4]-H[5]+H[6]+H[7]-H[8]-H[9]+
    H[10]-H[11]-J[0]-J[1]-J[2]-J[3]-J[4]+J[5]+J[6]-J[7]-J[8]+J[9]-J[10]+J[11]+J[12]+J[13]+J[14]-J[15]-J[16]+
    J[17]+J[18]-J[19]+J[20]+J[21]+J[22]+J[23]-J[24]-J[25]+J[26]+J[27]-J[28]+J[29]+J[30]+J[31]-J[32]-J[33]+
    J[34]+J[35]-J[36]+J[37]+J[38]-J[39]-J[40]+J[41]+J[42]-J[43]+J[44]-J[45]-J[46]+J[47]+J[48]-J[49]+J[50]+
    J[51]-J[52]-J[53]+J[54]-J[55]-J[56]-J[57]+J[58]-J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]-H[1]-H[2]-H[3]-H[4]-H[5]+
    H[6]+H[7]-H[8]-H[9]-H[10]+H[11]-J[0]-J[1]-J[2]-J[3]-J[4]+J[5]+J[6]-J[7]-J[8]-J[9]+J[10]+J[11]+J[12]+
    J[13]+J[14]-J[15]-J[16]+J[17]+J[18]+J[19]-J[20]+J[21]+J[22]+J[23]-J[24]-J[25]+J[26]+J[27]+J[28]-J[29]+
    J[30]+J[31]-J[32]-J[33]+J[34]+J[35]+J[36]-J[37]+J[38]-J[39]-J[40]+J[41]+J[42]+J[43]-J[44]-J[45]-J[46]+
    J[47]+J[48]+J[49]-J[50]+J[51]-J[52]-J[53]-J[54]+J[55]-J[56]-J[57]-J[58]+J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +
    H[0]-H[1]-H[2]-H[3]-H[4]-H[5]+H[6]+H[7]-H[8]-H[9]-H[10]-H[11]-J[0]-J[1]-J[2]-J[3]-J[4]+J[5]+J[6]-J[7]-J[8]-J[9]-J[10]+
    J[11]+J[12]+J[13]+J[14]-J[15]-J[16]+J[17]+J[18]+J[19]+J[20]+J[21]+J[22]+J[23]-J[24]-J[25]+J[26]+J[27]+
    J[28]+J[29]+J[30]+J[31]-J[32]-J[33]+J[34]+J[35]+J[36]+J[37]+J[38]-J[39]-J[40]+J[41]+J[42]+J[43]+J[44]-J[45]-J[46]+
    J[47]+J[48]+J[49]+J[50]+J[51]-J[52]-J[53]-J[54]-J[55]-J[56]-J[57]-J[58]-J[59]+J[60]+J[61]+J[62]+J[63]+
    J[64]+J[65], +H[0]-H[1]-H[2]-H[3]-H[4]-H[5]+H[6]-H[7]+H[8]+H[9]+H[10]+H[11]-J[0]-J[1]-J[2]-J[3]-J[4]+
    J[5]-J[6]+J[7]+J[8]+J[9]+J[10]+J[11]+J[12]+J[13]+J[14]-J[15]+J[16]-J[17]-J[18]-J[19]-J[20]+J[21]+J[22]+
    J[23]-J[24]+J[25]-J[26]-J[27]-J[28]-J[29]+J[30]+J[31]-J[32]+J[33]-J[34]-J[35]-J[36]-J[37]+J[38]-J[39]+
    J[40]-J[41]-J[42]-J[43]-J[44]-J[45]+J[46]-J[47]-J[48]-J[49]-J[50]-J[51]+J[52]+J[53]+J[54]+J[55]-J[56]-J[57]-J[58]-J[59]+
    J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]-H[1]-H[2]-H[3]-H[4]-H[5]+H[6]-H[7]+H[8]+H[9]+H[10]-H[11]-J[0]-J[1]-J[2]-J[3]-J[4]+
    J[5]-J[6]+J[7]+J[8]+J[9]-J[10]+J[11]+J[12]+J[13]+J[14]-J[15]+J[16]-J[17]-J[18]-J[19]+J[20]+J[21]+J[22]+
    J[23]-J[24]+J[25]-J[26]-J[27]-J[28]+J[29]+J[30]+J[31]-J[32]+J[33]-J[34]-J[35]-J[36]+J[37]+J[38]-J[39]+
    J[40]-J[41]-J[42]-J[43]+J[44]-J[45]+J[46]-J[47]-J[48]-J[49]+J[50]-J[51]+J[52]+J[53]+J[54]-J[55]-J[56]-J[57]-J[58]+
    J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]-H[1]-H[2]-H[3]-H[4]-H[5]+H[6]-H[7]+H[8]+H[9]-H[10]+
    H[11]-J[0]-J[1]-J[2]-J[3]-J[4]+J[5]-J[6]+J[7]+J[8]-J[9]+J[10]+J[11]+J[12]+J[13]+J[14]-J[15]+J[16]-J[17]-J[18]+
    J[19]-J[20]+J[21]+J[22]+J[23]-J[24]+J[25]-J[26]-J[27]+J[28]-J[29]+J[30]+J[31]-J[32]+J[33]-J[34]-J[35]+
    J[36]-J[37]+J[38]-J[39]+J[40]-J[41]-J[42]+J[43]-J[44]-J[45]+J[46]-J[47]-J[48]+J[49]-J[50]-J[51]+J[52]+
    J[53]-J[54]+J[55]-J[56]-J[57]+J[58]-J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]-H[1]-H[2]-H[3]-H[4]-H[5]+
    H[6]-H[7]+H[8]+H[9]-H[10]-H[11]-J[0]-J[1]-J[2]-J[3]-J[4]+J[5]-J[6]+J[7]+J[8]-J[9]-J[10]+J[11]+J[12]+
    J[13]+J[14]-J[15]+J[16]-J[17]-J[18]+J[19]+J[20]+J[21]+J[22]+J[23]-J[24]+J[25]-J[26]-J[27]+J[28]+J[29]+
    J[30]+J[31]-J[32]+J[33]-J[34]-J[35]+J[36]+J[37]+J[38]-J[39]+J[40]-J[41]-J[42]+J[43]+J[44]-J[45]+J[46]-J[47]-J[48]+
    J[49]+J[50]-J[51]+J[52]+J[53]-J[54]-J[55]-J[56]-J[57]+J[58]+J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +
    H[0]-H[1]-H[2]-H[3]-H[4]-H[5]+H[6]-H[7]+H[8]-H[9]+H[10]+H[11]-J[0]-J[1]-J[2]-J[3]-J[4]+J[5]-J[6]+J[7]-J[8]+
    J[9]+J[10]+J[11]+J[12]+J[13]+J[14]-J[15]+J[16]-J[17]+J[18]-J[19]-J[20]+J[21]+J[22]+J[23]-J[24]+J[25]-J[26]+
    J[27]-J[28]-J[29]+J[30]+J[31]-J[32]+J[33]-J[34]+J[35]-J[36]-J[37]+J[38]-J[39]+J[40]-J[41]+J[42]-J[43]-J[44]-J[45]+
    J[46]-J[47]+J[48]-J[49]-J[50]-J[51]+J[52]-J[53]+J[54]+J[55]-J[56]+J[57]-J[58]-J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+
    J[65], +H[0]-H[1]-H[2]-H[3]-H[4]-H[5]+H[6]-H[7]+H[8]-H[9]+H[10]-H[11]-J[0]-J[1]-J[2]-J[3]-J[4]+J[5]-J[6]+
    J[7]-J[8]+J[9]-J[10]+J[11]+J[12]+J[13]+J[14]-J[15]+J[16]-J[17]+J[18]-J[19]+J[20]+J[21]+J[22]+J[23]-J[24]+
    J[25]-J[26]+J[27]-J[28]+J[29]+J[30]+J[31]-J[32]+J[33]-J[34]+J[35]-J[36]+J[37]+J[38]-J[39]+J[40]-J[41]+
    J[42]-J[43]+J[44]-J[45]+J[46]-J[47]+J[48]-J[49]+J[50]-J[51]+J[52]-J[53]+J[54]-J[55]-J[56]+J[57]-J[58]+
    J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]-H[1]-H[2]-H[3]-H[4]-H[5]+H[6]-H[7]+H[8]-H[9]-H[10]+
    H[11]-J[0]-J[1]-J[2]-J[3]-J[4]+J[5]-J[6]+J[7]-J[8]-J[9]+J[10]+J[11]+J[12]+J[13]+J[14]-J[15]+J[16]-J[17]+
    J[18]+J[19]-J[20]+J[21]+J[22]+J[23]-J[24]+J[25]-J[26]+J[27]+J[28]-J[29]+J[30]+J[31]-J[32]+J[33]-J[34]+
    J[35]+J[36]-J[37]+J[38]-J[39]+J[40]-J[41]+J[42]+J[43]-J[44]-J[45]+J[46]-J[47]+J[48]+J[49]-J[50]-J[51]+
    J[52]-J[53]-J[54]+J[55]-J[56]+J[57]+J[58]-J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]-H[1]-H[2]-H[3]-H[4]-H[5]+
    H[6]-H[7]+H[8]-H[9]-H[10]-H[11]-J[0]-J[1]-J[2]-J[3]-J[4]+J[5]-J[6]+J[7]-J[8]-J[9]-J[10]+J[11]+J[12]+
    J[13]+J[14]-J[15]+J[16]-J[17]+J[18]+J[19]+J[20]+J[21]+J[22]+J[23]-J[24]+J[25]-J[26]+J[27]+J[28]+J[29]+
    J[30]+J[31]-J[32]+J[33]-J[34]+J[35]+J[36]+J[37]+J[38]-J[39]+J[40]-J[41]+J[42]+J[43]+J[44]-J[45]+J[46]-J[47]+
    J[48]+J[49]+J[50]-J[51]+J[52]-J[53]-J[54]-J[55]-J[56]+J[57]+J[58]+J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+
    J[65], +H[0]-H[1]-H[2]-H[3]-H[4]-H[5]+H[6]-H[7]-H[8]+H[9]+H[10]+H[11]-J[0]-J[1]-J[2]-J[3]-J[4]+J[5]-J[6]-J[7]+
    J[8]+J[9]+J[10]+J[11]+J[12]+J[13]+J[14]-J[15]+J[16]+J[17]-J[18]-J[19]-J[20]+J[21]+J[22]+J[23]-J[24]+
    J[25]+J[26]-J[27]-J[28]-J[29]+J[30]+J[31]-J[32]+J[33]+J[34]-J[35]-J[36]-J[37]+J[38]-J[39]+J[40]+J[41]-J[42]-J[43]-J[44]-J[45]+
    J[46]+J[47]-J[48]-J[49]-J[50]-J[51]-J[52]+J[53]+J[54]+J[55]+J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+
    J[63]+J[64]+J[65], +H[0]-H[1]-H[2]-H[3]-H[4]-H[5]+H[6]-H[7]-H[8]+H[9]+H[10]-H[11]-J[0]-J[1]-J[2]-J[3]-J[4]+
    J[5]-J[6]-J[7]+J[8]+J[9]-J[10]+J[11]+J[12]+J[13]+J[14]-J[15]+J[16]+J[17]-J[18]-J[19]+J[20]+J[21]+J[22]+
    J[23]-J[24]+J[25]+J[26]-J[27]-J[28]+J[29]+J[30]+J[31]-J[32]+J[33]+J[34]-J[35]-J[36]+J[37]+J[38]-J[39]+
    J[40]+J[41]-J[42]-J[43]+J[44]-J[45]+J[46]+J[47]-J[48]-J[49]+J[50]-J[51]-J[52]+J[53]+J[54]-J[55]+J[56]-J[57]-J[58]+
    J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]-H[1]-H[2]-H[3]-H[4]-H[5]+H[6]-H[7]-H[8]+H[9]-H[10]+
    H[11]-J[0]-J[1]-J[2]-J[3]-J[4]+J[5]-J[6]-J[7]+J[8]-J[9]+J[10]+J[11]+J[12]+J[13]+J[14]-J[15]+J[16]+J[17]-J[18]+
    J[19]-J[20]+J[21]+J[22]+J[23]-J[24]+J[25]+J[26]-J[27]+J[28]-J[29]+J[30]+J[31]-J[32]+J[33]+J[34]-J[35]+
    J[36]-J[37]+J[38]-J[39]+J[40]+J[41]-J[42]+J[43]-J[44]-J[45]+J[46]+J[47]-J[48]+J[49]-J[50]-J[51]-J[52]+
    J[53]-J[54]+J[55]+J[56]-J[57]+J[58]-J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]-H[1]-H[2]-H[3]-H[4]-H[5]+
    H[6]-H[7]-H[8]+H[9]-H[10]-H[11]-J[0]-J[1]-J[2]-J[3]-J[4]+J[5]-J[6]-J[7]+J[8]-J[9]-J[10]+J[11]+J[12]+
    J[13]+J[14]-J[15]+J[16]+J[17]-J[18]+J[19]+J[20]+J[21]+J[22]+J[23]-J[24]+J[25]+J[26]-J[27]+J[28]+J[29]+
    J[30]+J[31]-J[32]+J[33]+J[34]-J[35]+J[36]+J[37]+J[38]-J[39]+J[40]+J[41]-J[42]+J[43]+J[44]-J[45]+J[46]+
    J[47]-J[48]+J[49]+J[50]-J[51]-J[52]+J[53]-J[54]-J[55]+J[56]-J[57]+J[58]+J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+
    J[65], +H[0]-H[1]-H[2]-H[3]-H[4]-H[5]+H[6]-H[7]-H[8]-H[9]+H[10]+H[11]-J[0]-J[1]-J[2]-J[3]-J[4]+J[5]-J[6]-J[7]-J[8]+
    J[9]+J[10]+J[11]+J[12]+J[13]+J[14]-J[15]+J[16]+J[17]+J[18]-J[19]-J[20]+J[21]+J[22]+J[23]-J[24]+J[25]+
    J[26]+J[27]-J[28]-J[29]+J[30]+J[31]-J[32]+J[33]+J[34]+J[35]-J[36]-J[37]+J[38]-J[39]+J[40]+J[41]+J[42]-J[43]-J[44]-J[45]+
    J[46]+J[47]+J[48]-J[49]-J[50]-J[51]-J[52]-J[53]+J[54]+J[55]+J[56]+J[57]-J[58]-J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+
    J[65], +H[0]-H[1]-H[2]-H[3]-H[4]-H[5]+H[6]-H[7]-H[8]-H[9]+H[10]-H[11]-J[0]-J[1]-J[2]-J[3]-J[4]+J[5]-J[6]-J[7]-J[8]+
    J[9]-J[10]+J[11]+J[12]+J[13]+J[14]-J[15]+J[16]+J[17]+J[18]-J[19]+J[20]+J[21]+J[22]+J[23]-J[24]+J[25]+
    J[26]+J[27]-J[28]+J[29]+J[30]+J[31]-J[32]+J[33]+J[34]+J[35]-J[36]+J[37]+J[38]-J[39]+J[40]+J[41]+J[42]-J[43]+
    J[44]-J[45]+J[46]+J[47]+J[48]-J[49]+J[50]-J[51]-J[52]-J[53]+J[54]-J[55]+J[56]+J[57]-J[58]+J[59]+J[60]-J[61]+
    J[62]-J[63]+J[64]-J[65], +H[0]-H[1]-H[2]-H[3]-H[4]-H[5]+H[6]-H[7]-H[8]-H[9]-H[10]+H[11]-J[0]-J[1]-J[2]-J[3]-J[4]+
    J[5]-J[6]-J[7]-J[8]-J[9]+J[10]+J[11]+J[12]+J[13]+J[14]-J[15]+J[16]+J[17]+J[18]+J[19]-J[20]+J[21]+J[22]+
    J[23]-J[24]+J[25]+J[26]+J[27]+J[28]-J[29]+J[30]+J[31]-J[32]+J[33]+J[34]+J[35]+J[36]-J[37]+J[38]-J[39]+
    J[40]+J[41]+J[42]+J[43]-J[44]-J[45]+J[46]+J[47]+J[48]+J[49]-J[50]-J[51]-J[52]-J[53]-J[54]+J[55]+J[56]+
    J[57]+J[58]-J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]-H[1]-H[2]-H[3]-H[4]-H[5]+H[6]-H[7]-H[8]-H[9]-H[10]-H[11]-J[0]-J[1]-J[2]-J[3]-J[4]+
    J[5]-J[6]-J[7]-J[8]-J[9]-J[10]+J[11]+J[12]+J[13]+J[14]-J[15]+J[16]+J[17]+J[18]+J[19]+J[20]+J[21]+J[22]+
    J[23]-J[24]+J[25]+J[26]+J[27]+J[28]+J[29]+J[30]+J[31]-J[32]+J[33]+J[34]+J[35]+J[36]+J[37]+J[38]-J[39]+
    J[40]+J[41]+J[42]+J[43]+J[44]-J[45]+J[46]+J[47]+J[48]+J[49]+J[50]-J[51]-J[52]-J[53]-J[54]-J[55]+J[56]+
    J[57]+J[58]+J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]-H[1]-H[2]-H[3]-H[4]-H[5]-H[6]+H[7]+H[8]+
    H[9]+H[10]+H[11]-J[0]-J[1]-J[2]-J[3]-J[4]-J[5]+J[6]+J[7]+J[8]+J[9]+J[10]+J[11]+J[12]+J[13]+J[14]+J[15]-J[16]-J[17]-J[18]-J[19]-J[20]+
    J[21]+J[22]+J[23]+J[24]-J[25]-J[26]-J[27]-J[28]-J[29]+J[30]+J[31]+J[32]-J[33]-J[34]-J[35]-J[36]-J[37]+
    J[38]+J[39]-J[40]-J[41]-J[42]-J[43]-J[44]+J[45]-J[46]-J[47]-J[48]-J[49]-J[50]-J[51]-J[52]-J[53]-J[54]-J[55]+
    J[56]+J[57]+J[58]+J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], +H[0]-H[1]-H[2]-H[3]-H[4]-H[5]-H[6]+H[7]+
    H[8]+H[9]+H[10]-H[11]-J[0]-J[1]-J[2]-J[3]-J[4]-J[5]+J[6]+J[7]+J[8]+J[9]-J[10]+J[11]+J[12]+J[13]+J[14]+
    J[15]-J[16]-J[17]-J[18]-J[19]+J[20]+J[21]+J[22]+J[23]+J[24]-J[25]-J[26]-J[27]-J[28]+J[29]+J[30]+J[31]+
    J[32]-J[33]-J[34]-J[35]-J[36]+J[37]+J[38]+J[39]-J[40]-J[41]-J[42]-J[43]+J[44]+J[45]-J[46]-J[47]-J[48]-J[49]+
    J[50]-J[51]-J[52]-J[53]-J[54]+J[55]+J[56]+J[57]+J[58]-J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +H[0]-H[1]-H[2]-H[3]-H[4]-H[5]-H[6]+
    H[7]+H[8]+H[9]-H[10]+H[11]-J[0]-J[1]-J[2]-J[3]-J[4]-J[5]+J[6]+J[7]+J[8]-J[9]+J[10]+J[11]+J[12]+J[13]+
    J[14]+J[15]-J[16]-J[17]-J[18]+J[19]-J[20]+J[21]+J[22]+J[23]+J[24]-J[25]-J[26]-J[27]+J[28]-J[29]+J[30]+
    J[31]+J[32]-J[33]-J[34]-J[35]+J[36]-J[37]+J[38]+J[39]-J[40]-J[41]-J[42]+J[43]-J[44]+J[45]-J[46]-J[47]-J[48]+
    J[49]-J[50]-J[51]-J[52]-J[53]+J[54]-J[55]+J[56]+J[57]-J[58]+J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +
    H[0]-H[1]-H[2]-H[3]-H[4]-H[5]-H[6]+H[7]+H[8]+H[9]-H[10]-H[11]-J[0]-J[1]-J[2]-J[3]-J[4]-J[5]+J[6]+J[7]+
    J[8]-J[9]-J[10]+J[11]+J[12]+J[13]+J[14]+J[15]-J[16]-J[17]-J[18]+J[19]+J[20]+J[21]+J[22]+J[23]+J[24]-J[25]-J[26]-J[27]+
    J[28]+J[29]+J[30]+J[31]+J[32]-J[33]-J[34]-J[35]+J[36]+J[37]+J[38]+J[39]-J[40]-J[41]-J[42]+J[43]+J[44]+
    J[45]-J[46]-J[47]-J[48]+J[49]+J[50]-J[51]-J[52]-J[53]+J[54]+J[55]+J[56]+J[57]-J[58]-J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+
    J[65], +H[0]-H[1]-H[2]-H[3]-H[4]-H[5]-H[6]+H[7]+H[8]-H[9]+H[10]+H[11]-J[0]-J[1]-J[2]-J[3]-J[4]-J[5]+
    J[6]+J[7]-J[8]+J[9]+J[10]+J[11]+J[12]+J[13]+J[14]+J[15]-J[16]-J[17]+J[18]-J[19]-J[20]+J[21]+J[22]+J[23]+
    J[24]-J[25]-J[26]+J[27]-J[28]-J[29]+J[30]+J[31]+J[32]-J[33]-J[34]+J[35]-J[36]-J[37]+J[38]+J[39]-J[40]-J[41]+
    J[42]-J[43]-J[44]+J[45]-J[46]-J[47]+J[48]-J[49]-J[50]-J[51]-J[52]+J[53]-J[54]-J[55]+J[56]-J[57]+J[58]+
    J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], +H[0]-H[1]-H[2]-H[3]-H[4]-H[5]-H[6]+H[7]+H[8]-H[9]+H[10]-H[11]-J[0]-J[1]-J[2]-J[3]-J[4]-J[5]+
    J[6]+J[7]-J[8]+J[9]-J[10]+J[11]+J[12]+J[13]+J[14]+J[15]-J[16]-J[17]+J[18]-J[19]+J[20]+J[21]+J[22]+J[23]+
    J[24]-J[25]-J[26]+J[27]-J[28]+J[29]+J[30]+J[31]+J[32]-J[33]-J[34]+J[35]-J[36]+J[37]+J[38]+J[39]-J[40]-J[41]+
    J[42]-J[43]+J[44]+J[45]-J[46]-J[47]+J[48]-J[49]+J[50]-J[51]-J[52]+J[53]-J[54]+J[55]+J[56]-J[57]+J[58]-J[59]-J[60]+
    J[61]-J[62]-J[63]+J[64]-J[65], +H[0]-H[1]-H[2]-H[3]-H[4]-H[5]-H[6]+H[7]+H[8]-H[9]-H[10]+H[11]-J[0]-J[1]-J[2]-J[3]-J[4]-J[5]+
    J[6]+J[7]-J[8]-J[9]+J[10]+J[11]+J[12]+J[13]+J[14]+J[15]-J[16]-J[17]+J[18]+J[19]-J[20]+J[21]+J[22]+J[23]+
    J[24]-J[25]-J[26]+J[27]+J[28]-J[29]+J[30]+J[31]+J[32]-J[33]-J[34]+J[35]+J[36]-J[37]+J[38]+J[39]-J[40]-J[41]+
    J[42]+J[43]-J[44]+J[45]-J[46]-J[47]+J[48]+J[49]-J[50]-J[51]-J[52]+J[53]+J[54]-J[55]+J[56]-J[57]-J[58]+
    J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]-H[1]-H[2]-H[3]-H[4]-H[5]-H[6]+H[7]+H[8]-H[9]-H[10]-H[11]-J[0]-J[1]-J[2]-J[3]-J[4]-J[5]+
    J[6]+J[7]-J[8]-J[9]-J[10]+J[11]+J[12]+J[13]+J[14]+J[15]-J[16]-J[17]+J[18]+J[19]+J[20]+J[21]+J[22]+J[23]+
    J[24]-J[25]-J[26]+J[27]+J[28]+J[29]+J[30]+J[31]+J[32]-J[33]-J[34]+J[35]+J[36]+J[37]+J[38]+J[39]-J[40]-J[41]+
    J[42]+J[43]+J[44]+J[45]-J[46]-J[47]+J[48]+J[49]+J[50]-J[51]-J[52]+J[53]+J[54]+J[55]+J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+
    J[63]+J[64]+J[65], +H[0]-H[1]-H[2]-H[3]-H[4]-H[5]-H[6]+H[7]-H[8]+H[9]+H[10]+H[11]-J[0]-J[1]-J[2]-J[3]-J[4]-J[5]+
    J[6]-J[7]+J[8]+J[9]+J[10]+J[11]+J[12]+J[13]+J[14]+J[15]-J[16]+J[17]-J[18]-J[19]-J[20]+J[21]+J[22]+J[23]+
    J[24]-J[25]+J[26]-J[27]-J[28]-J[29]+J[30]+J[31]+J[32]-J[33]+J[34]-J[35]-J[36]-J[37]+J[38]+J[39]-J[40]+
    J[41]-J[42]-J[43]-J[44]+J[45]-J[46]+J[47]-J[48]-J[49]-J[50]-J[51]+J[52]-J[53]-J[54]-J[55]-J[56]+J[57]+
    J[58]+J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +H[0]-H[1]-H[2]-H[3]-H[4]-H[5]-H[6]+H[7]-H[8]+H[9]+
    H[10]-H[11]-J[0]-J[1]-J[2]-J[3]-J[4]-J[5]+J[6]-J[7]+J[8]+J[9]-J[10]+J[11]+J[12]+J[13]+J[14]+J[15]-J[16]+
    J[17]-J[18]-J[19]+J[20]+J[21]+J[22]+J[23]+J[24]-J[25]+J[26]-J[27]-J[28]+J[29]+J[30]+J[31]+J[32]-J[33]+
    J[34]-J[35]-J[36]+J[37]+J[38]+J[39]-J[40]+J[41]-J[42]-J[43]+J[44]+J[45]-J[46]+J[47]-J[48]-J[49]+J[50]-J[51]+
    J[52]-J[53]-J[54]+J[55]-J[56]+J[57]+J[58]-J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]-H[1]-H[2]-H[3]-H[4]-H[5]-H[6]+
    H[7]-H[8]+H[9]-H[10]+H[11]-J[0]-J[1]-J[2]-J[3]-J[4]-J[5]+J[6]-J[7]+J[8]-J[9]+J[10]+J[11]+J[12]+J[13]+
    J[14]+J[15]-J[16]+J[17]-J[18]+J[19]-J[20]+J[21]+J[22]+J[23]+J[24]-J[25]+J[26]-J[27]+J[28]-J[29]+J[30]+
    J[31]+J[32]-J[33]+J[34]-J[35]+J[36]-J[37]+J[38]+J[39]-J[40]+J[41]-J[42]+J[43]-J[44]+J[45]-J[46]+J[47]-J[48]+
    J[49]-J[50]-J[51]+J[52]-J[53]+J[54]-J[55]-J[56]+J[57]-J[58]+J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +
    H[0]-H[1]-H[2]-H[3]-H[4]-H[5]-H[6]+H[7]-H[8]+H[9]-H[10]-H[11]-J[0]-J[1]-J[2]-J[3]-J[4]-J[5]+J[6]-J[7]+
    J[8]-J[9]-J[10]+J[11]+J[12]+J[13]+J[14]+J[15]-J[16]+J[17]-J[18]+J[19]+J[20]+J[21]+J[22]+J[23]+J[24]-J[25]+
    J[26]-J[27]+J[28]+J[29]+J[30]+J[31]+J[32]-J[33]+J[34]-J[35]+J[36]+J[37]+J[38]+J[39]-J[40]+J[41]-J[42]+
    J[43]+J[44]+J[45]-J[46]+J[47]-J[48]+J[49]+J[50]-J[51]+J[52]-J[53]+J[54]+J[55]-J[56]+J[57]-J[58]-J[59]-J[60]+
    J[61]+J[62]-J[63]-J[64]+J[65], +H[0]-H[1]-H[2]-H[3]-H[4]-H[5]-H[6]+H[7]-H[8]-H[9]+H[10]+H[11]-J[0]-J[1]-J[2]-J[3]-J[4]-J[5]+
    J[6]-J[7]-J[8]+J[9]+J[10]+J[11]+J[12]+J[13]+J[14]+J[15]-J[16]+J[17]+J[18]-J[19]-J[20]+J[21]+J[22]+J[23]+
    J[24]-J[25]+J[26]+J[27]-J[28]-J[29]+J[30]+J[31]+J[32]-J[33]+J[34]+J[35]-J[36]-J[37]+J[38]+J[39]-J[40]+
    J[41]+J[42]-J[43]-J[44]+J[45]-J[46]+J[47]+J[48]-J[49]-J[50]-J[51]+J[52]+J[53]-J[54]-J[55]-J[56]-J[57]+
    J[58]+J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]-H[1]-H[2]-H[3]-H[4]-H[5]-H[6]+H[7]-H[8]-H[9]+
    H[10]-H[11]-J[0]-J[1]-J[2]-J[3]-J[4]-J[5]+J[6]-J[7]-J[8]+J[9]-J[10]+J[11]+J[12]+J[13]+J[14]+J[15]-J[16]+
    J[17]+J[18]-J[19]+J[20]+J[21]+J[22]+J[23]+J[24]-J[25]+J[26]+J[27]-J[28]+J[29]+J[30]+J[31]+J[32]-J[33]+
    J[34]+J[35]-J[36]+J[37]+J[38]+J[39]-J[40]+J[41]+J[42]-J[43]+J[44]+J[45]-J[46]+J[47]+J[48]-J[49]+J[50]-J[51]+
    J[52]+J[53]-J[54]+J[55]-J[56]-J[57]+J[58]-J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]-H[1]-H[2]-H[3]-H[4]-H[5]-H[6]+
    H[7]-H[8]-H[9]-H[10]+H[11]-J[0]-J[1]-J[2]-J[3]-J[4]-J[5]+J[6]-J[7]-J[8]-J[9]+J[10]+J[11]+J[12]+J[13]+
    J[14]+J[15]-J[16]+J[17]+J[18]+J[19]-J[20]+J[21]+J[22]+J[23]+J[24]-J[25]+J[26]+J[27]+J[28]-J[29]+J[30]+
    J[31]+J[32]-J[33]+J[34]+J[35]+J[36]-J[37]+J[38]+J[39]-J[40]+J[41]+J[42]+J[43]-J[44]+J[45]-J[46]+J[47]+
    J[48]+J[49]-J[50]-J[51]+J[52]+J[53]+J[54]-J[55]-J[56]-J[57]-J[58]+J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], +
    H[0]-H[1]-H[2]-H[3]-H[4]-H[5]-H[6]+H[7]-H[8]-H[9]-H[10]-H[11]-J[0]-J[1]-J[2]-J[3]-J[4]-J[5]+J[6]-J[7]-J[8]-J[9]-J[10]+
    J[11]+J[12]+J[13]+J[14]+J[15]-J[16]+J[17]+J[18]+J[19]+J[20]+J[21]+J[22]+J[23]+J[24]-J[25]+J[26]+J[27]+
    J[28]+J[29]+J[30]+J[31]+J[32]-J[33]+J[34]+J[35]+J[36]+J[37]+J[38]+J[39]-J[40]+J[41]+J[42]+J[43]+J[44]+
    J[45]-J[46]+J[47]+J[48]+J[49]+J[50]-J[51]+J[52]+J[53]+J[54]+J[55]-J[56]-J[57]-J[58]-J[59]+J[60]+J[61]+
    J[62]+J[63]+J[64]+J[65], +H[0]-H[1]-H[2]-H[3]-H[4]-H[5]-H[6]-H[7]+H[8]+H[9]+H[10]+H[11]-J[0]-J[1]-J[2]-J[3]-J[4]-J[5]-J[6]+
    J[7]+J[8]+J[9]+J[10]+J[11]+J[12]+J[13]+J[14]+J[15]+J[16]-J[17]-J[18]-J[19]-J[20]+J[21]+J[22]+J[23]+J[24]+
    J[25]-J[26]-J[27]-J[28]-J[29]+J[30]+J[31]+J[32]+J[33]-J[34]-J[35]-J[36]-J[37]+J[38]+J[39]+J[40]-J[41]-J[42]-J[43]-J[44]+
    J[45]+J[46]-J[47]-J[48]-J[49]-J[50]+J[51]-J[52]-J[53]-J[54]-J[55]-J[56]-J[57]-J[58]-J[59]+J[60]+J[61]+
    J[62]+J[63]+J[64]+J[65], +H[0]-H[1]-H[2]-H[3]-H[4]-H[5]-H[6]-H[7]+H[8]+H[9]+H[10]-H[11]-J[0]-J[1]-J[2]-J[3]-J[4]-J[5]-J[6]+
    J[7]+J[8]+J[9]-J[10]+J[11]+J[12]+J[13]+J[14]+J[15]+J[16]-J[17]-J[18]-J[19]+J[20]+J[21]+J[22]+J[23]+J[24]+
    J[25]-J[26]-J[27]-J[28]+J[29]+J[30]+J[31]+J[32]+J[33]-J[34]-J[35]-J[36]+J[37]+J[38]+J[39]+J[40]-J[41]-J[42]-J[43]+
    J[44]+J[45]+J[46]-J[47]-J[48]-J[49]+J[50]+J[51]-J[52]-J[53]-J[54]+J[55]-J[56]-J[57]-J[58]+J[59]+J[60]+
    J[61]-J[62]+J[63]-J[64]-J[65], +H[0]-H[1]-H[2]-H[3]-H[4]-H[5]-H[6]-H[7]+H[8]+H[9]-H[10]+H[11]-J[0]-J[1]-J[2]-J[3]-J[4]-J[5]-J[6]+
    J[7]+J[8]-J[9]+J[10]+J[11]+J[12]+J[13]+J[14]+J[15]+J[16]-J[17]-J[18]+J[19]-J[20]+J[21]+J[22]+J[23]+J[24]+
    J[25]-J[26]-J[27]+J[28]-J[29]+J[30]+J[31]+J[32]+J[33]-J[34]-J[35]+J[36]-J[37]+J[38]+J[39]+J[40]-J[41]-J[42]+
    J[43]-J[44]+J[45]+J[46]-J[47]-J[48]+J[49]-J[50]+J[51]-J[52]-J[53]+J[54]-J[55]-J[56]-J[57]+J[58]-J[59]+
    J[60]-J[61]+J[62]-J[63]+J[64]-J[65], +H[0]-H[1]-H[2]-H[3]-H[4]-H[5]-H[6]-H[7]+H[8]+H[9]-H[10]-H[11]-J[0]-J[1]-J[2]-J[3]-J[4]-J[5]-J[6]+
    J[7]+J[8]-J[9]-J[10]+J[11]+J[12]+J[13]+J[14]+J[15]+J[16]-J[17]-J[18]+J[19]+J[20]+J[21]+J[22]+J[23]+J[24]+
    J[25]-J[26]-J[27]+J[28]+J[29]+J[30]+J[31]+J[32]+J[33]-J[34]-J[35]+J[36]+J[37]+J[38]+J[39]+J[40]-J[41]-J[42]+
    J[43]+J[44]+J[45]+J[46]-J[47]-J[48]+J[49]+J[50]+J[51]-J[52]-J[53]+J[54]+J[55]-J[56]-J[57]+J[58]+J[59]+
    J[60]-J[61]-J[62]-J[63]-J[64]+J[65], +H[0]-H[1]-H[2]-H[3]-H[4]-H[5]-H[6]-H[7]+H[8]-H[9]+H[10]+H[11]-J[0]-J[1]-J[2]-J[3]-J[4]-J[5]-J[6]+
    J[7]-J[8]+J[9]+J[10]+J[11]+J[12]+J[13]+J[14]+J[15]+J[16]-J[17]+J[18]-J[19]-J[20]+J[21]+J[22]+J[23]+J[24]+
    J[25]-J[26]+J[27]-J[28]-J[29]+J[30]+J[31]+J[32]+J[33]-J[34]+J[35]-J[36]-J[37]+J[38]+J[39]+J[40]-J[41]+
    J[42]-J[43]-J[44]+J[45]+J[46]-J[47]+J[48]-J[49]-J[50]+J[51]-J[52]+J[53]-J[54]-J[55]-J[56]+J[57]-J[58]-J[59]-J[60]+
    J[61]+J[62]-J[63]-J[64]+J[65], +H[0]-H[1]-H[2]-H[3]-H[4]-H[5]-H[6]-H[7]+H[8]-H[9]+H[10]-H[11]-J[0]-J[1]-J[2]-J[3]-J[4]-J[5]-J[6]+
    J[7]-J[8]+J[9]-J[10]+J[11]+J[12]+J[13]+J[14]+J[15]+J[16]-J[17]+J[18]-J[19]+J[20]+J[21]+J[22]+J[23]+J[24]+
    J[25]-J[26]+J[27]-J[28]+J[29]+J[30]+J[31]+J[32]+J[33]-J[34]+J[35]-J[36]+J[37]+J[38]+J[39]+J[40]-J[41]+
    J[42]-J[43]+J[44]+J[45]+J[46]-J[47]+J[48]-J[49]+J[50]+J[51]-J[52]+J[53]-J[54]+J[55]-J[56]+J[57]-J[58]+
    J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], +H[0]-H[1]-H[2]-H[3]-H[4]-H[5]-H[6]-H[7]+H[8]-H[9]-H[10]+
    H[11]-J[0]-J[1]-J[2]-J[3]-J[4]-J[5]-J[6]+J[7]-J[8]-J[9]+J[10]+J[11]+J[12]+J[13]+J[14]+J[15]+J[16]-J[17]+
    J[18]+J[19]-J[20]+J[21]+J[22]+J[23]+J[24]+J[25]-J[26]+J[27]+J[28]-J[29]+J[30]+J[31]+J[32]+J[33]-J[34]+
    J[35]+J[36]-J[37]+J[38]+J[39]+J[40]-J[41]+J[42]+J[43]-J[44]+J[45]+J[46]-J[47]+J[48]+J[49]-J[50]+J[51]-J[52]+
    J[53]+J[54]-J[55]-J[56]+J[57]+J[58]-J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], +H[0]-H[1]-H[2]-H[3]-H[4]-H[5]-H[6]-H[7]+
    H[8]-H[9]-H[10]-H[11]-J[0]-J[1]-J[2]-J[3]-J[4]-J[5]-J[6]+J[7]-J[8]-J[9]-J[10]+J[11]+J[12]+J[13]+J[14]+
    J[15]+J[16]-J[17]+J[18]+J[19]+J[20]+J[21]+J[22]+J[23]+J[24]+J[25]-J[26]+J[27]+J[28]+J[29]+J[30]+J[31]+
    J[32]+J[33]-J[34]+J[35]+J[36]+J[37]+J[38]+J[39]+J[40]-J[41]+J[42]+J[43]+J[44]+J[45]+J[46]-J[47]+J[48]+
    J[49]+J[50]+J[51]-J[52]+J[53]+J[54]+J[55]-J[56]+J[57]+J[58]+J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], +
    H[0]-H[1]-H[2]-H[3]-H[4]-H[5]-H[6]-H[7]-H[8]+H[9]+H[10]+H[11]-J[0]-J[1]-J[2]-J[3]-J[4]-J[5]-J[6]-J[7]+
    J[8]+J[9]+J[10]+J[11]+J[12]+J[13]+J[14]+J[15]+J[16]+J[17]-J[18]-J[19]-J[20]+J[21]+J[22]+J[23]+J[24]+
    J[25]+J[26]-J[27]-J[28]-J[29]+J[30]+J[31]+J[32]+J[33]+J[34]-J[35]-J[36]-J[37]+J[38]+J[39]+J[40]+J[41]-J[42]-J[43]-J[44]+
    J[45]+J[46]+J[47]-J[48]-J[49]-J[50]+J[51]+J[52]-J[53]-J[54]-J[55]+J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+
    J[63]+J[64]+J[65], +H[0]-H[1]-H[2]-H[3]-H[4]-H[5]-H[6]-H[7]-H[8]+H[9]+H[10]-H[11]-J[0]-J[1]-J[2]-J[3]-J[4]-J[5]-J[6]-J[7]+
    J[8]+J[9]-J[10]+J[11]+J[12]+J[13]+J[14]+J[15]+J[16]+J[17]-J[18]-J[19]+J[20]+J[21]+J[22]+J[23]+J[24]+
    J[25]+J[26]-J[27]-J[28]+J[29]+J[30]+J[31]+J[32]+J[33]+J[34]-J[35]-J[36]+J[37]+J[38]+J[39]+J[40]+J[41]-J[42]-J[43]+
    J[44]+J[45]+J[46]+J[47]-J[48]-J[49]+J[50]+J[51]+J[52]-J[53]-J[54]+J[55]+J[56]-J[57]-J[58]+J[59]-J[60]-J[61]+
    J[62]+J[63]-J[64]-J[65], +H[0]-H[1]-H[2]-H[3]-H[4]-H[5]-H[6]-H[7]-H[8]+H[9]-H[10]+H[11]-J[0]-J[1]-J[2]-J[3]-J[4]-J[5]-J[6]-J[7]+
    J[8]-J[9]+J[10]+J[11]+J[12]+J[13]+J[14]+J[15]+J[16]+J[17]-J[18]+J[19]-J[20]+J[21]+J[22]+J[23]+J[24]+
    J[25]+J[26]-J[27]+J[28]-J[29]+J[30]+J[31]+J[32]+J[33]+J[34]-J[35]+J[36]-J[37]+J[38]+J[39]+J[40]+J[41]-J[42]+
    J[43]-J[44]+J[45]+J[46]+J[47]-J[48]+J[49]-J[50]+J[51]+J[52]-J[53]+J[54]-J[55]+J[56]-J[57]+J[58]-J[59]-J[60]+
    J[61]-J[62]-J[63]+J[64]-J[65], +H[0]-H[1]-H[2]-H[3]-H[4]-H[5]-H[6]-H[7]-H[8]+H[9]-H[10]-H[11]-J[0]-J[1]-J[2]-J[3]-J[4]-J[5]-J[6]-J[7]+
    J[8]-J[9]-J[10]+J[11]+J[12]+J[13]+J[14]+J[15]+J[16]+J[17]-J[18]+J[19]+J[20]+J[21]+J[22]+J[23]+J[24]+
    J[25]+J[26]-J[27]+J[28]+J[29]+J[30]+J[31]+J[32]+J[33]+J[34]-J[35]+J[36]+J[37]+J[38]+J[39]+J[40]+J[41]-J[42]+
    J[43]+J[44]+J[45]+J[46]+J[47]-J[48]+J[49]+J[50]+J[51]+J[52]-J[53]+J[54]+J[55]+J[56]-J[57]+J[58]+J[59]-J[60]+
    J[61]+J[62]-J[63]-J[64]+J[65], +H[0]-H[1]-H[2]-H[3]-H[4]-H[5]-H[6]-H[7]-H[8]-H[9]+H[10]+H[11]-J[0]-J[1]-J[2]-J[3]-J[4]-J[5]-J[6]-J[7]-J[8]+
    J[9]+J[10]+J[11]+J[12]+J[13]+J[14]+J[15]+J[16]+J[17]+J[18]-J[19]-J[20]+J[21]+J[22]+J[23]+J[24]+J[25]+
    J[26]+J[27]-J[28]-J[29]+J[30]+J[31]+J[32]+J[33]+J[34]+J[35]-J[36]-J[37]+J[38]+J[39]+J[40]+J[41]+J[42]-J[43]-J[44]+
    J[45]+J[46]+J[47]+J[48]-J[49]-J[50]+J[51]+J[52]+J[53]-J[54]-J[55]+J[56]+J[57]-J[58]-J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+
    J[65], +H[0]-H[1]-H[2]-H[3]-H[4]-H[5]-H[6]-H[7]-H[8]-H[9]+H[10]-H[11]-J[0]-J[1]-J[2]-J[3]-J[4]-J[5]-J[6]-J[7]-J[8]+
    J[9]-J[10]+J[11]+J[12]+J[13]+J[14]+J[15]+J[16]+J[17]+J[18]-J[19]+J[20]+J[21]+J[22]+J[23]+J[24]+J[25]+
    J[26]+J[27]-J[28]+J[29]+J[30]+J[31]+J[32]+J[33]+J[34]+J[35]-J[36]+J[37]+J[38]+J[39]+J[40]+J[41]+J[42]-J[43]+
    J[44]+J[45]+J[46]+J[47]+J[48]-J[49]+J[50]+J[51]+J[52]+J[53]-J[54]+J[55]+J[56]+J[57]-J[58]+J[59]+J[60]-J[61]+
    J[62]-J[63]+J[64]-J[65], +H[0]-H[1]-H[2]-H[3]-H[4]-H[5]-H[6]-H[7]-H[8]-H[9]-H[10]+H[11]-J[0]-J[1]-J[2]-J[3]-J[4]-J[5]-J[6]-J[7]-J[8]-J[9]+
    J[10]+J[11]+J[12]+J[13]+J[14]+J[15]+J[16]+J[17]+J[18]+J[19]-J[20]+J[21]+J[22]+J[23]+J[24]+J[25]+J[26]+
    J[27]+J[28]-J[29]+J[30]+J[31]+J[32]+J[33]+J[34]+J[35]+J[36]-J[37]+J[38]+J[39]+J[40]+J[41]+J[42]+J[43]-J[44]+
    J[45]+J[46]+J[47]+J[48]+J[49]-J[50]+J[51]+J[52]+J[53]+J[54]-J[55]+J[56]+J[57]+J[58]-J[59]+J[60]+J[61]-J[62]+
    J[63]-J[64]-J[65], +H[0]-H[1]-H[2]-H[3]-H[4]-H[5]-H[6]-H[7]-H[8]-H[9]-H[10]-H[11]-J[0]-J[1]-J[2]-J[3]-J[4]-J[5]-J[6]-J[7]-J[8]-J[9]-J[10]+
    J[11]+J[12]+J[13]+J[14]+J[15]+J[16]+J[17]+J[18]+J[19]+J[20]+J[21]+J[22]+J[23]+J[24]+J[25]+J[26]+J[27]+
    J[28]+J[29]+J[30]+J[31]+J[32]+J[33]+J[34]+J[35]+J[36]+J[37]+J[38]+J[39]+J[40]+J[41]+J[42]+J[43]+J[44]+
    J[45]+J[46]+J[47]+J[48]+J[49]+J[50]+J[51]+J[52]+J[53]+J[54]+J[55]+J[56]+J[57]+J[58]+J[59]+J[60]+J[61]+
    J[62]+J[63]+J[64]+J[65], -H[0]+H[1]+H[2]+H[3]+H[4]+H[5]+H[6]+H[7]+H[8]+H[9]+H[10]+H[11]-J[0]-J[1]-J[2]-J[3]-J[4]-J[5]-J[6]-J[7]-J[8]-J[9]-J[10]+
    J[11]+J[12]+J[13]+J[14]+J[15]+J[16]+J[17]+J[18]+J[19]+J[20]+J[21]+J[22]+J[23]+J[24]+J[25]+J[26]+J[27]+
    J[28]+J[29]+J[30]+J[31]+J[32]+J[33]+J[34]+J[35]+J[36]+J[37]+J[38]+J[39]+J[40]+J[41]+J[42]+J[43]+J[44]+
    J[45]+J[46]+J[47]+J[48]+J[49]+J[50]+J[51]+J[52]+J[53]+J[54]+J[55]+J[56]+J[57]+J[58]+J[59]+J[60]+J[61]+
    J[62]+J[63]+J[64]+J[65], -H[0]+H[1]+H[2]+H[3]+H[4]+H[5]+H[6]+H[7]+H[8]+H[9]+H[10]-H[11]-J[0]-J[1]-J[2]-J[3]-J[4]-J[5]-J[6]-J[7]-J[8]-J[9]+
    J[10]+J[11]+J[12]+J[13]+J[14]+J[15]+J[16]+J[17]+J[18]+J[19]-J[20]+J[21]+J[22]+J[23]+J[24]+J[25]+J[26]+
    J[27]+J[28]-J[29]+J[30]+J[31]+J[32]+J[33]+J[34]+J[35]+J[36]-J[37]+J[38]+J[39]+J[40]+J[41]+J[42]+J[43]-J[44]+
    J[45]+J[46]+J[47]+J[48]+J[49]-J[50]+J[51]+J[52]+J[53]+J[54]-J[55]+J[56]+J[57]+J[58]-J[59]+J[60]+J[61]-J[62]+
    J[63]-J[64]-J[65], -H[0]+H[1]+H[2]+H[3]+H[4]+H[5]+H[6]+H[7]+H[8]+H[9]-H[10]+H[11]-J[0]-J[1]-J[2]-J[3]-J[4]-J[5]-J[6]-J[7]-J[8]+
    J[9]-J[10]+J[11]+J[12]+J[13]+J[14]+J[15]+J[16]+J[17]+J[18]-J[19]+J[20]+J[21]+J[22]+J[23]+J[24]+J[25]+
    J[26]+J[27]-J[28]+J[29]+J[30]+J[31]+J[32]+J[33]+J[34]+J[35]-J[36]+J[37]+J[38]+J[39]+J[40]+J[41]+J[42]-J[43]+
    J[44]+J[45]+J[46]+J[47]+J[48]-J[49]+J[50]+J[51]+J[52]+J[53]-J[54]+J[55]+J[56]+J[57]-J[58]+J[59]+J[60]-J[61]+
    J[62]-J[63]+J[64]-J[65], -H[0]+H[1]+H[2]+H[3]+H[4]+H[5]+H[6]+H[7]+H[8]+H[9]-H[10]-H[11]-J[0]-J[1]-J[2]-J[3]-J[4]-J[5]-J[6]-J[7]-J[8]+
    J[9]+J[10]+J[11]+J[12]+J[13]+J[14]+J[15]+J[16]+J[17]+J[18]-J[19]-J[20]+J[21]+J[22]+J[23]+J[24]+J[25]+
    J[26]+J[27]-J[28]-J[29]+J[30]+J[31]+J[32]+J[33]+J[34]+J[35]-J[36]-J[37]+J[38]+J[39]+J[40]+J[41]+J[42]-J[43]-J[44]+
    J[45]+J[46]+J[47]+J[48]-J[49]-J[50]+J[51]+J[52]+J[53]-J[54]-J[55]+J[56]+J[57]-J[58]-J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+
    J[65], -H[0]+H[1]+H[2]+H[3]+H[4]+H[5]+H[6]+H[7]+H[8]-H[9]+H[10]+H[11]-J[0]-J[1]-J[2]-J[3]-J[4]-J[5]-J[6]-J[7]+
    J[8]-J[9]-J[10]+J[11]+J[12]+J[13]+J[14]+J[15]+J[16]+J[17]-J[18]+J[19]+J[20]+J[21]+J[22]+J[23]+J[24]+
    J[25]+J[26]-J[27]+J[28]+J[29]+J[30]+J[31]+J[32]+J[33]+J[34]-J[35]+J[36]+J[37]+J[38]+J[39]+J[40]+J[41]-J[42]+
    J[43]+J[44]+J[45]+J[46]+J[47]-J[48]+J[49]+J[50]+J[51]+J[52]-J[53]+J[54]+J[55]+J[56]-J[57]+J[58]+J[59]-J[60]+
    J[61]+J[62]-J[63]-J[64]+J[65], -H[0]+H[1]+H[2]+H[3]+H[4]+H[5]+H[6]+H[7]+H[8]-H[9]+H[10]-H[11]-J[0]-J[1]-J[2]-J[3]-J[4]-J[5]-J[6]-J[7]+
    J[8]-J[9]+J[10]+J[11]+J[12]+J[13]+J[14]+J[15]+J[16]+J[17]-J[18]+J[19]-J[20]+J[21]+J[22]+J[23]+J[24]+
    J[25]+J[26]-J[27]+J[28]-J[29]+J[30]+J[31]+J[32]+J[33]+J[34]-J[35]+J[36]-J[37]+J[38]+J[39]+J[40]+J[41]-J[42]+
    J[43]-J[44]+J[45]+J[46]+J[47]-J[48]+J[49]-J[50]+J[51]+J[52]-J[53]+J[54]-J[55]+J[56]-J[57]+J[58]-J[59]-J[60]+
    J[61]-J[62]-J[63]+J[64]-J[65], -H[0]+H[1]+H[2]+H[3]+H[4]+H[5]+H[6]+H[7]+H[8]-H[9]-H[10]+H[11]-J[0]-J[1]-J[2]-J[3]-J[4]-J[5]-J[6]-J[7]+
    J[8]+J[9]-J[10]+J[11]+J[12]+J[13]+J[14]+J[15]+J[16]+J[17]-J[18]-J[19]+J[20]+J[21]+J[22]+J[23]+J[24]+
    J[25]+J[26]-J[27]-J[28]+J[29]+J[30]+J[31]+J[32]+J[33]+J[34]-J[35]-J[36]+J[37]+J[38]+J[39]+J[40]+J[41]-J[42]-J[43]+
    J[44]+J[45]+J[46]+J[47]-J[48]-J[49]+J[50]+J[51]+J[52]-J[53]-J[54]+J[55]+J[56]-J[57]-J[58]+J[59]-J[60]-J[61]+
    J[62]+J[63]-J[64]-J[65], -H[0]+H[1]+H[2]+H[3]+H[4]+H[5]+H[6]+H[7]+H[8]-H[9]-H[10]-H[11]-J[0]-J[1]-J[2]-J[3]-J[4]-J[5]-J[6]-J[7]+
    J[8]+J[9]+J[10]+J[11]+J[12]+J[13]+J[14]+J[15]+J[16]+J[17]-J[18]-J[19]-J[20]+J[21]+J[22]+J[23]+J[24]+
    J[25]+J[26]-J[27]-J[28]-J[29]+J[30]+J[31]+J[32]+J[33]+J[34]-J[35]-J[36]-J[37]+J[38]+J[39]+J[40]+J[41]-J[42]-J[43]-J[44]+
    J[45]+J[46]+J[47]-J[48]-J[49]-J[50]+J[51]+J[52]-J[53]-J[54]-J[55]+J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+
    J[63]+J[64]+J[65], -H[0]+H[1]+H[2]+H[3]+H[4]+H[5]+H[6]+H[7]-H[8]+H[9]+H[10]+H[11]-J[0]-J[1]-J[2]-J[3]-J[4]-J[5]-J[6]+
    J[7]-J[8]-J[9]-J[10]+J[11]+J[12]+J[13]+J[14]+J[15]+J[16]-J[17]+J[18]+J[19]+J[20]+J[21]+J[22]+J[23]+J[24]+
    J[25]-J[26]+J[27]+J[28]+J[29]+J[30]+J[31]+J[32]+J[33]-J[34]+J[35]+J[36]+J[37]+J[38]+J[39]+J[40]-J[41]+
    J[42]+J[43]+J[44]+J[45]+J[46]-J[47]+J[48]+J[49]+J[50]+J[51]-J[52]+J[53]+J[54]+J[55]-J[56]+J[57]+J[58]+
    J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], -H[0]+H[1]+H[2]+H[3]+H[4]+H[5]+H[6]+H[7]-H[8]+H[9]+H[10]-H[11]-J[0]-J[1]-J[2]-J[3]-J[4]-J[5]-J[6]+
    J[7]-J[8]-J[9]+J[10]+J[11]+J[12]+J[13]+J[14]+J[15]+J[16]-J[17]+J[18]+J[19]-J[20]+J[21]+J[22]+J[23]+J[24]+
    J[25]-J[26]+J[27]+J[28]-J[29]+J[30]+J[31]+J[32]+J[33]-J[34]+J[35]+J[36]-J[37]+J[38]+J[39]+J[40]-J[41]+
    J[42]+J[43]-J[44]+J[45]+J[46]-J[47]+J[48]+J[49]-J[50]+J[51]-J[52]+J[53]+J[54]-J[55]-J[56]+J[57]+J[58]-J[59]-J[60]-J[61]+
    J[62]+J[63]-J[64]-J[65], -H[0]+H[1]+H[2]+H[3]+H[4]+H[5]+H[6]+H[7]-H[8]+H[9]-H[10]+H[11]-J[0]-J[1]-J[2]-J[3]-J[4]-J[5]-J[6]+
    J[7]-J[8]+J[9]-J[10]+J[11]+J[12]+J[13]+J[14]+J[15]+J[16]-J[17]+J[18]-J[19]+J[20]+J[21]+J[22]+J[23]+J[24]+
    J[25]-J[26]+J[27]-J[28]+J[29]+J[30]+J[31]+J[32]+J[33]-J[34]+J[35]-J[36]+J[37]+J[38]+J[39]+J[40]-J[41]+
    J[42]-J[43]+J[44]+J[45]+J[46]-J[47]+J[48]-J[49]+J[50]+J[51]-J[52]+J[53]-J[54]+J[55]-J[56]+J[57]-J[58]+
    J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], -H[0]+H[1]+H[2]+H[3]+H[4]+H[5]+H[6]+H[7]-H[8]+H[9]-H[10]-H[11]-J[0]-J[1]-J[2]-J[3]-J[4]-J[5]-J[6]+
    J[7]-J[8]+J[9]+J[10]+J[11]+J[12]+J[13]+J[14]+J[15]+J[16]-J[17]+J[18]-J[19]-J[20]+J[21]+J[22]+J[23]+J[24]+
    J[25]-J[26]+J[27]-J[28]-J[29]+J[30]+J[31]+J[32]+J[33]-J[34]+J[35]-J[36]-J[37]+J[38]+J[39]+J[40]-J[41]+
    J[42]-J[43]-J[44]+J[45]+J[46]-J[47]+J[48]-J[49]-J[50]+J[51]-J[52]+J[53]-J[54]-J[55]-J[56]+J[57]-J[58]-J[59]-J[60]+
    J[61]+J[62]-J[63]-J[64]+J[65], -H[0]+H[1]+H[2]+H[3]+H[4]+H[5]+H[6]+H[7]-H[8]-H[9]+H[10]+H[11]-J[0]-J[1]-J[2]-J[3]-J[4]-J[5]-J[6]+
    J[7]+J[8]-J[9]-J[10]+J[11]+J[12]+J[13]+J[14]+J[15]+J[16]-J[17]-J[18]+J[19]+J[20]+J[21]+J[22]+J[23]+J[24]+
    J[25]-J[26]-J[27]+J[28]+J[29]+J[30]+J[31]+J[32]+J[33]-J[34]-J[35]+J[36]+J[37]+J[38]+J[39]+J[40]-J[41]-J[42]+
    J[43]+J[44]+J[45]+J[46]-J[47]-J[48]+J[49]+J[50]+J[51]-J[52]-J[53]+J[54]+J[55]-J[56]-J[57]+J[58]+J[59]+
    J[60]-J[61]-J[62]-J[63]-J[64]+J[65], -H[0]+H[1]+H[2]+H[3]+H[4]+H[5]+H[6]+H[7]-H[8]-H[9]+H[10]-H[11]-J[0]-J[1]-J[2]-J[3]-J[4]-J[5]-J[6]+
    J[7]+J[8]-J[9]+J[10]+J[11]+J[12]+J[13]+J[14]+J[15]+J[16]-J[17]-J[18]+J[19]-J[20]+J[21]+J[22]+J[23]+J[24]+
    J[25]-J[26]-J[27]+J[28]-J[29]+J[30]+J[31]+J[32]+J[33]-J[34]-J[35]+J[36]-J[37]+J[38]+J[39]+J[40]-J[41]-J[42]+
    J[43]-J[44]+J[45]+J[46]-J[47]-J[48]+J[49]-J[50]+J[51]-J[52]-J[53]+J[54]-J[55]-J[56]-J[57]+J[58]-J[59]+
    J[60]-J[61]+J[62]-J[63]+J[64]-J[65], -H[0]+H[1]+H[2]+H[3]+H[4]+H[5]+H[6]+H[7]-H[8]-H[9]-H[10]+H[11]-J[0]-J[1]-J[2]-J[3]-J[4]-J[5]-J[6]+
    J[7]+J[8]+J[9]-J[10]+J[11]+J[12]+J[13]+J[14]+J[15]+J[16]-J[17]-J[18]-J[19]+J[20]+J[21]+J[22]+J[23]+J[24]+
    J[25]-J[26]-J[27]-J[28]+J[29]+J[30]+J[31]+J[32]+J[33]-J[34]-J[35]-J[36]+J[37]+J[38]+J[39]+J[40]-J[41]-J[42]-J[43]+
    J[44]+J[45]+J[46]-J[47]-J[48]-J[49]+J[50]+J[51]-J[52]-J[53]-J[54]+J[55]-J[56]-J[57]-J[58]+J[59]+J[60]+
    J[61]-J[62]+J[63]-J[64]-J[65], -H[0]+H[1]+H[2]+H[3]+H[4]+H[5]+H[6]+H[7]-H[8]-H[9]-H[10]-H[11]-J[0]-J[1]-J[2]-J[3]-J[4]-J[5]-J[6]+
    J[7]+J[8]+J[9]+J[10]+J[11]+J[12]+J[13]+J[14]+J[15]+J[16]-J[17]-J[18]-J[19]-J[20]+J[21]+J[22]+J[23]+J[24]+
    J[25]-J[26]-J[27]-J[28]-J[29]+J[30]+J[31]+J[32]+J[33]-J[34]-J[35]-J[36]-J[37]+J[38]+J[39]+J[40]-J[41]-J[42]-J[43]-J[44]+
    J[45]+J[46]-J[47]-J[48]-J[49]-J[50]+J[51]-J[52]-J[53]-J[54]-J[55]-J[56]-J[57]-J[58]-J[59]+J[60]+J[61]+
    J[62]+J[63]+J[64]+J[65], -H[0]+H[1]+H[2]+H[3]+H[4]+H[5]+H[6]-H[7]+H[8]+H[9]+H[10]+H[11]-J[0]-J[1]-J[2]-J[3]-J[4]-J[5]+
    J[6]-J[7]-J[8]-J[9]-J[10]+J[11]+J[12]+J[13]+J[14]+J[15]-J[16]+J[17]+J[18]+J[19]+J[20]+J[21]+J[22]+J[23]+
    J[24]-J[25]+J[26]+J[27]+J[28]+J[29]+J[30]+J[31]+J[32]-J[33]+J[34]+J[35]+J[36]+J[37]+J[38]+J[39]-J[40]+
    J[41]+J[42]+J[43]+J[44]+J[45]-J[46]+J[47]+J[48]+J[49]+J[50]-J[51]+J[52]+J[53]+J[54]+J[55]-J[56]-J[57]-J[58]-J[59]+
    J[60]+J[61]+J[62]+J[63]+J[64]+J[65], -H[0]+H[1]+H[2]+H[3]+H[4]+H[5]+H[6]-H[7]+H[8]+H[9]+H[10]-H[11]-J[0]-J[1]-J[2]-J[3]-J[4]-J[5]+
    J[6]-J[7]-J[8]-J[9]+J[10]+J[11]+J[12]+J[13]+J[14]+J[15]-J[16]+J[17]+J[18]+J[19]-J[20]+J[21]+J[22]+J[23]+
    J[24]-J[25]+J[26]+J[27]+J[28]-J[29]+J[30]+J[31]+J[32]-J[33]+J[34]+J[35]+J[36]-J[37]+J[38]+J[39]-J[40]+
    J[41]+J[42]+J[43]-J[44]+J[45]-J[46]+J[47]+J[48]+J[49]-J[50]-J[51]+J[52]+J[53]+J[54]-J[55]-J[56]-J[57]-J[58]+
    J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], -H[0]+H[1]+H[2]+H[3]+H[4]+H[5]+H[6]-H[7]+H[8]+H[9]-H[10]+
    H[11]-J[0]-J[1]-J[2]-J[3]-J[4]-J[5]+J[6]-J[7]-J[8]+J[9]-J[10]+J[11]+J[12]+J[13]+J[14]+J[15]-J[16]+J[17]+
    J[18]-J[19]+J[20]+J[21]+J[22]+J[23]+J[24]-J[25]+J[26]+J[27]-J[28]+J[29]+J[30]+J[31]+J[32]-J[33]+J[34]+
    J[35]-J[36]+J[37]+J[38]+J[39]-J[40]+J[41]+J[42]-J[43]+J[44]+J[45]-J[46]+J[47]+J[48]-J[49]+J[50]-J[51]+
    J[52]+J[53]-J[54]+J[55]-J[56]-J[57]+J[58]-J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], -H[0]+H[1]+H[2]+
    H[3]+H[4]+H[5]+H[6]-H[7]+H[8]+H[9]-H[10]-H[11]-J[0]-J[1]-J[2]-J[3]-J[4]-J[5]+J[6]-J[7]-J[8]+J[9]+J[10]+
    J[11]+J[12]+J[13]+J[14]+J[15]-J[16]+J[17]+J[18]-J[19]-J[20]+J[21]+J[22]+J[23]+J[24]-J[25]+J[26]+J[27]-J[28]-J[29]+
    J[30]+J[31]+J[32]-J[33]+J[34]+J[35]-J[36]-J[37]+J[38]+J[39]-J[40]+J[41]+J[42]-J[43]-J[44]+J[45]-J[46]+
    J[47]+J[48]-J[49]-J[50]-J[51]+J[52]+J[53]-J[54]-J[55]-J[56]-J[57]+J[58]+J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+
    J[65], -H[0]+H[1]+H[2]+H[3]+H[4]+H[5]+H[6]-H[7]+H[8]-H[9]+H[10]+H[11]-J[0]-J[1]-J[2]-J[3]-J[4]-J[5]+
    J[6]-J[7]+J[8]-J[9]-J[10]+J[11]+J[12]+J[13]+J[14]+J[15]-J[16]+J[17]-J[18]+J[19]+J[20]+J[21]+J[22]+J[23]+
    J[24]-J[25]+J[26]-J[27]+J[28]+J[29]+J[30]+J[31]+J[32]-J[33]+J[34]-J[35]+J[36]+J[37]+J[38]+J[39]-J[40]+
    J[41]-J[42]+J[43]+J[44]+J[45]-J[46]+J[47]-J[48]+J[49]+J[50]-J[51]+J[52]-J[53]+J[54]+J[55]-J[56]+J[57]-J[58]-J[59]-J[60]+
    J[61]+J[62]-J[63]-J[64]+J[65], -H[0]+H[1]+H[2]+H[3]+H[4]+H[5]+H[6]-H[7]+H[8]-H[9]+H[10]-H[11]-J[0]-J[1]-J[2]-J[3]-J[4]-J[5]+
    J[6]-J[7]+J[8]-J[9]+J[10]+J[11]+J[12]+J[13]+J[14]+J[15]-J[16]+J[17]-J[18]+J[19]-J[20]+J[21]+J[22]+J[23]+
    J[24]-J[25]+J[26]-J[27]+J[28]-J[29]+J[30]+J[31]+J[32]-J[33]+J[34]-J[35]+J[36]-J[37]+J[38]+J[39]-J[40]+
    J[41]-J[42]+J[43]-J[44]+J[45]-J[46]+J[47]-J[48]+J[49]-J[50]-J[51]+J[52]-J[53]+J[54]-J[55]-J[56]+J[57]-J[58]+
    J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], -H[0]+H[1]+H[2]+H[3]+H[4]+H[5]+H[6]-H[7]+H[8]-H[9]-H[10]+
    H[11]-J[0]-J[1]-J[2]-J[3]-J[4]-J[5]+J[6]-J[7]+J[8]+J[9]-J[10]+J[11]+J[12]+J[13]+J[14]+J[15]-J[16]+J[17]-J[18]-J[19]+
    J[20]+J[21]+J[22]+J[23]+J[24]-J[25]+J[26]-J[27]-J[28]+J[29]+J[30]+J[31]+J[32]-J[33]+J[34]-J[35]-J[36]+
    J[37]+J[38]+J[39]-J[40]+J[41]-J[42]-J[43]+J[44]+J[45]-J[46]+J[47]-J[48]-J[49]+J[50]-J[51]+J[52]-J[53]-J[54]+
    J[55]-J[56]+J[57]+J[58]-J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], -H[0]+H[1]+H[2]+H[3]+H[4]+H[5]+H[6]-H[7]+
    H[8]-H[9]-H[10]-H[11]-J[0]-J[1]-J[2]-J[3]-J[4]-J[5]+J[6]-J[7]+J[8]+J[9]+J[10]+J[11]+J[12]+J[13]+J[14]+
    J[15]-J[16]+J[17]-J[18]-J[19]-J[20]+J[21]+J[22]+J[23]+J[24]-J[25]+J[26]-J[27]-J[28]-J[29]+J[30]+J[31]+
    J[32]-J[33]+J[34]-J[35]-J[36]-J[37]+J[38]+J[39]-J[40]+J[41]-J[42]-J[43]-J[44]+J[45]-J[46]+J[47]-J[48]-J[49]-J[50]-J[51]+
    J[52]-J[53]-J[54]-J[55]-J[56]+J[57]+J[58]+J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], -H[0]+H[1]+H[2]+
    H[3]+H[4]+H[5]+H[6]-H[7]-H[8]+H[9]+H[10]+H[11]-J[0]-J[1]-J[2]-J[3]-J[4]-J[5]+J[6]+J[7]-J[8]-J[9]-J[10]+
    J[11]+J[12]+J[13]+J[14]+J[15]-J[16]-J[17]+J[18]+J[19]+J[20]+J[21]+J[22]+J[23]+J[24]-J[25]-J[26]+J[27]+
    J[28]+J[29]+J[30]+J[31]+J[32]-J[33]-J[34]+J[35]+J[36]+J[37]+J[38]+J[39]-J[40]-J[41]+J[42]+J[43]+J[44]+
    J[45]-J[46]-J[47]+J[48]+J[49]+J[50]-J[51]-J[52]+J[53]+J[54]+J[55]+J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+
    J[63]+J[64]+J[65], -H[0]+H[1]+H[2]+H[3]+H[4]+H[5]+H[6]-H[7]-H[8]+H[9]+H[10]-H[11]-J[0]-J[1]-J[2]-J[3]-J[4]-J[5]+
    J[6]+J[7]-J[8]-J[9]+J[10]+J[11]+J[12]+J[13]+J[14]+J[15]-J[16]-J[17]+J[18]+J[19]-J[20]+J[21]+J[22]+J[23]+
    J[24]-J[25]-J[26]+J[27]+J[28]-J[29]+J[30]+J[31]+J[32]-J[33]-J[34]+J[35]+J[36]-J[37]+J[38]+J[39]-J[40]-J[41]+
    J[42]+J[43]-J[44]+J[45]-J[46]-J[47]+J[48]+J[49]-J[50]-J[51]-J[52]+J[53]+J[54]-J[55]+J[56]-J[57]-J[58]+
    J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], -H[0]+H[1]+H[2]+H[3]+H[4]+H[5]+H[6]-H[7]-H[8]+H[9]-H[10]+
    H[11]-J[0]-J[1]-J[2]-J[3]-J[4]-J[5]+J[6]+J[7]-J[8]+J[9]-J[10]+J[11]+J[12]+J[13]+J[14]+J[15]-J[16]-J[17]+
    J[18]-J[19]+J[20]+J[21]+J[22]+J[23]+J[24]-J[25]-J[26]+J[27]-J[28]+J[29]+J[30]+J[31]+J[32]-J[33]-J[34]+
    J[35]-J[36]+J[37]+J[38]+J[39]-J[40]-J[41]+J[42]-J[43]+J[44]+J[45]-J[46]-J[47]+J[48]-J[49]+J[50]-J[51]-J[52]+
    J[53]-J[54]+J[55]+J[56]-J[57]+J[58]-J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], -H[0]+H[1]+H[2]+H[3]+
    H[4]+H[5]+H[6]-H[7]-H[8]+H[9]-H[10]-H[11]-J[0]-J[1]-J[2]-J[3]-J[4]-J[5]+J[6]+J[7]-J[8]+J[9]+J[10]+J[11]+
    J[12]+J[13]+J[14]+J[15]-J[16]-J[17]+J[18]-J[19]-J[20]+J[21]+J[22]+J[23]+J[24]-J[25]-J[26]+J[27]-J[28]-J[29]+
    J[30]+J[31]+J[32]-J[33]-J[34]+J[35]-J[36]-J[37]+J[38]+J[39]-J[40]-J[41]+J[42]-J[43]-J[44]+J[45]-J[46]-J[47]+
    J[48]-J[49]-J[50]-J[51]-J[52]+J[53]-J[54]-J[55]+J[56]-J[57]+J[58]+J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+
    J[65], -H[0]+H[1]+H[2]+H[3]+H[4]+H[5]+H[6]-H[7]-H[8]-H[9]+H[10]+H[11]-J[0]-J[1]-J[2]-J[3]-J[4]-J[5]+
    J[6]+J[7]+J[8]-J[9]-J[10]+J[11]+J[12]+J[13]+J[14]+J[15]-J[16]-J[17]-J[18]+J[19]+J[20]+J[21]+J[22]+J[23]+
    J[24]-J[25]-J[26]-J[27]+J[28]+J[29]+J[30]+J[31]+J[32]-J[33]-J[34]-J[35]+J[36]+J[37]+J[38]+J[39]-J[40]-J[41]-J[42]+
    J[43]+J[44]+J[45]-J[46]-J[47]-J[48]+J[49]+J[50]-J[51]-J[52]-J[53]+J[54]+J[55]+J[56]+J[57]-J[58]-J[59]+
    J[60]-J[61]-J[62]-J[63]-J[64]+J[65], -H[0]+H[1]+H[2]+H[3]+H[4]+H[5]+H[6]-H[7]-H[8]-H[9]+H[10]-H[11]-J[0]-J[1]-J[2]-J[3]-J[4]-J[5]+
    J[6]+J[7]+J[8]-J[9]+J[10]+J[11]+J[12]+J[13]+J[14]+J[15]-J[16]-J[17]-J[18]+J[19]-J[20]+J[21]+J[22]+J[23]+
    J[24]-J[25]-J[26]-J[27]+J[28]-J[29]+J[30]+J[31]+J[32]-J[33]-J[34]-J[35]+J[36]-J[37]+J[38]+J[39]-J[40]-J[41]-J[42]+
    J[43]-J[44]+J[45]-J[46]-J[47]-J[48]+J[49]-J[50]-J[51]-J[52]-J[53]+J[54]-J[55]+J[56]+J[57]-J[58]+J[59]+
    J[60]-J[61]+J[62]-J[63]+J[64]-J[65], -H[0]+H[1]+H[2]+H[3]+H[4]+H[5]+H[6]-H[7]-H[8]-H[9]-H[10]+H[11]-J[0]-J[1]-J[2]-J[3]-J[4]-J[5]+
    J[6]+J[7]+J[8]+J[9]-J[10]+J[11]+J[12]+J[13]+J[14]+J[15]-J[16]-J[17]-J[18]-J[19]+J[20]+J[21]+J[22]+J[23]+
    J[24]-J[25]-J[26]-J[27]-J[28]+J[29]+J[30]+J[31]+J[32]-J[33]-J[34]-J[35]-J[36]+J[37]+J[38]+J[39]-J[40]-J[41]-J[42]-J[43]+
    J[44]+J[45]-J[46]-J[47]-J[48]-J[49]+J[50]-J[51]-J[52]-J[53]-J[54]+J[55]+J[56]+J[57]+J[58]-J[59]+J[60]+
    J[61]-J[62]+J[63]-J[64]-J[65], -H[0]+H[1]+H[2]+H[3]+H[4]+H[5]+H[6]-H[7]-H[8]-H[9]-H[10]-H[11]-J[0]-J[1]-J[2]-J[3]-J[4]-J[5]+
    J[6]+J[7]+J[8]+J[9]+J[10]+J[11]+J[12]+J[13]+J[14]+J[15]-J[16]-J[17]-J[18]-J[19]-J[20]+J[21]+J[22]+J[23]+
    J[24]-J[25]-J[26]-J[27]-J[28]-J[29]+J[30]+J[31]+J[32]-J[33]-J[34]-J[35]-J[36]-J[37]+J[38]+J[39]-J[40]-J[41]-J[42]-J[43]-J[44]+
    J[45]-J[46]-J[47]-J[48]-J[49]-J[50]-J[51]-J[52]-J[53]-J[54]-J[55]+J[56]+J[57]+J[58]+J[59]+J[60]+J[61]+
    J[62]+J[63]+J[64]+J[65], -H[0]+H[1]+H[2]+H[3]+H[4]+H[5]-H[6]+H[7]+H[8]+H[9]+H[10]+H[11]-J[0]-J[1]-J[2]-J[3]-J[4]+
    J[5]-J[6]-J[7]-J[8]-J[9]-J[10]+J[11]+J[12]+J[13]+J[14]-J[15]+J[16]+J[17]+J[18]+J[19]+J[20]+J[21]+J[22]+
    J[23]-J[24]+J[25]+J[26]+J[27]+J[28]+J[29]+J[30]+J[31]-J[32]+J[33]+J[34]+J[35]+J[36]+J[37]+J[38]-J[39]+
    J[40]+J[41]+J[42]+J[43]+J[44]-J[45]+J[46]+J[47]+J[48]+J[49]+J[50]-J[51]-J[52]-J[53]-J[54]-J[55]+J[56]+
    J[57]+J[58]+J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], -H[0]+H[1]+H[2]+H[3]+H[4]+H[5]-H[6]+H[7]+H[8]+
    H[9]+H[10]-H[11]-J[0]-J[1]-J[2]-J[3]-J[4]+J[5]-J[6]-J[7]-J[8]-J[9]+J[10]+J[11]+J[12]+J[13]+J[14]-J[15]+
    J[16]+J[17]+J[18]+J[19]-J[20]+J[21]+J[22]+J[23]-J[24]+J[25]+J[26]+J[27]+J[28]-J[29]+J[30]+J[31]-J[32]+
    J[33]+J[34]+J[35]+J[36]-J[37]+J[38]-J[39]+J[40]+J[41]+J[42]+J[43]-J[44]-J[45]+J[46]+J[47]+J[48]+J[49]-J[50]-J[51]-J[52]-J[53]-J[54]+
    J[55]+J[56]+J[57]+J[58]-J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], -H[0]+H[1]+H[2]+H[3]+H[4]+H[5]-H[6]+
    H[7]+H[8]+H[9]-H[10]+H[11]-J[0]-J[1]-J[2]-J[3]-J[4]+J[5]-J[6]-J[7]-J[8]+J[9]-J[10]+J[11]+J[12]+J[13]+
    J[14]-J[15]+J[16]+J[17]+J[18]-J[19]+J[20]+J[21]+J[22]+J[23]-J[24]+J[25]+J[26]+J[27]-J[28]+J[29]+J[30]+
    J[31]-J[32]+J[33]+J[34]+J[35]-J[36]+J[37]+J[38]-J[39]+J[40]+J[41]+J[42]-J[43]+J[44]-J[45]+J[46]+J[47]+
    J[48]-J[49]+J[50]-J[51]-J[52]-J[53]+J[54]-J[55]+J[56]+J[57]-J[58]+J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], -H[0]+
    H[1]+H[2]+H[3]+H[4]+H[5]-H[6]+H[7]+H[8]+H[9]-H[10]-H[11]-J[0]-J[1]-J[2]-J[3]-J[4]+J[5]-J[6]-J[7]-J[8]+
    J[9]+J[10]+J[11]+J[12]+J[13]+J[14]-J[15]+J[16]+J[17]+J[18]-J[19]-J[20]+J[21]+J[22]+J[23]-J[24]+J[25]+
    J[26]+J[27]-J[28]-J[29]+J[30]+J[31]-J[32]+J[33]+J[34]+J[35]-J[36]-J[37]+J[38]-J[39]+J[40]+J[41]+J[42]-J[43]-J[44]-J[45]+
    J[46]+J[47]+J[48]-J[49]-J[50]-J[51]-J[52]-J[53]+J[54]+J[55]+J[56]+J[57]-J[58]-J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+
    J[65], -H[0]+H[1]+H[2]+H[3]+H[4]+H[5]-H[6]+H[7]+H[8]-H[9]+H[10]+H[11]-J[0]-J[1]-J[2]-J[3]-J[4]+J[5]-J[6]-J[7]+
    J[8]-J[9]-J[10]+J[11]+J[12]+J[13]+J[14]-J[15]+J[16]+J[17]-J[18]+J[19]+J[20]+J[21]+J[22]+J[23]-J[24]+
    J[25]+J[26]-J[27]+J[28]+J[29]+J[30]+J[31]-J[32]+J[33]+J[34]-J[35]+J[36]+J[37]+J[38]-J[39]+J[40]+J[41]-J[42]+
    J[43]+J[44]-J[45]+J[46]+J[47]-J[48]+J[49]+J[50]-J[51]-J[52]+J[53]-J[54]-J[55]+J[56]-J[57]+J[58]+J[59]-J[60]+
    J[61]+J[62]-J[63]-J[64]+J[65], -H[0]+H[1]+H[2]+H[3]+H[4]+H[5]-H[6]+H[7]+H[8]-H[9]+H[10]-H[11]-J[0]-J[1]-J[2]-J[3]-J[4]+
    J[5]-J[6]-J[7]+J[8]-J[9]+J[10]+J[11]+J[12]+J[13]+J[14]-J[15]+J[16]+J[17]-J[18]+J[19]-J[20]+J[21]+J[22]+
    J[23]-J[24]+J[25]+J[26]-J[27]+J[28]-J[29]+J[30]+J[31]-J[32]+J[33]+J[34]-J[35]+J[36]-J[37]+J[38]-J[39]+
    J[40]+J[41]-J[42]+J[43]-J[44]-J[45]+J[46]+J[47]-J[48]+J[49]-J[50]-J[51]-J[52]+J[53]-J[54]+J[55]+J[56]-J[57]+
    J[58]-J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], -H[0]+H[1]+H[2]+H[3]+H[4]+H[5]-H[6]+H[7]+H[8]-H[9]-H[10]+
    H[11]-J[0]-J[1]-J[2]-J[3]-J[4]+J[5]-J[6]-J[7]+J[8]+J[9]-J[10]+J[11]+J[12]+J[13]+J[14]-J[15]+J[16]+J[17]-J[18]-J[19]+
    J[20]+J[21]+J[22]+J[23]-J[24]+J[25]+J[26]-J[27]-J[28]+J[29]+J[30]+J[31]-J[32]+J[33]+J[34]-J[35]-J[36]+
    J[37]+J[38]-J[39]+J[40]+J[41]-J[42]-J[43]+J[44]-J[45]+J[46]+J[47]-J[48]-J[49]+J[50]-J[51]-J[52]+J[53]+
    J[54]-J[55]+J[56]-J[57]-J[58]+J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], -H[0]+H[1]+H[2]+H[3]+H[4]+H[5]-H[6]+
    H[7]+H[8]-H[9]-H[10]-H[11]-J[0]-J[1]-J[2]-J[3]-J[4]+J[5]-J[6]-J[7]+J[8]+J[9]+J[10]+J[11]+J[12]+J[13]+
    J[14]-J[15]+J[16]+J[17]-J[18]-J[19]-J[20]+J[21]+J[22]+J[23]-J[24]+J[25]+J[26]-J[27]-J[28]-J[29]+J[30]+
    J[31]-J[32]+J[33]+J[34]-J[35]-J[36]-J[37]+J[38]-J[39]+J[40]+J[41]-J[42]-J[43]-J[44]-J[45]+J[46]+J[47]-J[48]-J[49]-J[50]-J[51]-J[52]+
    J[53]+J[54]+J[55]+J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], -H[0]+H[1]+H[2]+H[3]+
    H[4]+H[5]-H[6]+H[7]-H[8]+H[9]+H[10]+H[11]-J[0]-J[1]-J[2]-J[3]-J[4]+J[5]-J[6]+J[7]-J[8]-J[9]-J[10]+J[11]+
    J[12]+J[13]+J[14]-J[15]+J[16]-J[17]+J[18]+J[19]+J[20]+J[21]+J[22]+J[23]-J[24]+J[25]-J[26]+J[27]+J[28]+
    J[29]+J[30]+J[31]-J[32]+J[33]-J[34]+J[35]+J[36]+J[37]+J[38]-J[39]+J[40]-J[41]+J[42]+J[43]+J[44]-J[45]+
    J[46]-J[47]+J[48]+J[49]+J[50]-J[51]+J[52]-J[53]-J[54]-J[55]-J[56]+J[57]+J[58]+J[59]-J[60]-J[61]-J[62]+
    J[63]+J[64]+J[65], -H[0]+H[1]+H[2]+H[3]+H[4]+H[5]-H[6]+H[7]-H[8]+H[9]+H[10]-H[11]-J[0]-J[1]-J[2]-J[3]-J[4]+
    J[5]-J[6]+J[7]-J[8]-J[9]+J[10]+J[11]+J[12]+J[13]+J[14]-J[15]+J[16]-J[17]+J[18]+J[19]-J[20]+J[21]+J[22]+
    J[23]-J[24]+J[25]-J[26]+J[27]+J[28]-J[29]+J[30]+J[31]-J[32]+J[33]-J[34]+J[35]+J[36]-J[37]+J[38]-J[39]+
    J[40]-J[41]+J[42]+J[43]-J[44]-J[45]+J[46]-J[47]+J[48]+J[49]-J[50]-J[51]+J[52]-J[53]-J[54]+J[55]-J[56]+
    J[57]+J[58]-J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], -H[0]+H[1]+H[2]+H[3]+H[4]+H[5]-H[6]+H[7]-H[8]+
    H[9]-H[10]+H[11]-J[0]-J[1]-J[2]-J[3]-J[4]+J[5]-J[6]+J[7]-J[8]+J[9]-J[10]+J[11]+J[12]+J[13]+J[14]-J[15]+
    J[16]-J[17]+J[18]-J[19]+J[20]+J[21]+J[22]+J[23]-J[24]+J[25]-J[26]+J[27]-J[28]+J[29]+J[30]+J[31]-J[32]+
    J[33]-J[34]+J[35]-J[36]+J[37]+J[38]-J[39]+J[40]-J[41]+J[42]-J[43]+J[44]-J[45]+J[46]-J[47]+J[48]-J[49]+
    J[50]-J[51]+J[52]-J[53]+J[54]-J[55]-J[56]+J[57]-J[58]+J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], -H[0]+
    H[1]+H[2]+H[3]+H[4]+H[5]-H[6]+H[7]-H[8]+H[9]-H[10]-H[11]-J[0]-J[1]-J[2]-J[3]-J[4]+J[5]-J[6]+J[7]-J[8]+
    J[9]+J[10]+J[11]+J[12]+J[13]+J[14]-J[15]+J[16]-J[17]+J[18]-J[19]-J[20]+J[21]+J[22]+J[23]-J[24]+J[25]-J[26]+
    J[27]-J[28]-J[29]+J[30]+J[31]-J[32]+J[33]-J[34]+J[35]-J[36]-J[37]+J[38]-J[39]+J[40]-J[41]+J[42]-J[43]-J[44]-J[45]+
    J[46]-J[47]+J[48]-J[49]-J[50]-J[51]+J[52]-J[53]+J[54]+J[55]-J[56]+J[57]-J[58]-J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+
    J[65], -H[0]+H[1]+H[2]+H[3]+H[4]+H[5]-H[6]+H[7]-H[8]-H[9]+H[10]+H[11]-J[0]-J[1]-J[2]-J[3]-J[4]+J[5]-J[6]+
    J[7]+J[8]-J[9]-J[10]+J[11]+J[12]+J[13]+J[14]-J[15]+J[16]-J[17]-J[18]+J[19]+J[20]+J[21]+J[22]+J[23]-J[24]+
    J[25]-J[26]-J[27]+J[28]+J[29]+J[30]+J[31]-J[32]+J[33]-J[34]-J[35]+J[36]+J[37]+J[38]-J[39]+J[40]-J[41]-J[42]+
    J[43]+J[44]-J[45]+J[46]-J[47]-J[48]+J[49]+J[50]-J[51]+J[52]+J[53]-J[54]-J[55]-J[56]-J[57]+J[58]+J[59]+
    J[60]-J[61]-J[62]-J[63]-J[64]+J[65], -H[0]+H[1]+H[2]+H[3]+H[4]+H[5]-H[6]+H[7]-H[8]-H[9]+H[10]-H[11]-J[0]-J[1]-J[2]-J[3]-J[4]+
    J[5]-J[6]+J[7]+J[8]-J[9]+J[10]+J[11]+J[12]+J[13]+J[14]-J[15]+J[16]-J[17]-J[18]+J[19]-J[20]+J[21]+J[22]+
    J[23]-J[24]+J[25]-J[26]-J[27]+J[28]-J[29]+J[30]+J[31]-J[32]+J[33]-J[34]-J[35]+J[36]-J[37]+J[38]-J[39]+
    J[40]-J[41]-J[42]+J[43]-J[44]-J[45]+J[46]-J[47]-J[48]+J[49]-J[50]-J[51]+J[52]+J[53]-J[54]+J[55]-J[56]-J[57]+
    J[58]-J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], -H[0]+H[1]+H[2]+H[3]+H[4]+H[5]-H[6]+H[7]-H[8]-H[9]-H[10]+
    H[11]-J[0]-J[1]-J[2]-J[3]-J[4]+J[5]-J[6]+J[7]+J[8]+J[9]-J[10]+J[11]+J[12]+J[13]+J[14]-J[15]+J[16]-J[17]-J[18]-J[19]+
    J[20]+J[21]+J[22]+J[23]-J[24]+J[25]-J[26]-J[27]-J[28]+J[29]+J[30]+J[31]-J[32]+J[33]-J[34]-J[35]-J[36]+
    J[37]+J[38]-J[39]+J[40]-J[41]-J[42]-J[43]+J[44]-J[45]+J[46]-J[47]-J[48]-J[49]+J[50]-J[51]+J[52]+J[53]+
    J[54]-J[55]-J[56]-J[57]-J[58]+J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], -H[0]+H[1]+H[2]+H[3]+H[4]+H[5]-H[6]+
    H[7]-H[8]-H[9]-H[10]-H[11]-J[0]-J[1]-J[2]-J[3]-J[4]+J[5]-J[6]+J[7]+J[8]+J[9]+J[10]+J[11]+J[12]+J[13]+
    J[14]-J[15]+J[16]-J[17]-J[18]-J[19]-J[20]+J[21]+J[22]+J[23]-J[24]+J[25]-J[26]-J[27]-J[28]-J[29]+J[30]+
    J[31]-J[32]+J[33]-J[34]-J[35]-J[36]-J[37]+J[38]-J[39]+J[40]-J[41]-J[42]-J[43]-J[44]-J[45]+J[46]-J[47]-J[48]-J[49]-J[50]-J[51]+
    J[52]+J[53]+J[54]+J[55]-J[56]-J[57]-J[58]-J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], -H[0]+H[1]+H[2]+
    H[3]+H[4]+H[5]-H[6]-H[7]+H[8]+H[9]+H[10]+H[11]-J[0]-J[1]-J[2]-J[3]-J[4]+J[5]+J[6]-J[7]-J[8]-J[9]-J[10]+
    J[11]+J[12]+J[13]+J[14]-J[15]-J[16]+J[17]+J[18]+J[19]+J[20]+J[21]+J[22]+J[23]-J[24]-J[25]+J[26]+J[27]+
    J[28]+J[29]+J[30]+J[31]-J[32]-J[33]+J[34]+J[35]+J[36]+J[37]+J[38]-J[39]-J[40]+J[41]+J[42]+J[43]+J[44]-J[45]-J[46]+
    J[47]+J[48]+J[49]+J[50]+J[51]-J[52]-J[53]-J[54]-J[55]-J[56]-J[57]-J[58]-J[59]+J[60]+J[61]+J[62]+J[63]+
    J[64]+J[65], -H[0]+H[1]+H[2]+H[3]+H[4]+H[5]-H[6]-H[7]+H[8]+H[9]+H[10]-H[11]-J[0]-J[1]-J[2]-J[3]-J[4]+
    J[5]+J[6]-J[7]-J[8]-J[9]+J[10]+J[11]+J[12]+J[13]+J[14]-J[15]-J[16]+J[17]+J[18]+J[19]-J[20]+J[21]+J[22]+
    J[23]-J[24]-J[25]+J[26]+J[27]+J[28]-J[29]+J[30]+J[31]-J[32]-J[33]+J[34]+J[35]+J[36]-J[37]+J[38]-J[39]-J[40]+
    J[41]+J[42]+J[43]-J[44]-J[45]-J[46]+J[47]+J[48]+J[49]-J[50]+J[51]-J[52]-J[53]-J[54]+J[55]-J[56]-J[57]-J[58]+
    J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], -H[0]+H[1]+H[2]+H[3]+H[4]+H[5]-H[6]-H[7]+H[8]+H[9]-H[10]+
    H[11]-J[0]-J[1]-J[2]-J[3]-J[4]+J[5]+J[6]-J[7]-J[8]+J[9]-J[10]+J[11]+J[12]+J[13]+J[14]-J[15]-J[16]+J[17]+
    J[18]-J[19]+J[20]+J[21]+J[22]+J[23]-J[24]-J[25]+J[26]+J[27]-J[28]+J[29]+J[30]+J[31]-J[32]-J[33]+J[34]+
    J[35]-J[36]+J[37]+J[38]-J[39]-J[40]+J[41]+J[42]-J[43]+J[44]-J[45]-J[46]+J[47]+J[48]-J[49]+J[50]+J[51]-J[52]-J[53]+
    J[54]-J[55]-J[56]-J[57]+J[58]-J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], -H[0]+H[1]+H[2]+H[3]+H[4]+H[5]-H[6]-H[7]+
    H[8]+H[9]-H[10]-H[11]-J[0]-J[1]-J[2]-J[3]-J[4]+J[5]+J[6]-J[7]-J[8]+J[9]+J[10]+J[11]+J[12]+J[13]+J[14]-J[15]-J[16]+
    J[17]+J[18]-J[19]-J[20]+J[21]+J[22]+J[23]-J[24]-J[25]+J[26]+J[27]-J[28]-J[29]+J[30]+J[31]-J[32]-J[33]+
    J[34]+J[35]-J[36]-J[37]+J[38]-J[39]-J[40]+J[41]+J[42]-J[43]-J[44]-J[45]-J[46]+J[47]+J[48]-J[49]-J[50]+
    J[51]-J[52]-J[53]+J[54]+J[55]-J[56]-J[57]+J[58]+J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], -H[0]+H[1]+
    H[2]+H[3]+H[4]+H[5]-H[6]-H[7]+H[8]-H[9]+H[10]+H[11]-J[0]-J[1]-J[2]-J[3]-J[4]+J[5]+J[6]-J[7]+J[8]-J[9]-J[10]+
    J[11]+J[12]+J[13]+J[14]-J[15]-J[16]+J[17]-J[18]+J[19]+J[20]+J[21]+J[22]+J[23]-J[24]-J[25]+J[26]-J[27]+
    J[28]+J[29]+J[30]+J[31]-J[32]-J[33]+J[34]-J[35]+J[36]+J[37]+J[38]-J[39]-J[40]+J[41]-J[42]+J[43]+J[44]-J[45]-J[46]+
    J[47]-J[48]+J[49]+J[50]+J[51]-J[52]+J[53]-J[54]-J[55]-J[56]+J[57]-J[58]-J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+
    J[65], -H[0]+H[1]+H[2]+H[3]+H[4]+H[5]-H[6]-H[7]+H[8]-H[9]+H[10]-H[11]-J[0]-J[1]-J[2]-J[3]-J[4]+J[5]+
    J[6]-J[7]+J[8]-J[9]+J[10]+J[11]+J[12]+J[13]+J[14]-J[15]-J[16]+J[17]-J[18]+J[19]-J[20]+J[21]+J[22]+J[23]-J[24]-J[25]+
    J[26]-J[27]+J[28]-J[29]+J[30]+J[31]-J[32]-J[33]+J[34]-J[35]+J[36]-J[37]+J[38]-J[39]-J[40]+J[41]-J[42]+
    J[43]-J[44]-J[45]-J[46]+J[47]-J[48]+J[49]-J[50]+J[51]-J[52]+J[53]-J[54]+J[55]-J[56]+J[57]-J[58]+J[59]-J[60]+
    J[61]-J[62]-J[63]+J[64]-J[65], -H[0]+H[1]+H[2]+H[3]+H[4]+H[5]-H[6]-H[7]+H[8]-H[9]-H[10]+H[11]-J[0]-J[1]-J[2]-J[3]-J[4]+
    J[5]+J[6]-J[7]+J[8]+J[9]-J[10]+J[11]+J[12]+J[13]+J[14]-J[15]-J[16]+J[17]-J[18]-J[19]+J[20]+J[21]+J[22]+
    J[23]-J[24]-J[25]+J[26]-J[27]-J[28]+J[29]+J[30]+J[31]-J[32]-J[33]+J[34]-J[35]-J[36]+J[37]+J[38]-J[39]-J[40]+
    J[41]-J[42]-J[43]+J[44]-J[45]-J[46]+J[47]-J[48]-J[49]+J[50]+J[51]-J[52]+J[53]+J[54]-J[55]-J[56]+J[57]+
    J[58]-J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], -H[0]+H[1]+H[2]+H[3]+H[4]+H[5]-H[6]-H[7]+H[8]-H[9]-H[10]-H[11]-J[0]-J[1]-J[2]-J[3]-J[4]+
    J[5]+J[6]-J[7]+J[8]+J[9]+J[10]+J[11]+J[12]+J[13]+J[14]-J[15]-J[16]+J[17]-J[18]-J[19]-J[20]+J[21]+J[22]+
    J[23]-J[24]-J[25]+J[26]-J[27]-J[28]-J[29]+J[30]+J[31]-J[32]-J[33]+J[34]-J[35]-J[36]-J[37]+J[38]-J[39]-J[40]+
    J[41]-J[42]-J[43]-J[44]-J[45]-J[46]+J[47]-J[48]-J[49]-J[50]+J[51]-J[52]+J[53]+J[54]+J[55]-J[56]+J[57]+
    J[58]+J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], -H[0]+H[1]+H[2]+H[3]+H[4]+H[5]-H[6]-H[7]-H[8]+H[9]+
    H[10]+H[11]-J[0]-J[1]-J[2]-J[3]-J[4]+J[5]+J[6]+J[7]-J[8]-J[9]-J[10]+J[11]+J[12]+J[13]+J[14]-J[15]-J[16]-J[17]+
    J[18]+J[19]+J[20]+J[21]+J[22]+J[23]-J[24]-J[25]-J[26]+J[27]+J[28]+J[29]+J[30]+J[31]-J[32]-J[33]-J[34]+
    J[35]+J[36]+J[37]+J[38]-J[39]-J[40]-J[41]+J[42]+J[43]+J[44]-J[45]-J[46]-J[47]+J[48]+J[49]+J[50]+J[51]+
    J[52]-J[53]-J[54]-J[55]+J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], -H[0]+H[1]+H[2]+
    H[3]+H[4]+H[5]-H[6]-H[7]-H[8]+H[9]+H[10]-H[11]-J[0]-J[1]-J[2]-J[3]-J[4]+J[5]+J[6]+J[7]-J[8]-J[9]+J[10]+
    J[11]+J[12]+J[13]+J[14]-J[15]-J[16]-J[17]+J[18]+J[19]-J[20]+J[21]+J[22]+J[23]-J[24]-J[25]-J[26]+J[27]+
    J[28]-J[29]+J[30]+J[31]-J[32]-J[33]-J[34]+J[35]+J[36]-J[37]+J[38]-J[39]-J[40]-J[41]+J[42]+J[43]-J[44]-J[45]-J[46]-J[47]+
    J[48]+J[49]-J[50]+J[51]+J[52]-J[53]-J[54]+J[55]+J[56]-J[57]-J[58]+J[59]-J[60]-J[61]+J[62]+J[63]-J[64]-J[65], -H[0]+
    H[1]+H[2]+H[3]+H[4]+H[5]-H[6]-H[7]-H[8]+H[9]-H[10]+H[11]-J[0]-J[1]-J[2]-J[3]-J[4]+J[5]+J[6]+J[7]-J[8]+
    J[9]-J[10]+J[11]+J[12]+J[13]+J[14]-J[15]-J[16]-J[17]+J[18]-J[19]+J[20]+J[21]+J[22]+J[23]-J[24]-J[25]-J[26]+
    J[27]-J[28]+J[29]+J[30]+J[31]-J[32]-J[33]-J[34]+J[35]-J[36]+J[37]+J[38]-J[39]-J[40]-J[41]+J[42]-J[43]+
    J[44]-J[45]-J[46]-J[47]+J[48]-J[49]+J[50]+J[51]+J[52]-J[53]+J[54]-J[55]+J[56]-J[57]+J[58]-J[59]-J[60]+
    J[61]-J[62]-J[63]+J[64]-J[65], -H[0]+H[1]+H[2]+H[3]+H[4]+H[5]-H[6]-H[7]-H[8]+H[9]-H[10]-H[11]-J[0]-J[1]-J[2]-J[3]-J[4]+
    J[5]+J[6]+J[7]-J[8]+J[9]+J[10]+J[11]+J[12]+J[13]+J[14]-J[15]-J[16]-J[17]+J[18]-J[19]-J[20]+J[21]+J[22]+
    J[23]-J[24]-J[25]-J[26]+J[27]-J[28]-J[29]+J[30]+J[31]-J[32]-J[33]-J[34]+J[35]-J[36]-J[37]+J[38]-J[39]-J[40]-J[41]+
    J[42]-J[43]-J[44]-J[45]-J[46]-J[47]+J[48]-J[49]-J[50]+J[51]+J[52]-J[53]+J[54]+J[55]+J[56]-J[57]+J[58]+
    J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], -H[0]+H[1]+H[2]+H[3]+H[4]+H[5]-H[6]-H[7]-H[8]-H[9]+H[10]+
    H[11]-J[0]-J[1]-J[2]-J[3]-J[4]+J[5]+J[6]+J[7]+J[8]-J[9]-J[10]+J[11]+J[12]+J[13]+J[14]-J[15]-J[16]-J[17]-J[18]+
    J[19]+J[20]+J[21]+J[22]+J[23]-J[24]-J[25]-J[26]-J[27]+J[28]+J[29]+J[30]+J[31]-J[32]-J[33]-J[34]-J[35]+
    J[36]+J[37]+J[38]-J[39]-J[40]-J[41]-J[42]+J[43]+J[44]-J[45]-J[46]-J[47]-J[48]+J[49]+J[50]+J[51]+J[52]+
    J[53]-J[54]-J[55]+J[56]+J[57]-J[58]-J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], -H[0]+H[1]+H[2]+H[3]+
    H[4]+H[5]-H[6]-H[7]-H[8]-H[9]+H[10]-H[11]-J[0]-J[1]-J[2]-J[3]-J[4]+J[5]+J[6]+J[7]+J[8]-J[9]+J[10]+J[11]+
    J[12]+J[13]+J[14]-J[15]-J[16]-J[17]-J[18]+J[19]-J[20]+J[21]+J[22]+J[23]-J[24]-J[25]-J[26]-J[27]+J[28]-J[29]+
    J[30]+J[31]-J[32]-J[33]-J[34]-J[35]+J[36]-J[37]+J[38]-J[39]-J[40]-J[41]-J[42]+J[43]-J[44]-J[45]-J[46]-J[47]-J[48]+
    J[49]-J[50]+J[51]+J[52]+J[53]-J[54]+J[55]+J[56]+J[57]-J[58]+J[59]+J[60]-J[61]+J[62]-J[63]+J[64]-J[65], -H[0]+
    H[1]+H[2]+H[3]+H[4]+H[5]-H[6]-H[7]-H[8]-H[9]-H[10]+H[11]-J[0]-J[1]-J[2]-J[3]-J[4]+J[5]+J[6]+J[7]+J[8]+
    J[9]-J[10]+J[11]+J[12]+J[13]+J[14]-J[15]-J[16]-J[17]-J[18]-J[19]+J[20]+J[21]+J[22]+J[23]-J[24]-J[25]-J[26]-J[27]-J[28]+
    J[29]+J[30]+J[31]-J[32]-J[33]-J[34]-J[35]-J[36]+J[37]+J[38]-J[39]-J[40]-J[41]-J[42]-J[43]+J[44]-J[45]-J[46]-J[47]-J[48]-J[49]+
    J[50]+J[51]+J[52]+J[53]+J[54]-J[55]+J[56]+J[57]+J[58]-J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], -H[0]+
    H[1]+H[2]+H[3]+H[4]+H[5]-H[6]-H[7]-H[8]-H[9]-H[10]-H[11]-J[0]-J[1]-J[2]-J[3]-J[4]+J[5]+J[6]+J[7]+J[8]+
    J[9]+J[10]+J[11]+J[12]+J[13]+J[14]-J[15]-J[16]-J[17]-J[18]-J[19]-J[20]+J[21]+J[22]+J[23]-J[24]-J[25]-J[26]-J[27]-J[28]-J[29]+
    J[30]+J[31]-J[32]-J[33]-J[34]-J[35]-J[36]-J[37]+J[38]-J[39]-J[40]-J[41]-J[42]-J[43]-J[44]-J[45]-J[46]-J[47]-J[48]-J[49]-J[50]+
    J[51]+J[52]+J[53]+J[54]+J[55]+J[56]+J[57]+J[58]+J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], -H[0]+H[1]+
    H[2]+H[3]+H[4]-H[5]+H[6]+H[7]+H[8]+H[9]+H[10]+H[11]-J[0]-J[1]-J[2]-J[3]+J[4]-J[5]-J[6]-J[7]-J[8]-J[9]-J[10]+
    J[11]+J[12]+J[13]-J[14]+J[15]+J[16]+J[17]+J[18]+J[19]+J[20]+J[21]+J[22]-J[23]+J[24]+J[25]+J[26]+J[27]+
    J[28]+J[29]+J[30]-J[31]+J[32]+J[33]+J[34]+J[35]+J[36]+J[37]-J[38]+J[39]+J[40]+J[41]+J[42]+J[43]+J[44]-J[45]-J[46]-J[47]-J[48]-J[49]-J[50]+
    J[51]+J[52]+J[53]+J[54]+J[55]+J[56]+J[57]+J[58]+J[59]+J[60]+J[61]+J[62]+J[63]+J[64]+J[65], -H[0]+H[1]+
    H[2]+H[3]+H[4]-H[5]+H[6]+H[7]+H[8]+H[9]+H[10]-H[11]-J[0]-J[1]-J[2]-J[3]+J[4]-J[5]-J[6]-J[7]-J[8]-J[9]+
    J[10]+J[11]+J[12]+J[13]-J[14]+J[15]+J[16]+J[17]+J[18]+J[19]-J[20]+J[21]+J[22]-J[23]+J[24]+J[25]+J[26]+
    J[27]+J[28]-J[29]+J[30]-J[31]+J[32]+J[33]+J[34]+J[35]+J[36]-J[37]-J[38]+J[39]+J[40]+J[41]+J[42]+J[43]-J[44]-J[45]-J[46]-J[47]-J[48]-J[49]+
    J[50]+J[51]+J[52]+J[53]+J[54]-J[55]+J[56]+J[57]+J[58]-J[59]+J[60]+J[61]-J[62]+J[63]-J[64]-J[65], -H[0]+
    H[1]+H[2]+H[3]+H[4]-H[5]+H[6]+H[7]+H[8]+H[9]-H[10]+H[11]-J[0]-J[1]-J[2]-J[3]+J[4]-J[5]-J[6]-J[7]-J[8]+
    J[9]-J[10]+J[11]+J[12]+J[13]-J[14]+J[15]+J[16]+J[17]+J[18]-J[19]+J[20]+J[21]+J[22]-J[23]+J[24]+J[25]+
    J[26]+J[27]-J[28]+J[29]+J[30]-J[31]+J[32]+J[33]+J[34]+J[35]-J[36]+J[37]-J[38]+J[39]+J[40]+J[41]+J[42]-J[43]+
    J[44]-J[45]-J[46]-J[47]-J[48]+J[49]-J[50]+J[51]+J[52]+J[53]-J[54]+J[55]+J[56]+J[57]-J[58]+J[59]+J[60]-J[61]+
    J[62]-J[63]+J[64]-J[65], -H[0]+H[1]+H[2]+H[3]+H[4]-H[5]+H[6]+H[7]+H[8]+H[9]-H[10]-H[11]-J[0]-J[1]-J[2]-J[3]+
    J[4]-J[5]-J[6]-J[7]-J[8]+J[9]+J[10]+J[11]+J[12]+J[13]-J[14]+J[15]+J[16]+J[17]+J[18]-J[19]-J[20]+J[21]+
    J[22]-J[23]+J[24]+J[25]+J[26]+J[27]-J[28]-J[29]+J[30]-J[31]+J[32]+J[33]+J[34]+J[35]-J[36]-J[37]-J[38]+
    J[39]+J[40]+J[41]+J[42]-J[43]-J[44]-J[45]-J[46]-J[47]-J[48]+J[49]+J[50]+J[51]+J[52]+J[53]-J[54]-J[55]+
    J[56]+J[57]-J[58]-J[59]+J[60]-J[61]-J[62]-J[63]-J[64]+J[65], -H[0]+H[1]+H[2]+H[3]+H[4]-H[5]+H[6]+H[7]+
    H[8]-H[9]+H[10]+H[11]-J[0]-J[1]-J[2]-J[3]+J[4]-J[5]-J[6]-J[7]+J[8]-J[9]-J[10]+J[11]+J[12]+J[13]-J[14]+
    J[15]+J[16]+J[17]-J[18]+J[19]+J[20]+J[21]+J[22]-J[23]+J[24]+J[25]+J[26]-J[27]+J[28]+J[29]+J[30]-J[31]+
    J[32]+J[33]+J[34]-J[35]+J[36]+J[37]-J[38]+J[39]+J[40]+J[41]-J[42]+J[43]+J[44]-J[45]-J[46]-J[47]+J[48]-J[49]-J[50]+
    J[51]+J[52]-J[53]+J[54]+J[55]+J[56]-J[57]+J[58]+J[59]-J[60]+J[61]+J[62]-J[63]-J[64]+J[65], -H[0]+H[1]+
    H[2]+H[3]+H[4]-H[5]+H[6]+H[7]+H[8]-H[9]+H[10]-H[11]-J[0]-J[1]-J[2]-J[3]+J[4]-J[5]-J[6]-J[7]+J[8]-J[9]+
    J[10]+J[11]+J[12]+J[13]-J[14]+J[15]+J[16]+J[17]-J[18]+J[19]-J[20]+J[21]+J[22]-J[23]+J[24]+J[25]+J[26]-J[27]+
    J[28]-J[29]+J[30]-J[31]+J[32]+J[33]+J[34]-J[35]+J[36]-J[37]-J[38]+J[39]+J[40]+J[41]-J[42]+J[43]-J[44]-J[45]-J[46]-J[47]+
    J[48]-J[49]+J[50]+J[51]+J[52]-J[53]+J[54]-J[55]+J[56]-J[57]+J[58]-J[59]-J[60]+J[61]-J[62]-J[63]+J[64]-J[65], -H[0]+
    H[1]+H[2]+H[3]+H[4]-H[5]+H[6]+H[7]+H[8]-H[9]-H[10]+H[11]-J[0]-J[1]-J[2]-J[3]+J[4]-J[5]-J[6]-J[7]+J[8]+
    J[9]-J[10]+J[11]+J[12]+J[13]-J[14]+J[15]+J[16]+J[17]-J[18]-J[19]+J[20]+J[21]+J[22]-J[23]+J[24]+J[25]+
    J[26]-J[27]-J[28]+J[29]+J[30]-J[31]+J[32]+J[33]+J[34]-J[35]-J[36]+J[37]-J[38]+J[39]+J[40]+J[41]-J[42]-J[43]+
    J[44]-J[45]-J[46]-J[47]+J[48]+J[49]-J[50]+J[51]+J[52]-J[53]-J[54]+J[55]+J[56]-J[57]-J[58]+J[59]-J[60]-J[61]+
    J[62]+J[63]-J[64]-J[65], -H[0]+H[1]+H[2]+H[3]+H[4]-H[5]+H[6]+H[7]+H[8]-H[9]-H[10]-H[11]-J[0]-J[1]-J[2]-J[3]+
    J[4]-J[5]-J[6]-J[7]+J[8]+J[9]+J[10]+J[11]+J[12]+J[13]-J[14]+J[15]+J[16]+J[17]-J[18]-J[19]-J[20]+J[21]+
    J[22]-J[23]+J[24]+J[25]+J[26]-J[27]-J[28]-J[29]+J[30]-J[31]+J[32]+J[33]+J[34]-J[35]-J[36]-J[37]-J[38]+
    J[39]+J[40]+J[41]-J[42]-J[43]-J[44]-J[45]-J[46]-J[47]+J[48]+J[49]+J[50]+J[51]+J[52]-J[53]-J[54]-J[55]+
    J[56]-J[57]-J[58]-J[59]-J[60]-J[61]-J[62]+J[63]+J[64]+J[65], -H[0]+H[1]+H[2]+H[3]+H[4]-H[5]+H[6]+H[7]-H[8]+
    H[9]+H[10]+H[11]-J[0]-J[1]-J[2]-J[3]+J[4]-J[5]-J[6]+J[7]-J[8]-J[9]-J[10]+J[11]+J[12]+J[13]-J[14]+J[15]+
    J[16]-J[17]+J[18]+J[19]+J[20]+J[21]+J[22]-J[23]+J[24]+J[25]-J[26]+J[27]+J[28]