# MIT License
# 
# Copyright (c) 2019 Edward D. Lee, Bryan C. Daniels
# 
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
# 
# The above copyright notice and this permission notice shall be included in all
# copies or substantial portions of the Software.
# 
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
# SOFTWARE.

# Equations for 8-spin Ising model.

# Written on 2019/09/19.
from numpy import zeros, exp, array, prod, isnan
from ..enumerate import fast_logsumexp

def calc_observables(params):
    """
    Give all parameters concatenated into one array from lowest to highest order.
    Returns all correlations.
    """
    Cout = zeros((36))
    H = params[0:8]
    J = params[8:36]
    energyTerms = array([    +H[0]+H[1]+H[2]+H[3]+H[4]+H[5]+H[6]+H[7]+J[0]+J[1]+J[2]+J[3]+J[4]+J[5]+J[6]+J[7]+J[8]+J[9]+J[10]+J[11]+
    J[12]+J[13]+J[14]+J[15]+J[16]+J[17]+J[18]+J[19]+J[20]+J[21]+J[22]+J[23]+J[24]+J[25]+J[26]+J[27], +H[0]+
    H[1]+H[2]+H[3]+H[4]+H[5]+H[6]-H[7]+J[0]+J[1]+J[2]+J[3]+J[4]+J[5]-J[6]+J[7]+J[8]+J[9]+J[10]+J[11]-J[12]+
    J[13]+J[14]+J[15]+J[16]-J[17]+J[18]+J[19]+J[20]-J[21]+J[22]+J[23]-J[24]+J[25]-J[26]-J[27], +H[0]+H[1]+
    H[2]+H[3]+H[4]+H[5]-H[6]+H[7]+J[0]+J[1]+J[2]+J[3]+J[4]-J[5]+J[6]+J[7]+J[8]+J[9]+J[10]-J[11]+J[12]+J[13]+
    J[14]+J[15]-J[16]+J[17]+J[18]+J[19]-J[20]+J[21]+J[22]-J[23]+J[24]-J[25]+J[26]-J[27], +H[0]+H[1]+H[2]+
    H[3]+H[4]+H[5]-H[6]-H[7]+J[0]+J[1]+J[2]+J[3]+J[4]-J[5]-J[6]+J[7]+J[8]+J[9]+J[10]-J[11]-J[12]+J[13]+J[14]+
    J[15]-J[16]-J[17]+J[18]+J[19]-J[20]-J[21]+J[22]-J[23]-J[24]-J[25]-J[26]+J[27], +H[0]+H[1]+H[2]+H[3]+
    H[4]-H[5]+H[6]+H[7]+J[0]+J[1]+J[2]+J[3]-J[4]+J[5]+J[6]+J[7]+J[8]+J[9]-J[10]+J[11]+J[12]+J[13]+J[14]-J[15]+
    J[16]+J[17]+J[18]-J[19]+J[20]+J[21]-J[22]+J[23]+J[24]-J[25]-J[26]+J[27], +H[0]+H[1]+H[2]+H[3]+H[4]-H[5]+
    H[6]-H[7]+J[0]+J[1]+J[2]+J[3]-J[4]+J[5]-J[6]+J[7]+J[8]+J[9]-J[10]+J[11]-J[12]+J[13]+J[14]-J[15]+J[16]-J[17]+
    J[18]-J[19]+J[20]-J[21]-J[22]+J[23]-J[24]-J[25]+J[26]-J[27], +H[0]+H[1]+H[2]+H[3]+H[4]-H[5]-H[6]+H[7]+
    J[0]+J[1]+J[2]+J[3]-J[4]-J[5]+J[6]+J[7]+J[8]+J[9]-J[10]-J[11]+J[12]+J[13]+J[14]-J[15]-J[16]+J[17]+J[18]-J[19]-J[20]+
    J[21]-J[22]-J[23]+J[24]+J[25]-J[26]-J[27], +H[0]+H[1]+H[2]+H[3]+H[4]-H[5]-H[6]-H[7]+J[0]+J[1]+J[2]+J[3]-J[4]-J[5]-J[6]+
    J[7]+J[8]+J[9]-J[10]-J[11]-J[12]+J[13]+J[14]-J[15]-J[16]-J[17]+J[18]-J[19]-J[20]-J[21]-J[22]-J[23]-J[24]+
    J[25]+J[26]+J[27], +H[0]+H[1]+H[2]+H[3]-H[4]+H[5]+H[6]+H[7]+J[0]+J[1]+J[2]-J[3]+J[4]+J[5]+J[6]+J[7]+
    J[8]-J[9]+J[10]+J[11]+J[12]+J[13]-J[14]+J[15]+J[16]+J[17]-J[18]+J[19]+J[20]+J[21]-J[22]-J[23]-J[24]+
    J[25]+J[26]+J[27], +H[0]+H[1]+H[2]+H[3]-H[4]+H[5]+H[6]-H[7]+J[0]+J[1]+J[2]-J[3]+J[4]+J[5]-J[6]+J[7]+
    J[8]-J[9]+J[10]+J[11]-J[12]+J[13]-J[14]+J[15]+J[16]-J[17]-J[18]+J[19]+J[20]-J[21]-J[22]-J[23]+J[24]+
    J[25]-J[26]-J[27], +H[0]+H[1]+H[2]+H[3]-H[4]+H[5]-H[6]+H[7]+J[0]+J[1]+J[2]-J[3]+J[4]-J[5]+J[6]+J[7]+
    J[8]-J[9]+J[10]-J[11]+J[12]+J[13]-J[14]+J[15]-J[16]+J[17]-J[18]+J[19]-J[20]+J[21]-J[22]+J[23]-J[24]-J[25]+
    J[26]-J[27], +H[0]+H[1]+H[2]+H[3]-H[4]+H[5]-H[6]-H[7]+J[0]+J[1]+J[2]-J[3]+J[4]-J[5]-J[6]+J[7]+J[8]-J[9]+
    J[10]-J[11]-J[12]+J[13]-J[14]+J[15]-J[16]-J[17]-J[18]+J[19]-J[20]-J[21]-J[22]+J[23]+J[24]-J[25]-J[26]+
    J[27], +H[0]+H[1]+H[2]+H[3]-H[4]-H[5]+H[6]+H[7]+J[0]+J[1]+J[2]-J[3]-J[4]+J[5]+J[6]+J[7]+J[8]-J[9]-J[10]+
    J[11]+J[12]+J[13]-J[14]-J[15]+J[16]+J[17]-J[18]-J[19]+J[20]+J[21]+J[22]-J[23]-J[24]-J[25]-J[26]+J[27], +
    H[0]+H[1]+H[2]+H[3]-H[4]-H[5]+H[6]-H[7]+J[0]+J[1]+J[2]-J[3]-J[4]+J[5]-J[6]+J[7]+J[8]-J[9]-J[10]+J[11]-J[12]+
    J[13]-J[14]-J[15]+J[16]-J[17]-J[18]-J[19]+J[20]-J[21]+J[22]-J[23]+J[24]-J[25]+J[26]-J[27], +H[0]+H[1]+
    H[2]+H[3]-H[4]-H[5]-H[6]+H[7]+J[0]+J[1]+J[2]-J[3]-J[4]-J[5]+J[6]+J[7]+J[8]-J[9]-J[10]-J[11]+J[12]+J[13]-J[14]-J[15]-J[16]+
    J[17]-J[18]-J[19]-J[20]+J[21]+J[22]+J[23]-J[24]+J[25]-J[26]-J[27], +H[0]+H[1]+H[2]+H[3]-H[4]-H[5]-H[6]-H[7]+
    J[0]+J[1]+J[2]-J[3]-J[4]-J[5]-J[6]+J[7]+J[8]-J[9]-J[10]-J[11]-J[12]+J[13]-J[14]-J[15]-J[16]-J[17]-J[18]-J[19]-J[20]-J[21]+
    J[22]+J[23]+J[24]+J[25]+J[26]+J[27], +H[0]+H[1]+H[2]-H[3]+H[4]+H[5]+H[6]+H[7]+J[0]+J[1]-J[2]+J[3]+J[4]+
    J[5]+J[6]+J[7]-J[8]+J[9]+J[10]+J[11]+J[12]-J[13]+J[14]+J[15]+J[16]+J[17]-J[18]-J[19]-J[20]-J[21]+J[22]+
    J[23]+J[24]+J[25]+J[26]+J[27], +H[0]+H[1]+H[2]-H[3]+H[4]+H[5]+H[6]-H[7]+J[0]+J[1]-J[2]+J[3]+J[4]+J[5]-J[6]+
    J[7]-J[8]+J[9]+J[10]+J[11]-J[12]-J[13]+J[14]+J[15]+J[16]-J[17]-J[18]-J[19]-J[20]+J[21]+J[22]+J[23]-J[24]+
    J[25]-J[26]-J[27], +H[0]+H[1]+H[2]-H[3]+H[4]+H[5]-H[6]+H[7]+J[0]+J[1]-J[2]+J[3]+J[4]-J[5]+J[6]+J[7]-J[8]+
    J[9]+J[10]-J[11]+J[12]-J[13]+J[14]+J[15]-J[16]+J[17]-J[18]-J[19]+J[20]-J[21]+J[22]-J[23]+J[24]-J[25]+
    J[26]-J[27], +H[0]+H[1]+H[2]-H[3]+H[4]+H[5]-H[6]-H[7]+J[0]+J[1]-J[2]+J[3]+J[4]-J[5]-J[6]+J[7]-J[8]+J[9]+
    J[10]-J[11]-J[12]-J[13]+J[14]+J[15]-J[16]-J[17]-J[18]-J[19]+J[20]+J[21]+J[22]-J[23]-J[24]-J[25]-J[26]+
    J[27], +H[0]+H[1]+H[2]-H[3]+H[4]-H[5]+H[6]+H[7]+J[0]+J[1]-J[2]+J[3]-J[4]+J[5]+J[6]+J[7]-J[8]+J[9]-J[10]+
    J[11]+J[12]-J[13]+J[14]-J[15]+J[16]+J[17]-J[18]+J[19]-J[20]-J[21]-J[22]+J[23]+J[24]-J[25]-J[26]+J[27], +
    H[0]+H[1]+H[2]-H[3]+H[4]-H[5]+H[6]-H[7]+J[0]+J[1]-J[2]+J[3]-J[4]+J[5]-J[6]+J[7]-J[8]+J[9]-J[10]+J[11]-J[12]-J[13]+
    J[14]-J[15]+J[16]-J[17]-J[18]+J[19]-J[20]+J[21]-J[22]+J[23]-J[24]-J[25]+J[26]-J[27], +H[0]+H[1]+H[2]-H[3]+
    H[4]-H[5]-H[6]+H[7]+J[0]+J[1]-J[2]+J[3]-J[4]-J[5]+J[6]+J[7]-J[8]+J[9]-J[10]-J[11]+J[12]-J[13]+J[14]-J[15]-J[16]+
    J[17]-J[18]+J[19]+J[20]-J[21]-J[22]-J[23]+J[24]+J[25]-J[26]-J[27], +H[0]+H[1]+H[2]-H[3]+H[4]-H[5]-H[6]-H[7]+
    J[0]+J[1]-J[2]+J[3]-J[4]-J[5]-J[6]+J[7]-J[8]+J[9]-J[10]-J[11]-J[12]-J[13]+J[14]-J[15]-J[16]-J[17]-J[18]+
    J[19]+J[20]+J[21]-J[22]-J[23]-J[24]+J[25]+J[26]+J[27], +H[0]+H[1]+H[2]-H[3]-H[4]+H[5]+H[6]+H[7]+J[0]+
    J[1]-J[2]-J[3]+J[4]+J[5]+J[6]+J[7]-J[8]-J[9]+J[10]+J[11]+J[12]-J[13]-J[14]+J[15]+J[16]+J[17]+J[18]-J[19]-J[20]-J[21]-J[22]-J[23]-J[24]+
    J[25]+J[26]+J[27], +H[0]+H[1]+H[2]-H[3]-H[4]+H[5]+H[6]-H[7]+J[0]+J[1]-J[2]-J[3]+J[4]+J[5]-J[6]+J[7]-J[8]-J[9]+
    J[10]+J[11]-J[12]-J[13]-J[14]+J[15]+J[16]-J[17]+J[18]-J[19]-J[20]+J[21]-J[22]-J[23]+J[24]+J[25]-J[26]-J[27], +
    H[0]+H[1]+H[2]-H[3]-H[4]+H[5]-H[6]+H[7]+J[0]+J[1]-J[2]-J[3]+J[4]-J[5]+J[6]+J[7]-J[8]-J[9]+J[10]-J[11]+
    J[12]-J[13]-J[14]+J[15]-J[16]+J[17]+J[18]-J[19]+J[20]-J[21]-J[22]+J[23]-J[24]-J[25]+J[26]-J[27], +H[0]+
    H[1]+H[2]-H[3]-H[4]+H[5]-H[6]-H[7]+J[0]+J[1]-J[2]-J[3]+J[4]-J[5]-J[6]+J[7]-J[8]-J[9]+J[10]-J[11]-J[12]-J[13]-J[14]+
    J[15]-J[16]-J[17]+J[18]-J[19]+J[20]+J[21]-J[22]+J[23]+J[24]-J[25]-J[26]+J[27], +H[0]+H[1]+H[2]-H[3]-H[4]-H[5]+
    H[6]+H[7]+J[0]+J[1]-J[2]-J[3]-J[4]+J[5]+J[6]+J[7]-J[8]-J[9]-J[10]+J[11]+J[12]-J[13]-J[14]-J[15]+J[16]+
    J[17]+J[18]+J[19]-J[20]-J[21]+J[22]-J[23]-J[24]-J[25]-J[26]+J[27], +H[0]+H[1]+H[2]-H[3]-H[4]-H[5]+H[6]-H[7]+
    J[0]+J[1]-J[2]-J[3]-J[4]+J[5]-J[6]+J[7]-J[8]-J[9]-J[10]+J[11]-J[12]-J[13]-J[14]-J[15]+J[16]-J[17]+J[18]+
    J[19]-J[20]+J[21]+J[22]-J[23]+J[24]-J[25]+J[26]-J[27], +H[0]+H[1]+H[2]-H[3]-H[4]-H[5]-H[6]+H[7]+J[0]+
    J[1]-J[2]-J[3]-J[4]-J[5]+J[6]+J[7]-J[8]-J[9]-J[10]-J[11]+J[12]-J[13]-J[14]-J[15]-J[16]+J[17]+J[18]+J[19]+
    J[20]-J[21]+J[22]+J[23]-J[24]+J[25]-J[26]-J[27], +H[0]+H[1]+H[2]-H[3]-H[4]-H[5]-H[6]-H[7]+J[0]+J[1]-J[2]-J[3]-J[4]-J[5]-J[6]+
    J[7]-J[8]-J[9]-J[10]-J[11]-J[12]-J[13]-J[14]-J[15]-J[16]-J[17]+J[18]+J[19]+J[20]+J[21]+J[22]+J[23]+J[24]+
    J[25]+J[26]+J[27], +H[0]+H[1]-H[2]+H[3]+H[4]+H[5]+H[6]+H[7]+J[0]-J[1]+J[2]+J[3]+J[4]+J[5]+J[6]-J[7]+
    J[8]+J[9]+J[10]+J[11]+J[12]-J[13]-J[14]-J[15]-J[16]-J[17]+J[18]+J[19]+J[20]+J[21]+J[22]+J[23]+J[24]+
    J[25]+J[26]+J[27], +H[0]+H[1]-H[2]+H[3]+H[4]+H[5]+H[6]-H[7]+J[0]-J[1]+J[2]+J[3]+J[4]+J[5]-J[6]-J[7]+
    J[8]+J[9]+J[10]+J[11]-J[12]-J[13]-J[14]-J[15]-J[16]+J[17]+J[18]+J[19]+J[20]-J[21]+J[22]+J[23]-J[24]+
    J[25]-J[26]-J[27], +H[0]+H[1]-H[2]+H[3]+H[4]+H[5]-H[6]+H[7]+J[0]-J[1]+J[2]+J[3]+J[4]-J[5]+J[6]-J[7]+
    J[8]+J[9]+J[10]-J[11]+J[12]-J[13]-J[14]-J[15]+J[16]-J[17]+J[18]+J[19]-J[20]+J[21]+J[22]-J[23]+J[24]-J[25]+
    J[26]-J[27], +H[0]+H[1]-H[2]+H[3]+H[4]+H[5]-H[6]-H[7]+J[0]-J[1]+J[2]+J[3]+J[4]-J[5]-J[6]-J[7]+J[8]+J[9]+
    J[10]-J[11]-J[12]-J[13]-J[14]-J[15]+J[16]+J[17]+J[18]+J[19]-J[20]-J[21]+J[22]-J[23]-J[24]-J[25]-J[26]+
    J[27], +H[0]+H[1]-H[2]+H[3]+H[4]-H[5]+H[6]+H[7]+J[0]-J[1]+J[2]+J[3]-J[4]+J[5]+J[6]-J[7]+J[8]+J[9]-J[10]+
    J[11]+J[12]-J[13]-J[14]+J[15]-J[16]-J[17]+J[18]-J[19]+J[20]+J[21]-J[22]+J[23]+J[24]-J[25]-J[26]+J[27], +
    H[0]+H[1]-H[2]+H[3]+H[4]-H[5]+H[6]-H[7]+J[0]-J[1]+J[2]+J[3]-J[4]+J[5]-J[6]-J[7]+J[8]+J[9]-J[10]+J[11]-J[12]-J[13]-J[14]+
    J[15]-J[16]+J[17]+J[18]-J[19]+J[20]-J[21]-J[22]+J[23]-J[24]-J[25]+J[26]-J[27], +H[0]+H[1]-H[2]+H[3]+
    H[4]-H[5]-H[6]+H[7]+J[0]-J[1]+J[2]+J[3]-J[4]-J[5]+J[6]-J[7]+J[8]+J[9]-J[10]-J[11]+J[12]-J[13]-J[14]+
    J[15]+J[16]-J[17]+J[18]-J[19]-J[20]+J[21]-J[22]-J[23]+J[24]+J[25]-J[26]-J[27], +H[0]+H[1]-H[2]+H[3]+
    H[4]-H[5]-H[6]-H[7]+J[0]-J[1]+J[2]+J[3]-J[4]-J[5]-J[6]-J[7]+J[8]+J[9]-J[10]-J[11]-J[12]-J[13]-J[14]+
    J[15]+J[16]+J[17]+J[18]-J[19]-J[20]-J[21]-J[22]-J[23]-J[24]+J[25]+J[26]+J[27], +H[0]+H[1]-H[2]+H[3]-H[4]+
    H[5]+H[6]+H[7]+J[0]-J[1]+J[2]-J[3]+J[4]+J[5]+J[6]-J[7]+J[8]-J[9]+J[10]+J[11]+J[12]-J[13]+J[14]-J[15]-J[16]-J[17]-J[18]+
    J[19]+J[20]+J[21]-J[22]-J[23]-J[24]+J[25]+J[26]+J[27], +H[0]+H[1]-H[2]+H[3]-H[4]+H[5]+H[6]-H[7]+J[0]-J[1]+
    J[2]-J[3]+J[4]+J[5]-J[6]-J[7]+J[8]-J[9]+J[10]+J[11]-J[12]-J[13]+J[14]-J[15]-J[16]+J[17]-J[18]+J[19]+
    J[20]-J[21]-J[22]-J[23]+J[24]+J[25]-J[26]-J[27], +H[0]+H[1]-H[2]+H[3]-H[4]+H[5]-H[6]+H[7]+J[0]-J[1]+
    J[2]-J[3]+J[4]-J[5]+J[6]-J[7]+J[8]-J[9]+J[10]-J[11]+J[12]-J[13]+J[14]-J[15]+J[16]-J[17]-J[18]+J[19]-J[20]+
    J[21]-J[22]+J[23]-J[24]-J[25]+J[26]-J[27], +H[0]+H[1]-H[2]+H[3]-H[4]+H[5]-H[6]-H[7]+J[0]-J[1]+J[2]-J[3]+
    J[4]-J[5]-J[6]-J[7]+J[8]-J[9]+J[10]-J[11]-J[12]-J[13]+J[14]-J[15]+J[16]+J[17]-J[18]+J[19]-J[20]-J[21]-J[22]+
    J[23]+J[24]-J[25]-J[26]+J[27], +H[0]+H[1]-H[2]+H[3]-H[4]-H[5]+H[6]+H[7]+J[0]-J[1]+J[2]-J[3]-J[4]+J[5]+
    J[6]-J[7]+J[8]-J[9]-J[10]+J[11]+J[12]-J[13]+J[14]+J[15]-J[16]-J[17]-J[18]-J[19]+J[20]+J[21]+J[22]-J[23]-J[24]-J[25]-J[26]+
    J[27], +H[0]+H[1]-H[2]+H[3]-H[4]-H[5]+H[6]-H[7]+J[0]-J[1]+J[2]-J[3]-J[4]+J[5]-J[6]-J[7]+J[8]-J[9]-J[10]+
    J[11]-J[12]-J[13]+J[14]+J[15]-J[16]+J[17]-J[18]-J[19]+J[20]-J[21]+J[22]-J[23]+J[24]-J[25]+J[26]-J[27], +
    H[0]+H[1]-H[2]+H[3]-H[4]-H[5]-H[6]+H[7]+J[0]-J[1]+J[2]-J[3]-J[4]-J[5]+J[6]-J[7]+J[8]-J[9]-J[10]-J[11]+
    J[12]-J[13]+J[14]+J[15]+J[16]-J[17]-J[18]-J[19]-J[20]+J[21]+J[22]+J[23]-J[24]+J[25]-J[26]-J[27], +H[0]+
    H[1]-H[2]+H[3]-H[4]-H[5]-H[6]-H[7]+J[0]-J[1]+J[2]-J[3]-J[4]-J[5]-J[6]-J[7]+J[8]-J[9]-J[10]-J[11]-J[12]-J[13]+
    J[14]+J[15]+J[16]+J[17]-J[18]-J[19]-J[20]-J[21]+J[22]+J[23]+J[24]+J[25]+J[26]+J[27], +H[0]+H[1]-H[2]-H[3]+
    H[4]+H[5]+H[6]+H[7]+J[0]-J[1]-J[2]+J[3]+J[4]+J[5]+J[6]-J[7]-J[8]+J[9]+J[10]+J[11]+J[12]+J[13]-J[14]-J[15]-J[16]-J[17]-J[18]-J[19]-J[20]-J[21]+
    J[22]+J[23]+J[24]+J[25]+J[26]+J[27], +H[0]+H[1]-H[2]-H[3]+H[4]+H[5]+H[6]-H[7]+J[0]-J[1]-J[2]+J[3]+J[4]+
    J[5]-J[6]-J[7]-J[8]+J[9]+J[10]+J[11]-J[12]+J[13]-J[14]-J[15]-J[16]+J[17]-J[18]-J[19]-J[20]+J[21]+J[22]+
    J[23]-J[24]+J[25]-J[26]-J[27], +H[0]+H[1]-H[2]-H[3]+H[4]+H[5]-H[6]+H[7]+J[0]-J[1]-J[2]+J[3]+J[4]-J[5]+
    J[6]-J[7]-J[8]+J[9]+J[10]-J[11]+J[12]+J[13]-J[14]-J[15]+J[16]-J[17]-J[18]-J[19]+J[20]-J[21]+J[22]-J[23]+
    J[24]-J[25]+J[26]-J[27], +H[0]+H[1]-H[2]-H[3]+H[4]+H[5]-H[6]-H[7]+J[0]-J[1]-J[2]+J[3]+J[4]-J[5]-J[6]-J[7]-J[8]+
    J[9]+J[10]-J[11]-J[12]+J[13]-J[14]-J[15]+J[16]+J[17]-J[18]-J[19]+J[20]+J[21]+J[22]-J[23]-J[24]-J[25]-J[26]+
    J[27], +H[0]+H[1]-H[2]-H[3]+H[4]-H[5]+H[6]+H[7]+J[0]-J[1]-J[2]+J[3]-J[4]+J[5]+J[6]-J[7]-J[8]+J[9]-J[10]+
    J[11]+J[12]+J[13]-J[14]+J[15]-J[16]-J[17]-J[18]+J[19]-J[20]-J[21]-J[22]+J[23]+J[24]-J[25]-J[26]+J[27], +
    H[0]+H[1]-H[2]-H[3]+H[4]-H[5]+H[6]-H[7]+J[0]-J[1]-J[2]+J[3]-J[4]+J[5]-J[6]-J[7]-J[8]+J[9]-J[10]+J[11]-J[12]+
    J[13]-J[14]+J[15]-J[16]+J[17]-J[18]+J[19]-J[20]+J[21]-J[22]+J[23]-J[24]-J[25]+J[26]-J[27], +H[0]+H[1]-H[2]-H[3]+
    H[4]-H[5]-H[6]+H[7]+J[0]-J[1]-J[2]+J[3]-J[4]-J[5]+J[6]-J[7]-J[8]+J[9]-J[10]-J[11]+J[12]+J[13]-J[14]+
    J[15]+J[16]-J[17]-J[18]+J[19]+J[20]-J[21]-J[22]-J[23]+J[24]+J[25]-J[26]-J[27], +H[0]+H[1]-H[2]-H[3]+
    H[4]-H[5]-H[6]-H[7]+J[0]-J[1]-J[2]+J[3]-J[4]-J[5]-J[6]-J[7]-J[8]+J[9]-J[10]-J[11]-J[12]+J[13]-J[14]+
    J[15]+J[16]+J[17]-J[18]+J[19]+J[20]+J[21]-J[22]-J[23]-J[24]+J[25]+J[26]+J[27], +H[0]+H[1]-H[2]-H[3]-H[4]+
    H[5]+H[6]+H[7]+J[0]-J[1]-J[2]-J[3]+J[4]+J[5]+J[6]-J[7]-J[8]-J[9]+J[10]+J[11]+J[12]+J[13]+J[14]-J[15]-J[16]-J[17]+
    J[18]-J[19]-J[20]-J[21]-J[22]-J[23]-J[24]+J[25]+J[26]+J[27], +H[0]+H[1]-H[2]-H[3]-H[4]+H[5]+H[6]-H[7]+
    J[0]-J[1]-J[2]-J[3]+J[4]+J[5]-J[6]-J[7]-J[8]-J[9]+J[10]+J[11]-J[12]+J[13]+J[14]-J[15]-J[16]+J[17]+J[18]-J[19]-J[20]+
    J[21]-J[22]-J[23]+J[24]+J[25]-J[26]-J[27], +H[0]+H[1]-H[2]-H[3]-H[4]+H[5]-H[6]+H[7]+J[0]-J[1]-J[2]-J[3]+
    J[4]-J[5]+J[6]-J[7]-J[8]-J[9]+J[10]-J[11]+J[12]+J[13]+J[14]-J[15]+J[16]-J[17]+J[18]-J[19]+J[20]-J[21]-J[22]+
    J[23]-J[24]-J[25]+J[26]-J[27], +H[0]+H[1]-H[2]-H[3]-H[4]+H[5]-H[6]-H[7]+J[0]-J[1]-J[2]-J[3]+J[4]-J[5]-J[6]-J[7]-J[8]-J[9]+
    J[10]-J[11]-J[12]+J[13]+J[14]-J[15]+J[16]+J[17]+J[18]-J[19]+J[20]+J[21]-J[22]+J[23]+J[24]-J[25]-J[26]+
    J[27], +H[0]+H[1]-H[2]-H[3]-H[4]-H[5]+H[6]+H[7]+J[0]-J[1]-J[2]-J[3]-J[4]+J[5]+J[6]-J[7]-J[8]-J[9]-J[10]+
    J[11]+J[12]+J[13]+J[14]+J[15]-J[16]-J[17]+J[18]+J[19]-J[20]-J[21]+J[22]-J[23]-J[24]-J[25]-J[26]+J[27], +
    H[0]+H[1]-H[2]-H[3]-H[4]-H[5]+H[6]-H[7]+J[0]-J[1]-J[2]-J[3]-J[4]+J[5]-J[6]-J[7]-J[8]-J[9]-J[10]+J[11]-J[12]+
    J[13]+J[14]+J[15]-J[16]+J[17]+J[18]+J[19]-J[20]+J[21]+J[22]-J[23]+J[24]-J[25]+J[26]-J[27], +H[0]+H[1]-H[2]-H[3]-H[4]-H[5]-H[6]+
    H[7]+J[0]-J[1]-J[2]-J[3]-J[4]-J[5]+J[6]-J[7]-J[8]-J[9]-J[10]-J[11]+J[12]+J[13]+J[14]+J[15]+J[16]-J[17]+
    J[18]+J[19]+J[20]-J[21]+J[22]+J[23]-J[24]+J[25]-J[26]-J[27], +H[0]+H[1]-H[2]-H[3]-H[4]-H[5]-H[6]-H[7]+
    J[0]-J[1]-J[2]-J[3]-J[4]-J[5]-J[6]-J[7]-J[8]-J[9]-J[10]-J[11]-J[12]+J[13]+J[14]+J[15]+J[16]+J[17]+J[18]+
    J[19]+J[20]+J[21]+J[22]+J[23]+J[24]+J[25]+J[26]+J[27], +H[0]-H[1]+H[2]+H[3]+H[4]+H[5]+H[6]+H[7]-J[0]+
    J[1]+J[2]+J[3]+J[4]+J[5]+J[6]-J[7]-J[8]-J[9]-J[10]-J[11]-J[12]+J[13]+J[14]+J[15]+J[16]+J[17]+J[18]+J[19]+
    J[20]+J[21]+J[22]+J[23]+J[24]+J[25]+J[26]+J[27], +H[0]-H[1]+H[2]+H[3]+H[4]+H[5]+H[6]-H[7]-J[0]+J[1]+
    J[2]+J[3]+J[4]+J[5]-J[6]-J[7]-J[8]-J[9]-J[10]-J[11]+J[12]+J[13]+J[14]+J[15]+J[16]-J[17]+J[18]+J[19]+
    J[20]-J[21]+J[22]+J[23]-J[24]+J[25]-J[26]-J[27], +H[0]-H[1]+H[2]+H[3]+H[4]+H[5]-H[6]+H[7]-J[0]+J[1]+
    J[2]+J[3]+J[4]-J[5]+J[6]-J[7]-J[8]-J[9]-J[10]+J[11]-J[12]+J[13]+J[14]+J[15]-J[16]+J[17]+J[18]+J[19]-J[20]+
    J[21]+J[22]-J[23]+J[24]-J[25]+J[26]-J[27], +H[0]-H[1]+H[2]+H[3]+H[4]+H[5]-H[6]-H[7]-J[0]+J[1]+J[2]+J[3]+
    J[4]-J[5]-J[6]-J[7]-J[8]-J[9]-J[10]+J[11]+J[12]+J[13]+J[14]+J[15]-J[16]-J[17]+J[18]+J[19]-J[20]-J[21]+
    J[22]-J[23]-J[24]-J[25]-J[26]+J[27], +H[0]-H[1]+H[2]+H[3]+H[4]-H[5]+H[6]+H[7]-J[0]+J[1]+J[2]+J[3]-J[4]+
    J[5]+J[6]-J[7]-J[8]-J[9]+J[10]-J[11]-J[12]+J[13]+J[14]-J[15]+J[16]+J[17]+J[18]-J[19]+J[20]+J[21]-J[22]+
    J[23]+J[24]-J[25]-J[26]+J[27], +H[0]-H[1]+H[2]+H[3]+H[4]-H[5]+H[6]-H[7]-J[0]+J[1]+J[2]+J[3]-J[4]+J[5]-J[6]-J[7]-J[8]-J[9]+
    J[10]-J[11]+J[12]+J[13]+J[14]-J[15]+J[16]-J[17]+J[18]-J[19]+J[20]-J[21]-J[22]+J[23]-J[24]-J[25]+J[26]-J[27], +
    H[0]-H[1]+H[2]+H[3]+H[4]-H[5]-H[6]+H[7]-J[0]+J[1]+J[2]+J[3]-J[4]-J[5]+J[6]-J[7]-J[8]-J[9]+J[10]+J[11]-J[12]+
    J[13]+J[14]-J[15]-J[16]+J[17]+J[18]-J[19]-J[20]+J[21]-J[22]-J[23]+J[24]+J[25]-J[26]-J[27], +H[0]-H[1]+
    H[2]+H[3]+H[4]-H[5]-H[6]-H[7]-J[0]+J[1]+J[2]+J[3]-J[4]-J[5]-J[6]-J[7]-J[8]-J[9]+J[10]+J[11]+J[12]+J[13]+
    J[14]-J[15]-J[16]-J[17]+J[18]-J[19]-J[20]-J[21]-J[22]-J[23]-J[24]+J[25]+J[26]+J[27], +H[0]-H[1]+H[2]+
    H[3]-H[4]+H[5]+H[6]+H[7]-J[0]+J[1]+J[2]-J[3]+J[4]+J[5]+J[6]-J[7]-J[8]+J[9]-J[10]-J[11]-J[12]+J[13]-J[14]+
    J[15]+J[16]+J[17]-J[18]+J[19]+J[20]+J[21]-J[22]-J[23]-J[24]+J[25]+J[26]+J[27], +H[0]-H[1]+H[2]+H[3]-H[4]+
    H[5]+H[6]-H[7]-J[0]+J[1]+J[2]-J[3]+J[4]+J[5]-J[6]-J[7]-J[8]+J[9]-J[10]-J[11]+J[12]+J[13]-J[14]+J[15]+
    J[16]-J[17]-J[18]+J[19]+J[20]-J[21]-J[22]-J[23]+J[24]+J[25]-J[26]-J[27], +H[0]-H[1]+H[2]+H[3]-H[4]+H[5]-H[6]+
    H[7]-J[0]+J[1]+J[2]-J[3]+J[4]-J[5]+J[6]-J[7]-J[8]+J[9]-J[10]+J[11]-J[12]+J[13]-J[14]+J[15]-J[16]+J[17]-J[18]+
    J[19]-J[20]+J[21]-J[22]+J[23]-J[24]-J[25]+J[26]-J[27], +H[0]-H[1]+H[2]+H[3]-H[4]+H[5]-H[6]-H[7]-J[0]+
    J[1]+J[2]-J[3]+J[4]-J[5]-J[6]-J[7]-J[8]+J[9]-J[10]+J[11]+J[12]+J[13]-J[14]+J[15]-J[16]-J[17]-J[18]+J[19]-J[20]-J[21]-J[22]+
    J[23]+J[24]-J[25]-J[26]+J[27], +H[0]-H[1]+H[2]+H[3]-H[4]-H[5]+H[6]+H[7]-J[0]+J[1]+J[2]-J[3]-J[4]+J[5]+
    J[6]-J[7]-J[8]+J[9]+J[10]-J[11]-J[12]+J[13]-J[14]-J[15]+J[16]+J[17]-J[18]-J[19]+J[20]+J[21]+J[22]-J[23]-J[24]-J[25]-J[26]+
    J[27], +H[0]-H[1]+H[2]+H[3]-H[4]-H[5]+H[6]-H[7]-J[0]+J[1]+J[2]-J[3]-J[4]+J[5]-J[6]-J[7]-J[8]+J[9]+J[10]-J[11]+
    J[12]+J[13]-J[14]-J[15]+J[16]-J[17]-J[18]-J[19]+J[20]-J[21]+J[22]-J[23]+J[24]-J[25]+J[26]-J[27], +H[0]-H[1]+
    H[2]+H[3]-H[4]-H[5]-H[6]+H[7]-J[0]+J[1]+J[2]-J[3]-J[4]-J[5]+J[6]-J[7]-J[8]+J[9]+J[10]+J[11]-J[12]+J[13]-J[14]-J[15]-J[16]+
    J[17]-J[18]-J[19]-J[20]+J[21]+J[22]+J[23]-J[24]+J[25]-J[26]-J[27], +H[0]-H[1]+H[2]+H[3]-H[4]-H[5]-H[6]-H[7]-J[0]+
    J[1]+J[2]-J[3]-J[4]-J[5]-J[6]-J[7]-J[8]+J[9]+J[10]+J[11]+J[12]+J[13]-J[14]-J[15]-J[16]-J[17]-J[18]-J[19]-J[20]-J[21]+
    J[22]+J[23]+J[24]+J[25]+J[26]+J[27], +H[0]-H[1]+H[2]-H[3]+H[4]+H[5]+H[6]+H[7]-J[0]+J[1]-J[2]+J[3]+J[4]+
    J[5]+J[6]-J[7]+J[8]-J[9]-J[10]-J[11]-J[12]-J[13]+J[14]+J[15]+J[16]+J[17]-J[18]-J[19]-J[20]-J[21]+J[22]+
    J[23]+J[24]+J[25]+J[26]+J[27], +H[0]-H[1]+H[2]-H[3]+H[4]+H[5]+H[6]-H[7]-J[0]+J[1]-J[2]+J[3]+J[4]+J[5]-J[6]-J[7]+
    J[8]-J[9]-J[10]-J[11]+J[12]-J[13]+J[14]+J[15]+J[16]-J[17]-J[18]-J[19]-J[20]+J[21]+J[22]+J[23]-J[24]+
    J[25]-J[26]-J[27], +H[0]-H[1]+H[2]-H[3]+H[4]+H[5]-H[6]+H[7]-J[0]+J[1]-J[2]+J[3]+J[4]-J[5]+J[6]-J[7]+
    J[8]-J[9]-J[10]+J[11]-J[12]-J[13]+J[14]+J[15]-J[16]+J[17]-J[18]-J[19]+J[20]-J[21]+J[22]-J[23]+J[24]-J[25]+
    J[26]-J[27], +H[0]-H[1]+H[2]-H[3]+H[4]+H[5]-H[6]-H[7]-J[0]+J[1]-J[2]+J[3]+J[4]-J[5]-J[6]-J[7]+J[8]-J[9]-J[10]+
    J[11]+J[12]-J[13]+J[14]+J[15]-J[16]-J[17]-J[18]-J[19]+J[20]+J[21]+J[22]-J[23]-J[24]-J[25]-J[26]+J[27], +
    H[0]-H[1]+H[2]-H[3]+H[4]-H[5]+H[6]+H[7]-J[0]+J[1]-J[2]+J[3]-J[4]+J[5]+J[6]-J[7]+J[8]-J[9]+J[10]-J[11]-J[12]-J[13]+
    J[14]-J[15]+J[16]+J[17]-J[18]+J[19]-J[20]-J[21]-J[22]+J[23]+J[24]-J[25]-J[26]+J[27], +H[0]-H[1]+H[2]-H[3]+
    H[4]-H[5]+H[6]-H[7]-J[0]+J[1]-J[2]+J[3]-J[4]+J[5]-J[6]-J[7]+J[8]-J[9]+J[10]-J[11]+J[12]-J[13]+J[14]-J[15]+
    J[16]-J[17]-J[18]+J[19]-J[20]+J[21]-J[22]+J[23]-J[24]-J[25]+J[26]-J[27], +H[0]-H[1]+H[2]-H[3]+H[4]-H[5]-H[6]+
    H[7]-J[0]+J[1]-J[2]+J[3]-J[4]-J[5]+J[6]-J[7]+J[8]-J[9]+J[10]+J[11]-J[12]-J[13]+J[14]-J[15]-J[16]+J[17]-J[18]+
    J[19]+J[20]-J[21]-J[22]-J[23]+J[24]+J[25]-J[26]-J[27], +H[0]-H[1]+H[2]-H[3]+H[4]-H[5]-H[6]-H[7]-J[0]+
    J[1]-J[2]+J[3]-J[4]-J[5]-J[6]-J[7]+J[8]-J[9]+J[10]+J[11]+J[12]-J[13]+J[14]-J[15]-J[16]-J[17]-J[18]+J[19]+
    J[20]+J[21]-J[22]-J[23]-J[24]+J[25]+J[26]+J[27], +H[0]-H[1]+H[2]-H[3]-H[4]+H[5]+H[6]+H[7]-J[0]+J[1]-J[2]-J[3]+
    J[4]+J[5]+J[6]-J[7]+J[8]+J[9]-J[10]-J[11]-J[12]-J[13]-J[14]+J[15]+J[16]+J[17]+J[18]-J[19]-J[20]-J[21]-J[22]-J[23]-J[24]+
    J[25]+J[26]+J[27], +H[0]-H[1]+H[2]-H[3]-H[4]+H[5]+H[6]-H[7]-J[0]+J[1]-J[2]-J[3]+J[4]+J[5]-J[6]-J[7]+
    J[8]+J[9]-J[10]-J[11]+J[12]-J[13]-J[14]+J[15]+J[16]-J[17]+J[18]-J[19]-J[20]+J[21]-J[22]-J[23]+J[24]+
    J[25]-J[26]-J[27], +H[0]-H[1]+H[2]-H[3]-H[4]+H[5]-H[6]+H[7]-J[0]+J[1]-J[2]-J[3]+J[4]-J[5]+J[6]-J[7]+
    J[8]+J[9]-J[10]+J[11]-J[12]-J[13]-J[14]+J[15]-J[16]+J[17]+J[18]-J[19]+J[20]-J[21]-J[22]+J[23]-J[24]-J[25]+
    J[26]-J[27], +H[0]-H[1]+H[2]-H[3]-H[4]+H[5]-H[6]-H[7]-J[0]+J[1]-J[2]-J[3]+J[4]-J[5]-J[6]-J[7]+J[8]+J[9]-J[10]+
    J[11]+J[12]-J[13]-J[14]+J[15]-J[16]-J[17]+J[18]-J[19]+J[20]+J[21]-J[22]+J[23]+J[24]-J[25]-J[26]+J[27], +
    H[0]-H[1]+H[2]-H[3]-H[4]-H[5]+H[6]+H[7]-J[0]+J[1]-J[2]-J[3]-J[4]+J[5]+J[6]-J[7]+J[8]+J[9]+J[10]-J[11]-J[12]-J[13]-J[14]-J[15]+
    J[16]+J[17]+J[18]+J[19]-J[20]-J[21]+J[22]-J[23]-J[24]-J[25]-J[26]+J[27], +H[0]-H[1]+H[2]-H[3]-H[4]-H[5]+
    H[6]-H[7]-J[0]+J[1]-J[2]-J[3]-J[4]+J[5]-J[6]-J[7]+J[8]+J[9]+J[10]-J[11]+J[12]-J[13]-J[14]-J[15]+J[16]-J[17]+
    J[18]+J[19]-J[20]+J[21]+J[22]-J[23]+J[24]-J[25]+J[26]-J[27], +H[0]-H[1]+H[2]-H[3]-H[4]-H[5]-H[6]+H[7]-J[0]+
    J[1]-J[2]-J[3]-J[4]-J[5]+J[6]-J[7]+J[8]+J[9]+J[10]+J[11]-J[12]-J[13]-J[14]-J[15]-J[16]+J[17]+J[18]+J[19]+
    J[20]-J[21]+J[22]+J[23]-J[24]+J[25]-J[26]-J[27], +H[0]-H[1]+H[2]-H[3]-H[4]-H[5]-H[6]-H[7]-J[0]+J[1]-J[2]-J[3]-J[4]-J[5]-J[6]-J[7]+
    J[8]+J[9]+J[10]+J[11]+J[12]-J[13]-J[14]-J[15]-J[16]-J[17]+J[18]+J[19]+J[20]+J[21]+J[22]+J[23]+J[24]+
    J[25]+J[26]+J[27], +H[0]-H[1]-H[2]+H[3]+H[4]+H[5]+H[6]+H[7]-J[0]-J[1]+J[2]+J[3]+J[4]+J[5]+J[6]+J[7]-J[8]-J[9]-J[10]-J[11]-J[12]-J[13]-J[14]-J[15]-J[16]-J[17]+
    J[18]+J[19]+J[20]+J[21]+J[22]+J[23]+J[24]+J[25]+J[26]+J[27], +H[0]-H[1]-H[2]+H[3]+H[4]+H[5]+H[6]-H[7]-J[0]-J[1]+
    J[2]+J[3]+J[4]+J[5]-J[6]+J[7]-J[8]-J[9]-J[10]-J[11]+J[12]-J[13]-J[14]-J[15]-J[16]+J[17]+J[18]+J[19]+
    J[20]-J[21]+J[22]+J[23]-J[24]+J[25]-J[26]-J[27], +H[0]-H[1]-H[2]+H[3]+H[4]+H[5]-H[6]+H[7]-J[0]-J[1]+
    J[2]+J[3]+J[4]-J[5]+J[6]+J[7]-J[8]-J[9]-J[10]+J[11]-J[12]-J[13]-J[14]-J[15]+J[16]-J[17]+J[18]+J[19]-J[20]+
    J[21]+J[22]-J[23]+J[24]-J[25]+J[26]-J[27], +H[0]-H[1]-H[2]+H[3]+H[4]+H[5]-H[6]-H[7]-J[0]-J[1]+J[2]+J[3]+
    J[4]-J[5]-J[6]+J[7]-J[8]-J[9]-J[10]+J[11]+J[12]-J[13]-J[14]-J[15]+J[16]+J[17]+J[18]+J[19]-J[20]-J[21]+
    J[22]-J[23]-J[24]-J[25]-J[26]+J[27], +H[0]-H[1]-H[2]+H[3]+H[4]-H[5]+H[6]+H[7]-J[0]-J[1]+J[2]+J[3]-J[4]+
    J[5]+J[6]+J[7]-J[8]-J[9]+J[10]-J[11]-J[12]-J[13]-J[14]+J[15]-J[16]-J[17]+J[18]-J[19]+J[20]+J[21]-J[22]+
    J[23]+J[24]-J[25]-J[26]+J[27], +H[0]-H[1]-H[2]+H[3]+H[4]-H[5]+H[6]-H[7]-J[0]-J[1]+J[2]+J[3]-J[4]+J[5]-J[6]+
    J[7]-J[8]-J[9]+J[10]-J[11]+J[12]-J[13]-J[14]+J[15]-J[16]+J[17]+J[18]-J[19]+J[20]-J[21]-J[22]+J[23]-J[24]-J[25]+
    J[26]-J[27], +H[0]-H[1]-H[2]+H[3]+H[4]-H[5]-H[6]+H[7]-J[0]-J[1]+J[2]+J[3]-J[4]-J[5]+J[6]+J[7]-J[8]-J[9]+
    J[10]+J[11]-J[12]-J[13]-J[14]+J[15]+J[16]-J[17]+J[18]-J[19]-J[20]+J[21]-J[22]-J[23]+J[24]+J[25]-J[26]-J[27], +
    H[0]-H[1]-H[2]+H[3]+H[4]-H[5]-H[6]-H[7]-J[0]-J[1]+J[2]+J[3]-J[4]-J[5]-J[6]+J[7]-J[8]-J[9]+J[10]+J[11]+
    J[12]-J[13]-J[14]+J[15]+J[16]+J[17]+J[18]-J[19]-J[20]-J[21]-J[22]-J[23]-J[24]+J[25]+J[26]+J[27], +H[0]-H[1]-H[2]+
    H[3]-H[4]+H[5]+H[6]+H[7]-J[0]-J[1]+J[2]-J[3]+J[4]+J[5]+J[6]+J[7]-J[8]+J[9]-J[10]-J[11]-J[12]-J[13]+J[14]-J[15]-J[16]-J[17]-J[18]+
    J[19]+J[20]+J[21]-J[22]-J[23]-J[24]+J[25]+J[26]+J[27], +H[0]-H[1]-H[2]+H[3]-H[4]+H[5]+H[6]-H[7]-J[0]-J[1]+
    J[2]-J[3]+J[4]+J[5]-J[6]+J[7]-J[8]+J[9]-J[10]-J[11]+J[12]-J[13]+J[14]-J[15]-J[16]+J[17]-J[18]+J[19]+
    J[20]-J[21]-J[22]-J[23]+J[24]+J[25]-J[26]-J[27], +H[0]-H[1]-H[2]+H[3]-H[4]+H[5]-H[6]+H[7]-J[0]-J[1]+
    J[2]-J[3]+J[4]-J[5]+J[6]+J[7]-J[8]+J[9]-J[10]+J[11]-J[12]-J[13]+J[14]-J[15]+J[16]-J[17]-J[18]+J[19]-J[20]+
    J[21]-J[22]+J[23]-J[24]-J[25]+J[26]-J[27], +H[0]-H[1]-H[2]+H[3]-H[4]+H[5]-H[6]-H[7]-J[0]-J[1]+J[2]-J[3]+
    J[4]-J[5]-J[6]+J[7]-J[8]+J[9]-J[10]+J[11]+J[12]-J[13]+J[14]-J[15]+J[16]+J[17]-J[18]+J[19]-J[20]-J[21]-J[22]+
    J[23]+J[24]-J[25]-J[26]+J[27], +H[0]-H[1]-H[2]+H[3]-H[4]-H[5]+H[6]+H[7]-J[0]-J[1]+J[2]-J[3]-J[4]+J[5]+
    J[6]+J[7]-J[8]+J[9]+J[10]-J[11]-J[12]-J[13]+J[14]+J[15]-J[16]-J[17]-J[18]-J[19]+J[20]+J[21]+J[22]-J[23]-J[24]-J[25]-J[26]+
    J[27], +H[0]-H[1]-H[2]+H[3]-H[4]-H[5]+H[6]-H[7]-J[0]-J[1]+J[2]-J[3]-J[4]+J[5]-J[6]+J[7]-J[8]+J[9]+J[10]-J[11]+
    J[12]-J[13]+J[14]+J[15]-J[16]+J[17]-J[18]-J[19]+J[20]-J[21]+J[22]-J[23]+J[24]-J[25]+J[26]-J[27], +H[0]-H[1]-H[2]+
    H[3]-H[4]-H[5]-H[6]+H[7]-J[0]-J[1]+J[2]-J[3]-J[4]-J[5]+J[6]+J[7]-J[8]+J[9]+J[10]+J[11]-J[12]-J[13]+J[14]+
    J[15]+J[16]-J[17]-J[18]-J[19]-J[20]+J[21]+J[22]+J[23]-J[24]+J[25]-J[26]-J[27], +H[0]-H[1]-H[2]+H[3]-H[4]-H[5]-H[6]-H[7]-J[0]-J[1]+
    J[2]-J[3]-J[4]-J[5]-J[6]+J[7]-J[8]+J[9]+J[10]+J[11]+J[12]-J[13]+J[14]+J[15]+J[16]+J[17]-J[18]-J[19]-J[20]-J[21]+
    J[22]+J[23]+J[24]+J[25]+J[26]+J[27], +H[0]-H[1]-H[2]-H[3]+H[4]+H[5]+H[6]+H[7]-J[0]-J[1]-J[2]+J[3]+J[4]+
    J[5]+J[6]+J[7]+J[8]-J[9]-J[10]-J[11]-J[12]+J[13]-J[14]-J[15]-J[16]-J[17]-J[18]-J[19]-J[20]-J[21]+J[22]+
    J[23]+J[24]+J[25]+J[26]+J[27], +H[0]-H[1]-H[2]-H[3]+H[4]+H[5]+H[6]-H[7]-J[0]-J[1]-J[2]+J[3]+J[4]+J[5]-J[6]+
    J[7]+J[8]-J[9]-J[10]-J[11]+J[12]+J[13]-J[14]-J[15]-J[16]+J[17]-J[18]-J[19]-J[20]+J[21]+J[22]+J[23]-J[24]+
    J[25]-J[26]-J[27], +H[0]-H[1]-H[2]-H[3]+H[4]+H[5]-H[6]+H[7]-J[0]-J[1]-J[2]+J[3]+J[4]-J[5]+J[6]+J[7]+
    J[8]-J[9]-J[10]+J[11]-J[12]+J[13]-J[14]-J[15]+J[16]-J[17]-J[18]-J[19]+J[20]-J[21]+J[22]-J[23]+J[24]-J[25]+
    J[26]-J[27], +H[0]-H[1]-H[2]-H[3]+H[4]+H[5]-H[6]-H[7]-J[0]-J[1]-J[2]+J[3]+J[4]-J[5]-J[6]+J[7]+J[8]-J[9]-J[10]+
    J[11]+J[12]+J[13]-J[14]-J[15]+J[16]+J[17]-J[18]-J[19]+J[20]+J[21]+J[22]-J[23]-J[24]-J[25]-J[26]+J[27], +
    H[0]-H[1]-H[2]-H[3]+H[4]-H[5]+H[6]+H[7]-J[0]-J[1]-J[2]+J[3]-J[4]+J[5]+J[6]+J[7]+J[8]-J[9]+J[10]-J[11]-J[12]+
    J[13]-J[14]+J[15]-J[16]-J[17]-J[18]+J[19]-J[20]-J[21]-J[22]+J[23]+J[24]-J[25]-J[26]+J[27], +H[0]-H[1]-H[2]-H[3]+
    H[4]-H[5]+H[6]-H[7]-J[0]-J[1]-J[2]+J[3]-J[4]+J[5]-J[6]+J[7]+J[8]-J[9]+J[10]-J[11]+J[12]+J[13]-J[14]+
    J[15]-J[16]+J[17]-J[18]+J[19]-J[20]+J[21]-J[22]+J[23]-J[24]-J[25]+J[26]-J[27], +H[0]-H[1]-H[2]-H[3]+
    H[4]-H[5]-H[6]+H[7]-J[0]-J[1]-J[2]+J[3]-J[4]-J[5]+J[6]+J[7]+J[8]-J[9]+J[10]+J[11]-J[12]+J[13]-J[14]+
    J[15]+J[16]-J[17]-J[18]+J[19]+J[20]-J[21]-J[22]-J[23]+J[24]+J[25]-J[26]-J[27], +H[0]-H[1]-H[2]-H[3]+
    H[4]-H[5]-H[6]-H[7]-J[0]-J[1]-J[2]+J[3]-J[4]-J[5]-J[6]+J[7]+J[8]-J[9]+J[10]+J[11]+J[12]+J[13]-J[14]+
    J[15]+J[16]+J[17]-J[18]+J[19]+J[20]+J[21]-J[22]-J[23]-J[24]+J[25]+J[26]+J[27], +H[0]-H[1]-H[2]-H[3]-H[4]+
    H[5]+H[6]+H[7]-J[0]-J[1]-J[2]-J[3]+J[4]+J[5]+J[6]+J[7]+J[8]+J[9]-J[10]-J[11]-J[12]+J[13]+J[14]-J[15]-J[16]-J[17]+
    J[18]-J[19]-J[20]-J[21]-J[22]-J[23]-J[24]+J[25]+J[26]+J[27], +H[0]-H[1]-H[2]-H[3]-H[4]+H[5]+H[6]-H[7]-J[0]-J[1]-J[2]-J[3]+
    J[4]+J[5]-J[6]+J[7]+J[8]+J[9]-J[10]-J[11]+J[12]+J[13]+J[14]-J[15]-J[16]+J[17]+J[18]-J[19]-J[20]+J[21]-J[22]-J[23]+
    J[24]+J[25]-J[26]-J[27], +H[0]-H[1]-H[2]-H[3]-H[4]+H[5]-H[6]+H[7]-J[0]-J[1]-J[2]-J[3]+J[4]-J[5]+J[6]+
    J[7]+J[8]+J[9]-J[10]+J[11]-J[12]+J[13]+J[14]-J[15]+J[16]-J[17]+J[18]-J[19]+J[20]-J[21]-J[22]+J[23]-J[24]-J[25]+
    J[26]-J[27], +H[0]-H[1]-H[2]-H[3]-H[4]+H[5]-H[6]-H[7]-J[0]-J[1]-J[2]-J[3]+J[4]-J[5]-J[6]+J[7]+J[8]+J[9]-J[10]+
    J[11]+J[12]+J[13]+J[14]-J[15]+J[16]+J[17]+J[18]-J[19]+J[20]+J[21]-J[22]+J[23]+J[24]-J[25]-J[26]+J[27], +
    H[0]-H[1]-H[2]-H[3]-H[4]-H[5]+H[6]+H[7]-J[0]-J[1]-J[2]-J[3]-J[4]+J[5]+J[6]+J[7]+J[8]+J[9]+J[10]-J[11]-J[12]+
    J[13]+J[14]+J[15]-J[16]-J[17]+J[18]+J[19]-J[20]-J[21]+J[22]-J[23]-J[24]-J[25]-J[26]+J[27], +H[0]-H[1]-H[2]-H[3]-H[4]-H[5]+
    H[6]-H[7]-J[0]-J[1]-J[2]-J[3]-J[4]+J[5]-J[6]+J[7]+J[8]+J[9]+J[10]-J[11]+J[12]+J[13]+J[14]+J[15]-J[16]+
    J[17]+J[18]+J[19]-J[20]+J[21]+J[22]-J[23]+J[24]-J[25]+J[26]-J[27], +H[0]-H[1]-H[2]-H[3]-H[4]-H[5]-H[6]+
    H[7]-J[0]-J[1]-J[2]-J[3]-J[4]-J[5]+J[6]+J[7]+J[8]+J[9]+J[10]+J[11]-J[12]+J[13]+J[14]+J[15]+J[16]-J[17]+
    J[18]+J[19]+J[20]-J[21]+J[22]+J[23]-J[24]+J[25]-J[26]-J[27], +H[0]-H[1]-H[2]-H[3]-H[4]-H[5]-H[6]-H[7]-J[0]-J[1]-J[2]-J[3]-J[4]-J[5]-J[6]+
    J[7]+J[8]+J[9]+J[10]+J[11]+J[12]+J[13]+J[14]+J[15]+J[16]+J[17]+J[18]+J[19]+J[20]+J[21]+J[22]+J[23]+J[24]+
    J[25]+J[26]+J[27], -H[0]+H[1]+H[2]+H[3]+H[4]+H[5]+H[6]+H[7]-J[0]-J[1]-J[2]-J[3]-J[4]-J[5]-J[6]+J[7]+
    J[8]+J[9]+J[10]+J[11]+J[12]+J[13]+J[14]+J[15]+J[16]+J[17]+J[18]+J[19]+J[20]+J[21]+J[22]+J[23]+J[24]+
    J[25]+J[26]+J[27], -H[0]+H[1]+H[2]+H[3]+H[4]+H[5]+H[6]-H[7]-J[0]-J[1]-J[2]-J[3]-J[4]-J[5]+J[6]+J[7]+
    J[8]+J[9]+J[10]+J[11]-J[12]+J[13]+J[14]+J[15]+J[16]-J[17]+J[18]+J[19]+J[20]-J[21]+J[22]+J[23]-J[24]+
    J[25]-J[26]-J[27], -H[0]+H[1]+H[2]+H[3]+H[4]+H[5]-H[6]+H[7]-J[0]-J[1]-J[2]-J[3]-J[4]+J[5]-J[6]+J[7]+
    J[8]+J[9]+J[10]-J[11]+J[12]+J[13]+J[14]+J[15]-J[16]+J[17]+J[18]+J[19]-J[20]+J[21]+J[22]-J[23]+J[24]-J[25]+
    J[26]-J[27], -H[0]+H[1]+H[2]+H[3]+H[4]+H[5]-H[6]-H[7]-J[0]-J[1]-J[2]-J[3]-J[4]+J[5]+J[6]+J[7]+J[8]+J[9]+
    J[10]-J[11]-J[12]+J[13]+J[14]+J[15]-J[16]-J[17]+J[18]+J[19]-J[20]-J[21]+J[22]-J[23]-J[24]-J[25]-J[26]+
    J[27], -H[0]+H[1]+H[2]+H[3]+H[4]-H[5]+H[6]+H[7]-J[0]-J[1]-J[2]-J[3]+J[4]-J[5]-J[6]+J[7]+J[8]+J[9]-J[10]+
    J[11]+J[12]+J[13]+J[14]-J[15]+J[16]+J[17]+J[18]-J[19]+J[20]+J[21]-J[22]+J[23]+J[24]-J[25]-J[26]+J[27], -H[0]+
    H[1]+H[2]+H[3]+H[4]-H[5]+H[6]-H[7]-J[0]-J[1]-J[2]-J[3]+J[4]-J[5]+J[6]+J[7]+J[8]+J[9]-J[10]+J[11]-J[12]+
    J[13]+J[14]-J[15]+J[16]-J[17]+J[18]-J[19]+J[20]-J[21]-J[22]+J[23]-J[24]-J[25]+J[26]-J[27], -H[0]+H[1]+
    H[2]+H[3]+H[4]-H[5]-H[6]+H[7]-J[0]-J[1]-J[2]-J[3]+J[4]+J[5]-J[6]+J[7]+J[8]+J[9]-J[10]-J[11]+J[12]+J[13]+
    J[14]-J[15]-J[16]+J[17]+J[18]-J[19]-J[20]+J[21]-J[22]-J[23]+J[24]+J[25]-J[26]-J[27], -H[0]+H[1]+H[2]+
    H[3]+H[4]-H[5]-H[6]-H[7]-J[0]-J[1]-J[2]-J[3]+J[4]+J[5]+J[6]+J[7]+J[8]+J[9]-J[10]-J[11]-J[12]+J[13]+J[14]-J[15]-J[16]-J[17]+
    J[18]-J[19]-J[20]-J[21]-J[22]-J[23]-J[24]+J[25]+J[26]+J[27], -H[0]+H[1]+H[2]+H[3]-H[4]+H[5]+H[6]+H[7]-J[0]-J[1]-J[2]+
    J[3]-J[4]-J[5]-J[6]+J[7]+J[8]-J[9]+J[10]+J[11]+J[12]+J[13]-J[14]+J[15]+J[16]+J[17]-J[18]+J[19]+J[20]+
    J[21]-J[22]-J[23]-J[24]+J[25]+J[26]+J[27], -H[0]+H[1]+H[2]+H[3]-H[4]+H[5]+H[6]-H[7]-J[0]-J[1]-J[2]+J[3]-J[4]-J[5]+
    J[6]+J[7]+J[8]-J[9]+J[10]+J[11]-J[12]+J[13]-J[14]+J[15]+J[16]-J[17]-J[18]+J[19]+J[20]-J[21]-J[22]-J[23]+
    J[24]+J[25]-J[26]-J[27], -H[0]+H[1]+H[2]+H[3]-H[4]+H[5]-H[6]+H[7]-J[0]-J[1]-J[2]+J[3]-J[4]+J[5]-J[6]+
    J[7]+J[8]-J[9]+J[10]-J[11]+J[12]+J[13]-J[14]+J[15]-J[16]+J[17]-J[18]+J[19]-J[20]+J[21]-J[22]+J[23]-J[24]-J[25]+
    J[26]-J[27], -H[0]+H[1]+H[2]+H[3]-H[4]+H[5]-H[6]-H[7]-J[0]-J[1]-J[2]+J[3]-J[4]+J[5]+J[6]+J[7]+J[8]-J[9]+
    J[10]-J[11]-J[12]+J[13]-J[14]+J[15]-J[16]-J[17]-J[18]+J[19]-J[20]-J[21]-J[22]+J[23]+J[24]-J[25]-J[26]+
    J[27], -H[0]+H[1]+H[2]+H[3]-H[4]-H[5]+H[6]+H[7]-J[0]-J[1]-J[2]+J[3]+J[4]-J[5]-J[6]+J[7]+J[8]-J[9]-J[10]+
    J[11]+J[12]+J[13]-J[14]-J[15]+J[16]+J[17]-J[18]-J[19]+J[20]+J[21]+J[22]-J[23]-J[24]-J[25]-J[26]+J[27], -H[0]+
    H[1]+H[2]+H[3]-H[4]-H[5]+H[6]-H[7]-J[0]-J[1]-J[2]+J[3]+J[4]-J[5]+J[6]+J[7]+J[8]-J[9]-J[10]+J[11]-J[12]+
    J[13]-J[14]-J[15]+J[16]-J[17]-J[18]-J[19]+J[20]-J[21]+J[22]-J[23]+J[24]-J[25]+J[26]-J[27], -H[0]+H[1]+
    H[2]+H[3]-H[4]-H[5]-H[6]+H[7]-J[0]-J[1]-J[2]+J[3]+J[4]+J[5]-J[6]+J[7]+J[8]-J[9]-J[10]-J[11]+J[12]+J[13]-J[14]-J[15]-J[16]+
    J[17]-J[18]-J[19]-J[20]+J[21]+J[22]+J[23]-J[24]+J[25]-J[26]-J[27], -H[0]+H[1]+H[2]+H[3]-H[4]-H[5]-H[6]-H[7]-J[0]-J[1]-J[2]+
    J[3]+J[4]+J[5]+J[6]+J[7]+J[8]-J[9]-J[10]-J[11]-J[12]+J[13]-J[14]-J[15]-J[16]-J[17]-J[18]-J[19]-J[20]-J[21]+
    J[22]+J[23]+J[24]+J[25]+J[26]+J[27], -H[0]+H[1]+H[2]-H[3]+H[4]+H[5]+H[6]+H[7]-J[0]-J[1]+J[2]-J[3]-J[4]-J[5]-J[6]+
    J[7]-J[8]+J[9]+J[10]+J[11]+J[12]-J[13]+J[14]+J[15]+J[16]+J[17]-J[18]-J[19]-J[20]-J[21]+J[22]+J[23]+J[24]+
    J[25]+J[26]+J[27], -H[0]+H[1]+H[2]-H[3]+H[4]+H[5]+H[6]-H[7]-J[0]-J[1]+J[2]-J[3]-J[4]-J[5]+J[6]+J[7]-J[8]+
    J[9]+J[10]+J[11]-J[12]-J[13]+J[14]+J[15]+J[16]-J[17]-J[18]-J[19]-J[20]+J[21]+J[22]+J[23]-J[24]+J[25]-J[26]-J[27], -H[0]+
    H[1]+H[2]-H[3]+H[4]+H[5]-H[6]+H[7]-J[0]-J[1]+J[2]-J[3]-J[4]+J[5]-J[6]+J[7]-J[8]+J[9]+J[10]-J[11]+J[12]-J[13]+
    J[14]+J[15]-J[16]+J[17]-J[18]-J[19]+J[20]-J[21]+J[22]-J[23]+J[24]-J[25]+J[26]-J[27], -H[0]+H[1]+H[2]-H[3]+
    H[4]+H[5]-H[6]-H[7]-J[0]-J[1]+J[2]-J[3]-J[4]+J[5]+J[6]+J[7]-J[8]+J[9]+J[10]-J[11]-J[12]-J[13]+J[14]+
    J[15]-J[16]-J[17]-J[18]-J[19]+J[20]+J[21]+J[22]-J[23]-J[24]-J[25]-J[26]+J[27], -H[0]+H[1]+H[2]-H[3]+
    H[4]-H[5]+H[6]+H[7]-J[0]-J[1]+J[2]-J[3]+J[4]-J[5]-J[6]+J[7]-J[8]+J[9]-J[10]+J[11]+J[12]-J[13]+J[14]-J[15]+
    J[16]+J[17]-J[18]+J[19]-J[20]-J[21]-J[22]+J[23]+J[24]-J[25]-J[26]+J[27], -H[0]+H[1]+H[2]-H[3]+H[4]-H[5]+
    H[6]-H[7]-J[0]-J[1]+J[2]-J[3]+J[4]-J[5]+J[6]+J[7]-J[8]+J[9]-J[10]+J[11]-J[12]-J[13]+J[14]-J[15]+J[16]-J[17]-J[18]+
    J[19]-J[20]+J[21]-J[22]+J[23]-J[24]-J[25]+J[26]-J[27], -H[0]+H[1]+H[2]-H[3]+H[4]-H[5]-H[6]+H[7]-J[0]-J[1]+
    J[2]-J[3]+J[4]+J[5]-J[6]+J[7]-J[8]+J[9]-J[10]-J[11]+J[12]-J[13]+J[14]-J[15]-J[16]+J[17]-J[18]+J[19]+
    J[20]-J[21]-J[22]-J[23]+J[24]+J[25]-J[26]-J[27], -H[0]+H[1]+H[2]-H[3]+H[4]-H[5]-H[6]-H[7]-J[0]-J[1]+
    J[2]-J[3]+J[4]+J[5]+J[6]+J[7]-J[8]+J[9]-J[10]-J[11]-J[12]-J[13]+J[14]-J[15]-J[16]-J[17]-J[18]+J[19]+
    J[20]+J[21]-J[22]-J[23]-J[24]+J[25]+J[26]+J[27], -H[0]+H[1]+H[2]-H[3]-H[4]+H[5]+H[6]+H[7]-J[0]-J[1]+
    J[2]+J[3]-J[4]-J[5]-J[6]+J[7]-J[8]-J[9]+J[10]+J[11]+J[12]-J[13]-J[14]+J[15]+J[16]+J[17]+J[18]-J[19]-J[20]-J[21]-J[22]-J[23]-J[24]+
    J[25]+J[26]+J[27], -H[0]+H[1]+H[2]-H[3]-H[4]+H[5]+H[6]-H[7]-J[0]-J[1]+J[2]+J[3]-J[4]-J[5]+J[6]+J[7]-J[8]-J[9]+
    J[10]+J[11]-J[12]-J[13]-J[14]+J[15]+J[16]-J[17]+J[18]-J[19]-J[20]+J[21]-J[22]-J[23]+J[24]+J[25]-J[26]-J[27], -H[0]+
    H[1]+H[2]-H[3]-H[4]+H[5]-H[6]+H[7]-J[0]-J[1]+J[2]+J[3]-J[4]+J[5]-J[6]+J[7]-J[8]-J[9]+J[10]-J[11]+J[12]-J[13]-J[14]+
    J[15]-J[16]+J[17]+J[18]-J[19]+J[20]-J[21]-J[22]+J[23]-J[24]-J[25]+J[26]-J[27], -H[0]+H[1]+H[2]-H[3]-H[4]+
    H[5]-H[6]-H[7]-J[0]-J[1]+J[2]+J[3]-J[4]+J[5]+J[6]+J[7]-J[8]-J[9]+J[10]-J[11]-J[12]-J[13]-J[14]+J[15]-J[16]-J[17]+
    J[18]-J[19]+J[20]+J[21]-J[22]+J[23]+J[24]-J[25]-J[26]+J[27], -H[0]+H[1]+H[2]-H[3]-H[4]-H[5]+H[6]+H[7]-J[0]-J[1]+
    J[2]+J[3]+J[4]-J[5]-J[6]+J[7]-J[8]-J[9]-J[10]+J[11]+J[12]-J[13]-J[14]-J[15]+J[16]+J[17]+J[18]+J[19]-J[20]-J[21]+
    J[22]-J[23]-J[24]-J[25]-J[26]+J[27], -H[0]+H[1]+H[2]-H[3]-H[4]-H[5]+H[6]-H[7]-J[0]-J[1]+J[2]+J[3]+J[4]-J[5]+
    J[6]+J[7]-J[8]-J[9]-J[10]+J[11]-J[12]-J[13]-J[14]-J[15]+J[16]-J[17]+J[18]+J[19]-J[20]+J[21]+J[22]-J[23]+
    J[24]-J[25]+J[26]-J[27], -H[0]+H[1]+H[2]-H[3]-H[4]-H[5]-H[6]+H[7]-J[0]-J[1]+J[2]+J[3]+J[4]+J[5]-J[6]+
    J[7]-J[8]-J[9]-J[10]-J[11]+J[12]-J[13]-J[14]-J[15]-J[16]+J[17]+J[18]+J[19]+J[20]-J[21]+J[22]+J[23]-J[24]+
    J[25]-J[26]-J[27], -H[0]+H[1]+H[2]-H[3]-H[4]-H[5]-H[6]-H[7]-J[0]-J[1]+J[2]+J[3]+J[4]+J[5]+J[6]+J[7]-J[8]-J[9]-J[10]-J[11]-J[12]-J[13]-J[14]-J[15]-J[16]-J[17]+
    J[18]+J[19]+J[20]+J[21]+J[22]+J[23]+J[24]+J[25]+J[26]+J[27], -H[0]+H[1]-H[2]+H[3]+H[4]+H[5]+H[6]+H[7]-J[0]+
    J[1]-J[2]-J[3]-J[4]-J[5]-J[6]-J[7]+J[8]+J[9]+J[10]+J[11]+J[12]-J[13]-J[14]-J[15]-J[16]-J[17]+J[18]+J[19]+
    J[20]+J[21]+J[22]+J[23]+J[24]+J[25]+J[26]+J[27], -H[0]+H[1]-H[2]+H[3]+H[4]+H[5]+H[6]-H[7]-J[0]+J[1]-J[2]-J[3]-J[4]-J[5]+
    J[6]-J[7]+J[8]+J[9]+J[10]+J[11]-J[12]-J[13]-J[14]-J[15]-J[16]+J[17]+J[18]+J[19]+J[20]-J[21]+J[22]+J[23]-J[24]+
    J[25]-J[26]-J[27], -H[0]+H[1]-H[2]+H[3]+H[4]+H[5]-H[6]+H[7]-J[0]+J[1]-J[2]-J[3]-J[4]+J[5]-J[6]-J[7]+
    J[8]+J[9]+J[10]-J[11]+J[12]-J[13]-J[14]-J[15]+J[16]-J[17]+J[18]+J[19]-J[20]+J[21]+J[22]-J[23]+J[24]-J[25]+
    J[26]-J[27], -H[0]+H[1]-H[2]+H[3]+H[4]+H[5]-H[6]-H[7]-J[0]+J[1]-J[2]-J[3]-J[4]+J[5]+J[6]-J[7]+J[8]+J[9]+
    J[10]-J[11]-J[12]-J[13]-J[14]-J[15]+J[16]+J[17]+J[18]+J[19]-J[20]-J[21]+J[22]-J[23]-J[24]-J[25]-J[26]+
    J[27], -H[0]+H[1]-H[2]+H[3]+H[4]-H[5]+H[6]+H[7]-J[0]+J[1]-J[2]-J[3]+J[4]-J[5]-J[6]-J[7]+J[8]+J[9]-J[10]+
    J[11]+J[12]-J[13]-J[14]+J[15]-J[16]-J[17]+J[18]-J[19]+J[20]+J[21]-J[22]+J[23]+J[24]-J[25]-J[26]+J[27], -H[0]+
    H[1]-H[2]+H[3]+H[4]-H[5]+H[6]-H[7]-J[0]+J[1]-J[2]-J[3]+J[4]-J[5]+J[6]-J[7]+J[8]+J[9]-J[10]+J[11]-J[12]-J[13]-J[14]+
    J[15]-J[16]+J[17]+J[18]-J[19]+J[20]-J[21]-J[22]+J[23]-J[24]-J[25]+J[26]-J[27], -H[0]+H[1]-H[2]+H[3]+
    H[4]-H[5]-H[6]+H[7]-J[0]+J[1]-J[2]-J[3]+J[4]+J[5]-J[6]-J[7]+J[8]+J[9]-J[10]-J[11]+J[12]-J[13]-J[14]+
    J[15]+J[16]-J[17]+J[18]-J[19]-J[20]+J[21]-J[22]-J[23]+J[24]+J[25]-J[26]-J[27], -H[0]+H[1]-H[2]+H[3]+
    H[4]-H[5]-H[6]-H[7]-J[0]+J[1]-J[2]-J[3]+J[4]+J[5]+J[6]-J[7]+J[8]+J[9]-J[10]-J[11]-J[12]-J[13]-J[14]+
    J[15]+J[16]+J[17]+J[18]-J[19]-J[20]-J[21]-J[22]-J[23]-J[24]+J[25]+J[26]+J[27], -H[0]+H[1]-H[2]+H[3]-H[4]+
    H[5]+H[6]+H[7]-J[0]+J[1]-J[2]+J[3]-J[4]-J[5]-J[6]-J[7]+J[8]-J[9]+J[10]+J[11]+J[12]-J[13]+J[14]-J[15]-J[16]-J[17]-J[18]+
    J[19]+J[20]+J[21]-J[22]-J[23]-J[24]+J[25]+J[26]+J[27], -H[0]+H[1]-H[2]+H[3]-H[4]+H[5]+H[6]-H[7]-J[0]+
    J[1]-J[2]+J[3]-J[4]-J[5]+J[6]-J[7]+J[8]-J[9]+J[10]+J[11]-J[12]-J[13]+J[14]-J[15]-J[16]+J[17]-J[18]+J[19]+
    J[20]-J[21]-J[22]-J[23]+J[24]+J[25]-J[26]-J[27], -H[0]+H[1]-H[2]+H[3]-H[4]+H[5]-H[6]+H[7]-J[0]+J[1]-J[2]+
    J[3]-J[4]+J[5]-J[6]-J[7]+J[8]-J[9]+J[10]-J[11]+J[12]-J[13]+J[14]-J[15]+J[16]-J[17]-J[18]+J[19]-J[20]+
    J[21]-J[22]+J[23]-J[24]-J[25]+J[26]-J[27], -H[0]+H[1]-H[2]+H[3]-H[4]+H[5]-H[6]-H[7]-J[0]+J[1]-J[2]+J[3]-J[4]+
    J[5]+J[6]-J[7]+J[8]-J[9]+J[10]-J[11]-J[12]-J[13]+J[14]-J[15]+J[16]+J[17]-J[18]+J[19]-J[20]-J[21]-J[22]+
    J[23]+J[24]-J[25]-J[26]+J[27], -H[0]+H[1]-H[2]+H[3]-H[4]-H[5]+H[6]+H[7]-J[0]+J[1]-J[2]+J[3]+J[4]-J[5]-J[6]-J[7]+
    J[8]-J[9]-J[10]+J[11]+J[12]-J[13]+J[14]+J[15]-J[16]-J[17]-J[18]-J[19]+J[20]+J[21]+J[22]-J[23]-J[24]-J[25]-J[26]+
    J[27], -H[0]+H[1]-H[2]+H[3]-H[4]-H[5]+H[6]-H[7]-J[0]+J[1]-J[2]+J[3]+J[4]-J[5]+J[6]-J[7]+J[8]-J[9]-J[10]+
    J[11]-J[12]-J[13]+J[14]+J[15]-J[16]+J[17]-J[18]-J[19]+J[20]-J[21]+J[22]-J[23]+J[24]-J[25]+J[26]-J[27], -H[0]+
    H[1]-H[2]+H[3]-H[4]-H[5]-H[6]+H[7]-J[0]+J[1]-J[2]+J[3]+J[4]+J[5]-J[6]-J[7]+J[8]-J[9]-J[10]-J[11]+J[12]-J[13]+
    J[14]+J[15]+J[16]-J[17]-J[18]-J[19]-J[20]+J[21]+J[22]+J[23]-J[24]+J[25]-J[26]-J[27], -H[0]+H[1]-H[2]+
    H[3]-H[4]-H[5]-H[6]-H[7]-J[0]+J[1]-J[2]+J[3]+J[4]+J[5]+J[6]-J[7]+J[8]-J[9]-J[10]-J[11]-J[12]-J[13]+J[14]+
    J[15]+J[16]+J[17]-J[18]-J[19]-J[20]-J[21]+J[22]+J[23]+J[24]+J[25]+J[26]+J[27], -H[0]+H[1]-H[2]-H[3]+
    H[4]+H[5]+H[6]+H[7]-J[0]+J[1]+J[2]-J[3]-J[4]-J[5]-J[6]-J[7]-J[8]+J[9]+J[10]+J[11]+J[12]+J[13]-J[14]-J[15]-J[16]-J[17]-J[18]-J[19]-J[20]-J[21]+
    J[22]+J[23]+J[24]+J[25]+J[26]+J[27], -H[0]+H[1]-H[2]-H[3]+H[4]+H[5]+H[6]-H[7]-J[0]+J[1]+J[2]-J[3]-J[4]-J[5]+
    J[6]-J[7]-J[8]+J[9]+J[10]+J[11]-J[12]+J[13]-J[14]-J[15]-J[16]+J[17]-J[18]-J[19]-J[20]+J[21]+J[22]+J[23]-J[24]+
    J[25]-J[26]-J[27], -H[0]+H[1]-H[2]-H[3]+H[4]+H[5]-H[6]+H[7]-J[0]+J[1]+J[2]-J[3]-J[4]+J[5]-J[6]-J[7]-J[8]+
    J[9]+J[10]-J[11]+J[12]+J[13]-J[14]-J[15]+J[16]-J[17]-J[18]-J[19]+J[20]-J[21]+J[22]-J[23]+J[24]-J[25]+
    J[26]-J[27], -H[0]+H[1]-H[2]-H[3]+H[4]+H[5]-H[6]-H[7]-J[0]+J[1]+J[2]-J[3]-J[4]+J[5]+J[6]-J[7]-J[8]+J[9]+
    J[10]-J[11]-J[12]+J[13]-J[14]-J[15]+J[16]+J[17]-J[18]-J[19]+J[20]+J[21]+J[22]-J[23]-J[24]-J[25]-J[26]+
    J[27], -H[0]+H[1]-H[2]-H[3]+H[4]-H[5]+H[6]+H[7]-J[0]+J[1]+J[2]-J[3]+J[4]-J[5]-J[6]-J[7]-J[8]+J[9]-J[10]+
    J[11]+J[12]+J[13]-J[14]+J[15]-J[16]-J[17]-J[18]+J[19]-J[20]-J[21]-J[22]+J[23]+J[24]-J[25]-J[26]+J[27], -H[0]+
    H[1]-H[2]-H[3]+H[4]-H[5]+H[6]-H[7]-J[0]+J[1]+J[2]-J[3]+J[4]-J[5]+J[6]-J[7]-J[8]+J[9]-J[10]+J[11]-J[12]+
    J[13]-J[14]+J[15]-J[16]+J[17]-J[18]+J[19]-J[20]+J[21]-J[22]+J[23]-J[24]-J[25]+J[26]-J[27], -H[0]+H[1]-H[2]-H[3]+
    H[4]-H[5]-H[6]+H[7]-J[0]+J[1]+J[2]-J[3]+J[4]+J[5]-J[6]-J[7]-J[8]+J[9]-J[10]-J[11]+J[12]+J[13]-J[14]+
    J[15]+J[16]-J[17]-J[18]+J[19]+J[20]-J[21]-J[22]-J[23]+J[24]+J[25]-J[26]-J[27], -H[0]+H[1]-H[2]-H[3]+
    H[4]-H[5]-H[6]-H[7]-J[0]+J[1]+J[2]-J[3]+J[4]+J[5]+J[6]-J[7]-J[8]+J[9]-J[10]-J[11]-J[12]+J[13]-J[14]+
    J[15]+J[16]+J[17]-J[18]+J[19]+J[20]+J[21]-J[22]-J[23]-J[24]+J[25]+J[26]+J[27], -H[0]+H[1]-H[2]-H[3]-H[4]+
    H[5]+H[6]+H[7]-J[0]+J[1]+J[2]+J[3]-J[4]-J[5]-J[6]-J[7]-J[8]-J[9]+J[10]+J[11]+J[12]+J[13]+J[14]-J[15]-J[16]-J[17]+
    J[18]-J[19]-J[20]-J[21]-J[22]-J[23]-J[24]+J[25]+J[26]+J[27], -H[0]+H[1]-H[2]-H[3]-H[4]+H[5]+H[6]-H[7]-J[0]+
    J[1]+J[2]+J[3]-J[4]-J[5]+J[6]-J[7]-J[8]-J[9]+J[10]+J[11]-J[12]+J[13]+J[14]-J[15]-J[16]+J[17]+J[18]-J[19]-J[20]+
    J[21]-J[22]-J[23]+J[24]+J[25]-J[26]-J[27], -H[0]+H[1]-H[2]-H[3]-H[4]+H[5]-H[6]+H[7]-J[0]+J[1]+J[2]+J[3]-J[4]+
    J[5]-J[6]-J[7]-J[8]-J[9]+J[10]-J[11]+J[12]+J[13]+J[14]-J[15]+J[16]-J[17]+J[18]-J[19]+J[20]-J[21]-J[22]+
    J[23]-J[24]-J[25]+J[26]-J[27], -H[0]+H[1]-H[2]-H[3]-H[4]+H[5]-H[6]-H[7]-J[0]+J[1]+J[2]+J[3]-J[4]+J[5]+
    J[6]-J[7]-J[8]-J[9]+J[10]-J[11]-J[12]+J[13]+J[14]-J[15]+J[16]+J[17]+J[18]-J[19]+J[20]+J[21]-J[22]+J[23]+
    J[24]-J[25]-J[26]+J[27], -H[0]+H[1]-H[2]-H[3]-H[4]-H[5]+H[6]+H[7]-J[0]+J[1]+J[2]+J[3]+J[4]-J[5]-J[6]-J[7]-J[8]-J[9]-J[10]+
    J[11]+J[12]+J[13]+J[14]+J[15]-J[16]-J[17]+J[18]+J[19]-J[20]-J[21]+J[22]-J[23]-J[24]-J[25]-J[26]+J[27], -H[0]+
    H[1]-H[2]-H[3]-H[4]-H[5]+H[6]-H[7]-J[0]+J[1]+J[2]+J[3]+J[4]-J[5]+J[6]-J[7]-J[8]-J[9]-J[10]+J[11]-J[12]+
    J[13]+J[14]+J[15]-J[16]+J[17]+J[18]+J[19]-J[20]+J[21]+J[22]-J[23]+J[24]-J[25]+J[26]-J[27], -H[0]+H[1]-H[2]-H[3]-H[4]-H[5]-H[6]+
    H[7]-J[0]+J[1]+J[2]+J[3]+J[4]+J[5]-J[6]-J[7]-J[8]-J[9]-J[10]-J[11]+J[12]+J[13]+J[14]+J[15]+J[16]-J[17]+
    J[18]+J[19]+J[20]-J[21]+J[22]+J[23]-J[24]+J[25]-J[26]-J[27], -H[0]+H[1]-H[2]-H[3]-H[4]-H[5]-H[6]-H[7]-J[0]+
    J[1]+J[2]+J[3]+J[4]+J[5]+J[6]-J[7]-J[8]-J[9]-J[10]-J[11]-J[12]+J[13]+J[14]+J[15]+J[16]+J[17]+J[18]+J[19]+
    J[20]+J[21]+J[22]+J[23]+J[24]+J[25]+J[26]+J[27], -H[0]-H[1]+H[2]+H[3]+H[4]+H[5]+H[6]+H[7]+J[0]-J[1]-J[2]-J[3]-J[4]-J[5]-J[6]-J[7]-J[8]-J[9]-J[10]-J[11]-J[12]+
    J[13]+J[14]+J[15]+J[16]+J[17]+J[18]+J[19]+J[20]+J[21]+J[22]+J[23]+J[24]+J[25]+J[26]+J[27], -H[0]-H[1]+
    H[2]+H[3]+H[4]+H[5]+H[6]-H[7]+J[0]-J[1]-J[2]-J[3]-J[4]-J[5]+J[6]-J[7]-J[8]-J[9]-J[10]-J[11]+J[12]+J[13]+
    J[14]+J[15]+J[16]-J[17]+J[18]+J[19]+J[20]-J[21]+J[22]+J[23]-J[24]+J[25]-J[26]-J[27], -H[0]-H[1]+H[2]+
    H[3]+H[4]+H[5]-H[6]+H[7]+J[0]-J[1]-J[2]-J[3]-J[4]+J[5]-J[6]-J[7]-J[8]-J[9]-J[10]+J[11]-J[12]+J[13]+J[14]+
    J[15]-J[16]+J[17]+J[18]+J[19]-J[20]+J[21]+J[22]-J[23]+J[24]-J[25]+J[26]-J[27], -H[0]-H[1]+H[2]+H[3]+
    H[4]+H[5]-H[6]-H[7]+J[0]-J[1]-J[2]-J[3]-J[4]+J[5]+J[6]-J[7]-J[8]-J[9]-J[10]+J[11]+J[12]+J[13]+J[14]+
    J[15]-J[16]-J[17]+J[18]+J[19]-J[20]-J[21]+J[22]-J[23]-J[24]-J[25]-J[26]+J[27], -H[0]-H[1]+H[2]+H[3]+
    H[4]-H[5]+H[6]+H[7]+J[0]-J[1]-J[2]-J[3]+J[4]-J[5]-J[6]-J[7]-J[8]-J[9]+J[10]-J[11]-J[12]+J[13]+J[14]-J[15]+
    J[16]+J[17]+J[18]-J[19]+J[20]+J[21]-J[22]+J[23]+J[24]-J[25]-J[26]+J[27], -H[0]-H[1]+H[2]+H[3]+H[4]-H[5]+
    H[6]-H[7]+J[0]-J[1]-J[2]-J[3]+J[4]-J[5]+J[6]-J[7]-J[8]-J[9]+J[10]-J[11]+J[12]+J[13]+J[14]-J[15]+J[16]-J[17]+
    J[18]-J[19]+J[20]-J[21]-J[22]+J[23]-J[24]-J[25]+J[26]-J[27], -H[0]-H[1]+H[2]+H[3]+H[4]-H[5]-H[6]+H[7]+
    J[0]-J[1]-J[2]-J[3]+J[4]+J[5]-J[6]-J[7]-J[8]-J[9]+J[10]+J[11]-J[12]+J[13]+J[14]-J[15]-J[16]+J[17]+J[18]-J[19]-J[20]+
    J[21]-J[22]-J[23]+J[24]+J[25]-J[26]-J[27], -H[0]-H[1]+H[2]+H[3]+H[4]-H[5]-H[6]-H[7]+J[0]-J[1]-J[2]-J[3]+
    J[4]+J[5]+J[6]-J[7]-J[8]-J[9]+J[10]+J[11]+J[12]+J[13]+J[14]-J[15]-J[16]-J[17]+J[18]-J[19]-J[20]-J[21]-J[22]-J[23]-J[24]+
    J[25]+J[26]+J[27], -H[0]-H[1]+H[2]+H[3]-H[4]+H[5]+H[6]+H[7]+J[0]-J[1]-J[2]+J[3]-J[4]-J[5]-J[6]-J[7]-J[8]+
    J[9]-J[10]-J[11]-J[12]+J[13]-J[14]+J[15]+J[16]+J[17]-J[18]+J[19]+J[20]+J[21]-J[22]-J[23]-J[24]+J[25]+
    J[26]+J[27], -H[0]-H[1]+H[2]+H[3]-H[4]+H[5]+H[6]-H[7]+J[0]-J[1]-J[2]+J[3]-J[4]-J[5]+J[6]-J[7]-J[8]+J[9]-J[10]-J[11]+
    J[12]+J[13]-J[14]+J[15]+J[16]-J[17]-J[18]+J[19]+J[20]-J[21]-J[22]-J[23]+J[24]+J[25]-J[26]-J[27], -H[0]-H[1]+
    H[2]+H[3]-H[4]+H[5]-H[6]+H[7]+J[0]-J[1]-J[2]+J[3]-J[4]+J[5]-J[6]-J[7]-J[8]+J[9]-J[10]+J[11]-J[12]+J[13]-J[14]+
    J[15]-J[16]+J[17]-J[18]+J[19]-J[20]+J[21]-J[22]+J[23]-J[24]-J[25]+J[26]-J[27], -H[0]-H[1]+H[2]+H[3]-H[4]+
    H[5]-H[6]-H[7]+J[0]-J[1]-J[2]+J[3]-J[4]+J[5]+J[6]-J[7]-J[8]+J[9]-J[10]+J[11]+J[12]+J[13]-J[14]+J[15]-J[16]-J[17]-J[18]+
    J[19]-J[20]-J[21]-J[22]+J[23]+J[24]-J[25]-J[26]+J[27], -H[0]-H[1]+H[2]+H[3]-H[4]-H[5]+H[6]+H[7]+J[0]-J[1]-J[2]+
    J[3]+J[4]-J[5]-J[6]-J[7]-J[8]+J[9]+J[10]-J[11]-J[12]+J[13]-J[14]-J[15]+J[16]+J[17]-J[18]-J[19]+J[20]+
    J[21]+J[22]-J[23]-J[24]-J[25]-J[26]+J[27], -H[0]-H[1]+H[2]+H[3]-H[4]-H[5]+H[6]-H[7]+J[0]-J[1]-J[2]+J[3]+
    J[4]-J[5]+J[6]-J[7]-J[8]+J[9]+J[10]-J[11]+J[12]+J[13]-J[14]-J[15]+J[16]-J[17]-J[18]-J[19]+J[20]-J[21]+
    J[22]-J[23]+J[24]-J[25]+J[26]-J[27], -H[0]-H[1]+H[2]+H[3]-H[4]-H[5]-H[6]+H[7]+J[0]-J[1]-J[2]+J[3]+J[4]+
    J[5]-J[6]-J[7]-J[8]+J[9]+J[10]+J[11]-J[12]+J[13]-J[14]-J[15]-J[16]+J[17]-J[18]-J[19]-J[20]+J[21]+J[22]+
    J[23]-J[24]+J[25]-J[26]-J[27], -H[0]-H[1]+H[2]+H[3]-H[4]-H[5]-H[6]-H[7]+J[0]-J[1]-J[2]+J[3]+J[4]+J[5]+
    J[6]-J[7]-J[8]+J[9]+J[10]+J[11]+J[12]+J[13]-J[14]-J[15]-J[16]-J[17]-J[18]-J[19]-J[20]-J[21]+J[22]+J[23]+
    J[24]+J[25]+J[26]+J[27], -H[0]-H[1]+H[2]-H[3]+H[4]+H[5]+H[6]+H[7]+J[0]-J[1]+J[2]-J[3]-J[4]-J[5]-J[6]-J[7]+
    J[8]-J[9]-J[10]-J[11]-J[12]-J[13]+J[14]+J[15]+J[16]+J[17]-J[18]-J[19]-J[20]-J[21]+J[22]+J[23]+J[24]+
    J[25]+J[26]+J[27], -H[0]-H[1]+H[2]-H[3]+H[4]+H[5]+H[6]-H[7]+J[0]-J[1]+J[2]-J[3]-J[4]-J[5]+J[6]-J[7]+
    J[8]-J[9]-J[10]-J[11]+J[12]-J[13]+J[14]+J[15]+J[16]-J[17]-J[18]-J[19]-J[20]+J[21]+J[22]+J[23]-J[24]+
    J[25]-J[26]-J[27], -H[0]-H[1]+H[2]-H[3]+H[4]+H[5]-H[6]+H[7]+J[0]-J[1]+J[2]-J[3]-J[4]+J[5]-J[6]-J[7]+
    J[8]-J[9]-J[10]+J[11]-J[12]-J[13]+J[14]+J[15]-J[16]+J[17]-J[18]-J[19]+J[20]-J[21]+J[22]-J[23]+J[24]-J[25]+
    J[26]-J[27], -H[0]-H[1]+H[2]-H[3]+H[4]+H[5]-H[6]-H[7]+J[0]-J[1]+J[2]-J[3]-J[4]+J[5]+J[6]-J[7]+J[8]-J[9]-J[10]+
    J[11]+J[12]-J[13]+J[14]+J[15]-J[16]-J[17]-J[18]-J[19]+J[20]+J[21]+J[22]-J[23]-J[24]-J[25]-J[26]+J[27], -H[0]-H[1]+
    H[2]-H[3]+H[4]-H[5]+H[6]+H[7]+J[0]-J[1]+J[2]-J[3]+J[4]-J[5]-J[6]-J[7]+J[8]-J[9]+J[10]-J[11]-J[12]-J[13]+
    J[14]-J[15]+J[16]+J[17]-J[18]+J[19]-J[20]-J[21]-J[22]+J[23]+J[24]-J[25]-J[26]+J[27], -H[0]-H[1]+H[2]-H[3]+
    H[4]-H[5]+H[6]-H[7]+J[0]-J[1]+J[2]-J[3]+J[4]-J[5]+J[6]-J[7]+J[8]-J[9]+J[10]-J[11]+J[12]-J[13]+J[14]-J[15]+
    J[16]-J[17]-J[18]+J[19]-J[20]+J[21]-J[22]+J[23]-J[24]-J[25]+J[26]-J[27], -H[0]-H[1]+H[2]-H[3]+H[4]-H[5]-H[6]+
    H[7]+J[0]-J[1]+J[2]-J[3]+J[4]+J[5]-J[6]-J[7]+J[8]-J[9]+J[10]+J[11]-J[12]-J[13]+J[14]-J[15]-J[16]+J[17]-J[18]+
    J[19]+J[20]-J[21]-J[22]-J[23]+J[24]+J[25]-J[26]-J[27], -H[0]-H[1]+H[2]-H[3]+H[4]-H[5]-H[6]-H[7]+J[0]-J[1]+
    J[2]-J[3]+J[4]+J[5]+J[6]-J[7]+J[8]-J[9]+J[10]+J[11]+J[12]-J[13]+J[14]-J[15]-J[16]-J[17]-J[18]+J[19]+
    J[20]+J[21]-J[22]-J[23]-J[24]+J[25]+J[26]+J[27], -H[0]-H[1]+H[2]-H[3]-H[4]+H[5]+H[6]+H[7]+J[0]-J[1]+
    J[2]+J[3]-J[4]-J[5]-J[6]-J[7]+J[8]+J[9]-J[10]-J[11]-J[12]-J[13]-J[14]+J[15]+J[16]+J[17]+J[18]-J[19]-J[20]-J[21]-J[22]-J[23]-J[24]+
    J[25]+J[26]+J[27], -H[0]-H[1]+H[2]-H[3]-H[4]+H[5]+H[6]-H[7]+J[0]-J[1]+J[2]+J[3]-J[4]-J[5]+J[6]-J[7]+
    J[8]+J[9]-J[10]-J[11]+J[12]-J[13]-J[14]+J[15]+J[16]-J[17]+J[18]-J[19]-J[20]+J[21]-J[22]-J[23]+J[24]+
    J[25]-J[26]-J[27], -H[0]-H[1]+H[2]-H[3]-H[4]+H[5]-H[6]+H[7]+J[0]-J[1]+J[2]+J[3]-J[4]+J[5]-J[6]-J[7]+
    J[8]+J[9]-J[10]+J[11]-J[12]-J[13]-J[14]+J[15]-J[16]+J[17]+J[18]-J[19]+J[20]-J[21]-J[22]+J[23]-J[24]-J[25]+
    J[26]-J[27], -H[0]-H[1]+H[2]-H[3]-H[4]+H[5]-H[6]-H[7]+J[0]-J[1]+J[2]+J[3]-J[4]+J[5]+J[6]-J[7]+J[8]+J[9]-J[10]+
    J[11]+J[12]-J[13]-J[14]+J[15]-J[16]-J[17]+J[18]-J[19]+J[20]+J[21]-J[22]+J[23]+J[24]-J[25]-J[26]+J[27], -H[0]-H[1]+
    H[2]-H[3]-H[4]-H[5]+H[6]+H[7]+J[0]-J[1]+J[2]+J[3]+J[4]-J[5]-J[6]-J[7]+J[8]+J[9]+J[10]-J[11]-J[12]-J[13]-J[14]-J[15]+
    J[16]+J[17]+J[18]+J[19]-J[20]-J[21]+J[22]-J[23]-J[24]-J[25]-J[26]+J[27], -H[0]-H[1]+H[2]-H[3]-H[4]-H[5]+
    H[6]-H[7]+J[0]-J[1]+J[2]+J[3]+J[4]-J[5]+J[6]-J[7]+J[8]+J[9]+J[10]-J[11]+J[12]-J[13]-J[14]-J[15]+J[16]-J[17]+
    J[18]+J[19]-J[20]+J[21]+J[22]-J[23]+J[24]-J[25]+J[26]-J[27], -H[0]-H[1]+H[2]-H[3]-H[4]-H[5]-H[6]+H[7]+
    J[0]-J[1]+J[2]+J[3]+J[4]+J[5]-J[6]-J[7]+J[8]+J[9]+J[10]+J[11]-J[12]-J[13]-J[14]-J[15]-J[16]+J[17]+J[18]+
    J[19]+J[20]-J[21]+J[22]+J[23]-J[24]+J[25]-J[26]-J[27], -H[0]-H[1]+H[2]-H[3]-H[4]-H[5]-H[6]-H[7]+J[0]-J[1]+
    J[2]+J[3]+J[4]+J[5]+J[6]-J[7]+J[8]+J[9]+J[10]+J[11]+J[12]-J[13]-J[14]-J[15]-J[16]-J[17]+J[18]+J[19]+
    J[20]+J[21]+J[22]+J[23]+J[24]+J[25]+J[26]+J[27], -H[0]-H[1]-H[2]+H[3]+H[4]+H[5]+H[6]+H[7]+J[0]+J[1]-J[2]-J[3]-J[4]-J[5]-J[6]+
    J[7]-J[8]-J[9]-J[10]-J[11]-J[12]-J[13]-J[14]-J[15]-J[16]-J[17]+J[18]+J[19]+J[20]+J[21]+J[22]+J[23]+J[24]+
    J[25]+J[26]+J[27], -H[0]-H[1]-H[2]+H[3]+H[4]+H[5]+H[6]-H[7]+J[0]+J[1]-J[2]-J[3]-J[4]-J[5]+J[6]+J[7]-J[8]-J[9]-J[10]-J[11]+
    J[12]-J[13]-J[14]-J[15]-J[16]+J[17]+J[18]+J[19]+J[20]-J[21]+J[22]+J[23]-J[24]+J[25]-J[26]-J[27], -H[0]-H[1]-H[2]+
    H[3]+H[4]+H[5]-H[6]+H[7]+J[0]+J[1]-J[2]-J[3]-J[4]+J[5]-J[6]+J[7]-J[8]-J[9]-J[10]+J[11]-J[12]-J[13]-J[14]-J[15]+
    J[16]-J[17]+J[18]+J[19]-J[20]+J[21]+J[22]-J[23]+J[24]-J[25]+J[26]-J[27], -H[0]-H[1]-H[2]+H[3]+H[4]+H[5]-H[6]-H[7]+
    J[0]+J[1]-J[2]-J[3]-J[4]+J[5]+J[6]+J[7]-J[8]-J[9]-J[10]+J[11]+J[12]-J[13]-J[14]-J[15]+J[16]+J[17]+J[18]+
    J[19]-J[20]-J[21]+J[22]-J[23]-J[24]-J[25]-J[26]+J[27], -H[0]-H[1]-H[2]+H[3]+H[4]-H[5]+H[6]+H[7]+J[0]+
    J[1]-J[2]-J[3]+J[4]-J[5]-J[6]+J[7]-J[8]-J[9]+J[10]-J[11]-J[12]-J[13]-J[14]+J[15]-J[16]-J[17]+J[18]-J[19]+
    J[20]+J[21]-J[22]+J[23]+J[24]-J[25]-J[26]+J[27], -H[0]-H[1]-H[2]+H[3]+H[4]-H[5]+H[6]-H[7]+J[0]+J[1]-J[2]-J[3]+
    J[4]-J[5]+J[6]+J[7]-J[8]-J[9]+J[10]-J[11]+J[12]-J[13]-J[14]+J[15]-J[16]+J[17]+J[18]-J[19]+J[20]-J[21]-J[22]+
    J[23]-J[24]-J[25]+J[26]-J[27], -H[0]-H[1]-H[2]+H[3]+H[4]-H[5]-H[6]+H[7]+J[0]+J[1]-J[2]-J[3]+J[4]+J[5]-J[6]+
    J[7]-J[8]-J[9]+J[10]+J[11]-J[12]-J[13]-J[14]+J[15]+J[16]-J[17]+J[18]-J[19]-J[20]+J[21]-J[22]-J[23]+J[24]+
    J[25]-J[26]-J[27], -H[0]-H[1]-H[2]+H[3]+H[4]-H[5]-H[6]-H[7]+J[0]+J[1]-J[2]-J[3]+J[4]+J[5]+J[6]+J[7]-J[8]-J[9]+
    J[10]+J[11]+J[12]-J[13]-J[14]+J[15]+J[16]+J[17]+J[18]-J[19]-J[20]-J[21]-J[22]-J[23]-J[24]+J[25]+J[26]+
    J[27], -H[0]-H[1]-H[2]+H[3]-H[4]+H[5]+H[6]+H[7]+J[0]+J[1]-J[2]+J[3]-J[4]-J[5]-J[6]+J[7]-J[8]+J[9]-J[10]-J[11]-J[12]-J[13]+
    J[14]-J[15]-J[16]-J[17]-J[18]+J[19]+J[20]+J[21]-J[22]-J[23]-J[24]+J[25]+J[26]+J[27], -H[0]-H[1]-H[2]+
    H[3]-H[4]+H[5]+H[6]-H[7]+J[0]+J[1]-J[2]+J[3]-J[4]-J[5]+J[6]+J[7]-J[8]+J[9]-J[10]-J[11]+J[12]-J[13]+J[14]-J[15]-J[16]+
    J[17]-J[18]+J[19]+J[20]-J[21]-J[22]-J[23]+J[24]+J[25]-J[26]-J[27], -H[0]-H[1]-H[2]+H[3]-H[4]+H[5]-H[6]+
    H[7]+J[0]+J[1]-J[2]+J[3]-J[4]+J[5]-J[6]+J[7]-J[8]+J[9]-J[10]+J[11]-J[12]-J[13]+J[14]-J[15]+J[16]-J[17]-J[18]+
    J[19]-J[20]+J[21]-J[22]+J[23]-J[24]-J[25]+J[26]-J[27], -H[0]-H[1]-H[2]+H[3]-H[4]+H[5]-H[6]-H[7]+J[0]+
    J[1]-J[2]+J[3]-J[4]+J[5]+J[6]+J[7]-J[8]+J[9]-J[10]+J[11]+J[12]-J[13]+J[14]-J[15]+J[16]+J[17]-J[18]+J[19]-J[20]-J[21]-J[22]+
    J[23]+J[24]-J[25]-J[26]+J[27], -H[0]-H[1]-H[2]+H[3]-H[4]-H[5]+H[6]+H[7]+J[0]+J[1]-J[2]+J[3]+J[4]-J[5]-J[6]+
    J[7]-J[8]+J[9]+J[10]-J[11]-J[12]-J[13]+J[14]+J[15]-J[16]-J[17]-J[18]-J[19]+J[20]+J[21]+J[22]-J[23]-J[24]-J[25]-J[26]+
    J[27], -H[0]-H[1]-H[2]+H[3]-H[4]-H[5]+H[6]-H[7]+J[0]+J[1]-J[2]+J[3]+J[4]-J[5]+J[6]+J[7]-J[8]+J[9]+J[10]-J[11]+
    J[12]-J[13]+J[14]+J[15]-J[16]+J[17]-J[18]-J[19]+J[20]-J[21]+J[22]-J[23]+J[24]-J[25]+J[26]-J[27], -H[0]-H[1]-H[2]+
    H[3]-H[4]-H[5]-H[6]+H[7]+J[0]+J[1]-J[2]+J[3]+J[4]+J[5]-J[6]+J[7]-J[8]+J[9]+J[10]+J[11]-J[12]-J[13]+J[14]+
    J[15]+J[16]-J[17]-J[18]-J[19]-J[20]+J[21]+J[22]+J[23]-J[24]+J[25]-J[26]-J[27], -H[0]-H[1]-H[2]+H[3]-H[4]-H[5]-H[6]-H[7]+
    J[0]+J[1]-J[2]+J[3]+J[4]+J[5]+J[6]+J[7]-J[8]+J[9]+J[10]+J[11]+J[12]-J[13]+J[14]+J[15]+J[16]+J[17]-J[18]-J[19]-J[20]-J[21]+
    J[22]+J[23]+J[24]+J[25]+J[26]+J[27], -H[0]-H[1]-H[2]-H[3]+H[4]+H[5]+H[6]+H[7]+J[0]+J[1]+J[2]-J[3]-J[4]-J[5]-J[6]+
    J[7]+J[8]-J[9]-J[10]-J[11]-J[12]+J[13]-J[14]-J[15]-J[16]-J[17]-J[18]-J[19]-J[20]-J[21]+J[22]+J[23]+J[24]+
    J[25]+J[26]+J[27], -H[0]-H[1]-H[2]-H[3]+H[4]+H[5]+H[6]-H[7]+J[0]+J[1]+J[2]-J[3]-J[4]-J[5]+J[6]+J[7]+
    J[8]-J[9]-J[10]-J[11]+J[12]+J[13]-J[14]-J[15]-J[16]+J[17]-J[18]-J[19]-J[20]+J[21]+J[22]+J[23]-J[24]+
    J[25]-J[26]-J[27], -H[0]-H[1]-H[2]-H[3]+H[4]+H[5]-H[6]+H[7]+J[0]+J[1]+J[2]-J[3]-J[4]+J[5]-J[6]+J[7]+
    J[8]-J[9]-J[10]+J[11]-J[12]+J[13]-J[14]-J[15]+J[16]-J[17]-J[18]-J[19]+J[20]-J[21]+J[22]-J[23]+J[24]-J[25]+
    J[26]-J[27], -H[0]-H[1]-H[2]-H[3]+H[4]+H[5]-H[6]-H[7]+J[0]+J[1]+J[2]-J[3]-J[4]+J[5]+J[6]+J[7]+J[8]-J[9]-J[10]+
    J[11]+J[12]+J[13]-J[14]-J[15]+J[16]+J[17]-J[18]-J[19]+J[20]+J[21]+J[22]-J[23]-J[24]-J[25]-J[26]+J[27], -H[0]-H[1]-H[2]-H[3]+
    H[4]-H[5]+H[6]+H[7]+J[0]+J[1]+J[2]-J[3]+J[4]-J[5]-J[6]+J[7]+J[8]-J[9]+J[10]-J[11]-J[12]+J[13]-J[14]+
    J[15]-J[16]-J[17]-J[18]+J[19]-J[20]-J[21]-J[22]+J[23]+J[24]-J[25]-J[26]+J[27], -H[0]-H[1]-H[2]-H[3]+
    H[4]-H[5]+H[6]-H[7]+J[0]+J[1]+J[2]-J[3]+J[4]-J[5]+J[6]+J[7]+J[8]-J[9]+J[10]-J[11]+J[12]+J[13]-J[14]+
    J[15]-J[16]+J[17]-J[18]+J[19]-J[20]+J[21]-J[22]+J[23]-J[24]-J[25]+J[26]-J[27], -H[0]-H[1]-H[2]-H[3]+
    H[4]-H[5]-H[6]+H[7]+J[0]+J[1]+J[2]-J[3]+J[4]+J[5]-J[6]+J[7]+J[8]-J[9]+J[10]+J[11]-J[12]+J[13]-J[14]+
    J[15]+J[16]-J[17]-J[18]+J[19]+J[20]-J[21]-J[22]-J[23]+J[24]+J[25]-J[26]-J[27], -H[0]-H[1]-H[2]-H[3]+
    H[4]-H[5]-H[6]-H[7]+J[0]+J[1]+J[2]-J[3]+J[4]+J[5]+J[6]+J[7]+J[8]-J[9]+J[10]+J[11]+J[12]+J[13]-J[14]+
    J[15]+J[16]+J[17]-J[18]+J[19]+J[20]+J[21]-J[22]-J[23]-J[24]+J[25]+J[26]+J[27], -H[0]-H[1]-H[2]-H[3]-H[4]+
    H[5]+H[6]+H[7]+J[0]+J[1]+J[2]+J[3]-J[4]-J[5]-J[6]+J[7]+J[8]+J[9]-J[10]-J[11]-J[12]+J[13]+J[14]-J[15]-J[16]-J[17]+
    J[18]-J[19]-J[20]-J[21]-J[22]-J[23]-J[24]+J[25]+J[26]+J[27], -H[0]-H[1]-H[2]-H[3]-H[4]+H[5]+H[6]-H[7]+
    J[0]+J[1]+J[2]+J[3]-J[4]-J[5]+J[6]+J[7]+J[8]+J[9]-J[10]-J[11]+J[12]+J[13]+J[14]-J[15]-J[16]+J[17]+J[18]-J[19]-J[20]+
    J[21]-J[22]-J[23]+J[24]+J[25]-J[26]-J[27], -H[0]-H[1]-H[2]-H[3]-H[4]+H[5]-H[6]+H[7]+J[0]+J[1]+J[2]+J[3]-J[4]+
    J[5]-J[6]+J[7]+J[8]+J[9]-J[10]+J[11]-J[12]+J[13]+J[14]-J[15]+J[16]-J[17]+J[18]-J[19]+J[20]-J[21]-J[22]+
    J[23]-J[24]-J[25]+J[26]-J[27], -H[0]-H[1]-H[2]-H[3]-H[4]+H[5]-H[6]-H[7]+J[0]+J[1]+J[2]+J[3]-J[4]+J[5]+
    J[6]+J[7]+J[8]+J[9]-J[10]+J[11]+J[12]+J[13]+J[14]-J[15]+J[16]+J[17]+J[18]-J[19]+J[20]+J[21]-J[22]+J[23]+
    J[24]-J[25]-J[26]+J[27], -H[0]-H[1]-H[2]-H[3]-H[4]-H[5]+H[6]+H[7]+J[0]+J[1]+J[2]+J[3]+J[4]-J[5]-J[6]+
    J[7]+J[8]+J[9]+J[10]-J[11]-J[12]+J[13]+J[14]+J[15]-J[16]-J[17]+J[18]+J[19]-J[20]-J[21]+J[22]-J[23]-J[24]-J[25]-J[26]+
    J[27], -H[0]-H[1]-H[2]-H[3]-H[4]-H[5]+H[6]-H[7]+J[0]+J[1]+J[2]+J[3]+J[4]-J[5]+J[6]+J[7]+J[8]+J[9]+J[10]-J[11]+
    J[12]+J[13]+J[14]+J[15]-J[16]+J[17]+J[18]+J[19]-J[20]+J[21]+J[22]-J[23]+J[24]-J[25]+J[26]-J[27], -H[0]-H[1]-H[2]-H[3]-H[4]-H[5]-H[6]+
    H[7]+J[0]+J[1]+J[2]+J[3]+J[4]+J[5]-J[6]+J[7]+J[8]+J[9]+J[10]+J[11]-J[12]+J[13]+J[14]+J[15]+J[16]-J[17]+
    J[18]+J[19]+J[20]-J[21]+J[22]+J[23]-J[24]+J[25]-J[26]-J[27], -H[0]-H[1]-H[2]-H[3]-H[4]-H[5]-H[6]-H[7]+
    J[0]+J[1]+J[2]+J[3]+J[4]+J[5]+J[6]+J[7]+J[8]+J[9]+J[10]+J[11]+J[12]+J[13]+J[14]+J[15]+J[16]+J[17]+J[18]+
            J[19]+J[20]+J[21]+J[22]+J[23]+J[24]+J[25]+J[26]+J[27],])
    logZ = fast_logsumexp(energyTerms)[0]
    num = fast_logsumexp(energyTerms, [ 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
 -1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
 -1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
 -1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
 -1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
 -1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1])
    Cout[0] = exp( num[0] - logZ ) * num[1]
    num = fast_logsumexp(energyTerms, [ 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,-1,-1,-1,-1,-1,-1,-1,-1,
 -1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
 -1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
 -1,-1,-1,-1,-1,-1,-1,-1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
 -1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
 -1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
 -1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1])
    Cout[1] = exp( num[0] - logZ ) * num[1]
    num = fast_logsumexp(energyTerms, [ 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
 -1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
 -1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
 -1,-1,-1,-1,-1,-1,-1,-1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,-1,-1,-1,-1,-1,-1,-1,-1,
 -1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
 -1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1])
    Cout[2] = exp( num[0] - logZ ) * num[1]
    num = fast_logsumexp(energyTerms, [ 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,-1,-1,-1,-1,-1,-1,-1,-1,
 -1,-1,-1,-1,-1,-1,-1,-1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
 -1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,-1,-1,-1,-1,-1,-1,-1,-1,
 -1,-1,-1,-1,-1,-1,-1,-1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
 -1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,-1,-1,-1,-1,-1,-1,-1,-1,
 -1,-1,-1,-1,-1,-1,-1,-1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
 -1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1])
    Cout[3] = exp( num[0] - logZ ) * num[1]
    num = fast_logsumexp(energyTerms, [ 1, 1, 1, 1, 1, 1, 1, 1,-1,-1,-1,-1,-1,-1,-1,-1, 1, 1, 1, 1, 1, 1, 1, 1,
 -1,-1,-1,-1,-1,-1,-1,-1, 1, 1, 1, 1, 1, 1, 1, 1,-1,-1,-1,-1,-1,-1,-1,-1,
  1, 1, 1, 1, 1, 1, 1, 1,-1,-1,-1,-1,-1,-1,-1,-1, 1, 1, 1, 1, 1, 1, 1, 1,
 -1,-1,-1,-1,-1,-1,-1,-1, 1, 1, 1, 1, 1, 1, 1, 1,-1,-1,-1,-1,-1,-1,-1,-1,
  1, 1, 1, 1, 1, 1, 1, 1,-1,-1,-1,-1,-1,-1,-1,-1, 1, 1, 1, 1, 1, 1, 1, 1,
 -1,-1,-1,-1,-1,-1,-1,-1, 1, 1, 1, 1, 1, 1, 1, 1,-1,-1,-1,-1,-1,-1,-1,-1,
  1, 1, 1, 1, 1, 1, 1, 1,-1,-1,-1,-1,-1,-1,-1,-1, 1, 1, 1, 1, 1, 1, 1, 1,
 -1,-1,-1,-1,-1,-1,-1,-1, 1, 1, 1, 1, 1, 1, 1, 1,-1,-1,-1,-1,-1,-1,-1,-1,
  1, 1, 1, 1, 1, 1, 1, 1,-1,-1,-1,-1,-1,-1,-1,-1, 1, 1, 1, 1, 1, 1, 1, 1,
 -1,-1,-1,-1,-1,-1,-1,-1, 1, 1, 1, 1, 1, 1, 1, 1,-1,-1,-1,-1,-1,-1,-1,-1,
  1, 1, 1, 1, 1, 1, 1, 1,-1,-1,-1,-1,-1,-1,-1,-1])
    Cout[4] = exp( num[0] - logZ ) * num[1]
    num = fast_logsumexp(energyTerms, [ 1, 1, 1, 1,-1,-1,-1,-1, 1, 1, 1, 1,-1,-1,-1,-1, 1, 1, 1, 1,-1,-1,-1,-1,
  1, 1, 1, 1,-1,-1,-1,-1, 1, 1, 1, 1,-1,-1,-1,-1, 1, 1, 1, 1,-1,-1,-1,-1,
  1, 1, 1, 1,-1,-1,-1,-1, 1, 1, 1, 1,-1,-1,-1,-1, 1, 1, 1, 1,-1,-1,-1,-1,
  1, 1, 1, 1,-1,-1,-1,-1, 1, 1, 1, 1,-1,-1,-1,-1, 1, 1, 1, 1,-1,-1,-1,-1,
  1, 1, 1, 1,-1,-1,-1,-1, 1, 1, 1, 1,-1,-1,-1,-1, 1, 1, 1, 1,-1,-1,-1,-1,
  1, 1, 1, 1,-1,-1,-1,-1, 1, 1, 1, 1,-1,-1,-1,-1, 1, 1, 1, 1,-1,-1,-1,-1,
  1, 1, 1, 1,-1,-1,-1,-1, 1, 1, 1, 1,-1,-1,-1,-1, 1, 1, 1, 1,-1,-1,-1,-1,
  1, 1, 1, 1,-1,-1,-1,-1, 1, 1, 1, 1,-1,-1,-1,-1, 1, 1, 1, 1,-1,-1,-1,-1,
  1, 1, 1, 1,-1,-1,-1,-1, 1, 1, 1, 1,-1,-1,-1,-1, 1, 1, 1, 1,-1,-1,-1,-1,
  1, 1, 1, 1,-1,-1,-1,-1, 1, 1, 1, 1,-1,-1,-1,-1, 1, 1, 1, 1,-1,-1,-1,-1,
  1, 1, 1, 1,-1,-1,-1,-1, 1, 1, 1, 1,-1,-1,-1,-1])
    Cout[5] = exp( num[0] - logZ ) * num[1]
    num = fast_logsumexp(energyTerms, [ 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1,
  1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1,
  1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1,
  1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1,
  1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1,
  1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1,
  1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1,
  1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1,
  1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1,
  1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1,
  1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1])
    Cout[6] = exp( num[0] - logZ ) * num[1]
    num = fast_logsumexp(energyTerms, [ 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1,
  1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1,
  1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1,
  1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1,
  1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1,
  1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1,
  1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1,
  1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1,
  1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1,
  1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1,
  1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1])
    Cout[7] = exp( num[0] - logZ ) * num[1]
    num = fast_logsumexp(energyTerms, [ 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,-1,-1,-1,-1,-1,-1,-1,-1,
 -1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
 -1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
 -1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
 -1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
 -1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1])
    Cout[8] = exp( num[0] - logZ ) * num[1]
    num = fast_logsumexp(energyTerms, [ 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
 -1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
 -1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
 -1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
 -1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
 -1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
 -1,-1,-1,-1,-1,-1,-1,-1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1])
    Cout[9] = exp( num[0] - logZ ) * num[1]
    num = fast_logsumexp(energyTerms, [ 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,-1,-1,-1,-1,-1,-1,-1,-1,
 -1,-1,-1,-1,-1,-1,-1,-1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
 -1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,-1,-1,-1,-1,-1,-1,-1,-1,
 -1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,-1,-1,-1,-1,-1,-1,-1,-1,
 -1,-1,-1,-1,-1,-1,-1,-1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
 -1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1])
    Cout[10] = exp( num[0] - logZ ) * num[1]
    num = fast_logsumexp(energyTerms, [ 1, 1, 1, 1, 1, 1, 1, 1,-1,-1,-1,-1,-1,-1,-1,-1, 1, 1, 1, 1, 1, 1, 1, 1,
 -1,-1,-1,-1,-1,-1,-1,-1, 1, 1, 1, 1, 1, 1, 1, 1,-1,-1,-1,-1,-1,-1,-1,-1,
  1, 1, 1, 1, 1, 1, 1, 1,-1,-1,-1,-1,-1,-1,-1,-1, 1, 1, 1, 1, 1, 1, 1, 1,
 -1,-1,-1,-1,-1,-1,-1,-1, 1, 1, 1, 1, 1, 1, 1, 1,-1,-1,-1,-1,-1,-1,-1,-1,
  1, 1, 1, 1, 1, 1, 1, 1,-1,-1,-1,-1,-1,-1,-1,-1, 1, 1, 1, 1, 1, 1, 1, 1,
 -1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1, 1, 1, 1, 1, 1, 1, 1, 1,
 -1,-1,-1,-1,-1,-1,-1,-1, 1, 1, 1, 1, 1, 1, 1, 1,-1,-1,-1,-1,-1,-1,-1,-1,
  1, 1, 1, 1, 1, 1, 1, 1,-1,-1,-1,-1,-1,-1,-1,-1, 1, 1, 1, 1, 1, 1, 1, 1,
 -1,-1,-1,-1,-1,-1,-1,-1, 1, 1, 1, 1, 1, 1, 1, 1,-1,-1,-1,-1,-1,-1,-1,-1,
  1, 1, 1, 1, 1, 1, 1, 1,-1,-1,-1,-1,-1,-1,-1,-1, 1, 1, 1, 1, 1, 1, 1, 1,
 -1,-1,-1,-1,-1,-1,-1,-1, 1, 1, 1, 1, 1, 1, 1, 1])
    Cout[11] = exp( num[0] - logZ ) * num[1]
    num = fast_logsumexp(energyTerms, [ 1, 1, 1, 1,-1,-1,-1,-1, 1, 1, 1, 1,-1,-1,-1,-1, 1, 1, 1, 1,-1,-1,-1,-1,
  1, 1, 1, 1,-1,-1,-1,-1, 1, 1, 1, 1,-1,-1,-1,-1, 1, 1, 1, 1,-1,-1,-1,-1,
  1, 1, 1, 1,-1,-1,-1,-1, 1, 1, 1, 1,-1,-1,-1,-1, 1, 1, 1, 1,-1,-1,-1,-1,
  1, 1, 1, 1,-1,-1,-1,-1, 1, 1, 1, 1,-1,-1,-1,-1, 1, 1, 1, 1,-1,-1,-1,-1,
  1, 1, 1, 1,-1,-1,-1,-1, 1, 1, 1, 1,-1,-1,-1,-1, 1, 1, 1, 1,-1,-1,-1,-1,
  1, 1, 1, 1,-1,-1,-1,-1,-1,-1,-1,-1, 1, 1, 1, 1,-1,-1,-1,-1, 1, 1, 1, 1,
 -1,-1,-1,-1, 1, 1, 1, 1,-1,-1,-1,-1, 1, 1, 1, 1,-1,-1,-1,-1, 1, 1, 1, 1,
 -1,-1,-1,-1, 1, 1, 1, 1,-1,-1,-1,-1, 1, 1, 1, 1,-1,-1,-1,-1, 1, 1, 1, 1,
 -1,-1,-1,-1, 1, 1, 1, 1,-1,-1,-1,-1, 1, 1, 1, 1,-1,-1,-1,-1, 1, 1, 1, 1,
 -1,-1,-1,-1, 1, 1, 1, 1,-1,-1,-1,-1, 1, 1, 1, 1,-1,-1,-1,-1, 1, 1, 1, 1,
 -1,-1,-1,-1, 1, 1, 1, 1,-1,-1,-1,-1, 1, 1, 1, 1])
    Cout[12] = exp( num[0] - logZ ) * num[1]
    num = fast_logsumexp(energyTerms, [ 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1,
  1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1,
  1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1,
  1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1,
  1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1,
  1, 1,-1,-1, 1, 1,-1,-1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,
 -1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,
 -1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,
 -1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,
 -1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,
 -1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1])
    Cout[13] = exp( num[0] - logZ ) * num[1]
    num = fast_logsumexp(energyTerms, [ 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1,
  1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1,
  1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1,
  1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1,
  1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1,
  1,-1, 1,-1, 1,-1, 1,-1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,
 -1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,
 -1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,
 -1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,
 -1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,
 -1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1])
    Cout[14] = exp( num[0] - logZ ) * num[1]
    num = fast_logsumexp(energyTerms, [ 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
 -1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
 -1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,-1,-1,-1,-1,-1,-1,-1,-1,
 -1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
 -1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
 -1,-1,-1,-1,-1,-1,-1,-1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1])
    Cout[15] = exp( num[0] - logZ ) * num[1]
    num = fast_logsumexp(energyTerms, [ 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,-1,-1,-1,-1,-1,-1,-1,-1,
 -1,-1,-1,-1,-1,-1,-1,-1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
 -1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
 -1,-1,-1,-1,-1,-1,-1,-1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
 -1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
 -1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
 -1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1])
    Cout[16] = exp( num[0] - logZ ) * num[1]
    num = fast_logsumexp(energyTerms, [ 1, 1, 1, 1, 1, 1, 1, 1,-1,-1,-1,-1,-1,-1,-1,-1, 1, 1, 1, 1, 1, 1, 1, 1,
 -1,-1,-1,-1,-1,-1,-1,-1, 1, 1, 1, 1, 1, 1, 1, 1,-1,-1,-1,-1,-1,-1,-1,-1,
  1, 1, 1, 1, 1, 1, 1, 1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
  1, 1, 1, 1, 1, 1, 1, 1,-1,-1,-1,-1,-1,-1,-1,-1, 1, 1, 1, 1, 1, 1, 1, 1,
 -1,-1,-1,-1,-1,-1,-1,-1, 1, 1, 1, 1, 1, 1, 1, 1,-1,-1,-1,-1,-1,-1,-1,-1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,-1,-1,-1,-1,-1,-1,-1,-1,
  1, 1, 1, 1, 1, 1, 1, 1,-1,-1,-1,-1,-1,-1,-1,-1, 1, 1, 1, 1, 1, 1, 1, 1,
 -1,-1,-1,-1,-1,-1,-1,-1, 1, 1, 1, 1, 1, 1, 1, 1,-1,-1,-1,-1,-1,-1,-1,-1,
 -1,-1,-1,-1,-1,-1,-1,-1, 1, 1, 1, 1, 1, 1, 1, 1,-1,-1,-1,-1,-1,-1,-1,-1,
  1, 1, 1, 1, 1, 1, 1, 1,-1,-1,-1,-1,-1,-1,-1,-1, 1, 1, 1, 1, 1, 1, 1, 1,
 -1,-1,-1,-1,-1,-1,-1,-1, 1, 1, 1, 1, 1, 1, 1, 1])
    Cout[17] = exp( num[0] - logZ ) * num[1]
    num = fast_logsumexp(energyTerms, [ 1, 1, 1, 1,-1,-1,-1,-1, 1, 1, 1, 1,-1,-1,-1,-1, 1, 1, 1, 1,-1,-1,-1,-1,
  1, 1, 1, 1,-1,-1,-1,-1, 1, 1, 1, 1,-1,-1,-1,-1, 1, 1, 1, 1,-1,-1,-1,-1,
  1, 1, 1, 1,-1,-1,-1,-1, 1, 1, 1, 1,-1,-1,-1,-1,-1,-1,-1,-1, 1, 1, 1, 1,
 -1,-1,-1,-1, 1, 1, 1, 1,-1,-1,-1,-1, 1, 1, 1, 1,-1,-1,-1,-1, 1, 1, 1, 1,
 -1,-1,-1,-1, 1, 1, 1, 1,-1,-1,-1,-1, 1, 1, 1, 1,-1,-1,-1,-1, 1, 1, 1, 1,
 -1,-1,-1,-1, 1, 1, 1, 1, 1, 1, 1, 1,-1,-1,-1,-1, 1, 1, 1, 1,-1,-1,-1,-1,
  1, 1, 1, 1,-1,-1,-1,-1, 1, 1, 1, 1,-1,-1,-1,-1, 1, 1, 1, 1,-1,-1,-1,-1,
  1, 1, 1, 1,-1,-1,-1,-1, 1, 1, 1, 1,-1,-1,-1,-1, 1, 1, 1, 1,-1,-1,-1,-1,
 -1,-1,-1,-1, 1, 1, 1, 1,-1,-1,-1,-1, 1, 1, 1, 1,-1,-1,-1,-1, 1, 1, 1, 1,
 -1,-1,-1,-1, 1, 1, 1, 1,-1,-1,-1,-1, 1, 1, 1, 1,-1,-1,-1,-1, 1, 1, 1, 1,
 -1,-1,-1,-1, 1, 1, 1, 1,-1,-1,-1,-1, 1, 1, 1, 1])
    Cout[18] = exp( num[0] - logZ ) * num[1]
    num = fast_logsumexp(energyTerms, [ 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1,
  1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1,
  1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1,-1,-1, 1, 1,-1,-1, 1, 1,
 -1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,
 -1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,
 -1,-1, 1, 1,-1,-1, 1, 1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1,
  1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1,
  1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1,
 -1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,
 -1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,
 -1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1])
    Cout[19] = exp( num[0] - logZ ) * num[1]
    num = fast_logsumexp(energyTerms, [ 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1,
  1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1,
  1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1,-1, 1,-1, 1,-1, 1,-1, 1,
 -1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,
 -1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,
 -1, 1,-1, 1,-1, 1,-1, 1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1,
  1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1,
  1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1,
 -1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,
 -1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,
 -1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1])
    Cout[20] = exp( num[0] - logZ ) * num[1]
    num = fast_logsumexp(energyTerms, [ 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,-1,-1,-1,-1,-1,-1,-1,-1,
 -1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
 -1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
 -1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
 -1,-1,-1,-1,-1,-1,-1,-1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,-1,-1,-1,-1,-1,-1,-1,-1,
 -1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1])
    Cout[21] = exp( num[0] - logZ ) * num[1]
    num = fast_logsumexp(energyTerms, [ 1, 1, 1, 1, 1, 1, 1, 1,-1,-1,-1,-1,-1,-1,-1,-1, 1, 1, 1, 1, 1, 1, 1, 1,
 -1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1, 1, 1, 1, 1, 1, 1, 1, 1,
 -1,-1,-1,-1,-1,-1,-1,-1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
 -1,-1,-1,-1,-1,-1,-1,-1, 1, 1, 1, 1, 1, 1, 1, 1,-1,-1,-1,-1,-1,-1,-1,-1,
 -1,-1,-1,-1,-1,-1,-1,-1, 1, 1, 1, 1, 1, 1, 1, 1,-1,-1,-1,-1,-1,-1,-1,-1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,-1,-1,-1,-1,-1,-1,-1,-1,
  1, 1, 1, 1, 1, 1, 1, 1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
  1, 1, 1, 1, 1, 1, 1, 1,-1,-1,-1,-1,-1,-1,-1,-1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1,-1,-1,-1,-1,-1,-1,-1,-1, 1, 1, 1, 1, 1, 1, 1, 1,
 -1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1, 1, 1, 1, 1, 1, 1, 1, 1,
 -1,-1,-1,-1,-1,-1,-1,-1, 1, 1, 1, 1, 1, 1, 1, 1])
    Cout[22] = exp( num[0] - logZ ) * num[1]
    num = fast_logsumexp(energyTerms, [ 1, 1, 1, 1,-1,-1,-1,-1, 1, 1, 1, 1,-1,-1,-1,-1, 1, 1, 1, 1,-1,-1,-1,-1,
  1, 1, 1, 1,-1,-1,-1,-1,-1,-1,-1,-1, 1, 1, 1, 1,-1,-1,-1,-1, 1, 1, 1, 1,
 -1,-1,-1,-1, 1, 1, 1, 1,-1,-1,-1,-1, 1, 1, 1, 1, 1, 1, 1, 1,-1,-1,-1,-1,
  1, 1, 1, 1,-1,-1,-1,-1, 1, 1, 1, 1,-1,-1,-1,-1, 1, 1, 1, 1,-1,-1,-1,-1,
 -1,-1,-1,-1, 1, 1, 1, 1,-1,-1,-1,-1, 1, 1, 1, 1,-1,-1,-1,-1, 1, 1, 1, 1,
 -1,-1,-1,-1, 1, 1, 1, 1, 1, 1, 1, 1,-1,-1,-1,-1, 1, 1, 1, 1,-1,-1,-1,-1,
  1, 1, 1, 1,-1,-1,-1,-1, 1, 1, 1, 1,-1,-1,-1,-1,-1,-1,-1,-1, 1, 1, 1, 1,
 -1,-1,-1,-1, 1, 1, 1, 1,-1,-1,-1,-1, 1, 1, 1, 1,-1,-1,-1,-1, 1, 1, 1, 1,
  1, 1, 1, 1,-1,-1,-1,-1, 1, 1, 1, 1,-1,-1,-1,-1, 1, 1, 1, 1,-1,-1,-1,-1,
  1, 1, 1, 1,-1,-1,-1,-1,-1,-1,-1,-1, 1, 1, 1, 1,-1,-1,-1,-1, 1, 1, 1, 1,
 -1,-1,-1,-1, 1, 1, 1, 1,-1,-1,-1,-1, 1, 1, 1, 1])
    Cout[23] = exp( num[0] - logZ ) * num[1]
    num = fast_logsumexp(energyTerms, [ 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1,
  1, 1,-1,-1, 1, 1,-1,-1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,
 -1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1, 1, 1,-1,-1, 1, 1,-1,-1,
  1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1,
 -1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,
 -1,-1, 1, 1,-1,-1, 1, 1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1,
  1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1,-1,-1, 1, 1,-1,-1, 1, 1,
 -1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,
  1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1,
  1, 1,-1,-1, 1, 1,-1,-1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,
 -1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1])
    Cout[24] = exp( num[0] - logZ ) * num[1]
    num = fast_logsumexp(energyTerms, [ 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1,
  1,-1, 1,-1, 1,-1, 1,-1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,
 -1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1, 1,-1, 1,-1, 1,-1, 1,-1,
  1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1,
 -1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,
 -1, 1,-1, 1,-1, 1,-1, 1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1,
  1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1,-1, 1,-1, 1,-1, 1,-1, 1,
 -1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,
  1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1,
  1,-1, 1,-1, 1,-1, 1,-1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,
 -1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1])
    Cout[25] = exp( num[0] - logZ ) * num[1]
    num = fast_logsumexp(energyTerms, [ 1, 1, 1, 1, 1, 1, 1, 1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,-1,-1,-1,-1,-1,-1,-1,-1,
 -1,-1,-1,-1,-1,-1,-1,-1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
 -1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,-1,-1,-1,-1,-1,-1,-1,-1,
 -1,-1,-1,-1,-1,-1,-1,-1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
 -1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,-1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,-1,-1,-1,-1,-1,-1,-1,-1,
 -1,-1,-1,-1,-1,-1,-1,-1, 1, 1, 1, 1, 1, 1, 1, 1])
    Cout[26] = exp( num[0] - logZ ) * num[1]
    num = fast_logsumexp(energyTerms, [ 1, 1, 1, 1,-1,-1,-1,-1, 1, 1, 1, 1,-1,-1,-1,-1,-1,-1,-1,-1, 1, 1, 1, 1,
 -1,-1,-1,-1, 1, 1, 1, 1, 1, 1, 1, 1,-1,-1,-1,-1, 1, 1, 1, 1,-1,-1,-1,-1,
 -1,-1,-1,-1, 1, 1, 1, 1,-1,-1,-1,-1, 1, 1, 1, 1, 1, 1, 1, 1,-1,-1,-1,-1,
  1, 1, 1, 1,-1,-1,-1,-1,-1,-1,-1,-1, 1, 1, 1, 1,-1,-1,-1,-1, 1, 1, 1, 1,
  1, 1, 1, 1,-1,-1,-1,-1, 1, 1, 1, 1,-1,-1,-1,-1,-1,-1,-1,-1, 1, 1, 1, 1,
 -1,-1,-1,-1, 1, 1, 1, 1, 1, 1, 1, 1,-1,-1,-1,-1, 1, 1, 1, 1,-1,-1,-1,-1,
 -1,-1,-1,-1, 1, 1, 1, 1,-1,-1,-1,-1, 1, 1, 1, 1, 1, 1, 1, 1,-1,-1,-1,-1,
  1, 1, 1, 1,-1,-1,-1,-1,-1,-1,-1,-1, 1, 1, 1, 1,-1,-1,-1,-1, 1, 1, 1, 1,
  1, 1, 1, 1,-1,-1,-1,-1, 1, 1, 1, 1,-1,-1,-1,-1,-1,-1,-1,-1, 1, 1, 1, 1,
 -1,-1,-1,-1, 1, 1, 1, 1, 1, 1, 1, 1,-1,-1,-1,-1, 1, 1, 1, 1,-1,-1,-1,-1,
 -1,-1,-1,-1, 1, 1, 1, 1,-1,-1,-1,-1, 1, 1, 1, 1])
    Cout[27] = exp( num[0] - logZ ) * num[1]
    num = fast_logsumexp(energyTerms, [ 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1,-1,-1, 1, 1,-1,-1, 1, 1,
 -1,-1, 1, 1,-1,-1, 1, 1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1,
 -1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1, 1, 1,-1,-1, 1, 1,-1,-1,
  1, 1,-1,-1, 1, 1,-1,-1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,
  1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1,-1,-1, 1, 1,-1,-1, 1, 1,
 -1,-1, 1, 1,-1,-1, 1, 1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1,
 -1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1, 1, 1,-1,-1, 1, 1,-1,-1,
  1, 1,-1,-1, 1, 1,-1,-1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,
  1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1,-1,-1, 1, 1,-1,-1, 1, 1,
 -1,-1, 1, 1,-1,-1, 1, 1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1,
 -1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1])
    Cout[28] = exp( num[0] - logZ ) * num[1]
    num = fast_logsumexp(energyTerms, [ 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1,-1, 1,-1, 1,-1, 1,-1, 1,
 -1, 1,-1, 1,-1, 1,-1, 1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1,
 -1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1, 1,-1, 1,-1, 1,-1, 1,-1,
  1,-1, 1,-1, 1,-1, 1,-1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,
  1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1,-1, 1,-1, 1,-1, 1,-1, 1,
 -1, 1,-1, 1,-1, 1,-1, 1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1,
 -1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1, 1,-1, 1,-1, 1,-1, 1,-1,
  1,-1, 1,-1, 1,-1, 1,-1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,
  1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1,-1, 1,-1, 1,-1, 1,-1, 1,
 -1, 1,-1, 1,-1, 1,-1, 1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1,
 -1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1,-1, 1])
    Cout[29] = exp( num[0] - logZ ) * num[1]
    num = fast_logsumexp(energyTerms, [ 1, 1, 1, 1,-1,-1,-1,-1,-1,-1,-1,-1, 1, 1, 1, 1, 1, 1, 1, 1,-1,-1,-1,-1,
 -1,-1,-1,-1, 1, 1, 1, 1, 1, 1, 1, 1,-1,-1,-1,-1,-1,-1,-1,-1, 1, 1, 1, 1,
  1, 1, 1, 1,-1,-1,-1,-1,-1,-1,-1,-1, 1, 1, 1, 1, 1, 1, 1, 1,-1,-1,-1,-1,
 -1,-1,-1,-1, 1, 1, 1, 1, 1, 1, 1, 1,-1,-1,-1,-1,-1,-1,-1,-1, 1, 1, 1, 1,
  1, 1, 1, 1,-1,-1,-1,-1,-1,-1,-1,-1, 1, 1, 1, 1, 1, 1, 1, 1,-1,-1,-1,-1,
 -1,-1,-1,-1, 1, 1, 1, 1, 1, 1, 1, 1,-1,-1,-1,-1,-1,-1,-1,-1, 1, 1, 1, 1,
  1, 1, 1, 1,-1,-1,-1,-1,-1,-1,-1,-1, 1, 1, 1, 1, 1, 1, 1, 1,-1,-1,-1,-1,
 -1,-1,-1,-1, 1, 1, 1, 1, 1, 1, 1, 1,-1,-1,-1,-1,-1,-1,-1,-1, 1, 1, 1, 1,
  1, 1, 1, 1,-1,-1,-1,-1,-1,-1,-1,-1, 1, 1, 1, 1, 1, 1, 1, 1,-1,-1,-1,-1,
 -1,-1,-1,-1, 1, 1, 1, 1, 1, 1, 1, 1,-1,-1,-1,-1,-1,-1,-1,-1, 1, 1, 1, 1,
  1, 1, 1, 1,-1,-1,-1,-1,-1,-1,-1,-1, 1, 1, 1, 1])
    Cout[30] = exp( num[0] - logZ ) * num[1]
    num = fast_logsumexp(energyTerms, [ 1, 1,-1,-1, 1, 1,-1,-1,-1,-1, 1, 1,-1,-1, 1, 1, 1, 1,-1,-1, 1, 1,-1,-1,
 -1,-1, 1, 1,-1,-1, 1, 1, 1, 1,-1,-1, 1, 1,-1,-1,-1,-1, 1, 1,-1,-1, 1, 1,
  1, 1,-1,-1, 1, 1,-1,-1,-1,-1, 1, 1,-1,-1, 1, 1, 1, 1,-1,-1, 1, 1,-1,-1,
 -1,-1, 1, 1,-1,-1, 1, 1, 1, 1,-1,-1, 1, 1,-1,-1,-1,-1, 1, 1,-1,-1, 1, 1,
  1, 1,-1,-1, 1, 1,-1,-1,-1,-1, 1, 1,-1,-1, 1, 1, 1, 1,-1,-1, 1, 1,-1,-1,
 -1,-1, 1, 1,-1,-1, 1, 1, 1, 1,-1,-1, 1, 1,-1,-1,-1,-1, 1, 1,-1,-1, 1, 1,
  1, 1,-1,-1, 1, 1,-1,-1,-1,-1, 1, 1,-1,-1, 1, 1, 1, 1,-1,-1, 1, 1,-1,-1,
 -1,-1, 1, 1,-1,-1, 1, 1, 1, 1,-1,-1, 1, 1,-1,-1,-1,-1, 1, 1,-1,-1, 1, 1,
  1, 1,-1,-1, 1, 1,-1,-1,-1,-1, 1, 1,-1,-1, 1, 1, 1, 1,-1,-1, 1, 1,-1,-1,
 -1,-1, 1, 1,-1,-1, 1, 1, 1, 1,-1,-1, 1, 1,-1,-1,-1,-1, 1, 1,-1,-1, 1, 1,
  1, 1,-1,-1, 1, 1,-1,-1,-1,-1, 1, 1,-1,-1, 1, 1])
    Cout[31] = exp( num[0] - logZ ) * num[1]
    num = fast_logsumexp(energyTerms, [ 1,-1, 1,-1, 1,-1, 1,-1,-1, 1,-1, 1,-1, 1,-1, 1, 1,-1, 1,-1, 1,-1, 1,-1,
 -1, 1,-1, 1,-1, 1,-1, 1, 1,-1, 1,-1, 1,-1, 1,-1,-1, 1,-1, 1,-1, 1,-1, 1,
  1,-1, 1,-1, 1,-1, 1,-1,-1, 1,-1, 1,-1, 1,-1, 1, 1,-1, 1,-1, 1,-1, 1,-1,
 -1, 1,-1, 1,-1, 1,-1, 1, 1,-1, 1,-1, 1,-1, 1,-1,-1, 1,-1, 1,-1, 1,-1, 1,
  1,-1, 1,-1, 1,-1, 1,-1,-1, 1,-1, 1,-1, 1,-1, 1, 1,-1, 1,-1, 1,-1, 1,-1,
 -1, 1,-1, 1,-1, 1,-1, 1, 1,-1, 1,-1, 1,-1, 1,-1,-1, 1,-1, 1,-1, 1,-1, 1,
  1,-1, 1,-1, 1,-1, 1,-1,-1, 1,-1, 1,-1, 1,-1, 1, 1,-1, 1,-1, 1,-1, 1,-1,
 -1, 1,-1, 1,-1, 1,-1, 1, 1,-1, 1,-1, 1,-1, 1,-1,-1, 1,-1, 1,-1, 1,-1, 1,
  1,-1, 1,-1, 1,-1, 1,-1,-1, 1,-1, 1,-1, 1,-1, 1, 1,-1, 1,-1, 1,-1, 1,-1,
 -1, 1,-1, 1,-1, 1,-1, 1, 1,-1, 1,-1, 1,-1, 1,-1,-1, 1,-1, 1,-1, 1,-1, 1,
  1,-1, 1,-1, 1,-1, 1,-1,-1, 1,-1, 1,-1, 1,-1, 1])
    Cout[32] = exp( num[0] - logZ ) * num[1]
    num = fast_logsumexp(energyTerms, [ 1, 1,-1,-1,-1,-1, 1, 1, 1, 1,-1,-1,-1,-1, 1, 1, 1, 1,-1,-1,-1,-1, 1, 1,
  1, 1,-1,-1,-1,-1, 1, 1, 1, 1,-1,-1,-1,-1, 1, 1, 1, 1,-1,-1,-1,-1, 1, 1,
  1, 1,-1,-1,-1,-1, 1, 1, 1, 1,-1,-1,-1,-1, 1, 1, 1, 1,-1,-1,-1,-1, 1, 1,
  1, 1,-1,-1,-1,-1, 1, 1, 1, 1,-1,-1,-1,-1, 1, 1, 1, 1,-1,-1,-1,-1, 1, 1,
  1, 1,-1,-1,-1,-1, 1, 1, 1, 1,-1,-1,-1,-1, 1, 1, 1, 1,-1,-1,-1,-1, 1, 1,
  1, 1,-1,-1,-1,-1, 1, 1, 1, 1,-1,-1,-1,-1, 1, 1, 1, 1,-1,-1,-1,-1, 1, 1,
  1, 1,-1,-1,-1,-1, 1, 1, 1, 1,-1,-1,-1,-1, 1, 1, 1, 1,-1,-1,-1,-1, 1, 1,
  1, 1,-1,-1,-1,-1, 1, 1, 1, 1,-1,-1,-1,-1, 1, 1, 1, 1,-1,-1,-1,-1, 1, 1,
  1, 1,-1,-1,-1,-1, 1, 1, 1, 1,-1,-1,-1,-1, 1, 1, 1, 1,-1,-1,-1,-1, 1, 1,
  1, 1,-1,-1,-1,-1, 1, 1, 1, 1,-1,-1,-1,-1, 1, 1, 1, 1,-1,-1,-1,-1, 1, 1,
  1, 1,-1,-1,-1,-1, 1, 1, 1, 1,-1,-1,-1,-1, 1, 1])
    Cout[33] = exp( num[0] - logZ ) * num[1]
    num = fast_logsumexp(energyTerms, [ 1,-1, 1,-1,-1, 1,-1, 1, 1,-1, 1,-1,-1, 1,-1, 1, 1,-1, 1,-1,-1, 1,-1, 1,
  1,-1, 1,-1,-1, 1,-1, 1, 1,-1, 1,-1,-1, 1,-1, 1, 1,-1, 1,-1,-1, 1,-1, 1,
  1,-1, 1,-1,-1, 1,-1, 1, 1,-1, 1,-1,-1, 1,-1, 1, 1,-1, 1,-1,-1, 1,-1, 1,
  1,-1, 1,-1,-1, 1,-1, 1, 1,-1, 1,-1,-1, 1,-1, 1, 1,-1, 1,-1,-1, 1,-1, 1,
  1,-1, 1,-1,-1, 1,-1, 1, 1,-1, 1,-1,-1, 1,-1, 1, 1,-1, 1,-1,-1, 1,-1, 1,
  1,-1, 1,-1,-1, 1,-1, 1, 1,-1, 1,-1,-1, 1,-1, 1, 1,-1, 1,-1,-1, 1,-1, 1,
  1,-1, 1,-1,-1, 1,-1, 1, 1,-1, 1,-1,-1, 1,-1, 1, 1,-1, 1,-1,-1, 1,-1, 1,
  1,-1, 1,-1,-1, 1,-1, 1, 1,-1, 1,-1,-1, 1,-1, 1, 1,-1, 1,-1,-1, 1,-1, 1,
  1,-1, 1,-1,-1, 1,-1, 1, 1,-1, 1,-1,-1, 1,-1, 1, 1,-1, 1,-1,-1, 1,-1, 1,
  1,-1, 1,-1,-1, 1,-1, 1, 1,-1, 1,-1,-1, 1,-1, 1, 1,-1, 1,-1,-1, 1,-1, 1,
  1,-1, 1,-1,-1, 1,-1, 1, 1,-1, 1,-1,-1, 1,-1, 1])
    Cout[34] = exp( num[0] - logZ ) * num[1]
    num = fast_logsumexp(energyTerms, [ 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1,
  1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1,
  1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1,
  1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1,
  1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1,
  1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1,
  1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1,
  1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1,
  1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1,
  1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1,
  1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1, 1,-1,-1, 1])
    Cout[35] = exp( num[0] - logZ ) * num[1]
    Cout[isnan(Cout)] = 0.
    return(Cout)

def p(params):
    """
    Give all parameters concatenated into one array from lowest to highest order.
    Returns probabilities of all configurations.
    """
    Cout = zeros((36))
    H = params[0:8]
    J = params[8:36]
    H = params[0:8]
    J = params[8:36]
    Pout = zeros((256))
    energyTerms = array([    +H[0]+H[1]+H[2]+H[3]+H[4]+H[5]+H[6]+H[7]+J[0]+J[1]+J[2]+J[3]+J[4]+J[5]+J[6]+J[7]+J[8]+J[9]+J[10]+J[11]+
    J[12]+J[13]+J[14]+J[15]+J[16]+J[17]+J[18]+J[19]+J[20]+J[21]+J[22]+J[23]+J[24]+J[25]+J[26]+J[27], +H[0]+
    H[1]+H[2]+H[3]+H[4]+H[5]+H[6]-H[7]+J[0]+J[1]+J[2]+J[3]+J[4]+J[5]-J[6]+J[7]+J[8]+J[9]+J[10]+J[11]-J[12]+
    J[13]+J[14]+J[15]+J[16]-J[17]+J[18]+J[19]+J[20]-J[21]+J[22]+J[23]-J[24]+J[25]-J[26]-J[27], +H[0]+H[1]+
    H[2]+H[3]+H[4]+H[5]-H[6]+H[7]+J[0]+J[1]+J[2]+J[3]+J[4]-J[5]+J[6]+J[7]+J[8]+J[9]+J[10]-J[11]+J[12]+J[13]+
    J[14]+J[15]-J[16]+J[17]+J[18]+J[19]-J[20]+J[21]+J[22]-J[23]+J[24]-J[25]+J[26]-J[27], +H[0]+H[1]+H[2]+
    H[3]+H[4]+H[5]-H[6]-H[7]+J[0]+J[1]+J[2]+J[3]+J[4]-J[5]-J[6]+J[7]+J[8]+J[9]+J[10]-J[11]-J[12]+J[13]+J[14]+
    J[15]-J[16]-J[17]+J[18]+J[19]-J[20]-J[21]+J[22]-J[23]-J[24]-J[25]-J[26]+J[27], +H[0]+H[1]+H[2]+H[3]+
    H[4]-H[5]+H[6]+H[7]+J[0]+J[1]+J[2]+J[3]-J[4]+J[5]+J[6]+J[7]+J[8]+J[9]-J[10]+J[11]+J[12]+J[13]+J[14]-J[15]+
    J[16]+J[17]+J[18]-J[19]+J[20]+J[21]-J[22]+J[23]+J[24]-J[25]-J[26]+J[27], +H[0]+H[1]+H[2]+H[3]+H[4]-H[5]+
    H[6]-H[7]+J[0]+J[1]+J[2]+J[3]-J[4]+J[5]-J[6]+J[7]+J[8]+J[9]-J[10]+J[11]-J[12]+J[13]+J[14]-J[15]+J[16]-J[17]+
    J[18]-J[19]+J[20]-J[21]-J[22]+J[23]-J[24]-J[25]+J[26]-J[27], +H[0]+H[1]+H[2]+H[3]+H[4]-H[5]-H[6]+H[7]+
    J[0]+J[1]+J[2]+J[3]-J[4]-J[5]+J[6]+J[7]+J[8]+J[9]-J[10]-J[11]+J[12]+J[13]+J[14]-J[15]-J[16]+J[17]+J[18]-J[19]-J[20]+
    J[21]-J[22]-J[23]+J[24]+J[25]-J[26]-J[27], +H[0]+H[1]+H[2]+H[3]+H[4]-H[5]-H[6]-H[7]+J[0]+J[1]+J[2]+J[3]-J[4]-J[5]-J[6]+
    J[7]+J[8]+J[9]-J[10]-J[11]-J[12]+J[13]+J[14]-J[15]-J[16]-J[17]+J[18]-J[19]-J[20]-J[21]-J[22]-J[23]-J[24]+
    J[25]+J[26]+J[27], +H[0]+H[1]+H[2]+H[3]-H[4]+H[5]+H[6]+H[7]+J[0]+J[1]+J[2]-J[3]+J[4]+J[5]+J[6]+J[7]+
    J[8]-J[9]+J[10]+J[11]+J[12]+J[13]-J[14]+J[15]+J[16]+J[17]-J[18]+J[19]+J[20]+J[21]-J[22]-J[23]-J[24]+
    J[25]+J[26]+J[27], +H[0]+H[1]+H[2]+H[3]-H[4]+H[5]+H[6]-H[7]+J[0]+J[1]+J[2]-J[3]+J[4]+J[5]-J[6]+J[7]+
    J[8]-J[9]+J[10]+J[11]-J[12]+J[13]-J[14]+J[15]+J[16]-J[17]-J[18]+J[19]+J[20]-J[21]-J[22]-J[23]+J[24]+
    J[25]-J[26]-J[27], +H[0]+H[1]+H[2]+H[3]-H[4]+H[5]-H[6]+H[7]+J[0]+J[1]+J[2]-J[3]+J[4]-J[5]+J[6]+J[7]+
    J[8]-J[9]+J[10]-J[11]+J[12]+J[13]-J[14]+J[15]-J[16]+J[17]-J[18]+J[19]-J[20]+J[21]-J[22]+J[23]-J[24]-J[25]+
    J[26]-J[27], +H[0]+H[1]+H[2]+H[3]-H[4]+H[5]-H[6]-H[7]+J[0]+J[1]+J[2]-J[3]+J[4]-J[5]-J[6]+J[7]+J[8]-J[9]+
    J[10]-J[11]-J[12]+J[13]-J[14]+J[15]-J[16]-J[17]-J[18]+J[19]-J[20]-J[21]-J[22]+J[23]+J[24]-J[25]-J[26]+
    J[27], +H[0]+H[1]+H[2]+H[3]-H[4]-H[5]+H[6]+H[7]+J[0]+J[1]+J[2]-J[3]-J[4]+J[5]+J[6]+J[7]+J[8]-J[9]-J[10]+
    J[11]+J[12]+J[13]-J[14]-J[15]+J[16]+J[17]-J[18]-J[19]+J[20]+J[21]+J[22]-J[23]-J[24]-J[25]-J[26]+J[27], +
    H[0]+H[1]+H[2]+H[3]-H[4]-H[5]+H[6]-H[7]+J[0]+J[1]+J[2]-J[3]-J[4]+J[5]-J[6]+J[7]+J[8]-J[9]-J[10]+J[11]-J[12]+
    J[13]-J[14]-J[15]+J[16]-J[17]-J[18]-J[19]+J[20]-J[21]+J[22]-J[23]+J[24]-J[25]+J[26]-J[27], +H[0]+H[1]+
    H[2]+H[3]-H[4]-H[5]-H[6]+H[7]+J[0]+J[1]+J[2]-J[3]-J[4]-J[5]+J[6]+J[7]+J[8]-J[9]-J[10]-J[11]+J[12]+J[13]-J[14]-J[15]-J[16]+
    J[17]-J[18]-J[19]-J[20]+J[21]+J[22]+J[23]-J[24]+J[25]-J[26]-J[27], +H[0]+H[1]+H[2]+H[3]-H[4]-H[5]-H[6]-H[7]+
    J[0]+J[1]+J[2]-J[3]-J[4]-J[5]-J[6]+J[7]+J[8]-J[9]-J[10]-J[11]-J[12]+J[13]-J[14]-J[15]-J[16]-J[17]-J[18]-J[19]-J[20]-J[21]+
    J[22]+J[23]+J[24]+J[25]+J[26]+J[27], +H[0]+H[1]+H[2]-H[3]+H[4]+H[5]+H[6]+H[7]+J[0]+J[1]-J[2]+J[3]+J[4]+
    J[5]+J[6]+J[7]-J[8]+J[9]+J[10]+J[11]+J[12]-J[13]+J[14]+J[15]+J[16]+J[17]-J[18]-J[19]-J[20]-J[21]+J[22]+
    J[23]+J[24]+J[25]+J[26]+J[27], +H[0]+H[1]+H[2]-H[3]+H[4]+H[5]+H[6]-H[7]+J[0]+J[1]-J[2]+J[3]+J[4]+J[5]-J[6]+
    J[7]-J[8]+J[9]+J[10]+J[11]-J[12]-J[13]+J[14]+J[15]+J[16]-J[17]-J[18]-J[19]-J[20]+J[21]+J[22]+J[23]-J[24]+
    J[25]-J[26]-J[27], +H[0]+H[1]+H[2]-H[3]+H[4]+H[5]-H[6]+H[7]+J[0]+J[1]-J[2]+J[3]+J[4]-J[5]+J[6]+J[7]-J[8]+
    J[9]+J[10]-J[11]+J[12]-J[13]+J[14]+J[15]-J[16]+J[17]-J[18]-J[19]+J[20]-J[21]+J[22]-J[23]+J[24]-J[25]+
    J[26]-J[27], +H[0]+H[1]+H[2]-H[3]+H[4]+H[5]-H[6]-H[7]+J[0]+J[1]-J[2]+J[3]+J[4]-J[5]-J[6]+J[7]-J[8]+J[9]+
    J[10]-J[11]-J[12]-J[13]+J[14]+J[15]-J[16]-J[17]-J[18]-J[19]+J[20]+J[21]+J[22]-J[23]-J[24]-J[25]-J[26]+
    J[27], +H[0]+H[1]+H[2]-H[3]+H[4]-H[5]+H[6]+H[7]+J[0]+J[1]-J[2]+J[3]-J[4]+J[5]+J[6]+J[7]-J[8]+J[9]-J[10]+
    J[11]+J[12]-J[13]+J[14]-J[15]+J[16]+J[17]-J[18]+J[19]-J[20]-J[21]-J[22]+J[23]+J[24]-J[25]-J[26]+J[27], +
    H[0]+H[1]+H[2]-H[3]+H[4]-H[5]+H[6]-H[7]+J[0]+J[1]-J[2]+J[3]-J[4]+J[5]-J[6]+J[7]-J[8]+J[9]-J[10]+J[11]-J[12]-J[13]+
    J[14]-J[15]+J[16]-J[17]-J[18]+J[19]-J[20]+J[21]-J[22]+J[23]-J[24]-J[25]+J[26]-J[27], +H[0]+H[1]+H[2]-H[3]+
    H[4]-H[5]-H[6]+H[7]+J[0]+J[1]-J[2]+J[3]-J[4]-J[5]+J[6]+J[7]-J[8]+J[9]-J[10]-J[11]+J[12]-J[13]+J[14]-J[15]-J[16]+
    J[17]-J[18]+J[19]+J[20]-J[21]-J[22]-J[23]+J[24]+J[25]-J[26]-J[27], +H[0]+H[1]+H[2]-H[3]+H[4]-H[5]-H[6]-H[7]+
    J[0]+J[1]-J[2]+J[3]-J[4]-J[5]-J[6]+J[7]-J[8]+J[9]-J[10]-J[11]-J[12]-J[13]+J[14]-J[15]-J[16]-J[17]-J[18]+
    J[19]+J[20]+J[21]-J[22]-J[23]-J[24]+J[25]+J[26]+J[27], +H[0]+H[1]+H[2]-H[3]-H[4]+H[5]+H[6]+H[7]+J[0]+
    J[1]-J[2]-J[3]+J[4]+J[5]+J[6]+J[7]-J[8]-J[9]+J[10]+J[11]+J[12]-J[13]-J[14]+J[15]+J[16]+J[17]+J[18]-J[19]-J[20]-J[21]-J[22]-J[23]-J[24]+
    J[25]+J[26]+J[27], +H[0]+H[1]+H[2]-H[3]-H[4]+H[5]+H[6]-H[7]+J[0]+J[1]-J[2]-J[3]+J[4]+J[5]-J[6]+J[7]-J[8]-J[9]+
    J[10]+J[11]-J[12]-J[13]-J[14]+J[15]+J[16]-J[17]+J[18]-J[19]-J[20]+J[21]-J[22]-J[23]+J[24]+J[25]-J[26]-J[27], +
    H[0]+H[1]+H[2]-H[3]-H[4]+H[5]-H[6]+H[7]+J[0]+J[1]-J[2]-J[3]+J[4]-J[5]+J[6]+J[7]-J[8]-J[9]+J[10]-J[11]+
    J[12]-J[13]-J[14]+J[15]-J[16]+J[17]+J[18]-J[19]+J[20]-J[21]-J[22]+J[23]-J[24]-J[25]+J[26]-J[27], +H[0]+
    H[1]+H[2]-H[3]-H[4]+H[5]-H[6]-H[7]+J[0]+J[1]-J[2]-J[3]+J[4]-J[5]-J[6]+J[7]-J[8]-J[9]+J[10]-J[11]-J[12]-J[13]-J[14]+
    J[15]-J[16]-J[17]+J[18]-J[19]+J[20]+J[21]-J[22]+J[23]+J[24]-J[25]-J[26]+J[27], +H[0]+H[1]+H[2]-H[3]-H[4]-H[5]+
    H[6]+H[7]+J[0]+J[1]-J[2]-J[3]-J[4]+J[5]+J[6]+J[7]-J[8]-J[9]-J[10]+J[11]+J[12]-J[13]-J[14]-J[15]+J[16]+
    J[17]+J[18]+J[19]-J[20]-J[21]+J[22]-J[23]-J[24]-J[25]-J[26]+J[27], +H[0]+H[1]+H[2]-H[3]-H[4]-H[5]+H[6]-H[7]+
    J[0]+J[1]-J[2]-J[3]-J[4]+J[5]-J[6]+J[7]-J[8]-J[9]-J[10]+J[11]-J[12]-J[13]-J[14]-J[15]+J[16]-J[17]+J[18]+
    J[19]-J[20]+J[21]+J[22]-J[23]+J[24]-J[25]+J[26]-J[27], +H[0]+H[1]+H[2]-H[3]-H[4]-H[5]-H[6]+H[7]+J[0]+
    J[1]-J[2]-J[3]-J[4]-J[5]+J[6]+J[7]-J[8]-J[9]-J[10]-J[11]+J[12]-J[13]-J[14]-J[15]-J[16]+J[17]+J[18]+J[19]+
    J[20]-J[21]+J[22]+J[23]-J[24]+J[25]-J[26]-J[27], +H[0]+H[1]+H[2]-H[3]-H[4]-H[5]-H[6]-H[7]+J[0]+J[1]-J[2]-J[3]-J[4]-J[5]-J[6]+
    J[7]-J[8]-J[9]-J[10]-J[11]-J[12]-J[13]-J[14]-J[15]-J[16]-J[17]+J[18]+J[19]+J[20]+J[21]+J[22]+J[23]+J[24]+
    J[25]+J[26]+J[27], +H[0]+H[1]-H[2]+H[3]+H[4]+H[5]+H[6]+H[7]+J[0]-J[1]+J[2]+J[3]+J[4]+J[5]+J[6]-J[7]+
    J[8]+J[9]+J[10]+J[11]+J[12]-J[13]-J[14]-J[15]-J[16]-J[17]+J[18]+J[19]+J[20]+J[21]+J[22]+J[23]+J[24]+
    J[25]+J[26]+J[27], +H[0]+H[1]-H[2]+H[3]+H[4]+H[5]+H[6]-H[7]+J[0]-J[1]+J[2]+J[3]+J[4]+J[5]-J[6]-J[7]+
    J[8]+J[9]+J[10]+J[11]-J[12]-J[13]-J[14]-J[15]-J[16]+J[17]+J[18]+J[19]+J[20]-J[21]+J[22]+J[23]-J[24]+
    J[25]-J[26]-J[27], +H[0]+H[1]-H[2]+H[3]+H[4]+H[5]-H[6]+H[7]+J[0]-J[1]+J[2]+J[3]+J[4]-J[5]+J[6]-J[7]+
    J[8]+J[9]+J[10]-J[11]+J[12]-J[13]-J[14]-J[15]+J[16]-J[17]+J[18]+J[19]-J[20]+J[21]+J[22]-J[23]+J[24]-J[25]+
    J[26]-J[27], +H[0]+H[1]-H[2]+H[3]+H[4]+H[5]-H[6]-H[7]+J[0]-J[1]+J[2]+J[3]+J[4]-J[5]-J[6]-J[7]+J[8]+J[9]+
    J[10]-J[11]-J[12]-J[13]-J[14]-J[15]+J[16]+J[17]+J[18]+J[19]-J[20]-J[21]+J[22]-J[23]-J[24]-J[25]-J[26]+
    J[27], +H[0]+H[1]-H[2]+H[3]+H[4]-H[5]+H[6]+H[7]+J[0]-J[1]+J[2]+J[3]-J[4]+J[5]+J[6]-J[7]+J[8]+J[9]-J[10]+
    J[11]+J[12]-J[13]-J[14]+J[15]-J[16]-J[17]+J[18]-J[19]+J[20]+J[21]-J[22]+J[23]+J[24]-J[25]-J[26]+J[27], +
    H[0]+H[1]-H[2]+H[3]+H[4]-H[5]+H[6]-H[7]+J[0]-J[1]+J[2]+J[3]-J[4]+J[5]-J[6]-J[7]+J[8]+J[9]-J[10]+J[11]-J[12]-J[13]-J[14]+
    J[15]-J[16]+J[17]+J[18]-J[19]+J[20]-J[21]-J[22]+J[23]-J[24]-J[25]+J[26]-J[27], +H[0]+H[1]-H[2]+H[3]+
    H[4]-H[5]-H[6]+H[7]+J[0]-J[1]+J[2]+J[3]-J[4]-J[5]+J[6]-J[7]+J[8]+J[9]-J[10]-J[11]+J[12]-J[13]-J[14]+
    J[15]+J[16]-J[17]+J[18]-J[19]-J[20]+J[21]-J[22]-J[23]+J[24]+J[25]-J[26]-J[27], +H[0]+H[1]-H[2]+H[3]+
    H[4]-H[5]-H[6]-H[7]+J[0]-J[1]+J[2]+J[3]-J[4]-J[5]-J[6]-J[7]+J[8]+J[9]-J[10]-J[11]-J[12]-J[13]-J[14]+
    J[15]+J[16]+J[17]+J[18]-J[19]-J[20]-J[21]-J[22]-J[23]-J[24]+J[25]+J[26]+J[27], +H[0]+H[1]-H[2]+H[3]-H[4]+
    H[5]+H[6]+H[7]+J[0]-J[1]+J[2]-J[3]+J[4]+J[5]+J[6]-J[7]+J[8]-J[9]+J[10]+J[11]+J[12]-J[13]+J[14]-J[15]-J[16]-J[17]-J[18]+
    J[19]+J[20]+J[21]-J[22]-J[23]-J[24]+J[25]+J[26]+J[27], +H[0]+H[1]-H[2]+H[3]-H[4]+H[5]+H[6]-H[7]+J[0]-J[1]+
    J[2]-J[3]+J[4]+J[5]-J[6]-J[7]+J[8]-J[9]+J[10]+J[11]-J[12]-J[13]+J[14]-J[15]-J[16]+J[17]-J[18]+J[19]+
    J[20]-J[21]-J[22]-J[23]+J[24]+J[25]-J[26]-J[27], +H[0]+H[1]-H[2]+H[3]-H[4]+H[5]-H[6]+H[7]+J[0]-J[1]+
    J[2]-J[3]+J[4]-J[5]+J[6]-J[7]+J[8]-J[9]+J[10]-J[11]+J[12]-J[13]+J[14]-J[15]+J[16]-J[17]-J[18]+J[19]-J[20]+
    J[21]-J[22]+J[23]-J[24]-J[25]+J[26]-J[27], +H[0]+H[1]-H[2]+H[3]-H[4]+H[5]-H[6]-H[7]+J[0]-J[1]+J[2]-J[3]+
    J[4]-J[5]-J[6]-J[7]+J[8]-J[9]+J[10]-J[11]-J[12]-J[13]+J[14]-J[15]+J[16]+J[17]-J[18]+J[19]-J[20]-J[21]-J[22]+
    J[23]+J[24]-J[25]-J[26]+J[27], +H[0]+H[1]-H[2]+H[3]-H[4]-H[5]+H[6]+H[7]+J[0]-J[1]+J[2]-J[3]-J[4]+J[5]+
    J[6]-J[7]+J[8]-J[9]-J[10]+J[11]+J[12]-J[13]+J[14]+J[15]-J[16]-J[17]-J[18]-J[19]+J[20]+J[21]+J[22]-J[23]-J[24]-J[25]-J[26]+
    J[27], +H[0]+H[1]-H[2]+H[3]-H[4]-H[5]+H[6]-H[7]+J[0]-J[1]+J[2]-J[3]-J[4]+J[5]-J[6]-J[7]+J[8]-J[9]-J[10]+
    J[11]-J[12]-J[13]+J[14]+J[15]-J[16]+J[17]-J[18]-J[19]+J[20]-J[21]+J[22]-J[23]+J[24]-J[25]+J[26]-J[27], +
    H[0]+H[1]-H[2]+H[3]-H[4]-H[5]-H[6]+H[7]+J[0]-J[1]+J[2]-J[3]-J[4]-J[5]+J[6]-J[7]+J[8]-J[9]-J[10]-J[11]+
    J[12]-J[13]+J[14]+J[15]+J[16]-J[17]-J[18]-J[19]-J[20]+J[21]+J[22]+J[23]-J[24]+J[25]-J[26]-J[27], +H[0]+
    H[1]-H[2]+H[3]-H[4]-H[5]-H[6]-H[7]+J[0]-J[1]+J[2]-J[3]-J[4]-J[5]-J[6]-J[7]+J[8]-J[9]-J[10]-J[11]-J[12]-J[13]+
    J[14]+J[15]+J[16]+J[17]-J[18]-J[19]-J[20]-J[21]+J[22]+J[23]+J[24]+J[25]+J[26]+J[27], +H[0]+H[1]-H[2]-H[3]+
    H[4]+H[5]+H[6]+H[7]+J[0]-J[1]-J[2]+J[3]+J[4]+J[5]+J[6]-J[7]-J[8]+J[9]+J[10]+J[11]+J[12]+J[13]-J[14]-J[15]-J[16]-J[17]-J[18]-J[19]-J[20]-J[21]+
    J[22]+J[23]+J[24]+J[25]+J[26]+J[27], +H[0]+H[1]-H[2]-H[3]+H[4]+H[5]+H[6]-H[7]+J[0]-J[1]-J[2]+J[3]+J[4]+
    J[5]-J[6]-J[7]-J[8]+J[9]+J[10]+J[11]-J[12]+J[13]-J[14]-J[15]-J[16]+J[17]-J[18]-J[19]-J[20]+J[21]+J[22]+
    J[23]-J[24]+J[25]-J[26]-J[27], +H[0]+H[1]-H[2]-H[3]+H[4]+H[5]-H[6]+H[7]+J[0]-J[1]-J[2]+J[3]+J[4]-J[5]+
    J[6]-J[7]-J[8]+J[9]+J[10]-J[11]+J[12]+J[13]-J[14]-J[15]+J[16]-J[17]-J[18]-J[19]+J[20]-J[21]+J[22]-J[23]+
    J[24]-J[25]+J[26]-J[27], +H[0]+H[1]-H[2]-H[3]+H[4]+H[5]-H[6]-H[7]+J[0]-J[1]-J[2]+J[3]+J[4]-J[5]-J[6]-J[7]-J[8]+
    J[9]+J[10]-J[11]-J[12]+J[13]-J[14]-J[15]+J[16]+J[17]-J[18]-J[19]+J[20]+J[21]+J[22]-J[23]-J[24]-J[25]-J[26]+
    J[27], +H[0]+H[1]-H[2]-H[3]+H[4]-H[5]+H[6]+H[7]+J[0]-J[1]-J[2]+J[3]-J[4]+J[5]+J[6]-J[7]-J[8]+J[9]-J[10]+
    J[11]+J[12]+J[13]-J[14]+J[15]-J[16]-J[17]-J[18]+J[19]-J[20]-J[21]-J[22]+J[23]+J[24]-J[25]-J[26]+J[27], +
    H[0]+H[1]-H[2]-H[3]+H[4]-H[5]+H[6]-H[7]+J[0]-J[1]-J[2]+J[3]-J[4]+J[5]-J[6]-J[7]-J[8]+J[9]-J[10]+J[11]-J[12]+
    J[13]-J[14]+J[15]-J[16]+J[17]-J[18]+J[19]-J[20]+J[21]-J[22]+J[23]-J[24]-J[25]+J[26]-J[27], +H[0]+H[1]-H[2]-H[3]+
    H[4]-H[5]-H[6]+H[7]+J[0]-J[1]-J[2]+J[3]-J[4]-J[5]+J[6]-J[7]-J[8]+J[9]-J[10]-J[11]+J[12]+J[13]-J[14]+
    J[15]+J[16]-J[17]-J[18]+J[19]+J[20]-J[21]-J[22]-J[23]+J[24]+J[25]-J[26]-J[27], +H[0]+H[1]-H[2]-H[3]+
    H[4]-H[5]-H[6]-H[7]+J[0]-J[1]-J[2]+J[3]-J[4]-J[5]-J[6]-J[7]-J[8]+J[9]-J[10]-J[11]-J[12]+J[13]-J[14]+
    J[15]+J[16]+J[17]-J[18]+J[19]+J[20]+J[21]-J[22]-J[23]-J[24]+J[25]+J[26]+J[27], +H[0]+H[1]-H[2]-H[3]-H[4]+
    H[5]+H[6]+H[7]+J[0]-J[1]-J[2]-J[3]+J[4]+J[5]+J[6]-J[7]-J[8]-J[9]+J[10]+J[11]+J[12]+J[13]+J[14]-J[15]-J[16]-J[17]+
    J[18]-J[19]-J[20]-J[21]-J[22]-J[23]-J[24]+J[25]+J[26]+J[27], +H[0]+H[1]-H[2]-H[3]-H[4]+H[5]+H[6]-H[7]+
    J[0]-J[1]-J[2]-J[3]+J[4]+J[5]-J[6]-J[7]-J[8]-J[9]+J[10]+J[11]-J[12]+J[13]+J[14]-J[15]-J[16]+J[17]+J[18]-J[19]-J[20]+
    J[21]-J[22]-J[23]+J[24]+J[25]-J[26]-J[27], +H[0]+H[1]-H[2]-H[3]-H[4]+H[5]-H[6]+H[7]+J[0]-J[1]-J[2]-J[3]+
    J[4]-J[5]+J[6]-J[7]-J[8]-J[9]+J[10]-J[11]+J[12]+J[13]+J[14]-J[15]+J[16]-J[17]+J[18]-J[19]+J[20]-J[21]-J[22]+
    J[23]-J[24]-J[25]+J[26]-J[27], +H[0]+H[1]-H[2]-H[3]-H[4]+H[5]-H[6]-H[7]+J[0]-J[1]-J[2]-J[3]+J[4]-J[5]-J[6]-J[7]-J[8]-J[9]+
    J[10]-J[11]-J[12]+J[13]+J[14]-J[15]+J[16]+J[17]+J[18]-J[19]+J[20]+J[21]-J[22]+J[23]+J[24]-J[25]-J[26]+
    J[27], +H[0]+H[1]-H[2]-H[3]-H[4]-H[5]+H[6]+H[7]+J[0]-J[1]-J[2]-J[3]-J[4]+J[5]+J[6]-J[7]-J[8]-J[9]-J[10]+
    J[11]+J[12]+J[13]+J[14]+J[15]-J[16]-J[17]+J[18]+J[19]-J[20]-J[21]+J[22]-J[23]-J[24]-J[25]-J[26]+J[27], +
    H[0]+H[1]-H[2]-H[3]-H[4]-H[5]+H[6]-H[7]+J[0]-J[1]-J[2]-J[3]-J[4]+J[5]-J[6]-J[7]-J[8]-J[9]-J[10]+J[11]-J[12]+
    J[13]+J[14]+J[15]-J[16]+J[17]+J[18]+J[19]-J[20]+J[21]+J[22]-J[23]+J[24]-J[25]+J[26]-J[27], +H[0]+H[1]-H[2]-H[3]-H[4]-H[5]-H[6]+
    H[7]+J[0]-J[1]-J[2]-J[3]-J[4]-J[5]+J[6]-J[7]-J[8]-J[9]-J[10]-J[11]+J[12]+J[13]+J[14]+J[15]+J[16]-J[17]+
    J[18]+J[19]+J[20]-J[21]+J[22]+J[23]-J[24]+J[25]-J[26]-J[27], +H[0]+H[1]-H[2]-H[3]-H[4]-H[5]-H[6]-H[7]+
    J[0]-J[1]-J[2]-J[3]-J[4]-J[5]-J[6]-J[7]-J[8]-J[9]-J[10]-J[11]-J[12]+J[13]+J[14]+J[15]+J[16]+J[17]+J[18]+
    J[19]+J[20]+J[21]+J[22]+J[23]+J[24]+J[25]+J[26]+J[27], +H[0]-H[1]+H[2]+H[3]+H[4]+H[5]+H[6]+H[7]-J[0]+
    J[1]+J[2]+J[3]+J[4]+J[5]+J[6]-J[7]-J[8]-J[9]-J[10]-J[11]-J[12]+J[13]+J[14]+J[15]+J[16]+J[17]+J[18]+J[19]+
    J[20]+J[21]+J[22]+J[23]+J[24]+J[25]+J[26]+J[27], +H[0]-H[1]+H[2]+H[3]+H[4]+H[5]+H[6]-H[7]-J[0]+J[1]+
    J[2]+J[3]+J[4]+J[5]-J[6]-J[7]-J[8]-J[9]-J[10]-J[11]+J[12]+J[13]+J[14]+J[15]+J[16]-J[17]+J[18]+J[19]+
    J[20]-J[21]+J[22]+J[23]-J[24]+J[25]-J[26]-J[27], +H[0]-H[1]+H[2]+H[3]+H[4]+H[5]-H[6]+H[7]-J[0]+J[1]+
    J[2]+J[3]+J[4]-J[5]+J[6]-J[7]-J[8]-J[9]-J[10]+J[11]-J[12]+J[13]+J[14]+J[15]-J[16]+J[17]+J[18]+J[19]-J[20]+
    J[21]+J[22]-J[23]+J[24]-J[25]+J[26]-J[27], +H[0]-H[1]+H[2]+H[3]+H[4]+H[5]-H[6]-H[7]-J[0]+J[1]+J[2]+J[3]+
    J[4]-J[5]-J[6]-J[7]-J[8]-J[9]-J[10]+J[11]+J[12]+J[13]+J[14]+J[15]-J[16]-J[17]+J[18]+J[19]-J[20]-J[21]+
    J[22]-J[23]-J[24]-J[25]-J[26]+J[27], +H[0]-H[1]+H[2]+H[3]+H[4]-H[5]+H[6]+H[7]-J[0]+J[1]+J[2]+J[3]-J[4]+
    J[5]+J[6]-J[7]-J[8]-J[9]+J[10]-J[11]-J[12]+J[13]+J[14]-J[15]+J[16]+J[17]+J[18]-J[19]+J[20]+J[21]-J[22]+
    J[23]+J[24]-J[25]-J[26]+J[27], +H[0]-H[1]+H[2]+H[3]+H[4]-H[5]+H[6]-H[7]-J[0]+J[1]+J[2]+J[3]-J[4]+J[5]-J[6]-J[7]-J[8]-J[9]+
    J[10]-J[11]+J[12]+J[13]+J[14]-J[15]+J[16]-J[17]+J[18]-J[19]+J[20]-J[21]-J[22]+J[23]-J[24]-J[25]+J[26]-J[27], +
    H[0]-H[1]+H[2]+H[3]+H[4]-H[5]-H[6]+H[7]-J[0]+J[1]+J[2]+J[3]-J[4]-J[5]+J[6]-J[7]-J[8]-J[9]+J[10]+J[11]-J[12]+
    J[13]+J[14]-J[15]-J[16]+J[17]+J[18]-J[19]-J[20]+J[21]-J[22]-J[23]+J[24]+J[25]-J[26]-J[27], +H[0]-H[1]+
    H[2]+H[3]+H[4]-H[5]-H[6]-H[7]-J[0]+J[1]+J[2]+J[3]-J[4]-J[5]-J[6]-J[7]-J[8]-J[9]+J[10]+J[11]+J[12]+J[13]+
    J[14]-J[15]-J[16]-J[17]+J[18]-J[19]-J[20]-J[21]-J[22]-J[23]-J[24]+J[25]+J[26]+J[27], +H[0]-H[1]+H[2]+
    H[3]-H[4]+H[5]+H[6]+H[7]-J[0]+J[1]+J[2]-J[3]+J[4]+J[5]+J[6]-J[7]-J[8]+J[9]-J[10]-J[11]-J[12]+J[13]-J[14]+
    J[15]+J[16]+J[17]-J[18]+J[19]+J[20]+J[21]-J[22]-J[23]-J[24]+J[25]+J[26]+J[27], +H[0]-H[1]+H[2]+H[3]-H[4]+
    H[5]+H[6]-H[7]-J[0]+J[1]+J[2]-J[3]+J[4]+J[5]-J[6]-J[7]-J[8]+J[9]-J[10]-J[11]+J[12]+J[13]-J[14]+J[15]+
    J[16]-J[17]-J[18]+J[19]+J[20]-J[21]-J[22]-J[23]+J[24]+J[25]-J[26]-J[27], +H[0]-H[1]+H[2]+H[3]-H[4]+H[5]-H[6]+
    H[7]-J[0]+J[1]+J[2]-J[3]+J[4]-J[5]+J[6]-J[7]-J[8]+J[9]-J[10]+J[11]-J[12]+J[13]-J[14]+J[15]-J[16]+J[17]-J[18]+
    J[19]-J[20]+J[21]-J[22]+J[23]-J[24]-J[25]+J[26]-J[27], +H[0]-H[1]+H[2]+H[3]-H[4]+H[5]-H[6]-H[7]-J[0]+
    J[1]+J[2]-J[3]+J[4]-J[5]-J[6]-J[7]-J[8]+J[9]-J[10]+J[11]+J[12]+J[13]-J[14]+J[15]-J[16]-J[17]-J[18]+J[19]-J[20]-J[21]-J[22]+
    J[23]+J[24]-J[25]-J[26]+J[27], +H[0]-H[1]+H[2]+H[3]-H[4]-H[5]+H[6]+H[7]-J[0]+J[1]+J[2]-J[3]-J[4]+J[5]+
    J[6]-J[7]-J[8]+J[9]+J[10]-J[11]-J[12]+J[13]-J[14]-J[15]+J[16]+J[17]-J[18]-J[19]+J[20]+J[21]+J[22]-J[23]-J[24]-J[25]-J[26]+
    J[27], +H[0]-H[1]+H[2]+H[3]-H[4]-H[5]+H[6]-H[7]-J[0]+J[1]+J[2]-J[3]-J[4]+J[5]-J[6]-J[7]-J[8]+J[9]+J[10]-J[11]+
    J[12]+J[13]-J[14]-J[15]+J[16]-J[17]-J[18]-J[19]+J[20]-J[21]+J[22]-J[23]+J[24]-J[25]+J[26]-J[27], +H[0]-H[1]+
    H[2]+H[3]-H[4]-H[5]-H[6]+H[7]-J[0]+J[1]+J[2]-J[3]-J[4]-J[5]+J[6]-J[7]-J[8]+J[9]+J[10]+J[11]-J[12]+J[13]-J[14]-J[15]-J[16]+
    J[17]-J[18]-J[19]-J[20]+J[21]+J[22]+J[23]-J[24]+J[25]-J[26]-J[27], +H[0]-H[1]+H[2]+H[3]-H[4]-H[5]-H[6]-H[7]-J[0]+
    J[1]+J[2]-J[3]-J[4]-J[5]-J[6]-J[7]-J[8]+J[9]+J[10]+J[11]+J[12]+J[13]-J[14]-J[15]-J[16]-J[17]-J[18]-J[19]-J[20]-J[21]+
    J[22]+J[23]+J[24]+J[25]+J[26]+J[27], +H[0]-H[1]+H[2]-H[3]+H[4]+H[5]+H[6]+H[7]-J[0]+J[1]-J[2]+J[3]+J[4]+
    J[5]+J[6]-J[7]+J[8]-J[9]-J[10]-J[11]-J[12]-J[13]+J[14]+J[15]+J[16]+J[17]-J[18]-J[19]-J[20]-J[21]+J[22]+
    J[23]+J[24]+J[25]+J[26]+J[27], +H[0]-H[1]+H[2]-H[3]+H[4]+H[5]+H[6]-H[7]-J[0]+J[1]-J[2]+J[3]+J[4]+J[5]-J[6]-J[7]+
    J[8]-J[9]-J[10]-J[11]+J[12]-J[13]+J[14]+J[15]+J[16]-J[17]-J[18]-J[19]-J[20]+J[21]+J[22]+J[23]-J[24]+
    J[25]-J[26]-J[27], +H[0]-H[1]+H[2]-H[3]+H[4]+H[5]-H[6]+H[7]-J[0]+J[1]-J[2]+J[3]+J[4]-J[5]+J[6]-J[7]+
    J[8]-J[9]-J[10]+J[11]-J[12]-J[13]+J[14]+J[15]-J[16]+J[17]-J[18]-J[19]+J[20]-J[21]+J[22]-J[23]+J[24]-J[25]+
    J[26]-J[27], +H[0]-H[1]+H[2]-H[3]+H[4]+H[5]-H[6]-H[7]-J[0]+J[1]-J[2]+J[3]+J[4]-J[5]-J[6]-J[7]+J[8]-J[9]-J[10]+
    J[11]+J[12]-J[13]+J[14]+J[15]-J[16]-J[17]-J[18]-J[19]+J[20]+J[21]+J[22]-J[23]-J[24]-J[25]-J[26]+J[27], +
    H[0]-H[1]+H[2]-H[3]+H[4]-H[5]+H[6]+H[7]-J[0]+J[1]-J[2]+J[3]-J[4]+J[5]+J[6]-J[7]+J[8]-J[9]+J[10]-J[11]-J[12]-J[13]+
    J[14]-J[15]+J[16]+J[17]-J[18]+J[19]-J[20]-J[21]-J[22]+J[23]+J[24]-J[25]-J[26]+J[27], +H[0]-H[1]+H[2]-H[3]+
    H[4]-H[5]+H[6]-H[7]-J[0]+J[1]-J[2]+J[3]-J[4]+J[5]-J[6]-J[7]+J[8]-J[9]+J[10]-J[11]+J[12]-J[13]+J[14]-J[15]+
    J[16]-J[17]-J[18]+J[19]-J[20]+J[21]-J[22]+J[23]-J[24]-J[25]+J[26]-J[27], +H[0]-H[1]+H[2]-H[3]+H[4]-H[5]-H[6]+
    H[7]-J[0]+J[1]-J[2]+J[3]-J[4]-J[5]+J[6]-J[7]+J[8]-J[9]+J[10]+J[11]-J[12]-J[13]+J[14]-J[15]-J[16]+J[17]-J[18]+
    J[19]+J[20]-J[21]-J[22]-J[23]+J[24]+J[25]-J[26]-J[27], +H[0]-H[1]+H[2]-H[3]+H[4]-H[5]-H[6]-H[7]-J[0]+
    J[1]-J[2]+J[3]-J[4]-J[5]-J[6]-J[7]+J[8]-J[9]+J[10]+J[11]+J[12]-J[13]+J[14]-J[15]-J[16]-J[17]-J[18]+J[19]+
    J[20]+J[21]-J[22]-J[23]-J[24]+J[25]+J[26]+J[27], +H[0]-H[1]+H[2]-H[3]-H[4]+H[5]+H[6]+H[7]-J[0]+J[1]-J[2]-J[3]+
    J[4]+J[5]+J[6]-J[7]+J[8]+J[9]-J[10]-J[11]-J[12]-J[13]-J[14]+J[15]+J[16]+J[17]+J[18]-J[19]-J[20]-J[21]-J[22]-J[23]-J[24]+
    J[25]+J[26]+J[27], +H[0]-H[1]+H[2]-H[3]-H[4]+H[5]+H[6]-H[7]-J[0]+J[1]-J[2]-J[3]+J[4]+J[5]-J[6]-J[7]+
    J[8]+J[9]-J[10]-J[11]+J[12]-J[13]-J[14]+J[15]+J[16]-J[17]+J[18]-J[19]-J[20]+J[21]-J[22]-J[23]+J[24]+
    J[25]-J[26]-J[27], +H[0]-H[1]+H[2]-H[3]-H[4]+H[5]-H[6]+H[7]-J[0]+J[1]-J[2]-J[3]+J[4]-J[5]+J[6]-J[7]+
    J[8]+J[9]-J[10]+J[11]-J[12]-J[13]-J[14]+J[15]-J[16]+J[17]+J[18]-J[19]+J[20]-J[21]-J[22]+J[23]-J[24]-J[25]+
    J[26]-J[27], +H[0]-H[1]+H[2]-H[3]-H[4]+H[5]-H[6]-H[7]-J[0]+J[1]-J[2]-J[3]+J[4]-J[5]-J[6]-J[7]+J[8]+J[9]-J[10]+
    J[11]+J[12]-J[13]-J[14]+J[15]-J[16]-J[17]+J[18]-J[19]+J[20]+J[21]-J[22]+J[23]+J[24]-J[25]-J[26]+J[27], +
    H[0]-H[1]+H[2]-H[3]-H[4]-H[5]+H[6]+H[7]-J[0]+J[1]-J[2]-J[3]-J[4]+J[5]+J[6]-J[7]+J[8]+J[9]+J[10]-J[11]-J[12]-J[13]-J[14]-J[15]+
    J[16]+J[17]+J[18]+J[19]-J[20]-J[21]+J[22]-J[23]-J[24]-J[25]-J[26]+J[27], +H[0]-H[1]+H[2]-H[3]-H[4]-H[5]+
    H[6]-H[7]-J[0]+J[1]-J[2]-J[3]-J[4]+J[5]-J[6]-J[7]+J[8]+J[9]+J[10]-J[11]+J[12]-J[13]-J[14]-J[15]+J[16]-J[17]+
    J[18]+J[19]-J[20]+J[21]+J[22]-J[23]+J[24]-J[25]+J[26]-J[27], +H[0]-H[1]+H[2]-H[3]-H[4]-H[5]-H[6]+H[7]-J[0]+
    J[1]-J[2]-J[3]-J[4]-J[5]+J[6]-J[7]+J[8]+J[9]+J[10]+J[11]-J[12]-J[13]-J[14]-J[15]-J[16]+J[17]+J[18]+J[19]+
    J[20]-J[21]+J[22]+J[23]-J[24]+J[25]-J[26]-J[27], +H[0]-H[1]+H[2]-H[3]-H[4]-H[5]-H[6]-H[7]-J[0]+J[1]-J[2]-J[3]-J[4]-J[5]-J[6]-J[7]+
    J[8]+J[9]+J[10]+J[11]+J[12]-J[13]-J[14]-J[15]-J[16]-J[17]+J[18]+J[19]+J[20]+J[21]+J[22]+J[23]+J[24]+
    J[25]+J[26]+J[27], +H[0]-H[1]-H[2]+H[3]+H[4]+H[5]+H[6]+H[7]-J[0]-J[1]+J[2]+J[3]+J[4]+J[5]+J[6]+J[7]-J[8]-J[9]-J[10]-J[11]-J[12]-J[13]-J[14]-J[15]-J[16]-J[17]+
    J[18]+J[19]+J[20]+J[21]+J[22]+J[23]+J[24]+J[25]+J[26]+J[27], +H[0]-H[1]-H[2]+H[3]+H[4]+H[5]+H[6]-H[7]-J[0]-J[1]+
    J[2]+J[3]+J[4]+J[5]-J[6]+J[7]-J[8]-J[9]-J[10]-J[11]+J[12]-J[13]-J[14]-J[15]-J[16]+J[17]+J[18]+J[19]+
    J[20]-J[21]+J[22]+J[23]-J[24]+J[25]-J[26]-J[27], +H[0]-H[1]-H[2]+H[3]+H[4]+H[5]-H[6]+H[7]-J[0]-J[1]+
    J[2]+J[3]+J[4]-J[5]+J[6]+J[7]-J[8]-J[9]-J[10]+J[11]-J[12]-J[13]-J[14]-J[15]+J[16]-J[17]+J[18]+J[19]-J[20]+
    J[21]+J[22]-J[23]+J[24]-J[25]+J[26]-J[27], +H[0]-H[1]-H[2]+H[3]+H[4]+H[5]-H[6]-H[7]-J[0]-J[1]+J[2]+J[3]+
    J[4]-J[5]-J[6]+J[7]-J[8]-J[9]-J[10]+J[11]+J[12]-J[13]-J[14]-J[15]+J[16]+J[17]+J[18]+J[19]-J[20]-J[21]+
    J[22]-J[23]-J[24]-J[25]-J[26]+J[27], +H[0]-H[1]-H[2]+H[3]+H[4]-H[5]+H[6]+H[7]-J[0]-J[1]+J[2]+J[3]-J[4]+
    J[5]+J[6]+J[7]-J[8]-J[9]+J[10]-J[11]-J[12]-J[13]-J[14]+J[15]-J[16]-J[17]+J[18]-J[19]+J[20]+J[21]-J[22]+
    J[23]+J[24]-J[25]-J[26]+J[27], +H[0]-H[1]-H[2]+H[3]+H[4]-H[5]+H[6]-H[7]-J[0]-J[1]+J[2]+J[3]-J[4]+J[5]-J[6]+
    J[7]-J[8]-J[9]+J[10]-J[11]+J[12]-J[13]-J[14]+J[15]-J[16]+J[17]+J[18]-J[19]+J[20]-J[21]-J[22]+J[23]-J[24]-J[25]+
    J[26]-J[27], +H[0]-H[1]-H[2]+H[3]+H[4]-H[5]-H[6]+H[7]-J[0]-J[1]+J[2]+J[3]-J[4]-J[5]+J[6]+J[7]-J[8]-J[9]+
    J[10]+J[11]-J[12]-J[13]-J[14]+J[15]+J[16]-J[17]+J[18]-J[19]-J[20]+J[21]-J[22]-J[23]+J[24]+J[25]-J[26]-J[27], +
    H[0]-H[1]-H[2]+H[3]+H[4]-H[5]-H[6]-H[7]-J[0]-J[1]+J[2]+J[3]-J[4]-J[5]-J[6]+J[7]-J[8]-J[9]+J[10]+J[11]+
    J[12]-J[13]-J[14]+J[15]+J[16]+J[17]+J[18]-J[19]-J[20]-J[21]-J[22]-J[23]-J[24]+J[25]+J[26]+J[27], +H[0]-H[1]-H[2]+
    H[3]-H[4]+H[5]+H[6]+H[7]-J[0]-J[1]+J[2]-J[3]+J[4]+J[5]+J[6]+J[7]-J[8]+J[9]-J[10]-J[11]-J[12]-J[13]+J[14]-J[15]-J[16]-J[17]-J[18]+
    J[19]+J[20]+J[21]-J[22]-J[23]-J[24]+J[25]+J[26]+J[27], +H[0]-H[1]-H[2]+H[3]-H[4]+H[5]+H[6]-H[7]-J[0]-J[1]+
    J[2]-J[3]+J[4]+J[5]-J[6]+J[7]-J[8]+J[9]-J[10]-J[11]+J[12]-J[13]+J[14]-J[15]-J[16]+J[17]-J[18]+J[19]+
    J[20]-J[21]-J[22]-J[23]+J[24]+J[25]-J[26]-J[27], +H[0]-H[1]-H[2]+H[3]-H[4]+H[5]-H[6]+H[7]-J[0]-J[1]+
    J[2]-J[3]+J[4]-J[5]+J[6]+J[7]-J[8]+J[9]-J[10]+J[11]-J[12]-J[13]+J[14]-J[15]+J[16]-J[17]-J[18]+J[19]-J[20]+
    J[21]-J[22]+J[23]-J[24]-J[25]+J[26]-J[27], +H[0]-H[1]-H[2]+H[3]-H[4]+H[5]-H[6]-H[7]-J[0]-J[1]+J[2]-J[3]+
    J[4]-J[5]-J[6]+J[7]-J[8]+J[9]-J[10]+J[11]+J[12]-J[13]+J[14]-J[15]+J[16]+J[17]-J[18]+J[19]-J[20]-J[21]-J[22]+
    J[23]+J[24]-J[25]-J[26]+J[27], +H[0]-H[1]-H[2]+H[3]-H[4]-H[5]+H[6]+H[7]-J[0]-J[1]+J[2]-J[3]-J[4]+J[5]+
    J[6]+J[7]-J[8]+J[9]+J[10]-J[11]-J[12]-J[13]+J[14]+J[15]-J[16]-J[17]-J[18]-J[19]+J[20]+J[21]+J[22]-J[23]-J[24]-J[25]-J[26]+
    J[27], +H[0]-H[1]-H[2]+H[3]-H[4]-H[5]+H[6]-H[7]-J[0]-J[1]+J[2]-J[3]-J[4]+J[5]-J[6]+J[7]-J[8]+J[9]+J[10]-J[11]+
    J[12]-J[13]+J[14]+J[15]-J[16]+J[17]-J[18]-J[19]+J[20]-J[21]+J[22]-J[23]+J[24]-J[25]+J[26]-J[27], +H[0]-H[1]-H[2]+
    H[3]-H[4]-H[5]-H[6]+H[7]-J[0]-J[1]+J[2]-J[3]-J[4]-J[5]+J[6]+J[7]-J[8]+J[9]+J[10]+J[11]-J[12]-J[13]+J[14]+
    J[15]+J[16]-J[17]-J[18]-J[19]-J[20]+J[21]+J[22]+J[23]-J[24]+J[25]-J[26]-J[27], +H[0]-H[1]-H[2]+H[3]-H[4]-H[5]-H[6]-H[7]-J[0]-J[1]+
    J[2]-J[3]-J[4]-J[5]-J[6]+J[7]-J[8]+J[9]+J[10]+J[11]+J[12]-J[13]+J[14]+J[15]+J[16]+J[17]-J[18]-J[19]-J[20]-J[21]+
    J[22]+J[23]+J[24]+J[25]+J[26]+J[27], +H[0]-H[1]-H[2]-H[3]+H[4]+H[5]+H[6]+H[7]-J[0]-J[1]-J[2]+J[3]+J[4]+
    J[5]+J[6]+J[7]+J[8]-J[9]-J[10]-J[11]-J[12]+J[13]-J[14]-J[15]-J[16]-J[17]-J[18]-J[19]-J[20]-J[21]+J[22]+
    J[23]+J[24]+J[25]+J[26]+J[27], +H[0]-H[1]-H[2]-H[3]+H[4]+H[5]+H[6]-H[7]-J[0]-J[1]-J[2]+J[3]+J[4]+J[5]-J[6]+
    J[7]+J[8]-J[9]-J[10]-J[11]+J[12]+J[13]-J[14]-J[15]-J[16]+J[17]-J[18]-J[19]-J[20]+J[21]+J[22]+J[23]-J[24]+
    J[25]-J[26]-J[27], +H[0]-H[1]-H[2]-H[3]+H[4]+H[5]-H[6]+H[7]-J[0]-J[1]-J[2]+J[3]+J[4]-J[5]+J[6]+J[7]+
    J[8]-J[9]-J[10]+J[11]-J[12]+J[13]-J[14]-J[15]+J[16]-J[17]-J[18]-J[19]+J[20]-J[21]+J[22]-J[23]+J[24]-J[25]+
    J[26]-J[27], +H[0]-H[1]-H[2]-H[3]+H[4]+H[5]-H[6]-H[7]-J[0]-J[1]-J[2]+J[3]+J[4]-J[5]-J[6]+J[7]+J[8]-J[9]-J[10]+
    J[11]+J[12]+J[13]-J[14]-J[15]+J[16]+J[17]-J[18]-J[19]+J[20]+J[21]+J[22]-J[23]-J[24]-J[25]-J[26]+J[27], +
    H[0]-H[1]-H[2]-H[3]+H[4]-H[5]+H[6]+H[7]-J[0]-J[1]-J[2]+J[3]-J[4]+J[5]+J[6]+J[7]+J[8]-J[9]+J[10]-J[11]-J[12]+
    J[13]-J[14]+J[15]-J[16]-J[17]-J[18]+J[19]-J[20]-J[21]-J[22]+J[23]+J[24]-J[25]-J[26]+J[27], +H[0]-H[1]-H[2]-H[3]+
    H[4]-H[5]+H[6]-H[7]-J[0]-J[1]-J[2]+J[3]-J[4]+J[5]-J[6]+J[7]+J[8]-J[9]+J[10]-J[11]+J[12]+J[13]-J[14]+
    J[15]-J[16]+J[17]-J[18]+J[19]-J[20]+J[21]-J[22]+J[23]-J[24]-J[25]+J[26]-J[27], +H[0]-H[1]-H[2]-H[3]+
    H[4]-H[5]-H[6]+H[7]-J[0]-J[1]-J[2]+J[3]-J[4]-J[5]+J[6]+J[7]+J[8]-J[9]+J[10]+J[11]-J[12]+J[13]-J[14]+
    J[15]+J[16]-J[17]-J[18]+J[19]+J[20]-J[21]-J[22]-J[23]+J[24]+J[25]-J[26]-J[27], +H[0]-H[1]-H[2]-H[3]+
    H[4]-H[5]-H[6]-H[7]-J[0]-J[1]-J[2]+J[3]-J[4]-J[5]-J[6]+J[7]+J[8]-J[9]+J[10]+J[11]+J[12]+J[13]-J[14]+
    J[15]+J[16]+J[17]-J[18]+J[19]+J[20]+J[21]-J[22]-J[23]-J[24]+J[25]+J[26]+J[27], +H[0]-H[1]-H[2]-H[3]-H[4]+
    H[5]+H[6]+H[7]-J[0]-J[1]-J[2]-J[3]+J[4]+J[5]+J[6]+J[7]+J[8]+J[9]-J[10]-J[11]-J[12]+J[13]+J[14]-J[15]-J[16]-J[17]+
    J[18]-J[19]-J[20]-J[21]-J[22]-J[23]-J[24]+J[25]+J[26]+J[27], +H[0]-H[1]-H[2]-H[3]-H[4]+H[5]+H[6]-H[7]-J[0]-J[1]-J[2]-J[3]+
    J[4]+J[5]-J[6]+J[7]+J[8]+J[9]-J[10]-J[11]+J[12]+J[13]+J[14]-J[15]-J[16]+J[17]+J[18]-J[19]-J[20]+J[21]-J[22]-J[23]+
    J[24]+J[25]-J[26]-J[27], +H[0]-H[1]-H[2]-H[3]-H[4]+H[5]-H[6]+H[7]-J[0]-J[1]-J[2]-J[3]+J[4]-J[5]+J[6]+
    J[7]+J[8]+J[9]-J[10]+J[11]-J[12]+J[13]+J[14]-J[15]+J[16]-J[17]+J[18]-J[19]+J[20]-J[21]-J[22]+J[23]-J[24]-J[25]+
    J[26]-J[27], +H[0]-H[1]-H[2]-H[3]-H[4]+H[5]-H[6]-H[7]-J[0]-J[1]-J[2]-J[3]+J[4]-J[5]-J[6]+J[7]+J[8]+J[9]-J[10]+
    J[11]+J[12]+J[13]+J[14]-J[15]+J[16]+J[17]+J[18]-J[19]+J[20]+J[21]-J[22]+J[23]+J[24]-J[25]-J[26]+J[27], +
    H[0]-H[1]-H[2]-H[3]-H[4]-H[5]+H[6]+H[7]-J[0]-J[1]-J[2]-J[3]-J[4]+J[5]+J[6]+J[7]+J[8]+J[9]+J[10]-J[11]-J[12]+
    J[13]+J[14]+J[15]-J[16]-J[17]+J[18]+J[19]-J[20]-J[21]+J[22]-J[23]-J[24]-J[25]-J[26]+J[27], +H[0]-H[1]-H[2]-H[3]-H[4]-H[5]+
    H[6]-H[7]-J[0]-J[1]-J[2]-J[3]-J[4]+J[5]-J[6]+J[7]+J[8]+J[9]+J[10]-J[11]+J[12]+J[13]+J[14]+J[15]-J[16]+
    J[17]+J[18]+J[19]-J[20]+J[21]+J[22]-J[23]+J[24]-J[25]+J[26]-J[27], +H[0]-H[1]-H[2]-H[3]-H[4]-H[5]-H[6]+
    H[7]-J[0]-J[1]-J[2]-J[3]-J[4]-J[5]+J[6]+J[7]+J[8]+J[9]+J[10]+J[11]-J[12]+J[13]+J[14]+J[15]+J[16]-J[17]+
    J[18]+J[19]+J[20]-J[21]+J[22]+J[23]-J[24]+J[25]-J[26]-J[27], +H[0]-H[1]-H[2]-H[3]-H[4]-H[5]-H[6]-H[7]-J[0]-J[1]-J[2]-J[3]-J[4]-J[5]-J[6]+
    J[7]+J[8]+J[9]+J[10]+J[11]+J[12]+J[13]+J[14]+J[15]+J[16]+J[17]+J[18]+J[19]+J[20]+J[21]+J[22]+J[23]+J[24]+
    J[25]+J[26]+J[27], -H[0]+H[1]+H[2]+H[3]+H[4]+H[5]+H[6]+H[7]-J[0]-J[1]-J[2]-J[3]-J[4]-J[5]-J[6]+J[7]+
    J[8]+J[9]+J[10]+J[11]+J[12]+J[13]+J[14]+J[15]+J[16]+J[17]+J[18]+J[19]+J[20]+J[21]+J[22]+J[23]+J[24]+
    J[25]+J[26]+J[27], -H[0]+H[1]+H[2]+H[3]+H[4]+H[5]+H[6]-H[7]-J[0]-J[1]-J[2]-J[3]-J[4]-J[5]+J[6]+J[7]+
    J[8]+J[9]+J[10]+J[11]-J[12]+J[13]+J[14]+J[15]+J[16]-J[17]+J[18]+J[19]+J[20]-J[21]+J[22]+J[23]-J[24]+
    J[25]-J[26]-J[27], -H[0]+H[1]+H[2]+H[3]+H[4]+H[5]-H[6]+H[7]-J[0]-J[1]-J[2]-J[3]-J[4]+J[5]-J[6]+J[7]+
    J[8]+J[9]+J[10]-J[11]+J[12]+J[13]+J[14]+J[15]-J[16]+J[17]+J[18]+J[19]-J[20]+J[21]+J[22]-J[23]+J[24]-J[25]+
    J[26]-J[27], -H[0]+H[1]+H[2]+H[3]+H[4]+H[5]-H[6]-H[7]-J[0]-J[1]-J[2]-J[3]-J[4]+J[5]+J[6]+J[7]+J[8]+J[9]+
    J[10]-J[11]-J[12]+J[13]+J[14]+J[15]-J[16]-J[17]+J[18]+J[19]-J[20]-J[21]+J[22]-J[23]-J[24]-J[25]-J[26]+
    J[27], -H[0]+H[1]+H[2]+H[3]+H[4]-H[5]+H[6]+H[7]-J[0]-J[1]-J[2]-J[3]+J[4]-J[5]-J[6]+J[7]+J[8]+J[9]-J[10]+
    J[11]+J[12]+J[13]+J[14]-J[15]+J[16]+J[17]+J[18]-J[19]+J[20]+J[21]-J[22]+J[23]+J[24]-J[25]-J[26]+J[27], -H[0]+
    H[1]+H[2]+H[3]+H[4]-H[5]+H[6]-H[7]-J[0]-J[1]-J[2]-J[3]+J[4]-J[5]+J[6]+J[7]+J[8]+J[9]-J[10]+J[11]-J[12]+
    J[13]+J[14]-J[15]+J[16]-J[17]+J[18]-J[19]+J[20]-J[21]-J[22]+J[23]-J[24]-J[25]+J[26]-J[27], -H[0]+H[1]+
    H[2]+H[3]+H[4]-H[5]-H[6]+H[7]-J[0]-J[1]-J[2]-J[3]+J[4]+J[5]-J[6]+J[7]+J[8]+J[9]-J[10]-J[11]+J[12]+J[13]+
    J[14]-J[15]-J[16]+J[17]+J[18]-J[19]-J[20]+J[21]-J[22]-J[23]+J[24]+J[25]-J[26]-J[27], -H[0]+H[1]+H[2]+
    H[3]+H[4]-H[5]-H[6]-H[7]-J[0]-J[1]-J[2]-J[3]+J[4]+J[5]+J[6]+J[7]+J[8]+J[9]-J[10]-J[11]-J[12]+J[13]+J[14]-J[15]-J[16]-J[17]+
    J[18]-J[19]-J[20]-J[21]-J[22]-J[23]-J[24]+J[25]+J[26]+J[27], -H[0]+H[1]+H[2]+H[3]-H[4]+H[5]+H[6]+H[7]-J[0]-J[1]-J[2]+
    J[3]-J[4]-J[5]-J[6]+J[7]+J[8]-J[9]+J[10]+J[11]+J[12]+J[13]-J[14]+J[15]+J[16]+J[17]-J[18]+J[19]+J[20]+
    J[21]-J[22]-J[23]-J[24]+J[25]+J[26]+J[27], -H[0]+H[1]+H[2]+H[3]-H[4]+H[5]+H[6]-H[7]-J[0]-J[1]-J[2]+J[3]-J[4]-J[5]+
    J[6]+J[7]+J[8]-J[9]+J[10]+J[11]-J[12]+J[13]-J[14]+J[15]+J[16]-J[17]-J[18]+J[19]+J[20]-J[21]-J[22]-J[23]+
    J[24]+J[25]-J[26]-J[27], -H[0]+H[1]+H[2]+H[3]-H[4]+H[5]-H[6]+H[7]-J[0]-J[1]-J[2]+J[3]-J[4]+J[5]-J[6]+
    J[7]+J[8]-J[9]+J[10]-J[11]+J[12]+J[13]-J[14]+J[15]-J[16]+J[17]-J[18]+J[19]-J[20]+J[21]-J[22]+J[23]-J[24]-J[25]+
    J[26]-J[27], -H[0]+H[1]+H[2]+H[3]-H[4]+H[5]-H[6]-H[7]-J[0]-J[1]-J[2]+J[3]-J[4]+J[5]+J[6]+J[7]+J[8]-J[9]+
    J[10]-J[11]-J[12]+J[13]-J[14]+J[15]-J[16]-J[17]-J[18]+J[19]-J[20]-J[21]-J[22]+J[23]+J[24]-J[25]-J[26]+
    J[27], -H[0]+H[1]+H[2]+H[3]-H[4]-H[5]+H[6]+H[7]-J[0]-J[1]-J[2]+J[3]+J[4]-J[5]-J[6]+J[7]+J[8]-J[9]-J[10]+
    J[11]+J[12]+J[13]-J[14]-J[15]+J[16]+J[17]-J[18]-J[19]+J[20]+J[21]+J[22]-J[23]-J[24]-J[25]-J[26]+J[27], -H[0]+
    H[1]+H[2]+H[3]-H[4]-H[5]+H[6]-H[7]-J[0]-J[1]-J[2]+J[3]+J[4]-J[5]+J[6]+J[7]+J[8]-J[9]-J[10]+J[11]-J[12]+
    J[13]-J[14]-J[15]+J[16]-J[17]-J[18]-J[19]+J[20]-J[21]+J[22]-J[23]+J[24]-J[25]+J[26]-J[27], -H[0]+H[1]+
    H[2]+H[3]-H[4]-H[5]-H[6]+H[7]-J[0]-J[1]-J[2]+J[3]+J[4]+J[5]-J[6]+J[7]+J[8]-J[9]-J[10]-J[11]+J[12]+J[13]-J[14]-J[15]-J[16]+
    J[17]-J[18]-J[19]-J[20]+J[21]+J[22]+J[23]-J[24]+J[25]-J[26]-J[27], -H[0]+H[1]+H[2]+H[3]-H[4]-H[5]-H[6]-H[7]-J[0]-J[1]-J[2]+
    J[3]+J[4]+J[5]+J[6]+J[7]+J[8]-J[9]-J[10]-J[11]-J[12]+J[13]-J[14]-J[15]-J[16]-J[17]-J[18]-J[19]-J[20]-J[21]+
    J[22]+J[23]+J[24]+J[25]+J[26]+J[27], -H[0]+H[1]+H[2]-H[3]+H[4]+H[5]+H[6]+H[7]-J[0]-J[1]+J[2]-J[3]-J[4]-J[5]-J[6]+
    J[7]-J[8]+J[9]+J[10]+J[11]+J[12]-J[13]+J[14]+J[15]+J[16]+J[17]-J[18]-J[19]-J[20]-J[21]+J[22]+J[23]+J[24]+
    J[25]+J[26]+J[27], -H[0]+H[1]+H[2]-H[3]+H[4]+H[5]+H[6]-H[7]-J[0]-J[1]+J[2]-J[3]-J[4]-J[5]+J[6]+J[7]-J[8]+
    J[9]+J[10]+J[11]-J[12]-J[13]+J[14]+J[15]+J[16]-J[17]-J[18]-J[19]-J[20]+J[21]+J[22]+J[23]-J[24]+J[25]-J[26]-J[27], -H[0]+
    H[1]+H[2]-H[3]+H[4]+H[5]-H[6]+H[7]-J[0]-J[1]+J[2]-J[3]-J[4]+J[5]-J[6]+J[7]-J[8]+J[9]+J[10]-J[11]+J[12]-J[13]+
    J[14]+J[15]-J[16]+J[17]-J[18]-J[19]+J[20]-J[21]+J[22]-J[23]+J[24]-J[25]+J[26]-J[27], -H[0]+H[1]+H[2]-H[3]+
    H[4]+H[5]-H[6]-H[7]-J[0]-J[1]+J[2]-J[3]-J[4]+J[5]+J[6]+J[7]-J[8]+J[9]+J[10]-J[11]-J[12]-J[13]+J[14]+
    J[15]-J[16]-J[17]-J[18]-J[19]+J[20]+J[21]+J[22]-J[23]-J[24]-J[25]-J[26]+J[27], -H[0]+H[1]+H[2]-H[3]+
    H[4]-H[5]+H[6]+H[7]-J[0]-J[1]+J[2]-J[3]+J[4]-J[5]-J[6]+J[7]-J[8]+J[9]-J[10]+J[11]+J[12]-J[13]+J[14]-J[15]+
    J[16]+J[17]-J[18]+J[19]-J[20]-J[21]-J[22]+J[23]+J[24]-J[25]-J[26]+J[27], -H[0]+H[1]+H[2]-H[3]+H[4]-H[5]+
    H[6]-H[7]-J[0]-J[1]+J[2]-J[3]+J[4]-J[5]+J[6]+J[7]-J[8]+J[9]-J[10]+J[11]-J[12]-J[13]+J[14]-J[15]+J[16]-J[17]-J[18]+
    J[19]-J[20]+J[21]-J[22]+J[23]-J[24]-J[25]+J[26]-J[27], -H[0]+H[1]+H[2]-H[3]+H[4]-H[5]-H[6]+H[7]-J[0]-J[1]+
    J[2]-J[3]+J[4]+J[5]-J[6]+J[7]-J[8]+J[9]-J[10]-J[11]+J[12]-J[13]+J[14]-J[15]-J[16]+J[17]-J[18]+J[19]+
    J[20]-J[21]-J[22]-J[23]+J[24]+J[25]-J[26]-J[27], -H[0]+H[1]+H[2]-H[3]+H[4]-H[5]-H[6]-H[7]-J[0]-J[1]+
    J[2]-J[3]+J[4]+J[5]+J[6]+J[7]-J[8]+J[9]-J[10]-J[11]-J[12]-J[13]+J[14]-J[15]-J[16]-J[17]-J[18]+J[19]+
    J[20]+J[21]-J[22]-J[23]-J[24]+J[25]+J[26]+J[27], -H[0]+H[1]+H[2]-H[3]-H[4]+H[5]+H[6]+H[7]-J[0]-J[1]+
    J[2]+J[3]-J[4]-J[5]-J[6]+J[7]-J[8]-J[9]+J[10]+J[11]+J[12]-J[13]-J[14]+J[15]+J[16]+J[17]+J[18]-J[19]-J[20]-J[21]-J[22]-J[23]-J[24]+
    J[25]+J[26]+J[27], -H[0]+H[1]+H[2]-H[3]-H[4]+H[5]+H[6]-H[7]-J[0]-J[1]+J[2]+J[3]-J[4]-J[5]+J[6]+J[7]-J[8]-J[9]+
    J[10]+J[11]-J[12]-J[13]-J[14]+J[15]+J[16]-J[17]+J[18]-J[19]-J[20]+J[21]-J[22]-J[23]+J[24]+J[25]-J[26]-J[27], -H[0]+
    H[1]+H[2]-H[3]-H[4]+H[5]-H[6]+H[7]-J[0]-J[1]+J[2]+J[3]-J[4]+J[5]-J[6]+J[7]-J[8]-J[9]+J[10]-J[11]+J[12]-J[13]-J[14]+
    J[15]-J[16]+J[17]+J[18]-J[19]+J[20]-J[21]-J[22]+J[23]-J[24]-J[25]+J[26]-J[27], -H[0]+H[1]+H[2]-H[3]-H[4]+
    H[5]-H[6]-H[7]-J[0]-J[1]+J[2]+J[3]-J[4]+J[5]+J[6]+J[7]-J[8]-J[9]+J[10]-J[11]-J[12]-J[13]-J[14]+J[15]-J[16]-J[17]+
    J[18]-J[19]+J[20]+J[21]-J[22]+J[23]+J[24]-J[25]-J[26]+J[27], -H[0]+H[1]+H[2]-H[3]-H[4]-H[5]+H[6]+H[7]-J[0]-J[1]+
    J[2]+J[3]+J[4]-J[5]-J[6]+J[7]-J[8]-J[9]-J[10]+J[11]+J[12]-J[13]-J[14]-J[15]+J[16]+J[17]+J[18]+J[19]-J[20]-J[21]+
    J[22]-J[23]-J[24]-J[25]-J[26]+J[27], -H[0]+H[1]+H[2]-H[3]-H[4]-H[5]+H[6]-H[7]-J[0]-J[1]+J[2]+J[3]+J[4]-J[5]+
    J[6]+J[7]-J[8]-J[9]-J[10]+J[11]-J[12]-J[13]-J[14]-J[15]+J[16]-J[17]+J[18]+J[19]-J[20]+J[21]+J[22]-J[23]+
    J[24]-J[25]+J[26]-J[27], -H[0]+H[1]+H[2]-H[3]-H[4]-H[5]-H[6]+H[7]-J[0]-J[1]+J[2]+J[3]+J[4]+J[5]-J[6]+
    J[7]-J[8]-J[9]-J[10]-J[11]+J[12]-J[13]-J[14]-J[15]-J[16]+J[17]+J[18]+J[19]+J[20]-J[21]+J[22]+J[23]-J[24]+
    J[25]-J[26]-J[27], -H[0]+H[1]+H[2]-H[3]-H[4]-H[5]-H[6]-H[7]-J[0]-J[1]+J[2]+J[3]+J[4]+J[5]+J[6]+J[7]-J[8]-J[9]-J[10]-J[11]-J[12]-J[13]-J[14]-J[15]-J[16]-J[17]+
    J[18]+J[19]+J[20]+J[21]+J[22]+J[23]+J[24]+J[25]+J[26]+J[27], -H[0]+H[1]-H[2]+H[3]+H[4]+H[5]+H[6]+H[7]-J[0]+
    J[1]-J[2]-J[3]-J[4]-J[5]-J[6]-J[7]+J[8]+J[9]+J[10]+J[11]+J[12]-J[13]-J[14]-J[15]-J[16]-J[17]+J[18]+J[19]+
    J[20]+J[21]+J[22]+J[23]+J[24]+J[25]+J[26]+J[27], -H[0]+H[1]-H[2]+H[3]+H[4]+H[5]+H[6]-H[7]-J[0]+J[1]-J[2]-J[3]-J[4]-J[5]+
    J[6]-J[7]+J[8]+J[9]+J[10]+J[11]-J[12]-J[13]-J[14]-J[15]-J[16]+J[17]+J[18]+J[19]+J[20]-J[21]+J[22]+J[23]-J[24]+
    J[25]-J[26]-J[27], -H[0]+H[1]-H[2]+H[3]+H[4]+H[5]-H[6]+H[7]-J[0]+J[1]-J[2]-J[3]-J[4]+J[5]-J[6]-J[7]+
    J[8]+J[9]+J[10]-J[11]+J[12]-J[13]-J[14]-J[15]+J[16]-J[17]+J[18]+J[19]-J[20]+J[21]+J[22]-J[23]+J[24]-J[25]+
    J[26]-J[27], -H[0]+H[1]-H[2]+H[3]+H[4]+H[5]-H[6]-H[7]-J[0]+J[1]-J[2]-J[3]-J[4]+J[5]+J[6]-J[7]+J[8]+J[9]+
    J[10]-J[11]-J[12]-J[13]-J[14]-J[15]+J[16]+J[17]+J[18]+J[19]-J[20]-J[21]+J[22]-J[23]-J[24]-J[25]-J[26]+
    J[27], -H[0]+H[1]-H[2]+H[3]+H[4]-H[5]+H[6]+H[7]-J[0]+J[1]-J[2]-J[3]+J[4]-J[5]-J[6]-J[7]+J[8]+J[9]-J[10]+
    J[11]+J[12]-J[13]-J[14]+J[15]-J[16]-J[17]+J[18]-J[19]+J[20]+J[21]-J[22]+J[23]+J[24]-J[25]-J[26]+J[27], -H[0]+
    H[1]-H[2]+H[3]+H[4]-H[5]+H[6]-H[7]-J[0]+J[1]-J[2]-J[3]+J[4]-J[5]+J[6]-J[7]+J[8]+J[9]-J[10]+J[11]-J[12]-J[13]-J[14]+
    J[15]-J[16]+J[17]+J[18]-J[19]+J[20]-J[21]-J[22]+J[23]-J[24]-J[25]+J[26]-J[27], -H[0]+H[1]-H[2]+H[3]+
    H[4]-H[5]-H[6]+H[7]-J[0]+J[1]-J[2]-J[3]+J[4]+J[5]-J[6]-J[7]+J[8]+J[9]-J[10]-J[11]+J[12]-J[13]-J[14]+
    J[15]+J[16]-J[17]+J[18]-J[19]-J[20]+J[21]-J[22]-J[23]+J[24]+J[25]-J[26]-J[27], -H[0]+H[1]-H[2]+H[3]+
    H[4]-H[5]-H[6]-H[7]-J[0]+J[1]-J[2]-J[3]+J[4]+J[5]+J[6]-J[7]+J[8]+J[9]-J[10]-J[11]-J[12]-J[13]-J[14]+
    J[15]+J[16]+J[17]+J[18]-J[19]-J[20]-J[21]-J[22]-J[23]-J[24]+J[25]+J[26]+J[27], -H[0]+H[1]-H[2]+H[3]-H[4]+
    H[5]+H[6]+H[7]-J[0]+J[1]-J[2]+J[3]-J[4]-J[5]-J[6]-J[7]+J[8]-J[9]+J[10]+J[11]+J[12]-J[13]+J[14]-J[15]-J[16]-J[17]-J[18]+
    J[19]+J[20]+J[21]-J[22]-J[23]-J[24]+J[25]+J[26]+J[27], -H[0]+H[1]-H[2]+H[3]-H[4]+H[5]+H[6]-H[7]-J[0]+
    J[1]-J[2]+J[3]-J[4]-J[5]+J[6]-J[7]+J[8]-J[9]+J[10]+J[11]-J[12]-J[13]+J[14]-J[15]-J[16]+J[17]-J[18]+J[19]+
    J[20]-J[21]-J[22]-J[23]+J[24]+J[25]-J[26]-J[27], -H[0]+H[1]-H[2]+H[3]-H[4]+H[5]-H[6]+H[7]-J[0]+J[1]-J[2]+
    J[3]-J[4]+J[5]-J[6]-J[7]+J[8]-J[9]+J[10]-J[11]+J[12]-J[13]+J[14]-J[15]+J[16]-J[17]-J[18]+J[19]-J[20]+
    J[21]-J[22]+J[23]-J[24]-J[25]+J[26]-J[27], -H[0]+H[1]-H[2]+H[3]-H[4]+H[5]-H[6]-H[7]-J[0]+J[1]-J[2]+J[3]-J[4]+
    J[5]+J[6]-J[7]+J[8]-J[9]+J[10]-J[11]-J[12]-J[13]+J[14]-J[15]+J[16]+J[17]-J[18]+J[19]-J[20]-J[21]-J[22]+
    J[23]+J[24]-J[25]-J[26]+J[27], -H[0]+H[1]-H[2]+H[3]-H[4]-H[5]+H[6]+H[7]-J[0]+J[1]-J[2]+J[3]+J[4]-J[5]-J[6]-J[7]+
    J[8]-J[9]-J[10]+J[11]+J[12]-J[13]+J[14]+J[15]-J[16]-J[17]-J[18]-J[19]+J[20]+J[21]+J[22]-J[23]-J[24]-J[25]-J[26]+
    J[27], -H[0]+H[1]-H[2]+H[3]-H[4]-H[5]+H[6]-H[7]-J[0]+J[1]-J[2]+J[3]+J[4]-J[5]+J[6]-J[7]+J[8]-J[9]-J[10]+
    J[11]-J[12]-J[13]+J[14]+J[15]-J[16]+J[17]-J[18]-J[19]+J[20]-J[21]+J[22]-J[23]+J[24]-J[25]+J[26]-J[27], -H[0]+
    H[1]-H[2]+H[3]-H[4]-H[5]-H[6]+H[7]-J[0]+J[1]-J[2]+J[3]+J[4]+J[5]-J[6]-J[7]+J[8]-J[9]-J[10]-J[11]+J[12]-J[13]+
    J[14]+J[15]+J[16]-J[17]-J[18]-J[19]-J[20]+J[21]+J[22]+J[23]-J[24]+J[25]-J[26]-J[27], -H[0]+H[1]-H[2]+
    H[3]-H[4]-H[5]-H[6]-H[7]-J[0]+J[1]-J[2]+J[3]+J[4]+J[5]+J[6]-J[7]+J[8]-J[9]-J[10]-J[11]-J[12]-J[13]+J[14]+
    J[15]+J[16]+J[17]-J[18]-J[19]-J[20]-J[21]+J[22]+J[23]+J[24]+J[25]+J[26]+J[27], -H[0]+H[1]-H[2]-H[3]+
    H[4]+H[5]+H[6]+H[7]-J[0]+J[1]+J[2]-J[3]-J[4]-J[5]-J[6]-J[7]-J[8]+J[9]+J[10]+J[11]+J[12]+J[13]-J[14]-J[15]-J[16]-J[17]-J[18]-J[19]-J[20]-J[21]+
    J[22]+J[23]+J[24]+J[25]+J[26]+J[27], -H[0]+H[1]-H[2]-H[3]+H[4]+H[5]+H[6]-H[7]-J[0]+J[1]+J[2]-J[3]-J[4]-J[5]+
    J[6]-J[7]-J[8]+J[9]+J[10]+J[11]-J[12]+J[13]-J[14]-J[15]-J[16]+J[17]-J[18]-J[19]-J[20]+J[21]+J[22]+J[23]-J[24]+
    J[25]-J[26]-J[27], -H[0]+H[1]-H[2]-H[3]+H[4]+H[5]-H[6]+H[7]-J[0]+J[1]+J[2]-J[3]-J[4]+J[5]-J[6]-J[7]-J[8]+
    J[9]+J[10]-J[11]+J[12]+J[13]-J[14]-J[15]+J[16]-J[17]-J[18]-J[19]+J[20]-J[21]+J[22]-J[23]+J[24]-J[25]+
    J[26]-J[27], -H[0]+H[1]-H[2]-H[3]+H[4]+H[5]-H[6]-H[7]-J[0]+J[1]+J[2]-J[3]-J[4]+J[5]+J[6]-J[7]-J[8]+J[9]+
    J[10]-J[11]-J[12]+J[13]-J[14]-J[15]+J[16]+J[17]-J[18]-J[19]+J[20]+J[21]+J[22]-J[23]-J[24]-J[25]-J[26]+
    J[27], -H[0]+H[1]-H[2]-H[3]+H[4]-H[5]+H[6]+H[7]-J[0]+J[1]+J[2]-J[3]+J[4]-J[5]-J[6]-J[7]-J[8]+J[9]-J[10]+
    J[11]+J[12]+J[13]-J[14]+J[15]-J[16]-J[17]-J[18]+J[19]-J[20]-J[21]-J[22]+J[23]+J[24]-J[25]-J[26]+J[27], -H[0]+
    H[1]-H[2]-H[3]+H[4]-H[5]+H[6]-H[7]-J[0]+J[1]+J[2]-J[3]+J[4]-J[5]+J[6]-J[7]-J[8]+J[9]-J[10]+J[11]-J[12]+
    J[13]-J[14]+J[15]-J[16]+J[17]-J[18]+J[19]-J[20]+J[21]-J[22]+J[23]-J[24]-J[25]+J[26]-J[27], -H[0]+H[1]-H[2]-H[3]+
    H[4]-H[5]-H[6]+H[7]-J[0]+J[1]+J[2]-J[3]+J[4]+J[5]-J[6]-J[7]-J[8]+J[9]-J[10]-J[11]+J[12]+J[13]-J[14]+
    J[15]+J[16]-J[17]-J[18]+J[19]+J[20]-J[21]-J[22]-J[23]+J[24]+J[25]-J[26]-J[27], -H[0]+H[1]-H[2]-H[3]+
    H[4]-H[5]-H[6]-H[7]-J[0]+J[1]+J[2]-J[3]+J[4]+J[5]+J[6]-J[7]-J[8]+J[9]-J[10]-J[11]-J[12]+J[13]-J[14]+
    J[15]+J[16]+J[17]-J[18]+J[19]+J[20]+J[21]-J[22]-J[23]-J[24]+J[25]+J[26]+J[27], -H[0]+H[1]-H[2]-H[3]-H[4]+
    H[5]+H[6]+H[7]-J[0]+J[1]+J[2]+J[3]-J[4]-J[5]-J[6]-J[7]-J[8]-J[9]+J[10]+J[11]+J[12]+J[13]+J[14]-J[15]-J[16]-J[17]+
    J[18]-J[19]-J[20]-J[21]-J[22]-J[23]-J[24]+J[25]+J[26]+J[27], -H[0]+H[1]-H[2]-H[3]-H[4]+H[5]+H[6]-H[7]-J[0]+
    J[1]+J[2]+J[3]-J[4]-J[5]+J[6]-J[7]-J[8]-J[9]+J[10]+J[11]-J[12]+J[13]+J[14]-J[15]-J[16]+J[17]+J[18]-J[19]-J[20]+
    J[21]-J[22]-J[23]+J[24]+J[25]-J[26]-J[27], -H[0]+H[1]-H[2]-H[3]-H[4]+H[5]-H[6]+H[7]-J[0]+J[1]+J[2]+J[3]-J[4]+
    J[5]-J[6]-J[7]-J[8]-J[9]+J[10]-J[11]+J[12]+J[13]+J[14]-J[15]+J[16]-J[17]+J[18]-J[19]+J[20]-J[21]-J[22]+
    J[23]-J[24]-J[25]+J[26]-J[27], -H[0]+H[1]-H[2]-H[3]-H[4]+H[5]-H[6]-H[7]-J[0]+J[1]+J[2]+J[3]-J[4]+J[5]+
    J[6]-J[7]-J[8]-J[9]+J[10]-J[11]-J[12]+J[13]+J[14]-J[15]+J[16]+J[17]+J[18]-J[19]+J[20]+J[21]-J[22]+J[23]+
    J[24]-J[25]-J[26]+J[27], -H[0]+H[1]-H[2]-H[3]-H[4]-H[5]+H[6]+H[7]-J[0]+J[1]+J[2]+J[3]+J[4]-J[5]-J[6]-J[7]-J[8]-J[9]-J[10]+
    J[11]+J[12]+J[13]+J[14]+J[15]-J[16]-J[17]+J[18]+J[19]-J[20]-J[21]+J[22]-J[23]-J[24]-J[25]-J[26]+J[27], -H[0]+
    H[1]-H[2]-H[3]-H[4]-H[5]+H[6]-H[7]-J[0]+J[1]+J[2]+J[3]+J[4]-J[5]+J[6]-J[7]-J[8]-J[9]-J[10]+J[11]-J[12]+
    J[13]+J[14]+J[15]-J[16]+J[17]+J[18]+J[19]-J[20]+J[21]+J[22]-J[23]+J[24]-J[25]+J[26]-J[27], -H[0]+H[1]-H[2]-H[3]-H[4]-H[5]-H[6]+
    H[7]-J[0]+J[1]+J[2]+J[3]+J[4]+J[5]-J[6]-J[7]-J[8]-J[9]-J[10]-J[11]+J[12]+J[13]+J[14]+J[15]+J[16]-J[17]+
    J[18]+J[19]+J[20]-J[21]+J[22]+J[23]-J[24]+J[25]-J[26]-J[27], -H[0]+H[1]-H[2]-H[3]-H[4]-H[5]-H[6]-H[7]-J[0]+
    J[1]+J[2]+J[3]+J[4]+J[5]+J[6]-J[7]-J[8]-J[9]-J[10]-J[11]-J[12]+J[13]+J[14]+J[15]+J[16]+J[17]+J[18]+J[19]+
    J[20]+J[21]+J[22]+J[23]+J[24]+J[25]+J[26]+J[27], -H[0]-H[1]+H[2]+H[3]+H[4]+H[5]+H[6]+H[7]+J[0]-J[1]-J[2]-J[3]-J[4]-J[5]-J[6]-J[7]-J[8]-J[9]-J[10]-J[11]-J[12]+
    J[13]+J[14]+J[15]+J[16]+J[17]+J[18]+J[19]+J[20]+J[21]+J[22]+J[23]+J[24]+J[25]+J[26]+J[27], -H[0]-H[1]+
    H[2]+H[3]+H[4]+H[5]+H[6]-H[7]+J[0]-J[1]-J[2]-J[3]-J[4]-J[5]+J[6]-J[7]-J[8]-J[9]-J[10]-J[11]+J[12]+J[13]+
    J[14]+J[15]+J[16]-J[17]+J[18]+J[19]+J[20]-J[21]+J[22]+J[23]-J[24]+J[25]-J[26]-J[27], -H[0]-H[1]+H[2]+
    H[3]+H[4]+H[5]-H[6]+H[7]+J[0]-J[1]-J[2]-J[3]-J[4]+J[5]-J[6]-J[7]-J[8]-J[9]-J[10]+J[11]-J[12]+J[13]+J[14]+
    J[15]-J[16]+J[17]+J[18]+J[19]-J[20]+J[21]+J[22]-J[23]+J[24]-J[25]+J[26]-J[27], -H[0]-H[1]+H[2]+H[3]+
    H[4]+H[5]-H[6]-H[7]+J[0]-J[1]-J[2]-J[3]-J[4]+J[5]+J[6]-J[7]-J[8]-J[9]-J[10]+J[11]+J[12]+J[13]+J[14]+
    J[15]-J[16]-J[17]+J[18]+J[19]-J[20]-J[21]+J[22]-J[23]-J[24]-J[25]-J[26]+J[27], -H[0]-H[1]+H[2]+H[3]+
    H[4]-H[5]+H[6]+H[7]+J[0]-J[1]-J[2]-J[3]+J[4]-J[5]-J[6]-J[7]-J[8]-J[9]+J[10]-J[11]-J[12]+J[13]+J[14]-J[15]+
    J[16]+J[17]+J[18]-J[19]+J[20]+J[21]-J[22]+J[23]+J[24]-J[25]-J[26]+J[27], -H[0]-H[1]+H[2]+H[3]+H[4]-H[5]+
    H[6]-H[7]+J[0]-J[1]-J[2]-J[3]+J[4]-J[5]+J[6]-J[7]-J[8]-J[9]+J[10]-J[11]+J[12]+J[13]+J[14]-J[15]+J[16]-J[17]+
    J[18]-J[19]+J[20]-J[21]-J[22]+J[23]-J[24]-J[25]+J[26]-J[27], -H[0]-H[1]+H[2]+H[3]+H[4]-H[5]-H[6]+H[7]+
    J[0]-J[1]-J[2]-J[3]+J[4]+J[5]-J[6]-J[7]-J[8]-J[9]+J[10]+J[11]-J[12]+J[13]+J[14]-J[15]-J[16]+J[17]+J[18]-J[19]-J[20]+
    J[21]-J[22]-J[23]+J[24]+J[25]-J[26]-J[27], -H[0]-H[1]+H[2]+H[3]+H[4]-H[5]-H[6]-H[7]+J[0]-J[1]-J[2]-J[3]+
    J[4]+J[5]+J[6]-J[7]-J[8]-J[9]+J[10]+J[11]+J[12]+J[13]+J[14]-J[15]-J[16]-J[17]+J[18]-J[19]-J[20]-J[21]-J[22]-J[23]-J[24]+
    J[25]+J[26]+J[27], -H[0]-H[1]+H[2]+H[3]-H[4]+H[5]+H[6]+H[7]+J[0]-J[1]-J[2]+J[3]-J[4]-J[5]-J[6]-J[7]-J[8]+
    J[9]-J[10]-J[11]-J[12]+J[13]-J[14]+J[15]+J[16]+J[17]-J[18]+J[19]+J[20]+J[21]-J[22]-J[23]-J[24]+J[25]+
    J[26]+J[27], -H[0]-H[1]+H[2]+H[3]-H[4]+H[5]+H[6]-H[7]+J[0]-J[1]-J[2]+J[3]-J[4]-J[5]+J[6]-J[7]-J[8]+J[9]-J[10]-J[11]+
    J[12]+J[13]-J[14]+J[15]+J[16]-J[17]-J[18]+J[19]+J[20]-J[21]-J[22]-J[23]+J[24]+J[25]-J[26]-J[27], -H[0]-H[1]+
    H[2]+H[3]-H[4]+H[5]-H[6]+H[7]+J[0]-J[1]-J[2]+J[3]-J[4]+J[5]-J[6]-J[7]-J[8]+J[9]-J[10]+J[11]-J[12]+J[13]-J[14]+
    J[15]-J[16]+J[17]-J[18]+J[19]-J[20]+J[21]-J[22]+J[23]-J[24]-J[25]+J[26]-J[27], -H[0]-H[1]+H[2]+H[3]-H[4]+
    H[5]-H[6]-H[7]+J[0]-J[1]-J[2]+J[3]-J[4]+J[5]+J[6]-J[7]-J[8]+J[9]-J[10]+J[11]+J[12]+J[13]-J[14]+J[15]-J[16]-J[17]-J[18]+
    J[19]-J[20]-J[21]-J[22]+J[23]+J[24]-J[25]-J[26]+J[27], -H[0]-H[1]+H[2]+H[3]-H[4]-H[5]+H[6]+H[7]+J[0]-J[1]-J[2]+
    J[3]+J[4]-J[5]-J[6]-J[7]-J[8]+J[9]+J[10]-J[11]-J[12]+J[13]-J[14]-J[15]+J[16]+J[17]-J[18]-J[19]+J[20]+
    J[21]+J[22]-J[23]-J[24]-J[25]-J[26]+J[27], -H[0]-H[1]+H[2]+H[3]-H[4]-H[5]+H[6]-H[7]+J[0]-J[1]-J[2]+J[3]+
    J[4]-J[5]+J[6]-J[7]-J[8]+J[9]+J[10]-J[11]+J[12]+J[13]-J[14]-J[15]+J[16]-J[17]-J[18]-J[19]+J[20]-J[21]+
    J[22]-J[23]+J[24]-J[25]+J[26]-J[27], -H[0]-H[1]+H[2]+H[3]-H[4]-H[5]-H[6]+H[7]+J[0]-J[1]-J[2]+J[3]+J[4]+
    J[5]-J[6]-J[7]-J[8]+J[9]+J[10]+J[11]-J[12]+J[13]-J[14]-J[15]-J[16]+J[17]-J[18]-J[19]-J[20]+J[21]+J[22]+
    J[23]-J[24]+J[25]-J[26]-J[27], -H[0]-H[1]+H[2]+H[3]-H[4]-H[5]-H[6]-H[7]+J[0]-J[1]-J[2]+J[3]+J[4]+J[5]+
    J[6]-J[7]-J[8]+J[9]+J[10]+J[11]+J[12]+J[13]-J[14]-J[15]-J[16]-J[17]-J[18]-J[19]-J[20]-J[21]+J[22]+J[23]+
    J[24]+J[25]+J[26]+J[27], -H[0]-H[1]+H[2]-H[3]+H[4]+H[5]+H[6]+H[7]+J[0]-J[1]+J[2]-J[3]-J[4]-J[5]-J[6]-J[7]+
    J[8]-J[9]-J[10]-J[11]-J[12]-J[13]+J[14]+J[15]+J[16]+J[17]-J[18]-J[19]-J[20]-J[21]+J[22]+J[23]+J[24]+
    J[25]+J[26]+J[27], -H[0]-H[1]+H[2]-H[3]+H[4]+H[5]+H[6]-H[7]+J[0]-J[1]+J[2]-J[3]-J[4]-J[5]+J[6]-J[7]+
    J[8]-J[9]-J[10]-J[11]+J[12]-J[13]+J[14]+J[15]+J[16]-J[17]-J[18]-J[19]-J[20]+J[21]+J[22]+J[23]-J[24]+
    J[25]-J[26]-J[27], -H[0]-H[1]+H[2]-H[3]+H[4]+H[5]-H[6]+H[7]+J[0]-J[1]+J[2]-J[3]-J[4]+J[5]-J[6]-J[7]+
    J[8]-J[9]-J[10]+J[11]-J[12]-J[13]+J[14]+J[15]-J[16]+J[17]-J[18]-J[19]+J[20]-J[21]+J[22]-J[23]+J[24]-J[25]+
    J[26]-J[27], -H[0]-H[1]+H[2]-H[3]+H[4]+H[5]-H[6]-H[7]+J[0]-J[1]+J[2]-J[3]-J[4]+J[5]+J[6]-J[7]+J[8]-J[9]-J[10]+
    J[11]+J[12]-J[13]+J[14]+J[15]-J[16]-J[17]-J[18]-J[19]+J[20]+J[21]+J[22]-J[23]-J[24]-J[25]-J[26]+J[27], -H[0]-H[1]+
    H[2]-H[3]+H[4]-H[5]+H[6]+H[7]+J[0]-J[1]+J[2]-J[3]+J[4]-J[5]-J[6]-J[7]+J[8]-J[9]+J[10]-J[11]-J[12]-J[13]+
    J[14]-J[15]+J[16]+J[17]-J[18]+J[19]-J[20]-J[21]-J[22]+J[23]+J[24]-J[25]-J[26]+J[27], -H[0]-H[1]+H[2]-H[3]+
    H[4]-H[5]+H[6]-H[7]+J[0]-J[1]+J[2]-J[3]+J[4]-J[5]+J[6]-J[7]+J[8]-J[9]+J[10]-J[11]+J[12]-J[13]+J[14]-J[15]+
    J[16]-J[17]-J[18]+J[19]-J[20]+J[21]-J[22]+J[23]-J[24]-J[25]+J[26]-J[27], -H[0]-H[1]+H[2]-H[3]+H[4]-H[5]-H[6]+
    H[7]+J[0]-J[1]+J[2]-J[3]+J[4]+J[5]-J[6]-J[7]+J[8]-J[9]+J[10]+J[11]-J[12]-J[13]+J[14]-J[15]-J[16]+J[17]-J[18]+
    J[19]+J[20]-J[21]-J[22]-J[23]+J[24]+J[25]-J[26]-J[27], -H[0]-H[1]+H[2]-H[3]+H[4]-H[5]-H[6]-H[7]+J[0]-J[1]+
    J[2]-J[3]+J[4]+J[5]+J[6]-J[7]+J[8]-J[9]+J[10]+J[11]+J[12]-J[13]+J[14]-J[15]-J[16]-J[17]-J[18]+J[19]+
    J[20]+J[21]-J[22]-J[23]-J[24]+J[25]+J[26]+J[27], -H[0]-H[1]+H[2]-H[3]-H[4]+H[5]+H[6]+H[7]+J[0]-J[1]+
    J[2]+J[3]-J[4]-J[5]-J[6]-J[7]+J[8]+J[9]-J[10]-J[11]-J[12]-J[13]-J[14]+J[15]+J[16]+J[17]+J[18]-J[19]-J[20]-J[21]-J[22]-J[23]-J[24]+
    J[25]+J[26]+J[27], -H[0]-H[1]+H[2]-H[3]-H[4]+H[5]+H[6]-H[7]+J[0]-J[1]+J[2]+J[3]-J[4]-J[5]+J[6]-J[7]+
    J[8]+J[9]-J[10]-J[11]+J[12]-J[13]-J[14]+J[15]+J[16]-J[17]+J[18]-J[19]-J[20]+J[21]-J[22]-J[23]+J[24]+
    J[25]-J[26]-J[27], -H[0]-H[1]+H[2]-H[3]-H[4]+H[5]-H[6]+H[7]+J[0]-J[1]+J[2]+J[3]-J[4]+J[5]-J[6]-J[7]+
    J[8]+J[9]-J[10]+J[11]-J[12]-J[13]-J[14]+J[15]-J[16]+J[17]+J[18]-J[19]+J[20]-J[21]-J[22]+J[23]-J[24]-J[25]+
    J[26]-J[27], -H[0]-H[1]+H[2]-H[3]-H[4]+H[5]-H[6]-H[7]+J[0]-J[1]+J[2]+J[3]-J[4]+J[5]+J[6]-J[7]+J[8]+J[9]-J[10]+
    J[11]+J[12]-J[13]-J[14]+J[15]-J[16]-J[17]+J[18]-J[19]+J[20]+J[21]-J[22]+J[23]+J[24]-J[25]-J[26]+J[27], -H[0]-H[1]+
    H[2]-H[3]-H[4]-H[5]+H[6]+H[7]+J[0]-J[1]+J[2]+J[3]+J[4]-J[5]-J[6]-J[7]+J[8]+J[9]+J[10]-J[11]-J[12]-J[13]-J[14]-J[15]+
    J[16]+J[17]+J[18]+J[19]-J[20]-J[21]+J[22]-J[23]-J[24]-J[25]-J[26]+J[27], -H[0]-H[1]+H[2]-H[3]-H[4]-H[5]+
    H[6]-H[7]+J[0]-J[1]+J[2]+J[3]+J[4]-J[5]+J[6]-J[7]+J[8]+J[9]+J[10]-J[11]+J[12]-J[13]-J[14]-J[15]+J[16]-J[17]+
    J[18]+J[19]-J[20]+J[21]+J[22]-J[23]+J[24]-J[25]+J[26]-J[27], -H[0]-H[1]+H[2]-H[3]-H[4]-H[5]-H[6]+H[7]+
    J[0]-J[1]+J[2]+J[3]+J[4]+J[5]-J[6]-J[7]+J[8]+J[9]+J[10]+J[11]-J[12]-J[13]-J[14]-J[15]-J[16]+J[17]+J[18]+
    J[19]+J[20]-J[21]+J[22]+J[23]-J[24]+J[25]-J[26]-J[27], -H[0]-H[1]+H[2]-H[3]-H[4]-H[5]-H[6]-H[7]+J[0]-J[1]+
    J[2]+J[3]+J[4]+J[5]+J[6]-J[7]+J[8]+J[9]+J[10]+J[11]+J[12]-J[13]-J[14]-J[15]-J[16]-J[17]+J[18]+J[19]+
    J[20]+J[21]+J[22]+J[23]+J[24]+J[25]+J[26]+J[27], -H[0]-H[1]-H[2]+H[3]+H[4]+H[5]+H[6]+H[7]+J[0]+J[1]-J[2]-J[3]-J[4]-J[5]-J[6]+
    J[7]-J[8]-J[9]-J[10]-J[11]-J[12]-J[13]-J[14]-J[15]-J[16]-J[17]+J[18]+J[19]+J[20]+J[21]+J[22]+J[23]+J[24]+
    J[25]+J[26]+J[27], -H[0]-H[1]-H[2]+H[3]+H[4]+H[5]+H[6]-H[7]+J[0]+J[1]-J[2]-J[3]-J[4]-J[5]+J[6]+J[7]-J[8]-J[9]-J[10]-J[11]+
    J[12]-J[13]-J[14]-J[15]-J[16]+J[17]+J[18]+J[19]+J[20]-J[21]+J[22]+J[23]-J[24]+J[25]-J[26]-J[27], -H[0]-H[1]-H[2]+
    H[3]+H[4]+H[5]-H[6]+H[7]+J[0]+J[1]-J[2]-J[3]-J[4]+J[5]-J[6]+J[7]-J[8]-J[9]-J[10]+J[11]-J[12]-J[13]-J[14]-J[15]+
    J[16]-J[17]+J[18]+J[19]-J[20]+J[21]+J[22]-J[23]+J[24]-J[25]+J[26]-J[27], -H[0]-H[1]-H[2]+H[3]+H[4]+H[5]-H[6]-H[7]+
    J[0]+J[1]-J[2]-J[3]-J[4]+J[5]+J[6]+J[7]-J[8]-J[9]-J[10]+J[11]+J[12]-J[13]-J[14]-J[15]+J[16]+J[17]+J[18]+
    J[19]-J[20]-J[21]+J[22]-J[23]-J[24]-J[25]-J[26]+J[27], -H[0]-H[1]-H[2]+H[3]+H[4]-H[5]+H[6]+H[7]+J[0]+
    J[1]-J[2]-J[3]+J[4]-J[5]-J[6]+J[7]-J[8]-J[9]+J[10]-J[11]-J[12]-J[13]-J[14]+J[15]-J[16]-J[17]+J[18]-J[19]+
    J[20]+J[21]-J[22]+J[23]+J[24]-J[25]-J[26]+J[27], -H[0]-H[1]-H[2]+H[3]+H[4]-H[5]+H[6]-H[7]+J[0]+J[1]-J[2]-J[3]+
    J[4]-J[5]+J[6]+J[7]-J[8]-J[9]+J[10]-J[11]+J[12]-J[13]-J[14]+J[15]-J[16]+J[17]+J[18]-J[19]+J[20]-J[21]-J[22]+
    J[23]-J[24]-J[25]+J[26]-J[27], -H[0]-H[1]-H[2]+H[3]+H[4]-H[5]-H[6]+H[7]+J[0]+J[1]-J[2]-J[3]+J[4]+J[5]-J[6]+
    J[7]-J[8]-J[9]+J[10]+J[11]-J[12]-J[13]-J[14]+J[15]+J[16]-J[17]+J[18]-J[19]-J[20]+J[21]-J[22]-J[23]+J[24]+
    J[25]-J[26]-J[27], -H[0]-H[1]-H[2]+H[3]+H[4]-H[5]-H[6]-H[7]+J[0]+J[1]-J[2]-J[3]+J[4]+J[5]+J[6]+J[7]-J[8]-J[9]+
    J[10]+J[11]+J[12]-J[13]-J[14]+J[15]+J[16]+J[17]+J[18]-J[19]-J[20]-J[21]-J[22]-J[23]-J[24]+J[25]+J[26]+
    J[27], -H[0]-H[1]-H[2]+H[3]-H[4]+H[5]+H[6]+H[7]+J[0]+J[1]-J[2]+J[3]-J[4]-J[5]-J[6]+J[7]-J[8]+J[9]-J[10]-J[11]-J[12]-J[13]+
    J[14]-J[15]-J[16]-J[17]-J[18]+J[19]+J[20]+J[21]-J[22]-J[23]-J[24]+J[25]+J[26]+J[27], -H[0]-H[1]-H[2]+
    H[3]-H[4]+H[5]+H[6]-H[7]+J[0]+J[1]-J[2]+J[3]-J[4]-J[5]+J[6]+J[7]-J[8]+J[9]-J[10]-J[11]+J[12]-J[13]+J[14]-J[15]-J[16]+
    J[17]-J[18]+J[19]+J[20]-J[21]-J[22]-J[23]+J[24]+J[25]-J[26]-J[27], -H[0]-H[1]-H[2]+H[3]-H[4]+H[5]-H[6]+
    H[7]+J[0]+J[1]-J[2]+J[3]-J[4]+J[5]-J[6]+J[7]-J[8]+J[9]-J[10]+J[11]-J[12]-J[13]+J[14]-J[15]+J[16]-J[17]-J[18]+
    J[19]-J[20]+J[21]-J[22]+J[23]-J[24]-J[25]+J[26]-J[27], -H[0]-H[1]-H[2]+H[3]-H[4]+H[5]-H[6]-H[7]+J[0]+
    J[1]-J[2]+J[3]-J[4]+J[5]+J[6]+J[7]-J[8]+J[9]-J[10]+J[11]+J[12]-J[13]+J[14]-J[15]+J[16]+J[17]-J[18]+J[19]-J[20]-J[21]-J[22]+
    J[23]+J[24]-J[25]-J[26]+J[27], -H[0]-H[1]-H[2]+H[3]-H[4]-H[5]+H[6]+H[7]+J[0]+J[1]-J[2]+J[3]+J[4]-J[5]-J[6]+
    J[7]-J[8]+J[9]+J[10]-J[11]-J[12]-J[13]+J[14]+J[15]-J[16]-J[17]-J[18]-J[19]+J[20]+J[21]+J[22]-J[23]-J[24]-J[25]-J[26]+
    J[27], -H[0]-H[1]-H[2]+H[3]-H[4]-H[5]+H[6]-H[7]+J[0]+J[1]-J[2]+J[3]+J[4]-J[5]+J[6]+J[7]-J[8]+J[9]+J[10]-J[11]+
    J[12]-J[13]+J[14]+J[15]-J[16]+J[17]-J[18]-J[19]+J[20]-J[21]+J[22]-J[23]+J[24]-J[25]+J[26]-J[27], -H[0]-H[1]-H[2]+
    H[3]-H[4]-H[5]-H[6]+H[7]+J[0]+J[1]-J[2]+J[3]+J[4]+J[5]-J[6]+J[7]-J[8]+J[9]+J[10]+J[11]-J[12]-J[13]+J[14]+
    J[15]+J[16]-J[17]-J[18]-J[19]-J[20]+J[21]+J[22]+J[23]-J[24]+J[25]-J[26]-J[27], -H[0]-H[1]-H[2]+H[3]-H[4]-H[5]-H[6]-H[7]+
    J[0]+J[1]-J[2]+J[3]+J[4]+J[5]+J[6]+J[7]-J[8]+J[9]+J[10]+J[11]+J[12]-J[13]+J[14]+J[15]+J[16]+J[17]-J[18]-J[19]-J[20]-J[21]+
    J[22]+J[23]+J[24]+J[25]+J[26]+J[27], -H[0]-H[1]-H[2]-H[3]+H[4]+H[5]+H[6]+H[7]+J[0]+J[1]+J[2]-J[3]-J[4]-J[5]-J[6]+
    J[7]+J[8]-J[9]-J[10]-J[11]-J[12]+J[13]-J[14]-J[15]-J[16]-J[17]-J[18]-J[19]-J[20]-J[21]+J[22]+J[23]+J[24]+
    J[25]+J[26]+J[27], -H[0]-H[1]-H[2]-H[3]+H[4]+H[5]+H[6]-H[7]+J[0]+J[1]+J[2]-J[3]-J[4]-J[5]+J[6]+J[7]+
    J[8]-J[9]-J[10]-J[11]+J[12]+J[13]-J[14]-J[15]-J[16]+J[17]-J[18]-J[19]-J[20]+J[21]+J[22]+J[23]-J[24]+
    J[25]-J[26]-J[27], -H[0]-H[1]-H[2]-H[3]+H[4]+H[5]-H[6]+H[7]+J[0]+J[1]+J[2]-J[3]-J[4]+J[5]-J[6]+J[7]+
    J[8]-J[9]-J[10]+J[11]-J[12]+J[13]-J[14]-J[15]+J[16]-J[17]-J[18]-J[19]+J[20]-J[21]+J[22]-J[23]+J[24]-J[25]+
    J[26]-J[27], -H[0]-H[1]-H[2]-H[3]+H[4]+H[5]-H[6]-H[7]+J[0]+J[1]+J[2]-J[3]-J[4]+J[5]+J[6]+J[7]+J[8]-J[9]-J[10]+
    J[11]+J[12]+J[13]-J[14]-J[15]+J[16]+J[17]-J[18]-J[19]+J[20]+J[21]+J[22]-J[23]-J[24]-J[25]-J[26]+J[27], -H[0]-H[1]-H[2]-H[3]+
    H[4]-H[5]+H[6]+H[7]+J[0]+J[1]+J[2]-J[3]+J[4]-J[5]-J[6]+J[7]+J[8]-J[9]+J[10]-J[11]-J[12]+J[13]-J[14]+
    J[15]-J[16]-J[17]-J[18]+J[19]-J[20]-J[21]-J[22]+J[23]+J[24]-J[25]-J[26]+J[27], -H[0]-H[1]-H[2]-H[3]+
    H[4]-H[5]+H[6]-H[7]+J[0]+J[1]+J[2]-J[3]+J[4]-J[5]+J[6]+J[7]+J[8]-J[9]+J[10]-J[11]+J[12]+J[13]-J[14]+
    J[15]-J[16]+J[17]-J[18]+J[19]-J[20]+J[21]-J[22]+J[23]-J[24]-J[25]+J[26]-J[27], -H[0]-H[1]-H[2]-H[3]+
    H[4]-H[5]-H[6]+H[7]+J[0]+J[1]+J[2]-J[3]+J[4]+J[5]-J[6]+J[7]+J[8]-J[9]+J[10]+J[11]-J[12]+J[13]-J[14]+
    J[15]+J[16]-J[17]-J[18]+J[19]+J[20]-J[21]-J[22]-J[23]+J[24]+J[25]-J[26]-J[27], -H[0]-H[1]-H[2]-H[3]+
    H[4]-H[5]-H[6]-H[7]+J[0]+J[1]+J[2]-J[3]+J[4]+J[5]+J[6]+J[7]+J[8]-J[9]+J[10]+J[11]+J[12]+J[13]-J[14]+
    J[15]+J[16]+J[17]-J[18]+J[19]+J[20]+J[21]-J[22]-J[23]-J[24]+J[25]+J[26]+J[27], -H[0]-H[1]-H[2]-H[3]-H[4]+
    H[5]+H[6]+H[7]+J[0]+J[1]+J[2]+J[3]-J[4]-J[5]-J[6]+J[7]+J[8]+J[9]-J[10]-J[11]-J[12]+J[13]+J[14]-J[15]-J[16]-J[17]+
    J[18]-J[19]-J[20]-J[21]-J[22]-J[23]-J[24]+J[25]+J[26]+J[27], -H[0]-H[1]-H[2]-H[3]-H[4]+H[5]+H[6]-H[7]+
    J[0]+J[1]+J[2]+J[3]-J[4]-J[5]+J[6]+J[7]+J[8]+J[9]-J[10]-J[11]+J[12]+J[13]+J[14]-J[15]-J[16]+J[17]+J[18]-J[19]-J[20]+
    J[21]-J[22]-J[23]+J[24]+J[25]-J[26]-J[27], -H[0]-H[1]-H[2]-H[3]-H[4]+H[5]-H[6]+H[7]+J[0]+J[1]+J[2]+J[3]-J[4]+
    J[5]-J[6]+J[7]+J[8]+J[9]-J[10]+J[11]-J[12]+J[13]+J[14]-J[15]+J[16]-J[17]+J[18]-J[19]+J[20]-J[21]-J[22]+
    J[23]-J[24]-J[25]+J[26]-J[27], -H[0]-H[1]-H[2]-H[3]-H[4]+H[5]-H[6]-H[7]+J[0]+J[1]+J[2]+J[3]-J[4]+J[5]+
    J[6]+J[7]+J[8]+J[9]-J[10]+J[11]+J[12]+J[13]+J[14]-J[15]+J[16]+J[17]+J[18]-J[19]+J[20]+J[21]-J[22]+J[23]+
    J[24]-J[25]-J[26]+J[27], -H[0]-H[1]-H[2]-H[3]-H[4]-H[5]+H[6]+H[7]+J[0]+J[1]+J[2]+J[3]+J[4]-J[5]-J[6]+
    J[7]+J[8]+J[9]+J[10]-J[11]-J[12]+J[13]+J[14]+J[15]-J[16]-J[17]+J[18]+J[19]-J[20]-J[21]+J[22]-J[23]-J[24]-J[25]-J[26]+
    J[27], -H[0]-H[1]-H[2]-H[3]-H[4]-H[5]+H[6]-H[7]+J[0]+J[1]+J[2]+J[3]+J[4]-J[5]+J[6]+J[7]+J[8]+J[9]+J[10]-J[11]+
    J[12]+J[13]+J[14]+J[15]-J[16]+J[17]+J[18]+J[19]-J[20]+J[21]+J[22]-J[23]+J[24]-J[25]+J[26]-J[27], -H[0]-H[1]-H[2]-H[3]-H[4]-H[5]-H[6]+
    H[7]+J[0]+J[1]+J[2]+J[3]+J[4]+J[5]-J[6]+J[7]+J[8]+J[9]+J[10]+J[11]-J[12]+J[13]+J[14]+J[15]+J[16]-J[17]+
    J[18]+J[19]+J[20]-J[21]+J[22]+J[23]-J[24]+J[25]-J[26]-J[27], -H[0]-H[1]-H[2]-H[3]-H[4]-H[5]-H[6]-H[7]+
    J[0]+J[1]+J[2]+J[3]+J[4]+J[5]+J[6]+J[7]+J[8]+J[9]+J[10]+J[11]+J[12]+J[13]+J[14]+J[15]+J[16]+J[17]+J[18]+
            J[19]+J[20]+J[21]+J[22]+J[23]+J[24]+J[25]+J[26]+J[27],])
    logZ = fast_logsumexp(energyTerms)[0]
    Pout[0] = exp( +H[0]+H[1]+H[2]+H[3]+H[4]+H[5]+H[6]+H[7]+J[0]+J[1]+J[2]+J[3]+J[4]+J[5]+J[6]+J[7]+J[8]+J[9]+J[10]+J[11]+J[12]+J[13]+J[14]+J[15]+J[16]+J[17]+J[18]+J[19]+J[20]+J[21]+J[22]+J[23]+J[24]+J[25]+J[26]+J[27] - logZ )
    Pout[1] = exp( +H[0]+H[1]+H[2]+H[3]+H[4]+H[5]+H[6]-H[7]+J[0]+J[1]+J[2]+J[3]+J[4]+J[5]-J[6]+J[7]+J[8]+J[9]+J[10]+J[11]-J[12]+J[13]+J[14]+J[15]+J[16]-J[17]+J[18]+J[19]+J[20]-J[21]+J[22]+J[23]-J[24]+J[25]-J[26]-J[27] - logZ )
    Pout[2] = exp( +H[0]+H[1]+H[2]+H[3]+H[4]+H[5]-H[6]+H[7]+J[0]+J[1]+J[2]+J[3]+J[4]-J[5]+J[6]+J[7]+J[8]+J[9]+J[10]-J[11]+J[12]+J[13]+J[14]+J[15]-J[16]+J[17]+J[18]+J[19]-J[20]+J[21]+J[22]-J[23]+J[24]-J[25]+J[26]-J[27] - logZ )
    Pout[3] = exp( +H[0]+H[1]+H[2]+H[3]+H[4]+H[5]-H[6]-H[7]+J[0]+J[1]+J[2]+J[3]+J[4]-J[5]-J[6]+J[7]+J[8]+J[9]+J[10]-J[11]-J[12]+J[13]+J[14]+J[15]-J[16]-J[17]+J[18]+J[19]-J[20]-J[21]+J[22]-J[23]-J[24]-J[25]-J[26]+J[27] - logZ )
    Pout[4] = exp( +H[0]+H[1]+H[2]+H[3]+H[4]-H[5]+H[6]+H[7]+J[0]+J[1]+J[2]+J[3]-J[4]+J[5]+J[6]+J[7]+J[8]+J[9]-J[10]+J[11]+J[12]+J[13]+J[14]-J[15]+J[16]+J[17]+J[18]-J[19]+J[20]+J[21]-J[22]+J[23]+J[24]-J[25]-J[26]+J[27] - logZ )
    Pout[5] = exp( +H[0]+H[1]+H[2]+H[3]+H[4]-H[5]+H[6]-H[7]+J[0]+J[1]+J[2]+J[3]-J[4]+J[5]-J[6]+J[7]+J[8]+J[9]-J[10]+J[11]-J[12]+J[13]+J[14]-J[15]+J[16]-J[17]+J[18]-J[19]+J[20]-J[21]-J[22]+J[23]-J[24]-J[25]+J[26]-J[27] - logZ )
    Pout[6] = exp( +H[0]+H[1]+H[2]+H[3]+H[4]-H[5]-H[6]+H[7]+J[0]+J[1]+J[2]+J[3]-J[4]-J[5]+J[6]+J[7]+J[8]+J[9]-J[10]-J[11]+J[12]+J[13]+J[14]-J[15]-J[16]+J[17]+J[18]-J[19]-J[20]+J[21]-J[22]-J[23]+J[24]+J[25]-J[26]-J[27] - logZ )
    Pout[7] = exp( +H[0]+H[1]+H[2]+H[3]+H[4]-H[5]-H[6]-H[7]+J[0]+J[1]+J[2]+J[3]-J[4]-J[5]-J[6]+J[7]+J[8]+J[9]-J[10]-J[11]-J[12]+J[13]+J[14]-J[15]-J[16]-J[17]+J[18]-J[19]-J[20]-J[21]-J[22]-J[23]-J[24]+J[25]+J[26]+J[27] - logZ )
    Pout[8] = exp( +H[0]+H[1]+H[2]+H[3]-H[4]+H[5]+H[6]+H[7]+J[0]+J[1]+J[2]-J[3]+J[4]+J[5]+J[6]+J[7]+J[8]-J[9]+J[10]+J[11]+J[12]+J[13]-J[14]+J[15]+J[16]+J[17]-J[18]+J[19]+J[20]+J[21]-J[22]-J[23]-J[24]+J[25]+J[26]+J[27] - logZ )
    Pout[9] = exp( +H[0]+H[1]+H[2]+H[3]-H[4]+H[5]+H[6]-H[7]+J[0]+J[1]+J[2]-J[3]+J[4]+J[5]-J[6]+J[7]+J[8]-J[9]+J[10]+J[11]-J[12]+J[13]-J[14]+J[15]+J[16]-J[17]-J[18]+J[19]+J[20]-J[21]-J[22]-J[23]+J[24]+J[25]-J[26]-J[27] - logZ )
    Pout[10] = exp( +H[0]+H[1]+H[2]+H[3]-H[4]+H[5]-H[6]+H[7]+J[0]+J[1]+J[2]-J[3]+J[4]-J[5]+J[6]+J[7]+J[8]-J[9]+J[10]-J[11]+J[12]+J[13]-J[14]+J[15]-J[16]+J[17]-J[18]+J[19]-J[20]+J[21]-J[22]+J[23]-J[24]-J[25]+J[26]-J[27] - logZ )
    Pout[11] = exp( +H[0]+H[1]+H[2]+H[3]-H[4]+H[5]-H[6]-H[7]+J[0]+J[1]+J[2]-J[3]+J[4]-J[5]-J[6]+J[7]+J[8]-J[9]+J[10]-J[11]-J[12]+J[13]-J[14]+J[15]-J[16]-J[17]-J[18]+J[19]-J[20]-J[21]-J[22]+J[23]+J[24]-J[25]-J[26]+J[27] - logZ )
    Pout[12] = exp( +H[0]+H[1]+H[2]+H[3]-H[4]-H[5]+H[6]+H[7]+J[0]+J[1]+J[2]-J[3]-J[4]+J[5]+J[6]+J[7]+J[8]-J[9]-J[10]+J[11]+J[12]+J[13]-J[14]-J[15]+J[16]+J[17]-J[18]-J[19]+J[20]+J[21]+J[22]-J[23]-J[24]-J[25]-J[26]+J[27] - logZ )
    Pout[13] = exp( +H[0]+H[1]+H[2]+H[3]-H[4]-H[5]+H[6]-H[7]+J[0]+J[1]+J[2]-J[3]-J[4]+J[5]-J[6]+J[7]+J[8]-J[9]-J[10]+J[11]-J[12]+J[13]-J[14]-J[15]+J[16]-J[17]-J[18]-J[19]+J[20]-J[21]+J[22]-J[23]+J[24]-J[25]+J[26]-J[27] - logZ )
    Pout[14] = exp( +H[0]+H[1]+H[2]+H[3]-H[4]-H[5]-H[6]+H[7]+J[0]+J[1]+J[2]-J[3]-J[4]-J[5]+J[6]+J[7]+J[8]-J[9]-J[10]-J[11]+J[12]+J[13]-J[14]-J[15]-J[16]+J[17]-J[18]-J[19]-J[20]+J[21]+J[22]+J[23]-J[24]+J[25]-J[26]-J[27] - logZ )
    Pout[15] = exp( +H[0]+H[1]+H[2]+H[3]-H[4]-H[5]-H[6]-H[7]+J[0]+J[1]+J[2]-J[3]-J[4]-J[5]-J[6]+J[7]+J[8]-J[9]-J[10]-J[11]-J[12]+J[13]-J[14]-J[15]-J[16]-J[17]-J[18]-J[19]-J[20]-J[21]+J[22]+J[23]+J[24]+J[25]+J[26]+J[27] - logZ )
    Pout[16] = exp( +H[0]+H[1]+H[2]-H[3]+H[4]+H[5]+H[6]+H[7]+J[0]+J[1]-J[2]+J[3]+J[4]+J[5]+J[6]+J[7]-J[8]+J[9]+J[10]+J[11]+J[12]-J[13]+J[14]+J[15]+J[16]+J[17]-J[18]-J[19]-J[20]-J[21]+J[22]+J[23]+J[24]+J[25]+J[26]+J[27] - logZ )
    Pout[17] = exp( +H[0]+H[1]+H[2]-H[3]+H[4]+H[5]+H[6]-H[7]+J[0]+J[1]-J[2]+J[3]+J[4]+J[5]-J[6]+J[7]-J[8]+J[9]+J[10]+J[11]-J[12]-J[13]+J[14]+J[15]+J[16]-J[17]-J[18]-J[19]-J[20]+J[21]+J[22]+J[23]-J[24]+J[25]-J[26]-J[27] - logZ )
    Pout[18] = exp( +H[0]+H[1]+H[2]-H[3]+H[4]+H[5]-H[6]+H[7]+J[0]+J[1]-J[2]+J[3]+J[4]-J[5]+J[6]+J[7]-J[8]+J[9]+J[10]-J[11]+J[12]-J[13]+J[14]+J[15]-J[16]+J[17]-J[18]-J[19]+J[20]-J[21]+J[22]-J[23]+J[24]-J[25]+J[26]-J[27] - logZ )
    Pout[19] = exp( +H[0]+H[1]+H[2]-H[3]+H[4]+H[5]-H[6]-H[7]+J[0]+J[1]-J[2]+J[3]+J[4]-J[5]-J[6]+J[7]-J[8]+J[9]+J[10]-J[11]-J[12]-J[13]+J[14]+J[15]-J[16]-J[17]-J[18]-J[19]+J[20]+J[21]+J[22]-J[23]-J[24]-J[25]-J[26]+J[27] - logZ )
    Pout[20] = exp( +H[0]+H[1]+H[2]-H[3]+H[4]-H[5]+H[6]+H[7]+J[0]+J[1]-J[2]+J[3]-J[4]+J[5]+J[6]+J[7]-J[8]+J[9]-J[10]+J[11]+J[12]-J[13]+J[14]-J[15]+J[16]+J[17]-J[18]+J[19]-J[20]-J[21]-J[22]+J[23]+J[24]-J[25]-J[26]+J[27] - logZ )
    Pout[21] = exp( +H[0]+H[1]+H[2]-H[3]+H[4]-H[5]+H[6]-H[7]+J[0]+J[1]-J[2]+J[3]-J[4]+J[5]-J[6]+J[7]-J[8]+J[9]-J[10]+J[11]-J[12]-J[13]+J[14]-J[15]+J[16]-J[17]-J[18]+J[19]-J[20]+J[21]-J[22]+J[23]-J[24]-J[25]+J[26]-J[27] - logZ )
    Pout[22] = exp( +H[0]+H[1]+H[2]-H[3]+H[4]-H[5]-H[6]+H[7]+J[0]+J[1]-J[2]+J[3]-J[4]-J[5]+J[6]+J[7]-J[8]+J[9]-J[10]-J[11]+J[12]-J[13]+J[14]-J[15]-J[16]+J[17]-J[18]+J[19]+J[20]-J[21]-J[22]-J[23]+J[24]+J[25]-J[26]-J[27] - logZ )
    Pout[23] = exp( +H[0]+H[1]+H[2]-H[3]+H[4]-H[5]-H[6]-H[7]+J[0]+J[1]-J[2]+J[3]-J[4]-J[5]-J[6]+J[7]-J[8]+J[9]-J[10]-J[11]-J[12]-J[13]+J[14]-J[15]-J[16]-J[17]-J[18]+J[19]+J[20]+J[21]-J[22]-J[23]-J[24]+J[25]+J[26]+J[27] - logZ )
    Pout[24] = exp( +H[0]+H[1]+H[2]-H[3]-H[4]+H[5]+H[6]+H[7]+J[0]+J[1]-J[2]-J[3]+J[4]+J[5]+J[6]+J[7]-J[8]-J[9]+J[10]+J[11]+J[12]-J[13]-J[14]+J[15]+J[16]+J[17]+J[18]-J[19]-J[20]-J[21]-J[22]-J[23]-J[24]+J[25]+J[26]+J[27] - logZ )
    Pout[25] = exp( +H[0]+H[1]+H[2]-H[3]-H[4]+H[5]+H[6]-H[7]+J[0]+J[1]-J[2]-J[3]+J[4]+J[5]-J[6]+J[7]-J[8]-J[9]+J[10]+J[11]-J[12]-J[13]-J[14]+J[15]+J[16]-J[17]+J[18]-J[19]-J[20]+J[21]-J[22]-J[23]+J[24]+J[25]-J[26]-J[27] - logZ )
    Pout[26] = exp( +H[0]+H[1]+H[2]-H[3]-H[4]+H[5]-H[6]+H[7]+J[0]+J[1]-J[2]-J[3]+J[4]-J[5]+J[6]+J[7]-J[8]-J[9]+J[10]-J[11]+J[12]-J[13]-J[14]+J[15]-J[16]+J[17]+J[18]-J[19]+J[20]-J[21]-J[22]+J[23]-J[24]-J[25]+J[26]-J[27] - logZ )
    Pout[27] = exp( +H[0]+H[1]+H[2]-H[3]-H[4]+H[5]-H[6]-H[7]+J[0]+J[1]-J[2]-J[3]+J[4]-J[5]-J[6]+J[7]-J[8]-J[9]+J[10]-J[11]-J[12]-J[13]-J[14]+J[15]-J[16]-J[17]+J[18]-J[19]+J[20]+J[21]-J[22]+J[23]+J[24]-J[25]-J[26]+J[27] - logZ )
    Pout[28] = exp( +H[0]+H[1]+H[2]-H[3]-H[4]-H[5]+H[6]+H[7]+J[0]+J[1]-J[2]-J[3]-J[4]+J[5]+J[6]+J[7]-J[8]-J[9]-J[10]+J[11]+J[12]-J[13]-J[14]-J[15]+J[16]+J[17]+J[18]+J[19]-J[20]-J[21]+J[22]-J[23]-J[24]-J[25]-J[26]+J[27] - logZ )
    Pout[29] = exp( +H[0]+H[1]+H[2]-H[3]-H[4]-H[5]+H[6]-H[7]+J[0]+J[1]-J[2]-J[3]-J[4]+J[5]-J[6]+J[7]-J[8]-J[9]-J[10]+J[11]-J[12]-J[13]-J[14]-J[15]+J[16]-J[17]+J[18]+J[19]-J[20]+J[21]+J[22]-J[23]+J[24]-J[25]+J[26]-J[27] - logZ )
    Pout[30] = exp( +H[0]+H[1]+H[2]-H[3]-H[4]-H[5]-H[6]+H[7]+J[0]+J[1]-J[2]-J[3]-J[4]-J[5]+J[6]+J[7]-J[8]-J[9]-J[10]-J[11]+J[12]-J[13]-J[14]-J[15]-J[16]+J[17]+J[18]+J[19]+J[20]-J[21]+J[22]+J[23]-J[24]+J[25]-J[26]-J[27] - logZ )
    Pout[31] = exp( +H[0]+H[1]+H[2]-H[3]-H[4]-H[5]-H[6]-H[7]+J[0]+J[1]-J[2]-J[3]-J[4]-J[5]-J[6]+J[7]-J[8]-J[9]-J[10]-J[11]-J[12]-J[13]-J[14]-J[15]-J[16]-J[17]+J[18]+J[19]+J[20]+J[21]+J[22]+J[23]+J[24]+J[25]+J[26]+J[27] - logZ )
    Pout[32] = exp( +H[0]+H[1]-H[2]+H[3]+H[4]+H[5]+H[6]+H[7]+J[0]-J[1]+J[2]+J[3]+J[4]+J[5]+J[6]-J[7]+J[8]+J[9]+J[10]+J[11]+J[12]-J[13]-J[14]-J[15]-J[16]-J[17]+J[18]+J[19]+J[20]+J[21]+J[22]+J[23]+J[24]+J[25]+J[26]+J[27] - logZ )
    Pout[33] = exp( +H[0]+H[1]-H[2]+H[3]+H[4]+H[5]+H[6]-H[7]+J[0]-J[1]+J[2]+J[3]+J[4]+J[5]-J[6]-J[7]+J[8]+J[9]+J[10]+J[11]-J[12]-J[13]-J[14]-J[15]-J[16]+J[17]+J[18]+J[19]+J[20]-J[21]+J[22]+J[23]-J[24]+J[25]-J[26]-J[27] - logZ )
    Pout[34] = exp( +H[0]+H[1]-H[2]+H[3]+H[4]+H[5]-H[6]+H[7]+J[0]-J[1]+J[2]+J[3]+J[4]-J[5]+J[6]-J[7]+J[8]+J[9]+J[10]-J[11]+J[12]-J[13]-J[14]-J[15]+J[16]-J[17]+J[18]+J[19]-J[20]+J[21]+J[22]-J[23]+J[24]-J[25]+J[26]-J[27] - logZ )
    Pout[35] = exp( +H[0]+H[1]-H[2]+H[3]+H[4]+H[5]-H[6]-H[7]+J[0]-J[1]+J[2]+J[3]+J[4]-J[5]-J[6]-J[7]+J[8]+J[9]+J[10]-J[11]-J[12]-J[13]-J[14]-J[15]+J[16]+J[17]+J[18]+J[19]-J[20]-J[21]+J[22]-J[23]-J[24]-J[25]-J[26]+J[27] - logZ )
    Pout[36] = exp( +H[0]+H[1]-H[2]+H[3]+H[4]-H[5]+H[6]+H[7]+J[0]-J[1]+J[2]+J[3]-J[4]+J[5]+J[6]-J[7]+J[8]+J[9]-J[10]+J[11]+J[12]-J[13]-J[14]+J[15]-J[16]-J[17]+J[18]-J[19]+J[20]+J[21]-J[22]+J[23]+J[24]-J[25]-J[26]+J[27] - logZ )
    Pout[37] = exp( +H[0]+H[1]-H[2]+H[3]+H[4]-H[5]+H[6]-H[7]+J[0]-J[1]+J[2]+J[3]-J[4]+J[5]-J[6]-J[7]+J[8]+J[9]-J[10]+J[11]-J[12]-J[13]-J[14]+J[15]-J[16]+J[17]+J[18]-J[19]+J[20]-J[21]-J[22]+J[23]-J[24]-J[25]+J[26]-J[27] - logZ )
    Pout[38] = exp( +H[0]+H[1]-H[2]+H[3]+H[4]-H[5]-H[6]+H[7]+J[0]-J[1]+J[2]+J[3]-J[4]-J[5]+J[6]-J[7]+J[8]+J[9]-J[10]-J[11]+J[12]-J[13]-J[14]+J[15]+J[16]-J[17]+J[18]-J[19]-J[20]+J[21]-J[22]-J[23]+J[24]+J[25]-J[26]-J[27] - logZ )
    Pout[39] = exp( +H[0]+H[1]-H[2]+H[3]+H[4]-H[5]-H[6]-H[7]+J[0]-J[1]+J[2]+J[3]-J[4]-J[5]-J[6]-J[7]+J[8]+J[9]-J[10]-J[11]-J[12]-J[13]-J[14]+J[15]+J[16]+J[17]+J[18]-J[19]-J[20]-J[21]-J[22]-J[23]-J[24]+J[25]+J[26]+J[27] - logZ )
    Pout[40] = exp( +H[0]+H[1]-H[2]+H[3]-H[4]+H[5]+H[6]+H[7]+J[0]-J[1]+J[2]-J[3]+J[4]+J[5]+J[6]-J[7]+J[8]-J[9]+J[10]+J[11]+J[12]-J[13]+J[14]-J[15]-J[16]-J[17]-J[18]+J[19]+J[20]+J[21]-J[22]-J[23]-J[24]+J[25]+J[26]+J[27] - logZ )
    Pout[41] = exp( +H[0]+H[1]-H[2]+H[3]-H[4]+H[5]+H[6]-H[7]+J[0]-J[1]+J[2]-J[3]+J[4]+J[5]-J[6]-J[7]+J[8]-J[9]+J[10]+J[11]-J[12]-J[13]+J[14]-J[15]-J[16]+J[17]-J[18]+J[19]+J[20]-J[21]-J[22]-J[23]+J[24]+J[25]-J[26]-J[27] - logZ )
    Pout[42] = exp( +H[0]+H[1]-H[2]+H[3]-H[4]+H[5]-H[6]+H[7]+J[0]-J[1]+J[2]-J[3]+J[4]-J[5]+J[6]-J[7]+J[8]-J[9]+J[10]-J[11]+J[12]-J[13]+J[14]-J[15]+J[16]-J[17]-J[18]+J[19]-J[20]+J[21]-J[22]+J[23]-J[24]-J[25]+J[26]-J[27] - logZ )
    Pout[43] = exp( +H[0]+H[1]-H[2]+H[3]-H[4]+H[5]-H[6]-H[7]+J[0]-J[1]+J[2]-J[3]+J[4]-J[5]-J[6]-J[7]+J[8]-J[9]+J[10]-J[11]-J[12]-J[13]+J[14]-J[15]+J[16]+J[17]-J[18]+J[19]-J[20]-J[21]-J[22]+J[23]+J[24]-J[25]-J[26]+J[27] - logZ )
    Pout[44] = exp( +H[0]+H[1]-H[2]+H[3]-H[4]-H[5]+H[6]+H[7]+J[0]-J[1]+J[2]-J[3]-J[4]+J[5]+J[6]-J[7]+J[8]-J[9]-J[10]+J[11]+J[12]-J[13]+J[14]+J[15]-J[16]-J[17]-J[18]-J[19]+J[20]+J[21]+J[22]-J[23]-J[24]-J[25]-J[26]+J[27] - logZ )
    Pout[45] = exp( +H[0]+H[1]-H[2]+H[3]-H[4]-H[5]+H[6]-H[7]+J[0]-J[1]+J[2]-J[3]-J[4]+J[5]-J[6]-J[7]+J[8]-J[9]-J[10]+J[11]-J[12]-J[13]+J[14]+J[15]-J[16]+J[17]-J[18]-J[19]+J[20]-J[21]+J[22]-J[23]+J[24]-J[25]+J[26]-J[27] - logZ )
    Pout[46] = exp( +H[0]+H[1]-H[2]+H[3]-H[4]-H[5]-H[6]+H[7]+J[0]-J[1]+J[2]-J[3]-J[4]-J[5]+J[6]-J[7]+J[8]-J[9]-J[10]-J[11]+J[12]-J[13]+J[14]+J[15]+J[16]-J[17]-J[18]-J[19]-J[20]+J[21]+J[22]+J[23]-J[24]+J[25]-J[26]-J[27] - logZ )
    Pout[47] = exp( +H[0]+H[1]-H[2]+H[3]-H[4]-H[5]-H[6]-H[7]+J[0]-J[1]+J[2]-J[3]-J[4]-J[5]-J[6]-J[7]+J[8]-J[9]-J[10]-J[11]-J[12]-J[13]+J[14]+J[15]+J[16]+J[17]-J[18]-J[19]-J[20]-J[21]+J[22]+J[23]+J[24]+J[25]+J[26]+J[27] - logZ )
    Pout[48] = exp( +H[0]+H[1]-H[2]-H[3]+H[4]+H[5]+H[6]+H[7]+J[0]-J[1]-J[2]+J[3]+J[4]+J[5]+J[6]-J[7]-J[8]+J[9]+J[10]+J[11]+J[12]+J[13]-J[14]-J[15]-J[16]-J[17]-J[18]-J[19]-J[20]-J[21]+J[22]+J[23]+J[24]+J[25]+J[26]+J[27] - logZ )
    Pout[49] = exp( +H[0]+H[1]-H[2]-H[3]+H[4]+H[5]+H[6]-H[7]+J[0]-J[1]-J[2]+J[3]+J[4]+J[5]-J[6]-J[7]-J[8]+J[9]+J[10]+J[11]-J[12]+J[13]-J[14]-J[15]-J[16]+J[17]-J[18]-J[19]-J[20]+J[21]+J[22]+J[23]-J[24]+J[25]-J[26]-J[27] - logZ )
    Pout[50] = exp( +H[0]+H[1]-H[2]-H[3]+H[4]+H[5]-H[6]+H[7]+J[0]-J[1]-J[2]+J[3]+J[4]-J[5]+J[6]-J[7]-J[8]+J[9]+J[10]-J[11]+J[12]+J[13]-J[14]-J[15]+J[16]-J[17]-J[18]-J[19]+J[20]-J[21]+J[22]-J[23]+J[24]-J[25]+J[26]-J[27] - logZ )
    Pout[51] = exp( +H[0]+H[1]-H[2]-H[3]+H[4]+H[5]-H[6]-H[7]+J[0]-J[1]-J[2]+J[3]+J[4]-J[5]-J[6]-J[7]-J[8]+J[9]+J[10]-J[11]-J[12]+J[13]-J[14]-J[15]+J[16]+J[17]-J[18]-J[19]+J[20]+J[21]+J[22]-J[23]-J[24]-J[25]-J[26]+J[27] - logZ )
    Pout[52] = exp( +H[0]+H[1]-H[2]-H[3]+H[4]-H[5]+H[6]+H[7]+J[0]-J[1]-J[2]+J[3]-J[4]+J[5]+J[6]-J[7]-J[8]+J[9]-J[10]+J[11]+J[12]+J[13]-J[14]+J[15]-J[16]-J[17]-J[18]+J[19]-J[20]-J[21]-J[22]+J[23]+J[24]-J[25]-J[26]+J[27] - logZ )
    Pout[53] = exp( +H[0]+H[1]-H[2]-H[3]+H[4]-H[5]+H[6]-H[7]+J[0]-J[1]-J[2]+J[3]-J[4]+J[5]-J[6]-J[7]-J[8]+J[9]-J[10]+J[11]-J[12]+J[13]-J[14]+J[15]-J[16]+J[17]-J[18]+J[19]-J[20]+J[21]-J[22]+J[23]-J[24]-J[25]+J[26]-J[27] - logZ )
    Pout[54] = exp( +H[0]+H[1]-H[2]-H[3]+H[4]-H[5]-H[6]+H[7]+J[0]-J[1]-J[2]+J[3]-J[4]-J[5]+J[6]-J[7]-J[8]+J[9]-J[10]-J[11]+J[12]+J[13]-J[14]+J[15]+J[16]-J[17]-J[18]+J[19]+J[20]-J[21]-J[22]-J[23]+J[24]+J[25]-J[26]-J[27] - logZ )
    Pout[55] = exp( +H[0]+H[1]-H[2]-H[3]+H[4]-H[5]-H[6]-H[7]+J[0]-J[1]-J[2]+J[3]-J[4]-J[5]-J[6]-J[7]-J[8]+J[9]-J[10]-J[11]-J[12]+J[13]-J[14]+J[15]+J[16]+J[17]-J[18]+J[19]+J[20]+J[21]-J[22]-J[23]-J[24]+J[25]+J[26]+J[27] - logZ )
    Pout[56] = exp( +H[0]+H[1]-H[2]-H[3]-H[4]+H[5]+H[6]+H[7]+J[0]-J[1]-J[2]-J[3]+J[4]+J[5]+J[6]-J[7]-J[8]-J[9]+J[10]+J[11]+J[12]+J[13]+J[14]-J[15]-J[16]-J[17]+J[18]-J[19]-J[20]-J[21]-J[22]-J[23]-J[24]+J[25]+J[26]+J[27] - logZ )
    Pout[57] = exp( +H[0]+H[1]-H[2]-H[3]-H[4]+H[5]+H[6]-H[7]+J[0]-J[1]-J[2]-J[3]+J[4]+J[5]-J[6]-J[7]-J[8]-J[9]+J[10]+J[11]-J[12]+J[13]+J[14]-J[15]-J[16]+J[17]+J[18]-J[19]-J[20]+J[21]-J[22]-J[23]+J[24]+J[25]-J[26]-J[27] - logZ )
    Pout[58] = exp( +H[0]+H[1]-H[2]-H[3]-H[4]+H[5]-H[6]+H[7]+J[0]-J[1]-J[2]-J[3]+J[4]-J[5]+J[6]-J[7]-J[8]-J[9]+J[10]-J[11]+J[12]+J[13]+J[14]-J[15]+J[16]-J[17]+J[18]-J[19]+J[20]-J[21]-J[22]+J[23]-J[24]-J[25]+J[26]-J[27] - logZ )
    Pout[59] = exp( +H[0]+H[1]-H[2]-H[3]-H[4]+H[5]-H[6]-H[7]+J[0]-J[1]-J[2]-J[3]+J[4]-J[5]-J[6]-J[7]-J[8]-J[9]+J[10]-J[11]-J[12]+J[13]+J[14]-J[15]+J[16]+J[17]+J[18]-J[19]+J[20]+J[21]-J[22]+J[23]+J[24]-J[25]-J[26]+J[27] - logZ )
    Pout[60] = exp( +H[0]+H[1]-H[2]-H[3]-H[4]-H[5]+H[6]+H[7]+J[0]-J[1]-J[2]-J[3]-J[4]+J[5]+J[6]-J[7]-J[8]-J[9]-J[10]+J[11]+J[12]+J[13]+J[14]+J[15]-J[16]-J[17]+J[18]+J[19]-J[20]-J[21]+J[22]-J[23]-J[24]-J[25]-J[26]+J[27] - logZ )
    Pout[61] = exp( +H[0]+H[1]-H[2]-H[3]-H[4]-H[5]+H[6]-H[7]+J[0]-J[1]-J[2]-J[3]-J[4]+J[5]-J[6]-J[7]-J[8]-J[9]-J[10]+J[11]-J[12]+J[13]+J[14]+J[15]-J[16]+J[17]+J[18]+J[19]-J[20]+J[21]+J[22]-J[23]+J[24]-J[25]+J[26]-J[27] - logZ )
    Pout[62] = exp( +H[0]+H[1]-H[2]-H[3]-H[4]-H[5]-H[6]+H[7]+J[0]-J[1]-J[2]-J[3]-J[4]-J[5]+J[6]-J[7]-J[8]-J[9]-J[10]-J[11]+J[12]+J[13]+J[14]+J[15]+J[16]-J[17]+J[18]+J[19]+J[20]-J[21]+J[22]+J[23]-J[24]+J[25]-J[26]-J[27] - logZ )
    Pout[63] = exp( +H[0]+H[1]-H[2]-H[3]-H[4]-H[5]-H[6]-H[7]+J[0]-J[1]-J[2]-J[3]-J[4]-J[5]-J[6]-J[7]-J[8]-J[9]-J[10]-J[11]-J[12]+J[13]+J[14]+J[15]+J[16]+J[17]+J[18]+J[19]+J[20]+J[21]+J[22]+J[23]+J[24]+J[25]+J[26]+J[27] - logZ )
    Pout[64] = exp( +H[0]-H[1]+H[2]+H[3]+H[4]+H[5]+H[6]+H[7]-J[0]+J[1]+J[2]+J[3]+J[4]+J[5]+J[6]-J[7]-J[8]-J[9]-J[10]-J[11]-J[12]+J[13]+J[14]+J[15]+J[16]+J[17]+J[18]+J[19]+J[20]+J[21]+J[22]+J[23]+J[24]+J[25]+J[26]+J[27] - logZ )
    Pout[65] = exp( +H[0]-H[1]+H[2]+H[3]+H[4]+H[5]+H[6]-H[7]-J[0]+J[1]+J[2]+J[3]+J[4]+J[5]-J[6]-J[7]-J[8]-J[9]-J[10]-J[11]+J[12]+J[13]+J[14]+J[15]+J[16]-J[17]+J[18]+J[19]+J[20]-J[21]+J[22]+J[23]-J[24]+J[25]-J[26]-J[27] - logZ )
    Pout[66] = exp( +H[0]-H[1]+H[2]+H[3]+H[4]+H[5]-H[6]+H[7]-J[0]+J[1]+J[2]+J[3]+J[4]-J[5]+J[6]-J[7]-J[8]-J[9]-J[10]+J[11]-J[12]+J[13]+J[14]+J[15]-J[16]+J[17]+J[18]+J[19]-J[20]+J[21]+J[22]-J[23]+J[24]-J[25]+J[26]-J[27] - logZ )
    Pout[67] = exp( +H[0]-H[1]+H[2]+H[3]+H[4]+H[5]-H[6]-H[7]-J[0]+J[1]+J[2]+J[3]+J[4]-J[5]-J[6]-J[7]-J[8]-J[9]-J[10]+J[11]+J[12]+J[13]+J[14]+J[15]-J[16]-J[17]+J[18]+J[19]-J[20]-J[21]+J[22]-J[23]-J[24]-J[25]-J[26]+J[27] - logZ )
    Pout[68] = exp( +H[0]-H[1]+H[2]+H[3]+H[4]-H[5]+H[6]+H[7]-J[0]+J[1]+J[2]+J[3]-J[4]+J[5]+J[6]-J[7]-J[8]-J[9]+J[10]-J[11]-J[12]+J[13]+J[14]-J[15]+J[16]+J[17]+J[18]-J[19]+J[20]+J[21]-J[22]+J[23]+J[24]-J[25]-J[26]+J[27] - logZ )
    Pout[69] = exp( +H[0]-H[1]+H[2]+H[3]+H[4]-H[5]+H[6]-H[7]-J[0]+J[1]+J[2]+J[3]-J[4]+J[5]-J[6]-J[7]-J[8]-J[9]+J[10]-J[11]+J[12]+J[13]+J[14]-J[15]+J[16]-J[17]+J[18]-J[19]+J[20]-J[21]-J[22]+J[23]-J[24]-J[25]+J[26]-J[27] - logZ )
    Pout[70] = exp( +H[0]-H[1]+H[2]+H[3]+H[4]-H[5]-H[6]+H[7]-J[0]+J[1]+J[2]+J[3]-J[4]-J[5]+J[6]-J[7]-J[8]-J[9]+J[10]+J[11]-J[12]+J[13]+J[14]-J[15]-J[16]+J[17]+J[18]-J[19]-J[20]+J[21]-J[22]-J[23]+J[24]+J[25]-J[26]-J[27] - logZ )
    Pout[71] = exp( +H[0]-H[1]+H[2]+H[3]+H[4]-H[5]-H[6]-H[7]-J[0]+J[1]+J[2]+J[3]-J[4]-J[5]-J[6]-J[7]-J[8]-J[9]+J[10]+J[11]+J[12]+J[13]+J[14]-J[15]-J[16]-J[17]+J[18]-J[19]-J[20]-J[21]-J[22]-J[23]-J[24]+J[25]+J[26]+J[27] - logZ )
    Pout[72] = exp( +H[0]-H[1]+H[2]+H[3]-H[4]+H[5]+H[6]+H[7]-J[0]+J[1]+J[2]-J[3]+J[4]+J[5]+J[6]-J[7]-J[8]+J[9]-J[10]-J[11]-J[12]+J[13]-J[14]+J[15]+J[16]+J[17]-J[18]+J[19]+J[20]+J[21]-J[22]-J[23]-J[24]+J[25]+J[26]+J[27] - logZ )
    Pout[73] = exp( +H[0]-H[1]+H[2]+H[3]-H[4]+H[5]+H[6]-H[7]-J[0]+J[1]+J[2]-J[3]+J[4]+J[5]-J[6]-J[7]-J[8]+J[9]-J[10]-J[11]+J[12]+J[13]-J[14]+J[15]+J[16]-J[17]-J[18]+J[19]+J[20]-J[21]-J[22]-J[23]+J[24]+J[25]-J[26]-J[27] - logZ )
    Pout[74] = exp( +H[0]-H[1]+H[2]+H[3]-H[4]+H[5]-H[6]+H[7]-J[0]+J[1]+J[2]-J[3]+J[4]-J[5]+J[6]-J[7]-J[8]+J[9]-J[10]+J[11]-J[12]+J[13]-J[14]+J[15]-J[16]+J[17]-J[18]+J[19]-J[20]+J[21]-J[22]+J[23]-J[24]-J[25]+J[26]-J[27] - logZ )
    Pout[75] = exp( +H[0]-H[1]+H[2]+H[3]-H[4]+H[5]-H[6]-H[7]-J[0]+J[1]+J[2]-J[3]+J[4]-J[5]-J[6]-J[7]-J[8]+J[9]-J[10]+J[11]+J[12]+J[13]-J[14]+J[15]-J[16]-J[17]-J[18]+J[19]-J[20]-J[21]-J[22]+J[23]+J[24]-J[25]-J[26]+J[27] - logZ )
    Pout[76] = exp( +H[0]-H[1]+H[2]+H[3]-H[4]-H[5]+H[6]+H[7]-J[0]+J[1]+J[2]-J[3]-J[4]+J[5]+J[6]-J[7]-J[8]+J[9]+J[10]-J[11]-J[12]+J[13]-J[14]-J[15]+J[16]+J[17]-J[18]-J[19]+J[20]+J[21]+J[22]-J[23]-J[24]-J[25]-J[26]+J[27] - logZ )
    Pout[77] = exp( +H[0]-H[1]+H[2]+H[3]-H[4]-H[5]+H[6]-H[7]-J[0]+J[1]+J[2]-J[3]-J[4]+J[5]-J[6]-J[7]-J[8]+J[9]+J[10]-J[11]+J[12]+J[13]-J[14]-J[15]+J[16]-J[17]-J[18]-J[19]+J[20]-J[21]+J[22]-J[23]+J[24]-J[25]+J[26]-J[27] - logZ )
    Pout[78] = exp( +H[0]-H[1]+H[2]+H[3]-H[4]-H[5]-H[6]+H[7]-J[0]+J[1]+J[2]-J[3]-J[4]-J[5]+J[6]-J[7]-J[8]+J[9]+J[10]+J[11]-J[12]+J[13]-J[14]-J[15]-J[16]+J[17]-J[18]-J[19]-J[20]+J[21]+J[22]+J[23]-J[24]+J[25]-J[26]-J[27] - logZ )
    Pout[79] = exp( +H[0]-H[1]+H[2]+H[3]-H[4]-H[5]-H[6]-H[7]-J[0]+J[1]+J[2]-J[3]-J[4]-J[5]-J[6]-J[7]-J[8]+J[9]+J[10]+J[11]+J[12]+J[13]-J[14]-J[15]-J[16]-J[17]-J[18]-J[19]-J[20]-J[21]+J[22]+J[23]+J[24]+J[25]+J[26]+J[27] - logZ )
    Pout[80] = exp( +H[0]-H[1]+H[2]-H[3]+H[4]+H[5]+H[6]+H[7]-J[0]+J[1]-J[2]+J[3]+J[4]+J[5]+J[6]-J[7]+J[8]-J[9]-J[10]-J[11]-J[12]-J[13]+J[14]+J[15]+J[16]+J[17]-J[18]-J[19]-J[20]-J[21]+J[22]+J[23]+J[24]+J[25]+J[26]+J[27] - logZ )
    Pout[81] = exp( +H[0]-H[1]+H[2]-H[3]+H[4]+H[5]+H[6]-H[7]-J[0]+J[1]-J[2]+J[3]+J[4]+J[5]-J[6]-J[7]+J[8]-J[9]-J[10]-J[11]+J[12]-J[13]+J[14]+J[15]+J[16]-J[17]-J[18]-J[19]-J[20]+J[21]+J[22]+J[23]-J[24]+J[25]-J[26]-J[27] - logZ )
    Pout[82] = exp( +H[0]-H[1]+H[2]-H[3]+H[4]+H[5]-H[6]+H[7]-J[0]+J[1]-J[2]+J[3]+J[4]-J[5]+J[6]-J[7]+J[8]-J[9]-J[10]+J[11]-J[12]-J[13]+J[14]+J[15]-J[16]+J[17]-J[18]-J[19]+J[20]-J[21]+J[22]-J[23]+J[24]-J[25]+J[26]-J[27] - logZ )
    Pout[83] = exp( +H[0]-H[1]+H[2]-H[3]+H[4]+H[5]-H[6]-H[7]-J[0]+J[1]-J[2]+J[3]+J[4]-J[5]-J[6]-J[7]+J[8]-J[9]-J[10]+J[11]+J[12]-J[13]+J[14]+J[15]-J[16]-J[17]-J[18]-J[19]+J[20]+J[21]+J[22]-J[23]-J[24]-J[25]-J[26]+J[27] - logZ )
    Pout[84] = exp( +H[0]-H[1]+H[2]-H[3]+H[4]-H[5]+H[6]+H[7]-J[0]+J[1]-J[2]+J[3]-J[4]+J[5]+J[6]-J[7]+J[8]-J[9]+J[10]-J[11]-J[12]-J[13]+J[14]-J[15]+J[16]+J[17]-J[18]+J[19]-J[20]-J[21]-J[22]+J[23]+J[24]-J[25]-J[26]+J[27] - logZ )
    Pout[85] = exp( +H[0]-H[1]+H[2]-H[3]+H[4]-H[5]+H[6]-H[7]-J[0]+J[1]-J[2]+J[3]-J[4]+J[5]-J[6]-J[7]+J[8]-J[9]+J[10]-J[11]+J[12]-J[13]+J[14]-J[15]+J[16]-J[17]-J[18]+J[19]-J[20]+J[21]-J[22]+J[23]-J[24]-J[25]+J[26]-J[27] - logZ )
    Pout[86] = exp( +H[0]-H[1]+H[2]-H[3]+H[4]-H[5]-H[6]+H[7]-J[0]+J[1]-J[2]+J[3]-J[4]-J[5]+J[6]-J[7]+J[8]-J[9]+J[10]+J[11]-J[12]-J[13]+J[14]-J[15]-J[16]+J[17]-J[18]+J[19]+J[20]-J[21]-J[22]-J[23]+J[24]+J[25]-J[26]-J[27] - logZ )
    Pout[87] = exp( +H[0]-H[1]+H[2]-H[3]+H[4]-H[5]-H[6]-H[7]-J[0]+J[1]-J[2]+J[3]-J[4]-J[5]-J[6]-J[7]+J[8]-J[9]+J[10]+J[11]+J[12]-J[13]+J[14]-J[15]-J[16]-J[17]-J[18]+J[19]+J[20]+J[21]-J[22]-J[23]-J[24]+J[25]+J[26]+J[27] - logZ )
    Pout[88] = exp( +H[0]-H[1]+H[2]-H[3]-H[4]+H[5]+H[6]+H[7]-J[0]+J[1]-J[2]-J[3]+J[4]+J[5]+J[6]-J[7]+J[8]+J[9]-J[10]-J[11]-J[12]-J[13]-J[14]+J[15]+J[16]+J[17]+J[18]-J[19]-J[20]-J[21]-J[22]-J[23]-J[24]+J[25]+J[26]+J[27] - logZ )
    Pout[89] = exp( +H[0]-H[1]+H[2]-H[3]-H[4]+H[5]+H[6]-H[7]-J[0]+J[1]-J[2]-J[3]+J[4]+J[5]-J[6]-J[7]+J[8]+J[9]-J[10]-J[11]+J[12]-J[13]-J[14]+J[15]+J[16]-J[17]+J[18]-J[19]-J[20]+J[21]-J[22]-J[23]+J[24]+J[25]-J[26]-J[27] - logZ )
    Pout[90] = exp( +H[0]-H[1]+H[2]-H[3]-H[4]+H[5]-H[6]+H[7]-J[0]+J[1]-J[2]-J[3]+J[4]-J[5]+J[6]-J[7]+J[8]+J[9]-J[10]+J[11]-J[12]-J[13]-J[14]+J[15]-J[16]+J[17]+J[18]-J[19]+J[20]-J[21]-J[22]+J[23]-J[24]-J[25]+J[26]-J[27] - logZ )
    Pout[91] = exp( +H[0]-H[1]+H[2]-H[3]-H[4]+H[5]-H[6]-H[7]-J[0]+J[1]-J[2]-J[3]+J[4]-J[5]-J[6]-J[7]+J[8]+J[9]-J[10]+J[11]+J[12]-J[13]-J[14]+J[15]-J[16]-J[17]+J[18]-J[19]+J[20]+J[21]-J[22]+J[23]+J[24]-J[25]-J[26]+J[27] - logZ )
    Pout[92] = exp( +H[0]-H[1]+H[2]-H[3]-H[4]-H[5]+H[6]+H[7]-J[0]+J[1]-J[2]-J[3]-J[4]+J[5]+J[6]-J[7]+J[8]+J[9]+J[10]-J[11]-J[12]-J[13]-J[14]-J[15]+J[16]+J[17]+J[18]+J[19]-J[20]-J[21]+J[22]-J[23]-J[24]-J[25]-J[26]+J[27] - logZ )
    Pout[93] = exp( +H[0]-H[1]+H[2]-H[3]-H[4]-H[5]+H[6]-H[7]-J[0]+J[1]-J[2]-J[3]-J[4]+J[5]-J[6]-J[7]+J[8]+J[9]+J[10]-J[11]+J[12]-J[13]-J[14]-J[15]+J[16]-J[17]+J[18]+J[19]-J[20]+J[21]+J[22]-J[23]+J[24]-J[25]+J[26]-J[27] - logZ )
    Pout[94] = exp( +H[0]-H[1]+H[2]-H[3]-H[4]-H[5]-H[6]+H[7]-J[0]+J[1]-J[2]-J[3]-J[4]-J[5]+J[6]-J[7]+J[8]+J[9]+J[10]+J[11]-J[12]-J[13]-J[14]-J[15]-J[16]+J[17]+J[18]+J[19]+J[20]-J[21]+J[22]+J[23]-J[24]+J[25]-J[26]-J[27] - logZ )
    Pout[95] = exp( +H[0]-H[1]+H[2]-H[3]-H[4]-H[5]-H[6]-H[7]-J[0]+J[1]-J[2]-J[3]-J[4]-J[5]-J[6]-J[7]+J[8]+J[9]+J[10]+J[11]+J[12]-J[13]-J[14]-J[15]-J[16]-J[17]+J[18]+J[19]+J[20]+J[21]+J[22]+J[23]+J[24]+J[25]+J[26]+J[27] - logZ )
    Pout[96] = exp( +H[0]-H[1]-H[2]+H[3]+H[4]+H[5]+H[6]+H[7]-J[0]-J[1]+J[2]+J[3]+J[4]+J[5]+J[6]+J[7]-J[8]-J[9]-J[10]-J[11]-J[12]-J[13]-J[14]-J[15]-J[16]-J[17]+J[18]+J[19]+J[20]+J[21]+J[22]+J[23]+J[24]+J[25]+J[26]+J[27] - logZ )
    Pout[97] = exp( +H[0]-H[1]-H[2]+H[3]+H[4]+H[5]+H[6]-H[7]-J[0]-J[1]+J[2]+J[3]+J[4]+J[5]-J[6]+J[7]-J[8]-J[9]-J[10]-J[11]+J[12]-J[13]-J[14]-J[15]-J[16]+J[17]+J[18]+J[19]+J[20]-J[21]+J[22]+J[23]-J[24]+J[25]-J[26]-J[27] - logZ )
    Pout[98] = exp( +H[0]-H[1]-H[2]+H[3]+H[4]+H[5]-H[6]+H[7]-J[0]-J[1]+J[2]+J[3]+J[4]-J[5]+J[6]+J[7]-J[8]-J[9]-J[10]+J[11]-J[12]-J[13]-J[14]-J[15]+J[16]-J[17]+J[18]+J[19]-J[20]+J[21]+J[22]-J[23]+J[24]-J[25]+J[26]-J[27] - logZ )
    Pout[99] = exp( +H[0]-H[1]-H[2]+H[3]+H[4]+H[5]-H[6]-H[7]-J[0]-J[1]+J[2]+J[3]+J[4]-J[5]-J[6]+J[7]-J[8]-J[9]-J[10]+J[11]+J[12]-J[13]-J[14]-J[15]+J[16]+J[17]+J[18]+J[19]-J[20]-J[21]+J[22]-J[23]-J[24]-J[25]-J[26]+J[27] - logZ )
    Pout[100] = exp( +H[0]-H[1]-H[2]+H[3]+H[4]-H[5]+H[6]+H[7]-J[0]-J[1]+J[2]+J[3]-J[4]+J[5]+J[6]+J[7]-J[8]-J[9]+J[10]-J[11]-J[12]-J[13]-J[14]+J[15]-J[16]-J[17]+J[18]-J[19]+J[20]+J[21]-J[22]+J[23]+J[24]-J[25]-J[26]+J[27] - logZ )
    Pout[101] = exp( +H[0]-H[1]-H[2]+H[3]+H[4]-H[5]+H[6]-H[7]-J[0]-J[1]+J[2]+J[3]-J[4]+J[5]-J[6]+J[7]-J[8]-J[9]+J[10]-J[11]+J[12]-J[13]-J[14]+J[15]-J[16]+J[17]+J[18]-J[19]+J[20]-J[21]-J[22]+J[23]-J[24]-J[25]+J[26]-J[27] - logZ )
    Pout[102] = exp( +H[0]-H[1]-H[2]+H[3]+H[4]-H[5]-H[6]+H[7]-J[0]-J[1]+J[2]+J[3]-J[4]-J[5]+J[6]+J[7]-J[8]-J[9]+J[10]+J[11]-J[12]-J[13]-J[14]+J[15]+J[16]-J[17]+J[18]-J[19]-J[20]+J[21]-J[22]-J[23]+J[24]+J[25]-J[26]-J[27] - logZ )
    Pout[103] = exp( +H[0]-H[1]-H[2]+H[3]+H[4]-H[5]-H[6]-H[7]-J[0]-J[1]+J[2]+J[3]-J[4]-J[5]-J[6]+J[7]-J[8]-J[9]+J[10]+J[11]+J[12]-J[13]-J[14]+J[15]+J[16]+J[17]+J[18]-J[19]-J[20]-J[21]-J[22]-J[23]-J[24]+J[25]+J[26]+J[27] - logZ )
    Pout[104] = exp( +H[0]-H[1]-H[2]+H[3]-H[4]+H[5]+H[6]+H[7]-J[0]-J[1]+J[2]-J[3]+J[4]+J[5]+J[6]+J[7]-J[8]+J[9]-J[10]-J[11]-J[12]-J[13]+J[14]-J[15]-J[16]-J[17]-J[18]+J[19]+J[20]+J[21]-J[22]-J[23]-J[24]+J[25]+J[26]+J[27] - logZ )
    Pout[105] = exp( +H[0]-H[1]-H[2]+H[3]-H[4]+H[5]+H[6]-H[7]-J[0]-J[1]+J[2]-J[3]+J[4]+J[5]-J[6]+J[7]-J[8]+J[9]-J[10]-J[11]+J[12]-J[13]+J[14]-J[15]-J[16]+J[17]-J[18]+J[19]+J[20]-J[21]-J[22]-J[23]+J[24]+J[25]-J[26]-J[27] - logZ )
    Pout[106] = exp( +H[0]-H[1]-H[2]+H[3]-H[4]+H[5]-H[6]+H[7]-J[0]-J[1]+J[2]-J[3]+J[4]-J[5]+J[6]+J[7]-J[8]+J[9]-J[10]+J[11]-J[12]-J[13]+J[14]-J[15]+J[16]-J[17]-J[18]+J[19]-J[20]+J[21]-J[22]+J[23]-J[24]-J[25]+J[26]-J[27] - logZ )
    Pout[107] = exp( +H[0]-H[1]-H[2]+H[3]-H[4]+H[5]-H[6]-H[7]-J[0]-J[1]+J[2]-J[3]+J[4]-J[5]-J[6]+J[7]-J[8]+J[9]-J[10]+J[11]+J[12]-J[13]+J[14]-J[15]+J[16]+J[17]-J[18]+J[19]-J[20]-J[21]-J[22]+J[23]+J[24]-J[25]-J[26]+J[27] - logZ )
    Pout[108] = exp( +H[0]-H[1]-H[2]+H[3]-H[4]-H[5]+H[6]+H[7]-J[0]-J[1]+J[2]-J[3]-J[4]+J[5]+J[6]+J[7]-J[8]+J[9]+J[10]-J[11]-J[12]-J[13]+J[14]+J[15]-J[16]-J[17]-J[18]-J[19]+J[20]+J[21]+J[22]-J[23]-J[24]-J[25]-J[26]+J[27] - logZ )
    Pout[109] = exp( +H[0]-H[1]-H[2]+H[3]-H[4]-H[5]+H[6]-H[7]-J[0]-J[1]+J[2]-J[3]-J[4]+J[5]-J[6]+J[7]-J[8]+J[9]+J[10]-J[11]+J[12]-J[13]+J[14]+J[15]-J[16]+J[17]-J[18]-J[19]+J[20]-J[21]+J[22]-J[23]+J[24]-J[25]+J[26]-J[27] - logZ )
    Pout[110] = exp( +H[0]-H[1]-H[2]+H[3]-H[4]-H[5]-H[6]+H[7]-J[0]-J[1]+J[2]-J[3]-J[4]-J[5]+J[6]+J[7]-J[8]+J[9]+J[10]+J[11]-J[12]-J[13]+J[14]+J[15]+J[16]-J[17]-J[18]-J[19]-J[20]+J[21]+J[22]+J[23]-J[24]+J[25]-J[26]-J[27] - logZ )
    Pout[111] = exp( +H[0]-H[1]-H[2]+H[3]-H[4]-H[5]-H[6]-H[7]-J[0]-J[1]+J[2]-J[3]-J[4]-J[5]-J[6]+J[7]-J[8]+J[9]+J[10]+J[11]+J[12]-J[13]+J[14]+J[15]+J[16]+J[17]-J[18]-J[19]-J[20]-J[21]+J[22]+J[23]+J[24]+J[25]+J[26]+J[27] - logZ )
    Pout[112] = exp( +H[0]-H[1]-H[2]-H[3]+H[4]+H[5]+H[6]+H[7]-J[0]-J[1]-J[2]+J[3]+J[4]+J[5]+J[6]+J[7]+J[8]-J[9]-J[10]-J[11]-J[12]+J[13]-J[14]-J[15]-J[16]-J[17]-J[18]-J[19]-J[20]-J[21]+J[22]+J[23]+J[24]+J[25]+J[26]+J[27] - logZ )
    Pout[113] = exp( +H[0]-H[1]-H[2]-H[3]+H[4]+H[5]+H[6]-H[7]-J[0]-J[1]-J[2]+J[3]+J[4]+J[5]-J[6]+J[7]+J[8]-J[9]-J[10]-J[11]+J[12]+J[13]-J[14]-J[15]-J[16]+J[17]-J[18]-J[19]-J[20]+J[21]+J[22]+J[23]-J[24]+J[25]-J[26]-J[27] - logZ )
    Pout[114] = exp( +H[0]-H[1]-H[2]-H[3]+H[4]+H[5]-H[6]+H[7]-J[0]-J[1]-J[2]+J[3]+J[4]-J[5]+J[6]+J[7]+J[8]-J[9]-J[10]+J[11]-J[12]+J[13]-J[14]-J[15]+J[16]-J[17]-J[18]-J[19]+J[20]-J[21]+J[22]-J[23]+J[24]-J[25]+J[26]-J[27] - logZ )
    Pout[115] = exp( +H[0]-H[1]-H[2]-H[3]+H[4]+H[5]-H[6]-H[7]-J[0]-J[1]-J[2]+J[3]+J[4]-J[5]-J[6]+J[7]+J[8]-J[9]-J[10]+J[11]+J[12]+J[13]-J[14]-J[15]+J[16]+J[17]-J[18]-J[19]+J[20]+J[21]+J[22]-J[23]-J[24]-J[25]-J[26]+J[27] - logZ )
    Pout[116] = exp( +H[0]-H[1]-H[2]-H[3]+H[4]-H[5]+H[6]+H[7]-J[0]-J[1]-J[2]+J[3]-J[4]+J[5]+J[6]+J[7]+J[8]-J[9]+J[10]-J[11]-J[12]+J[13]-J[14]+J[15]-J[16]-J[17]-J[18]+J[19]-J[20]-J[21]-J[22]+J[23]+J[24]-J[25]-J[26]+J[27] - logZ )
    Pout[117] = exp( +H[0]-H[1]-H[2]-H[3]+H[4]-H[5]+H[6]-H[7]-J[0]-J[1]-J[2]+J[3]-J[4]+J[5]-J[6]+J[7]+J[8]-J[9]+J[10]-J[11]+J[12]+J[13]-J[14]+J[15]-J[16]+J[17]-J[18]+J[19]-J[20]+J[21]-J[22]+J[23]-J[24]-J[25]+J[26]-J[27] - logZ )
    Pout[118] = exp( +H[0]-H[1]-H[2]-H[3]+H[4]-H[5]-H[6]+H[7]-J[0]-J[1]-J[2]+J[3]-J[4]-J[5]+J[6]+J[7]+J[8]-J[9]+J[10]+J[11]-J[12]+J[13]-J[14]+J[15]+J[16]-J[17]-J[18]+J[19]+J[20]-J[21]-J[22]-J[23]+J[24]+J[25]-J[26]-J[27] - logZ )
    Pout[119] = exp( +H[0]-H[1]-H[2]-H[3]+H[4]-H[5]-H[6]-H[7]-J[0]-J[1]-J[2]+J[3]-J[4]-J[5]-J[6]+J[7]+J[8]-J[9]+J[10]+J[11]+J[12]+J[13]-J[14]+J[15]+J[16]+J[17]-J[18]+J[19]+J[20]+J[21]-J[22]-J[23]-J[24]+J[25]+J[26]+J[27] - logZ )
    Pout[120] = exp( +H[0]-H[1]-H[2]-H[3]-H[4]+H[5]+H[6]+H[7]-J[0]-J[1]-J[2]-J[3]+J[4]+J[5]+J[6]+J[7]+J[8]+J[9]-J[10]-J[11]-J[12]+J[13]+J[14]-J[15]-J[16]-J[17]+J[18]-J[19]-J[20]-J[21]-J[22]-J[23]-J[24]+J[25]+J[26]+J[27] - logZ )
    Pout[121] = exp( +H[0]-H[1]-H[2]-H[3]-H[4]+H[5]+H[6]-H[7]-J[0]-J[1]-J[2]-J[3]+J[4]+J[5]-J[6]+J[7]+J[8]+J[9]-J[10]-J[11]+J[12]+J[13]+J[14]-J[15]-J[16]+J[17]+J[18]-J[19]-J[20]+J[21]-J[22]-J[23]+J[24]+J[25]-J[26]-J[27] - logZ )
    Pout[122] = exp( +H[0]-H[1]-H[2]-H[3]-H[4]+H[5]-H[6]+H[7]-J[0]-J[1]-J[2]-J[3]+J[4]-J[5]+J[6]+J[7]+J[8]+J[9]-J[10]+J[11]-J[12]+J[13]+J[14]-J[15]+J[16]-J[17]+J[18]-J[19]+J[20]-J[21]-J[22]+J[23]-J[24]-J[25]+J[26]-J[27] - logZ )
    Pout[123] = exp( +H[0]-H[1]-H[2]-H[3]-H[4]+H[5]-H[6]-H[7]-J[0]-J[1]-J[2]-J[3]+J[4]-J[5]-J[6]+J[7]+J[8]+J[9]-J[10]+J[11]+J[12]+J[13]+J[14]-J[15]+J[16]+J[17]+J[18]-J[19]+J[20]+J[21]-J[22]+J[23]+J[24]-J[25]-J[26]+J[27] - logZ )
    Pout[124] = exp( +H[0]-H[1]-H[2]-H[3]-H[4]-H[5]+H[6]+H[7]-J[0]-J[1]-J[2]-J[3]-J[4]+J[5]+J[6]+J[7]+J[8]+J[9]+J[10]-J[11]-J[12]+J[13]+J[14]+J[15]-J[16]-J[17]+J[18]+J[19]-J[20]-J[21]+J[22]-J[23]-J[24]-J[25]-J[26]+J[27] - logZ )
    Pout[125] = exp( +H[0]-H[1]-H[2]-H[3]-H[4]-H[5]+H[6]-H[7]-J[0]-J[1]-J[2]-J[3]-J[4]+J[5]-J[6]+J[7]+J[8]+J[9]+J[10]-J[11]+J[12]+J[13]+J[14]+J[15]-J[16]+J[17]+J[18]+J[19]-J[20]+J[21]+J[22]-J[23]+J[24]-J[25]+J[26]-J[27] - logZ )
    Pout[126] = exp( +H[0]-H[1]-H[2]-H[3]-H[4]-H[5]-H[6]+H[7]-J[0]-J[1]-J[2]-J[3]-J[4]-J[5]+J[6]+J[7]+J[8]+J[9]+J[10]+J[11]-J[12]+J[13]+J[14]+J[15]+J[16]-J[17]+J[18]+J[19]+J[20]-J[21]+J[22]+J[23]-J[24]+J[25]-J[26]-J[27] - logZ )
    Pout[127] = exp( +H[0]-H[1]-H[2]-H[3]-H[4]-H[5]-H[6]-H[7]-J[0]-J[1]-J[2]-J[3]-J[4]-J[5]-J[6]+J[7]+J[8]+J[9]+J[10]+J[11]+J[12]+J[13]+J[14]+J[15]+J[16]+J[17]+J[18]+J[19]+J[20]+J[21]+J[22]+J[23]+J[24]+J[25]+J[26]+J[27] - logZ )
    Pout[128] = exp( -H[0]+H[1]+H[2]+H[3]+H[4]+H[5]+H[6]+H[7]-J[0]-J[1]-J[2]-J[3]-J[4]-J[5]-J[6]+J[7]+J[8]+J[9]+J[10]+J[11]+J[12]+J[13]+J[14]+J[15]+J[16]+J[17]+J[18]+J[19]+J[20]+J[21]+J[22]+J[23]+J[24]+J[25]+J[26]+J[27] - logZ )
    Pout[129] = exp( -H[0]+H[1]+H[2]+H[3]+H[4]+H[5]+H[6]-H[7]-J[0]-J[1]-J[2]-J[3]-J[4]-J[5]+J[6]+J[7]+J[8]+J[9]+J[10]+J[11]-J[12]+J[13]+J[14]+J[15]+J[16]-J[17]+J[18]+J[19]+J[20]-J[21]+J[22]+J[23]-J[24]+J[25]-J[26]-J[27] - logZ )
    Pout[130] = exp( -H[0]+H[1]+H[2]+H[3]+H[4]+H[5]-H[6]+H[7]-J[0]-J[1]-J[2]-J[3]-J[4]+J[5]-J[6]+J[7]+J[8]+J[9]+J[10]-J[11]+J[12]+J[13]+J[14]+J[15]-J[16]+J[17]+J[18]+J[19]-J[20]+J[21]+J[22]-J[23]+J[24]-J[25]+J[26]-J[27] - logZ )
    Pout[131] = exp( -H[0]+H[1]+H[2]+H[3]+H[4]+H[5]-H[6]-H[7]-J[0]-J[1]-J[2]-J[3]-J[4]+J[5]+J[6]+J[7]+J[8]+J[9]+J[10]-J[11]-J[12]+J[13]+J[14]+J[15]-J[16]-J[17]+J[18]+J[19]-J[20]-J[21]+J[22]-J[23]-J[24]-J[25]-J[26]+J[27] - logZ )
    Pout[132] = exp( -H[0]+H[1]+H[2]+H[3]+H[4]-H[5]+H[6]+H[7]-J[0]-J[1]-J[2]-J[3]+J[4]-J[5]-J[6]+J[7]+J[8]+J[9]-J[10]+J[11]+J[12]+J[13]+J[14]-J[15]+J[16]+J[17]+J[18]-J[19]+J[20]+J[21]-J[22]+J[23]+J[24]-J[25]-J[26]+J[27] - logZ )
    Pout[133] = exp( -H[0]+H[1]+H[2]+H[3]+H[4]-H[5]+H[6]-H[7]-J[0]-J[1]-J[2]-J[3]+J[4]-J[5]+J[6]+J[7]+J[8]+J[9]-J[10]+J[11]-J[12]+J[13]+J[14]-J[15]+J[16]-J[17]+J[18]-J[19]+J[20]-J[21]-J[22]+J[23]-J[24]-J[25]+J[26]-J[27] - logZ )
    Pout[134] = exp( -H[0]+H[1]+H[2]+H[3]+H[4]-H[5]-H[6]+H[7]-J[0]-J[1]-J[2]-J[3]+J[4]+J[5]-J[6]+J[7]+J[8]+J[9]-J[10]-J[11]+J[12]+J[13]+J[14]-J[15]-J[16]+J[17]+J[18]-J[19]-J[20]+J[21]-J[22]-J[23]+J[24]+J[25]-J[26]-J[27] - logZ )
    Pout[135] = exp( -H[0]+H[1]+H[2]+H[3]+H[4]-H[5]-H[6]-H[7]-J[0]-J[1]-J[2]-J[3]+J[4]+J[5]+J[6]+J[7]+J[8]+J[9]-J[10]-J[11]-J[12]+J[13]+J[14]-J[15]-J[16]-J[17]+J[18]-J[19]-J[20]-J[21]-J[22]-J[23]-J[24]+J[25]+J[26]+J[27] - logZ )
    Pout[136] = exp( -H[0]+H[1]+H[2]+H[3]-H[4]+H[5]+H[6]+H[7]-J[0]-J[1]-J[2]+J[3]-J[4]-J[5]-J[6]+J[7]+J[8]-J[9]+J[10]+J[11]+J[12]+J[13]-J[14]+J[15]+J[16]+J[17]-J[18]+J[19]+J[20]+J[21]-J[22]-J[23]-J[24]+J[25]+J[26]+J[27] - logZ )
    Pout[137] = exp( -H[0]+H[1]+H[2]+H[3]-H[4]+H[5]+H[6]-H[7]-J[0]-J[1]-J[2]+J[3]-J[4]-J[5]+J[6]+J[7]+J[8]-J[9]+J[10]+J[11]-J[12]+J[13]-J[14]+J[15]+J[16]-J[17]-J[18]+J[19]+J[20]-J[21]-J[22]-J[23]+J[24]+J[25]-J[26]-J[27] - logZ )
    Pout[138] = exp( -H[0]+H[1]+H[2]+H[3]-H[4]+H[5]-H[6]+H[7]-J[0]-J[1]-J[2]+J[3]-J[4]+J[5]-J[6]+J[7]+J[8]-J[9]+J[10]-J[11]+J[12]+J[13]-J[14]+J[15]-J[16]+J[17]-J[18]+J[19]-J[20]+J[21]-J[22]+J[23]-J[24]-J[25]+J[26]-J[27] - logZ )
    Pout[139] = exp( -H[0]+H[1]+H[2]+H[3]-H[4]+H[5]-H[6]-H[7]-J[0]-J[1]-J[2]+J[3]-J[4]+J[5]+J[6]+J[7]+J[8]-J[9]+J[10]-J[11]-J[12]+J[13]-J[14]+J[15]-J[16]-J[17]-J[18]+J[19]-J[20]-J[21]-J[22]+J[23]+J[24]-J[25]-J[26]+J[27] - logZ )
    Pout[140] = exp( -H[0]+H[1]+H[2]+H[3]-H[4]-H[5]+H[6]+H[7]-J[0]-J[1]-J[2]+J[3]+J[4]-J[5]-J[6]+J[7]+J[8]-J[9]-J[10]+J[11]+J[12]+J[13]-J[14]-J[15]+J[16]+J[17]-J[18]-J[19]+J[20]+J[21]+J[22]-J[23]-J[24]-J[25]-J[26]+J[27] - logZ )
    Pout[141] = exp( -H[0]+H[1]+H[2]+H[3]-H[4]-H[5]+H[6]-H[7]-J[0]-J[1]-J[2]+J[3]+J[4]-J[5]+J[6]+J[7]+J[8]-J[9]-J[10]+J[11]-J[12]+J[13]-J[14]-J[15]+J[16]-J[17]-J[18]-J[19]+J[20]-J[21]+J[22]-J[23]+J[24]-J[25]+J[26]-J[27] - logZ )
    Pout[142] = exp( -H[0]+H[1]+H[2]+H[3]-H[4]-H[5]-H[6]+H[7]-J[0]-J[1]-J[2]+J[3]+J[4]+J[5]-J[6]+J[7]+J[8]-J[9]-J[10]-J[11]+J[12]+J[13]-J[14]-J[15]-J[16]+J[17]-J[18]-J[19]-J[20]+J[21]+J[22]+J[23]-J[24]+J[25]-J[26]-J[27] - logZ )
    Pout[143] = exp( -H[0]+H[1]+H[2]+H[3]-H[4]-H[5]-H[6]-H[7]-J[0]-J[1]-J[2]+J[3]+J[4]+J[5]+J[6]+J[7]+J[8]-J[9]-J[10]-J[11]-J[12]+J[13]-J[14]-J[15]-J[16]-J[17]-J[18]-J[19]-J[20]-J[21]+J[22]+J[23]+J[24]+J[25]+J[26]+J[27] - logZ )
    Pout[144] = exp( -H[0]+H[1]+H[2]-H[3]+H[4]+H[5]+H[6]+H[7]-J[0]-J[1]+J[2]-J[3]-J[4]-J[5]-J[6]+J[7]-J[8]+J[9]+J[10]+J[11]+J[12]-J[13]+J[14]+J[15]+J[16]+J[17]-J[18]-J[19]-J[20]-J[21]+J[22]+J[23]+J[24]+J[25]+J[26]+J[27] - logZ )
    Pout[145] = exp( -H[0]+H[1]+H[2]-H[3]+H[4]+H[5]+H[6]-H[7]-J[0]-J[1]+J[2]-J[3]-J[4]-J[5]+J[6]+J[7]-J[8]+J[9]+J[10]+J[11]-J[12]-J[13]+J[14]+J[15]+J[16]-J[17]-J[18]-J[19]-J[20]+J[21]+J[22]+J[23]-J[24]+J[25]-J[26]-J[27] - logZ )
    Pout[146] = exp( -H[0]+H[1]+H[2]-H[3]+H[4]+H[5]-H[6]+H[7]-J[0]-J[1]+J[2]-J[3]-J[4]+J[5]-J[6]+J[7]-J[8]+J[9]+J[10]-J[11]+J[12]-J[13]+J[14]+J[15]-J[16]+J[17]-J[18]-J[19]+J[20]-J[21]+J[22]-J[23]+J[24]-J[25]+J[26]-J[27] - logZ )
    Pout[147] = exp( -H[0]+H[1]+H[2]-H[3]+H[4]+H[5]-H[6]-H[7]-J[0]-J[1]+J[2]-J[3]-J[4]+J[5]+J[6]+J[7]-J[8]+J[9]+J[10]-J[11]-J[12]-J[13]+J[14]+J[15]-J[16]-J[17]-J[18]-J[19]+J[20]+J[21]+J[22]-J[23]-J[24]-J[25]-J[26]+J[27] - logZ )
    Pout[148] = exp( -H[0]+H[1]+H[2]-H[3]+H[4]-H[5]+H[6]+H[7]-J[0]-J[1]+J[2]-J[3]+J[4]-J[5]-J[6]+J[7]-J[8]+J[9]-J[10]+J[11]+J[12]-J[13]+J[14]-J[15]+J[16]+J[17]-J[18]+J[19]-J[20]-J[21]-J[22]+J[23]+J[24]-J[25]-J[26]+J[27] - logZ )
    Pout[149] = exp( -H[0]+H[1]+H[2]-H[3]+H[4]-H[5]+H[6]-H[7]-J[0]-J[1]+J[2]-J[3]+J[4]-J[5]+J[6]+J[7]-J[8]+J[9]-J[10]+J[11]-J[12]-J[13]+J[14]-J[15]+J[16]-J[17]-J[18]+J[19]-J[20]+J[21]-J[22]+J[23]-J[24]-J[25]+J[26]-J[27] - logZ )
    Pout[150] = exp( -H[0]+H[1]+H[2]-H[3]+H[4]-H[5]-H[6]+H[7]-J[0]-J[1]+J[2]-J[3]+J[4]+J[5]-J[6]+J[7]-J[8]+J[9]-J[10]-J[11]+J[12]-J[13]+J[14]-J[15]-J[16]+J[17]-J[18]+J[19]+J[20]-J[21]-J[22]-J[23]+J[24]+J[25]-J[26]-J[27] - logZ )
    Pout[151] = exp( -H[0]+H[1]+H[2]-H[3]+H[4]-H[5]-H[6]-H[7]-J[0]-J[1]+J[2]-J[3]+J[4]+J[5]+J[6]+J[7]-J[8]+J[9]-J[10]-J[11]-J[12]-J[13]+J[14]-J[15]-J[16]-J[17]-J[18]+J[19]+J[20]+J[21]-J[22]-J[23]-J[24]+J[25]+J[26]+J[27] - logZ )
    Pout[152] = exp( -H[0]+H[1]+H[2]-H[3]-H[4]+H[5]+H[6]+H[7]-J[0]-J[1]+J[2]+J[3]-J[4]-J[5]-J[6]+J[7]-J[8]-J[9]+J[10]+J[11]+J[12]-J[13]-J[14]+J[15]+J[16]+J[17]+J[18]-J[19]-J[20]-J[21]-J[22]-J[23]-J[24]+J[25]+J[26]+J[27] - logZ )
    Pout[153] = exp( -H[0]+H[1]+H[2]-H[3]-H[4]+H[5]+H[6]-H[7]-J[0]-J[1]+J[2]+J[3]-J[4]-J[5]+J[6]+J[7]-J[8]-J[9]+J[10]+J[11]-J[12]-J[13]-J[14]+J[15]+J[16]-J[17]+J[18]-J[19]-J[20]+J[21]-J[22]-J[23]+J[24]+J[25]-J[26]-J[27] - logZ )
    Pout[154] = exp( -H[0]+H[1]+H[2]-H[3]-H[4]+H[5]-H[6]+H[7]-J[0]-J[1]+J[2]+J[3]-J[4]+J[5]-J[6]+J[7]-J[8]-J[9]+J[10]-J[11]+J[12]-J[13]-J[14]+J[15]-J[16]+J[17]+J[18]-J[19]+J[20]-J[21]-J[22]+J[23]-J[24]-J[25]+J[26]-J[27] - logZ )
    Pout[155] = exp( -H[0]+H[1]+H[2]-H[3]-H[4]+H[5]-H[6]-H[7]-J[0]-J[1]+J[2]+J[3]-J[4]+J[5]+J[6]+J[7]-J[8]-J[9]+J[10]-J[11]-J[12]-J[13]-J[14]+J[15]-J[16]-J[17]+J[18]-J[19]+J[20]+J[21]-J[22]+J[23]+J[24]-J[25]-J[26]+J[27] - logZ )
    Pout[156] = exp( -H[0]+H[1]+H[2]-H[3]-H[4]-H[5]+H[6]+H[7]-J[0]-J[1]+J[2]+J[3]+J[4]-J[5]-J[6]+J[7]-J[8]-J[9]-J[10]+J[11]+J[12]-J[13]-J[14]-J[15]+J[16]+J[17]+J[18]+J[19]-J[20]-J[21]+J[22]-J[23]-J[24]-J[25]-J[26]+J[27] - logZ )
    Pout[157] = exp( -H[0]+H[1]+H[2]-H[3]-H[4]-H[5]+H[6]-H[7]-J[0]-J[1]+J[2]+J[3]+J[4]-J[5]+J[6]+J[7]-J[8]-J[9]-J[10]+J[11]-J[12]-J[13]-J[14]-J[15]+J[16]-J[17]+J[18]+J[19]-J[20]+J[21]+J[22]-J[23]+J[24]-J[25]+J[26]-J[27] - logZ )
    Pout[158] = exp( -H[0]+H[1]+H[2]-H[3]-H[4]-H[5]-H[6]+H[7]-J[0]-J[1]+J[2]+J[3]+J[4]+J[5]-J[6]+J[7]-J[8]-J[9]-J[10]-J[11]+J[12]-J[13]-J[14]-J[15]-J[16]+J[17]+J[18]+J[19]+J[20]-J[21]+J[22]+J[23]-J[24]+J[25]-J[26]-J[27] - logZ )
    Pout[159] = exp( -H[0]+H[1]+H[2]-H[3]-H[4]-H[5]-H[6]-H[7]-J[0]-J[1]+J[2]+J[3]+J[4]+J[5]+J[6]+J[7]-J[8]-J[9]-J[10]-J[11]-J[12]-J[13]-J[14]-J[15]-J[16]-J[17]+J[18]+J[19]+J[20]+J[21]+J[22]+J[23]+J[24]+J[25]+J[26]+J[27] - logZ )
    Pout[160] = exp( -H[0]+H[1]-H[2]+H[3]+H[4]+H[5]+H[6]+H[7]-J[0]+J[1]-J[2]-J[3]-J[4]-J[5]-J[6]-J[7]+J[8]+J[9]+J[10]+J[11]+J[12]-J[13]-J[14]-J[15]-J[16]-J[17]+J[18]+J[19]+J[20]+J[21]+J[22]+J[23]+J[24]+J[25]+J[26]+J[27] - logZ )
    Pout[161] = exp( -H[0]+H[1]-H[2]+H[3]+H[4]+H[5]+H[6]-H[7]-J[0]+J[1]-J[2]-J[3]-J[4]-J[5]+J[6]-J[7]+J[8]+J[9]+J[10]+J[11]-J[12]-J[13]-J[14]-J[15]-J[16]+J[17]+J[18]+J[19]+J[20]-J[21]+J[22]+J[23]-J[24]+J[25]-J[26]-J[27] - logZ )
    Pout[162] = exp( -H[0]+H[1]-H[2]+H[3]+H[4]+H[5]-H[6]+H[7]-J[0]+J[1]-J[2]-J[3]-J[4]+J[5]-J[6]-J[7]+J[8]+J[9]+J[10]-J[11]+J[12]-J[13]-J[14]-J[15]+J[16]-J[17]+J[18]+J[19]-J[20]+J[21]+J[22]-J[23]+J[24]-J[25]+J[26]-J[27] - logZ )
    Pout[163] = exp( -H[0]+H[1]-H[2]+H[3]+H[4]+H[5]-H[6]-H[7]-J[0]+J[1]-J[2]-J[3]-J[4]+J[5]+J[6]-J[7]+J[8]+J[9]+J[10]-J[11]-J[12]-J[13]-J[14]-J[15]+J[16]+J[17]+J[18]+J[19]-J[20]-J[21]+J[22]-J[23]-J[24]-J[25]-J[26]+J[27] - logZ )
    Pout[164] = exp( -H[0]+H[1]-H[2]+H[3]+H[4]-H[5]+H[6]+H[7]-J[0]+J[1]-J[2]-J[3]+J[4]-J[5]-J[6]-J[7]+J[8]+J[9]-J[10]+J[11]+J[12]-J[13]-J[14]+J[15]-J[16]-J[17]+J[18]-J[19]+J[20]+J[21]-J[22]+J[23]+J[24]-J[25]-J[26]+J[27] - logZ )
    Pout[165] = exp( -H[0]+H[1]-H[2]+H[3]+H[4]-H[5]+H[6]-H[7]-J[0]+J[1]-J[2]-J[3]+J[4]-J[5]+J[6]-J[7]+J[8]+J[9]-J[10]+J[11]-J[12]-J[13]-J[14]+J[15]-J[16]+J[17]+J[18]-J[19]+J[20]-J[21]-J[22]+J[23]-J[24]-J[25]+J[26]-J[27] - logZ )
    Pout[166] = exp( -H[0]+H[1]-H[2]+H[3]+H[4]-H[5]-H[6]+H[7]-J[0]+J[1]-J[2]-J[3]+J[4]+J[5]-J[6]-J[7]+J[8]+J[9]-J[10]-J[11]+J[12]-J[13]-J[14]+J[15]+J[16]-J[17]+J[18]-J[19]-J[20]+J[21]-J[22]-J[23]+J[24]+J[25]-J[26]-J[27] - logZ )
    Pout[167] = exp( -H[0]+H[1]-H[2]+H[3]+H[4]-H[5]-H[6]-H[7]-J[0]+J[1]-J[2]-J[3]+J[4]+J[5]+J[6]-J[7]+J[8]+J[9]-J[10]-J[11]-J[12]-J[13]-J[14]+J[15]+J[16]+J[17]+J[18]-J[19]-J[20]-J[21]-J[22]-J[23]-J[24]+J[25]+J[26]+J[27] - logZ )
    Pout[168] = exp( -H[0]+H[1]-H[2]+H[3]-H[4]+H[5]+H[6]+H[7]-J[0]+J[1]-J[2]+J[3]-J[4]-J[5]-J[6]-J[7]+J[8]-J[9]+J[10]+J[11]+J[12]-J[13]+J[14]-J[15]-J[16]-J[17]-J[18]+J[19]+J[20]+J[21]-J[22]-J[23]-J[24]+J[25]+J[26]+J[27] - logZ )
    Pout[169] = exp( -H[0]+H[1]-H[2]+H[3]-H[4]+H[5]+H[6]-H[7]-J[0]+J[1]-J[2]+J[3]-J[4]-J[5]+J[6]-J[7]+J[8]-J[9]+J[10]+J[11]-J[12]-J[13]+J[14]-J[15]-J[16]+J[17]-J[18]+J[19]+J[20]-J[21]-J[22]-J[23]+J[24]+J[25]-J[26]-J[27] - logZ )
    Pout[170] = exp( -H[0]+H[1]-H[2]+H[3]-H[4]+H[5]-H[6]+H[7]-J[0]+J[1]-J[2]+J[3]-J[4]+J[5]-J[6]-J[7]+J[8]-J[9]+J[10]-J[11]+J[12]-J[13]+J[14]-J[15]+J[16]-J[17]-J[18]+J[19]-J[20]+J[21]-J[22]+J[23]-J[24]-J[25]+J[26]-J[27] - logZ )
    Pout[171] = exp( -H[0]+H[1]-H[2]+H[3]-H[4]+H[5]-H[6]-H[7]-J[0]+J[1]-J[2]+J[3]-J[4]+J[5]+J[6]-J[7]+J[8]-J[9]+J[10]-J[11]-J[12]-J[13]+J[14]-J[15]+J[16]+J[17]-J[18]+J[19]-J[20]-J[21]-J[22]+J[23]+J[24]-J[25]-J[26]+J[27] - logZ )
    Pout[172] = exp( -H[0]+H[1]-H[2]+H[3]-H[4]-H[5]+H[6]+H[7]-J[0]+J[1]-J[2]+J[3]+J[4]-J[5]-J[6]-J[7]+J[8]-J[9]-J[10]+J[11]+J[12]-J[13]+J[14]+J[15]-J[16]-J[17]-J[18]-J[19]+J[20]+J[21]+J[22]-J[23]-J[24]-J[25]-J[26]+J[27] - logZ )
    Pout[173] = exp( -H[0]+H[1]-H[2]+H[3]-H[4]-H[5]+H[6]-H[7]-J[0]+J[1]-J[2]+J[3]+J[4]-J[5]+J[6]-J[7]+J[8]-J[9]-J[10]+J[11]-J[12]-J[13]+J[14]+J[15]-J[16]+J[17]-J[18]-J[19]+J[20]-J[21]+J[22]-J[23]+J[24]-J[25]+J[26]-J[27] - logZ )
    Pout[174] = exp( -H[0]+H[1]-H[2]+H[3]-H[4]-H[5]-H[6]+H[7]-J[0]+J[1]-J[2]+J[3]+J[4]+J[5]-J[6]-J[7]+J[8]-J[9]-J[10]-J[11]+J[12]-J[13]+J[14]+J[15]+J[16]-J[17]-J[18]-J[19]-J[20]+J[21]+J[22]+J[23]-J[24]+J[25]-J[26]-J[27] - logZ )
    Pout[175] = exp( -H[0]+H[1]-H[2]+H[3]-H[4]-H[5]-H[6]-H[7]-J[0]+J[1]-J[2]+J[3]+J[4]+J[5]+J[6]-J[7]+J[8]-J[9]-J[10]-J[11]-J[12]-J[13]+J[14]+J[15]+J[16]+J[17]-J[18]-J[19]-J[20]-J[21]+J[22]+J[23]+J[24]+J[25]+J[26]+J[27] - logZ )
    Pout[176] = exp( -H[0]+H[1]-H[2]-H[3]+H[4]+H[5]+H[6]+H[7]-J[0]+J[1]+J[2]-J[3]-J[4]-J[5]-J[6]-J[7]-J[8]+J[9]+J[10]+J[11]+J[12]+J[13]-J[14]-J[15]-J[16]-J[17]-J[18]-J[19]-J[20]-J[21]+J[22]+J[23]+J[24]+J[25]+J[26]+J[27] - logZ )
    Pout[177] = exp( -H[0]+H[1]-H[2]-H[3]+H[4]+H[5]+H[6]-H[7]-J[0]+J[1]+J[2]-J[3]-J[4]-J[5]+J[6]-J[7]-J[8]+J[9]+J[10]+J[11]-J[12]+J[13]-J[14]-J[15]-J[16]+J[17]-J[18]-J[19]-J[20]+J[21]+J[22]+J[23]-J[24]+J[25]-J[26]-J[27] - logZ )
    Pout[178] = exp( -H[0]+H[1]-H[2]-H[3]+H[4]+H[5]-H[6]+H[7]-J[0]+J[1]+J[2]-J[3]-J[4]+J[5]-J[6]-J[7]-J[8]+J[9]+J[10]-J[11]+J[12]+J[13]-J[14]-J[15]+J[16]-J[17]-J[18]-J[19]+J[20]-J[21]+J[22]-J[23]+J[24]-J[25]+J[26]-J[27] - logZ )
    Pout[179] = exp( -H[0]+H[1]-H[2]-H[3]+H[4]+H[5]-H[6]-H[7]-J[0]+J[1]+J[2]-J[3]-J[4]+J[5]+J[6]-J[7]-J[8]+J[9]+J[10]-J[11]-J[12]+J[13]-J[14]-J[15]+J[16]+J[17]-J[18]-J[19]+J[20]+J[21]+J[22]-J[23]-J[24]-J[25]-J[26]+J[27] - logZ )
    Pout[180] = exp( -H[0]+H[1]-H[2]-H[3]+H[4]-H[5]+H[6]+H[7]-J[0]+J[1]+J[2]-J[3]+J[4]-J[5]-J[6]-J[7]-J[8]+J[9]-J[10]+J[11]+J[12]+J[13]-J[14]+J[15]-J[16]-J[17]-J[18]+J[19]-J[20]-J[21]-J[22]+J[23]+J[24]-J[25]-J[26]+J[27] - logZ )
    Pout[181] = exp( -H[0]+H[1]-H[2]-H[3]+H[4]-H[5]+H[6]-H[7]-J[0]+J[1]+J[2]-J[3]+J[4]-J[5]+J[6]-J[7]-J[8]+J[9]-J[10]+J[11]-J[12]+J[13]-J[14]+J[15]-J[16]+J[17]-J[18]+J[19]-J[20]+J[21]-J[22]+J[23]-J[24]-J[25]+J[26]-J[27] - logZ )
    Pout[182] = exp( -H[0]+H[1]-H[2]-H[3]+H[4]-H[5]-H[6]+H[7]-J[0]+J[1]+J[2]-J[3]+J[4]+J[5]-J[6]-J[7]-J[8]+J[9]-J[10]-J[11]+J[12]+J[13]-J[14]+J[15]+J[16]-J[17]-J[18]+J[19]+J[20]-J[21]-J[22]-J[23]+J[24]+J[25]-J[26]-J[27] - logZ )
    Pout[183] = exp( -H[0]+H[1]-H[2]-H[3]+H[4]-H[5]-H[6]-H[7]-J[0]+J[1]+J[2]-J[3]+J[4]+J[5]+J[6]-J[7]-J[8]+J[9]-J[10]-J[11]-J[12]+J[13]-J[14]+J[15]+J[16]+J[17]-J[18]+J[19]+J[20]+J[21]-J[22]-J[23]-J[24]+J[25]+J[26]+J[27] - logZ )
    Pout[184] = exp( -H[0]+H[1]-H[2]-H[3]-H[4]+H[5]+H[6]+H[7]-J[0]+J[1]+J[2]+J[3]-J[4]-J[5]-J[6]-J[7]-J[8]-J[9]+J[10]+J[11]+J[12]+J[13]+J[14]-J[15]-J[16]-J[17]+J[18]-J[19]-J[20]-J[21]-J[22]-J[23]-J[24]+J[25]+J[26]+J[27] - logZ )
    Pout[185] = exp( -H[0]+H[1]-H[2]-H[3]-H[4]+H[5]+H[6]-H[7]-J[0]+J[1]+J[2]+J[3]-J[4]-J[5]+J[6]-J[7]-J[8]-J[9]+J[10]+J[11]-J[12]+J[13]+J[14]-J[15]-J[16]+J[17]+J[18]-J[19]-J[20]+J[21]-J[22]-J[23]+J[24]+J[25]-J[26]-J[27] - logZ )
    Pout[186] = exp( -H[0]+H[1]-H[2]-H[3]-H[4]+H[5]-H[6]+H[7]-J[0]+J[1]+J[2]+J[3]-J[4]+J[5]-J[6]-J[7]-J[8]-J[9]+J[10]-J[11]+J[12]+J[13]+J[14]-J[15]+J[16]-J[17]+J[18]-J[19]+J[20]-J[21]-J[22]+J[23]-J[24]-J[25]+J[26]-J[27] - logZ )
    Pout[187] = exp( -H[0]+H[1]-H[2]-H[3]-H[4]+H[5]-H[6]-H[7]-J[0]+J[1]+J[2]+J[3]-J[4]+J[5]+J[6]-J[7]-J[8]-J[9]+J[10]-J[11]-J[12]+J[13]+J[14]-J[15]+J[16]+J[17]+J[18]-J[19]+J[20]+J[21]-J[22]+J[23]+J[24]-J[25]-J[26]+J[27] - logZ )
    Pout[188] = exp( -H[0]+H[1]-H[2]-H[3]-H[4]-H[5]+H[6]+H[7]-J[0]+J[1]+J[2]+J[3]+J[4]-J[5]-J[6]-J[7]-J[8]-J[9]-J[10]+J[11]+J[12]+J[13]+J[14]+J[15]-J[16]-J[17]+J[18]+J[19]-J[20]-J[21]+J[22]-J[23]-J[24]-J[25]-J[26]+J[27] - logZ )
    Pout[189] = exp( -H[0]+H[1]-H[2]-H[3]-H[4]-H[5]+H[6]-H[7]-J[0]+J[1]+J[2]+J[3]+J[4]-J[5]+J[6]-J[7]-J[8]-J[9]-J[10]+J[11]-J[12]+J[13]+J[14]+J[15]-J[16]+J[17]+J[18]+J[19]-J[20]+J[21]+J[22]-J[23]+J[24]-J[25]+J[26]-J[27] - logZ )
    Pout[190] = exp( -H[0]+H[1]-H[2]-H[3]-H[4]-H[5]-H[6]+H[7]-J[0]+J[1]+J[2]+J[3]+J[4]+J[5]-J[6]-J[7]-J[8]-J[9]-J[10]-J[11]+J[12]+J[13]+J[14]+J[15]+J[16]-J[17]+J[18]+J[19]+J[20]-J[21]+J[22]+J[23]-J[24]+J[25]-J[26]-J[27] - logZ )
    Pout[191] = exp( -H[0]+H[1]-H[2]-H[3]-H[4]-H[5]-H[6]-H[7]-J[0]+J[1]+J[2]+J[3]+J[4]+J[5]+J[6]-J[7]-J[8]-J[9]-J[10]-J[11]-J[12]+J[13]+J[14]+J[15]+J[16]+J[17]+J[18]+J[19]+J[20]+J[21]+J[22]+J[23]+J[24]+J[25]+J[26]+J[27] - logZ )
    Pout[192] = exp( -H[0]-H[1]+H[2]+H[3]+H[4]+H[5]+H[6]+H[7]+J[0]-J[1]-J[2]-J[3]-J[4]-J[5]-J[6]-J[7]-J[8]-J[9]-J[10]-J[11]-J[12]+J[13]+J[14]+J[15]+J[16]+J[17]+J[18]+J[19]+J[20]+J[21]+J[22]+J[23]+J[24]+J[25]+J[26]+J[27] - logZ )
    Pout[193] = exp( -H[0]-H[1]+H[2]+H[3]+H[4]+H[5]+H[6]-H[7]+J[0]-J[1]-J[2]-J[3]-J[4]-J[5]+J[6]-J[7]-J[8]-J[9]-J[10]-J[11]+J[12]+J[13]+J[14]+J[15]+J[16]-J[17]+J[18]+J[19]+J[20]-J[21]+J[22]+J[23]-J[24]+J[25]-J[26]-J[27] - logZ )
    Pout[194] = exp( -H[0]-H[1]+H[2]+H[3]+H[4]+H[5]-H[6]+H[7]+J[0]-J[1]-J[2]-J[3]-J[4]+J[5]-J[6]-J[7]-J[8]-J[9]-J[10]+J[11]-J[12]+J[13]+J[14]+J[15]-J[16]+J[17]+J[18]+J[19]-J[20]+J[21]+J[22]-J[23]+J[24]-J[25]+J[26]-J[27] - logZ )
    Pout[195] = exp( -H[0]-H[1]+H[2]+H[3]+H[4]+H[5]-H[6]-H[7]+J[0]-J[1]-J[2]-J[3]-J[4]+J[5]+J[6]-J[7]-J[8]-J[9]-J[10]+J[11]+J[12]+J[13]+J[14]+J[15]-J[16]-J[17]+J[18]+J[19]-J[20]-J[21]+J[22]-J[23]-J[24]-J[25]-J[26]+J[27] - logZ )
    Pout[196] = exp( -H[0]-H[1]+H[2]+H[3]+H[4]-H[5]+H[6]+H[7]+J[0]-J[1]-J[2]-J[3]+J[4]-J[5]-J[6]-J[7]-J[8]-J[9]+J[10]-J[11]-J[12]+J[13]+J[14]-J[15]+J[16]+J[17]+J[18]-J[19]+J[20]+J[21]-J[22]+J[23]+J[24]-J[25]-J[26]+J[27] - logZ )
    Pout[197] = exp( -H[0]-H[1]+H[2]+H[3]+H[4]-H[5]+H[6]-H[7]+J[0]-J[1]-J[2]-J[3]+J[4]-J[5]+J[6]-J[7]-J[8]-J[9]+J[10]-J[11]+J[12]+J[13]+J[14]-J[15]+J[16]-J[17]+J[18]-J[19]+J[20]-J[21]-J[22]+J[23]-J[24]-J[25]+J[26]-J[27] - logZ )
    Pout[198] = exp( -H[0]-H[1]+H[2]+H[3]+H[4]-H[5]-H[6]+H[7]+J[0]-J[1]-J[2]-J[3]+J[4]+J[5]-J[6]-J[7]-J[8]-J[9]+J[10]+J[11]-J[12]+J[13]+J[14]-J[15]-J[16]+J[17]+J[18]-J[19]-J[20]+J[21]-J[22]-J[23]+J[24]+J[25]-J[26]-J[27] - logZ )
    Pout[199] = exp( -H[0]-H[1]+H[2]+H[3]+H[4]-H[5]-H[6]-H[7]+J[0]-J[1]-J[2]-J[3]+J[4]+J[5]+J[6]-J[7]-J[8]-J[9]+J[10]+J[11]+J[12]+J[13]+J[14]-J[15]-J[16]-J[17]+J[18]-J[19]-J[20]-J[21]-J[22]-J[23]-J[24]+J[25]+J[26]+J[27] - logZ )
    Pout[200] = exp( -H[0]-H[1]+H[2]+H[3]-H[4]+H[5]+H[6]+H[7]+J[0]-J[1]-J[2]+J[3]-J[4]-J[5]-J[6]-J[7]-J[8]+J[9]-J[10]-J[11]-J[12]+J[13]-J[14]+J[15]+J[16]+J[17]-J[18]+J[19]+J[20]+J[21]-J[22]-J[23]-J[24]+J[25]+J[26]+J[27] - logZ )
    Pout[201] = exp( -H[0]-H[1]+H[2]+H[3]-H[4]+H[5]+H[6]-H[7]+J[0]-J[1]-J[2]+J[3]-J[4]-J[5]+J[6]-J[7]-J[8]+J[9]-J[10]-J[11]+J[12]+J[13]-J[14]+J[15]+J[16]-J[17]-J[18]+J[19]+J[20]-J[21]-J[22]-J[23]+J[24]+J[25]-J[26]-J[27] - logZ )
    Pout[202] = exp( -H[0]-H[1]+H[2]+H[3]-H[4]+H[5]-H[6]+H[7]+J[0]-J[1]-J[2]+J[3]-J[4]+J[5]-J[6]-J[7]-J[8]+J[9]-J[10]+J[11]-J[12]+J[13]-J[14]+J[15]-J[16]+J[17]-J[18]+J[19]-J[20]+J[21]-J[22]+J[23]-J[24]-J[25]+J[26]-J[27] - logZ )
    Pout[203] = exp( -H[0]-H[1]+H[2]+H[3]-H[4]+H[5]-H[6]-H[7]+J[0]-J[1]-J[2]+J[3]-J[4]+J[5]+J[6]-J[7]-J[8]+J[9]-J[10]+J[11]+J[12]+J[13]-J[14]+J[15]-J[16]-J[17]-J[18]+J[19]-J[20]-J[21]-J[22]+J[23]+J[24]-J[25]-J[26]+J[27] - logZ )
    Pout[204] = exp( -H[0]-H[1]+H[2]+H[3]-H[4]-H[5]+H[6]+H[7]+J[0]-J[1]-J[2]+J[3]+J[4]-J[5]-J[6]-J[7]-J[8]+J[9]+J[10]-J[11]-J[12]+J[13]-J[14]-J[15]+J[16]+J[17]-J[18]-J[19]+J[20]+J[21]+J[22]-J[23]-J[24]-J[25]-J[26]+J[27] - logZ )
    Pout[205] = exp( -H[0]-H[1]+H[2]+H[3]-H[4]-H[5]+H[6]-H[7]+J[0]-J[1]-J[2]+J[3]+J[4]-J[5]+J[6]-J[7]-J[8]+J[9]+J[10]-J[11]+J[12]+J[13]-J[14]-J[15]+J[16]-J[17]-J[18]-J[19]+J[20]-J[21]+J[22]-J[23]+J[24]-J[25]+J[26]-J[27] - logZ )
    Pout[206] = exp( -H[0]-H[1]+H[2]+H[3]-H[4]-H[5]-H[6]+H[7]+J[0]-J[1]-J[2]+J[3]+J[4]+J[5]-J[6]-J[7]-J[8]+J[9]+J[10]+J[11]-J[12]+J[13]-J[14]-J[15]-J[16]+J[17]-J[18]-J[19]-J[20]+J[21]+J[22]+J[23]-J[24]+J[25]-J[26]-J[27] - logZ )
    Pout[207] = exp( -H[0]-H[1]+H[2]+H[3]-H[4]-H[5]-H[6]-H[7]+J[0]-J[1]-J[2]+J[3]+J[4]+J[5]+J[6]-J[7]-J[8]+J[9]+J[10]+J[11]+J[12]+J[13]-J[14]-J[15]-J[16]-J[17]-J[18]-J[19]-J[20]-J[21]+J[22]+J[23]+J[24]+J[25]+J[26]+J[27] - logZ )
    Pout[208] = exp( -H[0]-H[1]+H[2]-H[3]+H[4]+H[5]+H[6]+H[7]+J[0]-J[1]+J[2]-J[3]-J[4]-J[5]-J[6]-J[7]+J[8]-J[9]-J[10]-J[11]-J[12]-J[13]+J[14]+J[15]+J[16]+J[17]-J[18]-J[19]-J[20]-J[21]+J[22]+J[23]+J[24]+J[25]+J[26]+J[27] - logZ )
    Pout[209] = exp( -H[0]-H[1]+H[2]-H[3]+H[4]+H[5]+H[6]-H[7]+J[0]-J[1]+J[2]-J[3]-J[4]-J[5]+J[6]-J[7]+J[8]-J[9]-J[10]-J[11]+J[12]-J[13]+J[14]+J[15]+J[16]-J[17]-J[18]-J[19]-J[20]+J[21]+J[22]+J[23]-J[24]+J[25]-J[26]-J[27] - logZ )
    Pout[210] = exp( -H[0]-H[1]+H[2]-H[3]+H[4]+H[5]-H[6]+H[7]+J[0]-J[1]+J[2]-J[3]-J[4]+J[5]-J[6]-J[7]+J[8]-J[9]-J[10]+J[11]-J[12]-J[13]+J[14]+J[15]-J[16]+J[17]-J[18]-J[19]+J[20]-J[21]+J[22]-J[23]+J[24]-J[25]+J[26]-J[27] - logZ )
    Pout[211] = exp( -H[0]-H[1]+H[2]-H[3]+H[4]+H[5]-H[6]-H[7]+J[0]-J[1]+J[2]-J[3]-J[4]+J[5]+J[6]-J[7]+J[8]-J[9]-J[10]+J[11]+J[12]-J[13]+J[14]+J[15]-J[16]-J[17]-J[18]-J[19]+J[20]+J[21]+J[22]-J[23]-J[24]-J[25]-J[26]+J[27] - logZ )
    Pout[212] = exp( -H[0]-H[1]+H[2]-H[3]+H[4]-H[5]+H[6]+H[7]+J[0]-J[1]+J[2]-J[3]+J[4]-J[5]-J[6]-J[7]+J[8]-J[9]+J[10]-J[11]-J[12]-J[13]+J[14]-J[15]+J[16]+J[17]-J[18]+J[19]-J[20]-J[21]-J[22]+J[23]+J[24]-J[25]-J[26]+J[27] - logZ )
    Pout[213] = exp( -H[0]-H[1]+H[2]-H[3]+H[4]-H[5]+H[6]-H[7]+J[0]-J[1]+J[2]-J[3]+J[4]-J[5]+J[6]-J[7]+J[8]-J[9]+J[10]-J[11]+J[12]-J[13]+J[14]-J[15]+J[16]-J[17]-J[18]+J[19]-J[20]+J[21]-J[22]+J[23]-J[24]-J[25]+J[26]-J[27] - logZ )
    Pout[214] = exp( -H[0]-H[1]+H[2]-H[3]+H[4]-H[5]-H[6]+H[7]+J[0]-J[1]+J[2]-J[3]+J[4]+J[5]-J[6]-J[7]+J[8]-J[9]+J[10]+J[11]-J[12]-J[13]+J[14]-J[15]-J[16]+J[17]-J[18]+J[19]+J[20]-J[21]-J[22]-J[23]+J[24]+J[25]-J[26]-J[27] - logZ )
    Pout[215] = exp( -H[0]-H[1]+H[2]-H[3]+H[4]-H[5]-H[6]-H[7]+J[0]-J[1]+J[2]-J[3]+J[4]+J[5]+J[6]-J[7]+J[8]-J[9]+J[10]+J[11]+J[12]-J[13]+J[14]-J[15]-J[16]-J[17]-J[18]+J[19]+J[20]+J[21]-J[22]-J[23]-J[24]+J[25]+J[26]+J[27] - logZ )
    Pout[216] = exp( -H[0]-H[1]+H[2]-H[3]-H[4]+H[5]+H[6]+H[7]+J[0]-J[1]+J[2]+J[3]-J[4]-J[5]-J[6]-J[7]+J[8]+J[9]-J[10]-J[11]-J[12]-J[13]-J[14]+J[15]+J[16]+J[17]+J[18]-J[19]-J[20]-J[21]-J[22]-J[23]-J[24]+J[25]+J[26]+J[27] - logZ )
    Pout[217] = exp( -H[0]-H[1]+H[2]-H[3]-H[4]+H[5]+H[6]-H[7]+J[0]-J[1]+J[2]+J[3]-J[4]-J[5]+J[6]-J[7]+J[8]+J[9]-J[10]-J[11]+J[12]-J[13]-J[14]+J[15]+J[16]-J[17]+J[18]-J[19]-J[20]+J[21]-J[22]-J[23]+J[24]+J[25]-J[26]-J[27] - logZ )
    Pout[218] = exp( -H[0]-H[1]+H[2]-H[3]-H[4]+H[5]-H[6]+H[7]+J[0]-J[1]+J[2]+J[3]-J[4]+J[5]-J[6]-J[7]+J[8]+J[9]-J[10]+J[11]-J[12]-J[13]-J[14]+J[15]-J[16]+J[17]+J[18]-J[19]+J[20]-J[21]-J[22]+J[23]-J[24]-J[25]+J[26]-J[27] - logZ )
    Pout[219] = exp( -H[0]-H[1]+H[2]-H[3]-H[4]+H[5]-H[6]-H[7]+J[0]-J[1]+J[2]+J[3]-J[4]+J[5]+J[6]-J[7]+J[8]+J[9]-J[10]+J[11]+J[12]-J[13]-J[14]+J[15]-J[16]-J[17]+J[18]-J[19]+J[20]+J[21]-J[22]+J[23]+J[24]-J[25]-J[26]+J[27] - logZ )
    Pout[220] = exp( -H[0]-H[1]+H[2]-H[3]-H[4]-H[5]+H[6]+H[7]+J[0]-J[1]+J[2]+J[3]+J[4]-J[5]-J[6]-J[7]+J[8]+J[9]+J[10]-J[11]-J[12]-J[13]-J[14]-J[15]+J[16]+J[17]+J[18]+J[19]-J[20]-J[21]+J[22]-J[23]-J[24]-J[25]-J[26]+J[27] - logZ )
    Pout[221] = exp( -H[0]-H[1]+H[2]-H[3]-H[4]-H[5]+H[6]-H[7]+J[0]-J[1]+J[2]+J[3]+J[4]-J[5]+J[6]-J[7]+J[8]+J[9]+J[10]-J[11]+J[12]-J[13]-J[14]-J[15]+J[16]-J[17]+J[18]+J[19]-J[20]+J[21]+J[22]-J[23]+J[24]-J[25]+J[26]-J[27] - logZ )
    Pout[222] = exp( -H[0]-H[1]+H[2]-H[3]-H[4]-H[5]-H[6]+H[7]+J[0]-J[1]+J[2]+J[3]+J[4]+J[5]-J[6]-J[7]+J[8]+J[9]+J[10]+J[11]-J[12]-J[13]-J[14]-J[15]-J[16]+J[17]+J[18]+J[19]+J[20]-J[21]+J[22]+J[23]-J[24]+J[25]-J[26]-J[27] - logZ )
    Pout[223] = exp( -H[0]-H[1]+H[2]-H[3]-H[4]-H[5]-H[6]-H[7]+J[0]-J[1]+J[2]+J[3]+J[4]+J[5]+J[6]-J[7]+J[8]+J[9]+J[10]+J[11]+J[12]-J[13]-J[14]-J[15]-J[16]-J[17]+J[18]+J[19]+J[20]+J[21]+J[22]+J[23]+J[24]+J[25]+J[26]+J[27] - logZ )
    Pout[224] = exp( -H[0]-H[1]-H[2]+H[3]+H[4]+H[5]+H[6]+H[7]+J[0]+J[1]-J[2]-J[3]-J[4]-J[5]-J[6]+J[7]-J[8]-J[9]-J[10]-J[11]-J[12]-J[13]-J[14]-J[15]-J[16]-J[17]+J[18]+J[19]+J[20]+J[21]+J[22]+J[23]+J[24]+J[25]+J[26]+J[27] - logZ )
    Pout[225] = exp( -H[0]-H[1]-H[2]+H[3]+H[4]+H[5]+H[6]-H[7]+J[0]+J[1]-J[2]-J[3]-J[4]-J[5]+J[6]+J[7]-J[8]-J[9]-J[10]-J[11]+J[12]-J[13]-J[14]-J[15]-J[16]+J[17]+J[18]+J[19]+J[20]-J[21]+J[22]+J[23]-J[24]+J[25]-J[26]-J[27] - logZ )
    Pout[226] = exp( -H[0]-H[1]-H[2]+H[3]+H[4]+H[5]-H[6]+H[7]+J[0]+J[1]-J[2]-J[3]-J[4]+J[5]-J[6]+J[7]-J[8]-J[9]-J[10]+J[11]-J[12]-J[13]-J[14]-J[15]+J[16]-J[17]+J[18]+J[19]-J[20]+J[21]+J[22]-J[23]+J[24]-J[25]+J[26]-J[27] - logZ )
    Pout[227] = exp( -H[0]-H[1]-H[2]+H[3]+H[4]+H[5]-H[6]-H[7]+J[0]+J[1]-J[2]-J[3]-J[4]+J[5]+J[6]+J[7]-J[8]-J[9]-J[10]+J[11]+J[12]-J[13]-J[14]-J[15]+J[16]+J[17]+J[18]+J[19]-J[20]-J[21]+J[22]-J[23]-J[24]-J[25]-J[26]+J[27] - logZ )
    Pout[228] = exp( -H[0]-H[1]-H[2]+H[3]+H[4]-H[5]+H[6]+H[7]+J[0]+J[1]-J[2]-J[3]+J[4]-J[5]-J[6]+J[7]-J[8]-J[9]+J[10]-J[11]-J[12]-J[13]-J[14]+J[15]-J[16]-J[17]+J[18]-J[19]+J[20]+J[21]-J[22]+J[23]+J[24]-J[25]-J[26]+J[27] - logZ )
    Pout[229] = exp( -H[0]-H[1]-H[2]+H[3]+H[4]-H[5]+H[6]-H[7]+J[0]+J[1]-J[2]-J[3]+J[4]-J[5]+J[6]+J[7]-J[8]-J[9]+J[10]-J[11]+J[12]-J[13]-J[14]+J[15]-J[16]+J[17]+J[18]-J[19]+J[20]-J[21]-J[22]+J[23]-J[24]-J[25]+J[26]-J[27] - logZ )
    Pout[230] = exp( -H[0]-H[1]-H[2]+H[3]+H[4]-H[5]-H[6]+H[7]+J[0]+J[1]-J[2]-J[3]+J[4]+J[5]-J[6]+J[7]-J[8]-J[9]+J[10]+J[11]-J[12]-J[13]-J[14]+J[15]+J[16]-J[17]+J[18]-J[19]-J[20]+J[21]-J[22]-J[23]+J[24]+J[25]-J[26]-J[27] - logZ )
    Pout[231] = exp( -H[0]-H[1]-H[2]+H[3]+H[4]-H[5]-H[6]-H[7]+J[0]+J[1]-J[2]-J[3]+J[4]+J[5]+J[6]+J[7]-J[8]-J[9]+J[10]+J[11]+J[12]-J[13]-J[14]+J[15]+J[16]+J[17]+J[18]-J[19]-J[20]-J[21]-J[22]-J[23]-J[24]+J[25]+J[26]+J[27] - logZ )
    Pout[232] = exp( -H[0]-H[1]-H[2]+H[3]-H[4]+H[5]+H[6]+H[7]+J[0]+J[1]-J[2]+J[3]-J[4]-J[5]-J[6]+J[7]-J[8]+J[9]-J[10]-J[11]-J[12]-J[13]+J[14]-J[15]-J[16]-J[17]-J[18]+J[19]+J[20]+J[21]-J[22]-J[23]-J[24]+J[25]+J[26]+J[27] - logZ )
    Pout[233] = exp( -H[0]-H[1]-H[2]+H[3]-H[4]+H[5]+H[6]-H[7]+J[0]+J[1]-J[2]+J[3]-J[4]-J[5]+J[6]+J[7]-J[8]+J[9]-J[10]-J[11]+J[12]-J[13]+J[14]-J[15]-J[16]+J[17]-J[18]+J[19]+J[20]-J[21]-J[22]-J[23]+J[24]+J[25]-J[26]-J[27] - logZ )
    Pout[234] = exp( -H[0]-H[1]-H[2]+H[3]-H[4]+H[5]-H[6]+H[7]+J[0]+J[1]-J[2]+J[3]-J[4]+J[5]-J[6]+J[7]-J[8]+J[9]-J[10]+J[11]-J[12]-J[13]+J[14]-J[15]+J[16]-J[17]-J[18]+J[19]-J[20]+J[21]-J[22]+J[23]-J[24]-J[25]+J[26]-J[27] - logZ )
    Pout[235] = exp( -H[0]-H[1]-H[2]+H[3]-H[4]+H[5]-H[6]-H[7]+J[0]+J[1]-J[2]+J[3]-J[4]+J[5]+J[6]+J[7]-J[8]+J[9]-J[10]+J[11]+J[12]-J[13]+J[14]-J[15]+J[16]+J[17]-J[18]+J[19]-J[20]-J[21]-J[22]+J[23]+J[24]-J[25]-J[26]+J[27] - logZ )
    Pout[236] = exp( -H[0]-H[1]-H[2]+H[3]-H[4]-H[5]+H[6]+H[7]+J[0]+J[1]-J[2]+J[3]+J[4]-J[5]-J[6]+J[7]-J[8]+J[9]+J[10]-J[11]-J[12]-J[13]+J[14]+J[15]-J[16]-J[17]-J[18]-J[19]+J[20]+J[21]+J[22]-J[23]-J[24]-J[25]-J[26]+J[27] - logZ )
    Pout[237] = exp( -H[0]-H[1]-H[2]+H[3]-H[4]-H[5]+H[6]-H[7]+J[0]+J[1]-J[2]+J[3]+J[4]-J[5]+J[6]+J[7]-J[8]+J[9]+J[10]-J[11]+J[12]-J[13]+J[14]+J[15]-J[16]+J[17]-J[18]-J[19]+J[20]-J[21]+J[22]-J[23]+J[24]-J[25]+J[26]-J[27] - logZ )
    Pout[238] = exp( -H[0]-H[1]-H[2]+H[3]-H[4]-H[5]-H[6]+H[7]+J[0]+J[1]-J[2]+J[3]+J[4]+J[5]-J[6]+J[7]-J[8]+J[9]+J[10]+J[11]-J[12]-J[13]+J[14]+J[15]+J[16]-J[17]-J[18]-J[19]-J[20]+J[21]+J[22]+J[23]-J[24]+J[25]-J[26]-J[27] - logZ )
    Pout[239] = exp( -H[0]-H[1]-H[2]+H[3]-H[4]-H[5]-H[6]-H[7]+J[0]+J[1]-J[2]+J[3]+J[4]+J[5]+J[6]+J[7]-J[8]+J[9]+J[10]+J[11]+J[12]-J[13]+J[14]+J[15]+J[16]+J[17]-J[18]-J[19]-J[20]-J[21]+J[22]+J[23]+J[24]+J[25]+J[26]+J[27] - logZ )
    Pout[240] = exp( -H[0]-H[1]-H[2]-H[3]+H[4]+H[5]+H[6]+H[7]+J[0]+J[1]+J[2]-J[3]-J[4]-J[5]-J[6]+J[7]+J[8]-J[9]-J[10]-J[11]-J[12]+J[13]-J[14]-J[15]-J[16]-J[17]-J[18]-J[19]-J[20]-J[21]+J[22]+J[23]+J[24]+J[25]+J[26]+J[27] - logZ )
    Pout[241] = exp( -H[0]-H[1]-H[2]-H[3]+H[4]+H[5]+H[6]-H[7]+J[0]+J[1]+J[2]-J[3]-J[4]-J[5]+J[6]+J[7]+J[8]-J[9]-J[10]-J[11]+J[12]+J[13]-J[14]-J[15]-J[16]+J[17]-J[18]-J[19]-J[20]+J[21]+J[22]+J[23]-J[24]+J[25]-J[26]-J[27] - logZ )
    Pout[242] = exp( -H[0]-H[1]-H[2]-H[3]+H[4]+H[5]-H[6]+H[7]+J[0]+J[1]+J[2]-J[3]-J[4]+J[5]-J[6]+J[7]+J[8]-J[9]-J[10]+J[11]-J[12]+J[13]-J[14]-J[15]+J[16]-J[17]-J[18]-J[19]+J[20]-J[21]+J[22]-J[23]+J[24]-J[25]+J[26]-J[27] - logZ )
    Pout[243] = exp( -H[0]-H[1]-H[2]-H[3]+H[4]+H[5]-H[6]-H[7]+J[0]+J[1]+J[2]-J[3]-J[4]+J[5]+J[6]+J[7]+J[8]-J[9]-J[10]+J[11]+J[12]+J[13]-J[14]-J[15]+J[16]+J[17]-J[18]-J[19]+J[20]+J[21]+J[22]-J[23]-J[24]-J[25]-J[26]+J[27] - logZ )
    Pout[244] = exp( -H[0]-H[1]-H[2]-H[3]+H[4]-H[5]+H[6]+H[7]+J[0]+J[1]+J[2]-J[3]+J[4]-J[5]-J[6]+J[7]+J[8]-J[9]+J[10]-J[11]-J[12]+J[13]-J[14]+J[15]-J[16]-J[17]-J[18]+J[19]-J[20]-J[21]-J[22]+J[23]+J[24]-J[25]-J[26]+J[27] - logZ )
    Pout[245] = exp( -H[0]-H[1]-H[2]-H[3]+H[4]-H[5]+H[6]-H[7]+J[0]+J[1]+J[2]-J[3]+J[4]-J[5]+J[6]+J[7]+J[8]-J[9]+J[10]-J[11]+J[12]+J[13]-J[14]+J[15]-J[16]+J[17]-J[18]+J[19]-J[20]+J[21]-J[22]+J[23]-J[24]-J[25]+J[26]-J[27] - logZ )
    Pout[246] = exp( -H[0]-H[1]-H[2]-H[3]+H[4]-H[5]-H[6]+H[7]+J[0]+J[1]+J[2]-J[3]+J[4]+J[5]-J[6]+J[7]+J[8]-J[9]+J[10]+J[11]-J[12]+J[13]-J[14]+J[15]+J[16]-J[17]-J[18]+J[19]+J[20]-J[21]-J[22]-J[23]+J[24]+J[25]-J[26]-J[27] - logZ )
    Pout[247] = exp( -H[0]-H[1]-H[2]-H[3]+H[4]-H[5]-H[6]-H[7]+J[0]+J[1]+J[2]-J[3]+J[4]+J[5]+J[6]+J[7]+J[8]-J[9]+J[10]+J[11]+J[12]+J[13]-J[14]+J[15]+J[16]+J[17]-J[18]+J[19]+J[20]+J[21]-J[22]-J[23]-J[24]+J[25]+J[26]+J[27] - logZ )
    Pout[248] = exp( -H[0]-H[1]-H[2]-H[3]-H[4]+H[5]+H[6]+H[7]+J[0]+J[1]+J[2]+J[3]-J[4]-J[5]-J[6]+J[7]+J[8]+J[9]-J[10]-J[11]-J[12]+J[13]+J[14]-J[15]-J[16]-J[17]+J[18]-J[19]-J[20]-J[21]-J[22]-J[23]-J[24]+J[25]+J[26]+J[27] - logZ )
    Pout[249] = exp( -H[0]-H[1]-H[2]-H[3]-H[4]+H[5]+H[6]-H[7]+J[0]+J[1]+J[2]+J[3]-J[4]-J[5]+J[6]+J[7]+J[8]+J[9]-J[10]-J[11]+J[12]+J[13]+J[14]-J[15]-J[16]+J[17]+J[18]-J[19]-J[20]+J[21]-J[22]-J[23]+J[24]+J[25]-J[26]-J[27] - logZ )
    Pout[250] = exp( -H[0]-H[1]-H[2]-H[3]-H[4]+H[5]-H[6]+H[7]+J[0]+J[1]+J[2]+J[3]-J[4]+J[5]-J[6]+J[7]+J[8]+J[9]-J[10]+J[11]-J[12]+J[13]+J[14]-J[15]+J[16]-J[17]+J[18]-J[19]+J[20]-J[21]-J[22]+J[23]-J[24]-J[25]+J[26]-J[27] - logZ )
    Pout[251] = exp( -H[0]-H[1]-H[2]-H[3]-H[4]+H[5]-H[6]-H[7]+J[0]+J[1]+J[2]+J[3]-J[4]+J[5]+J[6]+J[7]+J[8]+J[9]-J[10]+J[11]+J[12]+J[13]+J[14]-J[15]+J[16]+J[17]+J[18]-J[19]+J[20]+J[21]-J[22]+J[23]+J[24]-J[25]-J[26]+J[27] - logZ )
    Pout[252] = exp( -H[0]-H[1]-H[2]-H[3]-H[4]-H[5]+H[6]+H[7]+J[0]+J[1]+J[2]+J[3]+J[4]-J[5]-J[6]+J[7]+J[8]+J[9]+J[10]-J[11]-J[12]+J[13]+J[14]+J[15]-J[16]-J[17]+J[18]+J[19]-J[20]-J[21]+J[22]-J[23]-J[24]-J[25]-J[26]+J[27] - logZ )
    Pout[253] = exp( -H[0]-H[1]-H[2]-H[3]-H[4]-H[5]+H[6]-H[7]+J[0]+J[1]+J[2]+J[3]+J[4]-J[5]+J[6]+J[7]+J[8]+J[9]+J[10]-J[11]+J[12]+J[13]+J[14]+J[15]-J[16]+J[17]+J[18]+J[19]-J[20]+J[21]+J[22]-J[23]+J[24]-J[25]+J[26]-J[27] - logZ )
    Pout[254] = exp( -H[0]-H[1]-H[2]-H[3]-H[4]-H[5]-H[6]+H[7]+J[0]+J[1]+J[2]+J[3]+J[4]+J[5]-J[6]+J[7]+J[8]+J[9]+J[10]+J[11]-J[12]+J[13]+J[14]+J[15]+J[16]-J[17]+J[18]+J[19]+J[20]-J[21]+J[22]+J[23]-J[24]+J[25]-J[26]-J[27] - logZ )
    Pout[255] = exp( -H[0]-H[1]-H[2]-H[3]-H[4]-H[5]-H[6]-H[7]+J[0]+J[1]+J[2]+J[3]+J[4]+J[5]+J[6]+J[7]+J[8]+J[9]+J[10]+J[11]+J[12]+J[13]+J[14]+J[15]+J[16]+J[17]+J[18]+J[19]+J[20]+J[21]+J[22]+J[23]+J[24]+J[25]+J[26]+J[27] - logZ )

    Pout = Pout[::-1]
    return(Pout)
