import requests
from uiuc_apartments.shared import BaseAgency, Apartment
import json

class Smile(BaseAgency):
    url = 'https://www.smilestudentliving.com/_dm/s/rt/actions/sites/24eaedf2/collections/appfolio-listings/ENGLISH'
    agency = "Smile"

    def get_all(self):
        apartments = []
        # request with user agent

        contents = requests.get(
            self.url, headers={'User-Agent': 'api-scraper'}).json()
        apartment_list = json.loads(contents['value'])
        for apartment in apartment_list:
            details = apartment['data']
            address = details['address_address1']
            available_date = details.get('available_date', None)
            bathrooms = details['bathrooms']
            bedrooms = details['bedrooms']
            # Studio
            is_studio = False
            if bedrooms == 0:
                bedrooms = 1
                is_studio = True
            market_rent = int(details['market_rent'])
            link = "https://www.smilestudentliving.com/listings/detail/" + \
                apartment['page_item_url']
            apartments.append(Apartment(address, market_rent, bedrooms,
                                        bathrooms, link, available_date, self.agency, is_studio))

        return apartments