#
# Autogenerated by Thrift Compiler (0.15.0)
#
# DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
#
#  options string: py:tornado,slots,no_utf8strings
#

from thrift.Thrift import TType, TMessageType, TFrozenDict, TException, TApplicationException
from thrift.protocol.TProtocol import TProtocolException
from thrift.TRecursive import fix_spec

import logging
from .ttypes import *
from thrift.Thrift import TProcessor
from thrift.transport import TTransport
from tornado import gen
from tornado import concurrent
all_structs = []


class Iface(object):
    """
    The SWC-DB Thrift Service

    """
    def sql_mng_column(self, sql):
        """
        The direct SQL method to Manage Column.

        Parameters:
         - sql: The SQL string to Execute

        """
        pass

    def sql_list_columns(self, sql):
        """
        The direct SQL method to List Columns

        Parameters:
         - sql: The SQL string to Execute

        """
        pass

    def sql_compact_columns(self, sql):
        """
        The direct SQL method to Compact Columns

        Parameters:
         - sql: The SQL string to Execute

        """
        pass

    def sql_select(self, sql):
        """
        The direct SQL method to select cells with result in Cells List.

        Parameters:
         - sql: The SQL string to Execute

        """
        pass

    def sql_select_rslt_on_column(self, sql):
        """
        The direct SQL method to select cells with result in Columns Cells map.

        Parameters:
         - sql: The SQL string to Execute

        """
        pass

    def sql_select_rslt_on_key(self, sql):
        """
        The direct SQL method to select cells with result in Key Cells list.

        Parameters:
         - sql: The SQL string to Execute

        """
        pass

    def sql_select_rslt_on_fraction(self, sql):
        """
        The direct SQL method to select cells with result in Fractons Cells.

        Parameters:
         - sql: The SQL string to Execute

        """
        pass

    def sql_query(self, sql, rslt):
        """
        The SQL method to select cells with result set by the request's type of CellsResult.

        Parameters:
         - sql: The SQL string to Execute
         - rslt: The Type of Cells Result for the response

        """
        pass

    def sql_update(self, sql, updater_id):
        """
        The direct SQL method to update cells optionally to work with updater-id.

        Parameters:
         - sql: The SQL string to Execute
         - updater_id: The Updater ID to work with

        """
        pass

    def exec_sql(self, sql):
        """
        The SQL method to execute any query.

        Parameters:
         - sql: The SQL string to Execute

        """
        pass

    def updater_create(self, buffer_size):
        """
        The method to Create an Updater ID with buffering size in bytes.

        Parameters:
         - buffer_size: The buffer size of the Updater

        """
        pass

    def updater_close(self, id):
        """
        The method to Close an Updater ID.

        Parameters:
         - id: The Updater ID to close

        """
        pass

    def update(self, cells, updater_id):
        """
        The direct method to update cells with cell in Update-Columns-Cells,
        optionally to work with updater-id.

        Parameters:
         - cells: The Cells to update
         - updater_id: The Updater ID to use for write

        """
        pass

    def update_serial(self, cells, updater_id):
        """
        The direct method to update cells with cell in Update-Columns-Cells-Serial,
        optionally to work with updater-id.

        Parameters:
         - cells: The Serial Cells to update
         - updater_id: The Updater ID to use for write

        """
        pass

    def mng_column(self, func, schema):
        """
        The direct method to Manage Column

        Parameters:
         - func: The Action Function to use
         - schema: The Schema for the Action

        """
        pass

    def list_columns(self, spec):
        """
        The direct method to List Columns

        Parameters:
         - spec: The Schemas Specifications to match Schema for response

        """
        pass

    def compact_columns(self, spec):
        """
        The direct method to Compact Columns

        Parameters:
         - spec: The Schemas Specifications to match columns to Compact

        """
        pass

    def scan(self, spec):
        """
        The direct method to select cells with result in Cells List.

        Parameters:
         - spec: The Scan Specifications for the scan

        """
        pass

    def scan_rslt_on_column(self, spec):
        """
        The direct method to select cells with result in Columns Cells map.

        Parameters:
         - spec: The Scan Specifications for the scan

        """
        pass

    def scan_rslt_on_key(self, spec):
        """
        The direct method to select cells with result in Key Cells list.

        Parameters:
         - spec: The Scan Specifications for the scan

        """
        pass

    def scan_rslt_on_fraction(self, spec):
        """
        The direct method to select cells with result in Fractons Cells.

        Parameters:
         - spec: The Scan Specifications for the scan

        """
        pass

    def scan_rslt_on(self, spec, rslt):
        """
        The method to select cells with result set by the request's type of CellsResult.

        Parameters:
         - spec: The Scan Specifications for the scan
         - rslt: The Type of Cells Result for the response

        """
        pass


class Client(Iface):
    """
    The SWC-DB Thrift Service

    """
    def __init__(self, transport, iprot_factory, oprot_factory=None):
        self._transport = transport
        self._iprot_factory = iprot_factory
        self._oprot_factory = (oprot_factory if oprot_factory is not None
                               else iprot_factory)
        self._seqid = 0
        self._reqs = {}
        self._transport.io_loop.spawn_callback(self._start_receiving)

    @gen.engine
    def _start_receiving(self):
        while True:
            try:
                frame = yield self._transport.readFrame()
            except TTransport.TTransportException as e:
                for future in self._reqs.values():
                    future.set_exception(e)
                self._reqs = {}
                return
            tr = TTransport.TMemoryBuffer(frame)
            iprot = self._iprot_factory.getProtocol(tr)
            (fname, mtype, rseqid) = iprot.readMessageBegin()
            method = getattr(self, 'recv_' + fname)
            future = self._reqs.pop(rseqid, None)
            if not future:
                # future has already been discarded
                continue
            try:
                result = method(iprot, mtype, rseqid)
            except Exception as e:
                future.set_exception(e)
            else:
                future.set_result(result)

    def sql_mng_column(self, sql):
        """
        The direct SQL method to Manage Column.

        Parameters:
         - sql: The SQL string to Execute

        """
        self._seqid += 1
        future = self._reqs[self._seqid] = concurrent.Future()
        self.send_sql_mng_column(sql)
        return future

    def send_sql_mng_column(self, sql):
        oprot = self._oprot_factory.getProtocol(self._transport)
        oprot.writeMessageBegin('sql_mng_column', TMessageType.CALL, self._seqid)
        args = sql_mng_column_args()
        args.sql = sql
        args.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    def recv_sql_mng_column(self, iprot, mtype, rseqid):
        if mtype == TMessageType.EXCEPTION:
            x = TApplicationException()
            x.read(iprot)
            iprot.readMessageEnd()
            raise x
        result = sql_mng_column_result()
        result.read(iprot)
        iprot.readMessageEnd()
        if result.e is not None:
            raise result.e
        return

    def sql_list_columns(self, sql):
        """
        The direct SQL method to List Columns

        Parameters:
         - sql: The SQL string to Execute

        """
        self._seqid += 1
        future = self._reqs[self._seqid] = concurrent.Future()
        self.send_sql_list_columns(sql)
        return future

    def send_sql_list_columns(self, sql):
        oprot = self._oprot_factory.getProtocol(self._transport)
        oprot.writeMessageBegin('sql_list_columns', TMessageType.CALL, self._seqid)
        args = sql_list_columns_args()
        args.sql = sql
        args.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    def recv_sql_list_columns(self, iprot, mtype, rseqid):
        if mtype == TMessageType.EXCEPTION:
            x = TApplicationException()
            x.read(iprot)
            iprot.readMessageEnd()
            raise x
        result = sql_list_columns_result()
        result.read(iprot)
        iprot.readMessageEnd()
        if result.success is not None:
            return result.success
        if result.e is not None:
            raise result.e
        raise TApplicationException(TApplicationException.MISSING_RESULT, "sql_list_columns failed: unknown result")

    def sql_compact_columns(self, sql):
        """
        The direct SQL method to Compact Columns

        Parameters:
         - sql: The SQL string to Execute

        """
        self._seqid += 1
        future = self._reqs[self._seqid] = concurrent.Future()
        self.send_sql_compact_columns(sql)
        return future

    def send_sql_compact_columns(self, sql):
        oprot = self._oprot_factory.getProtocol(self._transport)
        oprot.writeMessageBegin('sql_compact_columns', TMessageType.CALL, self._seqid)
        args = sql_compact_columns_args()
        args.sql = sql
        args.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    def recv_sql_compact_columns(self, iprot, mtype, rseqid):
        if mtype == TMessageType.EXCEPTION:
            x = TApplicationException()
            x.read(iprot)
            iprot.readMessageEnd()
            raise x
        result = sql_compact_columns_result()
        result.read(iprot)
        iprot.readMessageEnd()
        if result.success is not None:
            return result.success
        if result.e is not None:
            raise result.e
        raise TApplicationException(TApplicationException.MISSING_RESULT, "sql_compact_columns failed: unknown result")

    def sql_select(self, sql):
        """
        The direct SQL method to select cells with result in Cells List.

        Parameters:
         - sql: The SQL string to Execute

        """
        self._seqid += 1
        future = self._reqs[self._seqid] = concurrent.Future()
        self.send_sql_select(sql)
        return future

    def send_sql_select(self, sql):
        oprot = self._oprot_factory.getProtocol(self._transport)
        oprot.writeMessageBegin('sql_select', TMessageType.CALL, self._seqid)
        args = sql_select_args()
        args.sql = sql
        args.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    def recv_sql_select(self, iprot, mtype, rseqid):
        if mtype == TMessageType.EXCEPTION:
            x = TApplicationException()
            x.read(iprot)
            iprot.readMessageEnd()
            raise x
        result = sql_select_result()
        result.read(iprot)
        iprot.readMessageEnd()
        if result.success is not None:
            return result.success
        if result.e is not None:
            raise result.e
        raise TApplicationException(TApplicationException.MISSING_RESULT, "sql_select failed: unknown result")

    def sql_select_rslt_on_column(self, sql):
        """
        The direct SQL method to select cells with result in Columns Cells map.

        Parameters:
         - sql: The SQL string to Execute

        """
        self._seqid += 1
        future = self._reqs[self._seqid] = concurrent.Future()
        self.send_sql_select_rslt_on_column(sql)
        return future

    def send_sql_select_rslt_on_column(self, sql):
        oprot = self._oprot_factory.getProtocol(self._transport)
        oprot.writeMessageBegin('sql_select_rslt_on_column', TMessageType.CALL, self._seqid)
        args = sql_select_rslt_on_column_args()
        args.sql = sql
        args.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    def recv_sql_select_rslt_on_column(self, iprot, mtype, rseqid):
        if mtype == TMessageType.EXCEPTION:
            x = TApplicationException()
            x.read(iprot)
            iprot.readMessageEnd()
            raise x
        result = sql_select_rslt_on_column_result()
        result.read(iprot)
        iprot.readMessageEnd()
        if result.success is not None:
            return result.success
        if result.e is not None:
            raise result.e
        raise TApplicationException(TApplicationException.MISSING_RESULT, "sql_select_rslt_on_column failed: unknown result")

    def sql_select_rslt_on_key(self, sql):
        """
        The direct SQL method to select cells with result in Key Cells list.

        Parameters:
         - sql: The SQL string to Execute

        """
        self._seqid += 1
        future = self._reqs[self._seqid] = concurrent.Future()
        self.send_sql_select_rslt_on_key(sql)
        return future

    def send_sql_select_rslt_on_key(self, sql):
        oprot = self._oprot_factory.getProtocol(self._transport)
        oprot.writeMessageBegin('sql_select_rslt_on_key', TMessageType.CALL, self._seqid)
        args = sql_select_rslt_on_key_args()
        args.sql = sql
        args.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    def recv_sql_select_rslt_on_key(self, iprot, mtype, rseqid):
        if mtype == TMessageType.EXCEPTION:
            x = TApplicationException()
            x.read(iprot)
            iprot.readMessageEnd()
            raise x
        result = sql_select_rslt_on_key_result()
        result.read(iprot)
        iprot.readMessageEnd()
        if result.success is not None:
            return result.success
        if result.e is not None:
            raise result.e
        raise TApplicationException(TApplicationException.MISSING_RESULT, "sql_select_rslt_on_key failed: unknown result")

    def sql_select_rslt_on_fraction(self, sql):
        """
        The direct SQL method to select cells with result in Fractons Cells.

        Parameters:
         - sql: The SQL string to Execute

        """
        self._seqid += 1
        future = self._reqs[self._seqid] = concurrent.Future()
        self.send_sql_select_rslt_on_fraction(sql)
        return future

    def send_sql_select_rslt_on_fraction(self, sql):
        oprot = self._oprot_factory.getProtocol(self._transport)
        oprot.writeMessageBegin('sql_select_rslt_on_fraction', TMessageType.CALL, self._seqid)
        args = sql_select_rslt_on_fraction_args()
        args.sql = sql
        args.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    def recv_sql_select_rslt_on_fraction(self, iprot, mtype, rseqid):
        if mtype == TMessageType.EXCEPTION:
            x = TApplicationException()
            x.read(iprot)
            iprot.readMessageEnd()
            raise x
        result = sql_select_rslt_on_fraction_result()
        result.read(iprot)
        iprot.readMessageEnd()
        if result.success is not None:
            return result.success
        if result.e is not None:
            raise result.e
        raise TApplicationException(TApplicationException.MISSING_RESULT, "sql_select_rslt_on_fraction failed: unknown result")

    def sql_query(self, sql, rslt):
        """
        The SQL method to select cells with result set by the request's type of CellsResult.

        Parameters:
         - sql: The SQL string to Execute
         - rslt: The Type of Cells Result for the response

        """
        self._seqid += 1
        future = self._reqs[self._seqid] = concurrent.Future()
        self.send_sql_query(sql, rslt)
        return future

    def send_sql_query(self, sql, rslt):
        oprot = self._oprot_factory.getProtocol(self._transport)
        oprot.writeMessageBegin('sql_query', TMessageType.CALL, self._seqid)
        args = sql_query_args()
        args.sql = sql
        args.rslt = rslt
        args.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    def recv_sql_query(self, iprot, mtype, rseqid):
        if mtype == TMessageType.EXCEPTION:
            x = TApplicationException()
            x.read(iprot)
            iprot.readMessageEnd()
            raise x
        result = sql_query_result()
        result.read(iprot)
        iprot.readMessageEnd()
        if result.success is not None:
            return result.success
        if result.e is not None:
            raise result.e
        raise TApplicationException(TApplicationException.MISSING_RESULT, "sql_query failed: unknown result")

    def sql_update(self, sql, updater_id):
        """
        The direct SQL method to update cells optionally to work with updater-id.

        Parameters:
         - sql: The SQL string to Execute
         - updater_id: The Updater ID to work with

        """
        self._seqid += 1
        future = self._reqs[self._seqid] = concurrent.Future()
        self.send_sql_update(sql, updater_id)
        return future

    def send_sql_update(self, sql, updater_id):
        oprot = self._oprot_factory.getProtocol(self._transport)
        oprot.writeMessageBegin('sql_update', TMessageType.CALL, self._seqid)
        args = sql_update_args()
        args.sql = sql
        args.updater_id = updater_id
        args.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    def recv_sql_update(self, iprot, mtype, rseqid):
        if mtype == TMessageType.EXCEPTION:
            x = TApplicationException()
            x.read(iprot)
            iprot.readMessageEnd()
            raise x
        result = sql_update_result()
        result.read(iprot)
        iprot.readMessageEnd()
        if result.e is not None:
            raise result.e
        return

    def exec_sql(self, sql):
        """
        The SQL method to execute any query.

        Parameters:
         - sql: The SQL string to Execute

        """
        self._seqid += 1
        future = self._reqs[self._seqid] = concurrent.Future()
        self.send_exec_sql(sql)
        return future

    def send_exec_sql(self, sql):
        oprot = self._oprot_factory.getProtocol(self._transport)
        oprot.writeMessageBegin('exec_sql', TMessageType.CALL, self._seqid)
        args = exec_sql_args()
        args.sql = sql
        args.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    def recv_exec_sql(self, iprot, mtype, rseqid):
        if mtype == TMessageType.EXCEPTION:
            x = TApplicationException()
            x.read(iprot)
            iprot.readMessageEnd()
            raise x
        result = exec_sql_result()
        result.read(iprot)
        iprot.readMessageEnd()
        if result.success is not None:
            return result.success
        if result.e is not None:
            raise result.e
        raise TApplicationException(TApplicationException.MISSING_RESULT, "exec_sql failed: unknown result")

    def updater_create(self, buffer_size):
        """
        The method to Create an Updater ID with buffering size in bytes.

        Parameters:
         - buffer_size: The buffer size of the Updater

        """
        self._seqid += 1
        future = self._reqs[self._seqid] = concurrent.Future()
        self.send_updater_create(buffer_size)
        return future

    def send_updater_create(self, buffer_size):
        oprot = self._oprot_factory.getProtocol(self._transport)
        oprot.writeMessageBegin('updater_create', TMessageType.CALL, self._seqid)
        args = updater_create_args()
        args.buffer_size = buffer_size
        args.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    def recv_updater_create(self, iprot, mtype, rseqid):
        if mtype == TMessageType.EXCEPTION:
            x = TApplicationException()
            x.read(iprot)
            iprot.readMessageEnd()
            raise x
        result = updater_create_result()
        result.read(iprot)
        iprot.readMessageEnd()
        if result.success is not None:
            return result.success
        if result.e is not None:
            raise result.e
        raise TApplicationException(TApplicationException.MISSING_RESULT, "updater_create failed: unknown result")

    def updater_close(self, id):
        """
        The method to Close an Updater ID.

        Parameters:
         - id: The Updater ID to close

        """
        self._seqid += 1
        future = self._reqs[self._seqid] = concurrent.Future()
        self.send_updater_close(id)
        return future

    def send_updater_close(self, id):
        oprot = self._oprot_factory.getProtocol(self._transport)
        oprot.writeMessageBegin('updater_close', TMessageType.CALL, self._seqid)
        args = updater_close_args()
        args.id = id
        args.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    def recv_updater_close(self, iprot, mtype, rseqid):
        if mtype == TMessageType.EXCEPTION:
            x = TApplicationException()
            x.read(iprot)
            iprot.readMessageEnd()
            raise x
        result = updater_close_result()
        result.read(iprot)
        iprot.readMessageEnd()
        if result.e is not None:
            raise result.e
        return

    def update(self, cells, updater_id):
        """
        The direct method to update cells with cell in Update-Columns-Cells,
        optionally to work with updater-id.

        Parameters:
         - cells: The Cells to update
         - updater_id: The Updater ID to use for write

        """
        self._seqid += 1
        future = self._reqs[self._seqid] = concurrent.Future()
        self.send_update(cells, updater_id)
        return future

    def send_update(self, cells, updater_id):
        oprot = self._oprot_factory.getProtocol(self._transport)
        oprot.writeMessageBegin('update', TMessageType.CALL, self._seqid)
        args = update_args()
        args.cells = cells
        args.updater_id = updater_id
        args.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    def recv_update(self, iprot, mtype, rseqid):
        if mtype == TMessageType.EXCEPTION:
            x = TApplicationException()
            x.read(iprot)
            iprot.readMessageEnd()
            raise x
        result = update_result()
        result.read(iprot)
        iprot.readMessageEnd()
        if result.e is not None:
            raise result.e
        return

    def update_serial(self, cells, updater_id):
        """
        The direct method to update cells with cell in Update-Columns-Cells-Serial,
        optionally to work with updater-id.

        Parameters:
         - cells: The Serial Cells to update
         - updater_id: The Updater ID to use for write

        """
        self._seqid += 1
        future = self._reqs[self._seqid] = concurrent.Future()
        self.send_update_serial(cells, updater_id)
        return future

    def send_update_serial(self, cells, updater_id):
        oprot = self._oprot_factory.getProtocol(self._transport)
        oprot.writeMessageBegin('update_serial', TMessageType.CALL, self._seqid)
        args = update_serial_args()
        args.cells = cells
        args.updater_id = updater_id
        args.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    def recv_update_serial(self, iprot, mtype, rseqid):
        if mtype == TMessageType.EXCEPTION:
            x = TApplicationException()
            x.read(iprot)
            iprot.readMessageEnd()
            raise x
        result = update_serial_result()
        result.read(iprot)
        iprot.readMessageEnd()
        if result.e is not None:
            raise result.e
        return

    def mng_column(self, func, schema):
        """
        The direct method to Manage Column

        Parameters:
         - func: The Action Function to use
         - schema: The Schema for the Action

        """
        self._seqid += 1
        future = self._reqs[self._seqid] = concurrent.Future()
        self.send_mng_column(func, schema)
        return future

    def send_mng_column(self, func, schema):
        oprot = self._oprot_factory.getProtocol(self._transport)
        oprot.writeMessageBegin('mng_column', TMessageType.CALL, self._seqid)
        args = mng_column_args()
        args.func = func
        args.schema = schema
        args.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    def recv_mng_column(self, iprot, mtype, rseqid):
        if mtype == TMessageType.EXCEPTION:
            x = TApplicationException()
            x.read(iprot)
            iprot.readMessageEnd()
            raise x
        result = mng_column_result()
        result.read(iprot)
        iprot.readMessageEnd()
        if result.e is not None:
            raise result.e
        return

    def list_columns(self, spec):
        """
        The direct method to List Columns

        Parameters:
         - spec: The Schemas Specifications to match Schema for response

        """
        self._seqid += 1
        future = self._reqs[self._seqid] = concurrent.Future()
        self.send_list_columns(spec)
        return future

    def send_list_columns(self, spec):
        oprot = self._oprot_factory.getProtocol(self._transport)
        oprot.writeMessageBegin('list_columns', TMessageType.CALL, self._seqid)
        args = list_columns_args()
        args.spec = spec
        args.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    def recv_list_columns(self, iprot, mtype, rseqid):
        if mtype == TMessageType.EXCEPTION:
            x = TApplicationException()
            x.read(iprot)
            iprot.readMessageEnd()
            raise x
        result = list_columns_result()
        result.read(iprot)
        iprot.readMessageEnd()
        if result.success is not None:
            return result.success
        if result.e is not None:
            raise result.e
        raise TApplicationException(TApplicationException.MISSING_RESULT, "list_columns failed: unknown result")

    def compact_columns(self, spec):
        """
        The direct method to Compact Columns

        Parameters:
         - spec: The Schemas Specifications to match columns to Compact

        """
        self._seqid += 1
        future = self._reqs[self._seqid] = concurrent.Future()
        self.send_compact_columns(spec)
        return future

    def send_compact_columns(self, spec):
        oprot = self._oprot_factory.getProtocol(self._transport)
        oprot.writeMessageBegin('compact_columns', TMessageType.CALL, self._seqid)
        args = compact_columns_args()
        args.spec = spec
        args.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    def recv_compact_columns(self, iprot, mtype, rseqid):
        if mtype == TMessageType.EXCEPTION:
            x = TApplicationException()
            x.read(iprot)
            iprot.readMessageEnd()
            raise x
        result = compact_columns_result()
        result.read(iprot)
        iprot.readMessageEnd()
        if result.success is not None:
            return result.success
        if result.e is not None:
            raise result.e
        raise TApplicationException(TApplicationException.MISSING_RESULT, "compact_columns failed: unknown result")

    def scan(self, spec):
        """
        The direct method to select cells with result in Cells List.

        Parameters:
         - spec: The Scan Specifications for the scan

        """
        self._seqid += 1
        future = self._reqs[self._seqid] = concurrent.Future()
        self.send_scan(spec)
        return future

    def send_scan(self, spec):
        oprot = self._oprot_factory.getProtocol(self._transport)
        oprot.writeMessageBegin('scan', TMessageType.CALL, self._seqid)
        args = scan_args()
        args.spec = spec
        args.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    def recv_scan(self, iprot, mtype, rseqid):
        if mtype == TMessageType.EXCEPTION:
            x = TApplicationException()
            x.read(iprot)
            iprot.readMessageEnd()
            raise x
        result = scan_result()
        result.read(iprot)
        iprot.readMessageEnd()
        if result.success is not None:
            return result.success
        if result.e is not None:
            raise result.e
        raise TApplicationException(TApplicationException.MISSING_RESULT, "scan failed: unknown result")

    def scan_rslt_on_column(self, spec):
        """
        The direct method to select cells with result in Columns Cells map.

        Parameters:
         - spec: The Scan Specifications for the scan

        """
        self._seqid += 1
        future = self._reqs[self._seqid] = concurrent.Future()
        self.send_scan_rslt_on_column(spec)
        return future

    def send_scan_rslt_on_column(self, spec):
        oprot = self._oprot_factory.getProtocol(self._transport)
        oprot.writeMessageBegin('scan_rslt_on_column', TMessageType.CALL, self._seqid)
        args = scan_rslt_on_column_args()
        args.spec = spec
        args.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    def recv_scan_rslt_on_column(self, iprot, mtype, rseqid):
        if mtype == TMessageType.EXCEPTION:
            x = TApplicationException()
            x.read(iprot)
            iprot.readMessageEnd()
            raise x
        result = scan_rslt_on_column_result()
        result.read(iprot)
        iprot.readMessageEnd()
        if result.success is not None:
            return result.success
        if result.e is not None:
            raise result.e
        raise TApplicationException(TApplicationException.MISSING_RESULT, "scan_rslt_on_column failed: unknown result")

    def scan_rslt_on_key(self, spec):
        """
        The direct method to select cells with result in Key Cells list.

        Parameters:
         - spec: The Scan Specifications for the scan

        """
        self._seqid += 1
        future = self._reqs[self._seqid] = concurrent.Future()
        self.send_scan_rslt_on_key(spec)
        return future

    def send_scan_rslt_on_key(self, spec):
        oprot = self._oprot_factory.getProtocol(self._transport)
        oprot.writeMessageBegin('scan_rslt_on_key', TMessageType.CALL, self._seqid)
        args = scan_rslt_on_key_args()
        args.spec = spec
        args.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    def recv_scan_rslt_on_key(self, iprot, mtype, rseqid):
        if mtype == TMessageType.EXCEPTION:
            x = TApplicationException()
            x.read(iprot)
            iprot.readMessageEnd()
            raise x
        result = scan_rslt_on_key_result()
        result.read(iprot)
        iprot.readMessageEnd()
        if result.success is not None:
            return result.success
        if result.e is not None:
            raise result.e
        raise TApplicationException(TApplicationException.MISSING_RESULT, "scan_rslt_on_key failed: unknown result")

    def scan_rslt_on_fraction(self, spec):
        """
        The direct method to select cells with result in Fractons Cells.

        Parameters:
         - spec: The Scan Specifications for the scan

        """
        self._seqid += 1
        future = self._reqs[self._seqid] = concurrent.Future()
        self.send_scan_rslt_on_fraction(spec)
        return future

    def send_scan_rslt_on_fraction(self, spec):
        oprot = self._oprot_factory.getProtocol(self._transport)
        oprot.writeMessageBegin('scan_rslt_on_fraction', TMessageType.CALL, self._seqid)
        args = scan_rslt_on_fraction_args()
        args.spec = spec
        args.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    def recv_scan_rslt_on_fraction(self, iprot, mtype, rseqid):
        if mtype == TMessageType.EXCEPTION:
            x = TApplicationException()
            x.read(iprot)
            iprot.readMessageEnd()
            raise x
        result = scan_rslt_on_fraction_result()
        result.read(iprot)
        iprot.readMessageEnd()
        if result.success is not None:
            return result.success
        if result.e is not None:
            raise result.e
        raise TApplicationException(TApplicationException.MISSING_RESULT, "scan_rslt_on_fraction failed: unknown result")

    def scan_rslt_on(self, spec, rslt):
        """
        The method to select cells with result set by the request's type of CellsResult.

        Parameters:
         - spec: The Scan Specifications for the scan
         - rslt: The Type of Cells Result for the response

        """
        self._seqid += 1
        future = self._reqs[self._seqid] = concurrent.Future()
        self.send_scan_rslt_on(spec, rslt)
        return future

    def send_scan_rslt_on(self, spec, rslt):
        oprot = self._oprot_factory.getProtocol(self._transport)
        oprot.writeMessageBegin('scan_rslt_on', TMessageType.CALL, self._seqid)
        args = scan_rslt_on_args()
        args.spec = spec
        args.rslt = rslt
        args.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    def recv_scan_rslt_on(self, iprot, mtype, rseqid):
        if mtype == TMessageType.EXCEPTION:
            x = TApplicationException()
            x.read(iprot)
            iprot.readMessageEnd()
            raise x
        result = scan_rslt_on_result()
        result.read(iprot)
        iprot.readMessageEnd()
        if result.success is not None:
            return result.success
        if result.e is not None:
            raise result.e
        raise TApplicationException(TApplicationException.MISSING_RESULT, "scan_rslt_on failed: unknown result")


class Processor(Iface, TProcessor):
    def __init__(self, handler):
        self._handler = handler
        self._processMap = {}
        self._processMap["sql_mng_column"] = Processor.process_sql_mng_column
        self._processMap["sql_list_columns"] = Processor.process_sql_list_columns
        self._processMap["sql_compact_columns"] = Processor.process_sql_compact_columns
        self._processMap["sql_select"] = Processor.process_sql_select
        self._processMap["sql_select_rslt_on_column"] = Processor.process_sql_select_rslt_on_column
        self._processMap["sql_select_rslt_on_key"] = Processor.process_sql_select_rslt_on_key
        self._processMap["sql_select_rslt_on_fraction"] = Processor.process_sql_select_rslt_on_fraction
        self._processMap["sql_query"] = Processor.process_sql_query
        self._processMap["sql_update"] = Processor.process_sql_update
        self._processMap["exec_sql"] = Processor.process_exec_sql
        self._processMap["updater_create"] = Processor.process_updater_create
        self._processMap["updater_close"] = Processor.process_updater_close
        self._processMap["update"] = Processor.process_update
        self._processMap["update_serial"] = Processor.process_update_serial
        self._processMap["mng_column"] = Processor.process_mng_column
        self._processMap["list_columns"] = Processor.process_list_columns
        self._processMap["compact_columns"] = Processor.process_compact_columns
        self._processMap["scan"] = Processor.process_scan
        self._processMap["scan_rslt_on_column"] = Processor.process_scan_rslt_on_column
        self._processMap["scan_rslt_on_key"] = Processor.process_scan_rslt_on_key
        self._processMap["scan_rslt_on_fraction"] = Processor.process_scan_rslt_on_fraction
        self._processMap["scan_rslt_on"] = Processor.process_scan_rslt_on
        self._on_message_begin = None

    def on_message_begin(self, func):
        self._on_message_begin = func

    def process(self, iprot, oprot):
        (name, type, seqid) = iprot.readMessageBegin()
        if self._on_message_begin:
            self._on_message_begin(name, type, seqid)
        if name not in self._processMap:
            iprot.skip(TType.STRUCT)
            iprot.readMessageEnd()
            x = TApplicationException(TApplicationException.UNKNOWN_METHOD, 'Unknown function %s' % (name))
            oprot.writeMessageBegin(name, TMessageType.EXCEPTION, seqid)
            x.write(oprot)
            oprot.writeMessageEnd()
            oprot.trans.flush()
            return
        else:
            return self._processMap[name](self, seqid, iprot, oprot)

    @gen.coroutine
    def process_sql_mng_column(self, seqid, iprot, oprot):
        args = sql_mng_column_args()
        args.read(iprot)
        iprot.readMessageEnd()
        result = sql_mng_column_result()
        msg_type = TMessageType.REPLY
        try:
            yield gen.maybe_future(self._handler.sql_mng_column(args.sql))
        except Exception as e:
            result.e = e
        except TTransport.TTransportException:
            raise
        except TApplicationException as ex:
            logging.exception('TApplication exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = ex
        except Exception:
            logging.exception('Unexpected exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = TApplicationException(TApplicationException.INTERNAL_ERROR, 'Internal error')
        oprot.writeMessageBegin("sql_mng_column", msg_type, seqid)
        result.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    @gen.coroutine
    def process_sql_list_columns(self, seqid, iprot, oprot):
        args = sql_list_columns_args()
        args.read(iprot)
        iprot.readMessageEnd()
        result = sql_list_columns_result()
        msg_type = TMessageType.REPLY
        try:
            result.success = yield gen.maybe_future(self._handler.sql_list_columns(args.sql))
        except Exception as e:
            result.e = e
        except TTransport.TTransportException:
            raise
        except TApplicationException as ex:
            logging.exception('TApplication exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = ex
        except Exception:
            logging.exception('Unexpected exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = TApplicationException(TApplicationException.INTERNAL_ERROR, 'Internal error')
        oprot.writeMessageBegin("sql_list_columns", msg_type, seqid)
        result.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    @gen.coroutine
    def process_sql_compact_columns(self, seqid, iprot, oprot):
        args = sql_compact_columns_args()
        args.read(iprot)
        iprot.readMessageEnd()
        result = sql_compact_columns_result()
        msg_type = TMessageType.REPLY
        try:
            result.success = yield gen.maybe_future(self._handler.sql_compact_columns(args.sql))
        except Exception as e:
            result.e = e
        except TTransport.TTransportException:
            raise
        except TApplicationException as ex:
            logging.exception('TApplication exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = ex
        except Exception:
            logging.exception('Unexpected exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = TApplicationException(TApplicationException.INTERNAL_ERROR, 'Internal error')
        oprot.writeMessageBegin("sql_compact_columns", msg_type, seqid)
        result.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    @gen.coroutine
    def process_sql_select(self, seqid, iprot, oprot):
        args = sql_select_args()
        args.read(iprot)
        iprot.readMessageEnd()
        result = sql_select_result()
        msg_type = TMessageType.REPLY
        try:
            result.success = yield gen.maybe_future(self._handler.sql_select(args.sql))
        except Exception as e:
            result.e = e
        except TTransport.TTransportException:
            raise
        except TApplicationException as ex:
            logging.exception('TApplication exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = ex
        except Exception:
            logging.exception('Unexpected exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = TApplicationException(TApplicationException.INTERNAL_ERROR, 'Internal error')
        oprot.writeMessageBegin("sql_select", msg_type, seqid)
        result.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    @gen.coroutine
    def process_sql_select_rslt_on_column(self, seqid, iprot, oprot):
        args = sql_select_rslt_on_column_args()
        args.read(iprot)
        iprot.readMessageEnd()
        result = sql_select_rslt_on_column_result()
        msg_type = TMessageType.REPLY
        try:
            result.success = yield gen.maybe_future(self._handler.sql_select_rslt_on_column(args.sql))
        except Exception as e:
            result.e = e
        except TTransport.TTransportException:
            raise
        except TApplicationException as ex:
            logging.exception('TApplication exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = ex
        except Exception:
            logging.exception('Unexpected exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = TApplicationException(TApplicationException.INTERNAL_ERROR, 'Internal error')
        oprot.writeMessageBegin("sql_select_rslt_on_column", msg_type, seqid)
        result.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    @gen.coroutine
    def process_sql_select_rslt_on_key(self, seqid, iprot, oprot):
        args = sql_select_rslt_on_key_args()
        args.read(iprot)
        iprot.readMessageEnd()
        result = sql_select_rslt_on_key_result()
        msg_type = TMessageType.REPLY
        try:
            result.success = yield gen.maybe_future(self._handler.sql_select_rslt_on_key(args.sql))
        except Exception as e:
            result.e = e
        except TTransport.TTransportException:
            raise
        except TApplicationException as ex:
            logging.exception('TApplication exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = ex
        except Exception:
            logging.exception('Unexpected exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = TApplicationException(TApplicationException.INTERNAL_ERROR, 'Internal error')
        oprot.writeMessageBegin("sql_select_rslt_on_key", msg_type, seqid)
        result.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    @gen.coroutine
    def process_sql_select_rslt_on_fraction(self, seqid, iprot, oprot):
        args = sql_select_rslt_on_fraction_args()
        args.read(iprot)
        iprot.readMessageEnd()
        result = sql_select_rslt_on_fraction_result()
        msg_type = TMessageType.REPLY
        try:
            result.success = yield gen.maybe_future(self._handler.sql_select_rslt_on_fraction(args.sql))
        except Exception as e:
            result.e = e
        except TTransport.TTransportException:
            raise
        except TApplicationException as ex:
            logging.exception('TApplication exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = ex
        except Exception:
            logging.exception('Unexpected exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = TApplicationException(TApplicationException.INTERNAL_ERROR, 'Internal error')
        oprot.writeMessageBegin("sql_select_rslt_on_fraction", msg_type, seqid)
        result.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    @gen.coroutine
    def process_sql_query(self, seqid, iprot, oprot):
        args = sql_query_args()
        args.read(iprot)
        iprot.readMessageEnd()
        result = sql_query_result()
        msg_type = TMessageType.REPLY
        try:
            result.success = yield gen.maybe_future(self._handler.sql_query(args.sql, args.rslt))
        except Exception as e:
            result.e = e
        except TTransport.TTransportException:
            raise
        except TApplicationException as ex:
            logging.exception('TApplication exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = ex
        except Exception:
            logging.exception('Unexpected exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = TApplicationException(TApplicationException.INTERNAL_ERROR, 'Internal error')
        oprot.writeMessageBegin("sql_query", msg_type, seqid)
        result.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    @gen.coroutine
    def process_sql_update(self, seqid, iprot, oprot):
        args = sql_update_args()
        args.read(iprot)
        iprot.readMessageEnd()
        result = sql_update_result()
        msg_type = TMessageType.REPLY
        try:
            yield gen.maybe_future(self._handler.sql_update(args.sql, args.updater_id))
        except Exception as e:
            result.e = e
        except TTransport.TTransportException:
            raise
        except TApplicationException as ex:
            logging.exception('TApplication exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = ex
        except Exception:
            logging.exception('Unexpected exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = TApplicationException(TApplicationException.INTERNAL_ERROR, 'Internal error')
        oprot.writeMessageBegin("sql_update", msg_type, seqid)
        result.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    @gen.coroutine
    def process_exec_sql(self, seqid, iprot, oprot):
        args = exec_sql_args()
        args.read(iprot)
        iprot.readMessageEnd()
        result = exec_sql_result()
        msg_type = TMessageType.REPLY
        try:
            result.success = yield gen.maybe_future(self._handler.exec_sql(args.sql))
        except Exception as e:
            result.e = e
        except TTransport.TTransportException:
            raise
        except TApplicationException as ex:
            logging.exception('TApplication exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = ex
        except Exception:
            logging.exception('Unexpected exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = TApplicationException(TApplicationException.INTERNAL_ERROR, 'Internal error')
        oprot.writeMessageBegin("exec_sql", msg_type, seqid)
        result.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    @gen.coroutine
    def process_updater_create(self, seqid, iprot, oprot):
        args = updater_create_args()
        args.read(iprot)
        iprot.readMessageEnd()
        result = updater_create_result()
        msg_type = TMessageType.REPLY
        try:
            result.success = yield gen.maybe_future(self._handler.updater_create(args.buffer_size))
        except Exception as e:
            result.e = e
        except TTransport.TTransportException:
            raise
        except TApplicationException as ex:
            logging.exception('TApplication exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = ex
        except Exception:
            logging.exception('Unexpected exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = TApplicationException(TApplicationException.INTERNAL_ERROR, 'Internal error')
        oprot.writeMessageBegin("updater_create", msg_type, seqid)
        result.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    @gen.coroutine
    def process_updater_close(self, seqid, iprot, oprot):
        args = updater_close_args()
        args.read(iprot)
        iprot.readMessageEnd()
        result = updater_close_result()
        msg_type = TMessageType.REPLY
        try:
            yield gen.maybe_future(self._handler.updater_close(args.id))
        except Exception as e:
            result.e = e
        except TTransport.TTransportException:
            raise
        except TApplicationException as ex:
            logging.exception('TApplication exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = ex
        except Exception:
            logging.exception('Unexpected exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = TApplicationException(TApplicationException.INTERNAL_ERROR, 'Internal error')
        oprot.writeMessageBegin("updater_close", msg_type, seqid)
        result.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    @gen.coroutine
    def process_update(self, seqid, iprot, oprot):
        args = update_args()
        args.read(iprot)
        iprot.readMessageEnd()
        result = update_result()
        msg_type = TMessageType.REPLY
        try:
            yield gen.maybe_future(self._handler.update(args.cells, args.updater_id))
        except Exception as e:
            result.e = e
        except TTransport.TTransportException:
            raise
        except TApplicationException as ex:
            logging.exception('TApplication exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = ex
        except Exception:
            logging.exception('Unexpected exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = TApplicationException(TApplicationException.INTERNAL_ERROR, 'Internal error')
        oprot.writeMessageBegin("update", msg_type, seqid)
        result.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    @gen.coroutine
    def process_update_serial(self, seqid, iprot, oprot):
        args = update_serial_args()
        args.read(iprot)
        iprot.readMessageEnd()
        result = update_serial_result()
        msg_type = TMessageType.REPLY
        try:
            yield gen.maybe_future(self._handler.update_serial(args.cells, args.updater_id))
        except Exception as e:
            result.e = e
        except TTransport.TTransportException:
            raise
        except TApplicationException as ex:
            logging.exception('TApplication exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = ex
        except Exception:
            logging.exception('Unexpected exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = TApplicationException(TApplicationException.INTERNAL_ERROR, 'Internal error')
        oprot.writeMessageBegin("update_serial", msg_type, seqid)
        result.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    @gen.coroutine
    def process_mng_column(self, seqid, iprot, oprot):
        args = mng_column_args()
        args.read(iprot)
        iprot.readMessageEnd()
        result = mng_column_result()
        msg_type = TMessageType.REPLY
        try:
            yield gen.maybe_future(self._handler.mng_column(args.func, args.schema))
        except Exception as e:
            result.e = e
        except TTransport.TTransportException:
            raise
        except TApplicationException as ex:
            logging.exception('TApplication exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = ex
        except Exception:
            logging.exception('Unexpected exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = TApplicationException(TApplicationException.INTERNAL_ERROR, 'Internal error')
        oprot.writeMessageBegin("mng_column", msg_type, seqid)
        result.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    @gen.coroutine
    def process_list_columns(self, seqid, iprot, oprot):
        args = list_columns_args()
        args.read(iprot)
        iprot.readMessageEnd()
        result = list_columns_result()
        msg_type = TMessageType.REPLY
        try:
            result.success = yield gen.maybe_future(self._handler.list_columns(args.spec))
        except Exception as e:
            result.e = e
        except TTransport.TTransportException:
            raise
        except TApplicationException as ex:
            logging.exception('TApplication exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = ex
        except Exception:
            logging.exception('Unexpected exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = TApplicationException(TApplicationException.INTERNAL_ERROR, 'Internal error')
        oprot.writeMessageBegin("list_columns", msg_type, seqid)
        result.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    @gen.coroutine
    def process_compact_columns(self, seqid, iprot, oprot):
        args = compact_columns_args()
        args.read(iprot)
        iprot.readMessageEnd()
        result = compact_columns_result()
        msg_type = TMessageType.REPLY
        try:
            result.success = yield gen.maybe_future(self._handler.compact_columns(args.spec))
        except Exception as e:
            result.e = e
        except TTransport.TTransportException:
            raise
        except TApplicationException as ex:
            logging.exception('TApplication exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = ex
        except Exception:
            logging.exception('Unexpected exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = TApplicationException(TApplicationException.INTERNAL_ERROR, 'Internal error')
        oprot.writeMessageBegin("compact_columns", msg_type, seqid)
        result.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    @gen.coroutine
    def process_scan(self, seqid, iprot, oprot):
        args = scan_args()
        args.read(iprot)
        iprot.readMessageEnd()
        result = scan_result()
        msg_type = TMessageType.REPLY
        try:
            result.success = yield gen.maybe_future(self._handler.scan(args.spec))
        except Exception as e:
            result.e = e
        except TTransport.TTransportException:
            raise
        except TApplicationException as ex:
            logging.exception('TApplication exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = ex
        except Exception:
            logging.exception('Unexpected exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = TApplicationException(TApplicationException.INTERNAL_ERROR, 'Internal error')
        oprot.writeMessageBegin("scan", msg_type, seqid)
        result.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    @gen.coroutine
    def process_scan_rslt_on_column(self, seqid, iprot, oprot):
        args = scan_rslt_on_column_args()
        args.read(iprot)
        iprot.readMessageEnd()
        result = scan_rslt_on_column_result()
        msg_type = TMessageType.REPLY
        try:
            result.success = yield gen.maybe_future(self._handler.scan_rslt_on_column(args.spec))
        except Exception as e:
            result.e = e
        except TTransport.TTransportException:
            raise
        except TApplicationException as ex:
            logging.exception('TApplication exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = ex
        except Exception:
            logging.exception('Unexpected exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = TApplicationException(TApplicationException.INTERNAL_ERROR, 'Internal error')
        oprot.writeMessageBegin("scan_rslt_on_column", msg_type, seqid)
        result.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    @gen.coroutine
    def process_scan_rslt_on_key(self, seqid, iprot, oprot):
        args = scan_rslt_on_key_args()
        args.read(iprot)
        iprot.readMessageEnd()
        result = scan_rslt_on_key_result()
        msg_type = TMessageType.REPLY
        try:
            result.success = yield gen.maybe_future(self._handler.scan_rslt_on_key(args.spec))
        except Exception as e:
            result.e = e
        except TTransport.TTransportException:
            raise
        except TApplicationException as ex:
            logging.exception('TApplication exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = ex
        except Exception:
            logging.exception('Unexpected exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = TApplicationException(TApplicationException.INTERNAL_ERROR, 'Internal error')
        oprot.writeMessageBegin("scan_rslt_on_key", msg_type, seqid)
        result.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    @gen.coroutine
    def process_scan_rslt_on_fraction(self, seqid, iprot, oprot):
        args = scan_rslt_on_fraction_args()
        args.read(iprot)
        iprot.readMessageEnd()
        result = scan_rslt_on_fraction_result()
        msg_type = TMessageType.REPLY
        try:
            result.success = yield gen.maybe_future(self._handler.scan_rslt_on_fraction(args.spec))
        except Exception as e:
            result.e = e
        except TTransport.TTransportException:
            raise
        except TApplicationException as ex:
            logging.exception('TApplication exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = ex
        except Exception:
            logging.exception('Unexpected exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = TApplicationException(TApplicationException.INTERNAL_ERROR, 'Internal error')
        oprot.writeMessageBegin("scan_rslt_on_fraction", msg_type, seqid)
        result.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

    @gen.coroutine
    def process_scan_rslt_on(self, seqid, iprot, oprot):
        args = scan_rslt_on_args()
        args.read(iprot)
        iprot.readMessageEnd()
        result = scan_rslt_on_result()
        msg_type = TMessageType.REPLY
        try:
            result.success = yield gen.maybe_future(self._handler.scan_rslt_on(args.spec, args.rslt))
        except Exception as e:
            result.e = e
        except TTransport.TTransportException:
            raise
        except TApplicationException as ex:
            logging.exception('TApplication exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = ex
        except Exception:
            logging.exception('Unexpected exception in handler')
            msg_type = TMessageType.EXCEPTION
            result = TApplicationException(TApplicationException.INTERNAL_ERROR, 'Internal error')
        oprot.writeMessageBegin("scan_rslt_on", msg_type, seqid)
        result.write(oprot)
        oprot.writeMessageEnd()
        oprot.trans.flush()

# HELPER FUNCTIONS AND STRUCTURES


class sql_mng_column_args(object):
    """
    Attributes:
     - sql: The SQL string to Execute

    """

    __slots__ = (
        'sql',
    )


    def __init__(self, sql=None,):
        self.sql = sql

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRING:
                    self.sql = iprot.readString()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('sql_mng_column_args')
        if self.sql is not None:
            oprot.writeFieldBegin('sql', TType.STRING, 1)
            oprot.writeString(self.sql)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, getattr(self, key))
             for key in self.__slots__]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        if not isinstance(other, self.__class__):
            return False
        for attr in self.__slots__:
            my_val = getattr(self, attr)
            other_val = getattr(other, attr)
            if my_val != other_val:
                return False
        return True

    def __ne__(self, other):
        return not (self == other)
all_structs.append(sql_mng_column_args)
sql_mng_column_args.thrift_spec = (
    None,  # 0
    (1, TType.STRING, 'sql', None, None, ),  # 1
)


class sql_mng_column_result(object):
    """
    Attributes:
     - e

    """

    __slots__ = (
        'e',
    )


    def __init__(self, e=None,):
        self.e = e

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRUCT:
                    self.e = Exception.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('sql_mng_column_result')
        if self.e is not None:
            oprot.writeFieldBegin('e', TType.STRUCT, 1)
            self.e.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, getattr(self, key))
             for key in self.__slots__]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        if not isinstance(other, self.__class__):
            return False
        for attr in self.__slots__:
            my_val = getattr(self, attr)
            other_val = getattr(other, attr)
            if my_val != other_val:
                return False
        return True

    def __ne__(self, other):
        return not (self == other)
all_structs.append(sql_mng_column_result)
sql_mng_column_result.thrift_spec = (
    None,  # 0
    (1, TType.STRUCT, 'e', [Exception, None], None, ),  # 1
)


class sql_list_columns_args(object):
    """
    Attributes:
     - sql: The SQL string to Execute

    """

    __slots__ = (
        'sql',
    )


    def __init__(self, sql=None,):
        self.sql = sql

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRING:
                    self.sql = iprot.readString()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('sql_list_columns_args')
        if self.sql is not None:
            oprot.writeFieldBegin('sql', TType.STRING, 1)
            oprot.writeString(self.sql)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, getattr(self, key))
             for key in self.__slots__]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        if not isinstance(other, self.__class__):
            return False
        for attr in self.__slots__:
            my_val = getattr(self, attr)
            other_val = getattr(other, attr)
            if my_val != other_val:
                return False
        return True

    def __ne__(self, other):
        return not (self == other)
all_structs.append(sql_list_columns_args)
sql_list_columns_args.thrift_spec = (
    None,  # 0
    (1, TType.STRING, 'sql', None, None, ),  # 1
)


class sql_list_columns_result(object):
    """
    Attributes:
     - success
     - e

    """

    __slots__ = (
        'success',
        'e',
    )


    def __init__(self, success=None, e=None,):
        self.success = success
        self.e = e

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 0:
                if ftype == TType.LIST:
                    self.success = []
                    (_etype385, _size382) = iprot.readListBegin()
                    for _i386 in range(_size382):
                        _elem387 = Schema()
                        _elem387.read(iprot)
                        self.success.append(_elem387)
                    iprot.readListEnd()
                else:
                    iprot.skip(ftype)
            elif fid == 1:
                if ftype == TType.STRUCT:
                    self.e = Exception.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('sql_list_columns_result')
        if self.success is not None:
            oprot.writeFieldBegin('success', TType.LIST, 0)
            oprot.writeListBegin(TType.STRUCT, len(self.success))
            for iter388 in self.success:
                iter388.write(oprot)
            oprot.writeListEnd()
            oprot.writeFieldEnd()
        if self.e is not None:
            oprot.writeFieldBegin('e', TType.STRUCT, 1)
            self.e.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, getattr(self, key))
             for key in self.__slots__]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        if not isinstance(other, self.__class__):
            return False
        for attr in self.__slots__:
            my_val = getattr(self, attr)
            other_val = getattr(other, attr)
            if my_val != other_val:
                return False
        return True

    def __ne__(self, other):
        return not (self == other)
all_structs.append(sql_list_columns_result)
sql_list_columns_result.thrift_spec = (
    (0, TType.LIST, 'success', (TType.STRUCT, [Schema, None], False), None, ),  # 0
    (1, TType.STRUCT, 'e', [Exception, None], None, ),  # 1
)


class sql_compact_columns_args(object):
    """
    Attributes:
     - sql: The SQL string to Execute

    """

    __slots__ = (
        'sql',
    )


    def __init__(self, sql=None,):
        self.sql = sql

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRING:
                    self.sql = iprot.readString()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('sql_compact_columns_args')
        if self.sql is not None:
            oprot.writeFieldBegin('sql', TType.STRING, 1)
            oprot.writeString(self.sql)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, getattr(self, key))
             for key in self.__slots__]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        if not isinstance(other, self.__class__):
            return False
        for attr in self.__slots__:
            my_val = getattr(self, attr)
            other_val = getattr(other, attr)
            if my_val != other_val:
                return False
        return True

    def __ne__(self, other):
        return not (self == other)
all_structs.append(sql_compact_columns_args)
sql_compact_columns_args.thrift_spec = (
    None,  # 0
    (1, TType.STRING, 'sql', None, None, ),  # 1
)


class sql_compact_columns_result(object):
    """
    Attributes:
     - success
     - e

    """

    __slots__ = (
        'success',
        'e',
    )


    def __init__(self, success=None, e=None,):
        self.success = success
        self.e = e

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 0:
                if ftype == TType.LIST:
                    self.success = []
                    (_etype392, _size389) = iprot.readListBegin()
                    for _i393 in range(_size389):
                        _elem394 = CompactResult()
                        _elem394.read(iprot)
                        self.success.append(_elem394)
                    iprot.readListEnd()
                else:
                    iprot.skip(ftype)
            elif fid == 1:
                if ftype == TType.STRUCT:
                    self.e = Exception.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('sql_compact_columns_result')
        if self.success is not None:
            oprot.writeFieldBegin('success', TType.LIST, 0)
            oprot.writeListBegin(TType.STRUCT, len(self.success))
            for iter395 in self.success:
                iter395.write(oprot)
            oprot.writeListEnd()
            oprot.writeFieldEnd()
        if self.e is not None:
            oprot.writeFieldBegin('e', TType.STRUCT, 1)
            self.e.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, getattr(self, key))
             for key in self.__slots__]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        if not isinstance(other, self.__class__):
            return False
        for attr in self.__slots__:
            my_val = getattr(self, attr)
            other_val = getattr(other, attr)
            if my_val != other_val:
                return False
        return True

    def __ne__(self, other):
        return not (self == other)
all_structs.append(sql_compact_columns_result)
sql_compact_columns_result.thrift_spec = (
    (0, TType.LIST, 'success', (TType.STRUCT, [CompactResult, None], False), None, ),  # 0
    (1, TType.STRUCT, 'e', [Exception, None], None, ),  # 1
)


class sql_select_args(object):
    """
    Attributes:
     - sql: The SQL string to Execute

    """

    __slots__ = (
        'sql',
    )


    def __init__(self, sql=None,):
        self.sql = sql

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRING:
                    self.sql = iprot.readString()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('sql_select_args')
        if self.sql is not None:
            oprot.writeFieldBegin('sql', TType.STRING, 1)
            oprot.writeString(self.sql)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, getattr(self, key))
             for key in self.__slots__]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        if not isinstance(other, self.__class__):
            return False
        for attr in self.__slots__:
            my_val = getattr(self, attr)
            other_val = getattr(other, attr)
            if my_val != other_val:
                return False
        return True

    def __ne__(self, other):
        return not (self == other)
all_structs.append(sql_select_args)
sql_select_args.thrift_spec = (
    None,  # 0
    (1, TType.STRING, 'sql', None, None, ),  # 1
)


class sql_select_result(object):
    """
    Attributes:
     - success
     - e

    """

    __slots__ = (
        'success',
        'e',
    )


    def __init__(self, success=None, e=None,):
        self.success = success
        self.e = e

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 0:
                if ftype == TType.STRUCT:
                    self.success = Cells()
                    self.success.read(iprot)
                else:
                    iprot.skip(ftype)
            elif fid == 1:
                if ftype == TType.STRUCT:
                    self.e = Exception.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('sql_select_result')
        if self.success is not None:
            oprot.writeFieldBegin('success', TType.STRUCT, 0)
            self.success.write(oprot)
            oprot.writeFieldEnd()
        if self.e is not None:
            oprot.writeFieldBegin('e', TType.STRUCT, 1)
            self.e.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, getattr(self, key))
             for key in self.__slots__]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        if not isinstance(other, self.__class__):
            return False
        for attr in self.__slots__:
            my_val = getattr(self, attr)
            other_val = getattr(other, attr)
            if my_val != other_val:
                return False
        return True

    def __ne__(self, other):
        return not (self == other)
all_structs.append(sql_select_result)
sql_select_result.thrift_spec = (
    (0, TType.STRUCT, 'success', [Cells, None], None, ),  # 0
    (1, TType.STRUCT, 'e', [Exception, None], None, ),  # 1
)


class sql_select_rslt_on_column_args(object):
    """
    Attributes:
     - sql: The SQL string to Execute

    """

    __slots__ = (
        'sql',
    )


    def __init__(self, sql=None,):
        self.sql = sql

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRING:
                    self.sql = iprot.readString()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('sql_select_rslt_on_column_args')
        if self.sql is not None:
            oprot.writeFieldBegin('sql', TType.STRING, 1)
            oprot.writeString(self.sql)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, getattr(self, key))
             for key in self.__slots__]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        if not isinstance(other, self.__class__):
            return False
        for attr in self.__slots__:
            my_val = getattr(self, attr)
            other_val = getattr(other, attr)
            if my_val != other_val:
                return False
        return True

    def __ne__(self, other):
        return not (self == other)
all_structs.append(sql_select_rslt_on_column_args)
sql_select_rslt_on_column_args.thrift_spec = (
    None,  # 0
    (1, TType.STRING, 'sql', None, None, ),  # 1
)


class sql_select_rslt_on_column_result(object):
    """
    Attributes:
     - success
     - e

    """

    __slots__ = (
        'success',
        'e',
    )


    def __init__(self, success=None, e=None,):
        self.success = success
        self.e = e

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 0:
                if ftype == TType.MAP:
                    self.success = {}
                    (_ktype397, _vtype398, _size396) = iprot.readMapBegin()
                    for _i400 in range(_size396):
                        _key401 = iprot.readString()
                        _val402 = ColCells()
                        _val402.read(iprot)
                        self.success[_key401] = _val402
                    iprot.readMapEnd()
                else:
                    iprot.skip(ftype)
            elif fid == 1:
                if ftype == TType.STRUCT:
                    self.e = Exception.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('sql_select_rslt_on_column_result')
        if self.success is not None:
            oprot.writeFieldBegin('success', TType.MAP, 0)
            oprot.writeMapBegin(TType.STRING, TType.STRUCT, len(self.success))
            for kiter403, viter404 in self.success.items():
                oprot.writeString(kiter403)
                viter404.write(oprot)
            oprot.writeMapEnd()
            oprot.writeFieldEnd()
        if self.e is not None:
            oprot.writeFieldBegin('e', TType.STRUCT, 1)
            self.e.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, getattr(self, key))
             for key in self.__slots__]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        if not isinstance(other, self.__class__):
            return False
        for attr in self.__slots__:
            my_val = getattr(self, attr)
            other_val = getattr(other, attr)
            if my_val != other_val:
                return False
        return True

    def __ne__(self, other):
        return not (self == other)
all_structs.append(sql_select_rslt_on_column_result)
sql_select_rslt_on_column_result.thrift_spec = (
    (0, TType.MAP, 'success', (TType.STRING, None, TType.STRUCT, [ColCells, None], False), None, ),  # 0
    (1, TType.STRUCT, 'e', [Exception, None], None, ),  # 1
)


class sql_select_rslt_on_key_args(object):
    """
    Attributes:
     - sql: The SQL string to Execute

    """

    __slots__ = (
        'sql',
    )


    def __init__(self, sql=None,):
        self.sql = sql

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRING:
                    self.sql = iprot.readString()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('sql_select_rslt_on_key_args')
        if self.sql is not None:
            oprot.writeFieldBegin('sql', TType.STRING, 1)
            oprot.writeString(self.sql)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, getattr(self, key))
             for key in self.__slots__]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        if not isinstance(other, self.__class__):
            return False
        for attr in self.__slots__:
            my_val = getattr(self, attr)
            other_val = getattr(other, attr)
            if my_val != other_val:
                return False
        return True

    def __ne__(self, other):
        return not (self == other)
all_structs.append(sql_select_rslt_on_key_args)
sql_select_rslt_on_key_args.thrift_spec = (
    None,  # 0
    (1, TType.STRING, 'sql', None, None, ),  # 1
)


class sql_select_rslt_on_key_result(object):
    """
    Attributes:
     - success
     - e

    """

    __slots__ = (
        'success',
        'e',
    )


    def __init__(self, success=None, e=None,):
        self.success = success
        self.e = e

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 0:
                if ftype == TType.LIST:
                    self.success = []
                    (_etype408, _size405) = iprot.readListBegin()
                    for _i409 in range(_size405):
                        _elem410 = kCells()
                        _elem410.read(iprot)
                        self.success.append(_elem410)
                    iprot.readListEnd()
                else:
                    iprot.skip(ftype)
            elif fid == 1:
                if ftype == TType.STRUCT:
                    self.e = Exception.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('sql_select_rslt_on_key_result')
        if self.success is not None:
            oprot.writeFieldBegin('success', TType.LIST, 0)
            oprot.writeListBegin(TType.STRUCT, len(self.success))
            for iter411 in self.success:
                iter411.write(oprot)
            oprot.writeListEnd()
            oprot.writeFieldEnd()
        if self.e is not None:
            oprot.writeFieldBegin('e', TType.STRUCT, 1)
            self.e.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, getattr(self, key))
             for key in self.__slots__]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        if not isinstance(other, self.__class__):
            return False
        for attr in self.__slots__:
            my_val = getattr(self, attr)
            other_val = getattr(other, attr)
            if my_val != other_val:
                return False
        return True

    def __ne__(self, other):
        return not (self == other)
all_structs.append(sql_select_rslt_on_key_result)
sql_select_rslt_on_key_result.thrift_spec = (
    (0, TType.LIST, 'success', (TType.STRUCT, [kCells, None], False), None, ),  # 0
    (1, TType.STRUCT, 'e', [Exception, None], None, ),  # 1
)


class sql_select_rslt_on_fraction_args(object):
    """
    Attributes:
     - sql: The SQL string to Execute

    """

    __slots__ = (
        'sql',
    )


    def __init__(self, sql=None,):
        self.sql = sql

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRING:
                    self.sql = iprot.readString()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('sql_select_rslt_on_fraction_args')
        if self.sql is not None:
            oprot.writeFieldBegin('sql', TType.STRING, 1)
            oprot.writeString(self.sql)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, getattr(self, key))
             for key in self.__slots__]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        if not isinstance(other, self.__class__):
            return False
        for attr in self.__slots__:
            my_val = getattr(self, attr)
            other_val = getattr(other, attr)
            if my_val != other_val:
                return False
        return True

    def __ne__(self, other):
        return not (self == other)
all_structs.append(sql_select_rslt_on_fraction_args)
sql_select_rslt_on_fraction_args.thrift_spec = (
    None,  # 0
    (1, TType.STRING, 'sql', None, None, ),  # 1
)


class sql_select_rslt_on_fraction_result(object):
    """
    Attributes:
     - success
     - e

    """

    __slots__ = (
        'success',
        'e',
    )


    def __init__(self, success=None, e=None,):
        self.success = success
        self.e = e

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 0:
                if ftype == TType.STRUCT:
                    self.success = FCells()
                    self.success.read(iprot)
                else:
                    iprot.skip(ftype)
            elif fid == 1:
                if ftype == TType.STRUCT:
                    self.e = Exception.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('sql_select_rslt_on_fraction_result')
        if self.success is not None:
            oprot.writeFieldBegin('success', TType.STRUCT, 0)
            self.success.write(oprot)
            oprot.writeFieldEnd()
        if self.e is not None:
            oprot.writeFieldBegin('e', TType.STRUCT, 1)
            self.e.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, getattr(self, key))
             for key in self.__slots__]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        if not isinstance(other, self.__class__):
            return False
        for attr in self.__slots__:
            my_val = getattr(self, attr)
            other_val = getattr(other, attr)
            if my_val != other_val:
                return False
        return True

    def __ne__(self, other):
        return not (self == other)
all_structs.append(sql_select_rslt_on_fraction_result)
sql_select_rslt_on_fraction_result.thrift_spec = (
    (0, TType.STRUCT, 'success', [FCells, None], None, ),  # 0
    (1, TType.STRUCT, 'e', [Exception, None], None, ),  # 1
)


class sql_query_args(object):
    """
    Attributes:
     - sql: The SQL string to Execute
     - rslt: The Type of Cells Result for the response

    """

    __slots__ = (
        'sql',
        'rslt',
    )


    def __init__(self, sql=None, rslt=None,):
        self.sql = sql
        self.rslt = rslt

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRING:
                    self.sql = iprot.readString()
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.I32:
                    self.rslt = iprot.readI32()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('sql_query_args')
        if self.sql is not None:
            oprot.writeFieldBegin('sql', TType.STRING, 1)
            oprot.writeString(self.sql)
            oprot.writeFieldEnd()
        if self.rslt is not None:
            oprot.writeFieldBegin('rslt', TType.I32, 2)
            oprot.writeI32(self.rslt)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, getattr(self, key))
             for key in self.__slots__]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        if not isinstance(other, self.__class__):
            return False
        for attr in self.__slots__:
            my_val = getattr(self, attr)
            other_val = getattr(other, attr)
            if my_val != other_val:
                return False
        return True

    def __ne__(self, other):
        return not (self == other)
all_structs.append(sql_query_args)
sql_query_args.thrift_spec = (
    None,  # 0
    (1, TType.STRING, 'sql', None, None, ),  # 1
    (2, TType.I32, 'rslt', None, None, ),  # 2
)


class sql_query_result(object):
    """
    Attributes:
     - success
     - e

    """

    __slots__ = (
        'success',
        'e',
    )


    def __init__(self, success=None, e=None,):
        self.success = success
        self.e = e

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 0:
                if ftype == TType.STRUCT:
                    self.success = CellsGroup()
                    self.success.read(iprot)
                else:
                    iprot.skip(ftype)
            elif fid == 1:
                if ftype == TType.STRUCT:
                    self.e = Exception.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('sql_query_result')
        if self.success is not None:
            oprot.writeFieldBegin('success', TType.STRUCT, 0)
            self.success.write(oprot)
            oprot.writeFieldEnd()
        if self.e is not None:
            oprot.writeFieldBegin('e', TType.STRUCT, 1)
            self.e.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, getattr(self, key))
             for key in self.__slots__]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        if not isinstance(other, self.__class__):
            return False
        for attr in self.__slots__:
            my_val = getattr(self, attr)
            other_val = getattr(other, attr)
            if my_val != other_val:
                return False
        return True

    def __ne__(self, other):
        return not (self == other)
all_structs.append(sql_query_result)
sql_query_result.thrift_spec = (
    (0, TType.STRUCT, 'success', [CellsGroup, None], None, ),  # 0
    (1, TType.STRUCT, 'e', [Exception, None], None, ),  # 1
)


class sql_update_args(object):
    """
    Attributes:
     - sql: The SQL string to Execute
     - updater_id: The Updater ID to work with

    """

    __slots__ = (
        'sql',
        'updater_id',
    )


    def __init__(self, sql=None, updater_id=0,):
        self.sql = sql
        self.updater_id = updater_id

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRING:
                    self.sql = iprot.readString()
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.I64:
                    self.updater_id = iprot.readI64()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('sql_update_args')
        if self.sql is not None:
            oprot.writeFieldBegin('sql', TType.STRING, 1)
            oprot.writeString(self.sql)
            oprot.writeFieldEnd()
        if self.updater_id is not None:
            oprot.writeFieldBegin('updater_id', TType.I64, 2)
            oprot.writeI64(self.updater_id)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, getattr(self, key))
             for key in self.__slots__]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        if not isinstance(other, self.__class__):
            return False
        for attr in self.__slots__:
            my_val = getattr(self, attr)
            other_val = getattr(other, attr)
            if my_val != other_val:
                return False
        return True

    def __ne__(self, other):
        return not (self == other)
all_structs.append(sql_update_args)
sql_update_args.thrift_spec = (
    None,  # 0
    (1, TType.STRING, 'sql', None, None, ),  # 1
    (2, TType.I64, 'updater_id', None, 0, ),  # 2
)


class sql_update_result(object):
    """
    Attributes:
     - e

    """

    __slots__ = (
        'e',
    )


    def __init__(self, e=None,):
        self.e = e

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRUCT:
                    self.e = Exception.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('sql_update_result')
        if self.e is not None:
            oprot.writeFieldBegin('e', TType.STRUCT, 1)
            self.e.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, getattr(self, key))
             for key in self.__slots__]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        if not isinstance(other, self.__class__):
            return False
        for attr in self.__slots__:
            my_val = getattr(self, attr)
            other_val = getattr(other, attr)
            if my_val != other_val:
                return False
        return True

    def __ne__(self, other):
        return not (self == other)
all_structs.append(sql_update_result)
sql_update_result.thrift_spec = (
    None,  # 0
    (1, TType.STRUCT, 'e', [Exception, None], None, ),  # 1
)


class exec_sql_args(object):
    """
    Attributes:
     - sql: The SQL string to Execute

    """

    __slots__ = (
        'sql',
    )


    def __init__(self, sql=None,):
        self.sql = sql

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRING:
                    self.sql = iprot.readString()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('exec_sql_args')
        if self.sql is not None:
            oprot.writeFieldBegin('sql', TType.STRING, 1)
            oprot.writeString(self.sql)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, getattr(self, key))
             for key in self.__slots__]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        if not isinstance(other, self.__class__):
            return False
        for attr in self.__slots__:
            my_val = getattr(self, attr)
            other_val = getattr(other, attr)
            if my_val != other_val:
                return False
        return True

    def __ne__(self, other):
        return not (self == other)
all_structs.append(exec_sql_args)
exec_sql_args.thrift_spec = (
    None,  # 0
    (1, TType.STRING, 'sql', None, None, ),  # 1
)


class exec_sql_result(object):
    """
    Attributes:
     - success
     - e

    """

    __slots__ = (
        'success',
        'e',
    )


    def __init__(self, success=None, e=None,):
        self.success = success
        self.e = e

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 0:
                if ftype == TType.STRUCT:
                    self.success = Result()
                    self.success.read(iprot)
                else:
                    iprot.skip(ftype)
            elif fid == 1:
                if ftype == TType.STRUCT:
                    self.e = Exception.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('exec_sql_result')
        if self.success is not None:
            oprot.writeFieldBegin('success', TType.STRUCT, 0)
            self.success.write(oprot)
            oprot.writeFieldEnd()
        if self.e is not None:
            oprot.writeFieldBegin('e', TType.STRUCT, 1)
            self.e.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, getattr(self, key))
             for key in self.__slots__]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        if not isinstance(other, self.__class__):
            return False
        for attr in self.__slots__:
            my_val = getattr(self, attr)
            other_val = getattr(other, attr)
            if my_val != other_val:
                return False
        return True

    def __ne__(self, other):
        return not (self == other)
all_structs.append(exec_sql_result)
exec_sql_result.thrift_spec = (
    (0, TType.STRUCT, 'success', [Result, None], None, ),  # 0
    (1, TType.STRUCT, 'e', [Exception, None], None, ),  # 1
)


class updater_create_args(object):
    """
    Attributes:
     - buffer_size: The buffer size of the Updater

    """

    __slots__ = (
        'buffer_size',
    )


    def __init__(self, buffer_size=None,):
        self.buffer_size = buffer_size

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.I32:
                    self.buffer_size = iprot.readI32()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('updater_create_args')
        if self.buffer_size is not None:
            oprot.writeFieldBegin('buffer_size', TType.I32, 1)
            oprot.writeI32(self.buffer_size)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, getattr(self, key))
             for key in self.__slots__]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        if not isinstance(other, self.__class__):
            return False
        for attr in self.__slots__:
            my_val = getattr(self, attr)
            other_val = getattr(other, attr)
            if my_val != other_val:
                return False
        return True

    def __ne__(self, other):
        return not (self == other)
all_structs.append(updater_create_args)
updater_create_args.thrift_spec = (
    None,  # 0
    (1, TType.I32, 'buffer_size', None, None, ),  # 1
)


class updater_create_result(object):
    """
    Attributes:
     - success
     - e

    """

    __slots__ = (
        'success',
        'e',
    )


    def __init__(self, success=None, e=None,):
        self.success = success
        self.e = e

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 0:
                if ftype == TType.I64:
                    self.success = iprot.readI64()
                else:
                    iprot.skip(ftype)
            elif fid == 1:
                if ftype == TType.STRUCT:
                    self.e = Exception.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('updater_create_result')
        if self.success is not None:
            oprot.writeFieldBegin('success', TType.I64, 0)
            oprot.writeI64(self.success)
            oprot.writeFieldEnd()
        if self.e is not None:
            oprot.writeFieldBegin('e', TType.STRUCT, 1)
            self.e.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, getattr(self, key))
             for key in self.__slots__]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        if not isinstance(other, self.__class__):
            return False
        for attr in self.__slots__:
            my_val = getattr(self, attr)
            other_val = getattr(other, attr)
            if my_val != other_val:
                return False
        return True

    def __ne__(self, other):
        return not (self == other)
all_structs.append(updater_create_result)
updater_create_result.thrift_spec = (
    (0, TType.I64, 'success', None, None, ),  # 0
    (1, TType.STRUCT, 'e', [Exception, None], None, ),  # 1
)


class updater_close_args(object):
    """
    Attributes:
     - id: The Updater ID to close

    """

    __slots__ = (
        'id',
    )


    def __init__(self, id=None,):
        self.id = id

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.I64:
                    self.id = iprot.readI64()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('updater_close_args')
        if self.id is not None:
            oprot.writeFieldBegin('id', TType.I64, 1)
            oprot.writeI64(self.id)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, getattr(self, key))
             for key in self.__slots__]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        if not isinstance(other, self.__class__):
            return False
        for attr in self.__slots__:
            my_val = getattr(self, attr)
            other_val = getattr(other, attr)
            if my_val != other_val:
                return False
        return True

    def __ne__(self, other):
        return not (self == other)
all_structs.append(updater_close_args)
updater_close_args.thrift_spec = (
    None,  # 0
    (1, TType.I64, 'id', None, None, ),  # 1
)


class updater_close_result(object):
    """
    Attributes:
     - e

    """

    __slots__ = (
        'e',
    )


    def __init__(self, e=None,):
        self.e = e

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRUCT:
                    self.e = Exception.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('updater_close_result')
        if self.e is not None:
            oprot.writeFieldBegin('e', TType.STRUCT, 1)
            self.e.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, getattr(self, key))
             for key in self.__slots__]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        if not isinstance(other, self.__class__):
            return False
        for attr in self.__slots__:
            my_val = getattr(self, attr)
            other_val = getattr(other, attr)
            if my_val != other_val:
                return False
        return True

    def __ne__(self, other):
        return not (self == other)
all_structs.append(updater_close_result)
updater_close_result.thrift_spec = (
    None,  # 0
    (1, TType.STRUCT, 'e', [Exception, None], None, ),  # 1
)


class update_args(object):
    """
    Attributes:
     - cells: The Cells to update
     - updater_id: The Updater ID to use for write

    """

    __slots__ = (
        'cells',
        'updater_id',
    )


    def __init__(self, cells=None, updater_id=0,):
        self.cells = cells
        self.updater_id = updater_id

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.MAP:
                    self.cells = {}
                    (_ktype413, _vtype414, _size412) = iprot.readMapBegin()
                    for _i416 in range(_size412):
                        _key417 = iprot.readI64()
                        _val418 = []
                        (_etype422, _size419) = iprot.readListBegin()
                        for _i423 in range(_size419):
                            _elem424 = UCell()
                            _elem424.read(iprot)
                            _val418.append(_elem424)
                        iprot.readListEnd()
                        self.cells[_key417] = _val418
                    iprot.readMapEnd()
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.I64:
                    self.updater_id = iprot.readI64()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('update_args')
        if self.cells is not None:
            oprot.writeFieldBegin('cells', TType.MAP, 1)
            oprot.writeMapBegin(TType.I64, TType.LIST, len(self.cells))
            for kiter425, viter426 in self.cells.items():
                oprot.writeI64(kiter425)
                oprot.writeListBegin(TType.STRUCT, len(viter426))
                for iter427 in viter426:
                    iter427.write(oprot)
                oprot.writeListEnd()
            oprot.writeMapEnd()
            oprot.writeFieldEnd()
        if self.updater_id is not None:
            oprot.writeFieldBegin('updater_id', TType.I64, 2)
            oprot.writeI64(self.updater_id)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, getattr(self, key))
             for key in self.__slots__]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        if not isinstance(other, self.__class__):
            return False
        for attr in self.__slots__:
            my_val = getattr(self, attr)
            other_val = getattr(other, attr)
            if my_val != other_val:
                return False
        return True

    def __ne__(self, other):
        return not (self == other)
all_structs.append(update_args)
update_args.thrift_spec = (
    None,  # 0
    (1, TType.MAP, 'cells', (TType.I64, None, TType.LIST, (TType.STRUCT, [UCell, None], False), False), None, ),  # 1
    (2, TType.I64, 'updater_id', None, 0, ),  # 2
)


class update_result(object):
    """
    Attributes:
     - e

    """

    __slots__ = (
        'e',
    )


    def __init__(self, e=None,):
        self.e = e

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRUCT:
                    self.e = Exception.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('update_result')
        if self.e is not None:
            oprot.writeFieldBegin('e', TType.STRUCT, 1)
            self.e.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, getattr(self, key))
             for key in self.__slots__]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        if not isinstance(other, self.__class__):
            return False
        for attr in self.__slots__:
            my_val = getattr(self, attr)
            other_val = getattr(other, attr)
            if my_val != other_val:
                return False
        return True

    def __ne__(self, other):
        return not (self == other)
all_structs.append(update_result)
update_result.thrift_spec = (
    None,  # 0
    (1, TType.STRUCT, 'e', [Exception, None], None, ),  # 1
)


class update_serial_args(object):
    """
    Attributes:
     - cells: The Serial Cells to update
     - updater_id: The Updater ID to use for write

    """

    __slots__ = (
        'cells',
        'updater_id',
    )


    def __init__(self, cells=None, updater_id=0,):
        self.cells = cells
        self.updater_id = updater_id

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.MAP:
                    self.cells = {}
                    (_ktype429, _vtype430, _size428) = iprot.readMapBegin()
                    for _i432 in range(_size428):
                        _key433 = iprot.readI64()
                        _val434 = []
                        (_etype438, _size435) = iprot.readListBegin()
                        for _i439 in range(_size435):
                            _elem440 = UCellSerial()
                            _elem440.read(iprot)
                            _val434.append(_elem440)
                        iprot.readListEnd()
                        self.cells[_key433] = _val434
                    iprot.readMapEnd()
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.I64:
                    self.updater_id = iprot.readI64()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('update_serial_args')
        if self.cells is not None:
            oprot.writeFieldBegin('cells', TType.MAP, 1)
            oprot.writeMapBegin(TType.I64, TType.LIST, len(self.cells))
            for kiter441, viter442 in self.cells.items():
                oprot.writeI64(kiter441)
                oprot.writeListBegin(TType.STRUCT, len(viter442))
                for iter443 in viter442:
                    iter443.write(oprot)
                oprot.writeListEnd()
            oprot.writeMapEnd()
            oprot.writeFieldEnd()
        if self.updater_id is not None:
            oprot.writeFieldBegin('updater_id', TType.I64, 2)
            oprot.writeI64(self.updater_id)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, getattr(self, key))
             for key in self.__slots__]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        if not isinstance(other, self.__class__):
            return False
        for attr in self.__slots__:
            my_val = getattr(self, attr)
            other_val = getattr(other, attr)
            if my_val != other_val:
                return False
        return True

    def __ne__(self, other):
        return not (self == other)
all_structs.append(update_serial_args)
update_serial_args.thrift_spec = (
    None,  # 0
    (1, TType.MAP, 'cells', (TType.I64, None, TType.LIST, (TType.STRUCT, [UCellSerial, None], False), False), None, ),  # 1
    (2, TType.I64, 'updater_id', None, 0, ),  # 2
)


class update_serial_result(object):
    """
    Attributes:
     - e

    """

    __slots__ = (
        'e',
    )


    def __init__(self, e=None,):
        self.e = e

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRUCT:
                    self.e = Exception.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('update_serial_result')
        if self.e is not None:
            oprot.writeFieldBegin('e', TType.STRUCT, 1)
            self.e.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, getattr(self, key))
             for key in self.__slots__]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        if not isinstance(other, self.__class__):
            return False
        for attr in self.__slots__:
            my_val = getattr(self, attr)
            other_val = getattr(other, attr)
            if my_val != other_val:
                return False
        return True

    def __ne__(self, other):
        return not (self == other)
all_structs.append(update_serial_result)
update_serial_result.thrift_spec = (
    None,  # 0
    (1, TType.STRUCT, 'e', [Exception, None], None, ),  # 1
)


class mng_column_args(object):
    """
    Attributes:
     - func: The Action Function to use
     - schema: The Schema for the Action

    """

    __slots__ = (
        'func',
        'schema',
    )


    def __init__(self, func=None, schema=None,):
        self.func = func
        self.schema = schema

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.I32:
                    self.func = iprot.readI32()
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.STRUCT:
                    self.schema = Schema()
                    self.schema.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('mng_column_args')
        if self.func is not None:
            oprot.writeFieldBegin('func', TType.I32, 1)
            oprot.writeI32(self.func)
            oprot.writeFieldEnd()
        if self.schema is not None:
            oprot.writeFieldBegin('schema', TType.STRUCT, 2)
            self.schema.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, getattr(self, key))
             for key in self.__slots__]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        if not isinstance(other, self.__class__):
            return False
        for attr in self.__slots__:
            my_val = getattr(self, attr)
            other_val = getattr(other, attr)
            if my_val != other_val:
                return False
        return True

    def __ne__(self, other):
        return not (self == other)
all_structs.append(mng_column_args)
mng_column_args.thrift_spec = (
    None,  # 0
    (1, TType.I32, 'func', None, None, ),  # 1
    (2, TType.STRUCT, 'schema', [Schema, None], None, ),  # 2
)


class mng_column_result(object):
    """
    Attributes:
     - e

    """

    __slots__ = (
        'e',
    )


    def __init__(self, e=None,):
        self.e = e

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRUCT:
                    self.e = Exception.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('mng_column_result')
        if self.e is not None:
            oprot.writeFieldBegin('e', TType.STRUCT, 1)
            self.e.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, getattr(self, key))
             for key in self.__slots__]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        if not isinstance(other, self.__class__):
            return False
        for attr in self.__slots__:
            my_val = getattr(self, attr)
            other_val = getattr(other, attr)
            if my_val != other_val:
                return False
        return True

    def __ne__(self, other):
        return not (self == other)
all_structs.append(mng_column_result)
mng_column_result.thrift_spec = (
    None,  # 0
    (1, TType.STRUCT, 'e', [Exception, None], None, ),  # 1
)


class list_columns_args(object):
    """
    Attributes:
     - spec: The Schemas Specifications to match Schema for response

    """

    __slots__ = (
        'spec',
    )


    def __init__(self, spec=None,):
        self.spec = spec

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRUCT:
                    self.spec = SpecSchemas()
                    self.spec.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('list_columns_args')
        if self.spec is not None:
            oprot.writeFieldBegin('spec', TType.STRUCT, 1)
            self.spec.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, getattr(self, key))
             for key in self.__slots__]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        if not isinstance(other, self.__class__):
            return False
        for attr in self.__slots__:
            my_val = getattr(self, attr)
            other_val = getattr(other, attr)
            if my_val != other_val:
                return False
        return True

    def __ne__(self, other):
        return not (self == other)
all_structs.append(list_columns_args)
list_columns_args.thrift_spec = (
    None,  # 0
    (1, TType.STRUCT, 'spec', [SpecSchemas, None], None, ),  # 1
)


class list_columns_result(object):
    """
    Attributes:
     - success
     - e

    """

    __slots__ = (
        'success',
        'e',
    )


    def __init__(self, success=None, e=None,):
        self.success = success
        self.e = e

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 0:
                if ftype == TType.LIST:
                    self.success = []
                    (_etype447, _size444) = iprot.readListBegin()
                    for _i448 in range(_size444):
                        _elem449 = Schema()
                        _elem449.read(iprot)
                        self.success.append(_elem449)
                    iprot.readListEnd()
                else:
                    iprot.skip(ftype)
            elif fid == 1:
                if ftype == TType.STRUCT:
                    self.e = Exception.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('list_columns_result')
        if self.success is not None:
            oprot.writeFieldBegin('success', TType.LIST, 0)
            oprot.writeListBegin(TType.STRUCT, len(self.success))
            for iter450 in self.success:
                iter450.write(oprot)
            oprot.writeListEnd()
            oprot.writeFieldEnd()
        if self.e is not None:
            oprot.writeFieldBegin('e', TType.STRUCT, 1)
            self.e.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, getattr(self, key))
             for key in self.__slots__]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        if not isinstance(other, self.__class__):
            return False
        for attr in self.__slots__:
            my_val = getattr(self, attr)
            other_val = getattr(other, attr)
            if my_val != other_val:
                return False
        return True

    def __ne__(self, other):
        return not (self == other)
all_structs.append(list_columns_result)
list_columns_result.thrift_spec = (
    (0, TType.LIST, 'success', (TType.STRUCT, [Schema, None], False), None, ),  # 0
    (1, TType.STRUCT, 'e', [Exception, None], None, ),  # 1
)


class compact_columns_args(object):
    """
    Attributes:
     - spec: The Schemas Specifications to match columns to Compact

    """

    __slots__ = (
        'spec',
    )


    def __init__(self, spec=None,):
        self.spec = spec

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRUCT:
                    self.spec = SpecSchemas()
                    self.spec.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('compact_columns_args')
        if self.spec is not None:
            oprot.writeFieldBegin('spec', TType.STRUCT, 1)
            self.spec.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, getattr(self, key))
             for key in self.__slots__]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        if not isinstance(other, self.__class__):
            return False
        for attr in self.__slots__:
            my_val = getattr(self, attr)
            other_val = getattr(other, attr)
            if my_val != other_val:
                return False
        return True

    def __ne__(self, other):
        return not (self == other)
all_structs.append(compact_columns_args)
compact_columns_args.thrift_spec = (
    None,  # 0
    (1, TType.STRUCT, 'spec', [SpecSchemas, None], None, ),  # 1
)


class compact_columns_result(object):
    """
    Attributes:
     - success
     - e

    """

    __slots__ = (
        'success',
        'e',
    )


    def __init__(self, success=None, e=None,):
        self.success = success
        self.e = e

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 0:
                if ftype == TType.LIST:
                    self.success = []
                    (_etype454, _size451) = iprot.readListBegin()
                    for _i455 in range(_size451):
                        _elem456 = CompactResult()
                        _elem456.read(iprot)
                        self.success.append(_elem456)
                    iprot.readListEnd()
                else:
                    iprot.skip(ftype)
            elif fid == 1:
                if ftype == TType.STRUCT:
                    self.e = Exception.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('compact_columns_result')
        if self.success is not None:
            oprot.writeFieldBegin('success', TType.LIST, 0)
            oprot.writeListBegin(TType.STRUCT, len(self.success))
            for iter457 in self.success:
                iter457.write(oprot)
            oprot.writeListEnd()
            oprot.writeFieldEnd()
        if self.e is not None:
            oprot.writeFieldBegin('e', TType.STRUCT, 1)
            self.e.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, getattr(self, key))
             for key in self.__slots__]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        if not isinstance(other, self.__class__):
            return False
        for attr in self.__slots__:
            my_val = getattr(self, attr)
            other_val = getattr(other, attr)
            if my_val != other_val:
                return False
        return True

    def __ne__(self, other):
        return not (self == other)
all_structs.append(compact_columns_result)
compact_columns_result.thrift_spec = (
    (0, TType.LIST, 'success', (TType.STRUCT, [CompactResult, None], False), None, ),  # 0
    (1, TType.STRUCT, 'e', [Exception, None], None, ),  # 1
)


class scan_args(object):
    """
    Attributes:
     - spec: The Scan Specifications for the scan

    """

    __slots__ = (
        'spec',
    )


    def __init__(self, spec=None,):
        self.spec = spec

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRUCT:
                    self.spec = SpecScan()
                    self.spec.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('scan_args')
        if self.spec is not None:
            oprot.writeFieldBegin('spec', TType.STRUCT, 1)
            self.spec.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, getattr(self, key))
             for key in self.__slots__]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        if not isinstance(other, self.__class__):
            return False
        for attr in self.__slots__:
            my_val = getattr(self, attr)
            other_val = getattr(other, attr)
            if my_val != other_val:
                return False
        return True

    def __ne__(self, other):
        return not (self == other)
all_structs.append(scan_args)
scan_args.thrift_spec = (
    None,  # 0
    (1, TType.STRUCT, 'spec', [SpecScan, None], None, ),  # 1
)


class scan_result(object):
    """
    Attributes:
     - success
     - e

    """

    __slots__ = (
        'success',
        'e',
    )


    def __init__(self, success=None, e=None,):
        self.success = success
        self.e = e

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 0:
                if ftype == TType.STRUCT:
                    self.success = Cells()
                    self.success.read(iprot)
                else:
                    iprot.skip(ftype)
            elif fid == 1:
                if ftype == TType.STRUCT:
                    self.e = Exception.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('scan_result')
        if self.success is not None:
            oprot.writeFieldBegin('success', TType.STRUCT, 0)
            self.success.write(oprot)
            oprot.writeFieldEnd()
        if self.e is not None:
            oprot.writeFieldBegin('e', TType.STRUCT, 1)
            self.e.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, getattr(self, key))
             for key in self.__slots__]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        if not isinstance(other, self.__class__):
            return False
        for attr in self.__slots__:
            my_val = getattr(self, attr)
            other_val = getattr(other, attr)
            if my_val != other_val:
                return False
        return True

    def __ne__(self, other):
        return not (self == other)
all_structs.append(scan_result)
scan_result.thrift_spec = (
    (0, TType.STRUCT, 'success', [Cells, None], None, ),  # 0
    (1, TType.STRUCT, 'e', [Exception, None], None, ),  # 1
)


class scan_rslt_on_column_args(object):
    """
    Attributes:
     - spec: The Scan Specifications for the scan

    """

    __slots__ = (
        'spec',
    )


    def __init__(self, spec=None,):
        self.spec = spec

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRUCT:
                    self.spec = SpecScan()
                    self.spec.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('scan_rslt_on_column_args')
        if self.spec is not None:
            oprot.writeFieldBegin('spec', TType.STRUCT, 1)
            self.spec.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, getattr(self, key))
             for key in self.__slots__]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        if not isinstance(other, self.__class__):
            return False
        for attr in self.__slots__:
            my_val = getattr(self, attr)
            other_val = getattr(other, attr)
            if my_val != other_val:
                return False
        return True

    def __ne__(self, other):
        return not (self == other)
all_structs.append(scan_rslt_on_column_args)
scan_rslt_on_column_args.thrift_spec = (
    None,  # 0
    (1, TType.STRUCT, 'spec', [SpecScan, None], None, ),  # 1
)


class scan_rslt_on_column_result(object):
    """
    Attributes:
     - success
     - e

    """

    __slots__ = (
        'success',
        'e',
    )


    def __init__(self, success=None, e=None,):
        self.success = success
        self.e = e

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 0:
                if ftype == TType.MAP:
                    self.success = {}
                    (_ktype459, _vtype460, _size458) = iprot.readMapBegin()
                    for _i462 in range(_size458):
                        _key463 = iprot.readString()
                        _val464 = ColCells()
                        _val464.read(iprot)
                        self.success[_key463] = _val464
                    iprot.readMapEnd()
                else:
                    iprot.skip(ftype)
            elif fid == 1:
                if ftype == TType.STRUCT:
                    self.e = Exception.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('scan_rslt_on_column_result')
        if self.success is not None:
            oprot.writeFieldBegin('success', TType.MAP, 0)
            oprot.writeMapBegin(TType.STRING, TType.STRUCT, len(self.success))
            for kiter465, viter466 in self.success.items():
                oprot.writeString(kiter465)
                viter466.write(oprot)
            oprot.writeMapEnd()
            oprot.writeFieldEnd()
        if self.e is not None:
            oprot.writeFieldBegin('e', TType.STRUCT, 1)
            self.e.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, getattr(self, key))
             for key in self.__slots__]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        if not isinstance(other, self.__class__):
            return False
        for attr in self.__slots__:
            my_val = getattr(self, attr)
            other_val = getattr(other, attr)
            if my_val != other_val:
                return False
        return True

    def __ne__(self, other):
        return not (self == other)
all_structs.append(scan_rslt_on_column_result)
scan_rslt_on_column_result.thrift_spec = (
    (0, TType.MAP, 'success', (TType.STRING, None, TType.STRUCT, [ColCells, None], False), None, ),  # 0
    (1, TType.STRUCT, 'e', [Exception, None], None, ),  # 1
)


class scan_rslt_on_key_args(object):
    """
    Attributes:
     - spec: The Scan Specifications for the scan

    """

    __slots__ = (
        'spec',
    )


    def __init__(self, spec=None,):
        self.spec = spec

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRUCT:
                    self.spec = SpecScan()
                    self.spec.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('scan_rslt_on_key_args')
        if self.spec is not None:
            oprot.writeFieldBegin('spec', TType.STRUCT, 1)
            self.spec.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, getattr(self, key))
             for key in self.__slots__]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        if not isinstance(other, self.__class__):
            return False
        for attr in self.__slots__:
            my_val = getattr(self, attr)
            other_val = getattr(other, attr)
            if my_val != other_val:
                return False
        return True

    def __ne__(self, other):
        return not (self == other)
all_structs.append(scan_rslt_on_key_args)
scan_rslt_on_key_args.thrift_spec = (
    None,  # 0
    (1, TType.STRUCT, 'spec', [SpecScan, None], None, ),  # 1
)


class scan_rslt_on_key_result(object):
    """
    Attributes:
     - success
     - e

    """

    __slots__ = (
        'success',
        'e',
    )


    def __init__(self, success=None, e=None,):
        self.success = success
        self.e = e

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 0:
                if ftype == TType.LIST:
                    self.success = []
                    (_etype470, _size467) = iprot.readListBegin()
                    for _i471 in range(_size467):
                        _elem472 = kCells()
                        _elem472.read(iprot)
                        self.success.append(_elem472)
                    iprot.readListEnd()
                else:
                    iprot.skip(ftype)
            elif fid == 1:
                if ftype == TType.STRUCT:
                    self.e = Exception.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('scan_rslt_on_key_result')
        if self.success is not None:
            oprot.writeFieldBegin('success', TType.LIST, 0)
            oprot.writeListBegin(TType.STRUCT, len(self.success))
            for iter473 in self.success:
                iter473.write(oprot)
            oprot.writeListEnd()
            oprot.writeFieldEnd()
        if self.e is not None:
            oprot.writeFieldBegin('e', TType.STRUCT, 1)
            self.e.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, getattr(self, key))
             for key in self.__slots__]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        if not isinstance(other, self.__class__):
            return False
        for attr in self.__slots__:
            my_val = getattr(self, attr)
            other_val = getattr(other, attr)
            if my_val != other_val:
                return False
        return True

    def __ne__(self, other):
        return not (self == other)
all_structs.append(scan_rslt_on_key_result)
scan_rslt_on_key_result.thrift_spec = (
    (0, TType.LIST, 'success', (TType.STRUCT, [kCells, None], False), None, ),  # 0
    (1, TType.STRUCT, 'e', [Exception, None], None, ),  # 1
)


class scan_rslt_on_fraction_args(object):
    """
    Attributes:
     - spec: The Scan Specifications for the scan

    """

    __slots__ = (
        'spec',
    )


    def __init__(self, spec=None,):
        self.spec = spec

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRUCT:
                    self.spec = SpecScan()
                    self.spec.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('scan_rslt_on_fraction_args')
        if self.spec is not None:
            oprot.writeFieldBegin('spec', TType.STRUCT, 1)
            self.spec.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, getattr(self, key))
             for key in self.__slots__]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        if not isinstance(other, self.__class__):
            return False
        for attr in self.__slots__:
            my_val = getattr(self, attr)
            other_val = getattr(other, attr)
            if my_val != other_val:
                return False
        return True

    def __ne__(self, other):
        return not (self == other)
all_structs.append(scan_rslt_on_fraction_args)
scan_rslt_on_fraction_args.thrift_spec = (
    None,  # 0
    (1, TType.STRUCT, 'spec', [SpecScan, None], None, ),  # 1
)


class scan_rslt_on_fraction_result(object):
    """
    Attributes:
     - success
     - e

    """

    __slots__ = (
        'success',
        'e',
    )


    def __init__(self, success=None, e=None,):
        self.success = success
        self.e = e

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 0:
                if ftype == TType.STRUCT:
                    self.success = FCells()
                    self.success.read(iprot)
                else:
                    iprot.skip(ftype)
            elif fid == 1:
                if ftype == TType.STRUCT:
                    self.e = Exception.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('scan_rslt_on_fraction_result')
        if self.success is not None:
            oprot.writeFieldBegin('success', TType.STRUCT, 0)
            self.success.write(oprot)
            oprot.writeFieldEnd()
        if self.e is not None:
            oprot.writeFieldBegin('e', TType.STRUCT, 1)
            self.e.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, getattr(self, key))
             for key in self.__slots__]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        if not isinstance(other, self.__class__):
            return False
        for attr in self.__slots__:
            my_val = getattr(self, attr)
            other_val = getattr(other, attr)
            if my_val != other_val:
                return False
        return True

    def __ne__(self, other):
        return not (self == other)
all_structs.append(scan_rslt_on_fraction_result)
scan_rslt_on_fraction_result.thrift_spec = (
    (0, TType.STRUCT, 'success', [FCells, None], None, ),  # 0
    (1, TType.STRUCT, 'e', [Exception, None], None, ),  # 1
)


class scan_rslt_on_args(object):
    """
    Attributes:
     - spec: The Scan Specifications for the scan
     - rslt: The Type of Cells Result for the response

    """

    __slots__ = (
        'spec',
        'rslt',
    )


    def __init__(self, spec=None, rslt=None,):
        self.spec = spec
        self.rslt = rslt

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 1:
                if ftype == TType.STRUCT:
                    self.spec = SpecScan()
                    self.spec.read(iprot)
                else:
                    iprot.skip(ftype)
            elif fid == 2:
                if ftype == TType.I32:
                    self.rslt = iprot.readI32()
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('scan_rslt_on_args')
        if self.spec is not None:
            oprot.writeFieldBegin('spec', TType.STRUCT, 1)
            self.spec.write(oprot)
            oprot.writeFieldEnd()
        if self.rslt is not None:
            oprot.writeFieldBegin('rslt', TType.I32, 2)
            oprot.writeI32(self.rslt)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, getattr(self, key))
             for key in self.__slots__]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        if not isinstance(other, self.__class__):
            return False
        for attr in self.__slots__:
            my_val = getattr(self, attr)
            other_val = getattr(other, attr)
            if my_val != other_val:
                return False
        return True

    def __ne__(self, other):
        return not (self == other)
all_structs.append(scan_rslt_on_args)
scan_rslt_on_args.thrift_spec = (
    None,  # 0
    (1, TType.STRUCT, 'spec', [SpecScan, None], None, ),  # 1
    (2, TType.I32, 'rslt', None, None, ),  # 2
)


class scan_rslt_on_result(object):
    """
    Attributes:
     - success
     - e: The Base Exception

    """

    __slots__ = (
        'success',
        'e',
    )


    def __init__(self, success=None, e=None,):
        self.success = success
        self.e = e

    def read(self, iprot):
        if iprot._fast_decode is not None and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None:
            iprot._fast_decode(self, iprot, [self.__class__, self.thrift_spec])
            return
        iprot.readStructBegin()
        while True:
            (fname, ftype, fid) = iprot.readFieldBegin()
            if ftype == TType.STOP:
                break
            if fid == 0:
                if ftype == TType.STRUCT:
                    self.success = CellsGroup()
                    self.success.read(iprot)
                else:
                    iprot.skip(ftype)
            elif fid == 1:
                if ftype == TType.STRUCT:
                    self.e = Exception.read(iprot)
                else:
                    iprot.skip(ftype)
            else:
                iprot.skip(ftype)
            iprot.readFieldEnd()
        iprot.readStructEnd()

    def write(self, oprot):
        if oprot._fast_encode is not None and self.thrift_spec is not None:
            oprot.trans.write(oprot._fast_encode(self, [self.__class__, self.thrift_spec]))
            return
        oprot.writeStructBegin('scan_rslt_on_result')
        if self.success is not None:
            oprot.writeFieldBegin('success', TType.STRUCT, 0)
            self.success.write(oprot)
            oprot.writeFieldEnd()
        if self.e is not None:
            oprot.writeFieldBegin('e', TType.STRUCT, 1)
            self.e.write(oprot)
            oprot.writeFieldEnd()
        oprot.writeFieldStop()
        oprot.writeStructEnd()

    def validate(self):
        return

    def __repr__(self):
        L = ['%s=%r' % (key, getattr(self, key))
             for key in self.__slots__]
        return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

    def __eq__(self, other):
        if not isinstance(other, self.__class__):
            return False
        for attr in self.__slots__:
            my_val = getattr(self, attr)
            other_val = getattr(other, attr)
            if my_val != other_val:
                return False
        return True

    def __ne__(self, other):
        return not (self == other)
all_structs.append(scan_rslt_on_result)
scan_rslt_on_result.thrift_spec = (
    (0, TType.STRUCT, 'success', [CellsGroup, None], None, ),  # 0
    (1, TType.STRUCT, 'e', [Exception, None], None, ),  # 1
)
fix_spec(all_structs)
del all_structs
