# Generated by Django 3.1.14 on 2022-05-18 12:39

import django.contrib.gis.db.models.fields
import django.db.models.deletion
import django_countries.fields
from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ("stores", "0012_auto_20220514_0633"),
    ]

    operations = [
        migrations.CreateModel(
            name="Address",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("address_line", models.CharField(max_length=250)),
                (
                    "postal_code",
                    models.CharField(
                        help_text="The address postal/zip code.", max_length=64
                    ),
                ),
                (
                    "city",
                    models.CharField(help_text="The address city.", max_length=120),
                ),
                (
                    "region",
                    models.CharField(
                        blank=True,
                        help_text="The address region, province, or state.",
                        max_length=64,
                        null=True,
                    ),
                ),
                (
                    "country",
                    django_countries.fields.CountryField(
                        help_text="The address country.", max_length=2
                    ),
                ),
                (
                    "location",
                    django.contrib.gis.db.models.fields.PointField(
                        blank=True, null=True, srid=4326
                    ),
                ),
                ("is_active", models.BooleanField(default=True)),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
            ],
            options={
                "verbose_name": "address",
                "verbose_name_plural": "addresses",
            },
        ),
        migrations.AddField(
            model_name="store",
            name="pickup_addresses",
            field=models.ManyToManyField(
                blank=True, related_name="pickup_stores", to="stores.Address"
            ),
        ),
        migrations.AlterField(
            model_name="order",
            name="shipping_address",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.PROTECT,
                related_name="orders",
                to="stores.address",
            ),
        ),
        migrations.AlterField(
            model_name="store",
            name="address",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.PROTECT,
                related_name="stores",
                to="stores.address",
            ),
        ),
    ]
