# Generated by Django 4.0.5 on 2022-08-09 20:16

from django.conf import settings
import django.core.serializers.json
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import uuid


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name="ApiCall",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "method",
                    models.CharField(
                        choices=[("post", "POST"), ("get", "GET")],
                        default="post",
                        help_text="Tipo do método desejado",
                        max_length=50,
                    ),
                ),
                (
                    "created_date",
                    models.DateTimeField(default=django.utils.timezone.now),
                ),
                (
                    "body",
                    models.TextField(
                        blank=True,
                        default="\n{% set body = {} %}\n{{body}}\n",
                        help_text="Template Jinja que gerar um corpo que sera enviado com a requisição",
                        null=True,
                    ),
                ),
                (
                    "url",
                    models.CharField(
                        default="http://127.0.0.1:8000/analytics/v1/data",
                        help_text="Fonte de dados desta figura",
                        max_length=100,
                    ),
                ),
                (
                    "position",
                    models.PositiveSmallIntegerField(
                        help_text="Posição de processamento",
                        null=True,
                        verbose_name="Position",
                    ),
                ),
                ("update_at", models.DateTimeField(auto_now=True)),
            ],
            options={
                "verbose_name": "Api Call",
                "verbose_name_plural": "Api Call's",
                "ordering": ["position"],
            },
        ),
        migrations.CreateModel(
            name="Dashboard",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "dashboard_id",
                    models.CharField(default="", max_length=100, unique=True),
                ),
                ("name", models.CharField(max_length=100, unique=True)),
                (
                    "created_date",
                    models.DateTimeField(default=django.utils.timezone.now),
                ),
                ("update_at", models.DateTimeField(auto_now=True)),
                (
                    "image",
                    models.CharField(
                        blank=True, default=None, max_length=500, null=True
                    ),
                ),
                (
                    "apiCall",
                    models.ManyToManyField(
                        blank=True,
                        related_name="dashboardApiCAll",
                        to="analytics.apicall",
                    ),
                ),
            ],
            options={
                "verbose_name": "Dashboard",
                "verbose_name_plural": "Dashboards",
            },
        ),
        migrations.CreateModel(
            name="Figure",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "title",
                    models.CharField(default="", max_length=100, unique=True),
                ),
                (
                    "description",
                    models.CharField(blank=True, default="", max_length=50),
                ),
                (
                    "type",
                    models.CharField(
                        choices=[
                            ("card_box", "Card Box"),
                            ("bar_chart", "Bar Chart"),
                            ("bubble_chart", "Bubble Chart"),
                            (
                                "doughnut_and_pie_charts",
                                "Doughnut and Pie Charts",
                            ),
                            ("line_chart", "Line Chart"),
                            ("polar_area_chart", "Polar Area Chart"),
                            ("radar_chart", "Radar Chart"),
                            ("scatter_chart", "Scatter Chart"),
                        ],
                        default="card_box",
                        help_text="Tipo do gráfico desejado",
                        max_length=50,
                    ),
                ),
                (
                    "created_date",
                    models.DateTimeField(default=django.utils.timezone.now),
                ),
                (
                    "eventJinja",
                    models.TextField(
                        blank=True,
                        help_text="Template Jinja utilizado para tratar o dataset do dashboard",
                        verbose_name="Event Jinja",
                    ),
                ),
                (
                    "position",
                    models.PositiveSmallIntegerField(
                        help_text="Posição desta figura em relação aos outros objetos",
                        null=True,
                        verbose_name="Position",
                    ),
                ),
                ("update_at", models.DateTimeField(auto_now=True)),
                (
                    "dashboard",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="dashboardFigures",
                        to="analytics.dashboard",
                        verbose_name="dashboard",
                    ),
                ),
            ],
            options={
                "verbose_name": "Figure",
                "verbose_name_plural": "Figures",
                "ordering": ["position"],
            },
        ),
        migrations.CreateModel(
            name="Dataset",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                (
                    "created_date",
                    models.DateTimeField(default=django.utils.timezone.now),
                ),
                ("update_at", models.DateTimeField(auto_now=True)),
                (
                    "data",
                    models.JSONField(
                        blank=True,
                        default=dict,
                        encoder=django.core.serializers.json.DjangoJSONEncoder,
                        null=True,
                    ),
                ),
                (
                    "dashboard",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="dashboardDataset",
                        to="analytics.dashboard",
                        verbose_name="dashboard",
                    ),
                ),
            ],
            options={
                "verbose_name": "Dataset",
                "verbose_name_plural": "Datasets",
            },
        ),
        migrations.AddField(
            model_name="dashboard",
            name="dataset",
            field=models.OneToOneField(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="dashboardDataset",
                to="analytics.dataset",
            ),
        ),
        migrations.AddField(
            model_name="dashboard",
            name="figures",
            field=models.ManyToManyField(
                blank=True,
                related_name="dashboardFigures",
                to="analytics.figure",
            ),
        ),
        migrations.AddField(
            model_name="dashboard",
            name="usersAllowed",
            field=models.ManyToManyField(
                blank=True,
                related_name="users_allowed",
                to=settings.AUTH_USER_MODEL,
                verbose_name="Users Allowed",
            ),
        ),
        migrations.AddField(
            model_name="apicall",
            name="dashboard",
            field=models.ForeignKey(
                default=None,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="dashboardApiCall",
                to="analytics.dashboard",
                verbose_name="dashboard",
            ),
        ),
    ]
