class SourcePawnPluginError(Exception):
    """Base exception type for SourcePawn-related errors"""


class SourcePawnPluginFormatError(SourcePawnPluginError):
    """Errors reading SMX files"""


class SourcePawnPluginNativeError(SourcePawnPluginError):
    """Invalid native, or error invoking native"""


class SourcePawnStringFormatError(SourcePawnPluginNativeError):
    """Error during string formatting natives (PrintToChat, etc)"""


class SourcePawnOpcodeDeprecated(DeprecationWarning):
    """Deprecated opcode encountered during execution"""


class SourcePawnOpcodeNotSupported(SourcePawnOpcodeDeprecated):
    """Unsupported opcode encountered during execution"""


class SourcePawnOpcodeNotGenerated(SourcePawnOpcodeDeprecated):
    """A Pawn opcode was encountered which is not generated by spcomp"""


class Done(Exception):
    """This is a control flow hack"""

    def __init__(self, rval):
        self.rval = rval

    def __str__(self):
        # Haaaaack
        return self.rval
