var BraidClient;BraidClient=(()=>{var __webpack_modules__={10:module=>{eval("class BraidClient {\n  constructor (...endpoint) {\n    if (endpoint === '.') {\n      endpoint = window.location\n    }\n    this.endpoint = endpoint\n    this.initialReconnectDelay = 1000\n    this.currentReconnectDelay = this.initialReconnectDelay\n    this.maxReconnectDelay = 16000\n\n    this.subscribe = this.subscribe.bind(this)\n    this.publish = this.publish.bind(this)\n  }\n\n  currentState () {\n    return fetch(this.endpoint, {\n      credentials: 'same-origin',\n      headers: {\n        accept: 'application/json'\n      }\n    })\n      .then(response => response.json())\n      .then(data => {\n        return data\n      })\n  }\n\n  subscribe (handler) {\n    const reconnect = () => {\n      console.log(`Reconnecting to braid at: ${this.endpoint}`)\n      setTimeout(() => {\n        if (this.currentReconnectDelay < this.maxReconnectDelay) {\n          this.currentReconnectDelay *= 2\n        }\n        this.subscribe(handler)\n      }, this.currentReconnectDelay + Math.floor(Math.random() * 3000))\n    }\n\n    fetch(this.endpoint, {\n      headers: {\n        credentials: 'same-origin',\n        subscribe: 'keep-alive'\n      }\n    }).then(response => {\n      const reader = response.body.getReader()\n      const decoder = new TextDecoder('utf-8')\n      let buffer = ''\n      reader.read().then(function processText ({ done, value }) {\n        if (done) {\n          console.log('BRAID: end of stream')\n          return\n        }\n        buffer += decoder.decode(value)\n        const headers = {}\n        const patchParts = buffer.split('\\n\\n')\n        patchParts[0].split('\\n').forEach(header => {\n          const headerName = header.slice(0, header.indexOf(':')).toLowerCase()\n          const headerValue = header.slice(header.indexOf(':') + 1)\n          headers[headerName] = headerValue\n        })\n        if (Number(headers['content-length']) === patchParts[1].length) {\n          buffer = ''\n          const range = headers['content-range'].split('=')[1]\n          const body = JSON.parse(patchParts[1])\n          console.log('BRAID: patch received: ', range, body)\n          handler(range, body)\n        }\n        return reader.read().then(processText)\n      }).catch(err => {\n        console.error('BRAID:', err)\n        reconnect()\n      })\n    }).catch(err => {\n      console.error('BRAID:', err)\n      reconnect()\n    })\n  }\n\n  publish (range, body) {\n    const patch = JSON.stringify(body)\n    fetch(this.endpoint, {\n      method: 'PUT',\n      headers: {\n        credentials: 'same-origin',\n        patches: 1\n      },\n      body: `Content-Length: ${patch.length}\nContent-Range: json=${range}\n\n${patch}`\n    }).then(() => {\n      console.log('BRAID: patch sent: ', range, body)\n    })\n  }\n}\n\nmodule.exports = BraidClient\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///10\n")}},__webpack_module_cache__={};function __webpack_require__(n){if(__webpack_module_cache__[n])return __webpack_module_cache__[n].exports;var e=__webpack_module_cache__[n]={exports:{}};return __webpack_modules__[n](e,e.exports,__webpack_require__),e.exports}return __webpack_require__(10)})();