# mypy-boto3-es<a id="mypy-boto3-es"></a>

[![PyPI - mypy-boto3-es](https://img.shields.io/pypi/v/mypy-boto3-es.svg?color=blue)](https://pypi.org/project/mypy-boto3-es)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-es.svg?color=blue)](https://pypi.org/project/mypy-boto3-es)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)
[![PyPI - Downloads](https://img.shields.io/pypi/dw/mypy-boto3-es?color=blue)](https://pypistats.org/packages/mypy-boto3-es)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.ElasticsearchService 1.17.76](https://boto3.amazonaws.com/v1/documentation/api/1.17.76/reference/services/es.html#ElasticsearchService)
service compatible with [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright) and other tools.

Generated by
[mypy-boto3-buider 4.13.1](https://github.com/vemel/mypy_boto3_builder).

More information can be found on
[boto3-stubs](https://pypi.org/project/boto3-stubs/) page and in
[mypy-boto3-es docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_es/)

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-es](#mypy-boto3-es)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Literals](#literals)
    - [Typed dictionaries](#typed-dictionaries)
  - [Versioning](#versioning)
  - [Documentation](#documentation)
  - [Support and contributing](#support-and-contributing)

## How to install<a id="how-to-install"></a>

Install `boto3-stubs` for `ElasticsearchService` service.

```bash
python -m pip install boto3-stubs[es]
```

## Usage<a id="usage"></a>

### VSCode<a id="vscode"></a>

- Install
  [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install
  [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[es]` in your environment:
  `python -m pip install 'boto3-stubs[es]'`

Both type checking and auto-complete should work for `ElasticsearchService`
service. No explicit type annotations required, write your `boto3` code as
usual.

### PyCharm<a id="pycharm"></a>

- Install `boto-stubs[es]` in your environment:
  `python -m pip install 'boto3-stubs[es]'`

Both type checking and auto-complete should work for `ElasticsearchService`
service. No explicit type annotations required, write your `boto3` code as
usual. Auto-complete can be slow on big projects or if you have a lot of
installed `boto3-stubs` submodules.

### Other IDEs<a id="other-ides"></a>

Not tested, but as long as your IDE support `mypy` or `pyright`, everything
should work.

### mypy<a id="mypy"></a>

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[es]` in your environment:
  `python -m pip install 'boto3-stubs[es]'`
- Run `mypy` as usual

Type checking should work for `ElasticsearchService` service. No explicit type
annotations required, write your `boto3` code as usual.

### pyright<a id="pyright"></a>

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[es]` in your environment:
  `python -m pip install 'boto3-stubs[es]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `ElasticsearchService` service. No explicit type
annotations required, write your `boto3` code as usual.

## Explicit type annotations<a id="explicit-type-annotations"></a>

### Client annotations<a id="client-annotations"></a>

`ElasticsearchServiceClient` provides annotations for `boto3.client("es")`.

```python
import boto3

from mypy_boto3_es import ElasticsearchServiceClient

client: ElasticsearchServiceClient = boto3.client("es")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: ElasticsearchServiceClient = session.client("es")
```

### Paginators annotations<a id="paginators-annotations"></a>

`mypy_boto3_es.paginator` module contains type annotations for all paginators.

```python
from mypy_boto3_es import ElasticsearchServiceClient
from mypy_boto3_es.paginator import (
    DescribeReservedElasticsearchInstanceOfferingsPaginator,
    DescribeReservedElasticsearchInstancesPaginator,
    GetUpgradeHistoryPaginator,
    ListElasticsearchInstanceTypesPaginator,
    ListElasticsearchVersionsPaginator,
)

client: ElasticsearchServiceClient = boto3.client("es")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
describe_reserved_elasticsearch_instance_offerings_paginator: DescribeReservedElasticsearchInstanceOfferingsPaginator = client.get_paginator("describe_reserved_elasticsearch_instance_offerings")
describe_reserved_elasticsearch_instances_paginator: DescribeReservedElasticsearchInstancesPaginator = client.get_paginator("describe_reserved_elasticsearch_instances")
get_upgrade_history_paginator: GetUpgradeHistoryPaginator = client.get_paginator("get_upgrade_history")
list_elasticsearch_instance_types_paginator: ListElasticsearchInstanceTypesPaginator = client.get_paginator("list_elasticsearch_instance_types")
list_elasticsearch_versions_paginator: ListElasticsearchVersionsPaginator = client.get_paginator("list_elasticsearch_versions")
```

### Literals<a id="literals"></a>

`mypy_boto3_es.literals` module contains literals extracted from shapes that
can be used in user code for type checking.

```python
from mypy_boto3_es.literals import (
    AutoTuneDesiredStateType,
    AutoTuneStateType,
    AutoTuneTypeType,
    DeploymentStatusType,
    DescribePackagesFilterNameType,
    DescribeReservedElasticsearchInstanceOfferingsPaginatorName,
    DescribeReservedElasticsearchInstancesPaginatorName,
    DomainPackageStatusType,
    ESPartitionInstanceTypeType,
    ESWarmPartitionInstanceTypeType,
    GetUpgradeHistoryPaginatorName,
    InboundCrossClusterSearchConnectionStatusCodeType,
    ListElasticsearchInstanceTypesPaginatorName,
    ListElasticsearchVersionsPaginatorName,
    LogTypeType,
    OptionStateType,
    OutboundCrossClusterSearchConnectionStatusCodeType,
    PackageStatusType,
    PackageTypeType,
    ReservedElasticsearchInstancePaymentOptionType,
    RollbackOnDisableType,
    ScheduledAutoTuneActionTypeType,
    ScheduledAutoTuneSeverityTypeType,
    TLSSecurityPolicyType,
    TimeUnitType,
    UpgradeStatusType,
    UpgradeStepType,
    VolumeTypeType,
)

def check_value(value: AutoTuneDesiredStateType) -> bool:
    ...
```

### Typed dictionaries<a id="typed-dictionaries"></a>

`mypy_boto3_es.type_defs` module contains structures and shapes assembled to
typed dictionaries for additional type checking.

```python
from mypy_boto3_es.type_defs import (
    AcceptInboundCrossClusterSearchConnectionResponseTypeDef,
    AccessPoliciesStatusTypeDef,
    AdditionalLimitTypeDef,
    AdvancedOptionsStatusTypeDef,
    AdvancedSecurityOptionsInputTypeDef,
    AdvancedSecurityOptionsStatusTypeDef,
    AdvancedSecurityOptionsTypeDef,
    AssociatePackageResponseTypeDef,
    AutoTuneDetailsTypeDef,
    AutoTuneMaintenanceScheduleTypeDef,
    AutoTuneOptionsInputTypeDef,
    AutoTuneOptionsOutputTypeDef,
    AutoTuneOptionsStatusTypeDef,
    AutoTuneOptionsTypeDef,
    AutoTuneStatusTypeDef,
    AutoTuneTypeDef,
    CancelElasticsearchServiceSoftwareUpdateResponseTypeDef,
    CognitoOptionsStatusTypeDef,
    CognitoOptionsTypeDef,
    ColdStorageOptionsTypeDef,
    CompatibleVersionsMapTypeDef,
    CreateElasticsearchDomainResponseTypeDef,
    CreateOutboundCrossClusterSearchConnectionResponseTypeDef,
    CreatePackageResponseTypeDef,
    DeleteElasticsearchDomainResponseTypeDef,
    DeleteInboundCrossClusterSearchConnectionResponseTypeDef,
    DeleteOutboundCrossClusterSearchConnectionResponseTypeDef,
    DeletePackageResponseTypeDef,
    DescribeDomainAutoTunesResponseTypeDef,
    DescribeElasticsearchDomainConfigResponseTypeDef,
    DescribeElasticsearchDomainResponseTypeDef,
    DescribeElasticsearchDomainsResponseTypeDef,
    DescribeElasticsearchInstanceTypeLimitsResponseTypeDef,
    DescribeInboundCrossClusterSearchConnectionsResponseTypeDef,
    DescribeOutboundCrossClusterSearchConnectionsResponseTypeDef,
    DescribePackagesFilterTypeDef,
    DescribePackagesResponseTypeDef,
    DescribeReservedElasticsearchInstanceOfferingsResponseTypeDef,
    DescribeReservedElasticsearchInstancesResponseTypeDef,
    DissociatePackageResponseTypeDef,
    DomainEndpointOptionsStatusTypeDef,
    DomainEndpointOptionsTypeDef,
    DomainInfoTypeDef,
    DomainInformationTypeDef,
    DomainPackageDetailsTypeDef,
    DurationTypeDef,
    EBSOptionsStatusTypeDef,
    EBSOptionsTypeDef,
    ElasticsearchClusterConfigStatusTypeDef,
    ElasticsearchClusterConfigTypeDef,
    ElasticsearchDomainConfigTypeDef,
    ElasticsearchDomainStatusTypeDef,
    ElasticsearchVersionStatusTypeDef,
    EncryptionAtRestOptionsStatusTypeDef,
    EncryptionAtRestOptionsTypeDef,
    ErrorDetailsTypeDef,
    FilterTypeDef,
    GetCompatibleElasticsearchVersionsResponseTypeDef,
    GetPackageVersionHistoryResponseTypeDef,
    GetUpgradeHistoryResponseTypeDef,
    GetUpgradeStatusResponseTypeDef,
    InboundCrossClusterSearchConnectionStatusTypeDef,
    InboundCrossClusterSearchConnectionTypeDef,
    InstanceCountLimitsTypeDef,
    InstanceLimitsTypeDef,
    LimitsTypeDef,
    ListDomainNamesResponseTypeDef,
    ListDomainsForPackageResponseTypeDef,
    ListElasticsearchInstanceTypesResponseTypeDef,
    ListElasticsearchVersionsResponseTypeDef,
    ListPackagesForDomainResponseTypeDef,
    ListTagsResponseTypeDef,
    LogPublishingOptionTypeDef,
    LogPublishingOptionsStatusTypeDef,
    MasterUserOptionsTypeDef,
    NodeToNodeEncryptionOptionsStatusTypeDef,
    NodeToNodeEncryptionOptionsTypeDef,
    OptionStatusTypeDef,
    OutboundCrossClusterSearchConnectionStatusTypeDef,
    OutboundCrossClusterSearchConnectionTypeDef,
    PackageDetailsTypeDef,
    PackageSourceTypeDef,
    PackageVersionHistoryTypeDef,
    PaginatorConfigTypeDef,
    PurchaseReservedElasticsearchInstanceOfferingResponseTypeDef,
    RecurringChargeTypeDef,
    RejectInboundCrossClusterSearchConnectionResponseTypeDef,
    ReservedElasticsearchInstanceOfferingTypeDef,
    ReservedElasticsearchInstanceTypeDef,
    ResponseMetadataTypeDef,
    SAMLIdpTypeDef,
    SAMLOptionsInputTypeDef,
    SAMLOptionsOutputTypeDef,
    ScheduledAutoTuneDetailsTypeDef,
    ServiceSoftwareOptionsTypeDef,
    SnapshotOptionsStatusTypeDef,
    SnapshotOptionsTypeDef,
    StartElasticsearchServiceSoftwareUpdateResponseTypeDef,
    StorageTypeLimitTypeDef,
    StorageTypeTypeDef,
    TagTypeDef,
    UpdateElasticsearchDomainConfigResponseTypeDef,
    UpdatePackageResponseTypeDef,
    UpgradeElasticsearchDomainResponseTypeDef,
    UpgradeHistoryTypeDef,
    UpgradeStepItemTypeDef,
    VPCDerivedInfoStatusTypeDef,
    VPCDerivedInfoTypeDef,
    VPCOptionsTypeDef,
    ZoneAwarenessConfigTypeDef,
)

def get_structure() -> AcceptInboundCrossClusterSearchConnectionResponseTypeDef:
    return {
      ...
    }
```

## Versioning<a id="versioning"></a>

`mypy-boto3-es` version is the same as related `boto3` version and follows
[PEP 440](https://www.python.org/dev/peps/pep-0440/) format.

## Documentation<a id="documentation"></a>

All type annotations can be found in
[mypy-boto3-es docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_es/)

## Support and contributing<a id="support-and-contributing"></a>

This package is auto-generated. Please reports any bugs or request new features
in [mypy-boto3-builder](https://github.com/vemel/mypy_boto3_builder/issues/)
repository.
