/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json;

import java.lang.constant.Constable;
import kotlin.Metadata;
import kotlin.ULong;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.UStringsKt;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.builtins.BuiltinSerializersKt;
import kotlinx.serialization.descriptors.PrimitiveKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialDescriptorsKt;
import kotlinx.serialization.encoding.Decoder;
import kotlinx.serialization.encoding.Encoder;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonElementSerializersKt;
import kotlinx.serialization.json.JsonLiteral;
import kotlinx.serialization.json.internal.JsonExceptionsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lkotlinx/serialization/json/JsonLiteralSerializer;", "Lkotlinx/serialization/KSerializer;", "Lkotlinx/serialization/json/JsonLiteral;", "()V", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "getDescriptor", "()Lkotlinx/serialization/descriptors/SerialDescriptor;", "deserialize", "decoder", "Lkotlinx/serialization/encoding/Decoder;", "serialize", "", "encoder", "Lkotlinx/serialization/encoding/Encoder;", "value", "kotlinx-serialization-json"})
final class JsonLiteralSerializer
implements KSerializer<JsonLiteral> {
    @NotNull
    public static final JsonLiteralSerializer INSTANCE = new JsonLiteralSerializer();
    @NotNull
    private static final SerialDescriptor descriptor = SerialDescriptorsKt.PrimitiveSerialDescriptor((String)"kotlinx.serialization.json.JsonLiteral", (PrimitiveKind)((PrimitiveKind)PrimitiveKind.STRING.INSTANCE));

    private JsonLiteralSerializer() {
    }

    @NotNull
    public SerialDescriptor getDescriptor() {
        return descriptor;
    }

    public void serialize(@NotNull Encoder encoder2, @NotNull JsonLiteral value) {
        Intrinsics.checkNotNullParameter((Object)encoder2, (String)"encoder");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        JsonElementSerializersKt.access$verify(encoder2);
        if (value.isString()) {
            encoder2.encodeString(value.getContent());
            return;
        }
        Constable constable = JsonElementKt.getLongOrNull(value);
        if (constable != null) {
            Long l = constable;
            boolean bl = false;
            boolean bl2 = false;
            long it = ((Number)l).longValue();
            boolean bl3 = false;
            encoder2.encodeLong(it);
            return;
        }
        constable = UStringsKt.toULongOrNull((String)value.getContent());
        if (constable != null) {
            Long l = constable;
            boolean bl = false;
            boolean bl4 = false;
            long it = l.unbox-impl();
            boolean bl5 = false;
            Encoder encoder3 = encoder2.encodeInline(BuiltinSerializersKt.serializer((ULong.Companion)ULong.Companion).getDescriptor());
            if (encoder3 != null) {
                boolean bl6 = false;
                encoder3.encodeLong(it);
            }
            return;
        }
        constable = JsonElementKt.getDoubleOrNull(value);
        if (constable != null) {
            Number number = constable;
            boolean bl = false;
            boolean bl7 = false;
            double it = ((Number)number).doubleValue();
            boolean bl8 = false;
            encoder2.encodeDouble(it);
            return;
        }
        constable = JsonElementKt.getBooleanOrNull(value);
        if (constable != null) {
            Constable constable2 = constable;
            boolean bl = false;
            boolean bl9 = false;
            boolean it = (Boolean)constable2;
            boolean bl10 = false;
            encoder2.encodeBoolean(it);
            return;
        }
        encoder2.encodeString(value.getContent());
    }

    @NotNull
    public JsonLiteral deserialize(@NotNull Decoder decoder) {
        Intrinsics.checkNotNullParameter((Object)decoder, (String)"decoder");
        JsonElement result = JsonElementSerializersKt.asJsonDecoder(decoder).decodeJsonElement();
        if (!(result instanceof JsonLiteral)) {
            throw JsonExceptionsKt.JsonDecodingException(-1, Intrinsics.stringPlus((String)"Unexpected JSON element, expected JsonLiteral, had ", (Object)Reflection.getOrCreateKotlinClass(result.getClass())), result.toString());
        }
        return (JsonLiteral)result;
    }
}

