/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.json.internal;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.json.JsonArray;
import kotlinx.serialization.json.JsonConfiguration;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonLiteral;
import kotlinx.serialization.json.JsonNull;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonPrimitive;
import kotlinx.serialization.json.internal.JsonLexer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\t\u001a\u00020\nJ\b\u0010\u000b\u001a\u00020\nH\u0002J\b\u0010\f\u001a\u00020\nH\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\bH\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lkotlinx/serialization/json/internal/JsonTreeReader;", "", "configuration", "Lkotlinx/serialization/json/JsonConfiguration;", "lexer", "Lkotlinx/serialization/json/internal/JsonLexer;", "(Lkotlinx/serialization/json/JsonConfiguration;Lkotlinx/serialization/json/internal/JsonLexer;)V", "isLenient", "", "read", "Lkotlinx/serialization/json/JsonElement;", "readArray", "readObject", "readValue", "Lkotlinx/serialization/json/JsonPrimitive;", "isString", "kotlinx-serialization-json"})
public final class JsonTreeReader {
    @NotNull
    private final JsonLexer lexer;
    private final boolean isLenient;

    public JsonTreeReader(@NotNull JsonConfiguration configuration, @NotNull JsonLexer lexer) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)lexer, (String)"lexer");
        this.lexer = lexer;
        this.isLenient = configuration.isLenient();
    }

    private final JsonElement readObject() {
        byte lastToken = this.lexer.consumeNextToken((byte)6);
        if (this.lexer.peekNextToken() == 4) {
            JsonLexer.fail$default(this.lexer, "Unexpected leading comma", 0, 2, null);
            throw new KotlinNothingValueException();
        }
        boolean bl = false;
        LinkedHashMap result = new LinkedHashMap();
        while (this.lexer.canConsumeValue()) {
            String key = this.isLenient ? this.lexer.consumeStringLenient() : this.lexer.consumeString();
            this.lexer.consumeNextToken((byte)5);
            JsonElement element = this.read();
            Map map = result;
            boolean bl2 = false;
            map.put(key, element);
            lastToken = this.lexer.consumeNextToken();
            if (lastToken == 4 || lastToken == 7) continue;
            JsonLexer.fail$default(this.lexer, "Expected end of the object or comma", 0, 2, null);
            throw new KotlinNothingValueException();
        }
        if (lastToken == 6) {
            this.lexer.consumeNextToken((byte)7);
        } else if (lastToken == 4) {
            JsonLexer.fail$default(this.lexer, "Unexpected trailing comma", 0, 2, null);
            throw new KotlinNothingValueException();
        }
        return new JsonObject(result);
    }

    /*
     * WARNING - void declaration
     */
    private final JsonElement readArray() {
        byte lastToken = this.lexer.consumeNextToken();
        if (this.lexer.peekNextToken() == 4) {
            JsonLexer.fail$default(this.lexer, "Unexpected leading comma", 0, 2, null);
            throw new KotlinNothingValueException();
        }
        boolean bl = false;
        ArrayList<JsonElement> result = new ArrayList<JsonElement>();
        while (this.lexer.canConsumeValue()) {
            void this_$iv;
            JsonElement element = this.read();
            result.add(element);
            lastToken = this.lexer.consumeNextToken();
            if (lastToken == 4) continue;
            JsonLexer jsonLexer = this.lexer;
            boolean condition$iv = lastToken == 9;
            int position$iv = this_$iv.currentPosition;
            boolean $i$f$require$kotlinx_serialization_json = false;
            if (condition$iv) continue;
            void var9_9 = this_$iv;
            boolean bl2 = false;
            String string = "Expected end of the array or comma";
            var9_9.fail(string, position$iv);
            throw new KotlinNothingValueException();
        }
        if (lastToken == 8) {
            this.lexer.consumeNextToken((byte)9);
        } else if (lastToken == 4) {
            JsonLexer.fail$default(this.lexer, "Unexpected trailing comma", 0, 2, null);
            throw new KotlinNothingValueException();
        }
        return new JsonArray((List<? extends JsonElement>)result);
    }

    private final JsonPrimitive readValue(boolean isString) {
        String string;
        String string2 = string = this.isLenient || !isString ? this.lexer.consumeStringLenient() : this.lexer.consumeString();
        if (!isString && Intrinsics.areEqual((Object)string, (Object)"null")) {
            return JsonNull.INSTANCE;
        }
        return new JsonLiteral(string, isString);
    }

    @NotNull
    public final JsonElement read() {
        JsonElement jsonElement;
        byte by = this.lexer.peekNextToken();
        if (by == 1) {
            jsonElement = this.readValue(true);
        } else if (by == 0) {
            jsonElement = this.readValue(false);
        } else if (by == 6) {
            jsonElement = this.readObject();
        } else if (by == 8) {
            jsonElement = this.readArray();
        } else {
            JsonLexer.fail$default(this.lexer, "Can't begin reading element, unexpected token", 0, 2, null);
            throw new KotlinNothingValueException();
        }
        return jsonElement;
    }
}

