/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.projector.server.core.ij.log;

import java.lang.reflect.Method;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.projector.util.logging.Logger;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u0015H\u0016J \u0010\u0016\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u0015H\u0016J \u0010\u0017\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u0015H\u0016R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \t*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000e\u001a\u0012\u0012\u0002\b\u0003 \t*\b\u0012\u0002\b\u0003\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/projector/server/core/ij/log/IjJvmLogger;", "Lorg/jetbrains/projector/util/logging/Logger;", "ideaClassLoader", "Ljava/lang/ClassLoader;", "tag", "", "(Ljava/lang/ClassLoader;Ljava/lang/String;)V", "debugMethod", "Ljava/lang/reflect/Method;", "kotlin.jvm.PlatformType", "errorMethod", "infoMethod", "logger", "", "loggerClass", "Ljava/lang/Class;", "debug", "", "t", "", "lazyMessage", "Lkotlin/Function0;", "error", "info", "projector-server-core"})
public final class IjJvmLogger
implements Logger {
    private final Class<?> loggerClass;
    private final Object logger;
    private final Method errorMethod;
    private final Method infoMethod;
    private final Method debugMethod;

    public IjJvmLogger(@NotNull ClassLoader ideaClassLoader, @NotNull String tag) {
        Intrinsics.checkNotNullParameter((Object)ideaClassLoader, (String)"ideaClassLoader");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        this.loggerClass = Class.forName("com.intellij.openapi.diagnostic.Logger", false, ideaClassLoader);
        Object[] objectArray = new Class[]{String.class};
        Method method = this.loggerClass.getDeclaredMethod("getInstance", (Class<?>[])objectArray);
        objectArray = new Object[]{tag};
        this.logger = method.invoke(null, objectArray);
        objectArray = new Class[]{String.class, Throwable.class};
        this.errorMethod = this.loggerClass.getDeclaredMethod("error", (Class<?>[])objectArray);
        objectArray = new Class[]{String.class, Throwable.class};
        this.infoMethod = this.loggerClass.getDeclaredMethod("info", (Class<?>[])objectArray);
        objectArray = new Class[]{String.class, Throwable.class};
        this.debugMethod = this.loggerClass.getDeclaredMethod("debug", (Class<?>[])objectArray);
    }

    public void error(@Nullable Throwable t, @NotNull Function0<String> lazyMessage) {
        Intrinsics.checkNotNullParameter(lazyMessage, (String)"lazyMessage");
        Object[] objectArray = new Object[]{lazyMessage.invoke(), t};
        this.errorMethod.invoke(this.logger, objectArray);
    }

    public void info(@Nullable Throwable t, @NotNull Function0<String> lazyMessage) {
        Intrinsics.checkNotNullParameter(lazyMessage, (String)"lazyMessage");
        Object[] objectArray = new Object[]{lazyMessage.invoke(), t};
        this.infoMethod.invoke(this.logger, objectArray);
    }

    public void debug(@Nullable Throwable t, @NotNull Function0<String> lazyMessage) {
        Intrinsics.checkNotNullParameter(lazyMessage, (String)"lazyMessage");
        Object[] objectArray = new Object[]{lazyMessage.invoke(), t};
        this.debugMethod.invoke(this.logger, objectArray);
    }
}

