/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.projector.server.core.websocket;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference0Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty0;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.java_websocket.WebSocket;
import org.java_websocket.WebSocketImpl;
import org.java_websocket.WebSocketServerFactory;
import org.java_websocket.drafts.Draft;
import org.java_websocket.drafts.Draft_6455;
import org.java_websocket.enums.CloseHandshakeType;
import org.java_websocket.enums.HandshakeState;
import org.java_websocket.framing.Framedata;
import org.java_websocket.handshake.ClientHandshake;
import org.java_websocket.handshake.ClientHandshakeBuilder;
import org.java_websocket.handshake.HandshakeBuilder;
import org.java_websocket.handshake.Handshakedata;
import org.java_websocket.handshake.ServerHandshake;
import org.java_websocket.handshake.ServerHandshakeBuilder;
import org.java_websocket.server.WebSocketServer;
import org.java_websocket.util.Charsetfunctions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.projector.common.protocol.toClient.MainWindow;
import org.jetbrains.projector.common.protocol.toClient.MainWindowsEndpointKt;
import org.jetbrains.projector.server.core.ClientWrapper;
import org.jetbrains.projector.server.core.util.HostAddressKt;
import org.jetbrains.projector.server.core.websocket.GetRequestResult;
import org.jetbrains.projector.server.core.websocket.HttpWsServer;
import org.jetbrains.projector.server.core.websocket.HttpWsServerKt;
import org.jetbrains.projector.server.core.websocket.HttpWsTransport;
import org.jetbrains.projector.util.logging.Logger;
import org.jetbrains.projector.util.logging.LoggerKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000_\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006*\u0001\u000f\b&\u0018\u0000 &2\u00020\u0001:\u0002&'B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0015\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J+\u0010\u0011\u001a\u00020\u00122!\u0010\u0013\u001a\u001d\u0012\u0013\u0012\u00110\u0015\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\u0018\u0012\u0004\u0012\u00020\u00120\u0014H\u0016J\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH&J\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fJ\u000e\u0010 \u001a\u00020\u00122\u0006\u0010!\u001a\u00020\"J\b\u0010#\u001a\u00020\u0012H\u0016J\u0010\u0010$\u001a\u00020\u00122\u0006\u0010%\u001a\u00020\u0003H\u0016R\u001b\u0010\b\u001a\u00020\t8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u0010\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010\u00a8\u0006("}, d2={"Lorg/jetbrains/projector/server/core/websocket/HttpWsServer;", "Lorg/jetbrains/projector/server/core/websocket/HttpWsTransport;", "port", "", "(I)V", "host", "Ljava/net/InetAddress;", "(Ljava/net/InetAddress;I)V", "wasStarted", "", "getWasStarted", "()Z", "wasStarted$delegate", "Lkotlin/reflect/KProperty0;", "webSocketServer", "org/jetbrains/projector/server/core/websocket/HttpWsServer$webSocketServer$1", "Lorg/jetbrains/projector/server/core/websocket/HttpWsServer$webSocketServer$1;", "forEachOpenedConnection", "", "action", "Lkotlin/Function1;", "Lorg/jetbrains/projector/server/core/ClientWrapper;", "Lkotlin/ParameterName;", "name", "client", "getMainWindows", "", "Lorg/jetbrains/projector/common/protocol/toClient/MainWindow;", "onGetRequest", "Lorg/jetbrains/projector/server/core/websocket/GetRequestResult;", "path", "", "setWebSocketFactory", "factory", "Lorg/java_websocket/WebSocketServerFactory;", "start", "stop", "timeoutMs", "Companion", "HttpDraft", "projector-server-core"})
public abstract class HttpWsServer
implements HttpWsTransport {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final webSocketServer.1 webSocketServer;
    @NotNull
    private final KProperty0 wasStarted$delegate;
    @Deprecated
    @NotNull
    private static final Logger logger;
    @Deprecated
    @NotNull
    private static final String PATH_FIELD = "X-My-Path";
    @Deprecated
    @NotNull
    private static final Companion.HTTP_CONNECTION_ATTACHMENT.1 HTTP_CONNECTION_ATTACHMENT;

    public HttpWsServer(@NotNull InetAddress host, int port) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        InetSocketAddress inetSocketAddress = new InetSocketAddress(host, port);
        Object[] objectArray = new Draft[]{new HttpDraft(), (Draft)new Draft_6455()};
        List list = CollectionsKt.listOf((Object[])objectArray);
        this.webSocketServer = new WebSocketServer(this, host, port, inetSocketAddress, list){
            @Nullable
            private volatile Boolean wasInitialized;
            @NotNull
            private final ReentrantLock lock;
            private final Condition condition;
            final /* synthetic */ HttpWsServer this$0;
            final /* synthetic */ InetAddress $host;
            final /* synthetic */ int $port;
            {
                this.this$0 = $receiver;
                this.$host = $host;
                this.$port = $port;
                super($super_call_param$1, $super_call_param$2);
                this.lock = new ReentrantLock();
                this.condition = this.lock.newCondition();
                this.setReuseAddr(true);
                this.setTcpNoDelay(true);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final boolean getWasStarted() {
                while (this.wasInitialized == null) {
                    Lock lock = this.lock;
                    boolean bl = false;
                    boolean bl2 = false;
                    lock.lock();
                    try {
                        boolean bl3 = false;
                        if (this.wasInitialized != null) {
                            Boolean bl4 = this.wasInitialized;
                            Intrinsics.checkNotNull((Object)bl4);
                            boolean bl5 = bl4;
                            return bl5;
                        }
                        this.condition.await();
                        Unit unit = Unit.INSTANCE;
                    }
                    finally {
                        lock.unlock();
                    }
                }
                Boolean bl = this.wasInitialized;
                Intrinsics.checkNotNull((Object)bl);
                return bl;
            }

            public void onOpen(@NotNull WebSocket conn, @NotNull ClientHandshake handshake) {
                Intrinsics.checkNotNullParameter((Object)conn, (String)"conn");
                Intrinsics.checkNotNullParameter((Object)handshake, (String)"handshake");
                boolean bl = HttpWsServerKt.access$isHttp(handshake);
                if (bl) {
                    conn.setAttachment((Object)HttpWsServer.access$getHTTP_CONNECTION_ATTACHMENT$cp());
                    conn.close();
                } else if (!bl) {
                    this.this$0.onWsOpen(conn);
                }
            }

            public void onClose(@NotNull WebSocket conn, int code, @NotNull String reason, boolean remote) {
                Intrinsics.checkNotNullParameter((Object)conn, (String)"conn");
                Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
                Companion companion = HttpWsServer.access$getCompanion$p();
                HttpWsServer httpWsServer = this.this$0;
                boolean $i$f$onlyForWs = false;
                if (conn.getAttachment() != HttpWsServer.access$getHTTP_CONNECTION_ATTACHMENT$cp()) {
                    boolean bl = false;
                    httpWsServer.onWsClose(conn);
                }
            }

            public void onMessage(@NotNull WebSocket conn, @NotNull String message2) {
                Intrinsics.checkNotNullParameter((Object)conn, (String)"conn");
                Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
                Companion companion = HttpWsServer.access$getCompanion$p();
                HttpWsServer httpWsServer = this.this$0;
                boolean $i$f$onlyForWs = false;
                if (conn.getAttachment() != HttpWsServer.access$getHTTP_CONNECTION_ATTACHMENT$cp()) {
                    boolean bl = false;
                    httpWsServer.onWsMessage(conn, message2);
                }
            }

            public void onMessage(@NotNull WebSocket conn, @NotNull ByteBuffer message2) {
                Intrinsics.checkNotNullParameter((Object)conn, (String)"conn");
                Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
                this.this$0.onWsMessage(conn, message2);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onError(@Nullable WebSocket conn, @NotNull Exception ex) {
                Intrinsics.checkNotNullParameter((Object)ex, (String)"ex");
                this.this$0.onError(conn, ex);
                if (ex instanceof SocketException) {
                    Lock lock = this.lock;
                    boolean bl = false;
                    boolean bl2 = false;
                    lock.lock();
                    try {
                        boolean bl3 = false;
                        this.wasInitialized = false;
                        this.condition.signal();
                        Unit unit = Unit.INSTANCE;
                    }
                    finally {
                        lock.unlock();
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onStart() {
                Logger.DefaultImpls.info$default((Logger)HttpWsServer.access$getLogger$cp(), null, (Function0)((Function0)new Function0<String>(this.$host, this.$port){
                    final /* synthetic */ InetAddress $host;
                    final /* synthetic */ int $port;
                    {
                        this.$host = $host;
                        this.$port = $port;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "Server started on host " + this.$host + " and port " + this.$port;
                    }
                }), (int)1, null);
                Lock lock = this.lock;
                boolean bl = false;
                boolean bl2 = false;
                lock.lock();
                try {
                    boolean bl3 = false;
                    this.wasInitialized = true;
                    this.condition.signal();
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    lock.unlock();
                }
            }
        };
        this.wasStarted$delegate = (KProperty0)new PropertyReference0Impl((Object)this.webSocketServer){

            @Nullable
            public Object get() {
                return ((Object)this.receiver).getWasStarted();
            }
        };
    }

    public HttpWsServer(int port) {
        this(HostAddressKt.getWildcardHostAddress(), port);
    }

    @NotNull
    public abstract List<MainWindow> getMainWindows();

    @NotNull
    public final GetRequestResult onGetRequest(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        String pathWithoutParams = StringsKt.substringBefore$default((String)StringsKt.substringBefore$default((String)path, (char)'?', null, (int)2, null), (char)'#', null, (int)2, null);
        if (Intrinsics.areEqual((Object)pathWithoutParams, (Object)"/mainWindows")) {
            List<MainWindow> mainWindows = this.getMainWindows();
            String string = MainWindowsEndpointKt.toJson(mainWindows);
            Charset charset = Charsets.UTF_8;
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            byte[] byArray = string2.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            byte[] json = byArray;
            return new GetRequestResult(200, "OK", "text/json", json);
        }
        String resourceFileName = Companion.getResourceName(pathWithoutParams);
        byte[] resourceBytes = Companion.getResource(resourceFileName);
        if (resourceBytes != null) {
            return new GetRequestResult(200, "OK", HttpWsServer.Companion.calculateContentType(resourceFileName), resourceBytes);
        }
        String string = "<h1>404 Not found requested path: " + path + "</h1>";
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        String string3 = string;
        if (string3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string3.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        return new GetRequestResult(404, "Not found", "text/html", byArray);
    }

    @Override
    public boolean getWasStarted() {
        KProperty0 kProperty0 = this.wasStarted$delegate;
        boolean bl = false;
        return (Boolean)kProperty0.get();
    }

    @Override
    public void start() {
        this.webSocketServer.start();
    }

    @Override
    public void stop(int timeoutMs) {
        this.webSocketServer.stop(timeoutMs);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void forEachOpenedConnection(@NotNull Function1<? super ClientWrapper, Unit> action) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(action, (String)"action");
        Collection collection = this.webSocketServer.getConnections();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"webSocketServer.connections");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            WebSocket p0 = (WebSocket)element$iv$iv;
            boolean bl = false;
            if (!p0.isOpen()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            WebSocket it = (WebSocket)element$iv;
            boolean bl = false;
            ClientWrapper clientWrapper = (ClientWrapper)it.getAttachment();
            if (clientWrapper == null) {
                return;
            }
            ClientWrapper wrapper = clientWrapper;
            action.invoke((Object)wrapper);
        }
    }

    public final void setWebSocketFactory(@NotNull WebSocketServerFactory factory) {
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        this.webSocketServer.setWebSocketFactory(factory);
    }

    @Override
    public int getClientCount() {
        return HttpWsTransport.DefaultImpls.getClientCount(this);
    }

    public static final /* synthetic */ Logger access$getLogger$cp() {
        return logger;
    }

    static {
        boolean $i$f$Logger = false;
        String string = Reflection.getOrCreateKotlinClass(HttpWsServer.class).getSimpleName();
        Intrinsics.checkNotNull((Object)string);
        logger = LoggerKt.Logger((String)string);
        HTTP_CONNECTION_ATTACHMENT = new Object(){};
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006H\u0016J\b\u0010\f\u001a\u00020\u0001H\u0016J\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u001e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00120\u00182\u0006\u0010\u000b\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0014H\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u001eH\u0016J\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020!H\u0016J\u0018\u0010\"\u001a\u00020\u00042\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u000fH\u0016J\b\u0010&\u001a\u00020'H\u0016J\u0010\u0010(\u001a\u00020\u00042\u0006\u0010)\u001a\u00020\u0012H\u0016\u00a8\u0006*"}, d2={"Lorg/jetbrains/projector/server/core/websocket/HttpWsServer$HttpDraft;", "Lorg/java_websocket/drafts/Draft;", "(Lorg/jetbrains/projector/server/core/websocket/HttpWsServer;)V", "acceptHandshakeAsClient", "", "request", "Lorg/java_websocket/handshake/ClientHandshake;", "response", "Lorg/java_websocket/handshake/ServerHandshake;", "acceptHandshakeAsServer", "Lorg/java_websocket/enums/HandshakeState;", "handshakedata", "copyInstance", "createBinaryFrame", "framedata", "Lorg/java_websocket/framing/Framedata;", "createFrames", "binary", "Ljava/nio/ByteBuffer;", "mask", "", "text", "", "createHandshake", "", "Lorg/java_websocket/handshake/Handshakedata;", "withcontent", "getCloseHandshakeType", "Lorg/java_websocket/enums/CloseHandshakeType;", "postProcessHandshakeRequestAsClient", "Lorg/java_websocket/handshake/ClientHandshakeBuilder;", "postProcessHandshakeResponseAsServer", "Lorg/java_websocket/handshake/HandshakeBuilder;", "Lorg/java_websocket/handshake/ServerHandshakeBuilder;", "processFrame", "webSocketImpl", "Lorg/java_websocket/WebSocketImpl;", "frame", "reset", "", "translateFrame", "buffer", "projector-server-core"})
    private final class HttpDraft
    extends Draft {
        public HttpDraft() {
            Intrinsics.checkNotNullParameter((Object)HttpWsServer.this, (String)"this$0");
        }

        @NotNull
        public HandshakeState acceptHandshakeAsServer(@NotNull ClientHandshake handshakedata) {
            HandshakeState handshakeState;
            Intrinsics.checkNotNullParameter((Object)handshakedata, (String)"handshakedata");
            boolean bl = HttpWsServerKt.access$isHttp(handshakedata);
            if (bl) {
                handshakeState = HandshakeState.MATCHED;
            } else if (!bl) {
                handshakeState = HandshakeState.NOT_MATCHED;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return handshakeState;
        }

        @NotNull
        public HandshakeBuilder postProcessHandshakeResponseAsServer(@NotNull ClientHandshake request, @NotNull ServerHandshakeBuilder response) {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            Intrinsics.checkNotNullParameter((Object)response, (String)"response");
            response.put(HttpWsServer.PATH_FIELD, request.getResourceDescriptor());
            return (HandshakeBuilder)response;
        }

        @NotNull
        public List<ByteBuffer> createHandshake(@NotNull Handshakedata handshakedata, boolean withcontent) {
            Intrinsics.checkNotNullParameter((Object)handshakedata, (String)"handshakedata");
            String string = handshakedata.getFieldValue(HttpWsServer.PATH_FIELD);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"handshakedata.getFieldValue(PATH_FIELD)");
            GetRequestResult result = HttpWsServer.this.onGetRequest(string);
            byte[] header = Charsetfunctions.asciiBytes((String)("HTTP/1.0 " + result.getStatusCode() + " " + result.getStatusText() + "\r\nMime-Version: 1.0\r\nContent-Type: " + result.getContentType() + "\r\nContent-Length: " + result.getContent().length + "\r\nConnection: close\r\n\r\n"));
            ByteBuffer bytebuffer = ByteBuffer.allocate(result.getContent().length + header.length);
            bytebuffer.put(header);
            bytebuffer.put(result.getContent());
            bytebuffer.flip();
            return CollectionsKt.listOf((Object)bytebuffer);
        }

        @NotNull
        public CloseHandshakeType getCloseHandshakeType() {
            return CloseHandshakeType.NONE;
        }

        @NotNull
        public Draft copyInstance() {
            return this;
        }

        public void reset() {
        }

        @NotNull
        public Void translateFrame(@NotNull ByteBuffer buffer) {
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            Companion.failNoFrames();
            throw new KotlinNothingValueException();
        }

        @NotNull
        public Void processFrame(@NotNull WebSocketImpl webSocketImpl, @NotNull Framedata frame) {
            Intrinsics.checkNotNullParameter((Object)webSocketImpl, (String)"webSocketImpl");
            Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
            Companion.failNoFrames();
            throw new KotlinNothingValueException();
        }

        @NotNull
        public Void createBinaryFrame(@NotNull Framedata framedata) {
            Intrinsics.checkNotNullParameter((Object)framedata, (String)"framedata");
            Companion.failNoFrames();
            throw new KotlinNothingValueException();
        }

        @NotNull
        public Void createFrames(@NotNull ByteBuffer binary, boolean mask) {
            Intrinsics.checkNotNullParameter((Object)binary, (String)"binary");
            Companion.failNoFrames();
            throw new KotlinNothingValueException();
        }

        @NotNull
        public Void createFrames(@NotNull String text, boolean mask) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Companion.failNoFrames();
            throw new KotlinNothingValueException();
        }

        @NotNull
        public Void postProcessHandshakeRequestAsClient(@NotNull ClientHandshakeBuilder request) {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            Companion.failNoClient();
            throw new KotlinNothingValueException();
        }

        @NotNull
        public Void acceptHandshakeAsClient(@NotNull ClientHandshake request, @NotNull ServerHandshake response) {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            Intrinsics.checkNotNullParameter((Object)response, (String)"response");
            Companion.failNoClient();
            throw new KotlinNothingValueException();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000C\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002*\u0001\u0004\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\n\u001a\u00020\u000bH\u0002J\b\u0010\f\u001a\u00020\u000bH\u0002J\u0010\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0007J\u000e\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0007J\u001f\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00130\u0017H\u0082\bJ\f\u0010\u0018\u001a\u00020\u0007*\u00020\u0007H\u0002R\u0010\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0005R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/projector/server/core/websocket/HttpWsServer$Companion;", "", "()V", "HTTP_CONNECTION_ATTACHMENT", "org/jetbrains/projector/server/core/websocket/HttpWsServer$Companion$HTTP_CONNECTION_ATTACHMENT$1", "Lorg/jetbrains/projector/server/core/websocket/HttpWsServer$Companion$HTTP_CONNECTION_ATTACHMENT$1;", "PATH_FIELD", "", "logger", "Lorg/jetbrains/projector/util/logging/Logger;", "failNoClient", "", "failNoFrames", "getResource", "", "resourceFileName", "getResourceName", "pathWithoutParams", "onlyForWs", "", "connection", "Lorg/java_websocket/WebSocket;", "block", "Lkotlin/Function0;", "calculateContentType", "projector-server-core"})
    private static final class Companion {
        private Companion() {
        }

        private final Void failNoFrames() {
            throw new UnsupportedOperationException("This draft doesn't work with frames");
        }

        private final Void failNoClient() {
            throw new UnsupportedOperationException("This draft can't be used on a client");
        }

        private final void onlyForWs(WebSocket connection, Function0<Unit> block) {
            boolean $i$f$onlyForWs = false;
            if (connection.getAttachment() != HTTP_CONNECTION_ATTACHMENT) {
                block.invoke();
            }
        }

        private final String calculateContentType(String $this$calculateContentType) {
            String string;
            String string2 = StringsKt.substringAfterLast$default((String)$this$calculateContentType, (char)'.', null, (int)2, null);
            boolean bl = false;
            String string3 = string2;
            if (string3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.Strin\u2026.toLowerCase(Locale.ROOT)");
            switch (string4) {
                case "css": {
                    string = "text/css";
                    break;
                }
                case "html": {
                    string = "text/html";
                    break;
                }
                case "js": {
                    string = "text/javascript";
                    break;
                }
                case "png": {
                    string = "image/png";
                    break;
                }
                case "svg": {
                    string = "image/svg+xml";
                    break;
                }
                case "webmanifest": {
                    string = "application/manifest+json";
                    break;
                }
                default: {
                    string = "application/octet-stream";
                }
            }
            return string;
        }

        @NotNull
        public final String getResourceName(@NotNull String pathWithoutParams) {
            String string;
            String string2;
            String string3;
            Intrinsics.checkNotNullParameter((Object)pathWithoutParams, (String)"pathWithoutParams");
            String string4 = pathWithoutParams;
            boolean bl = false;
            boolean bl2 = false;
            String it = string4;
            boolean bl3 = false;
            boolean bl4 = StringsKt.startsWith$default((String)it, (String)"/projector/", (boolean)false, (int)2, null);
            if (bl4) {
                string3 = StringsKt.removePrefix((String)it, (CharSequence)"/projector");
            } else if (!bl4) {
                string3 = it;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            string4 = string3;
            bl = false;
            bl2 = false;
            it = string4;
            boolean bl5 = false;
            bl4 = StringsKt.startsWith$default((String)it, (String)"/projector-client/", (boolean)false, (int)2, null);
            if (bl4) {
                string2 = StringsKt.removePrefix((String)it, (CharSequence)"/projector-client");
            } else if (!bl4) {
                string2 = it;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            string4 = string2;
            bl = false;
            bl2 = false;
            it = string4;
            boolean bl6 = false;
            bl4 = Intrinsics.areEqual((Object)it, (Object)"/");
            if (bl4) {
                string = "/index.html";
            } else if (!bl4) {
                string = it;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return string;
        }

        @Nullable
        public final byte[] getResource(@NotNull String resourceFileName) {
            Intrinsics.checkNotNullParameter((Object)resourceFileName, (String)"resourceFileName");
            URL uRL = this.getClass().getResource("/projector-client-web-distribution" + resourceFileName);
            return uRL == null ? null : TextStreamsKt.readBytes((URL)uRL);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

