/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.projector.server.core.websocket;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.java_websocket.WebSocket;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.projector.server.core.ClientEventHandler;
import org.jetbrains.projector.server.core.ClientWrapper;
import org.jetbrains.projector.server.core.websocket.HttpWsServerBuilder;
import org.jetbrains.projector.server.core.websocket.HttpWsTransport;
import org.jetbrains.projector.server.core.websocket.WsClientWrapper;
import org.jetbrains.projector.server.core.websocket.WsTransportBuilder;
import org.jetbrains.projector.util.logging.Logger;
import org.jetbrains.projector.util.logging.LoggerKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 '2\u00020\u0001:\u0001'B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\"\u001a\u00020\u00002\u0006\u0010#\u001a\u00020$J\b\u0010%\u001a\u00020&H&R2\u0010\u0003\u001a\u001a\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\b\u0012\u00060\u0006j\u0002`\u0007\u0012\u0004\u0012\u00020\b0\u0004X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR5\u0010\r\u001a\u001d\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u00020\b0\u000eX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015RJ\u0010\u0016\u001a2\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0011\u0012\u0013\u0012\u00110\u0017\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0018\u0012\u0004\u0012\u00020\b0\u0004X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\n\"\u0004\b\u001a\u0010\fRJ\u0010\u001b\u001a2\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0011\u0012\u0013\u0012\u00110\u001c\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0018\u0012\u0004\u0012\u00020\b0\u0004X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\n\"\u0004\b\u001e\u0010\fR5\u0010\u001f\u001a\u001d\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\u000f\u0012\b\b\u0010\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u00020\b0\u000eX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u0013\"\u0004\b!\u0010\u0015\u00a8\u0006("}, d2={"Lorg/jetbrains/projector/server/core/websocket/WsTransportBuilder;", "", "()V", "onError", "Lkotlin/Function2;", "Lorg/java_websocket/WebSocket;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "", "getOnError", "()Lkotlin/jvm/functions/Function2;", "setOnError", "(Lkotlin/jvm/functions/Function2;)V", "onWsClose", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "connection", "getOnWsClose", "()Lkotlin/jvm/functions/Function1;", "setOnWsClose", "(Lkotlin/jvm/functions/Function1;)V", "onWsMessageByteBuffer", "Ljava/nio/ByteBuffer;", "message", "getOnWsMessageByteBuffer", "setOnWsMessageByteBuffer", "onWsMessageString", "", "getOnWsMessageString", "setOnWsMessageString", "onWsOpen", "getOnWsOpen", "setOnWsOpen", "attachDefaultServerEventHandlers", "clientEventHandler", "Lorg/jetbrains/projector/server/core/ClientEventHandler;", "build", "Lorg/jetbrains/projector/server/core/websocket/HttpWsTransport;", "Companion", "projector-server-core"})
public abstract class WsTransportBuilder {
    @NotNull
    private static final Companion Companion = new Companion(null);
    public Function2<? super WebSocket, ? super Exception, Unit> onError;
    public Function1<? super WebSocket, Unit> onWsOpen;
    public Function1<? super WebSocket, Unit> onWsClose;
    public Function2<? super WebSocket, ? super String, Unit> onWsMessageString;
    public Function2<? super WebSocket, ? super ByteBuffer, Unit> onWsMessageByteBuffer;
    @Deprecated
    @NotNull
    private static final Logger logger;

    @NotNull
    public final Function2<WebSocket, Exception, Unit> getOnError() {
        Function2<? super WebSocket, ? super Exception, Unit> function2 = this.onError;
        if (function2 != null) {
            return function2;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"onError");
        throw null;
    }

    public final void setOnError(@NotNull Function2<? super WebSocket, ? super Exception, Unit> function2) {
        Intrinsics.checkNotNullParameter(function2, (String)"<set-?>");
        this.onError = function2;
    }

    @NotNull
    public final Function1<WebSocket, Unit> getOnWsOpen() {
        Function1<? super WebSocket, Unit> function1 = this.onWsOpen;
        if (function1 != null) {
            return function1;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"onWsOpen");
        throw null;
    }

    public final void setOnWsOpen(@NotNull Function1<? super WebSocket, Unit> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"<set-?>");
        this.onWsOpen = function1;
    }

    @NotNull
    public final Function1<WebSocket, Unit> getOnWsClose() {
        Function1<? super WebSocket, Unit> function1 = this.onWsClose;
        if (function1 != null) {
            return function1;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"onWsClose");
        throw null;
    }

    public final void setOnWsClose(@NotNull Function1<? super WebSocket, Unit> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"<set-?>");
        this.onWsClose = function1;
    }

    @NotNull
    public final Function2<WebSocket, String, Unit> getOnWsMessageString() {
        Function2<? super WebSocket, ? super String, Unit> function2 = this.onWsMessageString;
        if (function2 != null) {
            return function2;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"onWsMessageString");
        throw null;
    }

    public final void setOnWsMessageString(@NotNull Function2<? super WebSocket, ? super String, Unit> function2) {
        Intrinsics.checkNotNullParameter(function2, (String)"<set-?>");
        this.onWsMessageString = function2;
    }

    @NotNull
    public final Function2<WebSocket, ByteBuffer, Unit> getOnWsMessageByteBuffer() {
        Function2<? super WebSocket, ? super ByteBuffer, Unit> function2 = this.onWsMessageByteBuffer;
        if (function2 != null) {
            return function2;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"onWsMessageByteBuffer");
        throw null;
    }

    public final void setOnWsMessageByteBuffer(@NotNull Function2<? super WebSocket, ? super ByteBuffer, Unit> function2) {
        Intrinsics.checkNotNullParameter(function2, (String)"<set-?>");
        this.onWsMessageByteBuffer = function2;
    }

    @NotNull
    public abstract HttpWsTransport build();

    @NotNull
    public final WsTransportBuilder attachDefaultServerEventHandlers(@NotNull ClientEventHandler clientEventHandler) {
        Intrinsics.checkNotNullParameter((Object)clientEventHandler, (String)"clientEventHandler");
        this.setOnWsMessageByteBuffer((Function2<? super WebSocket, ? super ByteBuffer, Unit>)((Function2)attachDefaultServerEventHandlers.1.INSTANCE));
        this.setOnWsMessageString((Function2<? super WebSocket, ? super String, Unit>)((Function2)new Function2<WebSocket, String, Unit>(clientEventHandler){
            final /* synthetic */ ClientEventHandler $clientEventHandler;
            {
                this.$clientEventHandler = $clientEventHandler;
                super(2);
            }

            public final void invoke(@NotNull WebSocket connection, @NotNull String message2) {
                Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
                Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
                Object object = connection.getAttachment();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"connection.getAttachment()");
                this.$clientEventHandler.handleMessage((ClientWrapper)object, message2);
            }
        }));
        this.setOnWsClose((Function1<? super WebSocket, Unit>)((Function1)new Function1<WebSocket, Unit>(clientEventHandler){
            final /* synthetic */ ClientEventHandler $clientEventHandler;
            {
                this.$clientEventHandler = $clientEventHandler;
                super(1);
            }

            public final void invoke(@NotNull WebSocket connection) {
                Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
                this.$clientEventHandler.updateClientsCount();
                ClientWrapper wrapper = (ClientWrapper)connection.getAttachment();
                if (wrapper != null) {
                    this.$clientEventHandler.onClientConnectionEnded(wrapper);
                } else {
                    Logger.DefaultImpls.info$default((Logger)WsTransportBuilder.access$getLogger$cp(), null, (Function0)((Function0)new Function0<String>(connection){
                        final /* synthetic */ WebSocket $connection;
                        {
                            this.$connection = $connection;
                            super(0);
                        }

                        @NotNull
                        public final String invoke() {
                            InetAddress inetAddress;
                            InetSocketAddress inetSocketAddress = this.$connection.getRemoteSocketAddress();
                            String address = inetSocketAddress == null ? null : ((inetAddress = inetSocketAddress.getAddress()) == null ? null : inetAddress.getHostAddress());
                            return "Client from address " + address + " is disconnected. This client hasn't clientSettings. This usually happens when the handshake stage didn't have time to be performed (so it seems the client has been connected for a very short time)";
                        }
                    }), (int)1, null);
                }
            }
        }));
        this.setOnWsOpen((Function1<? super WebSocket, Unit>)((Function1)new Function1<WebSocket, Unit>(clientEventHandler){
            final /* synthetic */ ClientEventHandler $clientEventHandler;
            {
                this.$clientEventHandler = $clientEventHandler;
                super(1);
            }

            public final void invoke(@NotNull WebSocket connection) {
                InetAddress inetAddress;
                Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
                InetSocketAddress inetSocketAddress = connection.getRemoteSocketAddress();
                String address = inetSocketAddress == null ? null : ((inetAddress = inetSocketAddress.getAddress()) == null ? null : inetAddress.getHostAddress());
                WsClientWrapper wrapper = new WsClientWrapper(connection, this.$clientEventHandler.getInitialClientState(address));
                connection.setAttachment((Object)wrapper);
                Logger.DefaultImpls.info$default((Logger)WsTransportBuilder.access$getLogger$cp(), null, (Function0)((Function0)new Function0<String>(address){
                    final /* synthetic */ String $address;
                    {
                        this.$address = $address;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return this.$address + " connected.";
                    }
                }), (int)1, null);
                this.$clientEventHandler.onClientConnected(wrapper);
            }
        }));
        this.setOnError((Function2<? super WebSocket, ? super Exception, Unit>)((Function2)attachDefaultServerEventHandlers.5.INSTANCE));
        return this;
    }

    public static final /* synthetic */ Logger access$getLogger$cp() {
        return logger;
    }

    static {
        boolean $i$f$Logger = false;
        String string = Reflection.getOrCreateKotlinClass(HttpWsServerBuilder.class).getSimpleName();
        Intrinsics.checkNotNull((Object)string);
        logger = LoggerKt.Logger((String)string);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/projector/server/core/websocket/WsTransportBuilder$Companion;", "", "()V", "logger", "Lorg/jetbrains/projector/util/logging/Logger;", "projector-server-core"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

