/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.projector.server;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.concurrent.ThreadsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.math.MathKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.projector.awt.PClipboard;
import org.jetbrains.projector.awt.PToolkit;
import org.jetbrains.projector.awt.PWindow;
import org.jetbrains.projector.awt.font.PFontManager;
import org.jetbrains.projector.awt.image.PGraphics2D;
import org.jetbrains.projector.awt.image.PGraphicsEnvironment;
import org.jetbrains.projector.awt.image.PVolatileImage;
import org.jetbrains.projector.awt.peer.PComponentPeer;
import org.jetbrains.projector.awt.peer.PDesktopPeer;
import org.jetbrains.projector.awt.peer.PMouseInfoPeer;
import org.jetbrains.projector.common.misc.Do;
import org.jetbrains.projector.common.protocol.compress.MessageCompressor;
import org.jetbrains.projector.common.protocol.compress.MessageDecompressor;
import org.jetbrains.projector.common.protocol.data.CommonIntRectangle;
import org.jetbrains.projector.common.protocol.data.CommonRectangle;
import org.jetbrains.projector.common.protocol.data.CursorType;
import org.jetbrains.projector.common.protocol.data.FontDataHolder;
import org.jetbrains.projector.common.protocol.data.ImageData;
import org.jetbrains.projector.common.protocol.data.ImageId;
import org.jetbrains.projector.common.protocol.data.UserKeymap;
import org.jetbrains.projector.common.protocol.handshake.CompressionType;
import org.jetbrains.projector.common.protocol.handshake.ConstantKt;
import org.jetbrains.projector.common.protocol.handshake.DisplayDescription;
import org.jetbrains.projector.common.protocol.handshake.ProtocolType;
import org.jetbrains.projector.common.protocol.handshake.ToClientHandshakeEvent;
import org.jetbrains.projector.common.protocol.handshake.ToClientHandshakeFailureEvent;
import org.jetbrains.projector.common.protocol.handshake.ToClientHandshakeSuccessEvent;
import org.jetbrains.projector.common.protocol.handshake.ToServerHandshakeEvent;
import org.jetbrains.projector.common.protocol.toClient.ServerCaretInfoChangedEvent;
import org.jetbrains.projector.common.protocol.toClient.ServerClipboardEvent;
import org.jetbrains.projector.common.protocol.toClient.ServerDrawCommandsEvent;
import org.jetbrains.projector.common.protocol.toClient.ServerEvent;
import org.jetbrains.projector.common.protocol.toClient.ServerImageDataReplyEvent;
import org.jetbrains.projector.common.protocol.toClient.ServerMarkdownEvent;
import org.jetbrains.projector.common.protocol.toClient.ServerPingReplyEvent;
import org.jetbrains.projector.common.protocol.toClient.ServerWindowColorsEvent;
import org.jetbrains.projector.common.protocol.toClient.ServerWindowSetChangedEvent;
import org.jetbrains.projector.common.protocol.toClient.ToClientMessageEncoder;
import org.jetbrains.projector.common.protocol.toClient.WindowData;
import org.jetbrains.projector.common.protocol.toClient.WindowType;
import org.jetbrains.projector.common.protocol.toServer.ClientClipboardEvent;
import org.jetbrains.projector.common.protocol.toServer.ClientDisplaySetChangeEvent;
import org.jetbrains.projector.common.protocol.toServer.ClientEvent;
import org.jetbrains.projector.common.protocol.toServer.ClientKeyEvent;
import org.jetbrains.projector.common.protocol.toServer.ClientKeyPressEvent;
import org.jetbrains.projector.common.protocol.toServer.ClientMouseEvent;
import org.jetbrains.projector.common.protocol.toServer.ClientOpenLinkEvent;
import org.jetbrains.projector.common.protocol.toServer.ClientRawKeyEvent;
import org.jetbrains.projector.common.protocol.toServer.ClientRequestImageDataEvent;
import org.jetbrains.projector.common.protocol.toServer.ClientRequestPingEvent;
import org.jetbrains.projector.common.protocol.toServer.ClientResizeEvent;
import org.jetbrains.projector.common.protocol.toServer.ClientSetKeymapEvent;
import org.jetbrains.projector.common.protocol.toServer.ClientWheelEvent;
import org.jetbrains.projector.common.protocol.toServer.ClientWindowCloseEvent;
import org.jetbrains.projector.common.protocol.toServer.ClientWindowInterestEvent;
import org.jetbrains.projector.common.protocol.toServer.ClientWindowMoveEvent;
import org.jetbrains.projector.common.protocol.toServer.ClientWindowResizeEvent;
import org.jetbrains.projector.common.protocol.toServer.ClientWindowSetBoundsEvent;
import org.jetbrains.projector.common.protocol.toServer.ClientWindowsActivationEvent;
import org.jetbrains.projector.common.protocol.toServer.ClientWindowsDeactivationEvent;
import org.jetbrains.projector.common.protocol.toServer.ToServerMessageDecoder;
import org.jetbrains.projector.server.ProjectorServer;
import org.jetbrains.projector.server.core.ClientEventHandler;
import org.jetbrains.projector.server.core.ClientSettings;
import org.jetbrains.projector.server.core.ClientWrapper;
import org.jetbrains.projector.server.core.ClosedClientSettings;
import org.jetbrains.projector.server.core.ConnectedClientSettings;
import org.jetbrains.projector.server.core.ReadyClientSettings;
import org.jetbrains.projector.server.core.ServerTransport;
import org.jetbrains.projector.server.core.SetUpClientData;
import org.jetbrains.projector.server.core.SetUpClientSettings;
import org.jetbrains.projector.server.core.SupportedHandshakeClientSettings;
import org.jetbrains.projector.server.core.convert.toAwt.ClientEventExtensionsKt;
import org.jetbrains.projector.server.core.convert.toAwt.KeyKt;
import org.jetbrains.projector.server.core.convert.toAwt.MouseKt;
import org.jetbrains.projector.server.core.convert.toClient.ShiftKt;
import org.jetbrains.projector.server.core.convert.toClient.TransformKt;
import org.jetbrains.projector.server.core.ij.IdeColors;
import org.jetbrains.projector.server.core.ij.IjInjectorAgentInitializer;
import org.jetbrains.projector.server.core.ij.KeymapSetter;
import org.jetbrains.projector.server.core.ij.SettingsInitializer;
import org.jetbrains.projector.server.core.ij.md.PanelUpdater;
import org.jetbrains.projector.server.core.protocol.HandshakeTypesSelector;
import org.jetbrains.projector.server.core.protocol.KotlinxJsonToClientHandshakeEncoder;
import org.jetbrains.projector.server.core.protocol.KotlinxJsonToServerHandshakeDecoder;
import org.jetbrains.projector.server.core.util.AbstractWindowDrawInterestManager;
import org.jetbrains.projector.server.core.util.AwtKt;
import org.jetbrains.projector.server.core.util.HostAddressKt;
import org.jetbrains.projector.server.core.util.LaterInvokator;
import org.jetbrains.projector.server.core.util.PropertyKt;
import org.jetbrains.projector.server.core.websocket.WsTransportBuilder;
import org.jetbrains.projector.server.idea.CaretInfoUpdater;
import org.jetbrains.projector.server.idea.UpdatesConfigKt;
import org.jetbrains.projector.server.service.ProjectorAwtInitializer;
import org.jetbrains.projector.server.service.ProjectorDrawEventQueue;
import org.jetbrains.projector.server.service.ProjectorImageCacher;
import org.jetbrains.projector.server.util.ConfirmConnection;
import org.jetbrains.projector.server.util.ConvertKt;
import org.jetbrains.projector.server.util.FontCacher;
import org.jetbrains.projector.server.util.NetworkKt;
import org.jetbrains.projector.server.util.ServerMessagesKt;
import org.jetbrains.projector.server.util.WindowDrawInterestManagerImpl;
import org.jetbrains.projector.server.websocket.WebsocketServer;
import org.jetbrains.projector.util.loading.UseProjectorLoader;
import org.jetbrains.projector.util.logging.Logger;
import org.jetbrains.projector.util.logging.LoggerKt;
import sun.awt.AWTAccessor;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@UseProjectorLoader
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00cc\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\b\u0007\u0018\u0000 ]2\u00020\u0001:\u0001]B\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010*\u001a\u00020\u00052\u0006\u0010+\u001a\u00020\u001aJ\u000e\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\"J\u0016\u0010/\u001a\u00020\u00052\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001cH\u0002J \u00101\u001a\u00020-2\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u000207H\u0002J\u000e\u00108\u001a\b\u0012\u0004\u0012\u0002090\u001cH\u0002J\b\u0010:\u001a\u00020$H\u0002J\u0006\u0010;\u001a\u00020-J\u000e\u0010<\u001a\u00020-2\u0006\u0010=\u001a\u000207J\u0019\u0010>\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u0001070?0?\u00a2\u0006\u0002\u0010@J\u0012\u0010A\u001a\u00020\u00052\b\u0010B\u001a\u0004\u0018\u00010\u0015H\u0002J\u0006\u0010C\u001a\u00020\u0005J\u0010\u0010D\u001a\u00020-2\u0006\u0010E\u001a\u00020FH\u0002J\u0018\u0010G\u001a\u00020-2\u0006\u0010H\u001a\u00020I2\u0006\u00106\u001a\u00020JH\u0002J\u000e\u0010K\u001a\u00020\u00052\u0006\u0010+\u001a\u00020\u001aJ\u0018\u0010L\u001a\u00020\u00052\u0006\u0010.\u001a\u00020\"2\b\b\u0002\u0010M\u001a\u00020NJ\u0010\u0010O\u001a\u00020-2\u0006\u0010P\u001a\u00020QH\u0002J\u0016\u0010R\u001a\u00020-2\f\u0010S\u001a\b\u0012\u0004\u0012\u0002090\u001cH\u0002J \u0010T\u001a\u00020-2\u0006\u00102\u001a\u0002032\u0006\u0010U\u001a\u00020V2\u0006\u00106\u001a\u000207H\u0002J\u0006\u0010W\u001a\u00020-J\u0012\u0010X\u001a\u00020-2\b\b\u0002\u0010Y\u001a\u00020NH\u0007J\u001e\u0010Z\u001a\u00020-2\f\u0010[\u001a\b\u0012\u0004\u0012\u00020N0\u001c2\u0006\u0010\\\u001a\u00020NH\u0002R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\f\u001a\u00020\r\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000e\u0010\u000f\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010\u0018\u001a&\u0012\f\u0012\n \u001b*\u0004\u0018\u00010\u001a0\u001a \u001b*\u0012\u0012\f\u0012\n \u001b*\u0004\u0018\u00010\u001a0\u001a\u0018\u00010\u001c0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082.\u00a2\u0006\u0002\n\u0000R\u0011\u0010%\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u0010\u0010(\u001a\u0004\u0018\u00010)X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006^"}, d2={"Lorg/jetbrains/projector/server/ProjectorServer;", "", "laterInvokator", "Lorg/jetbrains/projector/server/core/util/LaterInvokator;", "isAgent", "", "(Lorg/jetbrains/projector/server/core/util/LaterInvokator;Z)V", "caretInfoQueue", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "Lorg/jetbrains/projector/common/protocol/toClient/ServerCaretInfoChangedEvent$CaretInfoChange;", "caretInfoUpdater", "Lorg/jetbrains/projector/server/idea/CaretInfoUpdater;", "clientEventHandler", "Lorg/jetbrains/projector/server/core/ClientEventHandler;", "getClientEventHandler$annotations", "()V", "getClientEventHandler", "()Lorg/jetbrains/projector/server/core/ClientEventHandler;", "ideaColors", "Lorg/jetbrains/projector/server/core/ij/IdeColors;", "lastClipboardEvent", "Lorg/jetbrains/projector/common/protocol/toClient/ServerClipboardEvent;", "markdownQueue", "Lorg/jetbrains/projector/common/protocol/toClient/ServerMarkdownEvent;", "observers", "", "Ljava/beans/PropertyChangeListener;", "kotlin.jvm.PlatformType", "", "previousWindowEvents", "", "Lorg/jetbrains/projector/common/protocol/toClient/WindowData;", "transports", "", "Lorg/jetbrains/projector/server/core/ServerTransport;", "updateThread", "Ljava/lang/Thread;", "wasStarted", "getWasStarted", "()Z", "windowColorsEvent", "Lorg/jetbrains/projector/common/protocol/toClient/ServerWindowColorsEvent;", "addObserver", "listener", "addTransport", "", "transport", "areChangedWindows", "windowEvents", "checkHandshakeVersion", "conn", "Lorg/jetbrains/projector/server/core/ClientWrapper;", "connectedClientSettings", "Lorg/jetbrains/projector/server/core/ConnectedClientSettings;", "message", "", "createDataToSend", "Lorg/jetbrains/projector/common/protocol/toClient/ServerEvent;", "createUpdateThread", "disconnectAll", "disconnectByIp", "ip", "getClientList", "", "()[[Ljava/lang/String;", "isClipboardChanged", "current", "isStopped", "notifyObservers", "event", "Ljava/beans/PropertyChangeEvent;", "processMessage", "clientSettings", "Lorg/jetbrains/projector/server/core/ReadyClientSettings;", "Lorg/jetbrains/projector/common/protocol/toServer/ClientEvent;", "removeObserver", "removeTransport", "timeoutMs", "", "sendMacLocalConnectionWarning", "address", "Ljava/net/InetAddress;", "sendPictures", "dataToSend", "setUpClient", "supportedHandshakeClientSettings", "Lorg/jetbrains/projector/server/core/SupportedHandshakeClientSettings;", "start", "stop", "timeout", "updateWindowsState", "windowIds", "windowEventId", "Companion", "projector-server"})
public final class ProjectorServer {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final LaterInvokator laterInvokator;
    private final boolean isAgent;
    @NotNull
    private final Set<ServerTransport> transports;
    private Thread updateThread;
    @NotNull
    private final ConcurrentLinkedQueue<ServerCaretInfoChangedEvent.CaretInfoChange> caretInfoQueue;
    @NotNull
    private final CaretInfoUpdater caretInfoUpdater;
    @NotNull
    private final ConcurrentLinkedQueue<ServerMarkdownEvent> markdownQueue;
    @Nullable
    private ServerWindowColorsEvent windowColorsEvent;
    @NotNull
    private final IdeColors ideaColors;
    @NotNull
    private final ClientEventHandler clientEventHandler;
    private final List<PropertyChangeListener> observers;
    @Nullable
    private ServerClipboardEvent lastClipboardEvent;
    @NotNull
    private Set<WindowData> previousWindowEvents;
    @NotNull
    private static final Logger logger;
    @Nullable
    private static ProjectorServer lastStartedServer;
    @NotNull
    public static final String ENABLE_PROPERTY_NAME = "org.jetbrains.projector.server.enable";
    @NotNull
    private static final String HOST_PROPERTY_NAME_OLD = "org.jetbrains.projector.server.host";
    @NotNull
    public static final String HOST_PROPERTY_NAME = "ORG_JETBRAINS_PROJECTOR_SERVER_HOST";
    @NotNull
    private static final String PORT_PROPERTY_NAME_OLD = "org.jetbrains.projector.server.port";
    @NotNull
    public static final String PORT_PROPERTY_NAME = "ORG_JETBRAINS_PROJECTOR_SERVER_PORT";
    @NotNull
    private static final String DEFAULT_PORT = "8887";
    @NotNull
    public static final String TOKEN_ENV_NAME = "ORG_JETBRAINS_PROJECTOR_SERVER_HANDSHAKE_TOKEN";
    @NotNull
    public static final String RO_TOKEN_ENV_NAME = "ORG_JETBRAINS_PROJECTOR_SERVER_RO_HANDSHAKE_TOKEN";
    private static boolean ENABLE_BIG_COLLECTIONS_CHECKS;
    private static final int DEFAULT_BIG_COLLECTIONS_CHECKS_SIZE = 10000;
    private static int BIG_COLLECTIONS_CHECKS_START_SIZE;
    @NotNull
    public static final String ENABLE_AUTO_KEYMAP_SETTING = "ORG_JETBRAINS_PROJECTOR_SERVER_AUTO_KEYMAP";
    @NotNull
    public static final String MAC_KEYBOARD_MODIFIERS_MODE = "ORG_JETBRAINS_PROJECTOR_SERVER_MAC_KEYBOARD";
    @NotNull
    public static final String ENABLE_CONNECTION_CONFIRMATION = "ORG_JETBRAINS_PROJECTOR_SERVER_CONNECTION_CONFIRMATION";
    @NotNull
    private static final String DISABLE_IDEA_UPDATES_PROPERTY_NAME = "ORG_JETBRAINS_PROJECTOR_SERVER_DISABLE_IDEA_UPDATES";

    private ProjectorServer(LaterInvokator laterInvokator, boolean isAgent) {
        this.laterInvokator = laterInvokator;
        this.isAgent = isAgent;
        ConcurrentHashMap.KeySetView keySetView = new ConcurrentHashMap().keySet(Unit.INSTANCE);
        Intrinsics.checkNotNullExpressionValue(keySetView, (String)"ConcurrentHashMap<ServerTransport, Unit>().keySet(Unit)");
        this.transports = keySetView;
        this.caretInfoQueue = new ConcurrentLinkedQueue();
        this.caretInfoUpdater = new CaretInfoUpdater((Function1<? super ServerCaretInfoChangedEvent.CaretInfoChange, Unit>)((Function1)new Function1<ServerCaretInfoChangedEvent.CaretInfoChange, Unit>(this){
            final /* synthetic */ ProjectorServer this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull ServerCaretInfoChangedEvent.CaretInfoChange caretInfo) {
                Intrinsics.checkNotNullParameter((Object)caretInfo, (String)"caretInfo");
                ProjectorServer.access$getCaretInfoQueue$p(this.this$0).add(caretInfo);
            }
        }));
        this.markdownQueue = new ConcurrentLinkedQueue();
        this.ideaColors = new IdeColors((Function1)new Function1<ServerWindowColorsEvent.ColorsStorage, Unit>(this){
            final /* synthetic */ ProjectorServer this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull ServerWindowColorsEvent.ColorsStorage colors) {
                Intrinsics.checkNotNullParameter((Object)colors, (String)"colors");
                ProjectorServer.access$setWindowColorsEvent$p(this.this$0, new ServerWindowColorsEvent(colors));
            }
        });
        PanelUpdater.INSTANCE.setShowCallback((Function2)new Function2<Integer, Boolean, Unit>(){

            public final void invoke(int id, boolean show) {
                markdownQueue.add(new ServerMarkdownEvent.ServerMarkdownShowEvent(id, show));
            }
        });
        PanelUpdater.INSTANCE.setResizeCallback((Function2)new Function2<Integer, Dimension, Unit>(){

            public final void invoke(int id, @NotNull Dimension size) {
                Intrinsics.checkNotNullParameter((Object)size, (String)"size");
                markdownQueue.add(new ServerMarkdownEvent.ServerMarkdownResizeEvent(id, org.jetbrains.projector.server.core.convert.toClient.ConvertKt.toCommonIntSize((Dimension)size)));
            }
        });
        PanelUpdater.INSTANCE.setMoveCallback((Function2)new Function2<Integer, Point, Unit>(){

            public final void invoke(int id, @NotNull Point point) {
                Intrinsics.checkNotNullParameter((Object)point, (String)"point");
                markdownQueue.add(new ServerMarkdownEvent.ServerMarkdownMoveEvent(id, ShiftKt.shift((Point)point, (Point)PGraphicsEnvironment.Companion.getDefaultDevice().getClientShift())));
            }
        });
        PanelUpdater.INSTANCE.setDisposeCallback((Function1)new Function1<Integer, Unit>(){

            public final void invoke(int id) {
                markdownQueue.add(new ServerMarkdownEvent.ServerMarkdownDisposeEvent(id));
            }
        });
        PanelUpdater.INSTANCE.setPlaceToWindowCallback((Function2)new Function2<Integer, Component, Unit>(){

            public final void invoke(int id, @Nullable Component rootComponent) {
                Component component = rootComponent;
                if (component != null) {
                    Component component2 = component;
                    ProjectorServer projectorServer = this;
                    boolean bl = false;
                    boolean bl2 = false;
                    Component it = component2;
                    boolean bl3 = false;
                    Object peer = AWTAccessor.getComponentAccessor().getPeer(it);
                    if (peer instanceof PComponentPeer) {
                        projectorServer.markdownQueue.add(new ServerMarkdownEvent.ServerMarkdownPlaceToWindowEvent(id, ((PComponentPeer)peer).getPWindow().getId()));
                    }
                }
            }
        });
        PanelUpdater.INSTANCE.setSetHtmlCallback((Function2)new Function2<Integer, String, Unit>(){

            public final void invoke(int id, @NotNull String html) {
                Intrinsics.checkNotNullParameter((Object)html, (String)"html");
                markdownQueue.add(new ServerMarkdownEvent.ServerMarkdownSetHtmlEvent(id, html));
            }
        });
        PanelUpdater.INSTANCE.setSetCssCallback((Function2)new Function2<Integer, String, Unit>(){

            public final void invoke(int id, @NotNull String css) {
                Intrinsics.checkNotNullParameter((Object)css, (String)"css");
                markdownQueue.add(new ServerMarkdownEvent.ServerMarkdownSetCssEvent(id, css));
            }
        });
        PanelUpdater.INSTANCE.setScrollCallback((Function2)new Function2<Integer, Integer, Unit>(){

            public final void invoke(int id, int offset) {
                markdownQueue.add(new ServerMarkdownEvent.ServerMarkdownScrollEvent(id, offset));
            }
        });
        PDesktopPeer.Companion.setBrowseUriCallback((Function1)new Function1<String, Unit>(){

            public final void invoke(@NotNull String link) {
                Intrinsics.checkNotNullParameter((Object)link, (String)"link");
                markdownQueue.add(new ServerMarkdownEvent.ServerMarkdownBrowseUriEvent(link));
            }
        });
        this.clientEventHandler = new ClientEventHandler(this){
            final /* synthetic */ ProjectorServer this$0;
            {
                this.this$0 = $receiver;
            }

            public void onClientConnectionEnded(@NotNull ClientWrapper connection) {
                Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
                ClientSettings clientSettings = connection.getSettings();
                double connectionTime = (double)(System.currentTimeMillis() - clientSettings.getConnectionMillis()) / 1000.0;
                Logger.DefaultImpls.info$default((Logger)ProjectorServer.access$getLogger$cp(), null, (Function0)((Function0)new Function0<String>(clientSettings, connectionTime){
                    final /* synthetic */ ClientSettings $clientSettings;
                    final /* synthetic */ double $connectionTime;
                    {
                        this.$clientSettings = $clientSettings;
                        this.$connectionTime = $connectionTime;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return this.$clientSettings.getAddress() + " disconnected, was connected for " + MathKt.roundToLong((double)this.$connectionTime) + " s.";
                    }
                }), (int)1, null);
            }

            @NotNull
            public ClientSettings getInitialClientState(@Nullable String address) {
                return (ClientSettings)new ConnectedClientSettings(System.currentTimeMillis(), address);
            }

            public void onClientConnected(@NotNull ClientWrapper connection) {
                Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
            }

            /*
             * WARNING - void declaration
             */
            public void handleMessage(@NotNull ClientWrapper wrapper, @NotNull String message) {
                Intrinsics.checkNotNullParameter((Object)wrapper, (String)"wrapper");
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                Do do_ = Do.INSTANCE;
                ClientSettings clientSettings = wrapper.getSettings();
                if (clientSettings instanceof ConnectedClientSettings) {
                    ProjectorServer.access$checkHandshakeVersion(this.this$0, wrapper, (ConnectedClientSettings)clientSettings, message);
                } else if (clientSettings instanceof SupportedHandshakeClientSettings) {
                    ProjectorServer.access$setUpClient(this.this$0, wrapper, (SupportedHandshakeClientSettings)clientSettings, message);
                } else if (clientSettings instanceof SetUpClientSettings) {
                    PVolatileImage p0;
                    wrapper.setSettings((ClientSettings)new ReadyClientSettings(clientSettings.getConnectionMillis(), clientSettings.getAddress(), ((SetUpClientSettings)clientSettings).getSetUpClientData(), (AbstractWindowDrawInterestManager)new WindowDrawInterestManagerImpl(), ProjectorServer.Companion.getENABLE_BIG_COLLECTIONS_CHECKS() ? Integer.valueOf(ProjectorServer.Companion.getBIG_COLLECTIONS_CHECKS_START_SIZE()) : null));
                    Iterable $this$forEach$iv = PVolatileImage.Companion.getImages();
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        p0 = (PVolatileImage)element$iv;
                        boolean bl = false;
                        p0.invalidate();
                    }
                    $this$forEach$iv = PWindow.Companion.getWindows();
                    $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        PWindow it = (PWindow)element$iv;
                        boolean bl = false;
                        SwingUtilities.invokeAndWait(() -> clientEventHandler.1.handleMessage$lambda-1$lambda-0(it));
                    }
                    $this$forEach$iv = PWindow.Companion.getWindows();
                    $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        p0 = (PWindow)element$iv;
                        boolean bl = false;
                        p0.repaint();
                    }
                    ProjectorServer.access$setPreviousWindowEvents$p(this.this$0, SetsKt.emptySet());
                    ProjectorServer.access$getCaretInfoUpdater$p(this.this$0).createCaretInfoEvent();
                    PanelUpdater.INSTANCE.updateAll();
                } else if (clientSettings instanceof ReadyClientSettings) {
                    void $this$forEach$iv;
                    Object $i$f$forEach = ((ReadyClientSettings)clientSettings).getSetUpClientData();
                    boolean bl = false;
                    boolean element$iv = false;
                    SetUpClientData $this$handleMessage_u24lambda_u2d3 = $i$f$forEach;
                    boolean bl2 = false;
                    String decompressed = (String)$this$handleMessage_u24lambda_u2d3.getToServerMessageDecompressor().decompress((Object)message);
                    List events = (List)$this$handleMessage_u24lambda_u2d3.getToServerMessageDecoder().decode((Object)decompressed);
                    $i$f$forEach = events;
                    ProjectorServer projectorServer = this.this$0;
                    boolean $i$f$forEach2 = false;
                    for (T element$iv2 : $this$forEach$iv) {
                        ClientEvent it = (ClientEvent)element$iv2;
                        boolean bl3 = false;
                        ProjectorServer.access$processMessage(projectorServer, (ReadyClientSettings)clientSettings, it);
                    }
                } else if (!(clientSettings instanceof ClosedClientSettings)) {
                    throw new NoWhenBranchMatchedException();
                }
                clientSettings = Unit.INSTANCE;
                boolean $i$f$exhaustive = false;
            }

            /*
             * WARNING - void declaration
             */
            public void updateClientsCount() {
                Iterable iterable = ProjectorServer.access$getTransports$p(this.this$0);
                boolean bl = false;
                int n = 0;
                for (T t : iterable) {
                    void it;
                    ServerTransport serverTransport = (ServerTransport)t;
                    int n2 = n;
                    boolean bl2 = false;
                    int n3 = it.getClientCount();
                    n = n2 + n3;
                }
                int count = n;
                ProjectorServer.access$notifyObservers(this.this$0, ServerMessagesKt.clientsCountMessage(this, count));
            }

            private static final void handleMessage$lambda-1$lambda-0(PWindow $it) {
                Intrinsics.checkNotNullParameter((Object)$it, (String)"$it");
                $it.getTarget().revalidate();
            }
        };
        boolean bl = false;
        this.observers = Collections.synchronizedList(new ArrayList());
        this.previousWindowEvents = SetsKt.emptySet();
    }

    public final boolean getWasStarted() {
        boolean bl;
        block3: {
            Iterable $this$all$iv = this.transports;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    ServerTransport it = (ServerTransport)element$iv;
                    boolean bl2 = false;
                    if (it.getWasStarted()) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    @NotNull
    public final ClientEventHandler getClientEventHandler() {
        return this.clientEventHandler;
    }

    public static /* synthetic */ void getClientEventHandler$annotations() {
    }

    public final boolean addObserver(@NotNull PropertyChangeListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        return this.observers.add(listener);
    }

    public final boolean removeObserver(@NotNull PropertyChangeListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        return this.observers.remove(listener);
    }

    private final void notifyObservers(PropertyChangeEvent event) {
        List<PropertyChangeListener> list = this.observers;
        Intrinsics.checkNotNullExpressionValue(list, (String)"observers");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PropertyChangeListener it = (PropertyChangeListener)element$iv;
            boolean bl = false;
            it.propertyChange(event);
        }
    }

    private final void sendMacLocalConnectionWarning(InetAddress address) {
        this.notifyObservers(ServerMessagesKt.macLocalConnectionMessage(this, address));
    }

    private final Thread createUpdateThread() {
        return ThreadsKt.thread$default((boolean)false, (boolean)true, null, null, (int)0, (Function0)((Function0)new Function0<Unit>(this){
            final /* synthetic */ ProjectorServer this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                Logger.DefaultImpls.debug$default((Logger)ProjectorServer.access$getLogger$cp(), null, (Function0)createUpdateThread.1.INSTANCE, (int)1, null);
                while (!Thread.currentThread().isInterrupted()) {
                    try {
                        List dataToSend = ProjectorServer.access$createDataToSend(this.this$0);
                        ProjectorServer.access$sendPictures(this.this$0, dataToSend);
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                    }
                    catch (Throwable t) {
                        ProjectorServer.access$getLogger$cp().error(t, (Function0)createUpdateThread.2.INSTANCE);
                    }
                }
                Logger.DefaultImpls.debug$default((Logger)ProjectorServer.access$getLogger$cp(), null, (Function0)createUpdateThread.3.INSTANCE, (int)1, null);
            }
        }), (int)29, null);
    }

    private final boolean isClipboardChanged(ServerClipboardEvent current) {
        return !Intrinsics.areEqual((Object)this.lastClipboardEvent, (Object)current);
    }

    /*
     * WARNING - void declaration
     */
    private final List<ServerEvent> createDataToSend() {
        void $this$mapTo$iv$iv;
        boolean bl;
        String string;
        ServerCaretInfoChangedEvent.CaretInfoChange window;
        void $this$mapIndexedTo$iv$iv;
        void $this$mapIndexed$iv;
        ServerDrawCommandsEvent serverDrawCommandsEvent;
        Collection collection;
        void $this$mapTo$iv$iv2;
        boolean bl2;
        ProjectorDrawEventQueue it;
        Iterable $this$filterTo$iv$iv;
        List list;
        boolean bl3 = this.isAgent;
        if (!bl3) {
            Transferable transferable2 = PClipboard.INSTANCE.extractLastContents();
            transferable2 = transferable2 == null ? null : ProjectorServer.Companion.toServerClipboardEvent(transferable2);
            boolean bl4 = false;
            boolean bl5 = false;
            Transferable p022 = transferable2;
            boolean bl6 = false;
            list = CollectionsKt.listOfNotNull((Object)p022);
        } else if (bl3) {
            ServerClipboardEvent clipboardEvent;
            Transferable p022;
            Clipboard systemClipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            try {
                p022 = systemClipboard.getContents(null);
            }
            catch (IllegalStateException e) {
                p022 = null;
            }
            Transferable transferable3 = p022;
            ServerClipboardEvent serverClipboardEvent = clipboardEvent = transferable3 == null ? null : ProjectorServer.Companion.toServerClipboardEvent(transferable3);
            if (this.isClipboardChanged(clipboardEvent)) {
                this.lastClipboardEvent = clipboardEvent;
                transferable3 = clipboardEvent;
                boolean p022 = false;
                boolean e = false;
                Iterator p03 = transferable3;
                boolean bl7 = false;
                list = CollectionsKt.listOfNotNull((Object)p03);
            } else {
                list = CollectionsKt.emptyList();
            }
        } else {
            throw new NoWhenBranchMatchedException();
        }
        List clipboardEvent = list;
        ProjectorServer.Companion.calculateMainWindowShift();
        Iterable $this$filter$iv = ProjectorDrawEventQueue.Companion.getQueues();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (ProjectorDrawEventQueue)element$iv$iv;
            boolean bl8 = false;
            Collection collection2 = it.getCommands();
            bl2 = false;
            boolean bl4 = !collection2.isEmpty();
            if (!bl4) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map232 = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            Iterator queue;
            it = (ProjectorDrawEventQueue)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl10 = false;
            List drawEvents = TransformKt.extractData((Iterable)((ProjectorDrawEventQueue)((Object)queue)).getCommands());
            serverDrawCommandsEvent = new ServerDrawCommandsEvent(((ProjectorDrawEventQueue)((Object)queue)).getTarget(), TransformKt.convertToSimpleList((List)drawEvents));
            collection.add(serverDrawCommandsEvent);
        }
        List drawCommands = (List)destination$iv$iv;
        Iterable $i$f$map232 = PWindow.Companion.getWindows();
        boolean $i$f$mapIndexed = false;
        destination$iv$iv = $this$mapIndexed$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv232 = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void i;
            CursorType cursorType;
            CursorType $this$mapTo$iv$iv3;
            boolean bl11;
            List list2;
            int n = index$iv$iv232++;
            bl2 = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            PWindow pWindow = (PWindow)item$iv$iv;
            int n2 = n;
            collection = destination$iv$iv2;
            boolean bl12 = false;
            int n3 = window.getId();
            string = window.getTitle();
            List list3 = window.getIcons();
            if (list3 == null) {
                list2 = null;
            } else {
                Iterable $this$map$iv2 = list3;
                boolean $i$f$map = false;
                Iterable iterable2 = $this$map$iv2;
                Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                bl11 = false;
                Iterator iterator = $this$mapTo$iv$iv3.iterator();
                while (iterator.hasNext()) {
                    void it2;
                    Object item$iv$iv2;
                    Object t = item$iv$iv2 = iterator.next();
                    Collection collection3 = destination$iv$iv3;
                    boolean bl13 = false;
                    ImageId imageId = (ImageId)it2;
                    collection3.add(imageId);
                }
                list2 = (List)destination$iv$iv3;
            }
            List list4 = list2;
            bl = window.getTarget().isShowing();
            CommonRectangle commonRectangle = ShiftKt.shiftBounds((Component)window.getTarget(), (Point)PGraphicsEnvironment.Companion.getDefaultDevice().getClientShift());
            Integer $i$f$map = window.getHeaderHeight();
            Cursor cursor = window.getCursor();
            if (cursor == null) {
                cursorType = null;
            } else {
                bl11 = cursor.getType();
                cursorType = org.jetbrains.projector.server.core.convert.toClient.ConvertKt.toCursorType((int)(bl11 ? 1 : 0));
            }
            $this$mapTo$iv$iv3 = cursorType;
            boolean bl14 = window.getResizable();
            bl11 = window.getModal();
            boolean bl15 = window.getUndecorated();
            WindowType windowType = ConvertKt.getWindowType((PWindow)window);
            serverDrawCommandsEvent = new WindowData(n3, string, list4, bl, (int)i, commonRectangle, $this$mapTo$iv$iv3, bl14, bl11, bl15, windowType, $i$f$map);
            collection.add(serverDrawCommandsEvent);
        }
        List windows = (List)destination$iv$iv2;
        List windowSetChangedEvent = this.areChangedWindows(windows) ? CollectionsKt.listOf((Object)new ServerWindowSetChangedEvent(windows)) : CollectionsKt.emptyList();
        List newImagesCopy = TransformKt.extractData((Iterable)ProjectorImageCacher.INSTANCE.getNewImages());
        Iterable $this$map$iv3 = TransformKt.extractData((Iterable)this.caretInfoQueue);
        boolean $i$f$map = false;
        Iterable index$iv$iv232 = $this$map$iv3;
        Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
        boolean $i$f$mapTo3 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            window = (ServerCaretInfoChangedEvent.CaretInfoChange)item$iv$iv;
            collection = destination$iv$iv4;
            boolean bl16 = false;
            serverDrawCommandsEvent = new ServerCaretInfoChangedEvent((ServerCaretInfoChangedEvent.CaretInfoChange)p0);
            collection.add(serverDrawCommandsEvent);
        }
        List caretInfoEvents = (List)destination$iv$iv4;
        List markdownEvents = TransformKt.extractData((Iterable)this.markdownQueue);
        int commandsCount = caretInfoEvents.size() + newImagesCopy.size() + clipboardEvent.size() + drawCommands.size() + windowSetChangedEvent.size() + markdownEvents.size() + 1;
        boolean bl17 = false;
        boolean bl18 = false;
        bl18 = false;
        List list5 = CollectionsKt.createListBuilder((int)commandsCount);
        boolean bl19 = false;
        boolean bl20 = false;
        Object $this$createDataToSend_u24lambda_u2d9 = list5;
        boolean bl21 = false;
        $this$createDataToSend_u24lambda_u2d9.addAll(caretInfoEvents);
        $this$createDataToSend_u24lambda_u2d9.addAll(newImagesCopy);
        $this$createDataToSend_u24lambda_u2d9.addAll(clipboardEvent);
        $this$createDataToSend_u24lambda_u2d9.addAll(drawCommands);
        $this$createDataToSend_u24lambda_u2d9.addAll(windowSetChangedEvent);
        $this$createDataToSend_u24lambda_u2d9.addAll(markdownEvents);
        ServerWindowColorsEvent serverWindowColorsEvent = this.windowColorsEvent;
        if (serverWindowColorsEvent != null) {
            string = serverWindowColorsEvent;
            bl = false;
            boolean bl22 = false;
            String it3 = string;
            boolean bl23 = false;
            $this$createDataToSend_u24lambda_u2d9.add(it3);
            this.windowColorsEvent = null;
        }
        List allEvents = CollectionsKt.build((List)list5);
        ProjectorImageCacher.INSTANCE.collectGarbage();
        return allEvents;
    }

    private final void processMessage(ReadyClientSettings clientSettings, ClientEvent message) {
        Do pingReply;
        KeyEvent it2;
        boolean bl;
        KeyEvent keyEvent;
        Object object;
        if (!(clientSettings.getSetUpClientData().getHasWriteAccess() || message instanceof ClientRequestImageDataEvent || message instanceof ClientRequestPingEvent)) {
            return;
        }
        Do do_ = Do.INSTANCE;
        ClientEvent clientEvent = message;
        if (clientEvent instanceof ClientResizeEvent) {
            SwingUtilities.invokeLater(() -> ProjectorServer.processMessage$lambda-10(message));
            object = Unit.INSTANCE;
        } else if (clientEvent instanceof ClientDisplaySetChangeEvent) {
            SwingUtilities.invokeLater(() -> ProjectorServer.processMessage$lambda-12(message));
            object = Unit.INSTANCE;
        } else if (clientEvent instanceof ClientMouseEvent) {
            SwingUtilities.invokeLater(() -> ProjectorServer.processMessage$lambda-13(message, clientSettings, this));
            object = Unit.INSTANCE;
        } else if (clientEvent instanceof ClientWheelEvent) {
            SwingUtilities.invokeLater(() -> ProjectorServer.processMessage$lambda-14(message, clientSettings, this));
            object = Unit.INSTANCE;
        } else if (clientEvent instanceof ClientKeyEvent) {
            keyEvent = KeyKt.toAwtKeyEvent((ClientKeyEvent)((ClientKeyEvent)message), (long)clientSettings.getConnectionMillis(), (Component)AwtKt.focusOwnerOrTarget((Component)((PWindow)CollectionsKt.last((List)PWindow.Companion.getWindows())).getTarget()));
            boolean bl2 = false;
            bl = false;
            it2 = keyEvent;
            boolean bl3 = false;
            SwingUtilities.invokeLater(() -> ProjectorServer.processMessage$lambda-16$lambda-15(this, it2));
            object = Unit.INSTANCE;
        } else if (clientEvent instanceof ClientKeyPressEvent) {
            keyEvent = KeyKt.toAwtKeyEvent((ClientKeyPressEvent)((ClientKeyPressEvent)message), (long)clientSettings.getConnectionMillis(), (Component)AwtKt.focusOwnerOrTarget((Component)((PWindow)CollectionsKt.last((List)PWindow.Companion.getWindows())).getTarget()));
            boolean bl4 = false;
            bl = false;
            it2 = keyEvent;
            boolean bl5 = false;
            SwingUtilities.invokeLater(() -> ProjectorServer.processMessage$lambda-18$lambda-17(this, it2));
            object = Unit.INSTANCE;
        } else if (clientEvent instanceof ClientRawKeyEvent) {
            SwingUtilities.invokeLater(() -> ProjectorServer.processMessage$lambda-19(this, message, clientSettings));
            object = Unit.INSTANCE;
        } else if (clientEvent instanceof ClientRequestImageDataEvent) {
            ImageData imageData = ProjectorImageCacher.INSTANCE.getImage(((ClientRequestImageDataEvent)message).getImageId());
            ImageData imageData2 = imageData == null ? (ImageData)ImageData.Empty.INSTANCE : imageData;
            ServerImageDataReplyEvent resource = new ServerImageDataReplyEvent(((ClientRequestImageDataEvent)message).getImageId(), imageData2);
            object = clientSettings.getRequestedData().add(resource);
        } else if (clientEvent instanceof ClientClipboardEvent) {
            Transferable transferable2 = new Transferable(message){
                final /* synthetic */ ClientEvent $message;
                {
                    this.$message = $message;
                }

                @NotNull
                public Object getTransferData(@Nullable DataFlavor flavor) {
                    if (!this.isDataFlavorSupported(flavor)) {
                        throw new UnsupportedFlavorException(flavor);
                    }
                    return ((ClientClipboardEvent)this.$message).getStringContent();
                }

                public boolean isDataFlavorSupported(@Nullable DataFlavor flavor) {
                    return ArraysKt.contains((Object[])this.getTransferDataFlavors(), (Object)flavor);
                }

                @NotNull
                public DataFlavor[] getTransferDataFlavors() {
                    DataFlavor[] dataFlavorArray = new DataFlavor[1];
                    DataFlavor dataFlavor = DataFlavor.stringFlavor;
                    Intrinsics.checkNotNullExpressionValue((Object)dataFlavor, (String)"stringFlavor");
                    dataFlavorArray[0] = dataFlavor;
                    return dataFlavorArray;
                }
            };
            boolean resource = this.isAgent;
            if (resource) {
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(transferable2, null);
            } else if (!resource) {
                PClipboard.INSTANCE.putContentsWithoutLastContentsUpdate(transferable2);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            object = Unit.INSTANCE;
        } else if (clientEvent instanceof ClientRequestPingEvent) {
            pingReply = new ServerPingReplyEvent(((ClientRequestPingEvent)message).getClientTimeStamp(), (int)(System.currentTimeMillis() - clientSettings.getConnectionMillis()));
            object = clientSettings.getRequestedData().add(pingReply);
        } else if (clientEvent instanceof ClientOpenLinkEvent) {
            PanelUpdater.INSTANCE.openInExternalBrowser(((ClientOpenLinkEvent)message).getLink());
            object = Unit.INSTANCE;
        } else if (clientEvent instanceof ClientSetKeymapEvent) {
            String resource;
            pingReply = Do.INSTANCE;
            if (this.isAgent) {
                Logger.DefaultImpls.info$default((Logger)logger, null, (Function0)processMessage.8.INSTANCE, (int)1, null);
            } else {
                resource = PropertyKt.getOption((String)ENABLE_AUTO_KEYMAP_SETTING, (String)"true");
                boolean bl6 = false;
                if (Boolean.parseBoolean(resource)) {
                    KeymapSetter.INSTANCE.setKeymap(((ClientSetKeymapEvent)message).getKeymap());
                } else {
                    Logger.DefaultImpls.info$default((Logger)logger, null, (Function0)processMessage.9.INSTANCE, (int)1, null);
                }
            }
            resource = Unit.INSTANCE;
            boolean $i$f$exhaustive2 = false;
            Do this_$iv = Do.INSTANCE;
            if (this.isAgent) {
                Logger.DefaultImpls.info$default((Logger)logger, null, (Function0)processMessage.10.INSTANCE, (int)1, null);
            } else if (PropertyKt.getOption((String)MAC_KEYBOARD_MODIFIERS_MODE) != null) {
                String string = PropertyKt.getOption((String)MAC_KEYBOARD_MODIFIERS_MODE);
                Intrinsics.checkNotNull((Object)string);
                String $i$f$exhaustive2 = string;
                boolean it = false;
                boolean mode = Boolean.parseBoolean($i$f$exhaustive2);
                Logger.DefaultImpls.info$default((Logger)logger, null, (Function0)((Function0)new Function0<String>(mode){
                    final /* synthetic */ boolean $mode;
                    {
                        this.$mode = $mode;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "Force keyboard modifiers to " + this.$mode + " (property specified)";
                    }
                }), (int)1, null);
                $i$f$exhaustive2 = Do.INSTANCE;
                it = mode;
                if (it) {
                    ProjectorServer.Companion.updateToolkitKeyboardModifiersMode(UserKeymap.MAC);
                } else if (!it) {
                    ProjectorServer.Companion.updateToolkitKeyboardModifiersMode(UserKeymap.LINUX);
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                it2 = Unit.INSTANCE;
                boolean $i$f$exhaustive3 = false;
            } else {
                ProjectorServer.Companion.updateToolkitKeyboardModifiersMode(((ClientSetKeymapEvent)message).getKeymap());
            }
            Unit mode = Unit.INSTANCE;
            boolean $i$f$exhaustive4 = false;
            object = Unit.INSTANCE;
        } else if (clientEvent instanceof ClientWindowMoveEvent) {
            SwingUtilities.invokeLater(() -> ProjectorServer.processMessage$lambda-21(message));
            object = Unit.INSTANCE;
        } else if (clientEvent instanceof ClientWindowResizeEvent) {
            SwingUtilities.invokeLater(() -> ProjectorServer.processMessage$lambda-23(message));
            object = Unit.INSTANCE;
        } else if (clientEvent instanceof ClientWindowSetBoundsEvent) {
            SwingUtilities.invokeLater(() -> ProjectorServer.processMessage$lambda-26(message));
            object = Unit.INSTANCE;
        } else if (clientEvent instanceof ClientWindowCloseEvent) {
            SwingUtilities.invokeLater(() -> ProjectorServer.processMessage$lambda-27(message));
            object = Unit.INSTANCE;
        } else if (clientEvent instanceof ClientWindowInterestEvent) {
            SwingUtilities.invokeLater(() -> ProjectorServer.processMessage$lambda-28(clientSettings, message));
            object = Unit.INSTANCE;
        } else if (clientEvent instanceof ClientWindowsActivationEvent) {
            this.updateWindowsState(((ClientWindowsActivationEvent)message).getWindowIds(), 205);
            object = Unit.INSTANCE;
        } else if (clientEvent instanceof ClientWindowsDeactivationEvent) {
            this.updateWindowsState(((ClientWindowsDeactivationEvent)message).getWindowIds(), 206);
            object = Unit.INSTANCE;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        clientEvent = object;
        boolean $i$f$exhaustive = false;
    }

    private final void updateWindowsState(List<Integer> windowIds, int windowEventId) {
        EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        boolean bl = false;
        boolean bl2 = false;
        EventQueue $this$updateWindowsState_u24lambda_u2d29 = eventQueue;
        boolean bl3 = false;
        Iterator<Integer> iterator = windowIds.iterator();
        while (iterator.hasNext()) {
            Window window;
            int windowId = ((Number)iterator.next()).intValue();
            PWindow pWindow = PWindow.Companion.getWindow(windowId);
            Component component = pWindow == null ? null : pWindow.getTarget();
            Window window2 = window = component instanceof Window ? (Window)component : null;
            if (window == null) continue;
            Window window3 = window;
            $this$updateWindowsState_u24lambda_u2d29.postEvent(new WindowEvent(window3, windowEventId));
        }
    }

    private final void checkHandshakeVersion(ClientWrapper conn, ConnectedClientSettings connectedClientSettings, String message) {
        List list;
        String[] stringArray = new String[]{";"};
        List list2 = list = StringsKt.split$default((CharSequence)message, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean bl = false;
        String handshakeVersion = (String)list2.get(0);
        List list3 = list;
        boolean bl2 = false;
        String handshakeVersionId = (String)list3.get(1);
        if (!Intrinsics.areEqual((Object)handshakeVersion, (Object)String.valueOf(ConstantKt.getHANDSHAKE_VERSION()))) {
            String reason = "Incompatible handshake versions: server - " + ConstantKt.getHANDSHAKE_VERSION() + " (#" + ConstantKt.getHandshakeVersionList().indexOf(ConstantKt.getHANDSHAKE_VERSION()) + "), client - " + handshakeVersion + " (#" + handshakeVersionId + ")";
            conn.disconnect(reason);
            return;
        }
        conn.setSettings((ClientSettings)new SupportedHandshakeClientSettings(connectedClientSettings.getConnectionMillis(), connectedClientSettings.getAddress()));
    }

    /*
     * WARNING - void declaration
     */
    private final void setUpClient(ClientWrapper conn, SupportedHandshakeClientSettings supportedHandshakeClientSettings, String message) {
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        boolean bl;
        Object object;
        boolean bl2;
        ToServerHandshakeEvent toServerHandshakeEvent = KotlinxJsonToServerHandshakeDecoder.INSTANCE.decode(message);
        String string = toServerHandshakeEvent.getToken();
        if (Intrinsics.areEqual((Object)string, (Object)PropertyKt.getOption((String)TOKEN_ENV_NAME))) {
            bl2 = true;
        } else if (Intrinsics.areEqual((Object)string, (Object)PropertyKt.getOption((String)RO_TOKEN_ENV_NAME))) {
            bl2 = false;
        } else {
            ProjectorServer.setUpClient$sendHandshakeFailureEvent(conn, "Bad handshake token");
            return;
        }
        boolean hasWriteAccess = bl2;
        if (toServerHandshakeEvent.getCommonVersion() != ConstantKt.getCOMMON_VERSION()) {
            String reason = "Incompatible common protocol versions: server - " + ConstantKt.getCOMMON_VERSION() + " (#" + ConstantKt.getCommonVersionList().indexOf(ConstantKt.getCOMMON_VERSION()) + "), client - " + toServerHandshakeEvent.getCommonVersion() + " (#" + toServerHandshakeEvent.getCommonVersionId() + ")";
            ProjectorServer.setUpClient$sendHandshakeFailureEvent(conn, reason);
            return;
        }
        MessageCompressor toClientCompressor = HandshakeTypesSelector.INSTANCE.selectToClientCompressor(toServerHandshakeEvent.getSupportedToClientCompressions());
        if (toClientCompressor == null) {
            ProjectorServer.setUpClient$sendHandshakeFailureEvent(conn, "Server doesn't support any of the following to-client compressions: " + toServerHandshakeEvent.getSupportedToClientCompressions());
            return;
        }
        ToClientMessageEncoder toClientEncoder = HandshakeTypesSelector.INSTANCE.selectToClientEncoder(toServerHandshakeEvent.getSupportedToClientProtocols());
        if (toClientEncoder == null) {
            ProjectorServer.setUpClient$sendHandshakeFailureEvent(conn, "Server doesn't support any of the following to-client protocols: " + toServerHandshakeEvent.getSupportedToClientProtocols());
            return;
        }
        MessageDecompressor toServerDecompressor = HandshakeTypesSelector.INSTANCE.selectToServerDecompressor(toServerHandshakeEvent.getSupportedToServerCompressions());
        if (toServerDecompressor == null) {
            ProjectorServer.setUpClient$sendHandshakeFailureEvent(conn, "Server doesn't support any of the following to-server compressions: " + toServerHandshakeEvent.getSupportedToServerCompressions());
            return;
        }
        ToServerMessageDecoder toServerDecoder = HandshakeTypesSelector.INSTANCE.selectToServerDecoder(toServerHandshakeEvent.getSupportedToServerProtocols());
        if (toServerDecoder == null) {
            ProjectorServer.setUpClient$sendHandshakeFailureEvent(conn, "Server doesn't support any of the following to-server protocols: " + toServerHandshakeEvent.getSupportedToServerProtocols());
            return;
        }
        if (this.isAgent && conn.getRequiresConfirmation()) {
            boolean bl3;
            Font[] fontArray = PropertyKt.getOption((String)ENABLE_CONNECTION_CONFIRMATION);
            if (fontArray == null) {
                bl3 = false;
            } else {
                object = fontArray;
                bl = false;
                bl3 = !Boolean.parseBoolean((String)object);
            }
            if (!bl3) {
                Logger.DefaultImpls.info$default((Logger)logger, null, (Function0)setUpClient.1.INSTANCE, (int)1, null);
                Ref.BooleanRef resp = new Ref.BooleanRef();
                SwingUtilities.invokeAndWait(() -> ProjectorServer.setUpClient$lambda-31(hasWriteAccess, resp, conn));
                if (!resp.element) {
                    Logger.DefaultImpls.info$default((Logger)logger, null, (Function0)setUpClient.3.INSTANCE, (int)1, null);
                    ProjectorServer.setUpClient$sendHandshakeFailureEvent(conn, "Other user has disallowed this connection.");
                    return;
                }
                Logger.DefaultImpls.info$default((Logger)logger, null, (Function0)setUpClient.4.INSTANCE, (int)1, null);
            }
        }
        if (this.isAgent) {
            InetAddress remoteIp = conn.getConfirmationRemoteIp();
            if (ProjectorServer.Companion.isMac() && remoteIp != null && Companion.isLocalAddress(remoteIp)) {
                this.sendMacLocalConnectionWarning(remoteIp);
            }
        }
        object = PFontManager.INSTANCE.getAllInstalledFonts();
        ProtocolType protocolType = toServerDecoder.getProtocolType();
        CompressionType compressionType = toServerDecompressor.getCompressionType();
        ProtocolType protocolType2 = toClientEncoder.getProtocolType();
        CompressionType compressionType2 = toClientCompressor.getCompressionType();
        boolean $i$f$mapNotNull = false;
        void var13_17 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        void var18_25 = $this$forEach$iv$iv$iv;
        int n = ((void)var18_25).length;
        for (int i = 0; i < n; ++i) {
            Short s;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = var18_25[i];
            boolean bl4 = false;
            void font = element$iv$iv;
            boolean bl5 = false;
            if (FontCacher.INSTANCE.getId((Font)font) == null) continue;
            boolean bl6 = false;
            boolean bl7 = false;
            Short it$iv$iv = s;
            boolean bl8 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Collection<FontDataHolder> collection = (List)destination$iv$iv;
        $this$mapNotNull$iv = collection;
        boolean $i$f$map = false;
        $this$mapNotNullTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void fontId;
            short s = ((Number)item$iv$iv).shortValue();
            collection = destination$iv$iv;
            boolean bl9 = false;
            FontDataHolder fontDataHolder = FontCacher.INSTANCE.getFontData((short)fontId);
            collection.add(fontDataHolder);
        }
        collection = (List)destination$iv$iv;
        ServerWindowColorsEvent.ColorsStorage colorsStorage = this.ideaColors.getColors();
        Collection<FontDataHolder> collection2 = collection;
        ProtocolType protocolType3 = protocolType;
        CompressionType compressionType3 = compressionType;
        ProtocolType protocolType4 = protocolType2;
        CompressionType compressionType4 = compressionType2;
        ToClientHandshakeSuccessEvent successEvent = new ToClientHandshakeSuccessEvent(compressionType4, protocolType4, compressionType3, protocolType3, collection2, colorsStorage);
        conn.send(KotlinxJsonToClientHandshakeEncoder.INSTANCE.encode((ToClientHandshakeEvent)successEvent));
        conn.setSettings((ClientSettings)new SetUpClientSettings(supportedHandshakeClientSettings.getConnectionMillis(), supportedHandshakeClientSettings.getAddress(), new SetUpClientData(hasWriteAccess, toClientEncoder, toClientCompressor, toServerDecoder, toServerDecompressor)));
        if (hasWriteAccess) {
            Collection<CompressionType> collection3;
            PGraphicsEnvironment.Companion.setClientDoesWindowManagement(toServerHandshakeEvent.getClientDoesWindowManagement());
            $this$map$iv = toServerHandshakeEvent.getDisplays();
            PGraphicsEnvironment.Companion companion = PGraphicsEnvironment.Companion;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                DisplayDescription fontId = (DisplayDescription)item$iv$iv;
                collection3 = destination$iv$iv;
                boolean bl10 = false;
                compressionType2 = TuplesKt.to((Object)new Rectangle(it.getX(), it.getY(), it.getWidth(), it.getHeight()), (Object)it.getScaleFactor());
                collection3.add(compressionType2);
            }
            collection3 = (List)destination$iv$iv;
            companion.setupDisplays((List)collection3);
            object = toServerHandshakeEvent.getDisplays().get(0);
            bl = false;
            boolean bl11 = false;
            DisplayDescription $this$setUpClient_u24lambda_u2d35 = (DisplayDescription)object;
            boolean bl12 = false;
            ProjectorServer.Companion.resize($this$setUpClient_u24lambda_u2d35.getWidth(), $this$setUpClient_u24lambda_u2d35.getHeight());
        }
        this.clientEventHandler.updateClientsCount();
    }

    private final void sendPictures(List<? extends ServerEvent> dataToSend) {
        Iterable $this$forEach$iv = this.transports;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ServerTransport transport = (ServerTransport)element$iv;
            boolean bl = false;
            transport.forEachOpenedConnection((Function1)new Function1<ClientWrapper, Unit>(dataToSend){
                final /* synthetic */ List<ServerEvent> $dataToSend;
                {
                    this.$dataToSend = $dataToSend;
                    super(1);
                }

                public final void invoke(@NotNull ClientWrapper client) {
                    ReadyClientSettings readyClientSettings;
                    Intrinsics.checkNotNullParameter((Object)client, (String)"client");
                    ClientSettings clientSettings = client.getSettings();
                    ReadyClientSettings readyClientSettings2 = readyClientSettings = clientSettings instanceof ReadyClientSettings ? (ReadyClientSettings)clientSettings : null;
                    if (readyClientSettings == null) {
                        return;
                    }
                    ReadyClientSettings readyClientSettings3 = readyClientSettings;
                    clientSettings = readyClientSettings3.getSetUpClientData();
                    List<ServerEvent> list = this.$dataToSend;
                    boolean bl = false;
                    boolean bl2 = false;
                    ClientSettings $this$invoke_u24lambda_u2d0 = clientSettings;
                    boolean bl3 = false;
                    List requestedData = TransformKt.extractData((Iterable)readyClientSettings3.getRequestedData());
                    List message = SequencesKt.toList((Sequence)readyClientSettings3.getInterestManager().filterEvents(SequencesKt.plus((Sequence)CollectionsKt.asSequence((Iterable)requestedData), (Sequence)CollectionsKt.asSequence((Iterable)list))));
                    if (message.isEmpty()) {
                        return;
                    }
                    byte[] encoded = (byte[])$this$invoke_u24lambda_u2d0.getToClientMessageEncoder().encode((Object)message);
                    byte[] compressed = (byte[])$this$invoke_u24lambda_u2d0.getToClientMessageCompressor().compress((Object)encoded);
                    client.send(compressed);
                }
            });
        }
    }

    private final boolean areChangedWindows(List<WindowData> windowEvents) {
        boolean hasDifferentWindowEvents;
        Set set = CollectionsKt.toSet((Iterable)windowEvents);
        boolean bl = hasDifferentWindowEvents = !Intrinsics.areEqual((Object)set, this.previousWindowEvents);
        if (hasDifferentWindowEvents) {
            this.previousWindowEvents = set;
        }
        return hasDifferentWindowEvents;
    }

    public final void start() {
        this.updateThread = this.createUpdateThread();
        this.caretInfoUpdater.start();
        Iterable $this$forEach$iv = WebsocketServer.INSTANCE.createTransportBuilders$projector_server();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            WsTransportBuilder it = (WsTransportBuilder)element$iv;
            boolean bl = false;
            this.addTransport((ServerTransport)it.attachDefaultServerEventHandlers(this.getClientEventHandler()).build());
        }
    }

    public final void addTransport(@NotNull ServerTransport transport) {
        Intrinsics.checkNotNullParameter((Object)transport, (String)"transport");
        this.transports.add(transport);
        transport.start();
    }

    public final boolean removeTransport(@NotNull ServerTransport transport, int timeoutMs) {
        Intrinsics.checkNotNullParameter((Object)transport, (String)"transport");
        boolean removed = this.transports.remove(transport);
        if (removed) {
            transport.stop(timeoutMs);
        }
        return removed;
    }

    public static /* synthetic */ boolean removeTransport$default(ProjectorServer projectorServer, ServerTransport serverTransport, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return projectorServer.removeTransport(serverTransport, n);
    }

    @JvmOverloads
    public final void stop(int timeout) {
        Iterable $this$forEach$iv = this.transports;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ServerTransport it = (ServerTransport)element$iv;
            boolean bl = false;
            it.stop(timeout);
        }
        this.transports.clear();
        this.caretInfoUpdater.stop();
        if (this.updateThread != null) {
            Thread thread = this.updateThread;
            if (thread == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"updateThread");
                throw null;
            }
            thread.interrupt();
        }
    }

    public static /* synthetic */ void stop$default(ProjectorServer projectorServer, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        projectorServer.stop(n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isStopped() {
        if (this.updateThread == null) return true;
        Thread thread = this.updateThread;
        if (thread == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"updateThread");
            throw null;
        }
        if (thread.getState() != Thread.State.TERMINATED) return false;
        return true;
    }

    @NotNull
    public final String[][] getClientList() {
        boolean bl = false;
        ArrayList<String[]> s = new ArrayList<String[]>();
        Iterable $this$forEach$iv = this.transports;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ServerTransport transport = (ServerTransport)element$iv;
            boolean bl2 = false;
            transport.forEachOpenedConnection((Function1)new Function1<ClientWrapper, Unit>(s){
                final /* synthetic */ ArrayList<String[]> $s;
                {
                    this.$s = $s;
                    super(1);
                }

                public final void invoke(@NotNull ClientWrapper it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    InetAddress remoteAddress = it.getConfirmationRemoteIp();
                    if (remoteAddress != null) {
                        String[] stringArray = new String[]{remoteAddress.getHostAddress(), "resolving ..."};
                        this.$s.add(stringArray);
                    } else {
                        String name = it.getConfirmationRemoteName();
                        String[] stringArray = new String[]{name, name};
                        this.$s.add(stringArray);
                    }
                }
            });
        }
        Iterable $this$distinctBy$iv = s;
        boolean $i$f$distinctBy = false;
        HashSet<String> set$iv = new HashSet<String>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            String[] it = (String[])e$iv;
            boolean bl3 = false;
            String key$iv = it[0];
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        Collection $this$toTypedArray$iv = list$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        T[] TArray = thisCollection$iv.toArray((T[])new String[0][]);
        if (TArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return (String[][])TArray;
    }

    public final void disconnectAll() {
        Iterable $this$forEach$iv = this.transports;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ServerTransport transport = (ServerTransport)element$iv;
            boolean bl = false;
            transport.forEachOpenedConnection((Function1)disconnectAll.1.1.INSTANCE);
        }
    }

    public final void disconnectByIp(@NotNull String ip) {
        Intrinsics.checkNotNullParameter((Object)ip, (String)"ip");
        Iterable $this$forEach$iv = this.transports;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ServerTransport transport = (ServerTransport)element$iv;
            boolean bl = false;
            transport.forEachOpenedConnection((Function1)new Function1<ClientWrapper, Unit>(ip){
                final /* synthetic */ String $ip;
                {
                    this.$ip = $ip;
                    super(1);
                }

                public final void invoke(@NotNull ClientWrapper it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    InetAddress inetAddress = it.getConfirmationRemoteIp();
                    if (Intrinsics.areEqual((Object)(inetAddress == null ? null : inetAddress.getHostAddress()), (Object)this.$ip)) {
                        it.disconnect("The host has disconnected the address: " + this.$ip + ".");
                    }
                }
            });
        }
    }

    @JvmOverloads
    public final void stop() {
        ProjectorServer.stop$default(this, 0, 1, null);
    }

    private static final void processMessage$lambda-10(ClientEvent $message) {
        Intrinsics.checkNotNullParameter((Object)$message, (String)"$message");
        ProjectorServer.Companion.resize(((ClientResizeEvent)$message).getSize().getWidth(), ((ClientResizeEvent)$message).getSize().getHeight());
    }

    /*
     * WARNING - void declaration
     */
    private static final void processMessage$lambda-12(ClientEvent $message) {
        Collection<Pair> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)$message, (String)"$message");
        Iterable iterable = ((ClientDisplaySetChangeEvent)$message).getNewDisplays();
        PGraphicsEnvironment.Companion companion = PGraphicsEnvironment.Companion;
        boolean $i$f$map = false;
        void var3_4 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DisplayDescription displayDescription = (DisplayDescription)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)new Rectangle(it.getX(), it.getY(), it.getWidth(), it.getHeight()), (Object)it.getScaleFactor());
            collection.add(pair);
        }
        collection = (List)destination$iv$iv;
        companion.setupDisplays((List)collection);
    }

    private static final void processMessage$lambda-13(ClientEvent $message, ReadyClientSettings $clientSettings, ProjectorServer this$0) {
        Intrinsics.checkNotNullParameter((Object)$message, (String)"$message");
        Intrinsics.checkNotNullParameter((Object)$clientSettings, (String)"$clientSettings");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        ClientMouseEvent shiftedMessage = ClientEventExtensionsKt.shift((ClientMouseEvent)((ClientMouseEvent)$message), (Point)PGraphicsEnvironment.Companion.getDefaultDevice().getClientShift());
        PMouseInfoPeer.INSTANCE.getLastMouseCoords().setLocation(shiftedMessage.getX(), shiftedMessage.getY());
        Object object = PWindow.Companion.getWindow(((ClientMouseEvent)$message).getWindowId());
        Component window = object == null ? null : object.getTarget();
        PMouseInfoPeer.INSTANCE.setLastWindowUnderMouse(window);
        object = window;
        if (object == null) {
            return;
        }
        ReadyClientSettings.TouchState touchState = MouseKt.calculateNewTouchState((ClientMouseEvent)shiftedMessage, (ClientMouseEvent)((ClientMouseEvent)$message), (ReadyClientSettings.TouchState)$clientSettings.getTouchState());
        if (touchState == null) {
            return;
        }
        ReadyClientSettings.TouchState newTouchState = touchState;
        if (!window.isShowing()) {
            return;
        }
        MouseEvent mouseEvent = MouseKt.createMouseEvent((Component)window, (ClientMouseEvent)shiftedMessage, (ReadyClientSettings.TouchState)$clientSettings.getTouchState(), (ReadyClientSettings.TouchState)newTouchState, (long)$clientSettings.getConnectionMillis());
        $clientSettings.setTouchState(newTouchState);
        this$0.laterInvokator.invoke((AWTEvent)mouseEvent);
    }

    private static final void processMessage$lambda-14(ClientEvent $message, ReadyClientSettings $clientSettings, ProjectorServer this$0) {
        Intrinsics.checkNotNullParameter((Object)$message, (String)"$message");
        Intrinsics.checkNotNullParameter((Object)$clientSettings, (String)"$clientSettings");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        ClientWheelEvent shiftedMessage = ClientEventExtensionsKt.shift((ClientWheelEvent)((ClientWheelEvent)$message), (Point)PGraphicsEnvironment.Companion.getDefaultDevice().getClientShift());
        PMouseInfoPeer.INSTANCE.getLastMouseCoords().setLocation(shiftedMessage.getX(), shiftedMessage.getY());
        Object object = PWindow.Companion.getWindow(((ClientWheelEvent)$message).getWindowId());
        Component window = object == null ? null : object.getTarget();
        PMouseInfoPeer.INSTANCE.setLastWindowUnderMouse(window);
        object = window;
        if (object == null) {
            return;
        }
        MouseWheelEvent mouseWheelEvent = MouseKt.createMouseWheelEvent((Component)window, (ClientWheelEvent)shiftedMessage, (long)$clientSettings.getConnectionMillis());
        this$0.laterInvokator.invoke((AWTEvent)mouseWheelEvent);
    }

    private static final void processMessage$lambda-16$lambda-15(ProjectorServer this$0, KeyEvent $it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$it, (String)"$it");
        this$0.laterInvokator.invoke((AWTEvent)$it);
    }

    private static final void processMessage$lambda-18$lambda-17(ProjectorServer this$0, KeyEvent $it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$it, (String)"$it");
        this$0.laterInvokator.invoke((AWTEvent)$it);
    }

    private static final void processMessage$lambda-19(ProjectorServer this$0, ClientEvent $message, ReadyClientSettings $clientSettings) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$message, (String)"$message");
        Intrinsics.checkNotNullParameter((Object)$clientSettings, (String)"$clientSettings");
        this$0.laterInvokator.invoke((AWTEvent)KeyKt.toAwtKeyEvent((ClientRawKeyEvent)((ClientRawKeyEvent)$message), (long)$clientSettings.getConnectionMillis(), (Component)AwtKt.focusOwnerOrTarget((Component)((PWindow)CollectionsKt.last((List)PWindow.Companion.getWindows())).getTarget())));
    }

    private static final void processMessage$lambda-21(ClientEvent $message) {
        Intrinsics.checkNotNullParameter((Object)$message, (String)"$message");
        PWindow pWindow = PWindow.Companion.getWindow(((ClientWindowMoveEvent)$message).getWindowId());
        if (pWindow != null) {
            PWindow pWindow2 = pWindow;
            boolean bl = false;
            boolean bl2 = false;
            PWindow $this$processMessage_u24lambda_u2d21_u24lambda_u2d20 = pWindow2;
            boolean bl3 = false;
            $this$processMessage_u24lambda_u2d21_u24lambda_u2d20.move(((ClientWindowMoveEvent)$message).getDeltaX(), ((ClientWindowMoveEvent)$message).getDeltaY());
        }
    }

    private static final void processMessage$lambda-23(ClientEvent $message) {
        Intrinsics.checkNotNullParameter((Object)$message, (String)"$message");
        PWindow pWindow = PWindow.Companion.getWindow(((ClientWindowResizeEvent)$message).getWindowId());
        if (pWindow != null) {
            PWindow pWindow2 = pWindow;
            boolean bl = false;
            boolean bl2 = false;
            PWindow $this$processMessage_u24lambda_u2d23_u24lambda_u2d22 = pWindow2;
            boolean bl3 = false;
            $this$processMessage_u24lambda_u2d23_u24lambda_u2d22.resize(((ClientWindowResizeEvent)$message).getDeltaX(), ((ClientWindowResizeEvent)$message).getDeltaY(), ConvertKt.toDirection(((ClientWindowResizeEvent)$message).getDirection()));
        }
    }

    private static final void processMessage$lambda-26(ClientEvent $message) {
        Intrinsics.checkNotNullParameter((Object)$message, (String)"$message");
        PWindow pWindow = PWindow.Companion.getWindow(((ClientWindowSetBoundsEvent)$message).getWindowId());
        if (pWindow != null) {
            PWindow pWindow2 = pWindow;
            boolean bl = false;
            boolean bl2 = false;
            PWindow $this$processMessage_u24lambda_u2d26_u24lambda_u2d25 = pWindow2;
            boolean bl3 = false;
            CommonIntRectangle commonIntRectangle = ((ClientWindowSetBoundsEvent)$message).getBounds();
            boolean bl4 = false;
            boolean bl5 = false;
            CommonIntRectangle $this$processMessage_u24lambda_u2d26_u24lambda_u2d25_u24lambda_u2d24 = commonIntRectangle;
            boolean bl6 = false;
            $this$processMessage_u24lambda_u2d26_u24lambda_u2d25.setBounds($this$processMessage_u24lambda_u2d26_u24lambda_u2d25_u24lambda_u2d24.getX(), $this$processMessage_u24lambda_u2d26_u24lambda_u2d25_u24lambda_u2d24.getY(), $this$processMessage_u24lambda_u2d26_u24lambda_u2d25_u24lambda_u2d24.getWidth(), $this$processMessage_u24lambda_u2d26_u24lambda_u2d25_u24lambda_u2d24.getHeight());
        }
    }

    private static final void processMessage$lambda-27(ClientEvent $message) {
        Intrinsics.checkNotNullParameter((Object)$message, (String)"$message");
        PWindow pWindow = PWindow.Companion.getWindow(((ClientWindowCloseEvent)$message).getWindowId());
        if (pWindow != null) {
            pWindow.close();
        }
    }

    private static final void processMessage$lambda-28(ReadyClientSettings $clientSettings, ClientEvent $message) {
        Intrinsics.checkNotNullParameter((Object)$clientSettings, (String)"$clientSettings");
        Intrinsics.checkNotNullParameter((Object)$message, (String)"$message");
        $clientSettings.getInterestManager().processClientEvent((ClientWindowInterestEvent)$message);
    }

    private static final void setUpClient$sendHandshakeFailureEvent(ClientWrapper $conn, String reason) {
        ToClientHandshakeFailureEvent failureEvent = new ToClientHandshakeFailureEvent(reason);
        $conn.send(KotlinxJsonToClientHandshakeEncoder.INSTANCE.encode((ToClientHandshakeEvent)failureEvent));
    }

    /*
     * WARNING - void declaration
     */
    private static final void setUpClient$lambda-31(boolean $hasWriteAccess, Ref.BooleanRef $resp, ClientWrapper $conn) {
        Boolean bl;
        String string;
        Intrinsics.checkNotNullParameter((Object)$resp, (String)"$resp");
        Intrinsics.checkNotNullParameter((Object)$conn, (String)"$conn");
        boolean bl2 = $hasWriteAccess;
        if (bl2) {
            string = "read-write";
        } else if (!bl2) {
            string = "read-only";
        } else {
            throw new NoWhenBranchMatchedException();
        }
        String accessType = string;
        Ref.BooleanRef booleanRef = $resp;
        InetAddress inetAddress = $conn.getConfirmationRemoteIp();
        if (inetAddress == null) {
            bl = null;
        } else {
            void it;
            InetAddress inetAddress2 = inetAddress;
            boolean bl3 = false;
            boolean bl4 = false;
            InetAddress inetAddress3 = inetAddress2;
            Ref.BooleanRef booleanRef2 = booleanRef;
            boolean bl5 = false;
            Boolean bl6 = ConfirmConnection.Companion.confirm((InetAddress)it, accessType);
            booleanRef = booleanRef2;
            bl = bl6;
        }
        Boolean bl7 = bl;
        booleanRef.element = bl7 == null ? ConfirmConnection.Companion.confirm($conn.getConfirmationRemoteName(), accessType) : bl7.booleanValue();
    }

    public static final boolean isEnabled() {
        return Companion.isEnabled();
    }

    @JvmStatic
    @NotNull
    public static final ProjectorServer startServer(boolean isAgent, @NotNull Runnable initializer) {
        return Companion.startServer(isAgent, initializer);
    }

    public static final /* synthetic */ List access$createDataToSend(ProjectorServer $this) {
        return $this.createDataToSend();
    }

    public static final /* synthetic */ void access$sendPictures(ProjectorServer $this, List dataToSend) {
        $this.sendPictures(dataToSend);
    }

    public /* synthetic */ ProjectorServer(LaterInvokator laterInvokator, boolean isAgent, DefaultConstructorMarker $constructor_marker) {
        this(laterInvokator, isAgent);
    }

    public static final /* synthetic */ ConcurrentLinkedQueue access$getCaretInfoQueue$p(ProjectorServer $this) {
        return $this.caretInfoQueue;
    }

    public static final /* synthetic */ void access$setWindowColorsEvent$p(ProjectorServer $this, ServerWindowColorsEvent serverWindowColorsEvent) {
        $this.windowColorsEvent = serverWindowColorsEvent;
    }

    public static final /* synthetic */ void access$checkHandshakeVersion(ProjectorServer $this, ClientWrapper conn, ConnectedClientSettings connectedClientSettings, String message) {
        $this.checkHandshakeVersion(conn, connectedClientSettings, message);
    }

    public static final /* synthetic */ void access$setUpClient(ProjectorServer $this, ClientWrapper conn, SupportedHandshakeClientSettings supportedHandshakeClientSettings, String message) {
        $this.setUpClient(conn, supportedHandshakeClientSettings, message);
    }

    public static final /* synthetic */ void access$setPreviousWindowEvents$p(ProjectorServer $this, Set set) {
        $this.previousWindowEvents = set;
    }

    public static final /* synthetic */ CaretInfoUpdater access$getCaretInfoUpdater$p(ProjectorServer $this) {
        return $this.caretInfoUpdater;
    }

    public static final /* synthetic */ Set access$getTransports$p(ProjectorServer $this) {
        return $this.transports;
    }

    public static final /* synthetic */ void access$notifyObservers(ProjectorServer $this, PropertyChangeEvent event) {
        $this.notifyObservers(event);
    }

    public static final /* synthetic */ void access$processMessage(ProjectorServer $this, ReadyClientSettings clientSettings, ClientEvent message) {
        $this.processMessage(clientSettings, message);
    }

    static {
        Integer n;
        Companion = new Companion(null);
        boolean $i$f$Logger = false;
        String string = Reflection.getOrCreateKotlinClass(ProjectorServer.class).getSimpleName();
        Intrinsics.checkNotNull((Object)string);
        logger = LoggerKt.Logger((String)string);
        ENABLE_BIG_COLLECTIONS_CHECKS = Intrinsics.areEqual((Object)System.getProperty("org.jetbrains.projector.server.debug.collections.checks"), (Object)"true");
        String string2 = System.getProperty("org.jetbrains.projector.server.debug.collections.checks.size");
        BIG_COLLECTIONS_CHECKS_START_SIZE = string2 == null ? 10000 : ((n = StringsKt.toIntOrNull((String)string2)) == null ? 10000 : n);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010.\u001a\u00020/H\u0002J\r\u00100\u001a\u00020\u001aH\u0000\u00a2\u0006\u0002\b1J\u0006\u00102\u001a\u00020\u0004J\u0013\u00103\u001a\b\u0012\u0004\u0012\u0002040\u0019H\u0000\u00a2\u0006\u0002\b5J\u000e\u00106\u001a\u00020\u000f2\u0006\u00107\u001a\u00020\u001aJ\u0018\u00108\u001a\u00020/2\u0006\u00109\u001a\u00020\u00042\u0006\u0010:\u001a\u00020\u0004H\u0002J\u0018\u0010;\u001a\u00020'2\u0006\u0010<\u001a\u00020\u000f2\u0006\u0010=\u001a\u00020>H\u0007J\u0010\u0010?\u001a\u00020/2\u0006\u0010@\u001a\u00020AH\u0002J\u000e\u0010B\u001a\u0004\u0018\u00010C*\u00020DH\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\"\u0010\u0018\u001a\u0010\u0012\f\u0012\n \u001b*\u0004\u0018\u00010\u001a0\u001a0\u00198BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u000e\u0010\u001e\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000R\u001a\u0010#\u001a\u00020\u000f8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b$\u0010\u0002\u001a\u0004\b#\u0010\u0011R\u0014\u0010%\u001a\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u0011R(\u0010(\u001a\u0004\u0018\u00010'2\b\u0010&\u001a\u0004\u0018\u00010'@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u0012\u0004\b)\u0010\u0002\u001a\u0004\b*\u0010+R\u000e\u0010,\u001a\u00020-X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006E"}, d2={"Lorg/jetbrains/projector/server/ProjectorServer$Companion;", "", "()V", "BIG_COLLECTIONS_CHECKS_START_SIZE", "", "getBIG_COLLECTIONS_CHECKS_START_SIZE", "()I", "setBIG_COLLECTIONS_CHECKS_START_SIZE", "(I)V", "DEFAULT_BIG_COLLECTIONS_CHECKS_SIZE", "DEFAULT_PORT", "", "DISABLE_IDEA_UPDATES_PROPERTY_NAME", "ENABLE_AUTO_KEYMAP_SETTING", "ENABLE_BIG_COLLECTIONS_CHECKS", "", "getENABLE_BIG_COLLECTIONS_CHECKS", "()Z", "setENABLE_BIG_COLLECTIONS_CHECKS", "(Z)V", "ENABLE_CONNECTION_CONFIRMATION", "ENABLE_PROPERTY_NAME", "HOST_PROPERTY_NAME", "HOST_PROPERTY_NAME_OLD", "LOCAL_ADDRESSES", "", "Ljava/net/InetAddress;", "kotlin.jvm.PlatformType", "getLOCAL_ADDRESSES", "()Ljava/util/List;", "MAC_KEYBOARD_MODIFIERS_MODE", "PORT_PROPERTY_NAME", "PORT_PROPERTY_NAME_OLD", "RO_TOKEN_ENV_NAME", "TOKEN_ENV_NAME", "isEnabled", "isEnabled$annotations", "isMac", "<set-?>", "Lorg/jetbrains/projector/server/ProjectorServer;", "lastStartedServer", "getLastStartedServer$annotations", "getLastStartedServer", "()Lorg/jetbrains/projector/server/ProjectorServer;", "logger", "Lorg/jetbrains/projector/util/logging/Logger;", "calculateMainWindowShift", "", "getEnvHost", "getEnvHost$projector_server", "getEnvPort", "getMainWindows", "Lorg/jetbrains/projector/awt/PWindow;", "getMainWindows$projector_server", "isLocalAddress", "address", "resize", "width", "height", "startServer", "isAgent", "initializer", "Ljava/lang/Runnable;", "updateToolkitKeyboardModifiersMode", "keymap", "Lorg/jetbrains/projector/common/protocol/data/UserKeymap;", "toServerClipboardEvent", "Lorg/jetbrains/projector/common/protocol/toClient/ServerClipboardEvent;", "Ljava/awt/datatransfer/Transferable;", "projector-server"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isEnabled() {
            boolean bl;
            String string = System.getProperty(ProjectorServer.ENABLE_PROPERTY_NAME);
            if (string == null) {
                bl = false;
            } else {
                boolean bl2;
                String string2 = string;
                boolean bl3 = false;
                bl = bl2 = Boolean.parseBoolean(string2);
            }
            return bl;
        }

        @JvmStatic
        public static /* synthetic */ void isEnabled$annotations() {
        }

        private final ServerClipboardEvent toServerClipboardEvent(Transferable $this$toServerClipboardEvent) {
            ServerClipboardEvent serverClipboardEvent;
            boolean bl = $this$toServerClipboardEvent.isDataFlavorSupported(DataFlavor.stringFlavor);
            if (!bl) {
                serverClipboardEvent = null;
            } else if (bl) {
                Object object = $this$toServerClipboardEvent.getTransferData(DataFlavor.stringFlavor);
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                }
                ServerClipboardEvent serverClipboardEvent2 = new ServerClipboardEvent((String)object);
                serverClipboardEvent = serverClipboardEvent2;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return serverClipboardEvent;
        }

        private final void updateToolkitKeyboardModifiersMode(UserKeymap keymap) {
            boolean bl;
            UserKeymap userKeymap = keymap;
            int n = WhenMappings.$EnumSwitchMapping$0[userKeymap.ordinal()];
            switch (n) {
                case 1: 
                case 2: {
                    bl = false;
                    break;
                }
                case 3: {
                    bl = true;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            PToolkit.Companion.setMacKeyboardModifiersMode(bl);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<PWindow> getMainWindows$projector_server() {
            List list;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = PWindow.Companion.getWindows();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                PWindow it = (PWindow)element$iv$iv;
                boolean bl = false;
                if (!(ConvertKt.getWindowType(it) == WindowType.IDEA_WINDOW)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List ideWindows = (List)destination$iv$iv;
            Collection collection = ideWindows;
            boolean bl = false;
            if (!collection.isEmpty()) {
                return ideWindows;
            }
            collection = (PWindow)CollectionsKt.firstOrNull((List)PWindow.Companion.getWindows());
            if (collection == null) {
                list = null;
            } else {
                Collection collection2 = collection;
                boolean bl2 = false;
                boolean bl3 = false;
                Collection p0 = collection2;
                boolean bl4 = false;
                list = CollectionsKt.listOf((Object)p0);
            }
            collection = list;
            boolean bl5 = false;
            Collection collection3 = collection;
            if (collection3 == null) {
                collection3 = CollectionsKt.emptyList();
            }
            return collection3;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void calculateMainWindowShift() {
            Component component;
            if (PGraphicsEnvironment.Companion.getClientDoesWindowManagement()) {
                PGraphicsEnvironment.Companion.getDefaultDevice().getClientShift().setLocation(0, 0);
                return;
            }
            PWindow pWindow = (PWindow)CollectionsKt.firstOrNull(this.getMainWindows$projector_server());
            if (pWindow != null && (component = pWindow.getTarget()) != null) {
                Component component2 = component;
                boolean bl = false;
                boolean bl2 = false;
                Component window = component2;
                boolean bl3 = false;
                Object object = window.getTreeLock();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"window.treeLock");
                boolean bl4 = false;
                boolean bl5 = false;
                synchronized (object) {
                    Cloneable it;
                    boolean bl6;
                    boolean bl7;
                    Cloneable cloneable;
                    Cloneable cloneable2;
                    boolean bl8 = false;
                    double x = 0.0;
                    double y = 0.0;
                    if (window instanceof Frame && (cloneable2 = ((Frame)window).getInsets()) != null) {
                        cloneable = cloneable2;
                        bl7 = false;
                        bl6 = false;
                        it = cloneable;
                        boolean bl9 = false;
                        x += (double)((Insets)it).left;
                        y += (double)((Insets)it).top;
                    }
                    if ((cloneable2 = window.getBounds()) != null) {
                        cloneable = cloneable2;
                        bl7 = false;
                        bl6 = false;
                        it = cloneable;
                        boolean bl10 = false;
                        x += (double)it.x;
                        y += (double)it.y;
                    }
                    PGraphicsEnvironment.Companion.getDefaultDevice().getClientShift().setLocation(x, y);
                    Unit unit = Unit.INSTANCE;
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void resize(int width, int height) {
            void $this$mapTo$iv$iv;
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            if (ge instanceof PGraphicsEnvironment) {
                ((PGraphicsEnvironment)ge).setDefaultDeviceSize(width, height);
            }
            this.calculateMainWindowShift();
            if (PGraphicsEnvironment.Companion.getClientDoesWindowManagement()) {
                return;
            }
            Iterable $this$map$iv = this.getMainWindows$projector_server();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                PWindow pWindow = (PWindow)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Component component = p0.getTarget();
                collection.add(component);
            }
            List list = (List)destination$iv$iv;
            boolean bl = false;
            boolean bl2 = false;
            List mainWindows = list;
            boolean bl3 = false;
            SwingUtilities.invokeLater(() -> Companion.resize$lambda-9$lambda-8(mainWindows, width, height));
        }

        @JvmStatic
        @NotNull
        public final ProjectorServer startServer(boolean isAgent, @NotNull Runnable initializer) {
            boolean bl;
            Object object;
            Intrinsics.checkNotNullParameter((Object)initializer, (String)"initializer");
            LoggerKt.setLoggerFactory((Function1)startServer.1.INSTANCE);
            ProjectorAwtInitializer.INSTANCE.initProjectorAwt();
            initializer.run();
            IjInjectorAgentInitializer.INSTANCE.init(isAgent);
            ProjectorAwtInitializer.INSTANCE.initDefaults();
            SettingsInitializer.INSTANCE.addTaskToInitializeIdea(PGraphics2D.Companion.getDefaultAa());
            if (!isAgent) {
                object = PropertyKt.getOption((String)ProjectorServer.DISABLE_IDEA_UPDATES_PROPERTY_NAME, (String)"true");
                bl = false;
                if (Boolean.parseBoolean((String)object)) {
                    UpdatesConfigKt.forbidUpdates();
                }
            }
            if (this.getENABLE_BIG_COLLECTIONS_CHECKS()) {
                Logger.DefaultImpls.info$default((Logger)logger, null, (Function0)startServer.2.INSTANCE, (int)1, null);
            }
            object = new ProjectorServer(LaterInvokator.Companion.getDefaultLaterInvokator(), isAgent, null);
            bl = false;
            boolean bl2 = false;
            Object it = object;
            boolean bl3 = false;
            lastStartedServer = (ProjectorServer)it;
            ((ProjectorServer)it).start();
            return object;
        }

        @Nullable
        public final ProjectorServer getLastStartedServer() {
            return lastStartedServer;
        }

        public static /* synthetic */ void getLastStartedServer$annotations() {
        }

        public final boolean getENABLE_BIG_COLLECTIONS_CHECKS() {
            return ENABLE_BIG_COLLECTIONS_CHECKS;
        }

        public final void setENABLE_BIG_COLLECTIONS_CHECKS(boolean bl) {
            ENABLE_BIG_COLLECTIONS_CHECKS = bl;
        }

        public final int getBIG_COLLECTIONS_CHECKS_START_SIZE() {
            return BIG_COLLECTIONS_CHECKS_START_SIZE;
        }

        public final void setBIG_COLLECTIONS_CHECKS_START_SIZE(int n) {
            BIG_COLLECTIONS_CHECKS_START_SIZE = n;
        }

        @NotNull
        public final InetAddress getEnvHost$projector_server() {
            Object object;
            String host;
            Object object2 = PropertyKt.getOption((String)ProjectorServer.HOST_PROPERTY_NAME);
            String string = host = object2 == null ? PropertyKt.getOption((String)ProjectorServer.HOST_PROPERTY_NAME_OLD) : object2;
            if (host != null) {
                object2 = InetAddress.getByName(host);
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"getByName(host)");
                object = object2;
            } else {
                object = HostAddressKt.getWildcardHostAddress();
            }
            return object;
        }

        public final int getEnvPort() {
            String string = PropertyKt.getOption((String)ProjectorServer.PORT_PROPERTY_NAME);
            string = string == null ? PropertyKt.getOption((String)ProjectorServer.PORT_PROPERTY_NAME_OLD, (String)ProjectorServer.DEFAULT_PORT) : string;
            boolean bl = false;
            return Integer.parseInt(string);
        }

        /*
         * WARNING - void declaration
         */
        private final List<InetAddress> getLOCAL_ADDRESSES() {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = NetworkKt.getLocalAddresses(true);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                InterfaceAddress interfaceAddress = (InterfaceAddress)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                InetAddress inetAddress = it.getAddress();
                collection.add(inetAddress);
            }
            return (List)destination$iv$iv;
        }

        public final boolean isLocalAddress(@NotNull InetAddress address) {
            Intrinsics.checkNotNullParameter((Object)address, (String)"address");
            return this.getLOCAL_ADDRESSES().contains(address);
        }

        private final boolean isMac() {
            String string = System.getProperty("os.name");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(\"os.name\")");
            return StringsKt.startsWith$default((String)string, (String)"Mac OS", (boolean)false, (int)2, null);
        }

        private static final void resize$lambda-9$lambda-8(List $mainWindows, int $width, int $height) {
            Intrinsics.checkNotNullParameter((Object)$mainWindows, (String)"$mainWindows");
            Iterable $this$forEach$iv = $mainWindows;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Component it = (Component)element$iv;
                boolean bl = false;
                Point point = new Point(PGraphicsEnvironment.Companion.getDefaultDevice().getClientShift());
                int widthWithInsets = 0;
                widthWithInsets = $width;
                int heightWithInsets = 0;
                heightWithInsets = $height;
                if (it instanceof Frame) {
                    Insets insets = ((Frame)it).getInsets();
                    if (insets != null) {
                        Insets insets2 = insets;
                        boolean bl2 = false;
                        boolean bl3 = false;
                        Insets i = insets2;
                        boolean bl4 = false;
                        Point point2 = point;
                        point2.x -= i.left;
                        point2 = point;
                        point2.y -= i.top;
                        widthWithInsets += i.left + i.right;
                        heightWithInsets += i.top + i.bottom;
                    }
                    ((Frame)it).setExtendedState(0);
                }
                it.setBounds(point.x, point.y, widthWithInsets, heightWithInsets);
                it.revalidate();
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 5, 1}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[UserKeymap.values().length];
                nArray[UserKeymap.WINDOWS.ordinal()] = 1;
                nArray[UserKeymap.LINUX.ordinal()] = 2;
                nArray[UserKeymap.MAC.ordinal()] = 3;
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

