/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.projector.server.service;

import java.awt.Composite;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.TextAttribute;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.projector.awt.data.AwtImageInfo;
import org.jetbrains.projector.awt.data.AwtPaintType;
import org.jetbrains.projector.awt.service.DrawEventQueue;
import org.jetbrains.projector.common.protocol.data.ImageId;
import org.jetbrains.projector.common.protocol.data.Point;
import org.jetbrains.projector.common.protocol.toClient.ServerCopyAreaEvent;
import org.jetbrains.projector.common.protocol.toClient.ServerDrawCommandsEvent;
import org.jetbrains.projector.common.protocol.toClient.ServerDrawImageEvent;
import org.jetbrains.projector.common.protocol.toClient.ServerDrawLineEvent;
import org.jetbrains.projector.common.protocol.toClient.ServerDrawPolylineEvent;
import org.jetbrains.projector.common.protocol.toClient.ServerDrawRenderableImageEvent;
import org.jetbrains.projector.common.protocol.toClient.ServerDrawRenderedImageEvent;
import org.jetbrains.projector.common.protocol.toClient.ServerDrawStringEvent;
import org.jetbrains.projector.common.protocol.toClient.ServerPaintArcEvent;
import org.jetbrains.projector.common.protocol.toClient.ServerPaintOvalEvent;
import org.jetbrains.projector.common.protocol.toClient.ServerPaintPathEvent;
import org.jetbrains.projector.common.protocol.toClient.ServerPaintPolygonEvent;
import org.jetbrains.projector.common.protocol.toClient.ServerPaintRectEvent;
import org.jetbrains.projector.common.protocol.toClient.ServerPaintRoundRectEvent;
import org.jetbrains.projector.common.protocol.toClient.ServerSetCompositeEvent;
import org.jetbrains.projector.common.protocol.toClient.ServerSetFontEvent;
import org.jetbrains.projector.common.protocol.toClient.ServerSetPaintEvent;
import org.jetbrains.projector.common.protocol.toClient.ServerSetTransformEvent;
import org.jetbrains.projector.common.protocol.toClient.ServerWindowEvent;
import org.jetbrains.projector.server.ProjectorServer;
import org.jetbrains.projector.server.core.convert.toClient.ConvertKt;
import org.jetbrains.projector.server.core.util.SizeAware;
import org.jetbrains.projector.server.service.ProjectorDrawEventQueue;
import org.jetbrains.projector.server.util.FontCacher;
import org.jetbrains.projector.util.logging.LoggerKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00122\u00020\u0001:\u0002\u0011\u0012B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000f\u001a\u00020\u0010H\u0016R'\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u00068FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/projector/server/service/ProjectorDrawEventQueue;", "Lorg/jetbrains/projector/awt/service/DrawEventQueue;", "target", "Lorg/jetbrains/projector/common/protocol/toClient/ServerDrawCommandsEvent$Target;", "(Lorg/jetbrains/projector/common/protocol/toClient/ServerDrawCommandsEvent$Target;)V", "commands", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "", "Lorg/jetbrains/projector/common/protocol/toClient/ServerWindowEvent;", "getCommands", "()Ljava/util/concurrent/ConcurrentLinkedQueue;", "commands$delegate", "Lorg/jetbrains/projector/server/core/util/SizeAware;", "getTarget", "()Lorg/jetbrains/projector/common/protocol/toClient/ServerDrawCommandsEvent$Target;", "buildCommand", "Lorg/jetbrains/projector/awt/service/DrawEventQueue$CommandBuilder;", "CommandBuilder", "Companion", "projector-server"})
public final class ProjectorDrawEventQueue
implements DrawEventQueue {
    @NotNull
    public static final Companion Companion;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final ServerDrawCommandsEvent.Target target;
    @NotNull
    private final SizeAware commands$delegate;
    @NotNull
    private static final Set<SoftReference<ProjectorDrawEventQueue>> livingQueues;

    private ProjectorDrawEventQueue(ServerDrawCommandsEvent.Target target) {
        this.target = target;
        Collection collection = new ConcurrentLinkedQueue();
        Integer n = ProjectorServer.Companion.getENABLE_BIG_COLLECTIONS_CHECKS() ? Integer.valueOf(ProjectorServer.Companion.getBIG_COLLECTIONS_CHECKS_START_SIZE()) : null;
        String string = Reflection.getOrCreateKotlinClass(ProjectorDrawEventQueue.class).getSimpleName();
        Intrinsics.checkNotNull((Object)string);
        this.commands$delegate = new SizeAware(collection, n, LoggerKt.Logger((String)(string + " - " + this.target)));
    }

    @NotNull
    public final ServerDrawCommandsEvent.Target getTarget() {
        return this.target;
    }

    @NotNull
    public final ConcurrentLinkedQueue<List<ServerWindowEvent>> getCommands() {
        return (ConcurrentLinkedQueue)this.commands$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    @NotNull
    public DrawEventQueue.CommandBuilder buildCommand() {
        return new CommandBuilder();
    }

    public /* synthetic */ ProjectorDrawEventQueue(ServerDrawCommandsEvent.Target target, DefaultConstructorMarker $constructor_marker) {
        this(target);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(ProjectorDrawEventQueue.class), "commands", "getCommands()Ljava/util/concurrent/ConcurrentLinkedQueue;")))};
        $$delegatedProperties = kPropertyArray;
        Companion = new Companion(null);
        boolean bl = false;
        livingQueues = new LinkedHashSet();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0006\u001a\u00020\u0007H\u0002J8\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\nH\u0016J\u0018\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J(\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\nH\u0016J\"\u0010\u001a\u001a\u00020\u00072\u0018\u0010\u001b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u001d0\u001cH\u0016J\b\u0010\u001e\u001a\u00020\u0007H\u0016J\b\u0010\u001f\u001a\u00020\u0007H\u0016J(\u0010 \u001a\u00020\u00072\u0006\u0010!\u001a\u00020\"2\u0006\u0010\t\u001a\u00020#2\u0006\u0010\u000b\u001a\u00020#2\u0006\u0010$\u001a\u00020#H\u0016J@\u0010%\u001a\u00020\u00072\u0006\u0010&\u001a\u00020'2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010(\u001a\u00020\n2\u0006\u0010)\u001a\u00020\nH\u0016J0\u0010*\u001a\u00020\u00072\u0006\u0010&\u001a\u00020'2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\nH\u0016J\u0018\u0010+\u001a\u00020\u00072\u0006\u0010&\u001a\u00020'2\u0006\u0010,\u001a\u00020-H\u0016J*\u0010.\u001a\u00020\u00072\u0006\u0010&\u001a\u00020'2\u0018\u0010\u001b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u001d0\u001cH\u0016J0\u0010/\u001a\u00020\u00072\u0006\u0010&\u001a\u00020'2\u0006\u0010\t\u001a\u00020#2\u0006\u0010\u000b\u001a\u00020#2\u0006\u0010\f\u001a\u00020#2\u0006\u0010\r\u001a\u00020#H\u0016J@\u00100\u001a\u00020\u00072\u0006\u0010&\u001a\u00020'2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\n2\u0006\u00101\u001a\u00020\n2\u0006\u00102\u001a\u00020\nH\u0016J\u0012\u00103\u001a\u00020\u00012\b\u00104\u001a\u0004\u0018\u00010-H\u0016J\u0010\u00105\u001a\u00020\u00012\u0006\u00106\u001a\u000207H\u0016J\u0010\u00108\u001a\u00020\u00012\u0006\u00109\u001a\u00020:H\u0016J\u0010\u0010;\u001a\u00020\u00012\u0006\u0010<\u001a\u00020=H\u0016J\u0010\u0010>\u001a\u00020\u00012\u0006\u0010?\u001a\u00020@H\u0016J\u0016\u0010A\u001a\u00020\u00012\f\u0010B\u001a\b\u0012\u0004\u0012\u00020#0\u001cH\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006C"}, d2={"Lorg/jetbrains/projector/server/service/ProjectorDrawEventQueue$CommandBuilder;", "Lorg/jetbrains/projector/awt/service/DrawEventQueue$CommandBuilder;", "(Lorg/jetbrains/projector/server/service/ProjectorDrawEventQueue;)V", "events", "", "Lorg/jetbrains/projector/common/protocol/toClient/ServerWindowEvent;", "build", "", "copyArea", "x", "", "y", "width", "height", "dx", "dy", "drawImage", "imageId", "", "awtImageInfo", "Lorg/jetbrains/projector/awt/data/AwtImageInfo;", "drawLine", "x1", "y1", "x2", "y2", "drawPolyline", "points", "", "Lkotlin/Pair;", "drawRenderableImage", "drawRenderedImage", "drawString", "string", "", "", "desiredWidth", "paintArc", "paintType", "Lorg/jetbrains/projector/awt/data/AwtPaintType;", "startAngle", "arcAngle", "paintOval", "paintPath", "path", "Ljava/awt/Shape;", "paintPolygon", "paintRect", "paintRoundRect", "arcWidth", "arcHeight", "setClip", "identitySpaceClip", "setComposite", "composite", "Ljava/awt/Composite;", "setFont", "font", "Ljava/awt/Font;", "setPaint", "paint", "Ljava/awt/Paint;", "setStroke", "stroke", "Ljava/awt/Stroke;", "setTransform", "tx", "projector-server"})
    private final class CommandBuilder
    implements DrawEventQueue.CommandBuilder {
        @NotNull
        private final List<ServerWindowEvent> events;

        public CommandBuilder() {
            Intrinsics.checkNotNullParameter((Object)ProjectorDrawEventQueue.this, (String)"this$0");
            boolean bl = false;
            this.events = new ArrayList();
        }

        @NotNull
        public DrawEventQueue.CommandBuilder setClip(@Nullable Shape identitySpaceClip) {
            this.events.add((ServerWindowEvent)ConvertKt.createSetClipEvent((Shape)identitySpaceClip));
            return this;
        }

        @NotNull
        public DrawEventQueue.CommandBuilder setTransform(@NotNull List<Double> tx) {
            Intrinsics.checkNotNullParameter(tx, (String)"tx");
            this.events.add((ServerWindowEvent)new ServerSetTransformEvent(tx));
            return this;
        }

        @NotNull
        public DrawEventQueue.CommandBuilder setStroke(@NotNull Stroke stroke) {
            Intrinsics.checkNotNullParameter((Object)stroke, (String)"stroke");
            this.events.add((ServerWindowEvent)ConvertKt.toSetStrokeEvent((Stroke)stroke));
            return this;
        }

        @NotNull
        public DrawEventQueue.CommandBuilder setPaint(@NotNull Paint paint) {
            Intrinsics.checkNotNullParameter((Object)paint, (String)"paint");
            this.events.add((ServerWindowEvent)new ServerSetPaintEvent(ConvertKt.toPaintValue((Paint)paint)));
            return this;
        }

        @NotNull
        public DrawEventQueue.CommandBuilder setComposite(@NotNull Composite composite) {
            Intrinsics.checkNotNullParameter((Object)composite, (String)"composite");
            this.events.add((ServerWindowEvent)new ServerSetCompositeEvent(ConvertKt.toCommonComposite((Composite)composite)));
            return this;
        }

        @NotNull
        public DrawEventQueue.CommandBuilder setFont(@NotNull Font font) {
            Intrinsics.checkNotNullParameter((Object)font, (String)"font");
            Integer n = (Integer)font.getAttributes().get(TextAttribute.LIGATURES);
            this.events.add((ServerWindowEvent)new ServerSetFontEvent(FontCacher.INSTANCE.getId(font), font.getSize(), (n == null ? 0 : n) > 0));
            return this;
        }

        private final void build() {
            ProjectorDrawEventQueue.this.getCommands().add(this.events);
        }

        public void drawRenderedImage() {
            this.events.add((ServerWindowEvent)ServerDrawRenderedImageEvent.INSTANCE);
            this.build();
        }

        public void drawRenderableImage() {
            this.events.add((ServerWindowEvent)ServerDrawRenderableImageEvent.INSTANCE);
            this.build();
        }

        public void drawString(@NotNull String string, double x, double y, double desiredWidth) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"string");
            this.events.add((ServerWindowEvent)new ServerDrawStringEvent(string, x, y, desiredWidth));
            this.build();
        }

        public void copyArea(int x, int y, int width, int height, int dx, int dy) {
            this.events.add((ServerWindowEvent)new ServerCopyAreaEvent(x, y, width, height, dx, dy));
            this.build();
        }

        public void drawLine(int x1, int y1, int x2, int y2) {
            this.events.add((ServerWindowEvent)new ServerDrawLineEvent(x1, y1, x2, y2));
            this.build();
        }

        public void paintRect(@NotNull AwtPaintType paintType, double x, double y, double width, double height) {
            Intrinsics.checkNotNullParameter((Object)paintType, (String)"paintType");
            this.events.add((ServerWindowEvent)new ServerPaintRectEvent(org.jetbrains.projector.server.util.ConvertKt.toPaintType(paintType), x, y, width, height));
            this.build();
        }

        public void paintRoundRect(@NotNull AwtPaintType paintType, int x, int y, int width, int height, int arcWidth, int arcHeight) {
            Intrinsics.checkNotNullParameter((Object)paintType, (String)"paintType");
            this.events.add((ServerWindowEvent)new ServerPaintRoundRectEvent(org.jetbrains.projector.server.util.ConvertKt.toPaintType(paintType), x, y, width, height, arcWidth, arcHeight));
            this.build();
        }

        public void paintOval(@NotNull AwtPaintType paintType, int x, int y, int width, int height) {
            Intrinsics.checkNotNullParameter((Object)paintType, (String)"paintType");
            this.events.add((ServerWindowEvent)new ServerPaintOvalEvent(org.jetbrains.projector.server.util.ConvertKt.toPaintType(paintType), x, y, width, height));
            this.build();
        }

        public void paintArc(@NotNull AwtPaintType paintType, int x, int y, int width, int height, int startAngle, int arcAngle) {
            Intrinsics.checkNotNullParameter((Object)paintType, (String)"paintType");
            this.events.add((ServerWindowEvent)new ServerPaintArcEvent(org.jetbrains.projector.server.util.ConvertKt.toPaintType(paintType), x, y, width, height, startAngle, arcAngle));
            this.build();
        }

        public void drawPolyline(@NotNull List<Pair<Integer, Integer>> points2) {
            Intrinsics.checkNotNullParameter(points2, (String)"points");
            this.events.add((ServerWindowEvent)new ServerDrawPolylineEvent(Companion.toPoints(points2)));
            this.build();
        }

        public void paintPolygon(@NotNull AwtPaintType paintType, @NotNull List<Pair<Integer, Integer>> points2) {
            Intrinsics.checkNotNullParameter((Object)paintType, (String)"paintType");
            Intrinsics.checkNotNullParameter(points2, (String)"points");
            this.events.add((ServerWindowEvent)new ServerPaintPolygonEvent(org.jetbrains.projector.server.util.ConvertKt.toPaintType(paintType), Companion.toPoints(points2)));
            this.build();
        }

        public void drawImage(@NotNull Object imageId, @NotNull AwtImageInfo awtImageInfo) {
            Intrinsics.checkNotNullParameter((Object)imageId, (String)"imageId");
            Intrinsics.checkNotNullParameter((Object)awtImageInfo, (String)"awtImageInfo");
            boolean bl = imageId instanceof ImageId;
            boolean bl2 = false;
            boolean bl3 = false;
            bl3 = false;
            boolean bl4 = false;
            if (!bl) {
                boolean bl5 = false;
                String string = "Failed requirement.";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            this.events.add((ServerWindowEvent)new ServerDrawImageEvent((ImageId)imageId, org.jetbrains.projector.server.util.ConvertKt.toImageEventInfo(awtImageInfo)));
            this.build();
        }

        public void paintPath(@NotNull AwtPaintType paintType, @NotNull Shape path) {
            Intrinsics.checkNotNullParameter((Object)paintType, (String)"paintType");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            this.events.add((ServerWindowEvent)new ServerPaintPathEvent(org.jetbrains.projector.server.util.ConvertKt.toPaintType(paintType), ConvertKt.toCommonPath((Shape)path)));
            this.build();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\bH\u0002J\u000e\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bJ\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\rJ$\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\r*\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00110\u00100\rH\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/projector/server/service/ProjectorDrawEventQueue$Companion;", "", "()V", "livingQueues", "", "Ljava/lang/ref/SoftReference;", "Lorg/jetbrains/projector/server/service/ProjectorDrawEventQueue;", "collectGarbage", "", "create", "target", "Lorg/jetbrains/projector/common/protocol/toClient/ServerDrawCommandsEvent$Target;", "getQueues", "", "toPoints", "Lorg/jetbrains/projector/common/protocol/data/Point;", "Lkotlin/Pair;", "", "projector-server"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        private final List<Point> toPoints(List<Pair<Integer, Integer>> $this$toPoints) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = $this$toPoints;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void $dstr$x$y;
                Pair pair = (Pair)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                int x = ((Number)$dstr$x$y.component1()).intValue();
                int y = ((Number)$dstr$x$y.component2()).intValue();
                Point point = new Point((double)x, (double)y);
                collection.add(point);
            }
            return (List)destination$iv$iv;
        }

        @NotNull
        public final ProjectorDrawEventQueue create(@NotNull ServerDrawCommandsEvent.Target target) {
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            ProjectorDrawEventQueue newQueue = new ProjectorDrawEventQueue(target, null);
            livingQueues.add(new SoftReference<ProjectorDrawEventQueue>(newQueue));
            return newQueue;
        }

        private final void collectGarbage() {
            CollectionsKt.removeAll((Iterable)livingQueues, (Function1)collectGarbage.1.INSTANCE);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<ProjectorDrawEventQueue> getQueues() {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = livingQueues;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object t;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                SoftReference p0 = (SoftReference)element$iv$iv;
                boolean bl2 = false;
                if (p0.get() == null) continue;
                boolean bl3 = false;
                boolean bl4 = false;
                Object it$iv$iv = t;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List result = (List)destination$iv$iv;
            this.collectGarbage();
            return result;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

