/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.projector.server.util;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.concurrent.ThreadsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.projector.server.core.util.HostNameKt;
import org.jetbrains.projector.server.util.AsyncHostResolver;
import org.jetbrains.projector.server.util.Host;
import org.jetbrains.projector.server.util.NetworkKt;
import org.jetbrains.projector.server.util.ResolvedHostSubscriber;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0010$\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u0018B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000bH\u0002J\u0006\u0010\u000f\u001a\u00020\rJ\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0011\u001a\u00020\u0005H\u0002J\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u0005J\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0007J\b\u0010\u0017\u001a\u00020\rH\u0002RN\u0010\u0003\u001aB\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00070\u0007 \u0006* \u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00070\u0007\u0018\u00010\b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/projector/server/util/AsyncHostResolver;", "", "()V", "address2Name", "", "Ljava/net/InetAddress;", "kotlin.jvm.PlatformType", "", "", "queue", "", "Lorg/jetbrains/projector/server/util/AsyncHostResolver$Request;", "addRequest", "", "req", "cancelPendingRequests", "getName", "ip", "resolve", "Lorg/jetbrains/projector/server/util/Host;", "client", "Lorg/jetbrains/projector/server/util/ResolvedHostSubscriber;", "address", "runWorker", "Request", "projector-server"})
public final class AsyncHostResolver {
    private final Map<InetAddress, String> address2Name = Collections.synchronizedMap(new HashMap());
    @NotNull
    private final List<Request> queue;

    public AsyncHostResolver() {
        List list = Collections.synchronizedList(new ArrayList());
        Intrinsics.checkNotNullExpressionValue(list, (String)"synchronizedList(ArrayList<Request>())");
        this.queue = list;
    }

    public final void cancelPendingRequests() {
        this.queue.clear();
    }

    @NotNull
    public final Host resolve(@NotNull ResolvedHostSubscriber client, @NotNull String address) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        byte[] addr = NetworkKt.ipString2Bytes(address);
        InetAddress ip = InetAddress.getByAddress(null, addr);
        Intrinsics.checkNotNullExpressionValue((Object)ip, (String)"ip");
        return this.resolve(client, ip);
    }

    @NotNull
    public final Host resolve(@NotNull ResolvedHostSubscriber client, @NotNull InetAddress ip) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)ip, (String)"ip");
        String name = this.getName(ip);
        if (name == null) {
            this.addRequest(new Request(client, ip));
        }
        return new Host(ip, name);
    }

    private final String getName(InetAddress ip) {
        return this.address2Name.get(ip);
    }

    private final void addRequest(Request req) {
        this.queue.add(req);
        this.runWorker();
    }

    private final void runWorker() {
        ThreadsKt.thread$default((boolean)false, (boolean)false, null, null, (int)0, (Function0)((Function0)new Function0<Unit>(this){
            final /* synthetic */ AsyncHostResolver this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke() {
                while (true) {
                    Collection collection = AsyncHostResolver.access$getQueue$p(this.this$0);
                    boolean bl = false;
                    if (!(!collection.isEmpty())) break;
                    Object item = null;
                    Object object = AsyncHostResolver.access$getQueue$p(this.this$0);
                    Object object2 = this.this$0;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    synchronized (object) {
                        Request request;
                        boolean bl4 = false;
                        item = CollectionsKt.firstOrNull((List)AsyncHostResolver.access$getQueue$p((AsyncHostResolver)object2));
                        Request request2 = (Request)item;
                        if (request2 == null) {
                            request = null;
                        } else {
                            Request request3 = request2;
                            boolean bl5 = false;
                            boolean bl6 = false;
                            Request it = request3;
                            boolean bl7 = false;
                            request = (Request)AsyncHostResolver.access$getQueue$p((AsyncHostResolver)object2).remove(0);
                        }
                        Request request4 = request;
                    }
                    object = (Request)item;
                    if (object == null) continue;
                    object2 = object;
                    AsyncHostResolver asyncHostResolver = this.this$0;
                    boolean bl8 = false;
                    boolean bl9 = false;
                    Object req = object2;
                    boolean bl10 = false;
                    String string = AsyncHostResolver.access$getName(asyncHostResolver, ((Request)req).getIp());
                    String res = string == null ? HostNameKt.getHostName((InetAddress)((Request)req).getIp()) : string;
                    string = res;
                    if (string == null) continue;
                    String string2 = string;
                    boolean bl11 = false;
                    boolean bl12 = false;
                    String name = string2;
                    boolean bl13 = false;
                    Map map = AsyncHostResolver.access$getAddress2Name$p(asyncHostResolver);
                    Intrinsics.checkNotNullExpressionValue((Object)map, (String)"address2Name");
                    InetAddress inetAddress = ((Request)req).getIp();
                    boolean bl14 = false;
                    map.put(inetAddress, name);
                    SwingUtilities.invokeLater(() -> runWorker.1.invoke$lambda-4$lambda-3$lambda-2((Request)req, name));
                }
            }

            private static final void invoke$lambda-4$lambda-3$lambda-2(Request $req, String $name) {
                Intrinsics.checkNotNullParameter((Object)$req, (String)"$req");
                Intrinsics.checkNotNullParameter((Object)$name, (String)"$name");
                $req.getClient().resolved(new Host($req.getIp(), $name));
            }
        }), (int)31, null);
    }

    public static final /* synthetic */ List access$getQueue$p(AsyncHostResolver $this) {
        return $this.queue;
    }

    public static final /* synthetic */ Map access$getAddress2Name$p(AsyncHostResolver $this) {
        return $this.address2Name;
    }

    public static final /* synthetic */ String access$getName(AsyncHostResolver $this, InetAddress ip) {
        return $this.getName(ip);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/projector/server/util/AsyncHostResolver$Request;", "", "client", "Lorg/jetbrains/projector/server/util/ResolvedHostSubscriber;", "ip", "Ljava/net/InetAddress;", "(Lorg/jetbrains/projector/server/util/ResolvedHostSubscriber;Ljava/net/InetAddress;)V", "getClient", "()Lorg/jetbrains/projector/server/util/ResolvedHostSubscriber;", "getIp", "()Ljava/net/InetAddress;", "projector-server"})
    public static final class Request {
        @NotNull
        private final ResolvedHostSubscriber client;
        @NotNull
        private final InetAddress ip;

        public Request(@NotNull ResolvedHostSubscriber client, @NotNull InetAddress ip) {
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            Intrinsics.checkNotNullParameter((Object)ip, (String)"ip");
            this.client = client;
            this.ip = ip;
        }

        @NotNull
        public final ResolvedHostSubscriber getClient() {
            return this.client;
        }

        @NotNull
        public final InetAddress getIp() {
            return this.ip;
        }
    }
}

