/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.projector.server.util;

import java.net.InetAddress;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.projector.server.util.AsyncHostResolver;
import org.jetbrains.projector.server.util.Host;
import org.jetbrains.projector.server.util.ResolvedHostSubscriber;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00122\u00020\u00012\u00020\u0002:\u0001\u0012B\u0019\b\u0016\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u0017\b\u0016\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\tB\u000f\b\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0006H\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\u0011H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/projector/server/util/ConfirmConnection;", "Ljavax/swing/JLabel;", "Lorg/jetbrains/projector/server/util/ResolvedHostSubscriber;", "ip", "Ljava/net/InetAddress;", "accessType", "", "(Ljava/net/InetAddress;Ljava/lang/String;)V", "hostName", "(Ljava/lang/String;Ljava/lang/String;)V", "(Ljava/lang/String;)V", "resolver", "Lorg/jetbrains/projector/server/util/AsyncHostResolver;", "getMessage", "host", "resolved", "", "Lorg/jetbrains/projector/server/util/Host;", "Companion", "projector-server"})
public final class ConfirmConnection
extends JLabel
implements ResolvedHostSubscriber {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String accessType;
    @NotNull
    private final AsyncHostResolver resolver;

    private ConfirmConnection(String accessType) {
        this.accessType = accessType;
        this.resolver = new AsyncHostResolver();
    }

    public ConfirmConnection(@Nullable InetAddress ip, @NotNull String accessType) {
        String string;
        Intrinsics.checkNotNullParameter((Object)accessType, (String)"accessType");
        this(accessType);
        if (ip != null) {
            this.resolver.resolve((ResolvedHostSubscriber)this, ip);
            String string2 = ip.getHostAddress();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"ip.hostAddress");
            string = this.getMessage(string2);
        } else {
            string = this.getMessage("unknown host");
        }
        this.setText(string);
    }

    public ConfirmConnection(@NotNull String hostName, @NotNull String accessType) {
        Intrinsics.checkNotNullParameter((Object)hostName, (String)"hostName");
        Intrinsics.checkNotNullParameter((Object)accessType, (String)"accessType");
        this(accessType);
        this.setText(this.getMessage(hostName));
    }

    private final String getMessage(String host) {
        return "<html>Somebody from " + host + " wants to connect with " + this.accessType + " access. Allow the connection?";
    }

    @Override
    public void resolved(@NotNull Host host) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        this.setText(this.getMessage(host.toString()));
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\bJ\f\u0010\n\u001a\u00020\u0004*\u00020\u000bH\u0002\u00a8\u0006\f"}, d2={"Lorg/jetbrains/projector/server/util/ConfirmConnection$Companion;", "", "()V", "confirm", "", "ip", "Ljava/net/InetAddress;", "accessType", "", "hostName", "doShow", "Lorg/jetbrains/projector/server/util/ConfirmConnection;", "projector-server"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean confirm(@Nullable InetAddress ip, @NotNull String accessType) {
            Intrinsics.checkNotNullParameter((Object)accessType, (String)"accessType");
            return this.doShow(new ConfirmConnection(ip, accessType));
        }

        public final boolean confirm(@NotNull String hostName, @NotNull String accessType) {
            Intrinsics.checkNotNullParameter((Object)hostName, (String)"hostName");
            Intrinsics.checkNotNullParameter((Object)accessType, (String)"accessType");
            return this.doShow(new ConfirmConnection(hostName, accessType));
        }

        private final boolean doShow(ConfirmConnection $this$doShow) {
            return JOptionPane.showConfirmDialog(null, $this$doShow, "New connection", 2) == 0;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

