/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.projector.server.util;

import com.intellij.util.io.IoKt;
import java.net.Inet4Address;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.projector.server.util.NetworkKt;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0017\n\u0000\u001a\u0016\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u001a\u0010\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u0010\u0010\n\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u000e\u0010\u000b\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\t\u001a\u0010\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\tH\u0002\u001a\u0010\u0010\u000e\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\tH\u0002\u001a\f\u0010\u000f\u001a\u00020\u0006*\u00020\u0010H\u0002\u001a\f\u0010\u0011\u001a\u00020\u0001*\u00020\u0012H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"dockerVendor", "", "getLocalAddresses", "", "Ljava/net/InterfaceAddress;", "keepIpv6", "", "ip4String2Bytes", "src", "", "ip6String2Bytes", "ipString2Bytes", "isIp4String", "address", "isIp6String", "isHexDigit", "", "toByteArray", "", "projector-server"})
public final class NetworkKt {
    @NotNull
    private static final byte[] dockerVendor;

    @NotNull
    public static final List<InterfaceAddress> getLocalAddresses(boolean keepIpv6) {
        Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
        Intrinsics.checkNotNullExpressionValue(enumeration, (String)"getNetworkInterfaces()");
        boolean bl = false;
        return SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)SequencesKt.flatMap((Sequence)SequencesKt.filterNot((Sequence)SequencesKt.filterNotNull((Sequence)SequencesKt.asSequence((Iterator)CollectionsKt.iterator(enumeration))), (Function1)getLocalAddresses.1.INSTANCE), (Function1)getLocalAddresses.2.INSTANCE), (Function1)((Function1)new Function1<InterfaceAddress, Boolean>(keepIpv6){
            final /* synthetic */ boolean $keepIpv6;
            {
                this.$keepIpv6 = $keepIpv6;
                super(1);
            }

            public final boolean invoke(@NotNull InterfaceAddress it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return this.$keepIpv6 || it.getAddress() instanceof Inet4Address;
            }
        })));
    }

    public static /* synthetic */ List getLocalAddresses$default(boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return NetworkKt.getLocalAddresses(bl);
    }

    @NotNull
    public static final byte[] ipString2Bytes(@NotNull String src) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        if (NetworkKt.isIp4String(src)) {
            byArray = NetworkKt.ip4String2Bytes(src);
        } else if (NetworkKt.isIp6String(src)) {
            byArray = NetworkKt.ip6String2Bytes(src);
        } else {
            String string = "Invalid ip address string representation: " + src;
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return byArray;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isIp4String(String address) {
        void $this$filterTo$iv$iv;
        char[] cArray = new char[]{'.'};
        Iterable $this$filter$iv = StringsKt.split$default((CharSequence)address, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$filter = false;
        Object object = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            CharSequence charSequence = it;
            boolean bl2 = false;
            boolean bl3 = charSequence.length() > 0;
            if (!bl3) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List parts = (List)destination$iv$iv;
        if (parts.size() != 4) return false;
        CharSequence $this$all$iv = address;
        boolean $i$f$all = false;
        object = $this$all$iv;
        int n = 0;
        while (n < object.length()) {
            char element$iv;
            char it = element$iv = object.charAt(n);
            boolean bl = false;
            char c = it;
            boolean bl4 = false;
            if (!Character.isDigit(c)) {
                if (it != '.') return false;
            }
            boolean bl5 = true;
            if (!bl5) {
                return false;
            }
            ++n;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isHexDigit(char $this$isHexDigit) {
        char c;
        char c2 = $this$isHexDigit;
        boolean bl = false;
        c2 = c = Character.toUpperCase(c2);
        bl = false;
        if (Character.isDigit(c2)) return true;
        if ('A' > c) return false;
        if (c > 'Z') return false;
        return true;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isIp6String(String address) {
        void $this$filterTo$iv$iv;
        char[] cArray = new char[]{':'};
        Iterable $this$filter$iv = StringsKt.split$default((CharSequence)address, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$filter = false;
        Object object = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            CharSequence charSequence = it;
            boolean bl2 = false;
            boolean bl3 = charSequence.length() > 0;
            if (!bl3) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List parts = (List)destination$iv$iv;
        if (parts.size() != 8) return false;
        CharSequence $this$all$iv = address;
        boolean $i$f$all = false;
        object = $this$all$iv;
        int n = 0;
        while (n < object.length()) {
            char element$iv;
            char it = element$iv = object.charAt(n);
            boolean bl = false;
            if (!NetworkKt.isHexDigit(it)) {
                if (it != ':') return false;
            }
            boolean bl4 = true;
            if (!bl4) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private static final byte[] ip4String2Bytes(String src) {
        Number number;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        boolean bl;
        CharSequence charSequence;
        String it;
        Iterable $this$filterTo$iv$iv;
        char[] cArray = new char[]{'.'};
        Iterable $this$filter$iv = StringsKt.split$default((CharSequence)src, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl2 = false;
            charSequence = it;
            bl = false;
            boolean bl3 = charSequence.length() > 0;
            if (!bl3) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl4 = false;
            charSequence = it;
            bl = false;
            number = Integer.parseInt((String)charSequence);
            collection.add(number);
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            int it2 = ((Number)item$iv$iv).intValue();
            collection = destination$iv$iv;
            boolean bl5 = false;
            number = (byte)it2;
            collection.add(number);
        }
        return CollectionsKt.toByteArray((Collection)((List)destination$iv$iv));
    }

    private static final byte[] toByteArray(short[] $this$toByteArray) {
        ByteBuffer bytes = ByteBuffer.allocate($this$toByteArray.length * 2);
        short[] $this$forEach$iv = $this$toByteArray;
        boolean $i$f$forEach = false;
        short[] sArray = $this$forEach$iv;
        int n = sArray.length;
        for (int i = 0; i < n; ++i) {
            short element$iv;
            short it = element$iv = sArray[i];
            boolean bl = false;
            bytes.putShort(it);
        }
        Intrinsics.checkNotNullExpressionValue((Object)bytes, (String)"bytes");
        return IoKt.toByteArray$default((ByteBuffer)bytes, (boolean)false, (int)1, null);
    }

    private static final byte[] ip6String2Bytes(String src) {
        Number number;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        int n;
        CharSequence charSequence;
        String it;
        Iterable $this$filterTo$iv$iv;
        char[] cArray = new char[]{':'};
        Iterable $this$filter$iv = StringsKt.split$default((CharSequence)src, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            charSequence = it;
            n = 0;
            boolean bl2 = charSequence.length() > 0;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            charSequence = it;
            n = 16;
            boolean bl3 = false;
            number = Integer.parseInt((String)charSequence, CharsKt.checkRadix((int)n));
            collection.add(number);
        }
        $this$map$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            int it2 = ((Number)item$iv$iv).intValue();
            collection = destination$iv$iv;
            boolean bl = false;
            number = (short)it2;
            collection.add(number);
        }
        return NetworkKt.toByteArray(CollectionsKt.toShortArray((Collection)((List)destination$iv$iv)));
    }

    public static final /* synthetic */ byte[] access$getDockerVendor$p() {
        return dockerVendor;
    }

    static {
        byte[] byArray = new byte[]{2, 66};
        dockerVendor = byArray;
    }
}

