/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.projector.awt.peer;

import java.awt.AWTEvent;
import java.awt.BufferCapabilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.dnd.DropTarget;
import java.awt.dnd.peer.DropTargetPeer;
import java.awt.event.FocusEvent;
import java.awt.event.PaintEvent;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.image.VolatileImage;
import java.awt.peer.ComponentPeer;
import java.awt.peer.ContainerPeer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.projector.awt.PToolkit;
import org.jetbrains.projector.awt.PWindow;
import org.jetbrains.projector.awt.image.PVolatileImage;
import org.jetbrains.projector.awt.peer.PKeyboardFocusManagerPeer;
import org.jetbrains.projector.awt.peer.PMouseInfoPeer;
import sun.awt.image.ToolkitImage;
import sun.java2d.pipe.Region;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00d4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\b&\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0012\u0010\u0016\u001a\u00020\u00132\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0006H\u0016J*\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\u001b2\b\u0010 \u001a\u0004\u0018\u00010!H\u0016J\u0010\u0010\"\u001a\u00020\u00132\u0006\u0010#\u001a\u00020$H\u0016J\u0018\u0010%\u001a\u00020\u00132\u0006\u0010&\u001a\u00020\u001b2\u0006\u0010'\u001a\u00020(H\u0016J\u0010\u0010)\u001a\u00020\u001d2\u0006\u0010*\u001a\u00020+H\u0016J\u0018\u0010)\u001a\u00020\u001d2\u0006\u0010,\u001a\u00020\u001b2\u0006\u0010-\u001a\u00020\u001bH\u0016J\u0018\u0010.\u001a\u00020/2\u0006\u0010,\u001a\u00020\u001b2\u0006\u0010-\u001a\u00020\u001bH\u0016J\b\u00100\u001a\u00020\u0013H\u0016J\b\u00101\u001a\u00020\u0013H\u0016J0\u00102\u001a\u00020\u00132\u0006\u00103\u001a\u00020\u001b2\u0006\u00104\u001a\u00020\u001b2\u0006\u00105\u001a\u00020\u001b2\u0006\u00106\u001a\u00020\u001b2\u0006\u00107\u001a\u000208H\u0016J\b\u00109\u001a\u00020\u001dH\u0016J\b\u0010:\u001a\u00020;H\u0016J\u0010\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020?H\u0016J\b\u0010@\u001a\u00020AH\u0016J\b\u0010B\u001a\u00020\tH\u0016J\b\u0010C\u001a\u00020DH\u0016J\b\u0010E\u001a\u00020FH\u0016J\b\u0010G\u001a\u00020FH\u0016J\u0010\u0010H\u001a\u00020\u00132\u0006\u0010#\u001a\u00020IH\u0016J\b\u0010J\u001a\u00020\u0006H\u0016J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010K\u001a\u00020\u0006H\u0016J\b\u0010L\u001a\u00020\u0006H\u0016J\b\u0010M\u001a\u00020\u0013H\u0016J\u0010\u0010N\u001a\u00020\u00132\u0006\u0010O\u001a\u00020AH\u0016J*\u0010P\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\u001b2\b\u0010 \u001a\u0004\u0018\u00010!H\u0016J\u0010\u0010Q\u001a\u00020\u00132\u0006\u0010O\u001a\u00020AH\u0016J\u0010\u0010R\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010S\u001a\u00020\u00132\u0006\u0010T\u001a\u00020UH\u0016J0\u0010V\u001a\u00020\u00062\u0006\u0010W\u001a\u00020\u00042\u0006\u0010X\u001a\u00020\u00062\u0006\u0010Y\u001a\u00020\u00062\u0006\u0010Z\u001a\u00020[2\u0006\u0010\\\u001a\u00020]H\u0016J\u0010\u0010^\u001a\u00020\u00132\u0006\u0010_\u001a\u00020`H\u0016J0\u0010a\u001a\u00020\u00132\u0006\u0010b\u001a\u00020\u001b2\u0006\u0010c\u001a\u00020\u001b2\u0006\u0010,\u001a\u00020\u001b2\u0006\u0010-\u001a\u00020\u001b2\u0006\u0010d\u001a\u00020\u001bH\u0016J\u0010\u0010e\u001a\u00020\u00132\u0006\u0010#\u001a\u00020\u0006H\u0016J\u0010\u0010f\u001a\u00020\u00132\u0006\u0010g\u001a\u00020?H\u0016J\u0010\u0010h\u001a\u00020\u00132\u0006\u0010_\u001a\u00020`H\u0016J\u0010\u0010i\u001a\u00020\u00132\u0006\u0010j\u001a\u00020\u0006H\u0016J\u0012\u0010k\u001a\u00020\u00132\b\u0010l\u001a\u0004\u0018\u00010\u0001H\u0016J\b\u0010m\u001a\u00020\u0013H\u0016J\u0010\u0010n\u001a\u00020\u00062\u0006\u0010o\u001a\u00020\tH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006p"}, d2={"Lorg/jetbrains/projector/awt/peer/PComponentPeer;", "Ljava/awt/peer/ComponentPeer;", "Ljava/awt/dnd/peer/DropTargetPeer;", "target", "Ljava/awt/Component;", "isFocusable", "", "(Ljava/awt/Component;Z)V", "myGraphicsConfiguration", "Ljava/awt/GraphicsConfiguration;", "pWindow", "Lorg/jetbrains/projector/awt/PWindow;", "getPWindow", "()Lorg/jetbrains/projector/awt/PWindow;", "toolkit", "Ljava/awt/Toolkit;", "getToolkit", "()Ljava/awt/Toolkit;", "addDropTarget", "", "dt", "Ljava/awt/dnd/DropTarget;", "applyShape", "shape", "Lsun/java2d/pipe/Region;", "canDetermineObscurity", "checkImage", "", "img", "Ljava/awt/Image;", "w", "h", "o", "Ljava/awt/image/ImageObserver;", "coalescePaintEvent", "e", "Ljava/awt/event/PaintEvent;", "createBuffers", "numBuffers", "caps", "Ljava/awt/BufferCapabilities;", "createImage", "producer", "Ljava/awt/image/ImageProducer;", "width", "height", "createVolatileImage", "Ljava/awt/image/VolatileImage;", "destroyBuffers", "dispose", "flip", "x1", "y1", "x2", "y2", "flipAction", "Ljava/awt/BufferCapabilities$FlipContents;", "getBackBuffer", "getColorModel", "Ljava/awt/image/ColorModel;", "getFontMetrics", "Ljava/awt/FontMetrics;", "font", "Ljava/awt/Font;", "getGraphics", "Ljava/awt/Graphics;", "getGraphicsConfiguration", "getLocationOnScreen", "Ljava/awt/Point;", "getMinimumSize", "Ljava/awt/Dimension;", "getPreferredSize", "handleEvent", "Ljava/awt/AWTEvent;", "handlesWheelScrolling", "isObscured", "isReparentSupported", "layout", "paint", "g", "prepareImage", "print", "removeDropTarget", "reparent", "newContainer", "Ljava/awt/peer/ContainerPeer;", "requestFocus", "lightweightChild", "temporary", "focusedWindowChangeAllowed", "time", "", "cause", "Ljava/awt/event/FocusEvent$Cause;", "setBackground", "c", "Ljava/awt/Color;", "setBounds", "x", "y", "op", "setEnabled", "setFont", "f", "setForeground", "setVisible", "v", "setZOrder", "above", "updateCursorImmediately", "updateGraphicsData", "gc", "projector-awt"})
public abstract class PComponentPeer
implements ComponentPeer,
DropTargetPeer {
    private final boolean isFocusable;
    @NotNull
    private final PWindow pWindow;
    @Nullable
    private GraphicsConfiguration myGraphicsConfiguration;

    public PComponentPeer(@NotNull Component target, boolean isFocusable) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        this.isFocusable = isFocusable;
        this.pWindow = new PWindow(target, false);
    }

    public /* synthetic */ PComponentPeer(Component component, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(component, bl);
    }

    private final Toolkit getToolkit() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Intrinsics.checkNotNullExpressionValue((Object)toolkit, (String)"getDefaultToolkit()");
        return toolkit;
    }

    @NotNull
    public final PWindow getPWindow() {
        return this.pWindow;
    }

    @Override
    public void dispose() {
        PToolkit.Companion.targetDisposedPeer$projector_awt(this.pWindow.getTarget(), this);
        this.pWindow.dispose();
    }

    @Override
    public void addDropTarget(@NotNull DropTarget dt) {
        Intrinsics.checkNotNullParameter((Object)dt, (String)"dt");
    }

    @Override
    public void removeDropTarget(@NotNull DropTarget dt) {
        Intrinsics.checkNotNullParameter((Object)dt, (String)"dt");
    }

    @Override
    public boolean isObscured() {
        return false;
    }

    @Override
    public boolean canDetermineObscurity() {
        return false;
    }

    @Override
    public void setVisible(boolean v) {
        if (v) {
            this.pWindow.getTarget().repaint();
        }
        this.pWindow.getTarget().setVisible(v);
    }

    @Override
    public void setEnabled(boolean e) {
        this.pWindow.getTarget().setEnabled(e);
    }

    @Override
    public void paint(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        this.pWindow.getTarget().paint(g);
    }

    @Override
    public void print(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        g.setColor(this.pWindow.getTarget().getBackground());
        g.fillRect(0, 0, this.pWindow.getTarget().getWidth(), this.pWindow.getTarget().getHeight());
        g.setColor(this.pWindow.getTarget().getForeground());
        this.pWindow.getTarget().print(g);
    }

    @Override
    public void setBounds(int x, int y, int width, int height, int op) {
    }

    @Override
    public void handleEvent(@NotNull AWTEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
    }

    @Override
    public void coalescePaintEvent(@NotNull PaintEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
    }

    @Override
    @NotNull
    public Point getLocationOnScreen() {
        Point point = this.pWindow.getTarget().getLocation();
        Intrinsics.checkNotNullExpressionValue((Object)point, (String)"pWindow.target.location");
        return point;
    }

    @Override
    @NotNull
    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    @Override
    @NotNull
    public Dimension getMinimumSize() {
        Dimension dimension = this.pWindow.getTarget().getSize();
        Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"pWindow.target.size");
        return dimension;
    }

    @Override
    @NotNull
    public ColorModel getColorModel() {
        ColorModel colorModel = Toolkit.getDefaultToolkit().getColorModel();
        Intrinsics.checkNotNullExpressionValue((Object)colorModel, (String)"getDefaultToolkit().colorModel");
        return colorModel;
    }

    @Override
    @NotNull
    public Graphics getGraphics() {
        Graphics graphics = this.pWindow.getGraphics().create();
        Intrinsics.checkNotNullExpressionValue((Object)graphics, (String)"pWindow.graphics.create()");
        return graphics;
    }

    @Override
    @NotNull
    public FontMetrics getFontMetrics(@NotNull Font font) {
        Intrinsics.checkNotNullParameter((Object)font, (String)"font");
        FontMetrics fontMetrics = this.getToolkit().getFontMetrics(font);
        Intrinsics.checkNotNullExpressionValue((Object)fontMetrics, (String)"toolkit.getFontMetrics(font)");
        return fontMetrics;
    }

    @Override
    public void setForeground(@NotNull Color c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
    }

    @Override
    public void setBackground(@NotNull Color c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
    }

    @Override
    public void setFont(@NotNull Font f) {
        Intrinsics.checkNotNullParameter((Object)f, (String)"f");
    }

    @Override
    public void updateCursorImmediately() {
        Cursor cursor;
        Point mousePoint = PMouseInfoPeer.INSTANCE.getLastMouseCoords();
        Component component = PMouseInfoPeer.INSTANCE.getLastWindowUnderMouse();
        Container containerUnderMouse = component instanceof Container ? (Container)component : null;
        Container container = containerUnderMouse;
        if (container == null) {
            cursor = null;
        } else {
            Container container2 = container;
            boolean bl = false;
            boolean bl2 = false;
            Container it = container2;
            boolean bl3 = false;
            Point location = it.getLocation();
            Component componentUnderMouse = it.findComponentAt(mousePoint.x - location.x, mousePoint.y - location.y);
            Component component2 = componentUnderMouse;
            cursor = component2 == null ? null : component2.getCursor();
        }
        Cursor cursorUnderMouse = cursor;
        this.pWindow.setCursor(cursorUnderMouse);
    }

    @Override
    public boolean requestFocus(@NotNull Component lightweightChild, boolean temporary, boolean focusedWindowChangeAllowed, long time, @NotNull FocusEvent.Cause cause) {
        Intrinsics.checkNotNullParameter((Object)lightweightChild, (String)"lightweightChild");
        Intrinsics.checkNotNullParameter((Object)((Object)cause), (String)"cause");
        Component component = this.pWindow.getTarget();
        boolean bl = false;
        boolean bl2 = false;
        Component it = component;
        boolean bl3 = false;
        return PKeyboardFocusManagerPeer.INSTANCE.deliverFocus(lightweightChild, it, temporary, focusedWindowChangeAllowed, time, cause);
    }

    @Override
    public boolean isFocusable() {
        return this.isFocusable;
    }

    @NotNull
    public Image createImage(@NotNull ImageProducer producer) {
        Intrinsics.checkNotNullParameter((Object)producer, (String)"producer");
        return new ToolkitImage(producer);
    }

    @Override
    @NotNull
    public Image createImage(int width, int height) {
        return new PVolatileImage(width, height);
    }

    @Override
    @NotNull
    public VolatileImage createVolatileImage(int width, int height) {
        return new PVolatileImage(width, height);
    }

    public boolean prepareImage(@NotNull Image img, int w, int h, @Nullable ImageObserver o) {
        Intrinsics.checkNotNullParameter((Object)img, (String)"img");
        return this.getToolkit().prepareImage(img, w, h, o);
    }

    public int checkImage(@NotNull Image img, int w, int h, @Nullable ImageObserver o) {
        Intrinsics.checkNotNullParameter((Object)img, (String)"img");
        return this.getToolkit().checkImage(img, w, h, o);
    }

    @Override
    @NotNull
    public GraphicsConfiguration getGraphicsConfiguration() {
        GraphicsConfiguration graphicsConfiguration;
        GraphicsConfiguration graphicsConfiguration2 = this.myGraphicsConfiguration;
        if (graphicsConfiguration2 == null) {
            GraphicsConfiguration graphicsConfiguration3 = this.pWindow.getTarget().getGraphicsConfiguration();
            Intrinsics.checkNotNullExpressionValue((Object)graphicsConfiguration3, (String)"pWindow.target.graphicsConfiguration");
            graphicsConfiguration = graphicsConfiguration3;
        } else {
            graphicsConfiguration = graphicsConfiguration2;
        }
        return graphicsConfiguration;
    }

    @Override
    public boolean handlesWheelScrolling() {
        return false;
    }

    @Override
    public void createBuffers(int numBuffers, @NotNull BufferCapabilities caps) {
        Intrinsics.checkNotNullParameter((Object)caps, (String)"caps");
    }

    @Override
    @NotNull
    public Image getBackBuffer() {
        throw new IllegalStateException("Buffers have not been created");
    }

    @Override
    public void flip(int x1, int y1, int x2, int y2, @NotNull BufferCapabilities.FlipContents flipAction) {
        Intrinsics.checkNotNullParameter((Object)flipAction, (String)"flipAction");
    }

    @Override
    public void destroyBuffers() {
    }

    @Override
    public void reparent(@NotNull ContainerPeer newContainer) {
        Intrinsics.checkNotNullParameter((Object)newContainer, (String)"newContainer");
    }

    @Override
    public boolean isReparentSupported() {
        return false;
    }

    @Override
    public void layout() {
    }

    @Override
    public void applyShape(@Nullable Region shape) {
    }

    @Override
    public void setZOrder(@Nullable ComponentPeer above) {
    }

    @Override
    public boolean updateGraphicsData(@NotNull GraphicsConfiguration gc) {
        Intrinsics.checkNotNullParameter((Object)gc, (String)"gc");
        this.myGraphicsConfiguration = gc;
        return false;
    }
}

