# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base import serialize
from twilio.base import values
from twilio.base.instance_context import InstanceContext
from twilio.base.instance_resource import InstanceResource
from twilio.base.list_resource import ListResource
from twilio.base.page import Page


class WebhookList(ListResource):
    """ PLEASE NOTE that this class contains beta products that are subject to
    change. Use them with caution. """

    def __init__(self, version):
        """
        Initialize the WebhookList

        :param Version version: Version that contains the resource

        :returns: twilio.rest.conversations.v1.webhook.WebhookList
        :rtype: twilio.rest.conversations.v1.webhook.WebhookList
        """
        super(WebhookList, self).__init__(version)

        # Path Solution
        self._solution = {}

    def get(self):
        """
        Constructs a WebhookContext

        :returns: twilio.rest.conversations.v1.webhook.WebhookContext
        :rtype: twilio.rest.conversations.v1.webhook.WebhookContext
        """
        return WebhookContext(self._version, )

    def __call__(self):
        """
        Constructs a WebhookContext

        :returns: twilio.rest.conversations.v1.webhook.WebhookContext
        :rtype: twilio.rest.conversations.v1.webhook.WebhookContext
        """
        return WebhookContext(self._version, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Conversations.V1.WebhookList>'


class WebhookPage(Page):
    """ PLEASE NOTE that this class contains beta products that are subject to
    change. Use them with caution. """

    def __init__(self, version, response, solution):
        """
        Initialize the WebhookPage

        :param Version version: Version that contains the resource
        :param Response response: Response from the API

        :returns: twilio.rest.conversations.v1.webhook.WebhookPage
        :rtype: twilio.rest.conversations.v1.webhook.WebhookPage
        """
        super(WebhookPage, self).__init__(version, response)

        # Path Solution
        self._solution = solution

    def get_instance(self, payload):
        """
        Build an instance of WebhookInstance

        :param dict payload: Payload response from the API

        :returns: twilio.rest.conversations.v1.webhook.WebhookInstance
        :rtype: twilio.rest.conversations.v1.webhook.WebhookInstance
        """
        return WebhookInstance(self._version, payload, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Conversations.V1.WebhookPage>'


class WebhookContext(InstanceContext):
    """ PLEASE NOTE that this class contains beta products that are subject to
    change. Use them with caution. """

    def __init__(self, version):
        """
        Initialize the WebhookContext

        :param Version version: Version that contains the resource

        :returns: twilio.rest.conversations.v1.webhook.WebhookContext
        :rtype: twilio.rest.conversations.v1.webhook.WebhookContext
        """
        super(WebhookContext, self).__init__(version)

        # Path Solution
        self._solution = {}
        self._uri = '/Conversations/Webhooks'.format(**self._solution)

    def fetch(self):
        """
        Fetch the WebhookInstance

        :returns: The fetched WebhookInstance
        :rtype: twilio.rest.conversations.v1.webhook.WebhookInstance
        """
        payload = self._version.fetch(method='GET', uri=self._uri, )

        return WebhookInstance(self._version, payload, )

    def update(self, method=values.unset, filters=values.unset,
               pre_webhook_url=values.unset, post_webhook_url=values.unset,
               target=values.unset):
        """
        Update the WebhookInstance

        :param unicode method: The HTTP method to be used when sending a webhook request.
        :param unicode filters: The list of webhook event triggers that are enabled for this Service.
        :param unicode pre_webhook_url: The absolute url the pre-event webhook request should be sent to.
        :param unicode post_webhook_url: The absolute url the post-event webhook request should be sent to.
        :param WebhookInstance.Target target: The routing target of the webhook.

        :returns: The updated WebhookInstance
        :rtype: twilio.rest.conversations.v1.webhook.WebhookInstance
        """
        data = values.of({
            'Method': method,
            'Filters': serialize.map(filters, lambda e: e),
            'PreWebhookUrl': pre_webhook_url,
            'PostWebhookUrl': post_webhook_url,
            'Target': target,
        })

        payload = self._version.update(method='POST', uri=self._uri, data=data, )

        return WebhookInstance(self._version, payload, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Conversations.V1.WebhookContext {}>'.format(context)


class WebhookInstance(InstanceResource):
    """ PLEASE NOTE that this class contains beta products that are subject to
    change. Use them with caution. """

    class Target(object):
        WEBHOOK = "webhook"
        FLEX = "flex"

    class Method(object):
        GET = "GET"
        POST = "POST"

    def __init__(self, version, payload):
        """
        Initialize the WebhookInstance

        :returns: twilio.rest.conversations.v1.webhook.WebhookInstance
        :rtype: twilio.rest.conversations.v1.webhook.WebhookInstance
        """
        super(WebhookInstance, self).__init__(version)

        # Marshaled Properties
        self._properties = {
            'account_sid': payload.get('account_sid'),
            'method': payload.get('method'),
            'filters': payload.get('filters'),
            'pre_webhook_url': payload.get('pre_webhook_url'),
            'post_webhook_url': payload.get('post_webhook_url'),
            'target': payload.get('target'),
            'url': payload.get('url'),
        }

        # Context
        self._context = None
        self._solution = {}

    @property
    def _proxy(self):
        """
        Generate an instance context for the instance, the context is capable of
        performing various actions.  All instance actions are proxied to the context

        :returns: WebhookContext for this WebhookInstance
        :rtype: twilio.rest.conversations.v1.webhook.WebhookContext
        """
        if self._context is None:
            self._context = WebhookContext(self._version, )
        return self._context

    @property
    def account_sid(self):
        """
        :returns: The unique id of the Account responsible for this conversation.
        :rtype: unicode
        """
        return self._properties['account_sid']

    @property
    def method(self):
        """
        :returns: The HTTP method to be used when sending a webhook request.
        :rtype: WebhookInstance.Method
        """
        return self._properties['method']

    @property
    def filters(self):
        """
        :returns: The list of webhook event triggers that are enabled for this Service.
        :rtype: unicode
        """
        return self._properties['filters']

    @property
    def pre_webhook_url(self):
        """
        :returns: The absolute url the pre-event webhook request should be sent to.
        :rtype: unicode
        """
        return self._properties['pre_webhook_url']

    @property
    def post_webhook_url(self):
        """
        :returns: The absolute url the post-event webhook request should be sent to.
        :rtype: unicode
        """
        return self._properties['post_webhook_url']

    @property
    def target(self):
        """
        :returns: The routing target of the webhook.
        :rtype: WebhookInstance.Target
        """
        return self._properties['target']

    @property
    def url(self):
        """
        :returns: An absolute URL for this webhook.
        :rtype: unicode
        """
        return self._properties['url']

    def fetch(self):
        """
        Fetch the WebhookInstance

        :returns: The fetched WebhookInstance
        :rtype: twilio.rest.conversations.v1.webhook.WebhookInstance
        """
        return self._proxy.fetch()

    def update(self, method=values.unset, filters=values.unset,
               pre_webhook_url=values.unset, post_webhook_url=values.unset,
               target=values.unset):
        """
        Update the WebhookInstance

        :param unicode method: The HTTP method to be used when sending a webhook request.
        :param unicode filters: The list of webhook event triggers that are enabled for this Service.
        :param unicode pre_webhook_url: The absolute url the pre-event webhook request should be sent to.
        :param unicode post_webhook_url: The absolute url the post-event webhook request should be sent to.
        :param WebhookInstance.Target target: The routing target of the webhook.

        :returns: The updated WebhookInstance
        :rtype: twilio.rest.conversations.v1.webhook.WebhookInstance
        """
        return self._proxy.update(
            method=method,
            filters=filters,
            pre_webhook_url=pre_webhook_url,
            post_webhook_url=post_webhook_url,
            target=target,
        )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Conversations.V1.WebhookInstance {}>'.format(context)
