# Copyright 2022 The KServe Authors.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# coding: utf-8

"""
    KServe

    Python SDK for KServe  # noqa: E501

    The version of the OpenAPI document: v0.1
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from kserve.configuration import Configuration


class V1alpha1InferenceRouter(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'router_type': 'str',
        'steps': 'list[V1alpha1InferenceStep]'
    }

    attribute_map = {
        'router_type': 'routerType',
        'steps': 'steps'
    }

    def __init__(self, router_type='', steps=None, local_vars_configuration=None):  # noqa: E501
        """V1alpha1InferenceRouter - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._router_type = None
        self._steps = None
        self.discriminator = None

        self.router_type = router_type
        if steps is not None:
            self.steps = steps

    @property
    def router_type(self):
        """Gets the router_type of this V1alpha1InferenceRouter.  # noqa: E501

        RouterType  - `Sequence:` chain multiple inference steps with input/output from previous step  - `Splitter:` randomly routes to the target service according to the weight  - `Ensemble:` routes the request to multiple models and then merge the responses  - `Switch:` routes the request to one of the steps based on condition  # noqa: E501

        :return: The router_type of this V1alpha1InferenceRouter.  # noqa: E501
        :rtype: str
        """
        return self._router_type

    @router_type.setter
    def router_type(self, router_type):
        """Sets the router_type of this V1alpha1InferenceRouter.

        RouterType  - `Sequence:` chain multiple inference steps with input/output from previous step  - `Splitter:` randomly routes to the target service according to the weight  - `Ensemble:` routes the request to multiple models and then merge the responses  - `Switch:` routes the request to one of the steps based on condition  # noqa: E501

        :param router_type: The router_type of this V1alpha1InferenceRouter.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and router_type is None:  # noqa: E501
            raise ValueError("Invalid value for `router_type`, must not be `None`")  # noqa: E501

        self._router_type = router_type

    @property
    def steps(self):
        """Gets the steps of this V1alpha1InferenceRouter.  # noqa: E501

        Steps defines destinations for the current router node  # noqa: E501

        :return: The steps of this V1alpha1InferenceRouter.  # noqa: E501
        :rtype: list[V1alpha1InferenceStep]
        """
        return self._steps

    @steps.setter
    def steps(self, steps):
        """Sets the steps of this V1alpha1InferenceRouter.

        Steps defines destinations for the current router node  # noqa: E501

        :param steps: The steps of this V1alpha1InferenceRouter.  # noqa: E501
        :type: list[V1alpha1InferenceStep]
        """

        self._steps = steps

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, V1alpha1InferenceRouter):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, V1alpha1InferenceRouter):
            return True

        return self.to_dict() != other.to_dict()
