# Copyright 2022 The KServe Authors.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#    http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# coding: utf-8

"""
    KServe

    Python SDK for KServe  # noqa: E501

    The version of the OpenAPI document: v0.1
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from kserve.configuration import Configuration


class V1alpha1InferenceStep(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'condition': 'str',
        'data': 'str',
        'name': 'str',
        'node_name': 'str',
        'service_name': 'str',
        'service_url': 'str',
        'weight': 'int'
    }

    attribute_map = {
        'condition': 'condition',
        'data': 'data',
        'name': 'name',
        'node_name': 'nodeName',
        'service_name': 'serviceName',
        'service_url': 'serviceUrl',
        'weight': 'weight'
    }

    def __init__(self, condition=None, data=None, name=None, node_name=None, service_name=None, service_url=None, weight=None, local_vars_configuration=None):  # noqa: E501
        """V1alpha1InferenceStep - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._condition = None
        self._data = None
        self._name = None
        self._node_name = None
        self._service_name = None
        self._service_url = None
        self._weight = None
        self.discriminator = None

        if condition is not None:
            self.condition = condition
        if data is not None:
            self.data = data
        if name is not None:
            self.name = name
        if node_name is not None:
            self.node_name = node_name
        if service_name is not None:
            self.service_name = service_name
        if service_url is not None:
            self.service_url = service_url
        if weight is not None:
            self.weight = weight

    @property
    def condition(self):
        """Gets the condition of this V1alpha1InferenceStep.  # noqa: E501

        routing based on the condition  # noqa: E501

        :return: The condition of this V1alpha1InferenceStep.  # noqa: E501
        :rtype: str
        """
        return self._condition

    @condition.setter
    def condition(self, condition):
        """Sets the condition of this V1alpha1InferenceStep.

        routing based on the condition  # noqa: E501

        :param condition: The condition of this V1alpha1InferenceStep.  # noqa: E501
        :type: str
        """

        self._condition = condition

    @property
    def data(self):
        """Gets the data of this V1alpha1InferenceStep.  # noqa: E501

        request data sent to the next route with input/output from the previous step $request $response.predictions  # noqa: E501

        :return: The data of this V1alpha1InferenceStep.  # noqa: E501
        :rtype: str
        """
        return self._data

    @data.setter
    def data(self, data):
        """Sets the data of this V1alpha1InferenceStep.

        request data sent to the next route with input/output from the previous step $request $response.predictions  # noqa: E501

        :param data: The data of this V1alpha1InferenceStep.  # noqa: E501
        :type: str
        """

        self._data = data

    @property
    def name(self):
        """Gets the name of this V1alpha1InferenceStep.  # noqa: E501

        Unique name for the step within this node  # noqa: E501

        :return: The name of this V1alpha1InferenceStep.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this V1alpha1InferenceStep.

        Unique name for the step within this node  # noqa: E501

        :param name: The name of this V1alpha1InferenceStep.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def node_name(self):
        """Gets the node_name of this V1alpha1InferenceStep.  # noqa: E501

        The node name for routing as next step  # noqa: E501

        :return: The node_name of this V1alpha1InferenceStep.  # noqa: E501
        :rtype: str
        """
        return self._node_name

    @node_name.setter
    def node_name(self, node_name):
        """Sets the node_name of this V1alpha1InferenceStep.

        The node name for routing as next step  # noqa: E501

        :param node_name: The node_name of this V1alpha1InferenceStep.  # noqa: E501
        :type: str
        """

        self._node_name = node_name

    @property
    def service_name(self):
        """Gets the service_name of this V1alpha1InferenceStep.  # noqa: E501

        named reference for InferenceService  # noqa: E501

        :return: The service_name of this V1alpha1InferenceStep.  # noqa: E501
        :rtype: str
        """
        return self._service_name

    @service_name.setter
    def service_name(self, service_name):
        """Sets the service_name of this V1alpha1InferenceStep.

        named reference for InferenceService  # noqa: E501

        :param service_name: The service_name of this V1alpha1InferenceStep.  # noqa: E501
        :type: str
        """

        self._service_name = service_name

    @property
    def service_url(self):
        """Gets the service_url of this V1alpha1InferenceStep.  # noqa: E501

        InferenceService URL, mutually exclusive with ServiceName  # noqa: E501

        :return: The service_url of this V1alpha1InferenceStep.  # noqa: E501
        :rtype: str
        """
        return self._service_url

    @service_url.setter
    def service_url(self, service_url):
        """Sets the service_url of this V1alpha1InferenceStep.

        InferenceService URL, mutually exclusive with ServiceName  # noqa: E501

        :param service_url: The service_url of this V1alpha1InferenceStep.  # noqa: E501
        :type: str
        """

        self._service_url = service_url

    @property
    def weight(self):
        """Gets the weight of this V1alpha1InferenceStep.  # noqa: E501

        the weight for split of the traffic, only used for Split Router when weight is specified all the routing targets should be sum to 100  # noqa: E501

        :return: The weight of this V1alpha1InferenceStep.  # noqa: E501
        :rtype: int
        """
        return self._weight

    @weight.setter
    def weight(self, weight):
        """Sets the weight of this V1alpha1InferenceStep.

        the weight for split of the traffic, only used for Split Router when weight is specified all the routing targets should be sum to 100  # noqa: E501

        :param weight: The weight of this V1alpha1InferenceStep.  # noqa: E501
        :type: int
        """

        self._weight = weight

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, V1alpha1InferenceStep):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, V1alpha1InferenceStep):
            return True

        return self.to_dict() != other.to_dict()
