# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from ._enums import *

__all__ = ['DropletArgs', 'Droplet']

@pulumi.input_type
class DropletArgs:
    def __init__(__self__, *,
                 image: pulumi.Input[str],
                 region: pulumi.Input[Union[str, 'Region']],
                 size: pulumi.Input[Union[str, 'DropletSlug']],
                 backups: Optional[pulumi.Input[bool]] = None,
                 ipv6: Optional[pulumi.Input[bool]] = None,
                 monitoring: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 private_networking: Optional[pulumi.Input[bool]] = None,
                 resize_disk: Optional[pulumi.Input[bool]] = None,
                 ssh_keys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 user_data: Optional[pulumi.Input[str]] = None,
                 volume_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 vpc_uuid: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Droplet resource.
        :param pulumi.Input[str] image: The Droplet image ID or slug.
        :param pulumi.Input[Union[str, 'Region']] region: The region to start in.
        :param pulumi.Input[Union[str, 'DropletSlug']] size: The unique slug that indentifies the type of Droplet. You can find a list of available slugs on [DigitalOcean API documentation](https://developers.digitalocean.com/documentation/v2/#list-all-sizes).
        :param pulumi.Input[bool] backups: Boolean controlling if backups are made. Defaults to
               false.
        :param pulumi.Input[bool] ipv6: Boolean controlling if IPv6 is enabled. Defaults to false.
        :param pulumi.Input[bool] monitoring: Boolean controlling whether monitoring agent is installed.
               Defaults to false.
        :param pulumi.Input[str] name: The Droplet name.
        :param pulumi.Input[bool] private_networking: Boolean controlling if private networking
               is enabled. When VPC is enabled on an account, this will provision the
               Droplet inside of your account's default VPC for the region. Use the
               `vpc_uuid` attribute to specify a different VPC.
        :param pulumi.Input[bool] resize_disk: Boolean controlling whether to increase the disk
               size when resizing a Droplet. It defaults to `true`. When set to `false`,
               only the Droplet's RAM and CPU will be resized. **Increasing a Droplet's disk
               size is a permanent change**. Increasing only RAM and CPU is reversible.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ssh_keys: A list of SSH key IDs or fingerprints to enable in
               the format `[12345, 123456]`. To retrieve this info, use the
               [DigitalOcean API](https://docs.digitalocean.com/reference/api/api-reference/#tag/SSH-Keys)
               or CLI (`doctl compute ssh-key list`). Once a Droplet is created keys can not
               be added or removed via this provider. Modifying this field will prompt you
               to destroy and recreate the Droplet.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: A list of the tags to be applied to this Droplet.
        :param pulumi.Input[str] user_data: A string of the desired User Data for the Droplet.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] volume_ids: A list of the IDs of each block storage volume to be attached to the Droplet.
        :param pulumi.Input[str] vpc_uuid: The ID of the VPC where the Droplet will be located.
        """
        pulumi.set(__self__, "image", image)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "size", size)
        if backups is not None:
            pulumi.set(__self__, "backups", backups)
        if ipv6 is not None:
            pulumi.set(__self__, "ipv6", ipv6)
        if monitoring is not None:
            pulumi.set(__self__, "monitoring", monitoring)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if private_networking is not None:
            pulumi.set(__self__, "private_networking", private_networking)
        if resize_disk is not None:
            pulumi.set(__self__, "resize_disk", resize_disk)
        if ssh_keys is not None:
            pulumi.set(__self__, "ssh_keys", ssh_keys)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if user_data is not None:
            pulumi.set(__self__, "user_data", user_data)
        if volume_ids is not None:
            pulumi.set(__self__, "volume_ids", volume_ids)
        if vpc_uuid is not None:
            pulumi.set(__self__, "vpc_uuid", vpc_uuid)

    @property
    @pulumi.getter
    def image(self) -> pulumi.Input[str]:
        """
        The Droplet image ID or slug.
        """
        return pulumi.get(self, "image")

    @image.setter
    def image(self, value: pulumi.Input[str]):
        pulumi.set(self, "image", value)

    @property
    @pulumi.getter
    def region(self) -> pulumi.Input[Union[str, 'Region']]:
        """
        The region to start in.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: pulumi.Input[Union[str, 'Region']]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter
    def size(self) -> pulumi.Input[Union[str, 'DropletSlug']]:
        """
        The unique slug that indentifies the type of Droplet. You can find a list of available slugs on [DigitalOcean API documentation](https://developers.digitalocean.com/documentation/v2/#list-all-sizes).
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: pulumi.Input[Union[str, 'DropletSlug']]):
        pulumi.set(self, "size", value)

    @property
    @pulumi.getter
    def backups(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean controlling if backups are made. Defaults to
        false.
        """
        return pulumi.get(self, "backups")

    @backups.setter
    def backups(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "backups", value)

    @property
    @pulumi.getter
    def ipv6(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean controlling if IPv6 is enabled. Defaults to false.
        """
        return pulumi.get(self, "ipv6")

    @ipv6.setter
    def ipv6(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ipv6", value)

    @property
    @pulumi.getter
    def monitoring(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean controlling whether monitoring agent is installed.
        Defaults to false.
        """
        return pulumi.get(self, "monitoring")

    @monitoring.setter
    def monitoring(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "monitoring", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The Droplet name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="privateNetworking")
    def private_networking(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean controlling if private networking
        is enabled. When VPC is enabled on an account, this will provision the
        Droplet inside of your account's default VPC for the region. Use the
        `vpc_uuid` attribute to specify a different VPC.
        """
        return pulumi.get(self, "private_networking")

    @private_networking.setter
    def private_networking(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "private_networking", value)

    @property
    @pulumi.getter(name="resizeDisk")
    def resize_disk(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean controlling whether to increase the disk
        size when resizing a Droplet. It defaults to `true`. When set to `false`,
        only the Droplet's RAM and CPU will be resized. **Increasing a Droplet's disk
        size is a permanent change**. Increasing only RAM and CPU is reversible.
        """
        return pulumi.get(self, "resize_disk")

    @resize_disk.setter
    def resize_disk(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "resize_disk", value)

    @property
    @pulumi.getter(name="sshKeys")
    def ssh_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of SSH key IDs or fingerprints to enable in
        the format `[12345, 123456]`. To retrieve this info, use the
        [DigitalOcean API](https://docs.digitalocean.com/reference/api/api-reference/#tag/SSH-Keys)
        or CLI (`doctl compute ssh-key list`). Once a Droplet is created keys can not
        be added or removed via this provider. Modifying this field will prompt you
        to destroy and recreate the Droplet.
        """
        return pulumi.get(self, "ssh_keys")

    @ssh_keys.setter
    def ssh_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ssh_keys", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of the tags to be applied to this Droplet.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="userData")
    def user_data(self) -> Optional[pulumi.Input[str]]:
        """
        A string of the desired User Data for the Droplet.
        """
        return pulumi.get(self, "user_data")

    @user_data.setter
    def user_data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_data", value)

    @property
    @pulumi.getter(name="volumeIds")
    def volume_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of the IDs of each block storage volume to be attached to the Droplet.
        """
        return pulumi.get(self, "volume_ids")

    @volume_ids.setter
    def volume_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "volume_ids", value)

    @property
    @pulumi.getter(name="vpcUuid")
    def vpc_uuid(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the VPC where the Droplet will be located.
        """
        return pulumi.get(self, "vpc_uuid")

    @vpc_uuid.setter
    def vpc_uuid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_uuid", value)


@pulumi.input_type
class _DropletState:
    def __init__(__self__, *,
                 backups: Optional[pulumi.Input[bool]] = None,
                 created_at: Optional[pulumi.Input[str]] = None,
                 disk: Optional[pulumi.Input[int]] = None,
                 droplet_urn: Optional[pulumi.Input[str]] = None,
                 image: Optional[pulumi.Input[str]] = None,
                 ipv4_address: Optional[pulumi.Input[str]] = None,
                 ipv4_address_private: Optional[pulumi.Input[str]] = None,
                 ipv6: Optional[pulumi.Input[bool]] = None,
                 ipv6_address: Optional[pulumi.Input[str]] = None,
                 locked: Optional[pulumi.Input[bool]] = None,
                 memory: Optional[pulumi.Input[int]] = None,
                 monitoring: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 price_hourly: Optional[pulumi.Input[float]] = None,
                 price_monthly: Optional[pulumi.Input[float]] = None,
                 private_networking: Optional[pulumi.Input[bool]] = None,
                 region: Optional[pulumi.Input[Union[str, 'Region']]] = None,
                 resize_disk: Optional[pulumi.Input[bool]] = None,
                 size: Optional[pulumi.Input[Union[str, 'DropletSlug']]] = None,
                 ssh_keys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 user_data: Optional[pulumi.Input[str]] = None,
                 vcpus: Optional[pulumi.Input[int]] = None,
                 volume_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 vpc_uuid: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Droplet resources.
        :param pulumi.Input[bool] backups: Boolean controlling if backups are made. Defaults to
               false.
        :param pulumi.Input[int] disk: The size of the instance's disk in GB
        :param pulumi.Input[str] droplet_urn: The uniform resource name of the Droplet
               * `name`- The name of the Droplet
        :param pulumi.Input[str] image: The Droplet image ID or slug.
        :param pulumi.Input[str] ipv4_address: The IPv4 address
        :param pulumi.Input[str] ipv4_address_private: The private networking IPv4 address
        :param pulumi.Input[bool] ipv6: Boolean controlling if IPv6 is enabled. Defaults to false.
        :param pulumi.Input[str] ipv6_address: The IPv6 address
        :param pulumi.Input[bool] locked: Is the Droplet locked
        :param pulumi.Input[bool] monitoring: Boolean controlling whether monitoring agent is installed.
               Defaults to false.
        :param pulumi.Input[str] name: The Droplet name.
        :param pulumi.Input[float] price_hourly: Droplet hourly price
        :param pulumi.Input[float] price_monthly: Droplet monthly price
        :param pulumi.Input[bool] private_networking: Boolean controlling if private networking
               is enabled. When VPC is enabled on an account, this will provision the
               Droplet inside of your account's default VPC for the region. Use the
               `vpc_uuid` attribute to specify a different VPC.
        :param pulumi.Input[Union[str, 'Region']] region: The region to start in.
        :param pulumi.Input[bool] resize_disk: Boolean controlling whether to increase the disk
               size when resizing a Droplet. It defaults to `true`. When set to `false`,
               only the Droplet's RAM and CPU will be resized. **Increasing a Droplet's disk
               size is a permanent change**. Increasing only RAM and CPU is reversible.
        :param pulumi.Input[Union[str, 'DropletSlug']] size: The unique slug that indentifies the type of Droplet. You can find a list of available slugs on [DigitalOcean API documentation](https://developers.digitalocean.com/documentation/v2/#list-all-sizes).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ssh_keys: A list of SSH key IDs or fingerprints to enable in
               the format `[12345, 123456]`. To retrieve this info, use the
               [DigitalOcean API](https://docs.digitalocean.com/reference/api/api-reference/#tag/SSH-Keys)
               or CLI (`doctl compute ssh-key list`). Once a Droplet is created keys can not
               be added or removed via this provider. Modifying this field will prompt you
               to destroy and recreate the Droplet.
        :param pulumi.Input[str] status: The status of the Droplet
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: A list of the tags to be applied to this Droplet.
        :param pulumi.Input[str] user_data: A string of the desired User Data for the Droplet.
        :param pulumi.Input[int] vcpus: The number of the instance's virtual CPUs
        :param pulumi.Input[Sequence[pulumi.Input[str]]] volume_ids: A list of the IDs of each block storage volume to be attached to the Droplet.
        :param pulumi.Input[str] vpc_uuid: The ID of the VPC where the Droplet will be located.
        """
        if backups is not None:
            pulumi.set(__self__, "backups", backups)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if disk is not None:
            pulumi.set(__self__, "disk", disk)
        if droplet_urn is not None:
            pulumi.set(__self__, "droplet_urn", droplet_urn)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if ipv4_address is not None:
            pulumi.set(__self__, "ipv4_address", ipv4_address)
        if ipv4_address_private is not None:
            pulumi.set(__self__, "ipv4_address_private", ipv4_address_private)
        if ipv6 is not None:
            pulumi.set(__self__, "ipv6", ipv6)
        if ipv6_address is not None:
            pulumi.set(__self__, "ipv6_address", ipv6_address)
        if locked is not None:
            pulumi.set(__self__, "locked", locked)
        if memory is not None:
            pulumi.set(__self__, "memory", memory)
        if monitoring is not None:
            pulumi.set(__self__, "monitoring", monitoring)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if price_hourly is not None:
            pulumi.set(__self__, "price_hourly", price_hourly)
        if price_monthly is not None:
            pulumi.set(__self__, "price_monthly", price_monthly)
        if private_networking is not None:
            pulumi.set(__self__, "private_networking", private_networking)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if resize_disk is not None:
            pulumi.set(__self__, "resize_disk", resize_disk)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if ssh_keys is not None:
            pulumi.set(__self__, "ssh_keys", ssh_keys)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if user_data is not None:
            pulumi.set(__self__, "user_data", user_data)
        if vcpus is not None:
            pulumi.set(__self__, "vcpus", vcpus)
        if volume_ids is not None:
            pulumi.set(__self__, "volume_ids", volume_ids)
        if vpc_uuid is not None:
            pulumi.set(__self__, "vpc_uuid", vpc_uuid)

    @property
    @pulumi.getter
    def backups(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean controlling if backups are made. Defaults to
        false.
        """
        return pulumi.get(self, "backups")

    @backups.setter
    def backups(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "backups", value)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter
    def disk(self) -> Optional[pulumi.Input[int]]:
        """
        The size of the instance's disk in GB
        """
        return pulumi.get(self, "disk")

    @disk.setter
    def disk(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "disk", value)

    @property
    @pulumi.getter(name="dropletUrn")
    def droplet_urn(self) -> Optional[pulumi.Input[str]]:
        """
        The uniform resource name of the Droplet
        * `name`- The name of the Droplet
        """
        return pulumi.get(self, "droplet_urn")

    @droplet_urn.setter
    def droplet_urn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "droplet_urn", value)

    @property
    @pulumi.getter
    def image(self) -> Optional[pulumi.Input[str]]:
        """
        The Droplet image ID or slug.
        """
        return pulumi.get(self, "image")

    @image.setter
    def image(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image", value)

    @property
    @pulumi.getter(name="ipv4Address")
    def ipv4_address(self) -> Optional[pulumi.Input[str]]:
        """
        The IPv4 address
        """
        return pulumi.get(self, "ipv4_address")

    @ipv4_address.setter
    def ipv4_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv4_address", value)

    @property
    @pulumi.getter(name="ipv4AddressPrivate")
    def ipv4_address_private(self) -> Optional[pulumi.Input[str]]:
        """
        The private networking IPv4 address
        """
        return pulumi.get(self, "ipv4_address_private")

    @ipv4_address_private.setter
    def ipv4_address_private(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv4_address_private", value)

    @property
    @pulumi.getter
    def ipv6(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean controlling if IPv6 is enabled. Defaults to false.
        """
        return pulumi.get(self, "ipv6")

    @ipv6.setter
    def ipv6(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "ipv6", value)

    @property
    @pulumi.getter(name="ipv6Address")
    def ipv6_address(self) -> Optional[pulumi.Input[str]]:
        """
        The IPv6 address
        """
        return pulumi.get(self, "ipv6_address")

    @ipv6_address.setter
    def ipv6_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ipv6_address", value)

    @property
    @pulumi.getter
    def locked(self) -> Optional[pulumi.Input[bool]]:
        """
        Is the Droplet locked
        """
        return pulumi.get(self, "locked")

    @locked.setter
    def locked(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "locked", value)

    @property
    @pulumi.getter
    def memory(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "memory")

    @memory.setter
    def memory(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "memory", value)

    @property
    @pulumi.getter
    def monitoring(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean controlling whether monitoring agent is installed.
        Defaults to false.
        """
        return pulumi.get(self, "monitoring")

    @monitoring.setter
    def monitoring(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "monitoring", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The Droplet name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="priceHourly")
    def price_hourly(self) -> Optional[pulumi.Input[float]]:
        """
        Droplet hourly price
        """
        return pulumi.get(self, "price_hourly")

    @price_hourly.setter
    def price_hourly(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "price_hourly", value)

    @property
    @pulumi.getter(name="priceMonthly")
    def price_monthly(self) -> Optional[pulumi.Input[float]]:
        """
        Droplet monthly price
        """
        return pulumi.get(self, "price_monthly")

    @price_monthly.setter
    def price_monthly(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "price_monthly", value)

    @property
    @pulumi.getter(name="privateNetworking")
    def private_networking(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean controlling if private networking
        is enabled. When VPC is enabled on an account, this will provision the
        Droplet inside of your account's default VPC for the region. Use the
        `vpc_uuid` attribute to specify a different VPC.
        """
        return pulumi.get(self, "private_networking")

    @private_networking.setter
    def private_networking(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "private_networking", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[Union[str, 'Region']]]:
        """
        The region to start in.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[Union[str, 'Region']]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="resizeDisk")
    def resize_disk(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean controlling whether to increase the disk
        size when resizing a Droplet. It defaults to `true`. When set to `false`,
        only the Droplet's RAM and CPU will be resized. **Increasing a Droplet's disk
        size is a permanent change**. Increasing only RAM and CPU is reversible.
        """
        return pulumi.get(self, "resize_disk")

    @resize_disk.setter
    def resize_disk(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "resize_disk", value)

    @property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[Union[str, 'DropletSlug']]]:
        """
        The unique slug that indentifies the type of Droplet. You can find a list of available slugs on [DigitalOcean API documentation](https://developers.digitalocean.com/documentation/v2/#list-all-sizes).
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[Union[str, 'DropletSlug']]]):
        pulumi.set(self, "size", value)

    @property
    @pulumi.getter(name="sshKeys")
    def ssh_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of SSH key IDs or fingerprints to enable in
        the format `[12345, 123456]`. To retrieve this info, use the
        [DigitalOcean API](https://docs.digitalocean.com/reference/api/api-reference/#tag/SSH-Keys)
        or CLI (`doctl compute ssh-key list`). Once a Droplet is created keys can not
        be added or removed via this provider. Modifying this field will prompt you
        to destroy and recreate the Droplet.
        """
        return pulumi.get(self, "ssh_keys")

    @ssh_keys.setter
    def ssh_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ssh_keys", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the Droplet
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of the tags to be applied to this Droplet.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="userData")
    def user_data(self) -> Optional[pulumi.Input[str]]:
        """
        A string of the desired User Data for the Droplet.
        """
        return pulumi.get(self, "user_data")

    @user_data.setter
    def user_data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_data", value)

    @property
    @pulumi.getter
    def vcpus(self) -> Optional[pulumi.Input[int]]:
        """
        The number of the instance's virtual CPUs
        """
        return pulumi.get(self, "vcpus")

    @vcpus.setter
    def vcpus(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "vcpus", value)

    @property
    @pulumi.getter(name="volumeIds")
    def volume_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of the IDs of each block storage volume to be attached to the Droplet.
        """
        return pulumi.get(self, "volume_ids")

    @volume_ids.setter
    def volume_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "volume_ids", value)

    @property
    @pulumi.getter(name="vpcUuid")
    def vpc_uuid(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the VPC where the Droplet will be located.
        """
        return pulumi.get(self, "vpc_uuid")

    @vpc_uuid.setter
    def vpc_uuid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_uuid", value)


class Droplet(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backups: Optional[pulumi.Input[bool]] = None,
                 image: Optional[pulumi.Input[str]] = None,
                 ipv6: Optional[pulumi.Input[bool]] = None,
                 monitoring: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 private_networking: Optional[pulumi.Input[bool]] = None,
                 region: Optional[pulumi.Input[Union[str, 'Region']]] = None,
                 resize_disk: Optional[pulumi.Input[bool]] = None,
                 size: Optional[pulumi.Input[Union[str, 'DropletSlug']]] = None,
                 ssh_keys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 user_data: Optional[pulumi.Input[str]] = None,
                 volume_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 vpc_uuid: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a DigitalOcean Droplet resource. This can be used to create,
        modify, and delete Droplets.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_digitalocean as digitalocean

        # Create a new Web Droplet in the nyc2 region
        web = digitalocean.Droplet("web",
            image="ubuntu-18-04-x64",
            region="nyc2",
            size="s-1vcpu-1gb")
        ```

        ## Import

        Droplets can be imported using the Droplet `id`, e.g.

        ```sh
         $ pulumi import digitalocean:index/droplet:Droplet mydroplet 100823
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] backups: Boolean controlling if backups are made. Defaults to
               false.
        :param pulumi.Input[str] image: The Droplet image ID or slug.
        :param pulumi.Input[bool] ipv6: Boolean controlling if IPv6 is enabled. Defaults to false.
        :param pulumi.Input[bool] monitoring: Boolean controlling whether monitoring agent is installed.
               Defaults to false.
        :param pulumi.Input[str] name: The Droplet name.
        :param pulumi.Input[bool] private_networking: Boolean controlling if private networking
               is enabled. When VPC is enabled on an account, this will provision the
               Droplet inside of your account's default VPC for the region. Use the
               `vpc_uuid` attribute to specify a different VPC.
        :param pulumi.Input[Union[str, 'Region']] region: The region to start in.
        :param pulumi.Input[bool] resize_disk: Boolean controlling whether to increase the disk
               size when resizing a Droplet. It defaults to `true`. When set to `false`,
               only the Droplet's RAM and CPU will be resized. **Increasing a Droplet's disk
               size is a permanent change**. Increasing only RAM and CPU is reversible.
        :param pulumi.Input[Union[str, 'DropletSlug']] size: The unique slug that indentifies the type of Droplet. You can find a list of available slugs on [DigitalOcean API documentation](https://developers.digitalocean.com/documentation/v2/#list-all-sizes).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ssh_keys: A list of SSH key IDs or fingerprints to enable in
               the format `[12345, 123456]`. To retrieve this info, use the
               [DigitalOcean API](https://docs.digitalocean.com/reference/api/api-reference/#tag/SSH-Keys)
               or CLI (`doctl compute ssh-key list`). Once a Droplet is created keys can not
               be added or removed via this provider. Modifying this field will prompt you
               to destroy and recreate the Droplet.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: A list of the tags to be applied to this Droplet.
        :param pulumi.Input[str] user_data: A string of the desired User Data for the Droplet.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] volume_ids: A list of the IDs of each block storage volume to be attached to the Droplet.
        :param pulumi.Input[str] vpc_uuid: The ID of the VPC where the Droplet will be located.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DropletArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a DigitalOcean Droplet resource. This can be used to create,
        modify, and delete Droplets.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_digitalocean as digitalocean

        # Create a new Web Droplet in the nyc2 region
        web = digitalocean.Droplet("web",
            image="ubuntu-18-04-x64",
            region="nyc2",
            size="s-1vcpu-1gb")
        ```

        ## Import

        Droplets can be imported using the Droplet `id`, e.g.

        ```sh
         $ pulumi import digitalocean:index/droplet:Droplet mydroplet 100823
        ```

        :param str resource_name: The name of the resource.
        :param DropletArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DropletArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backups: Optional[pulumi.Input[bool]] = None,
                 image: Optional[pulumi.Input[str]] = None,
                 ipv6: Optional[pulumi.Input[bool]] = None,
                 monitoring: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 private_networking: Optional[pulumi.Input[bool]] = None,
                 region: Optional[pulumi.Input[Union[str, 'Region']]] = None,
                 resize_disk: Optional[pulumi.Input[bool]] = None,
                 size: Optional[pulumi.Input[Union[str, 'DropletSlug']]] = None,
                 ssh_keys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 user_data: Optional[pulumi.Input[str]] = None,
                 volume_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 vpc_uuid: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DropletArgs.__new__(DropletArgs)

            __props__.__dict__["backups"] = backups
            if image is None and not opts.urn:
                raise TypeError("Missing required property 'image'")
            __props__.__dict__["image"] = image
            __props__.__dict__["ipv6"] = ipv6
            __props__.__dict__["monitoring"] = monitoring
            __props__.__dict__["name"] = name
            __props__.__dict__["private_networking"] = private_networking
            if region is None and not opts.urn:
                raise TypeError("Missing required property 'region'")
            __props__.__dict__["region"] = region
            __props__.__dict__["resize_disk"] = resize_disk
            if size is None and not opts.urn:
                raise TypeError("Missing required property 'size'")
            __props__.__dict__["size"] = size
            __props__.__dict__["ssh_keys"] = ssh_keys
            __props__.__dict__["tags"] = tags
            __props__.__dict__["user_data"] = user_data
            __props__.__dict__["volume_ids"] = volume_ids
            __props__.__dict__["vpc_uuid"] = vpc_uuid
            __props__.__dict__["created_at"] = None
            __props__.__dict__["disk"] = None
            __props__.__dict__["droplet_urn"] = None
            __props__.__dict__["ipv4_address"] = None
            __props__.__dict__["ipv4_address_private"] = None
            __props__.__dict__["ipv6_address"] = None
            __props__.__dict__["locked"] = None
            __props__.__dict__["memory"] = None
            __props__.__dict__["price_hourly"] = None
            __props__.__dict__["price_monthly"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["vcpus"] = None
        super(Droplet, __self__).__init__(
            'digitalocean:index/droplet:Droplet',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            backups: Optional[pulumi.Input[bool]] = None,
            created_at: Optional[pulumi.Input[str]] = None,
            disk: Optional[pulumi.Input[int]] = None,
            droplet_urn: Optional[pulumi.Input[str]] = None,
            image: Optional[pulumi.Input[str]] = None,
            ipv4_address: Optional[pulumi.Input[str]] = None,
            ipv4_address_private: Optional[pulumi.Input[str]] = None,
            ipv6: Optional[pulumi.Input[bool]] = None,
            ipv6_address: Optional[pulumi.Input[str]] = None,
            locked: Optional[pulumi.Input[bool]] = None,
            memory: Optional[pulumi.Input[int]] = None,
            monitoring: Optional[pulumi.Input[bool]] = None,
            name: Optional[pulumi.Input[str]] = None,
            price_hourly: Optional[pulumi.Input[float]] = None,
            price_monthly: Optional[pulumi.Input[float]] = None,
            private_networking: Optional[pulumi.Input[bool]] = None,
            region: Optional[pulumi.Input[Union[str, 'Region']]] = None,
            resize_disk: Optional[pulumi.Input[bool]] = None,
            size: Optional[pulumi.Input[Union[str, 'DropletSlug']]] = None,
            ssh_keys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            status: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            user_data: Optional[pulumi.Input[str]] = None,
            vcpus: Optional[pulumi.Input[int]] = None,
            volume_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            vpc_uuid: Optional[pulumi.Input[str]] = None) -> 'Droplet':
        """
        Get an existing Droplet resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] backups: Boolean controlling if backups are made. Defaults to
               false.
        :param pulumi.Input[int] disk: The size of the instance's disk in GB
        :param pulumi.Input[str] droplet_urn: The uniform resource name of the Droplet
               * `name`- The name of the Droplet
        :param pulumi.Input[str] image: The Droplet image ID or slug.
        :param pulumi.Input[str] ipv4_address: The IPv4 address
        :param pulumi.Input[str] ipv4_address_private: The private networking IPv4 address
        :param pulumi.Input[bool] ipv6: Boolean controlling if IPv6 is enabled. Defaults to false.
        :param pulumi.Input[str] ipv6_address: The IPv6 address
        :param pulumi.Input[bool] locked: Is the Droplet locked
        :param pulumi.Input[bool] monitoring: Boolean controlling whether monitoring agent is installed.
               Defaults to false.
        :param pulumi.Input[str] name: The Droplet name.
        :param pulumi.Input[float] price_hourly: Droplet hourly price
        :param pulumi.Input[float] price_monthly: Droplet monthly price
        :param pulumi.Input[bool] private_networking: Boolean controlling if private networking
               is enabled. When VPC is enabled on an account, this will provision the
               Droplet inside of your account's default VPC for the region. Use the
               `vpc_uuid` attribute to specify a different VPC.
        :param pulumi.Input[Union[str, 'Region']] region: The region to start in.
        :param pulumi.Input[bool] resize_disk: Boolean controlling whether to increase the disk
               size when resizing a Droplet. It defaults to `true`. When set to `false`,
               only the Droplet's RAM and CPU will be resized. **Increasing a Droplet's disk
               size is a permanent change**. Increasing only RAM and CPU is reversible.
        :param pulumi.Input[Union[str, 'DropletSlug']] size: The unique slug that indentifies the type of Droplet. You can find a list of available slugs on [DigitalOcean API documentation](https://developers.digitalocean.com/documentation/v2/#list-all-sizes).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ssh_keys: A list of SSH key IDs or fingerprints to enable in
               the format `[12345, 123456]`. To retrieve this info, use the
               [DigitalOcean API](https://docs.digitalocean.com/reference/api/api-reference/#tag/SSH-Keys)
               or CLI (`doctl compute ssh-key list`). Once a Droplet is created keys can not
               be added or removed via this provider. Modifying this field will prompt you
               to destroy and recreate the Droplet.
        :param pulumi.Input[str] status: The status of the Droplet
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: A list of the tags to be applied to this Droplet.
        :param pulumi.Input[str] user_data: A string of the desired User Data for the Droplet.
        :param pulumi.Input[int] vcpus: The number of the instance's virtual CPUs
        :param pulumi.Input[Sequence[pulumi.Input[str]]] volume_ids: A list of the IDs of each block storage volume to be attached to the Droplet.
        :param pulumi.Input[str] vpc_uuid: The ID of the VPC where the Droplet will be located.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DropletState.__new__(_DropletState)

        __props__.__dict__["backups"] = backups
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["disk"] = disk
        __props__.__dict__["droplet_urn"] = droplet_urn
        __props__.__dict__["image"] = image
        __props__.__dict__["ipv4_address"] = ipv4_address
        __props__.__dict__["ipv4_address_private"] = ipv4_address_private
        __props__.__dict__["ipv6"] = ipv6
        __props__.__dict__["ipv6_address"] = ipv6_address
        __props__.__dict__["locked"] = locked
        __props__.__dict__["memory"] = memory
        __props__.__dict__["monitoring"] = monitoring
        __props__.__dict__["name"] = name
        __props__.__dict__["price_hourly"] = price_hourly
        __props__.__dict__["price_monthly"] = price_monthly
        __props__.__dict__["private_networking"] = private_networking
        __props__.__dict__["region"] = region
        __props__.__dict__["resize_disk"] = resize_disk
        __props__.__dict__["size"] = size
        __props__.__dict__["ssh_keys"] = ssh_keys
        __props__.__dict__["status"] = status
        __props__.__dict__["tags"] = tags
        __props__.__dict__["user_data"] = user_data
        __props__.__dict__["vcpus"] = vcpus
        __props__.__dict__["volume_ids"] = volume_ids
        __props__.__dict__["vpc_uuid"] = vpc_uuid
        return Droplet(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def backups(self) -> pulumi.Output[Optional[bool]]:
        """
        Boolean controlling if backups are made. Defaults to
        false.
        """
        return pulumi.get(self, "backups")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[str]:
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def disk(self) -> pulumi.Output[int]:
        """
        The size of the instance's disk in GB
        """
        return pulumi.get(self, "disk")

    @property
    @pulumi.getter(name="dropletUrn")
    def droplet_urn(self) -> pulumi.Output[str]:
        """
        The uniform resource name of the Droplet
        * `name`- The name of the Droplet
        """
        return pulumi.get(self, "droplet_urn")

    @property
    @pulumi.getter
    def image(self) -> pulumi.Output[str]:
        """
        The Droplet image ID or slug.
        """
        return pulumi.get(self, "image")

    @property
    @pulumi.getter(name="ipv4Address")
    def ipv4_address(self) -> pulumi.Output[str]:
        """
        The IPv4 address
        """
        return pulumi.get(self, "ipv4_address")

    @property
    @pulumi.getter(name="ipv4AddressPrivate")
    def ipv4_address_private(self) -> pulumi.Output[str]:
        """
        The private networking IPv4 address
        """
        return pulumi.get(self, "ipv4_address_private")

    @property
    @pulumi.getter
    def ipv6(self) -> pulumi.Output[Optional[bool]]:
        """
        Boolean controlling if IPv6 is enabled. Defaults to false.
        """
        return pulumi.get(self, "ipv6")

    @property
    @pulumi.getter(name="ipv6Address")
    def ipv6_address(self) -> pulumi.Output[str]:
        """
        The IPv6 address
        """
        return pulumi.get(self, "ipv6_address")

    @property
    @pulumi.getter
    def locked(self) -> pulumi.Output[bool]:
        """
        Is the Droplet locked
        """
        return pulumi.get(self, "locked")

    @property
    @pulumi.getter
    def memory(self) -> pulumi.Output[int]:
        return pulumi.get(self, "memory")

    @property
    @pulumi.getter
    def monitoring(self) -> pulumi.Output[Optional[bool]]:
        """
        Boolean controlling whether monitoring agent is installed.
        Defaults to false.
        """
        return pulumi.get(self, "monitoring")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The Droplet name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="priceHourly")
    def price_hourly(self) -> pulumi.Output[float]:
        """
        Droplet hourly price
        """
        return pulumi.get(self, "price_hourly")

    @property
    @pulumi.getter(name="priceMonthly")
    def price_monthly(self) -> pulumi.Output[float]:
        """
        Droplet monthly price
        """
        return pulumi.get(self, "price_monthly")

    @property
    @pulumi.getter(name="privateNetworking")
    def private_networking(self) -> pulumi.Output[bool]:
        """
        Boolean controlling if private networking
        is enabled. When VPC is enabled on an account, this will provision the
        Droplet inside of your account's default VPC for the region. Use the
        `vpc_uuid` attribute to specify a different VPC.
        """
        return pulumi.get(self, "private_networking")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        The region to start in.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="resizeDisk")
    def resize_disk(self) -> pulumi.Output[Optional[bool]]:
        """
        Boolean controlling whether to increase the disk
        size when resizing a Droplet. It defaults to `true`. When set to `false`,
        only the Droplet's RAM and CPU will be resized. **Increasing a Droplet's disk
        size is a permanent change**. Increasing only RAM and CPU is reversible.
        """
        return pulumi.get(self, "resize_disk")

    @property
    @pulumi.getter
    def size(self) -> pulumi.Output[str]:
        """
        The unique slug that indentifies the type of Droplet. You can find a list of available slugs on [DigitalOcean API documentation](https://developers.digitalocean.com/documentation/v2/#list-all-sizes).
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter(name="sshKeys")
    def ssh_keys(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        A list of SSH key IDs or fingerprints to enable in
        the format `[12345, 123456]`. To retrieve this info, use the
        [DigitalOcean API](https://docs.digitalocean.com/reference/api/api-reference/#tag/SSH-Keys)
        or CLI (`doctl compute ssh-key list`). Once a Droplet is created keys can not
        be added or removed via this provider. Modifying this field will prompt you
        to destroy and recreate the Droplet.
        """
        return pulumi.get(self, "ssh_keys")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The status of the Droplet
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        A list of the tags to be applied to this Droplet.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="userData")
    def user_data(self) -> pulumi.Output[Optional[str]]:
        """
        A string of the desired User Data for the Droplet.
        """
        return pulumi.get(self, "user_data")

    @property
    @pulumi.getter
    def vcpus(self) -> pulumi.Output[int]:
        """
        The number of the instance's virtual CPUs
        """
        return pulumi.get(self, "vcpus")

    @property
    @pulumi.getter(name="volumeIds")
    def volume_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        A list of the IDs of each block storage volume to be attached to the Droplet.
        """
        return pulumi.get(self, "volume_ids")

    @property
    @pulumi.getter(name="vpcUuid")
    def vpc_uuid(self) -> pulumi.Output[str]:
        """
        The ID of the VPC where the Droplet will be located.
        """
        return pulumi.get(self, "vpc_uuid")

