# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AppSpec',
    'AppSpecDatabase',
    'AppSpecDomainName',
    'AppSpecEnv',
    'AppSpecJob',
    'AppSpecJobEnv',
    'AppSpecJobGit',
    'AppSpecJobGithub',
    'AppSpecJobGitlab',
    'AppSpecJobImage',
    'AppSpecService',
    'AppSpecServiceEnv',
    'AppSpecServiceGit',
    'AppSpecServiceGithub',
    'AppSpecServiceGitlab',
    'AppSpecServiceHealthCheck',
    'AppSpecServiceImage',
    'AppSpecServiceRoute',
    'AppSpecStaticSite',
    'AppSpecStaticSiteEnv',
    'AppSpecStaticSiteGit',
    'AppSpecStaticSiteGithub',
    'AppSpecStaticSiteGitlab',
    'AppSpecStaticSiteRoute',
    'AppSpecWorker',
    'AppSpecWorkerEnv',
    'AppSpecWorkerGit',
    'AppSpecWorkerGithub',
    'AppSpecWorkerGitlab',
    'AppSpecWorkerImage',
    'DatabaseClusterMaintenanceWindow',
    'DatabaseFirewallRule',
    'FirewallInboundRule',
    'FirewallOutboundRule',
    'FirewallPendingChange',
    'KubernetesClusterKubeConfig',
    'KubernetesClusterNodePool',
    'KubernetesClusterNodePoolNode',
    'KubernetesClusterNodePoolTaint',
    'KubernetesNodePoolNode',
    'KubernetesNodePoolTaint',
    'LoadBalancerForwardingRule',
    'LoadBalancerHealthcheck',
    'LoadBalancerStickySessions',
    'SpacesBucketCorsRule',
    'SpacesBucketLifecycleRule',
    'SpacesBucketLifecycleRuleExpiration',
    'SpacesBucketLifecycleRuleNoncurrentVersionExpiration',
    'SpacesBucketVersioning',
    'GetAppSpecResult',
    'GetAppSpecDatabaseResult',
    'GetAppSpecEnvResult',
    'GetAppSpecJobResult',
    'GetAppSpecJobEnvResult',
    'GetAppSpecJobGitResult',
    'GetAppSpecJobGithubResult',
    'GetAppSpecJobGitlabResult',
    'GetAppSpecJobImageResult',
    'GetAppSpecServiceResult',
    'GetAppSpecServiceEnvResult',
    'GetAppSpecServiceGitResult',
    'GetAppSpecServiceGithubResult',
    'GetAppSpecServiceGitlabResult',
    'GetAppSpecServiceHealthCheckResult',
    'GetAppSpecServiceImageResult',
    'GetAppSpecServiceRouteResult',
    'GetAppSpecStaticSiteResult',
    'GetAppSpecStaticSiteEnvResult',
    'GetAppSpecStaticSiteGitResult',
    'GetAppSpecStaticSiteGithubResult',
    'GetAppSpecStaticSiteGitlabResult',
    'GetAppSpecStaticSiteRouteResult',
    'GetAppSpecWorkerResult',
    'GetAppSpecWorkerEnvResult',
    'GetAppSpecWorkerGitResult',
    'GetAppSpecWorkerGithubResult',
    'GetAppSpecWorkerGitlabResult',
    'GetAppSpecWorkerImageResult',
    'GetDatabaseClusterMaintenanceWindowResult',
    'GetDomainsDomainResult',
    'GetDomainsFilterResult',
    'GetDomainsSortResult',
    'GetDropletsDropletResult',
    'GetDropletsFilterResult',
    'GetDropletsSortResult',
    'GetFirewallInboundRuleResult',
    'GetFirewallOutboundRuleResult',
    'GetFirewallPendingChangeResult',
    'GetImagesFilterResult',
    'GetImagesImageResult',
    'GetImagesSortResult',
    'GetKubernetesClusterKubeConfigResult',
    'GetKubernetesClusterNodePoolResult',
    'GetKubernetesClusterNodePoolNodeResult',
    'GetKubernetesClusterNodePoolTaintResult',
    'GetLoadBalancerForwardingRuleResult',
    'GetLoadBalancerHealthcheckResult',
    'GetLoadBalancerStickySessionResult',
    'GetProjectsFilterResult',
    'GetProjectsProjectResult',
    'GetProjectsSortResult',
    'GetRecordsFilterResult',
    'GetRecordsRecordResult',
    'GetRecordsSortResult',
    'GetRegionsFilterResult',
    'GetRegionsRegionResult',
    'GetRegionsSortResult',
    'GetSizesFilterResult',
    'GetSizesSizeResult',
    'GetSizesSortResult',
    'GetSpacesBucketsBucketResult',
    'GetSpacesBucketsFilterResult',
    'GetSpacesBucketsSortResult',
    'GetSshKeysFilterResult',
    'GetSshKeysSortResult',
    'GetSshKeysSshKeyResult',
    'GetTagsFilterResult',
    'GetTagsSortResult',
    'GetTagsTagResult',
]

@pulumi.output_type
class AppSpec(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "domainNames":
            suggest = "domain_names"
        elif key == "staticSites":
            suggest = "static_sites"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppSpec. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppSpec.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppSpec.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 databases: Optional[Sequence['outputs.AppSpecDatabase']] = None,
                 domain_names: Optional[Sequence['outputs.AppSpecDomainName']] = None,
                 domains: Optional[Sequence[str]] = None,
                 envs: Optional[Sequence['outputs.AppSpecEnv']] = None,
                 jobs: Optional[Sequence['outputs.AppSpecJob']] = None,
                 region: Optional[str] = None,
                 services: Optional[Sequence['outputs.AppSpecService']] = None,
                 static_sites: Optional[Sequence['outputs.AppSpecStaticSite']] = None,
                 workers: Optional[Sequence['outputs.AppSpecWorker']] = None):
        """
        :param str name: The name of the component.
        :param Sequence['AppSpecDomainNameArgs'] domain_names: Describes a domain where the application will be made available.
        :param Sequence['AppSpecEnvArgs'] envs: Describes an environment variable made available to an app competent.
        :param str region: The slug for the DigitalOcean data center region hosting the app.
        """
        pulumi.set(__self__, "name", name)
        if databases is not None:
            pulumi.set(__self__, "databases", databases)
        if domain_names is not None:
            pulumi.set(__self__, "domain_names", domain_names)
        if domains is not None:
            pulumi.set(__self__, "domains", domains)
        if envs is not None:
            pulumi.set(__self__, "envs", envs)
        if jobs is not None:
            pulumi.set(__self__, "jobs", jobs)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if services is not None:
            pulumi.set(__self__, "services", services)
        if static_sites is not None:
            pulumi.set(__self__, "static_sites", static_sites)
        if workers is not None:
            pulumi.set(__self__, "workers", workers)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the component.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def databases(self) -> Optional[Sequence['outputs.AppSpecDatabase']]:
        return pulumi.get(self, "databases")

    @property
    @pulumi.getter(name="domainNames")
    def domain_names(self) -> Optional[Sequence['outputs.AppSpecDomainName']]:
        """
        Describes a domain where the application will be made available.
        """
        return pulumi.get(self, "domain_names")

    @property
    @pulumi.getter
    def domains(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "domains")

    @property
    @pulumi.getter
    def envs(self) -> Optional[Sequence['outputs.AppSpecEnv']]:
        """
        Describes an environment variable made available to an app competent.
        """
        return pulumi.get(self, "envs")

    @property
    @pulumi.getter
    def jobs(self) -> Optional[Sequence['outputs.AppSpecJob']]:
        return pulumi.get(self, "jobs")

    @property
    @pulumi.getter
    def region(self) -> Optional[str]:
        """
        The slug for the DigitalOcean data center region hosting the app.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def services(self) -> Optional[Sequence['outputs.AppSpecService']]:
        return pulumi.get(self, "services")

    @property
    @pulumi.getter(name="staticSites")
    def static_sites(self) -> Optional[Sequence['outputs.AppSpecStaticSite']]:
        return pulumi.get(self, "static_sites")

    @property
    @pulumi.getter
    def workers(self) -> Optional[Sequence['outputs.AppSpecWorker']]:
        return pulumi.get(self, "workers")


@pulumi.output_type
class AppSpecDatabase(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clusterName":
            suggest = "cluster_name"
        elif key == "dbName":
            suggest = "db_name"
        elif key == "dbUser":
            suggest = "db_user"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppSpecDatabase. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppSpecDatabase.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppSpecDatabase.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cluster_name: Optional[str] = None,
                 db_name: Optional[str] = None,
                 db_user: Optional[str] = None,
                 engine: Optional[str] = None,
                 name: Optional[str] = None,
                 production: Optional[bool] = None,
                 version: Optional[str] = None):
        """
        :param str cluster_name: The name of the underlying DigitalOcean DBaaS cluster. This is required for production databases. For dev databases, if `cluster_name` is not set, a new cluster will be provisioned.
        :param str db_name: The name of the MySQL or PostgreSQL database to configure.
        :param str db_user: The name of the MySQL or PostgreSQL user to configure.
        :param str engine: The database engine to use (`MYSQL`, `PG`, or `REDIS`).
        :param str name: The name of the component.
        :param bool production: Whether this is a production or dev database.
        :param str version: The version of the database engine.
        """
        if cluster_name is not None:
            pulumi.set(__self__, "cluster_name", cluster_name)
        if db_name is not None:
            pulumi.set(__self__, "db_name", db_name)
        if db_user is not None:
            pulumi.set(__self__, "db_user", db_user)
        if engine is not None:
            pulumi.set(__self__, "engine", engine)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if production is not None:
            pulumi.set(__self__, "production", production)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> Optional[str]:
        """
        The name of the underlying DigitalOcean DBaaS cluster. This is required for production databases. For dev databases, if `cluster_name` is not set, a new cluster will be provisioned.
        """
        return pulumi.get(self, "cluster_name")

    @property
    @pulumi.getter(name="dbName")
    def db_name(self) -> Optional[str]:
        """
        The name of the MySQL or PostgreSQL database to configure.
        """
        return pulumi.get(self, "db_name")

    @property
    @pulumi.getter(name="dbUser")
    def db_user(self) -> Optional[str]:
        """
        The name of the MySQL or PostgreSQL user to configure.
        """
        return pulumi.get(self, "db_user")

    @property
    @pulumi.getter
    def engine(self) -> Optional[str]:
        """
        The database engine to use (`MYSQL`, `PG`, or `REDIS`).
        """
        return pulumi.get(self, "engine")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the component.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def production(self) -> Optional[bool]:
        """
        Whether this is a production or dev database.
        """
        return pulumi.get(self, "production")

    @property
    @pulumi.getter
    def version(self) -> Optional[str]:
        """
        The version of the database engine.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class AppSpecDomainName(dict):
    def __init__(__self__, *,
                 name: str,
                 type: Optional[str] = None,
                 wildcard: Optional[bool] = None,
                 zone: Optional[str] = None):
        """
        :param str name: The name of the component.
        :param str type: The type of the environment variable, `GENERAL` or `SECRET`.
        :param bool wildcard: A boolean indicating whether the domain includes all sub-domains, in addition to the given domain.
        :param str zone: If the domain uses DigitalOcean DNS and you would like App Platform to automatically manage it for you, set this to the name of the domain on your account.
        """
        pulumi.set(__self__, "name", name)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if wildcard is not None:
            pulumi.set(__self__, "wildcard", wildcard)
        if zone is not None:
            pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the component.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The type of the environment variable, `GENERAL` or `SECRET`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def wildcard(self) -> Optional[bool]:
        """
        A boolean indicating whether the domain includes all sub-domains, in addition to the given domain.
        """
        return pulumi.get(self, "wildcard")

    @property
    @pulumi.getter
    def zone(self) -> Optional[str]:
        """
        If the domain uses DigitalOcean DNS and you would like App Platform to automatically manage it for you, set this to the name of the domain on your account.
        """
        return pulumi.get(self, "zone")


@pulumi.output_type
class AppSpecEnv(dict):
    def __init__(__self__, *,
                 key: Optional[str] = None,
                 scope: Optional[str] = None,
                 type: Optional[str] = None,
                 value: Optional[str] = None):
        """
        :param str key: The name of the environment variable.
        :param str scope: The visibility scope of the environment variable. One of `RUN_TIME`, `BUILD_TIME`, or `RUN_AND_BUILD_TIME` (default).
        :param str type: The type of the environment variable, `GENERAL` or `SECRET`.
        :param str value: The value of the environment variable.
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[str]:
        """
        The name of the environment variable.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def scope(self) -> Optional[str]:
        """
        The visibility scope of the environment variable. One of `RUN_TIME`, `BUILD_TIME`, or `RUN_AND_BUILD_TIME` (default).
        """
        return pulumi.get(self, "scope")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The type of the environment variable, `GENERAL` or `SECRET`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        The value of the environment variable.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class AppSpecJob(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "buildCommand":
            suggest = "build_command"
        elif key == "dockerfilePath":
            suggest = "dockerfile_path"
        elif key == "environmentSlug":
            suggest = "environment_slug"
        elif key == "instanceCount":
            suggest = "instance_count"
        elif key == "instanceSizeSlug":
            suggest = "instance_size_slug"
        elif key == "runCommand":
            suggest = "run_command"
        elif key == "sourceDir":
            suggest = "source_dir"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppSpecJob. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppSpecJob.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppSpecJob.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 build_command: Optional[str] = None,
                 dockerfile_path: Optional[str] = None,
                 environment_slug: Optional[str] = None,
                 envs: Optional[Sequence['outputs.AppSpecJobEnv']] = None,
                 git: Optional['outputs.AppSpecJobGit'] = None,
                 github: Optional['outputs.AppSpecJobGithub'] = None,
                 gitlab: Optional['outputs.AppSpecJobGitlab'] = None,
                 image: Optional['outputs.AppSpecJobImage'] = None,
                 instance_count: Optional[int] = None,
                 instance_size_slug: Optional[str] = None,
                 kind: Optional[str] = None,
                 run_command: Optional[str] = None,
                 source_dir: Optional[str] = None):
        """
        :param str name: The name of the component.
        :param str build_command: An optional build command to run while building this component from source.
        :param str dockerfile_path: The path to a Dockerfile relative to the root of the repo. If set, overrides usage of buildpacks.
        :param str environment_slug: An environment slug describing the type of this app.
        :param Sequence['AppSpecJobEnvArgs'] envs: Describes an environment variable made available to an app competent.
        :param 'AppSpecJobGitArgs' git: A Git repo to use as the component's source. The repository must be able to be cloned without authentication.  Only one of `git`, `github` or `gitlab`  may be set
        :param 'AppSpecJobGithubArgs' github: A GitHub repo to use as the component's source. DigitalOcean App Platform must have [access to the repository](https://cloud.digitalocean.com/apps/github/install). Only one of `git`, `github`, `gitlab`, or `image` may be set.
        :param 'AppSpecJobGitlabArgs' gitlab: A Gitlab repo to use as the component's source. DigitalOcean App Platform must have [access to the repository](https://cloud.digitalocean.com/apps/gitlab/install). Only one of `git`, `github`, `gitlab`, or `image` may be set.
        :param 'AppSpecJobImageArgs' image: An image to use as the component's source. Only one of `git`, `github`, `gitlab`, or `image` may be set.
        :param int instance_count: The amount of instances that this component should be scaled to.
        :param str instance_size_slug: The instance size to use for this component.
        :param str kind: The type of job and when it will be run during the deployment process. It may be one of:
               - `UNSPECIFIED`: Default job type, will auto-complete to POST_DEPLOY kind.
               - `PRE_DEPLOY`: Indicates a job that runs before an app deployment.
               - `POST_DEPLOY`: Indicates a job that runs after an app deployment.
               - `FAILED_DEPLOY`: Indicates a job that runs after a component fails to deploy.
        :param str run_command: An optional run command to override the component's default.
        :param str source_dir: An optional path to the working directory to use for the build.
        """
        pulumi.set(__self__, "name", name)
        if build_command is not None:
            pulumi.set(__self__, "build_command", build_command)
        if dockerfile_path is not None:
            pulumi.set(__self__, "dockerfile_path", dockerfile_path)
        if environment_slug is not None:
            pulumi.set(__self__, "environment_slug", environment_slug)
        if envs is not None:
            pulumi.set(__self__, "envs", envs)
        if git is not None:
            pulumi.set(__self__, "git", git)
        if github is not None:
            pulumi.set(__self__, "github", github)
        if gitlab is not None:
            pulumi.set(__self__, "gitlab", gitlab)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if instance_count is not None:
            pulumi.set(__self__, "instance_count", instance_count)
        if instance_size_slug is not None:
            pulumi.set(__self__, "instance_size_slug", instance_size_slug)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if run_command is not None:
            pulumi.set(__self__, "run_command", run_command)
        if source_dir is not None:
            pulumi.set(__self__, "source_dir", source_dir)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the component.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="buildCommand")
    def build_command(self) -> Optional[str]:
        """
        An optional build command to run while building this component from source.
        """
        return pulumi.get(self, "build_command")

    @property
    @pulumi.getter(name="dockerfilePath")
    def dockerfile_path(self) -> Optional[str]:
        """
        The path to a Dockerfile relative to the root of the repo. If set, overrides usage of buildpacks.
        """
        return pulumi.get(self, "dockerfile_path")

    @property
    @pulumi.getter(name="environmentSlug")
    def environment_slug(self) -> Optional[str]:
        """
        An environment slug describing the type of this app.
        """
        return pulumi.get(self, "environment_slug")

    @property
    @pulumi.getter
    def envs(self) -> Optional[Sequence['outputs.AppSpecJobEnv']]:
        """
        Describes an environment variable made available to an app competent.
        """
        return pulumi.get(self, "envs")

    @property
    @pulumi.getter
    def git(self) -> Optional['outputs.AppSpecJobGit']:
        """
        A Git repo to use as the component's source. The repository must be able to be cloned without authentication.  Only one of `git`, `github` or `gitlab`  may be set
        """
        return pulumi.get(self, "git")

    @property
    @pulumi.getter
    def github(self) -> Optional['outputs.AppSpecJobGithub']:
        """
        A GitHub repo to use as the component's source. DigitalOcean App Platform must have [access to the repository](https://cloud.digitalocean.com/apps/github/install). Only one of `git`, `github`, `gitlab`, or `image` may be set.
        """
        return pulumi.get(self, "github")

    @property
    @pulumi.getter
    def gitlab(self) -> Optional['outputs.AppSpecJobGitlab']:
        """
        A Gitlab repo to use as the component's source. DigitalOcean App Platform must have [access to the repository](https://cloud.digitalocean.com/apps/gitlab/install). Only one of `git`, `github`, `gitlab`, or `image` may be set.
        """
        return pulumi.get(self, "gitlab")

    @property
    @pulumi.getter
    def image(self) -> Optional['outputs.AppSpecJobImage']:
        """
        An image to use as the component's source. Only one of `git`, `github`, `gitlab`, or `image` may be set.
        """
        return pulumi.get(self, "image")

    @property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> Optional[int]:
        """
        The amount of instances that this component should be scaled to.
        """
        return pulumi.get(self, "instance_count")

    @property
    @pulumi.getter(name="instanceSizeSlug")
    def instance_size_slug(self) -> Optional[str]:
        """
        The instance size to use for this component.
        """
        return pulumi.get(self, "instance_size_slug")

    @property
    @pulumi.getter
    def kind(self) -> Optional[str]:
        """
        The type of job and when it will be run during the deployment process. It may be one of:
        - `UNSPECIFIED`: Default job type, will auto-complete to POST_DEPLOY kind.
        - `PRE_DEPLOY`: Indicates a job that runs before an app deployment.
        - `POST_DEPLOY`: Indicates a job that runs after an app deployment.
        - `FAILED_DEPLOY`: Indicates a job that runs after a component fails to deploy.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter(name="runCommand")
    def run_command(self) -> Optional[str]:
        """
        An optional run command to override the component's default.
        """
        return pulumi.get(self, "run_command")

    @property
    @pulumi.getter(name="sourceDir")
    def source_dir(self) -> Optional[str]:
        """
        An optional path to the working directory to use for the build.
        """
        return pulumi.get(self, "source_dir")


@pulumi.output_type
class AppSpecJobEnv(dict):
    def __init__(__self__, *,
                 key: Optional[str] = None,
                 scope: Optional[str] = None,
                 type: Optional[str] = None,
                 value: Optional[str] = None):
        """
        :param str key: The name of the environment variable.
        :param str scope: The visibility scope of the environment variable. One of `RUN_TIME`, `BUILD_TIME`, or `RUN_AND_BUILD_TIME` (default).
        :param str type: The type of the environment variable, `GENERAL` or `SECRET`.
        :param str value: The value of the environment variable.
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[str]:
        """
        The name of the environment variable.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def scope(self) -> Optional[str]:
        """
        The visibility scope of the environment variable. One of `RUN_TIME`, `BUILD_TIME`, or `RUN_AND_BUILD_TIME` (default).
        """
        return pulumi.get(self, "scope")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The type of the environment variable, `GENERAL` or `SECRET`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        The value of the environment variable.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class AppSpecJobGit(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "repoCloneUrl":
            suggest = "repo_clone_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppSpecJobGit. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppSpecJobGit.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppSpecJobGit.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 branch: Optional[str] = None,
                 repo_clone_url: Optional[str] = None):
        """
        :param str branch: The name of the branch to use.
        :param str repo_clone_url: The clone URL of the repo.
        """
        if branch is not None:
            pulumi.set(__self__, "branch", branch)
        if repo_clone_url is not None:
            pulumi.set(__self__, "repo_clone_url", repo_clone_url)

    @property
    @pulumi.getter
    def branch(self) -> Optional[str]:
        """
        The name of the branch to use.
        """
        return pulumi.get(self, "branch")

    @property
    @pulumi.getter(name="repoCloneUrl")
    def repo_clone_url(self) -> Optional[str]:
        """
        The clone URL of the repo.
        """
        return pulumi.get(self, "repo_clone_url")


@pulumi.output_type
class AppSpecJobGithub(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deployOnPush":
            suggest = "deploy_on_push"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppSpecJobGithub. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppSpecJobGithub.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppSpecJobGithub.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 branch: Optional[str] = None,
                 deploy_on_push: Optional[bool] = None,
                 repo: Optional[str] = None):
        """
        :param str branch: The name of the branch to use.
        :param bool deploy_on_push: Whether to automatically deploy new commits made to the repo.
        :param str repo: The name of the repo in the format `owner/repo`.
        """
        if branch is not None:
            pulumi.set(__self__, "branch", branch)
        if deploy_on_push is not None:
            pulumi.set(__self__, "deploy_on_push", deploy_on_push)
        if repo is not None:
            pulumi.set(__self__, "repo", repo)

    @property
    @pulumi.getter
    def branch(self) -> Optional[str]:
        """
        The name of the branch to use.
        """
        return pulumi.get(self, "branch")

    @property
    @pulumi.getter(name="deployOnPush")
    def deploy_on_push(self) -> Optional[bool]:
        """
        Whether to automatically deploy new commits made to the repo.
        """
        return pulumi.get(self, "deploy_on_push")

    @property
    @pulumi.getter
    def repo(self) -> Optional[str]:
        """
        The name of the repo in the format `owner/repo`.
        """
        return pulumi.get(self, "repo")


@pulumi.output_type
class AppSpecJobGitlab(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deployOnPush":
            suggest = "deploy_on_push"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppSpecJobGitlab. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppSpecJobGitlab.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppSpecJobGitlab.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 branch: Optional[str] = None,
                 deploy_on_push: Optional[bool] = None,
                 repo: Optional[str] = None):
        """
        :param str branch: The name of the branch to use.
        :param bool deploy_on_push: Whether to automatically deploy new commits made to the repo.
        :param str repo: The name of the repo in the format `owner/repo`.
        """
        if branch is not None:
            pulumi.set(__self__, "branch", branch)
        if deploy_on_push is not None:
            pulumi.set(__self__, "deploy_on_push", deploy_on_push)
        if repo is not None:
            pulumi.set(__self__, "repo", repo)

    @property
    @pulumi.getter
    def branch(self) -> Optional[str]:
        """
        The name of the branch to use.
        """
        return pulumi.get(self, "branch")

    @property
    @pulumi.getter(name="deployOnPush")
    def deploy_on_push(self) -> Optional[bool]:
        """
        Whether to automatically deploy new commits made to the repo.
        """
        return pulumi.get(self, "deploy_on_push")

    @property
    @pulumi.getter
    def repo(self) -> Optional[str]:
        """
        The name of the repo in the format `owner/repo`.
        """
        return pulumi.get(self, "repo")


@pulumi.output_type
class AppSpecJobImage(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "registryType":
            suggest = "registry_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppSpecJobImage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppSpecJobImage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppSpecJobImage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 registry_type: str,
                 repository: str,
                 registry: Optional[str] = None,
                 tag: Optional[str] = None):
        """
        :param str registry_type: The registry type. One of `DOCR` (DigitalOcean container registry) or `DOCKER_HUB`.
        :param str repository: The repository name.
        :param str registry: The registry name. Must be left empty for the `DOCR` registry type. Required for the `DOCKER_HUB` registry type.
        :param str tag: The repository tag. Defaults to `latest` if not provided.
        """
        pulumi.set(__self__, "registry_type", registry_type)
        pulumi.set(__self__, "repository", repository)
        if registry is not None:
            pulumi.set(__self__, "registry", registry)
        if tag is not None:
            pulumi.set(__self__, "tag", tag)

    @property
    @pulumi.getter(name="registryType")
    def registry_type(self) -> str:
        """
        The registry type. One of `DOCR` (DigitalOcean container registry) or `DOCKER_HUB`.
        """
        return pulumi.get(self, "registry_type")

    @property
    @pulumi.getter
    def repository(self) -> str:
        """
        The repository name.
        """
        return pulumi.get(self, "repository")

    @property
    @pulumi.getter
    def registry(self) -> Optional[str]:
        """
        The registry name. Must be left empty for the `DOCR` registry type. Required for the `DOCKER_HUB` registry type.
        """
        return pulumi.get(self, "registry")

    @property
    @pulumi.getter
    def tag(self) -> Optional[str]:
        """
        The repository tag. Defaults to `latest` if not provided.
        """
        return pulumi.get(self, "tag")


@pulumi.output_type
class AppSpecService(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "buildCommand":
            suggest = "build_command"
        elif key == "dockerfilePath":
            suggest = "dockerfile_path"
        elif key == "environmentSlug":
            suggest = "environment_slug"
        elif key == "healthCheck":
            suggest = "health_check"
        elif key == "httpPort":
            suggest = "http_port"
        elif key == "instanceCount":
            suggest = "instance_count"
        elif key == "instanceSizeSlug":
            suggest = "instance_size_slug"
        elif key == "internalPorts":
            suggest = "internal_ports"
        elif key == "runCommand":
            suggest = "run_command"
        elif key == "sourceDir":
            suggest = "source_dir"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppSpecService. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppSpecService.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppSpecService.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 build_command: Optional[str] = None,
                 dockerfile_path: Optional[str] = None,
                 environment_slug: Optional[str] = None,
                 envs: Optional[Sequence['outputs.AppSpecServiceEnv']] = None,
                 git: Optional['outputs.AppSpecServiceGit'] = None,
                 github: Optional['outputs.AppSpecServiceGithub'] = None,
                 gitlab: Optional['outputs.AppSpecServiceGitlab'] = None,
                 health_check: Optional['outputs.AppSpecServiceHealthCheck'] = None,
                 http_port: Optional[int] = None,
                 image: Optional['outputs.AppSpecServiceImage'] = None,
                 instance_count: Optional[int] = None,
                 instance_size_slug: Optional[str] = None,
                 internal_ports: Optional[Sequence[int]] = None,
                 routes: Optional[Sequence['outputs.AppSpecServiceRoute']] = None,
                 run_command: Optional[str] = None,
                 source_dir: Optional[str] = None):
        """
        :param str name: The name of the component.
        :param str build_command: An optional build command to run while building this component from source.
        :param str dockerfile_path: The path to a Dockerfile relative to the root of the repo. If set, overrides usage of buildpacks.
        :param str environment_slug: An environment slug describing the type of this app.
        :param Sequence['AppSpecServiceEnvArgs'] envs: Describes an environment variable made available to an app competent.
        :param 'AppSpecServiceGitArgs' git: A Git repo to use as the component's source. The repository must be able to be cloned without authentication.  Only one of `git`, `github` or `gitlab`  may be set
        :param 'AppSpecServiceGithubArgs' github: A GitHub repo to use as the component's source. DigitalOcean App Platform must have [access to the repository](https://cloud.digitalocean.com/apps/github/install). Only one of `git`, `github`, `gitlab`, or `image` may be set.
        :param 'AppSpecServiceGitlabArgs' gitlab: A Gitlab repo to use as the component's source. DigitalOcean App Platform must have [access to the repository](https://cloud.digitalocean.com/apps/gitlab/install). Only one of `git`, `github`, `gitlab`, or `image` may be set.
        :param 'AppSpecServiceHealthCheckArgs' health_check: A health check to determine the availability of this component.
        :param int http_port: The internal port on which this service's run command will listen.
        :param 'AppSpecServiceImageArgs' image: An image to use as the component's source. Only one of `git`, `github`, `gitlab`, or `image` may be set.
        :param int instance_count: The amount of instances that this component should be scaled to.
        :param str instance_size_slug: The instance size to use for this component.
        :param Sequence[int] internal_ports: A list of ports on which this service will listen for internal traffic.
        :param str run_command: An optional run command to override the component's default.
        :param str source_dir: An optional path to the working directory to use for the build.
        """
        pulumi.set(__self__, "name", name)
        if build_command is not None:
            pulumi.set(__self__, "build_command", build_command)
        if dockerfile_path is not None:
            pulumi.set(__self__, "dockerfile_path", dockerfile_path)
        if environment_slug is not None:
            pulumi.set(__self__, "environment_slug", environment_slug)
        if envs is not None:
            pulumi.set(__self__, "envs", envs)
        if git is not None:
            pulumi.set(__self__, "git", git)
        if github is not None:
            pulumi.set(__self__, "github", github)
        if gitlab is not None:
            pulumi.set(__self__, "gitlab", gitlab)
        if health_check is not None:
            pulumi.set(__self__, "health_check", health_check)
        if http_port is not None:
            pulumi.set(__self__, "http_port", http_port)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if instance_count is not None:
            pulumi.set(__self__, "instance_count", instance_count)
        if instance_size_slug is not None:
            pulumi.set(__self__, "instance_size_slug", instance_size_slug)
        if internal_ports is not None:
            pulumi.set(__self__, "internal_ports", internal_ports)
        if routes is not None:
            pulumi.set(__self__, "routes", routes)
        if run_command is not None:
            pulumi.set(__self__, "run_command", run_command)
        if source_dir is not None:
            pulumi.set(__self__, "source_dir", source_dir)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the component.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="buildCommand")
    def build_command(self) -> Optional[str]:
        """
        An optional build command to run while building this component from source.
        """
        return pulumi.get(self, "build_command")

    @property
    @pulumi.getter(name="dockerfilePath")
    def dockerfile_path(self) -> Optional[str]:
        """
        The path to a Dockerfile relative to the root of the repo. If set, overrides usage of buildpacks.
        """
        return pulumi.get(self, "dockerfile_path")

    @property
    @pulumi.getter(name="environmentSlug")
    def environment_slug(self) -> Optional[str]:
        """
        An environment slug describing the type of this app.
        """
        return pulumi.get(self, "environment_slug")

    @property
    @pulumi.getter
    def envs(self) -> Optional[Sequence['outputs.AppSpecServiceEnv']]:
        """
        Describes an environment variable made available to an app competent.
        """
        return pulumi.get(self, "envs")

    @property
    @pulumi.getter
    def git(self) -> Optional['outputs.AppSpecServiceGit']:
        """
        A Git repo to use as the component's source. The repository must be able to be cloned without authentication.  Only one of `git`, `github` or `gitlab`  may be set
        """
        return pulumi.get(self, "git")

    @property
    @pulumi.getter
    def github(self) -> Optional['outputs.AppSpecServiceGithub']:
        """
        A GitHub repo to use as the component's source. DigitalOcean App Platform must have [access to the repository](https://cloud.digitalocean.com/apps/github/install). Only one of `git`, `github`, `gitlab`, or `image` may be set.
        """
        return pulumi.get(self, "github")

    @property
    @pulumi.getter
    def gitlab(self) -> Optional['outputs.AppSpecServiceGitlab']:
        """
        A Gitlab repo to use as the component's source. DigitalOcean App Platform must have [access to the repository](https://cloud.digitalocean.com/apps/gitlab/install). Only one of `git`, `github`, `gitlab`, or `image` may be set.
        """
        return pulumi.get(self, "gitlab")

    @property
    @pulumi.getter(name="healthCheck")
    def health_check(self) -> Optional['outputs.AppSpecServiceHealthCheck']:
        """
        A health check to determine the availability of this component.
        """
        return pulumi.get(self, "health_check")

    @property
    @pulumi.getter(name="httpPort")
    def http_port(self) -> Optional[int]:
        """
        The internal port on which this service's run command will listen.
        """
        return pulumi.get(self, "http_port")

    @property
    @pulumi.getter
    def image(self) -> Optional['outputs.AppSpecServiceImage']:
        """
        An image to use as the component's source. Only one of `git`, `github`, `gitlab`, or `image` may be set.
        """
        return pulumi.get(self, "image")

    @property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> Optional[int]:
        """
        The amount of instances that this component should be scaled to.
        """
        return pulumi.get(self, "instance_count")

    @property
    @pulumi.getter(name="instanceSizeSlug")
    def instance_size_slug(self) -> Optional[str]:
        """
        The instance size to use for this component.
        """
        return pulumi.get(self, "instance_size_slug")

    @property
    @pulumi.getter(name="internalPorts")
    def internal_ports(self) -> Optional[Sequence[int]]:
        """
        A list of ports on which this service will listen for internal traffic.
        """
        return pulumi.get(self, "internal_ports")

    @property
    @pulumi.getter
    def routes(self) -> Optional[Sequence['outputs.AppSpecServiceRoute']]:
        return pulumi.get(self, "routes")

    @property
    @pulumi.getter(name="runCommand")
    def run_command(self) -> Optional[str]:
        """
        An optional run command to override the component's default.
        """
        return pulumi.get(self, "run_command")

    @property
    @pulumi.getter(name="sourceDir")
    def source_dir(self) -> Optional[str]:
        """
        An optional path to the working directory to use for the build.
        """
        return pulumi.get(self, "source_dir")


@pulumi.output_type
class AppSpecServiceEnv(dict):
    def __init__(__self__, *,
                 key: Optional[str] = None,
                 scope: Optional[str] = None,
                 type: Optional[str] = None,
                 value: Optional[str] = None):
        """
        :param str key: The name of the environment variable.
        :param str scope: The visibility scope of the environment variable. One of `RUN_TIME`, `BUILD_TIME`, or `RUN_AND_BUILD_TIME` (default).
        :param str type: The type of the environment variable, `GENERAL` or `SECRET`.
        :param str value: The value of the environment variable.
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[str]:
        """
        The name of the environment variable.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def scope(self) -> Optional[str]:
        """
        The visibility scope of the environment variable. One of `RUN_TIME`, `BUILD_TIME`, or `RUN_AND_BUILD_TIME` (default).
        """
        return pulumi.get(self, "scope")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The type of the environment variable, `GENERAL` or `SECRET`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        The value of the environment variable.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class AppSpecServiceGit(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "repoCloneUrl":
            suggest = "repo_clone_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppSpecServiceGit. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppSpecServiceGit.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppSpecServiceGit.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 branch: Optional[str] = None,
                 repo_clone_url: Optional[str] = None):
        """
        :param str branch: The name of the branch to use.
        :param str repo_clone_url: The clone URL of the repo.
        """
        if branch is not None:
            pulumi.set(__self__, "branch", branch)
        if repo_clone_url is not None:
            pulumi.set(__self__, "repo_clone_url", repo_clone_url)

    @property
    @pulumi.getter
    def branch(self) -> Optional[str]:
        """
        The name of the branch to use.
        """
        return pulumi.get(self, "branch")

    @property
    @pulumi.getter(name="repoCloneUrl")
    def repo_clone_url(self) -> Optional[str]:
        """
        The clone URL of the repo.
        """
        return pulumi.get(self, "repo_clone_url")


@pulumi.output_type
class AppSpecServiceGithub(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deployOnPush":
            suggest = "deploy_on_push"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppSpecServiceGithub. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppSpecServiceGithub.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppSpecServiceGithub.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 branch: Optional[str] = None,
                 deploy_on_push: Optional[bool] = None,
                 repo: Optional[str] = None):
        """
        :param str branch: The name of the branch to use.
        :param bool deploy_on_push: Whether to automatically deploy new commits made to the repo.
        :param str repo: The name of the repo in the format `owner/repo`.
        """
        if branch is not None:
            pulumi.set(__self__, "branch", branch)
        if deploy_on_push is not None:
            pulumi.set(__self__, "deploy_on_push", deploy_on_push)
        if repo is not None:
            pulumi.set(__self__, "repo", repo)

    @property
    @pulumi.getter
    def branch(self) -> Optional[str]:
        """
        The name of the branch to use.
        """
        return pulumi.get(self, "branch")

    @property
    @pulumi.getter(name="deployOnPush")
    def deploy_on_push(self) -> Optional[bool]:
        """
        Whether to automatically deploy new commits made to the repo.
        """
        return pulumi.get(self, "deploy_on_push")

    @property
    @pulumi.getter
    def repo(self) -> Optional[str]:
        """
        The name of the repo in the format `owner/repo`.
        """
        return pulumi.get(self, "repo")


@pulumi.output_type
class AppSpecServiceGitlab(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deployOnPush":
            suggest = "deploy_on_push"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppSpecServiceGitlab. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppSpecServiceGitlab.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppSpecServiceGitlab.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 branch: Optional[str] = None,
                 deploy_on_push: Optional[bool] = None,
                 repo: Optional[str] = None):
        """
        :param str branch: The name of the branch to use.
        :param bool deploy_on_push: Whether to automatically deploy new commits made to the repo.
        :param str repo: The name of the repo in the format `owner/repo`.
        """
        if branch is not None:
            pulumi.set(__self__, "branch", branch)
        if deploy_on_push is not None:
            pulumi.set(__self__, "deploy_on_push", deploy_on_push)
        if repo is not None:
            pulumi.set(__self__, "repo", repo)

    @property
    @pulumi.getter
    def branch(self) -> Optional[str]:
        """
        The name of the branch to use.
        """
        return pulumi.get(self, "branch")

    @property
    @pulumi.getter(name="deployOnPush")
    def deploy_on_push(self) -> Optional[bool]:
        """
        Whether to automatically deploy new commits made to the repo.
        """
        return pulumi.get(self, "deploy_on_push")

    @property
    @pulumi.getter
    def repo(self) -> Optional[str]:
        """
        The name of the repo in the format `owner/repo`.
        """
        return pulumi.get(self, "repo")


@pulumi.output_type
class AppSpecServiceHealthCheck(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "failureThreshold":
            suggest = "failure_threshold"
        elif key == "httpPath":
            suggest = "http_path"
        elif key == "initialDelaySeconds":
            suggest = "initial_delay_seconds"
        elif key == "periodSeconds":
            suggest = "period_seconds"
        elif key == "successThreshold":
            suggest = "success_threshold"
        elif key == "timeoutSeconds":
            suggest = "timeout_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppSpecServiceHealthCheck. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppSpecServiceHealthCheck.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppSpecServiceHealthCheck.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 failure_threshold: Optional[int] = None,
                 http_path: Optional[str] = None,
                 initial_delay_seconds: Optional[int] = None,
                 period_seconds: Optional[int] = None,
                 success_threshold: Optional[int] = None,
                 timeout_seconds: Optional[int] = None):
        """
        :param int failure_threshold: The number of failed health checks before considered unhealthy.
        :param str http_path: The route path used for the HTTP health check ping.
        :param int initial_delay_seconds: The number of seconds to wait before beginning health checks.
        :param int period_seconds: The number of seconds to wait between health checks.
        :param int success_threshold: The number of successful health checks before considered healthy.
        :param int timeout_seconds: The number of seconds after which the check times out.
        """
        if failure_threshold is not None:
            pulumi.set(__self__, "failure_threshold", failure_threshold)
        if http_path is not None:
            pulumi.set(__self__, "http_path", http_path)
        if initial_delay_seconds is not None:
            pulumi.set(__self__, "initial_delay_seconds", initial_delay_seconds)
        if period_seconds is not None:
            pulumi.set(__self__, "period_seconds", period_seconds)
        if success_threshold is not None:
            pulumi.set(__self__, "success_threshold", success_threshold)
        if timeout_seconds is not None:
            pulumi.set(__self__, "timeout_seconds", timeout_seconds)

    @property
    @pulumi.getter(name="failureThreshold")
    def failure_threshold(self) -> Optional[int]:
        """
        The number of failed health checks before considered unhealthy.
        """
        return pulumi.get(self, "failure_threshold")

    @property
    @pulumi.getter(name="httpPath")
    def http_path(self) -> Optional[str]:
        """
        The route path used for the HTTP health check ping.
        """
        return pulumi.get(self, "http_path")

    @property
    @pulumi.getter(name="initialDelaySeconds")
    def initial_delay_seconds(self) -> Optional[int]:
        """
        The number of seconds to wait before beginning health checks.
        """
        return pulumi.get(self, "initial_delay_seconds")

    @property
    @pulumi.getter(name="periodSeconds")
    def period_seconds(self) -> Optional[int]:
        """
        The number of seconds to wait between health checks.
        """
        return pulumi.get(self, "period_seconds")

    @property
    @pulumi.getter(name="successThreshold")
    def success_threshold(self) -> Optional[int]:
        """
        The number of successful health checks before considered healthy.
        """
        return pulumi.get(self, "success_threshold")

    @property
    @pulumi.getter(name="timeoutSeconds")
    def timeout_seconds(self) -> Optional[int]:
        """
        The number of seconds after which the check times out.
        """
        return pulumi.get(self, "timeout_seconds")


@pulumi.output_type
class AppSpecServiceImage(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "registryType":
            suggest = "registry_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppSpecServiceImage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppSpecServiceImage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppSpecServiceImage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 registry_type: str,
                 repository: str,
                 registry: Optional[str] = None,
                 tag: Optional[str] = None):
        """
        :param str registry_type: The registry type. One of `DOCR` (DigitalOcean container registry) or `DOCKER_HUB`.
        :param str repository: The repository name.
        :param str registry: The registry name. Must be left empty for the `DOCR` registry type. Required for the `DOCKER_HUB` registry type.
        :param str tag: The repository tag. Defaults to `latest` if not provided.
        """
        pulumi.set(__self__, "registry_type", registry_type)
        pulumi.set(__self__, "repository", repository)
        if registry is not None:
            pulumi.set(__self__, "registry", registry)
        if tag is not None:
            pulumi.set(__self__, "tag", tag)

    @property
    @pulumi.getter(name="registryType")
    def registry_type(self) -> str:
        """
        The registry type. One of `DOCR` (DigitalOcean container registry) or `DOCKER_HUB`.
        """
        return pulumi.get(self, "registry_type")

    @property
    @pulumi.getter
    def repository(self) -> str:
        """
        The repository name.
        """
        return pulumi.get(self, "repository")

    @property
    @pulumi.getter
    def registry(self) -> Optional[str]:
        """
        The registry name. Must be left empty for the `DOCR` registry type. Required for the `DOCKER_HUB` registry type.
        """
        return pulumi.get(self, "registry")

    @property
    @pulumi.getter
    def tag(self) -> Optional[str]:
        """
        The repository tag. Defaults to `latest` if not provided.
        """
        return pulumi.get(self, "tag")


@pulumi.output_type
class AppSpecServiceRoute(dict):
    def __init__(__self__, *,
                 path: Optional[str] = None):
        """
        :param str path: Paths must start with `/` and must be unique within the app.
        """
        if path is not None:
            pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        Paths must start with `/` and must be unique within the app.
        """
        return pulumi.get(self, "path")


@pulumi.output_type
class AppSpecStaticSite(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "buildCommand":
            suggest = "build_command"
        elif key == "catchallDocument":
            suggest = "catchall_document"
        elif key == "dockerfilePath":
            suggest = "dockerfile_path"
        elif key == "environmentSlug":
            suggest = "environment_slug"
        elif key == "errorDocument":
            suggest = "error_document"
        elif key == "indexDocument":
            suggest = "index_document"
        elif key == "outputDir":
            suggest = "output_dir"
        elif key == "sourceDir":
            suggest = "source_dir"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppSpecStaticSite. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppSpecStaticSite.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppSpecStaticSite.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 build_command: Optional[str] = None,
                 catchall_document: Optional[str] = None,
                 dockerfile_path: Optional[str] = None,
                 environment_slug: Optional[str] = None,
                 envs: Optional[Sequence['outputs.AppSpecStaticSiteEnv']] = None,
                 error_document: Optional[str] = None,
                 git: Optional['outputs.AppSpecStaticSiteGit'] = None,
                 github: Optional['outputs.AppSpecStaticSiteGithub'] = None,
                 gitlab: Optional['outputs.AppSpecStaticSiteGitlab'] = None,
                 index_document: Optional[str] = None,
                 output_dir: Optional[str] = None,
                 routes: Optional[Sequence['outputs.AppSpecStaticSiteRoute']] = None,
                 source_dir: Optional[str] = None):
        """
        :param str name: The name of the component.
        :param str build_command: An optional build command to run while building this component from source.
        :param str catchall_document: The name of the document to use as the fallback for any requests to documents that are not found when serving this static site.
        :param str dockerfile_path: The path to a Dockerfile relative to the root of the repo. If set, overrides usage of buildpacks.
        :param str environment_slug: An environment slug describing the type of this app.
        :param Sequence['AppSpecStaticSiteEnvArgs'] envs: Describes an environment variable made available to an app competent.
        :param str error_document: The name of the error document to use when serving this static site.
        :param 'AppSpecStaticSiteGitArgs' git: A Git repo to use as the component's source. The repository must be able to be cloned without authentication.  Only one of `git`, `github` or `gitlab`  may be set
        :param 'AppSpecStaticSiteGithubArgs' github: A GitHub repo to use as the component's source. DigitalOcean App Platform must have [access to the repository](https://cloud.digitalocean.com/apps/github/install). Only one of `git`, `github`, `gitlab`, or `image` may be set.
        :param 'AppSpecStaticSiteGitlabArgs' gitlab: A Gitlab repo to use as the component's source. DigitalOcean App Platform must have [access to the repository](https://cloud.digitalocean.com/apps/gitlab/install). Only one of `git`, `github`, `gitlab`, or `image` may be set.
        :param str index_document: The name of the index document to use when serving this static site.
        :param str output_dir: An optional path to where the built assets will be located, relative to the build context. If not set, App Platform will automatically scan for these directory names: `_static`, `dist`, `public`.
        :param str source_dir: An optional path to the working directory to use for the build.
        """
        pulumi.set(__self__, "name", name)
        if build_command is not None:
            pulumi.set(__self__, "build_command", build_command)
        if catchall_document is not None:
            pulumi.set(__self__, "catchall_document", catchall_document)
        if dockerfile_path is not None:
            pulumi.set(__self__, "dockerfile_path", dockerfile_path)
        if environment_slug is not None:
            pulumi.set(__self__, "environment_slug", environment_slug)
        if envs is not None:
            pulumi.set(__self__, "envs", envs)
        if error_document is not None:
            pulumi.set(__self__, "error_document", error_document)
        if git is not None:
            pulumi.set(__self__, "git", git)
        if github is not None:
            pulumi.set(__self__, "github", github)
        if gitlab is not None:
            pulumi.set(__self__, "gitlab", gitlab)
        if index_document is not None:
            pulumi.set(__self__, "index_document", index_document)
        if output_dir is not None:
            pulumi.set(__self__, "output_dir", output_dir)
        if routes is not None:
            pulumi.set(__self__, "routes", routes)
        if source_dir is not None:
            pulumi.set(__self__, "source_dir", source_dir)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the component.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="buildCommand")
    def build_command(self) -> Optional[str]:
        """
        An optional build command to run while building this component from source.
        """
        return pulumi.get(self, "build_command")

    @property
    @pulumi.getter(name="catchallDocument")
    def catchall_document(self) -> Optional[str]:
        """
        The name of the document to use as the fallback for any requests to documents that are not found when serving this static site.
        """
        return pulumi.get(self, "catchall_document")

    @property
    @pulumi.getter(name="dockerfilePath")
    def dockerfile_path(self) -> Optional[str]:
        """
        The path to a Dockerfile relative to the root of the repo. If set, overrides usage of buildpacks.
        """
        return pulumi.get(self, "dockerfile_path")

    @property
    @pulumi.getter(name="environmentSlug")
    def environment_slug(self) -> Optional[str]:
        """
        An environment slug describing the type of this app.
        """
        return pulumi.get(self, "environment_slug")

    @property
    @pulumi.getter
    def envs(self) -> Optional[Sequence['outputs.AppSpecStaticSiteEnv']]:
        """
        Describes an environment variable made available to an app competent.
        """
        return pulumi.get(self, "envs")

    @property
    @pulumi.getter(name="errorDocument")
    def error_document(self) -> Optional[str]:
        """
        The name of the error document to use when serving this static site.
        """
        return pulumi.get(self, "error_document")

    @property
    @pulumi.getter
    def git(self) -> Optional['outputs.AppSpecStaticSiteGit']:
        """
        A Git repo to use as the component's source. The repository must be able to be cloned without authentication.  Only one of `git`, `github` or `gitlab`  may be set
        """
        return pulumi.get(self, "git")

    @property
    @pulumi.getter
    def github(self) -> Optional['outputs.AppSpecStaticSiteGithub']:
        """
        A GitHub repo to use as the component's source. DigitalOcean App Platform must have [access to the repository](https://cloud.digitalocean.com/apps/github/install). Only one of `git`, `github`, `gitlab`, or `image` may be set.
        """
        return pulumi.get(self, "github")

    @property
    @pulumi.getter
    def gitlab(self) -> Optional['outputs.AppSpecStaticSiteGitlab']:
        """
        A Gitlab repo to use as the component's source. DigitalOcean App Platform must have [access to the repository](https://cloud.digitalocean.com/apps/gitlab/install). Only one of `git`, `github`, `gitlab`, or `image` may be set.
        """
        return pulumi.get(self, "gitlab")

    @property
    @pulumi.getter(name="indexDocument")
    def index_document(self) -> Optional[str]:
        """
        The name of the index document to use when serving this static site.
        """
        return pulumi.get(self, "index_document")

    @property
    @pulumi.getter(name="outputDir")
    def output_dir(self) -> Optional[str]:
        """
        An optional path to where the built assets will be located, relative to the build context. If not set, App Platform will automatically scan for these directory names: `_static`, `dist`, `public`.
        """
        return pulumi.get(self, "output_dir")

    @property
    @pulumi.getter
    def routes(self) -> Optional[Sequence['outputs.AppSpecStaticSiteRoute']]:
        return pulumi.get(self, "routes")

    @property
    @pulumi.getter(name="sourceDir")
    def source_dir(self) -> Optional[str]:
        """
        An optional path to the working directory to use for the build.
        """
        return pulumi.get(self, "source_dir")


@pulumi.output_type
class AppSpecStaticSiteEnv(dict):
    def __init__(__self__, *,
                 key: Optional[str] = None,
                 scope: Optional[str] = None,
                 type: Optional[str] = None,
                 value: Optional[str] = None):
        """
        :param str key: The name of the environment variable.
        :param str scope: The visibility scope of the environment variable. One of `RUN_TIME`, `BUILD_TIME`, or `RUN_AND_BUILD_TIME` (default).
        :param str type: The type of the environment variable, `GENERAL` or `SECRET`.
        :param str value: The value of the environment variable.
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[str]:
        """
        The name of the environment variable.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def scope(self) -> Optional[str]:
        """
        The visibility scope of the environment variable. One of `RUN_TIME`, `BUILD_TIME`, or `RUN_AND_BUILD_TIME` (default).
        """
        return pulumi.get(self, "scope")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The type of the environment variable, `GENERAL` or `SECRET`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        The value of the environment variable.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class AppSpecStaticSiteGit(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "repoCloneUrl":
            suggest = "repo_clone_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppSpecStaticSiteGit. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppSpecStaticSiteGit.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppSpecStaticSiteGit.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 branch: Optional[str] = None,
                 repo_clone_url: Optional[str] = None):
        """
        :param str branch: The name of the branch to use.
        :param str repo_clone_url: The clone URL of the repo.
        """
        if branch is not None:
            pulumi.set(__self__, "branch", branch)
        if repo_clone_url is not None:
            pulumi.set(__self__, "repo_clone_url", repo_clone_url)

    @property
    @pulumi.getter
    def branch(self) -> Optional[str]:
        """
        The name of the branch to use.
        """
        return pulumi.get(self, "branch")

    @property
    @pulumi.getter(name="repoCloneUrl")
    def repo_clone_url(self) -> Optional[str]:
        """
        The clone URL of the repo.
        """
        return pulumi.get(self, "repo_clone_url")


@pulumi.output_type
class AppSpecStaticSiteGithub(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deployOnPush":
            suggest = "deploy_on_push"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppSpecStaticSiteGithub. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppSpecStaticSiteGithub.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppSpecStaticSiteGithub.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 branch: Optional[str] = None,
                 deploy_on_push: Optional[bool] = None,
                 repo: Optional[str] = None):
        """
        :param str branch: The name of the branch to use.
        :param bool deploy_on_push: Whether to automatically deploy new commits made to the repo.
        :param str repo: The name of the repo in the format `owner/repo`.
        """
        if branch is not None:
            pulumi.set(__self__, "branch", branch)
        if deploy_on_push is not None:
            pulumi.set(__self__, "deploy_on_push", deploy_on_push)
        if repo is not None:
            pulumi.set(__self__, "repo", repo)

    @property
    @pulumi.getter
    def branch(self) -> Optional[str]:
        """
        The name of the branch to use.
        """
        return pulumi.get(self, "branch")

    @property
    @pulumi.getter(name="deployOnPush")
    def deploy_on_push(self) -> Optional[bool]:
        """
        Whether to automatically deploy new commits made to the repo.
        """
        return pulumi.get(self, "deploy_on_push")

    @property
    @pulumi.getter
    def repo(self) -> Optional[str]:
        """
        The name of the repo in the format `owner/repo`.
        """
        return pulumi.get(self, "repo")


@pulumi.output_type
class AppSpecStaticSiteGitlab(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deployOnPush":
            suggest = "deploy_on_push"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppSpecStaticSiteGitlab. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppSpecStaticSiteGitlab.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppSpecStaticSiteGitlab.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 branch: Optional[str] = None,
                 deploy_on_push: Optional[bool] = None,
                 repo: Optional[str] = None):
        """
        :param str branch: The name of the branch to use.
        :param bool deploy_on_push: Whether to automatically deploy new commits made to the repo.
        :param str repo: The name of the repo in the format `owner/repo`.
        """
        if branch is not None:
            pulumi.set(__self__, "branch", branch)
        if deploy_on_push is not None:
            pulumi.set(__self__, "deploy_on_push", deploy_on_push)
        if repo is not None:
            pulumi.set(__self__, "repo", repo)

    @property
    @pulumi.getter
    def branch(self) -> Optional[str]:
        """
        The name of the branch to use.
        """
        return pulumi.get(self, "branch")

    @property
    @pulumi.getter(name="deployOnPush")
    def deploy_on_push(self) -> Optional[bool]:
        """
        Whether to automatically deploy new commits made to the repo.
        """
        return pulumi.get(self, "deploy_on_push")

    @property
    @pulumi.getter
    def repo(self) -> Optional[str]:
        """
        The name of the repo in the format `owner/repo`.
        """
        return pulumi.get(self, "repo")


@pulumi.output_type
class AppSpecStaticSiteRoute(dict):
    def __init__(__self__, *,
                 path: Optional[str] = None):
        """
        :param str path: Paths must start with `/` and must be unique within the app.
        """
        if path is not None:
            pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        Paths must start with `/` and must be unique within the app.
        """
        return pulumi.get(self, "path")


@pulumi.output_type
class AppSpecWorker(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "buildCommand":
            suggest = "build_command"
        elif key == "dockerfilePath":
            suggest = "dockerfile_path"
        elif key == "environmentSlug":
            suggest = "environment_slug"
        elif key == "instanceCount":
            suggest = "instance_count"
        elif key == "instanceSizeSlug":
            suggest = "instance_size_slug"
        elif key == "runCommand":
            suggest = "run_command"
        elif key == "sourceDir":
            suggest = "source_dir"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppSpecWorker. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppSpecWorker.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppSpecWorker.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 build_command: Optional[str] = None,
                 dockerfile_path: Optional[str] = None,
                 environment_slug: Optional[str] = None,
                 envs: Optional[Sequence['outputs.AppSpecWorkerEnv']] = None,
                 git: Optional['outputs.AppSpecWorkerGit'] = None,
                 github: Optional['outputs.AppSpecWorkerGithub'] = None,
                 gitlab: Optional['outputs.AppSpecWorkerGitlab'] = None,
                 image: Optional['outputs.AppSpecWorkerImage'] = None,
                 instance_count: Optional[int] = None,
                 instance_size_slug: Optional[str] = None,
                 run_command: Optional[str] = None,
                 source_dir: Optional[str] = None):
        """
        :param str name: The name of the component.
        :param str build_command: An optional build command to run while building this component from source.
        :param str dockerfile_path: The path to a Dockerfile relative to the root of the repo. If set, overrides usage of buildpacks.
        :param str environment_slug: An environment slug describing the type of this app.
        :param Sequence['AppSpecWorkerEnvArgs'] envs: Describes an environment variable made available to an app competent.
        :param 'AppSpecWorkerGitArgs' git: A Git repo to use as the component's source. The repository must be able to be cloned without authentication.  Only one of `git`, `github` or `gitlab`  may be set
        :param 'AppSpecWorkerGithubArgs' github: A GitHub repo to use as the component's source. DigitalOcean App Platform must have [access to the repository](https://cloud.digitalocean.com/apps/github/install). Only one of `git`, `github`, `gitlab`, or `image` may be set.
        :param 'AppSpecWorkerGitlabArgs' gitlab: A Gitlab repo to use as the component's source. DigitalOcean App Platform must have [access to the repository](https://cloud.digitalocean.com/apps/gitlab/install). Only one of `git`, `github`, `gitlab`, or `image` may be set.
        :param 'AppSpecWorkerImageArgs' image: An image to use as the component's source. Only one of `git`, `github`, `gitlab`, or `image` may be set.
        :param int instance_count: The amount of instances that this component should be scaled to.
        :param str instance_size_slug: The instance size to use for this component.
        :param str run_command: An optional run command to override the component's default.
        :param str source_dir: An optional path to the working directory to use for the build.
        """
        pulumi.set(__self__, "name", name)
        if build_command is not None:
            pulumi.set(__self__, "build_command", build_command)
        if dockerfile_path is not None:
            pulumi.set(__self__, "dockerfile_path", dockerfile_path)
        if environment_slug is not None:
            pulumi.set(__self__, "environment_slug", environment_slug)
        if envs is not None:
            pulumi.set(__self__, "envs", envs)
        if git is not None:
            pulumi.set(__self__, "git", git)
        if github is not None:
            pulumi.set(__self__, "github", github)
        if gitlab is not None:
            pulumi.set(__self__, "gitlab", gitlab)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if instance_count is not None:
            pulumi.set(__self__, "instance_count", instance_count)
        if instance_size_slug is not None:
            pulumi.set(__self__, "instance_size_slug", instance_size_slug)
        if run_command is not None:
            pulumi.set(__self__, "run_command", run_command)
        if source_dir is not None:
            pulumi.set(__self__, "source_dir", source_dir)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the component.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="buildCommand")
    def build_command(self) -> Optional[str]:
        """
        An optional build command to run while building this component from source.
        """
        return pulumi.get(self, "build_command")

    @property
    @pulumi.getter(name="dockerfilePath")
    def dockerfile_path(self) -> Optional[str]:
        """
        The path to a Dockerfile relative to the root of the repo. If set, overrides usage of buildpacks.
        """
        return pulumi.get(self, "dockerfile_path")

    @property
    @pulumi.getter(name="environmentSlug")
    def environment_slug(self) -> Optional[str]:
        """
        An environment slug describing the type of this app.
        """
        return pulumi.get(self, "environment_slug")

    @property
    @pulumi.getter
    def envs(self) -> Optional[Sequence['outputs.AppSpecWorkerEnv']]:
        """
        Describes an environment variable made available to an app competent.
        """
        return pulumi.get(self, "envs")

    @property
    @pulumi.getter
    def git(self) -> Optional['outputs.AppSpecWorkerGit']:
        """
        A Git repo to use as the component's source. The repository must be able to be cloned without authentication.  Only one of `git`, `github` or `gitlab`  may be set
        """
        return pulumi.get(self, "git")

    @property
    @pulumi.getter
    def github(self) -> Optional['outputs.AppSpecWorkerGithub']:
        """
        A GitHub repo to use as the component's source. DigitalOcean App Platform must have [access to the repository](https://cloud.digitalocean.com/apps/github/install). Only one of `git`, `github`, `gitlab`, or `image` may be set.
        """
        return pulumi.get(self, "github")

    @property
    @pulumi.getter
    def gitlab(self) -> Optional['outputs.AppSpecWorkerGitlab']:
        """
        A Gitlab repo to use as the component's source. DigitalOcean App Platform must have [access to the repository](https://cloud.digitalocean.com/apps/gitlab/install). Only one of `git`, `github`, `gitlab`, or `image` may be set.
        """
        return pulumi.get(self, "gitlab")

    @property
    @pulumi.getter
    def image(self) -> Optional['outputs.AppSpecWorkerImage']:
        """
        An image to use as the component's source. Only one of `git`, `github`, `gitlab`, or `image` may be set.
        """
        return pulumi.get(self, "image")

    @property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> Optional[int]:
        """
        The amount of instances that this component should be scaled to.
        """
        return pulumi.get(self, "instance_count")

    @property
    @pulumi.getter(name="instanceSizeSlug")
    def instance_size_slug(self) -> Optional[str]:
        """
        The instance size to use for this component.
        """
        return pulumi.get(self, "instance_size_slug")

    @property
    @pulumi.getter(name="runCommand")
    def run_command(self) -> Optional[str]:
        """
        An optional run command to override the component's default.
        """
        return pulumi.get(self, "run_command")

    @property
    @pulumi.getter(name="sourceDir")
    def source_dir(self) -> Optional[str]:
        """
        An optional path to the working directory to use for the build.
        """
        return pulumi.get(self, "source_dir")


@pulumi.output_type
class AppSpecWorkerEnv(dict):
    def __init__(__self__, *,
                 key: Optional[str] = None,
                 scope: Optional[str] = None,
                 type: Optional[str] = None,
                 value: Optional[str] = None):
        """
        :param str key: The name of the environment variable.
        :param str scope: The visibility scope of the environment variable. One of `RUN_TIME`, `BUILD_TIME`, or `RUN_AND_BUILD_TIME` (default).
        :param str type: The type of the environment variable, `GENERAL` or `SECRET`.
        :param str value: The value of the environment variable.
        """
        if key is not None:
            pulumi.set(__self__, "key", key)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[str]:
        """
        The name of the environment variable.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def scope(self) -> Optional[str]:
        """
        The visibility scope of the environment variable. One of `RUN_TIME`, `BUILD_TIME`, or `RUN_AND_BUILD_TIME` (default).
        """
        return pulumi.get(self, "scope")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        The type of the environment variable, `GENERAL` or `SECRET`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        The value of the environment variable.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class AppSpecWorkerGit(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "repoCloneUrl":
            suggest = "repo_clone_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppSpecWorkerGit. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppSpecWorkerGit.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppSpecWorkerGit.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 branch: Optional[str] = None,
                 repo_clone_url: Optional[str] = None):
        """
        :param str branch: The name of the branch to use.
        :param str repo_clone_url: The clone URL of the repo.
        """
        if branch is not None:
            pulumi.set(__self__, "branch", branch)
        if repo_clone_url is not None:
            pulumi.set(__self__, "repo_clone_url", repo_clone_url)

    @property
    @pulumi.getter
    def branch(self) -> Optional[str]:
        """
        The name of the branch to use.
        """
        return pulumi.get(self, "branch")

    @property
    @pulumi.getter(name="repoCloneUrl")
    def repo_clone_url(self) -> Optional[str]:
        """
        The clone URL of the repo.
        """
        return pulumi.get(self, "repo_clone_url")


@pulumi.output_type
class AppSpecWorkerGithub(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deployOnPush":
            suggest = "deploy_on_push"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppSpecWorkerGithub. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppSpecWorkerGithub.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppSpecWorkerGithub.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 branch: Optional[str] = None,
                 deploy_on_push: Optional[bool] = None,
                 repo: Optional[str] = None):
        """
        :param str branch: The name of the branch to use.
        :param bool deploy_on_push: Whether to automatically deploy new commits made to the repo.
        :param str repo: The name of the repo in the format `owner/repo`.
        """
        if branch is not None:
            pulumi.set(__self__, "branch", branch)
        if deploy_on_push is not None:
            pulumi.set(__self__, "deploy_on_push", deploy_on_push)
        if repo is not None:
            pulumi.set(__self__, "repo", repo)

    @property
    @pulumi.getter
    def branch(self) -> Optional[str]:
        """
        The name of the branch to use.
        """
        return pulumi.get(self, "branch")

    @property
    @pulumi.getter(name="deployOnPush")
    def deploy_on_push(self) -> Optional[bool]:
        """
        Whether to automatically deploy new commits made to the repo.
        """
        return pulumi.get(self, "deploy_on_push")

    @property
    @pulumi.getter
    def repo(self) -> Optional[str]:
        """
        The name of the repo in the format `owner/repo`.
        """
        return pulumi.get(self, "repo")


@pulumi.output_type
class AppSpecWorkerGitlab(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "deployOnPush":
            suggest = "deploy_on_push"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppSpecWorkerGitlab. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppSpecWorkerGitlab.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppSpecWorkerGitlab.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 branch: Optional[str] = None,
                 deploy_on_push: Optional[bool] = None,
                 repo: Optional[str] = None):
        """
        :param str branch: The name of the branch to use.
        :param bool deploy_on_push: Whether to automatically deploy new commits made to the repo.
        :param str repo: The name of the repo in the format `owner/repo`.
        """
        if branch is not None:
            pulumi.set(__self__, "branch", branch)
        if deploy_on_push is not None:
            pulumi.set(__self__, "deploy_on_push", deploy_on_push)
        if repo is not None:
            pulumi.set(__self__, "repo", repo)

    @property
    @pulumi.getter
    def branch(self) -> Optional[str]:
        """
        The name of the branch to use.
        """
        return pulumi.get(self, "branch")

    @property
    @pulumi.getter(name="deployOnPush")
    def deploy_on_push(self) -> Optional[bool]:
        """
        Whether to automatically deploy new commits made to the repo.
        """
        return pulumi.get(self, "deploy_on_push")

    @property
    @pulumi.getter
    def repo(self) -> Optional[str]:
        """
        The name of the repo in the format `owner/repo`.
        """
        return pulumi.get(self, "repo")


@pulumi.output_type
class AppSpecWorkerImage(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "registryType":
            suggest = "registry_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AppSpecWorkerImage. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AppSpecWorkerImage.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AppSpecWorkerImage.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 registry_type: str,
                 repository: str,
                 registry: Optional[str] = None,
                 tag: Optional[str] = None):
        """
        :param str registry_type: The registry type. One of `DOCR` (DigitalOcean container registry) or `DOCKER_HUB`.
        :param str repository: The repository name.
        :param str registry: The registry name. Must be left empty for the `DOCR` registry type. Required for the `DOCKER_HUB` registry type.
        :param str tag: The repository tag. Defaults to `latest` if not provided.
        """
        pulumi.set(__self__, "registry_type", registry_type)
        pulumi.set(__self__, "repository", repository)
        if registry is not None:
            pulumi.set(__self__, "registry", registry)
        if tag is not None:
            pulumi.set(__self__, "tag", tag)

    @property
    @pulumi.getter(name="registryType")
    def registry_type(self) -> str:
        """
        The registry type. One of `DOCR` (DigitalOcean container registry) or `DOCKER_HUB`.
        """
        return pulumi.get(self, "registry_type")

    @property
    @pulumi.getter
    def repository(self) -> str:
        """
        The repository name.
        """
        return pulumi.get(self, "repository")

    @property
    @pulumi.getter
    def registry(self) -> Optional[str]:
        """
        The registry name. Must be left empty for the `DOCR` registry type. Required for the `DOCKER_HUB` registry type.
        """
        return pulumi.get(self, "registry")

    @property
    @pulumi.getter
    def tag(self) -> Optional[str]:
        """
        The repository tag. Defaults to `latest` if not provided.
        """
        return pulumi.get(self, "tag")


@pulumi.output_type
class DatabaseClusterMaintenanceWindow(dict):
    def __init__(__self__, *,
                 day: str,
                 hour: str):
        """
        :param str day: The day of the week on which to apply maintenance updates.
        :param str hour: The hour in UTC at which maintenance updates will be applied in 24 hour format.
        """
        pulumi.set(__self__, "day", day)
        pulumi.set(__self__, "hour", hour)

    @property
    @pulumi.getter
    def day(self) -> str:
        """
        The day of the week on which to apply maintenance updates.
        """
        return pulumi.get(self, "day")

    @property
    @pulumi.getter
    def hour(self) -> str:
        """
        The hour in UTC at which maintenance updates will be applied in 24 hour format.
        """
        return pulumi.get(self, "hour")


@pulumi.output_type
class DatabaseFirewallRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdAt":
            suggest = "created_at"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseFirewallRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseFirewallRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseFirewallRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 value: str,
                 created_at: Optional[str] = None,
                 uuid: Optional[str] = None):
        """
        :param str type: The type of resource that the firewall rule allows to access the database cluster. The possible values are: `droplet`, `k8s`, `ip_addr`, or `tag`.
        :param str value: The ID of the specific resource, the name of a tag applied to a group of resources, or the IP address that the firewall rule allows to access the database cluster.
        :param str created_at: The date and time when the firewall rule was created.
        :param str uuid: A unique identifier for the firewall rule.
        """
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if uuid is not None:
            pulumi.set(__self__, "uuid", uuid)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of resource that the firewall rule allows to access the database cluster. The possible values are: `droplet`, `k8s`, `ip_addr`, or `tag`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The ID of the specific resource, the name of a tag applied to a group of resources, or the IP address that the firewall rule allows to access the database cluster.
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[str]:
        """
        The date and time when the firewall rule was created.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def uuid(self) -> Optional[str]:
        """
        A unique identifier for the firewall rule.
        """
        return pulumi.get(self, "uuid")


@pulumi.output_type
class FirewallInboundRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "portRange":
            suggest = "port_range"
        elif key == "sourceAddresses":
            suggest = "source_addresses"
        elif key == "sourceDropletIds":
            suggest = "source_droplet_ids"
        elif key == "sourceLoadBalancerUids":
            suggest = "source_load_balancer_uids"
        elif key == "sourceTags":
            suggest = "source_tags"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FirewallInboundRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FirewallInboundRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FirewallInboundRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 protocol: str,
                 port_range: Optional[str] = None,
                 source_addresses: Optional[Sequence[str]] = None,
                 source_droplet_ids: Optional[Sequence[int]] = None,
                 source_load_balancer_uids: Optional[Sequence[str]] = None,
                 source_tags: Optional[Sequence[str]] = None):
        """
        :param str protocol: The type of traffic to be allowed.
               This may be one of "tcp", "udp", or "icmp".
        :param str port_range: The ports on which traffic will be allowed
               specified as a string containing a single port, a range (e.g. "8000-9000"),
               or "1-65535" to open all ports for a protocol. Required for when protocol is
               `tcp` or `udp`.
        :param Sequence[str] source_addresses: An array of strings containing the IPv4
               addresses, IPv6 addresses, IPv4 CIDRs, and/or IPv6 CIDRs from which the
               inbound traffic will be accepted.
        :param Sequence[int] source_droplet_ids: An array containing the IDs of
               the Droplets from which the inbound traffic will be accepted.
        :param Sequence[str] source_load_balancer_uids: An array containing the IDs
               of the Load Balancers from which the inbound traffic will be accepted.
        :param Sequence[str] source_tags: An array containing the names of Tags
               corresponding to groups of Droplets from which the inbound traffic
               will be accepted.
        """
        pulumi.set(__self__, "protocol", protocol)
        if port_range is not None:
            pulumi.set(__self__, "port_range", port_range)
        if source_addresses is not None:
            pulumi.set(__self__, "source_addresses", source_addresses)
        if source_droplet_ids is not None:
            pulumi.set(__self__, "source_droplet_ids", source_droplet_ids)
        if source_load_balancer_uids is not None:
            pulumi.set(__self__, "source_load_balancer_uids", source_load_balancer_uids)
        if source_tags is not None:
            pulumi.set(__self__, "source_tags", source_tags)

    @property
    @pulumi.getter
    def protocol(self) -> str:
        """
        The type of traffic to be allowed.
        This may be one of "tcp", "udp", or "icmp".
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="portRange")
    def port_range(self) -> Optional[str]:
        """
        The ports on which traffic will be allowed
        specified as a string containing a single port, a range (e.g. "8000-9000"),
        or "1-65535" to open all ports for a protocol. Required for when protocol is
        `tcp` or `udp`.
        """
        return pulumi.get(self, "port_range")

    @property
    @pulumi.getter(name="sourceAddresses")
    def source_addresses(self) -> Optional[Sequence[str]]:
        """
        An array of strings containing the IPv4
        addresses, IPv6 addresses, IPv4 CIDRs, and/or IPv6 CIDRs from which the
        inbound traffic will be accepted.
        """
        return pulumi.get(self, "source_addresses")

    @property
    @pulumi.getter(name="sourceDropletIds")
    def source_droplet_ids(self) -> Optional[Sequence[int]]:
        """
        An array containing the IDs of
        the Droplets from which the inbound traffic will be accepted.
        """
        return pulumi.get(self, "source_droplet_ids")

    @property
    @pulumi.getter(name="sourceLoadBalancerUids")
    def source_load_balancer_uids(self) -> Optional[Sequence[str]]:
        """
        An array containing the IDs
        of the Load Balancers from which the inbound traffic will be accepted.
        """
        return pulumi.get(self, "source_load_balancer_uids")

    @property
    @pulumi.getter(name="sourceTags")
    def source_tags(self) -> Optional[Sequence[str]]:
        """
        An array containing the names of Tags
        corresponding to groups of Droplets from which the inbound traffic
        will be accepted.
        """
        return pulumi.get(self, "source_tags")


@pulumi.output_type
class FirewallOutboundRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "destinationAddresses":
            suggest = "destination_addresses"
        elif key == "destinationDropletIds":
            suggest = "destination_droplet_ids"
        elif key == "destinationLoadBalancerUids":
            suggest = "destination_load_balancer_uids"
        elif key == "destinationTags":
            suggest = "destination_tags"
        elif key == "portRange":
            suggest = "port_range"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FirewallOutboundRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FirewallOutboundRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FirewallOutboundRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 protocol: str,
                 destination_addresses: Optional[Sequence[str]] = None,
                 destination_droplet_ids: Optional[Sequence[int]] = None,
                 destination_load_balancer_uids: Optional[Sequence[str]] = None,
                 destination_tags: Optional[Sequence[str]] = None,
                 port_range: Optional[str] = None):
        """
        :param str protocol: The type of traffic to be allowed.
               This may be one of "tcp", "udp", or "icmp".
        :param Sequence[str] destination_addresses: An array of strings containing the IPv4
               addresses, IPv6 addresses, IPv4 CIDRs, and/or IPv6 CIDRs to which the
               outbound traffic will be allowed.
        :param Sequence[int] destination_droplet_ids: An array containing the IDs of
               the Droplets to which the outbound traffic will be allowed.
        :param Sequence[str] destination_load_balancer_uids: An array containing the IDs
               of the Load Balancers to which the outbound traffic will be allowed.
        :param Sequence[str] destination_tags: An array containing the names of Tags
               corresponding to groups of Droplets to which the outbound traffic will
               be allowed.
               traffic.
        :param str port_range: The ports on which traffic will be allowed
               specified as a string containing a single port, a range (e.g. "8000-9000"),
               or "1-65535" to open all ports for a protocol. Required for when protocol is
               `tcp` or `udp`.
        """
        pulumi.set(__self__, "protocol", protocol)
        if destination_addresses is not None:
            pulumi.set(__self__, "destination_addresses", destination_addresses)
        if destination_droplet_ids is not None:
            pulumi.set(__self__, "destination_droplet_ids", destination_droplet_ids)
        if destination_load_balancer_uids is not None:
            pulumi.set(__self__, "destination_load_balancer_uids", destination_load_balancer_uids)
        if destination_tags is not None:
            pulumi.set(__self__, "destination_tags", destination_tags)
        if port_range is not None:
            pulumi.set(__self__, "port_range", port_range)

    @property
    @pulumi.getter
    def protocol(self) -> str:
        """
        The type of traffic to be allowed.
        This may be one of "tcp", "udp", or "icmp".
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="destinationAddresses")
    def destination_addresses(self) -> Optional[Sequence[str]]:
        """
        An array of strings containing the IPv4
        addresses, IPv6 addresses, IPv4 CIDRs, and/or IPv6 CIDRs to which the
        outbound traffic will be allowed.
        """
        return pulumi.get(self, "destination_addresses")

    @property
    @pulumi.getter(name="destinationDropletIds")
    def destination_droplet_ids(self) -> Optional[Sequence[int]]:
        """
        An array containing the IDs of
        the Droplets to which the outbound traffic will be allowed.
        """
        return pulumi.get(self, "destination_droplet_ids")

    @property
    @pulumi.getter(name="destinationLoadBalancerUids")
    def destination_load_balancer_uids(self) -> Optional[Sequence[str]]:
        """
        An array containing the IDs
        of the Load Balancers to which the outbound traffic will be allowed.
        """
        return pulumi.get(self, "destination_load_balancer_uids")

    @property
    @pulumi.getter(name="destinationTags")
    def destination_tags(self) -> Optional[Sequence[str]]:
        """
        An array containing the names of Tags
        corresponding to groups of Droplets to which the outbound traffic will
        be allowed.
        traffic.
        """
        return pulumi.get(self, "destination_tags")

    @property
    @pulumi.getter(name="portRange")
    def port_range(self) -> Optional[str]:
        """
        The ports on which traffic will be allowed
        specified as a string containing a single port, a range (e.g. "8000-9000"),
        or "1-65535" to open all ports for a protocol. Required for when protocol is
        `tcp` or `udp`.
        """
        return pulumi.get(self, "port_range")


@pulumi.output_type
class FirewallPendingChange(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dropletId":
            suggest = "droplet_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FirewallPendingChange. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FirewallPendingChange.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FirewallPendingChange.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 droplet_id: Optional[int] = None,
                 removing: Optional[bool] = None,
                 status: Optional[str] = None):
        """
        :param str status: A status string indicating the current state of the Firewall.
               This can be "waiting", "succeeded", or "failed".
        """
        if droplet_id is not None:
            pulumi.set(__self__, "droplet_id", droplet_id)
        if removing is not None:
            pulumi.set(__self__, "removing", removing)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="dropletId")
    def droplet_id(self) -> Optional[int]:
        return pulumi.get(self, "droplet_id")

    @property
    @pulumi.getter
    def removing(self) -> Optional[bool]:
        return pulumi.get(self, "removing")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        A status string indicating the current state of the Firewall.
        This can be "waiting", "succeeded", or "failed".
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class KubernetesClusterKubeConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientCertificate":
            suggest = "client_certificate"
        elif key == "clientKey":
            suggest = "client_key"
        elif key == "clusterCaCertificate":
            suggest = "cluster_ca_certificate"
        elif key == "expiresAt":
            suggest = "expires_at"
        elif key == "rawConfig":
            suggest = "raw_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KubernetesClusterKubeConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KubernetesClusterKubeConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KubernetesClusterKubeConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_certificate: Optional[str] = None,
                 client_key: Optional[str] = None,
                 cluster_ca_certificate: Optional[str] = None,
                 expires_at: Optional[str] = None,
                 host: Optional[str] = None,
                 raw_config: Optional[str] = None,
                 token: Optional[str] = None):
        """
        :param str client_certificate: The base64 encoded public certificate used by clients to access the cluster. Only available if token authentication is not supported on your cluster.
        :param str client_key: The base64 encoded private key used by clients to access the cluster. Only available if token authentication is not supported on your cluster.
        :param str cluster_ca_certificate: The base64 encoded public certificate for the cluster's certificate authority.
        :param str expires_at: The date and time when the credentials will expire and need to be regenerated.
        :param str host: The URL of the API server on the Kubernetes master node.
        :param str raw_config: The full contents of the Kubernetes cluster's kubeconfig file.
        :param str token: The DigitalOcean API access token used by clients to access the cluster.
        """
        if client_certificate is not None:
            pulumi.set(__self__, "client_certificate", client_certificate)
        if client_key is not None:
            pulumi.set(__self__, "client_key", client_key)
        if cluster_ca_certificate is not None:
            pulumi.set(__self__, "cluster_ca_certificate", cluster_ca_certificate)
        if expires_at is not None:
            pulumi.set(__self__, "expires_at", expires_at)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if raw_config is not None:
            pulumi.set(__self__, "raw_config", raw_config)
        if token is not None:
            pulumi.set(__self__, "token", token)

    @property
    @pulumi.getter(name="clientCertificate")
    def client_certificate(self) -> Optional[str]:
        """
        The base64 encoded public certificate used by clients to access the cluster. Only available if token authentication is not supported on your cluster.
        """
        return pulumi.get(self, "client_certificate")

    @property
    @pulumi.getter(name="clientKey")
    def client_key(self) -> Optional[str]:
        """
        The base64 encoded private key used by clients to access the cluster. Only available if token authentication is not supported on your cluster.
        """
        return pulumi.get(self, "client_key")

    @property
    @pulumi.getter(name="clusterCaCertificate")
    def cluster_ca_certificate(self) -> Optional[str]:
        """
        The base64 encoded public certificate for the cluster's certificate authority.
        """
        return pulumi.get(self, "cluster_ca_certificate")

    @property
    @pulumi.getter(name="expiresAt")
    def expires_at(self) -> Optional[str]:
        """
        The date and time when the credentials will expire and need to be regenerated.
        """
        return pulumi.get(self, "expires_at")

    @property
    @pulumi.getter
    def host(self) -> Optional[str]:
        """
        The URL of the API server on the Kubernetes master node.
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter(name="rawConfig")
    def raw_config(self) -> Optional[str]:
        """
        The full contents of the Kubernetes cluster's kubeconfig file.
        """
        return pulumi.get(self, "raw_config")

    @property
    @pulumi.getter
    def token(self) -> Optional[str]:
        """
        The DigitalOcean API access token used by clients to access the cluster.
        """
        return pulumi.get(self, "token")


@pulumi.output_type
class KubernetesClusterNodePool(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "actualNodeCount":
            suggest = "actual_node_count"
        elif key == "autoScale":
            suggest = "auto_scale"
        elif key == "maxNodes":
            suggest = "max_nodes"
        elif key == "minNodes":
            suggest = "min_nodes"
        elif key == "nodeCount":
            suggest = "node_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KubernetesClusterNodePool. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KubernetesClusterNodePool.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KubernetesClusterNodePool.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 size: str,
                 actual_node_count: Optional[int] = None,
                 auto_scale: Optional[bool] = None,
                 id: Optional[str] = None,
                 labels: Optional[Mapping[str, str]] = None,
                 max_nodes: Optional[int] = None,
                 min_nodes: Optional[int] = None,
                 node_count: Optional[int] = None,
                 nodes: Optional[Sequence['outputs.KubernetesClusterNodePoolNode']] = None,
                 tags: Optional[Sequence[str]] = None,
                 taints: Optional[Sequence['outputs.KubernetesClusterNodePoolTaint']] = None):
        """
        :param str name: A name for the node pool.
        :param str size: The slug identifier for the type of Droplet to be used as workers in the node pool.
        :param int actual_node_count: A computed field representing the actual number of nodes in the node pool, which is especially useful when auto-scaling is enabled.
        :param bool auto_scale: Enable auto-scaling of the number of nodes in the node pool within the given min/max range.
        :param str id: A unique ID that can be used to identify and reference the node.
        :param Mapping[str, str] labels: A map of key/value pairs to apply to nodes in the pool. The labels are exposed in the Kubernetes API as labels in the metadata of the corresponding [Node resources](https://kubernetes.io/docs/concepts/architecture/nodes/).
        :param int max_nodes: If auto-scaling is enabled, this represents the maximum number of nodes that the node pool can be scaled up to.
        :param int min_nodes: If auto-scaling is enabled, this represents the minimum number of nodes that the node pool can be scaled down to.
        :param int node_count: The number of Droplet instances in the node pool. If auto-scaling is enabled, this should only be set if the desired result is to explicitly reset the number of nodes to this value. If auto-scaling is enabled, and the node count is outside of the given min/max range, it will use the min nodes value.
        :param Sequence['KubernetesClusterNodePoolNodeArgs'] nodes: A list of nodes in the pool. Each node exports the following attributes:
        :param Sequence[str] tags: A list of tag names to be applied to the Kubernetes cluster.
        :param Sequence['KubernetesClusterNodePoolTaintArgs'] taints: A block representing a taint applied to all nodes in the pool. Each taint exports the following attributes (taints must be unique by key and effect pair):
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "size", size)
        if actual_node_count is not None:
            pulumi.set(__self__, "actual_node_count", actual_node_count)
        if auto_scale is not None:
            pulumi.set(__self__, "auto_scale", auto_scale)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if max_nodes is not None:
            pulumi.set(__self__, "max_nodes", max_nodes)
        if min_nodes is not None:
            pulumi.set(__self__, "min_nodes", min_nodes)
        if node_count is not None:
            pulumi.set(__self__, "node_count", node_count)
        if nodes is not None:
            pulumi.set(__self__, "nodes", nodes)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if taints is not None:
            pulumi.set(__self__, "taints", taints)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        A name for the node pool.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def size(self) -> str:
        """
        The slug identifier for the type of Droplet to be used as workers in the node pool.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter(name="actualNodeCount")
    def actual_node_count(self) -> Optional[int]:
        """
        A computed field representing the actual number of nodes in the node pool, which is especially useful when auto-scaling is enabled.
        """
        return pulumi.get(self, "actual_node_count")

    @property
    @pulumi.getter(name="autoScale")
    def auto_scale(self) -> Optional[bool]:
        """
        Enable auto-scaling of the number of nodes in the node pool within the given min/max range.
        """
        return pulumi.get(self, "auto_scale")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        A unique ID that can be used to identify and reference the node.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def labels(self) -> Optional[Mapping[str, str]]:
        """
        A map of key/value pairs to apply to nodes in the pool. The labels are exposed in the Kubernetes API as labels in the metadata of the corresponding [Node resources](https://kubernetes.io/docs/concepts/architecture/nodes/).
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="maxNodes")
    def max_nodes(self) -> Optional[int]:
        """
        If auto-scaling is enabled, this represents the maximum number of nodes that the node pool can be scaled up to.
        """
        return pulumi.get(self, "max_nodes")

    @property
    @pulumi.getter(name="minNodes")
    def min_nodes(self) -> Optional[int]:
        """
        If auto-scaling is enabled, this represents the minimum number of nodes that the node pool can be scaled down to.
        """
        return pulumi.get(self, "min_nodes")

    @property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> Optional[int]:
        """
        The number of Droplet instances in the node pool. If auto-scaling is enabled, this should only be set if the desired result is to explicitly reset the number of nodes to this value. If auto-scaling is enabled, and the node count is outside of the given min/max range, it will use the min nodes value.
        """
        return pulumi.get(self, "node_count")

    @property
    @pulumi.getter
    def nodes(self) -> Optional[Sequence['outputs.KubernetesClusterNodePoolNode']]:
        """
        A list of nodes in the pool. Each node exports the following attributes:
        """
        return pulumi.get(self, "nodes")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence[str]]:
        """
        A list of tag names to be applied to the Kubernetes cluster.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def taints(self) -> Optional[Sequence['outputs.KubernetesClusterNodePoolTaint']]:
        """
        A block representing a taint applied to all nodes in the pool. Each taint exports the following attributes (taints must be unique by key and effect pair):
        """
        return pulumi.get(self, "taints")


@pulumi.output_type
class KubernetesClusterNodePoolNode(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdAt":
            suggest = "created_at"
        elif key == "dropletId":
            suggest = "droplet_id"
        elif key == "updatedAt":
            suggest = "updated_at"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KubernetesClusterNodePoolNode. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KubernetesClusterNodePoolNode.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KubernetesClusterNodePoolNode.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_at: Optional[str] = None,
                 droplet_id: Optional[str] = None,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 status: Optional[str] = None,
                 updated_at: Optional[str] = None):
        """
        :param str created_at: The date and time when the node was created.
        :param str droplet_id: The id of the node's droplet
        :param str id: A unique ID that can be used to identify and reference the node.
        :param str name: A name for the node pool.
        :param str status: A string indicating the current status of the individual node.
        :param str updated_at: The date and time when the node was last updated.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if droplet_id is not None:
            pulumi.set(__self__, "droplet_id", droplet_id)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[str]:
        """
        The date and time when the node was created.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="dropletId")
    def droplet_id(self) -> Optional[str]:
        """
        The id of the node's droplet
        """
        return pulumi.get(self, "droplet_id")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        A unique ID that can be used to identify and reference the node.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        A name for the node pool.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        A string indicating the current status of the individual node.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[str]:
        """
        The date and time when the node was last updated.
        """
        return pulumi.get(self, "updated_at")


@pulumi.output_type
class KubernetesClusterNodePoolTaint(dict):
    def __init__(__self__, *,
                 effect: str,
                 key: str,
                 value: str):
        """
        :param str effect: How the node reacts to pods that it won't tolerate. Available effect values are: "NoSchedule", "PreferNoSchedule", "NoExecute".
        :param str key: An arbitrary string. The "key" and "value" fields of the "taint" object form a key-value pair.
        :param str value: An arbitrary string. The "key" and "value" fields of the "taint" object form a key-value pair.
        """
        pulumi.set(__self__, "effect", effect)
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def effect(self) -> str:
        """
        How the node reacts to pods that it won't tolerate. Available effect values are: "NoSchedule", "PreferNoSchedule", "NoExecute".
        """
        return pulumi.get(self, "effect")

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        An arbitrary string. The "key" and "value" fields of the "taint" object form a key-value pair.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        An arbitrary string. The "key" and "value" fields of the "taint" object form a key-value pair.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class KubernetesNodePoolNode(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdAt":
            suggest = "created_at"
        elif key == "dropletId":
            suggest = "droplet_id"
        elif key == "updatedAt":
            suggest = "updated_at"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KubernetesNodePoolNode. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KubernetesNodePoolNode.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KubernetesNodePoolNode.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_at: Optional[str] = None,
                 droplet_id: Optional[str] = None,
                 id: Optional[str] = None,
                 name: Optional[str] = None,
                 status: Optional[str] = None,
                 updated_at: Optional[str] = None):
        """
        :param str created_at: The date and time when the node was created.
        :param str droplet_id: The id of the node's droplet
        :param str id: A unique ID that can be used to identify and reference the node.
        :param str name: A name for the node pool.
        :param str status: A string indicating the current status of the individual node.
        :param str updated_at: The date and time when the node was last updated.
        """
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if droplet_id is not None:
            pulumi.set(__self__, "droplet_id", droplet_id)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[str]:
        """
        The date and time when the node was created.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="dropletId")
    def droplet_id(self) -> Optional[str]:
        """
        The id of the node's droplet
        """
        return pulumi.get(self, "droplet_id")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        A unique ID that can be used to identify and reference the node.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        A name for the node pool.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        A string indicating the current status of the individual node.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[str]:
        """
        The date and time when the node was last updated.
        """
        return pulumi.get(self, "updated_at")


@pulumi.output_type
class KubernetesNodePoolTaint(dict):
    def __init__(__self__, *,
                 effect: str,
                 key: str,
                 value: str):
        """
        :param str effect: How the node reacts to pods that it won't tolerate. Available effect values are: "NoSchedule", "PreferNoSchedule", "NoExecute".
        :param str key: An arbitrary string. The "key" and "value" fields of the "taint" object form a key-value pair.
        :param str value: An arbitrary string. The "key" and "value" fields of the "taint" object form a key-value pair.
        """
        pulumi.set(__self__, "effect", effect)
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def effect(self) -> str:
        """
        How the node reacts to pods that it won't tolerate. Available effect values are: "NoSchedule", "PreferNoSchedule", "NoExecute".
        """
        return pulumi.get(self, "effect")

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        An arbitrary string. The "key" and "value" fields of the "taint" object form a key-value pair.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        An arbitrary string. The "key" and "value" fields of the "taint" object form a key-value pair.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class LoadBalancerForwardingRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "entryPort":
            suggest = "entry_port"
        elif key == "entryProtocol":
            suggest = "entry_protocol"
        elif key == "targetPort":
            suggest = "target_port"
        elif key == "targetProtocol":
            suggest = "target_protocol"
        elif key == "certificateId":
            suggest = "certificate_id"
        elif key == "certificateName":
            suggest = "certificate_name"
        elif key == "tlsPassthrough":
            suggest = "tls_passthrough"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoadBalancerForwardingRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoadBalancerForwardingRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoadBalancerForwardingRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 entry_port: int,
                 entry_protocol: str,
                 target_port: int,
                 target_protocol: str,
                 certificate_id: Optional[str] = None,
                 certificate_name: Optional[str] = None,
                 tls_passthrough: Optional[bool] = None):
        """
        :param int entry_port: An integer representing the port on which the Load Balancer instance will listen.
        :param str entry_protocol: The protocol used for traffic to the Load Balancer. The possible values are: `http`, `https`, `http2` or `tcp`.
        :param int target_port: An integer representing the port on the backend Droplets to which the Load Balancer will send traffic.
        :param str target_protocol: The protocol used for traffic from the Load Balancer to the backend Droplets. The possible values are: `http`, `https`, `http2` or `tcp`.
        :param str certificate_id: **Deprecated** The ID of the TLS certificate to be used for SSL termination.
        :param str certificate_name: The unique name of the TLS certificate to be used for SSL termination.
        :param bool tls_passthrough: A boolean value indicating whether SSL encrypted traffic will be passed through to the backend Droplets. The default value is `false`.
        """
        pulumi.set(__self__, "entry_port", entry_port)
        pulumi.set(__self__, "entry_protocol", entry_protocol)
        pulumi.set(__self__, "target_port", target_port)
        pulumi.set(__self__, "target_protocol", target_protocol)
        if certificate_id is not None:
            pulumi.set(__self__, "certificate_id", certificate_id)
        if certificate_name is not None:
            pulumi.set(__self__, "certificate_name", certificate_name)
        if tls_passthrough is not None:
            pulumi.set(__self__, "tls_passthrough", tls_passthrough)

    @property
    @pulumi.getter(name="entryPort")
    def entry_port(self) -> int:
        """
        An integer representing the port on which the Load Balancer instance will listen.
        """
        return pulumi.get(self, "entry_port")

    @property
    @pulumi.getter(name="entryProtocol")
    def entry_protocol(self) -> str:
        """
        The protocol used for traffic to the Load Balancer. The possible values are: `http`, `https`, `http2` or `tcp`.
        """
        return pulumi.get(self, "entry_protocol")

    @property
    @pulumi.getter(name="targetPort")
    def target_port(self) -> int:
        """
        An integer representing the port on the backend Droplets to which the Load Balancer will send traffic.
        """
        return pulumi.get(self, "target_port")

    @property
    @pulumi.getter(name="targetProtocol")
    def target_protocol(self) -> str:
        """
        The protocol used for traffic from the Load Balancer to the backend Droplets. The possible values are: `http`, `https`, `http2` or `tcp`.
        """
        return pulumi.get(self, "target_protocol")

    @property
    @pulumi.getter(name="certificateId")
    def certificate_id(self) -> Optional[str]:
        """
        **Deprecated** The ID of the TLS certificate to be used for SSL termination.
        """
        return pulumi.get(self, "certificate_id")

    @property
    @pulumi.getter(name="certificateName")
    def certificate_name(self) -> Optional[str]:
        """
        The unique name of the TLS certificate to be used for SSL termination.
        """
        return pulumi.get(self, "certificate_name")

    @property
    @pulumi.getter(name="tlsPassthrough")
    def tls_passthrough(self) -> Optional[bool]:
        """
        A boolean value indicating whether SSL encrypted traffic will be passed through to the backend Droplets. The default value is `false`.
        """
        return pulumi.get(self, "tls_passthrough")


@pulumi.output_type
class LoadBalancerHealthcheck(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "checkIntervalSeconds":
            suggest = "check_interval_seconds"
        elif key == "healthyThreshold":
            suggest = "healthy_threshold"
        elif key == "responseTimeoutSeconds":
            suggest = "response_timeout_seconds"
        elif key == "unhealthyThreshold":
            suggest = "unhealthy_threshold"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoadBalancerHealthcheck. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoadBalancerHealthcheck.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoadBalancerHealthcheck.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 port: int,
                 protocol: str,
                 check_interval_seconds: Optional[int] = None,
                 healthy_threshold: Optional[int] = None,
                 path: Optional[str] = None,
                 response_timeout_seconds: Optional[int] = None,
                 unhealthy_threshold: Optional[int] = None):
        """
        :param int port: An integer representing the port on the backend Droplets on which the health check will attempt a connection.
        :param str protocol: The protocol used for health checks sent to the backend Droplets. The possible values are `http`, `https` or `tcp`.
        :param int check_interval_seconds: The number of seconds between between two consecutive health checks. If not specified, the default value is `10`.
        :param int healthy_threshold: The number of times a health check must pass for a backend Droplet to be marked "healthy" and be re-added to the pool. If not specified, the default value is `5`.
        :param str path: The path on the backend Droplets to which the Load Balancer instance will send a request.
        :param int response_timeout_seconds: The number of seconds the Load Balancer instance will wait for a response until marking a health check as failed. If not specified, the default value is `5`.
        :param int unhealthy_threshold: The number of times a health check must fail for a backend Droplet to be marked "unhealthy" and be removed from the pool. If not specified, the default value is `3`.
        """
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "protocol", protocol)
        if check_interval_seconds is not None:
            pulumi.set(__self__, "check_interval_seconds", check_interval_seconds)
        if healthy_threshold is not None:
            pulumi.set(__self__, "healthy_threshold", healthy_threshold)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if response_timeout_seconds is not None:
            pulumi.set(__self__, "response_timeout_seconds", response_timeout_seconds)
        if unhealthy_threshold is not None:
            pulumi.set(__self__, "unhealthy_threshold", unhealthy_threshold)

    @property
    @pulumi.getter
    def port(self) -> int:
        """
        An integer representing the port on the backend Droplets on which the health check will attempt a connection.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def protocol(self) -> str:
        """
        The protocol used for health checks sent to the backend Droplets. The possible values are `http`, `https` or `tcp`.
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="checkIntervalSeconds")
    def check_interval_seconds(self) -> Optional[int]:
        """
        The number of seconds between between two consecutive health checks. If not specified, the default value is `10`.
        """
        return pulumi.get(self, "check_interval_seconds")

    @property
    @pulumi.getter(name="healthyThreshold")
    def healthy_threshold(self) -> Optional[int]:
        """
        The number of times a health check must pass for a backend Droplet to be marked "healthy" and be re-added to the pool. If not specified, the default value is `5`.
        """
        return pulumi.get(self, "healthy_threshold")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        The path on the backend Droplets to which the Load Balancer instance will send a request.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter(name="responseTimeoutSeconds")
    def response_timeout_seconds(self) -> Optional[int]:
        """
        The number of seconds the Load Balancer instance will wait for a response until marking a health check as failed. If not specified, the default value is `5`.
        """
        return pulumi.get(self, "response_timeout_seconds")

    @property
    @pulumi.getter(name="unhealthyThreshold")
    def unhealthy_threshold(self) -> Optional[int]:
        """
        The number of times a health check must fail for a backend Droplet to be marked "unhealthy" and be removed from the pool. If not specified, the default value is `3`.
        """
        return pulumi.get(self, "unhealthy_threshold")


@pulumi.output_type
class LoadBalancerStickySessions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cookieName":
            suggest = "cookie_name"
        elif key == "cookieTtlSeconds":
            suggest = "cookie_ttl_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoadBalancerStickySessions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoadBalancerStickySessions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoadBalancerStickySessions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cookie_name: Optional[str] = None,
                 cookie_ttl_seconds: Optional[int] = None,
                 type: Optional[str] = None):
        """
        :param str cookie_name: The name to be used for the cookie sent to the client. This attribute is required when using `cookies` for the sticky sessions type.
        :param int cookie_ttl_seconds: The number of seconds until the cookie set by the Load Balancer expires. This attribute is required when using `cookies` for the sticky sessions type.
        :param str type: An attribute indicating how and if requests from a client will be persistently served by the same backend Droplet. The possible values are `cookies` or `none`. If not specified, the default value is `none`.
        """
        if cookie_name is not None:
            pulumi.set(__self__, "cookie_name", cookie_name)
        if cookie_ttl_seconds is not None:
            pulumi.set(__self__, "cookie_ttl_seconds", cookie_ttl_seconds)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="cookieName")
    def cookie_name(self) -> Optional[str]:
        """
        The name to be used for the cookie sent to the client. This attribute is required when using `cookies` for the sticky sessions type.
        """
        return pulumi.get(self, "cookie_name")

    @property
    @pulumi.getter(name="cookieTtlSeconds")
    def cookie_ttl_seconds(self) -> Optional[int]:
        """
        The number of seconds until the cookie set by the Load Balancer expires. This attribute is required when using `cookies` for the sticky sessions type.
        """
        return pulumi.get(self, "cookie_ttl_seconds")

    @property
    @pulumi.getter
    def type(self) -> Optional[str]:
        """
        An attribute indicating how and if requests from a client will be persistently served by the same backend Droplet. The possible values are `cookies` or `none`. If not specified, the default value is `none`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class SpacesBucketCorsRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allowedMethods":
            suggest = "allowed_methods"
        elif key == "allowedOrigins":
            suggest = "allowed_origins"
        elif key == "allowedHeaders":
            suggest = "allowed_headers"
        elif key == "maxAgeSeconds":
            suggest = "max_age_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SpacesBucketCorsRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SpacesBucketCorsRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SpacesBucketCorsRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allowed_methods: Sequence[str],
                 allowed_origins: Sequence[str],
                 allowed_headers: Optional[Sequence[str]] = None,
                 max_age_seconds: Optional[int] = None):
        """
        :param Sequence[str] allowed_methods: A list of HTTP methods (e.g. `GET`) which are allowed from the specified origin.
        :param Sequence[str] allowed_origins: A list of hosts from which requests using the specified methods are allowed. A host may contain one wildcard (e.g. http://*.example.com).
        :param Sequence[str] allowed_headers: A list of headers that will be included in the CORS preflight request's `Access-Control-Request-Headers`. A header may contain one wildcard (e.g. `x-amz-*`).
        :param int max_age_seconds: The time in seconds that browser can cache the response for a preflight request.
        """
        pulumi.set(__self__, "allowed_methods", allowed_methods)
        pulumi.set(__self__, "allowed_origins", allowed_origins)
        if allowed_headers is not None:
            pulumi.set(__self__, "allowed_headers", allowed_headers)
        if max_age_seconds is not None:
            pulumi.set(__self__, "max_age_seconds", max_age_seconds)

    @property
    @pulumi.getter(name="allowedMethods")
    def allowed_methods(self) -> Sequence[str]:
        """
        A list of HTTP methods (e.g. `GET`) which are allowed from the specified origin.
        """
        return pulumi.get(self, "allowed_methods")

    @property
    @pulumi.getter(name="allowedOrigins")
    def allowed_origins(self) -> Sequence[str]:
        """
        A list of hosts from which requests using the specified methods are allowed. A host may contain one wildcard (e.g. http://*.example.com).
        """
        return pulumi.get(self, "allowed_origins")

    @property
    @pulumi.getter(name="allowedHeaders")
    def allowed_headers(self) -> Optional[Sequence[str]]:
        """
        A list of headers that will be included in the CORS preflight request's `Access-Control-Request-Headers`. A header may contain one wildcard (e.g. `x-amz-*`).
        """
        return pulumi.get(self, "allowed_headers")

    @property
    @pulumi.getter(name="maxAgeSeconds")
    def max_age_seconds(self) -> Optional[int]:
        """
        The time in seconds that browser can cache the response for a preflight request.
        """
        return pulumi.get(self, "max_age_seconds")


@pulumi.output_type
class SpacesBucketLifecycleRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "abortIncompleteMultipartUploadDays":
            suggest = "abort_incomplete_multipart_upload_days"
        elif key == "noncurrentVersionExpiration":
            suggest = "noncurrent_version_expiration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SpacesBucketLifecycleRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SpacesBucketLifecycleRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SpacesBucketLifecycleRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enabled: bool,
                 abort_incomplete_multipart_upload_days: Optional[int] = None,
                 expiration: Optional['outputs.SpacesBucketLifecycleRuleExpiration'] = None,
                 id: Optional[str] = None,
                 noncurrent_version_expiration: Optional['outputs.SpacesBucketLifecycleRuleNoncurrentVersionExpiration'] = None,
                 prefix: Optional[str] = None):
        """
        :param bool enabled: Specifies lifecycle rule status.
        :param int abort_incomplete_multipart_upload_days: Specifies the number of days after initiating a multipart
               upload when the multipart upload must be completed or else Spaces will abort the upload.
        :param 'SpacesBucketLifecycleRuleExpirationArgs' expiration: Specifies a time period after which applicable objects expire (documented below).
        :param str id: Unique identifier for the rule.
        :param 'SpacesBucketLifecycleRuleNoncurrentVersionExpirationArgs' noncurrent_version_expiration: Specifies when non-current object versions expire (documented below).
        :param str prefix: Object key prefix identifying one or more objects to which the rule applies.
        """
        pulumi.set(__self__, "enabled", enabled)
        if abort_incomplete_multipart_upload_days is not None:
            pulumi.set(__self__, "abort_incomplete_multipart_upload_days", abort_incomplete_multipart_upload_days)
        if expiration is not None:
            pulumi.set(__self__, "expiration", expiration)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if noncurrent_version_expiration is not None:
            pulumi.set(__self__, "noncurrent_version_expiration", noncurrent_version_expiration)
        if prefix is not None:
            pulumi.set(__self__, "prefix", prefix)

    @property
    @pulumi.getter
    def enabled(self) -> bool:
        """
        Specifies lifecycle rule status.
        """
        return pulumi.get(self, "enabled")

    @property
    @pulumi.getter(name="abortIncompleteMultipartUploadDays")
    def abort_incomplete_multipart_upload_days(self) -> Optional[int]:
        """
        Specifies the number of days after initiating a multipart
        upload when the multipart upload must be completed or else Spaces will abort the upload.
        """
        return pulumi.get(self, "abort_incomplete_multipart_upload_days")

    @property
    @pulumi.getter
    def expiration(self) -> Optional['outputs.SpacesBucketLifecycleRuleExpiration']:
        """
        Specifies a time period after which applicable objects expire (documented below).
        """
        return pulumi.get(self, "expiration")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        Unique identifier for the rule.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="noncurrentVersionExpiration")
    def noncurrent_version_expiration(self) -> Optional['outputs.SpacesBucketLifecycleRuleNoncurrentVersionExpiration']:
        """
        Specifies when non-current object versions expire (documented below).
        """
        return pulumi.get(self, "noncurrent_version_expiration")

    @property
    @pulumi.getter
    def prefix(self) -> Optional[str]:
        """
        Object key prefix identifying one or more objects to which the rule applies.
        """
        return pulumi.get(self, "prefix")


@pulumi.output_type
class SpacesBucketLifecycleRuleExpiration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "expiredObjectDeleteMarker":
            suggest = "expired_object_delete_marker"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SpacesBucketLifecycleRuleExpiration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SpacesBucketLifecycleRuleExpiration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SpacesBucketLifecycleRuleExpiration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 date: Optional[str] = None,
                 days: Optional[int] = None,
                 expired_object_delete_marker: Optional[bool] = None):
        """
        :param str date: Specifies the date/time after which you want applicable objects to expire. The argument uses
               RFC3339 format, e.g. "2020-03-22T15:03:55Z" or parts thereof e.g. "2019-02-28".
        :param int days: Specifies the number of days after object creation when the applicable objects will expire.
        :param bool expired_object_delete_marker: On a versioned bucket (versioning-enabled or versioning-suspended
               bucket), setting this to true directs Spaces to delete expired object delete markers.
        """
        if date is not None:
            pulumi.set(__self__, "date", date)
        if days is not None:
            pulumi.set(__self__, "days", days)
        if expired_object_delete_marker is not None:
            pulumi.set(__self__, "expired_object_delete_marker", expired_object_delete_marker)

    @property
    @pulumi.getter
    def date(self) -> Optional[str]:
        """
        Specifies the date/time after which you want applicable objects to expire. The argument uses
        RFC3339 format, e.g. "2020-03-22T15:03:55Z" or parts thereof e.g. "2019-02-28".
        """
        return pulumi.get(self, "date")

    @property
    @pulumi.getter
    def days(self) -> Optional[int]:
        """
        Specifies the number of days after object creation when the applicable objects will expire.
        """
        return pulumi.get(self, "days")

    @property
    @pulumi.getter(name="expiredObjectDeleteMarker")
    def expired_object_delete_marker(self) -> Optional[bool]:
        """
        On a versioned bucket (versioning-enabled or versioning-suspended
        bucket), setting this to true directs Spaces to delete expired object delete markers.
        """
        return pulumi.get(self, "expired_object_delete_marker")


@pulumi.output_type
class SpacesBucketLifecycleRuleNoncurrentVersionExpiration(dict):
    def __init__(__self__, *,
                 days: Optional[int] = None):
        """
        :param int days: Specifies the number of days after which an object's non-current versions expire.
        """
        if days is not None:
            pulumi.set(__self__, "days", days)

    @property
    @pulumi.getter
    def days(self) -> Optional[int]:
        """
        Specifies the number of days after which an object's non-current versions expire.
        """
        return pulumi.get(self, "days")


@pulumi.output_type
class SpacesBucketVersioning(dict):
    def __init__(__self__, *,
                 enabled: Optional[bool] = None):
        """
        :param bool enabled: Enable versioning. Once you version-enable a bucket, it can never return to an unversioned
               state. You can, however, suspend versioning on that bucket.
        """
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)

    @property
    @pulumi.getter
    def enabled(self) -> Optional[bool]:
        """
        Enable versioning. Once you version-enable a bucket, it can never return to an unversioned
        state. You can, however, suspend versioning on that bucket.
        """
        return pulumi.get(self, "enabled")


@pulumi.output_type
class GetAppSpecResult(dict):
    def __init__(__self__, *,
                 domains: Sequence[str],
                 name: str,
                 databases: Optional[Sequence['outputs.GetAppSpecDatabaseResult']] = None,
                 envs: Optional[Sequence['outputs.GetAppSpecEnvResult']] = None,
                 jobs: Optional[Sequence['outputs.GetAppSpecJobResult']] = None,
                 region: Optional[str] = None,
                 services: Optional[Sequence['outputs.GetAppSpecServiceResult']] = None,
                 static_sites: Optional[Sequence['outputs.GetAppSpecStaticSiteResult']] = None,
                 workers: Optional[Sequence['outputs.GetAppSpecWorkerResult']] = None):
        """
        :param str name: The name of the component.
        :param Sequence['GetAppSpecEnvArgs'] envs: Describes an environment variable made available to an app competent.
        """
        pulumi.set(__self__, "domains", domains)
        pulumi.set(__self__, "name", name)
        if databases is not None:
            pulumi.set(__self__, "databases", databases)
        if envs is not None:
            pulumi.set(__self__, "envs", envs)
        if jobs is not None:
            pulumi.set(__self__, "jobs", jobs)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if services is not None:
            pulumi.set(__self__, "services", services)
        if static_sites is not None:
            pulumi.set(__self__, "static_sites", static_sites)
        if workers is not None:
            pulumi.set(__self__, "workers", workers)

    @property
    @pulumi.getter
    def domains(self) -> Sequence[str]:
        return pulumi.get(self, "domains")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the component.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def databases(self) -> Optional[Sequence['outputs.GetAppSpecDatabaseResult']]:
        return pulumi.get(self, "databases")

    @property
    @pulumi.getter
    def envs(self) -> Optional[Sequence['outputs.GetAppSpecEnvResult']]:
        """
        Describes an environment variable made available to an app competent.
        """
        return pulumi.get(self, "envs")

    @property
    @pulumi.getter
    def jobs(self) -> Optional[Sequence['outputs.GetAppSpecJobResult']]:
        return pulumi.get(self, "jobs")

    @property
    @pulumi.getter
    def region(self) -> Optional[str]:
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def services(self) -> Optional[Sequence['outputs.GetAppSpecServiceResult']]:
        return pulumi.get(self, "services")

    @property
    @pulumi.getter(name="staticSites")
    def static_sites(self) -> Optional[Sequence['outputs.GetAppSpecStaticSiteResult']]:
        return pulumi.get(self, "static_sites")

    @property
    @pulumi.getter
    def workers(self) -> Optional[Sequence['outputs.GetAppSpecWorkerResult']]:
        return pulumi.get(self, "workers")


@pulumi.output_type
class GetAppSpecDatabaseResult(dict):
    def __init__(__self__, *,
                 cluster_name: Optional[str] = None,
                 db_name: Optional[str] = None,
                 db_user: Optional[str] = None,
                 engine: Optional[str] = None,
                 name: Optional[str] = None,
                 production: Optional[bool] = None,
                 version: Optional[str] = None):
        """
        :param str cluster_name: The name of the underlying DigitalOcean DBaaS cluster. This is required for production databases. For dev databases, if `cluster_name` is not set, a new cluster will be provisioned.
        :param str db_name: The name of the MySQL or PostgreSQL database to configure.
        :param str db_user: The name of the MySQL or PostgreSQL user to configure.
        :param str engine: The database engine to use (`MYSQL`, `PG`, or `REDIS`).
        :param str name: The name of the component.
        :param bool production: Whether this is a production or dev database.
        :param str version: The version of the database engine.
        """
        if cluster_name is not None:
            pulumi.set(__self__, "cluster_name", cluster_name)
        if db_name is not None:
            pulumi.set(__self__, "db_name", db_name)
        if db_user is not None:
            pulumi.set(__self__, "db_user", db_user)
        if engine is not None:
            pulumi.set(__self__, "engine", engine)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if production is not None:
            pulumi.set(__self__, "production", production)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> Optional[str]:
        """
        The name of the underlying DigitalOcean DBaaS cluster. This is required for production databases. For dev databases, if `cluster_name` is not set, a new cluster will be provisioned.
        """
        return pulumi.get(self, "cluster_name")

    @property
    @pulumi.getter(name="dbName")
    def db_name(self) -> Optional[str]:
        """
        The name of the MySQL or PostgreSQL database to configure.
        """
        return pulumi.get(self, "db_name")

    @property
    @pulumi.getter(name="dbUser")
    def db_user(self) -> Optional[str]:
        """
        The name of the MySQL or PostgreSQL user to configure.
        """
        return pulumi.get(self, "db_user")

    @property
    @pulumi.getter
    def engine(self) -> Optional[str]:
        """
        The database engine to use (`MYSQL`, `PG`, or `REDIS`).
        """
        return pulumi.get(self, "engine")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the component.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def production(self) -> Optional[bool]:
        """
        Whether this is a production or dev database.
        """
        return pulumi.get(self, "production")

    @property
    @pulumi.getter
    def version(self) -> Optional[str]:
        """
        The version of the database engine.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetAppSpecEnvResult(dict):
    def __init__(__self__, *,
                 type: str,
                 key: Optional[str] = None,
                 scope: Optional[str] = None,
                 value: Optional[str] = None):
        """
        :param str type: The type of the environment variable, `GENERAL` or `SECRET`.
        :param str key: The name of the environment variable.
        :param str scope: The visibility scope of the environment variable. One of `RUN_TIME`, `BUILD_TIME`, or `RUN_AND_BUILD_TIME` (default).
        :param str value: The value of the environment variable.
        """
        pulumi.set(__self__, "type", type)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the environment variable, `GENERAL` or `SECRET`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def key(self) -> Optional[str]:
        """
        The name of the environment variable.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def scope(self) -> Optional[str]:
        """
        The visibility scope of the environment variable. One of `RUN_TIME`, `BUILD_TIME`, or `RUN_AND_BUILD_TIME` (default).
        """
        return pulumi.get(self, "scope")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        The value of the environment variable.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetAppSpecJobResult(dict):
    def __init__(__self__, *,
                 name: str,
                 build_command: Optional[str] = None,
                 dockerfile_path: Optional[str] = None,
                 environment_slug: Optional[str] = None,
                 envs: Optional[Sequence['outputs.GetAppSpecJobEnvResult']] = None,
                 git: Optional['outputs.GetAppSpecJobGitResult'] = None,
                 github: Optional['outputs.GetAppSpecJobGithubResult'] = None,
                 gitlab: Optional['outputs.GetAppSpecJobGitlabResult'] = None,
                 image: Optional['outputs.GetAppSpecJobImageResult'] = None,
                 instance_count: Optional[int] = None,
                 instance_size_slug: Optional[str] = None,
                 kind: Optional[str] = None,
                 run_command: Optional[str] = None,
                 source_dir: Optional[str] = None):
        """
        :param str name: The name of the component.
        :param str build_command: An optional build command to run while building this component from source.
        :param str dockerfile_path: The path to a Dockerfile relative to the root of the repo. If set, overrides usage of buildpacks.
        :param str environment_slug: An environment slug describing the type of this app.
        :param Sequence['GetAppSpecJobEnvArgs'] envs: Describes an environment variable made available to an app competent.
        :param 'GetAppSpecJobGitArgs' git: A Git repo to use as the component's source. The repository must be able to be cloned without authentication.  Only one of `git`, `github` or `gitlab`  may be set.
        :param 'GetAppSpecJobGithubArgs' github: A GitHub repo to use as the component's source. DigitalOcean App Platform must have [access to the repository](https://cloud.digitalocean.com/apps/github/install). Only one of `git`, `github`, `gitlab`, or `image` may be set.
        :param 'GetAppSpecJobGitlabArgs' gitlab: A Gitlab repo to use as the component's source. DigitalOcean App Platform must have [access to the repository](https://cloud.digitalocean.com/apps/gitlab/install). Only one of `git`, `github`, `gitlab`, or `image` may be set.
        :param 'GetAppSpecJobImageArgs' image: An image to use as the component's source. Only one of `git`, `github`, `gitlab`, or `image` may be set.
        :param int instance_count: The amount of instances that this component should be scaled to.
        :param str instance_size_slug: The instance size to use for this component.
        :param str kind: The type of job and when it will be run during the deployment process. It may be one of:
               - `UNSPECIFIED`: Default job type, will auto-complete to POST_DEPLOY kind.
               - `PRE_DEPLOY`: Indicates a job that runs before an app deployment.
               - `POST_DEPLOY`: Indicates a job that runs after an app deployment.
               - `FAILED_DEPLOY`: Indicates a job that runs after a component fails to deploy.
        :param str run_command: An optional run command to override the component's default.
        :param str source_dir: An optional path to the working directory to use for the build.
        """
        pulumi.set(__self__, "name", name)
        if build_command is not None:
            pulumi.set(__self__, "build_command", build_command)
        if dockerfile_path is not None:
            pulumi.set(__self__, "dockerfile_path", dockerfile_path)
        if environment_slug is not None:
            pulumi.set(__self__, "environment_slug", environment_slug)
        if envs is not None:
            pulumi.set(__self__, "envs", envs)
        if git is not None:
            pulumi.set(__self__, "git", git)
        if github is not None:
            pulumi.set(__self__, "github", github)
        if gitlab is not None:
            pulumi.set(__self__, "gitlab", gitlab)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if instance_count is not None:
            pulumi.set(__self__, "instance_count", instance_count)
        if instance_size_slug is not None:
            pulumi.set(__self__, "instance_size_slug", instance_size_slug)
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if run_command is not None:
            pulumi.set(__self__, "run_command", run_command)
        if source_dir is not None:
            pulumi.set(__self__, "source_dir", source_dir)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the component.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="buildCommand")
    def build_command(self) -> Optional[str]:
        """
        An optional build command to run while building this component from source.
        """
        return pulumi.get(self, "build_command")

    @property
    @pulumi.getter(name="dockerfilePath")
    def dockerfile_path(self) -> Optional[str]:
        """
        The path to a Dockerfile relative to the root of the repo. If set, overrides usage of buildpacks.
        """
        return pulumi.get(self, "dockerfile_path")

    @property
    @pulumi.getter(name="environmentSlug")
    def environment_slug(self) -> Optional[str]:
        """
        An environment slug describing the type of this app.
        """
        return pulumi.get(self, "environment_slug")

    @property
    @pulumi.getter
    def envs(self) -> Optional[Sequence['outputs.GetAppSpecJobEnvResult']]:
        """
        Describes an environment variable made available to an app competent.
        """
        return pulumi.get(self, "envs")

    @property
    @pulumi.getter
    def git(self) -> Optional['outputs.GetAppSpecJobGitResult']:
        """
        A Git repo to use as the component's source. The repository must be able to be cloned without authentication.  Only one of `git`, `github` or `gitlab`  may be set.
        """
        return pulumi.get(self, "git")

    @property
    @pulumi.getter
    def github(self) -> Optional['outputs.GetAppSpecJobGithubResult']:
        """
        A GitHub repo to use as the component's source. DigitalOcean App Platform must have [access to the repository](https://cloud.digitalocean.com/apps/github/install). Only one of `git`, `github`, `gitlab`, or `image` may be set.
        """
        return pulumi.get(self, "github")

    @property
    @pulumi.getter
    def gitlab(self) -> Optional['outputs.GetAppSpecJobGitlabResult']:
        """
        A Gitlab repo to use as the component's source. DigitalOcean App Platform must have [access to the repository](https://cloud.digitalocean.com/apps/gitlab/install). Only one of `git`, `github`, `gitlab`, or `image` may be set.
        """
        return pulumi.get(self, "gitlab")

    @property
    @pulumi.getter
    def image(self) -> Optional['outputs.GetAppSpecJobImageResult']:
        """
        An image to use as the component's source. Only one of `git`, `github`, `gitlab`, or `image` may be set.
        """
        return pulumi.get(self, "image")

    @property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> Optional[int]:
        """
        The amount of instances that this component should be scaled to.
        """
        return pulumi.get(self, "instance_count")

    @property
    @pulumi.getter(name="instanceSizeSlug")
    def instance_size_slug(self) -> Optional[str]:
        """
        The instance size to use for this component.
        """
        return pulumi.get(self, "instance_size_slug")

    @property
    @pulumi.getter
    def kind(self) -> Optional[str]:
        """
        The type of job and when it will be run during the deployment process. It may be one of:
        - `UNSPECIFIED`: Default job type, will auto-complete to POST_DEPLOY kind.
        - `PRE_DEPLOY`: Indicates a job that runs before an app deployment.
        - `POST_DEPLOY`: Indicates a job that runs after an app deployment.
        - `FAILED_DEPLOY`: Indicates a job that runs after a component fails to deploy.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter(name="runCommand")
    def run_command(self) -> Optional[str]:
        """
        An optional run command to override the component's default.
        """
        return pulumi.get(self, "run_command")

    @property
    @pulumi.getter(name="sourceDir")
    def source_dir(self) -> Optional[str]:
        """
        An optional path to the working directory to use for the build.
        """
        return pulumi.get(self, "source_dir")


@pulumi.output_type
class GetAppSpecJobEnvResult(dict):
    def __init__(__self__, *,
                 type: str,
                 key: Optional[str] = None,
                 scope: Optional[str] = None,
                 value: Optional[str] = None):
        """
        :param str type: The type of the environment variable, `GENERAL` or `SECRET`.
        :param str key: The name of the environment variable.
        :param str scope: The visibility scope of the environment variable. One of `RUN_TIME`, `BUILD_TIME`, or `RUN_AND_BUILD_TIME` (default).
        :param str value: The value of the environment variable.
        """
        pulumi.set(__self__, "type", type)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the environment variable, `GENERAL` or `SECRET`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def key(self) -> Optional[str]:
        """
        The name of the environment variable.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def scope(self) -> Optional[str]:
        """
        The visibility scope of the environment variable. One of `RUN_TIME`, `BUILD_TIME`, or `RUN_AND_BUILD_TIME` (default).
        """
        return pulumi.get(self, "scope")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        The value of the environment variable.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetAppSpecJobGitResult(dict):
    def __init__(__self__, *,
                 branch: Optional[str] = None,
                 repo_clone_url: Optional[str] = None):
        """
        :param str branch: The name of the branch to use.
        :param str repo_clone_url: The clone URL of the repo.
        """
        if branch is not None:
            pulumi.set(__self__, "branch", branch)
        if repo_clone_url is not None:
            pulumi.set(__self__, "repo_clone_url", repo_clone_url)

    @property
    @pulumi.getter
    def branch(self) -> Optional[str]:
        """
        The name of the branch to use.
        """
        return pulumi.get(self, "branch")

    @property
    @pulumi.getter(name="repoCloneUrl")
    def repo_clone_url(self) -> Optional[str]:
        """
        The clone URL of the repo.
        """
        return pulumi.get(self, "repo_clone_url")


@pulumi.output_type
class GetAppSpecJobGithubResult(dict):
    def __init__(__self__, *,
                 branch: Optional[str] = None,
                 deploy_on_push: Optional[bool] = None,
                 repo: Optional[str] = None):
        """
        :param str branch: The name of the branch to use.
        :param bool deploy_on_push: Whether to automatically deploy new commits made to the repo.
        :param str repo: The name of the repo in the format `owner/repo`.
        """
        if branch is not None:
            pulumi.set(__self__, "branch", branch)
        if deploy_on_push is not None:
            pulumi.set(__self__, "deploy_on_push", deploy_on_push)
        if repo is not None:
            pulumi.set(__self__, "repo", repo)

    @property
    @pulumi.getter
    def branch(self) -> Optional[str]:
        """
        The name of the branch to use.
        """
        return pulumi.get(self, "branch")

    @property
    @pulumi.getter(name="deployOnPush")
    def deploy_on_push(self) -> Optional[bool]:
        """
        Whether to automatically deploy new commits made to the repo.
        """
        return pulumi.get(self, "deploy_on_push")

    @property
    @pulumi.getter
    def repo(self) -> Optional[str]:
        """
        The name of the repo in the format `owner/repo`.
        """
        return pulumi.get(self, "repo")


@pulumi.output_type
class GetAppSpecJobGitlabResult(dict):
    def __init__(__self__, *,
                 branch: Optional[str] = None,
                 deploy_on_push: Optional[bool] = None,
                 repo: Optional[str] = None):
        """
        :param str branch: The name of the branch to use.
        :param bool deploy_on_push: Whether to automatically deploy new commits made to the repo.
        :param str repo: The name of the repo in the format `owner/repo`.
        """
        if branch is not None:
            pulumi.set(__self__, "branch", branch)
        if deploy_on_push is not None:
            pulumi.set(__self__, "deploy_on_push", deploy_on_push)
        if repo is not None:
            pulumi.set(__self__, "repo", repo)

    @property
    @pulumi.getter
    def branch(self) -> Optional[str]:
        """
        The name of the branch to use.
        """
        return pulumi.get(self, "branch")

    @property
    @pulumi.getter(name="deployOnPush")
    def deploy_on_push(self) -> Optional[bool]:
        """
        Whether to automatically deploy new commits made to the repo.
        """
        return pulumi.get(self, "deploy_on_push")

    @property
    @pulumi.getter
    def repo(self) -> Optional[str]:
        """
        The name of the repo in the format `owner/repo`.
        """
        return pulumi.get(self, "repo")


@pulumi.output_type
class GetAppSpecJobImageResult(dict):
    def __init__(__self__, *,
                 registry_type: str,
                 repository: str,
                 registry: Optional[str] = None,
                 tag: Optional[str] = None):
        """
        :param str registry_type: The registry type. One of `DOCR` (DigitalOcean container registry) or `DOCKER_HUB`.
        :param str repository: The repository name.
        :param str registry: The registry name. Must be left empty for the `DOCR` registry type. Required for the `DOCKER_HUB` registry type.
        :param str tag: The repository tag. Defaults to `latest` if not provided.
        """
        pulumi.set(__self__, "registry_type", registry_type)
        pulumi.set(__self__, "repository", repository)
        if registry is not None:
            pulumi.set(__self__, "registry", registry)
        if tag is not None:
            pulumi.set(__self__, "tag", tag)

    @property
    @pulumi.getter(name="registryType")
    def registry_type(self) -> str:
        """
        The registry type. One of `DOCR` (DigitalOcean container registry) or `DOCKER_HUB`.
        """
        return pulumi.get(self, "registry_type")

    @property
    @pulumi.getter
    def repository(self) -> str:
        """
        The repository name.
        """
        return pulumi.get(self, "repository")

    @property
    @pulumi.getter
    def registry(self) -> Optional[str]:
        """
        The registry name. Must be left empty for the `DOCR` registry type. Required for the `DOCKER_HUB` registry type.
        """
        return pulumi.get(self, "registry")

    @property
    @pulumi.getter
    def tag(self) -> Optional[str]:
        """
        The repository tag. Defaults to `latest` if not provided.
        """
        return pulumi.get(self, "tag")


@pulumi.output_type
class GetAppSpecServiceResult(dict):
    def __init__(__self__, *,
                 http_port: int,
                 name: str,
                 routes: Sequence['outputs.GetAppSpecServiceRouteResult'],
                 run_command: str,
                 build_command: Optional[str] = None,
                 dockerfile_path: Optional[str] = None,
                 environment_slug: Optional[str] = None,
                 envs: Optional[Sequence['outputs.GetAppSpecServiceEnvResult']] = None,
                 git: Optional['outputs.GetAppSpecServiceGitResult'] = None,
                 github: Optional['outputs.GetAppSpecServiceGithubResult'] = None,
                 gitlab: Optional['outputs.GetAppSpecServiceGitlabResult'] = None,
                 health_check: Optional['outputs.GetAppSpecServiceHealthCheckResult'] = None,
                 image: Optional['outputs.GetAppSpecServiceImageResult'] = None,
                 instance_count: Optional[int] = None,
                 instance_size_slug: Optional[str] = None,
                 internal_ports: Optional[Sequence[int]] = None,
                 source_dir: Optional[str] = None):
        """
        :param int http_port: The internal port on which this service's run command will listen.
        :param str name: The name of the component.
        :param str run_command: An optional run command to override the component's default.
        :param str build_command: An optional build command to run while building this component from source.
        :param str dockerfile_path: The path to a Dockerfile relative to the root of the repo. If set, overrides usage of buildpacks.
        :param str environment_slug: An environment slug describing the type of this app.
        :param Sequence['GetAppSpecServiceEnvArgs'] envs: Describes an environment variable made available to an app competent.
        :param 'GetAppSpecServiceGitArgs' git: A Git repo to use as the component's source. The repository must be able to be cloned without authentication.  Only one of `git`, `github` or `gitlab`  may be set.
        :param 'GetAppSpecServiceGithubArgs' github: A GitHub repo to use as the component's source. DigitalOcean App Platform must have [access to the repository](https://cloud.digitalocean.com/apps/github/install). Only one of `git`, `github`, `gitlab`, or `image` may be set.
        :param 'GetAppSpecServiceGitlabArgs' gitlab: A Gitlab repo to use as the component's source. DigitalOcean App Platform must have [access to the repository](https://cloud.digitalocean.com/apps/gitlab/install). Only one of `git`, `github`, `gitlab`, or `image` may be set.
        :param 'GetAppSpecServiceHealthCheckArgs' health_check: A health check to determine the availability of this component.
        :param 'GetAppSpecServiceImageArgs' image: An image to use as the component's source. Only one of `git`, `github`, `gitlab`, or `image` may be set.
        :param int instance_count: The amount of instances that this component should be scaled to.
        :param str instance_size_slug: The instance size to use for this component.
        :param Sequence[int] internal_ports: A list of ports on which this service will listen for internal traffic.
        :param str source_dir: An optional path to the working directory to use for the build.
        """
        pulumi.set(__self__, "http_port", http_port)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "routes", routes)
        pulumi.set(__self__, "run_command", run_command)
        if build_command is not None:
            pulumi.set(__self__, "build_command", build_command)
        if dockerfile_path is not None:
            pulumi.set(__self__, "dockerfile_path", dockerfile_path)
        if environment_slug is not None:
            pulumi.set(__self__, "environment_slug", environment_slug)
        if envs is not None:
            pulumi.set(__self__, "envs", envs)
        if git is not None:
            pulumi.set(__self__, "git", git)
        if github is not None:
            pulumi.set(__self__, "github", github)
        if gitlab is not None:
            pulumi.set(__self__, "gitlab", gitlab)
        if health_check is not None:
            pulumi.set(__self__, "health_check", health_check)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if instance_count is not None:
            pulumi.set(__self__, "instance_count", instance_count)
        if instance_size_slug is not None:
            pulumi.set(__self__, "instance_size_slug", instance_size_slug)
        if internal_ports is not None:
            pulumi.set(__self__, "internal_ports", internal_ports)
        if source_dir is not None:
            pulumi.set(__self__, "source_dir", source_dir)

    @property
    @pulumi.getter(name="httpPort")
    def http_port(self) -> int:
        """
        The internal port on which this service's run command will listen.
        """
        return pulumi.get(self, "http_port")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the component.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def routes(self) -> Sequence['outputs.GetAppSpecServiceRouteResult']:
        return pulumi.get(self, "routes")

    @property
    @pulumi.getter(name="runCommand")
    def run_command(self) -> str:
        """
        An optional run command to override the component's default.
        """
        return pulumi.get(self, "run_command")

    @property
    @pulumi.getter(name="buildCommand")
    def build_command(self) -> Optional[str]:
        """
        An optional build command to run while building this component from source.
        """
        return pulumi.get(self, "build_command")

    @property
    @pulumi.getter(name="dockerfilePath")
    def dockerfile_path(self) -> Optional[str]:
        """
        The path to a Dockerfile relative to the root of the repo. If set, overrides usage of buildpacks.
        """
        return pulumi.get(self, "dockerfile_path")

    @property
    @pulumi.getter(name="environmentSlug")
    def environment_slug(self) -> Optional[str]:
        """
        An environment slug describing the type of this app.
        """
        return pulumi.get(self, "environment_slug")

    @property
    @pulumi.getter
    def envs(self) -> Optional[Sequence['outputs.GetAppSpecServiceEnvResult']]:
        """
        Describes an environment variable made available to an app competent.
        """
        return pulumi.get(self, "envs")

    @property
    @pulumi.getter
    def git(self) -> Optional['outputs.GetAppSpecServiceGitResult']:
        """
        A Git repo to use as the component's source. The repository must be able to be cloned without authentication.  Only one of `git`, `github` or `gitlab`  may be set.
        """
        return pulumi.get(self, "git")

    @property
    @pulumi.getter
    def github(self) -> Optional['outputs.GetAppSpecServiceGithubResult']:
        """
        A GitHub repo to use as the component's source. DigitalOcean App Platform must have [access to the repository](https://cloud.digitalocean.com/apps/github/install). Only one of `git`, `github`, `gitlab`, or `image` may be set.
        """
        return pulumi.get(self, "github")

    @property
    @pulumi.getter
    def gitlab(self) -> Optional['outputs.GetAppSpecServiceGitlabResult']:
        """
        A Gitlab repo to use as the component's source. DigitalOcean App Platform must have [access to the repository](https://cloud.digitalocean.com/apps/gitlab/install). Only one of `git`, `github`, `gitlab`, or `image` may be set.
        """
        return pulumi.get(self, "gitlab")

    @property
    @pulumi.getter(name="healthCheck")
    def health_check(self) -> Optional['outputs.GetAppSpecServiceHealthCheckResult']:
        """
        A health check to determine the availability of this component.
        """
        return pulumi.get(self, "health_check")

    @property
    @pulumi.getter
    def image(self) -> Optional['outputs.GetAppSpecServiceImageResult']:
        """
        An image to use as the component's source. Only one of `git`, `github`, `gitlab`, or `image` may be set.
        """
        return pulumi.get(self, "image")

    @property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> Optional[int]:
        """
        The amount of instances that this component should be scaled to.
        """
        return pulumi.get(self, "instance_count")

    @property
    @pulumi.getter(name="instanceSizeSlug")
    def instance_size_slug(self) -> Optional[str]:
        """
        The instance size to use for this component.
        """
        return pulumi.get(self, "instance_size_slug")

    @property
    @pulumi.getter(name="internalPorts")
    def internal_ports(self) -> Optional[Sequence[int]]:
        """
        A list of ports on which this service will listen for internal traffic.
        """
        return pulumi.get(self, "internal_ports")

    @property
    @pulumi.getter(name="sourceDir")
    def source_dir(self) -> Optional[str]:
        """
        An optional path to the working directory to use for the build.
        """
        return pulumi.get(self, "source_dir")


@pulumi.output_type
class GetAppSpecServiceEnvResult(dict):
    def __init__(__self__, *,
                 type: str,
                 key: Optional[str] = None,
                 scope: Optional[str] = None,
                 value: Optional[str] = None):
        """
        :param str type: The type of the environment variable, `GENERAL` or `SECRET`.
        :param str key: The name of the environment variable.
        :param str scope: The visibility scope of the environment variable. One of `RUN_TIME`, `BUILD_TIME`, or `RUN_AND_BUILD_TIME` (default).
        :param str value: The value of the environment variable.
        """
        pulumi.set(__self__, "type", type)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the environment variable, `GENERAL` or `SECRET`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def key(self) -> Optional[str]:
        """
        The name of the environment variable.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def scope(self) -> Optional[str]:
        """
        The visibility scope of the environment variable. One of `RUN_TIME`, `BUILD_TIME`, or `RUN_AND_BUILD_TIME` (default).
        """
        return pulumi.get(self, "scope")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        The value of the environment variable.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetAppSpecServiceGitResult(dict):
    def __init__(__self__, *,
                 branch: Optional[str] = None,
                 repo_clone_url: Optional[str] = None):
        """
        :param str branch: The name of the branch to use.
        :param str repo_clone_url: The clone URL of the repo.
        """
        if branch is not None:
            pulumi.set(__self__, "branch", branch)
        if repo_clone_url is not None:
            pulumi.set(__self__, "repo_clone_url", repo_clone_url)

    @property
    @pulumi.getter
    def branch(self) -> Optional[str]:
        """
        The name of the branch to use.
        """
        return pulumi.get(self, "branch")

    @property
    @pulumi.getter(name="repoCloneUrl")
    def repo_clone_url(self) -> Optional[str]:
        """
        The clone URL of the repo.
        """
        return pulumi.get(self, "repo_clone_url")


@pulumi.output_type
class GetAppSpecServiceGithubResult(dict):
    def __init__(__self__, *,
                 branch: Optional[str] = None,
                 deploy_on_push: Optional[bool] = None,
                 repo: Optional[str] = None):
        """
        :param str branch: The name of the branch to use.
        :param bool deploy_on_push: Whether to automatically deploy new commits made to the repo.
        :param str repo: The name of the repo in the format `owner/repo`.
        """
        if branch is not None:
            pulumi.set(__self__, "branch", branch)
        if deploy_on_push is not None:
            pulumi.set(__self__, "deploy_on_push", deploy_on_push)
        if repo is not None:
            pulumi.set(__self__, "repo", repo)

    @property
    @pulumi.getter
    def branch(self) -> Optional[str]:
        """
        The name of the branch to use.
        """
        return pulumi.get(self, "branch")

    @property
    @pulumi.getter(name="deployOnPush")
    def deploy_on_push(self) -> Optional[bool]:
        """
        Whether to automatically deploy new commits made to the repo.
        """
        return pulumi.get(self, "deploy_on_push")

    @property
    @pulumi.getter
    def repo(self) -> Optional[str]:
        """
        The name of the repo in the format `owner/repo`.
        """
        return pulumi.get(self, "repo")


@pulumi.output_type
class GetAppSpecServiceGitlabResult(dict):
    def __init__(__self__, *,
                 branch: Optional[str] = None,
                 deploy_on_push: Optional[bool] = None,
                 repo: Optional[str] = None):
        """
        :param str branch: The name of the branch to use.
        :param bool deploy_on_push: Whether to automatically deploy new commits made to the repo.
        :param str repo: The name of the repo in the format `owner/repo`.
        """
        if branch is not None:
            pulumi.set(__self__, "branch", branch)
        if deploy_on_push is not None:
            pulumi.set(__self__, "deploy_on_push", deploy_on_push)
        if repo is not None:
            pulumi.set(__self__, "repo", repo)

    @property
    @pulumi.getter
    def branch(self) -> Optional[str]:
        """
        The name of the branch to use.
        """
        return pulumi.get(self, "branch")

    @property
    @pulumi.getter(name="deployOnPush")
    def deploy_on_push(self) -> Optional[bool]:
        """
        Whether to automatically deploy new commits made to the repo.
        """
        return pulumi.get(self, "deploy_on_push")

    @property
    @pulumi.getter
    def repo(self) -> Optional[str]:
        """
        The name of the repo in the format `owner/repo`.
        """
        return pulumi.get(self, "repo")


@pulumi.output_type
class GetAppSpecServiceHealthCheckResult(dict):
    def __init__(__self__, *,
                 failure_threshold: Optional[int] = None,
                 http_path: Optional[str] = None,
                 initial_delay_seconds: Optional[int] = None,
                 period_seconds: Optional[int] = None,
                 success_threshold: Optional[int] = None,
                 timeout_seconds: Optional[int] = None):
        """
        :param int failure_threshold: The number of failed health checks before considered unhealthy.
        :param str http_path: The route path used for the HTTP health check ping.
        :param int initial_delay_seconds: The number of seconds to wait before beginning health checks.
        :param int period_seconds: The number of seconds to wait between health checks.
        :param int success_threshold: The number of successful health checks before considered healthy.
        :param int timeout_seconds: The number of seconds after which the check times out.
        """
        if failure_threshold is not None:
            pulumi.set(__self__, "failure_threshold", failure_threshold)
        if http_path is not None:
            pulumi.set(__self__, "http_path", http_path)
        if initial_delay_seconds is not None:
            pulumi.set(__self__, "initial_delay_seconds", initial_delay_seconds)
        if period_seconds is not None:
            pulumi.set(__self__, "period_seconds", period_seconds)
        if success_threshold is not None:
            pulumi.set(__self__, "success_threshold", success_threshold)
        if timeout_seconds is not None:
            pulumi.set(__self__, "timeout_seconds", timeout_seconds)

    @property
    @pulumi.getter(name="failureThreshold")
    def failure_threshold(self) -> Optional[int]:
        """
        The number of failed health checks before considered unhealthy.
        """
        return pulumi.get(self, "failure_threshold")

    @property
    @pulumi.getter(name="httpPath")
    def http_path(self) -> Optional[str]:
        """
        The route path used for the HTTP health check ping.
        """
        return pulumi.get(self, "http_path")

    @property
    @pulumi.getter(name="initialDelaySeconds")
    def initial_delay_seconds(self) -> Optional[int]:
        """
        The number of seconds to wait before beginning health checks.
        """
        return pulumi.get(self, "initial_delay_seconds")

    @property
    @pulumi.getter(name="periodSeconds")
    def period_seconds(self) -> Optional[int]:
        """
        The number of seconds to wait between health checks.
        """
        return pulumi.get(self, "period_seconds")

    @property
    @pulumi.getter(name="successThreshold")
    def success_threshold(self) -> Optional[int]:
        """
        The number of successful health checks before considered healthy.
        """
        return pulumi.get(self, "success_threshold")

    @property
    @pulumi.getter(name="timeoutSeconds")
    def timeout_seconds(self) -> Optional[int]:
        """
        The number of seconds after which the check times out.
        """
        return pulumi.get(self, "timeout_seconds")


@pulumi.output_type
class GetAppSpecServiceImageResult(dict):
    def __init__(__self__, *,
                 registry_type: str,
                 repository: str,
                 registry: Optional[str] = None,
                 tag: Optional[str] = None):
        """
        :param str registry_type: The registry type. One of `DOCR` (DigitalOcean container registry) or `DOCKER_HUB`.
        :param str repository: The repository name.
        :param str registry: The registry name. Must be left empty for the `DOCR` registry type. Required for the `DOCKER_HUB` registry type.
        :param str tag: The repository tag. Defaults to `latest` if not provided.
        """
        pulumi.set(__self__, "registry_type", registry_type)
        pulumi.set(__self__, "repository", repository)
        if registry is not None:
            pulumi.set(__self__, "registry", registry)
        if tag is not None:
            pulumi.set(__self__, "tag", tag)

    @property
    @pulumi.getter(name="registryType")
    def registry_type(self) -> str:
        """
        The registry type. One of `DOCR` (DigitalOcean container registry) or `DOCKER_HUB`.
        """
        return pulumi.get(self, "registry_type")

    @property
    @pulumi.getter
    def repository(self) -> str:
        """
        The repository name.
        """
        return pulumi.get(self, "repository")

    @property
    @pulumi.getter
    def registry(self) -> Optional[str]:
        """
        The registry name. Must be left empty for the `DOCR` registry type. Required for the `DOCKER_HUB` registry type.
        """
        return pulumi.get(self, "registry")

    @property
    @pulumi.getter
    def tag(self) -> Optional[str]:
        """
        The repository tag. Defaults to `latest` if not provided.
        """
        return pulumi.get(self, "tag")


@pulumi.output_type
class GetAppSpecServiceRouteResult(dict):
    def __init__(__self__, *,
                 path: Optional[str] = None):
        """
        :param str path: Paths must start with `/` and must be unique within the app.
        """
        if path is not None:
            pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        Paths must start with `/` and must be unique within the app.
        """
        return pulumi.get(self, "path")


@pulumi.output_type
class GetAppSpecStaticSiteResult(dict):
    def __init__(__self__, *,
                 name: str,
                 routes: Sequence['outputs.GetAppSpecStaticSiteRouteResult'],
                 build_command: Optional[str] = None,
                 catchall_document: Optional[str] = None,
                 dockerfile_path: Optional[str] = None,
                 environment_slug: Optional[str] = None,
                 envs: Optional[Sequence['outputs.GetAppSpecStaticSiteEnvResult']] = None,
                 error_document: Optional[str] = None,
                 git: Optional['outputs.GetAppSpecStaticSiteGitResult'] = None,
                 github: Optional['outputs.GetAppSpecStaticSiteGithubResult'] = None,
                 gitlab: Optional['outputs.GetAppSpecStaticSiteGitlabResult'] = None,
                 index_document: Optional[str] = None,
                 output_dir: Optional[str] = None,
                 source_dir: Optional[str] = None):
        """
        :param str name: The name of the component.
        :param str build_command: An optional build command to run while building this component from source.
        :param str catchall_document: The name of the document to use as the fallback for any requests to documents that are not found when serving this static site.
        :param str dockerfile_path: The path to a Dockerfile relative to the root of the repo. If set, overrides usage of buildpacks.
        :param str environment_slug: An environment slug describing the type of this app.
        :param Sequence['GetAppSpecStaticSiteEnvArgs'] envs: Describes an environment variable made available to an app competent.
        :param str error_document: The name of the error document to use when serving this static site.
        :param 'GetAppSpecStaticSiteGitArgs' git: A Git repo to use as the component's source. The repository must be able to be cloned without authentication.  Only one of `git`, `github` or `gitlab`  may be set.
        :param 'GetAppSpecStaticSiteGithubArgs' github: A GitHub repo to use as the component's source. DigitalOcean App Platform must have [access to the repository](https://cloud.digitalocean.com/apps/github/install). Only one of `git`, `github`, `gitlab`, or `image` may be set.
        :param 'GetAppSpecStaticSiteGitlabArgs' gitlab: A Gitlab repo to use as the component's source. DigitalOcean App Platform must have [access to the repository](https://cloud.digitalocean.com/apps/gitlab/install). Only one of `git`, `github`, `gitlab`, or `image` may be set.
        :param str index_document: The name of the index document to use when serving this static site.
        :param str output_dir: An optional path to where the built assets will be located, relative to the build context. If not set, App Platform will automatically scan for these directory names: `_static`, `dist`, `public`.
        :param str source_dir: An optional path to the working directory to use for the build.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "routes", routes)
        if build_command is not None:
            pulumi.set(__self__, "build_command", build_command)
        if catchall_document is not None:
            pulumi.set(__self__, "catchall_document", catchall_document)
        if dockerfile_path is not None:
            pulumi.set(__self__, "dockerfile_path", dockerfile_path)
        if environment_slug is not None:
            pulumi.set(__self__, "environment_slug", environment_slug)
        if envs is not None:
            pulumi.set(__self__, "envs", envs)
        if error_document is not None:
            pulumi.set(__self__, "error_document", error_document)
        if git is not None:
            pulumi.set(__self__, "git", git)
        if github is not None:
            pulumi.set(__self__, "github", github)
        if gitlab is not None:
            pulumi.set(__self__, "gitlab", gitlab)
        if index_document is not None:
            pulumi.set(__self__, "index_document", index_document)
        if output_dir is not None:
            pulumi.set(__self__, "output_dir", output_dir)
        if source_dir is not None:
            pulumi.set(__self__, "source_dir", source_dir)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the component.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def routes(self) -> Sequence['outputs.GetAppSpecStaticSiteRouteResult']:
        return pulumi.get(self, "routes")

    @property
    @pulumi.getter(name="buildCommand")
    def build_command(self) -> Optional[str]:
        """
        An optional build command to run while building this component from source.
        """
        return pulumi.get(self, "build_command")

    @property
    @pulumi.getter(name="catchallDocument")
    def catchall_document(self) -> Optional[str]:
        """
        The name of the document to use as the fallback for any requests to documents that are not found when serving this static site.
        """
        return pulumi.get(self, "catchall_document")

    @property
    @pulumi.getter(name="dockerfilePath")
    def dockerfile_path(self) -> Optional[str]:
        """
        The path to a Dockerfile relative to the root of the repo. If set, overrides usage of buildpacks.
        """
        return pulumi.get(self, "dockerfile_path")

    @property
    @pulumi.getter(name="environmentSlug")
    def environment_slug(self) -> Optional[str]:
        """
        An environment slug describing the type of this app.
        """
        return pulumi.get(self, "environment_slug")

    @property
    @pulumi.getter
    def envs(self) -> Optional[Sequence['outputs.GetAppSpecStaticSiteEnvResult']]:
        """
        Describes an environment variable made available to an app competent.
        """
        return pulumi.get(self, "envs")

    @property
    @pulumi.getter(name="errorDocument")
    def error_document(self) -> Optional[str]:
        """
        The name of the error document to use when serving this static site.
        """
        return pulumi.get(self, "error_document")

    @property
    @pulumi.getter
    def git(self) -> Optional['outputs.GetAppSpecStaticSiteGitResult']:
        """
        A Git repo to use as the component's source. The repository must be able to be cloned without authentication.  Only one of `git`, `github` or `gitlab`  may be set.
        """
        return pulumi.get(self, "git")

    @property
    @pulumi.getter
    def github(self) -> Optional['outputs.GetAppSpecStaticSiteGithubResult']:
        """
        A GitHub repo to use as the component's source. DigitalOcean App Platform must have [access to the repository](https://cloud.digitalocean.com/apps/github/install). Only one of `git`, `github`, `gitlab`, or `image` may be set.
        """
        return pulumi.get(self, "github")

    @property
    @pulumi.getter
    def gitlab(self) -> Optional['outputs.GetAppSpecStaticSiteGitlabResult']:
        """
        A Gitlab repo to use as the component's source. DigitalOcean App Platform must have [access to the repository](https://cloud.digitalocean.com/apps/gitlab/install). Only one of `git`, `github`, `gitlab`, or `image` may be set.
        """
        return pulumi.get(self, "gitlab")

    @property
    @pulumi.getter(name="indexDocument")
    def index_document(self) -> Optional[str]:
        """
        The name of the index document to use when serving this static site.
        """
        return pulumi.get(self, "index_document")

    @property
    @pulumi.getter(name="outputDir")
    def output_dir(self) -> Optional[str]:
        """
        An optional path to where the built assets will be located, relative to the build context. If not set, App Platform will automatically scan for these directory names: `_static`, `dist`, `public`.
        """
        return pulumi.get(self, "output_dir")

    @property
    @pulumi.getter(name="sourceDir")
    def source_dir(self) -> Optional[str]:
        """
        An optional path to the working directory to use for the build.
        """
        return pulumi.get(self, "source_dir")


@pulumi.output_type
class GetAppSpecStaticSiteEnvResult(dict):
    def __init__(__self__, *,
                 type: str,
                 key: Optional[str] = None,
                 scope: Optional[str] = None,
                 value: Optional[str] = None):
        """
        :param str type: The type of the environment variable, `GENERAL` or `SECRET`.
        :param str key: The name of the environment variable.
        :param str scope: The visibility scope of the environment variable. One of `RUN_TIME`, `BUILD_TIME`, or `RUN_AND_BUILD_TIME` (default).
        :param str value: The value of the environment variable.
        """
        pulumi.set(__self__, "type", type)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the environment variable, `GENERAL` or `SECRET`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def key(self) -> Optional[str]:
        """
        The name of the environment variable.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def scope(self) -> Optional[str]:
        """
        The visibility scope of the environment variable. One of `RUN_TIME`, `BUILD_TIME`, or `RUN_AND_BUILD_TIME` (default).
        """
        return pulumi.get(self, "scope")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        The value of the environment variable.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetAppSpecStaticSiteGitResult(dict):
    def __init__(__self__, *,
                 branch: Optional[str] = None,
                 repo_clone_url: Optional[str] = None):
        """
        :param str branch: The name of the branch to use.
        :param str repo_clone_url: The clone URL of the repo.
        """
        if branch is not None:
            pulumi.set(__self__, "branch", branch)
        if repo_clone_url is not None:
            pulumi.set(__self__, "repo_clone_url", repo_clone_url)

    @property
    @pulumi.getter
    def branch(self) -> Optional[str]:
        """
        The name of the branch to use.
        """
        return pulumi.get(self, "branch")

    @property
    @pulumi.getter(name="repoCloneUrl")
    def repo_clone_url(self) -> Optional[str]:
        """
        The clone URL of the repo.
        """
        return pulumi.get(self, "repo_clone_url")


@pulumi.output_type
class GetAppSpecStaticSiteGithubResult(dict):
    def __init__(__self__, *,
                 branch: Optional[str] = None,
                 deploy_on_push: Optional[bool] = None,
                 repo: Optional[str] = None):
        """
        :param str branch: The name of the branch to use.
        :param bool deploy_on_push: Whether to automatically deploy new commits made to the repo.
        :param str repo: The name of the repo in the format `owner/repo`.
        """
        if branch is not None:
            pulumi.set(__self__, "branch", branch)
        if deploy_on_push is not None:
            pulumi.set(__self__, "deploy_on_push", deploy_on_push)
        if repo is not None:
            pulumi.set(__self__, "repo", repo)

    @property
    @pulumi.getter
    def branch(self) -> Optional[str]:
        """
        The name of the branch to use.
        """
        return pulumi.get(self, "branch")

    @property
    @pulumi.getter(name="deployOnPush")
    def deploy_on_push(self) -> Optional[bool]:
        """
        Whether to automatically deploy new commits made to the repo.
        """
        return pulumi.get(self, "deploy_on_push")

    @property
    @pulumi.getter
    def repo(self) -> Optional[str]:
        """
        The name of the repo in the format `owner/repo`.
        """
        return pulumi.get(self, "repo")


@pulumi.output_type
class GetAppSpecStaticSiteGitlabResult(dict):
    def __init__(__self__, *,
                 branch: Optional[str] = None,
                 deploy_on_push: Optional[bool] = None,
                 repo: Optional[str] = None):
        """
        :param str branch: The name of the branch to use.
        :param bool deploy_on_push: Whether to automatically deploy new commits made to the repo.
        :param str repo: The name of the repo in the format `owner/repo`.
        """
        if branch is not None:
            pulumi.set(__self__, "branch", branch)
        if deploy_on_push is not None:
            pulumi.set(__self__, "deploy_on_push", deploy_on_push)
        if repo is not None:
            pulumi.set(__self__, "repo", repo)

    @property
    @pulumi.getter
    def branch(self) -> Optional[str]:
        """
        The name of the branch to use.
        """
        return pulumi.get(self, "branch")

    @property
    @pulumi.getter(name="deployOnPush")
    def deploy_on_push(self) -> Optional[bool]:
        """
        Whether to automatically deploy new commits made to the repo.
        """
        return pulumi.get(self, "deploy_on_push")

    @property
    @pulumi.getter
    def repo(self) -> Optional[str]:
        """
        The name of the repo in the format `owner/repo`.
        """
        return pulumi.get(self, "repo")


@pulumi.output_type
class GetAppSpecStaticSiteRouteResult(dict):
    def __init__(__self__, *,
                 path: Optional[str] = None):
        """
        :param str path: Paths must start with `/` and must be unique within the app.
        """
        if path is not None:
            pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        Paths must start with `/` and must be unique within the app.
        """
        return pulumi.get(self, "path")


@pulumi.output_type
class GetAppSpecWorkerResult(dict):
    def __init__(__self__, *,
                 name: str,
                 build_command: Optional[str] = None,
                 dockerfile_path: Optional[str] = None,
                 environment_slug: Optional[str] = None,
                 envs: Optional[Sequence['outputs.GetAppSpecWorkerEnvResult']] = None,
                 git: Optional['outputs.GetAppSpecWorkerGitResult'] = None,
                 github: Optional['outputs.GetAppSpecWorkerGithubResult'] = None,
                 gitlab: Optional['outputs.GetAppSpecWorkerGitlabResult'] = None,
                 image: Optional['outputs.GetAppSpecWorkerImageResult'] = None,
                 instance_count: Optional[int] = None,
                 instance_size_slug: Optional[str] = None,
                 run_command: Optional[str] = None,
                 source_dir: Optional[str] = None):
        """
        :param str name: The name of the component.
        :param str build_command: An optional build command to run while building this component from source.
        :param str dockerfile_path: The path to a Dockerfile relative to the root of the repo. If set, overrides usage of buildpacks.
        :param str environment_slug: An environment slug describing the type of this app.
        :param Sequence['GetAppSpecWorkerEnvArgs'] envs: Describes an environment variable made available to an app competent.
        :param 'GetAppSpecWorkerGitArgs' git: A Git repo to use as the component's source. The repository must be able to be cloned without authentication.  Only one of `git`, `github` or `gitlab`  may be set.
        :param 'GetAppSpecWorkerGithubArgs' github: A GitHub repo to use as the component's source. DigitalOcean App Platform must have [access to the repository](https://cloud.digitalocean.com/apps/github/install). Only one of `git`, `github`, `gitlab`, or `image` may be set.
        :param 'GetAppSpecWorkerGitlabArgs' gitlab: A Gitlab repo to use as the component's source. DigitalOcean App Platform must have [access to the repository](https://cloud.digitalocean.com/apps/gitlab/install). Only one of `git`, `github`, `gitlab`, or `image` may be set.
        :param 'GetAppSpecWorkerImageArgs' image: An image to use as the component's source. Only one of `git`, `github`, `gitlab`, or `image` may be set.
        :param int instance_count: The amount of instances that this component should be scaled to.
        :param str instance_size_slug: The instance size to use for this component.
        :param str run_command: An optional run command to override the component's default.
        :param str source_dir: An optional path to the working directory to use for the build.
        """
        pulumi.set(__self__, "name", name)
        if build_command is not None:
            pulumi.set(__self__, "build_command", build_command)
        if dockerfile_path is not None:
            pulumi.set(__self__, "dockerfile_path", dockerfile_path)
        if environment_slug is not None:
            pulumi.set(__self__, "environment_slug", environment_slug)
        if envs is not None:
            pulumi.set(__self__, "envs", envs)
        if git is not None:
            pulumi.set(__self__, "git", git)
        if github is not None:
            pulumi.set(__self__, "github", github)
        if gitlab is not None:
            pulumi.set(__self__, "gitlab", gitlab)
        if image is not None:
            pulumi.set(__self__, "image", image)
        if instance_count is not None:
            pulumi.set(__self__, "instance_count", instance_count)
        if instance_size_slug is not None:
            pulumi.set(__self__, "instance_size_slug", instance_size_slug)
        if run_command is not None:
            pulumi.set(__self__, "run_command", run_command)
        if source_dir is not None:
            pulumi.set(__self__, "source_dir", source_dir)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the component.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="buildCommand")
    def build_command(self) -> Optional[str]:
        """
        An optional build command to run while building this component from source.
        """
        return pulumi.get(self, "build_command")

    @property
    @pulumi.getter(name="dockerfilePath")
    def dockerfile_path(self) -> Optional[str]:
        """
        The path to a Dockerfile relative to the root of the repo. If set, overrides usage of buildpacks.
        """
        return pulumi.get(self, "dockerfile_path")

    @property
    @pulumi.getter(name="environmentSlug")
    def environment_slug(self) -> Optional[str]:
        """
        An environment slug describing the type of this app.
        """
        return pulumi.get(self, "environment_slug")

    @property
    @pulumi.getter
    def envs(self) -> Optional[Sequence['outputs.GetAppSpecWorkerEnvResult']]:
        """
        Describes an environment variable made available to an app competent.
        """
        return pulumi.get(self, "envs")

    @property
    @pulumi.getter
    def git(self) -> Optional['outputs.GetAppSpecWorkerGitResult']:
        """
        A Git repo to use as the component's source. The repository must be able to be cloned without authentication.  Only one of `git`, `github` or `gitlab`  may be set.
        """
        return pulumi.get(self, "git")

    @property
    @pulumi.getter
    def github(self) -> Optional['outputs.GetAppSpecWorkerGithubResult']:
        """
        A GitHub repo to use as the component's source. DigitalOcean App Platform must have [access to the repository](https://cloud.digitalocean.com/apps/github/install). Only one of `git`, `github`, `gitlab`, or `image` may be set.
        """
        return pulumi.get(self, "github")

    @property
    @pulumi.getter
    def gitlab(self) -> Optional['outputs.GetAppSpecWorkerGitlabResult']:
        """
        A Gitlab repo to use as the component's source. DigitalOcean App Platform must have [access to the repository](https://cloud.digitalocean.com/apps/gitlab/install). Only one of `git`, `github`, `gitlab`, or `image` may be set.
        """
        return pulumi.get(self, "gitlab")

    @property
    @pulumi.getter
    def image(self) -> Optional['outputs.GetAppSpecWorkerImageResult']:
        """
        An image to use as the component's source. Only one of `git`, `github`, `gitlab`, or `image` may be set.
        """
        return pulumi.get(self, "image")

    @property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> Optional[int]:
        """
        The amount of instances that this component should be scaled to.
        """
        return pulumi.get(self, "instance_count")

    @property
    @pulumi.getter(name="instanceSizeSlug")
    def instance_size_slug(self) -> Optional[str]:
        """
        The instance size to use for this component.
        """
        return pulumi.get(self, "instance_size_slug")

    @property
    @pulumi.getter(name="runCommand")
    def run_command(self) -> Optional[str]:
        """
        An optional run command to override the component's default.
        """
        return pulumi.get(self, "run_command")

    @property
    @pulumi.getter(name="sourceDir")
    def source_dir(self) -> Optional[str]:
        """
        An optional path to the working directory to use for the build.
        """
        return pulumi.get(self, "source_dir")


@pulumi.output_type
class GetAppSpecWorkerEnvResult(dict):
    def __init__(__self__, *,
                 type: str,
                 key: Optional[str] = None,
                 scope: Optional[str] = None,
                 value: Optional[str] = None):
        """
        :param str type: The type of the environment variable, `GENERAL` or `SECRET`.
        :param str key: The name of the environment variable.
        :param str scope: The visibility scope of the environment variable. One of `RUN_TIME`, `BUILD_TIME`, or `RUN_AND_BUILD_TIME` (default).
        :param str value: The value of the environment variable.
        """
        pulumi.set(__self__, "type", type)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the environment variable, `GENERAL` or `SECRET`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def key(self) -> Optional[str]:
        """
        The name of the environment variable.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def scope(self) -> Optional[str]:
        """
        The visibility scope of the environment variable. One of `RUN_TIME`, `BUILD_TIME`, or `RUN_AND_BUILD_TIME` (default).
        """
        return pulumi.get(self, "scope")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        The value of the environment variable.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetAppSpecWorkerGitResult(dict):
    def __init__(__self__, *,
                 branch: Optional[str] = None,
                 repo_clone_url: Optional[str] = None):
        """
        :param str branch: The name of the branch to use.
        :param str repo_clone_url: The clone URL of the repo.
        """
        if branch is not None:
            pulumi.set(__self__, "branch", branch)
        if repo_clone_url is not None:
            pulumi.set(__self__, "repo_clone_url", repo_clone_url)

    @property
    @pulumi.getter
    def branch(self) -> Optional[str]:
        """
        The name of the branch to use.
        """
        return pulumi.get(self, "branch")

    @property
    @pulumi.getter(name="repoCloneUrl")
    def repo_clone_url(self) -> Optional[str]:
        """
        The clone URL of the repo.
        """
        return pulumi.get(self, "repo_clone_url")


@pulumi.output_type
class GetAppSpecWorkerGithubResult(dict):
    def __init__(__self__, *,
                 branch: Optional[str] = None,
                 deploy_on_push: Optional[bool] = None,
                 repo: Optional[str] = None):
        """
        :param str branch: The name of the branch to use.
        :param bool deploy_on_push: Whether to automatically deploy new commits made to the repo.
        :param str repo: The name of the repo in the format `owner/repo`.
        """
        if branch is not None:
            pulumi.set(__self__, "branch", branch)
        if deploy_on_push is not None:
            pulumi.set(__self__, "deploy_on_push", deploy_on_push)
        if repo is not None:
            pulumi.set(__self__, "repo", repo)

    @property
    @pulumi.getter
    def branch(self) -> Optional[str]:
        """
        The name of the branch to use.
        """
        return pulumi.get(self, "branch")

    @property
    @pulumi.getter(name="deployOnPush")
    def deploy_on_push(self) -> Optional[bool]:
        """
        Whether to automatically deploy new commits made to the repo.
        """
        return pulumi.get(self, "deploy_on_push")

    @property
    @pulumi.getter
    def repo(self) -> Optional[str]:
        """
        The name of the repo in the format `owner/repo`.
        """
        return pulumi.get(self, "repo")


@pulumi.output_type
class GetAppSpecWorkerGitlabResult(dict):
    def __init__(__self__, *,
                 branch: Optional[str] = None,
                 deploy_on_push: Optional[bool] = None,
                 repo: Optional[str] = None):
        """
        :param str branch: The name of the branch to use.
        :param bool deploy_on_push: Whether to automatically deploy new commits made to the repo.
        :param str repo: The name of the repo in the format `owner/repo`.
        """
        if branch is not None:
            pulumi.set(__self__, "branch", branch)
        if deploy_on_push is not None:
            pulumi.set(__self__, "deploy_on_push", deploy_on_push)
        if repo is not None:
            pulumi.set(__self__, "repo", repo)

    @property
    @pulumi.getter
    def branch(self) -> Optional[str]:
        """
        The name of the branch to use.
        """
        return pulumi.get(self, "branch")

    @property
    @pulumi.getter(name="deployOnPush")
    def deploy_on_push(self) -> Optional[bool]:
        """
        Whether to automatically deploy new commits made to the repo.
        """
        return pulumi.get(self, "deploy_on_push")

    @property
    @pulumi.getter
    def repo(self) -> Optional[str]:
        """
        The name of the repo in the format `owner/repo`.
        """
        return pulumi.get(self, "repo")


@pulumi.output_type
class GetAppSpecWorkerImageResult(dict):
    def __init__(__self__, *,
                 registry_type: str,
                 repository: str,
                 registry: Optional[str] = None,
                 tag: Optional[str] = None):
        """
        :param str registry_type: The registry type. One of `DOCR` (DigitalOcean container registry) or `DOCKER_HUB`.
        :param str repository: The repository name.
        :param str registry: The registry name. Must be left empty for the `DOCR` registry type. Required for the `DOCKER_HUB` registry type.
        :param str tag: The repository tag. Defaults to `latest` if not provided.
        """
        pulumi.set(__self__, "registry_type", registry_type)
        pulumi.set(__self__, "repository", repository)
        if registry is not None:
            pulumi.set(__self__, "registry", registry)
        if tag is not None:
            pulumi.set(__self__, "tag", tag)

    @property
    @pulumi.getter(name="registryType")
    def registry_type(self) -> str:
        """
        The registry type. One of `DOCR` (DigitalOcean container registry) or `DOCKER_HUB`.
        """
        return pulumi.get(self, "registry_type")

    @property
    @pulumi.getter
    def repository(self) -> str:
        """
        The repository name.
        """
        return pulumi.get(self, "repository")

    @property
    @pulumi.getter
    def registry(self) -> Optional[str]:
        """
        The registry name. Must be left empty for the `DOCR` registry type. Required for the `DOCKER_HUB` registry type.
        """
        return pulumi.get(self, "registry")

    @property
    @pulumi.getter
    def tag(self) -> Optional[str]:
        """
        The repository tag. Defaults to `latest` if not provided.
        """
        return pulumi.get(self, "tag")


@pulumi.output_type
class GetDatabaseClusterMaintenanceWindowResult(dict):
    def __init__(__self__, *,
                 day: str,
                 hour: str):
        """
        :param str day: The day of the week on which to apply maintenance updates.
        :param str hour: The hour in UTC at which maintenance updates will be applied in 24 hour format.
        """
        pulumi.set(__self__, "day", day)
        pulumi.set(__self__, "hour", hour)

    @property
    @pulumi.getter
    def day(self) -> str:
        """
        The day of the week on which to apply maintenance updates.
        """
        return pulumi.get(self, "day")

    @property
    @pulumi.getter
    def hour(self) -> str:
        """
        The hour in UTC at which maintenance updates will be applied in 24 hour format.
        """
        return pulumi.get(self, "hour")


@pulumi.output_type
class GetDomainsDomainResult(dict):
    def __init__(__self__, *,
                 name: str,
                 ttl: int,
                 urn: str):
        """
        :param str name: (Required) The name of the domain.
               - `ttl`-  The TTL of the domain.
        :param str urn: The uniform resource name of the domain
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "ttl", ttl)
        pulumi.set(__self__, "urn", urn)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        (Required) The name of the domain.
        - `ttl`-  The TTL of the domain.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def ttl(self) -> int:
        return pulumi.get(self, "ttl")

    @property
    @pulumi.getter
    def urn(self) -> str:
        """
        The uniform resource name of the domain
        """
        return pulumi.get(self, "urn")


@pulumi.output_type
class GetDomainsFilterResult(dict):
    def __init__(__self__, *,
                 key: str,
                 values: Sequence[str],
                 all: Optional[bool] = None,
                 match_by: Optional[str] = None):
        """
        :param str key: Filter the domains by this key. This may be one of `name`, `urn`, and `ttl`.
        :param Sequence[str] values: A list of values to match against the `key` field. Only retrieves domains
               where the `key` field takes on one or more of the values provided here.
        :param bool all: Set to `true` to require that a field match all of the `values` instead of just one or more of
               them. This is useful when matching against multi-valued fields such as lists or sets where you want to ensure
               that all of the `values` are present in the list or set.
        :param str match_by: One of `exact` (default), `re`, or `substring`. For string-typed fields, specify `re` to
               match by using the `values` as regular expressions, or specify `substring` to match by treating the `values` as
               substrings to find within the string field.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "values", values)
        if all is not None:
            pulumi.set(__self__, "all", all)
        if match_by is not None:
            pulumi.set(__self__, "match_by", match_by)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        Filter the domains by this key. This may be one of `name`, `urn`, and `ttl`.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        A list of values to match against the `key` field. Only retrieves domains
        where the `key` field takes on one or more of the values provided here.
        """
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def all(self) -> Optional[bool]:
        """
        Set to `true` to require that a field match all of the `values` instead of just one or more of
        them. This is useful when matching against multi-valued fields such as lists or sets where you want to ensure
        that all of the `values` are present in the list or set.
        """
        return pulumi.get(self, "all")

    @property
    @pulumi.getter(name="matchBy")
    def match_by(self) -> Optional[str]:
        """
        One of `exact` (default), `re`, or `substring`. For string-typed fields, specify `re` to
        match by using the `values` as regular expressions, or specify `substring` to match by treating the `values` as
        substrings to find within the string field.
        """
        return pulumi.get(self, "match_by")


@pulumi.output_type
class GetDomainsSortResult(dict):
    def __init__(__self__, *,
                 key: str,
                 direction: Optional[str] = None):
        """
        :param str key: Sort the domains by this key. This may be one of `name`, `urn`, and `ttl`.
        :param str direction: The sort direction. This may be either `asc` or `desc`.
        """
        pulumi.set(__self__, "key", key)
        if direction is not None:
            pulumi.set(__self__, "direction", direction)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        Sort the domains by this key. This may be one of `name`, `urn`, and `ttl`.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def direction(self) -> Optional[str]:
        """
        The sort direction. This may be either `asc` or `desc`.
        """
        return pulumi.get(self, "direction")


@pulumi.output_type
class GetDropletsDropletResult(dict):
    def __init__(__self__, *,
                 backups: bool,
                 created_at: str,
                 disk: int,
                 id: int,
                 image: str,
                 ipv4_address: str,
                 ipv4_address_private: str,
                 ipv6: bool,
                 ipv6_address: str,
                 ipv6_address_private: str,
                 locked: bool,
                 memory: int,
                 monitoring: bool,
                 name: str,
                 price_hourly: float,
                 price_monthly: float,
                 private_networking: bool,
                 region: str,
                 size: str,
                 status: str,
                 tags: Sequence[str],
                 urn: str,
                 vcpus: int,
                 volume_ids: Sequence[str],
                 vpc_uuid: str):
        """
        :param bool backups: Whether backups are enabled.
        :param int disk: The size of the Droplet's disk in GB.
        :param int id: The ID of the Droplet.
        :param str image: The Droplet image ID or slug.
        :param str ipv4_address: The Droplet's public IPv4 address
        :param str ipv4_address_private: The Droplet's private IPv4 address
        :param bool ipv6: Whether IPv6 is enabled.
        :param str ipv6_address: The Droplet's public IPv6 address
        :param str ipv6_address_private: The Droplet's private IPv6 address
        :param bool locked: Whether the Droplet is locked.
        :param int memory: The amount of the Droplet's memory in MB.
        :param bool monitoring: Whether monitoring agent is installed.
        :param float price_hourly: Droplet hourly price.
        :param float price_monthly: Droplet monthly price.
        :param bool private_networking: Whether private networks are enabled.
        :param str region: The region the Droplet is running in.
        :param str size: The unique slug that identifies the type of Droplet.
        :param str status: The status of the Droplet.
        :param Sequence[str] tags: A list of the tags associated to the Droplet.
        :param str urn: The uniform resource name of the Droplet
        :param int vcpus: The number of the Droplet's virtual CPUs.
        :param Sequence[str] volume_ids: List of the IDs of each volumes attached to the Droplet.
        :param str vpc_uuid: The ID of the VPC where the Droplet is located.
        """
        pulumi.set(__self__, "backups", backups)
        pulumi.set(__self__, "created_at", created_at)
        pulumi.set(__self__, "disk", disk)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "image", image)
        pulumi.set(__self__, "ipv4_address", ipv4_address)
        pulumi.set(__self__, "ipv4_address_private", ipv4_address_private)
        pulumi.set(__self__, "ipv6", ipv6)
        pulumi.set(__self__, "ipv6_address", ipv6_address)
        pulumi.set(__self__, "ipv6_address_private", ipv6_address_private)
        pulumi.set(__self__, "locked", locked)
        pulumi.set(__self__, "memory", memory)
        pulumi.set(__self__, "monitoring", monitoring)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "price_hourly", price_hourly)
        pulumi.set(__self__, "price_monthly", price_monthly)
        pulumi.set(__self__, "private_networking", private_networking)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "urn", urn)
        pulumi.set(__self__, "vcpus", vcpus)
        pulumi.set(__self__, "volume_ids", volume_ids)
        pulumi.set(__self__, "vpc_uuid", vpc_uuid)

    @property
    @pulumi.getter
    def backups(self) -> bool:
        """
        Whether backups are enabled.
        """
        return pulumi.get(self, "backups")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> str:
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def disk(self) -> int:
        """
        The size of the Droplet's disk in GB.
        """
        return pulumi.get(self, "disk")

    @property
    @pulumi.getter
    def id(self) -> int:
        """
        The ID of the Droplet.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def image(self) -> str:
        """
        The Droplet image ID or slug.
        """
        return pulumi.get(self, "image")

    @property
    @pulumi.getter(name="ipv4Address")
    def ipv4_address(self) -> str:
        """
        The Droplet's public IPv4 address
        """
        return pulumi.get(self, "ipv4_address")

    @property
    @pulumi.getter(name="ipv4AddressPrivate")
    def ipv4_address_private(self) -> str:
        """
        The Droplet's private IPv4 address
        """
        return pulumi.get(self, "ipv4_address_private")

    @property
    @pulumi.getter
    def ipv6(self) -> bool:
        """
        Whether IPv6 is enabled.
        """
        return pulumi.get(self, "ipv6")

    @property
    @pulumi.getter(name="ipv6Address")
    def ipv6_address(self) -> str:
        """
        The Droplet's public IPv6 address
        """
        return pulumi.get(self, "ipv6_address")

    @property
    @pulumi.getter(name="ipv6AddressPrivate")
    def ipv6_address_private(self) -> str:
        """
        The Droplet's private IPv6 address
        """
        return pulumi.get(self, "ipv6_address_private")

    @property
    @pulumi.getter
    def locked(self) -> bool:
        """
        Whether the Droplet is locked.
        """
        return pulumi.get(self, "locked")

    @property
    @pulumi.getter
    def memory(self) -> int:
        """
        The amount of the Droplet's memory in MB.
        """
        return pulumi.get(self, "memory")

    @property
    @pulumi.getter
    def monitoring(self) -> bool:
        """
        Whether monitoring agent is installed.
        """
        return pulumi.get(self, "monitoring")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="priceHourly")
    def price_hourly(self) -> float:
        """
        Droplet hourly price.
        """
        return pulumi.get(self, "price_hourly")

    @property
    @pulumi.getter(name="priceMonthly")
    def price_monthly(self) -> float:
        """
        Droplet monthly price.
        """
        return pulumi.get(self, "price_monthly")

    @property
    @pulumi.getter(name="privateNetworking")
    def private_networking(self) -> bool:
        """
        Whether private networks are enabled.
        """
        return pulumi.get(self, "private_networking")

    @property
    @pulumi.getter
    def region(self) -> str:
        """
        The region the Droplet is running in.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def size(self) -> str:
        """
        The unique slug that identifies the type of Droplet.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the Droplet.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> Sequence[str]:
        """
        A list of the tags associated to the Droplet.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def urn(self) -> str:
        """
        The uniform resource name of the Droplet
        """
        return pulumi.get(self, "urn")

    @property
    @pulumi.getter
    def vcpus(self) -> int:
        """
        The number of the Droplet's virtual CPUs.
        """
        return pulumi.get(self, "vcpus")

    @property
    @pulumi.getter(name="volumeIds")
    def volume_ids(self) -> Sequence[str]:
        """
        List of the IDs of each volumes attached to the Droplet.
        """
        return pulumi.get(self, "volume_ids")

    @property
    @pulumi.getter(name="vpcUuid")
    def vpc_uuid(self) -> str:
        """
        The ID of the VPC where the Droplet is located.
        """
        return pulumi.get(self, "vpc_uuid")


@pulumi.output_type
class GetDropletsFilterResult(dict):
    def __init__(__self__, *,
                 key: str,
                 values: Sequence[str],
                 all: Optional[bool] = None,
                 match_by: Optional[str] = None):
        """
        :param str key: Filter the Droplets by this key. This may be one of `backups`, `created_at`, `disk`, `id`,
               `image`, `ipv4_address`, `ipv4_address_private`, `ipv6`, `ipv6_address`, `ipv6_address_private`, `locked`,
               `memory`, `monitoring`, `name`, `price_hourly`, `price_monthly`, `private_networking`, `region`, `size`,
               `status`, `tags`, `urn`, `vcpus`, `volume_ids`, or `vpc_uuid`.
        :param Sequence[str] values: A list of values to match against the `key` field. Only retrieves Droplets
               where the `key` field takes on one or more of the values provided here.
        :param bool all: Set to `true` to require that a field match all of the `values` instead of just one or more of
               them. This is useful when matching against multi-valued fields such as lists or sets where you want to ensure
               that all of the `values` are present in the list or set.
        :param str match_by: One of `exact` (default), `re`, or `substring`. For string-typed fields, specify `re` to
               match by using the `values` as regular expressions, or specify `substring` to match by treating the `values` as
               substrings to find within the string field.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "values", values)
        if all is not None:
            pulumi.set(__self__, "all", all)
        if match_by is not None:
            pulumi.set(__self__, "match_by", match_by)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        Filter the Droplets by this key. This may be one of `backups`, `created_at`, `disk`, `id`,
        `image`, `ipv4_address`, `ipv4_address_private`, `ipv6`, `ipv6_address`, `ipv6_address_private`, `locked`,
        `memory`, `monitoring`, `name`, `price_hourly`, `price_monthly`, `private_networking`, `region`, `size`,
        `status`, `tags`, `urn`, `vcpus`, `volume_ids`, or `vpc_uuid`.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        A list of values to match against the `key` field. Only retrieves Droplets
        where the `key` field takes on one or more of the values provided here.
        """
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def all(self) -> Optional[bool]:
        """
        Set to `true` to require that a field match all of the `values` instead of just one or more of
        them. This is useful when matching against multi-valued fields such as lists or sets where you want to ensure
        that all of the `values` are present in the list or set.
        """
        return pulumi.get(self, "all")

    @property
    @pulumi.getter(name="matchBy")
    def match_by(self) -> Optional[str]:
        """
        One of `exact` (default), `re`, or `substring`. For string-typed fields, specify `re` to
        match by using the `values` as regular expressions, or specify `substring` to match by treating the `values` as
        substrings to find within the string field.
        """
        return pulumi.get(self, "match_by")


@pulumi.output_type
class GetDropletsSortResult(dict):
    def __init__(__self__, *,
                 key: str,
                 direction: Optional[str] = None):
        """
        :param str key: Sort the Droplets by this key. This may be one of `backups`, `created_at`, `disk`, `id`,
               `image`, `ipv4_address`, `ipv4_address_private`, `ipv6`, `ipv6_address`, `ipv6_address_private`, `locked`,
               `memory`, `monitoring`, `name`, `price_hourly`, `price_monthly`, `private_networking`, `region`, `size`,
               `status`, `urn`, `vcpus`, or `vpc_uuid`.
        :param str direction: The sort direction. This may be either `asc` or `desc`.
        """
        pulumi.set(__self__, "key", key)
        if direction is not None:
            pulumi.set(__self__, "direction", direction)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        Sort the Droplets by this key. This may be one of `backups`, `created_at`, `disk`, `id`,
        `image`, `ipv4_address`, `ipv4_address_private`, `ipv6`, `ipv6_address`, `ipv6_address_private`, `locked`,
        `memory`, `monitoring`, `name`, `price_hourly`, `price_monthly`, `private_networking`, `region`, `size`,
        `status`, `urn`, `vcpus`, or `vpc_uuid`.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def direction(self) -> Optional[str]:
        """
        The sort direction. This may be either `asc` or `desc`.
        """
        return pulumi.get(self, "direction")


@pulumi.output_type
class GetFirewallInboundRuleResult(dict):
    def __init__(__self__, *,
                 protocol: str,
                 port_range: Optional[str] = None,
                 source_addresses: Optional[Sequence[str]] = None,
                 source_droplet_ids: Optional[Sequence[int]] = None,
                 source_load_balancer_uids: Optional[Sequence[str]] = None,
                 source_tags: Optional[Sequence[str]] = None):
        """
        :param str protocol: The type of traffic to be allowed.
               This may be one of "tcp", "udp", or "icmp".
        :param str port_range: The ports on which traffic will be allowed
               specified as a string containing a single port, a range (e.g. "8000-9000"),
               or "1-65535" to open all ports for a protocol. Required for when protocol is
               `tcp` or `udp`.
        :param Sequence[str] source_addresses: An array of strings containing the IPv4
               addresses, IPv6 addresses, IPv4 CIDRs, and/or IPv6 CIDRs from which the
               inbound traffic will be accepted.
        :param Sequence[int] source_droplet_ids: An array containing the IDs of
               the Droplets from which the inbound traffic will be accepted.
        :param Sequence[str] source_load_balancer_uids: An array containing the IDs
               of the Load Balancers from which the inbound traffic will be accepted.
        :param Sequence[str] source_tags: A set of names of Tags corresponding to group of
               Droplets from which the inbound traffic will be accepted.
        """
        pulumi.set(__self__, "protocol", protocol)
        if port_range is not None:
            pulumi.set(__self__, "port_range", port_range)
        if source_addresses is not None:
            pulumi.set(__self__, "source_addresses", source_addresses)
        if source_droplet_ids is not None:
            pulumi.set(__self__, "source_droplet_ids", source_droplet_ids)
        if source_load_balancer_uids is not None:
            pulumi.set(__self__, "source_load_balancer_uids", source_load_balancer_uids)
        if source_tags is not None:
            pulumi.set(__self__, "source_tags", source_tags)

    @property
    @pulumi.getter
    def protocol(self) -> str:
        """
        The type of traffic to be allowed.
        This may be one of "tcp", "udp", or "icmp".
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="portRange")
    def port_range(self) -> Optional[str]:
        """
        The ports on which traffic will be allowed
        specified as a string containing a single port, a range (e.g. "8000-9000"),
        or "1-65535" to open all ports for a protocol. Required for when protocol is
        `tcp` or `udp`.
        """
        return pulumi.get(self, "port_range")

    @property
    @pulumi.getter(name="sourceAddresses")
    def source_addresses(self) -> Optional[Sequence[str]]:
        """
        An array of strings containing the IPv4
        addresses, IPv6 addresses, IPv4 CIDRs, and/or IPv6 CIDRs from which the
        inbound traffic will be accepted.
        """
        return pulumi.get(self, "source_addresses")

    @property
    @pulumi.getter(name="sourceDropletIds")
    def source_droplet_ids(self) -> Optional[Sequence[int]]:
        """
        An array containing the IDs of
        the Droplets from which the inbound traffic will be accepted.
        """
        return pulumi.get(self, "source_droplet_ids")

    @property
    @pulumi.getter(name="sourceLoadBalancerUids")
    def source_load_balancer_uids(self) -> Optional[Sequence[str]]:
        """
        An array containing the IDs
        of the Load Balancers from which the inbound traffic will be accepted.
        """
        return pulumi.get(self, "source_load_balancer_uids")

    @property
    @pulumi.getter(name="sourceTags")
    def source_tags(self) -> Optional[Sequence[str]]:
        """
        A set of names of Tags corresponding to group of
        Droplets from which the inbound traffic will be accepted.
        """
        return pulumi.get(self, "source_tags")


@pulumi.output_type
class GetFirewallOutboundRuleResult(dict):
    def __init__(__self__, *,
                 protocol: str,
                 destination_addresses: Optional[Sequence[str]] = None,
                 destination_droplet_ids: Optional[Sequence[int]] = None,
                 destination_load_balancer_uids: Optional[Sequence[str]] = None,
                 destination_tags: Optional[Sequence[str]] = None,
                 port_range: Optional[str] = None):
        """
        :param str protocol: The type of traffic to be allowed.
               This may be one of "tcp", "udp", or "icmp".
        :param Sequence[str] destination_addresses: An array of strings containing the IPv4
               addresses, IPv6 addresses, IPv4 CIDRs, and/or IPv6 CIDRs to which the
               outbound traffic will be allowed.
        :param Sequence[int] destination_droplet_ids: An array containing the IDs of
               the Droplets to which the outbound traffic will be allowed.
        :param Sequence[str] destination_load_balancer_uids: An array containing the IDs
               of the Load Balancers to which the outbound traffic will be allowed.
        :param Sequence[str] destination_tags: An array containing the names of Tags
               corresponding to groups of Droplets to which the outbound traffic will
               be allowed.
               traffic.
        :param str port_range: The ports on which traffic will be allowed
               specified as a string containing a single port, a range (e.g. "8000-9000"),
               or "1-65535" to open all ports for a protocol. Required for when protocol is
               `tcp` or `udp`.
        """
        pulumi.set(__self__, "protocol", protocol)
        if destination_addresses is not None:
            pulumi.set(__self__, "destination_addresses", destination_addresses)
        if destination_droplet_ids is not None:
            pulumi.set(__self__, "destination_droplet_ids", destination_droplet_ids)
        if destination_load_balancer_uids is not None:
            pulumi.set(__self__, "destination_load_balancer_uids", destination_load_balancer_uids)
        if destination_tags is not None:
            pulumi.set(__self__, "destination_tags", destination_tags)
        if port_range is not None:
            pulumi.set(__self__, "port_range", port_range)

    @property
    @pulumi.getter
    def protocol(self) -> str:
        """
        The type of traffic to be allowed.
        This may be one of "tcp", "udp", or "icmp".
        """
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="destinationAddresses")
    def destination_addresses(self) -> Optional[Sequence[str]]:
        """
        An array of strings containing the IPv4
        addresses, IPv6 addresses, IPv4 CIDRs, and/or IPv6 CIDRs to which the
        outbound traffic will be allowed.
        """
        return pulumi.get(self, "destination_addresses")

    @property
    @pulumi.getter(name="destinationDropletIds")
    def destination_droplet_ids(self) -> Optional[Sequence[int]]:
        """
        An array containing the IDs of
        the Droplets to which the outbound traffic will be allowed.
        """
        return pulumi.get(self, "destination_droplet_ids")

    @property
    @pulumi.getter(name="destinationLoadBalancerUids")
    def destination_load_balancer_uids(self) -> Optional[Sequence[str]]:
        """
        An array containing the IDs
        of the Load Balancers to which the outbound traffic will be allowed.
        """
        return pulumi.get(self, "destination_load_balancer_uids")

    @property
    @pulumi.getter(name="destinationTags")
    def destination_tags(self) -> Optional[Sequence[str]]:
        """
        An array containing the names of Tags
        corresponding to groups of Droplets to which the outbound traffic will
        be allowed.
        traffic.
        """
        return pulumi.get(self, "destination_tags")

    @property
    @pulumi.getter(name="portRange")
    def port_range(self) -> Optional[str]:
        """
        The ports on which traffic will be allowed
        specified as a string containing a single port, a range (e.g. "8000-9000"),
        or "1-65535" to open all ports for a protocol. Required for when protocol is
        `tcp` or `udp`.
        """
        return pulumi.get(self, "port_range")


@pulumi.output_type
class GetFirewallPendingChangeResult(dict):
    def __init__(__self__, *,
                 droplet_id: Optional[int] = None,
                 removing: Optional[bool] = None,
                 status: Optional[str] = None):
        """
        :param str status: A status string indicating the current state of the Firewall.
               This can be "waiting", "succeeded", or "failed".
        """
        if droplet_id is not None:
            pulumi.set(__self__, "droplet_id", droplet_id)
        if removing is not None:
            pulumi.set(__self__, "removing", removing)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="dropletId")
    def droplet_id(self) -> Optional[int]:
        return pulumi.get(self, "droplet_id")

    @property
    @pulumi.getter
    def removing(self) -> Optional[bool]:
        return pulumi.get(self, "removing")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        A status string indicating the current state of the Firewall.
        This can be "waiting", "succeeded", or "failed".
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetImagesFilterResult(dict):
    def __init__(__self__, *,
                 key: str,
                 values: Sequence[str],
                 all: Optional[bool] = None,
                 match_by: Optional[str] = None):
        """
        :param str key: Filter the images by this key. This may be one of `distribution`, `error_message`,
               `id`, `image`, `min_disk_size`, `name`, `private`, `regions`, `size_gigabytes`, `slug`, `status`,
               `tags`, or `type`.
        :param Sequence[str] values: A list of values to match against the `key` field. Only retrieves images
               where the `key` field takes on one or more of the values provided here.
        :param bool all: Set to `true` to require that a field match all of the `values` instead of just one or more of
               them. This is useful when matching against multi-valued fields such as lists or sets where you want to ensure
               that all of the `values` are present in the list or set.
        :param str match_by: One of `exact` (default), `re`, or `substring`. For string-typed fields, specify `re` to
               match by using the `values` as regular expressions, or specify `substring` to match by treating the `values` as
               substrings to find within the string field.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "values", values)
        if all is not None:
            pulumi.set(__self__, "all", all)
        if match_by is not None:
            pulumi.set(__self__, "match_by", match_by)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        Filter the images by this key. This may be one of `distribution`, `error_message`,
        `id`, `image`, `min_disk_size`, `name`, `private`, `regions`, `size_gigabytes`, `slug`, `status`,
        `tags`, or `type`.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        A list of values to match against the `key` field. Only retrieves images
        where the `key` field takes on one or more of the values provided here.
        """
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def all(self) -> Optional[bool]:
        """
        Set to `true` to require that a field match all of the `values` instead of just one or more of
        them. This is useful when matching against multi-valued fields such as lists or sets where you want to ensure
        that all of the `values` are present in the list or set.
        """
        return pulumi.get(self, "all")

    @property
    @pulumi.getter(name="matchBy")
    def match_by(self) -> Optional[str]:
        """
        One of `exact` (default), `re`, or `substring`. For string-typed fields, specify `re` to
        match by using the `values` as regular expressions, or specify `substring` to match by treating the `values` as
        substrings to find within the string field.
        """
        return pulumi.get(self, "match_by")


@pulumi.output_type
class GetImagesImageResult(dict):
    def __init__(__self__, *,
                 created: str,
                 description: str,
                 distribution: str,
                 error_message: str,
                 id: int,
                 image: str,
                 min_disk_size: int,
                 name: str,
                 private: bool,
                 regions: Sequence[str],
                 size_gigabytes: float,
                 slug: str,
                 status: str,
                 tags: Sequence[str],
                 type: str):
        """
        :param str distribution: The name of the distribution of the OS of the image.
               - `min_disk_size`: The minimum 'disk' required for the image.
               - `size_gigabytes`: The size of the image in GB.
        :param str image: The id of the image (legacy parameter).
        :param bool private: Is image a public image or not. Public images represent
               Linux distributions or One-Click Applications, while non-public images represent
               snapshots and backups and are only available within your account.
               - `regions`: A set of the regions that the image is available in.
               - `tags`: A set of tags applied to the image
               - `created`: When the image was created
               - `status`: Current status of the image
               - `error_message`: Any applicable error message pertaining to the image
        """
        pulumi.set(__self__, "created", created)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "distribution", distribution)
        pulumi.set(__self__, "error_message", error_message)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "image", image)
        pulumi.set(__self__, "min_disk_size", min_disk_size)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "private", private)
        pulumi.set(__self__, "regions", regions)
        pulumi.set(__self__, "size_gigabytes", size_gigabytes)
        pulumi.set(__self__, "slug", slug)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def created(self) -> str:
        return pulumi.get(self, "created")

    @property
    @pulumi.getter
    def description(self) -> str:
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def distribution(self) -> str:
        """
        The name of the distribution of the OS of the image.
        - `min_disk_size`: The minimum 'disk' required for the image.
        - `size_gigabytes`: The size of the image in GB.
        """
        return pulumi.get(self, "distribution")

    @property
    @pulumi.getter(name="errorMessage")
    def error_message(self) -> str:
        return pulumi.get(self, "error_message")

    @property
    @pulumi.getter
    def id(self) -> int:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def image(self) -> str:
        """
        The id of the image (legacy parameter).
        """
        return pulumi.get(self, "image")

    @property
    @pulumi.getter(name="minDiskSize")
    def min_disk_size(self) -> int:
        return pulumi.get(self, "min_disk_size")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def private(self) -> bool:
        """
        Is image a public image or not. Public images represent
        Linux distributions or One-Click Applications, while non-public images represent
        snapshots and backups and are only available within your account.
        - `regions`: A set of the regions that the image is available in.
        - `tags`: A set of tags applied to the image
        - `created`: When the image was created
        - `status`: Current status of the image
        - `error_message`: Any applicable error message pertaining to the image
        """
        return pulumi.get(self, "private")

    @property
    @pulumi.getter
    def regions(self) -> Sequence[str]:
        return pulumi.get(self, "regions")

    @property
    @pulumi.getter(name="sizeGigabytes")
    def size_gigabytes(self) -> float:
        return pulumi.get(self, "size_gigabytes")

    @property
    @pulumi.getter
    def slug(self) -> str:
        return pulumi.get(self, "slug")

    @property
    @pulumi.getter
    def status(self) -> str:
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> Sequence[str]:
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def type(self) -> str:
        return pulumi.get(self, "type")


@pulumi.output_type
class GetImagesSortResult(dict):
    def __init__(__self__, *,
                 key: str,
                 direction: Optional[str] = None):
        """
        :param str key: Sort the images by this key. This may be one of `distribution`, `error_message`, `id`,
               `image`, `min_disk_size`, `name`, `private`, `size_gigabytes`, `slug`, `status`, or `type`.
        :param str direction: The sort direction. This may be either `asc` or `desc`.
        """
        pulumi.set(__self__, "key", key)
        if direction is not None:
            pulumi.set(__self__, "direction", direction)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        Sort the images by this key. This may be one of `distribution`, `error_message`, `id`,
        `image`, `min_disk_size`, `name`, `private`, `size_gigabytes`, `slug`, `status`, or `type`.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def direction(self) -> Optional[str]:
        """
        The sort direction. This may be either `asc` or `desc`.
        """
        return pulumi.get(self, "direction")


@pulumi.output_type
class GetKubernetesClusterKubeConfigResult(dict):
    def __init__(__self__, *,
                 client_certificate: str,
                 client_key: str,
                 cluster_ca_certificate: str,
                 expires_at: str,
                 host: str,
                 raw_config: str,
                 token: str):
        """
        :param str client_certificate: The base64 encoded public certificate used by clients to access the cluster. Only available if token authentication is not supported on your cluster.
        :param str client_key: The base64 encoded private key used by clients to access the cluster. Only available if token authentication is not supported on your cluster.
        :param str cluster_ca_certificate: The base64 encoded public certificate for the cluster's certificate authority.
        :param str expires_at: The date and time when the credentials will expire and need to be regenerated.
        :param str host: The URL of the API server on the Kubernetes master node.
        :param str raw_config: The full contents of the Kubernetes cluster's kubeconfig file.
        :param str token: The DigitalOcean API access token used by clients to access the cluster.
        """
        pulumi.set(__self__, "client_certificate", client_certificate)
        pulumi.set(__self__, "client_key", client_key)
        pulumi.set(__self__, "cluster_ca_certificate", cluster_ca_certificate)
        pulumi.set(__self__, "expires_at", expires_at)
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "raw_config", raw_config)
        pulumi.set(__self__, "token", token)

    @property
    @pulumi.getter(name="clientCertificate")
    def client_certificate(self) -> str:
        """
        The base64 encoded public certificate used by clients to access the cluster. Only available if token authentication is not supported on your cluster.
        """
        return pulumi.get(self, "client_certificate")

    @property
    @pulumi.getter(name="clientKey")
    def client_key(self) -> str:
        """
        The base64 encoded private key used by clients to access the cluster. Only available if token authentication is not supported on your cluster.
        """
        return pulumi.get(self, "client_key")

    @property
    @pulumi.getter(name="clusterCaCertificate")
    def cluster_ca_certificate(self) -> str:
        """
        The base64 encoded public certificate for the cluster's certificate authority.
        """
        return pulumi.get(self, "cluster_ca_certificate")

    @property
    @pulumi.getter(name="expiresAt")
    def expires_at(self) -> str:
        """
        The date and time when the credentials will expire and need to be regenerated.
        """
        return pulumi.get(self, "expires_at")

    @property
    @pulumi.getter
    def host(self) -> str:
        """
        The URL of the API server on the Kubernetes master node.
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter(name="rawConfig")
    def raw_config(self) -> str:
        """
        The full contents of the Kubernetes cluster's kubeconfig file.
        """
        return pulumi.get(self, "raw_config")

    @property
    @pulumi.getter
    def token(self) -> str:
        """
        The DigitalOcean API access token used by clients to access the cluster.
        """
        return pulumi.get(self, "token")


@pulumi.output_type
class GetKubernetesClusterNodePoolResult(dict):
    def __init__(__self__, *,
                 actual_node_count: int,
                 auto_scale: bool,
                 id: str,
                 labels: Mapping[str, str],
                 max_nodes: int,
                 min_nodes: int,
                 name: str,
                 node_count: int,
                 nodes: Sequence['outputs.GetKubernetesClusterNodePoolNodeResult'],
                 size: str,
                 tags: Sequence[str],
                 taints: Sequence['outputs.GetKubernetesClusterNodePoolTaintResult']):
        """
        :param int actual_node_count: The actual number of nodes in the node pool, which is especially useful when auto-scaling is enabled.
        :param bool auto_scale: A boolean indicating whether auto-scaling is enabled on the node pool.
        :param str id: A unique ID that can be used to identify and reference the node.
        :param Mapping[str, str] labels: A map of key/value pairs applied to nodes in the pool. The labels are exposed in the Kubernetes API as labels in the metadata of the corresponding [Node resources](https://kubernetes.io/docs/concepts/architecture/nodes/).
        :param int max_nodes: If auto-scaling is enabled, this represents the maximum number of nodes that the node pool can be scaled up to.
        :param int min_nodes: If auto-scaling is enabled, this represents the minimum number of nodes that the node pool can be scaled down to.
        :param str name: The name of Kubernetes cluster.
        :param int node_count: The number of Droplet instances in the node pool.
        :param Sequence['GetKubernetesClusterNodePoolNodeArgs'] nodes: A list of nodes in the pool. Each node exports the following attributes:
        :param str size: The slug identifier for the type of Droplet used as workers in the node pool.
        :param Sequence[str] tags: A list of tag names applied to the node pool.
        :param Sequence['GetKubernetesClusterNodePoolTaintArgs'] taints: A list of taints applied to all nodes in the pool. Each taint exports the following attributes:
        """
        pulumi.set(__self__, "actual_node_count", actual_node_count)
        pulumi.set(__self__, "auto_scale", auto_scale)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "labels", labels)
        pulumi.set(__self__, "max_nodes", max_nodes)
        pulumi.set(__self__, "min_nodes", min_nodes)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "node_count", node_count)
        pulumi.set(__self__, "nodes", nodes)
        pulumi.set(__self__, "size", size)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "taints", taints)

    @property
    @pulumi.getter(name="actualNodeCount")
    def actual_node_count(self) -> int:
        """
        The actual number of nodes in the node pool, which is especially useful when auto-scaling is enabled.
        """
        return pulumi.get(self, "actual_node_count")

    @property
    @pulumi.getter(name="autoScale")
    def auto_scale(self) -> bool:
        """
        A boolean indicating whether auto-scaling is enabled on the node pool.
        """
        return pulumi.get(self, "auto_scale")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        A unique ID that can be used to identify and reference the node.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        """
        A map of key/value pairs applied to nodes in the pool. The labels are exposed in the Kubernetes API as labels in the metadata of the corresponding [Node resources](https://kubernetes.io/docs/concepts/architecture/nodes/).
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="maxNodes")
    def max_nodes(self) -> int:
        """
        If auto-scaling is enabled, this represents the maximum number of nodes that the node pool can be scaled up to.
        """
        return pulumi.get(self, "max_nodes")

    @property
    @pulumi.getter(name="minNodes")
    def min_nodes(self) -> int:
        """
        If auto-scaling is enabled, this represents the minimum number of nodes that the node pool can be scaled down to.
        """
        return pulumi.get(self, "min_nodes")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of Kubernetes cluster.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> int:
        """
        The number of Droplet instances in the node pool.
        """
        return pulumi.get(self, "node_count")

    @property
    @pulumi.getter
    def nodes(self) -> Sequence['outputs.GetKubernetesClusterNodePoolNodeResult']:
        """
        A list of nodes in the pool. Each node exports the following attributes:
        """
        return pulumi.get(self, "nodes")

    @property
    @pulumi.getter
    def size(self) -> str:
        """
        The slug identifier for the type of Droplet used as workers in the node pool.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter
    def tags(self) -> Sequence[str]:
        """
        A list of tag names applied to the node pool.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def taints(self) -> Sequence['outputs.GetKubernetesClusterNodePoolTaintResult']:
        """
        A list of taints applied to all nodes in the pool. Each taint exports the following attributes:
        """
        return pulumi.get(self, "taints")


@pulumi.output_type
class GetKubernetesClusterNodePoolNodeResult(dict):
    def __init__(__self__, *,
                 created_at: str,
                 droplet_id: str,
                 id: str,
                 name: str,
                 status: str,
                 updated_at: str):
        """
        :param str created_at: The date and time when the node was created.
        :param str id: A unique ID that can be used to identify and reference the node.
        :param str name: The name of Kubernetes cluster.
        :param str status: A string indicating the current status of the individual node.
        :param str updated_at: The date and time when the node was last updated.
        """
        pulumi.set(__self__, "created_at", created_at)
        pulumi.set(__self__, "droplet_id", droplet_id)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "updated_at", updated_at)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> str:
        """
        The date and time when the node was created.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="dropletId")
    def droplet_id(self) -> str:
        return pulumi.get(self, "droplet_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        A unique ID that can be used to identify and reference the node.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of Kubernetes cluster.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        A string indicating the current status of the individual node.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> str:
        """
        The date and time when the node was last updated.
        """
        return pulumi.get(self, "updated_at")


@pulumi.output_type
class GetKubernetesClusterNodePoolTaintResult(dict):
    def __init__(__self__, *,
                 effect: str,
                 key: str,
                 value: str):
        """
        :param str effect: How the node reacts to pods that it won't tolerate. Available effect values are: "NoSchedule", "PreferNoSchedule", "NoExecute".
        :param str key: An arbitrary string. The "key" and "value" fields of the "taint" object form a key-value pair.
        :param str value: An arbitrary string. The "key" and "value" fields of the "taint" object form a key-value pair.
        """
        pulumi.set(__self__, "effect", effect)
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def effect(self) -> str:
        """
        How the node reacts to pods that it won't tolerate. Available effect values are: "NoSchedule", "PreferNoSchedule", "NoExecute".
        """
        return pulumi.get(self, "effect")

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        An arbitrary string. The "key" and "value" fields of the "taint" object form a key-value pair.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        An arbitrary string. The "key" and "value" fields of the "taint" object form a key-value pair.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetLoadBalancerForwardingRuleResult(dict):
    def __init__(__self__, *,
                 certificate_id: str,
                 certificate_name: str,
                 entry_port: int,
                 entry_protocol: str,
                 target_port: int,
                 target_protocol: str,
                 tls_passthrough: bool):
        pulumi.set(__self__, "certificate_id", certificate_id)
        pulumi.set(__self__, "certificate_name", certificate_name)
        pulumi.set(__self__, "entry_port", entry_port)
        pulumi.set(__self__, "entry_protocol", entry_protocol)
        pulumi.set(__self__, "target_port", target_port)
        pulumi.set(__self__, "target_protocol", target_protocol)
        pulumi.set(__self__, "tls_passthrough", tls_passthrough)

    @property
    @pulumi.getter(name="certificateId")
    def certificate_id(self) -> str:
        return pulumi.get(self, "certificate_id")

    @property
    @pulumi.getter(name="certificateName")
    def certificate_name(self) -> str:
        return pulumi.get(self, "certificate_name")

    @property
    @pulumi.getter(name="entryPort")
    def entry_port(self) -> int:
        return pulumi.get(self, "entry_port")

    @property
    @pulumi.getter(name="entryProtocol")
    def entry_protocol(self) -> str:
        return pulumi.get(self, "entry_protocol")

    @property
    @pulumi.getter(name="targetPort")
    def target_port(self) -> int:
        return pulumi.get(self, "target_port")

    @property
    @pulumi.getter(name="targetProtocol")
    def target_protocol(self) -> str:
        return pulumi.get(self, "target_protocol")

    @property
    @pulumi.getter(name="tlsPassthrough")
    def tls_passthrough(self) -> bool:
        return pulumi.get(self, "tls_passthrough")


@pulumi.output_type
class GetLoadBalancerHealthcheckResult(dict):
    def __init__(__self__, *,
                 check_interval_seconds: int,
                 healthy_threshold: int,
                 path: str,
                 port: int,
                 protocol: str,
                 response_timeout_seconds: int,
                 unhealthy_threshold: int):
        pulumi.set(__self__, "check_interval_seconds", check_interval_seconds)
        pulumi.set(__self__, "healthy_threshold", healthy_threshold)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "protocol", protocol)
        pulumi.set(__self__, "response_timeout_seconds", response_timeout_seconds)
        pulumi.set(__self__, "unhealthy_threshold", unhealthy_threshold)

    @property
    @pulumi.getter(name="checkIntervalSeconds")
    def check_interval_seconds(self) -> int:
        return pulumi.get(self, "check_interval_seconds")

    @property
    @pulumi.getter(name="healthyThreshold")
    def healthy_threshold(self) -> int:
        return pulumi.get(self, "healthy_threshold")

    @property
    @pulumi.getter
    def path(self) -> str:
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def port(self) -> int:
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def protocol(self) -> str:
        return pulumi.get(self, "protocol")

    @property
    @pulumi.getter(name="responseTimeoutSeconds")
    def response_timeout_seconds(self) -> int:
        return pulumi.get(self, "response_timeout_seconds")

    @property
    @pulumi.getter(name="unhealthyThreshold")
    def unhealthy_threshold(self) -> int:
        return pulumi.get(self, "unhealthy_threshold")


@pulumi.output_type
class GetLoadBalancerStickySessionResult(dict):
    def __init__(__self__, *,
                 cookie_name: str,
                 cookie_ttl_seconds: int,
                 type: str):
        pulumi.set(__self__, "cookie_name", cookie_name)
        pulumi.set(__self__, "cookie_ttl_seconds", cookie_ttl_seconds)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="cookieName")
    def cookie_name(self) -> str:
        return pulumi.get(self, "cookie_name")

    @property
    @pulumi.getter(name="cookieTtlSeconds")
    def cookie_ttl_seconds(self) -> int:
        return pulumi.get(self, "cookie_ttl_seconds")

    @property
    @pulumi.getter
    def type(self) -> str:
        return pulumi.get(self, "type")


@pulumi.output_type
class GetProjectsFilterResult(dict):
    def __init__(__self__, *,
                 key: str,
                 values: Sequence[str],
                 all: Optional[bool] = None,
                 match_by: Optional[str] = None):
        """
        :param str key: Filter the projects by this key. This may be one of `name`,
               `purpose`, `description`, `environment`, or `is_default`.
        :param Sequence[str] values: A list of values to match against the `key` field. Only retrieves projects
               where the `key` field takes on one or more of the values provided here.
        :param bool all: Set to `true` to require that a field match all of the `values` instead of just one or more of
               them. This is useful when matching against multi-valued fields such as lists or sets where you want to ensure
               that all of the `values` are present in the list or set.
        :param str match_by: One of `exact` (default), `re`, or `substring`. For string-typed fields, specify `re` to
               match by using the `values` as regular expressions, or specify `substring` to match by treating the `values` as
               substrings to find within the string field.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "values", values)
        if all is not None:
            pulumi.set(__self__, "all", all)
        if match_by is not None:
            pulumi.set(__self__, "match_by", match_by)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        Filter the projects by this key. This may be one of `name`,
        `purpose`, `description`, `environment`, or `is_default`.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        A list of values to match against the `key` field. Only retrieves projects
        where the `key` field takes on one or more of the values provided here.
        """
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def all(self) -> Optional[bool]:
        """
        Set to `true` to require that a field match all of the `values` instead of just one or more of
        them. This is useful when matching against multi-valued fields such as lists or sets where you want to ensure
        that all of the `values` are present in the list or set.
        """
        return pulumi.get(self, "all")

    @property
    @pulumi.getter(name="matchBy")
    def match_by(self) -> Optional[str]:
        """
        One of `exact` (default), `re`, or `substring`. For string-typed fields, specify `re` to
        match by using the `values` as regular expressions, or specify `substring` to match by treating the `values` as
        substrings to find within the string field.
        """
        return pulumi.get(self, "match_by")


@pulumi.output_type
class GetProjectsProjectResult(dict):
    def __init__(__self__, *,
                 created_at: str,
                 description: str,
                 environment: str,
                 id: str,
                 is_default: bool,
                 name: str,
                 owner_id: int,
                 owner_uuid: str,
                 purpose: str,
                 resources: Sequence[str],
                 updated_at: str):
        """
        :param str created_at: The date and time when the project was created, (ISO8601)
        :param str description: The description of the project
        :param str environment: The environment of the project's resources. The possible values are: `Development`, `Staging`, `Production`.
        :param str id: The ID of the project
        :param str name: The name of the project
        :param int owner_id: The ID of the project owner
        :param str owner_uuid: The unique universal identifier of the project owner
        :param str purpose: The purpose of the project (Default: "Web Application")
        :param Sequence[str] resources: A set of uniform resource names (URNs) for the resources associated with the project
        :param str updated_at: The date and time when the project was last updated, (ISO8601)
        """
        pulumi.set(__self__, "created_at", created_at)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "environment", environment)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_default", is_default)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "owner_id", owner_id)
        pulumi.set(__self__, "owner_uuid", owner_uuid)
        pulumi.set(__self__, "purpose", purpose)
        pulumi.set(__self__, "resources", resources)
        pulumi.set(__self__, "updated_at", updated_at)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> str:
        """
        The date and time when the project was created, (ISO8601)
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the project
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def environment(self) -> str:
        """
        The environment of the project's resources. The possible values are: `Development`, `Staging`, `Production`.
        """
        return pulumi.get(self, "environment")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the project
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> bool:
        return pulumi.get(self, "is_default")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the project
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="ownerId")
    def owner_id(self) -> int:
        """
        The ID of the project owner
        """
        return pulumi.get(self, "owner_id")

    @property
    @pulumi.getter(name="ownerUuid")
    def owner_uuid(self) -> str:
        """
        The unique universal identifier of the project owner
        """
        return pulumi.get(self, "owner_uuid")

    @property
    @pulumi.getter
    def purpose(self) -> str:
        """
        The purpose of the project (Default: "Web Application")
        """
        return pulumi.get(self, "purpose")

    @property
    @pulumi.getter
    def resources(self) -> Sequence[str]:
        """
        A set of uniform resource names (URNs) for the resources associated with the project
        """
        return pulumi.get(self, "resources")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> str:
        """
        The date and time when the project was last updated, (ISO8601)
        """
        return pulumi.get(self, "updated_at")


@pulumi.output_type
class GetProjectsSortResult(dict):
    def __init__(__self__, *,
                 key: str,
                 direction: Optional[str] = None):
        """
        :param str key: Sort the projects by this key. This may be one of `name`,
               `purpose`, `description`, or `environment`.
        :param str direction: The sort direction. This may be either `asc` or `desc`.
        """
        pulumi.set(__self__, "key", key)
        if direction is not None:
            pulumi.set(__self__, "direction", direction)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        Sort the projects by this key. This may be one of `name`,
        `purpose`, `description`, or `environment`.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def direction(self) -> Optional[str]:
        """
        The sort direction. This may be either `asc` or `desc`.
        """
        return pulumi.get(self, "direction")


@pulumi.output_type
class GetRecordsFilterResult(dict):
    def __init__(__self__, *,
                 key: str,
                 values: Sequence[str],
                 all: Optional[bool] = None,
                 match_by: Optional[str] = None):
        """
        :param str key: Filter the DNS records by this key. This may be one of `domain`, `flags`, `name`, `port`,
               `priority`, `tag`, `ttl`, `type`, `value`, or `weight`.
        :param Sequence[str] values: A list of values to match against the `key` field. Only retrieves DNS records
               where the `key` field takes on one or more of the values provided here.
        :param bool all: Set to `true` to require that a field match all of the `values` instead of just one or more of
               them. This is useful when matching against multi-valued fields such as lists or sets where you want to ensure
               that all of the `values` are present in the list or set.
        :param str match_by: One of `exact` (default), `re`, or `substring`. For string-typed fields, specify `re` to
               match by using the `values` as regular expressions, or specify `substring` to match by treating the `values` as
               substrings to find within the string field.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "values", values)
        if all is not None:
            pulumi.set(__self__, "all", all)
        if match_by is not None:
            pulumi.set(__self__, "match_by", match_by)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        Filter the DNS records by this key. This may be one of `domain`, `flags`, `name`, `port`,
        `priority`, `tag`, `ttl`, `type`, `value`, or `weight`.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        A list of values to match against the `key` field. Only retrieves DNS records
        where the `key` field takes on one or more of the values provided here.
        """
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def all(self) -> Optional[bool]:
        """
        Set to `true` to require that a field match all of the `values` instead of just one or more of
        them. This is useful when matching against multi-valued fields such as lists or sets where you want to ensure
        that all of the `values` are present in the list or set.
        """
        return pulumi.get(self, "all")

    @property
    @pulumi.getter(name="matchBy")
    def match_by(self) -> Optional[str]:
        """
        One of `exact` (default), `re`, or `substring`. For string-typed fields, specify `re` to
        match by using the `values` as regular expressions, or specify `substring` to match by treating the `values` as
        substrings to find within the string field.
        """
        return pulumi.get(self, "match_by")


@pulumi.output_type
class GetRecordsRecordResult(dict):
    def __init__(__self__, *,
                 domain: str,
                 flags: int,
                 id: int,
                 name: str,
                 port: int,
                 priority: int,
                 tag: str,
                 ttl: int,
                 type: str,
                 value: str,
                 weight: int):
        """
        :param str domain: The domain name to search for DNS records
        """
        pulumi.set(__self__, "domain", domain)
        pulumi.set(__self__, "flags", flags)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "priority", priority)
        pulumi.set(__self__, "tag", tag)
        pulumi.set(__self__, "ttl", ttl)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)
        pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter
    def domain(self) -> str:
        """
        The domain name to search for DNS records
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter
    def flags(self) -> int:
        return pulumi.get(self, "flags")

    @property
    @pulumi.getter
    def id(self) -> int:
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def port(self) -> int:
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def priority(self) -> int:
        return pulumi.get(self, "priority")

    @property
    @pulumi.getter
    def tag(self) -> str:
        return pulumi.get(self, "tag")

    @property
    @pulumi.getter
    def ttl(self) -> int:
        return pulumi.get(self, "ttl")

    @property
    @pulumi.getter
    def type(self) -> str:
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> str:
        return pulumi.get(self, "value")

    @property
    @pulumi.getter
    def weight(self) -> int:
        return pulumi.get(self, "weight")


@pulumi.output_type
class GetRecordsSortResult(dict):
    def __init__(__self__, *,
                 key: str,
                 direction: Optional[str] = None):
        """
        :param str key: Sort the DNS records by this key. This may be one of `domain`, `flags`, `name`, `port`,
               `priority`, `tag`, `ttl`, `type`, `value`, or `weight`.
        :param str direction: The sort direction. This may be either `asc` or `desc`.
        """
        pulumi.set(__self__, "key", key)
        if direction is not None:
            pulumi.set(__self__, "direction", direction)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        Sort the DNS records by this key. This may be one of `domain`, `flags`, `name`, `port`,
        `priority`, `tag`, `ttl`, `type`, `value`, or `weight`.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def direction(self) -> Optional[str]:
        """
        The sort direction. This may be either `asc` or `desc`.
        """
        return pulumi.get(self, "direction")


@pulumi.output_type
class GetRegionsFilterResult(dict):
    def __init__(__self__, *,
                 key: str,
                 values: Sequence[str],
                 all: Optional[bool] = None,
                 match_by: Optional[str] = None):
        """
        :param str key: Filter the regions by this key. This may be one of `slug`,
               `name`, `available`, `features`, or `sizes`.
        :param Sequence[str] values: A list of values to match against the `key` field. Only retrieves regions
               where the `key` field takes on one or more of the values provided here.
        :param bool all: Set to `true` to require that a field match all of the `values` instead of just one or more of
               them. This is useful when matching against multi-valued fields such as lists or sets where you want to ensure
               that all of the `values` are present in the list or set.
        :param str match_by: One of `exact` (default), `re`, or `substring`. For string-typed fields, specify `re` to
               match by using the `values` as regular expressions, or specify `substring` to match by treating the `values` as
               substrings to find within the string field.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "values", values)
        if all is not None:
            pulumi.set(__self__, "all", all)
        if match_by is not None:
            pulumi.set(__self__, "match_by", match_by)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        Filter the regions by this key. This may be one of `slug`,
        `name`, `available`, `features`, or `sizes`.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        A list of values to match against the `key` field. Only retrieves regions
        where the `key` field takes on one or more of the values provided here.
        """
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def all(self) -> Optional[bool]:
        """
        Set to `true` to require that a field match all of the `values` instead of just one or more of
        them. This is useful when matching against multi-valued fields such as lists or sets where you want to ensure
        that all of the `values` are present in the list or set.
        """
        return pulumi.get(self, "all")

    @property
    @pulumi.getter(name="matchBy")
    def match_by(self) -> Optional[str]:
        """
        One of `exact` (default), `re`, or `substring`. For string-typed fields, specify `re` to
        match by using the `values` as regular expressions, or specify `substring` to match by treating the `values` as
        substrings to find within the string field.
        """
        return pulumi.get(self, "match_by")


@pulumi.output_type
class GetRegionsRegionResult(dict):
    def __init__(__self__, *,
                 available: bool,
                 features: Sequence[str],
                 name: str,
                 sizes: Sequence[str],
                 slug: str):
        """
        :param bool available: A boolean value that represents whether new Droplets can be created in this region.
        :param Sequence[str] features: A set of features available in this region.
        :param str name: The display name of the region.
        :param Sequence[str] sizes: A set of identifying slugs for the Droplet sizes available in this region.
        :param str slug: A human-readable string that is used as a unique identifier for each region.
        """
        pulumi.set(__self__, "available", available)
        pulumi.set(__self__, "features", features)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "sizes", sizes)
        pulumi.set(__self__, "slug", slug)

    @property
    @pulumi.getter
    def available(self) -> bool:
        """
        A boolean value that represents whether new Droplets can be created in this region.
        """
        return pulumi.get(self, "available")

    @property
    @pulumi.getter
    def features(self) -> Sequence[str]:
        """
        A set of features available in this region.
        """
        return pulumi.get(self, "features")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The display name of the region.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def sizes(self) -> Sequence[str]:
        """
        A set of identifying slugs for the Droplet sizes available in this region.
        """
        return pulumi.get(self, "sizes")

    @property
    @pulumi.getter
    def slug(self) -> str:
        """
        A human-readable string that is used as a unique identifier for each region.
        """
        return pulumi.get(self, "slug")


@pulumi.output_type
class GetRegionsSortResult(dict):
    def __init__(__self__, *,
                 key: str,
                 direction: Optional[str] = None):
        """
        :param str key: Sort the regions by this key. This may be one of `slug`,
               `name`, or `available`.
        :param str direction: The sort direction. This may be either `asc` or `desc`.
        """
        pulumi.set(__self__, "key", key)
        if direction is not None:
            pulumi.set(__self__, "direction", direction)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        Sort the regions by this key. This may be one of `slug`,
        `name`, or `available`.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def direction(self) -> Optional[str]:
        """
        The sort direction. This may be either `asc` or `desc`.
        """
        return pulumi.get(self, "direction")


@pulumi.output_type
class GetSizesFilterResult(dict):
    def __init__(__self__, *,
                 key: str,
                 values: Sequence[str],
                 all: Optional[bool] = None,
                 match_by: Optional[str] = None):
        """
        :param str key: Filter the sizes by this key. This may be one of `slug`,
               `regions`, `memory`, `vcpus`, `disk`, `transfer`, `price_monthly`,
               `price_hourly`, or `available`.
        :param Sequence[str] values: Only retrieves sizes which keys has value that matches
               one of the values provided here.
        :param bool all: Set to `true` to require that a field match all of the `values` instead of just one or more of
               them. This is useful when matching against multi-valued fields such as lists or sets where you want to ensure
               that all of the `values` are present in the list or set.
        :param str match_by: One of `exact` (default), `re`, or `substring`. For string-typed fields, specify `re` to
               match by using the `values` as regular expressions, or specify `substring` to match by treating the `values` as
               substrings to find within the string field.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "values", values)
        if all is not None:
            pulumi.set(__self__, "all", all)
        if match_by is not None:
            pulumi.set(__self__, "match_by", match_by)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        Filter the sizes by this key. This may be one of `slug`,
        `regions`, `memory`, `vcpus`, `disk`, `transfer`, `price_monthly`,
        `price_hourly`, or `available`.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        Only retrieves sizes which keys has value that matches
        one of the values provided here.
        """
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def all(self) -> Optional[bool]:
        """
        Set to `true` to require that a field match all of the `values` instead of just one or more of
        them. This is useful when matching against multi-valued fields such as lists or sets where you want to ensure
        that all of the `values` are present in the list or set.
        """
        return pulumi.get(self, "all")

    @property
    @pulumi.getter(name="matchBy")
    def match_by(self) -> Optional[str]:
        """
        One of `exact` (default), `re`, or `substring`. For string-typed fields, specify `re` to
        match by using the `values` as regular expressions, or specify `substring` to match by treating the `values` as
        substrings to find within the string field.
        """
        return pulumi.get(self, "match_by")


@pulumi.output_type
class GetSizesSizeResult(dict):
    def __init__(__self__, *,
                 available: bool,
                 disk: int,
                 memory: int,
                 price_hourly: float,
                 price_monthly: float,
                 regions: Sequence[str],
                 slug: str,
                 transfer: float,
                 vcpus: int):
        """
        :param bool available: This represents whether new Droplets can be created with this size.
        :param int disk: The amount of disk space set aside for Droplets of this size. The value is measured in gigabytes.
        :param int memory: The amount of RAM allocated to Droplets created of this size. The value is measured in megabytes.
        :param float price_hourly: The hourly cost of Droplets created in this size as measured hourly. The value is measured in US dollars.
        :param float price_monthly: The monthly cost of Droplets created in this size if they are kept for an entire month. The value is measured in US dollars.
        :param Sequence[str] regions: List of region slugs where Droplets can be created in this size.
        :param str slug: A human-readable string that is used to uniquely identify each size.
        :param float transfer: The amount of transfer bandwidth that is available for Droplets created in this size. This only counts traffic on the public interface. The value is given in terabytes.
        :param int vcpus: The number of CPUs allocated to Droplets of this size.
        """
        pulumi.set(__self__, "available", available)
        pulumi.set(__self__, "disk", disk)
        pulumi.set(__self__, "memory", memory)
        pulumi.set(__self__, "price_hourly", price_hourly)
        pulumi.set(__self__, "price_monthly", price_monthly)
        pulumi.set(__self__, "regions", regions)
        pulumi.set(__self__, "slug", slug)
        pulumi.set(__self__, "transfer", transfer)
        pulumi.set(__self__, "vcpus", vcpus)

    @property
    @pulumi.getter
    def available(self) -> bool:
        """
        This represents whether new Droplets can be created with this size.
        """
        return pulumi.get(self, "available")

    @property
    @pulumi.getter
    def disk(self) -> int:
        """
        The amount of disk space set aside for Droplets of this size. The value is measured in gigabytes.
        """
        return pulumi.get(self, "disk")

    @property
    @pulumi.getter
    def memory(self) -> int:
        """
        The amount of RAM allocated to Droplets created of this size. The value is measured in megabytes.
        """
        return pulumi.get(self, "memory")

    @property
    @pulumi.getter(name="priceHourly")
    def price_hourly(self) -> float:
        """
        The hourly cost of Droplets created in this size as measured hourly. The value is measured in US dollars.
        """
        return pulumi.get(self, "price_hourly")

    @property
    @pulumi.getter(name="priceMonthly")
    def price_monthly(self) -> float:
        """
        The monthly cost of Droplets created in this size if they are kept for an entire month. The value is measured in US dollars.
        """
        return pulumi.get(self, "price_monthly")

    @property
    @pulumi.getter
    def regions(self) -> Sequence[str]:
        """
        List of region slugs where Droplets can be created in this size.
        """
        return pulumi.get(self, "regions")

    @property
    @pulumi.getter
    def slug(self) -> str:
        """
        A human-readable string that is used to uniquely identify each size.
        """
        return pulumi.get(self, "slug")

    @property
    @pulumi.getter
    def transfer(self) -> float:
        """
        The amount of transfer bandwidth that is available for Droplets created in this size. This only counts traffic on the public interface. The value is given in terabytes.
        """
        return pulumi.get(self, "transfer")

    @property
    @pulumi.getter
    def vcpus(self) -> int:
        """
        The number of CPUs allocated to Droplets of this size.
        """
        return pulumi.get(self, "vcpus")


@pulumi.output_type
class GetSizesSortResult(dict):
    def __init__(__self__, *,
                 key: str,
                 direction: Optional[str] = None):
        """
        :param str key: Sort the sizes by this key. This may be one of `slug`,
               `memory`, `vcpus`, `disk`, `transfer`, `price_monthly`, or `price_hourly`.
        :param str direction: The sort direction. This may be either `asc` or `desc`.
        """
        pulumi.set(__self__, "key", key)
        if direction is not None:
            pulumi.set(__self__, "direction", direction)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        Sort the sizes by this key. This may be one of `slug`,
        `memory`, `vcpus`, `disk`, `transfer`, `price_monthly`, or `price_hourly`.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def direction(self) -> Optional[str]:
        """
        The sort direction. This may be either `asc` or `desc`.
        """
        return pulumi.get(self, "direction")


@pulumi.output_type
class GetSpacesBucketsBucketResult(dict):
    def __init__(__self__, *,
                 bucket_domain_name: str,
                 name: str,
                 region: str,
                 urn: str):
        """
        :param str bucket_domain_name: The FQDN of the bucket (e.g. bucket-name.nyc3.digitaloceanspaces.com)
        :param str name: The name of the Spaces bucket
        :param str region: The slug of the region where the bucket is stored.
        :param str urn: The uniform resource name of the bucket
        """
        pulumi.set(__self__, "bucket_domain_name", bucket_domain_name)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "region", region)
        pulumi.set(__self__, "urn", urn)

    @property
    @pulumi.getter(name="bucketDomainName")
    def bucket_domain_name(self) -> str:
        """
        The FQDN of the bucket (e.g. bucket-name.nyc3.digitaloceanspaces.com)
        """
        return pulumi.get(self, "bucket_domain_name")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the Spaces bucket
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def region(self) -> str:
        """
        The slug of the region where the bucket is stored.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def urn(self) -> str:
        """
        The uniform resource name of the bucket
        """
        return pulumi.get(self, "urn")


@pulumi.output_type
class GetSpacesBucketsFilterResult(dict):
    def __init__(__self__, *,
                 key: str,
                 values: Sequence[str],
                 all: Optional[bool] = None,
                 match_by: Optional[str] = None):
        """
        :param str key: Filter the images by this key. This may be one of `bucket_domain_name`, `name`, `region`, or `urn`.
        :param Sequence[str] values: A list of values to match against the `key` field. Only retrieves Spaces buckets
               where the `key` field takes on one or more of the values provided here.
        :param bool all: Set to `true` to require that a field match all of the `values` instead of just one or more of
               them. This is useful when matching against multi-valued fields such as lists or sets where you want to ensure
               that all of the `values` are present in the list or set.
        :param str match_by: One of `exact` (default), `re`, or `substring`. For string-typed fields, specify `re` to
               match by using the `values` as regular expressions, or specify `substring` to match by treating the `values` as
               substrings to find within the string field.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "values", values)
        if all is not None:
            pulumi.set(__self__, "all", all)
        if match_by is not None:
            pulumi.set(__self__, "match_by", match_by)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        Filter the images by this key. This may be one of `bucket_domain_name`, `name`, `region`, or `urn`.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        A list of values to match against the `key` field. Only retrieves Spaces buckets
        where the `key` field takes on one or more of the values provided here.
        """
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def all(self) -> Optional[bool]:
        """
        Set to `true` to require that a field match all of the `values` instead of just one or more of
        them. This is useful when matching against multi-valued fields such as lists or sets where you want to ensure
        that all of the `values` are present in the list or set.
        """
        return pulumi.get(self, "all")

    @property
    @pulumi.getter(name="matchBy")
    def match_by(self) -> Optional[str]:
        """
        One of `exact` (default), `re`, or `substring`. For string-typed fields, specify `re` to
        match by using the `values` as regular expressions, or specify `substring` to match by treating the `values` as
        substrings to find within the string field.
        """
        return pulumi.get(self, "match_by")


@pulumi.output_type
class GetSpacesBucketsSortResult(dict):
    def __init__(__self__, *,
                 key: str,
                 direction: Optional[str] = None):
        """
        :param str key: Sort the images by this key. This may be one of `bucket_domain_name`, `name`, `region`, or `urn`.
        :param str direction: The sort direction. This may be either `asc` or `desc`.
        """
        pulumi.set(__self__, "key", key)
        if direction is not None:
            pulumi.set(__self__, "direction", direction)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        Sort the images by this key. This may be one of `bucket_domain_name`, `name`, `region`, or `urn`.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def direction(self) -> Optional[str]:
        """
        The sort direction. This may be either `asc` or `desc`.
        """
        return pulumi.get(self, "direction")


@pulumi.output_type
class GetSshKeysFilterResult(dict):
    def __init__(__self__, *,
                 key: str,
                 values: Sequence[str],
                 all: Optional[bool] = None,
                 match_by: Optional[str] = None):
        """
        :param str key: Filter the SSH Keys by this key. This may be one of `name`, `public_key`, or `fingerprint`.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "values", values)
        if all is not None:
            pulumi.set(__self__, "all", all)
        if match_by is not None:
            pulumi.set(__self__, "match_by", match_by)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        Filter the SSH Keys by this key. This may be one of `name`, `public_key`, or `fingerprint`.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def all(self) -> Optional[bool]:
        return pulumi.get(self, "all")

    @property
    @pulumi.getter(name="matchBy")
    def match_by(self) -> Optional[str]:
        return pulumi.get(self, "match_by")


@pulumi.output_type
class GetSshKeysSortResult(dict):
    def __init__(__self__, *,
                 key: str,
                 direction: Optional[str] = None):
        """
        :param str key: Sort the SSH Keys by this key. This may be one of `name`, `public_key`, or `fingerprint`.
        :param str direction: The sort direction. This may be either `asc` or `desc`.
        """
        pulumi.set(__self__, "key", key)
        if direction is not None:
            pulumi.set(__self__, "direction", direction)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        Sort the SSH Keys by this key. This may be one of `name`, `public_key`, or `fingerprint`.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def direction(self) -> Optional[str]:
        """
        The sort direction. This may be either `asc` or `desc`.
        """
        return pulumi.get(self, "direction")


@pulumi.output_type
class GetSshKeysSshKeyResult(dict):
    def __init__(__self__, *,
                 fingerprint: str,
                 id: int,
                 name: str,
                 public_key: str):
        """
        :param int id: The ID of the ssh key.
               * `name`: The name of the ssh key.
               * `public_key`: The public key of the ssh key.
               * `fingerprint`: The fingerprint of the public key of the ssh key.
        """
        pulumi.set(__self__, "fingerprint", fingerprint)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "public_key", public_key)

    @property
    @pulumi.getter
    def fingerprint(self) -> str:
        return pulumi.get(self, "fingerprint")

    @property
    @pulumi.getter
    def id(self) -> int:
        """
        The ID of the ssh key.
        * `name`: The name of the ssh key.
        * `public_key`: The public key of the ssh key.
        * `fingerprint`: The fingerprint of the public key of the ssh key.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> str:
        return pulumi.get(self, "public_key")


@pulumi.output_type
class GetTagsFilterResult(dict):
    def __init__(__self__, *,
                 key: str,
                 values: Sequence[str],
                 all: Optional[bool] = None,
                 match_by: Optional[str] = None):
        """
        :param str key: Filter the tags by this key. This may be one of `name`, `total_resource_count`,  `droplets_count`, `images_count`, `volumes_count`, `volume_snapshots_count`, or `databases_count`.
        :param Sequence[str] values: Only retrieves tags which keys has value that matches
               one of the values provided here.
        :param bool all: Set to `true` to require that a field match all of the `values` instead of just one or more of
               them. This is useful when matching against multi-valued fields such as lists or sets where you want to ensure
               that all of the `values` are present in the list or set.
        :param str match_by: One of `exact` (default), `re`, or `substring`. For string-typed fields, specify `re` to
               match by using the `values` as regular expressions, or specify `substring` to match by treating the `values` as
               substrings to find within the string field.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "values", values)
        if all is not None:
            pulumi.set(__self__, "all", all)
        if match_by is not None:
            pulumi.set(__self__, "match_by", match_by)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        Filter the tags by this key. This may be one of `name`, `total_resource_count`,  `droplets_count`, `images_count`, `volumes_count`, `volume_snapshots_count`, or `databases_count`.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        Only retrieves tags which keys has value that matches
        one of the values provided here.
        """
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def all(self) -> Optional[bool]:
        """
        Set to `true` to require that a field match all of the `values` instead of just one or more of
        them. This is useful when matching against multi-valued fields such as lists or sets where you want to ensure
        that all of the `values` are present in the list or set.
        """
        return pulumi.get(self, "all")

    @property
    @pulumi.getter(name="matchBy")
    def match_by(self) -> Optional[str]:
        """
        One of `exact` (default), `re`, or `substring`. For string-typed fields, specify `re` to
        match by using the `values` as regular expressions, or specify `substring` to match by treating the `values` as
        substrings to find within the string field.
        """
        return pulumi.get(self, "match_by")


@pulumi.output_type
class GetTagsSortResult(dict):
    def __init__(__self__, *,
                 key: str,
                 direction: Optional[str] = None):
        """
        :param str key: Sort the tags by this key. This may be one of `name`, `total_resource_count`,  `droplets_count`, `images_count`, `volumes_count`, `volume_snapshots_count`, or `databases_count`.
        :param str direction: The sort direction. This may be either `asc` or `desc`.
        """
        pulumi.set(__self__, "key", key)
        if direction is not None:
            pulumi.set(__self__, "direction", direction)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        Sort the tags by this key. This may be one of `name`, `total_resource_count`,  `droplets_count`, `images_count`, `volumes_count`, `volume_snapshots_count`, or `databases_count`.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def direction(self) -> Optional[str]:
        """
        The sort direction. This may be either `asc` or `desc`.
        """
        return pulumi.get(self, "direction")


@pulumi.output_type
class GetTagsTagResult(dict):
    def __init__(__self__, *,
                 databases_count: int,
                 droplets_count: int,
                 images_count: int,
                 name: str,
                 total_resource_count: int,
                 volume_snapshots_count: int,
                 volumes_count: int):
        """
        :param int databases_count: A count of the database clusters that the tag is applied to.
        :param int droplets_count: A count of the Droplets the tag is applied to.
        :param int images_count: A count of the images that the tag is applied to.
        :param str name: The name of the tag.
        :param int total_resource_count: A count of the total number of resources that the tag is applied to.
        :param int volume_snapshots_count: A count of the volume snapshots that the tag is applied to.
        :param int volumes_count: A count of the volumes that the tag is applied to.
        """
        pulumi.set(__self__, "databases_count", databases_count)
        pulumi.set(__self__, "droplets_count", droplets_count)
        pulumi.set(__self__, "images_count", images_count)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "total_resource_count", total_resource_count)
        pulumi.set(__self__, "volume_snapshots_count", volume_snapshots_count)
        pulumi.set(__self__, "volumes_count", volumes_count)

    @property
    @pulumi.getter(name="databasesCount")
    def databases_count(self) -> int:
        """
        A count of the database clusters that the tag is applied to.
        """
        return pulumi.get(self, "databases_count")

    @property
    @pulumi.getter(name="dropletsCount")
    def droplets_count(self) -> int:
        """
        A count of the Droplets the tag is applied to.
        """
        return pulumi.get(self, "droplets_count")

    @property
    @pulumi.getter(name="imagesCount")
    def images_count(self) -> int:
        """
        A count of the images that the tag is applied to.
        """
        return pulumi.get(self, "images_count")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the tag.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="totalResourceCount")
    def total_resource_count(self) -> int:
        """
        A count of the total number of resources that the tag is applied to.
        """
        return pulumi.get(self, "total_resource_count")

    @property
    @pulumi.getter(name="volumeSnapshotsCount")
    def volume_snapshots_count(self) -> int:
        """
        A count of the volume snapshots that the tag is applied to.
        """
        return pulumi.get(self, "volume_snapshots_count")

    @property
    @pulumi.getter(name="volumesCount")
    def volumes_count(self) -> int:
        """
        A count of the volumes that the tag is applied to.
        """
        return pulumi.get(self, "volumes_count")


