# coding: utf-8

"""
    Tator REST API

    Interface to the Tator backend.  # noqa: E501

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from ..configuration import Configuration


class Affiliation(object):
    """
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'int',
        'organization': 'int',
        'permission': 'str',
        'user': 'int'
    }

    attribute_map = {
        'id': 'id',
        'organization': 'organization',
        'permission': 'permission',
        'user': 'user'
    }

    def __init__(self, id=None, organization=None, permission=None, user=None, local_vars_configuration=None):  # noqa: E501
        """Affiliation - a model defined in OpenAPI"""
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._organization = None
        self._permission = None
        self._user = None
        self.discriminator = None

        if id is not None:
            self.id = id
        if organization is not None:
            self.organization = organization
        if permission is not None:
            self.permission = permission
        if user is not None:
            self.user = user

    @property
    def id(self):
        """
        Unique integer identifying a affiliation.

        :return: The id of this Affiliation. 
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Unique integer identifying a affiliation.

        :param id: The id of this Affiliation.
        :type: int
        """

        self._id = id

    @property
    def organization(self):
        """
        Unique integer identifying an organization.

        :return: The organization of this Affiliation. 
        :rtype: int
        """
        return self._organization

    @organization.setter
    def organization(self, organization):
        """
        Unique integer identifying an organization.

        :param organization: The organization of this Affiliation.
        :type: int
        """
        if (self.local_vars_configuration.client_side_validation and
                organization is not None and organization < 1):  # noqa: E501
            raise ValueError("Invalid value for `organization`, must be a value greater than or equal to `1`")  # noqa: E501

        self._organization = organization

    @property
    def permission(self):
        """
        User permission level for the organization.

        :return: The permission of this Affiliation. 
        :rtype: str
        """
        return self._permission

    @permission.setter
    def permission(self, permission):
        """
        User permission level for the organization.

        :param permission: The permission of this Affiliation.
        :type: str
        """
        allowed_values = ["Member", "Admin"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and permission not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `permission` ({0}), must be one of {1}"  # noqa: E501
                .format(permission, allowed_values)
            )

        self._permission = permission

    @property
    def user(self):
        """
        Unique integer identifying a user.

        :return: The user of this Affiliation. 
        :rtype: int
        """
        return self._user

    @user.setter
    def user(self, user):
        """
        Unique integer identifying a user.

        :param user: The user of this Affiliation.
        :type: int
        """
        if (self.local_vars_configuration.client_side_validation and
                user is not None and user < 1):  # noqa: E501
            raise ValueError("Invalid value for `user`, must be a value greater than or equal to `1`")  # noqa: E501

        self._user = user

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Affiliation):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Affiliation):
            return True

        return self.to_dict() != other.to_dict()
