# coding: utf-8

"""
    Tator REST API

    Interface to the Tator backend.  # noqa: E501

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from ..configuration import Configuration


class Bookmark(object):
    """
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'int',
        'name': 'str',
        'project': 'int',
        'uri': 'str',
        'user': 'int'
    }

    attribute_map = {
        'id': 'id',
        'name': 'name',
        'project': 'project',
        'uri': 'uri',
        'user': 'user'
    }

    def __init__(self, id=None, name=None, project=None, uri=None, user=None, local_vars_configuration=None):  # noqa: E501
        """Bookmark - a model defined in OpenAPI"""
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._name = None
        self._project = None
        self._uri = None
        self._user = None
        self.discriminator = None

        if id is not None:
            self.id = id
        if name is not None:
            self.name = name
        if project is not None:
            self.project = project
        if uri is not None:
            self.uri = uri
        if user is not None:
            self.user = user

    @property
    def id(self):
        """
        Unique integer identifying a bookmark.

        :return: The id of this Bookmark. 
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Unique integer identifying a bookmark.

        :param id: The id of this Bookmark.
        :type: int
        """

        self._id = id

    @property
    def name(self):
        """
        Name of the bookmark.

        :return: The name of this Bookmark. 
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Name of the bookmark.

        :param name: The name of this Bookmark.
        :type: str
        """

        self._name = name

    @property
    def project(self):
        """
        Unique integer identifying a project.

        :return: The project of this Bookmark. 
        :rtype: int
        """
        return self._project

    @project.setter
    def project(self, project):
        """
        Unique integer identifying a project.

        :param project: The project of this Bookmark.
        :type: int
        """

        self._project = project

    @property
    def uri(self):
        """
        URI to the saved link.

        :return: The uri of this Bookmark. 
        :rtype: str
        """
        return self._uri

    @uri.setter
    def uri(self, uri):
        """
        URI to the saved link.

        :param uri: The uri of this Bookmark.
        :type: str
        """

        self._uri = uri

    @property
    def user(self):
        """
        Unique integer identifying a user.

        :return: The user of this Bookmark. 
        :rtype: int
        """
        return self._user

    @user.setter
    def user(self, user):
        """
        Unique integer identifying a user.

        :param user: The user of this Bookmark.
        :type: int
        """
        if (self.local_vars_configuration.client_side_validation and
                user is not None and user < 1):  # noqa: E501
            raise ValueError("Invalid value for `user`, must be a value greater than or equal to `1`")  # noqa: E501

        self._user = user

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Bookmark):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Bookmark):
            return True

        return self.to_dict() != other.to_dict()
