# coding: utf-8

"""
    Tator REST API

    Interface to the Tator backend.  # noqa: E501

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from ..configuration import Configuration


class EmailSpec(object):
    """
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'attachments': 'list[EmailAttachmentSpec]',
        'recipients': 'list[str]',
        'subject': 'str',
        'text': 'str'
    }

    attribute_map = {
        'attachments': 'attachments',
        'recipients': 'recipients',
        'subject': 'subject',
        'text': 'text'
    }

    def __init__(self, attachments=None, recipients=None, subject=None, text=None, local_vars_configuration=None):  # noqa: E501
        """EmailSpec - a model defined in OpenAPI"""
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._attachments = None
        self._recipients = None
        self._subject = None
        self._text = None
        self.discriminator = None

        if attachments is not None:
            self.attachments = attachments
        self.recipients = recipients
        self.subject = subject
        self.text = text

    @property
    def attachments(self):
        """
        S3 object(s) to send as attachment(s). Ensure the attachment size does not exceed the corresponding email service limits

        :return: The attachments of this EmailSpec. 
        :rtype: list[EmailAttachmentSpec]
        """
        return self._attachments

    @attachments.setter
    def attachments(self, attachments):
        """
        S3 object(s) to send as attachment(s). Ensure the attachment size does not exceed the corresponding email service limits

        :param attachments: The attachments of this EmailSpec.
        :type: list[EmailAttachmentSpec]
        """

        self._attachments = attachments

    @property
    def recipients(self):
        """
        Recipients of the email message. They must be members of this project. Entries are either in \"Name <email@email.com>\" or \"email@email.com\" format

        :return: The recipients of this EmailSpec. 
        :rtype: list[str]
        """
        return self._recipients

    @recipients.setter
    def recipients(self, recipients):
        """
        Recipients of the email message. They must be members of this project. Entries are either in \"Name <email@email.com>\" or \"email@email.com\" format

        :param recipients: The recipients of this EmailSpec.
        :type: list[str]
        """
        if self.local_vars_configuration.client_side_validation and recipients is None:  # noqa: E501
            raise ValueError("Invalid value for `recipients`, must not be `None`")  # noqa: E501

        self._recipients = recipients

    @property
    def subject(self):
        """
        Subject of the email message

        :return: The subject of this EmailSpec. 
        :rtype: str
        """
        return self._subject

    @subject.setter
    def subject(self, subject):
        """
        Subject of the email message

        :param subject: The subject of this EmailSpec.
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and subject is None:  # noqa: E501
            raise ValueError("Invalid value for `subject`, must not be `None`")  # noqa: E501

        self._subject = subject

    @property
    def text(self):
        """
        Text body of the email message. HTML is currently not supported.

        :return: The text of this EmailSpec. 
        :rtype: str
        """
        return self._text

    @text.setter
    def text(self, text):
        """
        Text body of the email message. HTML is currently not supported.

        :param text: The text of this EmailSpec.
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and text is None:  # noqa: E501
            raise ValueError("Invalid value for `text`, must not be `None`")  # noqa: E501

        self._text = text

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, EmailSpec):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, EmailSpec):
            return True

        return self.to_dict() != other.to_dict()
