# coding: utf-8

"""
    Tator REST API

    Interface to the Tator backend.  # noqa: E501

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from ..configuration import Configuration


class InvitationSpec(object):
    """
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'email': 'str',
        'permission': 'str'
    }

    attribute_map = {
        'email': 'email',
        'permission': 'permission'
    }

    def __init__(self, email=None, permission=None, local_vars_configuration=None):  # noqa: E501
        """InvitationSpec - a model defined in OpenAPI"""
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._email = None
        self._permission = None
        self.discriminator = None

        self.email = email
        self.permission = permission

    @property
    def email(self):
        """
        Email address of invitee.

        :return: The email of this InvitationSpec. 
        :rtype: str
        """
        return self._email

    @email.setter
    def email(self, email):
        """
        Email address of invitee.

        :param email: The email of this InvitationSpec.
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and email is None:  # noqa: E501
            raise ValueError("Invalid value for `email`, must not be `None`")  # noqa: E501

        self._email = email

    @property
    def permission(self):
        """
        User permission level for the organization.

        :return: The permission of this InvitationSpec. 
        :rtype: str
        """
        return self._permission

    @permission.setter
    def permission(self, permission):
        """
        User permission level for the organization.

        :param permission: The permission of this InvitationSpec.
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and permission is None:  # noqa: E501
            raise ValueError("Invalid value for `permission`, must not be `None`")  # noqa: E501
        allowed_values = ["Member", "Admin"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and permission not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `permission` ({0}), must be one of {1}"  # noqa: E501
                .format(permission, allowed_values)
            )

        self._permission = permission

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, InvitationSpec):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, InvitationSpec):
            return True

        return self.to_dict() != other.to_dict()
