# coding: utf-8

"""
    Tator REST API

    Interface to the Tator backend.  # noqa: E501

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from ..configuration import Configuration


class JobClusterSpec(object):
    """
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'cert': 'str',
        'host': 'str',
        'name': 'str',
        'port': 'int',
        'token': 'str'
    }

    attribute_map = {
        'cert': 'cert',
        'host': 'host',
        'name': 'name',
        'port': 'port',
        'token': 'token'
    }

    def __init__(self, cert=None, host=None, name=None, port=None, token=None, local_vars_configuration=None):  # noqa: E501
        """JobClusterSpec - a model defined in OpenAPI"""
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._cert = None
        self._host = None
        self._name = None
        self._port = None
        self._token = None
        self.discriminator = None

        self.cert = cert
        self.host = host
        self.name = name
        self.port = port
        self.token = token

    @property
    def cert(self):
        """
        Certificate for accessing the job cluster.

        :return: The cert of this JobClusterSpec. 
        :rtype: str
        """
        return self._cert

    @cert.setter
    def cert(self, cert):
        """
        Certificate for accessing the job cluster.

        :param cert: The cert of this JobClusterSpec.
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and cert is None:  # noqa: E501
            raise ValueError("Invalid value for `cert`, must not be `None`")  # noqa: E501

        self._cert = cert

    @property
    def host(self):
        """
        Hostname where the cluster can be accessed.

        :return: The host of this JobClusterSpec. 
        :rtype: str
        """
        return self._host

    @host.setter
    def host(self, host):
        """
        Hostname where the cluster can be accessed.

        :param host: The host of this JobClusterSpec.
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and host is None:  # noqa: E501
            raise ValueError("Invalid value for `host`, must not be `None`")  # noqa: E501

        self._host = host

    @property
    def name(self):
        """
        Unique name of the job cluster.

        :return: The name of this JobClusterSpec. 
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Unique name of the job cluster.

        :param name: The name of this JobClusterSpec.
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and name is None:  # noqa: E501
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def port(self):
        """
        Port where the cluster can be accessed.

        :return: The port of this JobClusterSpec. 
        :rtype: int
        """
        return self._port

    @port.setter
    def port(self, port):
        """
        Port where the cluster can be accessed.

        :param port: The port of this JobClusterSpec.
        :type: int
        """
        if self.local_vars_configuration.client_side_validation and port is None:  # noqa: E501
            raise ValueError("Invalid value for `port`, must not be `None`")  # noqa: E501

        self._port = port

    @property
    def token(self):
        """
        Token for accessing the job cluster.

        :return: The token of this JobClusterSpec. 
        :rtype: str
        """
        return self._token

    @token.setter
    def token(self, token):
        """
        Token for accessing the job cluster.

        :param token: The token of this JobClusterSpec.
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and token is None:  # noqa: E501
            raise ValueError("Invalid value for `token`, must not be `None`")  # noqa: E501

        self._token = token

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, JobClusterSpec):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, JobClusterSpec):
            return True

        return self.to_dict() != other.to_dict()
