# coding: utf-8

"""
    Tator REST API

    Interface to the Tator backend.  # noqa: E501

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from ..configuration import Configuration


class Leaf(object):
    """
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'attributes': 'dict(str, object)',
        'id': 'int',
        'meta': 'int',
        'name': 'str',
        'parent': 'int',
        'path': 'str',
        'project': 'int'
    }

    attribute_map = {
        'attributes': 'attributes',
        'id': 'id',
        'meta': 'meta',
        'name': 'name',
        'parent': 'parent',
        'path': 'path',
        'project': 'project'
    }

    def __init__(self, attributes=None, id=None, meta=None, name=None, parent=None, path=None, project=None, local_vars_configuration=None):  # noqa: E501
        """Leaf - a model defined in OpenAPI"""
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._attributes = None
        self._id = None
        self._meta = None
        self._name = None
        self._parent = None
        self._path = None
        self._project = None
        self.discriminator = None

        if attributes is not None:
            self.attributes = attributes
        if id is not None:
            self.id = id
        if meta is not None:
            self.meta = meta
        if name is not None:
            self.name = name
        self.parent = parent
        if path is not None:
            self.path = path
        if project is not None:
            self.project = project

    @property
    def attributes(self):
        """
        Object containing attribute values.

        :return: The attributes of this Leaf. 
        :rtype: dict(str, object)
        """
        return self._attributes

    @attributes.setter
    def attributes(self, attributes):
        """
        Object containing attribute values.

        :param attributes: The attributes of this Leaf.
        :type: dict(str, object)
        """

        self._attributes = attributes

    @property
    def id(self):
        """
        Unique integer identifying the leaf.

        :return: The id of this Leaf. 
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Unique integer identifying the leaf.

        :param id: The id of this Leaf.
        :type: int
        """

        self._id = id

    @property
    def meta(self):
        """
        Unique integer identifying the entity type.

        :return: The meta of this Leaf. 
        :rtype: int
        """
        return self._meta

    @meta.setter
    def meta(self, meta):
        """
        Unique integer identifying the entity type.

        :param meta: The meta of this Leaf.
        :type: int
        """

        self._meta = meta

    @property
    def name(self):
        """
        Name of the leaf.

        :return: The name of this Leaf. 
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Name of the leaf.

        :param name: The name of this Leaf.
        :type: str
        """

        self._name = name

    @property
    def parent(self):
        """
        ID to use as parent if there is one.

        :return: The parent of this Leaf. 
        :rtype: int
        """
        return self._parent

    @parent.setter
    def parent(self, parent):
        """
        ID to use as parent if there is one.

        :param parent: The parent of this Leaf.
        :type: int
        """

        self._parent = parent

    @property
    def path(self):
        """
        Full path to leaf in hierarchy.

        :return: The path of this Leaf. 
        :rtype: str
        """
        return self._path

    @path.setter
    def path(self, path):
        """
        Full path to leaf in hierarchy.

        :param path: The path of this Leaf.
        :type: str
        """

        self._path = path

    @property
    def project(self):
        """
        Unique integer identifying a project.

        :return: The project of this Leaf. 
        :rtype: int
        """
        return self._project

    @project.setter
    def project(self, project):
        """
        Unique integer identifying a project.

        :param project: The project of this Leaf.
        :type: int
        """

        self._project = project

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Leaf):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Leaf):
            return True

        return self.to_dict() != other.to_dict()
