# coding: utf-8

"""
    Tator REST API

    Interface to the Tator backend.  # noqa: E501

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from ..configuration import Configuration


class LeafType(object):
    """
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'attribute_types': 'list[AttributeType]',
        'description': 'str',
        'dtype': 'str',
        'id': 'int',
        'name': 'str',
        'project': 'int'
    }

    attribute_map = {
        'attribute_types': 'attribute_types',
        'description': 'description',
        'dtype': 'dtype',
        'id': 'id',
        'name': 'name',
        'project': 'project'
    }

    def __init__(self, attribute_types=None, description='', dtype=None, id=None, name=None, project=None, local_vars_configuration=None):  # noqa: E501
        """LeafType - a model defined in OpenAPI"""
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._attribute_types = None
        self._description = None
        self._dtype = None
        self._id = None
        self._name = None
        self._project = None
        self.discriminator = None

        if attribute_types is not None:
            self.attribute_types = attribute_types
        if description is not None:
            self.description = description
        if dtype is not None:
            self.dtype = dtype
        if id is not None:
            self.id = id
        if name is not None:
            self.name = name
        if project is not None:
            self.project = project

    @property
    def attribute_types(self):
        """
        Attribute type definitions.

        :return: The attribute_types of this LeafType. 
        :rtype: list[AttributeType]
        """
        return self._attribute_types

    @attribute_types.setter
    def attribute_types(self, attribute_types):
        """
        Attribute type definitions.

        :param attribute_types: The attribute_types of this LeafType.
        :type: list[AttributeType]
        """

        self._attribute_types = attribute_types

    @property
    def description(self):
        """
        Description of the leaf type.

        :return: The description of this LeafType. 
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Description of the leaf type.

        :param description: The description of this LeafType.
        :type: str
        """

        self._description = description

    @property
    def dtype(self):
        """
        Name of this data type, value is always \"leaf\".

        :return: The dtype of this LeafType. 
        :rtype: str
        """
        return self._dtype

    @dtype.setter
    def dtype(self, dtype):
        """
        Name of this data type, value is always \"leaf\".

        :param dtype: The dtype of this LeafType.
        :type: str
        """

        self._dtype = dtype

    @property
    def id(self):
        """
        Unique integer identifying a leaf type.

        :return: The id of this LeafType. 
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Unique integer identifying a leaf type.

        :param id: The id of this LeafType.
        :type: int
        """

        self._id = id

    @property
    def name(self):
        """
        Name of the leaf type.

        :return: The name of this LeafType. 
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Name of the leaf type.

        :param name: The name of this LeafType.
        :type: str
        """

        self._name = name

    @property
    def project(self):
        """
        Unique integer identifying project for this leaf type.

        :return: The project of this LeafType. 
        :rtype: int
        """
        return self._project

    @project.setter
    def project(self, project):
        """
        Unique integer identifying project for this leaf type.

        :param project: The project of this LeafType.
        :type: int
        """

        self._project = project

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, LeafType):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, LeafType):
            return True

        return self.to_dict() != other.to_dict()
