# coding: utf-8

"""
    Tator REST API

    Interface to the Tator backend.  # noqa: E501

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from ..configuration import Configuration


class Localization(object):
    """
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'attributes': 'dict(str, object)',
        'created_datetime': 'datetime',
        'frame': 'int',
        'height': 'float',
        'id': 'int',
        'media': 'int',
        'meta': 'int',
        'modified_by': 'int',
        'modified_datetime': 'datetime',
        'parent': 'float',
        'project': 'int',
        'thumbnail_image': 'str',
        'u': 'float',
        'user': 'int',
        'v': 'float',
        'version': 'int',
        'width': 'float',
        'x': 'float',
        'y': 'float'
    }

    attribute_map = {
        'attributes': 'attributes',
        'created_datetime': 'created_datetime',
        'frame': 'frame',
        'height': 'height',
        'id': 'id',
        'media': 'media',
        'meta': 'meta',
        'modified_by': 'modified_by',
        'modified_datetime': 'modified_datetime',
        'parent': 'parent',
        'project': 'project',
        'thumbnail_image': 'thumbnail_image',
        'u': 'u',
        'user': 'user',
        'v': 'v',
        'version': 'version',
        'width': 'width',
        'x': 'x',
        'y': 'y'
    }

    def __init__(self, attributes=None, created_datetime=None, frame=None, height=None, id=None, media=None, meta=None, modified_by=None, modified_datetime=None, parent=None, project=None, thumbnail_image=None, u=None, user=None, v=None, version=None, width=None, x=None, y=None, local_vars_configuration=None):  # noqa: E501
        """Localization - a model defined in OpenAPI"""
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._attributes = None
        self._created_datetime = None
        self._frame = None
        self._height = None
        self._id = None
        self._media = None
        self._meta = None
        self._modified_by = None
        self._modified_datetime = None
        self._parent = None
        self._project = None
        self._thumbnail_image = None
        self._u = None
        self._user = None
        self._v = None
        self._version = None
        self._width = None
        self._x = None
        self._y = None
        self.discriminator = None

        if attributes is not None:
            self.attributes = attributes
        if created_datetime is not None:
            self.created_datetime = created_datetime
        if frame is not None:
            self.frame = frame
        self.height = height
        if id is not None:
            self.id = id
        if media is not None:
            self.media = media
        if meta is not None:
            self.meta = meta
        if modified_by is not None:
            self.modified_by = modified_by
        if modified_datetime is not None:
            self.modified_datetime = modified_datetime
        self.parent = parent
        if project is not None:
            self.project = project
        if thumbnail_image is not None:
            self.thumbnail_image = thumbnail_image
        self.u = u
        if user is not None:
            self.user = user
        self.v = v
        if version is not None:
            self.version = version
        self.width = width
        self.x = x
        self.y = y

    @property
    def attributes(self):
        """
        Object containing attribute values.

        :return: The attributes of this Localization. 
        :rtype: dict(str, object)
        """
        return self._attributes

    @attributes.setter
    def attributes(self, attributes):
        """
        Object containing attribute values.

        :param attributes: The attributes of this Localization.
        :type: dict(str, object)
        """

        self._attributes = attributes

    @property
    def created_datetime(self):
        """
        Datetime this localization was created.

        :return: The created_datetime of this Localization. 
        :rtype: datetime
        """
        return self._created_datetime

    @created_datetime.setter
    def created_datetime(self, created_datetime):
        """
        Datetime this localization was created.

        :param created_datetime: The created_datetime of this Localization.
        :type: datetime
        """

        self._created_datetime = created_datetime

    @property
    def frame(self):
        """
        Frame number of this localization if it is in a video.

        :return: The frame of this Localization. 
        :rtype: int
        """
        return self._frame

    @frame.setter
    def frame(self, frame):
        """
        Frame number of this localization if it is in a video.

        :param frame: The frame of this Localization.
        :type: int
        """

        self._frame = frame

    @property
    def height(self):
        """
        Normalized height of bounding box for `box` localization types.

        :return: The height of this Localization. 
        :rtype: float
        """
        return self._height

    @height.setter
    def height(self, height):
        """
        Normalized height of bounding box for `box` localization types.

        :param height: The height of this Localization.
        :type: float
        """
        if (self.local_vars_configuration.client_side_validation and
                height is not None and height > 1.0):  # noqa: E501
            raise ValueError("Invalid value for `height`, must be a value less than or equal to `1.0`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                height is not None and height < 0.0):  # noqa: E501
            raise ValueError("Invalid value for `height`, must be a value greater than or equal to `0.0`")  # noqa: E501

        self._height = height

    @property
    def id(self):
        """
        Unique integer identifying this localization.

        :return: The id of this Localization. 
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Unique integer identifying this localization.

        :param id: The id of this Localization.
        :type: int
        """

        self._id = id

    @property
    def media(self):
        """
        Unique integer identifying media of this localization.

        :return: The media of this Localization. 
        :rtype: int
        """
        return self._media

    @media.setter
    def media(self, media):
        """
        Unique integer identifying media of this localization.

        :param media: The media of this Localization.
        :type: int
        """

        self._media = media

    @property
    def meta(self):
        """
        Unique integer identifying entity type of this localization.

        :return: The meta of this Localization. 
        :rtype: int
        """
        return self._meta

    @meta.setter
    def meta(self, meta):
        """
        Unique integer identifying entity type of this localization.

        :param meta: The meta of this Localization.
        :type: int
        """

        self._meta = meta

    @property
    def modified_by(self):
        """
        Unique integer identifying the user who last modified this localization.

        :return: The modified_by of this Localization. 
        :rtype: int
        """
        return self._modified_by

    @modified_by.setter
    def modified_by(self, modified_by):
        """
        Unique integer identifying the user who last modified this localization.

        :param modified_by: The modified_by of this Localization.
        :type: int
        """

        self._modified_by = modified_by

    @property
    def modified_datetime(self):
        """
        Datetime this localization was last modified.

        :return: The modified_datetime of this Localization. 
        :rtype: datetime
        """
        return self._modified_datetime

    @modified_datetime.setter
    def modified_datetime(self, modified_datetime):
        """
        Datetime this localization was last modified.

        :param modified_datetime: The modified_datetime of this Localization.
        :type: datetime
        """

        self._modified_datetime = modified_datetime

    @property
    def parent(self):
        """
        If a clone, the pk of the parent.

        :return: The parent of this Localization. 
        :rtype: float
        """
        return self._parent

    @parent.setter
    def parent(self, parent):
        """
        If a clone, the pk of the parent.

        :param parent: The parent of this Localization.
        :type: float
        """

        self._parent = parent

    @property
    def project(self):
        """
        Unique integer identifying project of this localization.

        :return: The project of this Localization. 
        :rtype: int
        """
        return self._project

    @project.setter
    def project(self, project):
        """
        Unique integer identifying project of this localization.

        :param project: The project of this Localization.
        :type: int
        """

        self._project = project

    @property
    def thumbnail_image(self):
        """
        URL of thumbnail corresponding to this localization.

        :return: The thumbnail_image of this Localization. 
        :rtype: str
        """
        return self._thumbnail_image

    @thumbnail_image.setter
    def thumbnail_image(self, thumbnail_image):
        """
        URL of thumbnail corresponding to this localization.

        :param thumbnail_image: The thumbnail_image of this Localization.
        :type: str
        """

        self._thumbnail_image = thumbnail_image

    @property
    def u(self):
        """
        Horizontal vector component for `line` localization types.

        :return: The u of this Localization. 
        :rtype: float
        """
        return self._u

    @u.setter
    def u(self, u):
        """
        Horizontal vector component for `line` localization types.

        :param u: The u of this Localization.
        :type: float
        """
        if (self.local_vars_configuration.client_side_validation and
                u is not None and u > 1.0):  # noqa: E501
            raise ValueError("Invalid value for `u`, must be a value less than or equal to `1.0`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                u is not None and u < -1.0):  # noqa: E501
            raise ValueError("Invalid value for `u`, must be a value greater than or equal to `-1.0`")  # noqa: E501

        self._u = u

    @property
    def user(self):
        """
        Unique integer identifying the user who created this localization.

        :return: The user of this Localization. 
        :rtype: int
        """
        return self._user

    @user.setter
    def user(self, user):
        """
        Unique integer identifying the user who created this localization.

        :param user: The user of this Localization.
        :type: int
        """

        self._user = user

    @property
    def v(self):
        """
        Vertical vector component for `line` localization types.

        :return: The v of this Localization. 
        :rtype: float
        """
        return self._v

    @v.setter
    def v(self, v):
        """
        Vertical vector component for `line` localization types.

        :param v: The v of this Localization.
        :type: float
        """
        if (self.local_vars_configuration.client_side_validation and
                v is not None and v > 1.0):  # noqa: E501
            raise ValueError("Invalid value for `v`, must be a value less than or equal to `1.0`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                v is not None and v < -1.0):  # noqa: E501
            raise ValueError("Invalid value for `v`, must be a value greater than or equal to `-1.0`")  # noqa: E501

        self._v = v

    @property
    def version(self):
        """
        Unique integer identifying a version.

        :return: The version of this Localization. 
        :rtype: int
        """
        return self._version

    @version.setter
    def version(self, version):
        """
        Unique integer identifying a version.

        :param version: The version of this Localization.
        :type: int
        """

        self._version = version

    @property
    def width(self):
        """
        Normalized width of bounding box for `box` localization types.

        :return: The width of this Localization. 
        :rtype: float
        """
        return self._width

    @width.setter
    def width(self, width):
        """
        Normalized width of bounding box for `box` localization types.

        :param width: The width of this Localization.
        :type: float
        """
        if (self.local_vars_configuration.client_side_validation and
                width is not None and width > 1.0):  # noqa: E501
            raise ValueError("Invalid value for `width`, must be a value less than or equal to `1.0`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                width is not None and width < 0.0):  # noqa: E501
            raise ValueError("Invalid value for `width`, must be a value greater than or equal to `0.0`")  # noqa: E501

        self._width = width

    @property
    def x(self):
        """
        Normalized horizontal position of left edge of bounding box for `box` localization types, start of line for `line` localization types, or position of dot for `dot` localization types.

        :return: The x of this Localization. 
        :rtype: float
        """
        return self._x

    @x.setter
    def x(self, x):
        """
        Normalized horizontal position of left edge of bounding box for `box` localization types, start of line for `line` localization types, or position of dot for `dot` localization types.

        :param x: The x of this Localization.
        :type: float
        """
        if (self.local_vars_configuration.client_side_validation and
                x is not None and x > 1.0):  # noqa: E501
            raise ValueError("Invalid value for `x`, must be a value less than or equal to `1.0`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                x is not None and x < 0.0):  # noqa: E501
            raise ValueError("Invalid value for `x`, must be a value greater than or equal to `0.0`")  # noqa: E501

        self._x = x

    @property
    def y(self):
        """
        Normalized vertical position of top edge of bounding box for `box` localization types, start of line for `line` localization types, or position of dot for `dot` localization types.

        :return: The y of this Localization. 
        :rtype: float
        """
        return self._y

    @y.setter
    def y(self, y):
        """
        Normalized vertical position of top edge of bounding box for `box` localization types, start of line for `line` localization types, or position of dot for `dot` localization types.

        :param y: The y of this Localization.
        :type: float
        """
        if (self.local_vars_configuration.client_side_validation and
                y is not None and y > 1.0):  # noqa: E501
            raise ValueError("Invalid value for `y`, must be a value less than or equal to `1.0`")  # noqa: E501
        if (self.local_vars_configuration.client_side_validation and
                y is not None and y < 0.0):  # noqa: E501
            raise ValueError("Invalid value for `y`, must be a value greater than or equal to `0.0`")  # noqa: E501

        self._y = y

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Localization):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Localization):
            return True

        return self.to_dict() != other.to_dict()
