# coding: utf-8

"""
    Tator REST API

    Interface to the Tator backend.  # noqa: E501

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from ..configuration import Configuration


class S3StorageConfig(object):
    """
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'aws_access_key': 'str',
        'aws_secret_access_key': 'str',
        'bucket_name': 'str'
    }

    attribute_map = {
        'aws_access_key': 'aws_access_key',
        'aws_secret_access_key': 'aws_secret_access_key',
        'bucket_name': 'bucket_name'
    }

    def __init__(self, aws_access_key=None, aws_secret_access_key=None, bucket_name=None, local_vars_configuration=None):  # noqa: E501
        """S3StorageConfig - a model defined in OpenAPI"""
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._aws_access_key = None
        self._aws_secret_access_key = None
        self._bucket_name = None
        self.discriminator = None

        if aws_access_key is not None:
            self.aws_access_key = aws_access_key
        if aws_secret_access_key is not None:
            self.aws_secret_access_key = aws_secret_access_key
        if bucket_name is not None:
            self.bucket_name = bucket_name

    @property
    def aws_access_key(self):
        """
        AWS access key.

        :return: The aws_access_key of this S3StorageConfig. 
        :rtype: str
        """
        return self._aws_access_key

    @aws_access_key.setter
    def aws_access_key(self, aws_access_key):
        """
        AWS access key.

        :param aws_access_key: The aws_access_key of this S3StorageConfig.
        :type: str
        """

        self._aws_access_key = aws_access_key

    @property
    def aws_secret_access_key(self):
        """
        AWS secret access key.

        :return: The aws_secret_access_key of this S3StorageConfig. 
        :rtype: str
        """
        return self._aws_secret_access_key

    @aws_secret_access_key.setter
    def aws_secret_access_key(self, aws_secret_access_key):
        """
        AWS secret access key.

        :param aws_secret_access_key: The aws_secret_access_key of this S3StorageConfig.
        :type: str
        """

        self._aws_secret_access_key = aws_secret_access_key

    @property
    def bucket_name(self):
        """
        Name of bucket.

        :return: The bucket_name of this S3StorageConfig. 
        :rtype: str
        """
        return self._bucket_name

    @bucket_name.setter
    def bucket_name(self, bucket_name):
        """
        Name of bucket.

        :param bucket_name: The bucket_name of this S3StorageConfig.
        :type: str
        """

        self._bucket_name = bucket_name

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, S3StorageConfig):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, S3StorageConfig):
            return True

        return self.to_dict() != other.to_dict()
