# coding: utf-8

"""
    Tator REST API

    Interface to the Tator backend.  # noqa: E501

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from ..configuration import Configuration


class StateUpdate(object):
    """
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'attributes': 'dict(str, object)',
        'frame': 'int',
        'localization_ids_add': 'list[int]',
        'localization_ids_remove': 'list[int]'
    }

    attribute_map = {
        'attributes': 'attributes',
        'frame': 'frame',
        'localization_ids_add': 'localization_ids_add',
        'localization_ids_remove': 'localization_ids_remove'
    }

    def __init__(self, attributes=None, frame=None, localization_ids_add=None, localization_ids_remove=None, local_vars_configuration=None):  # noqa: E501
        """StateUpdate - a model defined in OpenAPI"""
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._attributes = None
        self._frame = None
        self._localization_ids_add = None
        self._localization_ids_remove = None
        self.discriminator = None

        if attributes is not None:
            self.attributes = attributes
        if frame is not None:
            self.frame = frame
        if localization_ids_add is not None:
            self.localization_ids_add = localization_ids_add
        if localization_ids_remove is not None:
            self.localization_ids_remove = localization_ids_remove

    @property
    def attributes(self):
        """
        Object containing attribute values.

        :return: The attributes of this StateUpdate. 
        :rtype: dict(str, object)
        """
        return self._attributes

    @attributes.setter
    def attributes(self, attributes):
        """
        Object containing attribute values.

        :param attributes: The attributes of this StateUpdate.
        :type: dict(str, object)
        """

        self._attributes = attributes

    @property
    def frame(self):
        """
        Frame number this state applies to.

        :return: The frame of this StateUpdate. 
        :rtype: int
        """
        return self._frame

    @frame.setter
    def frame(self, frame):
        """
        Frame number this state applies to.

        :param frame: The frame of this StateUpdate.
        :type: int
        """

        self._frame = frame

    @property
    def localization_ids_add(self):
        """
        List of new localization IDs that this state applies to.

        :return: The localization_ids_add of this StateUpdate. 
        :rtype: list[int]
        """
        return self._localization_ids_add

    @localization_ids_add.setter
    def localization_ids_add(self, localization_ids_add):
        """
        List of new localization IDs that this state applies to.

        :param localization_ids_add: The localization_ids_add of this StateUpdate.
        :type: list[int]
        """

        self._localization_ids_add = localization_ids_add

    @property
    def localization_ids_remove(self):
        """
        List of new localization IDs that this state applies to.

        :return: The localization_ids_remove of this StateUpdate. 
        :rtype: list[int]
        """
        return self._localization_ids_remove

    @localization_ids_remove.setter
    def localization_ids_remove(self, localization_ids_remove):
        """
        List of new localization IDs that this state applies to.

        :param localization_ids_remove: The localization_ids_remove of this StateUpdate.
        :type: list[int]
        """

        self._localization_ids_remove = localization_ids_remove

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, StateUpdate):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, StateUpdate):
            return True

        return self.to_dict() != other.to_dict()
