# coding: utf-8

"""
    Tator REST API

    Interface to the Tator backend.  # noqa: E501

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from ..configuration import Configuration


class TemporaryFile(object):
    """
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'created_datetime': 'str',
        'eol_datetime': 'str',
        'id': 'int',
        'lookup': 'str',
        'name': 'str',
        'path': 'str',
        'project': 'int',
        'user': 'int'
    }

    attribute_map = {
        'created_datetime': 'created_datetime',
        'eol_datetime': 'eol_datetime',
        'id': 'id',
        'lookup': 'lookup',
        'name': 'name',
        'path': 'path',
        'project': 'project',
        'user': 'user'
    }

    def __init__(self, created_datetime=None, eol_datetime=None, id=None, lookup=None, name=None, path=None, project=None, user=None, local_vars_configuration=None):  # noqa: E501
        """TemporaryFile - a model defined in OpenAPI"""
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._created_datetime = None
        self._eol_datetime = None
        self._id = None
        self._lookup = None
        self._name = None
        self._path = None
        self._project = None
        self._user = None
        self.discriminator = None

        if created_datetime is not None:
            self.created_datetime = created_datetime
        if eol_datetime is not None:
            self.eol_datetime = eol_datetime
        if id is not None:
            self.id = id
        if lookup is not None:
            self.lookup = lookup
        if name is not None:
            self.name = name
        if path is not None:
            self.path = path
        if project is not None:
            self.project = project
        if user is not None:
            self.user = user

    @property
    def created_datetime(self):
        """
        Datetime when this temporary file was created.

        :return: The created_datetime of this TemporaryFile. 
        :rtype: str
        """
        return self._created_datetime

    @created_datetime.setter
    def created_datetime(self, created_datetime):
        """
        Datetime when this temporary file was created.

        :param created_datetime: The created_datetime of this TemporaryFile.
        :type: str
        """

        self._created_datetime = created_datetime

    @property
    def eol_datetime(self):
        """
        Datetime when this temporary file may be deleted.

        :return: The eol_datetime of this TemporaryFile. 
        :rtype: str
        """
        return self._eol_datetime

    @eol_datetime.setter
    def eol_datetime(self, eol_datetime):
        """
        Datetime when this temporary file may be deleted.

        :param eol_datetime: The eol_datetime of this TemporaryFile.
        :type: str
        """

        self._eol_datetime = eol_datetime

    @property
    def id(self):
        """
        Unique integer identifying a temporary file.

        :return: The id of this TemporaryFile. 
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Unique integer identifying a temporary file.

        :param id: The id of this TemporaryFile.
        :type: int
        """

        self._id = id

    @property
    def lookup(self):
        """
        md5hash of lookup parameters

        :return: The lookup of this TemporaryFile. 
        :rtype: str
        """
        return self._lookup

    @lookup.setter
    def lookup(self, lookup):
        """
        md5hash of lookup parameters

        :param lookup: The lookup of this TemporaryFile.
        :type: str
        """

        self._lookup = lookup

    @property
    def name(self):
        """
        Unique name for the temporary file

        :return: The name of this TemporaryFile. 
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Unique name for the temporary file

        :param name: The name of this TemporaryFile.
        :type: str
        """

        self._name = name

    @property
    def path(self):
        """
        Full URL to the temporary file.

        :return: The path of this TemporaryFile. 
        :rtype: str
        """
        return self._path

    @path.setter
    def path(self, path):
        """
        Full URL to the temporary file.

        :param path: The path of this TemporaryFile.
        :type: str
        """

        self._path = path

    @property
    def project(self):
        """
        Unique integer identifying a project.

        :return: The project of this TemporaryFile. 
        :rtype: int
        """
        return self._project

    @project.setter
    def project(self, project):
        """
        Unique integer identifying a project.

        :param project: The project of this TemporaryFile.
        :type: int
        """

        self._project = project

    @property
    def user(self):
        """
        Unique integer identifying user who created this file.

        :return: The user of this TemporaryFile. 
        :rtype: int
        """
        return self._user

    @user.setter
    def user(self, user):
        """
        Unique integer identifying user who created this file.

        :param user: The user of this TemporaryFile.
        :type: int
        """

        self._user = user

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, TemporaryFile):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, TemporaryFile):
            return True

        return self.to_dict() != other.to_dict()
