# coding: utf-8

"""
    Tator REST API

    Interface to the Tator backend.  # noqa: E501

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from ..configuration import Configuration


class UploadCompletionSpec(object):
    """
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'key': 'str',
        'parts': 'list[UploadPart]',
        'upload_id': 'str'
    }

    attribute_map = {
        'key': 'key',
        'parts': 'parts',
        'upload_id': 'upload_id'
    }

    def __init__(self, key=None, parts=None, upload_id=None, local_vars_configuration=None):  # noqa: E501
        """UploadCompletionSpec - a model defined in OpenAPI"""
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._key = None
        self._parts = None
        self._upload_id = None
        self.discriminator = None

        if key is not None:
            self.key = key
        if parts is not None:
            self.parts = parts
        if upload_id is not None:
            self.upload_id = upload_id

    @property
    def key(self):
        """
        An object key that can be supplied to the `Transcode` or `Media` endpoint after the file has been uploaded.

        :return: The key of this UploadCompletionSpec. 
        :rtype: str
        """
        return self._key

    @key.setter
    def key(self, key):
        """
        An object key that can be supplied to the `Transcode` or `Media` endpoint after the file has been uploaded.

        :param key: The key of this UploadCompletionSpec.
        :type: str
        """

        self._key = key

    @property
    def parts(self):
        """
        List of objects containing part number for each PUT request and ETag header from each response.

        :return: The parts of this UploadCompletionSpec. 
        :rtype: list[UploadPart]
        """
        return self._parts

    @parts.setter
    def parts(self, parts):
        """
        List of objects containing part number for each PUT request and ETag header from each response.

        :param parts: The parts of this UploadCompletionSpec.
        :type: list[UploadPart]
        """

        self._parts = parts

    @property
    def upload_id(self):
        """
        An upload ID.

        :return: The upload_id of this UploadCompletionSpec. 
        :rtype: str
        """
        return self._upload_id

    @upload_id.setter
    def upload_id(self, upload_id):
        """
        An upload ID.

        :param upload_id: The upload_id of this UploadCompletionSpec.
        :type: str
        """

        self._upload_id = upload_id

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, UploadCompletionSpec):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, UploadCompletionSpec):
            return True

        return self.to_dict() != other.to_dict()
