# coding: utf-8

"""
    Tator REST API

    Interface to the Tator backend.  # noqa: E501

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from ..configuration import Configuration


class UserSpec(object):
    """
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'email': 'str',
        'first_name': 'str',
        'last_name': 'str',
        'password': 'str',
        'registration_token': 'str',
        'username': 'str'
    }

    attribute_map = {
        'email': 'email',
        'first_name': 'first_name',
        'last_name': 'last_name',
        'password': 'password',
        'registration_token': 'registration_token',
        'username': 'username'
    }

    def __init__(self, email=None, first_name=None, last_name=None, password=None, registration_token=None, username=None, local_vars_configuration=None):  # noqa: E501
        """UserSpec - a model defined in OpenAPI"""
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._email = None
        self._first_name = None
        self._last_name = None
        self._password = None
        self._registration_token = None
        self._username = None
        self.discriminator = None

        self.email = email
        self.first_name = first_name
        self.last_name = last_name
        self.password = password
        if registration_token is not None:
            self.registration_token = registration_token
        self.username = username

    @property
    def email(self):
        """
        Email address of user.

        :return: The email of this UserSpec. 
        :rtype: str
        """
        return self._email

    @email.setter
    def email(self, email):
        """
        Email address of user.

        :param email: The email of this UserSpec.
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and email is None:  # noqa: E501
            raise ValueError("Invalid value for `email`, must not be `None`")  # noqa: E501

        self._email = email

    @property
    def first_name(self):
        """
        First name of user.

        :return: The first_name of this UserSpec. 
        :rtype: str
        """
        return self._first_name

    @first_name.setter
    def first_name(self, first_name):
        """
        First name of user.

        :param first_name: The first_name of this UserSpec.
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and first_name is None:  # noqa: E501
            raise ValueError("Invalid value for `first_name`, must not be `None`")  # noqa: E501

        self._first_name = first_name

    @property
    def last_name(self):
        """
        Last name of user.

        :return: The last_name of this UserSpec. 
        :rtype: str
        """
        return self._last_name

    @last_name.setter
    def last_name(self, last_name):
        """
        Last name of user.

        :param last_name: The last_name of this UserSpec.
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and last_name is None:  # noqa: E501
            raise ValueError("Invalid value for `last_name`, must not be `None`")  # noqa: E501

        self._last_name = last_name

    @property
    def password(self):
        """
        Account password.

        :return: The password of this UserSpec. 
        :rtype: str
        """
        return self._password

    @password.setter
    def password(self, password):
        """
        Account password.

        :param password: The password of this UserSpec.
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and password is None:  # noqa: E501
            raise ValueError("Invalid value for `password`, must not be `None`")  # noqa: E501

        self._password = password

    @property
    def registration_token(self):
        """
        Registration token generated by Invitation object.

        :return: The registration_token of this UserSpec. 
        :rtype: str
        """
        return self._registration_token

    @registration_token.setter
    def registration_token(self, registration_token):
        """
        Registration token generated by Invitation object.

        :param registration_token: The registration_token of this UserSpec.
        :type: str
        """

        self._registration_token = registration_token

    @property
    def username(self):
        """
        Username of user.

        :return: The username of this UserSpec. 
        :rtype: str
        """
        return self._username

    @username.setter
    def username(self, username):
        """
        Username of user.

        :param username: The username of this UserSpec.
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and username is None:  # noqa: E501
            raise ValueError("Invalid value for `username`, must not be `None`")  # noqa: E501

        self._username = username

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, UserSpec):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, UserSpec):
            return True

        return self.to_dict() != other.to_dict()
