# coding: utf-8

"""
    Tator REST API

    Interface to the Tator backend.  # noqa: E501

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from ..configuration import Configuration


class UserUpdate(object):
    """
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'email': 'str',
        'first_name': 'str',
        'last_name': 'str',
        'password': 'str',
        'reset_token': 'str'
    }

    attribute_map = {
        'email': 'email',
        'first_name': 'first_name',
        'last_name': 'last_name',
        'password': 'password',
        'reset_token': 'reset_token'
    }

    def __init__(self, email=None, first_name=None, last_name=None, password=None, reset_token=None, local_vars_configuration=None):  # noqa: E501
        """UserUpdate - a model defined in OpenAPI"""
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._email = None
        self._first_name = None
        self._last_name = None
        self._password = None
        self._reset_token = None
        self.discriminator = None

        if email is not None:
            self.email = email
        if first_name is not None:
            self.first_name = first_name
        if last_name is not None:
            self.last_name = last_name
        if password is not None:
            self.password = password
        if reset_token is not None:
            self.reset_token = reset_token

    @property
    def email(self):
        """
        Email address of user.

        :return: The email of this UserUpdate. 
        :rtype: str
        """
        return self._email

    @email.setter
    def email(self, email):
        """
        Email address of user.

        :param email: The email of this UserUpdate.
        :type: str
        """

        self._email = email

    @property
    def first_name(self):
        """
        First name of user.

        :return: The first_name of this UserUpdate. 
        :rtype: str
        """
        return self._first_name

    @first_name.setter
    def first_name(self, first_name):
        """
        First name of user.

        :param first_name: The first_name of this UserUpdate.
        :type: str
        """

        self._first_name = first_name

    @property
    def last_name(self):
        """
        Last name of user.

        :return: The last_name of this UserUpdate. 
        :rtype: str
        """
        return self._last_name

    @last_name.setter
    def last_name(self, last_name):
        """
        Last name of user.

        :param last_name: The last_name of this UserUpdate.
        :type: str
        """

        self._last_name = last_name

    @property
    def password(self):
        """
        Account password.

        :return: The password of this UserUpdate. 
        :rtype: str
        """
        return self._password

    @password.setter
    def password(self, password):
        """
        Account password.

        :param password: The password of this UserUpdate.
        :type: str
        """

        self._password = password

    @property
    def reset_token(self):
        """
        Password reset token generated by PasswordReset object.

        :return: The reset_token of this UserUpdate. 
        :rtype: str
        """
        return self._reset_token

    @reset_token.setter
    def reset_token(self, reset_token):
        """
        Password reset token generated by PasswordReset object.

        :param reset_token: The reset_token of this UserUpdate.
        :type: str
        """

        self._reset_token = reset_token

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, UserUpdate):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, UserUpdate):
            return True

        return self.to_dict() != other.to_dict()
