# coding: utf-8

"""
    Tator REST API

    Interface to the Tator backend.  # noqa: E501

    The version of the OpenAPI document: v1
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from ..configuration import Configuration


class Version(object):
    """
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'bases': 'list[int]',
        'created_by': 'str',
        'description': 'str',
        'id': 'int',
        'name': 'str',
        'number': 'int',
        'project': 'int',
        'show_empty': 'bool'
    }

    attribute_map = {
        'bases': 'bases',
        'created_by': 'created_by',
        'description': 'description',
        'id': 'id',
        'name': 'name',
        'number': 'number',
        'project': 'project',
        'show_empty': 'show_empty'
    }

    def __init__(self, bases=None, created_by=None, description='', id=None, name=None, number=None, project=None, show_empty=True, local_vars_configuration=None):  # noqa: E501
        """Version - a model defined in OpenAPI"""
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._bases = None
        self._created_by = None
        self._description = None
        self._id = None
        self._name = None
        self._number = None
        self._project = None
        self._show_empty = None
        self.discriminator = None

        if bases is not None:
            self.bases = bases
        if created_by is not None:
            self.created_by = created_by
        if description is not None:
            self.description = description
        if id is not None:
            self.id = id
        if name is not None:
            self.name = name
        if number is not None:
            self.number = number
        if project is not None:
            self.project = project
        if show_empty is not None:
            self.show_empty = show_empty

    @property
    def bases(self):
        """
        Array of other version IDs that are dependencies of this version.

        :return: The bases of this Version. 
        :rtype: list[int]
        """
        return self._bases

    @bases.setter
    def bases(self, bases):
        """
        Array of other version IDs that are dependencies of this version.

        :param bases: The bases of this Version.
        :type: list[int]
        """

        self._bases = bases

    @property
    def created_by(self):
        """
        Name of user who created the last unmodified annotation in this version.

        :return: The created_by of this Version. 
        :rtype: str
        """
        return self._created_by

    @created_by.setter
    def created_by(self, created_by):
        """
        Name of user who created the last unmodified annotation in this version.

        :param created_by: The created_by of this Version.
        :type: str
        """

        self._created_by = created_by

    @property
    def description(self):
        """
        Description of the version.

        :return: The description of this Version. 
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Description of the version.

        :param description: The description of this Version.
        :type: str
        """

        self._description = description

    @property
    def id(self):
        """
        Unique integer identifying a membership.

        :return: The id of this Version. 
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Unique integer identifying a membership.

        :param id: The id of this Version.
        :type: int
        """

        self._id = id

    @property
    def name(self):
        """
        Name of the version.

        :return: The name of this Version. 
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Name of the version.

        :param name: The name of this Version.
        :type: str
        """

        self._name = name

    @property
    def number(self):
        """
        Version number.

        :return: The number of this Version. 
        :rtype: int
        """
        return self._number

    @number.setter
    def number(self, number):
        """
        Version number.

        :param number: The number of this Version.
        :type: int
        """

        self._number = number

    @property
    def project(self):
        """
        Unique integer identifying a project.

        :return: The project of this Version. 
        :rtype: int
        """
        return self._project

    @project.setter
    def project(self, project):
        """
        Unique integer identifying a project.

        :param project: The project of this Version.
        :type: int
        """

        self._project = project

    @property
    def show_empty(self):
        """
        Whether to show this version on media for which no annotations exist.

        :return: The show_empty of this Version. 
        :rtype: bool
        """
        return self._show_empty

    @show_empty.setter
    def show_empty(self, show_empty):
        """
        Whether to show this version on media for which no annotations exist.

        :param show_empty: The show_empty of this Version.
        :type: bool
        """

        self._show_empty = show_empty

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Version):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, Version):
            return True

        return self.to_dict() != other.to_dict()
