#!/usr/bin/env python3
#
# GlobalChem - Vitamins
#
# -----------------------------------

class Vitamins(object):

    def __init__(self):

        self.name = 'vitamins'

    @staticmethod
    def get_smiles():

        smiles = {
            'vitamin A': 'CC1=C(C(CCC1)(C)C)C=CC(=CC=CC(=CCO)C)C',
            'vitamin C': 'C(C(C1C(=C(C(=O)O1)O)O)O)O',
            'vitamin D': 'CC(C)CCCC(C)C1CCC2C1(CCCC2=CC=C3CC(CCC3=C)O)C',
            'vitamin E': 'CC1=C(C2=C(CCC(O2)(C)CCCC(C)CCCC(C)CCCC(C)C)C(=C1O)C)C',
            'vitamin K': 'CC1=C(C(=O)C2=CC=CC=C2C1=O)CC=C(C)CCCC(C)CCCC(C)CCCC(C)C',
            'thiamine': 'OCCC1=C(C)[N+](CC2=CN=C(C)N=C2N)=CS1',
            'riboflavin': 'OC[C@H](O)[C@H](O)[C@H](O)CN(C(C=C1C)=C(C=C1C)N=C2C(N3)=O)C2=NC3=O',
            'niacin': 'C1=CC(=CN=C1)C(=O)O',
            'pantothenic acid': 'CC(C)(CO)C(C(=O)NCCC(=O)O)O',
            'biotin': 'C1C2C(C(S1)CCCCC(=O)O)NC(=O)N2',
            'b6': 'CC1=NC=C(C(=C1O)CO)CO',
            'b12': 'CC1=CC2=C(C=C1C)N(C=N2)C3C(C(C(O3)CO)OP(=O)(O)OC(C)CNC(=O)CCC4(C(C5C6(C(C(C(=C(C7=NC(=CC8=NC(=C(C4=N5)C)C(C8(C)C)CCC(=O)N)C(C7(C)CC(=O)N)CCC(=O)N)C)[N-]6)CCC(=O)N)(C)CC(=O)N)C)CC(=O)N)C)O',
            'folate': 'C1=CC(=CC=C1C(=O)NC(CCC(=O)O)C(=O)O)NCC2=CN=C3C(=N2)C(=O)NC(=N3)N',
        }

        return smiles

    @staticmethod
    def get_smarts():

        smarts = {
            'vitamin A':'[#6]-[#6]1=[#6](-[#6](-[#6]-[#6]-[#6]-1)(-[#6])-[#6])-[#6]=[#6]-[#6](=[#6]-[#6]=[#6]-[#6](=[#6]-[#6]-[#8])-[#6])-[#6]',
            'vitamin C':'[#6](-[#6](-[#6]1-[#6](=[#6](-[#6](=[#8])-[#8]-1)-[#8])-[#8])-[#8])-[#8]',
            'vitamin D':'[#6]-[#6](-[#6])-[#6]-[#6]-[#6]-[#6](-[#6])-[#6]1-[#6]-[#6]-[#6]2-[#6]-1(-[#6]-[#6]-[#6]-[#6]-2=[#6]-[#6]=[#6]1-[#6]-[#6](-[#6]-[#6]-[#6]-1=[#6])-[#8])-[#6]',
            'vitamin E':'[#6]-[#6]1:[#6](:[#6]2:[#6](-[#6]-[#6]-[#6](-[#8]-2)(-[#6])-[#6]-[#6]-[#6]-[#6](-[#6])-[#6]-[#6]-[#6]-[#6](-[#6])-[#6]-[#6]-[#6]-[#6](-[#6])-[#6]):[#6](:[#6]:1-[#8])-[#6])-[#6]',
            'vitamin K':'[#6]-[#6]1=[#6](-[#6](=[#8])-[#6]2:[#6]:[#6]:[#6]:[#6]:[#6]:2-[#6]-1=[#8])-[#6]-[#6]=[#6](-[#6])-[#6]-[#6]-[#6]-[#6](-[#6])-[#6]-[#6]-[#6]-[#6](-[#6])-[#6]-[#6]-[#6]-[#6](-[#6])-[#6]',
            'thiamine':'[#8]-[#6]-[#6]-[#6]1:[#6](-[#6]):[#7+](-[#6]-[#6]2:[#6]:[#7]:[#6](-[#6]):[#7]:[#6]:2-[#7]):[#6]:[#16]:1',
            'riboflavin':'[#8]-[#6]-[#6@H](-[#8])-[#6@H](-[#8])-[#6@H](-[#8])-[#6]-[#7]1:[#6]2:[#6]:[#6](-[#6]):[#6](:[#6]:[#6]:2:[#7]:[#6]2:[#6](:[#7H]:[#6](:[#7]:[#6]:1-2)=[#8])=[#8])-[#6]',
            'niacin':'[#6]1:[#6]:[#6](:[#6]:[#7]:[#6]:1)-[#6](=[#8])-[#8]',
            'pantothenic acid':'[#6]-[#6](-[#6])(-[#6]-[#8])-[#6](-[#6](=[#8])-[#7]-[#6]-[#6]-[#6](=[#8])-[#8])-[#8]',
            'biotin':'[#6]1-[#6]2-[#6](-[#6](-[#16]-1)-[#6]-[#6]-[#6]-[#6]-[#6](=[#8])-[#8])-[#7]-[#6](=[#8])-[#7]-2',
            'b6':'[#6]-[#6]1:[#7]:[#6]:[#6](:[#6](:[#6]:1-[#8])-[#6]-[#8])-[#6]-[#8]',
            'b12':'[#6]-[#6]1:[#6]:[#6]2:[#6](:[#6]:[#6]:1-[#6]):[#7](:[#6]:[#7]:2)-[#6]1-[#6](-[#6](-[#6](-[#8]-1)-[#6]-[#8])-[#8]-[#15](=[#8])(-[#8])-[#8]-[#6](-[#6])-[#6]-[#7]-[#6](=[#8])-[#6]-[#6]-[#6]1(-[#6](-[#6]2-[#6]3(-[#6](-[#6](-[#6](=[#6](-[#6]4=[#7]-[#6](=[#6]-[#6]5=[#7]-[#6](=[#6](-[#6]-1=[#7]-2)-[#6])-[#6](-[#6]-5(-[#6])-[#6])-[#6]-[#6]-[#6](=[#8])-[#7])-[#6](-[#6]-4(-[#6])-[#6]-[#6](=[#8])-[#7])-[#6]-[#6]-[#6](=[#8])-[#7])-[#6])-[#7-]-3)-[#6]-[#6]-[#6](=[#8])-[#7])(-[#6])-[#6]-[#6](=[#8])-[#7])-[#6])-[#6]-[#6](=[#8])-[#7])-[#6])-[#8]',
            'folate':'[#6]1:[#6]:[#6](:[#6]:[#6]:[#6]:1-[#6](=[#8])-[#7]-[#6](-[#6]-[#6]-[#6](=[#8])-[#8])-[#6](=[#8])-[#8])-[#7]-[#6]-[#6]1:[#6]:[#7]:[#6]2:[#6](:[#7]:1):[#6](=[#8]):[#7H]:[#6](:[#7]:2)-[#7]',
        }

        return smarts
