# artefacts

![badge](https://img.shields.io/badge/dbt-%3E%3D0.21.0-orange?style=flat&logo=dbt) ![badge](https://img.shields.io/pypi/pyversions/artefacts?logo=python) 

Artefacts is a Python library that makes it easier to write scripts that leverage dbt's [artifacts](https://docs.getdbt.com/reference/artifacts/dbt-artifacts).

```python
>>> from artefacts import Project
>>> project = Project(target='./target')
>>> len(project.models)
6

```

## Install

```
pip install artefacts
```

## Quickstart

Before using `artefacts`, make sure that you have _compiled_ a dbt project to generate a `manifest.json` artifact for the project. 

```sh
dbt compile
```

Additional dbt artifacts that you can use with `artefacts` can also be generated by other dbt commands.

- `catalog.json`: generated by `dbt docs generate`
- `run_results.json`: generated by `dbt build`
- `sources.json`: generated by `dbt source snapshot-freshness`
- `manifest.json`: generated by `dbt compile`, as well as most other dbt commands (including `build`, `run`, `test`, etc)

Once your dbt project has been compiled, you can start using `artefacts`.

```python
>>> from artefacts import Project
>>> project = Project(target='./target')
>>> len(project.models)
6

```

To learn more about how to write scripts that use `artefacts`, please see our [tutorial](https://tjwaterman99.github.io/artefacts/tutorial/) and additional [reference documenation](https://tjwaterman99.github.io/artefacts/reference/).

## Development

This project provides a development environment thru Github Codespaces. To create a new development environment, use the following link to view your Codespaces instances for this project, and then click the button for "New Codespace."

> https://github.com/tjwaterman99/artefacts/codespaces

#### Testing

```
pytest
```

#### Docs

```
mkdocs serve
```

The development docs site is available at http://127.0.0.1:8000

#### Deployment

New versions are released to PyPI by creating a release on Github.

First, make sure to update the project's VERSION file.

```
echo 0.0.2rc0 > artefacts/VERSION
git add artefacts/VERSION
git commit -m "Bump version 0.0.2rc0"
```

Create [a new release on Github](https://github.com/tjwaterman99/artefacts/releases/new), tagging the release with the associated version (ie `v0.0.2rc0`).

The ["Deploy PyPI"](https://github.com/tjwaterman99/artefacts/actions/workflows/deploy-pypi.yml) workflow will then build and push the release to PyPI.
