from typing import Union, List

import pydantic

from artefacts.mixins import ContextReader, Artifact
from artefacts.shared import Metadata


class SourceFreshnessResult(ContextReader, pydantic.BaseModel):
    unique_id: str
    status: str
    error: Union[None, str, int]
    max_loaded_at: str
    snapshotted_at: str
    max_loaded_at_time_ago_in_s: int
    criteria: dict
    adapter_response: dict
    timing: List[dict]
    thread_id: str
    execution_time: float


class Sources(Artifact, ContextReader, pydantic.BaseModel):
    """
    Sources are generated by the `dbt sources snapshot-freshness` command.

    Examples:

        >>> from artefacts import Project
        >>> project = Project(target='./target')
        >>> print(project.sources)
        <Sources v2>

    Attributes:

        metadata (Metadata):
            The [`Metadata`][artefacts.shared.Metadata] of the artifact

        results (List[SourceFreshnessResult])
            A list of results containing details about the source's freshness.

    """

    class Config:
        arbitrary_types_allowed = True

    metadata: Metadata
    results: List[SourceFreshnessResult]
    elapsed_time: float
