import * as cdk from 'aws-cdk-lib';
import * as constructs from 'constructs';
/**
 * Manages an Application within Azure Active Directory.
 *
 * -> **NOTE:** If you're authenticating using a Service Principal then it must have permissions to both `Read and write owned by applications` and `Sign in and read user profile` within the `Windows Azure Active Directory` API.
 *
 * @schema CfnApplicationProps
 */
export interface CfnApplicationProps {
    /**
     * A collection of `app_role` blocks as documented below. For more information see [official documentation on Application Roles](https://docs.microsoft.com/en-us/azure/architecture/multitenant-identity/app-roles).
     *
     * @schema CfnApplicationProps#AppRole
     */
    readonly appRole?: AppRoleDefinition[];
    /**
     * Is this Azure AD Application available to other tenants? Defaults to `false`. This property is deprecated and has been replaced by the `sign_in_audience` property.
     *
     * @default false`. This property is deprecated and has been replaced by the `sign_in_audience` property.
     * @schema CfnApplicationProps#AvailableToOtherTenants
     */
    readonly availableToOtherTenants?: boolean;
    /**
     * The display name for the application.
     *
     * @schema CfnApplicationProps#DisplayName
     */
    readonly displayName?: string;
    /**
     * The fallback application type as public client, such as an installed application running on a mobile device. Defaults to `false`.
     *
     * @default false`.
     * @schema CfnApplicationProps#FallbackPublicClientEnabled
     */
    readonly fallbackPublicClientEnabled?: boolean;
    /**
     * Configures the `groups` claim issued in a user or OAuth 2.0 access token that the app expects. Defaults to `SecurityGroup`. Possible values are `None`, `SecurityGroup`, `DirectoryRole`, `ApplicationGroup` or `All`.
     *
     * @default SecurityGroup`. Possible values are `None`, `SecurityGroup`, `DirectoryRole`, `ApplicationGroup` or `All`.
     * @schema CfnApplicationProps#GroupMembershipClaims
     */
    readonly groupMembershipClaims?: string;
    /**
     * The URL to the application's home page. This property is deprecated and has been replaced by the `homepage_url` property in the `web` block.
     *
     * @schema CfnApplicationProps#Homepage
     */
    readonly homepage?: string;
    /**
     * The user-defined URI(s) that uniquely identify an application within it's Azure AD tenant, or within a verified custom domain if the application is multi-tenant.
     *
     * @schema CfnApplicationProps#IdentifierUris
     */
    readonly identifierUris?: string[];
    /**
     * The URL of the logout page. This property is deprecated and has been replaced by the `logout_url` property in the `web` block.
     *
     * @schema CfnApplicationProps#LogoutUrl
     */
    readonly logoutUrl?: string;
    /**
     * The name of the optional claim.
     *
     * @schema CfnApplicationProps#Name
     */
    readonly name?: string;
    /**
     * Does this Azure AD Application allow OAuth 2.0 implicit flow tokens? Defaults to `false`. This property is deprecated and has been replaced by the `access_token_issuance_enabled` property in the `implicit_grant` block.
     *
     * @default false`. This property is deprecated and has been replaced by the `access_token_issuance_enabled` property in the `implicit_grant` block.
     * @schema CfnApplicationProps#Oauth2AllowImplicitFlow
     */
    readonly oauth2AllowImplicitFlow?: boolean;
    /**
     * A collection of OAuth 2.0 permission scopes that the web API (resource) app exposes to client apps. Each permission is covered by `oauth2_permissions` blocks as documented below. This block is deprecated and has been replaced by the `oauth2_permission_scope` block in the `api` block.
     *
     * @schema CfnApplicationProps#Oauth2Permissions
     */
    readonly oauth2Permissions?: Oauth2PermissionsDefinition[];
    /**
     * A list of object IDs of principals that will be granted ownership of the application. It's recommended to specify the object ID of the authenticated principal running Terraform, to ensure sufficient permissions that the application can be subsequently updated.
     *
     * @schema CfnApplicationProps#Owners
     */
    readonly owners?: string[];
    /**
     * If `true`, will return an error when an existing Application is found with the same name. Defaults to `false`.
     *
     * @default false`.
     * @schema CfnApplicationProps#PreventDuplicateNames
     */
    readonly preventDuplicateNames?: boolean;
    /**
     * Is this Azure AD Application a public client? Defaults to `false`. This property is deprecated and has been replaced by the `fallback_public_client_enabled` property.
     *
     * @default false`. This property is deprecated and has been replaced by the `fallback_public_client_enabled` property.
     * @schema CfnApplicationProps#PublicClient
     */
    readonly publicClient?: boolean;
    /**
     * A list of URLs that user tokens are sent to for sign in, or the redirect URIs that OAuth 2.0 authorization codes and access tokens are sent to. This property is deprecated and has been replaced by the `redirect_uris` property in the `web` block.
     *
     * @schema CfnApplicationProps#ReplyUrls
     */
    readonly replyUrls?: string[];
    /**
     * The Microsoft account types that are supported for the current application. Must be one of `AzureADMyOrg` or `AzureADMultipleOrgs`. Defaults to `AzureADMyOrg`.
     *
     * @default AzureADMyOrg`.
     * @schema CfnApplicationProps#SignInAudience
     */
    readonly signInAudience?: string;
    /**
     * The type of the application: `webapp/api` or `native`. Defaults to `webapp/api`. For `native` apps type `identifier_uris` property can not be set. **This legacy property is deprecated and will be removed in version 2.0 of the provider**.
     *
     * @default webapp/api`. For `native` apps type `identifier_uris` property can not be set. **This legacy property is deprecated and will be removed in version 2.0 of the provider**.
     * @schema CfnApplicationProps#Type
     */
    readonly type?: string;
    /**
     * @schema CfnApplicationProps#Api
     */
    readonly api?: ApiDefinition[];
    /**
     * @schema CfnApplicationProps#OptionalClaims
     */
    readonly optionalClaims?: OptionalClaimsDefinition[];
    /**
     * @schema CfnApplicationProps#RequiredResourceAccess
     */
    readonly requiredResourceAccess?: RequiredResourceAccessDefinition[];
    /**
     * @schema CfnApplicationProps#Timeouts
     */
    readonly timeouts?: TimeoutsDefinition;
    /**
     * @schema CfnApplicationProps#Web
     */
    readonly web?: WebDefinition[];
}
/**
 * Converts an object of type 'CfnApplicationProps' to JSON representation.
 */
export declare function toJson_CfnApplicationProps(obj: CfnApplicationProps | undefined): Record<string, any> | undefined;
/**
 * @schema AppRoleDefinition
 */
export interface AppRoleDefinition {
    /**
     * @schema AppRoleDefinition#AllowedMemberTypes
     */
    readonly allowedMemberTypes?: string[];
    /**
     * @schema AppRoleDefinition#Description
     */
    readonly description?: string;
    /**
     * @schema AppRoleDefinition#DisplayName
     */
    readonly displayName?: string;
    /**
     * @schema AppRoleDefinition#Enabled
     */
    readonly enabled?: boolean;
    /**
     * @schema AppRoleDefinition#Id
     */
    readonly id?: string;
    /**
     * @schema AppRoleDefinition#IsEnabled
     */
    readonly isEnabled?: boolean;
    /**
     * @schema AppRoleDefinition#Value
     */
    readonly value?: string;
}
/**
 * Converts an object of type 'AppRoleDefinition' to JSON representation.
 */
export declare function toJson_AppRoleDefinition(obj: AppRoleDefinition | undefined): Record<string, any> | undefined;
/**
 * @schema Oauth2PermissionsDefinition
 */
export interface Oauth2PermissionsDefinition {
    /**
     * @schema Oauth2PermissionsDefinition#AdminConsentDescription
     */
    readonly adminConsentDescription?: string;
    /**
     * @schema Oauth2PermissionsDefinition#AdminConsentDisplayName
     */
    readonly adminConsentDisplayName?: string;
    /**
     * @schema Oauth2PermissionsDefinition#Id
     */
    readonly id?: string;
    /**
     * @schema Oauth2PermissionsDefinition#IsEnabled
     */
    readonly isEnabled?: boolean;
    /**
     * @schema Oauth2PermissionsDefinition#Type
     */
    readonly type?: string;
    /**
     * @schema Oauth2PermissionsDefinition#UserConsentDescription
     */
    readonly userConsentDescription?: string;
    /**
     * @schema Oauth2PermissionsDefinition#UserConsentDisplayName
     */
    readonly userConsentDisplayName?: string;
    /**
     * @schema Oauth2PermissionsDefinition#Value
     */
    readonly value?: string;
}
/**
 * Converts an object of type 'Oauth2PermissionsDefinition' to JSON representation.
 */
export declare function toJson_Oauth2PermissionsDefinition(obj: Oauth2PermissionsDefinition | undefined): Record<string, any> | undefined;
/**
 * @schema ApiDefinition
 */
export interface ApiDefinition {
    /**
     * @schema ApiDefinition#Oauth2PermissionScope
     */
    readonly oauth2PermissionScope?: Oauth2PermissionScopeDefinition[];
}
/**
 * Converts an object of type 'ApiDefinition' to JSON representation.
 */
export declare function toJson_ApiDefinition(obj: ApiDefinition | undefined): Record<string, any> | undefined;
/**
 * @schema OptionalClaimsDefinition
 */
export interface OptionalClaimsDefinition {
    /**
     * @schema OptionalClaimsDefinition#AccessToken
     */
    readonly accessToken?: AccessTokenDefinition[];
    /**
     * @schema OptionalClaimsDefinition#IdToken
     */
    readonly idToken?: IdTokenDefinition[];
}
/**
 * Converts an object of type 'OptionalClaimsDefinition' to JSON representation.
 */
export declare function toJson_OptionalClaimsDefinition(obj: OptionalClaimsDefinition | undefined): Record<string, any> | undefined;
/**
 * @schema RequiredResourceAccessDefinition
 */
export interface RequiredResourceAccessDefinition {
    /**
     * The unique identifier for the resource that the application requires access to. This should be the Application ID of the target application.
     *
     * @schema RequiredResourceAccessDefinition#ResourceAppId
     */
    readonly resourceAppId: string;
    /**
     * @schema RequiredResourceAccessDefinition#ResourceAccess
     */
    readonly resourceAccess?: ResourceAccessDefinition[];
}
/**
 * Converts an object of type 'RequiredResourceAccessDefinition' to JSON representation.
 */
export declare function toJson_RequiredResourceAccessDefinition(obj: RequiredResourceAccessDefinition | undefined): Record<string, any> | undefined;
/**
 * @schema TimeoutsDefinition
 */
export interface TimeoutsDefinition {
    /**
     * @schema TimeoutsDefinition#Create
     */
    readonly create?: string;
    /**
     * @schema TimeoutsDefinition#Delete
     */
    readonly delete?: string;
    /**
     * @schema TimeoutsDefinition#Read
     */
    readonly read?: string;
    /**
     * @schema TimeoutsDefinition#Update
     */
    readonly update?: string;
}
/**
 * Converts an object of type 'TimeoutsDefinition' to JSON representation.
 */
export declare function toJson_TimeoutsDefinition(obj: TimeoutsDefinition | undefined): Record<string, any> | undefined;
/**
 * @schema WebDefinition
 */
export interface WebDefinition {
    /**
     * Home page or landing page of the application.
     *
     * @schema WebDefinition#HomepageUrl
     */
    readonly homepageUrl?: string;
    /**
     * The URL that will be used by Microsoft's authorization service to sign out a user using front-channel, back-channel or SAML logout protocols.
     *
     * @schema WebDefinition#LogoutUrl
     */
    readonly logoutUrl?: string;
    /**
     * A list of URLs where user tokens are sent for sign-in, or the redirect URIs where OAuth 2.0 authorization codes and access tokens are sent.
     *
     * @schema WebDefinition#RedirectUris
     */
    readonly redirectUris?: string[];
    /**
     * @schema WebDefinition#ImplicitGrant
     */
    readonly implicitGrant?: ImplicitGrantDefinition[];
}
/**
 * Converts an object of type 'WebDefinition' to JSON representation.
 */
export declare function toJson_WebDefinition(obj: WebDefinition | undefined): Record<string, any> | undefined;
/**
 * @schema Oauth2PermissionScopeDefinition
 */
export interface Oauth2PermissionScopeDefinition {
    /**
     * Delegated permission description that appears in all tenant-wide admin consent experiences, intended to be read by an administrator granting the permission on behalf of all users.
     *
     * @schema Oauth2PermissionScopeDefinition#AdminConsentDescription
     */
    readonly adminConsentDescription?: string;
    /**
     * Display name for the delegated permission, intended to be read by an administrator granting the permission on behalf of all users.
     *
     * @schema Oauth2PermissionScopeDefinition#AdminConsentDisplayName
     */
    readonly adminConsentDisplayName?: string;
    /**
     * Determines if the permission scope is enabled. Defaults to `true`.
     *
     * @default true`.
     * @schema Oauth2PermissionScopeDefinition#Enabled
     */
    readonly enabled?: boolean;
    /**
     * The unique identifier of the delegated permission. Must be a valid UUID.
     *
     * @schema Oauth2PermissionScopeDefinition#Id
     */
    readonly id: string;
    /**
     * Whether this delegated permission should be considered safe for non-admin users to consent to on behalf of themselves, or whether an administrator should be required for consent to the permissions. Defaults to `User`. Possible values are `User` or `Admin`.
     *
     * @default User`. Possible values are `User` or `Admin`.
     * @schema Oauth2PermissionScopeDefinition#Type
     */
    readonly type?: string;
    /**
     * Delegated permission description that appears in the end user consent experience, intended to be read by a user consenting on their own behalf.
     *
     * @schema Oauth2PermissionScopeDefinition#UserConsentDescription
     */
    readonly userConsentDescription?: string;
    /**
     * Display name for the delegated permission that appears in the end user consent experience.
     *
     * @schema Oauth2PermissionScopeDefinition#UserConsentDisplayName
     */
    readonly userConsentDisplayName?: string;
    /**
     * The value that is used for the `scp` claim in OAuth 2.0 access tokens.
     *
     * @schema Oauth2PermissionScopeDefinition#Value
     */
    readonly value?: string;
}
/**
 * Converts an object of type 'Oauth2PermissionScopeDefinition' to JSON representation.
 */
export declare function toJson_Oauth2PermissionScopeDefinition(obj: Oauth2PermissionScopeDefinition | undefined): Record<string, any> | undefined;
/**
 * @schema AccessTokenDefinition
 */
export interface AccessTokenDefinition {
    /**
     * @schema AccessTokenDefinition#AdditionalProperties
     */
    readonly additionalProperties?: string[];
    /**
     * @schema AccessTokenDefinition#Essential
     */
    readonly essential?: boolean;
    /**
     * @schema AccessTokenDefinition#Name
     */
    readonly name: string;
    /**
     * @schema AccessTokenDefinition#Source
     */
    readonly source?: string;
}
/**
 * Converts an object of type 'AccessTokenDefinition' to JSON representation.
 */
export declare function toJson_AccessTokenDefinition(obj: AccessTokenDefinition | undefined): Record<string, any> | undefined;
/**
 * @schema IdTokenDefinition
 */
export interface IdTokenDefinition {
    /**
     * @schema IdTokenDefinition#AdditionalProperties
     */
    readonly additionalProperties?: string[];
    /**
     * @schema IdTokenDefinition#Essential
     */
    readonly essential?: boolean;
    /**
     * @schema IdTokenDefinition#Name
     */
    readonly name: string;
    /**
     * @schema IdTokenDefinition#Source
     */
    readonly source?: string;
}
/**
 * Converts an object of type 'IdTokenDefinition' to JSON representation.
 */
export declare function toJson_IdTokenDefinition(obj: IdTokenDefinition | undefined): Record<string, any> | undefined;
/**
 * @schema ResourceAccessDefinition
 */
export interface ResourceAccessDefinition {
    /**
     * The unique identifier for one of the `OAuth2Permission` or `AppRole` instances that the resource application exposes.
     *
     * @schema ResourceAccessDefinition#Id
     */
    readonly id: string;
    /**
     * Specifies whether the `id` property references an `OAuth2Permission` or an `AppRole`. Possible values are `Scope` or `Role`.
     *
     * @schema ResourceAccessDefinition#Type
     */
    readonly type: string;
}
/**
 * Converts an object of type 'ResourceAccessDefinition' to JSON representation.
 */
export declare function toJson_ResourceAccessDefinition(obj: ResourceAccessDefinition | undefined): Record<string, any> | undefined;
/**
 * @schema ImplicitGrantDefinition
 */
export interface ImplicitGrantDefinition {
    /**
     * @schema ImplicitGrantDefinition#AccessTokenIssuanceEnabled
     */
    readonly accessTokenIssuanceEnabled?: boolean;
}
/**
 * Converts an object of type 'ImplicitGrantDefinition' to JSON representation.
 */
export declare function toJson_ImplicitGrantDefinition(obj: ImplicitGrantDefinition | undefined): Record<string, any> | undefined;
/**
 * A CloudFormation `TF::AzureAD::Application`
 *
 * @cloudformationResource TF::AzureAD::Application
 * @stability external
 * @link https://github.com/iann0036/cfn-tf-custom-types.git
 */
export declare class CfnApplication extends cdk.CfnResource {
    /**
    * The CloudFormation resource type name for this resource class.
    */
    static readonly CFN_RESOURCE_TYPE_NAME = "TF::AzureAD::Application";
    /**
     * Resource props.
     */
    readonly props: CfnApplicationProps;
    /**
     * Attribute `TF::AzureAD::Application.tfcfnid`
     * @link https://github.com/iann0036/cfn-tf-custom-types.git
     */
    readonly attrTfcfnid: string;
    /**
     * Attribute `TF::AzureAD::Application.ApplicationId`
     * @link https://github.com/iann0036/cfn-tf-custom-types.git
     */
    readonly attrApplicationId: string;
    /**
     * Attribute `TF::AzureAD::Application.Id`
     * @link https://github.com/iann0036/cfn-tf-custom-types.git
     */
    readonly attrId: string;
    /**
     * Attribute `TF::AzureAD::Application.ObjectId`
     * @link https://github.com/iann0036/cfn-tf-custom-types.git
     */
    readonly attrObjectId: string;
    /**
     * Create a new `TF::AzureAD::Application`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: constructs.Construct, id: string, props: CfnApplicationProps);
}
