"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnApplication = exports.toJson_ImplicitGrantDefinition = exports.toJson_ResourceAccessDefinition = exports.toJson_IdTokenDefinition = exports.toJson_AccessTokenDefinition = exports.toJson_Oauth2PermissionScopeDefinition = exports.toJson_WebDefinition = exports.toJson_TimeoutsDefinition = exports.toJson_RequiredResourceAccessDefinition = exports.toJson_OptionalClaimsDefinition = exports.toJson_ApiDefinition = exports.toJson_Oauth2PermissionsDefinition = exports.toJson_AppRoleDefinition = exports.toJson_CfnApplicationProps = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Generated by cdk-import
const cdk = require("aws-cdk-lib");
/**
 * Converts an object of type 'CfnApplicationProps' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_CfnApplicationProps(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'AppRole': obj.appRole?.map(y => toJson_AppRoleDefinition(y)),
        'AvailableToOtherTenants': obj.availableToOtherTenants,
        'DisplayName': obj.displayName,
        'FallbackPublicClientEnabled': obj.fallbackPublicClientEnabled,
        'GroupMembershipClaims': obj.groupMembershipClaims,
        'Homepage': obj.homepage,
        'IdentifierUris': obj.identifierUris?.map(y => y),
        'LogoutUrl': obj.logoutUrl,
        'Name': obj.name,
        'Oauth2AllowImplicitFlow': obj.oauth2AllowImplicitFlow,
        'Oauth2Permissions': obj.oauth2Permissions?.map(y => toJson_Oauth2PermissionsDefinition(y)),
        'Owners': obj.owners?.map(y => y),
        'PreventDuplicateNames': obj.preventDuplicateNames,
        'PublicClient': obj.publicClient,
        'ReplyUrls': obj.replyUrls?.map(y => y),
        'SignInAudience': obj.signInAudience,
        'Type': obj.type,
        'Api': obj.api?.map(y => toJson_ApiDefinition(y)),
        'OptionalClaims': obj.optionalClaims?.map(y => toJson_OptionalClaimsDefinition(y)),
        'RequiredResourceAccess': obj.requiredResourceAccess?.map(y => toJson_RequiredResourceAccessDefinition(y)),
        'Timeouts': toJson_TimeoutsDefinition(obj.timeouts),
        'Web': obj.web?.map(y => toJson_WebDefinition(y)),
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_CfnApplicationProps = toJson_CfnApplicationProps;
/**
 * Converts an object of type 'AppRoleDefinition' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_AppRoleDefinition(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'AllowedMemberTypes': obj.allowedMemberTypes?.map(y => y),
        'Description': obj.description,
        'DisplayName': obj.displayName,
        'Enabled': obj.enabled,
        'Id': obj.id,
        'IsEnabled': obj.isEnabled,
        'Value': obj.value,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_AppRoleDefinition = toJson_AppRoleDefinition;
/**
 * Converts an object of type 'Oauth2PermissionsDefinition' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_Oauth2PermissionsDefinition(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'AdminConsentDescription': obj.adminConsentDescription,
        'AdminConsentDisplayName': obj.adminConsentDisplayName,
        'Id': obj.id,
        'IsEnabled': obj.isEnabled,
        'Type': obj.type,
        'UserConsentDescription': obj.userConsentDescription,
        'UserConsentDisplayName': obj.userConsentDisplayName,
        'Value': obj.value,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_Oauth2PermissionsDefinition = toJson_Oauth2PermissionsDefinition;
/**
 * Converts an object of type 'ApiDefinition' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_ApiDefinition(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'Oauth2PermissionScope': obj.oauth2PermissionScope?.map(y => toJson_Oauth2PermissionScopeDefinition(y)),
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_ApiDefinition = toJson_ApiDefinition;
/**
 * Converts an object of type 'OptionalClaimsDefinition' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_OptionalClaimsDefinition(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'AccessToken': obj.accessToken?.map(y => toJson_AccessTokenDefinition(y)),
        'IdToken': obj.idToken?.map(y => toJson_IdTokenDefinition(y)),
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_OptionalClaimsDefinition = toJson_OptionalClaimsDefinition;
/**
 * Converts an object of type 'RequiredResourceAccessDefinition' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_RequiredResourceAccessDefinition(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'ResourceAppId': obj.resourceAppId,
        'ResourceAccess': obj.resourceAccess?.map(y => toJson_ResourceAccessDefinition(y)),
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_RequiredResourceAccessDefinition = toJson_RequiredResourceAccessDefinition;
/**
 * Converts an object of type 'TimeoutsDefinition' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_TimeoutsDefinition(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'Create': obj.create,
        'Delete': obj.delete,
        'Read': obj.read,
        'Update': obj.update,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_TimeoutsDefinition = toJson_TimeoutsDefinition;
/**
 * Converts an object of type 'WebDefinition' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_WebDefinition(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'HomepageUrl': obj.homepageUrl,
        'LogoutUrl': obj.logoutUrl,
        'RedirectUris': obj.redirectUris?.map(y => y),
        'ImplicitGrant': obj.implicitGrant?.map(y => toJson_ImplicitGrantDefinition(y)),
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_WebDefinition = toJson_WebDefinition;
/**
 * Converts an object of type 'Oauth2PermissionScopeDefinition' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_Oauth2PermissionScopeDefinition(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'AdminConsentDescription': obj.adminConsentDescription,
        'AdminConsentDisplayName': obj.adminConsentDisplayName,
        'Enabled': obj.enabled,
        'Id': obj.id,
        'Type': obj.type,
        'UserConsentDescription': obj.userConsentDescription,
        'UserConsentDisplayName': obj.userConsentDisplayName,
        'Value': obj.value,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_Oauth2PermissionScopeDefinition = toJson_Oauth2PermissionScopeDefinition;
/**
 * Converts an object of type 'AccessTokenDefinition' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_AccessTokenDefinition(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'AdditionalProperties': obj.additionalProperties?.map(y => y),
        'Essential': obj.essential,
        'Name': obj.name,
        'Source': obj.source,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_AccessTokenDefinition = toJson_AccessTokenDefinition;
/**
 * Converts an object of type 'IdTokenDefinition' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_IdTokenDefinition(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'AdditionalProperties': obj.additionalProperties?.map(y => y),
        'Essential': obj.essential,
        'Name': obj.name,
        'Source': obj.source,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_IdTokenDefinition = toJson_IdTokenDefinition;
/**
 * Converts an object of type 'ResourceAccessDefinition' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_ResourceAccessDefinition(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'Id': obj.id,
        'Type': obj.type,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_ResourceAccessDefinition = toJson_ResourceAccessDefinition;
/**
 * Converts an object of type 'ImplicitGrantDefinition' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_ImplicitGrantDefinition(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'AccessTokenIssuanceEnabled': obj.accessTokenIssuanceEnabled,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_ImplicitGrantDefinition = toJson_ImplicitGrantDefinition;
/* eslint-enable max-len, quote-props */
/**
 * A CloudFormation `TF::AzureAD::Application`
 *
 * @cloudformationResource TF::AzureAD::Application
 * @stability external
 * @link https://github.com/iann0036/cfn-tf-custom-types.git
 */
class CfnApplication extends cdk.CfnResource {
    /**
     * Create a new `TF::AzureAD::Application`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnApplication.CFN_RESOURCE_TYPE_NAME, properties: toJson_CfnApplicationProps(props) });
        this.props = props;
        this.attrTfcfnid = cdk.Token.asString(this.getAtt('tfcfnid'));
        this.attrApplicationId = cdk.Token.asString(this.getAtt('ApplicationId'));
        this.attrId = cdk.Token.asString(this.getAtt('Id'));
        this.attrObjectId = cdk.Token.asString(this.getAtt('ObjectId'));
    }
}
exports.CfnApplication = CfnApplication;
_a = JSII_RTTI_SYMBOL_1;
CfnApplication[_a] = { fqn: "@cdk-cloudformation/tf-azuread-application.CfnApplication", version: "1.0.0-alpha.7" };
/**
* The CloudFormation resource type name for this resource class.
*/
CfnApplication.CFN_RESOURCE_TYPE_NAME = "TF::AzureAD::Application";
//# sourceMappingURL=data:application/json;base64,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