"Inherit LiveSlides class from here. It adds useful attributes and methods."
from .widgets import Widgets
from .print_pdf import PdfPrint
from .navigation import Navigation
from .settings import LayoutSettings
from .notes import Notes

class BaseLiveSlides:
    def __init__(self):
        "Both instnaces should be inside `LiveSlide` class."
        self.__widgets = Widgets()
        self.__print = PdfPrint(self.__widgets)
        self.__navigation = Navigation(self.__widgets) # Not accessed later, just for actions
        self.__settings = LayoutSettings(self.__widgets)
        self.notes = Notes(self, self.__widgets) # Needs main class for access to notes
        
        self.__toasts = {} #Store notifications
        self.toast_html = self.widgets.htmls.toast
        
        self.widgets.checks.toast.observe(self.__toggle_notify,names=['value'])
    
    @property
    def widgets(self):
        return self.__widgets
    
    @property
    def print(self):
        return self.__print
    
    @property
    def settings(self):
        return self.__settings
    
    def notify(self,content,title='IPySlides Notification',timeout=5):
        "Send inside notifications for user to know whats happened on some button click. Set `title = None` if need only content. Remain invisible in screenshot."
        return self.widgets._push_toast(content,title=title,timeout=timeout)
    
    def __toggle_notify(self,change):
        "Blocks notifications."
        if self.toast_check.value:
            self.toast_html.layout.visibility = 'hidden' 
        else:
            self.toast_html.layout.visibility = 'visible'
    
    def notify_at(self, slide, title='IPySlides Notification', timeout=5):
        """Decorartor to push notification at given slide. It should return as string. `slide` here is what you see on slides's footer like 3.1, not just int.
        The content is dynamically generated by underlying function, so you can set timer as well. Remains invisible in screenshot through app itself.
        
        @notify_at(slide=1)
        def push_to(slide): #you can refer slide number in noteification function. 
            ..."""
        def _notify(func): 
            self.__toasts[f'{slide}'] = dict(func = func,arg = slide,kwargs = dict(title=title, timeout=timeout))
        return _notify
    
    def clear_notifications(self):
        "Remove all redundent notifications that show up."
        self.__toasts = {} # Free up
    
    @property
    def notifications(self):
        "See all stored notifications."
        return self.__toasts
    
    def display_toast(self):
        # self.iterable is picked from LiveSlide class after instantiation
        slide_id = str(self.iterable[self.widgets.sliders.progress.value - 1]['n'])
        try:
            toast = self.__toasts[slide_id]
            self.notify(content=toast['func'](toast['arg']),**toast['kwargs'])
        except:pass 
