# Author: Abdul Saboor
# This demonstrates that you can generate slides from a .py file too, which you can import in notebook.
import textwrap, time
from .core import LiveSlides
from .utils import textbox
from .writers import write, iwrite, __reprs__
from .objs_formatter import libraries, plt2html

slides = LiveSlides()
slides.convert2slides(True)
slides.settings.set_footer('Author: Abdul Saboor عبدالصبور')
slides.settings.set_logo('''<svg viewBox="0 0 100 100" xmlns="http://www.w3.org/2000/svg">
        <circle cx="50" cy="50" r="50" fill="blue"/>
        <text x="45%" y="45%" fill="white" font-size="4em" dominant-baseline="central" text-anchor="middle">↑</text>
        <text x="55%" y="60%" fill="white" font-size="4em" dominant-baseline="central" text-anchor="middle">↓</text></svg>''',width=50)

#title is skipped to show instructions  
with slides.slide(1): #slide 1
    with slides.source.context() as s:
        write('## I am created using `with slides.slide(1)` context( manager!')
        write(f'I am {slides.alert("Alerted")} and I am *{slides.colored("colored and italic text","magenta","whitesmoke")}*')
    write(s.focus_lines([1]))  #focus on line 1 
    slides.notes.insert('### Note for slide 1')
    
slides.shell.user_ns['write'] = write #Inject variable in IPython shell

#slide 2    
slides.shell.run_cell_magic('slide','2','write("## I am created using magic `%%slide 2`")')
#slide 3
online_sources = '''# IPySlides Online Running Sources 
Launch as voila slides (may not work as expected [^1])[![Binder](https://mybinder.org/badge_logo.svg)](https://mybinder.org/v2/gh/massgh/ipyslides-voila/HEAD?urlpath=voila%2Frender%2Fnotebooks%2Fipyslides.ipynb)
[Edit on Kaggle](https://www.kaggle.com/massgh/ipyslides)
Launch example Notebook [![Binder](https://mybinder.org/badge_logo.svg)](https://mybinder.org/v2/gh/massgh/ipyslides-voila/HEAD?urlpath=lab%2Ftree%2Fnotebooks%2Fipyslides.ipynb)
<br>
[^1]: Add references like this per slide. Use slides.cite() to add citations generally.
'''
@slides.frames(3,'## I am created using `@slides.frames`',online_sources)
def func(obj):
    slides.write(obj)
    with slides.source.context() as s:
        slides.write('------ Above text generated by this!-------')
        slides.write(slides.keep_format(obj))
    write(s)

#Now generate many slides in a loop
__contents = [f"""## IPython Display Objects
#### Any object with following methods could be in`write` command:
{', '.join([f'`_repr_{rep}_`' for rep in __reprs__])}
Such as `IPython.display.<HTML,SVG,Markdown,Code>` etc. or third party such as `plotly.graph_objects.Figure`.            
""",
f"""## Plots and Other Data Types
#### These objects are implemented to be writable in `write` command:
{', '.join([f"`{lib['name']}.{lib['obj']}`" for lib in libraries])}
Many will be extentended in future. If an object is not implemented, use `display(obj)` to show inline or use library's specific
command to show in Notebook outside `write`.
""",
f"""## Interactive Widgets
### Any object in `ipywidgets`{textbox('<a href="https://ipywidgets.readthedocs.io/en/latest/">Link to ipywidgtes right here using `textbox` command</a>')} 
or libraries based on ipywidgtes such as `bqplot`,`ipyvolume`,plotly's `FigureWidget`{slides.cite('pf','This is refernce to FigureWidget using `slides.cite` command')}(reference at end)
can be included in `iwrite` command as well as other objects that can be passed to `write` with caveat of Javascript.
""",
'## Commands which do all Magic!']
for i in range(4,8):
    with slides.slide(i, background='skyblue'):
        write(__contents[i-4])
        if i == 7:
            with slides.source.context() as s:
                write(slides.block_r('slides.write/ipyslides.writers.write',write), 
                      slides.block_b('slides.iwrite/ipyslides.writers.iwrite',iwrite))
                write("#### If an object does not render as you want, use `display(object)` or it's own library's mehod to display inside Notebook.")
            write(s.show_lines([0,1]))
# Matplotlib
with slides.slide(8,background='linear-gradient(to right, #FFDAB9 0%, #F0E68C 100%)'):
    with slides.source.context() as s:
        import numpy as np, matplotlib.pyplot as plt
        x = np.linspace(0,2*np.pi)
        with plt.style.context('ggplot'):
            fig, ax = plt.subplots(figsize=(3.4,2.6))
            _ = ax.plot(x,np.cos(x))
            
    write('## Plotting with Matplotlib')
    write(slides.block_g('Matplotlib inside block!',slides.alert('Alerting inside block!'),
                         plt2html(caption='No need to save me in file, I directly show up here!'),
                         s.focus_lines([1,3,4])))

# Youtube
from IPython.display import YouTubeVideo
with slides.slide(9):
    with slides.source.context() as s:
        write(f"### Watching Youtube Video?")
        write(YouTubeVideo('Z3iR551KgpI',width='100%',height='266px'))
    write([slides.format_css('.youtube-source',position='absloute',width='50%',border_radius='8px 2em',background='black'), s]
          ,className='youtube-source')
    
# Data Table
with slides.slide(10):
    with slides.source.context() as s:
        write('## Data Tables')
        write(slides.block_r('Here is Table',
            textwrap.dedent('''
            |h1|h2|h3|
            |---|---|---|
            |d1|d2|d3|
            |r1|r2|r3|
            ''')))
    write(s.focus_lines([3,4,5,6]))

# Plotly and Pandas DataFrame only show if you have installed
with slides.slide(11,background='#800000'):
    with slides.source.context():
        try:
            import pandas as pd 
            import altair as alt
            alt.themes.enable('dark')
            df = pd.read_csv('https://raw.githubusercontent.com/mwaskom/seaborn-data/master/iris.csv')
            chart = alt.Chart(df,width=300,height=260).mark_circle(size=60).encode(
                x='sepal_length',
                y='sepal_width',
                color='species',
                size = 'petal_width',
                tooltip=['species', 'sepal_length', 'sepal_width','petal_width','petal_length']
                ).interactive()
            df = df.describe() #Small for display
        except:
            df = '### Install `pandas` to view output'
            chart = '### Install Altair to see chart'
        write(('## Writing Pandas DataFrame',df),
            ('## Writing Altair Chart\nMay not work everywhere, needs javascript',chart)
            )
    write(slides.source.current.show_lines(range(5,12))) #Show source code of above block even without assignning to variable explicitly
    
try:
    import plotly.graph_objects as go
    fig = go.Figure()
    fig.add_trace(go.Bar([1,5,8,9]))
except:
    fig = '### Install `plotly` to view output'
with slides.slide(12):
    write(('## Writing Plotly Figure',fig))

# Interactive widgets can't be used in write command, but still they are displayed.   

with slides.slide(13):
    with slides.source.context(focus_lines = [4,5,6,7,*range(24,30)]) as src:
        import ipywidgets as ipw
        import numpy as np, matplotlib.pyplot as plt
        
        write('## Interactive Apps on Slide\n Use `ipywidgets`, `bqplot`,`ipyvolume` , `plotly Figurewidget` etc. to show live apps like this!')
        grid, [(plot,button, _), code] = slides.iwrite([
            '## Plot will be here! Click button below to activate it!',
            ipw.Button(description='Click me to update race plot',layout=ipw.Layout(width='max-content')),
            "[Check out this app](https://massgh.github.io/pivotpy/Widgets.html#VasprunApp)"],src)
        
        def update_plot():
            x = np.linspace(0,0.9,10)
            y = np.random.random((10,))
            _sort = np.argsort(y)
            
            fig,ax = plt.subplots(figsize=(3.4,2.6))
            ax.barh(x,y[_sort],height=0.07,color=plt.cm.get_cmap('plasma')(x[_sort]))
        
            for s in ['right','top','bottom']:
                ax.spines[s].set_visible(False)
            
            ax.set(title='Race Plot', ylim = [-0.05,0.95], xticks=[],yticks=[c for c in x],yticklabels=[rf'$X_{int(c*10)}$' for c in x[_sort]])
            global plot # only need if you want to change something on it inside function
            plot = grid.update(plot, fig) #Update plot each time
            
        def onclick(btn):
            plot_theme = 'dark_background' if 'Dark' in slides.settings.theme_dd.value else 'default'
            with plt.style.context(plot_theme):
                update_plot()

        button.on_click(onclick)
        update_plot() #Initialize plot
    
    slides.notes.insert('## Something to hide from viewers!')


# Animat plot in slides  
@slides.frames(14,*range(14,19))
def func(obj):
    with slides.source.context() as s:
        fig, ax = plt.subplots()
        x = np.linspace(0,obj+1,50+10*(obj - 13))
        ax.plot(x,np.sin(x));
        ax.set_title(f'$f(x)=\sin(x)$, 0 < x < {obj - 13}')
        ax.set_axis_off()
    slides.write([f'### This is Slide {14}.{obj-13}\n and we are animating matplotlib',
                  s.focus_lines([obj-14])
                  ],ax,width_percents=[40,60])

    
# Let's test notification API
for i in range(slides.prog_slider.max):
    @slides.notify_at(i,timeout=2)
    def push_notification(idx): # idx is will pick i from decorator, just to show these are dummy varibales
        t = time.localtime()
        return f'Slide-{idx}<br/> Time-{t.tm_hour:02}:{t.tm_min:02}'       